/* BlindsEffect.c generated by valac 0.56.18, the Vala compiler
 * generated from BlindsEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2013 Jens Bav
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <math.h>
#include <float.h>
#include <gdk/gdk.h>

#define BLINDS_EFFECT_DESIRED_FPS 30
#define BLINDS_EFFECT_MIN_FPS 15
#define BLINDS_EFFECT_BLIND_WIDTH 50
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_BLINDS_EFFECT_DESCRIPTOR (blinds_effect_descriptor_get_type ())
#define BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptor))
#define BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))
#define IS_BLINDS_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define IS_BLINDS_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT_DESCRIPTOR))
#define BLINDS_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT_DESCRIPTOR, BlindsEffectDescriptorClass))

typedef struct _BlindsEffectDescriptor BlindsEffectDescriptor;
typedef struct _BlindsEffectDescriptorClass BlindsEffectDescriptorClass;
typedef struct _BlindsEffectDescriptorPrivate BlindsEffectDescriptorPrivate;
enum  {
	BLINDS_EFFECT_DESCRIPTOR_0_PROPERTY,
	BLINDS_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* blinds_effect_descriptor_properties[BLINDS_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_BLINDS_EFFECT (blinds_effect_get_type ())
#define BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLINDS_EFFECT, BlindsEffect))
#define BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLINDS_EFFECT, BlindsEffectClass))
#define IS_BLINDS_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLINDS_EFFECT))
#define IS_BLINDS_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLINDS_EFFECT))
#define BLINDS_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLINDS_EFFECT, BlindsEffectClass))

typedef struct _BlindsEffect BlindsEffect;
typedef struct _BlindsEffectClass BlindsEffectClass;
typedef struct _BlindsEffectPrivate BlindsEffectPrivate;
enum  {
	BLINDS_EFFECT_0_PROPERTY,
	BLINDS_EFFECT_NUM_PROPERTIES
};
static GParamSpec* blinds_effect_properties[BLINDS_EFFECT_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _BlindsEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	BlindsEffectDescriptorPrivate * priv;
};

struct _BlindsEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _BlindsEffect {
	GObject parent_instance;
	BlindsEffectPrivate * priv;
};

struct _BlindsEffectClass {
	GObjectClass parent_class;
};

struct _BlindsEffectPrivate {
	gint current_blind_width;
	cairo_surface_t** to_blinds;
	gint to_blinds_length1;
	gint _to_blinds_size_;
	gint blind_count;
};

static gpointer blinds_effect_descriptor_parent_class = NULL;
static gint BlindsEffect_private_offset;
static gpointer blinds_effect_parent_class = NULL;
static SpitTransitionsEffectIface * blinds_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType blinds_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BlindsEffectDescriptor* blinds_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN BlindsEffectDescriptor* blinds_effect_descriptor_construct (GType object_type,
                                                            GFile* resource_directory);
static const gchar* blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                             SpitHostInterface* host);
VALA_EXTERN BlindsEffect* blinds_effect_new (void);
VALA_EXTERN BlindsEffect* blinds_effect_construct (GType object_type);
VALA_EXTERN GType blinds_effect_get_type (void) G_GNUC_CONST ;
static GType blinds_effect_descriptor_get_type_once (void);
static void blinds_effect_real_get_fps (SpitTransitionsEffect* base,
                                 gint* desired_fps,
                                 gint* min_fps);
static gboolean blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void blinds_effect_real_start (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion);
static void blinds_effect_real_paint (SpitTransitionsEffect* base,
                               SpitTransitionsVisuals* visuals,
                               SpitTransitionsMotion* motion,
                               cairo_t* ctx,
                               gint width,
                               gint height,
                               gint frame_number);
static void blinds_effect_real_advance (SpitTransitionsEffect* base,
                                 SpitTransitionsVisuals* visuals,
                                 SpitTransitionsMotion* motion,
                                 gint frame_number);
static void blinds_effect_real_cancel (SpitTransitionsEffect* base);
static void blinds_effect_finalize (GObject * obj);
static GType blinds_effect_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

BlindsEffectDescriptor*
blinds_effect_descriptor_construct (GType object_type,
                                    GFile* resource_directory)
{
	BlindsEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (BlindsEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

BlindsEffectDescriptor*
blinds_effect_descriptor_new (GFile* resource_directory)
{
	return blinds_effect_descriptor_construct (TYPE_BLINDS_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
blinds_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	BlindsEffectDescriptor * self;
	const gchar* result;
	self = (BlindsEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.blinds";
	return result;
}

static const gchar*
blinds_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	BlindsEffectDescriptor * self;
	const gchar* result;
	self = (BlindsEffectDescriptor*) base;
	result = _ ("Blinds");
	return result;
}

static SpitTransitionsEffect*
blinds_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                      SpitHostInterface* host)
{
	BlindsEffectDescriptor * self;
	BlindsEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (BlindsEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = blinds_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
blinds_effect_descriptor_class_init (BlindsEffectDescriptorClass * klass,
                                     gpointer klass_data)
{
	blinds_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) blinds_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) blinds_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) blinds_effect_descriptor_real_create;
}

static void
blinds_effect_descriptor_instance_init (BlindsEffectDescriptor * self,
                                        gpointer klass)
{
}

static GType
blinds_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffectDescriptor), 0, (GInstanceInitFunc) blinds_effect_descriptor_instance_init, NULL };
	GType blinds_effect_descriptor_type_id;
	blinds_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "BlindsEffectDescriptor", &g_define_type_info, 0);
	return blinds_effect_descriptor_type_id;
}

GType
blinds_effect_descriptor_get_type (void)
{
	static volatile gsize blinds_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&blinds_effect_descriptor_type_id__once)) {
		GType blinds_effect_descriptor_type_id;
		blinds_effect_descriptor_type_id = blinds_effect_descriptor_get_type_once ();
		g_once_init_leave (&blinds_effect_descriptor_type_id__once, blinds_effect_descriptor_type_id);
	}
	return blinds_effect_descriptor_type_id__once;
}

static inline gpointer
blinds_effect_get_instance_private (BlindsEffect* self)
{
	return G_STRUCT_MEMBER_P (self, BlindsEffect_private_offset);
}

BlindsEffect*
blinds_effect_construct (GType object_type)
{
	BlindsEffect * self = NULL;
	self = (BlindsEffect*) g_object_new (object_type, NULL);
	return self;
}

BlindsEffect*
blinds_effect_new (void)
{
	return blinds_effect_construct (TYPE_BLINDS_EFFECT);
}

static void
blinds_effect_real_get_fps (SpitTransitionsEffect* base,
                            gint* desired_fps,
                            gint* min_fps)
{
	BlindsEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (BlindsEffect*) base;
	_vala_desired_fps = BLINDS_EFFECT_DESIRED_FPS;
	_vala_min_fps = BLINDS_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static gboolean
blinds_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	BlindsEffect * self;
	gboolean result;
	self = (BlindsEffect*) base;
	result = TRUE;
	return result;
}

static void
blinds_effect_real_start (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion)
{
	BlindsEffect * self;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	self = (BlindsEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		cairo_surface_t** _tmp10_;
		_tmp2_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		_tmp4_ = gdk_pixbuf_get_width (_tmp3_);
		_tmp5_ = _tmp4_;
		self->priv->blind_count = _tmp5_ / BLINDS_EFFECT_BLIND_WIDTH;
		_tmp6_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp7_ = _tmp6_;
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
		_tmp9_ = _tmp8_;
		self->priv->current_blind_width = (gint) ceil (((gdouble) _tmp9_) / ((gdouble) self->priv->blind_count));
		_tmp10_ = g_new0 (cairo_surface_t*, self->priv->blind_count + 1);
		self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		self->priv->to_blinds = _tmp10_;
		self->priv->to_blinds_length1 = self->priv->blind_count;
		self->priv->_to_blinds_size_ = self->priv->to_blinds_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					cairo_surface_t** _tmp13_;
					gint _tmp13__length1;
					GdkPixbuf* _tmp14_;
					GdkPixbuf* _tmp15_;
					gint _tmp16_;
					gint _tmp17_;
					cairo_surface_t* _tmp18_;
					cairo_t* ctx = NULL;
					cairo_surface_t** _tmp19_;
					gint _tmp19__length1;
					cairo_surface_t* _tmp20_;
					cairo_t* _tmp21_;
					cairo_t* _tmp22_;
					GdkPixbuf* _tmp23_;
					GdkPixbuf* _tmp24_;
					cairo_t* _tmp25_;
					if (!_tmp11_) {
						gint _tmp12_;
						i = i + 1;
						_tmp12_ = i;
					}
					_tmp11_ = FALSE;
					if (!(i < self->priv->blind_count)) {
						break;
					}
					_tmp13_ = self->priv->to_blinds;
					_tmp13__length1 = self->priv->to_blinds_length1;
					_tmp14_ = spit_transitions_visuals_get_to_pixbuf (visuals);
					_tmp15_ = _tmp14_;
					_tmp16_ = gdk_pixbuf_get_height (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, self->priv->current_blind_width, _tmp17_);
					_cairo_surface_destroy0 (_tmp13_[i]);
					_tmp13_[i] = _tmp18_;
					_tmp19_ = self->priv->to_blinds;
					_tmp19__length1 = self->priv->to_blinds_length1;
					_tmp20_ = _tmp19_[i];
					_tmp21_ = cairo_create (_tmp20_);
					ctx = _tmp21_;
					_tmp22_ = ctx;
					_tmp23_ = spit_transitions_visuals_get_to_pixbuf (visuals);
					_tmp24_ = _tmp23_;
					gdk_cairo_set_source_pixbuf (_tmp22_, _tmp24_, (gdouble) ((-i) * self->priv->current_blind_width), (gdouble) 0);
					_tmp25_ = ctx;
					cairo_paint (_tmp25_);
					_cairo_destroy0 (ctx);
				}
			}
		}
	}
}

static void
blinds_effect_real_paint (SpitTransitionsEffect* base,
                          SpitTransitionsVisuals* visuals,
                          SpitTransitionsMotion* motion,
                          cairo_t* ctx,
                          gint width,
                          gint height,
                          gint frame_number)
{
	BlindsEffect * self;
	gdouble alpha = 0.0;
	gint y = 0;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	gint x = 0;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	self = (BlindsEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
	_tmp1_ = _tmp0_;
	y = _tmp1_.y;
	spit_transitions_visuals_get_to_pos (visuals, &_tmp2_);
	_tmp3_ = _tmp2_;
	x = _tmp3_.x;
	_tmp4_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		GdkRectangle _tmp8_ = {0};
		GdkRectangle _tmp9_;
		GdkRectangle _tmp10_ = {0};
		GdkRectangle _tmp11_;
		_tmp6_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp7_ = _tmp6_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp8_);
		_tmp9_ = _tmp8_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp10_);
		_tmp11_ = _tmp10_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp7_, (gdouble) _tmp9_.x, (gdouble) _tmp11_.y);
		cairo_paint_with_alpha (ctx, 1 - (alpha * 2));
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				cairo_surface_t** _tmp14_;
				gint _tmp14__length1;
				cairo_surface_t* _tmp15_;
				GdkPixbuf* _tmp16_;
				GdkPixbuf* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				if (!_tmp12_) {
					gint _tmp13_;
					i = i + 1;
					_tmp13_ = i;
				}
				_tmp12_ = FALSE;
				if (!(i < self->priv->blind_count)) {
					break;
				}
				_tmp14_ = self->priv->to_blinds;
				_tmp14__length1 = self->priv->to_blinds_length1;
				_tmp15_ = _tmp14_[i];
				cairo_set_source_surface (ctx, _tmp15_, (gdouble) (x + (i * self->priv->current_blind_width)), (gdouble) y);
				_tmp16_ = spit_transitions_visuals_get_to_pixbuf (visuals);
				_tmp17_ = _tmp16_;
				_tmp18_ = gdk_pixbuf_get_height (_tmp17_);
				_tmp19_ = _tmp18_;
				cairo_rectangle (ctx, (gdouble) (x + (i * self->priv->current_blind_width)), (gdouble) y, self->priv->current_blind_width * (alpha + 0.5), (gdouble) _tmp19_);
				cairo_fill (ctx);
			}
		}
	}
	cairo_clip (ctx);
	cairo_paint (ctx);
}

static void
blinds_effect_real_advance (SpitTransitionsEffect* base,
                            SpitTransitionsVisuals* visuals,
                            SpitTransitionsMotion* motion,
                            gint frame_number)
{
	BlindsEffect * self;
	self = (BlindsEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
blinds_effect_real_cancel (SpitTransitionsEffect* base)
{
	BlindsEffect * self;
	self = (BlindsEffect*) base;
}

static void
blinds_effect_class_init (BlindsEffectClass * klass,
                          gpointer klass_data)
{
	blinds_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BlindsEffect_private_offset);
	G_OBJECT_CLASS (klass)->finalize = blinds_effect_finalize;
}

static void
blinds_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                      gpointer iface_data)
{
	blinds_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) blinds_effect_real_get_fps;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) blinds_effect_real_needs_clear_background;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) blinds_effect_real_start;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) blinds_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) blinds_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) blinds_effect_real_cancel;
}

static void
blinds_effect_instance_init (BlindsEffect * self,
                             gpointer klass)
{
	self->priv = blinds_effect_get_instance_private (self);
}

static void
blinds_effect_finalize (GObject * obj)
{
	BlindsEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLINDS_EFFECT, BlindsEffect);
	self->priv->to_blinds = (_vala_array_free (self->priv->to_blinds, self->priv->to_blinds_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
	G_OBJECT_CLASS (blinds_effect_parent_class)->finalize (obj);
}

static GType
blinds_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BlindsEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) blinds_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BlindsEffect), 0, (GInstanceInitFunc) blinds_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) blinds_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType blinds_effect_type_id;
	blinds_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "BlindsEffect", &g_define_type_info, 0);
	g_type_add_interface_static (blinds_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	BlindsEffect_private_offset = g_type_add_instance_private (blinds_effect_type_id, sizeof (BlindsEffectPrivate));
	return blinds_effect_type_id;
}

GType
blinds_effect_get_type (void)
{
	static volatile gsize blinds_effect_type_id__once = 0;
	if (g_once_init_enter (&blinds_effect_type_id__once)) {
		GType blinds_effect_type_id;
		blinds_effect_type_id = blinds_effect_get_type_once ();
		g_once_init_leave (&blinds_effect_type_id__once, blinds_effect_type_id);
	}
	return blinds_effect_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

