const char merger_lua[] =
"local ffi = require('ffi')\n"
"local fun = require('fun')\n"
"local merger = require('merger')\n"
"\n"
"local ibuf_t = ffi.typeof('struct ibuf')\n"
"local merge_source_t = ffi.typeof('struct merge_source')\n"
"\n"
"-- Create a source from one buffer.\n"
"merger.new_source_frombuffer = function(buf)\n"
"    local func_name = 'merger.new_source_frombuffer'\n"
"    if type(buf) ~= 'cdata' or not ffi.istype(ibuf_t, buf) then\n"
"        error(('Usage: %s(<cdata<struct ibuf>>)'):format(func_name), 0)\n"
"    end\n"
"\n"
"    return merger.new_buffer_source(fun.iter({buf}))\n"
"end\n"
"\n"
"-- Create a source from one table.\n"
"merger.new_source_fromtable = function(tbl)\n"
"    local func_name = 'merger.new_source_fromtable'\n"
"    if type(tbl) ~= 'table' then\n"
"        error(('Usage: %s(<table>)'):format(func_name), 0)\n"
"    end\n"
"\n"
"    return merger.new_table_source(fun.iter({tbl}))\n"
"end\n"
"\n"
"local methods = {\n"
"    ['select'] = merger.internal.select,\n"
"    ['pairs']  = merger.internal.ipairs,\n"
"    ['ipairs']  = merger.internal.ipairs,\n"
"}\n"
"\n"
"ffi.metatype(merge_source_t, {\n"
"    __index = function(self, key)\n"
"        return methods[key]\n"
"    end,\n"
"    -- Lua 5.2 compatibility\n"
"    __pairs = merger.internal.ipairs,\n"
"    __ipairs = merger.internal.ipairs,\n"
"})\n"
""
;
