/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pom.java.LanguageLevel;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes.LanguageLevelQuickFix;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/ProcessQuickFix;", "", "<init>", "()V", "perform", "Ljava/util/concurrent/CompletableFuture;", "languageLevelQuickFix", "Lorg/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFix;", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "intellij.maven"})
public final class ProcessQuickFix {
    @NotNull
    public static final ProcessQuickFix INSTANCE = new ProcessQuickFix();

    private ProcessQuickFix() {
    }

    @NotNull
    public final CompletableFuture<?> perform(@Nullable LanguageLevelQuickFix languageLevelQuickFix, @NotNull Project project, @NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        if (languageLevelQuickFix == null) {
            Object[] objectArray = new Object[]{mavenProject.getDisplayName()};
            new Notification("Maven", "", MavenProjectBundle.message("maven.quickfix.cannot.update.source.level.module.not.found", objectArray), NotificationType.INFORMATION).notify(project);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
        MavenProject mavenProject2 = languageLevelQuickFix.getMavenProject();
        Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"getMavenProject(...)");
        Sdk moduleJdk = MavenUtil.INSTANCE.getModuleJdk(mavenProjectsManager, mavenProject2);
        if (moduleJdk == null) {
            Object[] objectArray = new Object[]{languageLevelQuickFix.getMavenProject().getDisplayName()};
            new Notification("Maven", "", MavenProjectBundle.message("maven.quickfix.cannot.update.source.level.module.not.found", objectArray), NotificationType.INFORMATION).notify(project);
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        LanguageLevel languageLevel = LanguageLevel.Companion.parse(moduleJdk.getVersionString());
        Intrinsics.checkNotNull((Object)languageLevel);
        languageLevelQuickFix.perform(languageLevel);
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }
}

