/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.introduceParameter.IntroduceParameterData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GrExpressionWrapper
implements IntroduceParameterData.ExpressionWrapper {
    private final GrExpression myExpression;
    private final RangeMarker myMarker;
    private final PsiFile myFile;

    public GrExpressionWrapper(@NotNull GrExpression expression) {
        if (expression == null) {
            GrExpressionWrapper.$$$reportNull$$$0(0);
        }
        assert (expression.isValid());
        this.myExpression = expression;
        this.myFile = expression.getContainingFile();
        if (this.myFile.isPhysical()) {
            Document document = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(this.myFile);
            assert (document != null);
            this.myMarker = document.createRangeMarker(this.myExpression.getTextRange());
        } else {
            this.myMarker = null;
        }
    }

    @NotNull
    public String getText() {
        String string = this.myExpression.getText();
        if (string == null) {
            GrExpressionWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiType getType() {
        return this.myExpression.getType();
    }

    @NotNull
    public GrExpression getExpression() {
        PsiElement at;
        if (this.myExpression.isValid()) {
            GrExpression grExpression = this.myExpression;
            if (grExpression == null) {
                GrExpressionWrapper.$$$reportNull$$$0(2);
            }
            return grExpression;
        }
        if (this.myMarker != null && this.myMarker.isValid() && (at = this.myFile.findElementAt(this.myMarker.getStartOffset())) != null) {
            GrExpression grExpression = GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), at);
            if (grExpression == null) {
                GrExpressionWrapper.$$$reportNull$$$0(3);
            }
            return grExpression;
        }
        GrExpression grExpression = GroovyPsiElementFactory.getInstance(this.myFile.getProject()).createExpressionFromText(this.myExpression.getText(), null);
        if (grExpression == null) {
            GrExpressionWrapper.$$$reportNull$$$0(4);
        }
        return grExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/GrExpressionWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

