/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.application.ApplicationManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilerType;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluationCompilerResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.FragmentProjectFileDependencyCollectorKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluatorStatisticsCollector;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenExceptionKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J.\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J(\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00170\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "getFilesToCompile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "onSuccess", "", "processError", "e", "", "otherFiles", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "beforeAnalyzingCodeFragment", "prepareFilesToCompile", "Lkotlin/Pair;", "", "files", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCompilingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,107:1\n81#2:108\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCompilingStrategy.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/IRCodeFragmentCompilingStrategy\n*L\n92#1:108\n*E\n"})
public final class IRCodeFragmentCompilingStrategy
extends CodeFragmentCompilingStrategy {
    public IRCodeFragmentCompilingStrategy(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        super(codeFragment);
    }

    @Override
    @NotNull
    public List<KtFile> getFilesToCompile(@NotNull ResolutionFacade resolutionFacade, @NotNull BindingContext bindingContext) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        List $this$getFilesToCompile_u24lambda_u240 = list2 = CollectionsKt.toMutableList((Collection)FragmentProjectFileDependencyCollectorKt.gatherProjectFilesDependedOnByFragment(this.getCodeFragment(), bindingContext));
        boolean bl = false;
        IRCodeFragmentCompilingStrategy.getFilesToCompile$moveToLast($this$getFilesToCompile_u24lambda_u240, this.getCodeFragment());
        return list2;
    }

    @Override
    public void onSuccess() {
        KotlinDebuggerEvaluatorStatisticsCollector.logAnalysisAndCompilationResult(this.getCodeFragment().getProject(), CompilerType.IR, EvaluationCompilerResult.SUCCESS, this.getStats$kotlin_jvm_debugger_evaluation_k1());
    }

    @Override
    public void processError(@NotNull Throwable e, @NotNull KtCodeFragment codeFragment, @NotNull List<? extends KtFile> otherFiles, @NotNull ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter(otherFiles, (String)"otherFiles");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Throwable throwable = this.unwrapException(e);
        if (throwable == null) {
            throw e;
        }
        Throwable exceptionToReport = throwable;
        KotlinDebuggerEvaluatorStatisticsCollector.logAnalysisAndCompilationResult(codeFragment.getProject(), CompilerType.IR, EvaluationCompilerResult.COMPILER_INTERNAL_ERROR, this.getStats$kotlin_jvm_debugger_evaluation_k1());
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw exceptionToReport;
        }
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            CodeFragmentCodegenExceptionKt.reportErrorWithAttachments$default(executionContext, codeFragment, exceptionToReport, this.prepareFilesToCompile(otherFiles), null, 16, null);
        }
    }

    @Override
    public void beforeAnalyzingCodeFragment() {
        this.getCodeFragment().putCopyableUserData(CodeFragmentUtils.INSTANCE.getUSED_FOR_COMPILATION_IN_IR_EVALUATOR(), (Object)true);
    }

    private final List<Pair<String, String>> prepareFilesToCompile(List<? extends KtFile> files) {
        List list2;
        List $this$prepareFilesToCompile_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (KtFile ktFile2 : files) {
            $this$prepareFilesToCompile_u24lambda_u241.add(TuplesKt.to((Object)ktFile2.getName(), (Object)ktFile2.getText()));
        }
        return CollectionsKt.build((List)list2);
    }

    private static final <T> void getFilesToCompile$moveToLast(List<T> $this$getFilesToCompile_u24moveToLast, T element) {
        $this$getFilesToCompile_u24moveToLast.removeAll(CollectionsKt.listOf(element));
        $this$getFilesToCompile_u24moveToLast.add(element);
    }
}

