/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.counting.trie;

import com.intellij.completion.ngram.slp.counting.Counter;
import com.intellij.completion.ngram.slp.counting.trie.ArrayStorage;
import com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter;
import com.intellij.completion.ngram.slp.counting.trie.MapTrieCounter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractTrie
implements Counter {
    public static int COUNT_OF_COUNTS_CUTOFF = 3;
    public static volatile int[][] nCounts = new int[6][4];
    int[] counts = new int[2 + COUNT_OF_COUNTS_CUTOFF];

    abstract AbstractTrie makeNext(int var1);

    public abstract List<Integer> getSuccessors();

    public abstract Object getSuccessor(int var1);

    abstract List<Integer> getTopSuccessorsInternal(int var1);

    abstract void putSuccessor(int var1, Object var2);

    abstract void removeSuccessor(int var1);

    @Override
    public abstract void readExternal(ObjectInput var1) throws IOException, ClassNotFoundException;

    @Override
    public abstract void writeExternal(ObjectOutput var1) throws IOException;

    @Override
    public final int getCount() {
        return this.counts[0];
    }

    final int getCount(Object successor) {
        if (successor == null) {
            return 0;
        }
        if (successor instanceof AbstractTrie) {
            return ((AbstractTrie)successor).getCount();
        }
        return ((int[])successor)[0];
    }

    public final int getContextCount() {
        return this.counts[1];
    }

    @Override
    public final int getCountOfCount(int n, int count) {
        int minN = Math.min(n, nCounts.length) - 1;
        int minC = Math.min(count, nCounts[minN].length) - 1;
        return nCounts[minN][minC];
    }

    @Override
    public final long[] getCounts(List<Integer> indices) {
        if (indices.isEmpty()) {
            return new long[]{this.getCount(), this.getCount()};
        }
        return this.getCounts(indices, 0);
    }

    private long[] getCounts(List<Integer> indices, int index) {
        boolean nearLast;
        Integer next = indices.get(index);
        Object succ = this.getSuccessor(next);
        boolean bl = nearLast = index == indices.size() - 1;
        if (succ instanceof AbstractTrie) {
            AbstractTrie successor = (AbstractTrie)succ;
            if (!nearLast) {
                return successor.getCounts(indices, index + 1);
            }
            return new long[]{successor.getCount(), this.counts[1]};
        }
        long[] counts = new long[2];
        if (nearLast) {
            counts[1] = this.counts[1];
        }
        if (succ != null) {
            int[] successor = (int[])succ;
            if (ArrayStorage.checkPartialSequence(indices, index, successor)) {
                counts[0] = successor[0];
                if (!nearLast) {
                    counts[1] = counts[0];
                }
            } else if (!nearLast && successor.length >= indices.size() - index && ArrayStorage.checkPartialSequence(indices.subList(0, indices.size() - 1), index, successor)) {
                counts[1] = successor[0];
            }
        }
        return counts;
    }

    @Override
    public final int[] getDistinctCounts(int range, List<Integer> indices) {
        return this.getDistinctCounts(range, indices, 0);
    }

    private int[] getDistinctCounts(int range, List<Integer> indices, int index) {
        if (index < indices.size()) {
            int next = indices.get(index);
            Object succ = this.getSuccessor(next);
            if (succ == null) {
                return new int[range];
            }
            if (succ instanceof AbstractTrie) {
                AbstractTrie successor = (AbstractTrie)succ;
                return successor.getDistinctCounts(range, indices, index + 1);
            }
            int[] successor = (int[])succ;
            int[] distinctCounts = new int[range];
            if (ArrayStorage.checkPartialSequence(indices, index, successor) && !ArrayStorage.checkExactSequence(indices, index, successor)) {
                distinctCounts[Math.min((int)(range - 1), (int)(successor[0] - 1))] = 1;
            }
            return distinctCounts;
        }
        int[] distinctCounts = new int[range];
        int totalDistinct = this.getSuccessorCount();
        for (int i = 2; i < this.counts.length - 1 && i - 1 < range; ++i) {
            int countOfCountsI;
            distinctCounts[i - 2] = countOfCountsI = this.counts[i];
            totalDistinct -= countOfCountsI;
        }
        distinctCounts[range - 1] = totalDistinct;
        return distinctCounts;
    }

    @Override
    public final int getSuccessorCount() {
        return Arrays.stream(this.counts).skip(2L).sum();
    }

    @Override
    public final int getSuccessorCount(List<Integer> indices) {
        Object successor = this.getSuccessorNode(indices, 0);
        if (successor == null) {
            return 0;
        }
        if (successor instanceof AbstractTrie) {
            return ((AbstractTrie)successor).getSuccessorCount();
        }
        return 1;
    }

    private Object getSuccessorNode(List<Integer> indices, int index) {
        if (index == indices.size()) {
            return this;
        }
        int next = indices.get(index);
        Object succ = this.getSuccessor(next);
        if (succ == null) {
            return null;
        }
        if (succ instanceof AbstractTrie) {
            AbstractTrie successor = (AbstractTrie)succ;
            return successor.getSuccessorNode(indices, index + 1);
        }
        int[] successor = (int[])succ;
        if (!ArrayStorage.checkPartialSequence(indices, index, successor)) {
            return null;
        }
        int[] trueSucc = new int[1 + successor.length - (indices.size() - index)];
        trueSucc[0] = successor[0];
        for (int i = 1; i < trueSucc.length; ++i) {
            trueSucc[i] = successor[i + indices.size() - index - 1];
        }
        return trueSucc;
    }

    @Override
    public List<Integer> getTopSuccessors(List<Integer> indices, int limit) {
        Object successor = this.getSuccessorNode(indices, 0);
        if (successor == null) {
            return new ArrayList<Integer>();
        }
        if (successor instanceof AbstractTrie) {
            return ((AbstractTrie)successor).getTopSuccessorsInternal(limit);
        }
        int[] succ = (int[])successor;
        ArrayList<Integer> successors = new ArrayList<Integer>();
        if (succ.length > 1) {
            successors.add(succ[1]);
        }
        return successors;
    }

    @Override
    public final void count(List<Integer> indices) {
        this.update(indices, 1);
    }

    @Override
    public final void unCount(List<Integer> indices) {
        this.update(indices, -1);
    }

    public final void updateCount(int adj) {
        this.update(Collections.emptyList(), adj);
    }

    public final void update(List<Integer> indices, int adj) {
        this.update(indices, 0, adj);
    }

    private synchronized void update(List<Integer> indices, int index, int adj) {
        if (index < indices.size()) {
            int key = indices.get(index);
            Object successor = this.getSuccessor(key);
            if (successor != null) {
                this.updateSuccessor(indices, index, adj, successor);
            } else {
                this.addArray(indices, index, adj);
            }
        }
        this.counts[0] = this.counts[0] + adj;
        if (index != indices.size()) {
            this.counts[1] = this.counts[1] + adj;
        }
        AbstractTrie.updateNCounts(index, this.getCount(), adj);
    }

    private void updateSuccessor(List<Integer> indices, int index, int adj, Object succ) {
        if (succ instanceof AbstractTrie) {
            this.updateTrie(indices, index, adj, succ);
        } else {
            this.updateArray(indices, index, adj, succ);
        }
    }

    private void updateTrie(List<Integer> indices, int index, int adj, Object succ) {
        AbstractTrie next = (AbstractTrie)succ;
        if (next instanceof ArrayTrieCounter) {
            ArrayTrieCounter arrayCounter = (ArrayTrieCounter)next;
            if (arrayCounter.indices.length > 10) {
                next = this.promoteArrayToMap(indices, index, arrayCounter);
            }
        }
        next.update(indices, index + 1, adj);
        this.updateCoCs(next.getCount(), adj);
        if (next.getCount() == 0) {
            this.removeSuccessor(indices.get(index));
        }
    }

    private void updateArray(List<Integer> indices, int index, int adj, Object succ) {
        int[] successor = (int[])succ;
        boolean valid = ArrayStorage.checkExactSequence(indices, index, successor);
        if (valid) {
            this.updateArrayCount(indices, index, adj, successor);
        } else {
            AbstractTrie newNext = this.promoteArrayToTrie(indices, index, successor);
            this.updateTrie(indices, index, adj, newNext);
        }
    }

    private void updateArrayCount(List<Integer> indices, int index, int adj, int[] successor) {
        successor[0] = successor[0] + adj;
        if (successor[0] == 0) {
            this.removeSuccessor(indices.get(index));
        }
        this.updateCoCs(successor[0], adj);
        for (int i = index + 1; i <= indices.size(); ++i) {
            AbstractTrie.updateNCounts(i, successor[0], adj);
        }
    }

    private AbstractTrie promoteArrayToMap(List<Integer> indices, int index, ArrayTrieCounter counter) {
        MapTrieCounter newNext = new MapTrieCounter();
        newNext.counts = counter.counts;
        for (int i = 0; i < counter.indices.length; ++i) {
            int ix = counter.indices[i];
            if (ix == Integer.MAX_VALUE) continue;
            Object successor = counter.successors[i];
            ((AbstractTrie)newNext).putSuccessor(ix, successor);
        }
        this.putSuccessor(indices.get(index), newNext);
        return newNext;
    }

    private AbstractTrie promoteArrayToTrie(List<Integer> indices, int index, int[] successor) {
        AbstractTrie newNext = this.makeNext(index);
        newNext.updateCount(successor[0]);
        if (successor.length > 1) {
            newNext.counts[1] = newNext.counts[0];
            int[] temp = Arrays.copyOfRange(successor, 1, successor.length);
            temp[0] = successor[0];
            newNext.putSuccessor(successor[1], temp);
            if (COUNT_OF_COUNTS_CUTOFF > 0) {
                int n = 1 + Math.min(temp[0], COUNT_OF_COUNTS_CUTOFF);
                newNext.counts[n] = newNext.counts[n] + 1;
            }
        }
        this.putSuccessor(indices.get(index), newNext);
        return newNext;
    }

    private void addArray(List<Integer> indices, int index, int adj) {
        int i;
        if (adj < 0) {
            return;
        }
        int[] singleton = new int[indices.size() - index];
        singleton[0] = adj;
        for (i = 1; i < singleton.length; ++i) {
            singleton[i] = indices.get(index + i);
        }
        this.putSuccessor(indices.get(index), singleton);
        this.updateCoCs(adj, adj);
        for (i = index + 1; i <= indices.size(); ++i) {
            AbstractTrie.updateNCounts(i, adj, adj);
        }
    }

    private static void updateNCounts(int n, int count, int adj) {
        int prevIndex;
        if (n == 0) {
            return;
        }
        if (n > 6) {
            return;
        }
        int[] toUpdate = nCounts[n - 1];
        int currIndex = Math.min(count, toUpdate.length);
        if (currIndex != (prevIndex = Math.min(count - adj, toUpdate.length))) {
            boolean updatePrev;
            boolean updateCurr = currIndex > 0;
            boolean bl = updatePrev = prevIndex > 0;
            if (updateCurr) {
                int n2 = currIndex - 1;
                toUpdate[n2] = toUpdate[n2] + 1;
            }
            if (updatePrev) {
                int n3 = prevIndex - 1;
                toUpdate[n3] = toUpdate[n3] - 1;
            }
        }
    }

    private void updateCoCs(int count, int adj) {
        int prevIndex;
        if (COUNT_OF_COUNTS_CUTOFF == 0) {
            return;
        }
        int currIndex = Math.min(count, COUNT_OF_COUNTS_CUTOFF);
        if (currIndex != (prevIndex = Math.min(count - adj, COUNT_OF_COUNTS_CUTOFF))) {
            if (currIndex >= 1) {
                int n = currIndex + 1;
                this.counts[n] = this.counts[n] + 1;
            }
            if (prevIndex >= 1) {
                int n = prevIndex + 1;
                this.counts[n] = this.counts[n] - 1;
            }
        }
    }
}

