/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.tree;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.fus.JsonSchemaFusCountedFeature;
import com.jetbrains.jsonSchema.fus.JsonSchemaHighlightingSessionStatisticsCollector;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.SchemaResolveState;
import com.jetbrains.jsonSchema.impl.tree.JsonSchemaNodeExpansionRequest;
import com.jetbrains.jsonSchema.impl.tree.Operation;
import com.jetbrains.jsonSchema.impl.tree.ProcessDefinitionsOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllOfOperation
extends Operation {
    private final JsonSchemaService myService;

    public AllOfOperation(@NotNull JsonSchemaObject sourceNode, JsonSchemaService service, @Nullable JsonSchemaNodeExpansionRequest expansionRequest) {
        if (sourceNode == null) {
            AllOfOperation.$$$reportNull$$$0(0);
        }
        super(sourceNode, expansionRequest);
        this.myService = service;
    }

    @Override
    public void map(@NotNull Set<JsonSchemaObject> visited) {
        if (visited == null) {
            AllOfOperation.$$$reportNull$$$0(1);
        }
        JsonSchemaHighlightingSessionStatisticsCollector.getInstance().reportSchemaUsageFeature(JsonSchemaFusCountedFeature.AllOfExpanded);
        List<? extends JsonSchemaObject> allOf = this.mySourceNode.getAllOf();
        assert (allOf != null);
        this.myChildOperations.addAll(ContainerUtil.map(allOf, sourceNode -> new ProcessDefinitionsOperation((JsonSchemaObject)sourceNode, this.myService, this.myExpansionRequest)));
    }

    private static <T> int maxSize(List<List<T>> items) {
        if (items.isEmpty()) {
            return 0;
        }
        int maxsize = -1;
        for (List<T> item : items) {
            int size = item.size();
            if (maxsize >= size) continue;
            maxsize = size;
        }
        return maxsize;
    }

    @Override
    public void reduce() {
        this.myAnyOfGroup.add(this.mySourceNode);
        for (Operation op : this.myChildOperations) {
            if (!op.myState.equals((Object)SchemaResolveState.normal)) continue;
            List<JsonSchemaObject> mergedAny = JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, this.myAnyOfGroup);
            if (mergedAny.isEmpty() && !op.myAnyOfGroup.isEmpty()) {
                mergedAny.addAll(op.myAnyOfGroup);
            }
            ArrayList<List<JsonSchemaObject>> mergedExclusive = new ArrayList<List<JsonSchemaObject>>(op.myAnyOfGroup.size() * AllOfOperation.maxSize(this.myOneOfGroup) + this.myAnyOfGroup.size() * AllOfOperation.maxSize(op.myOneOfGroup) + AllOfOperation.maxSize(this.myOneOfGroup) * AllOfOperation.maxSize(op.myOneOfGroup));
            for (List list : this.myOneOfGroup) {
                mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(op.myAnyOfGroup, list));
            }
            for (List list : op.myOneOfGroup) {
                mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list, this.myAnyOfGroup));
            }
            for (List list : op.myOneOfGroup) {
                for (List otherGroup : this.myOneOfGroup) {
                    mergedExclusive.add(JsonSchemaVariantsTreeBuilder.andGroups(list, otherGroup));
                }
            }
            this.myAnyOfGroup.clear();
            this.myOneOfGroup.clear();
            this.myAnyOfGroup.addAll(mergedAny);
            this.myOneOfGroup.addAll(mergedExclusive);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/tree/AllOfOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "map";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

