/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.remote;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.remote.LangDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.util.io.DigestUtil;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u001a\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001c\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0018H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/grazie/remote/GrazieRemote;", "", "<init>", "()V", "isLibExists", "", "lib", "", "isAvailableLocally", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "allAvailableLocally", "", "download", "project", "Lcom/intellij/openapi/project/Project;", "downloadAsync", "", "languages", "", "downloadMissing", "isValidBundleForLanguage", "language", "file", "Ljava/nio/file/Path;", "checksum", "path", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nGrazieRemote.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieRemote.kt\ncom/intellij/grazie/remote/GrazieRemote\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,53:1\n3829#2:54\n4344#2,2:55\n*S KotlinDebug\n*F\n+ 1 GrazieRemote.kt\ncom/intellij/grazie/remote/GrazieRemote\n*L\n21#1:54\n21#1:55,2\n*E\n"})
public final class GrazieRemote {
    @NotNull
    public static final GrazieRemote INSTANCE = new GrazieRemote();

    private GrazieRemote() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLibExists(String lib) {
        Path path = GrazieDynamic.INSTANCE.getDynamicFolder().resolve(lib);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return true;
        Path path3 = GraziePlugin.INSTANCE.getLibFolder().resolve(lib);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        path2 = path3;
        linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        return true;
    }

    public final boolean isAvailableLocally(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return lang.isEnglish() || this.isLibExists(lang.getRemote().getFileName());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Lang> allAvailableLocally() {
        void $this$filterTo$iv$iv;
        Lang[] $this$filter$iv = Lang.values();
        boolean $i$f$filter = false;
        Lang[] langArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!INSTANCE.isAvailableLocally((Lang)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean download(@NotNull Lang lang, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return LangDownloader.INSTANCE.download(lang, project);
    }

    public static /* synthetic */ boolean download$default(GrazieRemote grazieRemote, Lang lang, Project project, int n, Object object) {
        if ((n & 2) != 0) {
            project = null;
        }
        return grazieRemote.download(lang, project);
    }

    public final void downloadAsync(@NotNull Collection<? extends Lang> languages2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangDownloader.INSTANCE.downloadAsync(languages2, project);
    }

    public final void downloadMissing(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LangDownloader.INSTANCE.downloadAsync((Collection<? extends Lang>)GrazieConfig.Companion.get().getMissedLanguages(), project);
    }

    public final boolean isValidBundleForLanguage(@NotNull Lang language, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String actualChecksum = this.checksum(file);
        return Intrinsics.areEqual((Object)language.getRemote().getChecksum(), (Object)actualChecksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public final String checksum(@NotNull Path path) {
        MessageDigest messageDigest;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            MessageDigest digest = DigestUtil.md5();
            Closeable closeable2 = new DigestInputStream(it, digest);
            Throwable throwable2 = null;
            try {
                DigestInputStream stream = (DigestInputStream)closeable2;
                boolean bl2 = false;
                byte[] buffer = new byte[8192];
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = stream.read(buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            messageDigest = digest;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        MessageDigest digest = messageDigest;
        return DigestUtil.digestToHash((MessageDigest)digest);
    }
}

