/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.cert;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1SequenceInputStream;
import oracle.security.pki.internal.cert.X509Extension;
import oracle.security.pki.util.Utils;

public class X509ExtensionSet
implements Externalizable,
java.security.cert.X509Extension,
ASN1Object {
    private LinkedHashMap<ASN1ObjectID, X509Extension> a = new LinkedHashMap();
    private ASN1Sequence b = null;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(List<X509Extension> list) {
        for (X509Extension x509Extension : list) {
            this.a(x509Extension);
        }
    }

    public X509ExtensionSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509Extension a(X509Extension x509Extension) {
        this.e();
        return this.a.put(x509Extension.b(), x509Extension);
    }

    public X509Extension a(ASN1ObjectID aSN1ObjectID) {
        return this.a.get(aSN1ObjectID);
    }

    public Map<ASN1ObjectID, X509Extension> a() {
        return this.a;
    }

    public ArrayList<X509Extension> b() {
        return this.a == null ? null : new ArrayList<X509Extension>(this.a.values());
    }

    public int c() {
        return this.a.size();
    }

    public boolean b(ASN1ObjectID aSN1ObjectID) {
        return this.a.containsKey(aSN1ObjectID);
    }

    public boolean d() {
        for (X509Extension x509Extension : this.a.values()) {
            if (!x509Extension.c() || x509Extension.a()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator<X509Extension> iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509Extension x509Extension : this.a.values()) {
            if (!x509Extension.c()) continue;
            linkedHashSet.add(x509Extension.b().d());
        }
        return linkedHashSet;
    }

    @Override
    public byte[] getExtensionValue(String string) {
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(string);
        return this.a.get(aSN1ObjectID).d();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (X509Extension x509Extension : this.a.values()) {
            if (x509Extension.c()) continue;
            linkedHashSet.add(x509Extension.b().d());
        }
        return linkedHashSet;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.d();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.a.clear();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.a()) {
            this.a(X509Extension.a(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.b();
        this.e();
        if (this.c() == 0) {
            throw new ASN1FormatException("Extension set must contain at least 1 extension");
        }
    }

    private void e() {
        this.b = null;
    }

    private ASN1Sequence f() {
        if (this.b == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            for (X509Extension x509Extension : this.a.values()) {
                aSN1Sequence.a(x509Extension);
            }
            this.b = aSN1Sequence;
        }
        return this.b;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.f().output(outputStream);
    }

    @Override
    public int length() {
        return this.f().length();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

