/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import net.sourceforge.plantuml.emoji.GrayLevelRange;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;

public class ColorResolver {
    private final HColorSimple fontColor;
    private final HColorSimple forcedColor;
    private final GrayLevelRange grayLevelRange;

    public ColorResolver(HColor fontColor, HColor forcedColor, GrayLevelRange grayLevelRange) {
        this.fontColor = (HColorSimple)fontColor;
        this.forcedColor = (HColorSimple)forcedColor;
        this.grayLevelRange = grayLevelRange;
    }

    public HColor getDefaultColor() {
        if (this.fontColor == null && this.forcedColor == null) {
            return HColors.BLACK;
        }
        return this.forcedColor == null ? this.fontColor : this.forcedColor;
    }

    public HColor getTrueColor(String code) {
        if (code.equalsIgnoreCase("none")) {
            return HColors.none();
        }
        HColorSimple result = (HColorSimple)HColorSet.instance().getColorOrWhite(code);
        if (this.forcedColor == null) {
            return result;
        }
        if (this.forcedColor.isGray()) {
            return result.asMonochrome();
        }
        return result.asMonochrome(this.forcedColor, this.grayLevelRange.getMinGrayLevel(), this.grayLevelRange.getMaxGrayLevel());
    }
}

