/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.pivotal.PivotalTrackerRepository;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class PivotalTrackerRepositoryEditor
extends BaseRepositoryEditor<PivotalTrackerRepository> {
    private JTextField myProjectId;
    private JBLabel myProjectIDLabel;

    public PivotalTrackerRepositoryEditor(Project project, PivotalTrackerRepository repository, Consumer<? super PivotalTrackerRepository> changeListener) {
        super(project, repository, changeListener);
        this.myUserNameText.setVisible(false);
        this.myUsernameLabel.setVisible(false);
        this.myPasswordLabel.setText(TaskBundle.message((String)"label.api.token", (Object[])new Object[0]));
        this.myProjectId.setText(repository.getProjectId());
        this.myUseHttpAuthenticationCheckBox.setVisible(false);
    }

    @Override
    public void apply() {
        super.apply();
        ((PivotalTrackerRepository)this.myRepository).setProjectId(this.myProjectId.getText().trim());
    }

    @Override
    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectIDLabel = new JBLabel(TaskBundle.message((String)"label.project.id", (Object[])new Object[0]), 4);
        this.myProjectId = new JTextField();
        this.installListener(this.myProjectId);
        return FormBuilder.createFormBuilder().addLabeledComponent((JComponent)this.myProjectIDLabel, (JComponent)this.myProjectId).getPanel();
    }

    @Override
    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectIDLabel.setAnchor(anchor);
    }
}

