/* auto-generated, do not modify */
#include "config.h"

#include "fu-ep963x-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ep963x_smbus_error_to_string(FuEp963xSmbusError val)
{
    if (val == FU_EP963X_SMBUS_ERROR_NONE)
        return "none";
    if (val == FU_EP963X_SMBUS_ERROR_ADDRESS)
        return "address";
    if (val == FU_EP963X_SMBUS_ERROR_NO_ACK)
        return "no-ack";
    if (val == FU_EP963X_SMBUS_ERROR_ARBITRATION)
        return "arbitration";
    if (val == FU_EP963X_SMBUS_ERROR_COMMAND)
        return "command";
    if (val == FU_EP963X_SMBUS_ERROR_TIMEOUT)
        return "timeout";
    if (val == FU_EP963X_SMBUS_ERROR_BUSY)
        return "busy";
    return NULL;
}




/* getters */
/**
 * fu_struct_ep963x_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_ep963x_firmware_hdr_get_magic(const FuStructEp963xFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 16, 5, NULL);
}

/* setters */
static gboolean
fu_struct_ep963x_firmware_hdr_validate_internal(FuStructEp963xFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->data + 16), "EP963", 5) != 0) {
        g_autofree gchar *str = fu_struct_ep963x_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEp963xFirmwareHdr.magic was not valid, "
                    "expected 'EP963' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ep963x_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_ep963x_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st = fu_input_stream_read_byte_array(stream, offset, 21, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructEp963xFirmwareHdr failed read of 0x%x: ", (guint) 21);
        return FALSE;
    }
    if (st->len != 21) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEp963xFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 21,
                    (guint) st->len);
        return FALSE;
    }
    return fu_struct_ep963x_firmware_hdr_validate_internal(st, error);
}
