/* auto-generated, do not modify */
#include "config.h"

#include "fu-redfish-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


const gchar *
fu_redfish_interface_type_to_string(FuRedfishInterfaceType val)
{
    if (val == FU_REDFISH_INTERFACE_TYPE_USB_NETWORK)
        return "usb-network";
    if (val == FU_REDFISH_INTERFACE_TYPE_PCI_NETWORK)
        return "pci-network";
    if (val == FU_REDFISH_INTERFACE_TYPE_USB_NETWORK_V2)
        return "usb-network-v2";
    if (val == FU_REDFISH_INTERFACE_TYPE_PCI_NETWORK_V2)
        return "pci-network-v2";
    return NULL;
}



const gchar *
fu_redfish_smbios_interface_type_to_string(FuRedfishSmbiosInterfaceType val)
{
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_UNKNOWN)
        return "unknown";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_KCS)
        return "kcs";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_8250_UART)
        return "8250-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_16450_UART)
        return "16450-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_16550_UART)
        return "16550-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_16650_UART)
        return "16650-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_16750_UART)
        return "16750-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_16850_UART)
        return "16850-uart";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_MCTP)
        return "mctp";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_NETWORK)
        return "network";
    if (val == FU_REDFISH_SMBIOS_INTERFACE_TYPE_OEM)
        return "oem";
    return NULL;
}

const gchar *
fu_redfish_network_device_state_to_string(FuRedfishNetworkDeviceState val)
{
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_UNKNOWN)
        return "unknown";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_UNMANAGED)
        return "unmanaged";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_UNAVAILABLE)
        return "unavailable";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_DISCONNECTED)
        return "disconnected";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_PREPARE)
        return "prepare";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_CONFIG)
        return "config";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_NEED_AUTH)
        return "need-auth";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_IP_CONFIG)
        return "ip-config";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_IP_CHECK)
        return "ip-check";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_SECONDARIES)
        return "secondaries";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_ACTIVATED)
        return "activated";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_DEACTIVATING)
        return "deactivating";
    if (val == FU_REDFISH_NETWORK_DEVICE_STATE_FAILED)
        return "failed";
    return NULL;
}
/* getters */
/**
 * fu_struct_redfish_protocol_over_ip_get_service_uuid: (skip):
 **/
const fwupd_guid_t *
fu_struct_redfish_protocol_over_ip_get_service_uuid(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_redfish_protocol_over_ip_get_host_ip_assignment_type: (skip):
 **/
guint8
fu_struct_redfish_protocol_over_ip_get_host_ip_assignment_type(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[16];
}
/**
 * fu_struct_redfish_protocol_over_ip_get_host_ip_address_format: (skip):
 **/
guint8
fu_struct_redfish_protocol_over_ip_get_host_ip_address_format(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[17];
}
/**
 * fu_struct_redfish_protocol_over_ip_get_host_ip_address: (skip):
 **/
const guint8 *
fu_struct_redfish_protocol_over_ip_get_host_ip_address(const FuStructRedfishProtocolOverIp *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->data + 18;
}
/**
 * fu_struct_redfish_protocol_over_ip_get_host_ip_mask: (skip):
 **/
const guint8 *
fu_struct_redfish_protocol_over_ip_get_host_ip_mask(const FuStructRedfishProtocolOverIp *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->data + 34;
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_assignment_type: (skip):
 **/
guint8
fu_struct_redfish_protocol_over_ip_get_service_ip_assignment_type(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[50];
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_address_format: (skip):
 **/
guint8
fu_struct_redfish_protocol_over_ip_get_service_ip_address_format(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[51];
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_address: (skip):
 **/
const guint8 *
fu_struct_redfish_protocol_over_ip_get_service_ip_address(const FuStructRedfishProtocolOverIp *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->data + 52;
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_mask: (skip):
 **/
const guint8 *
fu_struct_redfish_protocol_over_ip_get_service_ip_mask(const FuStructRedfishProtocolOverIp *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 16;
    return st->data + 68;
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_port: (skip):
 **/
guint16
fu_struct_redfish_protocol_over_ip_get_service_ip_port(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 84, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_ip_vlan_id: (skip):
 **/
guint32
fu_struct_redfish_protocol_over_ip_get_service_ip_vlan_id(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 86, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_redfish_protocol_over_ip_get_service_hostname_len: (skip):
 **/
guint8
fu_struct_redfish_protocol_over_ip_get_service_hostname_len(const FuStructRedfishProtocolOverIp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[90];
}

/* setters */
/**
 * fu_struct_redfish_protocol_over_ip_set_service_uuid: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_uuid(FuStructRedfishProtocolOverIp *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value)); /* nocheck:blocked */
}
/**
 * fu_struct_redfish_protocol_over_ip_set_host_ip_assignment_type: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_host_ip_assignment_type(FuStructRedfishProtocolOverIp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[16] = value;
}
/**
 * fu_struct_redfish_protocol_over_ip_set_host_ip_address_format: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_host_ip_address_format(FuStructRedfishProtocolOverIp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[17] = value;
}
/**
 * fu_struct_redfish_protocol_over_ip_set_host_ip_address: (skip):
 **/
gboolean
fu_struct_redfish_protocol_over_ip_set_host_ip_address(FuStructRedfishProtocolOverIp *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 18, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_host_ip_mask: (skip):
 **/
gboolean
fu_struct_redfish_protocol_over_ip_set_host_ip_mask(FuStructRedfishProtocolOverIp *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 34, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_assignment_type: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_ip_assignment_type(FuStructRedfishProtocolOverIp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[50] = value;
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_address_format: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_ip_address_format(FuStructRedfishProtocolOverIp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[51] = value;
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_address: (skip):
 **/
gboolean
fu_struct_redfish_protocol_over_ip_set_service_ip_address(FuStructRedfishProtocolOverIp *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 52, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_mask: (skip):
 **/
gboolean
fu_struct_redfish_protocol_over_ip_set_service_ip_mask(FuStructRedfishProtocolOverIp *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 68, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_port: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_ip_port(FuStructRedfishProtocolOverIp *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 84, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_ip_vlan_id: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_ip_vlan_id(FuStructRedfishProtocolOverIp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 86, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_redfish_protocol_over_ip_set_service_hostname_len: (skip):
 **/
void
fu_struct_redfish_protocol_over_ip_set_service_hostname_len(FuStructRedfishProtocolOverIp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[90] = value;
}
/**
 * fu_struct_redfish_protocol_over_ip_new: (skip):
 **/
FuStructRedfishProtocolOverIp *
fu_struct_redfish_protocol_over_ip_new(void)
{
    FuStructRedfishProtocolOverIp *st = g_byte_array_sized_new(91);
    fu_byte_array_set_size(st, 91, 0x0);
    return st;
}
/**
 * fu_struct_redfish_protocol_over_ip_to_string: (skip):
 **/
static gchar *
fu_struct_redfish_protocol_over_ip_to_string(const FuStructRedfishProtocolOverIp *st)
{
    g_autoptr(GString) str = g_string_new("FuStructRedfishProtocolOverIp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_redfish_protocol_over_ip_get_service_uuid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  service_uuid: %s\n", tmp);
    }
    g_string_append_printf(str, "  host_ip_assignment_type: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_host_ip_assignment_type(st));
    g_string_append_printf(str, "  host_ip_address_format: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_host_ip_address_format(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_redfish_protocol_over_ip_get_host_ip_address(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  host_ip_address: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_redfish_protocol_over_ip_get_host_ip_mask(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  host_ip_mask: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  service_ip_assignment_type: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_service_ip_assignment_type(st));
    g_string_append_printf(str, "  service_ip_address_format: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_service_ip_address_format(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_redfish_protocol_over_ip_get_service_ip_address(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  service_ip_address: 0x%s\n", tmp->str);
    }
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_redfish_protocol_over_ip_get_service_ip_mask(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  service_ip_mask: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  service_ip_port: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_service_ip_port(st));
    g_string_append_printf(str, "  service_ip_vlan_id: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_service_ip_vlan_id(st));
    g_string_append_printf(str, "  service_hostname_len: 0x%x\n",
                           (guint) fu_struct_redfish_protocol_over_ip_get_service_hostname_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_redfish_protocol_over_ip_validate_internal(FuStructRedfishProtocolOverIp *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_redfish_protocol_over_ip_parse_internal(FuStructRedfishProtocolOverIp *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_redfish_protocol_over_ip_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_redfish_protocol_over_ip_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_redfish_protocol_over_ip_parse_stream: (skip):
 **/
FuStructRedfishProtocolOverIp *
fu_struct_redfish_protocol_over_ip_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 91, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructRedfishProtocolOverIp failed read of 0x%x: ", (guint) 91);
        return NULL;
    }
    if (st->len != 91) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructRedfishProtocolOverIp requested 0x%x and got 0x%x",
                    (guint) 91,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_redfish_protocol_over_ip_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_redfish_smbios_type42_get_type: (skip):
 **/
static guint8
fu_struct_redfish_smbios_type42_get_type(const FuStructRedfishSmbiosType42 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_redfish_smbios_type42_get_length: (skip):
 **/
guint8
fu_struct_redfish_smbios_type42_get_length(const FuStructRedfishSmbiosType42 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_redfish_smbios_type42_get_handle: (skip):
 **/
guint16
fu_struct_redfish_smbios_type42_get_handle(const FuStructRedfishSmbiosType42 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_redfish_smbios_type42_get_interface_type: (skip):
 **/
FuRedfishSmbiosInterfaceType
fu_struct_redfish_smbios_type42_get_interface_type(const FuStructRedfishSmbiosType42 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}
/**
 * fu_struct_redfish_smbios_type42_get_data_length: (skip):
 **/
guint8
fu_struct_redfish_smbios_type42_get_data_length(const FuStructRedfishSmbiosType42 *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}

/* setters */
/**
 * fu_struct_redfish_smbios_type42_to_string: (skip):
 **/
static gchar *
fu_struct_redfish_smbios_type42_to_string(const FuStructRedfishSmbiosType42 *st)
{
    g_autoptr(GString) str = g_string_new("FuStructRedfishSmbiosType42:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_redfish_smbios_type42_get_length(st));
    g_string_append_printf(str, "  handle: 0x%x\n",
                           (guint) fu_struct_redfish_smbios_type42_get_handle(st));
    {
        const gchar *tmp = fu_redfish_smbios_interface_type_to_string(fu_struct_redfish_smbios_type42_get_interface_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  interface_type: 0x%x [%s]\n", (guint) fu_struct_redfish_smbios_type42_get_interface_type(st), tmp);
        } else {
            g_string_append_printf(str, "  interface_type: 0x%x\n", (guint) fu_struct_redfish_smbios_type42_get_interface_type(st));
        }
    }
    g_string_append_printf(str, "  data_length: 0x%x\n",
                           (guint) fu_struct_redfish_smbios_type42_get_data_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_redfish_smbios_type42_validate_internal(FuStructRedfishSmbiosType42 *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_redfish_smbios_type42_get_type(st) != 42) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructRedfishSmbiosType42.type was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_redfish_smbios_type42_parse_internal(FuStructRedfishSmbiosType42 *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_redfish_smbios_type42_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_redfish_smbios_type42_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_redfish_smbios_type42_parse_stream: (skip):
 **/
FuStructRedfishSmbiosType42 *
fu_struct_redfish_smbios_type42_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 6, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructRedfishSmbiosType42 failed read of 0x%x: ", (guint) 6);
        return NULL;
    }
    if (st->len != 6) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructRedfishSmbiosType42 requested 0x%x and got 0x%x",
                    (guint) 6,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_redfish_smbios_type42_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
