/* util-contact.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-contact.vala, do not modify */

/*
 * Copyright 2022 Cédric Bellegarde <cedric.bellegarde@adishatz.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

/**
     * Returns true if loading images for contact is allowed
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
util_contact_should_load_images (ApplicationContact* contact,
                                 ApplicationConfiguration* config)
{
	GeeCollection* email_addresses = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gchar** domains = NULL;
	gint _tmp3_ = 0;
	gchar** _tmp4_;
	gint domains_length1;
	gint _domains_size_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (contact), FALSE);
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), FALSE);
	_tmp0_ = application_contact_get_email_addresses (contact);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	email_addresses = _tmp2_;
	_tmp4_ = application_configuration_get_images_trusted_domains (config, &_tmp3_);
	domains = _tmp4_;
	domains_length1 = _tmp3_;
	_domains_size_ = domains_length1;
	if (contact == NULL) {
		result = FALSE;
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (email_addresses);
		return result;
	} else {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = application_contact_get_load_remote_resources (contact);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			result = TRUE;
			domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (email_addresses);
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp8_ = domains;
			_tmp8__length1 = domains_length1;
			if (_tmp8__length1 > 0) {
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				_tmp9_ = domains;
				_tmp9__length1 = domains_length1;
				_tmp10_ = _tmp9_[0];
				_tmp7_ = g_strcmp0 (_tmp10_, "*") == 0;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (email_addresses);
				return result;
			} else {
				{
					GeeIterator* _email_it = NULL;
					GeeCollection* _tmp11_;
					GeeIterator* _tmp12_;
					_tmp11_ = email_addresses;
					_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
					_email_it = _tmp12_;
					while (TRUE) {
						GeeIterator* _tmp13_;
						GearyRFC822MailboxAddress* email = NULL;
						GeeIterator* _tmp14_;
						gpointer _tmp15_;
						GearyRFC822MailboxAddress* _tmp16_;
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						gchar** _tmp19_;
						gint _tmp19__length1;
						_tmp13_ = _email_it;
						if (!gee_iterator_next (_tmp13_)) {
							break;
						}
						_tmp14_ = _email_it;
						_tmp15_ = gee_iterator_get (_tmp14_);
						email = (GearyRFC822MailboxAddress*) _tmp15_;
						_tmp16_ = email;
						_tmp17_ = geary_rf_c822_mailbox_address_get_domain (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp19_ = domains;
						_tmp19__length1 = domains_length1;
						if (_vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_)) {
							result = TRUE;
							_g_object_unref0 (email);
							_g_object_unref0 (_email_it);
							domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (email_addresses);
							return result;
						}
						_g_object_unref0 (email);
					}
					_g_object_unref0 (_email_it);
				}
			}
		}
	}
	result = FALSE;
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (email_addresses);
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

