/* math-preferences.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-preferences.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "calculator.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
typedef struct _MathPreferencesDialogPrivate MathPreferencesDialogPrivate;
enum  {
	MATH_PREFERENCES_DIALOG_0_PROPERTY,
	MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY,
	MATH_PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_NUM_PROPERTIES];
typedef enum  {
	MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT = 8,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT = 16,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT = 32,
	MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT = 64
} MathPreferencesDialogWordSize;

#define MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE (math_preferences_dialog_word_size_get_type ())
typedef enum  {
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER = 0,
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY = 86400,
	MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY = 604800
} MathPreferencesDialogRefreshInterval;

#define MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL (math_preferences_dialog_refresh_interval_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef enum  {
	CURRENCY_DISPLAY_CODE,
	CURRENCY_DISPLAY_NAME,
	CURRENCY_DISPLAY_BOTH
} CurrencyDisplay;

#define TYPE_CURRENCY_DISPLAY (currency_display_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))

struct _MathPreferencesDialog {
	AdwPreferencesDialog parent_instance;
	MathPreferencesDialogPrivate * priv;
};

struct _MathPreferencesDialogClass {
	AdwPreferencesDialogClass parent_class;
};

struct _MathPreferencesDialogPrivate {
	MathEquation* _equation;
	AdwComboRow* row_angle_units;
	AdwComboRow* row_word_size;
	AdwComboRow* row_refresh_interval;
	AdwComboRow* row_currency_display;
	AdwComboRow* row_currency_completion;
	AdwSpinRow* row_decimals;
	AdwSwitchRow* row_trailing_zeroes;
	AdwSwitchRow* row_thousands_separators;
	AdwNavigationPage* page_favorite_currencies;
	AdwPreferencesGroup* group_favorite_currencies;
	GtkSearchEntry* search_entry;
	GtkStack* search_stack;
	GHashTable* currency_rows;
	gulong favorites_changed;
	GSettings* settings;
};

struct _Block8Data {
	int _ref_count_;
	MathPreferencesDialog* self;
	gchar** favorites;
	gint favorites_length1;
	gint _favorites_size_;
};

struct _Block9Data {
	int _ref_count_;
	MathPreferencesDialog* self;
	gchar* search;
	gboolean found;
};

static gint MathPreferencesDialog_private_offset;
static gpointer math_preferences_dialog_parent_class = NULL;

VALA_EXTERN GType math_preferences_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathPreferencesDialog, g_object_unref)
VALA_EXTERN GType math_preferences_dialog_word_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType math_preferences_dialog_refresh_interval_get_type (void) G_GNUC_CONST ;
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
VALA_EXTERN MathPreferencesDialog* math_preferences_dialog_construct (GType object_type,
                                                          MathEquation* eq);
static gchar* math_preferences_dialog_angle_units_name (AdwEnumListItem* item);
static gchar* math_preferences_dialog_word_size_name (AdwEnumListItem* item);
static gchar* math_preferences_dialog_refresh_interval_name (AdwEnumListItem* item);
static gchar* math_preferences_dialog_currency_display_name (AdwEnumListItem* item);
VALA_EXTERN GType currency_display_get_type (void) G_GNUC_CONST ;
static void math_preferences_dialog_row_angle_units_changed_cb (MathPreferencesDialog* self);
static MathEquation* math_preferences_dialog_get_equation (MathPreferencesDialog* self);
static void math_preferences_dialog_row_word_size_changed_cb (MathPreferencesDialog* self);
static void math_preferences_dialog_row_refresh_interval_changed_cb (MathPreferencesDialog* self);
static void math_preferences_dialog_row_currency_display_changed_cb (MathPreferencesDialog* self);
static void math_preferences_dialog_row_currency_completion_changed_cb (MathPreferencesDialog* self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void math_preferences_dialog_set_currency_completion_row (MathPreferencesDialog* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void math_preferences_dialog_row_favorite_currencies_activated_cb (MathPreferencesDialog* self);
static void math_preferences_dialog_load_currencies (MathPreferencesDialog* self);
static void _math_preferences_dialog_row_favorite_currencies_activated_cb_adw_action_row_activated (AdwActionRow* _sender,
                                                                                             gpointer self);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void math_preferences_dialog_currency_row_active_cb (MathPreferencesDialog* self);
static void _math_preferences_dialog_currency_row_active_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void math_preferences_dialog_favorites_changed_cb (MathPreferencesDialog* self);
static void _math_preferences_dialog_favorites_changed_cb_g_settings_changed (GSettings* _sender,
                                                                       const gchar* key,
                                                                       gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda40_ (Block8Data* _data8_,
                  const gchar* name,
                  AdwSwitchRow* row);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ___lambda40__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void __lambda41_ (MathPreferencesDialog* self,
                  const gchar* name,
                  AdwSwitchRow* row);
static void ___lambda41__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void math_preferences_dialog_search_changed_cb (MathPreferencesDialog* self,
                                                GtkSearchEntry* entry);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda42_ (Block9Data* _data9_,
                  const gchar* name,
                  AdwSwitchRow* row);
static void ___lambda42__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
static void _math_preferences_dialog_search_changed_cb_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                 gpointer self);
static void math_preferences_dialog_set_combo_row_from_int (MathPreferencesDialog* self,
                                                     AdwComboRow* row,
                                                     gint value);
static void math_preferences_dialog_set_equation (MathPreferencesDialog* self,
                                           MathEquation* value);
static GObject * math_preferences_dialog_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _math_preferences_dialog_row_angle_units_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void _math_preferences_dialog_row_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void _math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void _math_preferences_dialog_row_currency_display_changed_cb_g_object_notify (GObject* _sender,
                                                                               GParamSpec* pspec,
                                                                               gpointer self);
static void _math_preferences_dialog_row_currency_completion_changed_cb_g_object_notify (GObject* _sender,
                                                                                  GParamSpec* pspec,
                                                                                  gpointer self);
static void _math_preferences_dialog___lambda43_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda43__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda44_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda44__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static void _math_preferences_dialog___lambda45_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda45__g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self);
static void _math_preferences_dialog___lambda46_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda46__g_settings_changed (GSettings* _sender,
                                                               const gchar* key,
                                                               gpointer self);
static void _math_preferences_dialog_set_currency_completion_row_g_settings_changed (GSettings* _sender,
                                                                              const gchar* key,
                                                                              gpointer self);
static void math_preferences_dialog_finalize (GObject * obj);
static GType math_preferences_dialog_get_type_once (void);
static void _vala_math_preferences_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_math_preferences_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
math_preferences_dialog_get_instance_private (MathPreferencesDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MathPreferencesDialog_private_offset);
}

static GType
math_preferences_dialog_word_size_get_type_once (void)
{
	static const GEnumValue values[] = {{MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT", "8-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT", "16-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT", "32-bit"}, {MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT, "MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT", "64-bit"}, {0, NULL, NULL}};
	GType math_preferences_dialog_word_size_type_id;
	math_preferences_dialog_word_size_type_id = g_enum_register_static ("MathPreferencesDialogWordSize", values);
	return math_preferences_dialog_word_size_type_id;
}

GType
math_preferences_dialog_word_size_get_type (void)
{
	static volatile gsize math_preferences_dialog_word_size_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_word_size_type_id__once)) {
		GType math_preferences_dialog_word_size_type_id;
		math_preferences_dialog_word_size_type_id = math_preferences_dialog_word_size_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_word_size_type_id__once, math_preferences_dialog_word_size_type_id);
	}
	return math_preferences_dialog_word_size_type_id__once;
}

static GType
math_preferences_dialog_refresh_interval_get_type_once (void)
{
	static const GEnumValue values[] = {{MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER", "never"}, {MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY", "daily"}, {MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY, "MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY", "weekly"}, {0, NULL, NULL}};
	GType math_preferences_dialog_refresh_interval_type_id;
	math_preferences_dialog_refresh_interval_type_id = g_enum_register_static ("MathPreferencesDialogRefreshInterval", values);
	return math_preferences_dialog_refresh_interval_type_id;
}

GType
math_preferences_dialog_refresh_interval_get_type (void)
{
	static volatile gsize math_preferences_dialog_refresh_interval_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_refresh_interval_type_id__once)) {
		GType math_preferences_dialog_refresh_interval_type_id;
		math_preferences_dialog_refresh_interval_type_id = math_preferences_dialog_refresh_interval_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_refresh_interval_type_id__once, math_preferences_dialog_refresh_interval_type_id);
	}
	return math_preferences_dialog_refresh_interval_type_id__once;
}

MathPreferencesDialog*
math_preferences_dialog_construct (GType object_type,
                                   MathEquation* eq)
{
	MathPreferencesDialog * self = NULL;
	g_return_val_if_fail (eq != NULL, NULL);
	g_type_ensure (MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE);
	g_type_ensure (MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL);
	self = (MathPreferencesDialog*) g_object_new (object_type, "equation", eq, NULL);
	return self;
}

MathPreferencesDialog*
math_preferences_dialog_new (MathEquation* eq)
{
	return math_preferences_dialog_construct (TYPE_MATH_PREFERENCES_DIALOG, eq);
}

static gchar*
math_preferences_dialog_angle_units_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case ANGLE_UNIT_DEGREES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Degrees"));
			result = _tmp2_;
			return result;
		}
		case ANGLE_UNIT_RADIANS:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Radians"));
			result = _tmp3_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Gradians"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}

static gchar*
math_preferences_dialog_word_size_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_8_BIT:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("8-bit"));
			result = _tmp2_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_16_BIT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("16-bit"));
			result = _tmp3_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_32_BIT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("32-bit"));
			result = _tmp4_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_WORD_SIZE_64_BIT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("64-bit"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			result = _tmp6_;
			return result;
		}
	}
}

static gchar*
math_preferences_dialog_refresh_interval_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_NEVER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Never"));
			result = _tmp2_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_DAILY:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Daily"));
			result = _tmp3_;
			return result;
		}
		case MATH_PREFERENCES_DIALOG_REFRESH_INTERVAL_WEEKLY:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Weekly"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}

static gchar*
math_preferences_dialog_currency_display_name (AdwEnumListItem* item)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = adw_enum_list_item_get_value (item);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case CURRENCY_DISPLAY_CODE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Currency Code"));
			result = _tmp2_;
			return result;
		}
		case CURRENCY_DISPLAY_NAME:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Currency Name"));
			result = _tmp3_;
			return result;
		}
		case CURRENCY_DISPLAY_BOTH:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Both"));
			result = _tmp4_;
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("");
			result = _tmp5_;
			return result;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
math_preferences_dialog_row_angle_units_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathEquation* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_angle_units;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = self->priv->_equation;
	_tmp5_ = adw_enum_list_item_get_value (item);
	_tmp6_ = _tmp5_;
	math_equation_set_angle_units (_tmp4_, (AngleUnit) _tmp6_);
	_g_object_unref0 (item);
}

static void
math_preferences_dialog_row_word_size_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathEquation* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_word_size;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = self->priv->_equation;
	_tmp5_ = adw_enum_list_item_get_value (item);
	_tmp6_ = _tmp5_;
	math_equation_set_word_size (_tmp4_, (gint) ((MathPreferencesDialogWordSize) _tmp6_));
	_g_object_unref0 (item);
}

static void
math_preferences_dialog_row_refresh_interval_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	MathPreferencesDialogRefreshInterval value = 0;
	gint _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	CurrencyManager* _tmp7_;
	CurrencyManager* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_refresh_interval;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = adw_enum_list_item_get_value (item);
	_tmp5_ = _tmp4_;
	value = (MathPreferencesDialogRefreshInterval) _tmp5_;
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "refresh-interval", (gint) value);
	_tmp7_ = currency_manager_get_default (TRUE, TRUE);
	_tmp8_ = _tmp7_;
	currency_manager_set_refresh_interval (_tmp8_, (gint) value);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (item);
}

static void
math_preferences_dialog_row_currency_display_changed_cb (MathPreferencesDialog* self)
{
	AdwEnumListItem* item = NULL;
	AdwComboRow* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	AdwEnumListItem* _tmp3_;
	CurrencyDisplay value = 0;
	gint _tmp4_;
	gint _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->row_currency_display;
	_tmp1_ = adw_combo_row_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_enum_list_item_get_type (), AdwEnumListItem));
	item = _tmp3_;
	_tmp4_ = adw_enum_list_item_get_value (item);
	_tmp5_ = _tmp4_;
	value = (CurrencyDisplay) _tmp5_;
	_tmp6_ = self->priv->settings;
	g_settings_set_enum (_tmp6_, "currency-display", (gint) value);
	_g_object_unref0 (item);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
math_preferences_dialog_row_currency_completion_changed_cb (MathPreferencesDialog* self)
{
	gchar** completions = NULL;
	gchar** _tmp0_;
	gint completions_length1;
	gint _completions_size_;
	AdwComboRow* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	AdwComboRow* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GSettings* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	GSettings* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	completions = _tmp0_;
	completions_length1 = 0;
	_completions_size_ = completions_length1;
	_tmp1_ = self->priv->row_currency_completion;
	_tmp2_ = adw_combo_row_get_selected (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == ((guint) 0)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("currency");
		_vala_array_add2 (&completions, &completions_length1, &_completions_size_, _tmp4_);
	}
	_tmp5_ = self->priv->row_currency_completion;
	_tmp6_ = adw_combo_row_get_selected (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != ((guint) 2)) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("favorite");
		_vala_array_add3 (&completions, &completions_length1, &_completions_size_, _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp11_ = _tmp10_ = g_settings_get_strv (_tmp9_, "enabled-completions");
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp11_;
		name_collection_length1 = _vala_array_length (_tmp10_);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp12_;
			gchar* name = NULL;
			_tmp12_ = g_strdup (name_collection[name_it]);
			name = _tmp12_;
			{
				gboolean _tmp13_ = FALSE;
				const gchar* _tmp14_;
				_tmp14_ = name;
				if (g_strcmp0 (_tmp14_, "currency") != 0) {
					const gchar* _tmp15_;
					_tmp15_ = name;
					_tmp13_ = g_strcmp0 (_tmp15_, "favorite") != 0;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp16_ = name;
					_tmp17_ = g_strdup (_tmp16_);
					_vala_array_add4 (&completions, &completions_length1, &_completions_size_, _tmp17_);
				}
				_g_free0 (name);
			}
		}
		name_collection = (_vala_array_free (name_collection, name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp18_ = self->priv->settings;
	_tmp19_ = completions;
	_tmp19__length1 = completions_length1;
	g_settings_set_strv (_tmp18_, "enabled-completions", _tmp19_);
	completions = (_vala_array_free (completions, completions_length1, (GDestroyNotify) g_free), NULL);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
math_preferences_dialog_set_currency_completion_row (MathPreferencesDialog* self)
{
	gchar** completions = NULL;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint completions_length1;
	gint _completions_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "enabled-completions");
	completions = _tmp2_;
	completions_length1 = _vala_array_length (_tmp1_);
	_completions_size_ = completions_length1;
	_tmp3_ = completions;
	_tmp3__length1 = completions_length1;
	if (_vala_string_array_contains (_tmp3_, _tmp3__length1, "currency")) {
		AdwComboRow* _tmp4_;
		_tmp4_ = self->priv->row_currency_completion;
		adw_combo_row_set_selected (_tmp4_, (guint) 0);
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = completions;
		_tmp5__length1 = completions_length1;
		if (_vala_string_array_contains (_tmp5_, _tmp5__length1, "favorite")) {
			AdwComboRow* _tmp6_;
			_tmp6_ = self->priv->row_currency_completion;
			adw_combo_row_set_selected (_tmp6_, (guint) 1);
		} else {
			AdwComboRow* _tmp7_;
			_tmp7_ = self->priv->row_currency_completion;
			adw_combo_row_set_selected (_tmp7_, (guint) 2);
		}
	}
	completions = (_vala_array_free (completions, completions_length1, (GDestroyNotify) g_free), NULL);
}

static void
math_preferences_dialog_row_favorite_currencies_activated_cb (MathPreferencesDialog* self)
{
	GHashTable* _tmp0_;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	AdwNavigationPage* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->currency_rows;
	if (_tmp0_ == NULL) {
		math_preferences_dialog_load_currencies (self);
	}
	_tmp1_ = self->priv->search_stack;
	_tmp2_ = gtk_widget_get_first_child ((GtkWidget*) _tmp1_);
	adw_preferences_page_scroll_to_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, adw_preferences_page_get_type (), AdwPreferencesPage));
	_tmp3_ = self->priv->page_favorite_currencies;
	adw_preferences_dialog_push_subpage ((AdwPreferencesDialog*) self, _tmp3_);
	_tmp4_ = self->priv->search_entry;
	gtk_editable_set_text ((GtkEditable*) _tmp4_, "");
	_tmp5_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
}

static void
_math_preferences_dialog_row_favorite_currencies_activated_cb_adw_action_row_activated (AdwActionRow* _sender,
                                                                                        gpointer self)
{
	math_preferences_dialog_row_favorite_currencies_activated_cb ((MathPreferencesDialog*) self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_math_preferences_dialog_currency_row_active_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	math_preferences_dialog_currency_row_active_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_favorites_changed_cb_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self)
{
	math_preferences_dialog_favorites_changed_cb ((MathPreferencesDialog*) self);
}

static void
math_preferences_dialog_load_currencies (MathPreferencesDialog* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	UnitCategory* category = NULL;
	UnitManager* _tmp3_;
	UnitManager* _tmp4_;
	UnitCategory* _tmp5_;
	UnitCategory* _tmp6_;
	UnitCategory* _tmp7_;
	GList* _tmp8_;
	GSettings* _tmp33_;
	gulong _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->currency_rows);
	self->priv->currency_rows = _tmp2_;
	_tmp3_ = unit_manager_get_default ();
	_tmp4_ = _tmp3_;
	_tmp5_ = unit_manager_get_category (_tmp4_, "currency");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	category = _tmp6_;
	_tmp7_ = category;
	_tmp8_ = unit_category_get_units (_tmp7_);
	{
		GList* unit_collection = NULL;
		GList* unit_it = NULL;
		unit_collection = _tmp8_;
		for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
			Unit* _tmp9_;
			Unit* unit = NULL;
			_tmp9_ = _g_object_ref0 ((Unit*) unit_it->data);
			unit = _tmp9_;
			{
				AdwSwitchRow* row = NULL;
				AdwSwitchRow* _tmp10_;
				AdwSwitchRow* _tmp11_;
				AdwSwitchRow* _tmp12_;
				Unit* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				AdwSwitchRow* _tmp17_;
				Unit* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gulong handler = 0UL;
				AdwSwitchRow* _tmp22_;
				gulong _tmp23_;
				AdwSwitchRow* _tmp24_;
				AdwPreferencesGroup* _tmp25_;
				AdwSwitchRow* _tmp26_;
				GHashTable* _tmp27_;
				Unit* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				AdwSwitchRow* _tmp31_;
				AdwSwitchRow* _tmp32_;
				_tmp10_ = (AdwSwitchRow*) adw_switch_row_new ();
				g_object_ref_sink (_tmp10_);
				row = _tmp10_;
				_tmp11_ = row;
				adw_preferences_row_set_use_markup ((AdwPreferencesRow*) _tmp11_, FALSE);
				_tmp12_ = row;
				_tmp13_ = unit;
				_tmp14_ = unit_get_display_name (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_;
				adw_preferences_row_set_title ((AdwPreferencesRow*) _tmp12_, _tmp16_);
				_g_free0 (_tmp16_);
				_tmp17_ = row;
				_tmp18_ = unit;
				_tmp19_ = unit_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				adw_action_row_set_subtitle ((AdwActionRow*) _tmp17_, _tmp21_);
				_g_free0 (_tmp21_);
				_tmp22_ = row;
				_tmp23_ = g_signal_connect_object ((GObject*) _tmp22_, "notify::active", (GCallback) _math_preferences_dialog_currency_row_active_cb_g_object_notify, self, 0);
				handler = _tmp23_;
				_tmp24_ = row;
				g_object_set_data_full ((GObject*) _tmp24_, "handler", (gpointer) ((guintptr) handler), NULL);
				_tmp25_ = self->priv->group_favorite_currencies;
				_tmp26_ = row;
				adw_preferences_group_add (_tmp25_, (GtkWidget*) _tmp26_);
				_tmp27_ = self->priv->currency_rows;
				_tmp28_ = unit;
				_tmp29_ = unit_get_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = row;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				g_hash_table_insert (_tmp27_, _tmp30_, _tmp32_);
				_g_object_unref0 (row);
				_g_object_unref0 (unit);
			}
		}
	}
	_tmp33_ = self->priv->settings;
	_tmp34_ = g_signal_connect_object (_tmp33_, "changed::favorite-currencies", (GCallback) _math_preferences_dialog_favorites_changed_cb_g_settings_changed, self, 0);
	self->priv->favorites_changed = _tmp34_;
	math_preferences_dialog_favorites_changed_cb (self);
	_g_object_unref0 (category);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		MathPreferencesDialog* self;
		self = _data8_->self;
		_data8_->favorites = (_vala_array_free (_data8_->favorites, _data8_->favorites_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda40_ (Block8Data* _data8_,
             const gchar* name,
             AdwSwitchRow* row)
{
	MathPreferencesDialog* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data8_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = adw_switch_row_get_active (row);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (name);
		_vala_array_add5 (&_data8_->favorites, &_data8_->favorites_length1, &_data8_->_favorites_size_, _tmp2_);
	}
}

static void
___lambda40__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda40_ (self, (const gchar*) key, (AdwSwitchRow*) value);
}

static void
math_preferences_dialog_currency_row_active_cb (MathPreferencesDialog* self)
{
	Block8Data* _data8_;
	gchar** _tmp0_;
	GHashTable* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	_data8_->favorites = _tmp0_;
	_data8_->favorites_length1 = 0;
	_data8_->_favorites_size_ = _data8_->favorites_length1;
	_tmp1_ = self->priv->currency_rows;
	g_hash_table_foreach (_tmp1_, ___lambda40__gh_func, _data8_);
	_tmp2_ = self->priv->settings;
	g_signal_handler_block (_tmp2_, self->priv->favorites_changed);
	_tmp3_ = self->priv->settings;
	g_settings_set_strv (_tmp3_, "favorite-currencies", _data8_->favorites);
	_tmp4_ = self->priv->settings;
	g_signal_handler_unblock (_tmp4_, self->priv->favorites_changed);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
__lambda41_ (MathPreferencesDialog* self,
             const gchar* name,
             AdwSwitchRow* row)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = adw_switch_row_get_active (row);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gconstpointer _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = g_object_get_data ((GObject*) row, "handler");
		g_signal_handler_block (row, (gulong) ((guintptr) _tmp2_));
		adw_switch_row_set_active (row, FALSE);
		_tmp3_ = g_object_get_data ((GObject*) row, "handler");
		g_signal_handler_unblock (row, (gulong) ((guintptr) _tmp3_));
	}
}

static void
___lambda41__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda41_ ((MathPreferencesDialog*) self, (const gchar*) key, (AdwSwitchRow*) value);
}

static void
math_preferences_dialog_favorites_changed_cb (MathPreferencesDialog* self)
{
	GHashTable* _tmp0_;
	gchar** favorites = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint favorites_length1;
	gint _favorites_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->currency_rows;
	g_hash_table_foreach (_tmp0_, ___lambda41__gh_func, self);
	_tmp1_ = self->priv->settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "favorite-currencies");
	favorites = _tmp3_;
	favorites_length1 = _vala_array_length (_tmp2_);
	_favorites_size_ = favorites_length1;
	_tmp4_ = favorites;
	_tmp4__length1 = favorites_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp4_;
		name_collection_length1 = _tmp4__length1;
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp5_;
			gchar* name = NULL;
			_tmp5_ = g_strdup (name_collection[name_it]);
			name = _tmp5_;
			{
				AdwSwitchRow* row = NULL;
				GHashTable* _tmp6_;
				const gchar* _tmp7_;
				gconstpointer _tmp8_;
				AdwSwitchRow* _tmp9_;
				AdwSwitchRow* _tmp10_;
				AdwSwitchRow* _tmp11_;
				gconstpointer _tmp12_;
				AdwSwitchRow* _tmp13_;
				AdwSwitchRow* _tmp14_;
				AdwSwitchRow* _tmp15_;
				gconstpointer _tmp16_;
				_tmp6_ = self->priv->currency_rows;
				_tmp7_ = name;
				_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
				_tmp9_ = _g_object_ref0 ((AdwSwitchRow*) _tmp8_);
				row = _tmp9_;
				_tmp10_ = row;
				_tmp11_ = row;
				_tmp12_ = g_object_get_data ((GObject*) _tmp11_, "handler");
				g_signal_handler_block (_tmp10_, (gulong) ((guintptr) _tmp12_));
				_tmp13_ = row;
				adw_switch_row_set_active (_tmp13_, TRUE);
				_tmp14_ = row;
				_tmp15_ = row;
				_tmp16_ = g_object_get_data ((GObject*) _tmp15_, "handler");
				g_signal_handler_unblock (_tmp14_, (gulong) ((guintptr) _tmp16_));
				_g_object_unref0 (row);
				_g_free0 (name);
			}
		}
	}
	favorites = (_vala_array_free (favorites, favorites_length1, (GDestroyNotify) g_free), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		MathPreferencesDialog* self;
		self = _data9_->self;
		_g_free0 (_data9_->search);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
__lambda42_ (Block9Data* _data9_,
             const gchar* name,
             AdwSwitchRow* row)
{
	MathPreferencesDialog* self;
	gchar* currency_code = NULL;
	gchar* _tmp0_;
	gchar* currency_name = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	self = _data9_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = g_utf8_casefold (name, (gssize) -1);
	currency_code = _tmp0_;
	_tmp1_ = adw_preferences_row_get_title ((AdwPreferencesRow*) row);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_normalize (_tmp2_, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_casefold (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	currency_name = _tmp6_;
	_tmp8_ = currency_code;
	_tmp9_ = _data9_->search;
	if (string_contains (_tmp8_, _tmp9_)) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = currency_name;
		_tmp11_ = _data9_->search;
		_tmp7_ = string_contains (_tmp10_, _tmp11_);
	}
	if (_tmp7_) {
		_data9_->found = TRUE;
		gtk_widget_set_visible ((GtkWidget*) row, _data9_->found);
	} else {
		gtk_widget_set_visible ((GtkWidget*) row, FALSE);
	}
	_g_free0 (currency_name);
	_g_free0 (currency_code);
}

static void
___lambda42__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda42_ (self, (const gchar*) key, (AdwSwitchRow*) value);
}

static void
math_preferences_dialog_search_changed_cb (MathPreferencesDialog* self,
                                           GtkSearchEntry* entry)
{
	Block9Data* _data9_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gint _tmp7_ = 0;
	GtkStack* _tmp8_;
	GtkSelectionModel* _tmp9_;
	GtkSelectionModel* _tmp10_;
	GtkSelectionModel* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_normalize (_tmp1_, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_utf8_casefold (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_data9_->search = _tmp5_;
	_data9_->found = FALSE;
	_tmp6_ = self->priv->currency_rows;
	g_hash_table_foreach (_tmp6_, ___lambda42__gh_func, _data9_);
	if (_data9_->found) {
		_tmp7_ = 0;
	} else {
		_tmp7_ = 1;
	}
	_tmp8_ = self->priv->search_stack;
	_tmp9_ = gtk_stack_get_pages (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	gtk_selection_model_select_item (_tmp11_, (guint) _tmp7_, TRUE);
	_g_object_unref0 (_tmp11_);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
_math_preferences_dialog_search_changed_cb_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                            gpointer self)
{
	math_preferences_dialog_search_changed_cb ((MathPreferencesDialog*) self, _sender);
}

static void
math_preferences_dialog_set_combo_row_from_int (MathPreferencesDialog* self,
                                                AdwComboRow* row,
                                                gint value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListModel* _tmp2_;
				GListModel* _tmp3_;
				GListModel* _tmp4_;
				GListModel* _tmp5_;
				GObject* _tmp6_;
				AdwEnumListItem* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = adw_combo_row_get_model (row);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < g_list_model_get_n_items (_tmp3_))) {
					break;
				}
				_tmp4_ = adw_combo_row_get_model (row);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_list_model_get_item (_tmp5_, (guint) i);
				_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_enum_list_item_get_type (), AdwEnumListItem);
				_tmp8_ = adw_enum_list_item_get_value (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = ((gint) _tmp9_) == value;
				_g_object_unref0 (_tmp7_);
				if (_tmp10_) {
					adw_combo_row_set_selected (row, (guint) i);
					break;
				}
			}
		}
	}
}

static MathEquation*
math_preferences_dialog_get_equation (MathPreferencesDialog* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

static void
math_preferences_dialog_set_equation (MathPreferencesDialog* self,
                                      MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_preferences_dialog_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY]);
	}
}

static void
_math_preferences_dialog_row_angle_units_changed_cb_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	math_preferences_dialog_row_angle_units_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_word_size_changed_cb_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	math_preferences_dialog_row_word_size_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	math_preferences_dialog_row_refresh_interval_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_currency_display_changed_cb_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self)
{
	math_preferences_dialog_row_currency_display_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_row_currency_completion_changed_cb_g_object_notify (GObject* _sender,
                                                                             GParamSpec* pspec,
                                                                             gpointer self)
{
	math_preferences_dialog_row_currency_completion_changed_cb ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda43_ (MathPreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	MathEquation* _tmp1_;
	AngleUnit _tmp2_;
	AngleUnit _tmp3_;
	_tmp0_ = self->priv->row_angle_units;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_angle_units (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, (gint) _tmp3_);
}

static void
__math_preferences_dialog___lambda43__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda43_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda44_ (MathPreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = self->priv->row_word_size;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_word_size (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, _tmp3_);
}

static void
__math_preferences_dialog___lambda44__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_math_preferences_dialog___lambda44_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda45_ (MathPreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->row_refresh_interval;
	_tmp1_ = self->priv->settings;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, g_settings_get_int (_tmp1_, "refresh-interval"));
}

static void
__math_preferences_dialog___lambda45__g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self)
{
	_math_preferences_dialog___lambda45_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog___lambda46_ (MathPreferencesDialog* self)
{
	AdwComboRow* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = self->priv->row_currency_display;
	_tmp1_ = self->priv->settings;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp0_, g_settings_get_enum (_tmp1_, "currency-display"));
}

static void
__math_preferences_dialog___lambda46__g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self)
{
	_math_preferences_dialog___lambda46_ ((MathPreferencesDialog*) self);
}

static void
_math_preferences_dialog_set_currency_completion_row_g_settings_changed (GSettings* _sender,
                                                                         const gchar* key,
                                                                         gpointer self)
{
	math_preferences_dialog_set_currency_completion_row ((MathPreferencesDialog*) self);
}

static GObject *
math_preferences_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathPreferencesDialog * self;
	GSettings* _tmp0_;
	AdwEnumListModel* model = NULL;
	AdwEnumListModel* _tmp1_;
	GtkCClosureExpression* expression = NULL;
	GtkExpression** _tmp2_;
	GtkCClosureExpression* _tmp3_;
	AdwComboRow* _tmp4_;
	GtkCClosureExpression* _tmp5_;
	AdwComboRow* _tmp6_;
	AdwEnumListModel* _tmp7_;
	AdwEnumListModel* _tmp8_;
	GtkExpression** _tmp9_;
	GtkCClosureExpression* _tmp10_;
	AdwComboRow* _tmp11_;
	GtkCClosureExpression* _tmp12_;
	AdwComboRow* _tmp13_;
	AdwEnumListModel* _tmp14_;
	AdwEnumListModel* _tmp15_;
	GtkExpression** _tmp16_;
	GtkCClosureExpression* _tmp17_;
	AdwComboRow* _tmp18_;
	GtkCClosureExpression* _tmp19_;
	AdwComboRow* _tmp20_;
	AdwEnumListModel* _tmp21_;
	AdwEnumListModel* _tmp22_;
	GtkExpression** _tmp23_;
	GtkCClosureExpression* _tmp24_;
	AdwComboRow* _tmp25_;
	GtkCClosureExpression* _tmp26_;
	AdwComboRow* _tmp27_;
	AdwEnumListModel* _tmp28_;
	GSettings* _tmp29_;
	AdwSpinRow* _tmp30_;
	GSettings* _tmp31_;
	AdwSwitchRow* _tmp32_;
	GSettings* _tmp33_;
	AdwSwitchRow* _tmp34_;
	AdwComboRow* _tmp35_;
	AdwComboRow* _tmp36_;
	AdwComboRow* _tmp37_;
	AdwComboRow* _tmp38_;
	AdwComboRow* _tmp39_;
	AdwComboRow* _tmp40_;
	MathEquation* _tmp41_;
	AngleUnit _tmp42_;
	AngleUnit _tmp43_;
	MathEquation* _tmp44_;
	AdwComboRow* _tmp45_;
	MathEquation* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	MathEquation* _tmp49_;
	AdwComboRow* _tmp50_;
	GSettings* _tmp51_;
	GSettings* _tmp52_;
	AdwComboRow* _tmp53_;
	GSettings* _tmp54_;
	GSettings* _tmp55_;
	GSettings* _tmp56_;
	parent_class = G_OBJECT_CLASS (math_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_tmp0_ = g_settings_new ("org.gnome.calculator");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = adw_enum_list_model_new (TYPE_ANGLE_UNIT);
	model = _tmp1_;
	_tmp2_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp3_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp2_, (GCallback) math_preferences_dialog_angle_units_name, NULL, NULL);
	expression = _tmp3_;
	_tmp4_ = self->priv->row_angle_units;
	_tmp5_ = expression;
	adw_combo_row_set_expression (_tmp4_, (GtkExpression*) _tmp5_);
	_tmp6_ = self->priv->row_angle_units;
	_tmp7_ = model;
	adw_combo_row_set_model (_tmp6_, (GListModel*) _tmp7_);
	_tmp8_ = adw_enum_list_model_new (MATH_PREFERENCES_DIALOG_TYPE_WORD_SIZE);
	_g_object_unref0 (model);
	model = _tmp8_;
	_tmp9_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp10_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp9_, (GCallback) math_preferences_dialog_word_size_name, NULL, NULL);
	_gtk_expression_unref0 (expression);
	expression = _tmp10_;
	_tmp11_ = self->priv->row_word_size;
	_tmp12_ = expression;
	adw_combo_row_set_expression (_tmp11_, (GtkExpression*) _tmp12_);
	_tmp13_ = self->priv->row_word_size;
	_tmp14_ = model;
	adw_combo_row_set_model (_tmp13_, (GListModel*) _tmp14_);
	_tmp15_ = adw_enum_list_model_new (MATH_PREFERENCES_DIALOG_TYPE_REFRESH_INTERVAL);
	_g_object_unref0 (model);
	model = _tmp15_;
	_tmp16_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp17_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp16_, (GCallback) math_preferences_dialog_refresh_interval_name, NULL, NULL);
	_gtk_expression_unref0 (expression);
	expression = _tmp17_;
	_tmp18_ = self->priv->row_refresh_interval;
	_tmp19_ = expression;
	adw_combo_row_set_expression (_tmp18_, (GtkExpression*) _tmp19_);
	_tmp20_ = self->priv->row_refresh_interval;
	_tmp21_ = model;
	adw_combo_row_set_model (_tmp20_, (GListModel*) _tmp21_);
	_tmp22_ = adw_enum_list_model_new (TYPE_CURRENCY_DISPLAY);
	_g_object_unref0 (model);
	model = _tmp22_;
	_tmp23_ = g_new0 (GtkExpression*, 0 + 1);
	_tmp24_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp23_, (GCallback) math_preferences_dialog_currency_display_name, NULL, NULL);
	_gtk_expression_unref0 (expression);
	expression = _tmp24_;
	_tmp25_ = self->priv->row_currency_display;
	_tmp26_ = expression;
	adw_combo_row_set_expression (_tmp25_, (GtkExpression*) _tmp26_);
	_tmp27_ = self->priv->row_currency_display;
	_tmp28_ = model;
	adw_combo_row_set_model (_tmp27_, (GListModel*) _tmp28_);
	_tmp29_ = self->priv->settings;
	_tmp30_ = self->priv->row_decimals;
	g_settings_bind (_tmp29_, "accuracy", (GObject*) _tmp30_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp31_ = self->priv->settings;
	_tmp32_ = self->priv->row_trailing_zeroes;
	g_settings_bind (_tmp31_, "show-zeroes", (GObject*) _tmp32_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp33_ = self->priv->settings;
	_tmp34_ = self->priv->row_thousands_separators;
	g_settings_bind (_tmp33_, "show-thousands", (GObject*) _tmp34_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp35_ = self->priv->row_angle_units;
	g_signal_connect_object ((GObject*) _tmp35_, "notify::selected", (GCallback) _math_preferences_dialog_row_angle_units_changed_cb_g_object_notify, self, 0);
	_tmp36_ = self->priv->row_word_size;
	g_signal_connect_object ((GObject*) _tmp36_, "notify::selected", (GCallback) _math_preferences_dialog_row_word_size_changed_cb_g_object_notify, self, 0);
	_tmp37_ = self->priv->row_refresh_interval;
	g_signal_connect_object ((GObject*) _tmp37_, "notify::selected", (GCallback) _math_preferences_dialog_row_refresh_interval_changed_cb_g_object_notify, self, 0);
	_tmp38_ = self->priv->row_currency_display;
	g_signal_connect_object ((GObject*) _tmp38_, "notify::selected", (GCallback) _math_preferences_dialog_row_currency_display_changed_cb_g_object_notify, self, 0);
	_tmp39_ = self->priv->row_currency_completion;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::selected", (GCallback) _math_preferences_dialog_row_currency_completion_changed_cb_g_object_notify, self, 0);
	_tmp40_ = self->priv->row_angle_units;
	_tmp41_ = self->priv->_equation;
	_tmp42_ = math_equation_get_angle_units (_tmp41_);
	_tmp43_ = _tmp42_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp40_, (gint) _tmp43_);
	_tmp44_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp44_, "notify::angle-units", (GCallback) __math_preferences_dialog___lambda43__g_object_notify, self, 0);
	_tmp45_ = self->priv->row_word_size;
	_tmp46_ = self->priv->_equation;
	_tmp47_ = math_equation_get_word_size (_tmp46_);
	_tmp48_ = _tmp47_;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp45_, _tmp48_);
	_tmp49_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp49_, "notify::word-size", (GCallback) __math_preferences_dialog___lambda44__g_object_notify, self, 0);
	_tmp50_ = self->priv->row_refresh_interval;
	_tmp51_ = self->priv->settings;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp50_, g_settings_get_int (_tmp51_, "refresh-interval"));
	_tmp52_ = self->priv->settings;
	g_signal_connect_object (_tmp52_, "changed::refresh-interval", (GCallback) __math_preferences_dialog___lambda45__g_settings_changed, self, 0);
	_tmp53_ = self->priv->row_currency_display;
	_tmp54_ = self->priv->settings;
	math_preferences_dialog_set_combo_row_from_int (self, _tmp53_, g_settings_get_enum (_tmp54_, "currency-display"));
	_tmp55_ = self->priv->settings;
	g_signal_connect_object (_tmp55_, "changed::currency-display", (GCallback) __math_preferences_dialog___lambda46__g_settings_changed, self, 0);
	math_preferences_dialog_set_currency_completion_row (self);
	_tmp56_ = self->priv->settings;
	g_signal_connect_object (_tmp56_, "changed::enabled-completions", (GCallback) _math_preferences_dialog_set_currency_completion_row_g_settings_changed, self, 0);
	if (DEVELOPMENT_BUILD) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (model);
	return obj;
}

static void
math_preferences_dialog_class_init (MathPreferencesDialogClass * klass,
                                    gpointer klass_data)
{
	math_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathPreferencesDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_preferences_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_preferences_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_preferences_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY, math_preferences_dialog_properties[MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-preferences.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_angle_units", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_angle_units));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_word_size", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_word_size));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_refresh_interval", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_refresh_interval));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_currency_display", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_currency_display));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_currency_completion", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_currency_completion));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_decimals", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_decimals));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_trailing_zeroes", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_trailing_zeroes));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_thousands_separators", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, row_thousands_separators));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page_favorite_currencies", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, page_favorite_currencies));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "group_favorite_currencies", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, group_favorite_currencies));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_stack", FALSE, MathPreferencesDialog_private_offset + G_STRUCT_OFFSET (MathPreferencesDialogPrivate, search_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "row_favorite_currencies_activated_cb", G_CALLBACK(_math_preferences_dialog_row_favorite_currencies_activated_cb_adw_action_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "search_changed_cb", G_CALLBACK(_math_preferences_dialog_search_changed_cb_gtk_search_entry_search_changed));
}

static void
math_preferences_dialog_instance_init (MathPreferencesDialog * self,
                                       gpointer klass)
{
	self->priv = math_preferences_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_preferences_dialog_finalize (GObject * obj)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_g_object_unref0 (self->priv->_equation);
	_g_hash_table_unref0 (self->priv->currency_rows);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (math_preferences_dialog_parent_class)->finalize (obj);
}

static GType
math_preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathPreferencesDialog), 0, (GInstanceInitFunc) math_preferences_dialog_instance_init, NULL };
	GType math_preferences_dialog_type_id;
	math_preferences_dialog_type_id = g_type_register_static (adw_preferences_dialog_get_type (), "MathPreferencesDialog", &g_define_type_info, 0);
	MathPreferencesDialog_private_offset = g_type_add_instance_private (math_preferences_dialog_type_id, sizeof (MathPreferencesDialogPrivate));
	return math_preferences_dialog_type_id;
}

GType
math_preferences_dialog_get_type (void)
{
	static volatile gsize math_preferences_dialog_type_id__once = 0;
	if (g_once_init_enter (&math_preferences_dialog_type_id__once)) {
		GType math_preferences_dialog_type_id;
		math_preferences_dialog_type_id = math_preferences_dialog_get_type_once ();
		g_once_init_leave (&math_preferences_dialog_type_id__once, math_preferences_dialog_type_id);
	}
	return math_preferences_dialog_type_id__once;
}

static void
_vala_math_preferences_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY:
		g_value_set_object (value, math_preferences_dialog_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_preferences_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION_PROPERTY:
		math_preferences_dialog_set_equation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

