/* contacts-store.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-store.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contacts.h"
#include <folks/folks.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <folks/folks-eds.h>
#include <libedataserver/libedataserver.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_STORE_0_PROPERTY,
	CONTACTS_STORE_AGGREGATOR_PROPERTY,
	CONTACTS_STORE_BACKEND_STORE_PROPERTY,
	CONTACTS_STORE_SORTER_PROPERTY,
	CONTACTS_STORE_QUERY_FILTER_PROPERTY,
	CONTACTS_STORE_MANUAL_FILTER_PROPERTY,
	CONTACTS_STORE_INDIVIDUALS_PROPERTY,
	CONTACTS_STORE_ADDRESS_BOOKS_PROPERTY,
	CONTACTS_STORE_NUM_PROPERTIES
};
static GParamSpec* contacts_store_properties[CONTACTS_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _ContactsStoreFindIndividualForQueryData ContactsStoreFindIndividualForQueryData;
typedef struct _Block3Data Block3Data;
typedef struct _ContactsStoreFindIndividualForIdData ContactsStoreFindIndividualForIdData;
enum  {
	CONTACTS_STORE_QUIESCENT_SIGNAL,
	CONTACTS_STORE_PREPARED_SIGNAL,
	CONTACTS_STORE_NUM_SIGNALS
};
static guint contacts_store_signals[CONTACTS_STORE_NUM_SIGNALS] = {0};

struct _ContactsStorePrivate {
	FolksIndividualAggregator* _aggregator;
	GListStore* base_model;
	GtkSortListModel* sort_model;
	ContactsIndividualSorter* _sorter;
	GtkFilterListModel* filter_model;
	ContactsQueryFilter* _query_filter;
	ContactsManualFilter* _manual_filter;
	GListStore* _address_books;
};

struct _Block2Data {
	int _ref_count_;
	ContactsStore* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsStoreFindIndividualForQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	FolksQuery* query;
	guint result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Block2Data* _data2_;
	gulong signal_id;
	gulong _tmp3_;
	guint matched_pos;
	guint strength;
	guint i;
	gboolean _tmp4_;
	guint _tmp5_;
	GListModel* _tmp6_;
	GListModel* _tmp7_;
	FolksIndividual* individual;
	GListModel* _tmp8_;
	GListModel* _tmp9_;
	GObject* _tmp10_;
	guint this_strength;
	FolksIndividual* _tmp11_;
};

struct _Block3Data {
	int _ref_count_;
	ContactsStore* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsStoreFindIndividualForIdData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsStore* self;
	gchar* id;
	guint result;
	FolksIndividualAggregator* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	Block3Data* _data3_;
	gulong signal_id;
	gulong _tmp3_;
	guint i;
	gboolean _tmp4_;
	guint _tmp5_;
	GListModel* _tmp6_;
	GListModel* _tmp7_;
	FolksIndividual* individual;
	GListModel* _tmp8_;
	GListModel* _tmp9_;
	GObject* _tmp10_;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
};

static gint ContactsStore_private_offset;
static gpointer contacts_store_parent_class = NULL;

static void contacts_store_read_dont_suggest_db (ContactsStore* self);
static void contacts_store_write_dont_suggest_db (ContactsStore* self);
static void contacts_store_set_sorter (ContactsStore* self,
                                ContactsIndividualSorter* value);
static void contacts_store_set_query_filter (ContactsStore* self,
                                      ContactsQueryFilter* value);
static void contacts_store_set_manual_filter (ContactsStore* self,
                                       ContactsManualFilter* value);
static void contacts_store_on_individuals_changed_detailed (ContactsStore* self,
                                                     GeeMultiMap* changes);
static void ______lambda6_ (ContactsStore* self,
                     GObject* obj,
                     GParamSpec* pspec);
static void _______lambda6__g_object_notify (GObject* _sender,
                                      GParamSpec* pspec,
                                      gpointer self);
static void contacts_store_find_individual_for_query_data_free (gpointer _data);
static gboolean contacts_store_find_individual_for_query_co (ContactsStoreFindIndividualForQueryData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _contacts_store_find_individual_for_query_co_gsource_func (gpointer self);
static void ___lambda7_ (Block2Data* _data2_);
static void ____lambda7__contacts_store_quiescent (ContactsStore* _sender,
                                            gpointer self);
static void contacts_store_find_individual_for_id_data_free (gpointer _data);
static gboolean contacts_store_find_individual_for_id_co (ContactsStoreFindIndividualForIdData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean _contacts_store_find_individual_for_id_co_gsource_func (gpointer self);
static void ___lambda8_ (Block3Data* _data3_);
static void ____lambda8__contacts_store_quiescent (ContactsStore* _sender,
                                            gpointer self);
static gboolean contacts_store_non_linkable (ContactsStore* self,
                                      FolksIndividual* individual);
static gboolean contacts_store_has_mainable_persona (ContactsStore* self,
                                              FolksIndividual* individual);
static void contacts_store_set_aggregator (ContactsStore* self,
                                    FolksIndividualAggregator* value);
static GObject * contacts_store_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _contacts_store___lambda9_ (ContactsStore* self,
                                 FolksBackend* backend);
static void __contacts_store___lambda9__folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                                        FolksBackend* backend,
                                                                        gpointer self);
static void _contacts_store___lambda10_ (ContactsStore* self,
                                  GObject* obj,
                                  GParamSpec* pspec);
static gboolean __lambda11_ (ContactsStore* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void __contacts_store___lambda10__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void _contacts_store___lambda12_ (ContactsStore* self,
                                  GObject* obj,
                                  GParamSpec* pspec);
static gboolean __lambda13_ (ContactsStore* self);
static gboolean ___lambda13__gsource_func (gpointer self);
static void __contacts_store___lambda12__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void _contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                               GeeMultiMap* changes,
                                                                                                               gpointer self);
static void contacts_store_finalize (GObject * obj);
static GType contacts_store_get_type_once (void);
static void _vala_contacts_store_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_contacts_store_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
contacts_store_get_instance_private (ContactsStore* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsStore_private_offset);
}

static void
contacts_store_read_dont_suggest_db (ContactsStore* self)
{
	GeeHashMultiMap* _tmp0_;
	gchar* path = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->dont_suggest_link;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	_tmp1_ = g_get_user_config_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-contacts", "dont_suggest.db", NULL);
	path = _tmp2_;
	{
		gchar* contents = NULL;
		gchar* _tmp3_ = NULL;
		gchar** rows = NULL;
		gchar** _tmp4_;
		gchar** _tmp5_;
		gint rows_length1;
		gint _rows_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		g_file_get_contents (path, &_tmp3_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (contents);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp4_ = g_strsplit (contents, "\n", 0);
		rows = _tmp5_;
		rows_length1 = _vala_array_length (_tmp4_);
		_rows_size_ = rows_length1;
		_tmp6_ = rows;
		_tmp6__length1 = rows_length1;
		{
			gchar** r_collection = NULL;
			gint r_collection_length1 = 0;
			gint _r_collection_size_ = 0;
			gint r_it = 0;
			r_collection = _tmp6_;
			r_collection_length1 = _tmp6__length1;
			for (r_it = 0; r_it < r_collection_length1; r_it = r_it + 1) {
				const gchar* r = NULL;
				r = r_collection[r_it];
				{
					gchar** ids = NULL;
					const gchar* _tmp7_;
					gchar** _tmp8_;
					gchar** _tmp9_;
					gint ids_length1;
					gint _ids_size_;
					gchar** _tmp10_;
					gint _tmp10__length1;
					_tmp7_ = r;
					_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
					ids = _tmp9_;
					ids_length1 = _vala_array_length (_tmp8_);
					_ids_size_ = ids_length1;
					_tmp10_ = ids;
					_tmp10__length1 = ids_length1;
					if (_tmp10__length1 == 2) {
						GeeHashMultiMap* _tmp11_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
						const gchar* _tmp15_;
						_tmp11_ = self->dont_suggest_link;
						_tmp12_ = ids;
						_tmp12__length1 = ids_length1;
						_tmp13_ = _tmp12_[0];
						_tmp14_ = ids;
						_tmp14__length1 = ids_length1;
						_tmp15_ = _tmp14_[1];
						gee_multi_map_set ((GeeMultiMap*) _tmp11_, _tmp13_, _tmp15_);
					}
					ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		rows = (_vala_array_free (rows, rows_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (contents);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		if (g_error_matches (_tmp16_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			_g_error_free0 (e);
			_g_free0 (path);
			return;
		}
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("contacts-store.vala:75: error loading no suggestion db: %s\n", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
}

static void
contacts_store_write_dont_suggest_db (ContactsStore* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* dir = NULL;
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* path = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GString* s = NULL;
		GString* _tmp5_;
		const gchar* _tmp26_;
		GString* _tmp27_;
		const gchar* _tmp28_;
		GString* _tmp29_;
		_tmp0_ = g_get_user_config_dir ();
		_tmp1_ = g_build_filename (_tmp0_, "gnome-contacts", NULL);
		dir = _tmp1_;
		_tmp2_ = dir;
		g_mkdir_with_parents (_tmp2_, 0700);
		_tmp3_ = dir;
		_tmp4_ = g_build_filename (_tmp3_, "dont_suggest.db", NULL);
		path = _tmp4_;
		_tmp5_ = g_string_new ("");
		s = _tmp5_;
		{
			GeeIterator* _key_it = NULL;
			GeeHashMultiMap* _tmp6_;
			GeeSet* _tmp7_;
			GeeSet* _tmp8_;
			GeeIterator* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp6_ = self->dont_suggest_link;
			_tmp7_ = gee_multi_map_get_keys ((GeeMultiMap*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
			_tmp10_ = _tmp9_;
			_g_object_unref0 (_tmp8_);
			_key_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				gchar* key = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				_tmp11_ = _key_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _key_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				key = (gchar*) _tmp13_;
				{
					GeeIterator* _value_it = NULL;
					GeeHashMultiMap* _tmp14_;
					const gchar* _tmp15_;
					GeeCollection* _tmp16_;
					GeeCollection* _tmp17_;
					GeeIterator* _tmp18_;
					GeeIterator* _tmp19_;
					_tmp14_ = self->dont_suggest_link;
					_tmp15_ = key;
					_tmp16_ = gee_multi_map_get ((GeeMultiMap*) _tmp14_, _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
					_tmp19_ = _tmp18_;
					_g_object_unref0 (_tmp17_);
					_value_it = _tmp19_;
					while (TRUE) {
						GeeIterator* _tmp20_;
						gchar* value = NULL;
						GeeIterator* _tmp21_;
						gpointer _tmp22_;
						GString* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						_tmp20_ = _value_it;
						if (!gee_iterator_next (_tmp20_)) {
							break;
						}
						_tmp21_ = _value_it;
						_tmp22_ = gee_iterator_get (_tmp21_);
						value = (gchar*) _tmp22_;
						_tmp23_ = s;
						_tmp24_ = key;
						_tmp25_ = value;
						g_string_append_printf (_tmp23_, "%s %s\n", _tmp24_, _tmp25_);
						_g_free0 (value);
					}
					_g_object_unref0 (_value_it);
				}
				_g_free0 (key);
			}
			_g_object_unref0 (_key_it);
		}
		_tmp26_ = path;
		_tmp27_ = s;
		_tmp28_ = _tmp27_->str;
		_tmp29_ = s;
		g_file_set_contents (_tmp26_, _tmp28_, _tmp29_->len, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_string_free0 (s);
			_g_free0 (path);
			_g_free0 (dir);
			goto __catch0_g_error;
		}
		_g_string_free0 (s);
		_g_free0 (path);
		_g_free0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("contacts-store.vala:92: error writing no suggestion db: %s\n", _tmp31_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
contacts_store_may_suggest_link (ContactsStore* self,
                                 FolksIndividual* a,
                                 FolksIndividual* b)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	{
		GeeIterator* _a_persona_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (a);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_a_persona_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* a_persona = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = _a_persona_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _a_persona_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			a_persona = (FolksPersona*) _tmp5_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp6_;
				FolksPersona* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				GeeCollection* _tmp10_;
				GeeCollection* _tmp11_;
				GeeIterator* _tmp12_;
				GeeIterator* _tmp13_;
				_tmp6_ = self->dont_suggest_link;
				_tmp7_ = a_persona;
				_tmp8_ = folks_persona_get_uid (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = gee_multi_map_get ((GeeMultiMap*) _tmp6_, _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
				_tmp13_ = _tmp12_;
				_g_object_unref0 (_tmp11_);
				_no_link_uid_it = _tmp13_;
				while (TRUE) {
					GeeIterator* _tmp14_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp15_;
					gpointer _tmp16_;
					_tmp14_ = _no_link_uid_it;
					if (!gee_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = _no_link_uid_it;
					_tmp16_ = gee_iterator_get (_tmp15_);
					no_link_uid = (gchar*) _tmp16_;
					{
						GeeIterator* _b_persona_it = NULL;
						GeeSet* _tmp17_;
						GeeSet* _tmp18_;
						GeeIterator* _tmp19_;
						_tmp17_ = folks_individual_get_personas (b);
						_tmp18_ = _tmp17_;
						_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
						_b_persona_it = _tmp19_;
						while (TRUE) {
							GeeIterator* _tmp20_;
							FolksPersona* b_persona = NULL;
							GeeIterator* _tmp21_;
							gpointer _tmp22_;
							FolksPersona* _tmp23_;
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							const gchar* _tmp26_;
							_tmp20_ = _b_persona_it;
							if (!gee_iterator_next (_tmp20_)) {
								break;
							}
							_tmp21_ = _b_persona_it;
							_tmp22_ = gee_iterator_get (_tmp21_);
							b_persona = (FolksPersona*) _tmp22_;
							_tmp23_ = b_persona;
							_tmp24_ = folks_persona_get_uid (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = no_link_uid;
							if (g_strcmp0 (_tmp25_, _tmp26_) == 0) {
								result = FALSE;
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								return result;
							}
							_g_object_unref0 (b_persona);
						}
						_g_object_unref0 (_b_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (a_persona);
		}
		_g_object_unref0 (_a_persona_it);
	}
	{
		GeeIterator* _b_persona_it = NULL;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeIterator* _tmp29_;
		_tmp27_ = folks_individual_get_personas (b);
		_tmp28_ = _tmp27_;
		_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
		_b_persona_it = _tmp29_;
		while (TRUE) {
			GeeIterator* _tmp30_;
			FolksPersona* b_persona = NULL;
			GeeIterator* _tmp31_;
			gpointer _tmp32_;
			_tmp30_ = _b_persona_it;
			if (!gee_iterator_next (_tmp30_)) {
				break;
			}
			_tmp31_ = _b_persona_it;
			_tmp32_ = gee_iterator_get (_tmp31_);
			b_persona = (FolksPersona*) _tmp32_;
			{
				GeeIterator* _no_link_uid_it = NULL;
				GeeHashMultiMap* _tmp33_;
				FolksPersona* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				GeeCollection* _tmp37_;
				GeeCollection* _tmp38_;
				GeeIterator* _tmp39_;
				GeeIterator* _tmp40_;
				_tmp33_ = self->dont_suggest_link;
				_tmp34_ = b_persona;
				_tmp35_ = folks_persona_get_uid (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = gee_multi_map_get ((GeeMultiMap*) _tmp33_, _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = gee_iterable_iterator ((GeeIterable*) _tmp38_);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp38_);
				_no_link_uid_it = _tmp40_;
				while (TRUE) {
					GeeIterator* _tmp41_;
					gchar* no_link_uid = NULL;
					GeeIterator* _tmp42_;
					gpointer _tmp43_;
					_tmp41_ = _no_link_uid_it;
					if (!gee_iterator_next (_tmp41_)) {
						break;
					}
					_tmp42_ = _no_link_uid_it;
					_tmp43_ = gee_iterator_get (_tmp42_);
					no_link_uid = (gchar*) _tmp43_;
					{
						GeeIterator* _a_persona_it = NULL;
						GeeSet* _tmp44_;
						GeeSet* _tmp45_;
						GeeIterator* _tmp46_;
						_tmp44_ = folks_individual_get_personas (a);
						_tmp45_ = _tmp44_;
						_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
						_a_persona_it = _tmp46_;
						while (TRUE) {
							GeeIterator* _tmp47_;
							FolksPersona* a_persona = NULL;
							GeeIterator* _tmp48_;
							gpointer _tmp49_;
							FolksPersona* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							_tmp47_ = _a_persona_it;
							if (!gee_iterator_next (_tmp47_)) {
								break;
							}
							_tmp48_ = _a_persona_it;
							_tmp49_ = gee_iterator_get (_tmp48_);
							a_persona = (FolksPersona*) _tmp49_;
							_tmp50_ = a_persona;
							_tmp51_ = folks_persona_get_uid (_tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = no_link_uid;
							if (g_strcmp0 (_tmp52_, _tmp53_) == 0) {
								result = FALSE;
								_g_object_unref0 (a_persona);
								_g_object_unref0 (_a_persona_it);
								_g_free0 (no_link_uid);
								_g_object_unref0 (_no_link_uid_it);
								_g_object_unref0 (b_persona);
								_g_object_unref0 (_b_persona_it);
								return result;
							}
							_g_object_unref0 (a_persona);
						}
						_g_object_unref0 (_a_persona_it);
					}
					_g_free0 (no_link_uid);
				}
				_g_object_unref0 (_no_link_uid_it);
			}
			_g_object_unref0 (b_persona);
		}
		_g_object_unref0 (_b_persona_it);
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_store_add_no_suggest_link (ContactsStore* self,
                                    FolksIndividual* a,
                                    FolksIndividual* b)
{
	FolksPersona* persona1 = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	FolksPersona** _tmp4_;
	gint _tmp4__length1;
	FolksPersona* _tmp5_;
	FolksPersona* _tmp6_;
	FolksPersona* _tmp7_;
	FolksPersona* persona2 = NULL;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	gint _tmp10_ = 0;
	gpointer* _tmp11_;
	FolksPersona** _tmp12_;
	gint _tmp12__length1;
	FolksPersona* _tmp13_;
	FolksPersona* _tmp14_;
	FolksPersona* _tmp15_;
	GeeHashMultiMap* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = folks_individual_get_personas (a);
	_tmp1_ = _tmp0_;
	_tmp3_ = gee_collection_to_array ((GeeCollection*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = _tmp4_[0];
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	persona1 = _tmp7_;
	_tmp8_ = folks_individual_get_personas (b);
	_tmp9_ = _tmp8_;
	_tmp11_ = gee_collection_to_array ((GeeCollection*) _tmp9_, &_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _tmp10_;
	_tmp13_ = _tmp12_[0];
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_object_unref), NULL);
	persona2 = _tmp15_;
	_tmp16_ = self->dont_suggest_link;
	_tmp17_ = folks_persona_get_uid (persona1);
	_tmp18_ = _tmp17_;
	_tmp19_ = folks_persona_get_uid (persona2);
	_tmp20_ = _tmp19_;
	gee_multi_map_set ((GeeMultiMap*) _tmp16_, _tmp18_, _tmp20_);
	contacts_store_write_dont_suggest_db (self);
	_g_object_unref0 (persona2);
	_g_object_unref0 (persona1);
}

ContactsStore*
contacts_store_construct (GType object_type,
                          GSettings* settings,
                          FolksQuery* query)
{
	ContactsStore * self = NULL;
	ContactsIndividualSorter* _tmp0_;
	ContactsIndividualSorter* _tmp1_;
	GListStore* _tmp2_;
	GListModel* _tmp3_;
	ContactsIndividualSorter* _tmp4_;
	GtkSorter* _tmp5_;
	GtkSortListModel* _tmp6_;
	GtkSortListModel* _tmp7_;
	ContactsIndividualSectionSorter* _tmp8_;
	ContactsIndividualSectionSorter* _tmp9_;
	GtkEveryFilter* filter = NULL;
	GtkEveryFilter* _tmp10_;
	ContactsQueryFilter* _tmp11_;
	ContactsQueryFilter* _tmp12_;
	ContactsQueryFilter* _tmp13_;
	GtkFilter* _tmp14_;
	ContactsManualFilter* _tmp15_;
	ContactsManualFilter* _tmp16_;
	ContactsManualFilter* _tmp17_;
	GtkFilter* _tmp18_;
	GtkSortListModel* _tmp19_;
	GListModel* _tmp20_;
	GtkFilter* _tmp21_;
	GtkFilterListModel* _tmp22_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (query != NULL, NULL);
	self = (ContactsStore*) g_object_new (object_type, NULL);
	_tmp0_ = contacts_individual_sorter_new (settings);
	_tmp1_ = _tmp0_;
	contacts_store_set_sorter (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->base_model;
	_tmp3_ = _g_object_ref0 ((GListModel*) _tmp2_);
	_tmp4_ = self->priv->_sorter;
	_tmp5_ = _g_object_ref0 ((GtkSorter*) _tmp4_);
	_tmp6_ = gtk_sort_list_model_new (_tmp3_, _tmp5_);
	_g_object_unref0 (self->priv->sort_model);
	self->priv->sort_model = _tmp6_;
	_tmp7_ = self->priv->sort_model;
	_tmp8_ = contacts_individual_section_sorter_new ();
	_tmp9_ = _tmp8_;
	gtk_sort_list_model_set_section_sorter (_tmp7_, (GtkSorter*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = gtk_every_filter_new ();
	filter = _tmp10_;
	_tmp11_ = contacts_query_filter_new (query);
	_tmp12_ = _tmp11_;
	contacts_store_set_query_filter (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->_query_filter;
	_tmp14_ = _g_object_ref0 ((GtkFilter*) _tmp13_);
	gtk_multi_filter_append ((GtkMultiFilter*) filter, _tmp14_);
	_tmp15_ = contacts_manual_filter_new ();
	_tmp16_ = _tmp15_;
	contacts_store_set_manual_filter (self, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->_manual_filter;
	_tmp18_ = _g_object_ref0 ((GtkFilter*) _tmp17_);
	gtk_multi_filter_append ((GtkMultiFilter*) filter, _tmp18_);
	_tmp19_ = self->priv->sort_model;
	_tmp20_ = _g_object_ref0 ((GListModel*) _tmp19_);
	_tmp21_ = _g_object_ref0 ((GtkFilter*) filter);
	_tmp22_ = gtk_filter_list_model_new (_tmp20_, _tmp21_);
	_g_object_unref0 (self->priv->filter_model);
	self->priv->filter_model = _tmp22_;
	_g_object_unref0 (filter);
	return self;
}

ContactsStore*
contacts_store_new (GSettings* settings,
                    FolksQuery* query)
{
	return contacts_store_construct (CONTACTS_TYPE_STORE, settings, query);
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
______lambda6_ (ContactsStore* self,
                GObject* obj,
                GParamSpec* pspec)
{
	const gchar* prop_name = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	guint pos = 0U;
	GListStore* _tmp4_;
	guint _tmp5_ = 0U;
	gboolean _tmp6_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = g_param_spec_get_name (pspec);
	prop_name = _tmp0_;
	_tmp2_ = prop_name;
	if (g_strcmp0 (_tmp2_, "display-name") != 0) {
		const gchar* _tmp3_;
		_tmp3_ = prop_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "is-favourite") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	_tmp4_ = self->priv->base_model;
	_tmp6_ = g_list_store_find (_tmp4_, obj, &_tmp5_);
	pos = _tmp5_;
	if (_tmp6_) {
		GListStore* _tmp7_;
		_tmp7_ = self->priv->base_model;
		g_list_model_items_changed ((GListModel*) _tmp7_, pos, (guint) 1, (guint) 1);
	}
}

static void
_______lambda6__g_object_notify (GObject* _sender,
                                 GParamSpec* pspec,
                                 gpointer self)
{
	______lambda6_ ((ContactsStore*) self, _sender, pspec);
}

static void
contacts_store_on_individuals_changed_detailed (ContactsStore* self,
                                                GeeMultiMap* changes)
{
	GPtrArray* to_add = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* to_remove = NULL;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	GPtrArray* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GPtrArray* _tmp32_;
	GListStore* _tmp58_;
	GListStore* _tmp59_;
	GPtrArray* _tmp60_;
	gpointer* _tmp61_;
	gint _tmp61__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changes != NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, NULL);
	to_add = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, NULL);
	to_remove = _tmp1_;
	{
		GeeIterator* _individual_it = NULL;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp2_ = gee_multi_map_get_keys (changes);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_individual_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			FolksIndividual* individual = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			FolksIndividual* _tmp9_;
			_tmp6_ = _individual_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _individual_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			individual = (FolksIndividual*) _tmp8_;
			_tmp9_ = individual;
			if (_tmp9_ != NULL) {
				GPtrArray* _tmp10_;
				FolksIndividual* _tmp11_;
				_tmp10_ = to_remove;
				_tmp11_ = individual;
				g_ptr_array_add (_tmp10_, _tmp11_);
			}
			{
				GeeIterator* _new_i_it = NULL;
				FolksIndividual* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GeeIterator* _tmp15_;
				GeeIterator* _tmp16_;
				_tmp12_ = individual;
				_tmp13_ = gee_multi_map_get (changes, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_new_i_it = _tmp16_;
				while (TRUE) {
					GeeIterator* _tmp17_;
					FolksIndividual* new_i = NULL;
					GeeIterator* _tmp18_;
					gpointer _tmp19_;
					gboolean _tmp20_ = FALSE;
					FolksIndividual* _tmp21_;
					_tmp17_ = _new_i_it;
					if (!gee_iterator_next (_tmp17_)) {
						break;
					}
					_tmp18_ = _new_i_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					new_i = (FolksIndividual*) _tmp19_;
					_tmp21_ = new_i;
					if (_tmp21_ != NULL) {
						GPtrArray* _tmp22_;
						FolksIndividual* _tmp23_;
						_tmp22_ = to_add;
						_tmp23_ = new_i;
						_tmp20_ = !g_ptr_array_find (_tmp22_, _tmp23_, NULL);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						GPtrArray* _tmp24_;
						FolksIndividual* _tmp25_;
						_tmp24_ = to_add;
						_tmp25_ = new_i;
						g_ptr_array_add (_tmp24_, _tmp25_);
					}
					_g_object_unref0 (new_i);
				}
				_g_object_unref0 (_new_i_it);
			}
			_g_object_unref0 (individual);
		}
		_g_object_unref0 (_individual_it);
	}
	_tmp26_ = to_add;
	_tmp27_ = vala_g_ptr_array_get_length (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = to_remove;
	_tmp30_ = vala_g_ptr_array_get_length (_tmp29_);
	_tmp31_ = _tmp30_;
	g_debug ("contacts-store.vala:189: Individuals changed: %d added, %d removed", _tmp28_, _tmp31_);
	_tmp32_ = to_remove;
	{
		GPtrArray* indiv_collection = NULL;
		guint indiv_index = 0U;
		indiv_collection = _tmp32_;
		for (indiv_index = 0; indiv_index < indiv_collection->len; indiv_index = indiv_index + 1) {
			FolksIndividual* indiv = NULL;
			indiv = (FolksIndividual*) g_ptr_array_index (indiv_collection, indiv_index);
			{
				guint pos = 0U;
				GListStore* _tmp33_;
				FolksIndividual* _tmp34_;
				guint _tmp35_ = 0U;
				gboolean _tmp36_;
				pos = (guint) 0;
				_tmp33_ = self->priv->base_model;
				_tmp34_ = indiv;
				_tmp36_ = g_list_store_find (_tmp33_, (GObject*) _tmp34_, &_tmp35_);
				pos = _tmp35_;
				if (_tmp36_) {
					GListStore* _tmp37_;
					_tmp37_ = self->priv->base_model;
					g_list_store_remove (_tmp37_, pos);
				} else {
					FolksIndividual* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp38_ = indiv;
					_tmp39_ = folks_individual_get_display_name (_tmp38_);
					_tmp40_ = _tmp39_;
					g_debug ("contacts-store.vala:198: Tried to remove individual '%s', but could't " \
"find it", _tmp40_);
				}
			}
		}
	}
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				FolksIndividual* indiv = NULL;
				GPtrArray* _tmp46_;
				gconstpointer _tmp47_;
				gboolean _tmp48_ = FALSE;
				FolksIndividual* _tmp49_;
				GeeSet* _tmp50_;
				GeeSet* _tmp51_;
				gint _tmp52_;
				gint _tmp53_;
				if (!_tmp41_) {
					guint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = to_add;
				_tmp44_ = vala_g_ptr_array_get_length (_tmp43_);
				_tmp45_ = _tmp44_;
				if (!(i < ((guint) _tmp45_))) {
					break;
				}
				_tmp46_ = to_add;
				_tmp47_ = g_ptr_array_index (_tmp46_, i);
				indiv = (FolksIndividual*) _tmp47_;
				_tmp49_ = indiv;
				_tmp50_ = folks_individual_get_personas (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = gee_collection_get_size ((GeeCollection*) _tmp51_);
				_tmp53_ = _tmp52_;
				if (_tmp53_ == 0) {
					_tmp48_ = TRUE;
				} else {
					FolksIndividual* _tmp54_;
					_tmp54_ = indiv;
					_tmp48_ = contacts_utils_is_ignorable (_tmp54_);
				}
				if (_tmp48_) {
					GPtrArray* _tmp55_;
					guint _tmp56_;
					_tmp55_ = to_add;
					g_ptr_array_remove_index_fast (_tmp55_, i);
					_tmp56_ = i;
					i = _tmp56_ - 1;
				} else {
					FolksIndividual* _tmp57_;
					_tmp57_ = indiv;
					g_signal_connect_object ((GObject*) _tmp57_, "notify", (GCallback) _______lambda6__g_object_notify, self, 0);
				}
			}
		}
	}
	_tmp58_ = self->priv->base_model;
	_tmp59_ = self->priv->base_model;
	_tmp60_ = to_add;
	_tmp61_ = _tmp60_->pdata;
	_tmp61__length1 = _tmp60_->len;
	g_list_store_splice (_tmp58_, g_list_model_get_n_items ((GListModel*) _tmp59_), (guint) 0, (GObject**) _tmp61_, (guint) ((_tmp61__length1 * sizeof (FolksIndividual*)) / sizeof (GObject*)));
	_g_ptr_array_unref0 (to_remove);
	_g_ptr_array_unref0 (to_add);
}

static void
contacts_store_find_individual_for_query_data_free (gpointer _data)
{
	ContactsStoreFindIndividualForQueryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->query);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreFindIndividualForQueryData, _data_);
}

void
contacts_store_find_individual_for_query (ContactsStore* self,
                                          FolksQuery* query,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	ContactsStoreFindIndividualForQueryData* _data_;
	ContactsStore* _tmp0_;
	FolksQuery* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_data_ = g_slice_new0 (ContactsStoreFindIndividualForQueryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_find_individual_for_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (query);
	_g_object_unref0 (_data_->query);
	_data_->query = _tmp1_;
	contacts_store_find_individual_for_query_co (_data_);
}

guint
contacts_store_find_individual_for_query_finish (ContactsStore* self,
                                                 GAsyncResult* _res_)
{
	guint result;
	ContactsStoreFindIndividualForQueryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/**
   * A helper method to find a contact based on the given search query, while
   * making sure to take care of (wait for) the "quiescent" property of the
   * IndividualAggregator.
   */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsStore* self;
		self = _data2_->self;
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_contacts_store_find_individual_for_query_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_store_find_individual_for_query_co (self);
	return result;
}

static void
___lambda7_ (Block2Data* _data2_)
{
	ContactsStore* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data2_->self;
	_tmp0_ = _data2_->callback;
	_tmp0__target = _data2_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
____lambda7__contacts_store_quiescent (ContactsStore* _sender,
                                       gpointer self)
{
	___lambda7_ (self);
}

static gboolean
contacts_store_find_individual_for_query_co (ContactsStoreFindIndividualForQueryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_aggregator;
	_data_->_tmp1_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_data2_ = g_slice_new0 (Block2Data);
		_data_->_data2_->_ref_count_ = 1;
		_data_->_data2_->self = g_object_ref (_data_->self);
		_data_->_data2_->callback = _contacts_store_find_individual_for_query_co_gsource_func;
		_data_->_data2_->callback_target = _data_;
		_data_->_data2_->callback_target_destroy_notify = NULL;
		_data_->_tmp3_ = g_signal_connect_data (_data_->self, "quiescent", (GCallback) ____lambda7__contacts_store_quiescent, block2_data_ref (_data_->_data2_), (GClosureNotify) block2_data_unref, 0);
		_data_->signal_id = _data_->_tmp3_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->signal_id);
		block2_data_unref (_data_->_data2_);
		_data_->_data2_ = NULL;
	}
	_data_->matched_pos = GTK_INVALID_LIST_POSITION;
	_data_->strength = (guint) 0;
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp4_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp4_) {
					_data_->_tmp5_ = _data_->i;
					_data_->i = _data_->_tmp5_ + 1;
				}
				_data_->_tmp4_ = FALSE;
				_data_->_tmp6_ = contacts_store_get_individuals (_data_->self);
				_data_->_tmp7_ = _data_->_tmp6_;
				if (!(_data_->i < g_list_model_get_n_items (_data_->_tmp7_))) {
					break;
				}
				_data_->_tmp8_ = contacts_store_get_individuals (_data_->self);
				_data_->_tmp9_ = _data_->_tmp8_;
				_data_->_tmp10_ = g_list_model_get_item (_data_->_tmp9_, _data_->i);
				_data_->individual = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
				_data_->_tmp11_ = _data_->individual;
				_data_->this_strength = folks_query_is_match (_data_->query, _data_->_tmp11_);
				if (_data_->this_strength > _data_->strength) {
					_data_->matched_pos = _data_->i;
					_data_->strength = _data_->this_strength;
				}
				_g_object_unref0 (_data_->individual);
			}
		}
	}
	_data_->result = _data_->matched_pos;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_store_find_individual_for_id_data_free (gpointer _data)
{
	ContactsStoreFindIndividualForIdData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsStoreFindIndividualForIdData, _data_);
}

void
contacts_store_find_individual_for_id (ContactsStore* self,
                                       const gchar* id,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ContactsStoreFindIndividualForIdData* _data_;
	ContactsStore* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_data_ = g_slice_new0 (ContactsStoreFindIndividualForIdData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_store_find_individual_for_id_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	contacts_store_find_individual_for_id_co (_data_);
}

guint
contacts_store_find_individual_for_id_finish (ContactsStore* self,
                                              GAsyncResult* _res_)
{
	guint result;
	ContactsStoreFindIndividualForIdData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

/**
   * A helper method to find a contact based on the given individual id, while
   * making sure to take care of (wait for) the "quiescent" property of the
   * IndividualAggregator.
   */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ContactsStore* self;
		self = _data3_->self;
		(_data3_->callback_target_destroy_notify == NULL) ? NULL : (_data3_->callback_target_destroy_notify (_data3_->callback_target), NULL);
		_data3_->callback = NULL;
		_data3_->callback_target = NULL;
		_data3_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_contacts_store_find_individual_for_id_co_gsource_func (gpointer self)
{
	gboolean result;
	result = contacts_store_find_individual_for_id_co (self);
	return result;
}

static void
___lambda8_ (Block3Data* _data3_)
{
	ContactsStore* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	self = _data3_->self;
	_tmp0_ = _data3_->callback;
	_tmp0__target = _data3_->callback_target;
	_tmp0_ (_tmp0__target);
}

static void
____lambda8__contacts_store_quiescent (ContactsStore* _sender,
                                       gpointer self)
{
	___lambda8_ (self);
}

static gboolean
contacts_store_find_individual_for_id_co (ContactsStoreFindIndividualForIdData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_aggregator;
	_data_->_tmp1_ = folks_individual_aggregator_get_is_quiescent (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (!_data_->_tmp2_) {
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->self = g_object_ref (_data_->self);
		_data_->_data3_->callback = _contacts_store_find_individual_for_id_co_gsource_func;
		_data_->_data3_->callback_target = _data_;
		_data_->_data3_->callback_target_destroy_notify = NULL;
		_data_->_tmp3_ = g_signal_connect_data (_data_->self, "quiescent", (GCallback) ____lambda8__contacts_store_quiescent, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->signal_id = _data_->_tmp3_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		g_signal_handler_disconnect ((GObject*) _data_->self, _data_->signal_id);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
	}
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp4_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp4_) {
					_data_->_tmp5_ = _data_->i;
					_data_->i = _data_->_tmp5_ + 1;
				}
				_data_->_tmp4_ = FALSE;
				_data_->_tmp6_ = contacts_store_get_individuals (_data_->self);
				_data_->_tmp7_ = _data_->_tmp6_;
				if (!(_data_->i < g_list_model_get_n_items (_data_->_tmp7_))) {
					break;
				}
				_data_->_tmp8_ = contacts_store_get_individuals (_data_->self);
				_data_->_tmp9_ = _data_->_tmp8_;
				_data_->_tmp10_ = g_list_model_get_item (_data_->_tmp9_, _data_->i);
				_data_->individual = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, FOLKS_TYPE_INDIVIDUAL, FolksIndividual);
				_data_->_tmp11_ = _data_->individual;
				_data_->_tmp12_ = folks_individual_get_id (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				if (g_strcmp0 (_data_->_tmp13_, _data_->id) == 0) {
					_data_->result = _data_->i;
					_g_object_unref0 (_data_->individual);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->individual);
			}
		}
	}
	_data_->result = GTK_INVALID_LIST_POSITION;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Sets the primary address book. This will be used as the primary candidate
   * to store new contacts, and will prioritize personas coming from this store
   * when showing them.
   */
void
contacts_store_set_primary_address_book (ContactsStore* self,
                                         EdsfPersonaStore* e_store)
{
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (e_store != NULL);
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = edsf_persona_store_get_source (e_store);
	_tmp2_ = _tmp1_;
	e_source_registry_set_default_address_book (_tmp0_, _tmp2_);
	_tmp3_ = g_settings_new ("org.freedesktop.folks");
	settings = _tmp3_;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) e_store);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("eds:%s", _tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_string (settings, "primary-store", _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (settings);
}

gboolean
contacts_store_suggest_link_to (ContactsStore* self,
                                FolksIndividual* _self_,
                                FolksIndividual* other)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_self_ != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	if (contacts_store_non_linkable (self, _self_)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = contacts_store_non_linkable (self, other);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (!contacts_store_may_suggest_link (self, _self_, other)) {
		result = FALSE;
		return result;
	}
	if (!contacts_utils_has_main_persona (_self_)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = !contacts_store_has_mainable_persona (self, other);
	}
	result = _tmp1_;
	return result;
}

static gboolean
contacts_store_has_mainable_persona (ContactsStore* self,
                                     FolksIndividual* individual)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (individual != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			gboolean _tmp6_ = FALSE;
			FolksPersona* _tmp7_;
			FolksPersonaStore* _tmp8_;
			FolksPersonaStore* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp7_ = p;
			_tmp8_ = folks_persona_get_store (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = folks_persona_store_get_type_id (_tmp9_);
			_tmp11_ = _tmp10_;
			if (g_strcmp0 (_tmp11_, "eds") == 0) {
				FolksPersona* _tmp12_;
				_tmp12_ = p;
				_tmp6_ = !contacts_utils_persona_is_google_other (_tmp12_);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}

static gboolean
contacts_store_non_linkable (ContactsStore* self,
                             FolksIndividual* individual)
{
	gboolean all_unlinkable = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (individual != NULL, FALSE);
	all_unlinkable = TRUE;
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp0_ = folks_individual_get_personas (individual);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_p_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			_tmp3_ = _p_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			if (!contacts_utils_persona_is_google_other (_tmp6_)) {
				all_unlinkable = FALSE;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = all_unlinkable;
	return result;
}

FolksIndividualAggregator*
contacts_store_get_aggregator (ContactsStore* self)
{
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}

static void
contacts_store_set_aggregator (ContactsStore* self,
                               FolksIndividualAggregator* value)
{
	FolksIndividualAggregator* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_store_get_aggregator (self);
	if (old_value != value) {
		FolksIndividualAggregator* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_aggregator);
		self->priv->_aggregator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_store_properties[CONTACTS_STORE_AGGREGATOR_PROPERTY]);
	}
}

FolksBackendStore*
contacts_store_get_backend_store (ContactsStore* self)
{
	FolksBackendStore* result;
	FolksIndividualAggregator* _tmp0_;
	FolksBackendStore* _tmp1_;
	FolksBackendStore* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	_tmp1_ = folks_individual_aggregator_get_backend_store (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

ContactsIndividualSorter*
contacts_store_get_sorter (ContactsStore* self)
{
	ContactsIndividualSorter* result;
	ContactsIndividualSorter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sorter;
	result = _tmp0_;
	return result;
}

static void
contacts_store_set_sorter (ContactsStore* self,
                           ContactsIndividualSorter* value)
{
	ContactsIndividualSorter* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_store_get_sorter (self);
	if (old_value != value) {
		ContactsIndividualSorter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sorter);
		self->priv->_sorter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_store_properties[CONTACTS_STORE_SORTER_PROPERTY]);
	}
}

ContactsQueryFilter*
contacts_store_get_query_filter (ContactsStore* self)
{
	ContactsQueryFilter* result;
	ContactsQueryFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_filter;
	result = _tmp0_;
	return result;
}

static void
contacts_store_set_query_filter (ContactsStore* self,
                                 ContactsQueryFilter* value)
{
	ContactsQueryFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_store_get_query_filter (self);
	if (old_value != value) {
		ContactsQueryFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_query_filter);
		self->priv->_query_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_store_properties[CONTACTS_STORE_QUERY_FILTER_PROPERTY]);
	}
}

ContactsManualFilter*
contacts_store_get_manual_filter (ContactsStore* self)
{
	ContactsManualFilter* result;
	ContactsManualFilter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manual_filter;
	result = _tmp0_;
	return result;
}

static void
contacts_store_set_manual_filter (ContactsStore* self,
                                  ContactsManualFilter* value)
{
	ContactsManualFilter* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_store_get_manual_filter (self);
	if (old_value != value) {
		ContactsManualFilter* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_manual_filter);
		self->priv->_manual_filter = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_store_properties[CONTACTS_STORE_MANUAL_FILTER_PROPERTY]);
	}
}

GListModel*
contacts_store_get_individuals (ContactsStore* self)
{
	GListModel* result;
	GtkFilterListModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filter_model;
	result = (GListModel*) _tmp0_;
	return result;
}

GListModel*
contacts_store_get_address_books (ContactsStore* self)
{
	GListModel* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address_books;
	result = (GListModel*) _tmp0_;
	return result;
}

static void
_contacts_store___lambda9_ (ContactsStore* self,
                            FolksBackend* backend)
{
	g_return_if_fail (backend != NULL);
	{
		GeeIterator* _persona_store_it = NULL;
		GeeMap* _tmp0_;
		GeeMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = folks_backend_get_persona_stores (backend);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_map_get_values (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_persona_store_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			FolksPersonaStore* persona_store = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GListStore* _tmp10_;
			FolksPersonaStore* _tmp11_;
			_tmp7_ = _persona_store_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _persona_store_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			persona_store = (FolksPersonaStore*) _tmp9_;
			_tmp10_ = self->priv->_address_books;
			_tmp11_ = persona_store;
			g_list_store_append (_tmp10_, (GObject*) _tmp11_);
			_g_object_unref0 (persona_store);
		}
		_g_object_unref0 (_persona_store_it);
	}
}

static void
__contacts_store___lambda9__folks_backend_store_backend_available (FolksBackendStore* _sender,
                                                                   FolksBackend* backend,
                                                                   gpointer self)
{
	_contacts_store___lambda9_ ((ContactsStore*) self, backend);
}

static gboolean
__lambda11_ (ContactsStore* self)
{
	gboolean result;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((ContactsStore*) self);
	return result;
}

static void
_contacts_store___lambda10_ (ContactsStore* self,
                             GObject* obj,
                             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__contacts_store___lambda10__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	_contacts_store___lambda10_ ((ContactsStore*) self, _sender, pspec);
}

static gboolean
__lambda13_ (ContactsStore* self)
{
	gboolean result;
	g_signal_emit (self, contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((ContactsStore*) self);
	return result;
}

static void
_contacts_store___lambda12_ (ContactsStore* self,
                             GObject* obj,
                             GParamSpec* pspec)
{
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
}

static void
__contacts_store___lambda12__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	_contacts_store___lambda12_ ((ContactsStore*) self, _sender, pspec);
}

static void
_contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed (FolksIndividualAggregator* _sender,
                                                                                                          GeeMultiMap* changes,
                                                                                                          gpointer self)
{
	contacts_store_on_individuals_changed_detailed ((ContactsStore*) self, changes);
}

static GObject *
contacts_store_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsStore * self;
	GeeHashMultiMap* _tmp0_;
	FolksBackendStore* backend_store = NULL;
	FolksBackendStore* _tmp1_;
	FolksBackendStore* _tmp26_;
	FolksBackendStore* _tmp27_;
	FolksIndividualAggregator* _tmp28_;
	FolksIndividualAggregator* _tmp29_;
	FolksIndividualAggregator* _tmp30_;
	FolksIndividualAggregator* _tmp31_;
	FolksIndividualAggregator* _tmp32_;
	FolksIndividualAggregator* _tmp33_;
	parent_class = G_OBJECT_CLASS (contacts_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->dont_suggest_link);
	self->dont_suggest_link = _tmp0_;
	contacts_store_read_dont_suggest_db (self);
	_tmp1_ = folks_backend_store_dup ();
	backend_store = _tmp1_;
	{
		GeeIterator* _backend_it = NULL;
		FolksBackendStore* _tmp2_;
		GeeMap* _tmp3_;
		GeeMap* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeIterator* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp2_ = backend_store;
		_tmp3_ = folks_backend_store_get_enabled_backends (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_map_get_values (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp7_);
		_backend_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			FolksBackend* backend = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			_tmp10_ = _backend_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _backend_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			backend = (FolksBackend*) _tmp12_;
			{
				GeeIterator* _persona_store_it = NULL;
				FolksBackend* _tmp13_;
				GeeMap* _tmp14_;
				GeeMap* _tmp15_;
				GeeCollection* _tmp16_;
				GeeCollection* _tmp17_;
				GeeCollection* _tmp18_;
				GeeIterator* _tmp19_;
				GeeIterator* _tmp20_;
				_tmp13_ = backend;
				_tmp14_ = folks_backend_get_persona_stores (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = gee_map_get_values (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_g_object_unref0 (_tmp18_);
				_persona_store_it = _tmp20_;
				while (TRUE) {
					GeeIterator* _tmp21_;
					FolksPersonaStore* persona_store = NULL;
					GeeIterator* _tmp22_;
					gpointer _tmp23_;
					GListStore* _tmp24_;
					FolksPersonaStore* _tmp25_;
					_tmp21_ = _persona_store_it;
					if (!gee_iterator_next (_tmp21_)) {
						break;
					}
					_tmp22_ = _persona_store_it;
					_tmp23_ = gee_iterator_get (_tmp22_);
					persona_store = (FolksPersonaStore*) _tmp23_;
					_tmp24_ = self->priv->_address_books;
					_tmp25_ = persona_store;
					g_list_store_append (_tmp24_, (GObject*) _tmp25_);
					_g_object_unref0 (persona_store);
				}
				_g_object_unref0 (_persona_store_it);
			}
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp26_ = backend_store;
	g_signal_connect_object (_tmp26_, "backend-available", (GCallback) __contacts_store___lambda9__folks_backend_store_backend_available, self, 0);
	_tmp27_ = backend_store;
	_tmp28_ = folks_individual_aggregator_dup_with_backend_store (_tmp27_);
	_tmp29_ = _tmp28_;
	contacts_store_set_aggregator (self, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp30_, "notify::is-quiescent", (GCallback) __contacts_store___lambda10__g_object_notify, self, 0);
	_tmp31_ = self->priv->_aggregator;
	g_signal_connect_object ((GObject*) _tmp31_, "notify::is-prepared", (GCallback) __contacts_store___lambda12__g_object_notify, self, 0);
	_tmp32_ = self->priv->_aggregator;
	g_signal_connect_object (_tmp32_, "individuals-changed-detailed", (GCallback) _contacts_store_on_individuals_changed_detailed_folks_individual_aggregator_individuals_changed_detailed, self, 0);
	_tmp33_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp33_, NULL, NULL);
	_g_object_unref0 (backend_store);
	return obj;
}

static void
contacts_store_class_init (ContactsStoreClass * klass,
                           gpointer klass_data)
{
	contacts_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_AGGREGATOR_PROPERTY, contacts_store_properties[CONTACTS_STORE_AGGREGATOR_PROPERTY] = g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_BACKEND_STORE_PROPERTY, contacts_store_properties[CONTACTS_STORE_BACKEND_STORE_PROPERTY] = g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_SORTER_PROPERTY, contacts_store_properties[CONTACTS_STORE_SORTER_PROPERTY] = g_param_spec_object ("sorter", "sorter", "sorter", CONTACTS_TYPE_INDIVIDUAL_SORTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_QUERY_FILTER_PROPERTY, contacts_store_properties[CONTACTS_STORE_QUERY_FILTER_PROPERTY] = g_param_spec_object ("query-filter", "query-filter", "query-filter", CONTACTS_TYPE_QUERY_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_MANUAL_FILTER_PROPERTY, contacts_store_properties[CONTACTS_STORE_MANUAL_FILTER_PROPERTY] = g_param_spec_object ("manual-filter", "manual-filter", "manual-filter", CONTACTS_TYPE_MANUAL_FILTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The list of individuals after all sorting/filtering operations */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_INDIVIDUALS_PROPERTY, contacts_store_properties[CONTACTS_STORE_INDIVIDUALS_PROPERTY] = g_param_spec_object ("individuals", "individuals", "individuals", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_STORE_ADDRESS_BOOKS_PROPERTY, contacts_store_properties[CONTACTS_STORE_ADDRESS_BOOKS_PROPERTY] = g_param_spec_object ("address-books", "address-books", "address-books", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	contacts_store_signals[CONTACTS_STORE_QUIESCENT_SIGNAL] = g_signal_new ("quiescent", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	contacts_store_signals[CONTACTS_STORE_PREPARED_SIGNAL] = g_signal_new ("prepared", CONTACTS_TYPE_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
contacts_store_instance_init (ContactsStore * self,
                              gpointer klass)
{
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	self->priv = contacts_store_get_instance_private (self);
	_tmp0_ = g_list_store_new (FOLKS_TYPE_INDIVIDUAL);
	self->priv->base_model = _tmp0_;
	_tmp1_ = g_list_store_new (FOLKS_TYPE_PERSONA_STORE);
	self->priv->_address_books = _tmp1_;
}

static void
contacts_store_finalize (GObject * obj)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_STORE, ContactsStore);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->base_model);
	_g_object_unref0 (self->priv->sort_model);
	_g_object_unref0 (self->priv->_sorter);
	_g_object_unref0 (self->priv->filter_model);
	_g_object_unref0 (self->priv->_query_filter);
	_g_object_unref0 (self->priv->_manual_filter);
	_g_object_unref0 (self->priv->_address_books);
	_g_object_unref0 (self->dont_suggest_link);
	G_OBJECT_CLASS (contacts_store_parent_class)->finalize (obj);
}

/**
 * The Contacts.Store is the base abstraction that holds all contacts (i.e.
 * {@link Folks.Indidivual}s). Note that it also has a "quiescent" and
 * "prepared" signal, with similar effects to those of a
 * {@link Folks.IndividualAggregator}.
 *
 * Internally, the Store works with 3 list models layered on top of each other:
 *
 * - A base list model which contains all contacts in the
 * {@link Folks.IndividualAggregator}
 * - A {@link Gtk.SortListModel}, which sorts the base model according to
 * first name or last name, or whatever user preference
 * - A {@link Gtk.FilterListModel} to filter out contacts using a
 * {@link Folks.Query}, so a user can filter contacts with the search entry
 */
 G_GNUC_NO_INLINE static GType
contacts_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsStore), 0, (GInstanceInitFunc) contacts_store_instance_init, NULL };
	GType contacts_store_type_id;
	contacts_store_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsStore", &g_define_type_info, 0);
	ContactsStore_private_offset = g_type_add_instance_private (contacts_store_type_id, sizeof (ContactsStorePrivate));
	return contacts_store_type_id;
}

GType
contacts_store_get_type (void)
{
	static volatile gsize contacts_store_type_id__once = 0;
	if (g_once_init_enter (&contacts_store_type_id__once)) {
		GType contacts_store_type_id;
		contacts_store_type_id = contacts_store_get_type_once ();
		g_once_init_leave (&contacts_store_type_id__once, contacts_store_type_id);
	}
	return contacts_store_type_id__once;
}

static void
_vala_contacts_store_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR_PROPERTY:
		g_value_set_object (value, contacts_store_get_aggregator (self));
		break;
		case CONTACTS_STORE_BACKEND_STORE_PROPERTY:
		g_value_set_object (value, contacts_store_get_backend_store (self));
		break;
		case CONTACTS_STORE_SORTER_PROPERTY:
		g_value_set_object (value, contacts_store_get_sorter (self));
		break;
		case CONTACTS_STORE_QUERY_FILTER_PROPERTY:
		g_value_set_object (value, contacts_store_get_query_filter (self));
		break;
		case CONTACTS_STORE_MANUAL_FILTER_PROPERTY:
		g_value_set_object (value, contacts_store_get_manual_filter (self));
		break;
		case CONTACTS_STORE_INDIVIDUALS_PROPERTY:
		g_value_set_object (value, contacts_store_get_individuals (self));
		break;
		case CONTACTS_STORE_ADDRESS_BOOKS_PROPERTY:
		g_value_set_object (value, contacts_store_get_address_books (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_store_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ContactsStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_STORE, ContactsStore);
	switch (property_id) {
		case CONTACTS_STORE_AGGREGATOR_PROPERTY:
		contacts_store_set_aggregator (self, g_value_get_object (value));
		break;
		case CONTACTS_STORE_SORTER_PROPERTY:
		contacts_store_set_sorter (self, g_value_get_object (value));
		break;
		case CONTACTS_STORE_QUERY_FILTER_PROPERTY:
		contacts_store_set_query_filter (self, g_value_get_object (value));
		break;
		case CONTACTS_STORE_MANUAL_FILTER_PROPERTY:
		contacts_store_set_manual_filter (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

