/* nibbles-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nibbles-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2023-2025 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 */
/* designed for Gtk 4, link with libgtk-4-dev or gtk4-devel */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gee.h>
#include "libgnome-games-support.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>

#define NIBBLES_WINDOW_COUNTDOWN_TIME 3
#define NIBBLES_PROGRAM_NAME _ ("Nibbles")
#define NIBBLES_GAME_MAX_LEVEL 26
#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_VIEW_WIDTH ((guint8) 92)
#define NIBBLES_VIEW_HEIGHT ((guint8) 66)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	SETUP_SCREEN_USUAL,
	SETUP_SCREEN_SPEED,
	SETUP_SCREEN_CONTROLS,
	SETUP_SCREEN_GAME
} SetupScreen;

#define TYPE_SETUP_SCREEN (setup_screen_get_type ())

#define TYPE_ARE_YOU_SURE_WINDOW (are_you_sure_window_get_type ())
#define ARE_YOU_SURE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindow))
#define ARE_YOU_SURE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindowClass))
#define IS_ARE_YOU_SURE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARE_YOU_SURE_WINDOW))
#define IS_ARE_YOU_SURE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARE_YOU_SURE_WINDOW))
#define ARE_YOU_SURE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindowClass))

typedef struct _AreYouSureWindow AreYouSureWindow;
typedef struct _AreYouSureWindowClass AreYouSureWindowClass;
typedef struct _AreYouSureWindowPrivate AreYouSureWindowPrivate;
typedef void (*AreYouSureWindowAreYouSureResultFunction) (gboolean yes, gpointer user_data);
enum  {
	ARE_YOU_SURE_WINDOW_0_PROPERTY,
	ARE_YOU_SURE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* are_you_sure_window_properties[ARE_YOU_SURE_WINDOW_NUM_PROPERTIES];
typedef struct _Block3Data Block3Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NIBBLES_WINDOW (nibbles_window_get_type ())
#define NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_WINDOW, NibblesWindow))
#define NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_WINDOW, NibblesWindowClass))
#define IS_NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_WINDOW))
#define IS_NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_WINDOW))
#define NIBBLES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_WINDOW, NibblesWindowClass))

typedef struct _NibblesWindow NibblesWindow;
typedef struct _NibblesWindowClass NibblesWindowClass;
typedef struct _NibblesWindowPrivate NibblesWindowPrivate;

#define TYPE_PLAYERS (players_get_type ())
#define PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYERS, Players))
#define PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYERS, PlayersClass))
#define IS_PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYERS))
#define IS_PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYERS))
#define PLAYERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYERS, PlayersClass))

typedef struct _Players Players;
typedef struct _PlayersClass PlayersClass;

#define TYPE_SPEED (speed_get_type ())
#define SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SPEED, Speed))
#define SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SPEED, SpeedClass))
#define IS_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SPEED))
#define IS_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SPEED))
#define SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SPEED, SpeedClass))

typedef struct _Speed Speed;
typedef struct _SpeedClass SpeedClass;

#define TYPE_BOARD_PROGRESS (board_progress_get_type ())
#define BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_PROGRESS, BoardProgress))
#define BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_PROGRESS, BoardProgressClass))
#define IS_BOARD_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_PROGRESS))
#define IS_BOARD_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_PROGRESS))
#define BOARD_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_PROGRESS, BoardProgressClass))

typedef struct _BoardProgress BoardProgress;
typedef struct _BoardProgressClass BoardProgressClass;

#define TYPE_CONTROLS (controls_get_type ())
#define CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS, Controls))
#define CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS, ControlsClass))
#define IS_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS))
#define IS_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS))
#define CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS, ControlsClass))

typedef struct _Controls Controls;
typedef struct _ControlsClass ControlsClass;

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;

#define TYPE_TRANSPARENT_CONTAINER (transparent_container_get_type ())
#define TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainer))
#define TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))
#define IS_TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPARENT_CONTAINER))
#define IS_TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPARENT_CONTAINER))
#define TRANSPARENT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))

typedef struct _TransparentContainer TransparentContainer;
typedef struct _TransparentContainerClass TransparentContainerClass;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;

#define TYPE_SOUND (sound_get_type ())
#define SOUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOUND, Sound))
#define SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOUND, SoundClass))
#define IS_SOUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOUND))
#define IS_SOUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOUND))
#define SOUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOUND, SoundClass))

typedef struct _Sound Sound;
typedef struct _SoundClass SoundClass;

#define NIBBLES_WINDOW_TYPE_DELEGATE_STACK (nibbles_window_delegate_stack_get_type ())
#define NIBBLES_WINDOW_DELEGATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStack))
#define NIBBLES_WINDOW_DELEGATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStackClass))
#define NIBBLES_WINDOW_IS_DELEGATE_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK))
#define NIBBLES_WINDOW_IS_DELEGATE_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_WINDOW_TYPE_DELEGATE_STACK))
#define NIBBLES_WINDOW_DELEGATE_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStackClass))

typedef struct _NibblesWindowDelegateStack NibblesWindowDelegateStack;
typedef struct _NibblesWindowDelegateStackClass NibblesWindowDelegateStackClass;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
enum  {
	NIBBLES_WINDOW_0_PROPERTY,
	NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY,
	NIBBLES_WINDOW_PROGRESS_PROPERTY,
	NIBBLES_WINDOW_START_SCREEN_PROPERTY,
	NIBBLES_WINDOW_GAME_PAUSED_PROPERTY,
	NIBBLES_WINDOW_NUM_PROPERTIES
};
static GParamSpec* nibbles_window_properties[NIBBLES_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _nibbles_window_delegate_stack_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_unref (var), NULL)))

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _NibblesGamePrivate NibblesGamePrivate;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef enum  {
	NIBBLES_GAME_ESTATUS_GAMEOVER,
	NIBBLES_GAME_ESTATUS_VICTORY,
	NIBBLES_GAME_ESTATUS_NEWROUND
} NibblesGameeStatus;

#define NIBBLES_GAME_TYPE_ESTATUS (nibbles_game_estatus_get_type ())
typedef struct _NibblesWindowDelegateStackPrivate NibblesWindowDelegateStackPrivate;

#define NIBBLES_WINDOW_DELEGATE_STACK_TYPE_NODE (nibbles_window_delegate_stack_node_get_type ())
typedef struct _NibblesWindowDelegateStackNode NibblesWindowDelegateStackNode;
typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
#define _nibbles_window_delegate_stack_node_free0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_node_free (var), NULL)))

#define NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR (nibbles_window_delegate_stack_delegate_stack_iterator_get_type ())
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIterator))
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIteratorClass))
#define NIBBLES_WINDOW_DELEGATE_STACK_IS_DELEGATE_STACK_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR))
#define NIBBLES_WINDOW_DELEGATE_STACK_IS_DELEGATE_STACK_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR))
#define NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIteratorClass))

typedef struct _NibblesWindowDelegateStackDelegateStackIterator NibblesWindowDelegateStackDelegateStackIterator;
typedef struct _NibblesWindowDelegateStackDelegateStackIteratorClass NibblesWindowDelegateStackDelegateStackIteratorClass;
typedef struct _NibblesWindowDelegateStackDelegateStackIteratorPrivate NibblesWindowDelegateStackDelegateStackIteratorPrivate;
typedef struct _NibblesWindowDelegateStackParamSpecDelegateStackIterator NibblesWindowDelegateStackParamSpecDelegateStackIterator;
typedef struct _NibblesWindowParamSpecDelegateStack NibblesWindowParamSpecDelegateStack;
#define _nibbles_window_delegate_stack_delegate_stack_iterator_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_window_delegate_stack_delegate_stack_iterator_unref (var), NULL)))
typedef gint (*NibblesViewCountdownActiveFunction) (gpointer user_data);
typedef gboolean (*NibblesViewFullscreenActiveFunction) (gpointer user_data);

#define TYPE_FIRST_RUN (first_run_get_type ())
#define FIRST_RUN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FIRST_RUN, FirstRun))
#define FIRST_RUN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FIRST_RUN, FirstRunClass))
#define IS_FIRST_RUN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FIRST_RUN))
#define IS_FIRST_RUN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FIRST_RUN))
#define FIRST_RUN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FIRST_RUN, FirstRunClass))

typedef struct _FirstRun FirstRun;
typedef struct _FirstRunClass FirstRunClass;
typedef struct _FirstRunPrivate FirstRunPrivate;
enum  {
	FIRST_RUN_0_PROPERTY,
	FIRST_RUN_NUM_PROPERTIES
};
static GParamSpec* first_run_properties[FIRST_RUN_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AreYouSureWindow {
	GtkWindow parent_instance;
	AreYouSureWindowPrivate * priv;
};

struct _AreYouSureWindowClass {
	GtkWindowClass parent_class;
};

struct _AreYouSureWindowPrivate {
	GtkLabel* line_one;
	GtkLabel* line_two;
	GtkButton* button_no;
	GtkButton* button_yes;
	AreYouSureWindowAreYouSureResultFunction result_function;
	gpointer result_function_target;
	GDestroyNotify result_function_target_destroy_notify;
};

struct _Block3Data {
	int _ref_count_;
	AreYouSureWindow* self;
	AreYouSureWindowAreYouSureResultFunction result_function;
	gpointer result_function_target;
};

struct _NibblesWindow {
	AdwApplicationWindow parent_instance;
	NibblesWindowPrivate * priv;
};

struct _NibblesWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _NibblesWindowPrivate {
	GSettings* settings;
	GeeArrayList* worm_settings;
	gboolean fullscreen_mode;
	GtkStack* main_stack;
	GtkOverlay* overlay;
	AdwToolbarView* toolbar;
	AdwHeaderBar* headerbar;
	GtkButton* new_game_button;
	GtkButton* pause_button;
	GtkMenuButton* hamburger_menu;
	Players* players;
	Speed* speed;
	BoardProgress* board_progress;
	Controls* controls;
	GtkStack* statusbar_stack;
	Scoreboard* scoreboard;
	NibblesView* view;
	GtkBox* game_box;
	Sound* sound;
	NibblesWindowDelegateStack* keypress_handlers;
	NibblesGame* game;
	gint _cli_start_level;
	gint _progress;
	SetupScreen _start_screen;
	GamesScoresContext* scores_context;
	GSimpleAction* hamburger_action;
	GSimpleAction* new_game_action;
	GSimpleAction* fullscreen_action;
	GSimpleAction* pause_action;
	GSimpleAction* back_action;
	GSimpleAction* start_game_action;
	guint countdown_id;
	gint seconds;
	gboolean dialog_visible;
	GeeArrayList* overlay_members;
	gchar** category_descriptions;
	gint category_descriptions_length1;
	gint category_descriptions_length2;
	GamesScoresCategory** created_categories;
	gint created_categories_length1;
	gint _created_categories_size_;
	gboolean end_of_game;
};

struct _Block4Data {
	int _ref_count_;
	NibblesWindow* self;
	AdwAlertDialog* dialog;
};

struct _Block5Data {
	int _ref_count_;
	NibblesWindow* self;
	glong lowest_high_score;
	gint score;
	gint level_reached;
};

struct _Block6Data {
	int _ref_count_;
	NibblesWindow* self;
	gboolean should_unpause;
	gulong id;
};

struct _Block7Data {
	int _ref_count_;
	NibblesWindow* self;
	GtkButton* button;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint _progress;
	gint* levels_uncompleated;
	gint levels_uncompleated_length1;
	gint _levels_uncompleated_size_;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _NibblesWindowDelegateStack {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesWindowDelegateStackPrivate * priv;
};

struct _NibblesWindowDelegateStackClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesWindowDelegateStack *self);
};

struct _NibblesWindowDelegateStackNode {
	KeypressHandlerFunction keypress_handler;
	gpointer keypress_handler_target;
	NibblesWindowDelegateStackNode* pNext;
};

struct _NibblesWindowDelegateStackPrivate {
	NibblesWindowDelegateStackNode* pHead;
};

struct _NibblesWindowDelegateStackDelegateStackIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesWindowDelegateStackDelegateStackIteratorPrivate * priv;
};

struct _NibblesWindowDelegateStackDelegateStackIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesWindowDelegateStackDelegateStackIterator *self);
};

struct _NibblesWindowDelegateStackDelegateStackIteratorPrivate {
	NibblesWindowDelegateStackNode* pIterator;
	gboolean first_next;
};

struct _NibblesWindowDelegateStackParamSpecDelegateStackIterator {
	GParamSpec parent_instance;
};

struct _NibblesWindowParamSpecDelegateStack {
	GParamSpec parent_instance;
};

struct _FirstRun {
	GtkBox parent_instance;
	FirstRunPrivate * priv;
};

struct _FirstRunClass {
	GtkBoxClass parent_class;
};

struct _FirstRunPrivate {
	GtkButton* button;
};

static gint AreYouSureWindow_private_offset;
static gpointer are_you_sure_window_parent_class = NULL;
static gint NibblesWindow_private_offset;
static gpointer nibbles_window_parent_class = NULL;
static gint NibblesWindowDelegateStack_private_offset;
static gpointer nibbles_window_delegate_stack_parent_class = NULL;
static gint NibblesWindowDelegateStackDelegateStackIterator_private_offset;
static gpointer nibbles_window_delegate_stack_delegate_stack_iterator_parent_class = NULL;
static gint FirstRun_private_offset;
static gpointer first_run_parent_class = NULL;

VALA_EXTERN GType setup_screen_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType are_you_sure_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AreYouSureWindow, g_object_unref)
VALA_EXTERN AreYouSureWindow* are_you_sure_window_new (GtkWindow* w,
                                           const gchar* line1,
                                           const gchar* line2,
                                           AreYouSureWindowAreYouSureResultFunction result_function,
                                           gpointer result_function_target);
VALA_EXTERN AreYouSureWindow* are_you_sure_window_construct (GType object_type,
                                                 GtkWindow* w,
                                                 const gchar* line1,
                                                 const gchar* line2,
                                                 AreYouSureWindowAreYouSureResultFunction result_function,
                                                 gpointer result_function_target);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda49_ (Block3Data* _data3_);
static gboolean ___lambda49__gtk_window_close_request (GtkWindow* _sender,
                                                gpointer self);
static void __lambda50_ (Block3Data* _data3_);
static void ___lambda50__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda51_ (Block3Data* _data3_);
static void ___lambda51__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void are_you_sure_window_finalize (GObject * obj);
static GType are_you_sure_window_get_type_once (void);
VALA_EXTERN GType nibbles_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindow, g_object_unref)
VALA_EXTERN GType players_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Players, g_object_unref)
VALA_EXTERN GType speed_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Speed, g_object_unref)
VALA_EXTERN GType board_progress_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoardProgress, g_object_unref)
VALA_EXTERN GType controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Controls, g_object_unref)
VALA_EXTERN GType scoreboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scoreboard, g_object_unref)
VALA_EXTERN GType transparent_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransparentContainer, g_object_unref)
VALA_EXTERN GType nibbles_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesView, g_object_unref)
VALA_EXTERN GType sound_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sound, g_object_unref)
static gpointer nibbles_window_delegate_stack_ref (gpointer instance);
static void nibbles_window_delegate_stack_unref (gpointer instance);
static GParamSpec* nibbles_window_param_spec_delegate_stack (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_window_value_set_delegate_stack (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_window_value_take_delegate_stack (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_window_value_get_delegate_stack (const GValue* value) G_GNUC_UNUSED ;
static GType nibbles_window_delegate_stack_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindowDelegateStack, nibbles_window_delegate_stack_unref)
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
static void nibbles_window_hamburger_cb (NibblesWindow* self);
static void _nibbles_window_hamburger_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void nibbles_window_new_game_cb (NibblesWindow* self);
static void _nibbles_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void nibbles_window_fullscreen_cb (NibblesWindow* self);
static void _nibbles_window_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void nibbles_window_pause_cb (NibblesWindow* self);
static void _nibbles_window_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void nibbles_window_scores_cb (NibblesWindow* self);
static void _nibbles_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static inline void nibbles_window_next_screen_cb (NibblesWindow* self);
static void _nibbles_window_next_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void nibbles_window_start_game (NibblesWindow* self);
static void _nibbles_window_start_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void nibbles_window_back_cb (NibblesWindow* self);
static void _nibbles_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static NibblesWindowDelegateStack* nibbles_window_delegate_stack_new (void);
static NibblesWindowDelegateStack* nibbles_window_delegate_stack_construct (GType object_type);
static void nibbles_window_overlay_add (NibblesWindow* self,
                                 GtkWidget* widget);
static gboolean nibbles_window_overlay_remove_all (NibblesWindow* self);
VALA_EXTERN NibblesWindow* nibbles_window_new (gint cli_start_level,
                                   SetupScreen start_screen);
VALA_EXTERN NibblesWindow* nibbles_window_construct (GType object_type,
                                         gint cli_start_level,
                                         SetupScreen start_screen);
VALA_EXTERN void nibbles_window_on_shutdown (NibblesWindow* self);
VALA_EXTERN gint nibbles_game_get_speed (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_fakes (NibblesGame* self);
static gboolean nibbles_window_countdown_cb (NibblesWindow* self);
VALA_EXTERN void nibbles_view_redraw (NibblesView* self,
                          gboolean AnimateStep);
VALA_EXTERN void nibbles_game_start (NibblesGame* self,
                         gboolean add_initial_bonus);
VALA_EXTERN gboolean nibbles_game_get_paused (NibblesGame* self);
static void nibbles_window_set_pause_button_label (NibblesWindow* self,
                                            gboolean paused);
VALA_EXTERN void nibbles_game_reset (NibblesGame* self,
                         gint start_level);
static gint nibbles_window_get_start_level (NibblesWindow* self);
VALA_EXTERN void nibbles_game_new_level (NibblesGame* self,
                             gint level_id);
VALA_EXTERN gint nibbles_game_get_current_level (NibblesGame* self);
VALA_EXTERN void scoreboard_clear (Scoreboard* self);
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
VALA_EXTERN void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name);
VALA_EXTERN gchar* nibbles_view_colorval_name_untranslated (gint colorval);
VALA_EXTERN void scoreboard_update (Scoreboard* self);
static void _scoreboard_update_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self);
VALA_EXTERN void nibbles_game_add_worms (NibblesGame* self);
static void nibbles_window_show_game_view (NibblesWindow* self);
static void nibbles_window_start_game_with_countdown (NibblesWindow* self);
static gboolean _nibbles_window_countdown_cb_gsource_func (gpointer self);
static void nibbles_window_restart_game (NibblesWindow* self);
static gboolean nibbles_window_fullscreen_active (NibblesWindow* self);
VALA_EXTERN gboolean nibbles_game_get_is_running (NibblesGame* self);
static gint nibbles_window_countdown_active (NibblesWindow* self);
static void nibbles_window_show_new_game_screen (NibblesWindow* self,
                                          gboolean after_first_run);
static void nibbles_window_show_new_game_dialog (NibblesWindow* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN void nibbles_game_stop (NibblesGame* self);
static void __lambda36_ (NibblesWindow* self,
                  const gchar* response);
static void ___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                             const gchar* response,
                                             gpointer self);
static void __lambda37_ (Block4Data* _data4_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda37__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void nibbles_game_set_paused (NibblesGame* self,
                              gboolean value);
static void nibbles_window_settings_changed_cb (NibblesWindow* self,
                                         const gchar* key);
VALA_EXTERN void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
VALA_EXTERN void sound_set_muted (Sound* self,
                      gboolean muted);
VALA_EXTERN void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
VALA_EXTERN void nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                              gboolean value);
VALA_EXTERN void nibbles_view_redraw_all (NibblesView* self);
static void nibbles_window_worm_settings_changed_cb (NibblesWindow* self,
                                              GSettings* changed_worm_settings,
                                              const gchar* key);
VALA_EXTERN gint nibbles_game_get_numworms (NibblesGame* self);
VALA_EXTERN void worm_properties_set_color (WormProperties* self,
                                gint value);
VALA_EXTERN void worm_properties_set_up (WormProperties* self,
                             guint value);
VALA_EXTERN void worm_properties_set_down (WormProperties* self,
                               guint value);
VALA_EXTERN void worm_properties_set_left (WormProperties* self,
                               guint value);
VALA_EXTERN void worm_properties_set_right (WormProperties* self,
                                guint value);
VALA_EXTERN void worm_properties_set_raw_up (WormProperties* self,
                                 gint value);
VALA_EXTERN gint worm_properties_get_raw_up (WormProperties* self);
static gint nibbles_window_get_raw_key (NibblesWindow* self,
                                 guint keyval);
VALA_EXTERN guint worm_properties_get_up (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_down (WormProperties* self,
                                   gint value);
VALA_EXTERN gint worm_properties_get_raw_down (WormProperties* self);
VALA_EXTERN guint worm_properties_get_down (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_left (WormProperties* self,
                                   gint value);
VALA_EXTERN gint worm_properties_get_raw_left (WormProperties* self);
VALA_EXTERN guint worm_properties_get_left (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_right (WormProperties* self,
                                    gint value);
VALA_EXTERN gint worm_properties_get_raw_right (WormProperties* self);
VALA_EXTERN guint worm_properties_get_right (WormProperties* self);
VALA_EXTERN gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_window_update_start_game_action (NibblesWindow* self);
static void nibbles_window_show_board_progress_screen (NibblesWindow* self);
static void nibbles_window_show_speed_screen (NibblesWindow* self);
static void nibbles_window_leave_speed_screen (NibblesWindow* self);
static void nibbles_window_show_controls_screen (NibblesWindow* self);
static void nibbles_window_set_headerbar_title (NibblesWindow* self,
                                         const gchar* title);
VALA_EXTERN void board_progress_get_values (BoardProgress* self,
                                gint* progress,
                                gint* level);
VALA_EXTERN void nibbles_game_set_progress (NibblesGame* self,
                                gint value);
VALA_EXTERN void nibbles_game_set_start_level (NibblesGame* self,
                                   gint value);
VALA_EXTERN void players_get_values (Players* self,
                         gint* players_number,
                         gint* number_of_ais);
VALA_EXTERN void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
VALA_EXTERN void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
VALA_EXTERN void speed_get_values (Speed* self,
                       gint* speed,
                       gboolean* fakes);
VALA_EXTERN void controls_clean (Controls* self);
VALA_EXTERN void nibbles_game_create_worms (NibblesGame* self,
                                GeeArrayList* worm_settings);
VALA_EXTERN void controls_prepare (Controls* self,
                       GeeLinkedList* worms,
                       GeeHashMap* worms_props,
                       GeeList* worm_settings);
static gulong nibbles_window_get_category_index (NibblesWindow* self,
                                          const gchar* key);
static GamesScoresCategory* nibbles_window_get_category (NibblesWindow* self,
                                                  const gchar* key);
static void _vala_array_add7 (GamesScoresCategory** * array,
                       gint* length,
                       gint* size,
                       GamesScoresCategory* value);
static void nibbles_window_create_scores (NibblesWindow* self);
static GamesScoresCategory* _nibbles_window_get_category_games_scores_context_category_request_func (const gchar* category_key,
                                                                                              gpointer self);
static gboolean __lambda39_ (NibblesWindow* self,
                      GamesScoresCategory* a,
                      GamesScoresCategory* b);
static gboolean ___lambda39__games_scores_context_is_lower_order_category_func (GamesScoresCategory* a,
                                                                         GamesScoresCategory* b,
                                                                         gpointer self);
static gchar* nibbles_window_get_scores_category_key (NibblesWindow* self,
                                               gint speed,
                                               gboolean fakes,
                                               gint board_progress,
                                               gint start_level);
static void nibbles_window_log_score_cb (NibblesWindow* self,
                                  gint score,
                                  gint level_reached);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN gint nibbles_game_get_progress (NibblesGame* self);
VALA_EXTERN gint nibbles_game_get_start_level (NibblesGame* self);
static void nibbles_window_game_over (NibblesWindow* self,
                               gint score,
                               glong lowest_high_score,
                               gint level_reached);
static void __lambda40_ (Block5Data* _data5_,
                  GObject* object,
                  GAsyncResult* _result_);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda38_ (Block6Data* _data6_);
static void ___lambda38__games_scores_context_dialog_closed (GamesScoresContext* _sender,
                                                      gpointer self);
static void nibbles_window_level_completed_cb (NibblesWindow* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda41_ (NibblesWindow* self);
static void ___lambda41__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda42_ (Block7Data* _data7_);
static gboolean ___lambda42__gsource_func (gpointer self);
VALA_EXTERN GType nibbles_game_estatus_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NibblesGameeStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                                      const NibblesGameeStatus * s2);
static gint nibbles_window_get_cli_start_level (NibblesWindow* self);
static void nibbles_window_set_cli_start_level (NibblesWindow* self,
                                         gint value);
VALA_EXTERN gint nibbles_window_get_progress (NibblesWindow* self);
VALA_EXTERN void nibbles_window_set_progress (NibblesWindow* self,
                                  gint value);
static SetupScreen nibbles_window_get_start_screen (NibblesWindow* self);
static void nibbles_window_set_start_screen (NibblesWindow* self,
                                      SetupScreen value);
VALA_EXTERN gboolean nibbles_window_get_game_paused (NibblesWindow* self);
static void nibbles_window_set_game_paused (NibblesWindow* self,
                                     gboolean value);
static GType nibbles_window_delegate_stack_node_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NibblesWindowDelegateStackNode* nibbles_window_delegate_stack_node_dup (const NibblesWindowDelegateStackNode* self);
static void nibbles_window_delegate_stack_node_free (NibblesWindowDelegateStackNode* self);
static void nibbles_window_delegate_stack_node_copy (const NibblesWindowDelegateStackNode* self,
                                              NibblesWindowDelegateStackNode* dest);
static void nibbles_window_delegate_stack_node_destroy (NibblesWindowDelegateStackNode* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (NibblesWindowDelegateStackNode, nibbles_window_delegate_stack_node_destroy)
static void nibbles_window_delegate_stack_push (NibblesWindowDelegateStack* self,
                                         KeypressHandlerFunction handler,
                                         gpointer handler_target);
static gboolean nibbles_window_delegate_stack_pop (NibblesWindowDelegateStack* self);
static void nibbles_window_delegate_stack_remove (NibblesWindowDelegateStack* self,
                                           KeypressHandlerFunction handler,
                                           gpointer handler_target);
static gpointer nibbles_window_delegate_stack_delegate_stack_iterator_ref (gpointer instance);
static void nibbles_window_delegate_stack_delegate_stack_iterator_unref (gpointer instance);
static GParamSpec* nibbles_window_delegate_stack_param_spec_delegate_stack_iterator (const gchar* name,
                                                                              const gchar* nick,
                                                                              const gchar* blurb,
                                                                              GType object_type,
                                                                              GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_window_delegate_stack_value_set_delegate_stack_iterator (GValue* value,
                                                                      gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_window_delegate_stack_value_take_delegate_stack_iterator (GValue* value,
                                                                       gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_window_delegate_stack_value_get_delegate_stack_iterator (const GValue* value) G_GNUC_UNUSED ;
VALA_EXTERN GType nibbles_window_delegate_stack_delegate_stack_iterator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindowDelegateStackDelegateStackIterator, nibbles_window_delegate_stack_delegate_stack_iterator_unref)
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_iterator (NibblesWindowDelegateStack* self);
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_delegate_stack_iterator_new (NibblesWindowDelegateStack* p);
static NibblesWindowDelegateStackDelegateStackIterator* nibbles_window_delegate_stack_delegate_stack_iterator_construct (GType object_type,
                                                                                                                  NibblesWindowDelegateStack* p);
static gboolean nibbles_window_delegate_stack_delegate_stack_iterator_next (NibblesWindowDelegateStackDelegateStackIterator* self);
static KeypressHandlerFunction nibbles_window_delegate_stack_delegate_stack_iterator_get (NibblesWindowDelegateStackDelegateStackIterator* self,
                                                                                   gpointer* result_target);
static void nibbles_window_delegate_stack_delegate_stack_iterator_finalize (NibblesWindowDelegateStackDelegateStackIterator * obj);
static GType nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once (void);
static void nibbles_window_delegate_stack_finalize (NibblesWindowDelegateStack * obj);
static GType nibbles_window_delegate_stack_get_type_once (void);
static GObject * nibbles_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _nibbles_window_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self);
static void _nibbles_window_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                                  const gchar* key,
                                                                  gpointer self);
static void _nibbles_window___lambda43_ (NibblesWindow* self);
static void __nibbles_window___lambda43__gtk_popover_closed (GtkPopover* _sender,
                                                      gpointer self);
static gboolean _nibbles_window___lambda44_ (NibblesWindow* self,
                                      GtkEventControllerKey* controller,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType state);
static gboolean __nibbles_window___lambda44__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self);
static void _nibbles_window___lambda45_ (NibblesWindow* self);
static void __nibbles_window___lambda45__gtk_event_controller_key_im_update (GtkEventControllerKey* _sender,
                                                                      gpointer self);
VALA_EXTERN Sound* sound_new (gboolean is_muted);
VALA_EXTERN Sound* sound_construct (GType object_type,
                        gboolean is_muted);
VALA_EXTERN NibblesGame* nibbles_game_new (gint start_level,
                               gint speed,
                               gint gamedelay,
                               gboolean fakes,
                               gboolean three_dimensional_view,
                               guint8 width,
                               guint8 height,
                               gboolean no_random);
VALA_EXTERN NibblesGame* nibbles_game_construct (GType object_type,
                                     gint start_level,
                                     gint speed,
                                     gint gamedelay,
                                     gboolean fakes,
                                     gboolean three_dimensional_view,
                                     guint8 width,
                                     guint8 height,
                                     gboolean no_random);
static void _nibbles_window_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                          gint score,
                                                          gint level_reached,
                                                          gpointer self);
static void _nibbles_window_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                                      gpointer self);
VALA_EXTERN void sound_connect_signal (Sound* self,
                           NibblesGame* game);
static gchar* _nibbles_window___lambda46_ (NibblesWindow* self);
static gchar* __nibbles_window___lambda46__nibbles_game_get_pkgdatadir (NibblesGame* _sender,
                                                                 gpointer self);
static gboolean _nibbles_window___lambda47_ (NibblesWindow* self,
                                      KeypressHandlerFunction handler,
                                      gpointer handler_target);
static gboolean __nibbles_window___lambda47__nibbles_game_add_keypress_handler (NibblesGame* _sender,
                                                                         KeypressHandlerFunction keypress_handler,
                                                                         gpointer keypress_handler_target,
                                                                         gpointer self);
static gint _nibbles_window_countdown_active_nibbles_view_countdown_active_function (gpointer self);
static gboolean _nibbles_window_fullscreen_active_nibbles_view_fullscreen_active_function (gpointer self);
VALA_EXTERN NibblesView* nibbles_view_new (NibblesGame* game,
                               NibblesViewCountdownActiveFunction countdown_active,
                               gpointer countdown_active_target,
                               NibblesViewFullscreenActiveFunction fullscreen_active,
                               gpointer fullscreen_active_target);
VALA_EXTERN NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game,
                                     NibblesViewCountdownActiveFunction countdown_active,
                                     gpointer countdown_active_target,
                                     NibblesViewFullscreenActiveFunction fullscreen_active,
                                     gpointer fullscreen_active_target);
VALA_EXTERN void players_set_values (Players* self,
                         gint players_number,
                         gint number_of_ais);
VALA_EXTERN void board_progress_set_values (BoardProgress* self,
                                gint progress,
                                gint level);
VALA_EXTERN void speed_set_values (Speed* self,
                       gint speed,
                       gboolean fakes);
static void _nibbles_window___lambda48_ (NibblesWindow* self,
                                  KeypressHandlerFunction handler,
                                  gpointer handler_target);
static void __nibbles_window___lambda48__controls_add_keypress_handler (Controls* _sender,
                                                                 KeypressHandlerFunction handler,
                                                                 gpointer handler_target,
                                                                 gpointer self);
VALA_EXTERN GType first_run_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FirstRun, g_object_unref)
VALA_EXTERN FirstRun* first_run_new (void);
VALA_EXTERN FirstRun* first_run_construct (GType object_type);
static void nibbles_window_finalize (GObject * obj);
static GType nibbles_window_get_type_once (void);
static void _vala_nibbles_window_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_nibbles_window_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static GObject * first_run_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void first_run_finalize (GObject * obj);
static GType first_run_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_WINDOW_menu_entries[8] = {{"hamburger", _nibbles_window_hamburger_cb_gsimple_action_activate_callback}, {"new-game", _nibbles_window_new_game_cb_gsimple_action_activate_callback}, {"fullscreen", _nibbles_window_fullscreen_cb_gsimple_action_activate_callback}, {"pause", _nibbles_window_pause_cb_gsimple_action_activate_callback}, {"scores", _nibbles_window_scores_cb_gsimple_action_activate_callback}, {"next-screen", _nibbles_window_next_screen_cb_gsimple_action_activate_callback}, {"start-game", _nibbles_window_start_game_gsimple_action_activate_callback}, {"back", _nibbles_window_back_cb_gsimple_action_activate_callback}};

 G_GNUC_NO_INLINE static GType
setup_screen_get_type_once (void)
{
	static const GEnumValue values[] = {{SETUP_SCREEN_USUAL, "SETUP_SCREEN_USUAL", "usual"}, {SETUP_SCREEN_SPEED, "SETUP_SCREEN_SPEED", "speed"}, {SETUP_SCREEN_CONTROLS, "SETUP_SCREEN_CONTROLS", "controls"}, {SETUP_SCREEN_GAME, "SETUP_SCREEN_GAME", "game"}, {0, NULL, NULL}};
	GType setup_screen_type_id;
	setup_screen_type_id = g_enum_register_static ("SetupScreen", values);
	return setup_screen_type_id;
}

GType
setup_screen_get_type (void)
{
	static gsize setup_screen_type_id__once = 0;
	if (g_once_init_enter (&setup_screen_type_id__once)) {
		GType setup_screen_type_id;
		setup_screen_type_id = setup_screen_get_type_once ();
		g_once_init_leave (&setup_screen_type_id__once, setup_screen_type_id);
	}
	return setup_screen_type_id__once;
}

static inline gpointer
are_you_sure_window_get_instance_private (AreYouSureWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AreYouSureWindow_private_offset);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AreYouSureWindow* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda49_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	gboolean result;
	self = _data3_->self;
	_data3_->result_function (FALSE, _data3_->result_function_target);
	result = FALSE;
	return result;
}

static gboolean
___lambda49__gtk_window_close_request (GtkWindow* _sender,
                                       gpointer self)
{
	gboolean result;
	result = __lambda49_ (self);
	return result;
}

static void
__lambda50_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	self = _data3_->self;
	_data3_->result_function (FALSE, _data3_->result_function_target);
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda50__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda50_ (self);
}

static void
__lambda51_ (Block3Data* _data3_)
{
	AreYouSureWindow* self;
	self = _data3_->self;
	_data3_->result_function (TRUE, _data3_->result_function_target);
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda51__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda51_ (self);
}

AreYouSureWindow*
are_you_sure_window_construct (GType object_type,
                               GtkWindow* w,
                               const gchar* line1,
                               const gchar* line2,
                               AreYouSureWindowAreYouSureResultFunction result_function,
                               gpointer result_function_target)
{
	AreYouSureWindow * self = NULL;
	Block3Data* _data3_;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_val_if_fail (w != NULL, NULL);
	g_return_val_if_fail (line1 != NULL, NULL);
	g_return_val_if_fail (line2 != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->result_function = result_function;
	_data3_->result_function_target = result_function_target;
	self = (AreYouSureWindow*) g_object_new (object_type, NULL);
	_data3_->self = g_object_ref (self);
	gtk_window_set_transient_for ((GtkWindow*) self, w);
	_tmp0_ = self->priv->line_one;
	gtk_label_set_label (_tmp0_, line1);
	_tmp1_ = self->priv->line_two;
	gtk_label_set_label (_tmp1_, line2);
	(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
	self->priv->result_function = NULL;
	self->priv->result_function_target = NULL;
	self->priv->result_function_target_destroy_notify = NULL;
	self->priv->result_function = (AreYouSureWindowAreYouSureResultFunction) _data3_->result_function;
	self->priv->result_function_target = _data3_->result_function_target;
	self->priv->result_function_target_destroy_notify = NULL;
	g_signal_connect_data ((GtkWindow*) self, "close-request", (GCallback) ___lambda49__gtk_window_close_request, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp2_ = self->priv->button_no;
	g_signal_connect_data (_tmp2_, "clicked", (GCallback) ___lambda50__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp3_ = self->priv->button_yes;
	g_signal_connect_data (_tmp3_, "clicked", (GCallback) ___lambda51__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

AreYouSureWindow*
are_you_sure_window_new (GtkWindow* w,
                         const gchar* line1,
                         const gchar* line2,
                         AreYouSureWindowAreYouSureResultFunction result_function,
                         gpointer result_function_target)
{
	return are_you_sure_window_construct (TYPE_ARE_YOU_SURE_WINDOW, w, line1, line2, result_function, result_function_target);
}

static void
are_you_sure_window_class_init (AreYouSureWindowClass * klass,
                                gpointer klass_data)
{
	are_you_sure_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AreYouSureWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = are_you_sure_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/are-you-sure.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "line_one", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, line_one));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "line_two", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, line_two));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_no", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, button_no));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_yes", FALSE, AreYouSureWindow_private_offset + G_STRUCT_OFFSET (AreYouSureWindowPrivate, button_yes));
}

static void
are_you_sure_window_instance_init (AreYouSureWindow * self,
                                   gpointer klass)
{
	self->priv = are_you_sure_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
are_you_sure_window_finalize (GObject * obj)
{
	AreYouSureWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ARE_YOU_SURE_WINDOW, AreYouSureWindow);
	(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
	self->priv->result_function = NULL;
	self->priv->result_function_target = NULL;
	self->priv->result_function_target_destroy_notify = NULL;
	G_OBJECT_CLASS (are_you_sure_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
are_you_sure_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AreYouSureWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) are_you_sure_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AreYouSureWindow), 0, (GInstanceInitFunc) are_you_sure_window_instance_init, NULL };
	GType are_you_sure_window_type_id;
	are_you_sure_window_type_id = g_type_register_static (gtk_window_get_type (), "AreYouSureWindow", &g_define_type_info, 0);
	AreYouSureWindow_private_offset = g_type_add_instance_private (are_you_sure_window_type_id, sizeof (AreYouSureWindowPrivate));
	return are_you_sure_window_type_id;
}

GType
are_you_sure_window_get_type (void)
{
	static gsize are_you_sure_window_type_id__once = 0;
	if (g_once_init_enter (&are_you_sure_window_type_id__once)) {
		GType are_you_sure_window_type_id;
		are_you_sure_window_type_id = are_you_sure_window_get_type_once ();
		g_once_init_leave (&are_you_sure_window_type_id__once, are_you_sure_window_type_id);
	}
	return are_you_sure_window_type_id__once;
}

static inline gpointer
nibbles_window_get_instance_private (NibblesWindow* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindow_private_offset);
}

static void
_nibbles_window_hamburger_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	nibbles_window_hamburger_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	nibbles_window_new_game_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	nibbles_window_fullscreen_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	nibbles_window_pause_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	nibbles_window_scores_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_next_screen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	nibbles_window_next_screen_cb ((NibblesWindow*) self);
}

static void
_nibbles_window_start_game_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	nibbles_window_start_game ((NibblesWindow*) self);
}

static void
_nibbles_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	nibbles_window_back_cb ((NibblesWindow*) self);
}

static void
nibbles_window_overlay_add (NibblesWindow* self,
                            GtkWidget* widget)
{
	GeeArrayList* _tmp0_;
	GtkOverlay* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->overlay_members;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, widget);
	_tmp1_ = self->priv->overlay;
	gtk_overlay_add_overlay (_tmp1_, widget);
}

static gboolean
nibbles_window_overlay_remove_all (NibblesWindow* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->overlay_members;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	} else {
		{
			gint i = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			_tmp3_ = self->priv->overlay_members;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			i = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GtkOverlay* _tmp8_;
					GeeArrayList* _tmp9_;
					gpointer _tmp10_;
					GtkWidget* _tmp11_;
					GeeArrayList* _tmp12_;
					gpointer _tmp13_;
					GtkWidget* _tmp14_;
					if (!_tmp6_) {
						gint _tmp7_;
						i = i - 1;
						_tmp7_ = i;
					}
					_tmp6_ = FALSE;
					if (!(i > 0)) {
						break;
					}
					_tmp8_ = self->priv->overlay;
					_tmp9_ = self->priv->overlay_members;
					_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, i - 1);
					_tmp11_ = (GtkWidget*) _tmp10_;
					gtk_overlay_remove_overlay (_tmp8_, _tmp11_);
					_g_object_unref0 (_tmp11_);
					_tmp12_ = self->priv->overlay_members;
					_tmp13_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp12_, i - 1);
					_tmp14_ = (GtkWidget*) _tmp13_;
					_g_object_unref0 (_tmp14_);
				}
			}
		}
		result = TRUE;
		return result;
	}
}

NibblesWindow*
nibbles_window_construct (GType object_type,
                          gint cli_start_level,
                          SetupScreen start_screen)
{
	NibblesWindow * self = NULL;
	self = (NibblesWindow*) g_object_new (object_type, "cli-start-level", cli_start_level, "start-screen", start_screen, NULL);
	return self;
}

NibblesWindow*
nibbles_window_new (gint cli_start_level,
                    SetupScreen start_screen)
{
	return nibbles_window_construct (TYPE_NIBBLES_WINDOW, cli_start_level, start_screen);
}

void
nibbles_window_on_shutdown (NibblesWindow* self)
{
	GSettings* _tmp0_;
	gint window_width = 0;
	gint window_height = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	NibblesGame* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GSettings* _tmp12_;
	NibblesGame* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GSettings* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	gtk_window_get_default_size ((GtkWindow*) self, &_tmp1_, &_tmp2_);
	window_width = _tmp1_;
	window_height = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_settings_set_int (_tmp3_, "window-width", window_width);
	_tmp4_ = self->priv->settings;
	g_settings_set_int (_tmp4_, "window-height", window_height);
	_tmp5_ = self->priv->settings;
	g_object_get ((GtkWindow*) self, "maximized", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp5_, "window-is-maximized", _tmp7_);
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->game;
	_tmp10_ = nibbles_game_get_speed (_tmp9_);
	_tmp11_ = _tmp10_;
	g_settings_set_int (_tmp8_, "speed", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = self->priv->game;
	_tmp14_ = nibbles_game_get_fakes (_tmp13_);
	_tmp15_ = _tmp14_;
	g_settings_set_boolean (_tmp12_, "fakes", _tmp15_);
	_tmp16_ = self->priv->settings;
	g_settings_apply (_tmp16_);
}

static gboolean
nibbles_window_countdown_cb (NibblesWindow* self)
{
	gint _tmp0_;
	NibblesView* _tmp1_;
	NibblesGame* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->seconds;
	self->priv->seconds = _tmp0_ - 1;
	_tmp1_ = self->priv->view;
	nibbles_view_redraw (_tmp1_, FALSE);
	_tmp2_ = self->priv->game;
	g_signal_emit_by_name (_tmp2_, "play-sound", "gobble");
	if (self->priv->seconds == 0) {
		NibblesGame* _tmp3_;
		GSimpleAction* _tmp4_;
		_tmp3_ = self->priv->game;
		nibbles_game_start (_tmp3_, TRUE);
		_tmp4_ = self->priv->pause_action;
		g_simple_action_set_enabled (_tmp4_, TRUE);
		self->priv->countdown_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	result = G_SOURCE_CONTINUE;
	return result;
}

static void
_scoreboard_update_g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self)
{
	scoreboard_update ((Scoreboard*) self);
}

static void
nibbles_window_start_game (NibblesWindow* self)
{
	GSettings* _tmp0_;
	NibblesGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	NibblesGame* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NibblesGame* _tmp7_;
	NibblesGame* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Scoreboard* _tmp11_;
	NibblesGame* _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_boolean (_tmp0_, "first-run", FALSE);
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		nibbles_window_set_pause_button_label (self, FALSE);
	}
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_window_get_start_level (self);
	_tmp6_ = _tmp5_;
	nibbles_game_reset (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->game;
	_tmp8_ = self->priv->game;
	_tmp9_ = nibbles_game_get_current_level (_tmp8_);
	_tmp10_ = _tmp9_;
	nibbles_game_new_level (_tmp7_, _tmp10_);
	_tmp11_ = self->priv->scoreboard;
	scoreboard_clear (_tmp11_);
	{
		GeeLinkedList* _worm_list = NULL;
		NibblesGame* _tmp12_;
		GeeLinkedList* _tmp13_;
		GeeLinkedList* _tmp14_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _worm_index = 0;
		_tmp12_ = self->priv->game;
		_tmp13_ = nibbles_game_get_worms (_tmp12_);
		_tmp14_ = _tmp13_;
		_worm_list = _tmp14_;
		_tmp15_ = _worm_list;
		_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_worm_size = _tmp17_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp20_;
			gpointer _tmp21_;
			gint color = 0;
			NibblesGame* _tmp22_;
			GeeHashMap* _tmp23_;
			GeeHashMap* _tmp24_;
			Worm* _tmp25_;
			gpointer _tmp26_;
			WormProperties* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			Scoreboard* _tmp31_;
			Worm* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			Worm* _tmp35_;
			Scoreboard* _tmp36_;
			Worm* _tmp37_;
			Scoreboard* _tmp38_;
			_worm_index = _worm_index + 1;
			_tmp18_ = _worm_index;
			_tmp19_ = _worm_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _worm_list;
			_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _worm_index);
			worm = (Worm*) _tmp21_;
			_tmp22_ = self->priv->game;
			_tmp23_ = nibbles_game_get_worm_props (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = worm;
			_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
			_tmp27_ = (WormProperties*) _tmp26_;
			_tmp28_ = worm_properties_get_color (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_;
			_g_object_unref0 (_tmp27_);
			color = _tmp30_;
			_tmp31_ = self->priv->scoreboard;
			_tmp32_ = worm;
			_tmp33_ = nibbles_view_colorval_name_untranslated (color);
			_tmp34_ = _tmp33_;
			scoreboard_register (_tmp31_, _tmp32_, _tmp34_);
			_g_free0 (_tmp34_);
			_tmp35_ = worm;
			_tmp36_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp35_, "notify::lives", (GCallback) _scoreboard_update_g_object_notify, _tmp36_, 0);
			_tmp37_ = worm;
			_tmp38_ = self->priv->scoreboard;
			g_signal_connect_object ((GObject*) _tmp37_, "notify::score", (GCallback) _scoreboard_update_g_object_notify, _tmp38_, 0);
			_g_object_unref0 (worm);
		}
	}
	_tmp39_ = self->priv->game;
	nibbles_game_add_worms (_tmp39_);
	nibbles_window_show_game_view (self);
	nibbles_window_start_game_with_countdown (self);
}

static gboolean
_nibbles_window_countdown_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = nibbles_window_countdown_cb ((NibblesWindow*) self);
	return result;
}

static void
nibbles_window_start_game_with_countdown (NibblesWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	NibblesView* _tmp2_;
	NibblesGame* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp1_, TRUE);
	self->priv->seconds = NIBBLES_WINDOW_COUNTDOWN_TIME;
	_tmp2_ = self->priv->view;
	nibbles_view_redraw (_tmp2_, FALSE);
	_tmp3_ = self->priv->game;
	g_signal_emit_by_name (_tmp3_, "play-sound", "gobble");
	self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_window_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
}

static void
nibbles_window_restart_game (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NibblesGame* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_current_level (_tmp1_);
	_tmp3_ = _tmp2_;
	nibbles_game_new_level (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->game;
	nibbles_game_add_worms (_tmp4_);
	nibbles_window_start_game_with_countdown (self);
}

static void
nibbles_window_hamburger_cb (NibblesWindow* self)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!nibbles_window_fullscreen_active (self)) {
		GtkMenuButton* _tmp1_;
		_tmp1_ = self->priv->hamburger_menu;
		_tmp0_ = !gtk_menu_button_get_active (_tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenuButton* _tmp2_;
		_tmp2_ = self->priv->hamburger_menu;
		gtk_menu_button_popup (_tmp2_);
	}
}

static void
nibbles_window_new_game_cb (NibblesWindow* self)
{
	gchar* child_name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	static GQuark _tmp5_label4 = 0;
	static GQuark _tmp5_label5 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	child_name = _tmp2_;
	_tmp3_ = child_name;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if ((((_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("first-run")))) || (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("number_of_players"))))) || (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("board-progress"))))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("speed"))))) {
		switch (0) {
			default:
			{
				nibbles_window_next_screen_cb (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				nibbles_window_start_game (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				NibblesGame* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = self->priv->game;
				_tmp10_ = nibbles_game_get_is_running (_tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_) {
					_tmp8_ = TRUE;
				} else {
					_tmp8_ = nibbles_window_countdown_active (self) > 0;
				}
				if (_tmp8_) {
					_tmp7_ = nibbles_window_fullscreen_active (self);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					nibbles_window_fullscreen_cb (self);
				} else {
					nibbles_window_overlay_remove_all (self);
					if (self->priv->end_of_game) {
						NibblesView* _tmp12_;
						_tmp12_ = self->priv->view;
						gtk_widget_set_visible ((GtkWidget*) _tmp12_, TRUE);
						self->priv->end_of_game = FALSE;
						nibbles_window_show_new_game_screen (self, FALSE);
					} else {
						if (!self->priv->dialog_visible) {
							nibbles_window_show_new_game_dialog (self);
						}
					}
				}
				break;
			}
		}
	}
	_g_free0 (child_name);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		NibblesWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda36_ (NibblesWindow* self,
             const gchar* response)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (response != NULL);
	self->priv->dialog_visible = FALSE;
	if (g_strcmp0 (response, "new-game") == 0) {
		nibbles_window_show_new_game_screen (self, FALSE);
	}
	if (g_strcmp0 (response, "new-game") != 0) {
		NibblesGame* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->game;
		_tmp2_ = nibbles_game_get_paused (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesView* _tmp5_;
		if (self->priv->seconds == 0) {
			NibblesGame* _tmp4_;
			_tmp4_ = self->priv->game;
			nibbles_game_start (_tmp4_, FALSE);
		} else {
			self->priv->countdown_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, _nibbles_window_countdown_cb_gsource_func, g_object_ref (self), g_object_unref);
		}
		_tmp5_ = self->priv->view;
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
}

static void
___lambda36__adw_alert_dialog_response (AdwAlertDialog* _sender,
                                        const gchar* response,
                                        gpointer self)
{
	__lambda36_ ((NibblesWindow*) self, response);
}

static void
__lambda37_ (Block4Data* _data4_,
             GObject* obj,
             GAsyncResult* res)
{
	NibblesWindow* self;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	adw_alert_dialog_choose_finish (_data4_->dialog, res);
}

static void
___lambda37__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda37_ (self, source_object, res);
	block4_data_unref (self);
}

static void
nibbles_window_show_new_game_dialog (NibblesWindow* self)
{
	Block4Data* _data4_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	AdwAlertDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	if (self->priv->countdown_id != ((guint) 0)) {
		g_source_remove (self->priv->countdown_id);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	_tmp4_ = (AdwAlertDialog*) adw_alert_dialog_new (_ ("New Game?"), _ ("If you start a new game, the current one will be lost"));
	g_object_ref_sink (_tmp4_);
	_data4_->dialog = _tmp4_;
	adw_alert_dialog_add_response (_data4_->dialog, "cancel", _ ("_Cancel"));
	adw_alert_dialog_add_response (_data4_->dialog, "new-game", _ ("_New Game"));
	adw_alert_dialog_set_response_appearance (_data4_->dialog, "new-game", ADW_RESPONSE_DESTRUCTIVE);
	g_signal_connect_object (_data4_->dialog, "response", (GCallback) ___lambda36__adw_alert_dialog_response, self, 0);
	adw_alert_dialog_choose (_data4_->dialog, (GtkWidget*) self, NULL, ___lambda37__gasync_ready_callback, block4_data_ref (_data4_));
	self->priv->dialog_visible = TRUE;
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
nibbles_window_fullscreen_cb (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		if (self->priv->fullscreen_mode) {
			AdwToolbarView* _tmp1_;
			AdwToolbarView* _tmp2_;
			GtkStack* _tmp3_;
			_tmp1_ = self->priv->toolbar;
			adw_toolbar_view_set_reveal_top_bars (_tmp1_, TRUE);
			_tmp2_ = self->priv->toolbar;
			adw_toolbar_view_set_reveal_bottom_bars (_tmp2_, TRUE);
			_tmp3_ = self->priv->statusbar_stack;
			gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
			gtk_window_unfullscreen ((GtkWindow*) self);
		} else {
			AdwToolbarView* _tmp4_;
			AdwToolbarView* _tmp5_;
			gboolean _tmp6_ = FALSE;
			NibblesGame* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			GtkStack* _tmp10_;
			gtk_window_fullscreen ((GtkWindow*) self);
			_tmp4_ = self->priv->toolbar;
			adw_toolbar_view_set_reveal_top_bars (_tmp4_, FALSE);
			_tmp5_ = self->priv->toolbar;
			adw_toolbar_view_set_reveal_bottom_bars (_tmp5_, FALSE);
			_tmp7_ = self->priv->game;
			_tmp8_ = nibbles_game_get_is_running (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				_tmp6_ = TRUE;
			} else {
				_tmp6_ = nibbles_window_countdown_active (self) > 0;
			}
			_tmp10_ = self->priv->statusbar_stack;
			gtk_widget_set_visible ((GtkWidget*) _tmp10_, !_tmp6_);
		}
		self->priv->fullscreen_mode = !self->priv->fullscreen_mode;
	}
}

static void
nibbles_window_pause_cb (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		NibblesGame* _tmp1_;
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		NibblesGame* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		NibblesGame* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp1_ = self->priv->game;
		_tmp2_ = self->priv->game;
		_tmp3_ = nibbles_game_get_is_running (_tmp2_);
		_tmp4_ = _tmp3_;
		nibbles_game_set_paused (_tmp1_, _tmp4_);
		_tmp5_ = self->priv->game;
		_tmp6_ = nibbles_game_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		nibbles_window_set_pause_button_label (self, _tmp7_);
		if (!nibbles_window_fullscreen_active (self)) {
			const gchar* _tmp8_ = NULL;
			NibblesGame* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			GtkStack* _tmp12_;
			_tmp9_ = self->priv->game;
			_tmp10_ = nibbles_game_get_paused (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				_tmp8_ = "paused";
			} else {
				_tmp8_ = "scoreboard";
			}
			_tmp12_ = self->priv->statusbar_stack;
			gtk_stack_set_visible_child_name (_tmp12_, _tmp8_);
		}
		_tmp13_ = self->priv->game;
		_tmp14_ = nibbles_game_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		if (!_tmp15_) {
			NibblesView* _tmp16_;
			_tmp16_ = self->priv->view;
			gtk_widget_grab_focus ((GtkWidget*) _tmp16_);
		}
	}
}

static void
nibbles_window_set_pause_button_label (NibblesWindow* self,
                                       gboolean paused)
{
	g_return_if_fail (self != NULL);
	if (paused) {
		GtkButton* _tmp0_;
		GtkButton* _tmp1_;
		_tmp0_ = self->priv->pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp0_, _ ("Resume"));
		_tmp1_ = self->priv->pause_button;
		gtk_button_set_icon_name (_tmp1_, "media-playback-start-symbolic");
	} else {
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		_tmp2_ = self->priv->pause_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Pause"));
		_tmp3_ = self->priv->pause_button;
		gtk_button_set_icon_name (_tmp3_, "media-playback-pause-symbolic");
	}
}

static void
nibbles_window_settings_changed_cb (NibblesWindow* self,
                                    const gchar* key)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp3_;
				GSettings* _tmp4_;
				_tmp3_ = self->priv->game;
				_tmp4_ = self->priv->settings;
				nibbles_game_set_speed (_tmp3_, g_settings_get_int (_tmp4_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("sound")))) {
		switch (0) {
			default:
			{
				Sound* _tmp5_;
				GSettings* _tmp6_;
				_tmp5_ = self->priv->sound;
				_tmp6_ = self->priv->settings;
				sound_set_muted (_tmp5_, !g_settings_get_boolean (_tmp6_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("fakes")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp7_;
				GSettings* _tmp8_;
				_tmp7_ = self->priv->game;
				_tmp8_ = self->priv->settings;
				nibbles_game_set_fakes (_tmp7_, g_settings_get_boolean (_tmp8_, key));
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("three-dimensional-view")))) {
		switch (0) {
			default:
			{
				NibblesGame* _tmp9_;
				GSettings* _tmp10_;
				NibblesView* _tmp11_;
				_tmp9_ = self->priv->game;
				_tmp10_ = self->priv->settings;
				nibbles_game_set_three_dimensional_view (_tmp9_, g_settings_get_boolean (_tmp10_, key));
				_tmp11_ = self->priv->view;
				if (NULL != _tmp11_) {
					NibblesView* _tmp12_;
					_tmp12_ = self->priv->view;
					nibbles_view_redraw_all (_tmp12_);
				}
				break;
			}
		}
	}
}

static void
nibbles_window_worm_settings_changed_cb (NibblesWindow* self,
                                         GSettings* changed_worm_settings,
                                         const gchar* key)
{
	NibblesGame* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeArrayList* _tmp5_;
	gint id = 0;
	GeeArrayList* _tmp6_;
	NibblesGame* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	Worm* worm = NULL;
	NibblesGame* _tmp10_;
	GeeLinkedList* _tmp11_;
	GeeLinkedList* _tmp12_;
	gpointer _tmp13_;
	WormProperties* properties = NULL;
	NibblesGame* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	Worm* _tmp17_;
	gpointer _tmp18_;
	const gchar* _tmp19_;
	GQuark _tmp21_ = 0U;
	static GQuark _tmp20_label0 = 0;
	static GQuark _tmp20_label1 = 0;
	static GQuark _tmp20_label2 = 0;
	static GQuark _tmp20_label3 = 0;
	static GQuark _tmp20_label4 = 0;
	static GQuark _tmp20_label5 = 0;
	static GQuark _tmp20_label6 = 0;
	static GQuark _tmp20_label7 = 0;
	static GQuark _tmp20_label8 = 0;
	NibblesGame* _tmp59_;
	GeeHashMap* _tmp60_;
	GeeHashMap* _tmp61_;
	Worm* _tmp62_;
	WormProperties* _tmp63_;
	NibblesGame* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_worm_settings != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_worm_props (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		return;
	}
	_tmp5_ = self->priv->worm_settings;
	_vala_assert (_tmp5_ != NULL, "worm_settings != null");
	_tmp6_ = self->priv->worm_settings;
	id = gee_abstract_list_index_of ((GeeAbstractList*) _tmp6_, changed_worm_settings);
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_numworms (_tmp7_);
	_tmp9_ = _tmp8_;
	if (id >= _tmp9_) {
		return;
	}
	_tmp10_ = self->priv->game;
	_tmp11_ = nibbles_game_get_worms (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, id);
	worm = (Worm*) _tmp13_;
	_tmp14_ = self->priv->game;
	_tmp15_ = nibbles_game_get_worm_props (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = worm;
	_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp16_, _tmp17_);
	properties = (WormProperties*) _tmp18_;
	_tmp19_ = key;
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("color")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp22_;
				_tmp22_ = properties;
				worm_properties_set_color (_tmp22_, g_settings_get_enum (changed_worm_settings, "color"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("key-up")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp23_;
				_tmp23_ = properties;
				worm_properties_set_up (_tmp23_, (guint) g_settings_get_int (changed_worm_settings, "key-up"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label2) ? _tmp20_label2 : (_tmp20_label2 = g_quark_from_static_string ("key-down")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp24_;
				_tmp24_ = properties;
				worm_properties_set_down (_tmp24_, (guint) g_settings_get_int (changed_worm_settings, "key-down"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label3) ? _tmp20_label3 : (_tmp20_label3 = g_quark_from_static_string ("key-left")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp25_;
				_tmp25_ = properties;
				worm_properties_set_left (_tmp25_, (guint) g_settings_get_int (changed_worm_settings, "key-left"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label4) ? _tmp20_label4 : (_tmp20_label4 = g_quark_from_static_string ("key-right")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp26_;
				_tmp26_ = properties;
				worm_properties_set_right (_tmp26_, (guint) g_settings_get_int (changed_worm_settings, "key-right"));
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label5) ? _tmp20_label5 : (_tmp20_label5 = g_quark_from_static_string ("key-up-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp27_;
				WormProperties* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp27_ = properties;
				worm_properties_set_raw_up (_tmp27_, g_settings_get_int (changed_worm_settings, "key-up-raw"));
				_tmp28_ = properties;
				_tmp29_ = worm_properties_get_raw_up (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ < 0) {
					WormProperties* _tmp31_;
					WormProperties* _tmp32_;
					guint _tmp33_;
					guint _tmp34_;
					_tmp31_ = properties;
					_tmp32_ = properties;
					_tmp33_ = worm_properties_get_up (_tmp32_);
					_tmp34_ = _tmp33_;
					worm_properties_set_raw_up (_tmp31_, nibbles_window_get_raw_key (self, _tmp34_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label6) ? _tmp20_label6 : (_tmp20_label6 = g_quark_from_static_string ("key-down-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp35_;
				WormProperties* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				_tmp35_ = properties;
				worm_properties_set_raw_down (_tmp35_, g_settings_get_int (changed_worm_settings, "key-down-raw"));
				_tmp36_ = properties;
				_tmp37_ = worm_properties_get_raw_down (_tmp36_);
				_tmp38_ = _tmp37_;
				if (_tmp38_ < 0) {
					WormProperties* _tmp39_;
					WormProperties* _tmp40_;
					guint _tmp41_;
					guint _tmp42_;
					_tmp39_ = properties;
					_tmp40_ = properties;
					_tmp41_ = worm_properties_get_down (_tmp40_);
					_tmp42_ = _tmp41_;
					worm_properties_set_raw_down (_tmp39_, nibbles_window_get_raw_key (self, _tmp42_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label7) ? _tmp20_label7 : (_tmp20_label7 = g_quark_from_static_string ("key-left-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp43_;
				WormProperties* _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				_tmp43_ = properties;
				worm_properties_set_raw_left (_tmp43_, g_settings_get_int (changed_worm_settings, "key-left-raw"));
				_tmp44_ = properties;
				_tmp45_ = worm_properties_get_raw_left (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_ < 0) {
					WormProperties* _tmp47_;
					WormProperties* _tmp48_;
					guint _tmp49_;
					guint _tmp50_;
					_tmp47_ = properties;
					_tmp48_ = properties;
					_tmp49_ = worm_properties_get_left (_tmp48_);
					_tmp50_ = _tmp49_;
					worm_properties_set_raw_left (_tmp47_, nibbles_window_get_raw_key (self, _tmp50_));
				}
				break;
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label8) ? _tmp20_label8 : (_tmp20_label8 = g_quark_from_static_string ("key-right-raw")))) {
		switch (0) {
			default:
			{
				WormProperties* _tmp51_;
				WormProperties* _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				_tmp51_ = properties;
				worm_properties_set_raw_right (_tmp51_, g_settings_get_int (changed_worm_settings, "key-right-raw"));
				_tmp52_ = properties;
				_tmp53_ = worm_properties_get_raw_right (_tmp52_);
				_tmp54_ = _tmp53_;
				if (_tmp54_ < 0) {
					WormProperties* _tmp55_;
					WormProperties* _tmp56_;
					guint _tmp57_;
					guint _tmp58_;
					_tmp55_ = properties;
					_tmp56_ = properties;
					_tmp57_ = worm_properties_get_right (_tmp56_);
					_tmp58_ = _tmp57_;
					worm_properties_set_raw_right (_tmp55_, nibbles_window_get_raw_key (self, _tmp58_));
				}
				break;
			}
		}
	}
	_tmp59_ = self->priv->game;
	_tmp60_ = nibbles_game_get_worm_props (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = worm;
	_tmp63_ = properties;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, _tmp62_, _tmp63_);
	_tmp64_ = self->priv->game;
	_tmp65_ = nibbles_game_get_numhumans (_tmp64_);
	_tmp66_ = _tmp65_;
	if (id < _tmp66_) {
		nibbles_window_update_start_game_action (self);
	}
	_g_object_unref0 (properties);
	_g_object_unref0 (worm);
}

static gint
nibbles_window_get_raw_key (NibblesWindow* self,
                            guint keyval)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkDisplay* _tmp0_;
	GdkKeymapKey* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gdk_display_get_default ();
	_tmp3_ = gdk_display_map_keyval (_tmp0_, keyval, &_tmp1_, &_tmp2_);
	keys = (g_free (keys), NULL);
	keys = _tmp1_;
	keys_length1 = _tmp2_;
	_keys_size_ = keys_length1;
	if (_tmp3_) {
		GdkKeymapKey* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = keys;
		_tmp4__length1 = keys_length1;
		if (_tmp4__length1 > 0) {
			GdkKeymapKey* _tmp5_;
			gint _tmp5__length1;
			GdkKeymapKey _tmp6_;
			_tmp5_ = keys;
			_tmp5__length1 = keys_length1;
			_tmp6_ = _tmp5_[0];
			result = (gint) _tmp6_.keycode;
			keys = (g_free (keys), NULL);
			return result;
		}
	}
	result = -1;
	keys = (g_free (keys), NULL);
	return result;
}

static inline void
nibbles_window_next_screen_cb (NibblesWindow* self)
{
	gchar* child_name = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	static GQuark _tmp5_label3 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	child_name = _tmp2_;
	_tmp3_ = child_name;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("first-run")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_new_game_screen (self, TRUE);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_board_progress_screen (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("board_progress")))) {
		switch (0) {
			default:
			{
				nibbles_window_show_speed_screen (self);
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				nibbles_window_leave_speed_screen (self);
				nibbles_window_show_controls_screen (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_free0 (child_name);
				return;
			}
		}
	}
	_g_free0 (child_name);
}

static void
nibbles_window_set_headerbar_title (NibblesWindow* self,
                                    const gchar* title)
{
	AdwHeaderBar* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = adw_header_bar_get_title_widget (_tmp0_);
	if (_tmp1_ == NULL) {
		AdwHeaderBar* _tmp2_;
		AdwWindowTitle* _tmp3_;
		AdwWindowTitle* _tmp4_;
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = (AdwWindowTitle*) adw_window_title_new (title, "");
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		adw_header_bar_set_title_widget (_tmp2_, (GtkWidget*) _tmp4_);
		_g_object_unref0 (_tmp4_);
	} else {
		AdwHeaderBar* _tmp5_;
		GtkWidget* _tmp6_;
		_tmp5_ = self->priv->headerbar;
		_tmp6_ = adw_header_bar_get_title_widget (_tmp5_);
		adw_window_title_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, adw_window_title_get_type (), AdwWindowTitle), title);
	}
}

static void
nibbles_window_show_new_game_screen (NibblesWindow* self,
                                     gboolean after_first_run)
{
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GSimpleAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkStack* _tmp11_;
	GtkStack* _tmp12_;
	g_return_if_fail (self != NULL);
	if (self->priv->countdown_id != ((guint) 0)) {
		g_source_remove (self->priv->countdown_id);
		self->priv->countdown_id = (guint) 0;
	}
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		NibblesGame* _tmp3_;
		_tmp3_ = self->priv->game;
		nibbles_game_stop (_tmp3_);
	}
	nibbles_window_set_headerbar_title (self, NIBBLES_PROGRAM_NAME);
	_tmp4_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp4_, TRUE);
	_tmp5_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp5_, FALSE);
	_tmp6_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp6_, TRUE);
	_tmp7_ = self->priv->new_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = self->priv->pause_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
	if (after_first_run) {
		GtkStack* _tmp9_;
		_tmp9_ = self->priv->main_stack;
		gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	} else {
		GtkStack* _tmp10_;
		_tmp10_ = self->priv->main_stack;
		gtk_stack_set_transition_type (_tmp10_, GTK_STACK_TRANSITION_TYPE_NONE);
	}
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "number_of_players");
	_tmp12_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp12_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
}

static void
nibbles_window_show_speed_screen (NibblesWindow* self)
{
	gint progress = 0;
	gint level = 0;
	BoardProgress* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	NibblesGame* _tmp3_;
	GSettings* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_progress;
	board_progress_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	progress = _tmp1_;
	level = _tmp2_;
	_tmp3_ = self->priv->game;
	nibbles_game_set_progress (_tmp3_, progress);
	if (progress == 2) {
		GSettings* _tmp4_;
		NibblesGame* _tmp5_;
		_tmp4_ = self->priv->settings;
		g_settings_set_int (_tmp4_, "start-level", level);
		_tmp5_ = self->priv->game;
		nibbles_game_set_start_level (_tmp5_, level);
	}
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "progress", progress);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "speed");
}

static void
nibbles_window_show_board_progress_screen (NibblesWindow* self)
{
	gint numhumans = 0;
	gint numai = 0;
	Players* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->players;
	players_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	numhumans = _tmp1_;
	numai = _tmp2_;
	_tmp3_ = self->priv->game;
	nibbles_game_set_numhumans (_tmp3_, numhumans);
	_tmp4_ = self->priv->game;
	nibbles_game_set_numai (_tmp4_, numai);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, "players", numhumans);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "ai", numai);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "board_progress");
}

static void
nibbles_window_leave_speed_screen (NibblesWindow* self)
{
	gint game_speed = 0;
	gboolean fakes = FALSE;
	Speed* _tmp0_;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	NibblesGame* _tmp3_;
	NibblesGame* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->speed;
	speed_get_values (_tmp0_, &_tmp1_, &_tmp2_);
	game_speed = _tmp1_;
	fakes = _tmp2_;
	_tmp3_ = self->priv->game;
	nibbles_game_set_speed (_tmp3_, game_speed);
	_tmp4_ = self->priv->game;
	nibbles_game_set_fakes (_tmp4_, fakes);
	_tmp5_ = self->priv->settings;
	g_settings_set_int (_tmp5_, "speed", game_speed);
	_tmp6_ = self->priv->settings;
	g_settings_set_boolean (_tmp6_, "fakes", fakes);
}

static void
nibbles_window_show_controls_screen (NibblesWindow* self)
{
	Controls* _tmp0_;
	NibblesGame* _tmp1_;
	GeeArrayList* _tmp2_;
	Controls* _tmp3_;
	NibblesGame* _tmp4_;
	GeeLinkedList* _tmp5_;
	GeeLinkedList* _tmp6_;
	NibblesGame* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeArrayList* _tmp10_;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->controls;
	controls_clean (_tmp0_);
	_tmp1_ = self->priv->game;
	_tmp2_ = self->priv->worm_settings;
	nibbles_game_create_worms (_tmp1_, _tmp2_);
	nibbles_window_update_start_game_action (self);
	_tmp3_ = self->priv->controls;
	_tmp4_ = self->priv->game;
	_tmp5_ = nibbles_game_get_worms (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->game;
	_tmp8_ = nibbles_game_get_worm_props (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->worm_settings;
	controls_prepare (_tmp3_, _tmp6_, _tmp9_, (GeeList*) _tmp10_);
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp11_, "controls");
}

static void
nibbles_window_update_start_game_action (NibblesWindow* self)
{
	GHashTable* keys = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSimpleAction* _tmp112_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	keys = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				NibblesGame* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				WormProperties* worm_prop = NULL;
				NibblesGame* _tmp8_;
				GeeHashMap* _tmp9_;
				GeeHashMap* _tmp10_;
				NibblesGame* _tmp11_;
				GeeLinkedList* _tmp12_;
				GeeLinkedList* _tmp13_;
				gpointer _tmp14_;
				Worm* _tmp15_;
				gpointer _tmp16_;
				WormProperties* _tmp17_;
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				WormProperties* _tmp31_;
				guint _tmp32_;
				guint _tmp33_;
				GHashTable* _tmp96_;
				WormProperties* _tmp97_;
				guint _tmp98_;
				guint _tmp99_;
				GHashTable* _tmp100_;
				WormProperties* _tmp101_;
				guint _tmp102_;
				guint _tmp103_;
				GHashTable* _tmp104_;
				WormProperties* _tmp105_;
				guint _tmp106_;
				guint _tmp107_;
				GHashTable* _tmp108_;
				WormProperties* _tmp109_;
				guint _tmp110_;
				guint _tmp111_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->game;
				_tmp6_ = nibbles_game_get_numhumans (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->game;
				_tmp9_ = nibbles_game_get_worm_props (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = self->priv->game;
				_tmp12_ = nibbles_game_get_worms (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, i);
				_tmp15_ = (Worm*) _tmp14_;
				_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp15_);
				_tmp17_ = (WormProperties*) _tmp16_;
				_g_object_unref0 (_tmp15_);
				worm_prop = _tmp17_;
				_tmp31_ = worm_prop;
				_tmp32_ = worm_properties_get_up (_tmp31_);
				_tmp33_ = _tmp32_;
				if (_tmp33_ == ((guint) 0)) {
					_tmp30_ = TRUE;
				} else {
					WormProperties* _tmp34_;
					guint _tmp35_;
					guint _tmp36_;
					_tmp34_ = worm_prop;
					_tmp35_ = worm_properties_get_down (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp30_ = _tmp36_ == ((guint) 0);
				}
				if (_tmp30_) {
					_tmp29_ = TRUE;
				} else {
					WormProperties* _tmp37_;
					guint _tmp38_;
					guint _tmp39_;
					_tmp37_ = worm_prop;
					_tmp38_ = worm_properties_get_left (_tmp37_);
					_tmp39_ = _tmp38_;
					_tmp29_ = _tmp39_ == ((guint) 0);
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					WormProperties* _tmp40_;
					guint _tmp41_;
					guint _tmp42_;
					_tmp40_ = worm_prop;
					_tmp41_ = worm_properties_get_right (_tmp40_);
					_tmp42_ = _tmp41_;
					_tmp28_ = _tmp42_ == ((guint) 0);
				}
				if (_tmp28_) {
					_tmp27_ = TRUE;
				} else {
					WormProperties* _tmp43_;
					guint _tmp44_;
					guint _tmp45_;
					WormProperties* _tmp46_;
					guint _tmp47_;
					guint _tmp48_;
					_tmp43_ = worm_prop;
					_tmp44_ = worm_properties_get_up (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = worm_prop;
					_tmp47_ = worm_properties_get_down (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp27_ = _tmp45_ == _tmp48_;
				}
				if (_tmp27_) {
					_tmp26_ = TRUE;
				} else {
					WormProperties* _tmp49_;
					guint _tmp50_;
					guint _tmp51_;
					WormProperties* _tmp52_;
					guint _tmp53_;
					guint _tmp54_;
					_tmp49_ = worm_prop;
					_tmp50_ = worm_properties_get_up (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = worm_prop;
					_tmp53_ = worm_properties_get_left (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp26_ = _tmp51_ == _tmp54_;
				}
				if (_tmp26_) {
					_tmp25_ = TRUE;
				} else {
					WormProperties* _tmp55_;
					guint _tmp56_;
					guint _tmp57_;
					WormProperties* _tmp58_;
					guint _tmp59_;
					guint _tmp60_;
					_tmp55_ = worm_prop;
					_tmp56_ = worm_properties_get_up (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = worm_prop;
					_tmp59_ = worm_properties_get_right (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp25_ = _tmp57_ == _tmp60_;
				}
				if (_tmp25_) {
					_tmp24_ = TRUE;
				} else {
					WormProperties* _tmp61_;
					guint _tmp62_;
					guint _tmp63_;
					WormProperties* _tmp64_;
					guint _tmp65_;
					guint _tmp66_;
					_tmp61_ = worm_prop;
					_tmp62_ = worm_properties_get_down (_tmp61_);
					_tmp63_ = _tmp62_;
					_tmp64_ = worm_prop;
					_tmp65_ = worm_properties_get_left (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp24_ = _tmp63_ == _tmp66_;
				}
				if (_tmp24_) {
					_tmp23_ = TRUE;
				} else {
					WormProperties* _tmp67_;
					guint _tmp68_;
					guint _tmp69_;
					WormProperties* _tmp70_;
					guint _tmp71_;
					guint _tmp72_;
					_tmp67_ = worm_prop;
					_tmp68_ = worm_properties_get_down (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = worm_prop;
					_tmp71_ = worm_properties_get_right (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp23_ = _tmp69_ == _tmp72_;
				}
				if (_tmp23_) {
					_tmp22_ = TRUE;
				} else {
					WormProperties* _tmp73_;
					guint _tmp74_;
					guint _tmp75_;
					WormProperties* _tmp76_;
					guint _tmp77_;
					guint _tmp78_;
					_tmp73_ = worm_prop;
					_tmp74_ = worm_properties_get_right (_tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = worm_prop;
					_tmp77_ = worm_properties_get_left (_tmp76_);
					_tmp78_ = _tmp77_;
					_tmp22_ = _tmp75_ == _tmp78_;
				}
				if (_tmp22_) {
					_tmp21_ = TRUE;
				} else {
					GHashTable* _tmp79_;
					WormProperties* _tmp80_;
					guint _tmp81_;
					guint _tmp82_;
					_tmp79_ = keys;
					_tmp80_ = worm_prop;
					_tmp81_ = worm_properties_get_up (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp21_ = g_hash_table_contains (_tmp79_, (gpointer) ((guintptr) _tmp82_));
				}
				if (_tmp21_) {
					_tmp20_ = TRUE;
				} else {
					GHashTable* _tmp83_;
					WormProperties* _tmp84_;
					guint _tmp85_;
					guint _tmp86_;
					_tmp83_ = keys;
					_tmp84_ = worm_prop;
					_tmp85_ = worm_properties_get_down (_tmp84_);
					_tmp86_ = _tmp85_;
					_tmp20_ = g_hash_table_contains (_tmp83_, (gpointer) ((guintptr) _tmp86_));
				}
				if (_tmp20_) {
					_tmp19_ = TRUE;
				} else {
					GHashTable* _tmp87_;
					WormProperties* _tmp88_;
					guint _tmp89_;
					guint _tmp90_;
					_tmp87_ = keys;
					_tmp88_ = worm_prop;
					_tmp89_ = worm_properties_get_left (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp19_ = g_hash_table_contains (_tmp87_, (gpointer) ((guintptr) _tmp90_));
				}
				if (_tmp19_) {
					_tmp18_ = TRUE;
				} else {
					GHashTable* _tmp91_;
					WormProperties* _tmp92_;
					guint _tmp93_;
					guint _tmp94_;
					_tmp91_ = keys;
					_tmp92_ = worm_prop;
					_tmp93_ = worm_properties_get_right (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp18_ = g_hash_table_contains (_tmp91_, (gpointer) ((guintptr) _tmp94_));
				}
				if (_tmp18_) {
					GSimpleAction* _tmp95_;
					_tmp95_ = self->priv->start_game_action;
					g_simple_action_set_enabled (_tmp95_, FALSE);
					_g_object_unref0 (worm_prop);
					_g_hash_table_unref0 (keys);
					return;
				}
				_tmp96_ = keys;
				_tmp97_ = worm_prop;
				_tmp98_ = worm_properties_get_up (_tmp97_);
				_tmp99_ = _tmp98_;
				g_hash_table_add (_tmp96_, (gpointer) ((guintptr) _tmp99_));
				_tmp100_ = keys;
				_tmp101_ = worm_prop;
				_tmp102_ = worm_properties_get_down (_tmp101_);
				_tmp103_ = _tmp102_;
				g_hash_table_add (_tmp100_, (gpointer) ((guintptr) _tmp103_));
				_tmp104_ = keys;
				_tmp105_ = worm_prop;
				_tmp106_ = worm_properties_get_left (_tmp105_);
				_tmp107_ = _tmp106_;
				g_hash_table_add (_tmp104_, (gpointer) ((guintptr) _tmp107_));
				_tmp108_ = keys;
				_tmp109_ = worm_prop;
				_tmp110_ = worm_properties_get_right (_tmp109_);
				_tmp111_ = _tmp110_;
				g_hash_table_add (_tmp108_, (gpointer) ((guintptr) _tmp111_));
				_g_object_unref0 (worm_prop);
			}
		}
	}
	_tmp112_ = self->priv->start_game_action;
	g_simple_action_set_enabled (_tmp112_, TRUE);
	_g_hash_table_unref0 (keys);
}

static void
nibbles_window_show_game_view (NibblesWindow* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	NibblesGame* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GtkStack* _tmp7_;
	GtkStack* _tmp8_;
	GtkStack* _tmp9_;
	NibblesView* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->pause_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_current_level (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf (_ ("Level %d"), _tmp4_);
	_tmp6_ = _tmp5_;
	nibbles_window_set_headerbar_title (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->main_stack;
	gtk_stack_set_visible_child_name (_tmp7_, "game_box");
	_tmp8_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp8_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_tmp9_ = self->priv->statusbar_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, !nibbles_window_fullscreen_active (self));
	_tmp10_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
}

static void
nibbles_window_back_cb (NibblesWindow* self)
{
	GtkStack* _tmp0_;
	gchar* child_name = NULL;
	GtkStack* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	static GQuark _tmp6_label3 = 0;
	static GQuark _tmp6_label4 = 0;
	static GQuark _tmp6_label5 = 0;
	GtkStack* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp0_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	_tmp1_ = self->priv->main_stack;
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	child_name = _tmp3_;
	_tmp4_ = child_name;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("first-run")))) {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("number_of_players")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string ("board_progress")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp8_;
				_tmp8_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp8_, "number_of_players");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label3) ? _tmp6_label3 : (_tmp6_label3 = g_quark_from_static_string ("speed")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp9_;
				_tmp9_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp9_, "board_progress");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label4) ? _tmp6_label4 : (_tmp6_label4 = g_quark_from_static_string ("controls")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp10_;
				_tmp10_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp10_, "speed");
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label5) ? _tmp6_label5 : (_tmp6_label5 = g_quark_from_static_string ("game_box")))) {
		switch (0) {
			default:
			{
				nibbles_window_new_game_cb (self);
				break;
			}
		}
	}
	_tmp11_ = self->priv->main_stack;
	gtk_stack_set_transition_type (_tmp11_, GTK_STACK_TRANSITION_TYPE_SLIDE_UP);
	_g_free0 (child_name);
}

static gulong
nibbles_window_get_category_index (NibblesWindow* self,
                                   const gchar* key)
{
	gulong i = 0UL;
	gulong result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (key != NULL, 0UL);
	{
		gboolean _tmp0_ = FALSE;
		i = (gulong) 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gchar** _tmp3_;
			gint _tmp3__length1;
			gint _tmp3__length2;
			gint _tmp4_;
			if (!_tmp0_) {
				gulong _tmp1_;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = self->priv->category_descriptions;
			_tmp3__length1 = self->priv->category_descriptions_length1;
			_tmp3__length2 = self->priv->category_descriptions_length2;
			_tmp4_ = _tmp3__length1;
			if (i < ((gulong) _tmp4_)) {
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				const gchar* _tmp6_;
				_tmp5_ = self->priv->category_descriptions;
				_tmp5__length1 = self->priv->category_descriptions_length1;
				_tmp5__length2 = self->priv->category_descriptions_length2;
				_tmp6_ = _tmp5_[(i * _tmp5__length2) + 0];
				_tmp2_ = g_strcmp0 (_tmp6_, key) != 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	result = i;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add7 (GamesScoresCategory** * array,
                  gint* length,
                  gint* size,
                  GamesScoresCategory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesScoresCategory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesScoresCategory*
nibbles_window_get_category (NibblesWindow* self,
                             const gchar* key)
{
	GamesScoresCategory** _tmp0_;
	gint _tmp0__length1;
	gulong i = 0UL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gint _tmp6_;
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->created_categories;
	_tmp0__length1 = self->priv->created_categories_length1;
	{
		GamesScoresCategory** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			GamesScoresCategory* _tmp1_;
			GamesScoresCategory* c = NULL;
			_tmp1_ = _g_object_ref0 (c_collection[c_it]);
			c = _tmp1_;
			{
				GamesScoresCategory* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = c;
				_tmp3_ = games_scores_category_get_key (_tmp2_);
				_tmp4_ = _tmp3_;
				if (g_strcmp0 (_tmp4_, key) == 0) {
					result = c;
					return result;
				}
				_g_object_unref0 (c);
			}
		}
	}
	i = nibbles_window_get_category_index (self, key);
	_tmp5_ = self->priv->category_descriptions;
	_tmp5__length1 = self->priv->category_descriptions_length1;
	_tmp5__length2 = self->priv->category_descriptions_length2;
	_tmp6_ = _tmp5__length1;
	if (i < ((gulong) _tmp6_)) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		gint _tmp7__length2;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		const gchar* _tmp10_;
		GamesScoresCategory* _tmp11_;
		GamesScoresCategory** _tmp12_;
		gint _tmp12__length1;
		GamesScoresCategory** _tmp13_;
		gint _tmp13__length1;
		GamesScoresCategory* _tmp14_;
		GamesScoresCategory* _tmp15_;
		_tmp7_ = self->priv->category_descriptions;
		_tmp7__length1 = self->priv->category_descriptions_length1;
		_tmp7__length2 = self->priv->category_descriptions_length2;
		_tmp8_ = _tmp7_[(i * _tmp7__length2) + 0];
		_tmp9_ = self->priv->category_descriptions;
		_tmp9__length1 = self->priv->category_descriptions_length1;
		_tmp9__length2 = self->priv->category_descriptions_length2;
		_tmp10_ = _tmp9_[(i * _tmp9__length2) + 1];
		_tmp11_ = games_scores_category_new (_tmp8_, _tmp10_);
		_vala_array_add7 (&self->priv->created_categories, &self->priv->created_categories_length1, &self->priv->_created_categories_size_, _tmp11_);
		_tmp12_ = self->priv->created_categories;
		_tmp12__length1 = self->priv->created_categories_length1;
		_tmp13_ = self->priv->created_categories;
		_tmp13__length1 = self->priv->created_categories_length1;
		_tmp14_ = _tmp12_[_tmp13__length1 - 1];
		_tmp15_ = _g_object_ref0 (_tmp14_);
		result = _tmp15_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static GamesScoresCategory*
_nibbles_window_get_category_games_scores_context_category_request_func (const gchar* category_key,
                                                                         gpointer self)
{
	GamesScoresCategory* result;
	result = nibbles_window_get_category ((NibblesWindow*) self, category_key);
	return result;
}

static gboolean
__lambda39_ (NibblesWindow* self,
             GamesScoresCategory* a,
             GamesScoresCategory* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = games_scores_category_get_key (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_scores_category_get_key (b);
	_tmp3_ = _tmp2_;
	result = nibbles_window_get_category_index (self, _tmp1_) < nibbles_window_get_category_index (self, _tmp3_);
	return result;
}

static gboolean
___lambda39__games_scores_context_is_lower_order_category_func (GamesScoresCategory* a,
                                                                GamesScoresCategory* b,
                                                                gpointer self)
{
	gboolean result;
	result = __lambda39_ ((NibblesWindow*) self, a, b);
	return result;
}

static void
nibbles_window_create_scores (NibblesWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_scores_context_new ("gnome-nibbles", _ ("Difficulty Level:"), (GtkWindow*) self, _nibbles_window_get_category_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_GREATER_IS_BETTER, "org.gnome.Nibbles", ___lambda39__games_scores_context_is_lower_order_category_func, self);
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp0_;
}

static gchar*
nibbles_window_get_scores_category_key (NibblesWindow* self,
                                        gint speed,
                                        gboolean fakes,
                                        gint board_progress,
                                        gint start_level)
{
	gchar* key = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (speed) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fast");
			_g_free0 (key);
			key = _tmp0_;
			break;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("medium");
			_g_free0 (key);
			key = _tmp1_;
			break;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("slow");
			_g_free0 (key);
			key = _tmp2_;
			break;
		}
		default:
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("beginner");
			_g_free0 (key);
			key = _tmp3_;
			break;
		}
	}
	if (fakes) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = key;
		_tmp5_ = g_strconcat (_tmp4_, "-fakes", NULL);
		_g_free0 (key);
		key = _tmp5_;
	}
	if (board_progress == 1) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = key;
		_tmp7_ = g_strconcat (_tmp6_, "-random", NULL);
		_g_free0 (key);
		key = _tmp7_;
	} else {
		if (board_progress == 2) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp8_ = key;
			_tmp9_ = g_strdup_printf ("%i", start_level);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("-fixed", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
			_g_free0 (key);
			key = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		}
	}
	result = key;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NibblesWindow* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda40_ (Block5Data* _data5_,
             GObject* object,
             GAsyncResult* _result_)
{
	NibblesWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("nibbles-window.vala:1356: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	nibbles_window_game_over (self, _data5_->score, _data5_->lowest_high_score, _data5_->level_reached);
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ (self, source_object, res);
	block5_data_unref (self);
}

static void
nibbles_window_log_score_cb (NibblesWindow* self,
                             gint score,
                             gint level_reached)
{
	Block5Data* _data5_;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GamesScoresCategory* category = NULL;
	NibblesGame* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NibblesGame* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	NibblesGame* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NibblesGame* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GamesScoresCategory* _tmp17_;
	GamesScoresCategory* _tmp18_;
	GamesScoresCategory* _tmp19_;
	static const gint max_high_score_count = 10;
	GeeList* scores = NULL;
	GamesScoresContext* _tmp20_;
	GamesScoresCategory* _tmp21_;
	GeeList* _tmp22_;
	glong _tmp23_ = 0L;
	GeeList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	NibblesGame* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	GamesScoresContext* _tmp35_;
	GamesScoresCategory* _tmp36_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->score = score;
	_data5_->level_reached = level_reached;
	_tmp0_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = self->priv->game;
	_tmp4_ = nibbles_game_get_speed (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->game;
	_tmp7_ = nibbles_game_get_fakes (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->game;
	_tmp10_ = nibbles_game_get_progress (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->game;
	_tmp13_ = nibbles_game_get_start_level (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = nibbles_window_get_scores_category_key (self, _tmp5_, _tmp8_, _tmp11_, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = nibbles_window_get_category (self, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	category = _tmp18_;
	_tmp19_ = category;
	_vala_assert (NULL != _tmp19_, "null != category");
	_tmp20_ = self->priv->scores_context;
	_tmp21_ = category;
	_tmp22_ = games_scores_context_get_high_scores (_tmp20_, _tmp21_, max_high_score_count);
	scores = _tmp22_;
	_tmp24_ = scores;
	_tmp25_ = gee_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ < max_high_score_count) {
		_tmp23_ = (glong) -1;
	} else {
		GeeList* _tmp27_;
		gpointer _tmp28_;
		GamesScoresScore* _tmp29_;
		glong _tmp30_;
		glong _tmp31_;
		_tmp27_ = scores;
		_tmp28_ = gee_list_last (_tmp27_);
		_tmp29_ = (GamesScoresScore*) _tmp28_;
		_tmp30_ = games_scores_score_get_score (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp23_ = _tmp31_;
		_g_object_unref0 (_tmp29_);
	}
	_data5_->lowest_high_score = _tmp23_;
	_tmp32_ = self->priv->game;
	_tmp33_ = nibbles_game_get_numhumans (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ < 1) {
		nibbles_window_game_over (self, _data5_->score, _data5_->lowest_high_score, _data5_->level_reached);
		_g_object_unref0 (scores);
		_g_object_unref0 (category);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp35_ = self->priv->scores_context;
	_tmp36_ = category;
	games_scores_context_add_score (_tmp35_, (glong) _data5_->score, _tmp36_, NULL, ___lambda40__gasync_ready_callback, block5_data_ref (_data5_));
	_g_object_unref0 (scores);
	_g_object_unref0 (category);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NibblesWindow* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda38_ (Block6Data* _data6_)
{
	NibblesWindow* self;
	GamesScoresContext* _tmp1_;
	self = _data6_->self;
	if (_data6_->should_unpause) {
		GSimpleAction* _tmp0_;
		_tmp0_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp0_, "activate", NULL);
	}
	_tmp1_ = self->priv->scores_context;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _data6_->id);
}

static void
___lambda38__games_scores_context_dialog_closed (GamesScoresContext* _sender,
                                                 gpointer self)
{
	__lambda38_ (self);
}

static void
nibbles_window_scores_cb (NibblesWindow* self)
{
	Block6Data* _data6_;
	NibblesGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesScoresContext* _tmp4_;
	GamesScoresContext* _tmp5_;
	gulong _tmp6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->should_unpause = FALSE;
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_is_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		_tmp3_ = self->priv->pause_action;
		g_signal_emit_by_name (_tmp3_, "activate", NULL);
		_data6_->should_unpause = TRUE;
	}
	_tmp4_ = self->priv->scores_context;
	games_scores_context_present_dialog (_tmp4_);
	_data6_->id = (gulong) 0;
	_tmp5_ = self->priv->scores_context;
	_tmp6_ = g_signal_connect_data (_tmp5_, "dialog-closed", (GCallback) ___lambda38__games_scores_context_dialog_closed, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_data6_->id = _tmp6_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NibblesWindow* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->button);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda41_ (NibblesWindow* self)
{
	NibblesGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	NibblesView* _tmp5_;
	nibbles_window_overlay_remove_all (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = nibbles_game_get_current_level (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Level %d"), _tmp2_);
	_tmp4_ = _tmp3_;
	nibbles_window_set_headerbar_title (self, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
	nibbles_window_restart_game (self);
}

static void
___lambda41__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda41_ ((NibblesWindow*) self);
}

static gboolean
__lambda42_ (Block7Data* _data7_)
{
	NibblesWindow* self;
	GtkButton* _tmp0_;
	gboolean result;
	self = _data7_->self;
	_tmp0_ = _data7_->button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda42__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda42_ (self);
	return result;
}

static void
nibbles_window_level_completed_cb (NibblesWindow* self)
{
	Block7Data* _data7_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	NibblesGame* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkStack* _tmp21_;
	NibblesView* _tmp22_;
	GSimpleAction* _tmp23_;
	GSimpleAction* _tmp24_;
	GtkLabel* label = NULL;
	NibblesGame* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkLabel* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	PangoAttrList* _tmp36_;
	PangoAttrList* _tmp37_;
	GtkLabel* _tmp41_;
	PangoAttrList* _tmp42_;
	PangoAttrList* _tmp43_;
	PangoAttribute* _tmp44_;
	GtkLabel* _tmp45_;
	PangoAttrList* _tmp46_;
	PangoAttrList* _tmp47_;
	PangoAttribute* _tmp48_;
	GtkLabel* _tmp49_;
	GtkButton* _tmp50_;
	GtkButton* _tmp51_;
	GtkButton* _tmp52_;
	GtkButton* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkButton* _tmp59_;
	GtkLabel* _tmp60_;
	GtkButton* _tmp61_;
	GtkButton* _tmp62_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp2_ = self->priv->game;
	_tmp3_ = nibbles_game_get_progress (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		gint _tmp5_ = 0;
		NibblesGame* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		NibblesGame* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp6_ = self->priv->game;
		_tmp7_ = nibbles_game_get_start_level (_tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_ > 1) {
			NibblesGame* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->game;
			_tmp10_ = nibbles_game_get_start_level (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_ - 1;
		} else {
			_tmp5_ = NIBBLES_GAME_MAX_LEVEL;
		}
		_tmp12_ = self->priv->game;
		_tmp13_ = nibbles_game_get_current_level (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp1_ = _tmp14_ == _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		NibblesGame* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = self->priv->game;
		_tmp17_ = nibbles_game_get_progress (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == 1) {
			NibblesGame* _tmp19_;
			gint* _tmp20_;
			gint _tmp20__length1;
			_tmp19_ = self->priv->game;
			_tmp20_ = _tmp19_->levels_uncompleated;
			_tmp20__length1 = _tmp19_->levels_uncompleated_length1;
			_tmp15_ = _tmp20__length1 == 0;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp0_ = _tmp15_;
	}
	if (_tmp0_) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp21_ = self->priv->statusbar_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp23_, FALSE);
	_tmp24_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp24_, FALSE);
	_tmp25_ = self->priv->game;
	_tmp26_ = nibbles_game_get_current_level (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strdup_printf (_ ("Level %d Completed!"), _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = (GtkLabel*) gtk_label_new (_tmp29_);
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp29_);
	label = _tmp31_;
	_tmp32_ = label;
	gtk_widget_set_halign ((GtkWidget*) _tmp32_, GTK_ALIGN_CENTER);
	_tmp33_ = label;
	gtk_widget_set_valign ((GtkWidget*) _tmp33_, GTK_ALIGN_START);
	_tmp34_ = label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp34_, 150);
	_tmp35_ = label;
	_tmp36_ = gtk_label_get_attributes (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == NULL) {
		GtkLabel* _tmp38_;
		PangoAttrList* _tmp39_;
		PangoAttrList* _tmp40_;
		_tmp38_ = label;
		_tmp39_ = pango_attr_list_new ();
		_tmp40_ = _tmp39_;
		gtk_label_set_attributes (_tmp38_, _tmp40_);
		_pango_attr_list_unref0 (_tmp40_);
	}
	_tmp41_ = label;
	_tmp42_ = gtk_label_get_attributes (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
	pango_attr_list_insert (_tmp43_, _tmp44_);
	_tmp45_ = label;
	_tmp46_ = gtk_label_get_attributes (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp47_, _tmp48_);
	_tmp49_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp49_, TRUE);
	_tmp50_ = (GtkButton*) gtk_button_new_with_label (_ ("_Next Level"));
	g_object_ref_sink (_tmp50_);
	_data7_->button = _tmp50_;
	_tmp51_ = _data7_->button;
	gtk_button_set_use_underline (_tmp51_, TRUE);
	_tmp52_ = _data7_->button;
	g_object_set ((GtkWidget*) _tmp52_, "width-request", 116, NULL);
	_tmp53_ = _data7_->button;
	g_object_set ((GtkWidget*) _tmp53_, "height-request", 34, NULL);
	_tmp54_ = _data7_->button;
	gtk_widget_set_halign ((GtkWidget*) _tmp54_, GTK_ALIGN_CENTER);
	_tmp55_ = _data7_->button;
	gtk_widget_set_valign ((GtkWidget*) _tmp55_, GTK_ALIGN_END);
	_tmp56_ = _data7_->button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp56_, 100);
	_tmp57_ = _data7_->button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp57_, "suggested-action");
	_tmp58_ = _data7_->button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp58_, "pill");
	_tmp59_ = _data7_->button;
	g_signal_connect_object (_tmp59_, "clicked", (GCallback) ___lambda41__gtk_button_clicked, self, 0);
	_tmp60_ = label;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp60_);
	_tmp61_ = _data7_->button;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp61_);
	_tmp62_ = _data7_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp62_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ___lambda42__gsource_func, block7_data_ref (_data7_), block7_data_unref);
	_g_object_unref0 (label);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static gboolean
_nibbles_game_estatus_equal (const NibblesGameeStatus * s1,
                             const NibblesGameeStatus * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
nibbles_window_game_over (NibblesWindow* self,
                          gint score,
                          glong lowest_high_score,
                          gint level_reached)
{
	GtkStack* _tmp0_;
	gboolean is_high_score = FALSE;
	gboolean is_game_won = FALSE;
	NibblesGame* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp13_ = NULL;
	GtkLabel* game_over_label = NULL;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	PangoAttrList* _tmp19_;
	PangoAttrList* _tmp20_;
	GtkLabel* _tmp24_;
	PangoAttrList* _tmp25_;
	PangoAttrList* _tmp26_;
	PangoAttribute* _tmp27_;
	GtkLabel* _tmp28_;
	PangoAttrList* _tmp29_;
	PangoAttrList* _tmp30_;
	PangoAttribute* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* msg_label = NULL;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkLabel* _tmp36_;
	GtkLabel* _tmp37_;
	PangoAttrList* _tmp38_;
	PangoAttrList* _tmp39_;
	GtkLabel* _tmp43_;
	PangoAttrList* _tmp44_;
	PangoAttrList* _tmp45_;
	PangoAttribute* _tmp46_;
	GtkLabel* _tmp47_;
	PangoAttrList* _tmp48_;
	PangoAttrList* _tmp49_;
	PangoAttribute* _tmp50_;
	GtkLabel* _tmp51_;
	gchar* score_string = NULL;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	GtkLabel* score_label = NULL;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	GtkLabel* _tmp59_;
	GtkLabel* _tmp60_;
	GtkLabel* _tmp61_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	GtkLabel* _tmp64_;
	GtkLabel* _tmp65_;
	glong points_left = 0L;
	GtkLabel* points_left_label = NULL;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GtkLabel* _tmp68_;
	GtkLabel* _tmp69_;
	GtkLabel* _tmp70_;
	GtkLabel* _tmp71_;
	GtkLabel* _tmp72_;
	GtkLabel* _tmp73_;
	GtkButton* play_again_button = NULL;
	GtkButton* _tmp74_;
	GtkButton* _tmp75_;
	GtkButton* _tmp76_;
	GtkButton* _tmp77_;
	GtkButton* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* _tmp80_;
	GtkButton* _tmp81_;
	GtkButton* _tmp82_;
	GtkLabel* _tmp83_;
	NibblesGame* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	gboolean _tmp89_ = FALSE;
	NibblesGame* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GtkButton* _tmp94_;
	GtkButton* _tmp95_;
	NibblesView* _tmp96_;
	GSimpleAction* _tmp97_;
	GSimpleAction* _tmp98_;
	GSimpleAction* _tmp99_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->statusbar_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	is_high_score = ((glong) score) > lowest_high_score;
	_tmp1_ = self->priv->game;
	_tmp2_ = nibbles_game_get_progress (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		is_game_won = level_reached > NIBBLES_GAME_MAX_LEVEL;
	} else {
		NibblesGame* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->game;
		_tmp5_ = nibbles_game_get_progress (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == 1) {
			NibblesGame* _tmp7_;
			gint* _tmp8_;
			gint _tmp8__length1;
			_tmp7_ = self->priv->game;
			_tmp8_ = _tmp7_->levels_uncompleated;
			_tmp8__length1 = _tmp7_->levels_uncompleated_length1;
			is_game_won = _tmp8__length1 == 0;
		} else {
			NibblesGame* _tmp9_;
			NibblesGameeStatus* _tmp10_;
			NibblesGameeStatus* _tmp11_;
			NibblesGameeStatus _tmp12_;
			_tmp9_ = self->priv->game;
			_tmp10_ = nibbles_game_get_game_status (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = NIBBLES_GAME_ESTATUS_VICTORY;
			is_game_won = _nibbles_game_estatus_equal (_tmp11_, &_tmp12_) == TRUE;
			_g_free0 (_tmp11_);
		}
	}
	if (is_game_won) {
		_tmp13_ = _ ("Congratulations!");
	} else {
		_tmp13_ = _ ("Game Over!");
	}
	_tmp14_ = (GtkLabel*) gtk_label_new (_tmp13_);
	g_object_ref_sink (_tmp14_);
	game_over_label = _tmp14_;
	_tmp15_ = game_over_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	_tmp16_ = game_over_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	_tmp17_ = game_over_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp17_, 150);
	_tmp18_ = game_over_label;
	_tmp19_ = gtk_label_get_attributes (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == NULL) {
		GtkLabel* _tmp21_;
		PangoAttrList* _tmp22_;
		PangoAttrList* _tmp23_;
		_tmp21_ = game_over_label;
		_tmp22_ = pango_attr_list_new ();
		_tmp23_ = _tmp22_;
		gtk_label_set_attributes (_tmp21_, _tmp23_);
		_pango_attr_list_unref0 (_tmp23_);
	}
	_tmp24_ = game_over_label;
	_tmp25_ = gtk_label_get_attributes (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = pango_attr_scale_new (PANGO_SCALE_XX_LARGE * 2);
	pango_attr_list_insert (_tmp26_, _tmp27_);
	_tmp28_ = game_over_label;
	_tmp29_ = gtk_label_get_attributes (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp30_, _tmp31_);
	_tmp32_ = game_over_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp32_, TRUE);
	_tmp33_ = (GtkLabel*) gtk_label_new (_ ("You have completed the game."));
	g_object_ref_sink (_tmp33_);
	msg_label = _tmp33_;
	_tmp34_ = msg_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp34_, GTK_ALIGN_CENTER);
	_tmp35_ = msg_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
	_tmp36_ = msg_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp36_, gtk_widget_get_height ((GtkWidget*) self) / 3);
	_tmp37_ = msg_label;
	_tmp38_ = gtk_label_get_attributes (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NULL) {
		GtkLabel* _tmp40_;
		PangoAttrList* _tmp41_;
		PangoAttrList* _tmp42_;
		_tmp40_ = msg_label;
		_tmp41_ = pango_attr_list_new ();
		_tmp42_ = _tmp41_;
		gtk_label_set_attributes (_tmp40_, _tmp42_);
		_pango_attr_list_unref0 (_tmp42_);
	}
	_tmp43_ = msg_label;
	_tmp44_ = gtk_label_get_attributes (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
	pango_attr_list_insert (_tmp45_, _tmp46_);
	_tmp47_ = msg_label;
	_tmp48_ = gtk_label_get_attributes (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp49_, _tmp50_);
	_tmp51_ = msg_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp51_, TRUE);
	_tmp52_ = g_strdup (ngettext ("%d Point", "%d Points", (gulong) score));
	score_string = _tmp52_;
	_tmp53_ = score_string;
	_tmp54_ = g_strdup_printf (_tmp53_, score);
	_g_free0 (score_string);
	score_string = _tmp54_;
	_tmp55_ = score_string;
	_tmp56_ = string_to_string (_tmp55_);
	_tmp57_ = g_strconcat ("<b>", _tmp56_, "</b>", NULL);
	_tmp58_ = _tmp57_;
	_tmp59_ = (GtkLabel*) gtk_label_new (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_tmp60_ = _tmp59_;
	_g_free0 (_tmp58_);
	score_label = _tmp60_;
	_tmp61_ = score_label;
	gtk_label_set_use_markup (_tmp61_, TRUE);
	_tmp62_ = score_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp62_, GTK_ALIGN_CENTER);
	_tmp63_ = score_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp63_, GTK_ALIGN_START);
	_tmp64_ = score_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp64_, (gtk_widget_get_height ((GtkWidget*) self) / 3) + 80);
	_tmp65_ = score_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp65_, TRUE);
	points_left = (lowest_high_score + 1) - score;
	_tmp66_ = g_strdup_printf (_ ("(%ld more points to reach the leaderboard)"), points_left);
	_tmp67_ = _tmp66_;
	_tmp68_ = (GtkLabel*) gtk_label_new (_tmp67_);
	g_object_ref_sink (_tmp68_);
	_tmp69_ = _tmp68_;
	_g_free0 (_tmp67_);
	points_left_label = _tmp69_;
	_tmp70_ = points_left_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp70_, GTK_ALIGN_CENTER);
	_tmp71_ = points_left_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp71_, GTK_ALIGN_START);
	_tmp72_ = points_left_label;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp72_, (gtk_widget_get_height ((GtkWidget*) self) / 3) + 100);
	_tmp73_ = points_left_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp73_, TRUE);
	_tmp74_ = (GtkButton*) gtk_button_new_with_label (_ ("_Play Again"));
	g_object_ref_sink (_tmp74_);
	play_again_button = _tmp74_;
	_tmp75_ = play_again_button;
	gtk_button_set_use_underline (_tmp75_, TRUE);
	_tmp76_ = play_again_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp76_, GTK_ALIGN_CENTER);
	_tmp77_ = play_again_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp77_, GTK_ALIGN_END);
	_tmp78_ = play_again_button;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp78_, 100);
	_tmp79_ = play_again_button;
	gtk_actionable_set_action_name ((GtkActionable*) _tmp79_, "win.new-game");
	_tmp80_ = play_again_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp80_, "suggested-action");
	_tmp81_ = play_again_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp81_, "pill");
	_tmp82_ = play_again_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp82_, TRUE);
	_tmp83_ = game_over_label;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp83_);
	if (is_game_won) {
		GtkLabel* _tmp84_;
		_tmp84_ = msg_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp84_);
	}
	_tmp85_ = self->priv->game;
	_tmp86_ = nibbles_game_get_numhumans (_tmp85_);
	_tmp87_ = _tmp86_;
	if (_tmp87_ == 1) {
		GtkLabel* _tmp88_;
		_tmp88_ = score_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp88_);
	}
	_tmp90_ = self->priv->game;
	_tmp91_ = nibbles_game_get_numhumans (_tmp90_);
	_tmp92_ = _tmp91_;
	if (_tmp92_ == 1) {
		_tmp89_ = !is_high_score;
	} else {
		_tmp89_ = FALSE;
	}
	if (_tmp89_) {
		GtkLabel* _tmp93_;
		_tmp93_ = points_left_label;
		nibbles_window_overlay_add (self, (GtkWidget*) _tmp93_);
	}
	_tmp94_ = play_again_button;
	nibbles_window_overlay_add (self, (GtkWidget*) _tmp94_);
	_tmp95_ = play_again_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp95_);
	_tmp96_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp96_, FALSE);
	self->priv->end_of_game = TRUE;
	_tmp97_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp97_, TRUE);
	_tmp98_ = self->priv->pause_action;
	g_simple_action_set_enabled (_tmp98_, FALSE);
	_tmp99_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp99_, FALSE);
	_g_object_unref0 (play_again_button);
	_g_object_unref0 (points_left_label);
	_g_object_unref0 (score_label);
	_g_free0 (score_string);
	_g_object_unref0 (msg_label);
	_g_object_unref0 (game_over_label);
}

static gint
nibbles_window_countdown_active (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->seconds;
	return result;
}

static gboolean
nibbles_window_fullscreen_active (NibblesWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->fullscreen_mode;
	return result;
}

static gint
nibbles_window_get_cli_start_level (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cli_start_level;
	return result;
}

static void
nibbles_window_set_cli_start_level (NibblesWindow* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_cli_start_level (self);
	if (old_value != value) {
		self->priv->_cli_start_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY]);
	}
}

static gint
nibbles_window_get_start_level (NibblesWindow* self)
{
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_cli_start_level;
	if (_tmp1_ == 0) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->settings;
		_tmp0_ = g_settings_get_int (_tmp2_, "start-level");
	} else {
		gint _tmp3_;
		_tmp3_ = self->priv->_cli_start_level;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

gint
nibbles_window_get_progress (NibblesWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_progress;
	return result;
}

void
nibbles_window_set_progress (NibblesWindow* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_PROGRESS_PROPERTY]);
	}
}

static SetupScreen
nibbles_window_get_start_screen (NibblesWindow* self)
{
	SetupScreen result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start_screen;
	return result;
}

static void
nibbles_window_set_start_screen (NibblesWindow* self,
                                 SetupScreen value)
{
	SetupScreen old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_window_get_start_screen (self);
	if (old_value != value) {
		self->priv->_start_screen = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_START_SCREEN_PROPERTY]);
	}
}

gboolean
nibbles_window_get_game_paused (NibblesWindow* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	NibblesGame* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		NibblesGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = nibbles_game_get_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
nibbles_window_set_game_paused (NibblesWindow* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	g_object_notify_by_pspec ((GObject *) self, nibbles_window_properties[NIBBLES_WINDOW_GAME_PAUSED_PROPERTY]);
}

static inline gpointer
nibbles_window_delegate_stack_get_instance_private (NibblesWindowDelegateStack* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindowDelegateStack_private_offset);
}

static gpointer
_nibbles_window_delegate_stack_node_dup0 (gpointer self)
{
	return self ? nibbles_window_delegate_stack_node_dup (self) : NULL;
}

static void
nibbles_window_delegate_stack_push (NibblesWindowDelegateStack* self,
                                    KeypressHandlerFunction handler,
                                    gpointer handler_target)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pHead;
	if (_tmp0_ == NULL) {
		NibblesWindowDelegateStackNode _tmp1_ = {0};
		NibblesWindowDelegateStackNode _tmp2_;
		NibblesWindowDelegateStackNode* _tmp3_;
		_tmp1_.keypress_handler = handler;
		_tmp1_.keypress_handler_target = handler_target;
		_nibbles_window_delegate_stack_node_free0 (_tmp1_.pNext);
		_tmp1_.pNext = NULL;
		_tmp2_ = _tmp1_;
		_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (&_tmp2_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp3_;
		nibbles_window_delegate_stack_node_destroy (&_tmp2_);
	} else {
		NibblesWindowDelegateStackNode* _tmp4_;
		NibblesWindowDelegateStackNode* _tmp5_;
		NibblesWindowDelegateStackNode _tmp6_ = {0};
		NibblesWindowDelegateStackNode _tmp7_;
		NibblesWindowDelegateStackNode* _tmp8_;
		_tmp4_ = self->priv->pHead;
		_tmp5_ = _nibbles_window_delegate_stack_node_dup0 (_tmp4_);
		_tmp6_.keypress_handler = handler;
		_tmp6_.keypress_handler_target = handler_target;
		_nibbles_window_delegate_stack_node_free0 (_tmp6_.pNext);
		_tmp6_.pNext = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = _nibbles_window_delegate_stack_node_dup0 (&_tmp7_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp8_;
		nibbles_window_delegate_stack_node_destroy (&_tmp7_);
	}
}

static gboolean
nibbles_window_delegate_stack_pop (NibblesWindowDelegateStack* self)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pHead;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	} else {
		NibblesWindowDelegateStackNode* _tmp1_;
		NibblesWindowDelegateStackNode* _tmp2_;
		NibblesWindowDelegateStackNode* _tmp3_;
		_tmp1_ = self->priv->pHead;
		_tmp2_ = (*_tmp1_).pNext;
		_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (_tmp2_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp3_;
		result = TRUE;
		return result;
	}
}

static void
nibbles_window_delegate_stack_remove (NibblesWindowDelegateStack* self,
                                      KeypressHandlerFunction handler,
                                      gpointer handler_target)
{
	gboolean _tmp0_ = FALSE;
	NibblesWindowDelegateStackNode* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->pHead;
	if (_tmp1_ != NULL) {
		NibblesWindowDelegateStackNode* _tmp2_;
		KeypressHandlerFunction _tmp3_;
		gpointer _tmp3__target;
		_tmp2_ = self->priv->pHead;
		_tmp3_ = (*_tmp2_).keypress_handler;
		_tmp3__target = (*_tmp2_).keypress_handler_target;
		_tmp0_ = _tmp3_ == handler;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesWindowDelegateStackNode* _tmp4_;
		NibblesWindowDelegateStackNode* _tmp5_;
		NibblesWindowDelegateStackNode* _tmp6_;
		_tmp4_ = self->priv->pHead;
		_tmp5_ = (*_tmp4_).pNext;
		_tmp6_ = _nibbles_window_delegate_stack_node_dup0 (_tmp5_);
		_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
		self->priv->pHead = _tmp6_;
	} else {
		gboolean _tmp7_ = FALSE;
		NibblesWindowDelegateStackNode* _tmp8_;
		_tmp8_ = self->priv->pHead;
		if (_tmp8_ != NULL) {
			NibblesWindowDelegateStackNode* _tmp9_;
			NibblesWindowDelegateStackNode* _tmp10_;
			_tmp9_ = self->priv->pHead;
			_tmp10_ = (*_tmp9_).pNext;
			_tmp7_ = _tmp10_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			NibblesWindowDelegateStackNode* pTrail = NULL;
			NibblesWindowDelegateStackNode* _tmp11_;
			NibblesWindowDelegateStackNode* _tmp12_;
			_tmp11_ = self->priv->pHead;
			_tmp12_ = _nibbles_window_delegate_stack_node_dup0 (_tmp11_);
			pTrail = _tmp12_;
			{
				NibblesWindowDelegateStackNode* p = NULL;
				NibblesWindowDelegateStackNode* _tmp13_;
				NibblesWindowDelegateStackNode* _tmp14_;
				NibblesWindowDelegateStackNode* _tmp15_;
				_tmp13_ = pTrail;
				_tmp14_ = (*_tmp13_).pNext;
				_tmp15_ = _nibbles_window_delegate_stack_node_dup0 (_tmp14_);
				p = _tmp15_;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						NibblesWindowDelegateStackNode* _tmp17_;
						NibblesWindowDelegateStackNode* _tmp18_;
						KeypressHandlerFunction _tmp19_;
						gpointer _tmp19__target;
						if (!_tmp16_) {
						}
						_tmp16_ = FALSE;
						_tmp17_ = p;
						if (!(_tmp17_ != NULL)) {
							break;
						}
						_tmp18_ = p;
						_tmp19_ = (*_tmp18_).keypress_handler;
						_tmp19__target = (*_tmp18_).keypress_handler_target;
						if (_tmp19_ == handler) {
							NibblesWindowDelegateStackNode* _tmp20_;
							NibblesWindowDelegateStackNode* _tmp21_;
							NibblesWindowDelegateStackNode* _tmp22_;
							NibblesWindowDelegateStackNode* _tmp23_;
							_tmp20_ = pTrail;
							_tmp21_ = p;
							_tmp22_ = (*_tmp21_).pNext;
							_tmp23_ = _nibbles_window_delegate_stack_node_dup0 (_tmp22_);
							_nibbles_window_delegate_stack_node_free0 ((*_tmp20_).pNext);
							(*_tmp20_).pNext = _tmp23_;
							break;
						} else {
							NibblesWindowDelegateStackNode* _tmp24_;
							NibblesWindowDelegateStackNode* _tmp25_;
							NibblesWindowDelegateStackNode* _tmp26_;
							NibblesWindowDelegateStackNode* _tmp27_;
							NibblesWindowDelegateStackNode* _tmp28_;
							_tmp24_ = p;
							_tmp25_ = _nibbles_window_delegate_stack_node_dup0 (_tmp24_);
							_nibbles_window_delegate_stack_node_free0 (pTrail);
							pTrail = _tmp25_;
							_tmp26_ = p;
							_tmp27_ = (*_tmp26_).pNext;
							_tmp28_ = _nibbles_window_delegate_stack_node_dup0 (_tmp27_);
							_nibbles_window_delegate_stack_node_free0 (p);
							p = _tmp28_;
						}
					}
				}
				_nibbles_window_delegate_stack_node_free0 (p);
			}
			_nibbles_window_delegate_stack_node_free0 (pTrail);
		}
	}
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_iterator (NibblesWindowDelegateStack* self)
{
	NibblesWindowDelegateStackDelegateStackIterator* _tmp0_;
	NibblesWindowDelegateStackDelegateStackIterator* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = nibbles_window_delegate_stack_delegate_stack_iterator_new (self);
	result = _tmp0_;
	return result;
}

static NibblesWindowDelegateStack*
nibbles_window_delegate_stack_construct (GType object_type)
{
	NibblesWindowDelegateStack* self = NULL;
	self = (NibblesWindowDelegateStack*) g_type_create_instance (object_type);
	return self;
}

static NibblesWindowDelegateStack*
nibbles_window_delegate_stack_new (void)
{
	return nibbles_window_delegate_stack_construct (NIBBLES_WINDOW_TYPE_DELEGATE_STACK);
}

static inline gpointer
nibbles_window_delegate_stack_delegate_stack_iterator_get_instance_private (NibblesWindowDelegateStackDelegateStackIterator* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesWindowDelegateStackDelegateStackIterator_private_offset);
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_delegate_stack_iterator_construct (GType object_type,
                                                                 NibblesWindowDelegateStack* p)
{
	NibblesWindowDelegateStackDelegateStackIterator* self = NULL;
	NibblesWindowDelegateStackNode* _tmp0_;
	NibblesWindowDelegateStackNode* _tmp1_;
	g_return_val_if_fail (p != NULL, NULL);
	self = (NibblesWindowDelegateStackDelegateStackIterator*) g_type_create_instance (object_type);
	_tmp0_ = p->priv->pHead;
	_tmp1_ = _nibbles_window_delegate_stack_node_dup0 (_tmp0_);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
	self->priv->pIterator = _tmp1_;
	self->priv->first_next = TRUE;
	return self;
}

static NibblesWindowDelegateStackDelegateStackIterator*
nibbles_window_delegate_stack_delegate_stack_iterator_new (NibblesWindowDelegateStack* p)
{
	return nibbles_window_delegate_stack_delegate_stack_iterator_construct (NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, p);
}

static gboolean
nibbles_window_delegate_stack_delegate_stack_iterator_next (NibblesWindowDelegateStackDelegateStackIterator* self)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pIterator;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	} else {
		if (self->priv->first_next) {
			self->priv->first_next = !self->priv->first_next;
			result = TRUE;
			return result;
		} else {
			NibblesWindowDelegateStackNode* _tmp1_;
			NibblesWindowDelegateStackNode* _tmp2_;
			NibblesWindowDelegateStackNode* _tmp3_;
			NibblesWindowDelegateStackNode* _tmp4_;
			_tmp1_ = self->priv->pIterator;
			_tmp2_ = (*_tmp1_).pNext;
			_tmp3_ = _nibbles_window_delegate_stack_node_dup0 (_tmp2_);
			_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
			self->priv->pIterator = _tmp3_;
			_tmp4_ = self->priv->pIterator;
			result = _tmp4_ != NULL;
			return result;
		}
	}
}

static KeypressHandlerFunction
nibbles_window_delegate_stack_delegate_stack_iterator_get (NibblesWindowDelegateStackDelegateStackIterator* self,
                                                           gpointer* result_target)
{
	NibblesWindowDelegateStackNode* _tmp0_;
	KeypressHandlerFunction _tmp1_;
	gpointer _tmp1__target;
	KeypressHandlerFunction _tmp2_;
	gpointer _tmp2__target;
	KeypressHandlerFunction result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pIterator;
	_tmp1_ = (*_tmp0_).keypress_handler;
	_tmp1__target = (*_tmp0_).keypress_handler_target;
	_tmp2_ = _tmp1_;
	_tmp2__target = _tmp1__target;
	*result_target = _tmp2__target;
	result = _tmp2_;
	return result;
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_window_delegate_stack_value_delegate_stack_iterator_copy_value (const GValue* src_value,
                                                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_window_delegate_stack_delegate_stack_iterator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_window_delegate_stack_value_delegate_stack_iterator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_window_delegate_stack_value_delegate_stack_iterator_collect_value (GValue* value,
                                                                           guint n_collect_values,
                                                                           GTypeCValue* collect_values,
                                                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesWindowDelegateStackDelegateStackIterator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_window_delegate_stack_delegate_stack_iterator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_window_delegate_stack_value_delegate_stack_iterator_lcopy_value (const GValue* value,
                                                                         guint n_collect_values,
                                                                         GTypeCValue* collect_values,
                                                                         guint collect_flags)
{
	NibblesWindowDelegateStackDelegateStackIterator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_window_delegate_stack_delegate_stack_iterator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_window_delegate_stack_param_spec_delegate_stack_iterator (const gchar* name,
                                                                  const gchar* nick,
                                                                  const gchar* blurb,
                                                                  GType object_type,
                                                                  GParamFlags flags)
{
	NibblesWindowDelegateStackParamSpecDelegateStackIterator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_window_delegate_stack_value_get_delegate_stack_iterator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_window_delegate_stack_value_set_delegate_stack_iterator (GValue* value,
                                                                 gpointer v_object)
{
	NibblesWindowDelegateStackDelegateStackIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_window_delegate_stack_delegate_stack_iterator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (old);
	}
}

static void
nibbles_window_delegate_stack_value_take_delegate_stack_iterator (GValue* value,
                                                                  gpointer v_object)
{
	NibblesWindowDelegateStackDelegateStackIterator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_delegate_stack_iterator_unref (old);
	}
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_class_init (NibblesWindowDelegateStackDelegateStackIteratorClass * klass,
                                                                  gpointer klass_data)
{
	nibbles_window_delegate_stack_delegate_stack_iterator_parent_class = g_type_class_peek_parent (klass);
	((NibblesWindowDelegateStackDelegateStackIteratorClass *) klass)->finalize = nibbles_window_delegate_stack_delegate_stack_iterator_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesWindowDelegateStackDelegateStackIterator_private_offset);
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_instance_init (NibblesWindowDelegateStackDelegateStackIterator * self,
                                                                     gpointer klass)
{
	self->priv = nibbles_window_delegate_stack_delegate_stack_iterator_get_instance_private (self);
	self->ref_count = 1;
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_finalize (NibblesWindowDelegateStackDelegateStackIterator * obj)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_WINDOW_DELEGATE_STACK_TYPE_DELEGATE_STACK_ITERATOR, NibblesWindowDelegateStackDelegateStackIterator);
	g_signal_handlers_destroy (self);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pIterator);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_window_delegate_stack_value_delegate_stack_iterator_init, nibbles_window_delegate_stack_value_delegate_stack_iterator_free_value, nibbles_window_delegate_stack_value_delegate_stack_iterator_copy_value, nibbles_window_delegate_stack_value_delegate_stack_iterator_peek_pointer, "p", nibbles_window_delegate_stack_value_delegate_stack_iterator_collect_value, "p", nibbles_window_delegate_stack_value_delegate_stack_iterator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowDelegateStackDelegateStackIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_delegate_stack_delegate_stack_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindowDelegateStackDelegateStackIterator), 0, (GInstanceInitFunc) nibbles_window_delegate_stack_delegate_stack_iterator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
	nibbles_window_delegate_stack_delegate_stack_iterator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesWindowDelegateStackDelegateStackIterator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesWindowDelegateStackDelegateStackIterator_private_offset = g_type_add_instance_private (nibbles_window_delegate_stack_delegate_stack_iterator_type_id, sizeof (NibblesWindowDelegateStackDelegateStackIteratorPrivate));
	return nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
}

GType
nibbles_window_delegate_stack_delegate_stack_iterator_get_type (void)
{
	static gsize nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once)) {
		GType nibbles_window_delegate_stack_delegate_stack_iterator_type_id;
		nibbles_window_delegate_stack_delegate_stack_iterator_type_id = nibbles_window_delegate_stack_delegate_stack_iterator_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once, nibbles_window_delegate_stack_delegate_stack_iterator_type_id);
	}
	return nibbles_window_delegate_stack_delegate_stack_iterator_type_id__once;
}

static gpointer
nibbles_window_delegate_stack_delegate_stack_iterator_ref (gpointer instance)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_window_delegate_stack_delegate_stack_iterator_unref (gpointer instance)
{
	NibblesWindowDelegateStackDelegateStackIterator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_WINDOW_DELEGATE_STACK_DELEGATE_STACK_ITERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
nibbles_window_delegate_stack_node_copy (const NibblesWindowDelegateStackNode* self,
                                         NibblesWindowDelegateStackNode* dest)
{
	KeypressHandlerFunction _tmp0_;
	gpointer _tmp0__target;
	NibblesWindowDelegateStackNode* _tmp1_;
	NibblesWindowDelegateStackNode* _tmp2_;
	_tmp0_ = (*self).keypress_handler;
	_tmp0__target = (*self).keypress_handler_target;
	(*dest).keypress_handler = _tmp0_;
	(*dest).keypress_handler_target = _tmp0__target;
	_tmp1_ = (*self).pNext;
	_tmp2_ = _nibbles_window_delegate_stack_node_dup0 (_tmp1_);
	_nibbles_window_delegate_stack_node_free0 ((*dest).pNext);
	(*dest).pNext = _tmp2_;
}

static void
nibbles_window_delegate_stack_node_destroy (NibblesWindowDelegateStackNode* self)
{
	_nibbles_window_delegate_stack_node_free0 ((*self).pNext);
}

static NibblesWindowDelegateStackNode*
nibbles_window_delegate_stack_node_dup (const NibblesWindowDelegateStackNode* self)
{
	NibblesWindowDelegateStackNode* dup;
	dup = g_new0 (NibblesWindowDelegateStackNode, 1);
	nibbles_window_delegate_stack_node_copy (self, dup);
	return dup;
}

static void
nibbles_window_delegate_stack_node_free (NibblesWindowDelegateStackNode* self)
{
	nibbles_window_delegate_stack_node_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_node_get_type_once (void)
{
	GType nibbles_window_delegate_stack_node_type_id;
	nibbles_window_delegate_stack_node_type_id = g_boxed_type_register_static ("NibblesWindowDelegateStackNode", (GBoxedCopyFunc) nibbles_window_delegate_stack_node_dup, (GBoxedFreeFunc) nibbles_window_delegate_stack_node_free);
	return nibbles_window_delegate_stack_node_type_id;
}

static GType
nibbles_window_delegate_stack_node_get_type (void)
{
	static gsize nibbles_window_delegate_stack_node_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_node_type_id__once)) {
		GType nibbles_window_delegate_stack_node_type_id;
		nibbles_window_delegate_stack_node_type_id = nibbles_window_delegate_stack_node_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_node_type_id__once, nibbles_window_delegate_stack_node_type_id);
	}
	return nibbles_window_delegate_stack_node_type_id__once;
}

static void
nibbles_window_value_delegate_stack_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_window_value_delegate_stack_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_window_delegate_stack_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_window_value_delegate_stack_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_window_delegate_stack_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_window_value_delegate_stack_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_window_value_delegate_stack_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesWindowDelegateStack * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_window_delegate_stack_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_window_value_delegate_stack_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	NibblesWindowDelegateStack ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_window_delegate_stack_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_window_param_spec_delegate_stack (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	NibblesWindowParamSpecDelegateStack* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_WINDOW_TYPE_DELEGATE_STACK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_window_value_get_delegate_stack (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_window_value_set_delegate_stack (GValue* value,
                                         gpointer v_object)
{
	NibblesWindowDelegateStack * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_window_delegate_stack_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_unref (old);
	}
}

static void
nibbles_window_value_take_delegate_stack (GValue* value,
                                          gpointer v_object)
{
	NibblesWindowDelegateStack * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_WINDOW_TYPE_DELEGATE_STACK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_window_delegate_stack_unref (old);
	}
}

static void
nibbles_window_delegate_stack_class_init (NibblesWindowDelegateStackClass * klass,
                                          gpointer klass_data)
{
	nibbles_window_delegate_stack_parent_class = g_type_class_peek_parent (klass);
	((NibblesWindowDelegateStackClass *) klass)->finalize = nibbles_window_delegate_stack_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesWindowDelegateStack_private_offset);
}

static void
nibbles_window_delegate_stack_instance_init (NibblesWindowDelegateStack * self,
                                             gpointer klass)
{
	self->priv = nibbles_window_delegate_stack_get_instance_private (self);
	self->priv->pHead = NULL;
	self->ref_count = 1;
}

static void
nibbles_window_delegate_stack_finalize (NibblesWindowDelegateStack * obj)
{
	NibblesWindowDelegateStack * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_WINDOW_TYPE_DELEGATE_STACK, NibblesWindowDelegateStack);
	g_signal_handlers_destroy (self);
	_nibbles_window_delegate_stack_node_free0 (self->priv->pHead);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_delegate_stack_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_window_value_delegate_stack_init, nibbles_window_value_delegate_stack_free_value, nibbles_window_value_delegate_stack_copy_value, nibbles_window_value_delegate_stack_peek_pointer, "p", nibbles_window_value_delegate_stack_collect_value, "p", nibbles_window_value_delegate_stack_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowDelegateStackClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_delegate_stack_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindowDelegateStack), 0, (GInstanceInitFunc) nibbles_window_delegate_stack_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_window_delegate_stack_type_id;
	nibbles_window_delegate_stack_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesWindowDelegateStack", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesWindowDelegateStack_private_offset = g_type_add_instance_private (nibbles_window_delegate_stack_type_id, sizeof (NibblesWindowDelegateStackPrivate));
	return nibbles_window_delegate_stack_type_id;
}

static GType
nibbles_window_delegate_stack_get_type (void)
{
	static gsize nibbles_window_delegate_stack_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_delegate_stack_type_id__once)) {
		GType nibbles_window_delegate_stack_type_id;
		nibbles_window_delegate_stack_type_id = nibbles_window_delegate_stack_get_type_once ();
		g_once_init_leave (&nibbles_window_delegate_stack_type_id__once, nibbles_window_delegate_stack_type_id);
	}
	return nibbles_window_delegate_stack_type_id__once;
}

static gpointer
nibbles_window_delegate_stack_ref (gpointer instance)
{
	NibblesWindowDelegateStack * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_window_delegate_stack_unref (gpointer instance)
{
	NibblesWindowDelegateStack * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_WINDOW_DELEGATE_STACK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_nibbles_window_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                        const gchar* key,
                                                        gpointer self)
{
	nibbles_window_settings_changed_cb ((NibblesWindow*) self, key);
}

static void
_nibbles_window_worm_settings_changed_cb_g_settings_changed (GSettings* _sender,
                                                             const gchar* key,
                                                             gpointer self)
{
	nibbles_window_worm_settings_changed_cb ((NibblesWindow*) self, _sender, key);
}

static void
_nibbles_window___lambda43_ (NibblesWindow* self)
{
	NibblesView* _tmp0_;
	_tmp0_ = self->priv->view;
	if (NULL != _tmp0_) {
		NibblesView* _tmp1_;
		_tmp1_ = self->priv->view;
		gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp1_);
	}
}

static void
__nibbles_window___lambda43__gtk_popover_closed (GtkPopover* _sender,
                                                 gpointer self)
{
	_nibbles_window___lambda43_ ((NibblesWindow*) self);
}

static gboolean
_nibbles_window___lambda44_ (NibblesWindow* self,
                             GtkEventControllerKey* controller,
                             guint keyval,
                             guint keycode,
                             GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (controller != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	if (g_strcmp0 ((const gchar*) _tmp0_, "F1") == 0) {
		if ((state & GDK_CONTROL_MASK) > 0) {
			g_action_group_activate_action ((GActionGroup*) self, "show-help-overlay", NULL);
		} else {
			if ((state & GDK_SHIFT_MASK) > 0) {
				GtkApplication* _tmp2_;
				GtkApplication* _tmp3_;
				_tmp2_ = gtk_window_get_application ((GtkWindow*) self);
				_tmp3_ = _tmp2_;
				g_action_group_activate_action ((GActionGroup*) _tmp3_, "about", NULL);
			} else {
				if ((state & GDK_SHIFT_MASK) == 0) {
					GtkApplication* _tmp4_;
					GtkApplication* _tmp5_;
					_tmp4_ = gtk_window_get_application ((GtkWindow*) self);
					_tmp5_ = _tmp4_;
					g_action_group_activate_action ((GActionGroup*) _tmp5_, "help", NULL);
				} else {
					result = FALSE;
					return result;
				}
			}
		}
		result = TRUE;
		return result;
	} else {
		NibblesWindowDelegateStack* handlers_to_remove = NULL;
		NibblesWindowDelegateStack* _tmp6_;
		_tmp6_ = nibbles_window_delegate_stack_new ();
		handlers_to_remove = _tmp6_;
		{
			NibblesWindowDelegateStackDelegateStackIterator* _handler_it = NULL;
			NibblesWindowDelegateStack* _tmp7_;
			NibblesWindowDelegateStackDelegateStackIterator* _tmp8_;
			_tmp7_ = self->priv->keypress_handlers;
			_tmp8_ = nibbles_window_delegate_stack_iterator (_tmp7_);
			_handler_it = _tmp8_;
			while (TRUE) {
				NibblesWindowDelegateStackDelegateStackIterator* _tmp9_;
				KeypressHandlerFunction handler = NULL;
				NibblesWindowDelegateStackDelegateStackIterator* _tmp10_;
				gpointer _tmp11_ = NULL;
				KeypressHandlerFunction _tmp12_;
				gpointer handler_target;
				gboolean remove_handler = FALSE;
				gboolean r = FALSE;
				KeypressHandlerFunction _tmp13_;
				gpointer _tmp13__target;
				gboolean _tmp14_ = FALSE;
				gboolean _tmp15_;
				_tmp9_ = _handler_it;
				if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp9_)) {
					break;
				}
				_tmp10_ = _handler_it;
				_tmp12_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp10_, &_tmp11_);
				handler = _tmp12_;
				handler_target = _tmp11_;
				_tmp13_ = handler;
				_tmp13__target = handler_target;
				_tmp15_ = _tmp13_ (keyval, keycode, &_tmp14_, _tmp13__target);
				remove_handler = _tmp14_;
				r = _tmp15_;
				if (remove_handler) {
					NibblesWindowDelegateStack* _tmp16_;
					KeypressHandlerFunction _tmp17_;
					gpointer _tmp17__target;
					_tmp16_ = handlers_to_remove;
					_tmp17_ = handler;
					_tmp17__target = handler_target;
					nibbles_window_delegate_stack_push (_tmp16_, _tmp17_, _tmp17__target);
				}
				if (r) {
					{
						NibblesWindowDelegateStackDelegateStackIterator* _h_it = NULL;
						NibblesWindowDelegateStack* _tmp18_;
						NibblesWindowDelegateStackDelegateStackIterator* _tmp19_;
						_tmp18_ = handlers_to_remove;
						_tmp19_ = nibbles_window_delegate_stack_iterator (_tmp18_);
						_h_it = _tmp19_;
						while (TRUE) {
							NibblesWindowDelegateStackDelegateStackIterator* _tmp20_;
							KeypressHandlerFunction h = NULL;
							NibblesWindowDelegateStackDelegateStackIterator* _tmp21_;
							gpointer _tmp22_ = NULL;
							KeypressHandlerFunction _tmp23_;
							gpointer h_target;
							NibblesWindowDelegateStack* _tmp24_;
							KeypressHandlerFunction _tmp25_;
							gpointer _tmp25__target;
							_tmp20_ = _h_it;
							if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp20_)) {
								break;
							}
							_tmp21_ = _h_it;
							_tmp23_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp21_, &_tmp22_);
							h = _tmp23_;
							h_target = _tmp22_;
							_tmp24_ = self->priv->keypress_handlers;
							_tmp25_ = h;
							_tmp25__target = h_target;
							nibbles_window_delegate_stack_remove (_tmp24_, _tmp25_, _tmp25__target);
						}
						_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_h_it);
					}
					result = r;
					_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
					_nibbles_window_delegate_stack_unref0 (handlers_to_remove);
					return result;
				}
			}
			_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
		}
		{
			NibblesWindowDelegateStackDelegateStackIterator* _handler_it = NULL;
			NibblesWindowDelegateStack* _tmp26_;
			NibblesWindowDelegateStackDelegateStackIterator* _tmp27_;
			_tmp26_ = handlers_to_remove;
			_tmp27_ = nibbles_window_delegate_stack_iterator (_tmp26_);
			_handler_it = _tmp27_;
			while (TRUE) {
				NibblesWindowDelegateStackDelegateStackIterator* _tmp28_;
				KeypressHandlerFunction handler = NULL;
				NibblesWindowDelegateStackDelegateStackIterator* _tmp29_;
				gpointer _tmp30_ = NULL;
				KeypressHandlerFunction _tmp31_;
				gpointer handler_target;
				NibblesWindowDelegateStack* _tmp32_;
				KeypressHandlerFunction _tmp33_;
				gpointer _tmp33__target;
				_tmp28_ = _handler_it;
				if (!nibbles_window_delegate_stack_delegate_stack_iterator_next (_tmp28_)) {
					break;
				}
				_tmp29_ = _handler_it;
				_tmp31_ = nibbles_window_delegate_stack_delegate_stack_iterator_get (_tmp29_, &_tmp30_);
				handler = _tmp31_;
				handler_target = _tmp30_;
				_tmp32_ = self->priv->keypress_handlers;
				_tmp33_ = handler;
				_tmp33__target = handler_target;
				nibbles_window_delegate_stack_remove (_tmp32_, _tmp33_, _tmp33__target);
			}
			_nibbles_window_delegate_stack_delegate_stack_iterator_unref0 (_handler_it);
		}
		result = FALSE;
		_nibbles_window_delegate_stack_unref0 (handlers_to_remove);
		return result;
	}
}

static gboolean
__nibbles_window___lambda44__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state,
                                                                   gpointer self)
{
	gboolean result;
	result = _nibbles_window___lambda44_ ((NibblesWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static void
_nibbles_window___lambda45_ (NibblesWindow* self)
{
	_vala_assert (FALSE, "false");
}

static void
__nibbles_window___lambda45__gtk_event_controller_key_im_update (GtkEventControllerKey* _sender,
                                                                 gpointer self)
{
	_nibbles_window___lambda45_ ((NibblesWindow*) self);
}

static void
_nibbles_window_log_score_cb_nibbles_game_log_score (NibblesGame* _sender,
                                                     gint score,
                                                     gint level_reached,
                                                     gpointer self)
{
	nibbles_window_log_score_cb ((NibblesWindow*) self, score, level_reached);
}

static void
_nibbles_window_level_completed_cb_nibbles_game_level_completed (NibblesGame* _sender,
                                                                 gpointer self)
{
	nibbles_window_level_completed_cb ((NibblesWindow*) self);
}

static gchar*
_nibbles_window___lambda46_ (NibblesWindow* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (PKGDATADIR);
	result = _tmp0_;
	return result;
}

static gchar*
__nibbles_window___lambda46__nibbles_game_get_pkgdatadir (NibblesGame* _sender,
                                                          gpointer self)
{
	gchar* result;
	result = _nibbles_window___lambda46_ ((NibblesWindow*) self);
	return result;
}

static gboolean
_nibbles_window___lambda47_ (NibblesWindow* self,
                             KeypressHandlerFunction handler,
                             gpointer handler_target)
{
	gboolean result;
	if (handler != NULL) {
		NibblesWindowDelegateStack* _tmp0_;
		_tmp0_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_push (_tmp0_, handler, handler_target);
	} else {
		NibblesWindowDelegateStack* _tmp1_;
		_tmp1_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_pop (_tmp1_);
	}
	result = TRUE;
	return result;
}

static gboolean
__nibbles_window___lambda47__nibbles_game_add_keypress_handler (NibblesGame* _sender,
                                                                KeypressHandlerFunction keypress_handler,
                                                                gpointer keypress_handler_target,
                                                                gpointer self)
{
	gboolean result;
	result = _nibbles_window___lambda47_ ((NibblesWindow*) self, keypress_handler, keypress_handler_target);
	return result;
}

static gint
_nibbles_window_countdown_active_nibbles_view_countdown_active_function (gpointer self)
{
	gint result;
	result = nibbles_window_countdown_active ((NibblesWindow*) self);
	return result;
}

static gboolean
_nibbles_window_fullscreen_active_nibbles_view_fullscreen_active_function (gpointer self)
{
	gboolean result;
	result = nibbles_window_fullscreen_active ((NibblesWindow*) self);
	return result;
}

static void
_nibbles_window___lambda48_ (NibblesWindow* self,
                             KeypressHandlerFunction handler,
                             gpointer handler_target)
{
	if (handler != NULL) {
		NibblesWindowDelegateStack* _tmp0_;
		_tmp0_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_push (_tmp0_, handler, handler_target);
	} else {
		NibblesWindowDelegateStack* _tmp1_;
		_tmp1_ = self->priv->keypress_handlers;
		nibbles_window_delegate_stack_pop (_tmp1_);
	}
}

static void
__nibbles_window___lambda48__controls_add_keypress_handler (Controls* _sender,
                                                            KeypressHandlerFunction handler,
                                                            gpointer handler_target,
                                                            gpointer self)
{
	_nibbles_window___lambda48_ ((NibblesWindow*) self, handler, handler_target);
}

static GObject *
nibbles_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NibblesWindow * self;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GAction* _tmp10_;
	GSimpleAction* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GAction* _tmp15_;
	GAction* _tmp16_;
	GSettings* _tmp17_;
	GAction* _tmp18_;
	GAction* _tmp19_;
	GeeArrayList* _tmp20_;
	GtkMenuButton* _tmp31_;
	GtkPopover* _tmp32_;
	GSettings* _tmp33_;
	GSettings* _tmp34_;
	GSettings* _tmp35_;
	GtkEventControllerKey* key_controller = NULL;
	GtkEventControllerKey* _tmp36_;
	GtkEventControllerKey* _tmp37_;
	GtkEventControllerKey* _tmp38_;
	GtkEventControllerKey* _tmp39_;
	GtkEventController* _tmp40_;
	gboolean three_dimensional_view = FALSE;
	GSettings* _tmp41_;
	GSettings* _tmp42_;
	Sound* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	GSettings* _tmp46_;
	GSettings* _tmp47_;
	NibblesGame* _tmp48_;
	NibblesGame* _tmp49_;
	NibblesGame* _tmp50_;
	Sound* _tmp51_;
	NibblesGame* _tmp52_;
	NibblesGame* _tmp53_;
	NibblesGame* _tmp54_;
	NibblesGame* _tmp55_;
	NibblesView* _tmp56_;
	NibblesView* _tmp57_;
	NibblesView* _tmp58_;
	GtkBox* _tmp59_;
	NibblesView* _tmp60_;
	NibblesView* _tmp61_;
	NibblesGame* _tmp62_;
	GSettings* _tmp63_;
	gint numai = 0;
	GSettings* _tmp64_;
	NibblesGame* _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	NibblesGame* _tmp74_;
	Players* _tmp75_;
	NibblesGame* _tmp76_;
	gint _tmp77_;
	gint _tmp78_;
	BoardProgress* _tmp79_;
	GSettings* _tmp80_;
	GSettings* _tmp81_;
	Speed* _tmp82_;
	GSettings* _tmp83_;
	GSettings* _tmp84_;
	Controls* _tmp85_;
	SetupScreen _tmp86_;
	parent_class = G_OBJECT_CLASS (nibbles_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_WINDOW, NibblesWindow);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_WINDOW_menu_entries, (gint) G_N_ELEMENTS (NIBBLES_WINDOW_menu_entries), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "hamburger");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->hamburger_action);
	self->priv->hamburger_action = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "fullscreen");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->fullscreen_action);
	self->priv->fullscreen_action = _tmp5_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp7_;
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) self, "back");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp9_;
	_tmp10_ = g_action_map_lookup_action ((GActionMap*) self, "start-game");
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->start_game_action);
	self->priv->start_game_action = _tmp11_;
	_tmp12_ = g_settings_new ("org.gnome.Nibbles");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp12_;
	_tmp13_ = self->priv->settings;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) _nibbles_window_settings_changed_cb_g_settings_changed, self, 0);
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_settings_create_action (_tmp14_, "sound");
	_tmp16_ = _tmp15_;
	g_action_map_add_action ((GActionMap*) self, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->settings;
	_tmp18_ = g_settings_create_action (_tmp17_, "three-dimensional-view");
	_tmp19_ = _tmp18_;
	g_action_map_add_action ((GActionMap*) self, _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = gee_array_list_new (g_settings_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->worm_settings);
	self->priv->worm_settings = _tmp20_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gchar* name = NULL;
				gchar* _tmp23_;
				GeeArrayList* _tmp24_;
				const gchar* _tmp25_;
				GSettings* _tmp26_;
				GSettings* _tmp27_;
				GeeArrayList* _tmp28_;
				gpointer _tmp29_;
				GSettings* _tmp30_;
				if (!_tmp21_) {
					gint _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < NIBBLES_GAME_MAX_WORMS)) {
					break;
				}
				_tmp23_ = g_strdup_printf ("org.gnome.Nibbles.worm%d", i);
				name = _tmp23_;
				_tmp24_ = self->priv->worm_settings;
				_tmp25_ = name;
				_tmp26_ = g_settings_new (_tmp25_);
				_tmp27_ = _tmp26_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp27_);
				_g_object_unref0 (_tmp27_);
				_tmp28_ = self->priv->worm_settings;
				_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, i);
				_tmp30_ = (GSettings*) _tmp29_;
				g_signal_connect_object (_tmp30_, "changed", (GCallback) _nibbles_window_worm_settings_changed_cb_g_settings_changed, self, 0);
				_g_object_unref0 (_tmp30_);
				_g_free0 (name);
			}
		}
	}
	_tmp31_ = self->priv->hamburger_menu;
	_tmp32_ = gtk_menu_button_get_popover (_tmp31_);
	g_signal_connect_object (_tmp32_, "closed", (GCallback) __nibbles_window___lambda43__gtk_popover_closed, self, 0);
	_tmp33_ = self->priv->settings;
	_tmp34_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp33_, "window-width"), g_settings_get_int (_tmp34_, "window-height"));
	_tmp35_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp35_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	_tmp36_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
	key_controller = _tmp36_;
	_tmp37_ = key_controller;
	g_signal_connect_object (_tmp37_, "key-pressed", (GCallback) __nibbles_window___lambda44__gtk_event_controller_key_key_pressed, self, 0);
	_tmp38_ = key_controller;
	g_signal_connect_object (_tmp38_, "im-update", (GCallback) __nibbles_window___lambda45__gtk_event_controller_key_im_update, self, 0);
	_tmp39_ = key_controller;
	_tmp40_ = _g_object_ref0 ((GtkEventController*) _tmp39_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp40_);
	_tmp41_ = self->priv->settings;
	three_dimensional_view = g_settings_get_boolean (_tmp41_, "three-dimensional-view");
	_tmp42_ = self->priv->settings;
	_tmp43_ = sound_new (!g_settings_get_boolean (_tmp42_, "sound"));
	_g_object_unref0 (self->priv->sound);
	self->priv->sound = _tmp43_;
	_tmp44_ = nibbles_window_get_start_level (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = self->priv->settings;
	_tmp47_ = self->priv->settings;
	_tmp48_ = nibbles_game_new (_tmp45_, g_settings_get_int (_tmp46_, "speed"), 35, g_settings_get_boolean (_tmp47_, "fakes"), three_dimensional_view, NIBBLES_VIEW_WIDTH, NIBBLES_VIEW_HEIGHT, FALSE);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp48_;
	_tmp49_ = self->priv->game;
	g_signal_connect_object (_tmp49_, "log-score", (GCallback) _nibbles_window_log_score_cb_nibbles_game_log_score, self, 0);
	_tmp50_ = self->priv->game;
	g_signal_connect_object (_tmp50_, "level-completed", (GCallback) _nibbles_window_level_completed_cb_nibbles_game_level_completed, self, 0);
	_tmp51_ = self->priv->sound;
	_tmp52_ = self->priv->game;
	sound_connect_signal (_tmp51_, _tmp52_);
	_tmp53_ = self->priv->game;
	g_signal_connect_object (_tmp53_, "get-pkgdatadir", (GCallback) __nibbles_window___lambda46__nibbles_game_get_pkgdatadir, self, 0);
	_tmp54_ = self->priv->game;
	g_signal_connect_object (_tmp54_, "add-keypress-handler", (GCallback) __nibbles_window___lambda47__nibbles_game_add_keypress_handler, self, 0);
	_tmp55_ = self->priv->game;
	_tmp56_ = nibbles_view_new (_tmp55_, _nibbles_window_countdown_active_nibbles_view_countdown_active_function, self, _nibbles_window_fullscreen_active_nibbles_view_fullscreen_active_function, self);
	g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp56_;
	_tmp57_ = self->priv->view;
	gtk_widget_set_visible ((GtkWidget*) _tmp57_, TRUE);
	_tmp58_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp58_, TRUE);
	_tmp59_ = self->priv->game_box;
	_tmp60_ = self->priv->view;
	gtk_box_prepend (_tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = self->priv->view;
	gtk_root_set_focus ((GtkRoot*) self, (GtkWidget*) _tmp61_);
	_tmp62_ = self->priv->game;
	_tmp63_ = self->priv->settings;
	nibbles_game_set_numhumans (_tmp62_, g_settings_get_int (_tmp63_, "players"));
	_tmp64_ = self->priv->settings;
	numai = g_settings_get_int (_tmp64_, "ai");
	_tmp65_ = self->priv->game;
	_tmp66_ = nibbles_game_get_numhumans (_tmp65_);
	_tmp67_ = _tmp66_;
	if ((numai + _tmp67_) > NIBBLES_GAME_MAX_WORMS) {
		NibblesGame* _tmp68_;
		GSettings* _tmp69_;
		NibblesGame* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		GSettings* _tmp73_;
		_tmp68_ = self->priv->game;
		nibbles_game_set_numhumans (_tmp68_, 1);
		numai = 5;
		_tmp69_ = self->priv->settings;
		_tmp70_ = self->priv->game;
		_tmp71_ = nibbles_game_get_numhumans (_tmp70_);
		_tmp72_ = _tmp71_;
		g_settings_set_int (_tmp69_, "players", _tmp72_);
		_tmp73_ = self->priv->settings;
		g_settings_set_int (_tmp73_, "ai", numai);
	}
	_tmp74_ = self->priv->game;
	nibbles_game_set_numai (_tmp74_, numai);
	_tmp75_ = self->priv->players;
	_tmp76_ = self->priv->game;
	_tmp77_ = nibbles_game_get_numhumans (_tmp76_);
	_tmp78_ = _tmp77_;
	players_set_values (_tmp75_, _tmp78_, numai);
	_tmp79_ = self->priv->board_progress;
	_tmp80_ = self->priv->settings;
	_tmp81_ = self->priv->settings;
	board_progress_set_values (_tmp79_, g_settings_get_int (_tmp80_, "progress"), g_settings_get_int (_tmp81_, "start-level"));
	_tmp82_ = self->priv->speed;
	_tmp83_ = self->priv->settings;
	_tmp84_ = self->priv->settings;
	speed_set_values (_tmp82_, g_settings_get_int (_tmp83_, "speed"), g_settings_get_boolean (_tmp84_, "fakes"));
	_tmp85_ = self->priv->controls;
	g_signal_connect_object (_tmp85_, "add-keypress-handler", (GCallback) __nibbles_window___lambda48__controls_add_keypress_handler, self, 0);
	_tmp86_ = self->priv->_start_screen;
	if (_tmp86_ == SETUP_SCREEN_GAME) {
		NibblesGame* _tmp87_;
		GSettings* _tmp88_;
		NibblesGame* _tmp89_;
		GSettings* _tmp90_;
		NibblesGame* _tmp91_;
		GSettings* _tmp92_;
		NibblesGame* _tmp93_;
		GSettings* _tmp94_;
		NibblesGame* _tmp95_;
		GeeArrayList* _tmp96_;
		_tmp87_ = self->priv->game;
		_tmp88_ = self->priv->settings;
		nibbles_game_set_numhumans (_tmp87_, g_settings_get_int (_tmp88_, "players"));
		_tmp89_ = self->priv->game;
		_tmp90_ = self->priv->settings;
		nibbles_game_set_numai (_tmp89_, g_settings_get_int (_tmp90_, "ai"));
		_tmp91_ = self->priv->game;
		_tmp92_ = self->priv->settings;
		nibbles_game_set_speed (_tmp91_, g_settings_get_int (_tmp92_, "speed"));
		_tmp93_ = self->priv->game;
		_tmp94_ = self->priv->settings;
		nibbles_game_set_fakes (_tmp93_, g_settings_get_boolean (_tmp94_, "fakes"));
		_tmp95_ = self->priv->game;
		_tmp96_ = self->priv->worm_settings;
		nibbles_game_create_worms (_tmp95_, _tmp96_);
		nibbles_window_start_game (self);
	} else {
		SetupScreen _tmp97_;
		_tmp97_ = self->priv->_start_screen;
		if (_tmp97_ == SETUP_SCREEN_CONTROLS) {
			NibblesGame* _tmp98_;
			GSettings* _tmp99_;
			NibblesGame* _tmp100_;
			GSettings* _tmp101_;
			NibblesGame* _tmp102_;
			GSettings* _tmp103_;
			NibblesGame* _tmp104_;
			GSettings* _tmp105_;
			_tmp98_ = self->priv->game;
			_tmp99_ = self->priv->settings;
			nibbles_game_set_numhumans (_tmp98_, g_settings_get_int (_tmp99_, "players"));
			_tmp100_ = self->priv->game;
			_tmp101_ = self->priv->settings;
			nibbles_game_set_numai (_tmp100_, g_settings_get_int (_tmp101_, "ai"));
			_tmp102_ = self->priv->game;
			_tmp103_ = self->priv->settings;
			nibbles_game_set_speed (_tmp102_, g_settings_get_int (_tmp103_, "speed"));
			_tmp104_ = self->priv->game;
			_tmp105_ = self->priv->settings;
			nibbles_game_set_fakes (_tmp104_, g_settings_get_boolean (_tmp105_, "fakes"));
			nibbles_window_show_controls_screen (self);
		} else {
			SetupScreen _tmp106_;
			_tmp106_ = self->priv->_start_screen;
			if (_tmp106_ == SETUP_SCREEN_SPEED) {
				NibblesGame* _tmp107_;
				GSettings* _tmp108_;
				NibblesGame* _tmp109_;
				GSettings* _tmp110_;
				GtkStack* _tmp111_;
				_tmp107_ = self->priv->game;
				_tmp108_ = self->priv->settings;
				nibbles_game_set_numhumans (_tmp107_, g_settings_get_int (_tmp108_, "players"));
				_tmp109_ = self->priv->game;
				_tmp110_ = self->priv->settings;
				nibbles_game_set_numai (_tmp109_, g_settings_get_int (_tmp110_, "ai"));
				_tmp111_ = self->priv->main_stack;
				gtk_stack_set_visible_child_name (_tmp111_, "speed");
			} else {
				GSettings* _tmp112_;
				_tmp112_ = self->priv->settings;
				if (g_settings_get_boolean (_tmp112_, "first-run")) {
					FirstRun* first_run_panel = NULL;
					FirstRun* _tmp113_;
					FirstRun* _tmp114_;
					GtkStack* _tmp115_;
					FirstRun* _tmp116_;
					GSimpleAction* _tmp117_;
					GSimpleAction* _tmp118_;
					GSimpleAction* _tmp119_;
					GtkStack* _tmp120_;
					FirstRun* _tmp121_;
					_tmp113_ = first_run_new ();
					g_object_ref_sink (_tmp113_);
					first_run_panel = _tmp113_;
					_tmp114_ = first_run_panel;
					gtk_widget_set_visible ((GtkWidget*) _tmp114_, TRUE);
					_tmp115_ = self->priv->main_stack;
					_tmp116_ = first_run_panel;
					gtk_stack_add_named (_tmp115_, (GtkWidget*) _tmp116_, "first-run");
					_tmp117_ = self->priv->new_game_action;
					g_simple_action_set_enabled (_tmp117_, TRUE);
					_tmp118_ = self->priv->pause_action;
					g_simple_action_set_enabled (_tmp118_, FALSE);
					_tmp119_ = self->priv->back_action;
					g_simple_action_set_enabled (_tmp119_, FALSE);
					_tmp120_ = self->priv->main_stack;
					_tmp121_ = first_run_panel;
					gtk_stack_set_visible_child (_tmp120_, (GtkWidget*) _tmp121_);
					_g_object_unref0 (first_run_panel);
				} else {
					nibbles_window_show_new_game_screen (self, FALSE);
				}
			}
		}
	}
	nibbles_window_create_scores (self);
	_g_object_unref0 (key_controller);
	return obj;
}

static void
nibbles_window_class_init (NibblesWindowClass * klass,
                           gpointer klass_data)
{
	nibbles_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = nibbles_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = nibbles_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY] = g_param_spec_int ("cli-start-level", "cli-start-level", "cli-start-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_PROGRESS_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_PROGRESS_PROPERTY] = g_param_spec_int ("progress", "progress", "progress", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_START_SCREEN_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_START_SCREEN_PROPERTY] = g_param_spec_enum ("start-screen", "start-screen", "start-screen", TYPE_SETUP_SCREEN, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_WINDOW_GAME_PAUSED_PROPERTY, nibbles_window_properties[NIBBLES_WINDOW_GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("game-paused", "game-paused", "game-paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/nibbles-adw.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toolbar", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, toolbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_button", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, pause_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hamburger_menu", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, hamburger_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, players));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "speed", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, speed));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "board_progress", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, board_progress));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "controls", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, controls));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "statusbar_stack", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, statusbar_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scoreboard", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, scoreboard));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, NibblesWindow_private_offset + G_STRUCT_OFFSET (NibblesWindowPrivate, game_box));
}

static void
nibbles_window_instance_init (NibblesWindow * self,
                              gpointer klass)
{
	NibblesWindowDelegateStack* _tmp0_;
	GeeArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	gchar* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	gchar* _tmp141_;
	gchar* _tmp142_;
	gchar* _tmp143_;
	gchar* _tmp144_;
	gchar* _tmp145_;
	gchar* _tmp146_;
	gchar* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	gchar* _tmp150_;
	gchar* _tmp151_;
	gchar* _tmp152_;
	gchar* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	gchar* _tmp156_;
	gchar* _tmp157_;
	gchar* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	gchar* _tmp161_;
	gchar* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	gchar* _tmp165_;
	gchar* _tmp166_;
	gchar* _tmp167_;
	gchar* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	gchar* _tmp173_;
	gchar* _tmp174_;
	gchar* _tmp175_;
	gchar* _tmp176_;
	gchar* _tmp177_;
	gchar* _tmp178_;
	gchar* _tmp179_;
	gchar* _tmp180_;
	gchar* _tmp181_;
	gchar* _tmp182_;
	gchar* _tmp183_;
	gchar* _tmp184_;
	gchar* _tmp185_;
	gchar* _tmp186_;
	gchar* _tmp187_;
	gchar* _tmp188_;
	gchar* _tmp189_;
	gchar* _tmp190_;
	gchar* _tmp191_;
	gchar* _tmp192_;
	gchar* _tmp193_;
	gchar* _tmp194_;
	gchar* _tmp195_;
	gchar* _tmp196_;
	gchar* _tmp197_;
	gchar* _tmp198_;
	gchar* _tmp199_;
	gchar* _tmp200_;
	gchar* _tmp201_;
	gchar* _tmp202_;
	gchar* _tmp203_;
	gchar* _tmp204_;
	gchar* _tmp205_;
	gchar* _tmp206_;
	gchar* _tmp207_;
	gchar* _tmp208_;
	gchar* _tmp209_;
	gchar* _tmp210_;
	gchar* _tmp211_;
	gchar* _tmp212_;
	gchar* _tmp213_;
	gchar* _tmp214_;
	gchar* _tmp215_;
	gchar* _tmp216_;
	gchar* _tmp217_;
	gchar* _tmp218_;
	gchar* _tmp219_;
	gchar* _tmp220_;
	gchar* _tmp221_;
	gchar* _tmp222_;
	gchar* _tmp223_;
	gchar* _tmp224_;
	gchar* _tmp225_;
	gchar* _tmp226_;
	gchar* _tmp227_;
	gchar* _tmp228_;
	gchar* _tmp229_;
	gchar* _tmp230_;
	gchar* _tmp231_;
	gchar* _tmp232_;
	gchar* _tmp233_;
	gchar* _tmp234_;
	gchar* _tmp235_;
	gchar* _tmp236_;
	gchar* _tmp237_;
	gchar* _tmp238_;
	gchar* _tmp239_;
	gchar* _tmp240_;
	gchar* _tmp241_;
	gchar* _tmp242_;
	gchar* _tmp243_;
	gchar* _tmp244_;
	gchar* _tmp245_;
	gchar* _tmp246_;
	gchar* _tmp247_;
	gchar* _tmp248_;
	gchar* _tmp249_;
	gchar* _tmp250_;
	gchar* _tmp251_;
	gchar* _tmp252_;
	gchar* _tmp253_;
	gchar* _tmp254_;
	gchar* _tmp255_;
	gchar* _tmp256_;
	gchar* _tmp257_;
	gchar* _tmp258_;
	gchar* _tmp259_;
	gchar* _tmp260_;
	gchar* _tmp261_;
	gchar* _tmp262_;
	gchar* _tmp263_;
	gchar* _tmp264_;
	gchar* _tmp265_;
	gchar* _tmp266_;
	gchar* _tmp267_;
	gchar* _tmp268_;
	gchar* _tmp269_;
	gchar* _tmp270_;
	gchar* _tmp271_;
	gchar* _tmp272_;
	gchar* _tmp273_;
	gchar* _tmp274_;
	gchar* _tmp275_;
	gchar* _tmp276_;
	gchar* _tmp277_;
	gchar* _tmp278_;
	gchar* _tmp279_;
	gchar* _tmp280_;
	gchar* _tmp281_;
	gchar* _tmp282_;
	gchar* _tmp283_;
	gchar* _tmp284_;
	gchar* _tmp285_;
	gchar* _tmp286_;
	gchar* _tmp287_;
	gchar* _tmp288_;
	gchar* _tmp289_;
	gchar* _tmp290_;
	gchar* _tmp291_;
	gchar* _tmp292_;
	gchar* _tmp293_;
	gchar* _tmp294_;
	gchar* _tmp295_;
	gchar* _tmp296_;
	gchar* _tmp297_;
	gchar* _tmp298_;
	gchar* _tmp299_;
	gchar* _tmp300_;
	gchar* _tmp301_;
	gchar* _tmp302_;
	gchar* _tmp303_;
	gchar* _tmp304_;
	gchar* _tmp305_;
	gchar* _tmp306_;
	gchar* _tmp307_;
	gchar* _tmp308_;
	gchar* _tmp309_;
	gchar* _tmp310_;
	gchar* _tmp311_;
	gchar* _tmp312_;
	gchar* _tmp313_;
	gchar* _tmp314_;
	gchar* _tmp315_;
	gchar* _tmp316_;
	gchar* _tmp317_;
	gchar* _tmp318_;
	gchar* _tmp319_;
	gchar* _tmp320_;
	gchar* _tmp321_;
	gchar* _tmp322_;
	gchar* _tmp323_;
	gchar* _tmp324_;
	gchar* _tmp325_;
	gchar* _tmp326_;
	gchar* _tmp327_;
	gchar* _tmp328_;
	gchar* _tmp329_;
	gchar* _tmp330_;
	gchar* _tmp331_;
	gchar* _tmp332_;
	gchar* _tmp333_;
	gchar* _tmp334_;
	gchar* _tmp335_;
	gchar* _tmp336_;
	gchar* _tmp337_;
	gchar* _tmp338_;
	gchar* _tmp339_;
	gchar* _tmp340_;
	gchar* _tmp341_;
	gchar* _tmp342_;
	gchar* _tmp343_;
	gchar* _tmp344_;
	gchar* _tmp345_;
	gchar* _tmp346_;
	gchar* _tmp347_;
	gchar* _tmp348_;
	gchar* _tmp349_;
	gchar* _tmp350_;
	gchar* _tmp351_;
	gchar* _tmp352_;
	gchar* _tmp353_;
	gchar* _tmp354_;
	gchar* _tmp355_;
	gchar* _tmp356_;
	gchar* _tmp357_;
	gchar* _tmp358_;
	gchar* _tmp359_;
	gchar* _tmp360_;
	gchar* _tmp361_;
	gchar* _tmp362_;
	gchar* _tmp363_;
	gchar* _tmp364_;
	gchar* _tmp365_;
	gchar* _tmp366_;
	gchar* _tmp367_;
	gchar* _tmp368_;
	gchar* _tmp369_;
	gchar* _tmp370_;
	gchar* _tmp371_;
	gchar* _tmp372_;
	gchar* _tmp373_;
	gchar* _tmp374_;
	gchar* _tmp375_;
	gchar* _tmp376_;
	gchar* _tmp377_;
	gchar* _tmp378_;
	gchar* _tmp379_;
	gchar* _tmp380_;
	gchar* _tmp381_;
	gchar* _tmp382_;
	gchar* _tmp383_;
	gchar* _tmp384_;
	gchar* _tmp385_;
	gchar* _tmp386_;
	gchar* _tmp387_;
	gchar* _tmp388_;
	gchar* _tmp389_;
	gchar* _tmp390_;
	gchar* _tmp391_;
	gchar* _tmp392_;
	gchar* _tmp393_;
	gchar* _tmp394_;
	gchar* _tmp395_;
	gchar* _tmp396_;
	gchar* _tmp397_;
	gchar* _tmp398_;
	gchar* _tmp399_;
	gchar* _tmp400_;
	gchar* _tmp401_;
	gchar* _tmp402_;
	gchar* _tmp403_;
	gchar* _tmp404_;
	gchar* _tmp405_;
	gchar* _tmp406_;
	gchar* _tmp407_;
	gchar* _tmp408_;
	gchar* _tmp409_;
	gchar* _tmp410_;
	gchar* _tmp411_;
	gchar* _tmp412_;
	gchar* _tmp413_;
	gchar* _tmp414_;
	gchar* _tmp415_;
	gchar* _tmp416_;
	gchar* _tmp417_;
	gchar* _tmp418_;
	gchar* _tmp419_;
	gchar* _tmp420_;
	gchar* _tmp421_;
	gchar* _tmp422_;
	gchar* _tmp423_;
	gchar* _tmp424_;
	gchar* _tmp425_;
	gchar* _tmp426_;
	gchar* _tmp427_;
	gchar* _tmp428_;
	gchar* _tmp429_;
	gchar* _tmp430_;
	gchar* _tmp431_;
	gchar* _tmp432_;
	gchar* _tmp433_;
	gchar* _tmp434_;
	gchar* _tmp435_;
	gchar* _tmp436_;
	gchar* _tmp437_;
	gchar* _tmp438_;
	gchar* _tmp439_;
	gchar* _tmp440_;
	gchar* _tmp441_;
	gchar** _tmp442_;
	GamesScoresCategory** _tmp443_;
	self->priv = nibbles_window_get_instance_private (self);
	self->priv->fullscreen_mode = FALSE;
	_tmp0_ = nibbles_window_delegate_stack_new ();
	self->priv->keypress_handlers = _tmp0_;
	self->priv->game = NULL;
	self->priv->countdown_id = (guint) 0;
	self->priv->seconds = 0;
	self->priv->dialog_visible = FALSE;
	_tmp1_ = gee_array_list_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->overlay_members = _tmp1_;
	_tmp2_ = g_strdup ("beginner");
	_tmp3_ = g_strdup (_ ("Beginner"));
	_tmp4_ = g_strdup ("beginner-random");
	_tmp5_ = g_strdup (_ ("Beginner with random levels"));
	_tmp6_ = g_strdup ("beginner-fixed1");
	_tmp7_ = g_strdup (_ ("Beginner, fixed on level 1"));
	_tmp8_ = g_strdup ("beginner-fixed2");
	_tmp9_ = g_strdup (_ ("Beginner, fixed on level 2"));
	_tmp10_ = g_strdup ("beginner-fixed3");
	_tmp11_ = g_strdup (_ ("Beginner, fixed on level 3"));
	_tmp12_ = g_strdup ("beginner-fixed4");
	_tmp13_ = g_strdup (_ ("Beginner, fixed on level 4"));
	_tmp14_ = g_strdup ("beginner-fixed5");
	_tmp15_ = g_strdup (_ ("Beginner, fixed on level 5"));
	_tmp16_ = g_strdup ("beginner-fixed6");
	_tmp17_ = g_strdup (_ ("Beginner, fixed on level 6"));
	_tmp18_ = g_strdup ("beginner-fixed7");
	_tmp19_ = g_strdup (_ ("Beginner, fixed on level 7"));
	_tmp20_ = g_strdup ("beginner-fixed8");
	_tmp21_ = g_strdup (_ ("Beginner, fixed on level 8"));
	_tmp22_ = g_strdup ("beginner-fixed9");
	_tmp23_ = g_strdup (_ ("Beginner, fixed on level 9"));
	_tmp24_ = g_strdup ("beginner-fixed10");
	_tmp25_ = g_strdup (_ ("Beginner, fixed on level 10"));
	_tmp26_ = g_strdup ("beginner-fixed11");
	_tmp27_ = g_strdup (_ ("Beginner, fixed on level 11"));
	_tmp28_ = g_strdup ("beginner-fixed12");
	_tmp29_ = g_strdup (_ ("Beginner, fixed on level 12"));
	_tmp30_ = g_strdup ("beginner-fixed13");
	_tmp31_ = g_strdup (_ ("Beginner, fixed on level 13"));
	_tmp32_ = g_strdup ("beginner-fixed14");
	_tmp33_ = g_strdup (_ ("Beginner, fixed on level 14"));
	_tmp34_ = g_strdup ("beginner-fixed15");
	_tmp35_ = g_strdup (_ ("Beginner, fixed on level 15"));
	_tmp36_ = g_strdup ("beginner-fixed16");
	_tmp37_ = g_strdup (_ ("Beginner, fixed on level 16"));
	_tmp38_ = g_strdup ("beginner-fixed17");
	_tmp39_ = g_strdup (_ ("Beginner, fixed on level 17"));
	_tmp40_ = g_strdup ("beginner-fixed18");
	_tmp41_ = g_strdup (_ ("Beginner, fixed on level 18"));
	_tmp42_ = g_strdup ("beginner-fixed19");
	_tmp43_ = g_strdup (_ ("Beginner, fixed on level 19"));
	_tmp44_ = g_strdup ("beginner-fixed20");
	_tmp45_ = g_strdup (_ ("Beginner, fixed on level 20"));
	_tmp46_ = g_strdup ("beginner-fixed21");
	_tmp47_ = g_strdup (_ ("Beginner, fixed on level 21"));
	_tmp48_ = g_strdup ("beginner-fixed22");
	_tmp49_ = g_strdup (_ ("Beginner, fixed on level 22"));
	_tmp50_ = g_strdup ("beginner-fixed23");
	_tmp51_ = g_strdup (_ ("Beginner, fixed on level 23"));
	_tmp52_ = g_strdup ("beginner-fixed24");
	_tmp53_ = g_strdup (_ ("Beginner, fixed on level 24"));
	_tmp54_ = g_strdup ("beginner-fixed25");
	_tmp55_ = g_strdup (_ ("Beginner, fixed on level 25"));
	_tmp56_ = g_strdup ("beginner-fixed26");
	_tmp57_ = g_strdup (_ ("Beginner, fixed on level 26"));
	_tmp58_ = g_strdup ("beginner-fakes-random");
	_tmp59_ = g_strdup (_ ("Beginner with fakes and random levels"));
	_tmp60_ = g_strdup ("beginner-fakes-fixed1");
	_tmp61_ = g_strdup (_ ("Beginner with fakes, fixed on level 1"));
	_tmp62_ = g_strdup ("beginner-fakes-fixed2");
	_tmp63_ = g_strdup (_ ("Beginner with fakes, fixed on level 2"));
	_tmp64_ = g_strdup ("beginner-fakes-fixed3");
	_tmp65_ = g_strdup (_ ("Beginner with fakes, fixed on level 3"));
	_tmp66_ = g_strdup ("beginner-fakes-fixed4");
	_tmp67_ = g_strdup (_ ("Beginner with fakes, fixed on level 4"));
	_tmp68_ = g_strdup ("beginner-fakes-fixed5");
	_tmp69_ = g_strdup (_ ("Beginner with fakes, fixed on level 5"));
	_tmp70_ = g_strdup ("beginner-fakes-fixed6");
	_tmp71_ = g_strdup (_ ("Beginner with fakes, fixed on level 6"));
	_tmp72_ = g_strdup ("beginner-fakes-fixed7");
	_tmp73_ = g_strdup (_ ("Beginner with fakes, fixed on level 7"));
	_tmp74_ = g_strdup ("beginner-fakes-fixed8");
	_tmp75_ = g_strdup (_ ("Beginner with fakes, fixed on level 8"));
	_tmp76_ = g_strdup ("beginner-fakes-fixed9");
	_tmp77_ = g_strdup (_ ("Beginner with fakes, fixed on level 9"));
	_tmp78_ = g_strdup ("beginner-fakes-fixed10");
	_tmp79_ = g_strdup (_ ("Beginner with fakes, fixed on level 10"));
	_tmp80_ = g_strdup ("beginner-fakes-fixed11");
	_tmp81_ = g_strdup (_ ("Beginner with fakes, fixed on level 11"));
	_tmp82_ = g_strdup ("beginner-fakes-fixed12");
	_tmp83_ = g_strdup (_ ("Beginner with fakes, fixed on level 12"));
	_tmp84_ = g_strdup ("beginner-fakes-fixed13");
	_tmp85_ = g_strdup (_ ("Beginner with fakes, fixed on level 13"));
	_tmp86_ = g_strdup ("beginner-fakes-fixed14");
	_tmp87_ = g_strdup (_ ("Beginner with fakes, fixed on level 14"));
	_tmp88_ = g_strdup ("beginner-fakes-fixed15");
	_tmp89_ = g_strdup (_ ("Beginner with fakes, fixed on level 15"));
	_tmp90_ = g_strdup ("beginner-fakes-fixed16");
	_tmp91_ = g_strdup (_ ("Beginner with fakes, fixed on level 16"));
	_tmp92_ = g_strdup ("beginner-fakes-fixed17");
	_tmp93_ = g_strdup (_ ("Beginner with fakes, fixed on level 17"));
	_tmp94_ = g_strdup ("beginner-fakes-fixed18");
	_tmp95_ = g_strdup (_ ("Beginner with fakes, fixed on level 18"));
	_tmp96_ = g_strdup ("beginner-fakes-fixed19");
	_tmp97_ = g_strdup (_ ("Beginner with fakes, fixed on level 19"));
	_tmp98_ = g_strdup ("beginner-fakes-fixed20");
	_tmp99_ = g_strdup (_ ("Beginner with fakes, fixed on level 20"));
	_tmp100_ = g_strdup ("beginner-fakes-fixed21");
	_tmp101_ = g_strdup (_ ("Beginner with fakes, fixed on level 21"));
	_tmp102_ = g_strdup ("beginner-fakes-fixed22");
	_tmp103_ = g_strdup (_ ("Beginner with fakes, fixed on level 22"));
	_tmp104_ = g_strdup ("beginner-fakes-fixed23");
	_tmp105_ = g_strdup (_ ("Beginner with fakes, fixed on level 23"));
	_tmp106_ = g_strdup ("beginner-fakes-fixed24");
	_tmp107_ = g_strdup (_ ("Beginner with fakes, fixed on level 24"));
	_tmp108_ = g_strdup ("beginner-fakes-fixed25");
	_tmp109_ = g_strdup (_ ("Beginner with fakes, fixed on level 25"));
	_tmp110_ = g_strdup ("beginner-fakes-fixed26");
	_tmp111_ = g_strdup (_ ("Beginner with fakes, fixed on level 26"));
	_tmp112_ = g_strdup ("slow");
	_tmp113_ = g_strdup (_ ("Slow"));
	_tmp114_ = g_strdup ("slow-random");
	_tmp115_ = g_strdup (_ ("Slow with random levels"));
	_tmp116_ = g_strdup ("slow-fixed1");
	_tmp117_ = g_strdup (_ ("Slow, fixed on level 1"));
	_tmp118_ = g_strdup ("slow-fixed2");
	_tmp119_ = g_strdup (_ ("Slow, fixed on level 2"));
	_tmp120_ = g_strdup ("slow-fixed3");
	_tmp121_ = g_strdup (_ ("Slow, fixed on level 3"));
	_tmp122_ = g_strdup ("slow-fixed4");
	_tmp123_ = g_strdup (_ ("Slow, fixed on level 4"));
	_tmp124_ = g_strdup ("slow-fixed5");
	_tmp125_ = g_strdup (_ ("Slow, fixed on level 5"));
	_tmp126_ = g_strdup ("slow-fixed6");
	_tmp127_ = g_strdup (_ ("Slow, fixed on level 6"));
	_tmp128_ = g_strdup ("slow-fixed7");
	_tmp129_ = g_strdup (_ ("Slow, fixed on level 7"));
	_tmp130_ = g_strdup ("slow-fixed8");
	_tmp131_ = g_strdup (_ ("Slow, fixed on level 8"));
	_tmp132_ = g_strdup ("slow-fixed9");
	_tmp133_ = g_strdup (_ ("Slow, fixed on level 9"));
	_tmp134_ = g_strdup ("slow-fixed10");
	_tmp135_ = g_strdup (_ ("Slow, fixed on level 10"));
	_tmp136_ = g_strdup ("slow-fixed11");
	_tmp137_ = g_strdup (_ ("Slow, fixed on level 11"));
	_tmp138_ = g_strdup ("slow-fixed12");
	_tmp139_ = g_strdup (_ ("Slow, fixed on level 12"));
	_tmp140_ = g_strdup ("slow-fixed13");
	_tmp141_ = g_strdup (_ ("Slow, fixed on level 13"));
	_tmp142_ = g_strdup ("slow-fixed14");
	_tmp143_ = g_strdup (_ ("Slow, fixed on level 14"));
	_tmp144_ = g_strdup ("slow-fixed15");
	_tmp145_ = g_strdup (_ ("Slow, fixed on level 15"));
	_tmp146_ = g_strdup ("slow-fixed16");
	_tmp147_ = g_strdup (_ ("Slow, fixed on level 16"));
	_tmp148_ = g_strdup ("slow-fixed17");
	_tmp149_ = g_strdup (_ ("Slow, fixed on level 17"));
	_tmp150_ = g_strdup ("slow-fixed18");
	_tmp151_ = g_strdup (_ ("Slow, fixed on level 18"));
	_tmp152_ = g_strdup ("slow-fixed19");
	_tmp153_ = g_strdup (_ ("Slow, fixed on level 19"));
	_tmp154_ = g_strdup ("slow-fixed20");
	_tmp155_ = g_strdup (_ ("Slow, fixed on level 20"));
	_tmp156_ = g_strdup ("slow-fixed21");
	_tmp157_ = g_strdup (_ ("Slow, fixed on level 21"));
	_tmp158_ = g_strdup ("slow-fixed22");
	_tmp159_ = g_strdup (_ ("Slow, fixed on level 22"));
	_tmp160_ = g_strdup ("slow-fixed23");
	_tmp161_ = g_strdup (_ ("Slow, fixed on level 23"));
	_tmp162_ = g_strdup ("slow-fixed24");
	_tmp163_ = g_strdup (_ ("Slow, fixed on level 24"));
	_tmp164_ = g_strdup ("slow-fixed25");
	_tmp165_ = g_strdup (_ ("Slow, fixed on level 25"));
	_tmp166_ = g_strdup ("slow-fixed26");
	_tmp167_ = g_strdup (_ ("Slow, fixed on level 26"));
	_tmp168_ = g_strdup ("slow-fakes-random");
	_tmp169_ = g_strdup (_ ("Slow with fakes and random levels"));
	_tmp170_ = g_strdup ("slow-fakes-fixed1");
	_tmp171_ = g_strdup (_ ("Slow with fakes, fixed on level 1"));
	_tmp172_ = g_strdup ("slow-fakes-fixed2");
	_tmp173_ = g_strdup (_ ("Slow with fakes, fixed on level 2"));
	_tmp174_ = g_strdup ("slow-fakes-fixed3");
	_tmp175_ = g_strdup (_ ("Slow with fakes, fixed on level 3"));
	_tmp176_ = g_strdup ("slow-fakes-fixed4");
	_tmp177_ = g_strdup (_ ("Slow with fakes, fixed on level 4"));
	_tmp178_ = g_strdup ("slow-fakes-fixed5");
	_tmp179_ = g_strdup (_ ("Slow with fakes, fixed on level 5"));
	_tmp180_ = g_strdup ("slow-fakes-fixed6");
	_tmp181_ = g_strdup (_ ("Slow with fakes, fixed on level 6"));
	_tmp182_ = g_strdup ("slow-fakes-fixed7");
	_tmp183_ = g_strdup (_ ("Slow with fakes, fixed on level 7"));
	_tmp184_ = g_strdup ("slow-fakes-fixed8");
	_tmp185_ = g_strdup (_ ("Slow with fakes, fixed on level 8"));
	_tmp186_ = g_strdup ("slow-fakes-fixed9");
	_tmp187_ = g_strdup (_ ("Slow with fakes, fixed on level 9"));
	_tmp188_ = g_strdup ("slow-fakes-fixed10");
	_tmp189_ = g_strdup (_ ("Slow with fakes, fixed on level 10"));
	_tmp190_ = g_strdup ("slow-fakes-fixed11");
	_tmp191_ = g_strdup (_ ("Slow with fakes, fixed on level 11"));
	_tmp192_ = g_strdup ("slow-fakes-fixed12");
	_tmp193_ = g_strdup (_ ("Slow with fakes, fixed on level 12"));
	_tmp194_ = g_strdup ("slow-fakes-fixed13");
	_tmp195_ = g_strdup (_ ("Slow with fakes, fixed on level 13"));
	_tmp196_ = g_strdup ("slow-fakes-fixed14");
	_tmp197_ = g_strdup (_ ("Slow with fakes, fixed on level 14"));
	_tmp198_ = g_strdup ("slow-fakes-fixed15");
	_tmp199_ = g_strdup (_ ("Slow with fakes, fixed on level 15"));
	_tmp200_ = g_strdup ("slow-fakes-fixed16");
	_tmp201_ = g_strdup (_ ("Slow with fakes, fixed on level 16"));
	_tmp202_ = g_strdup ("slow-fakes-fixed17");
	_tmp203_ = g_strdup (_ ("Slow with fakes, fixed on level 17"));
	_tmp204_ = g_strdup ("slow-fakes-fixed18");
	_tmp205_ = g_strdup (_ ("Slow with fakes, fixed on level 18"));
	_tmp206_ = g_strdup ("slow-fakes-fixed19");
	_tmp207_ = g_strdup (_ ("Slow with fakes, fixed on level 19"));
	_tmp208_ = g_strdup ("slow-fakes-fixed20");
	_tmp209_ = g_strdup (_ ("Slow with fakes, fixed on level 20"));
	_tmp210_ = g_strdup ("slow-fakes-fixed21");
	_tmp211_ = g_strdup (_ ("Slow with fakes, fixed on level 21"));
	_tmp212_ = g_strdup ("slow-fakes-fixed22");
	_tmp213_ = g_strdup (_ ("Slow with fakes, fixed on level 22"));
	_tmp214_ = g_strdup ("slow-fakes-fixed23");
	_tmp215_ = g_strdup (_ ("Slow with fakes, fixed on level 23"));
	_tmp216_ = g_strdup ("slow-fakes-fixed24");
	_tmp217_ = g_strdup (_ ("Slow with fakes, fixed on level 24"));
	_tmp218_ = g_strdup ("slow-fakes-fixed25");
	_tmp219_ = g_strdup (_ ("Slow with fakes, fixed on level 25"));
	_tmp220_ = g_strdup ("slow-fakes-fixed26");
	_tmp221_ = g_strdup (_ ("Slow with fakes, fixed on level 26"));
	_tmp222_ = g_strdup ("medium");
	_tmp223_ = g_strdup (_ ("Medium"));
	_tmp224_ = g_strdup ("medium-random");
	_tmp225_ = g_strdup (_ ("Medium with random levels"));
	_tmp226_ = g_strdup ("medium-fixed1");
	_tmp227_ = g_strdup (_ ("Medium, fixed on level 1"));
	_tmp228_ = g_strdup ("medium-fixed2");
	_tmp229_ = g_strdup (_ ("Medium, fixed on level 2"));
	_tmp230_ = g_strdup ("medium-fixed3");
	_tmp231_ = g_strdup (_ ("Medium, fixed on level 3"));
	_tmp232_ = g_strdup ("medium-fixed4");
	_tmp233_ = g_strdup (_ ("Medium, fixed on level 4"));
	_tmp234_ = g_strdup ("medium-fixed5");
	_tmp235_ = g_strdup (_ ("Medium, fixed on level 5"));
	_tmp236_ = g_strdup ("medium-fixed6");
	_tmp237_ = g_strdup (_ ("Medium, fixed on level 6"));
	_tmp238_ = g_strdup ("medium-fixed7");
	_tmp239_ = g_strdup (_ ("Medium, fixed on level 7"));
	_tmp240_ = g_strdup ("medium-fixed8");
	_tmp241_ = g_strdup (_ ("Medium, fixed on level 8"));
	_tmp242_ = g_strdup ("medium-fixed9");
	_tmp243_ = g_strdup (_ ("Medium, fixed on level 9"));
	_tmp244_ = g_strdup ("medium-fixed10");
	_tmp245_ = g_strdup (_ ("Medium, fixed on level 10"));
	_tmp246_ = g_strdup ("medium-fixed11");
	_tmp247_ = g_strdup (_ ("Medium, fixed on level 11"));
	_tmp248_ = g_strdup ("medium-fixed12");
	_tmp249_ = g_strdup (_ ("Medium, fixed on level 12"));
	_tmp250_ = g_strdup ("medium-fixed13");
	_tmp251_ = g_strdup (_ ("Medium, fixed on level 13"));
	_tmp252_ = g_strdup ("medium-fixed14");
	_tmp253_ = g_strdup (_ ("Medium, fixed on level 14"));
	_tmp254_ = g_strdup ("medium-fixed15");
	_tmp255_ = g_strdup (_ ("Medium, fixed on level 15"));
	_tmp256_ = g_strdup ("medium-fixed16");
	_tmp257_ = g_strdup (_ ("Medium, fixed on level 16"));
	_tmp258_ = g_strdup ("medium-fixed17");
	_tmp259_ = g_strdup (_ ("Medium, fixed on level 17"));
	_tmp260_ = g_strdup ("medium-fixed18");
	_tmp261_ = g_strdup (_ ("Medium, fixed on level 18"));
	_tmp262_ = g_strdup ("medium-fixed19");
	_tmp263_ = g_strdup (_ ("Medium, fixed on level 19"));
	_tmp264_ = g_strdup ("medium-fixed20");
	_tmp265_ = g_strdup (_ ("Medium, fixed on level 20"));
	_tmp266_ = g_strdup ("medium-fixed21");
	_tmp267_ = g_strdup (_ ("Medium, fixed on level 21"));
	_tmp268_ = g_strdup ("medium-fixed22");
	_tmp269_ = g_strdup (_ ("Medium, fixed on level 22"));
	_tmp270_ = g_strdup ("medium-fixed23");
	_tmp271_ = g_strdup (_ ("Medium, fixed on level 23"));
	_tmp272_ = g_strdup ("medium-fixed24");
	_tmp273_ = g_strdup (_ ("Medium, fixed on level 24"));
	_tmp274_ = g_strdup ("medium-fixed25");
	_tmp275_ = g_strdup (_ ("Medium, fixed on level 25"));
	_tmp276_ = g_strdup ("medium-fixed26");
	_tmp277_ = g_strdup (_ ("Medium, fixed on level 26"));
	_tmp278_ = g_strdup ("medium-fakes-random");
	_tmp279_ = g_strdup (_ ("Medium with fakes and random levels"));
	_tmp280_ = g_strdup ("medium-fakes-fixed1");
	_tmp281_ = g_strdup (_ ("Medium with fakes, fixed on level 1"));
	_tmp282_ = g_strdup ("medium-fakes-fixed2");
	_tmp283_ = g_strdup (_ ("Medium with fakes, fixed on level 2"));
	_tmp284_ = g_strdup ("medium-fakes-fixed3");
	_tmp285_ = g_strdup (_ ("Medium with fakes, fixed on level 3"));
	_tmp286_ = g_strdup ("medium-fakes-fixed4");
	_tmp287_ = g_strdup (_ ("Medium with fakes, fixed on level 4"));
	_tmp288_ = g_strdup ("medium-fakes-fixed5");
	_tmp289_ = g_strdup (_ ("Medium with fakes, fixed on level 5"));
	_tmp290_ = g_strdup ("medium-fakes-fixed6");
	_tmp291_ = g_strdup (_ ("Medium with fakes, fixed on level 6"));
	_tmp292_ = g_strdup ("medium-fakes-fixed7");
	_tmp293_ = g_strdup (_ ("Medium with fakes, fixed on level 7"));
	_tmp294_ = g_strdup ("medium-fakes-fixed8");
	_tmp295_ = g_strdup (_ ("Medium with fakes, fixed on level 8"));
	_tmp296_ = g_strdup ("medium-fakes-fixed9");
	_tmp297_ = g_strdup (_ ("Medium with fakes, fixed on level 9"));
	_tmp298_ = g_strdup ("medium-fakes-fixed10");
	_tmp299_ = g_strdup (_ ("Medium with fakes, fixed on level 10"));
	_tmp300_ = g_strdup ("medium-fakes-fixed11");
	_tmp301_ = g_strdup (_ ("Medium with fakes, fixed on level 11"));
	_tmp302_ = g_strdup ("medium-fakes-fixed12");
	_tmp303_ = g_strdup (_ ("Medium with fakes, fixed on level 12"));
	_tmp304_ = g_strdup ("medium-fakes-fixed13");
	_tmp305_ = g_strdup (_ ("Medium with fakes, fixed on level 13"));
	_tmp306_ = g_strdup ("medium-fakes-fixed14");
	_tmp307_ = g_strdup (_ ("Medium with fakes, fixed on level 14"));
	_tmp308_ = g_strdup ("medium-fakes-fixed15");
	_tmp309_ = g_strdup (_ ("Medium with fakes, fixed on level 15"));
	_tmp310_ = g_strdup ("medium-fakes-fixed16");
	_tmp311_ = g_strdup (_ ("Medium with fakes, fixed on level 16"));
	_tmp312_ = g_strdup ("medium-fakes-fixed17");
	_tmp313_ = g_strdup (_ ("Medium with fakes, fixed on level 17"));
	_tmp314_ = g_strdup ("medium-fakes-fixed18");
	_tmp315_ = g_strdup (_ ("Medium with fakes, fixed on level 18"));
	_tmp316_ = g_strdup ("medium-fakes-fixed19");
	_tmp317_ = g_strdup (_ ("Medium with fakes, fixed on level 19"));
	_tmp318_ = g_strdup ("medium-fakes-fixed20");
	_tmp319_ = g_strdup (_ ("Medium with fakes, fixed on level 20"));
	_tmp320_ = g_strdup ("medium-fakes-fixed21");
	_tmp321_ = g_strdup (_ ("Medium with fakes, fixed on level 21"));
	_tmp322_ = g_strdup ("medium-fakes-fixed22");
	_tmp323_ = g_strdup (_ ("Medium with fakes, fixed on level 22"));
	_tmp324_ = g_strdup ("medium-fakes-fixed23");
	_tmp325_ = g_strdup (_ ("Medium with fakes, fixed on level 23"));
	_tmp326_ = g_strdup ("medium-fakes-fixed24");
	_tmp327_ = g_strdup (_ ("Medium with fakes, fixed on level 24"));
	_tmp328_ = g_strdup ("medium-fakes-fixed25");
	_tmp329_ = g_strdup (_ ("Medium with fakes, fixed on level 25"));
	_tmp330_ = g_strdup ("medium-fakes-fixed26");
	_tmp331_ = g_strdup (_ ("Medium with fakes, fixed on level 26"));
	_tmp332_ = g_strdup ("fast");
	_tmp333_ = g_strdup (_ ("Fast"));
	_tmp334_ = g_strdup ("fast-random");
	_tmp335_ = g_strdup (_ ("Fast with random levels"));
	_tmp336_ = g_strdup ("fast-fixed1");
	_tmp337_ = g_strdup (_ ("Fast, fixed on level 1"));
	_tmp338_ = g_strdup ("fast-fixed2");
	_tmp339_ = g_strdup (_ ("Fast, fixed on level 2"));
	_tmp340_ = g_strdup ("fast-fixed3");
	_tmp341_ = g_strdup (_ ("Fast, fixed on level 3"));
	_tmp342_ = g_strdup ("fast-fixed4");
	_tmp343_ = g_strdup (_ ("Fast, fixed on level 4"));
	_tmp344_ = g_strdup ("fast-fixed5");
	_tmp345_ = g_strdup (_ ("Fast, fixed on level 5"));
	_tmp346_ = g_strdup ("fast-fixed6");
	_tmp347_ = g_strdup (_ ("Fast, fixed on level 6"));
	_tmp348_ = g_strdup ("fast-fixed7");
	_tmp349_ = g_strdup (_ ("Fast, fixed on level 7"));
	_tmp350_ = g_strdup ("fast-fixed8");
	_tmp351_ = g_strdup (_ ("Fast, fixed on level 8"));
	_tmp352_ = g_strdup ("fast-fixed9");
	_tmp353_ = g_strdup (_ ("Fast, fixed on level 9"));
	_tmp354_ = g_strdup ("fast-fixed10");
	_tmp355_ = g_strdup (_ ("Fast, fixed on level 10"));
	_tmp356_ = g_strdup ("fast-fixed11");
	_tmp357_ = g_strdup (_ ("Fast, fixed on level 11"));
	_tmp358_ = g_strdup ("fast-fixed12");
	_tmp359_ = g_strdup (_ ("Fast, fixed on level 12"));
	_tmp360_ = g_strdup ("fast-fixed13");
	_tmp361_ = g_strdup (_ ("Fast, fixed on level 13"));
	_tmp362_ = g_strdup ("fast-fixed14");
	_tmp363_ = g_strdup (_ ("Fast, fixed on level 14"));
	_tmp364_ = g_strdup ("fast-fixed15");
	_tmp365_ = g_strdup (_ ("Fast, fixed on level 15"));
	_tmp366_ = g_strdup ("fast-fixed16");
	_tmp367_ = g_strdup (_ ("Fast, fixed on level 16"));
	_tmp368_ = g_strdup ("fast-fixed17");
	_tmp369_ = g_strdup (_ ("Fast, fixed on level 17"));
	_tmp370_ = g_strdup ("fast-fixed18");
	_tmp371_ = g_strdup (_ ("Fast, fixed on level 18"));
	_tmp372_ = g_strdup ("fast-fixed19");
	_tmp373_ = g_strdup (_ ("Fast, fixed on level 19"));
	_tmp374_ = g_strdup ("fast-fixed20");
	_tmp375_ = g_strdup (_ ("Fast, fixed on level 20"));
	_tmp376_ = g_strdup ("fast-fixed21");
	_tmp377_ = g_strdup (_ ("Fast, fixed on level 21"));
	_tmp378_ = g_strdup ("fast-fixed22");
	_tmp379_ = g_strdup (_ ("Fast, fixed on level 22"));
	_tmp380_ = g_strdup ("fast-fixed23");
	_tmp381_ = g_strdup (_ ("Fast, fixed on level 23"));
	_tmp382_ = g_strdup ("fast-fixed24");
	_tmp383_ = g_strdup (_ ("Fast, fixed on level 24"));
	_tmp384_ = g_strdup ("fast-fixed25");
	_tmp385_ = g_strdup (_ ("Fast, fixed on level 25"));
	_tmp386_ = g_strdup ("fast-fixed26");
	_tmp387_ = g_strdup (_ ("Fast, fixed on level 26"));
	_tmp388_ = g_strdup ("fast-fakes-random");
	_tmp389_ = g_strdup (_ ("Fast with fakes and random levels"));
	_tmp390_ = g_strdup ("fast-fakes-fixed1");
	_tmp391_ = g_strdup (_ ("Fast with fakes, fixed on level 1"));
	_tmp392_ = g_strdup ("fast-fakes-fixed2");
	_tmp393_ = g_strdup (_ ("Fast with fakes, fixed on level 2"));
	_tmp394_ = g_strdup ("fast-fakes-fixed3");
	_tmp395_ = g_strdup (_ ("Fast with fakes, fixed on level 3"));
	_tmp396_ = g_strdup ("fast-fakes-fixed4");
	_tmp397_ = g_strdup (_ ("Fast with fakes, fixed on level 4"));
	_tmp398_ = g_strdup ("fast-fakes-fixed5");
	_tmp399_ = g_strdup (_ ("Fast with fakes, fixed on level 5"));
	_tmp400_ = g_strdup ("fast-fakes-fixed6");
	_tmp401_ = g_strdup (_ ("Fast with fakes, fixed on level 6"));
	_tmp402_ = g_strdup ("fast-fakes-fixed7");
	_tmp403_ = g_strdup (_ ("Fast with fakes, fixed on level 7"));
	_tmp404_ = g_strdup ("fast-fakes-fixed8");
	_tmp405_ = g_strdup (_ ("Fast with fakes, fixed on level 8"));
	_tmp406_ = g_strdup ("fast-fakes-fixed9");
	_tmp407_ = g_strdup (_ ("Fast with fakes, fixed on level 9"));
	_tmp408_ = g_strdup ("fast-fakes-fixed10");
	_tmp409_ = g_strdup (_ ("Fast with fakes, fixed on level 10"));
	_tmp410_ = g_strdup ("fast-fakes-fixed11");
	_tmp411_ = g_strdup (_ ("Fast with fakes, fixed on level 11"));
	_tmp412_ = g_strdup ("fast-fakes-fixed12");
	_tmp413_ = g_strdup (_ ("Fast with fakes, fixed on level 12"));
	_tmp414_ = g_strdup ("fast-fakes-fixed13");
	_tmp415_ = g_strdup (_ ("Fast with fakes, fixed on level 13"));
	_tmp416_ = g_strdup ("fast-fakes-fixed14");
	_tmp417_ = g_strdup (_ ("Fast with fakes, fixed on level 14"));
	_tmp418_ = g_strdup ("fast-fakes-fixed15");
	_tmp419_ = g_strdup (_ ("Fast with fakes, fixed on level 15"));
	_tmp420_ = g_strdup ("fast-fakes-fixed16");
	_tmp421_ = g_strdup (_ ("Fast with fakes, fixed on level 16"));
	_tmp422_ = g_strdup ("fast-fakes-fixed17");
	_tmp423_ = g_strdup (_ ("Fast with fakes, fixed on level 17"));
	_tmp424_ = g_strdup ("fast-fakes-fixed18");
	_tmp425_ = g_strdup (_ ("Fast with fakes, fixed on level 18"));
	_tmp426_ = g_strdup ("fast-fakes-fixed19");
	_tmp427_ = g_strdup (_ ("Fast with fakes, fixed on level 19"));
	_tmp428_ = g_strdup ("fast-fakes-fixed20");
	_tmp429_ = g_strdup (_ ("Fast with fakes, fixed on level 20"));
	_tmp430_ = g_strdup ("fast-fakes-fixed21");
	_tmp431_ = g_strdup (_ ("Fast with fakes, fixed on level 21"));
	_tmp432_ = g_strdup ("fast-fakes-fixed22");
	_tmp433_ = g_strdup (_ ("Fast with fakes, fixed on level 22"));
	_tmp434_ = g_strdup ("fast-fakes-fixed23");
	_tmp435_ = g_strdup (_ ("Fast with fakes, fixed on level 23"));
	_tmp436_ = g_strdup ("fast-fakes-fixed24");
	_tmp437_ = g_strdup (_ ("Fast with fakes, fixed on level 24"));
	_tmp438_ = g_strdup ("fast-fakes-fixed25");
	_tmp439_ = g_strdup (_ ("Fast with fakes, fixed on level 25"));
	_tmp440_ = g_strdup ("fast-fakes-fixed26");
	_tmp441_ = g_strdup (_ ("Fast with fakes, fixed on level 26"));
	_tmp442_ = g_new0 (gchar*, (220 * 2) + 1);
	_tmp442_[0] = _tmp2_;
	_tmp442_[1] = _tmp3_;
	_tmp442_[2] = _tmp4_;
	_tmp442_[3] = _tmp5_;
	_tmp442_[4] = _tmp6_;
	_tmp442_[5] = _tmp7_;
	_tmp442_[6] = _tmp8_;
	_tmp442_[7] = _tmp9_;
	_tmp442_[8] = _tmp10_;
	_tmp442_[9] = _tmp11_;
	_tmp442_[10] = _tmp12_;
	_tmp442_[11] = _tmp13_;
	_tmp442_[12] = _tmp14_;
	_tmp442_[13] = _tmp15_;
	_tmp442_[14] = _tmp16_;
	_tmp442_[15] = _tmp17_;
	_tmp442_[16] = _tmp18_;
	_tmp442_[17] = _tmp19_;
	_tmp442_[18] = _tmp20_;
	_tmp442_[19] = _tmp21_;
	_tmp442_[20] = _tmp22_;
	_tmp442_[21] = _tmp23_;
	_tmp442_[22] = _tmp24_;
	_tmp442_[23] = _tmp25_;
	_tmp442_[24] = _tmp26_;
	_tmp442_[25] = _tmp27_;
	_tmp442_[26] = _tmp28_;
	_tmp442_[27] = _tmp29_;
	_tmp442_[28] = _tmp30_;
	_tmp442_[29] = _tmp31_;
	_tmp442_[30] = _tmp32_;
	_tmp442_[31] = _tmp33_;
	_tmp442_[32] = _tmp34_;
	_tmp442_[33] = _tmp35_;
	_tmp442_[34] = _tmp36_;
	_tmp442_[35] = _tmp37_;
	_tmp442_[36] = _tmp38_;
	_tmp442_[37] = _tmp39_;
	_tmp442_[38] = _tmp40_;
	_tmp442_[39] = _tmp41_;
	_tmp442_[40] = _tmp42_;
	_tmp442_[41] = _tmp43_;
	_tmp442_[42] = _tmp44_;
	_tmp442_[43] = _tmp45_;
	_tmp442_[44] = _tmp46_;
	_tmp442_[45] = _tmp47_;
	_tmp442_[46] = _tmp48_;
	_tmp442_[47] = _tmp49_;
	_tmp442_[48] = _tmp50_;
	_tmp442_[49] = _tmp51_;
	_tmp442_[50] = _tmp52_;
	_tmp442_[51] = _tmp53_;
	_tmp442_[52] = _tmp54_;
	_tmp442_[53] = _tmp55_;
	_tmp442_[54] = _tmp56_;
	_tmp442_[55] = _tmp57_;
	_tmp442_[56] = _tmp58_;
	_tmp442_[57] = _tmp59_;
	_tmp442_[58] = _tmp60_;
	_tmp442_[59] = _tmp61_;
	_tmp442_[60] = _tmp62_;
	_tmp442_[61] = _tmp63_;
	_tmp442_[62] = _tmp64_;
	_tmp442_[63] = _tmp65_;
	_tmp442_[64] = _tmp66_;
	_tmp442_[65] = _tmp67_;
	_tmp442_[66] = _tmp68_;
	_tmp442_[67] = _tmp69_;
	_tmp442_[68] = _tmp70_;
	_tmp442_[69] = _tmp71_;
	_tmp442_[70] = _tmp72_;
	_tmp442_[71] = _tmp73_;
	_tmp442_[72] = _tmp74_;
	_tmp442_[73] = _tmp75_;
	_tmp442_[74] = _tmp76_;
	_tmp442_[75] = _tmp77_;
	_tmp442_[76] = _tmp78_;
	_tmp442_[77] = _tmp79_;
	_tmp442_[78] = _tmp80_;
	_tmp442_[79] = _tmp81_;
	_tmp442_[80] = _tmp82_;
	_tmp442_[81] = _tmp83_;
	_tmp442_[82] = _tmp84_;
	_tmp442_[83] = _tmp85_;
	_tmp442_[84] = _tmp86_;
	_tmp442_[85] = _tmp87_;
	_tmp442_[86] = _tmp88_;
	_tmp442_[87] = _tmp89_;
	_tmp442_[88] = _tmp90_;
	_tmp442_[89] = _tmp91_;
	_tmp442_[90] = _tmp92_;
	_tmp442_[91] = _tmp93_;
	_tmp442_[92] = _tmp94_;
	_tmp442_[93] = _tmp95_;
	_tmp442_[94] = _tmp96_;
	_tmp442_[95] = _tmp97_;
	_tmp442_[96] = _tmp98_;
	_tmp442_[97] = _tmp99_;
	_tmp442_[98] = _tmp100_;
	_tmp442_[99] = _tmp101_;
	_tmp442_[100] = _tmp102_;
	_tmp442_[101] = _tmp103_;
	_tmp442_[102] = _tmp104_;
	_tmp442_[103] = _tmp105_;
	_tmp442_[104] = _tmp106_;
	_tmp442_[105] = _tmp107_;
	_tmp442_[106] = _tmp108_;
	_tmp442_[107] = _tmp109_;
	_tmp442_[108] = _tmp110_;
	_tmp442_[109] = _tmp111_;
	_tmp442_[110] = _tmp112_;
	_tmp442_[111] = _tmp113_;
	_tmp442_[112] = _tmp114_;
	_tmp442_[113] = _tmp115_;
	_tmp442_[114] = _tmp116_;
	_tmp442_[115] = _tmp117_;
	_tmp442_[116] = _tmp118_;
	_tmp442_[117] = _tmp119_;
	_tmp442_[118] = _tmp120_;
	_tmp442_[119] = _tmp121_;
	_tmp442_[120] = _tmp122_;
	_tmp442_[121] = _tmp123_;
	_tmp442_[122] = _tmp124_;
	_tmp442_[123] = _tmp125_;
	_tmp442_[124] = _tmp126_;
	_tmp442_[125] = _tmp127_;
	_tmp442_[126] = _tmp128_;
	_tmp442_[127] = _tmp129_;
	_tmp442_[128] = _tmp130_;
	_tmp442_[129] = _tmp131_;
	_tmp442_[130] = _tmp132_;
	_tmp442_[131] = _tmp133_;
	_tmp442_[132] = _tmp134_;
	_tmp442_[133] = _tmp135_;
	_tmp442_[134] = _tmp136_;
	_tmp442_[135] = _tmp137_;
	_tmp442_[136] = _tmp138_;
	_tmp442_[137] = _tmp139_;
	_tmp442_[138] = _tmp140_;
	_tmp442_[139] = _tmp141_;
	_tmp442_[140] = _tmp142_;
	_tmp442_[141] = _tmp143_;
	_tmp442_[142] = _tmp144_;
	_tmp442_[143] = _tmp145_;
	_tmp442_[144] = _tmp146_;
	_tmp442_[145] = _tmp147_;
	_tmp442_[146] = _tmp148_;
	_tmp442_[147] = _tmp149_;
	_tmp442_[148] = _tmp150_;
	_tmp442_[149] = _tmp151_;
	_tmp442_[150] = _tmp152_;
	_tmp442_[151] = _tmp153_;
	_tmp442_[152] = _tmp154_;
	_tmp442_[153] = _tmp155_;
	_tmp442_[154] = _tmp156_;
	_tmp442_[155] = _tmp157_;
	_tmp442_[156] = _tmp158_;
	_tmp442_[157] = _tmp159_;
	_tmp442_[158] = _tmp160_;
	_tmp442_[159] = _tmp161_;
	_tmp442_[160] = _tmp162_;
	_tmp442_[161] = _tmp163_;
	_tmp442_[162] = _tmp164_;
	_tmp442_[163] = _tmp165_;
	_tmp442_[164] = _tmp166_;
	_tmp442_[165] = _tmp167_;
	_tmp442_[166] = _tmp168_;
	_tmp442_[167] = _tmp169_;
	_tmp442_[168] = _tmp170_;
	_tmp442_[169] = _tmp171_;
	_tmp442_[170] = _tmp172_;
	_tmp442_[171] = _tmp173_;
	_tmp442_[172] = _tmp174_;
	_tmp442_[173] = _tmp175_;
	_tmp442_[174] = _tmp176_;
	_tmp442_[175] = _tmp177_;
	_tmp442_[176] = _tmp178_;
	_tmp442_[177] = _tmp179_;
	_tmp442_[178] = _tmp180_;
	_tmp442_[179] = _tmp181_;
	_tmp442_[180] = _tmp182_;
	_tmp442_[181] = _tmp183_;
	_tmp442_[182] = _tmp184_;
	_tmp442_[183] = _tmp185_;
	_tmp442_[184] = _tmp186_;
	_tmp442_[185] = _tmp187_;
	_tmp442_[186] = _tmp188_;
	_tmp442_[187] = _tmp189_;
	_tmp442_[188] = _tmp190_;
	_tmp442_[189] = _tmp191_;
	_tmp442_[190] = _tmp192_;
	_tmp442_[191] = _tmp193_;
	_tmp442_[192] = _tmp194_;
	_tmp442_[193] = _tmp195_;
	_tmp442_[194] = _tmp196_;
	_tmp442_[195] = _tmp197_;
	_tmp442_[196] = _tmp198_;
	_tmp442_[197] = _tmp199_;
	_tmp442_[198] = _tmp200_;
	_tmp442_[199] = _tmp201_;
	_tmp442_[200] = _tmp202_;
	_tmp442_[201] = _tmp203_;
	_tmp442_[202] = _tmp204_;
	_tmp442_[203] = _tmp205_;
	_tmp442_[204] = _tmp206_;
	_tmp442_[205] = _tmp207_;
	_tmp442_[206] = _tmp208_;
	_tmp442_[207] = _tmp209_;
	_tmp442_[208] = _tmp210_;
	_tmp442_[209] = _tmp211_;
	_tmp442_[210] = _tmp212_;
	_tmp442_[211] = _tmp213_;
	_tmp442_[212] = _tmp214_;
	_tmp442_[213] = _tmp215_;
	_tmp442_[214] = _tmp216_;
	_tmp442_[215] = _tmp217_;
	_tmp442_[216] = _tmp218_;
	_tmp442_[217] = _tmp219_;
	_tmp442_[218] = _tmp220_;
	_tmp442_[219] = _tmp221_;
	_tmp442_[220] = _tmp222_;
	_tmp442_[221] = _tmp223_;
	_tmp442_[222] = _tmp224_;
	_tmp442_[223] = _tmp225_;
	_tmp442_[224] = _tmp226_;
	_tmp442_[225] = _tmp227_;
	_tmp442_[226] = _tmp228_;
	_tmp442_[227] = _tmp229_;
	_tmp442_[228] = _tmp230_;
	_tmp442_[229] = _tmp231_;
	_tmp442_[230] = _tmp232_;
	_tmp442_[231] = _tmp233_;
	_tmp442_[232] = _tmp234_;
	_tmp442_[233] = _tmp235_;
	_tmp442_[234] = _tmp236_;
	_tmp442_[235] = _tmp237_;
	_tmp442_[236] = _tmp238_;
	_tmp442_[237] = _tmp239_;
	_tmp442_[238] = _tmp240_;
	_tmp442_[239] = _tmp241_;
	_tmp442_[240] = _tmp242_;
	_tmp442_[241] = _tmp243_;
	_tmp442_[242] = _tmp244_;
	_tmp442_[243] = _tmp245_;
	_tmp442_[244] = _tmp246_;
	_tmp442_[245] = _tmp247_;
	_tmp442_[246] = _tmp248_;
	_tmp442_[247] = _tmp249_;
	_tmp442_[248] = _tmp250_;
	_tmp442_[249] = _tmp251_;
	_tmp442_[250] = _tmp252_;
	_tmp442_[251] = _tmp253_;
	_tmp442_[252] = _tmp254_;
	_tmp442_[253] = _tmp255_;
	_tmp442_[254] = _tmp256_;
	_tmp442_[255] = _tmp257_;
	_tmp442_[256] = _tmp258_;
	_tmp442_[257] = _tmp259_;
	_tmp442_[258] = _tmp260_;
	_tmp442_[259] = _tmp261_;
	_tmp442_[260] = _tmp262_;
	_tmp442_[261] = _tmp263_;
	_tmp442_[262] = _tmp264_;
	_tmp442_[263] = _tmp265_;
	_tmp442_[264] = _tmp266_;
	_tmp442_[265] = _tmp267_;
	_tmp442_[266] = _tmp268_;
	_tmp442_[267] = _tmp269_;
	_tmp442_[268] = _tmp270_;
	_tmp442_[269] = _tmp271_;
	_tmp442_[270] = _tmp272_;
	_tmp442_[271] = _tmp273_;
	_tmp442_[272] = _tmp274_;
	_tmp442_[273] = _tmp275_;
	_tmp442_[274] = _tmp276_;
	_tmp442_[275] = _tmp277_;
	_tmp442_[276] = _tmp278_;
	_tmp442_[277] = _tmp279_;
	_tmp442_[278] = _tmp280_;
	_tmp442_[279] = _tmp281_;
	_tmp442_[280] = _tmp282_;
	_tmp442_[281] = _tmp283_;
	_tmp442_[282] = _tmp284_;
	_tmp442_[283] = _tmp285_;
	_tmp442_[284] = _tmp286_;
	_tmp442_[285] = _tmp287_;
	_tmp442_[286] = _tmp288_;
	_tmp442_[287] = _tmp289_;
	_tmp442_[288] = _tmp290_;
	_tmp442_[289] = _tmp291_;
	_tmp442_[290] = _tmp292_;
	_tmp442_[291] = _tmp293_;
	_tmp442_[292] = _tmp294_;
	_tmp442_[293] = _tmp295_;
	_tmp442_[294] = _tmp296_;
	_tmp442_[295] = _tmp297_;
	_tmp442_[296] = _tmp298_;
	_tmp442_[297] = _tmp299_;
	_tmp442_[298] = _tmp300_;
	_tmp442_[299] = _tmp301_;
	_tmp442_[300] = _tmp302_;
	_tmp442_[301] = _tmp303_;
	_tmp442_[302] = _tmp304_;
	_tmp442_[303] = _tmp305_;
	_tmp442_[304] = _tmp306_;
	_tmp442_[305] = _tmp307_;
	_tmp442_[306] = _tmp308_;
	_tmp442_[307] = _tmp309_;
	_tmp442_[308] = _tmp310_;
	_tmp442_[309] = _tmp311_;
	_tmp442_[310] = _tmp312_;
	_tmp442_[311] = _tmp313_;
	_tmp442_[312] = _tmp314_;
	_tmp442_[313] = _tmp315_;
	_tmp442_[314] = _tmp316_;
	_tmp442_[315] = _tmp317_;
	_tmp442_[316] = _tmp318_;
	_tmp442_[317] = _tmp319_;
	_tmp442_[318] = _tmp320_;
	_tmp442_[319] = _tmp321_;
	_tmp442_[320] = _tmp322_;
	_tmp442_[321] = _tmp323_;
	_tmp442_[322] = _tmp324_;
	_tmp442_[323] = _tmp325_;
	_tmp442_[324] = _tmp326_;
	_tmp442_[325] = _tmp327_;
	_tmp442_[326] = _tmp328_;
	_tmp442_[327] = _tmp329_;
	_tmp442_[328] = _tmp330_;
	_tmp442_[329] = _tmp331_;
	_tmp442_[330] = _tmp332_;
	_tmp442_[331] = _tmp333_;
	_tmp442_[332] = _tmp334_;
	_tmp442_[333] = _tmp335_;
	_tmp442_[334] = _tmp336_;
	_tmp442_[335] = _tmp337_;
	_tmp442_[336] = _tmp338_;
	_tmp442_[337] = _tmp339_;
	_tmp442_[338] = _tmp340_;
	_tmp442_[339] = _tmp341_;
	_tmp442_[340] = _tmp342_;
	_tmp442_[341] = _tmp343_;
	_tmp442_[342] = _tmp344_;
	_tmp442_[343] = _tmp345_;
	_tmp442_[344] = _tmp346_;
	_tmp442_[345] = _tmp347_;
	_tmp442_[346] = _tmp348_;
	_tmp442_[347] = _tmp349_;
	_tmp442_[348] = _tmp350_;
	_tmp442_[349] = _tmp351_;
	_tmp442_[350] = _tmp352_;
	_tmp442_[351] = _tmp353_;
	_tmp442_[352] = _tmp354_;
	_tmp442_[353] = _tmp355_;
	_tmp442_[354] = _tmp356_;
	_tmp442_[355] = _tmp357_;
	_tmp442_[356] = _tmp358_;
	_tmp442_[357] = _tmp359_;
	_tmp442_[358] = _tmp360_;
	_tmp442_[359] = _tmp361_;
	_tmp442_[360] = _tmp362_;
	_tmp442_[361] = _tmp363_;
	_tmp442_[362] = _tmp364_;
	_tmp442_[363] = _tmp365_;
	_tmp442_[364] = _tmp366_;
	_tmp442_[365] = _tmp367_;
	_tmp442_[366] = _tmp368_;
	_tmp442_[367] = _tmp369_;
	_tmp442_[368] = _tmp370_;
	_tmp442_[369] = _tmp371_;
	_tmp442_[370] = _tmp372_;
	_tmp442_[371] = _tmp373_;
	_tmp442_[372] = _tmp374_;
	_tmp442_[373] = _tmp375_;
	_tmp442_[374] = _tmp376_;
	_tmp442_[375] = _tmp377_;
	_tmp442_[376] = _tmp378_;
	_tmp442_[377] = _tmp379_;
	_tmp442_[378] = _tmp380_;
	_tmp442_[379] = _tmp381_;
	_tmp442_[380] = _tmp382_;
	_tmp442_[381] = _tmp383_;
	_tmp442_[382] = _tmp384_;
	_tmp442_[383] = _tmp385_;
	_tmp442_[384] = _tmp386_;
	_tmp442_[385] = _tmp387_;
	_tmp442_[386] = _tmp388_;
	_tmp442_[387] = _tmp389_;
	_tmp442_[388] = _tmp390_;
	_tmp442_[389] = _tmp391_;
	_tmp442_[390] = _tmp392_;
	_tmp442_[391] = _tmp393_;
	_tmp442_[392] = _tmp394_;
	_tmp442_[393] = _tmp395_;
	_tmp442_[394] = _tmp396_;
	_tmp442_[395] = _tmp397_;
	_tmp442_[396] = _tmp398_;
	_tmp442_[397] = _tmp399_;
	_tmp442_[398] = _tmp400_;
	_tmp442_[399] = _tmp401_;
	_tmp442_[400] = _tmp402_;
	_tmp442_[401] = _tmp403_;
	_tmp442_[402] = _tmp404_;
	_tmp442_[403] = _tmp405_;
	_tmp442_[404] = _tmp406_;
	_tmp442_[405] = _tmp407_;
	_tmp442_[406] = _tmp408_;
	_tmp442_[407] = _tmp409_;
	_tmp442_[408] = _tmp410_;
	_tmp442_[409] = _tmp411_;
	_tmp442_[410] = _tmp412_;
	_tmp442_[411] = _tmp413_;
	_tmp442_[412] = _tmp414_;
	_tmp442_[413] = _tmp415_;
	_tmp442_[414] = _tmp416_;
	_tmp442_[415] = _tmp417_;
	_tmp442_[416] = _tmp418_;
	_tmp442_[417] = _tmp419_;
	_tmp442_[418] = _tmp420_;
	_tmp442_[419] = _tmp421_;
	_tmp442_[420] = _tmp422_;
	_tmp442_[421] = _tmp423_;
	_tmp442_[422] = _tmp424_;
	_tmp442_[423] = _tmp425_;
	_tmp442_[424] = _tmp426_;
	_tmp442_[425] = _tmp427_;
	_tmp442_[426] = _tmp428_;
	_tmp442_[427] = _tmp429_;
	_tmp442_[428] = _tmp430_;
	_tmp442_[429] = _tmp431_;
	_tmp442_[430] = _tmp432_;
	_tmp442_[431] = _tmp433_;
	_tmp442_[432] = _tmp434_;
	_tmp442_[433] = _tmp435_;
	_tmp442_[434] = _tmp436_;
	_tmp442_[435] = _tmp437_;
	_tmp442_[436] = _tmp438_;
	_tmp442_[437] = _tmp439_;
	_tmp442_[438] = _tmp440_;
	_tmp442_[439] = _tmp441_;
	self->priv->category_descriptions = _tmp442_;
	self->priv->category_descriptions_length1 = 220;
	self->priv->category_descriptions_length2 = 2;
	_tmp443_ = g_new0 (GamesScoresCategory*, 0 + 1);
	self->priv->created_categories = _tmp443_;
	self->priv->created_categories_length1 = 0;
	self->priv->_created_categories_size_ = self->priv->created_categories_length1;
	self->priv->end_of_game = FALSE;
	g_type_ensure (TYPE_PLAYERS);
	g_type_ensure (TYPE_SPEED);
	g_type_ensure (TYPE_BOARD_PROGRESS);
	g_type_ensure (TYPE_CONTROLS);
	g_type_ensure (TYPE_SCOREBOARD);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
nibbles_window_finalize (GObject * obj)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_WINDOW, NibblesWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->worm_settings);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->sound);
	_nibbles_window_delegate_stack_unref0 (self->priv->keypress_handlers);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->hamburger_action);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->fullscreen_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->back_action);
	_g_object_unref0 (self->priv->start_game_action);
	_g_object_unref0 (self->priv->overlay_members);
	self->priv->category_descriptions = (_vala_array_free (self->priv->category_descriptions, self->priv->category_descriptions_length1 * self->priv->category_descriptions_length2, (GDestroyNotify) g_free), NULL);
	self->priv->created_categories = (_vala_array_free (self->priv->created_categories, self->priv->created_categories_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (nibbles_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesWindow), 0, (GInstanceInitFunc) nibbles_window_instance_init, NULL };
	GType nibbles_window_type_id;
	nibbles_window_type_id = g_type_register_static (adw_application_window_get_type (), "NibblesWindow", &g_define_type_info, 0);
	NibblesWindow_private_offset = g_type_add_instance_private (nibbles_window_type_id, sizeof (NibblesWindowPrivate));
	return nibbles_window_type_id;
}

GType
nibbles_window_get_type (void)
{
	static gsize nibbles_window_type_id__once = 0;
	if (g_once_init_enter (&nibbles_window_type_id__once)) {
		GType nibbles_window_type_id;
		nibbles_window_type_id = nibbles_window_get_type_once ();
		g_once_init_leave (&nibbles_window_type_id__once, nibbles_window_type_id);
	}
	return nibbles_window_type_id__once;
}

static void
_vala_nibbles_window_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_WINDOW, NibblesWindow);
	switch (property_id) {
		case NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_window_get_cli_start_level (self));
		break;
		case NIBBLES_WINDOW_PROGRESS_PROPERTY:
		g_value_set_int (value, nibbles_window_get_progress (self));
		break;
		case NIBBLES_WINDOW_START_SCREEN_PROPERTY:
		g_value_set_enum (value, nibbles_window_get_start_screen (self));
		break;
		case NIBBLES_WINDOW_GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, nibbles_window_get_game_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nibbles_window_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	NibblesWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_WINDOW, NibblesWindow);
	switch (property_id) {
		case NIBBLES_WINDOW_CLI_START_LEVEL_PROPERTY:
		nibbles_window_set_cli_start_level (self, g_value_get_int (value));
		break;
		case NIBBLES_WINDOW_PROGRESS_PROPERTY:
		nibbles_window_set_progress (self, g_value_get_int (value));
		break;
		case NIBBLES_WINDOW_START_SCREEN_PROPERTY:
		nibbles_window_set_start_screen (self, g_value_get_enum (value));
		break;
		case NIBBLES_WINDOW_GAME_PAUSED_PROPERTY:
		nibbles_window_set_game_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
first_run_get_instance_private (FirstRun* self)
{
	return G_STRUCT_MEMBER_P (self, FirstRun_private_offset);
}

FirstRun*
first_run_construct (GType object_type)
{
	FirstRun * self = NULL;
	self = (FirstRun*) g_object_new (object_type, NULL);
	return self;
}

FirstRun*
first_run_new (void)
{
	return first_run_construct (TYPE_FIRST_RUN);
}

static GObject *
first_run_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FirstRun * self;
	GtkButton* _tmp0_;
	parent_class = G_OBJECT_CLASS (first_run_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FIRST_RUN, FirstRun);
	_tmp0_ = self->priv->button;
	if (gtk_widget_has_css_class ((GtkWidget*) _tmp0_, "play")) {
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		_tmp1_ = self->priv->button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp1_, "play");
		_tmp2_ = self->priv->button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "pill");
	}
	return obj;
}

static void
first_run_class_init (FirstRunClass * klass,
                      gpointer klass_data)
{
	first_run_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FirstRun_private_offset);
	G_OBJECT_CLASS (klass)->constructor = first_run_constructor;
	G_OBJECT_CLASS (klass)->finalize = first_run_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/first-run-adw.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button", FALSE, FirstRun_private_offset + G_STRUCT_OFFSET (FirstRunPrivate, button));
}

static void
first_run_instance_init (FirstRun * self,
                         gpointer klass)
{
	self->priv = first_run_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
first_run_finalize (GObject * obj)
{
	FirstRun * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FIRST_RUN, FirstRun);
	G_OBJECT_CLASS (first_run_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
first_run_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FirstRunClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) first_run_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FirstRun), 0, (GInstanceInitFunc) first_run_instance_init, NULL };
	GType first_run_type_id;
	first_run_type_id = g_type_register_static (gtk_box_get_type (), "FirstRun", &g_define_type_info, 0);
	FirstRun_private_offset = g_type_add_instance_private (first_run_type_id, sizeof (FirstRunPrivate));
	return first_run_type_id;
}

GType
first_run_get_type (void)
{
	static gsize first_run_type_id__once = 0;
	if (g_once_init_enter (&first_run_type_id__once)) {
		GType first_run_type_id;
		first_run_type_id = first_run_get_type_once ();
		g_once_init_leave (&first_run_type_id__once, first_run_type_id);
	}
	return first_run_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

