/* cell.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from cell.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2023 Jamie Murphy <jmurphy@gnome.org>
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <adwaita.h>
#include "libsudoku.h"
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_CELL (sudoku_cell_get_type ())
#define SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL, SudokuCell))
#define SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL, SudokuCellClass))
#define IS_SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL))
#define IS_SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL))
#define SUDOKU_CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL, SudokuCellClass))

typedef struct _SudokuCell SudokuCell;
typedef struct _SudokuCellClass SudokuCellClass;
typedef struct _SudokuCellPrivate SudokuCellPrivate;

#define TYPE_SUDOKU_EARMARK (sudoku_earmark_get_type ())
#define SUDOKU_EARMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_EARMARK, SudokuEarmark))
#define SUDOKU_EARMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_EARMARK, SudokuEarmarkClass))
#define IS_SUDOKU_EARMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_EARMARK))
#define IS_SUDOKU_EARMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_EARMARK))
#define SUDOKU_EARMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_EARMARK, SudokuEarmarkClass))

typedef struct _SudokuEarmark SudokuEarmark;
typedef struct _SudokuEarmarkClass SudokuEarmarkClass;

#define TYPE_SUDOKU_GRID (sudoku_grid_get_type ())
#define SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GRID, SudokuGrid))
#define SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GRID, SudokuGridClass))
#define IS_SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GRID))
#define IS_SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GRID))
#define SUDOKU_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GRID, SudokuGridClass))

typedef struct _SudokuGrid SudokuGrid;
typedef struct _SudokuGridClass SudokuGridClass;
enum  {
	SUDOKU_CELL_0_PROPERTY,
	SUDOKU_CELL_ROW_PROPERTY,
	SUDOKU_CELL_COL_PROPERTY,
	SUDOKU_CELL_VALUE_PROPERTY,
	SUDOKU_CELL_IS_FIXED_PROPERTY,
	SUDOKU_CELL_SELECTED_PROPERTY,
	SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY,
	SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY,
	SUDOKU_CELL_NUM_PROPERTIES
};
static GParamSpec* sudoku_cell_properties[SUDOKU_CELL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SudokuGridPrivate SudokuGridPrivate;

#define TYPE_SUDOKU_NUMBER_PICKER (sudoku_number_picker_get_type ())
#define SUDOKU_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPicker))
#define SUDOKU_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPickerClass))
#define IS_SUDOKU_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_NUMBER_PICKER))
#define IS_SUDOKU_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_NUMBER_PICKER))
#define SUDOKU_NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_NUMBER_PICKER, SudokuNumberPickerClass))

typedef struct _SudokuNumberPicker SudokuNumberPicker;
typedef struct _SudokuNumberPickerClass SudokuNumberPickerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _SudokuEarmarkPrivate SudokuEarmarkPrivate;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

struct _SudokuCell {
	GtkWidget parent_instance;
	SudokuCellPrivate * priv;
};

struct _SudokuCellClass {
	GtkWidgetClass parent_class;
};

struct _SudokuCellPrivate {
	gint _row;
	gint _col;
	GtkGestureClick* button_controller;
	GtkGestureLongPress* long_press_controller;
	GtkLabel* value_label;
	SudokuEarmark** earmarks;
	gint earmarks_length1;
	gint _earmarks_size_;
	SudokuGame* game;
	SudokuGrid* grid;
	gdouble* zoom_value_multiplier;
	gdouble* zoom_earmark_multiplier;
	GSimpleAction* insert_earmark_action;
	GSimpleAction* insert_value_action;
	GSimpleAction* show_picker_action;
	gboolean _selected;
	gboolean _highlight_coord;
	gboolean _highlight_number;
};

struct _SudokuGrid {
	GtkGrid parent_instance;
	SudokuGridPrivate * priv;
	SudokuNumberPicker* number_picker;
};

struct _SudokuGridClass {
	GtkGridClass parent_class;
};

struct _SudokuEarmark {
	AdwBin parent_instance;
	SudokuEarmarkPrivate * priv;
	GtkLabel* label;
};

struct _SudokuEarmarkClass {
	AdwBinClass parent_class;
};

static gint SudokuCell_private_offset;
static gpointer sudoku_cell_parent_class = NULL;
static GtkShortcut* sudoku_cell_earmark_shortcuts[9];
static GtkShortcut* sudoku_cell_earmark_shortcuts[9] = {0};
static GtkShortcut* sudoku_cell_value_shortcuts[9];
static GtkShortcut* sudoku_cell_value_shortcuts[9] = {0};
VALA_EXTERN Sudoku* sudoku_app;

VALA_EXTERN GType sudoku_cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuCell, g_object_unref)
VALA_EXTERN GType sudoku_earmark_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuEarmark, g_object_unref)
VALA_EXTERN GType sudoku_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGrid, g_object_unref)
static GtkShortcut* sudoku_cell_new_shortcut (SudokuCellClass* klass,
                                       const gchar* name,
                                       const gchar* accelerator,
                                       gint val);
static void sudoku_cell_insert_value (SudokuCell* self,
                               GVariant* variant);
VALA_EXTERN GType sudoku_number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuNumberPicker, g_object_unref)
VALA_EXTERN void sudoku_cell_set_value (SudokuCell* self,
                            gint value);
static void sudoku_cell_insert_earmark (SudokuCell* self,
                                 GVariant* variant);
VALA_EXTERN gint sudoku_cell_get_value (SudokuCell* self);
VALA_EXTERN gint sudoku_cell_get_row (SudokuCell* self);
VALA_EXTERN gint sudoku_cell_get_col (SudokuCell* self);
VALA_EXTERN SudokuCell* sudoku_cell_new (SudokuGame* game,
                             SudokuGrid* grid,
                             gdouble* zoom_value_multiplier,
                             gdouble* zoom_earmark_multiplier,
                             gint row,
                             gint col);
VALA_EXTERN SudokuCell* sudoku_cell_construct (GType object_type,
                                   SudokuGame* game,
                                   SudokuGrid* grid,
                                   gdouble* zoom_value_multiplier,
                                   gdouble* zoom_earmark_multiplier,
                                   gint row,
                                   gint col);
static void sudoku_cell_set_row (SudokuCell* self,
                          gint value);
static void sudoku_cell_set_col (SudokuCell* self,
                          gint value);
static void sudoku_cell_paused_cb (SudokuCell* self);
static void _sudoku_cell_paused_cb_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self);
VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
static void sudoku_cell_flip_shortcuts (SudokuCell* self);
static void _sudoku_cell_flip_shortcuts_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void sudoku_cell_button_released_cb (SudokuCell* self,
                                     GtkGestureClick* gesture,
                                     gint n_press,
                                     gdouble x,
                                     gdouble y);
static void _sudoku_cell_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                 gint n_press,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self);
static void sudoku_cell_long_press_cb (SudokuCell* self,
                                GtkGestureLongPress* gesture,
                                gdouble x,
                                gdouble y);
static void _sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
VALA_EXTERN SudokuEarmark* sudoku_earmark_new (const gchar* str);
VALA_EXTERN SudokuEarmark* sudoku_earmark_construct (GType object_type,
                                         const gchar* str);
static void _sudoku_cell_insert_value_g_simple_action_activate (GSimpleAction* _sender,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _sudoku_cell_insert_earmark_g_simple_action_activate (GSimpleAction* _sender,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_cell_show_picker (SudokuCell* self,
                              GVariant* wants_value);
static void _sudoku_cell_show_picker_g_simple_action_activate (GSimpleAction* _sender,
                                                        GVariant* parameter,
                                                        gpointer self);
VALA_EXTERN void sudoku_cell_update_fixed (SudokuCell* self);
static void sudoku_cell_set_actions (SudokuCell* self,
                              gboolean enabled);
VALA_EXTERN gboolean sudoku_cell_get_is_fixed (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_earmark_highlight (SudokuCell* self,
                                        gint num,
                                        gboolean enabled);
VALA_EXTERN void sudoku_earmark_set_highlight (SudokuEarmark* self,
                                   gboolean value);
VALA_EXTERN void sudoku_cell_animate_earmark_removal (SudokuCell* self,
                                          gint num);
VALA_EXTERN void sudoku_earmark_play_hide_animation (SudokuEarmark* self);
VALA_EXTERN void sudoku_cell_update_content_visibility (SudokuCell* self);
VALA_EXTERN void sudoku_cell_update_earmark_visibility (SudokuCell* self,
                                            gint num);
VALA_EXTERN gboolean sudoku_cell_grab_selection (SudokuCell* self);
VALA_EXTERN void sudoku_grid_set_selected (SudokuGrid* self,
                               gint cell_row,
                               gint cell_col);
VALA_EXTERN gboolean sudoku_get_number_picker_second_click (Sudoku* self);
VALA_EXTERN gboolean sudoku_get_highlighter (Sudoku* self);
VALA_EXTERN gboolean sudoku_get_highlight_numbers (Sudoku* self);
VALA_EXTERN gboolean sudoku_cell_get_selected (SudokuCell* self);
static GVariant* _variant_new1 (gboolean value);
static GVariant* _variant_new2 (gboolean value);
VALA_EXTERN gboolean sudoku_get_earmark_mode (Sudoku* self);
static GVariant* _variant_new3 (gboolean value);
static GVariant* _variant_new4 (gboolean value);
VALA_EXTERN void sudoku_number_picker_show_value_picker (SudokuNumberPicker* self,
                                             SudokuCell* cell);
VALA_EXTERN void sudoku_number_picker_show_earmark_picker (SudokuNumberPicker* self,
                                               SudokuCell* cell);
VALA_EXTERN void sudoku_earmark_skip_animation (SudokuEarmark* self);
VALA_EXTERN void sudoku_cell_add_value_warnings (SudokuCell* self);
VALA_EXTERN gboolean sudoku_get_solution_warnings (Sudoku* self);
VALA_EXTERN void sudoku_cell_update_all_earmark_warnings (SudokuCell* self);
VALA_EXTERN void sudoku_cell_add_earmark_warnings (SudokuCell* self,
                                       gint num);
VALA_EXTERN gboolean sudoku_get_earmark_warnings (Sudoku* self);
VALA_EXTERN void sudoku_earmark_set_error (SudokuEarmark* self,
                               gboolean value);
VALA_EXTERN void sudoku_cell_clear_warnings (SudokuCell* self);
static gboolean sudoku_cell_real_focus (GtkWidget* base,
                                 GtkDirectionType direction);
static void sudoku_cell_real_size_allocate (GtkWidget* base,
                                     gint width,
                                     gint height,
                                     gint baseline);
static void sudoku_cell_set_font_size (SudokuCell* self,
                                GtkLabel* label,
                                gint font_size);
static void sudoku_cell_real_dispose (GObject* base);
VALA_EXTERN gboolean sudoku_get_autoclean_earmarks (Sudoku* self);
VALA_EXTERN void sudoku_cell_set_selected (SudokuCell* self,
                               gboolean value);
VALA_EXTERN gboolean sudoku_cell_get_highlight_coord (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlight_coord (SudokuCell* self,
                                      gboolean value);
VALA_EXTERN gboolean sudoku_cell_get_highlight_number (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlight_number (SudokuCell* self,
                                       gboolean value);
static void sudoku_cell_finalize (GObject * obj);
static GType sudoku_cell_get_type_once (void);
static void _vala_sudoku_cell_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sudoku_cell_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sudoku_cell_get_instance_private (SudokuCell* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuCell_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkShortcut*
sudoku_cell_new_shortcut (SudokuCellClass* klass,
                          const gchar* name,
                          const gchar* accelerator,
                          gint val)
{
	GtkNamedAction* action = NULL;
	GtkNamedAction* _tmp0_;
	GtkShortcutTrigger* trigger = NULL;
	GtkShortcutTrigger* _tmp1_;
	GtkShortcut* shortcut = NULL;
	GtkShortcutTrigger* _tmp2_;
	GtkShortcutAction* _tmp3_;
	GtkShortcut* _tmp4_;
	GtkShortcut* result;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (accelerator != NULL, NULL);
	_tmp0_ = (GtkNamedAction*) gtk_named_action_new (name);
	action = _tmp0_;
	_tmp1_ = gtk_shortcut_trigger_parse_string (accelerator);
	trigger = _tmp1_;
	_tmp2_ = _g_object_ref0 (trigger);
	_tmp3_ = _g_object_ref0 ((GtkShortcutAction*) action);
	_tmp4_ = gtk_shortcut_new_with_arguments (_tmp2_, _tmp3_, "i", val, NULL);
	shortcut = _tmp4_;
	gtk_widget_class_add_shortcut (GTK_WIDGET_CLASS (klass), shortcut);
	result = shortcut;
	_g_object_unref0 (trigger);
	_g_object_unref0 (action);
	return result;
}

static void
sudoku_cell_insert_value (SudokuCell* self,
                          GVariant* variant)
{
	SudokuGrid* _tmp0_;
	SudokuNumberPicker* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->grid;
	_tmp1_ = _tmp0_->number_picker;
	gtk_popover_popdown ((GtkPopover*) _tmp1_);
	sudoku_cell_set_value (self, (gint) g_variant_get_int32 (variant));
}

static void
sudoku_cell_insert_earmark (SudokuCell* self,
                            GVariant* variant)
{
	SudokuGrid* _tmp0_;
	SudokuNumberPicker* _tmp1_;
	gint32 key = 0;
	gboolean _tmp2_ = FALSE;
	SudokuGame* _tmp3_;
	GameMode _tmp4_;
	GameMode _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->grid;
	_tmp1_ = _tmp0_->number_picker;
	gtk_popover_popdown ((GtkPopover*) _tmp1_);
	key = g_variant_get_int32 (variant);
	_tmp3_ = self->priv->game;
	_tmp4_ = sudoku_game_get_mode (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == GAME_MODE_PLAY) {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = sudoku_cell_get_value (self);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean enabled = FALSE;
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		SudokuBoard* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp8_ = self->priv->game;
		_tmp9_ = sudoku_game_get_board (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_row;
		_tmp12_ = self->priv->_col;
		enabled = sudoku_board_is_earmark_enabled (_tmp10_, _tmp11_, _tmp12_, (gint) key);
		if (!enabled) {
			SudokuGame* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			_tmp13_ = self->priv->game;
			_tmp14_ = self->priv->_row;
			_tmp15_ = self->priv->_col;
			sudoku_game_enable_earmark (_tmp13_, _tmp14_, _tmp15_, (gint) key);
		} else {
			SudokuGame* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			_tmp16_ = self->priv->game;
			_tmp17_ = self->priv->_row;
			_tmp18_ = self->priv->_col;
			sudoku_game_disable_earmark (_tmp16_, _tmp17_, _tmp18_, (gint) key);
		}
	}
}

static void
_sudoku_cell_paused_cb_g_object_notify (GObject* _sender,
                                        GParamSpec* pspec,
                                        gpointer self)
{
	sudoku_cell_paused_cb ((SudokuCell*) self);
}

static void
_sudoku_cell_flip_shortcuts_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	sudoku_cell_flip_shortcuts ((SudokuCell*) self);
}

static void
_sudoku_cell_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                            gint n_press,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self)
{
	sudoku_cell_button_released_cb ((SudokuCell*) self, _sender, n_press, x, y);
}

static void
_sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	sudoku_cell_long_press_cb ((SudokuCell*) self, _sender, x, y);
}

static void
_sudoku_cell_insert_value_g_simple_action_activate (GSimpleAction* _sender,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	sudoku_cell_insert_value ((SudokuCell*) self, parameter);
}

static void
_sudoku_cell_insert_earmark_g_simple_action_activate (GSimpleAction* _sender,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	sudoku_cell_insert_earmark ((SudokuCell*) self, parameter);
}

static void
_sudoku_cell_show_picker_g_simple_action_activate (GSimpleAction* _sender,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_cell_show_picker ((SudokuCell*) self, parameter);
}

SudokuCell*
sudoku_cell_construct (GType object_type,
                       SudokuGame* game,
                       SudokuGrid* grid,
                       gdouble* zoom_value_multiplier,
                       gdouble* zoom_earmark_multiplier,
                       gint row,
                       gint col)
{
	SudokuCell * self = NULL;
	SudokuGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	Sudoku* _tmp12_;
	GtkGestureClick* _tmp13_;
	GtkGestureClick* _tmp14_;
	GtkGestureClick* _tmp15_;
	GtkGestureClick* _tmp16_;
	GtkEventController* _tmp17_;
	GtkGestureLongPress* _tmp18_;
	GtkGestureLongPress* _tmp19_;
	GtkGestureLongPress* _tmp20_;
	GtkEventController* _tmp21_;
	SudokuEarmark** _tmp22_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp35_;
	const GVariantType* _tmp36_;
	GSimpleAction* _tmp37_;
	GSimpleAction* _tmp38_;
	GSimpleAction* _tmp39_;
	const GVariantType* _tmp40_;
	GSimpleAction* _tmp41_;
	GSimpleAction* _tmp42_;
	GSimpleAction* _tmp43_;
	const GVariantType* _tmp44_;
	GSimpleAction* _tmp45_;
	GSimpleAction* _tmp46_;
	GSimpleAction* _tmp47_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (grid != NULL, NULL);
	self = (SudokuCell*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	self->priv->grid = grid;
	self->priv->zoom_value_multiplier = zoom_value_multiplier;
	self->priv->zoom_earmark_multiplier = zoom_earmark_multiplier;
	gtk_widget_class_set_accessible_role (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GTK_ACCESSIBLE_ROLE_BUTTON);
	sudoku_cell_set_row (self, row);
	sudoku_cell_set_col (self, col);
	_tmp1_ = sudoku_cell_get_value (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->value_label);
	self->priv->value_label = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->value_label;
	_tmp7_ = sudoku_cell_get_value (self);
	_tmp8_ = _tmp7_;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, _tmp8_ != 0);
	_tmp9_ = self->priv->value_label;
	gtk_widget_set_parent ((GtkWidget*) _tmp9_, (GtkWidget*) self);
	_tmp10_ = self->priv->value_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp10_, "value");
	_tmp11_ = self->priv->value_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp11_, "numeric");
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	g_signal_connect_object ((GObject*) game, "notify::paused", (GCallback) _sudoku_cell_paused_cb_g_object_notify, self, 0);
	_tmp12_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::earmark-mode", (GCallback) _sudoku_cell_flip_shortcuts_g_object_notify, self, 0);
	_tmp13_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->button_controller);
	self->priv->button_controller = _tmp13_;
	_tmp14_ = self->priv->button_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp14_, (guint) 0);
	_tmp15_ = self->priv->button_controller;
	g_signal_connect_object (_tmp15_, "released", (GCallback) _sudoku_cell_button_released_cb_gtk_gesture_click_released, self, 0);
	_tmp16_ = self->priv->button_controller;
	_tmp17_ = _g_object_ref0 ((GtkEventController*) _tmp16_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp17_);
	_tmp18_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	_g_object_unref0 (self->priv->long_press_controller);
	self->priv->long_press_controller = _tmp18_;
	_tmp19_ = self->priv->long_press_controller;
	g_signal_connect_object (_tmp19_, "pressed", (GCallback) _sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed, self, 0);
	_tmp20_ = self->priv->long_press_controller;
	_tmp21_ = _g_object_ref0 ((GtkEventController*) _tmp20_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp21_);
	_tmp22_ = g_new0 (SudokuEarmark*, 9 + 1);
	self->priv->earmarks = (_vala_array_free (self->priv->earmarks, self->priv->earmarks_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->earmarks = _tmp22_;
	self->priv->earmarks_length1 = 9;
	self->priv->_earmarks_size_ = self->priv->earmarks_length1;
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				SudokuEarmark** _tmp25_;
				gint _tmp25__length1;
				gchar* _tmp26_;
				gchar* _tmp27_;
				SudokuEarmark* _tmp28_;
				SudokuEarmark** _tmp29_;
				gint _tmp29__length1;
				SudokuEarmark* _tmp30_;
				SudokuBoard* _tmp31_;
				SudokuBoard* _tmp32_;
				SudokuEarmark** _tmp33_;
				gint _tmp33__length1;
				SudokuEarmark* _tmp34_;
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = num;
					num = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				if (!(num < 10)) {
					break;
				}
				_tmp25_ = self->priv->earmarks;
				_tmp25__length1 = self->priv->earmarks_length1;
				_tmp26_ = g_strdup_printf ("%i", num);
				_tmp27_ = _tmp26_;
				_tmp28_ = sudoku_earmark_new (_tmp27_);
				g_object_ref_sink (_tmp28_);
				_g_object_unref0 (_tmp25_[num - 1]);
				_tmp25_[num - 1] = _tmp28_;
				_g_free0 (_tmp27_);
				_tmp29_ = self->priv->earmarks;
				_tmp29__length1 = self->priv->earmarks_length1;
				_tmp30_ = _tmp29_[num - 1];
				_tmp31_ = sudoku_game_get_board (game);
				_tmp32_ = _tmp31_;
				gtk_widget_set_visible ((GtkWidget*) _tmp30_, sudoku_board_is_earmark_enabled (_tmp32_, row, col, num));
				_tmp33_ = self->priv->earmarks;
				_tmp33__length1 = self->priv->earmarks_length1;
				_tmp34_ = _tmp33_[num - 1];
				gtk_widget_set_parent ((GtkWidget*) _tmp34_, (GtkWidget*) self);
			}
		}
	}
	_tmp35_ = g_simple_action_group_new ();
	action_group = _tmp35_;
	_tmp36_ = G_VARIANT_TYPE_INT32;
	_tmp37_ = g_simple_action_new ("insert-value", _tmp36_);
	_g_object_unref0 (self->priv->insert_value_action);
	self->priv->insert_value_action = _tmp37_;
	_tmp38_ = self->priv->insert_value_action;
	g_signal_connect_object (_tmp38_, "activate", (GCallback) _sudoku_cell_insert_value_g_simple_action_activate, self, 0);
	_tmp39_ = self->priv->insert_value_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp39_);
	_tmp40_ = G_VARIANT_TYPE_INT32;
	_tmp41_ = g_simple_action_new ("insert-earmark", _tmp40_);
	_g_object_unref0 (self->priv->insert_earmark_action);
	self->priv->insert_earmark_action = _tmp41_;
	_tmp42_ = self->priv->insert_earmark_action;
	g_signal_connect_object (_tmp42_, "activate", (GCallback) _sudoku_cell_insert_earmark_g_simple_action_activate, self, 0);
	_tmp43_ = self->priv->insert_earmark_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp43_);
	_tmp44_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp45_ = g_simple_action_new ("show-picker", _tmp44_);
	_g_object_unref0 (self->priv->show_picker_action);
	self->priv->show_picker_action = _tmp45_;
	_tmp46_ = self->priv->show_picker_action;
	g_signal_connect_object (_tmp46_, "activate", (GCallback) _sudoku_cell_show_picker_g_simple_action_activate, self, 0);
	_tmp47_ = self->priv->show_picker_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp47_);
	gtk_widget_insert_action_group ((GtkWidget*) self, "cell", (GActionGroup*) action_group);
	sudoku_cell_update_fixed (self);
	_g_object_unref0 (action_group);
	return self;
}

SudokuCell*
sudoku_cell_new (SudokuGame* game,
                 SudokuGrid* grid,
                 gdouble* zoom_value_multiplier,
                 gdouble* zoom_earmark_multiplier,
                 gint row,
                 gint col)
{
	return sudoku_cell_construct (TYPE_SUDOKU_CELL, game, grid, zoom_value_multiplier, zoom_earmark_multiplier, row, col);
}

void
sudoku_cell_update_fixed (SudokuCell* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	sudoku_cell_set_actions (self, !_tmp1_);
	_tmp2_ = sudoku_cell_get_is_fixed (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "fixed");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "fixed");
	}
}

void
sudoku_cell_set_earmark_highlight (SudokuCell* self,
                                   gint num,
                                   gboolean enabled)
{
	SudokuEarmark** _tmp0_;
	gint _tmp0__length1;
	SudokuEarmark* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp1_ = _tmp0_[num - 1];
	sudoku_earmark_set_highlight (_tmp1_, enabled);
}

void
sudoku_cell_animate_earmark_removal (SudokuCell* self,
                                     gint num)
{
	SudokuEarmark** _tmp0_;
	gint _tmp0__length1;
	SudokuEarmark* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp1_ = _tmp0_[num - 1];
	sudoku_earmark_play_hide_animation (_tmp1_);
}

void
sudoku_cell_update_content_visibility (SudokuCell* self)
{
	GtkLabel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->value_label;
	_tmp1_ = sudoku_cell_get_value (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->value_label;
	_tmp6_ = sudoku_cell_get_value (self);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp7_ != 0);
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = num;
					num = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(num <= 9)) {
					break;
				}
				sudoku_cell_update_earmark_visibility (self, num);
			}
		}
	}
}

gboolean
sudoku_cell_grab_selection (SudokuCell* self)
{
	SudokuGrid* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->grid;
	_tmp1_ = self->priv->_row;
	_tmp2_ = self->priv->_col;
	sudoku_grid_set_selected (_tmp0_, _tmp1_, _tmp2_);
	result = gtk_widget_grab_focus ((GtkWidget*) self);
	return result;
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
sudoku_cell_button_released_cb (SudokuCell* self,
                                GtkGestureClick* gesture,
                                gint n_press,
                                gdouble x,
                                gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Sudoku* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean double_click_wanted = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_;
	gboolean _tmp17_;
	GdkModifierType state = 0U;
	gboolean control_pressed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	_tmp2_ = sudoku_app;
	_tmp3_ = sudoku_get_number_picker_second_click (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		Sudoku* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = sudoku_app;
		_tmp8_ = sudoku_get_highlighter (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			Sudoku* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp10_ = sudoku_app;
			_tmp11_ = sudoku_get_highlight_numbers (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp6_ = _tmp12_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint _tmp13_;
			gint _tmp14_;
			_tmp13_ = sudoku_cell_get_value (self);
			_tmp14_ = _tmp13_;
			_tmp5_ = _tmp14_ != 0;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	double_click_wanted = _tmp1_;
	_tmp16_ = sudoku_cell_get_is_fixed (self);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp19_ = sudoku_cell_get_selected (self);
		_tmp20_ = _tmp19_;
		if (!_tmp20_) {
			_tmp18_ = double_click_wanted;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp15_ = _tmp18_;
	}
	if (_tmp15_) {
		sudoku_cell_grab_selection (self);
		return;
	}
	state = gtk_event_controller_get_current_event_state ((GtkEventController*) gesture);
	control_pressed = (gboolean) (state & GDK_CONTROL_MASK);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) == ((guint) GDK_BUTTON_PRIMARY)) {
		GVariant* _tmp21_;
		_tmp21_ = _variant_new1 (!control_pressed);
		gtk_widget_activate_action_variant ((GtkWidget*) self, "cell.show-picker", _tmp21_);
		_g_variant_unref0 (_tmp21_);
	} else {
		if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) == ((guint) GDK_BUTTON_SECONDARY)) {
			GVariant* _tmp22_;
			_tmp22_ = _variant_new2 (control_pressed);
			gtk_widget_activate_action_variant ((GtkWidget*) self, "cell.show-picker", _tmp22_);
			_g_variant_unref0 (_tmp22_);
		}
	}
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new4 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
sudoku_cell_long_press_cb (SudokuCell* self,
                           GtkGestureLongPress* gesture,
                           gdouble x,
                           gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	SudokuGame* _tmp2_;
	GameMode _tmp3_;
	GameMode _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	_tmp2_ = self->priv->game;
	_tmp3_ = sudoku_game_get_mode (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == GAME_MODE_CREATE) {
		_tmp1_ = TRUE;
	} else {
		Sudoku* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = sudoku_app;
		_tmp6_ = sudoku_get_earmark_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_;
	}
	if (_tmp1_) {
		GVariant* _tmp8_;
		_tmp8_ = _variant_new3 (TRUE);
		gtk_widget_activate_action_variant ((GtkWidget*) self, "cell.show-picker", _tmp8_);
		_g_variant_unref0 (_tmp8_);
	} else {
		GVariant* _tmp9_;
		_tmp9_ = _variant_new4 (FALSE);
		gtk_widget_activate_action_variant ((GtkWidget*) self, "cell.show-picker", _tmp9_);
		_g_variant_unref0 (_tmp9_);
	}
}

static void
sudoku_cell_show_picker (SudokuCell* self,
                         GVariant* wants_value)
{
	gboolean value_picker = FALSE;
	Sudoku* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	sudoku_cell_grab_selection (self);
	_tmp0_ = sudoku_app;
	_tmp1_ = sudoku_get_earmark_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	value_picker = g_variant_get_boolean (wants_value) ^ _tmp2_;
	if (value_picker) {
		SudokuGrid* _tmp3_;
		SudokuNumberPicker* _tmp4_;
		_tmp3_ = self->priv->grid;
		_tmp4_ = _tmp3_->number_picker;
		sudoku_number_picker_show_value_picker (_tmp4_, self);
	} else {
		SudokuGame* _tmp5_;
		GameMode _tmp6_;
		GameMode _tmp7_;
		_tmp5_ = self->priv->game;
		_tmp6_ = sudoku_game_get_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == GAME_MODE_PLAY) {
			SudokuGrid* _tmp8_;
			SudokuNumberPicker* _tmp9_;
			_tmp8_ = self->priv->grid;
			_tmp9_ = _tmp8_->number_picker;
			sudoku_number_picker_show_earmark_picker (_tmp9_, self);
		}
	}
}

static void
sudoku_cell_flip_shortcuts (SudokuCell* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkShortcutTrigger* copy = NULL;
				GtkShortcut* _tmp2_;
				GtkShortcutTrigger* _tmp3_;
				GtkShortcutTrigger* _tmp4_;
				GtkShortcut* _tmp5_;
				GtkShortcut* _tmp6_;
				GtkShortcutTrigger* _tmp7_;
				GtkShortcutTrigger* _tmp8_;
				GtkShortcut* _tmp9_;
				GtkShortcutTrigger* _tmp10_;
				GtkShortcutTrigger* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 9)) {
					break;
				}
				_tmp2_ = sudoku_cell_earmark_shortcuts[i];
				_tmp3_ = gtk_shortcut_get_trigger (_tmp2_);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				copy = _tmp4_;
				_tmp5_ = sudoku_cell_earmark_shortcuts[i];
				_tmp6_ = sudoku_cell_value_shortcuts[i];
				_tmp7_ = gtk_shortcut_get_trigger (_tmp6_);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				gtk_shortcut_set_trigger (_tmp5_, _tmp8_);
				_tmp9_ = sudoku_cell_value_shortcuts[i];
				_tmp10_ = copy;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				gtk_shortcut_set_trigger (_tmp9_, _tmp11_);
				_g_object_unref0 (copy);
			}
		}
	}
}

static void
sudoku_cell_set_actions (SudokuCell* self,
                         gboolean enabled)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->insert_value_action;
	g_simple_action_set_enabled (_tmp0_, enabled);
	_tmp1_ = self->priv->insert_earmark_action;
	g_simple_action_set_enabled (_tmp1_, enabled);
	_tmp2_ = self->priv->show_picker_action;
	g_simple_action_set_enabled (_tmp2_, enabled);
}

static void
sudoku_cell_paused_cb (SudokuCell* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "paused");
		sudoku_cell_set_actions (self, FALSE);
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		gtk_widget_remove_css_class ((GtkWidget*) self, "paused");
		_tmp3_ = sudoku_cell_get_is_fixed (self);
		_tmp4_ = _tmp3_;
		sudoku_cell_set_actions (self, !_tmp4_);
	}
}

void
sudoku_cell_update_earmark_visibility (SudokuCell* self,
                                       gint num)
{
	SudokuEarmark** _tmp0_;
	gint _tmp0__length1;
	SudokuEarmark* _tmp1_;
	SudokuEarmark** _tmp2_;
	gint _tmp2__length1;
	SudokuEarmark* _tmp3_;
	SudokuGame* _tmp4_;
	SudokuBoard* _tmp5_;
	SudokuBoard* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp1_ = _tmp0_[num - 1];
	sudoku_earmark_skip_animation (_tmp1_);
	_tmp2_ = self->priv->earmarks;
	_tmp2__length1 = self->priv->earmarks_length1;
	_tmp3_ = _tmp2_[num - 1];
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_get_board (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_row;
	_tmp8_ = self->priv->_col;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, sudoku_board_is_earmark_enabled (_tmp6_, _tmp7_, _tmp8_, num));
}

void
sudoku_cell_add_value_warnings (SudokuCell* self)
{
	SudokuGame* _tmp0_;
	GameMode _tmp1_;
	GameMode _tmp2_;
	gboolean _error_ = FALSE;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GAME_MODE_CREATE) {
		return;
	}
	_error_ = FALSE;
	_tmp3_ = sudoku_cell_get_value (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != 0) {
		SudokuGame* _tmp5_;
		SudokuBoard* _tmp6_;
		SudokuBoard* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		Coord _tmp12_ = {0};
		_tmp5_ = self->priv->game;
		_tmp6_ = sudoku_game_get_board (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = sudoku_board_get_broken_coords (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_row;
		_tmp11_ = self->priv->_col;
		coord_init (&_tmp12_, _tmp10_, _tmp11_);
		if (gee_collection_contains ((GeeCollection*) _tmp9_, &_tmp12_)) {
			_error_ = TRUE;
		} else {
			gboolean _tmp13_ = FALSE;
			Sudoku* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp14_ = sudoku_app;
			_tmp15_ = sudoku_get_solution_warnings (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				SudokuGame* _tmp17_;
				GameMode _tmp18_;
				GameMode _tmp19_;
				_tmp17_ = self->priv->game;
				_tmp18_ = sudoku_game_get_mode (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp13_ = _tmp19_ == GAME_MODE_PLAY;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gint solution = 0;
				SudokuGame* _tmp20_;
				SudokuBoard* _tmp21_;
				SudokuBoard* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_tmp20_ = self->priv->game;
				_tmp21_ = sudoku_game_get_board (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->_row;
				_tmp24_ = self->priv->_col;
				solution = sudoku_board_get_solution (_tmp22_, _tmp23_, _tmp24_);
				if (solution != 0) {
					gint _tmp25_;
					gint _tmp26_;
					_tmp25_ = sudoku_cell_get_value (self);
					_tmp26_ = _tmp25_;
					_error_ = _tmp26_ != solution;
				}
			}
		}
	}
	if (_error_) {
		GtkLabel* _tmp27_;
		_tmp27_ = self->priv->value_label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp27_, "error");
	} else {
		GtkLabel* _tmp28_;
		_tmp28_ = self->priv->value_label;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp28_, "error");
	}
}

void
sudoku_cell_update_all_earmark_warnings (SudokuCell* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean* marks = NULL;
	SudokuGame* _tmp2_;
	SudokuBoard* _tmp3_;
	SudokuBoard* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_ = 0;
	gboolean* _tmp8_;
	gint marks_length1;
	gint _marks_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 0) {
		return;
	}
	_tmp2_ = self->priv->game;
	_tmp3_ = sudoku_game_get_board (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_row;
	_tmp6_ = self->priv->_col;
	_tmp8_ = sudoku_board_get_earmarks (_tmp4_, _tmp5_, _tmp6_, &_tmp7_);
	marks = _tmp8_;
	marks_length1 = _tmp7_;
	_marks_size_ = marks_length1;
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean* _tmp11_;
				gint _tmp11__length1;
				gboolean* _tmp12_;
				gint _tmp12__length1;
				gboolean _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = num;
					num = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = marks;
				_tmp11__length1 = marks_length1;
				if (!(num <= _tmp11__length1)) {
					break;
				}
				_tmp12_ = marks;
				_tmp12__length1 = marks_length1;
				_tmp13_ = _tmp12_[num - 1];
				if (_tmp13_) {
					sudoku_cell_add_earmark_warnings (self, num);
				}
			}
		}
	}
	marks = (g_free (marks), NULL);
}

void
sudoku_cell_add_earmark_warnings (SudokuCell* self,
                                  gint num)
{
	gboolean _tmp0_ = FALSE;
	Sudoku* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SudokuEarmark** _tmp9_;
	gint _tmp9__length1;
	SudokuEarmark* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_app;
	_tmp2_ = sudoku_get_earmark_warnings (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		SudokuGame* _tmp4_;
		SudokuBoard* _tmp5_;
		SudokuBoard* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp4_ = self->priv->game;
		_tmp5_ = sudoku_game_get_board (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->_row;
		_tmp8_ = self->priv->_col;
		_tmp0_ = !sudoku_board_is_possible (_tmp6_, _tmp7_, _tmp8_, num);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = self->priv->earmarks;
	_tmp9__length1 = self->priv->earmarks_length1;
	_tmp10_ = _tmp9_[num - 1];
	sudoku_earmark_set_error (_tmp10_, _tmp0_);
}

void
sudoku_cell_clear_warnings (SudokuCell* self)
{
	GtkLabel* _tmp0_;
	SudokuEarmark** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->value_label;
	gtk_widget_remove_css_class ((GtkWidget*) _tmp0_, "error");
	_tmp1_ = self->priv->earmarks;
	_tmp1__length1 = self->priv->earmarks_length1;
	{
		SudokuEarmark** earmark_collection = NULL;
		gint earmark_collection_length1 = 0;
		gint _earmark_collection_size_ = 0;
		gint earmark_it = 0;
		earmark_collection = _tmp1_;
		earmark_collection_length1 = _tmp1__length1;
		for (earmark_it = 0; earmark_it < earmark_collection_length1; earmark_it = earmark_it + 1) {
			SudokuEarmark* _tmp2_;
			SudokuEarmark* earmark = NULL;
			_tmp2_ = _g_object_ref0 (earmark_collection[earmark_it]);
			earmark = _tmp2_;
			{
				SudokuEarmark* _tmp3_;
				_tmp3_ = earmark;
				sudoku_earmark_set_error (_tmp3_, FALSE);
				_g_object_unref0 (earmark);
			}
		}
	}
}

static gboolean
sudoku_cell_real_focus (GtkWidget* base,
                        GtkDirectionType direction)
{
	SudokuCell * self;
	SudokuGrid* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	self = (SudokuCell*) base;
	_tmp0_ = self->priv->grid;
	_tmp1_ = self->priv->_row;
	_tmp2_ = self->priv->_col;
	sudoku_grid_set_selected (_tmp0_, _tmp1_, _tmp2_);
	result = GTK_WIDGET_CLASS (sudoku_cell_parent_class)->focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), direction);
	return result;
}

static void
sudoku_cell_real_size_allocate (GtkWidget* base,
                                gint width,
                                gint height,
                                gint baseline)
{
	SudokuCell * self;
	gint zoomed_size = 0;
	gdouble* _tmp0_;
	GtkLabel* _tmp1_;
	GtkWidget* child = NULL;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkRequisition nat = {0};
	GtkLabel* _tmp13_;
	GtkRequisition _tmp14_ = {0};
	gint value_width = 0;
	GtkRequisition _tmp15_;
	gint value_height = 0;
	GtkRequisition _tmp16_;
	GtkAllocation value_allocation = {0};
	GtkRequisition _tmp17_;
	GtkRequisition _tmp18_;
	GtkAllocation _tmp19_ = {0};
	GtkLabel* _tmp20_;
	GtkAllocation _tmp21_;
	gint earmark_width = 0;
	gint earmark_height = 0;
	gint max_earmark_size = 0;
	gint num = 0;
	gdouble* _tmp22_;
	self = (SudokuCell*) base;
	_tmp0_ = self->priv->zoom_value_multiplier;
	zoomed_size = (gint) (height * (*_tmp0_));
	_tmp1_ = self->priv->value_label;
	sudoku_cell_set_font_size (self, _tmp1_, zoomed_size);
	_tmp2_ = gtk_widget_get_last_child ((GtkWidget*) self);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	child = _tmp3_;
	while (TRUE) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		SudokuGrid* _tmp6_;
		SudokuNumberPicker* _tmp7_;
		GtkWidget* _tmp10_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp4_ = child;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = child;
		_tmp6_ = self->priv->grid;
		_tmp7_ = _tmp6_->number_picker;
		if (_tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
			SudokuGrid* _tmp8_;
			SudokuNumberPicker* _tmp9_;
			_tmp8_ = self->priv->grid;
			_tmp9_ = _tmp8_->number_picker;
			gtk_popover_present ((GtkPopover*) _tmp9_);
			break;
		}
		_tmp10_ = child;
		_tmp11_ = gtk_widget_get_prev_sibling (_tmp10_);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (child);
		child = _tmp12_;
	}
	_tmp13_ = self->priv->value_label;
	gtk_widget_get_preferred_size ((GtkWidget*) _tmp13_, NULL, &_tmp14_);
	nat = _tmp14_;
	_tmp15_ = nat;
	value_width = MIN (_tmp15_.width, width);
	_tmp16_ = nat;
	value_height = MIN (_tmp16_.height, height);
	_tmp17_ = nat;
	_tmp18_ = nat;
	_tmp19_.x = (width - value_width) / 2;
	_tmp19_.y = (height - value_height) / 2;
	_tmp19_.width = _tmp17_.width;
	_tmp19_.height = _tmp18_.height;
	value_allocation = _tmp19_;
	_tmp20_ = self->priv->value_label;
	_tmp21_ = value_allocation;
	gtk_widget_size_allocate ((GtkWidget*) _tmp20_, &_tmp21_, baseline);
	max_earmark_size = width / 3;
	num = 0;
	_tmp22_ = self->priv->zoom_earmark_multiplier;
	zoomed_size = (gint) (height * (*_tmp22_));
	{
		gint row_tmp = 0;
		row_tmp = 2;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = row_tmp;
					row_tmp = _tmp24_ - 1;
				}
				_tmp23_ = FALSE;
				if (!(row_tmp >= 0)) {
					break;
				}
				{
					gint col_tmp = 0;
					col_tmp = 0;
					{
						gboolean _tmp25_ = FALSE;
						_tmp25_ = TRUE;
						while (TRUE) {
							SudokuEarmark** _tmp27_;
							gint _tmp27__length1;
							SudokuEarmark* _tmp28_;
							GtkLabel* _tmp29_;
							SudokuEarmark** _tmp30_;
							gint _tmp30__length1;
							SudokuEarmark* _tmp31_;
							GtkRequisition _tmp32_ = {0};
							GtkRequisition _tmp33_;
							GtkRequisition _tmp34_;
							GtkAllocation earmark_allocation = {0};
							GtkAllocation _tmp35_ = {0};
							SudokuEarmark** _tmp36_;
							gint _tmp36__length1;
							SudokuEarmark* _tmp37_;
							GtkAllocation _tmp38_;
							gint _tmp39_;
							if (!_tmp25_) {
								gint _tmp26_;
								_tmp26_ = col_tmp;
								col_tmp = _tmp26_ + 1;
							}
							_tmp25_ = FALSE;
							if (!(col_tmp < 3)) {
								break;
							}
							_tmp27_ = self->priv->earmarks;
							_tmp27__length1 = self->priv->earmarks_length1;
							_tmp28_ = _tmp27_[num];
							_tmp29_ = _tmp28_->label;
							sudoku_cell_set_font_size (self, _tmp29_, zoomed_size);
							_tmp30_ = self->priv->earmarks;
							_tmp30__length1 = self->priv->earmarks_length1;
							_tmp31_ = _tmp30_[num];
							gtk_widget_get_preferred_size ((GtkWidget*) _tmp31_, NULL, &_tmp32_);
							nat = _tmp32_;
							_tmp33_ = nat;
							earmark_width = MIN (max_earmark_size, _tmp33_.width);
							_tmp34_ = nat;
							earmark_height = MIN (max_earmark_size, _tmp34_.height);
							_tmp35_.x = (col_tmp * max_earmark_size) + ((max_earmark_size - earmark_width) / 2);
							_tmp35_.y = (row_tmp * max_earmark_size) + ((max_earmark_size - earmark_height) / 2);
							_tmp35_.width = earmark_width;
							_tmp35_.height = earmark_height;
							earmark_allocation = _tmp35_;
							_tmp36_ = self->priv->earmarks;
							_tmp36__length1 = self->priv->earmarks_length1;
							_tmp37_ = _tmp36_[num];
							_tmp38_ = earmark_allocation;
							gtk_widget_size_allocate ((GtkWidget*) _tmp37_, &_tmp38_, baseline);
							_tmp39_ = num;
							num = _tmp39_ + 1;
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (child);
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
sudoku_cell_set_font_size (SudokuCell* self,
                           GtkLabel* label,
                           gint font_size)
{
	PangoAttrList* attr_list = NULL;
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	PangoAttrList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = gtk_label_get_attributes (label);
	_tmp1_ = _pango_attr_list_ref0 (_tmp0_);
	attr_list = _tmp1_;
	_tmp2_ = attr_list;
	if (_tmp2_ == NULL) {
		PangoAttrList* _tmp3_;
		_tmp3_ = pango_attr_list_new ();
		_pango_attr_list_unref0 (attr_list);
		attr_list = _tmp3_;
	}
	_tmp4_ = attr_list;
	_tmp5_ = pango_attr_size_new_absolute (font_size * PANGO_SCALE);
	pango_attr_list_change (_tmp4_, _tmp5_);
	_tmp6_ = attr_list;
	gtk_label_set_attributes (label, _tmp6_);
	_pango_attr_list_unref0 (attr_list);
}

static void
sudoku_cell_real_dispose (GObject* base)
{
	SudokuCell * self;
	GtkLabel* _tmp0_;
	SudokuEarmark** _tmp1_;
	gint _tmp1__length1;
	self = (SudokuCell*) base;
	_tmp0_ = self->priv->value_label;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->earmarks;
	_tmp1__length1 = self->priv->earmarks_length1;
	{
		SudokuEarmark** earmark_collection = NULL;
		gint earmark_collection_length1 = 0;
		gint _earmark_collection_size_ = 0;
		gint earmark_it = 0;
		earmark_collection = _tmp1_;
		earmark_collection_length1 = _tmp1__length1;
		for (earmark_it = 0; earmark_it < earmark_collection_length1; earmark_it = earmark_it + 1) {
			SudokuEarmark* _tmp2_;
			SudokuEarmark* earmark = NULL;
			_tmp2_ = _g_object_ref0 (earmark_collection[earmark_it]);
			earmark = _tmp2_;
			{
				SudokuEarmark* _tmp3_;
				_tmp3_ = earmark;
				gtk_widget_unparent ((GtkWidget*) _tmp3_);
				_g_object_unref0 (earmark);
			}
		}
	}
	G_OBJECT_CLASS (sudoku_cell_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

gint
sudoku_cell_get_row (SudokuCell* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_row;
	return result;
}

static void
sudoku_cell_set_row (SudokuCell* self,
                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_cell_get_row (self);
	if (old_value != value) {
		self->priv->_row = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_ROW_PROPERTY]);
	}
}

gint
sudoku_cell_get_col (SudokuCell* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_col;
	return result;
}

static void
sudoku_cell_set_col (SudokuCell* self,
                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_cell_get_col (self);
	if (old_value != value) {
		self->priv->_col = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_COL_PROPERTY]);
	}
}

gint
sudoku_cell_get_value (SudokuCell* self)
{
	gint result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_row;
	_tmp4_ = self->priv->_col;
	result = sudoku_board_get (_tmp2_, _tmp3_, _tmp4_);
	return result;
}

void
sudoku_cell_set_value (SudokuCell* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	if (value == 0) {
		SudokuGame* _tmp0_;
		SudokuBoard* _tmp1_;
		SudokuBoard* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp0_ = self->priv->game;
		_tmp1_ = sudoku_game_get_board (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_row;
		_tmp4_ = self->priv->_col;
		if (sudoku_board_get (_tmp2_, _tmp3_, _tmp4_) != 0) {
			SudokuGame* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp5_ = self->priv->game;
			_tmp6_ = self->priv->_row;
			_tmp7_ = self->priv->_col;
			sudoku_game_remove (_tmp5_, _tmp6_, _tmp7_);
		} else {
			SudokuGame* _tmp8_;
			SudokuBoard* _tmp9_;
			SudokuBoard* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp8_ = self->priv->game;
			_tmp9_ = sudoku_game_get_board (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_row;
			_tmp12_ = self->priv->_col;
			if (sudoku_board_has_earmarks (_tmp10_, _tmp11_, _tmp12_)) {
				SudokuGame* _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				_tmp13_ = self->priv->game;
				_tmp14_ = self->priv->_row;
				_tmp15_ = self->priv->_col;
				sudoku_game_disable_all_earmarks (_tmp13_, _tmp14_, _tmp15_);
			}
		}
	} else {
		SudokuGame* _tmp16_;
		SudokuBoard* _tmp17_;
		SudokuBoard* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		_tmp16_ = self->priv->game;
		_tmp17_ = sudoku_game_get_board (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_row;
		_tmp20_ = self->priv->_col;
		if (value != sudoku_board_get (_tmp18_, _tmp19_, _tmp20_)) {
			gboolean _tmp21_ = FALSE;
			Sudoku* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp22_ = sudoku_app;
			_tmp23_ = sudoku_get_autoclean_earmarks (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				SudokuGame* _tmp25_;
				GameMode _tmp26_;
				GameMode _tmp27_;
				_tmp25_ = self->priv->game;
				_tmp26_ = sudoku_game_get_mode (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp21_ = _tmp27_ == GAME_MODE_PLAY;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				SudokuGame* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp28_ = self->priv->game;
				_tmp29_ = self->priv->_row;
				_tmp30_ = self->priv->_col;
				sudoku_game_insert_and_disable_related_earmarks (_tmp28_, _tmp29_, _tmp30_, value);
			} else {
				SudokuGame* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				_tmp31_ = self->priv->game;
				_tmp32_ = self->priv->_row;
				_tmp33_ = self->priv->_col;
				sudoku_game_insert (_tmp31_, _tmp32_, _tmp33_, value);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_VALUE_PROPERTY]);
}

gboolean
sudoku_cell_get_is_fixed (SudokuCell* self)
{
	gboolean result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_row;
	_tmp4_ = self->priv->_col;
	result = sudoku_board_get_is_fixed (_tmp2_, _tmp3_, _tmp4_);
	return result;
}

gboolean
sudoku_cell_get_selected (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
sudoku_cell_set_selected (SudokuCell* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_selected = value;
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "selected");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "selected");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_SELECTED_PROPERTY]);
}

gboolean
sudoku_cell_get_highlight_coord (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight_coord;
	return result;
}

void
sudoku_cell_set_highlight_coord (SudokuCell* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_coord = value;
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "highlight-coord");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "highlight-coord");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY]);
}

gboolean
sudoku_cell_get_highlight_number (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlight_number;
	return result;
}

void
sudoku_cell_set_highlight_number (SudokuCell* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlight_number = value;
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "highlight-number");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "highlight-number");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY]);
}

static void
sudoku_cell_class_init (SudokuCellClass * klass,
                        gpointer klass_data)
{
	GtkNamedAction* action = NULL;
	GtkNamedAction* _tmp0_;
	GtkShortcutTrigger* alt_trigger = NULL;
	GtkShortcutTrigger* _tmp1_;
	GtkShortcut* shortcut = NULL;
	GtkShortcutTrigger* _tmp2_;
	GtkShortcutTrigger* _tmp3_;
	GtkNamedAction* _tmp4_;
	GtkShortcutAction* _tmp5_;
	GtkShortcut* _tmp6_;
	GtkShortcut* _tmp7_;
	GtkShortcutTrigger* _tmp8_;
	GtkShortcutTrigger* _tmp9_;
	GtkShortcutTrigger* _tmp10_;
	GtkNamedAction* _tmp11_;
	GtkShortcutAction* _tmp12_;
	GtkShortcut* _tmp13_;
	GtkShortcut* _tmp14_;
	GtkShortcut* _tmp15_;
	GtkShortcut* _tmp16_;
	sudoku_cell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuCell_private_offset);
	((GtkWidgetClass *) klass)->focus = (gboolean (*) (GtkWidget*, GtkDirectionType)) sudoku_cell_real_focus;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) sudoku_cell_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_cell_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_ROW_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_ROW_PROPERTY] = g_param_spec_int ("row", "row", "row", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_COL_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_COL_PROPERTY] = g_param_spec_int ("col", "col", "col", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VALUE_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_IS_FIXED_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_IS_FIXED_PROPERTY] = g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_SELECTED_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY] = g_param_spec_boolean ("highlight-coord", "highlight-coord", "highlight-coord", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY] = g_param_spec_boolean ("highlight-number", "highlight-number", "highlight-number", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "sudoku-cell");
	_tmp0_ = (GtkNamedAction*) gtk_named_action_new ("cell.show-picker");
	action = _tmp0_;
	_tmp1_ = gtk_shortcut_trigger_parse_string ("Return|KP_Enter|space");
	alt_trigger = _tmp1_;
	_tmp2_ = alt_trigger;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = action;
	_tmp5_ = _g_object_ref0 ((GtkShortcutAction*) _tmp4_);
	_tmp6_ = gtk_shortcut_new_with_arguments (_tmp3_, _tmp5_, "b", TRUE, NULL);
	shortcut = _tmp6_;
	_tmp7_ = shortcut;
	gtk_widget_class_add_shortcut (GTK_WIDGET_CLASS (klass), _tmp7_);
	_tmp8_ = gtk_shortcut_trigger_parse_string ("<Primary>Return|<Primary>space|<Primary>KP_Enter");
	_g_object_unref0 (alt_trigger);
	alt_trigger = _tmp8_;
	_tmp9_ = alt_trigger;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_tmp11_ = action;
	_tmp12_ = _g_object_ref0 ((GtkShortcutAction*) _tmp11_);
	_tmp13_ = gtk_shortcut_new_with_arguments (_tmp10_, _tmp12_, "b", FALSE, NULL);
	_g_object_unref0 (shortcut);
	shortcut = _tmp13_;
	_tmp14_ = shortcut;
	gtk_widget_class_add_shortcut (GTK_WIDGET_CLASS (klass), _tmp14_);
	_tmp15_ = sudoku_cell_new_shortcut (klass, "cell.insert-value", "Delete|BackSpace|KP_0|0", 0);
	_tmp16_ = _tmp15_;
	_g_object_unref0 (_tmp16_);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar* accel = NULL;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				GtkShortcut* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				GtkShortcut* _tmp36_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < 10)) {
					break;
				}
				_tmp19_ = g_strdup_printf ("%i", i);
				accel = _tmp19_;
				_tmp20_ = accel;
				_tmp21_ = g_strconcat (_tmp20_, "|KP_", NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = accel;
				_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
				_g_free0 (accel);
				accel = _tmp24_;
				_g_free0 (_tmp22_);
				_tmp25_ = accel;
				_tmp26_ = sudoku_cell_new_shortcut (klass, "cell.insert-value", _tmp25_, i);
				_g_object_unref0 (sudoku_cell_value_shortcuts[i - 1]);
				sudoku_cell_value_shortcuts[i - 1] = _tmp26_;
				_tmp27_ = g_strdup_printf ("%i", i);
				_g_free0 (accel);
				accel = _tmp27_;
				_tmp28_ = accel;
				_tmp29_ = g_strconcat ("<Primary>", _tmp28_, NULL);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp30_, "|<Primary>KP_", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = accel;
				_tmp34_ = g_strconcat (_tmp32_, _tmp33_, NULL);
				_g_free0 (accel);
				accel = _tmp34_;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_tmp35_ = accel;
				_tmp36_ = sudoku_cell_new_shortcut (klass, "cell.insert-earmark", _tmp35_, i);
				_g_object_unref0 (sudoku_cell_earmark_shortcuts[i - 1]);
				sudoku_cell_earmark_shortcuts[i - 1] = _tmp36_;
				_g_free0 (accel);
			}
		}
	}
	_g_object_unref0 (shortcut);
	_g_object_unref0 (alt_trigger);
	_g_object_unref0 (action);
}

static void
sudoku_cell_instance_init (SudokuCell * self,
                           gpointer klass)
{
	self->priv = sudoku_cell_get_instance_private (self);
	self->priv->_selected = FALSE;
	self->priv->_highlight_coord = FALSE;
	self->priv->_highlight_number = FALSE;
}

static void
sudoku_cell_finalize (GObject * obj)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL, SudokuCell);
	_g_object_unref0 (self->priv->button_controller);
	_g_object_unref0 (self->priv->long_press_controller);
	_g_object_unref0 (self->priv->value_label);
	self->priv->earmarks = (_vala_array_free (self->priv->earmarks, self->priv->earmarks_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->insert_earmark_action);
	_g_object_unref0 (self->priv->insert_value_action);
	_g_object_unref0 (self->priv->show_picker_action);
	G_OBJECT_CLASS (sudoku_cell_parent_class)->finalize (obj);
}

static GType
sudoku_cell_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuCellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCell), 0, (GInstanceInitFunc) sudoku_cell_instance_init, NULL };
	GType sudoku_cell_type_id;
	sudoku_cell_type_id = g_type_register_static (gtk_widget_get_type (), "SudokuCell", &g_define_type_info, 0);
	SudokuCell_private_offset = g_type_add_instance_private (sudoku_cell_type_id, sizeof (SudokuCellPrivate));
	return sudoku_cell_type_id;
}

GType
sudoku_cell_get_type (void)
{
	static volatile gsize sudoku_cell_type_id__once = 0;
	if (g_once_init_enter (&sudoku_cell_type_id__once)) {
		GType sudoku_cell_type_id;
		sudoku_cell_type_id = sudoku_cell_get_type_once ();
		g_once_init_leave (&sudoku_cell_type_id__once, sudoku_cell_type_id);
	}
	return sudoku_cell_type_id__once;
}

static void
_vala_sudoku_cell_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL, SudokuCell);
	switch (property_id) {
		case SUDOKU_CELL_ROW_PROPERTY:
		g_value_set_int (value, sudoku_cell_get_row (self));
		break;
		case SUDOKU_CELL_COL_PROPERTY:
		g_value_set_int (value, sudoku_cell_get_col (self));
		break;
		case SUDOKU_CELL_VALUE_PROPERTY:
		g_value_set_int (value, sudoku_cell_get_value (self));
		break;
		case SUDOKU_CELL_IS_FIXED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_is_fixed (self));
		break;
		case SUDOKU_CELL_SELECTED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_selected (self));
		break;
		case SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_highlight_coord (self));
		break;
		case SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_highlight_number (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_cell_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL, SudokuCell);
	switch (property_id) {
		case SUDOKU_CELL_ROW_PROPERTY:
		sudoku_cell_set_row (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_COL_PROPERTY:
		sudoku_cell_set_col (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_VALUE_PROPERTY:
		sudoku_cell_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_SELECTED_PROPERTY:
		sudoku_cell_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_HIGHLIGHT_COORD_PROPERTY:
		sudoku_cell_set_highlight_coord (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_HIGHLIGHT_NUMBER_PROPERTY:
		sudoku_cell_set_highlight_number (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

