/* game-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 * Copyright © 2023 Jamie Murphy <jmurphy@gnome.org>
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_GAME_VIEW (sudoku_game_view_get_type ())
#define SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameView))
#define SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))
#define IS_SUDOKU_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GAME_VIEW))
#define IS_SUDOKU_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GAME_VIEW))
#define SUDOKU_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GAME_VIEW, SudokuGameViewClass))

typedef struct _SudokuGameView SudokuGameView;
typedef struct _SudokuGameViewClass SudokuGameViewClass;
typedef struct _SudokuGameViewPrivate SudokuGameViewPrivate;

#define TYPE_SUDOKU_GRID (sudoku_grid_get_type ())
#define SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GRID, SudokuGrid))
#define SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GRID, SudokuGridClass))
#define IS_SUDOKU_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GRID))
#define IS_SUDOKU_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GRID))
#define SUDOKU_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GRID, SudokuGridClass))

typedef struct _SudokuGrid SudokuGrid;
typedef struct _SudokuGridClass SudokuGridClass;

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;

#define TYPE_SUDOKU_MENU_BUTTON (sudoku_menu_button_get_type ())
#define SUDOKU_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_MENU_BUTTON, SudokuMenuButton))
#define SUDOKU_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_MENU_BUTTON, SudokuMenuButtonClass))
#define IS_SUDOKU_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_MENU_BUTTON))
#define IS_SUDOKU_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_MENU_BUTTON))
#define SUDOKU_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_MENU_BUTTON, SudokuMenuButtonClass))

typedef struct _SudokuMenuButton SudokuMenuButton;
typedef struct _SudokuMenuButtonClass SudokuMenuButtonClass;
enum  {
	SUDOKU_GAME_VIEW_0_PROPERTY,
	SUDOKU_GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_game_view_properties[SUDOKU_GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuMenuButtonPrivate SudokuMenuButtonPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_SUDOKU_GRID_LAYOUT_MANAGER (sudoku_grid_layout_manager_get_type ())
#define SUDOKU_GRID_LAYOUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GRID_LAYOUT_MANAGER, SudokuGridLayoutManager))
#define SUDOKU_GRID_LAYOUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GRID_LAYOUT_MANAGER, SudokuGridLayoutManagerClass))
#define IS_SUDOKU_GRID_LAYOUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GRID_LAYOUT_MANAGER))
#define IS_SUDOKU_GRID_LAYOUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GRID_LAYOUT_MANAGER))
#define SUDOKU_GRID_LAYOUT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GRID_LAYOUT_MANAGER, SudokuGridLayoutManagerClass))

typedef struct _SudokuGridLayoutManager SudokuGridLayoutManager;
typedef struct _SudokuGridLayoutManagerClass SudokuGridLayoutManagerClass;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef enum  {
	ZOOM_LEVEL_NONE = 0,
	ZOOM_LEVEL_SMALL = 1,
	ZOOM_LEVEL_MEDIUM = 2,
	ZOOM_LEVEL_LARGE = 3
} ZoomLevel;

#define TYPE_ZOOM_LEVEL (zoom_level_get_type ())

struct _SudokuGameView {
	AdwBin parent_instance;
	SudokuGameViewPrivate * priv;
	SudokuGame* game;
	SudokuGrid* grid;
	SudokuWindow* window;
	gdouble* highscore;
};

struct _SudokuGameViewClass {
	AdwBinClass parent_class;
};

struct _SudokuGameViewPrivate {
	GtkOverlay* grid_overlay;
	AdwBin* grid_bin;
	GtkBox* clock_box;
	GtkLabel* clock_label;
	GtkButton* play_custom_game_button;
	GtkToggleButton* earmark_mode_button;
	AdwWindowTitle* windowtitle;
	GtkStack* play_pause_stack;
	GtkButton* pause_button;
	GtkButton* play_button;
	SudokuMenuButton* menu_button;
	GtkLabel* paused_label;
	GtkGestureClick* button_controller;
	gulong tick_handle;
	GSimpleAction* toggle_pause_action;
	GSimpleAction* earmark_mode_action;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* reset_board_action;
};

struct _SudokuMenuButton {
	AdwBin parent_instance;
	SudokuMenuButtonPrivate * priv;
	GtkStack* menu_fullscreen_stack;
	GtkButton* menu_unfullscreen_button;
	GtkButton* menu_fullscreen_button;
	GtkPopover* main_menu;
};

struct _SudokuMenuButtonClass {
	AdwBinClass parent_class;
};

static gint SudokuGameView_private_offset;
static gpointer sudoku_game_view_parent_class = NULL;
VALA_EXTERN Sudoku* sudoku_app;

VALA_EXTERN GType sudoku_game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGameView, g_object_unref)
VALA_EXTERN GType sudoku_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGrid, g_object_unref)
VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN GType sudoku_menu_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuMenuButton, g_object_unref)
static void sudoku_game_view_new_shortcut (SudokuGameViewClass* klass,
                                    const gchar* name,
                                    const gchar* accelerator);
VALA_EXTERN void sudoku_game_view_init (SudokuGameView* self,
                            SudokuBoard* board,
                            gdouble* highscore,
                            SudokuWindow* window);
static gdouble* _double_dup (gdouble* self);
VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
static void sudoku_game_view_highlighter_cb (SudokuGameView* self);
static void _sudoku_game_view_highlighter_cb_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void sudoku_game_view_show_possibilities_cb (SudokuGameView* self);
static void _sudoku_game_view_show_possibilities_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self);
static void sudoku_game_view_warnings_cb (SudokuGameView* self);
static void _sudoku_game_view_warnings_cb_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void sudoku_game_view_zoom_cb (SudokuGameView* self);
static void _sudoku_game_view_zoom_cb_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self);
static void sudoku_game_view_show_timer_cb (SudokuGameView* self);
static void _sudoku_game_view_show_timer_cb_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void sudoku_game_view_window_width_is_small_cb (SudokuGameView* self);
static void _sudoku_game_view_window_width_is_small_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void __lambda5_ (SudokuGameView* self);
static void ___lambda5__gtk_popover_closed (GtkPopover* _sender,
                                     gpointer self);
static void sudoku_game_view_button_released_cb (SudokuGameView* self,
                                          GtkGestureClick* gesture,
                                          gint n_press,
                                          gdouble x,
                                          gdouble y);
static void _sudoku_game_view_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                      gint n_press,
                                                                      gdouble x,
                                                                      gdouble y,
                                                                      gpointer self);
static GVariant* _variant_new5 (gboolean value);
static void sudoku_game_view_earmark_mode_cb (SudokuGameView* self);
static void _sudoku_game_view_earmark_mode_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static GVariant* _variant_new6 (gboolean value);
static void _sudoku_game_toggle_pause_g_simple_action_activate (GSimpleAction* _sender,
                                                         GVariant* parameter,
                                                         gpointer self);
VALA_EXTERN gboolean sudoku_get_show_timer (Sudoku* self);
static void _sudoku_game_reset_g_simple_action_activate (GSimpleAction* _sender,
                                                  GVariant* parameter,
                                                  gpointer self);
static void _sudoku_game_undo_g_simple_action_activate (GSimpleAction* _sender,
                                                 GVariant* parameter,
                                                 gpointer self);
static void _sudoku_game_redo_g_simple_action_activate (GSimpleAction* _sender,
                                                 GVariant* parameter,
                                                 gpointer self);
static void sudoku_game_view_initialize_clock_label (SudokuGameView* self);
static void sudoku_game_view_initialize_buttons (SudokuGameView* self);
static void sudoku_game_view_update_tick_connection (SudokuGameView* self);
static void sudoku_game_view_add_earmark_possibilities (SudokuGameView* self);
static void sudoku_game_view_paused_cb (SudokuGameView* self);
static void _sudoku_game_view_paused_cb_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void sudoku_game_view_action_completed_cb (SudokuGameView* self);
static void _sudoku_game_view_action_completed_cb_sudoku_game_action_completed (SudokuGame* _sender,
                                                                         StackAction action,
                                                                         gpointer self);
VALA_EXTERN SudokuGrid* sudoku_grid_new (SudokuGame* game);
VALA_EXTERN SudokuGrid* sudoku_grid_construct (GType object_type,
                                   SudokuGame* game);
VALA_EXTERN GType sudoku_grid_layout_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuGridLayoutManager, g_object_unref)
VALA_EXTERN SudokuGridLayoutManager* sudoku_grid_layout_manager_new (void);
VALA_EXTERN SudokuGridLayoutManager* sudoku_grid_layout_manager_construct (GType object_type);
VALA_EXTERN void sudoku_game_view_change_board (SudokuGameView* self,
                                    SudokuBoard* board,
                                    gdouble* highscore);
VALA_EXTERN void sudoku_grid_change_board (SudokuGrid* self);
VALA_EXTERN gboolean sudoku_window_get_width_is_small (SudokuWindow* self);
static void sudoku_game_view_set_clock_label_text (SudokuGameView* self,
                                            gint elapsed_time);
VALA_EXTERN gboolean sudoku_get_show_possibilities (Sudoku* self);
static void sudoku_game_view_tick_cb (SudokuGameView* self);
static void _sudoku_game_view_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                                 gpointer self);
VALA_EXTERN void sudoku_grid_toggle_highlighter (SudokuGrid* self);
VALA_EXTERN void sudoku_grid_update_warnings (SudokuGrid* self);
VALA_EXTERN void sudoku_grid_update_zoom (SudokuGrid* self);
VALA_EXTERN void sudoku_grid_unselect (SudokuGrid* self);
VALA_EXTERN gboolean sudoku_get_earmark_mode (Sudoku* self);
VALA_EXTERN void sudoku_set_earmark_mode (Sudoku* self,
                              gboolean value);
static gboolean sudoku_game_view_real_grab_focus (GtkWidget* base);
static void sudoku_game_view_real_dispose (GObject* base);
VALA_EXTERN SudokuGameView* sudoku_game_view_new (void);
VALA_EXTERN SudokuGameView* sudoku_game_view_construct (GType object_type);
static void sudoku_game_view_finalize (GObject * obj);
static GType sudoku_game_view_get_type_once (void);
VALA_EXTERN GType zoom_level_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean zoom_level_is_fully_zoomed_out (ZoomLevel self);
VALA_EXTERN gboolean zoom_level_is_fully_zoomed_in (ZoomLevel self);
VALA_EXTERN ZoomLevel zoom_level_zoom_in (ZoomLevel self);
VALA_EXTERN ZoomLevel zoom_level_zoom_out (ZoomLevel self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sudoku_game_view_get_instance_private (SudokuGameView* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuGameView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sudoku_game_view_new_shortcut (SudokuGameViewClass* klass,
                               const gchar* name,
                               const gchar* accelerator)
{
	GtkNamedAction* action = NULL;
	GtkNamedAction* _tmp0_;
	GtkShortcutTrigger* trigger = NULL;
	GtkShortcutTrigger* _tmp1_;
	GtkShortcut* shortcut = NULL;
	GtkShortcutTrigger* _tmp2_;
	GtkShortcutAction* _tmp3_;
	GtkShortcut* _tmp4_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (accelerator != NULL);
	_tmp0_ = (GtkNamedAction*) gtk_named_action_new (name);
	action = _tmp0_;
	_tmp1_ = gtk_shortcut_trigger_parse_string (accelerator);
	trigger = _tmp1_;
	_tmp2_ = _g_object_ref0 (trigger);
	_tmp3_ = _g_object_ref0 ((GtkShortcutAction*) action);
	_tmp4_ = gtk_shortcut_new (_tmp2_, _tmp3_);
	shortcut = _tmp4_;
	gtk_widget_class_add_shortcut (GTK_WIDGET_CLASS (klass), shortcut);
	_g_object_unref0 (shortcut);
	_g_object_unref0 (trigger);
	_g_object_unref0 (action);
}

static gdouble*
_double_dup (gdouble* self)
{
	gdouble* dup;
	dup = g_new0 (gdouble, 1);
	memcpy (dup, self, sizeof (gdouble));
	return dup;
}

static gpointer
__double_dup0 (gpointer self)
{
	return self ? _double_dup (self) : NULL;
}

static void
_sudoku_game_view_highlighter_cb_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	sudoku_game_view_highlighter_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_show_possibilities_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self)
{
	sudoku_game_view_show_possibilities_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_warnings_cb_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	sudoku_game_view_warnings_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_zoom_cb_g_object_notify (GObject* _sender,
                                           GParamSpec* pspec,
                                           gpointer self)
{
	sudoku_game_view_zoom_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_show_timer_cb_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	sudoku_game_view_show_timer_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_window_width_is_small_cb_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	sudoku_game_view_window_width_is_small_cb ((SudokuGameView*) self);
}

static void
__lambda5_ (SudokuGameView* self)
{
	gtk_widget_grab_focus ((GtkWidget*) self);
}

static void
___lambda5__gtk_popover_closed (GtkPopover* _sender,
                                gpointer self)
{
	__lambda5_ ((SudokuGameView*) self);
}

static void
_sudoku_game_view_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                 gint n_press,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self)
{
	sudoku_game_view_button_released_cb ((SudokuGameView*) self, _sender, n_press, x, y);
}

static GVariant*
_variant_new5 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_sudoku_game_view_earmark_mode_cb_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	sudoku_game_view_earmark_mode_cb ((SudokuGameView*) self);
}

static GVariant*
_variant_new6 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
_sudoku_game_toggle_pause_g_simple_action_activate (GSimpleAction* _sender,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	sudoku_game_toggle_pause ((SudokuGame*) self);
}

static void
_sudoku_game_reset_g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self)
{
	sudoku_game_reset ((SudokuGame*) self);
}

static void
_sudoku_game_undo_g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self)
{
	sudoku_game_undo ((SudokuGame*) self);
}

static void
_sudoku_game_redo_g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self)
{
	sudoku_game_redo ((SudokuGame*) self);
}

static void
_sudoku_game_view_paused_cb_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	sudoku_game_view_paused_cb ((SudokuGameView*) self);
}

static void
_sudoku_game_view_action_completed_cb_sudoku_game_action_completed (SudokuGame* _sender,
                                                                    StackAction action,
                                                                    gpointer self)
{
	sudoku_game_view_action_completed_cb ((SudokuGameView*) self);
}

void
sudoku_game_view_init (SudokuGameView* self,
                       SudokuBoard* board,
                       gdouble* highscore,
                       SudokuWindow* window)
{
	SudokuGame* _tmp0_;
	gdouble* _tmp1_;
	AdwWindowTitle* _tmp2_;
	SudokuGame* _tmp3_;
	SudokuBoard* _tmp4_;
	SudokuBoard* _tmp5_;
	DifficultyCategory _tmp6_;
	DifficultyCategory _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	Sudoku* _tmp10_;
	Sudoku* _tmp11_;
	Sudoku* _tmp12_;
	Sudoku* _tmp13_;
	Sudoku* _tmp14_;
	Sudoku* _tmp15_;
	Sudoku* _tmp16_;
	SudokuWindow* _tmp17_;
	SudokuMenuButton* _tmp18_;
	GtkPopover* _tmp19_;
	GtkGestureClick* _tmp20_;
	GtkGestureClick* _tmp21_;
	GtkGestureClick* _tmp22_;
	GtkGestureClick* _tmp23_;
	GtkEventController* _tmp24_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp25_;
	GVariant* _tmp26_;
	GSimpleAction* _tmp27_;
	GSimpleAction* _tmp28_;
	GSimpleAction* _tmp29_;
	SudokuGame* _tmp30_;
	GameMode _tmp31_;
	GameMode _tmp32_;
	GSimpleActionGroup* _tmp33_;
	GSimpleAction* _tmp34_;
	GVariant* _tmp35_;
	GSimpleAction* _tmp36_;
	GSimpleAction* _tmp37_;
	SudokuGame* _tmp38_;
	gboolean _tmp39_ = FALSE;
	SudokuGame* _tmp40_;
	GameMode _tmp41_;
	GameMode _tmp42_;
	GSimpleAction* _tmp46_;
	GSimpleActionGroup* _tmp47_;
	GSimpleAction* _tmp48_;
	GSimpleAction* _tmp49_;
	GSimpleAction* _tmp50_;
	SudokuGame* _tmp51_;
	GSimpleAction* _tmp52_;
	SudokuGame* _tmp53_;
	GSimpleActionGroup* _tmp54_;
	GSimpleAction* _tmp55_;
	GSimpleAction* _tmp56_;
	GSimpleAction* _tmp57_;
	SudokuGame* _tmp58_;
	GSimpleAction* _tmp59_;
	SudokuGame* _tmp60_;
	GSimpleActionGroup* _tmp61_;
	GSimpleAction* _tmp62_;
	GSimpleAction* _tmp63_;
	GSimpleAction* _tmp64_;
	SudokuGame* _tmp65_;
	GSimpleAction* _tmp66_;
	SudokuGame* _tmp67_;
	GSimpleActionGroup* _tmp68_;
	GSimpleAction* _tmp69_;
	GSimpleActionGroup* _tmp70_;
	GtkLabel* _tmp71_;
	SudokuGame* _tmp72_;
	SudokuBoard* _tmp73_;
	SudokuBoard* _tmp74_;
	gdouble _tmp75_;
	gdouble _tmp76_;
	SudokuGame* _tmp77_;
	SudokuGame* _tmp78_;
	SudokuGame* _tmp79_;
	SudokuGrid* _tmp80_;
	SudokuGridLayoutManager* grid_layout = NULL;
	SudokuGridLayoutManager* _tmp81_;
	AdwBin* _tmp82_;
	GtkLayoutManager* _tmp83_;
	GtkOverlay* _tmp84_;
	SudokuGrid* _tmp85_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = sudoku_game_new (board);
	_g_object_unref0 (self->game);
	self->game = _tmp0_;
	_tmp1_ = __double_dup0 (highscore);
	_g_free0 (self->highscore);
	self->highscore = _tmp1_;
	self->window = window;
	_tmp2_ = self->priv->windowtitle;
	_tmp3_ = self->game;
	_tmp4_ = sudoku_game_get_board (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = sudoku_board_get_difficulty_category (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = difficulty_category_to_string (_tmp7_);
	_tmp9_ = _tmp8_;
	adw_window_title_set_subtitle (_tmp2_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::highlighter", (GCallback) _sudoku_game_view_highlighter_cb_g_object_notify, self, 0);
	_tmp11_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::show-possibilities", (GCallback) _sudoku_game_view_show_possibilities_cb_g_object_notify, self, 0);
	_tmp12_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::show-warnings", (GCallback) _sudoku_game_view_warnings_cb_g_object_notify, self, 0);
	_tmp13_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::earmark-warnings", (GCallback) _sudoku_game_view_warnings_cb_g_object_notify, self, 0);
	_tmp14_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp14_, "notify::solution-warnings", (GCallback) _sudoku_game_view_warnings_cb_g_object_notify, self, 0);
	_tmp15_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::zoom-level", (GCallback) _sudoku_game_view_zoom_cb_g_object_notify, self, 0);
	_tmp16_ = sudoku_app;
	g_signal_connect_object ((GObject*) _tmp16_, "notify::show-timer", (GCallback) _sudoku_game_view_show_timer_cb_g_object_notify, self, 0);
	_tmp17_ = self->window;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::width-is-small", (GCallback) _sudoku_game_view_window_width_is_small_cb_g_object_notify, self, 0);
	_tmp18_ = self->priv->menu_button;
	_tmp19_ = _tmp18_->main_menu;
	g_signal_connect_object (_tmp19_, "closed", (GCallback) ___lambda5__gtk_popover_closed, self, 0);
	_tmp20_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->button_controller);
	self->priv->button_controller = _tmp20_;
	_tmp21_ = self->priv->button_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp21_, (guint) 0);
	_tmp22_ = self->priv->button_controller;
	g_signal_connect_object (_tmp22_, "released", (GCallback) _sudoku_game_view_button_released_cb_gtk_gesture_click_released, self, 0);
	_tmp23_ = self->priv->button_controller;
	_tmp24_ = _g_object_ref0 ((GtkEventController*) _tmp23_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp24_);
	_tmp25_ = g_simple_action_group_new ();
	action_group = _tmp25_;
	_tmp26_ = _variant_new5 (FALSE);
	_tmp27_ = g_simple_action_new_stateful ("earmark-mode", NULL, _tmp26_);
	_g_object_unref0 (self->priv->earmark_mode_action);
	self->priv->earmark_mode_action = _tmp27_;
	_g_variant_unref0 (_tmp26_);
	_tmp28_ = self->priv->earmark_mode_action;
	g_signal_connect_object (_tmp28_, "activate", (GCallback) _sudoku_game_view_earmark_mode_cb_g_simple_action_activate, self, 0);
	_tmp29_ = self->priv->earmark_mode_action;
	_tmp30_ = self->game;
	_tmp31_ = sudoku_game_get_mode (_tmp30_);
	_tmp32_ = _tmp31_;
	g_simple_action_set_enabled (_tmp29_, _tmp32_ != GAME_MODE_CREATE);
	_tmp33_ = action_group;
	_tmp34_ = self->priv->earmark_mode_action;
	g_action_map_add_action ((GActionMap*) _tmp33_, (GAction*) _tmp34_);
	_tmp35_ = _variant_new6 (FALSE);
	_tmp36_ = g_simple_action_new_stateful ("toggle-pause", NULL, _tmp35_);
	_g_object_unref0 (self->priv->toggle_pause_action);
	self->priv->toggle_pause_action = _tmp36_;
	_g_variant_unref0 (_tmp35_);
	_tmp37_ = self->priv->toggle_pause_action;
	_tmp38_ = self->game;
	g_signal_connect_object (_tmp37_, "activate", (GCallback) _sudoku_game_toggle_pause_g_simple_action_activate, _tmp38_, 0);
	_tmp40_ = self->game;
	_tmp41_ = sudoku_game_get_mode (_tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ == GAME_MODE_PLAY) {
		Sudoku* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp43_ = sudoku_app;
		_tmp44_ = sudoku_get_show_timer (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = _tmp45_;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp46_ = self->priv->toggle_pause_action;
	g_simple_action_set_enabled (_tmp46_, _tmp39_);
	_tmp47_ = action_group;
	_tmp48_ = self->priv->toggle_pause_action;
	g_action_map_add_action ((GActionMap*) _tmp47_, (GAction*) _tmp48_);
	_tmp49_ = g_simple_action_new ("reset-board", NULL);
	_g_object_unref0 (self->priv->reset_board_action);
	self->priv->reset_board_action = _tmp49_;
	_tmp50_ = self->priv->reset_board_action;
	_tmp51_ = self->game;
	g_signal_connect_object (_tmp50_, "activate", (GCallback) _sudoku_game_reset_g_simple_action_activate, _tmp51_, 0);
	_tmp52_ = self->priv->reset_board_action;
	_tmp53_ = self->game;
	g_simple_action_set_enabled (_tmp52_, !sudoku_game_is_empty (_tmp53_));
	_tmp54_ = action_group;
	_tmp55_ = self->priv->reset_board_action;
	g_action_map_add_action ((GActionMap*) _tmp54_, (GAction*) _tmp55_);
	_tmp56_ = g_simple_action_new ("undo", NULL);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp56_;
	_tmp57_ = self->priv->undo_action;
	_tmp58_ = self->game;
	g_signal_connect_object (_tmp57_, "activate", (GCallback) _sudoku_game_undo_g_simple_action_activate, _tmp58_, 0);
	_tmp59_ = self->priv->undo_action;
	_tmp60_ = self->game;
	g_simple_action_set_enabled (_tmp59_, !sudoku_game_is_undostack_null (_tmp60_));
	_tmp61_ = action_group;
	_tmp62_ = self->priv->undo_action;
	g_action_map_add_action ((GActionMap*) _tmp61_, (GAction*) _tmp62_);
	_tmp63_ = g_simple_action_new ("redo", NULL);
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp63_;
	_tmp64_ = self->priv->redo_action;
	_tmp65_ = self->game;
	g_signal_connect_object (_tmp64_, "activate", (GCallback) _sudoku_game_redo_g_simple_action_activate, _tmp65_, 0);
	_tmp66_ = self->priv->redo_action;
	_tmp67_ = self->game;
	g_simple_action_set_enabled (_tmp66_, !sudoku_game_is_redostack_null (_tmp67_));
	_tmp68_ = action_group;
	_tmp69_ = self->priv->redo_action;
	g_action_map_add_action ((GActionMap*) _tmp68_, (GAction*) _tmp69_);
	_tmp70_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "game-view", (GActionGroup*) _tmp70_);
	_tmp71_ = (GtkLabel*) gtk_label_new (_ ("Paused"));
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->paused_label);
	self->priv->paused_label = _tmp71_;
	sudoku_game_view_initialize_clock_label (self);
	sudoku_game_view_initialize_buttons (self);
	sudoku_game_view_update_tick_connection (self);
	_tmp72_ = self->game;
	_tmp73_ = sudoku_game_get_board (_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp75_ = sudoku_board_get_previous_played_time (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ == 0.0) {
		sudoku_game_view_add_earmark_possibilities (self);
	}
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	_tmp77_ = self->game;
	g_signal_connect_object ((GObject*) _tmp77_, "notify::paused", (GCallback) _sudoku_game_view_paused_cb_g_object_notify, self, 0);
	_tmp78_ = self->game;
	g_signal_connect_object (_tmp78_, "action-completed", (GCallback) _sudoku_game_view_action_completed_cb_sudoku_game_action_completed, self, 0);
	_tmp79_ = self->game;
	_tmp80_ = sudoku_grid_new (_tmp79_);
	g_object_ref_sink (_tmp80_);
	_g_object_unref0 (self->grid);
	self->grid = _tmp80_;
	_tmp81_ = sudoku_grid_layout_manager_new ();
	grid_layout = _tmp81_;
	_tmp82_ = self->priv->grid_bin;
	_tmp83_ = _g_object_ref0 ((GtkLayoutManager*) grid_layout);
	gtk_widget_set_layout_manager ((GtkWidget*) _tmp82_, _tmp83_);
	_tmp84_ = self->priv->grid_overlay;
	_tmp85_ = self->grid;
	gtk_overlay_set_child (_tmp84_, (GtkWidget*) _tmp85_);
	_g_object_unref0 (grid_layout);
	_g_object_unref0 (action_group);
}

void
sudoku_game_view_change_board (SudokuGameView* self,
                               SudokuBoard* board,
                               gdouble* highscore)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	GameMode _tmp3_;
	gboolean _tmp4_ = FALSE;
	SudokuGame* _tmp5_;
	GameMode _tmp6_;
	GameMode _tmp7_;
	GSimpleAction* _tmp11_;
	gdouble* _tmp12_;
	SudokuGame* _tmp13_;
	SudokuGrid* _tmp14_;
	AdwWindowTitle* _tmp15_;
	DifficultyCategory _tmp16_;
	DifficultyCategory _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->priv->earmark_mode_action;
	_tmp1_ = self->game;
	_tmp2_ = sudoku_game_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	g_simple_action_set_enabled (_tmp0_, _tmp3_ == GAME_MODE_PLAY);
	_tmp5_ = self->game;
	_tmp6_ = sudoku_game_get_mode (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == GAME_MODE_PLAY) {
		Sudoku* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = sudoku_app;
		_tmp9_ = sudoku_get_show_timer (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp11_ = self->priv->toggle_pause_action;
	g_simple_action_set_enabled (_tmp11_, _tmp4_);
	_tmp12_ = __double_dup0 (highscore);
	_g_free0 (self->highscore);
	self->highscore = _tmp12_;
	_tmp13_ = self->game;
	sudoku_game_change_board (_tmp13_, board);
	sudoku_game_view_initialize_buttons (self);
	sudoku_game_view_add_earmark_possibilities (self);
	_tmp14_ = self->grid;
	sudoku_grid_change_board (_tmp14_);
	sudoku_game_view_initialize_clock_label (self);
	sudoku_game_view_update_tick_connection (self);
	_tmp15_ = self->priv->windowtitle;
	_tmp16_ = sudoku_board_get_difficulty_category (board);
	_tmp17_ = _tmp16_;
	_tmp18_ = difficulty_category_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	adw_window_title_set_subtitle (_tmp15_, _tmp19_);
	_g_free0 (_tmp19_);
	G_TYPE_INSTANCE_GET_CLASS ((GtkWidget*) self, gtk_widget_get_type (), GtkWidgetClass)->focus ((GtkWidget*) self, GTK_DIR_TAB_FORWARD);
}

static void
sudoku_game_view_initialize_buttons (SudokuGameView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Sudoku* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkBox* _tmp11_;
	gboolean _tmp12_ = FALSE;
	Sudoku* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GtkStack* _tmp19_;
	GtkButton* _tmp20_;
	SudokuGame* _tmp21_;
	GameMode _tmp22_;
	GameMode _tmp23_;
	gboolean _tmp24_ = FALSE;
	SudokuGame* _tmp25_;
	GameMode _tmp26_;
	GameMode _tmp27_;
	GtkToggleButton* _tmp39_;
	gboolean _tmp40_ = FALSE;
	SudokuGame* _tmp41_;
	GtkButton* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp2_ = sudoku_app;
	_tmp3_ = sudoku_get_show_timer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		SudokuGame* _tmp5_;
		GameMode _tmp6_;
		GameMode _tmp7_;
		_tmp5_ = self->game;
		_tmp6_ = sudoku_game_get_mode (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == GAME_MODE_PLAY;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SudokuWindow* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->window;
		_tmp9_ = sudoku_window_get_width_is_small (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = !_tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = self->priv->clock_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp0_);
	_tmp13_ = sudoku_app;
	_tmp14_ = sudoku_get_show_timer (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		SudokuGame* _tmp16_;
		GameMode _tmp17_;
		GameMode _tmp18_;
		_tmp16_ = self->game;
		_tmp17_ = sudoku_game_get_mode (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_ == GAME_MODE_PLAY;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp19_ = self->priv->play_pause_stack;
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, _tmp12_);
	_tmp20_ = self->priv->play_custom_game_button;
	_tmp21_ = self->game;
	_tmp22_ = sudoku_game_get_mode (_tmp21_);
	_tmp23_ = _tmp22_;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, _tmp23_ == GAME_MODE_CREATE);
	_tmp25_ = self->game;
	_tmp26_ = sudoku_game_get_mode (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == GAME_MODE_PLAY) {
		gboolean _tmp28_ = FALSE;
		Sudoku* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp29_ = sudoku_app;
		_tmp30_ = sudoku_get_show_timer (_tmp29_);
		_tmp31_ = _tmp30_;
		if (!_tmp31_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			Sudoku* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			_tmp33_ = sudoku_app;
			_tmp34_ = sudoku_get_show_timer (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_) {
				SudokuWindow* _tmp36_;
				gboolean _tmp37_;
				gboolean _tmp38_;
				_tmp36_ = self->window;
				_tmp37_ = sudoku_window_get_width_is_small (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp32_ = !_tmp38_;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp28_ = _tmp32_;
		}
		_tmp24_ = _tmp28_;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp39_ = self->priv->earmark_mode_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp39_, _tmp24_);
	_tmp41_ = self->game;
	if (!sudoku_game_is_empty (_tmp41_)) {
		SudokuGame* _tmp42_;
		SudokuBoard* _tmp43_;
		SudokuBoard* _tmp44_;
		_tmp42_ = self->game;
		_tmp43_ = sudoku_game_get_board (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp40_ = !sudoku_board_is_fully_filled (_tmp44_);
	} else {
		_tmp40_ = FALSE;
	}
	_tmp45_ = self->priv->play_custom_game_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp45_, _tmp40_);
}

static void
sudoku_game_view_initialize_clock_label (SudokuGameView* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	GameMode _tmp3_;
	gint elapsed_time = 0;
	SudokuGame* _tmp7_;
	gdouble* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->game;
	_tmp2_ = sudoku_game_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_MODE_CREATE) {
		_tmp0_ = TRUE;
	} else {
		Sudoku* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = sudoku_app;
		_tmp5_ = sudoku_get_show_timer (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = self->game;
	elapsed_time = (gint) sudoku_game_get_total_time_played (_tmp7_);
	_tmp8_ = self->highscore;
	if (_tmp8_ != NULL) {
		gdouble* _tmp9_;
		_tmp9_ = self->highscore;
		if (((gdouble) elapsed_time) > (*_tmp9_)) {
			GtkLabel* _tmp10_;
			gchar* _tmp11_;
			gchar** _tmp12_;
			gchar** _tmp13_;
			gint _tmp13__length1;
			_tmp10_ = self->priv->clock_label;
			_tmp11_ = g_strdup ("numeric");
			_tmp12_ = g_new0 (gchar*, 1 + 1);
			_tmp12_[0] = _tmp11_;
			_tmp13_ = _tmp12_;
			_tmp13__length1 = 1;
			gtk_widget_set_css_classes ((GtkWidget*) _tmp10_, _tmp13_);
			_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
		} else {
			gdouble* _tmp14_;
			_tmp14_ = self->highscore;
			if (((gdouble) elapsed_time) > ((*_tmp14_) - 60)) {
				GtkLabel* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				_tmp15_ = self->priv->clock_label;
				_tmp16_ = g_strdup ("numeric");
				_tmp17_ = g_strdup ("warning");
				_tmp18_ = g_new0 (gchar*, 2 + 1);
				_tmp18_[0] = _tmp16_;
				_tmp18_[1] = _tmp17_;
				_tmp19_ = _tmp18_;
				_tmp19__length1 = 2;
				gtk_widget_set_css_classes ((GtkWidget*) _tmp15_, _tmp19_);
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
			} else {
				GtkLabel* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar** _tmp23_;
				gchar** _tmp24_;
				gint _tmp24__length1;
				_tmp20_ = self->priv->clock_label;
				_tmp21_ = g_strdup ("numeric");
				_tmp22_ = g_strdup ("success");
				_tmp23_ = g_new0 (gchar*, 2 + 1);
				_tmp23_[0] = _tmp21_;
				_tmp23_[1] = _tmp22_;
				_tmp24_ = _tmp23_;
				_tmp24__length1 = 2;
				gtk_widget_set_css_classes ((GtkWidget*) _tmp20_, _tmp24_);
				_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	sudoku_game_view_set_clock_label_text (self, elapsed_time);
}

static void
sudoku_game_view_set_clock_label_text (SudokuGameView* self,
                                       gint elapsed_time)
{
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	g_return_if_fail (self != NULL);
	hours = elapsed_time / 3600;
	minutes = (elapsed_time - (hours * 3600)) / 60;
	seconds = (elapsed_time - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		GtkLabel* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->clock_label;
		_tmp1_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_tmp2_ = _tmp1_;
		gtk_label_set_text (_tmp0_, _tmp2_);
		_g_free0 (_tmp2_);
	} else {
		GtkLabel* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->clock_label;
		_tmp4_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_tmp5_ = _tmp4_;
		gtk_label_set_text (_tmp3_, _tmp5_);
		_g_free0 (_tmp5_);
	}
}

static void
sudoku_game_view_add_earmark_possibilities (SudokuGameView* self)
{
	gboolean _tmp0_ = FALSE;
	Sudoku* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_app;
	_tmp2_ = sudoku_get_show_possibilities (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		SudokuGame* _tmp4_;
		GameMode _tmp5_;
		GameMode _tmp6_;
		_tmp4_ = self->game;
		_tmp5_ = sudoku_game_get_mode (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != GAME_MODE_CREATE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp7_;
		_tmp7_ = self->game;
		sudoku_game_enable_all_earmark_possibilities (_tmp7_);
	}
}

static void
_sudoku_game_view_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                            gpointer self)
{
	sudoku_game_view_tick_cb ((SudokuGameView*) self);
}

static void
sudoku_game_view_update_tick_connection (SudokuGameView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->tick_handle == ((gulong) 0)) {
		SudokuGame* _tmp2_;
		GameMode _tmp3_;
		GameMode _tmp4_;
		_tmp2_ = self->game;
		_tmp3_ = sudoku_game_get_mode (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ != GAME_MODE_CREATE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Sudoku* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = sudoku_app;
		_tmp6_ = sudoku_get_show_timer (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp8_;
		gulong _tmp9_;
		_tmp8_ = self->game;
		_tmp9_ = g_signal_connect_object (_tmp8_, "tick", (GCallback) _sudoku_game_view_tick_cb_sudoku_game_tick, self, 0);
		self->priv->tick_handle = _tmp9_;
	} else {
		gboolean _tmp10_ = FALSE;
		if (self->priv->tick_handle != ((gulong) 0)) {
			gboolean _tmp11_ = FALSE;
			SudokuGame* _tmp12_;
			GameMode _tmp13_;
			GameMode _tmp14_;
			_tmp12_ = self->game;
			_tmp13_ = sudoku_game_get_mode (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == GAME_MODE_CREATE) {
				_tmp11_ = TRUE;
			} else {
				Sudoku* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = sudoku_app;
				_tmp16_ = sudoku_get_show_timer (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = !_tmp17_;
			}
			_tmp10_ = _tmp11_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			SudokuGame* _tmp18_;
			_tmp18_ = self->game;
			g_signal_handler_disconnect ((GObject*) _tmp18_, self->priv->tick_handle);
			self->priv->tick_handle = (gulong) 0;
		}
	}
}

static void
sudoku_game_view_tick_cb (SudokuGameView* self)
{
	gint elapsed_time = 0;
	SudokuGame* _tmp0_;
	gdouble* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->game;
	elapsed_time = (gint) sudoku_game_get_total_time_played (_tmp0_);
	_tmp1_ = self->highscore;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gdouble* _tmp3_;
		_tmp3_ = self->highscore;
		if (((gdouble) elapsed_time) > (*_tmp3_)) {
			GtkLabel* _tmp4_;
			_tmp4_ = self->priv->clock_label;
			_tmp2_ = gtk_widget_has_css_class ((GtkWidget*) _tmp4_, "warning");
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GtkLabel* _tmp5_;
			_tmp5_ = self->priv->clock_label;
			gtk_widget_remove_css_class ((GtkWidget*) _tmp5_, "warning");
		} else {
			gboolean _tmp6_ = FALSE;
			gdouble* _tmp7_;
			_tmp7_ = self->highscore;
			if (((gdouble) elapsed_time) > ((*_tmp7_) - 60)) {
				GtkLabel* _tmp8_;
				_tmp8_ = self->priv->clock_label;
				_tmp6_ = gtk_widget_has_css_class ((GtkWidget*) _tmp8_, "success");
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				GtkLabel* _tmp9_;
				gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				_tmp9_ = self->priv->clock_label;
				_tmp10_ = g_strdup ("warning");
				_tmp11_ = g_new0 (gchar*, 1 + 1);
				_tmp11_[0] = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp12__length1 = 1;
				gtk_widget_set_css_classes ((GtkWidget*) _tmp9_, _tmp12_);
				_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	sudoku_game_view_set_clock_label_text (self, elapsed_time);
}

static void
sudoku_game_view_window_width_is_small_cb (SudokuGameView* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Sudoku* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkBox* _tmp11_;
	gboolean _tmp12_ = FALSE;
	SudokuGame* _tmp13_;
	GameMode _tmp14_;
	GameMode _tmp15_;
	GtkToggleButton* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp2_ = sudoku_app;
	_tmp3_ = sudoku_get_show_timer (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		SudokuWindow* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->window;
		_tmp6_ = sudoku_window_get_width_is_small (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		SudokuGame* _tmp8_;
		GameMode _tmp9_;
		GameMode _tmp10_;
		_tmp8_ = self->game;
		_tmp9_ = sudoku_game_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_ == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = self->priv->clock_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp0_);
	_tmp13_ = self->game;
	_tmp14_ = sudoku_game_get_mode (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == GAME_MODE_PLAY) {
		gboolean _tmp16_ = FALSE;
		Sudoku* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp17_ = sudoku_app;
		_tmp18_ = sudoku_get_show_timer (_tmp17_);
		_tmp19_ = _tmp18_;
		if (!_tmp19_) {
			_tmp16_ = TRUE;
		} else {
			gboolean _tmp20_ = FALSE;
			Sudoku* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp21_ = sudoku_app;
			_tmp22_ = sudoku_get_show_timer (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				SudokuWindow* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp24_ = self->window;
				_tmp25_ = sudoku_window_get_width_is_small (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp20_ = !_tmp26_;
			} else {
				_tmp20_ = FALSE;
			}
			_tmp16_ = _tmp20_;
		}
		_tmp12_ = _tmp16_;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp27_ = self->priv->earmark_mode_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp27_, _tmp12_);
}

static void
sudoku_game_view_action_completed_cb (SudokuGameView* self)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	GSimpleAction* _tmp4_;
	SudokuGame* _tmp5_;
	gboolean _tmp6_ = FALSE;
	SudokuGame* _tmp7_;
	GtkButton* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_action;
	_tmp1_ = self->game;
	g_simple_action_set_enabled (_tmp0_, !sudoku_game_is_undostack_null (_tmp1_));
	_tmp2_ = self->priv->redo_action;
	_tmp3_ = self->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_redostack_null (_tmp3_));
	_tmp4_ = self->priv->reset_board_action;
	_tmp5_ = self->game;
	g_simple_action_set_enabled (_tmp4_, !sudoku_game_is_empty (_tmp5_));
	_tmp7_ = self->game;
	if (!sudoku_game_is_empty (_tmp7_)) {
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		SudokuBoard* _tmp10_;
		_tmp8_ = self->game;
		_tmp9_ = sudoku_game_get_board (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = !sudoku_board_is_fully_filled (_tmp10_);
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = self->priv->play_custom_game_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp6_);
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
sudoku_game_view_paused_cb (SudokuGameView* self)
{
	PangoAttrList* attr_list = NULL;
	GtkLabel* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp3_;
	PangoAttrList* _tmp5_;
	PangoAttribute* _tmp6_;
	GtkLabel* _tmp7_;
	PangoAttrList* _tmp8_;
	GtkLabel* _tmp9_;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	SudokuGrid* _tmp13_;
	SudokuGame* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	SudokuGame* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->paused_label;
	_tmp1_ = gtk_label_get_attributes (_tmp0_);
	_tmp2_ = _pango_attr_list_ref0 (_tmp1_);
	attr_list = _tmp2_;
	_tmp3_ = attr_list;
	if (_tmp3_ == NULL) {
		PangoAttrList* _tmp4_;
		_tmp4_ = pango_attr_list_new ();
		_pango_attr_list_unref0 (attr_list);
		attr_list = _tmp4_;
	}
	_tmp5_ = attr_list;
	_tmp6_ = pango_attr_size_new_absolute (((gint) (gtk_widget_get_width ((GtkWidget*) self) * 0.125)) * PANGO_SCALE);
	pango_attr_list_change (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->paused_label;
	_tmp8_ = attr_list;
	gtk_label_set_attributes (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->paused_label;
	_tmp10_ = self->game;
	_tmp11_ = sudoku_game_get_paused (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, _tmp12_);
	_tmp13_ = self->grid;
	_tmp14_ = self->game;
	_tmp15_ = sudoku_game_get_paused (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp13_, !_tmp16_);
	_tmp17_ = self->game;
	_tmp18_ = sudoku_game_get_paused (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		GtkStack* _tmp20_;
		GtkButton* _tmp21_;
		GSimpleAction* _tmp22_;
		GtkOverlay* _tmp23_;
		GtkLabel* _tmp24_;
		GtkOverlay* _tmp25_;
		_tmp20_ = self->priv->play_pause_stack;
		_tmp21_ = self->priv->play_button;
		gtk_stack_set_visible_child (_tmp20_, (GtkWidget*) _tmp21_);
		_tmp22_ = self->priv->reset_board_action;
		g_simple_action_set_enabled (_tmp22_, FALSE);
		_tmp23_ = self->priv->grid_overlay;
		_tmp24_ = self->priv->paused_label;
		gtk_overlay_add_overlay (_tmp23_, (GtkWidget*) _tmp24_);
		_tmp25_ = self->priv->grid_overlay;
		gtk_widget_add_css_class ((GtkWidget*) _tmp25_, "paused");
	} else {
		GtkStack* _tmp26_;
		GtkButton* _tmp27_;
		GSimpleAction* _tmp28_;
		SudokuGame* _tmp29_;
		GtkOverlay* _tmp30_;
		GtkLabel* _tmp31_;
		GtkOverlay* _tmp32_;
		_tmp26_ = self->priv->play_pause_stack;
		_tmp27_ = self->priv->pause_button;
		gtk_stack_set_visible_child (_tmp26_, (GtkWidget*) _tmp27_);
		_tmp28_ = self->priv->reset_board_action;
		_tmp29_ = self->game;
		g_simple_action_set_enabled (_tmp28_, !sudoku_game_is_empty (_tmp29_));
		_tmp30_ = self->priv->grid_overlay;
		_tmp31_ = self->priv->paused_label;
		gtk_overlay_remove_overlay (_tmp30_, (GtkWidget*) _tmp31_);
		_tmp32_ = self->priv->grid_overlay;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp32_, "paused");
	}
	_pango_attr_list_unref0 (attr_list);
}

static void
sudoku_game_view_show_possibilities_cb (SudokuGameView* self)
{
	SudokuGame* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->game;
	if (sudoku_game_get_current_stack_action (_tmp0_) == STACK_ACTION_ENABLE_ALL_EARMARK_POSSIBILITIES) {
		SudokuGame* _tmp1_;
		_tmp1_ = self->game;
		sudoku_game_undo (_tmp1_);
	} else {
		sudoku_game_view_add_earmark_possibilities (self);
	}
}

static void
sudoku_game_view_highlighter_cb (SudokuGameView* self)
{
	SudokuGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->grid;
	sudoku_grid_toggle_highlighter (_tmp0_);
}

static void
sudoku_game_view_warnings_cb (SudokuGameView* self)
{
	SudokuGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->grid;
	sudoku_grid_update_warnings (_tmp0_);
}

static void
sudoku_game_view_zoom_cb (SudokuGameView* self)
{
	SudokuGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->grid;
	sudoku_grid_update_zoom (_tmp0_);
}

static void
sudoku_game_view_show_timer_cb (SudokuGameView* self)
{
	SudokuGame* _tmp0_;
	GameMode _tmp1_;
	GameMode _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->game;
	_tmp1_ = sudoku_game_get_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GAME_MODE_PLAY) {
		Sudoku* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = sudoku_app;
		_tmp4_ = sudoku_get_show_timer (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			GtkToggleButton* _tmp6_;
			SudokuWindow* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			GtkBox* _tmp10_;
			SudokuWindow* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			GSimpleAction* _tmp14_;
			GtkStack* _tmp15_;
			sudoku_game_view_initialize_clock_label (self);
			sudoku_game_view_update_tick_connection (self);
			_tmp6_ = self->priv->earmark_mode_button;
			_tmp7_ = self->window;
			_tmp8_ = sudoku_window_get_width_is_small (_tmp7_);
			_tmp9_ = _tmp8_;
			gtk_widget_set_visible ((GtkWidget*) _tmp6_, !_tmp9_);
			_tmp10_ = self->priv->clock_box;
			_tmp11_ = self->window;
			_tmp12_ = sudoku_window_get_width_is_small (_tmp11_);
			_tmp13_ = _tmp12_;
			gtk_widget_set_visible ((GtkWidget*) _tmp10_, !_tmp13_);
			_tmp14_ = self->priv->toggle_pause_action;
			g_simple_action_set_enabled (_tmp14_, TRUE);
			_tmp15_ = self->priv->play_pause_stack;
			gtk_widget_set_visible ((GtkWidget*) _tmp15_, TRUE);
		} else {
			GtkBox* _tmp16_;
			GtkToggleButton* _tmp17_;
			GtkStack* _tmp18_;
			GSimpleAction* _tmp19_;
			SudokuGame* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			_tmp16_ = self->priv->clock_box;
			gtk_widget_set_visible ((GtkWidget*) _tmp16_, FALSE);
			sudoku_game_view_update_tick_connection (self);
			_tmp17_ = self->priv->earmark_mode_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp17_, TRUE);
			_tmp18_ = self->priv->play_pause_stack;
			gtk_widget_set_visible ((GtkWidget*) _tmp18_, FALSE);
			_tmp19_ = self->priv->toggle_pause_action;
			g_simple_action_set_enabled (_tmp19_, FALSE);
			_tmp20_ = self->game;
			_tmp21_ = sudoku_game_get_paused (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				SudokuGame* _tmp23_;
				_tmp23_ = self->game;
				sudoku_game_toggle_pause (_tmp23_);
			}
		}
	}
}

static void
sudoku_game_view_button_released_cb (SudokuGameView* self,
                                     GtkGestureClick* gesture,
                                     gint n_press,
                                     gdouble x,
                                     gdouble y)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->game;
	_tmp2_ = sudoku_game_get_paused (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		SudokuGrid* _tmp4_;
		_tmp4_ = self->grid;
		sudoku_grid_unselect (_tmp4_);
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

static void
sudoku_game_view_earmark_mode_cb (SudokuGameView* self)
{
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkToggleButton* _tmp4_;
	Sudoku* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_app;
	_tmp1_ = sudoku_app;
	_tmp2_ = sudoku_get_earmark_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	sudoku_set_earmark_mode (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->earmark_mode_button;
	_tmp5_ = sudoku_app;
	_tmp6_ = sudoku_get_earmark_mode (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_toggle_button_set_active (_tmp4_, _tmp7_);
}

static gboolean
sudoku_game_view_real_grab_focus (GtkWidget* base)
{
	SudokuGameView * self;
	SudokuGrid* _tmp0_;
	gboolean result;
	self = (SudokuGameView*) base;
	_tmp0_ = self->grid;
	result = gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	return result;
}

static void
sudoku_game_view_real_dispose (GObject* base)
{
	SudokuGameView * self;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	SudokuGrid* _tmp6_ = NULL;
	SudokuGrid* _tmp7_;
	self = (SudokuGameView*) base;
	_tmp1_ = self->game;
	if (_tmp1_ != NULL) {
		SudokuGame* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->game;
		_tmp3_ = sudoku_game_get_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp5_;
		_tmp5_ = self->game;
		sudoku_game_stop_clock (_tmp5_);
	}
	_tmp7_ = self->grid;
	_tmp6_ = _tmp7_;
	if (_tmp6_ != NULL) {
		gtk_widget_unparent ((GtkWidget*) _tmp6_);
	}
	G_OBJECT_CLASS (sudoku_game_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin));
}

SudokuGameView*
sudoku_game_view_construct (GType object_type)
{
	SudokuGameView * self = NULL;
	self = (SudokuGameView*) g_object_new (object_type, NULL);
	return self;
}

SudokuGameView*
sudoku_game_view_new (void)
{
	return sudoku_game_view_construct (TYPE_SUDOKU_GAME_VIEW);
}

static void
sudoku_game_view_class_init (SudokuGameViewClass * klass,
                             gpointer klass_data)
{
	sudoku_game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuGameView_private_offset);
	((GtkWidgetClass *) klass)->grab_focus = (gboolean (*) (GtkWidget*)) sudoku_game_view_real_grab_focus;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_game_view_real_dispose;
	G_OBJECT_CLASS (klass)->finalize = sudoku_game_view_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/game-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_overlay", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, grid_overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_bin", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, grid_bin));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_box", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, clock_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_label", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, clock_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_custom_game_button", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, play_custom_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "earmark_mode_button", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, earmark_mode_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "windowtitle", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, windowtitle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_pause_stack", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, play_pause_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pause_button", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, pause_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_button", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, play_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menu_button", FALSE, SudokuGameView_private_offset + G_STRUCT_OFFSET (SudokuGameViewPrivate, menu_button));
	sudoku_game_view_new_shortcut (klass, "game-view.earmark-mode", "e");
	sudoku_game_view_new_shortcut (klass, "game-view.toggle-pause", "p");
	sudoku_game_view_new_shortcut (klass, "game-view.reset-board", "<Primary>r");
	sudoku_game_view_new_shortcut (klass, "game-view.undo", "u|<Primary>z");
	sudoku_game_view_new_shortcut (klass, "game-view.redo", "r|<Primary><Shift>z");
}

static void
sudoku_game_view_instance_init (SudokuGameView * self,
                                gpointer klass)
{
	self->priv = sudoku_game_view_get_instance_private (self);
	g_type_ensure (TYPE_SUDOKU_MENU_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sudoku_game_view_finalize (GObject * obj)
{
	SudokuGameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GAME_VIEW, SudokuGameView);
	_g_object_unref0 (self->priv->paused_label);
	_g_object_unref0 (self->priv->button_controller);
	_g_object_unref0 (self->game);
	_g_object_unref0 (self->grid);
	_g_object_unref0 (self->priv->toggle_pause_action);
	_g_object_unref0 (self->priv->earmark_mode_action);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->reset_board_action);
	_g_free0 (self->highscore);
	G_OBJECT_CLASS (sudoku_game_view_parent_class)->finalize (obj);
}

static GType
sudoku_game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuGameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGameView), 0, (GInstanceInitFunc) sudoku_game_view_instance_init, NULL };
	GType sudoku_game_view_type_id;
	sudoku_game_view_type_id = g_type_register_static (adw_bin_get_type (), "SudokuGameView", &g_define_type_info, 0);
	SudokuGameView_private_offset = g_type_add_instance_private (sudoku_game_view_type_id, sizeof (SudokuGameViewPrivate));
	return sudoku_game_view_type_id;
}

GType
sudoku_game_view_get_type (void)
{
	static volatile gsize sudoku_game_view_type_id__once = 0;
	if (g_once_init_enter (&sudoku_game_view_type_id__once)) {
		GType sudoku_game_view_type_id;
		sudoku_game_view_type_id = sudoku_game_view_get_type_once ();
		g_once_init_leave (&sudoku_game_view_type_id__once, sudoku_game_view_type_id);
	}
	return sudoku_game_view_type_id__once;
}

gboolean
zoom_level_is_fully_zoomed_out (ZoomLevel self)
{
	gboolean result;
	switch (self) {
		case ZOOM_LEVEL_SMALL:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
zoom_level_is_fully_zoomed_in (ZoomLevel self)
{
	gboolean result;
	switch (self) {
		case ZOOM_LEVEL_LARGE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

ZoomLevel
zoom_level_zoom_in (ZoomLevel self)
{
	ZoomLevel result;
	switch (self) {
		case ZOOM_LEVEL_SMALL:
		{
			result = ZOOM_LEVEL_MEDIUM;
			return result;
		}
		case ZOOM_LEVEL_MEDIUM:
		{
			result = ZOOM_LEVEL_LARGE;
			return result;
		}
		case ZOOM_LEVEL_LARGE:
		{
			{
				g_warning ("game-view.vala:420: ZOOM already at maximum");
				result = ZOOM_LEVEL_LARGE;
				return result;
			}
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

ZoomLevel
zoom_level_zoom_out (ZoomLevel self)
{
	ZoomLevel result;
	switch (self) {
		case ZOOM_LEVEL_LARGE:
		{
			result = ZOOM_LEVEL_MEDIUM;
			return result;
		}
		case ZOOM_LEVEL_MEDIUM:
		{
			result = ZOOM_LEVEL_SMALL;
			return result;
		}
		case ZOOM_LEVEL_SMALL:
		{
			{
				g_warning ("game-view.vala:438: ZOOM already at minimum");
				result = ZOOM_LEVEL_SMALL;
				return result;
			}
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
zoom_level_get_type_once (void)
{
	static const GEnumValue values[] = {{ZOOM_LEVEL_NONE, "ZOOM_LEVEL_NONE", "none"}, {ZOOM_LEVEL_SMALL, "ZOOM_LEVEL_SMALL", "small"}, {ZOOM_LEVEL_MEDIUM, "ZOOM_LEVEL_MEDIUM", "medium"}, {ZOOM_LEVEL_LARGE, "ZOOM_LEVEL_LARGE", "large"}, {0, NULL, NULL}};
	GType zoom_level_type_id;
	zoom_level_type_id = g_enum_register_static ("ZoomLevel", values);
	return zoom_level_type_id;
}

GType
zoom_level_get_type (void)
{
	static volatile gsize zoom_level_type_id__once = 0;
	if (g_once_init_enter (&zoom_level_type_id__once)) {
		GType zoom_level_type_id;
		zoom_level_type_id = zoom_level_get_type_once ();
		g_once_init_leave (&zoom_level_type_id__once, zoom_level_type_id);
	}
	return zoom_level_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

