/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_selective_fading_model2 = R"doc(fading simulator

This block implements a basic fading model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    N : the number of sinusoids to use in simulating the channel; 8 is a good value
    fDTs : normalized maximum Doppler frequency, fD * Ts
    LOS : include Line-of-Site path? selects between Rayleigh (NLOS) and Rician (LOS) models
    K : Rician factor (ratio of the specular power to the scattered power)
    seed : a random number to seed the noise generators
    delays : a vector of values that specify the time delay of each impulse
    delays_std : a vector of values that specify the gaussian step size std of delays
    delays_maxdev : a vector of values that specify the max deviation of each delay component
    mags : a vector of values that specify the magnitude of each impulse
    ntaps : the number of filter taps)doc";


static const char* __doc_gr_channels_selective_fading_model2_selective_fading_model2_0 =
    R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_selective_fading_model2_1 =
    R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_make = R"doc(fading simulator

This block implements a basic fading model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.

Constructor Specific Documentation:

Build the channel simulator.

Args:
    N : the number of sinusoids to use in simulating the channel; 8 is a good value
    fDTs : normalized maximum Doppler frequency, fD * Ts
    LOS : include Line-of-Site path? selects between Rayleigh (NLOS) and Rician (LOS) models
    K : Rician factor (ratio of the specular power to the scattered power)
    seed : a random number to seed the noise generators
    delays : a vector of values that specify the time delay of each impulse
    delays_std : a vector of values that specify the gaussian step size std of delays
    delays_maxdev : a vector of values that specify the max deviation of each delay component
    mags : a vector of values that specify the magnitude of each impulse
    ntaps : the number of filter taps)doc";


static const char* __doc_gr_channels_selective_fading_model2_fDTs = R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_K = R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_step = R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_set_fDTs = R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_set_K = R"doc()doc";


static const char* __doc_gr_channels_selective_fading_model2_set_step = R"doc()doc";
