{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Xlib.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "pkg-config-name xlib x11"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Xlib.Config"
 , "GI.Xlib"
 , "GI.Xlib.Functions"
 , "GI.Xlib.Structs"
 , "GI.Xlib.Structs.Display"
 , "GI.Xlib.Structs.Screen"
 , "GI.Xlib.Structs.Visual"
 , "GI.Xlib.Structs.XConfigureEvent"
 , "GI.Xlib.Structs.XFontStruct"
 , "GI.Xlib.Structs.XImage"
 , "GI.Xlib.Structs.XTrapezoid"
 , "GI.Xlib.Structs.XVisualInfo"
 , "GI.Xlib.Structs.XWindowAttributes"
 , "GI.Xlib.Unions"
 , "GI.Xlib.Unions.XEvent"]
