//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/tracers/fluentd/v3/fluentd.proto

package fluentdv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on FluentdConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *FluentdConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FluentdConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in FluentdConfigMultiError, or
// nil if none found.
func (m *FluentdConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *FluentdConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetCluster()) < 1 {
		err := FluentdConfigValidationError{
			field:  "Cluster",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetTag()) < 1 {
		err := FluentdConfigValidationError{
			field:  "Tag",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := FluentdConfigValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetBufferFlushInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = FluentdConfigValidationError{
				field:  "BufferFlushInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := FluentdConfigValidationError{
					field:  "BufferFlushInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetBufferSizeBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FluentdConfigValidationError{
					field:  "BufferSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FluentdConfigValidationError{
					field:  "BufferSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBufferSizeBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FluentdConfigValidationError{
				field:  "BufferSizeBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FluentdConfigValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FluentdConfigValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FluentdConfigValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return FluentdConfigMultiError(errors)
	}

	return nil
}

// FluentdConfigMultiError is an error wrapping multiple validation errors
// returned by FluentdConfig.ValidateAll() if the designated constraints
// aren't met.
type FluentdConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FluentdConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FluentdConfigMultiError) AllErrors() []error { return m }

// FluentdConfigValidationError is the validation error returned by
// FluentdConfig.Validate if the designated constraints aren't met.
type FluentdConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FluentdConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FluentdConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FluentdConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FluentdConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FluentdConfigValidationError) ErrorName() string { return "FluentdConfigValidationError" }

// Error satisfies the builtin error interface
func (e FluentdConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFluentdConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FluentdConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FluentdConfigValidationError{}
