
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "ktwofingertap_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpoint.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KTwoFingerTap_Type = nullptr;
static PyTypeObject *Sbk_KTwoFingerTap_TypeF(void)
{
    return _Sbk_KTwoFingerTap_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KTwoFingerTapWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KTwoFingerTapWrapper::KTwoFingerTapWrapper(::QObject * parent) : KTwoFingerTap(parent)
{
}

void KTwoFingerTapWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KTwoFingerTap", funcName, gil, pyOverride, event);
}

void KTwoFingerTapWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTwoFingerTap", funcName, gil, pyOverride, signal);
}

void KTwoFingerTapWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KTwoFingerTap", funcName, gil, pyOverride, event);
}

void KTwoFingerTapWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KTwoFingerTap", funcName, gil, pyOverride, signal);
}

bool KTwoFingerTapWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KTwoFingerTap", funcName, gil, pyOverride, event);
}

bool KTwoFingerTapWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KTwoFingerTap", funcName, gil, pyOverride, watched, event);
}

void KTwoFingerTapWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KTwoFingerTap_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KTwoFingerTap", funcName, gil, pyOverride, event);
}

const QMetaObject *KTwoFingerTapWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KTwoFingerTap::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KTwoFingerTapWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KTwoFingerTap::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KTwoFingerTapWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KTwoFingerTapWrapper *>(this));
    }
    return KTwoFingerTap::qt_metacast(_clname);
}

KTwoFingerTapWrapper::~KTwoFingerTapWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KTwoFingerTap_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KTwoFingerTap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KTwoFingerTap >()))
        return -1;

    KTwoFingerTapWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KTwoFingerTap", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KTwoFingerTap::KTwoFingerTap(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KTwoFingerTap(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KTwoFingerTap(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KTwoFingerTap(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KTwoFingerTapWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KTwoFingerTapWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KTwoFingerTap >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KTwoFingerTapFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pos()const
        QPointF cppResult = const_cast<const ::KTwoFingerTap *>(cppSelf)->pos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerTapFunc_scenePos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // scenePos()const
        QPointF cppResult = const_cast<const ::KTwoFingerTap *>(cppSelf)->scenePos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerTapFunc_screenPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // screenPos()const
        QPointF cppResult = const_cast<const ::KTwoFingerTap *>(cppSelf)->screenPos();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KTwoFingerTapFunc_setPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerTap::setPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setPos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setPos(QPointF)
            cppSelf->setPos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerTapFunc_setScenePos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerTap::setScenePos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setScenePos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setScenePos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setScenePos(QPointF)
            cppSelf->setScenePos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KTwoFingerTapFunc_setScreenPos(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KTwoFingerTap::setScreenPos(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QPointF_IDX]), (pyArg)))) {
        overloadId = 0; // setScreenPos(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setScreenPos", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setScreenPos(QPointF)
            cppSelf->setScreenPos(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KTwoFingerTap_PropertyStrings[] = {
    "pos::",
    "scenePos::",
    "screenPos::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KTwoFingerTap_methods[] = {
    {"pos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_pos), METH_NOARGS, nullptr},
    {"scenePos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_scenePos), METH_NOARGS, nullptr},
    {"screenPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_screenPos), METH_NOARGS, nullptr},
    {"setPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_setPos), METH_O, nullptr},
    {"setScenePos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_setScenePos), METH_O, nullptr},
    {"setScreenPos", reinterpret_cast<PyCFunction>(Sbk_KTwoFingerTapFunc_setScreenPos), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KTwoFingerTap_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KTwoFingerTap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KTwoFingerTapWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KTwoFingerTap_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KTwoFingerTap_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KTwoFingerTap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KTwoFingerTap_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KTwoFingerTap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KTwoFingerTap_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KTwoFingerTap_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KTwoFingerTap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KTwoFingerTap_spec = {
    "1:KWidgetsAddons.KTwoFingerTap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KTwoFingerTap_slots
};

} //extern "C"

static void *Sbk_KTwoFingerTap_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KTwoFingerTap *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KTwoFingerTap_PythonToCpp_KTwoFingerTap_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KTwoFingerTap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KTwoFingerTap_PythonToCpp_KTwoFingerTap_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KTwoFingerTap_TypeF()))
        return KTwoFingerTap_PythonToCpp_KTwoFingerTap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KTwoFingerTap_PTR_CppToPython_KTwoFingerTap(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KTwoFingerTap *>(const_cast<void *>(cppIn)), Sbk_KTwoFingerTap_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KTwoFingerTap_SignatureStrings[] = {
    "KWidgetsAddons.KTwoFingerTap(self,parent:PySide6.QtCore.QObject=nullptr,*:KeywordOnly=None,pos:QPointF=None,screenPos:QPointF=None,scenePos:QPointF=None)",
    "KWidgetsAddons.KTwoFingerTap.pos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerTap.scenePos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerTap.screenPos(self)->PySide6.QtCore.QPointF",
    "KWidgetsAddons.KTwoFingerTap.setPos(self,pos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "KWidgetsAddons.KTwoFingerTap.setScenePos(self,scenePos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    "KWidgetsAddons.KTwoFingerTap.setScreenPos(self,screenPos:typing.Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint])",
    nullptr}; // Sentinel
#else
static constexpr size_t KTwoFingerTap_SignatureByteSize = 196;
static constexpr uint8_t KTwoFingerTap_SignatureBytes[196] = {
    0x78, 0xda, 0xb5, 0x92, 0x41, 0x0b, 0x82, 0x40, 0x10, 0x85, 0xef, 0xfd, 0x8a, 0x8e, 0x19, 0xdb,
    0x1e, 0x3b, 0x08, 0x06, 0x11, 0x78, 0x11, 0x52, 0xd1, 0xe8, 0x10, 0x1d, 0xcc, 0x9d, 0x64, 0x43,
    0x66, 0x97, 0xdd, 0x0d, 0xd9, 0x7f, 0x9f, 0x68, 0x92, 0x98, 0xd8, 0x41, 0xba, 0xbe, 0x61, 0xbe,
    0xf7, 0xe6, 0x31, 0xc1, 0x99, 0xb3, 0x02, 0x8c, 0xde, 0x33, 0x26, 0x50, 0xd3, 0x20, 0xad, 0x84,
    0xcf, 0xb1, 0x00, 0x95, 0x66, 0x72, 0xa5, 0xa1, 0xbc, 0x13, 0x99, 0x29, 0x40, 0xe3, 0x46, 0x36,
    0xe1, 0x0c, 0xb6, 0x34, 0x36, 0x07, 0xa1, 0x80, 0xc6, 0xe1, 0xed, 0x01, 0xb9, 0xf1, 0xf0, 0x59,
    0x96, 0xd2, 0x28, 0xb2, 0x76, 0x03, 0xb0, 0x95, 0x50, 0x2c, 0xc4, 0xd2, 0x7a, 0x47, 0x81, 0x40,
    0xa4, 0xd0, 0x6e, 0x1c, 0x09, 0x8e, 0xc6, 0x6f, 0x05, 0x9d, 0x2b, 0x00, 0x8c, 0xbe, 0x65, 0x40,
    0x18, 0xaa, 0xce, 0x22, 0x98, 0x48, 0x46, 0x6b, 0x76, 0x93, 0xce, 0xd9, 0xec, 0x86, 0xc1, 0x5a,
    0xc8, 0xf4, 0x7a, 0x67, 0x39, 0x8f, 0xf1, 0xbe, 0x66, 0x16, 0x04, 0x4c, 0x47, 0x68, 0xfa, 0x32,
    0x56, 0xd6, 0x33, 0x7a, 0x42, 0x2e, 0xf0, 0x32, 0x0e, 0x24, 0xcb, 0x51, 0xfd, 0xea, 0xfc, 0x74,
    0x4a, 0xfa, 0x57, 0x7f, 0x6a, 0xff, 0xb3, 0x67, 0xbf, 0xa5, 0xde, 0x0b, 0xcc, 0x72, 0x7d, 0x01,
    0xa5, 0x75, 0xfb, 0x6c
};
#endif

PyTypeObject *init_KTwoFingerTap(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX].type;

    Shiboken::AutoDecRef Sbk_KTwoFingerTap_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QGesture_IDX]))));

    _Sbk_KTwoFingerTap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KTwoFingerTap",
        "KTwoFingerTap*",
        &Sbk_KTwoFingerTap_spec,
        &Shiboken::callCppDestructor< KTwoFingerTap >,
        Sbk_KTwoFingerTap_Type_bases.object(),
        0);
    auto *pyType = Sbk_KTwoFingerTap_TypeF(); // references _Sbk_KTwoFingerTap_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KTwoFingerTap_SignatureStrings);
#else
    InitSignatureBytes(pyType, KTwoFingerTap_SignatureBytes, KTwoFingerTap_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KTwoFingerTap_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KTwoFingerTap_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KTwoFingerTap_PythonToCpp_KTwoFingerTap_PTR,
        is_KTwoFingerTap_PythonToCpp_KTwoFingerTap_PTR_Convertible,
        KTwoFingerTap_PTR_CppToPython_KTwoFingerTap);

    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTap");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTap*");
    Shiboken::Conversions::registerConverterName(converter, "KTwoFingerTap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KTwoFingerTap).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KTwoFingerTapWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KTwoFingerTap_TypeF(), &Sbk_KTwoFingerTap_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KTwoFingerTap::staticMetaObject, sizeof(KTwoFingerTapWrapper));

    return pyType;
}
