
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdatecombobox_wrapper.h"

// Wrappers providing overrides
#include "kdatetimeedit_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <QMap>
#include <QString>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qdatetime.h>
#include <qevent.h>
#include <qlocale.h>
#include <qmetaobject.h>
#include <qnamespace.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qpaintdevice.h>
#include <qpoint.h>
#include <qsize.h>
#include <qstyleoption.h>
#include <qvariant.h>
#include <qwidget.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDateComboBox_Type = nullptr;
static PyTypeObject *Sbk_KDateComboBox_TypeF(void)
{
    return _Sbk_KDateComboBox_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDateComboBoxWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDateComboBoxWrapper::KDateComboBoxWrapper(::QWidget * parent) : KDateComboBox(parent)
{
}

void KDateComboBoxWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    KXYSelectorWrapper::sbk_o_actionEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::assignDate(const ::QDate & date)
{
    static const char *funcName = "assignDate";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::assignDate(date);
    }
    KDateTimeEditWrapper::sbk_o_assignDate("KDateComboBox", funcName, gil, pyOverride, date);
}

void KDateComboBoxWrapper::changeEvent(::QEvent * e)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::changeEvent(e);
    }
    KXYSelectorWrapper::sbk_o_changeEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_closeEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDateComboBox", funcName, gil, pyOverride, signal);
}

void KDateComboBoxWrapper::contextMenuEvent(::QContextMenuEvent * e)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::contextMenuEvent(e);
    }
    KXYSelectorWrapper::sbk_o_contextMenuEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

int KDateComboBoxWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return KXYSelectorWrapper::sbk_o_devType("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDateComboBox", funcName, gil, pyOverride, signal);
}

void KDateComboBoxWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragEnterEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragLeaveEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dragMoveEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    KXYSelectorWrapper::sbk_o_dropEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    KXYSelectorWrapper::sbk_o_enterEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

bool KDateComboBoxWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KDateComboBox", funcName, gil, pyOverride, event);
}

bool KDateComboBoxWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDateComboBox", funcName, gil, pyOverride, object, event);
}

void KDateComboBoxWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::focusInEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusInEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

bool KDateComboBoxWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return KXYSelectorWrapper::sbk_o_focusNextPrevChild("KDateComboBox", funcName, gil, pyOverride, next);
}

void KDateComboBoxWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::focusOutEvent(event);
    }
    KXYSelectorWrapper::sbk_o_focusOutEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

bool KDateComboBoxWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return KXYSelectorWrapper::sbk_o_hasHeightForWidth("KDateComboBox", funcName, gil, pyOverride);
}

int KDateComboBoxWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_heightForWidth("KDateComboBox", funcName, gil, pyOverride, arg__1);
}

void KDateComboBoxWrapper::hideEvent(::QHideEvent * e)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::hideEvent(e);
    }
    KXYSelectorWrapper::sbk_o_hideEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::hidePopup()
{
    static const char *funcName = "hidePopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::hidePopup();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    KXYSelectorWrapper::sbk_o_drawContents("KDateComboBox", funcName, gil, pyOverride, painter);
}

void KDateComboBoxWrapper::initStyleOption(::QStyleOptionComboBox * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::initStyleOption(option);
    }
    KTimeComboBoxWrapper::sbk_o_initStyleOption("KDateComboBox", funcName, gil, pyOverride, option);
}

void KDateComboBoxWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodEvent(arg__1);
    }
    KXYSelectorWrapper::sbk_o_inputMethodEvent("KDateComboBox", funcName, gil, pyOverride, arg__1);
}

::QVariant KDateComboBoxWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::inputMethodQuery(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_inputMethodQuery("KDateComboBox", funcName, gil, pyOverride, arg__1);
}

void KDateComboBoxWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::keyPressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_keyPressEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::keyReleaseEvent(::QKeyEvent * e)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::keyReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_keyReleaseEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_leaveEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

int KDateComboBoxWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_metric("KDateComboBox", funcName, gil, pyOverride, arg__1);
}

::QSize KDateComboBoxWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::minimumSizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseDoubleClickEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mouseMoveEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::mousePressEvent(event);
    }
    KXYSelectorWrapper::sbk_o_mousePressEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::mouseReleaseEvent(::QMouseEvent * e)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::mouseReleaseEvent(e);
    }
    KXYSelectorWrapper::sbk_o_mouseReleaseEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    KXYSelectorWrapper::sbk_o_moveEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

bool KDateComboBoxWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return KXYSelectorWrapper::sbk_o_nativeEvent("KDateComboBox", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * KDateComboBoxWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return KXYSelectorWrapper::sbk_o_paintEngine("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::paintEvent(::QPaintEvent * e)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::paintEvent(e);
    }
    KXYSelectorWrapper::sbk_o_paintEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

::QPaintDevice * KDateComboBoxWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return KXYSelectorWrapper::sbk_o_redirected("KDateComboBox", funcName, gil, pyOverride, offset);
}

void KDateComboBoxWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::resizeEvent(event);
    }
    KXYSelectorWrapper::sbk_o_resizeEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::setModel(::QAbstractItemModel * model)
{
    static const char *funcName = "setModel";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::setModel(model);
    }
    KTimeComboBoxWrapper::sbk_o_setModel("KDateComboBox", funcName, gil, pyOverride, model);
}

void KDateComboBoxWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    KXYSelectorWrapper::sbk_o_setVisible("KDateComboBox", funcName, gil, pyOverride, visible);
}

::QPainter * KDateComboBoxWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return KXYSelectorWrapper::sbk_o_sharedPainter("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::showEvent(::QShowEvent * e)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::showEvent(e);
    }
    KXYSelectorWrapper::sbk_o_showEvent("KDateComboBox", funcName, gil, pyOverride, e);
}

void KDateComboBoxWrapper::showPopup()
{
    static const char *funcName = "showPopup";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::showPopup();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KDateComboBox", funcName, gil, pyOverride);
}

::QSize KDateComboBoxWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[48], nameCache));
    if (pyOverride.isNull()) {
        return this->::QComboBox::sizeHint();
    }
    return KXYSelectorWrapper::sbk_o_minimumSizeHint("KDateComboBox", funcName, gil, pyOverride);
}

void KDateComboBoxWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[49], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    KXYSelectorWrapper::sbk_o_tabletEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[50], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

void KDateComboBoxWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDateComboBox_TypeF(), gil, funcName, m_PyMethodCache[51], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDateComboBox::wheelEvent(event);
    }
    KXYSelectorWrapper::sbk_o_wheelEvent("KDateComboBox", funcName, gil, pyOverride, event);
}

const QMetaObject *KDateComboBoxWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDateComboBox::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDateComboBoxWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDateComboBox::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDateComboBoxWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDateComboBoxWrapper *>(this));
    }
    return KDateComboBox::qt_metacast(_clname);
}

KDateComboBoxWrapper::~KDateComboBoxWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDateComboBox_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDateComboBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDateComboBox >()))
        return -1;

    KDateComboBoxWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KDateComboBox", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDateComboBox::KDateComboBox(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KDateComboBox(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDateComboBox(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDateComboBox(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDateComboBoxWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDateComboBoxWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDateComboBox >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDateComboBoxFunc_assignDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateComboBox::assignDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // assignDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assignDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // assignDate(QDate)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::assignDate(*cppArg0)
                : cppSelf->assignDate(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_date(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // date()const
        QDate cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->date();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_dateMap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dateMap()const
        QMap<QDate,QString> cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->dateMap();
        pyResult = Shiboken::Conversions::copyToPython(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_displayFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // displayFormat()const
        QLocale::FormatType cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->displayFormat();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusInEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFocusEvent_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "focusOutEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_hidePopup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hidePopup()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KDateComboBox::hidePopup()
            : cppSelf->hidePopup();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_maximumDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // maximumDate()const
        QDate cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->maximumDate();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_minimumDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // minimumDate()const
        QDate cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->minimumDate();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mousePressEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // options()const
        QFlags<KDateComboBox::Option> cppResult = const_cast<const ::KDateComboBox *>(cppSelf)->options();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateComboBox_Option_IDX])))->flagsConverter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDateComboBoxFunc_resetDateRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetDateRange()
        cppSelf->resetDateRange();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_resetMaximumDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMaximumDate()
        cppSelf->resetMaximumDate();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_resetMinimumDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetMinimumDate()
        cppSelf->resetMinimumDate();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QResizeEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resizeEvent(QResizeEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::resizeEvent(cppArg0)
                : cppSelf->resizeEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setDate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateComboBox::setDate(QDate)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArg)))) {
        overloadId = 0; // setDate(QDate)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setDate(QDate)
            cppSelf->setDate(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setDateMap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateComboBox::setDateMap(QMap<QDate,QString>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkKWidgetsAddonsTypeConverters[SBK_KWidgetsAddons_QMap_QDate_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDateMap(QMap<QDate,QString>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDateMap", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        ::QMap<QDate,QString> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateMap(QMap<QDate,QString>)
            cppSelf->setDateMap(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setDateRange(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:setDateRange", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateComboBox::setDateRange(QDate,QDate,const QString&=,const QString&=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setDateRange(QDate,QDate,QString,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // setDateRange(QDate,QDate,QString,QString)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                overloadId = 0; // setDateRange(QDate,QDate,QString,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"minWarnMsg", 2}, {"maxWarnMsg", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setDateRange", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QDate cppArg1_local;
        ::QDate *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDateRange(QDate,QDate,QString,QString)
            cppSelf->setDateRange(*cppArg0, *cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setDisplayFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateComboBox::setDisplayFormat(QLocale::FormatType)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QLocale_FormatType_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setDisplayFormat(QLocale::FormatType)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDisplayFormat", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        ::QLocale::FormatType cppArg0{QLocale::LongFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDisplayFormat(QLocale::FormatType)
            cppSelf->setDisplayFormat(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setMaximumDate(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMaximumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMaximumDate", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateComboBox::setMaximumDate(QDate,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMaximumDate(QDate,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMaximumDate(QDate,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMaximumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMaximumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMaximumDate(QDate,QString)
            cppSelf->setMaximumDate(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setMinimumDate(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setMinimumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setMinimumDate", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KDateComboBox::setMinimumDate(QDate,const QString&=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDate_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setMinimumDate(QDate,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // setMinimumDate(QDate,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setMinimumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"minWarnMsg", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setMinimumDate", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QDate cppArg0_local;
        ::QDate *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setMinimumDate(QDate,QString)
            cppSelf->setMinimumDate(*cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDateComboBox::setOptions(QFlags<KDateComboBox::Option>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateComboBox_Option_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<KDateComboBox::Option>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOptions", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        ::QFlags<KDateComboBox::Option> cppArg0 = QFlags<KDateComboBox::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOptions(QFlags<KDateComboBox::Option>)
            cppSelf->setOptions(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_showPopup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showPopup()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KDateComboBox::showPopup()
            : cppSelf->showPopup();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDateComboBoxFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "wheelEvent", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDateComboBox::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDateComboBox_PropertyStrings[] = {
    "date::",
    "maximumDate::",
    "minimumDate::",
    "options::",
    nullptr // Sentinel
};

static const char *Sbk_KDateComboBox_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDateComboBox_methods[] = {
    {"assignDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_assignDate), METH_O, nullptr},
    {"date", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_date), METH_NOARGS, nullptr},
    {"dateMap", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_dateMap), METH_NOARGS, nullptr},
    {"displayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_displayFormat), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_eventFilter), METH_VARARGS, nullptr},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_focusInEvent), METH_O, nullptr},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_focusOutEvent), METH_O, nullptr},
    {"hidePopup", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_hidePopup), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_isNull), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_isValid), METH_NOARGS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_keyPressEvent), METH_O, nullptr},
    {"maximumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_maximumDate), METH_NOARGS, nullptr},
    {"minimumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_minimumDate), METH_NOARGS, nullptr},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_mousePressEvent), METH_O, nullptr},
    {"options", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_options), METH_NOARGS, nullptr},
    {"resetDateRange", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_resetDateRange), METH_NOARGS, nullptr},
    {"resetMaximumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_resetMaximumDate), METH_NOARGS, nullptr},
    {"resetMinimumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_resetMinimumDate), METH_NOARGS, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_resizeEvent), METH_O, nullptr},
    {"setDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setDate), METH_O, nullptr},
    {"setDateMap", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setDateMap), METH_O, nullptr},
    {"setDateRange", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setDateRange), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setDisplayFormat", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setDisplayFormat), METH_O, nullptr},
    {"setMaximumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setMaximumDate), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setMinimumDate", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setMinimumDate), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_setOptions), METH_O, nullptr},
    {"showPopup", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_showPopup), METH_NOARGS, nullptr},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_KDateComboBoxFunc_wheelEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDateComboBox_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDateComboBox *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDateComboBoxWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDateComboBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDateComboBox_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KDateComboBoxSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KDateComboBox *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))
        return static_cast< ::QComboBox *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDateComboBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDateComboBox_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDateComboBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDateComboBox_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDateComboBox_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDateComboBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDateComboBox_spec = {
    "1:KWidgetsAddons.KDateComboBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDateComboBox_slots
};

} //extern "C"

static void *Sbk_KDateComboBox_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::KDateComboBox *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDateComboBox *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::KDateComboBox *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KDateComboBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KDateComboBox::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KDateComboBox::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KDateComboBox_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_Option_IDX])))
        return Enum_PythonToCpp_KDateComboBox_Option;
    return {};
}

static PyObject *KDateComboBox_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KDateComboBox::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KDateComboBox::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_KDateComboBox_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::KDateComboBox::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::KDateComboBox::Option> *>(cppOut) = value;

}

static PyObject *KDateComboBox_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::KDateComboBox::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_Option_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDateComboBox_PythonToCpp_KDateComboBox_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDateComboBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDateComboBox_PythonToCpp_KDateComboBox_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDateComboBox_TypeF()))
        return KDateComboBox_PythonToCpp_KDateComboBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDateComboBox_PTR_CppToPython_KDateComboBox(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDateComboBox *>(const_cast<void *>(cppIn)), Sbk_KDateComboBox_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDateComboBox_SignatureStrings[] = {
    "KWidgetsAddons.KDateComboBox(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,date:QDate=None,minimumDate:QDate=None,maximumDate:QDate=None,options:KWidgetsAddons.KDateComboBox.Option=None)",
    "KWidgetsAddons.KDateComboBox.assignDate(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDateComboBox.date(self)->PySide6.QtCore.QDate",
    "KWidgetsAddons.KDateComboBox.dateMap(self)->QMap[PySide6.QtCore.QDate, QString]",
    "KWidgetsAddons.KDateComboBox.displayFormat(self)->PySide6.QtCore.QLocale.FormatType",
    "KWidgetsAddons.KDateComboBox.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KDateComboBox.focusInEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KDateComboBox.focusOutEvent(self,event:PySide6.QtGui.QFocusEvent)",
    "KWidgetsAddons.KDateComboBox.hidePopup(self)",
    "KWidgetsAddons.KDateComboBox.isNull(self)->bool",
    "KWidgetsAddons.KDateComboBox.isValid(self)->bool",
    "KWidgetsAddons.KDateComboBox.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "KWidgetsAddons.KDateComboBox.maximumDate(self)->PySide6.QtCore.QDate",
    "KWidgetsAddons.KDateComboBox.minimumDate(self)->PySide6.QtCore.QDate",
    "KWidgetsAddons.KDateComboBox.mousePressEvent(self,event:PySide6.QtGui.QMouseEvent)",
    "KWidgetsAddons.KDateComboBox.options(self)->KWidgetsAddons.KDateComboBox.Option",
    "KWidgetsAddons.KDateComboBox.resetDateRange(self)",
    "KWidgetsAddons.KDateComboBox.resetMaximumDate(self)",
    "KWidgetsAddons.KDateComboBox.resetMinimumDate(self)",
    "KWidgetsAddons.KDateComboBox.resizeEvent(self,event:PySide6.QtGui.QResizeEvent)",
    "KWidgetsAddons.KDateComboBox.setDate(self,date:PySide6.QtCore.QDate)",
    "KWidgetsAddons.KDateComboBox.setDateMap(self,dateMap:QMap[PySide6.QtCore.QDate, QString])",
    "KWidgetsAddons.KDateComboBox.setDateRange(self,minDate:PySide6.QtCore.QDate,maxDate:PySide6.QtCore.QDate,minWarnMsg:QString=QString(),maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateComboBox.setDisplayFormat(self,format:PySide6.QtCore.QLocale.FormatType)",
    "KWidgetsAddons.KDateComboBox.setMaximumDate(self,maxDate:PySide6.QtCore.QDate,maxWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateComboBox.setMinimumDate(self,minDate:PySide6.QtCore.QDate,minWarnMsg:QString=QString())",
    "KWidgetsAddons.KDateComboBox.setOptions(self,options:KWidgetsAddons.KDateComboBox.Option)",
    "KWidgetsAddons.KDateComboBox.showPopup(self)",
    "KWidgetsAddons.KDateComboBox.wheelEvent(self,event:PySide6.QtGui.QWheelEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDateComboBox_SignatureByteSize = 483;
static constexpr uint8_t KDateComboBox_SignatureBytes[483] = {
    0x78, 0xda, 0xad, 0x56, 0xc1, 0x4e, 0xe3, 0x30, 0x10, 0xbd, 0xf3, 0x15, 0x7b, 0xa4, 0x28, 0xe4,
    0xb8, 0x87, 0x48, 0x5d, 0x09, 0x28, 0x5d, 0xad, 0x4a, 0x49, 0x03, 0x88, 0x1e, 0x56, 0x1c, 0xdc,
    0x66, 0x9a, 0x7a, 0xd7, 0xf1, 0x44, 0xb6, 0x43, 0x09, 0x5f, 0x8f, 0xed, 0x24, 0xdb, 0x2a, 0x6d,
    0x63, 0x43, 0xf7, 0x14, 0x67, 0x3c, 0xef, 0xcd, 0x9b, 0xb1, 0x67, 0x92, 0xc9, 0x9c, 0xa6, 0x19,
    0x28, 0x79, 0x95, 0xa6, 0xc8, 0x65, 0x38, 0x19, 0x11, 0x05, 0x37, 0x98, 0x2f, 0xf0, 0x1a, 0xdf,
    0xce, 0x25, 0xb0, 0x55, 0x50, 0x10, 0x01, 0x5c, 0x45, 0xb3, 0xea, 0x91, 0xa6, 0xf0, 0x3d, 0x4c,
    0x54, 0x83, 0x08, 0x93, 0x7a, 0x31, 0xe4, 0x25, 0x63, 0x85, 0x12, 0xc1, 0x45, 0x34, 0x81, 0x6a,
    0x83, 0x22, 0x8d, 0x39, 0xab, 0x86, 0xf7, 0xc8, 0x21, 0x48, 0x35, 0x5b, 0x94, 0x18, 0xce, 0xfa,
    0x3d, 0xa7, 0x9c, 0xe6, 0x65, 0x3e, 0xea, 0x9a, 0xc9, 0xdb, 0x21, 0x33, 0x16, 0x8a, 0x6a, 0x51,
    0xd1, 0xa4, 0x47, 0x63, 0x18, 0x5b, 0x27, 0x0b, 0x18, 0x9c, 0xf5, 0x7a, 0x12, 0x29, 0x69, 0xc6,
    0x8d, 0xa9, 0x4e, 0xcc, 0x8a, 0xdb, 0xa6, 0x75, 0x83, 0x02, 0x42, 0x1b, 0xdd, 0xc1, 0x93, 0xb6,
    0x0c, 0x83, 0xcb, 0x1f, 0x87, 0xe0, 0x6e, 0xf4, 0x94, 0x14, 0x2d, 0x41, 0xa2, 0xd7, 0xbf, 0x0f,
    0xb1, 0x04, 0xdf, 0x92, 0x47, 0x25, 0x28, 0xcf, 0x5e, 0x1c, 0x7c, 0x54, 0x16, 0x8c, 0x54, 0x63,
    0x14, 0x39, 0x51, 0xc7, 0x64, 0xdd, 0xe1, 0x92, 0x30, 0x08, 0x6b, 0xa7, 0xa7, 0xaa, 0x70, 0x68,
    0x84, 0x57, 0x7d, 0xe2, 0x63, 0xca, 0x14, 0x88, 0xba, 0x54, 0xb8, 0xf8, 0x03, 0x4b, 0xb5, 0x57,
    0xac, 0xd8, 0x9a, 0x03, 0xeb, 0xbe, 0xb7, 0x79, 0x6b, 0xac, 0x5a, 0xcb, 0x02, 0x91, 0xf5, 0x87,
    0x5b, 0xe1, 0xb2, 0x94, 0xbf, 0xb8, 0x05, 0xd4, 0xf1, 0xba, 0x8c, 0x3f, 0x4b, 0x1a, 0x26, 0x63,
    0xe3, 0x56, 0xb3, 0x7a, 0xf0, 0xc5, 0xa5, 0xfa, 0x6f, 0x84, 0x6b, 0x8d, 0x9a, 0x61, 0x51, 0x36,
    0xa7, 0xd6, 0xef, 0x4c, 0xe5, 0xbd, 0x6e, 0x88, 0xf6, 0x24, 0xdc, 0xd9, 0x53, 0xf9, 0x4c, 0x18,
    0x4d, 0xfd, 0x01, 0x7f, 0xa1, 0x9a, 0x09, 0x90, 0xd2, 0x95, 0x9e, 0xee, 0x46, 0x9f, 0xe4, 0x76,
    0x9a, 0xef, 0xeb, 0xb7, 0x7a, 0xa7, 0xb1, 0x4f, 0x20, 0xc1, 0x52, 0x82, 0x57, 0x6a, 0x53, 0xe3,
    0xe9, 0x93, 0x5c, 0x33, 0x42, 0x5a, 0x4d, 0x1e, 0x93, 0xa4, 0x9f, 0x4f, 0x8b, 0x03, 0x65, 0x2c,
    0x0f, 0x84, 0x67, 0xe0, 0x73, 0x1d, 0x2c, 0x62, 0xda, 0xad, 0xb1, 0x0f, 0xa6, 0x5b, 0x52, 0x27,
    0x86, 0xbe, 0x83, 0xab, 0x70, 0x0f, 0x5b, 0x2f, 0x07, 0x5f, 0x93, 0xe7, 0x69, 0xa3, 0xb2, 0x21,
    0x69, 0xe7, 0x5d, 0xd0, 0x0c, 0xbf, 0xc8, 0x63, 0xea, 0xf9, 0x31, 0x6f, 0x8f, 0xc1, 0x7c, 0x5b,
    0x46, 0xc7, 0x64, 0x9a, 0x2f, 0x4c, 0xcf, 0x26, 0xe5, 0x73, 0x22, 0xf8, 0x54, 0x66, 0x51, 0x13,
    0x7d, 0xd8, 0x3c, 0xcf, 0x07, 0x06, 0x79, 0x74, 0xd3, 0x43, 0xe3, 0xde, 0x74, 0x0e, 0x56, 0x76,
    0x1d, 0x39, 0x47, 0xb4, 0x9b, 0xbc, 0x7b, 0xab, 0x1c, 0x59, 0x9e, 0x94, 0x48, 0xf7, 0x36, 0x3a,
    0xca, 0xdd, 0x53, 0x51, 0x77, 0xac, 0x78, 0xa7, 0x69, 0x3f, 0xf3, 0x13, 0xe0, 0x62, 0x5e, 0xe3,
    0xc6, 0x7b, 0x8a, 0x6f, 0xd6, 0x00, 0xcc, 0xd5, 0x4d, 0xf3, 0x7f, 0x4e, 0x83, 0xb3, 0x0f, 0x87,
    0xc6, 0x5f, 0x74
};
#endif

PyTypeObject *init_KDateComboBox(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX].type;

    Shiboken::AutoDecRef Sbk_KDateComboBox_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QComboBox_IDX]))));

    _Sbk_KDateComboBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDateComboBox",
        "KDateComboBox*",
        &Sbk_KDateComboBox_spec,
        &Shiboken::callCppDestructor< KDateComboBox >,
        Sbk_KDateComboBox_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = Sbk_KDateComboBox_TypeF(); // references _Sbk_KDateComboBox_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDateComboBox_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDateComboBox_SignatureBytes, KDateComboBox_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDateComboBox_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDateComboBox_PythonToCpp_KDateComboBox_PTR,
        is_KDateComboBox_PythonToCpp_KDateComboBox_PTR_Convertible,
        KDateComboBox_PTR_CppToPython_KDateComboBox);

    Shiboken::Conversions::registerConverterName(converter, "KDateComboBox");
    Shiboken::Conversions::registerConverterName(converter, "KDateComboBox*");
    Shiboken::Conversions::registerConverterName(converter, "KDateComboBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDateComboBox).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDateComboBoxWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KDateComboBox_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KDateComboBox_TypeF(), &Sbk_KDateComboBoxSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDateComboBox_TypeF(), &Sbk_KDateComboBox_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KDateComboBox_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "EditDate",
        "SelectDate",
        "DatePicker",
        "DateKeywords",
        "WarnOnInvalid",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(KDateComboBox::Option::EditDate),     //  0x01  1
        uint8_t(KDateComboBox::Option::SelectDate),   //  0x02  2
        uint8_t(KDateComboBox::Option::DatePicker),   //  0x04  4
        uint8_t(KDateComboBox::Option::DateKeywords), //  0x08  8
        uint8_t(KDateComboBox::Option::WarnOnInvalid) //  0x10  16
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KDateComboBox_TypeF(),
        "1:KWidgetsAddons.KDateComboBox.Option",
        Option_Initializer, Option_InitializerValues);
    SbkKWidgetsAddonsTypeStructs[SBK_KDateComboBox_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkKWidgetsAddonsTypeStructs[SBK_QFlags_KDateComboBox_Option_IDX].type =
        EType;
    // Register converter for enum 'KDateComboBox::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KDateComboBox_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KDateComboBox_Option,
            is_Enum_PythonToCpp_KDateComboBox_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KDateComboBox::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            KDateComboBox_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_KDateComboBox_Option,
            is_Enum_PythonToCpp_KDateComboBox_Option_Convertible);
        // Register converter for flag 'QFlags<KDateComboBox::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<KDateComboBox::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "KDateComboBox::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    PySide::Signal::registerSignals(pyType, &::KDateComboBox::staticMetaObject);
    qRegisterMetaType< ::KDateComboBox::Option >("KDateComboBox::Option");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDateComboBox::staticMetaObject, sizeof(KDateComboBoxWrapper));

    return pyType;
}
