// Package v3 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/egoscale/v3/generator version v0.0.1 DO NOT EDIT.
package v3

import (
	"net"
	"time"
)

type AccessKeyType string

const (
	AccessKeyTypeRestricted   AccessKeyType = "restricted"
	AccessKeyTypeUnrestricted AccessKeyType = "unrestricted"
)

type AccessKeyVersion string

const (
	AccessKeyVersionV2 AccessKeyVersion = "v2"
	AccessKeyVersionV1 AccessKeyVersion = "v1"
)

// IAM Access Key
type AccessKey struct {
	// IAM Access Key
	Key string `json:"key,omitempty"`
	// IAM Access Key name
	Name string `json:"name,omitempty"`
	// IAM Access Key operations
	Operations []string `json:"operations,omitempty"`
	// IAM Access Key Resources
	Resources []AccessKeyResource `json:"resources,omitempty"`
	// IAM Access Key Secret
	Secret string `json:"secret,omitempty"`
	// IAM Access Key tags
	Tags []string `json:"tags,omitempty"`
	// IAM Access Key type
	Type AccessKeyType `json:"type,omitempty"`
	// IAM Access Key version
	Version AccessKeyVersion `json:"version,omitempty"`
}

// Access key operation
type AccessKeyOperation struct {
	// Name of the operation
	Operation string `json:"operation,omitempty"`
	// Tags associated with the operation
	Tags []string `json:"tags,omitempty"`
}

type AccessKeyResourceDomain string

const (
	AccessKeyResourceDomainPartner AccessKeyResourceDomain = "partner"
	AccessKeyResourceDomainSOS     AccessKeyResourceDomain = "sos"
)

type AccessKeyResourceResourceType string

const (
	AccessKeyResourceResourceTypeProduct AccessKeyResourceResourceType = "product"
	AccessKeyResourceResourceTypeBucket  AccessKeyResourceResourceType = "bucket"
)

// Access key resource
type AccessKeyResource struct {
	// Resource domain
	Domain AccessKeyResourceDomain `json:"domain,omitempty"`
	// Resource name
	ResourceName string `json:"resource-name,omitempty"`
	// Resource type
	ResourceType AccessKeyResourceResourceType `json:"resource-type,omitempty"`
}

// Anti-affinity Group
type AntiAffinityGroup struct {
	// Anti-affinity Group description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Anti-affinity Group ID
	ID UUID `json:"id,omitempty"`
	// Anti-affinity Group instances
	Instances []Instance `json:"instances,omitempty"`
	// Anti-affinity Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type BlockStorageSnapshotState string

const (
	BlockStorageSnapshotStatePartiallyDestroyed BlockStorageSnapshotState = "partially-destroyed"
	BlockStorageSnapshotStateDestroying         BlockStorageSnapshotState = "destroying"
	BlockStorageSnapshotStateCreating           BlockStorageSnapshotState = "creating"
	BlockStorageSnapshotStateCreated            BlockStorageSnapshotState = "created"
	BlockStorageSnapshotStatePromoting          BlockStorageSnapshotState = "promoting"
	BlockStorageSnapshotStateError              BlockStorageSnapshotState = "error"
	BlockStorageSnapshotStateDestroyed          BlockStorageSnapshotState = "destroyed"
	BlockStorageSnapshotStateAllocated          BlockStorageSnapshotState = "allocated"
)

// Block storage snapshot
type BlockStorageSnapshot struct {
	// Target block storage volume
	BlockStorageVolume *BlockStorageVolumeTarget `json:"block-storage-volume,omitempty"`
	// Snapshot creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Snapshot ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Snapshot name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Snapshot size
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=1"`
	// Snapshot state
	State BlockStorageSnapshotState `json:"state,omitempty"`
	// Original Volume size
	VolumeSize int64 `json:"volume-size,omitempty" validate:"omitempty,gte=0"`
}

// Target block storage snapshot
type BlockStorageSnapshotTarget struct {
	// Block storage snapshot ID
	ID UUID `json:"id,omitempty"`
}

type BlockStorageVolumeState string

const (
	BlockStorageVolumeStateSnapshotting BlockStorageVolumeState = "snapshotting"
	BlockStorageVolumeStateDeleted      BlockStorageVolumeState = "deleted"
	BlockStorageVolumeStateCreating     BlockStorageVolumeState = "creating"
	BlockStorageVolumeStateDetached     BlockStorageVolumeState = "detached"
	BlockStorageVolumeStateDeleting     BlockStorageVolumeState = "deleting"
	BlockStorageVolumeStateAttaching    BlockStorageVolumeState = "attaching"
	BlockStorageVolumeStateError        BlockStorageVolumeState = "error"
	BlockStorageVolumeStateAttached     BlockStorageVolumeState = "attached"
	BlockStorageVolumeStateDetaching    BlockStorageVolumeState = "detaching"
)

// Block storage volume
type BlockStorageVolume struct {
	// Volume snapshots, if any
	BlockStorageSnapshots []BlockStorageSnapshotTarget `json:"block-storage-snapshots,omitempty"`
	// Volume block size
	Blocksize int64 `json:"blocksize,omitempty" validate:"omitempty,gte=0"`
	// Volume creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Volume ID
	ID UUID `json:"id,omitempty"`
	// Target Instance
	Instance *InstanceTarget `json:"instance,omitempty"`
	Labels   Labels          `json:"labels,omitempty"`
	// Volume name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Volume size
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=1"`
	// Volume state
	State BlockStorageVolumeState `json:"state,omitempty"`
}

// Target block storage volume
type BlockStorageVolumeTarget struct {
	// Block storage volume ID
	ID UUID `json:"id,omitempty"`
}

// DBaaS plan backup config
type DBAASBackupConfig struct {
	// Interval of taking a frequent backup in service types supporting different backup schedules
	FrequentIntervalMinutes int64 `json:"frequent-interval-minutes,omitempty" validate:"omitempty,gte=0"`
	// Maximum age of the oldest frequent backup in service types supporting different backup schedules
	FrequentOldestAgeMinutes int64 `json:"frequent-oldest-age-minutes,omitempty" validate:"omitempty,gte=0"`
	// Interval of taking a frequent backup in service types supporting different backup schedules
	InfrequentIntervalMinutes int64 `json:"infrequent-interval-minutes,omitempty" validate:"omitempty,gte=0"`
	// Maximum age of the oldest infrequent backup in service types supporting different backup schedules
	InfrequentOldestAgeMinutes int64 `json:"infrequent-oldest-age-minutes,omitempty" validate:"omitempty,gte=0"`
	// The interval, in hours, at which backups are generated.
	// For some services, like PostgreSQL, this is the interval
	// at which full snapshots are taken and continuous incremental
	// backup stream is maintained in addition to that.
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gt=0"`
	// Maximum number of backups to keep. Zero when no backups are created.
	MaxCount int64 `json:"max-count,omitempty" validate:"omitempty,gte=0"`
	// Mechanism how backups can be restored. 'regular'
	// means a backup is restored as is so that the system
	// is restored to the state it was when the backup was generated.
	// 'pitr' means point-in-time-recovery, which allows restoring the system to any state since the first available full snapshot.
	RecoveryMode string `json:"recovery-mode,omitempty"`
}

type DBAASDatabaseName string

type DBAASDatadogTag struct {
	// Optional tag explanation
	Comment string `json:"comment,omitempty" validate:"omitempty,lte=1024"`
	// Tag value
	Tag string `json:"tag" validate:"required,gte=1,lte=200"`
}

type DBAASEndpointDatadogCommon struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable kafka consumer group metrics. Applies only when attached to kafka services.
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send. Applies only when attached to kafka services.
	MaxPartitionContexts int64 `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
}

type DBAASEndpointDatadogInputCreateSettings struct {
	// Datadog API key
	DatadogAPIKey string `json:"datadog-api-key" validate:"required,gte=1,lte=256"`
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable kafka consumer group metrics. Applies only when attached to kafka services.
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send. Applies only when attached to kafka services.
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site" validate:"required"`
}

type DBAASEndpointDatadogInputCreate struct {
	Settings *DBAASEndpointDatadogInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointDatadogInputUpdateSettings struct {
	// Datadog API key
	DatadogAPIKey string `json:"datadog-api-key" validate:"required,gte=1,lte=256"`
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable kafka consumer group metrics. Applies only when attached to kafka services.
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send. Applies only when attached to kafka services.
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASEndpointDatadogInputUpdate struct {
	Settings *DBAASEndpointDatadogInputUpdateSettings `json:"settings,omitempty"`
}

// External integration DataDog configuration
type DBAASEndpointDatadogSettingsSettings struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable kafka consumer group metrics. Applies only when attached to kafka services.
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send. Applies only when attached to kafka services.
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASEndpointDatadogSettings struct {
	// External integration DataDog configuration
	Settings *DBAASEndpointDatadogSettingsSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearch struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputCreate struct {
	Settings *DBAASEndpointElasticsearchInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearchInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchInputUpdate struct {
	Settings *DBAASEndpointElasticsearchInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointElasticsearchOptionalFields struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// Elasticsearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// Elasticsearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// Elasticsearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointElasticsearchOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                                    `json:"name,omitempty"`
	Settings *DBAASEndpointElasticsearchOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                 `json:"type,omitempty"`
}

type DBAASEndpointElasticsearchSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
}

// External integration Prometheus configuration
type DBAASEndpointExternalPrometheusOutputSettings struct {
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointExternalPrometheusOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string `json:"name,omitempty"`
	// External integration Prometheus configuration
	Settings *DBAASEndpointExternalPrometheusOutputSettings `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                      `json:"type,omitempty"`
}

type DBAASEndpointOpensearch struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix" validate:"required,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url" validate:"required,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputCreate struct {
	Settings *DBAASEndpointOpensearchInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointOpensearchInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchInputUpdate struct {
	Settings *DBAASEndpointOpensearchInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointOpensearchOptionalFields struct {
	// Maximum number of days of logs to keep
	IndexDaysMax int64 `json:"index-days-max,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// OpenSearch index prefix
	IndexPrefix string `json:"index-prefix,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// OpenSearch request timeout limit
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=10,lte=120"`
	// OpenSearch connection URL
	URL string `json:"url,omitempty" validate:"omitempty,gte=12,lte=2048"`
}

type DBAASEndpointOpensearchOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                                 `json:"name,omitempty"`
	Settings *DBAASEndpointOpensearchOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes              `json:"type,omitempty"`
}

type DBAASEndpointOpensearchSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
}

type DBAASEndpointPrometheus struct {
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointPrometheusPayloadSettings struct {
	// Prometheus basic authentication password
	BasicAuthPassword string `json:"basic-auth-password,omitempty" validate:"omitempty,gte=8,lte=64"`
	// Prometheus basic authentication username
	BasicAuthUsername string `json:"basic-auth-username,omitempty" validate:"omitempty,gte=5,lte=32"`
}

type DBAASEndpointPrometheusPayload struct {
	Settings *DBAASEndpointPrometheusPayloadSettings `json:"settings,omitempty"`
}

type DBAASEndpointPrometheusSecrets struct {
	// Prometheus basic authentication password
	BasicAuthPassword string `json:"basic-auth-password,omitempty" validate:"omitempty,gte=8,lte=64"`
}

type DBAASEndpointRsyslog struct {
	Format EnumRsyslogFormat `json:"format" validate:"required"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server" validate:"required,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls" validate:"required"`
}

type DBAASEndpointRsyslogInputCreateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert   string            `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	Format EnumRsyslogFormat `json:"format" validate:"required"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server" validate:"required,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls" validate:"required"`
}

type DBAASEndpointRsyslogInputCreate struct {
	Settings *DBAASEndpointRsyslogInputCreateSettings `json:"settings,omitempty"`
}

type DBAASEndpointRsyslogInputUpdateSettings struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert   string            `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	Format EnumRsyslogFormat `json:"format,omitempty"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server,omitempty" validate:"omitempty,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls,omitempty"`
}

type DBAASEndpointRsyslogInputUpdate struct {
	Settings *DBAASEndpointRsyslogInputUpdateSettings `json:"settings,omitempty"`
}

type DBAASEndpointRsyslogOptionalFields struct {
	Format EnumRsyslogFormat `json:"format,omitempty"`
	// Custom syslog message format
	Logline string `json:"logline,omitempty" validate:"omitempty,gte=1,lte=512"`
	// Rsyslog max message size
	MaxMessageSize int64 `json:"max-message-size,omitempty" validate:"omitempty,gte=2048,lte=2.147483647e+09"`
	// Rsyslog server port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Structured data block for log message
	SD string `json:"sd,omitempty" validate:"omitempty,lte=1024"`
	// Rsyslog server IP address or hostname
	Server string `json:"server,omitempty" validate:"omitempty,gte=4,lte=255"`
	// Require TLS
	Tls *bool `json:"tls,omitempty"`
}

type DBAASEndpointRsyslogSecrets struct {
	// PEM encoded CA certificate
	CA string `json:"ca,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client certificate
	Cert string `json:"cert,omitempty" validate:"omitempty,lte=16384"`
	// PEM encoded client key
	Key string `json:"key,omitempty" validate:"omitempty,lte=16384"`
}

type DBAASExternalEndpoint struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string                    `json:"name,omitempty"`
	Type EnumExternalEndpointTypes `json:"type,omitempty"`
}

// External integration DataDog configuration
type DBAASExternalEndpointDatadogOutputSettings struct {
	// Custom tags provided by user
	DatadogTags []DBAASDatadogTag `json:"datadog-tags,omitempty"`
	// Disable kafka consumer group metrics. Applies only when attached to kafka services.
	DisableConsumerStats *bool `json:"disable-consumer-stats,omitempty"`
	// Number of separate instances to fetch kafka consumer statistics with. Applies only when attached to kafka services.
	KafkaConsumerCheckInstances int64 `json:"kafka-consumer-check-instances,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Number of seconds that datadog will wait to get consumer statistics from brokers. Applies only when attached to kafka services.
	KafkaConsumerStatsTimeout int64 `json:"kafka-consumer-stats-timeout,omitempty" validate:"omitempty,gte=2,lte=300"`
	// Maximum number of partition contexts to send. Applies only when attached to kafka services.
	MaxPartitionContexts int64           `json:"max-partition-contexts,omitempty" validate:"omitempty,gte=200,lte=200000"`
	Site                 EnumDatadogSite `json:"site,omitempty"`
}

type DBAASExternalEndpointDatadogOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name string `json:"name,omitempty"`
	// External integration DataDog configuration
	Settings *DBAASExternalEndpointDatadogOutputSettings `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes                   `json:"type,omitempty"`
}

type DBAASExternalEndpointRsyslogOutput struct {
	// External integration endpoint id
	ID UUID `json:"id,omitempty"`
	// External integration endpoint name
	Name     string                              `json:"name,omitempty"`
	Settings *DBAASEndpointRsyslogOptionalFields `json:"settings,omitempty"`
	Type     EnumExternalEndpointTypes           `json:"type,omitempty"`
}

// Integrations with other services
type DBAASExternalIntegration struct {
	// Description of the integration
	Description string `json:"description" validate:"required"`
	// External destination endpoint id
	DestEndpointID string `json:"dest-endpoint-id,omitempty"`
	// External destination endpoint name
	DestEndpointName string `json:"dest-endpoint-name,omitempty"`
	// Endpoint integration UUID
	IntegrationID UUID `json:"integration-id,omitempty"`
	// DBaaS source service name
	SourceServiceName string               `json:"source-service-name" validate:"required"`
	SourceServiceType DBAASServiceTypeName `json:"source-service-type" validate:"required,gte=0,lte=64"`
	// Integration status
	Status string                    `json:"status,omitempty"`
	Type   EnumExternalEndpointTypes `json:"type" validate:"required"`
}

type DBAASIntegration struct {
	// Description of the integration
	Description string `json:"description,omitempty"`
	// Destination service name
	Dest string `json:"dest,omitempty"`
	// Integration id
	ID UUID `json:"id,omitempty"`
	// Whether the integration is active or not
	ISActive *bool `json:"is-active,omitempty"`
	// Whether the integration is enabled or not
	ISEnabled *bool `json:"is-enabled,omitempty"`
	// Integration settings
	Settings map[string]any `json:"settings,omitempty"`
	// Source service name
	Source string `json:"source,omitempty"`
	// Integration status
	Status string `json:"status,omitempty"`
	// Integration type
	Type string `json:"type,omitempty"`
}

type DBAASIntegrationSettingsDatadog struct {
	// Database monitoring: view query metrics, explain plans, and execution details. Correlate queries with host metrics.
	DatadogDbmEnabled *bool `json:"datadog-dbm-enabled,omitempty"`
	// Integrate PgBouncer with Datadog to track connection pool metrics and monitor application traffic.
	DatadogPgbouncerEnabled *bool `json:"datadog-pgbouncer-enabled,omitempty"`
}

// A JSON schema of additional settings of the integration.
type DBAASIntegrationTypeSettings struct {
	AdditionalProperties *bool          `json:"additionalProperties,omitempty"`
	Properties           map[string]any `json:"properties,omitempty"`
	Title                string         `json:"title,omitempty"`
	Type                 string         `json:"type,omitempty"`
}

type DBAASIntegrationType struct {
	// The description of the destination service types.
	DestDescription string `json:"dest-description,omitempty"`
	// A list of the destination service types the integration supports.
	DestServiceTypes []string `json:"dest-service-types,omitempty"`
	// A JSON schema of additional settings of the integration.
	Settings *DBAASIntegrationTypeSettings `json:"settings,omitempty"`
	// The description of the source service types.
	SourceDescription string `json:"source-description,omitempty"`
	// A list of the source service types the integration supports.
	SourceServiceTypes []string `json:"source-service-types,omitempty"`
	// The type of the integration.
	Type string `json:"type,omitempty"`
}

type DBAASKafkaAclID string

type DBAASKafkaAcls struct {
	SchemaRegistryAcl []DBAASKafkaSchemaRegistryAclEntry `json:"schema-registry-acl,omitempty"`
	TopicAcl          []DBAASKafkaTopicAclEntry          `json:"topic-acl,omitempty"`
}

type DBAASKafkaSchemaRegistryAclEntryPermission string

const (
	DBAASKafkaSchemaRegistryAclEntryPermissionSchemaRegistryRead  DBAASKafkaSchemaRegistryAclEntryPermission = "schema_registry_read"
	DBAASKafkaSchemaRegistryAclEntryPermissionSchemaRegistryWrite DBAASKafkaSchemaRegistryAclEntryPermission = "schema_registry_write"
)

type DBAASKafkaSchemaRegistryAclEntry struct {
	ID DBAASKafkaAclID `json:"id,omitempty" validate:"omitempty,gte=1,lte=40"`
	// Kafka Schema Registry permission
	Permission DBAASKafkaSchemaRegistryAclEntryPermission `json:"permission" validate:"required"`
	// Kafka Schema Registry name or pattern
	Resource string `json:"resource" validate:"required,gte=1,lte=249"`
	// Kafka username or username pattern
	Username string `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASKafkaTopicAclEntryPermission string

const (
	DBAASKafkaTopicAclEntryPermissionAdmin     DBAASKafkaTopicAclEntryPermission = "admin"
	DBAASKafkaTopicAclEntryPermissionRead      DBAASKafkaTopicAclEntryPermission = "read"
	DBAASKafkaTopicAclEntryPermissionReadwrite DBAASKafkaTopicAclEntryPermission = "readwrite"
	DBAASKafkaTopicAclEntryPermissionWrite     DBAASKafkaTopicAclEntryPermission = "write"
)

type DBAASKafkaTopicAclEntry struct {
	ID DBAASKafkaAclID `json:"id,omitempty" validate:"omitempty,gte=1,lte=40"`
	// Kafka permission
	Permission DBAASKafkaTopicAclEntryPermission `json:"permission" validate:"required"`
	// Kafka topic name or pattern
	Topic string `json:"topic" validate:"required,gte=1,lte=249"`
	// Kafka username or username pattern
	Username string `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASMigrationStatusDetails struct {
	// Migrated db name (PG) or number (Valkey)
	Dbname string `json:"dbname,omitempty"`
	// Error message in case that migration has failed
	Error string `json:"error,omitempty"`
	// Migration method
	Method string              `json:"method,omitempty"`
	Status EnumMigrationStatus `json:"status,omitempty"`
}

type DBAASMigrationStatus struct {
	// Migration status per database
	Details []DBAASMigrationStatusDetails `json:"details,omitempty"`
	// Error message in case that migration has failed
	Error string `json:"error,omitempty"`
	// Migration method. Empty in case of multiple methods or error
	Method string `json:"method,omitempty"`
	// Migration status
	Status string `json:"status,omitempty"`
}

type DBAASMysqlDatabaseName string

type DBAASNodeStateRole string

const (
	DBAASNodeStateRoleStandby     DBAASNodeStateRole = "standby"
	DBAASNodeStateRoleMaster      DBAASNodeStateRole = "master"
	DBAASNodeStateRoleReadReplica DBAASNodeStateRole = "read-replica"
)

type DBAASNodeStateState string

const (
	DBAASNodeStateStateLeaving     DBAASNodeStateState = "leaving"
	DBAASNodeStateStateRunning     DBAASNodeStateState = "running"
	DBAASNodeStateStateSyncingData DBAASNodeStateState = "syncing_data"
	DBAASNodeStateStateSettingUPVm DBAASNodeStateState = "setting_up_vm"
	DBAASNodeStateStateUnknown     DBAASNodeStateState = "unknown"
)

// Automatic maintenance settings
type DBAASNodeState struct {
	// Name of the service node
	Name string `json:"name" validate:"required"`
	// Extra information regarding the progress for current state
	ProgressUpdates []DBAASNodeStateProgressUpdate `json:"progress-updates,omitempty"`
	// Role of this node. Only returned for a subset of service types
	Role DBAASNodeStateRole `json:"role,omitempty"`
	// Current state of the service node
	State DBAASNodeStateState `json:"state" validate:"required"`
}

type DBAASNodeStateProgressUpdatePhase string

const (
	DBAASNodeStateProgressUpdatePhaseStream     DBAASNodeStateProgressUpdatePhase = "stream"
	DBAASNodeStateProgressUpdatePhaseBasebackup DBAASNodeStateProgressUpdatePhase = "basebackup"
	DBAASNodeStateProgressUpdatePhasePrepare    DBAASNodeStateProgressUpdatePhase = "prepare"
	DBAASNodeStateProgressUpdatePhaseFinalize   DBAASNodeStateProgressUpdatePhase = "finalize"
)

// Extra information regarding the progress for current state
type DBAASNodeStateProgressUpdate struct {
	// Indicates whether this phase has been completed or not
	Completed *bool `json:"completed" validate:"required"`
	// Current progress for this phase. May be missing or null.
	Current int64 `json:"current,omitempty" validate:"omitempty,gte=0"`
	// Maximum progress value for this phase. May be missing or null. May change.
	Max int64 `json:"max,omitempty" validate:"omitempty,gte=0"`
	// Minimum progress value for this phase. May be missing or null.
	Min int64 `json:"min,omitempty" validate:"omitempty,gte=0"`
	// Key identifying this phase
	Phase DBAASNodeStateProgressUpdatePhase `json:"phase" validate:"required"`
	// Unit for current/min/max values. New units may be added.
	// If null should be treated as generic unit
	Unit string `json:"unit,omitempty"`
}

type DBAASOpensearchAclConfigAclsRules struct {
	// OpenSearch index pattern
	Index      string                       `json:"index" validate:"required,lte=249"`
	Permission EnumOpensearchRulePermission `json:"permission,omitempty"`
}

type DBAASOpensearchAclConfigAcls struct {
	Rules    []DBAASOpensearchAclConfigAclsRules `json:"rules,omitempty"`
	Username DBAASUserUsername                   `json:"username,omitempty" validate:"omitempty,gte=1,lte=64"`
}

type DBAASOpensearchAclConfig struct {
	// Enable OpenSearch ACLs. When disabled authenticated service users have unrestricted access.
	AclEnabled *bool `json:"acl-enabled,omitempty"`
	// List of OpenSearch ACLs
	Acls []DBAASOpensearchAclConfigAcls `json:"acls,omitempty"`
	// Enable to enforce index rules in a limited fashion for requests that use the _mget, _msearch, and _bulk APIs
	ExtendedAclEnabled *bool `json:"extended-acl-enabled,omitempty"`
}

type DBAASPGDatabaseName string

type DBAASPGPoolName string

type DBAASPGPoolSize int64

type DBAASPGPoolUsername string

type DBAASPGTargetVersions string

const (
	DBAASPGTargetVersions14 DBAASPGTargetVersions = "14"
	DBAASPGTargetVersions17 DBAASPGTargetVersions = "17"
	DBAASPGTargetVersions15 DBAASPGTargetVersions = "15"
	DBAASPGTargetVersions13 DBAASPGTargetVersions = "13"
	DBAASPGTargetVersions16 DBAASPGTargetVersions = "16"
)

// DBaaS plan
type DBAASPlan struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`
	// DBaaS plan backup config
	BackupConfig *DBAASBackupConfig `json:"backup-config,omitempty"`
	// DBaaS plan disk space
	DiskSpace int64 `json:"disk-space,omitempty"`
	// Instance family subset which the service can use
	Family string `json:"family,omitempty"`
	// DBaaS plan max memory allocated percentage
	MaxMemoryPercent int64 `json:"max-memory-percent,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan name
	Name string `json:"name,omitempty"`
	// DBaaS plan node count
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan CPU count per node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gt=0"`
	// DBaaS plan memory count per node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gt=0"`
	// Zones where the plan is available
	Zones []string `json:"zones,omitempty"`
}

type DBAASPostgresUsersUsers struct {
	AllowReplication *bool             `json:"allow-replication,omitempty"`
	Username         DBAASUserUsername `json:"username" validate:"required,gte=1,lte=64"`
}

type DBAASPostgresUsers struct {
	Users []DBAASPostgresUsersUsers `json:"users,omitempty"`
}

// List of backups for the service
type DBAASServiceBackup struct {
	// Internal name of this backup
	BackupName string `json:"backup-name" validate:"required"`
	// Backup timestamp (ISO 8601)
	BackupTime time.Time `json:"backup-time" validate:"required"`
	// Backup's original size before compression
	DataSize int64 `json:"data-size" validate:"required,gte=0"`
}

type DBAASServiceCommon struct {
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	Name         DBAASServiceName   `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan  string           `json:"plan" validate:"required"`
	State EnumServiceState `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceComponentsRoute string

const (
	DBAASServiceComponentsRouteDynamic     DBAASServiceComponentsRoute = "dynamic"
	DBAASServiceComponentsRoutePrivate     DBAASServiceComponentsRoute = "private"
	DBAASServiceComponentsRoutePublic      DBAASServiceComponentsRoute = "public"
	DBAASServiceComponentsRoutePrivatelink DBAASServiceComponentsRoute = "privatelink"
)

type DBAASServiceComponentsUsage string

const (
	DBAASServiceComponentsUsagePrimary DBAASServiceComponentsUsage = "primary"
	DBAASServiceComponentsUsageReplica DBAASServiceComponentsUsage = "replica"
)

// Service component information objects
type DBAASServiceComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host                      string              `json:"host" validate:"required"`
	KafkaAuthenticationMethod EnumKafkaAuthMethod `json:"kafka-authentication-method,omitempty"`
	// Path component of the service URL (useful only if service component is HTTP or HTTPS endpoint)
	Path string `json:"path,omitempty"`
	// Port number for connecting to the service component
	Port int64 `json:"port" validate:"required,gte=0,lte=65535"`
	// Network access route
	Route DBAASServiceComponentsRoute `json:"route" validate:"required"`
	// Whether the endpoint is encrypted or accepts plaintext.
	// By default endpoints are always encrypted and
	// this property is only included for service components that may disable encryption.
	SSL *bool `json:"ssl,omitempty"`
	// DNS usage name
	Usage DBAASServiceComponentsUsage `json:"usage" validate:"required"`
}

type DBAASServiceGrafanaComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Grafana connection information properties
type DBAASServiceGrafanaConnectionInfo struct {
	Password string `json:"password,omitempty"`
	URI      string `json:"uri,omitempty"`
	Username string `json:"username,omitempty"`
}

// Prometheus integration URI
type DBAASServiceGrafanaPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceGrafanaUsers struct {
	Password string `json:"password,omitempty"`
	Type     string `json:"type,omitempty"`
	Username string `json:"username,omitempty"`
}

type DBAASServiceGrafana struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceGrafanaComponents `json:"components,omitempty"`
	// Grafana connection information properties
	ConnectionInfo *DBAASServiceGrafanaConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DbaaS service description
	Description string `json:"description,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Grafana settings
	GrafanaSettings *JSONSchemaGrafana `json:"grafana-settings,omitempty"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceGrafanaPrometheusURI `json:"prometheus-uri" validate:"required"`
	State         EnumServiceState                  `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceGrafanaUsers `json:"users,omitempty"`
	// Grafana version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// Kafka authentication methods
type DBAASServiceKafkaAuthenticationMethods struct {
	// Whether certificate/SSL authentication is enabled
	Certificate *bool `json:"certificate,omitempty"`
	// Whether SASL authentication is enabled
	Sasl *bool `json:"sasl,omitempty"`
}

type DBAASServiceKafkaComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host                      string              `json:"host" validate:"required"`
	KafkaAuthenticationMethod EnumKafkaAuthMethod `json:"kafka-authentication-method,omitempty"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Kafka connection information properties
type DBAASServiceKafkaConnectionInfo struct {
	AccessCert  string   `json:"access-cert,omitempty"`
	AccessKey   string   `json:"access-key,omitempty"`
	ConnectURI  string   `json:"connect-uri,omitempty"`
	Nodes       []string `json:"nodes,omitempty"`
	RegistryURI string   `json:"registry-uri,omitempty"`
	RestURI     string   `json:"rest-uri,omitempty"`
}

// Prometheus integration URI
type DBAASServiceKafkaPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceKafkaUsers struct {
	AccessCert       string    `json:"access-cert,omitempty"`
	AccessCertExpiry time.Time `json:"access-cert-expiry,omitempty"`
	AccessKey        string    `json:"access-key,omitempty"`
	Password         string    `json:"password,omitempty"`
	Type             string    `json:"type,omitempty"`
	Username         string    `json:"username,omitempty"`
}

type DBAASServiceKafka struct {
	// Kafka authentication methods
	AuthenticationMethods *DBAASServiceKafkaAuthenticationMethods `json:"authentication-methods,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceKafkaComponents `json:"components,omitempty"`
	// Kafka connection information properties
	ConnectionInfo *DBAASServiceKafkaConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allow incoming connections from CIDR address block, e.g. '10.20.0.0/16'
	IPFilter []string `json:"ip-filter,omitempty"`
	// Whether Kafka Connect is enabled
	KafkaConnectEnabled *bool `json:"kafka-connect-enabled,omitempty"`
	// Kafka Connect configuration values
	KafkaConnectSettings *JSONSchemaKafkaConnect `json:"kafka-connect-settings,omitempty"`
	// Whether Kafka REST is enabled
	KafkaRestEnabled *bool `json:"kafka-rest-enabled,omitempty"`
	// Kafka REST configuration
	KafkaRestSettings *JSONSchemaKafkaRest `json:"kafka-rest-settings,omitempty"`
	// Kafka broker configuration values
	KafkaSettings *JSONSchemaKafka `json:"kafka-settings,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceKafkaPrometheusURI `json:"prometheus-uri" validate:"required"`
	// Whether Schema-Registry is enabled
	SchemaRegistryEnabled *bool `json:"schema-registry-enabled,omitempty"`
	// Schema Registry configuration
	SchemaRegistrySettings *JSONSchemaSchemaRegistry `json:"schema-registry-settings,omitempty"`
	State                  EnumServiceState          `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceKafkaUsers `json:"users,omitempty"`
	// Kafka version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceLogsLogs struct {
	Message string `json:"message,omitempty"`
	Node    string `json:"node,omitempty"`
	Time    string `json:"time,omitempty"`
	Unit    string `json:"unit,omitempty"`
}

type DBAASServiceLogs struct {
	FirstLogOffset string                 `json:"first-log-offset,omitempty"`
	Logs           []DBAASServiceLogsLogs `json:"logs,omitempty"`
	Offset         string                 `json:"offset,omitempty"`
}

type DBAASServiceMaintenanceDow string

const (
	DBAASServiceMaintenanceDowSaturday  DBAASServiceMaintenanceDow = "saturday"
	DBAASServiceMaintenanceDowTuesday   DBAASServiceMaintenanceDow = "tuesday"
	DBAASServiceMaintenanceDowNever     DBAASServiceMaintenanceDow = "never"
	DBAASServiceMaintenanceDowWednesday DBAASServiceMaintenanceDow = "wednesday"
	DBAASServiceMaintenanceDowSunday    DBAASServiceMaintenanceDow = "sunday"
	DBAASServiceMaintenanceDowFriday    DBAASServiceMaintenanceDow = "friday"
	DBAASServiceMaintenanceDowMonday    DBAASServiceMaintenanceDow = "monday"
	DBAASServiceMaintenanceDowThursday  DBAASServiceMaintenanceDow = "thursday"
)

// Automatic maintenance settings
type DBAASServiceMaintenance struct {
	// Day of week for installing updates
	Dow DBAASServiceMaintenanceDow `json:"dow" validate:"required"`
	// Time for installing updates, UTC
	Time string `json:"time" validate:"required,gte=8,lte=8"`
	// List of updates waiting to be installed
	Updates []DBAASServiceUpdate `json:"updates" validate:"required"`
}

// Backup schedule
type DBAASServiceMysqlBackupSchedule struct {
	// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupHour int64 `json:"backup-hour,omitempty" validate:"omitempty,gte=0,lte=23"`
	// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupMinute int64 `json:"backup-minute,omitempty" validate:"omitempty,gte=0,lte=59"`
}

type DBAASServiceMysqlComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// MySQL connection information properties
type DBAASServiceMysqlConnectionInfo struct {
	Params  []map[string]string `json:"params,omitempty"`
	Standby []string            `json:"standby,omitempty"`
	URI     []string            `json:"uri,omitempty"`
}

// Prometheus integration URI
type DBAASServiceMysqlPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceMysqlUsers struct {
	Authentication string `json:"authentication,omitempty"`
	Password       string `json:"password,omitempty"`
	Type           string `json:"type,omitempty"`
	Username       string `json:"username,omitempty"`
}

type DBAASServiceMysql struct {
	// Backup schedule
	BackupSchedule *DBAASServiceMysqlBackupSchedule `json:"backup-schedule,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceMysqlComponents `json:"components,omitempty"`
	// MySQL connection information properties
	ConnectionInfo *DBAASServiceMysqlConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// List of MySQL databases
	Databases []DBAASMysqlDatabaseName `json:"databases,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// mysql.conf configuration values
	MysqlSettings *JSONSchemaMysql `json:"mysql-settings,omitempty"`
	Name          DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceMysqlPrometheusURI `json:"prometheus-uri" validate:"required"`
	State         EnumServiceState                `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceMysqlUsers `json:"users,omitempty"`
	// MySQL version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceName string

type DBAASServiceNotificationLevel string

const (
	DBAASServiceNotificationLevelWarning DBAASServiceNotificationLevel = "warning"
	DBAASServiceNotificationLevelNotice  DBAASServiceNotificationLevel = "notice"
)

type DBAASServiceNotificationType string

const (
	DBAASServiceNotificationTypeServicePoweredOffRemoval DBAASServiceNotificationType = "service_powered_off_removal"
	DBAASServiceNotificationTypeServiceEndOfLife         DBAASServiceNotificationType = "service_end_of_life"
)

// Service notifications
type DBAASServiceNotification struct {
	// Notification level
	Level DBAASServiceNotificationLevel `json:"level" validate:"required"`
	// Human notification message
	Message string `json:"message" validate:"required,gte=1,lte=1024"`
	// Notification type
	Metadata map[string]any `json:"metadata" validate:"required"`
	// Notification type
	Type DBAASServiceNotificationType `json:"type" validate:"required"`
}

type DBAASServiceOpensearchComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Opensearch connection information properties
type DBAASServiceOpensearchConnectionInfo struct {
	DashboardURI string   `json:"dashboard-uri,omitempty"`
	Password     string   `json:"password,omitempty"`
	URI          []string `json:"uri,omitempty"`
	Username     string   `json:"username,omitempty"`
}

type DBAASServiceOpensearchIndexPatternsSortingAlgorithm string

const (
	DBAASServiceOpensearchIndexPatternsSortingAlgorithmAlphabetical DBAASServiceOpensearchIndexPatternsSortingAlgorithm = "alphabetical"
	DBAASServiceOpensearchIndexPatternsSortingAlgorithmCreationDate DBAASServiceOpensearchIndexPatternsSortingAlgorithm = "creation_date"
)

type DBAASServiceOpensearchIndexPatterns struct {
	// Maximum number of indexes to keep
	MaxIndexCount *int64 `json:"max-index-count,omitempty" validate:"omitempty,gte=0"`
	// fnmatch pattern
	Pattern string `json:"pattern,omitempty" validate:"omitempty,lte=1024"`
	// Deletion sorting algorithm
	SortingAlgorithm DBAASServiceOpensearchIndexPatternsSortingAlgorithm `json:"sorting-algorithm,omitempty"`
}

// Template settings for all new indexes
type DBAASServiceOpensearchIndexTemplate struct {
	// The maximum number of nested JSON objects that a single document can contain across all nested types. This limit helps to prevent out of memory errors when a document contains too many nested objects. Default is 10000.
	MappingNestedObjectsLimit int64 `json:"mapping-nested-objects-limit,omitempty" validate:"omitempty,gte=0,lte=100000"`
	// The number of replicas each primary shard has.
	NumberOfReplicas int64 `json:"number-of-replicas,omitempty" validate:"omitempty,gte=0,lte=29"`
	// The number of primary shards that an index should have.
	NumberOfShards int64 `json:"number-of-shards,omitempty" validate:"omitempty,gte=1,lte=1024"`
}

// OpenSearch Dashboards settings
type DBAASServiceOpensearchOpensearchDashboards struct {
	// Enable or disable OpenSearch Dashboards (default: true)
	Enabled *bool `json:"enabled,omitempty"`
	// Limits the maximum amount of memory (in MiB) the OpenSearch Dashboards process can use. This sets the max_old_space_size option of the nodejs running the OpenSearch Dashboards. Note: the memory reserved by OpenSearch Dashboards is not available for OpenSearch. (default: 128)
	MaxOldSpaceSize int64 `json:"max-old-space-size,omitempty" validate:"omitempty,gte=64,lte=1024"`
	// Timeout in milliseconds for requests made by OpenSearch Dashboards towards OpenSearch (default: 30000)
	OpensearchRequestTimeout int64 `json:"opensearch-request-timeout,omitempty" validate:"omitempty,gte=5000,lte=120000"`
}

// Prometheus integration URI
type DBAASServiceOpensearchPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceOpensearchUsers struct {
	Password string `json:"password,omitempty"`
	Type     string `json:"type,omitempty"`
	Username string `json:"username,omitempty"`
}

type DBAASServiceOpensearch struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceOpensearchComponents `json:"components,omitempty"`
	// Opensearch connection information properties
	ConnectionInfo *DBAASServiceOpensearchConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DbaaS service description
	Description string `json:"description,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Allows you to create glob style patterns and set a max number of indexes matching this pattern you want to keep. Creating indexes exceeding this value will cause the oldest one to get deleted. You could for example create a pattern looking like 'logs.?' and then create index logs.1, logs.2 etc, it will delete logs.1 once you create logs.6. Do note 'logs.?' does not apply to logs.10. Note: Setting max_index_count to 0 will do nothing and the pattern gets ignored.
	IndexPatterns []DBAASServiceOpensearchIndexPatterns `json:"index-patterns,omitempty"`
	// Template settings for all new indexes
	IndexTemplate *DBAASServiceOpensearchIndexTemplate `json:"index-template,omitempty"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Aiven automation resets index.refresh_interval to default value for every index to be sure that indices are always visible to search. If it doesn't fit your case, you can disable this by setting up this flag to true.
	KeepIndexRefreshInterval *bool `json:"keep-index-refresh-interval,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// Maximum number of indexes to keep before deleting the oldest one
	MaxIndexCount *int64           `json:"max-index-count,omitempty" validate:"omitempty,gte=0"`
	Name          DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// OpenSearch Dashboards settings
	OpensearchDashboards *DBAASServiceOpensearchOpensearchDashboards `json:"opensearch-dashboards,omitempty"`
	// OpenSearch settings
	OpensearchSettings *JSONSchemaOpensearch `json:"opensearch-settings,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceOpensearchPrometheusURI `json:"prometheus-uri" validate:"required"`
	State         EnumServiceState                     `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceOpensearchUsers `json:"users,omitempty"`
	// OpenSearch version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// Backup schedule
type DBAASServicePGBackupSchedule struct {
	// The hour of day (in UTC) when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupHour int64 `json:"backup-hour,omitempty" validate:"omitempty,gte=0,lte=23"`
	// The minute of an hour when backup for the service is started. New backup is only started if previous backup has already completed.
	BackupMinute int64 `json:"backup-minute,omitempty" validate:"omitempty,gte=0,lte=59"`
}

type DBAASServicePGComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// PG connection information properties
type DBAASServicePGConnectionInfo struct {
	Params  []map[string]string `json:"params,omitempty"`
	Standby []string            `json:"standby,omitempty"`
	Syncing []string            `json:"syncing,omitempty"`
	URI     []string            `json:"uri,omitempty"`
}

type DBAASServicePGConnectionPools struct {
	// Connection URI for the DB pool
	ConnectionURI string              `json:"connection-uri" validate:"required"`
	Database      DBAASDatabaseName   `json:"database" validate:"required,gte=1,lte=40"`
	Mode          EnumPGPoolMode      `json:"mode" validate:"required"`
	Name          DBAASPGPoolName     `json:"name" validate:"required,gte=1,lte=63"`
	Size          DBAASPGPoolSize     `json:"size" validate:"required,gte=1,lte=10000"`
	Username      DBAASPGPoolUsername `json:"username" validate:"required,gte=1,lte=64"`
}

// Prometheus integration URI
type DBAASServicePGPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

// List of service users
type DBAASServicePGUsers struct {
	AllowReplication *bool `json:"allow-replication,omitempty"`
	// Account password. A missing field indicates a user overridden password.
	Password string `json:"password,omitempty"`
	// Account type
	Type string `json:"type" validate:"required"`
	// Account username
	Username string `json:"username" validate:"required"`
}

type DBAASServicePG struct {
	// Backup schedule
	BackupSchedule *DBAASServicePGBackupSchedule `json:"backup-schedule,omitempty"`
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServicePGComponents `json:"components,omitempty"`
	// PG connection information properties
	ConnectionInfo *DBAASServicePGConnectionInfo `json:"connection-info,omitempty"`
	// PostgreSQL PGBouncer connection pools
	ConnectionPools []DBAASServicePGConnectionPools `json:"connection-pools,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// List of PostgreSQL databases
	Databases []DBAASDatabaseName `json:"databases,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	// Maximum number of connections allowed to an instance
	MaxConnections int64            `json:"max-connections,omitempty" validate:"omitempty,gt=0"`
	Name           DBAASServiceName `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// postgresql.conf configuration values
	PGSettings *JSONSchemaPG `json:"pg-settings,omitempty"`
	// System-wide settings for pgbouncer.
	PgbouncerSettings *JSONSchemaPgbouncer `json:"pgbouncer-settings,omitempty"`
	// System-wide settings for pglookout.
	PglookoutSettings *JSONSchemaPglookout `json:"pglookout-settings,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServicePGPrometheusURI `json:"prometheus-uri" validate:"required"`
	// Percentage of total RAM that the database server uses for shared memory buffers. Valid range is 20-60 (float), which corresponds to 20% - 60%. This setting adjusts the shared_buffers configuration value.
	SharedBuffersPercentage int64                        `json:"shared-buffers-percentage,omitempty" validate:"omitempty,gte=20,lte=60"`
	State                   EnumServiceState             `json:"state,omitempty"`
	SynchronousReplication  EnumPGSynchronousReplication `json:"synchronous-replication,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
	// System-wide settings for the timescaledb extension
	TimescaledbSettings *JSONSchemaTimescaledb `json:"timescaledb-settings,omitempty"`
	Type                DBAASServiceTypeName   `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServicePGUsers `json:"users,omitempty"`
	// PostgreSQL version
	Version string `json:"version,omitempty"`
	// Sets the maximum amount of memory to be used by a query operation (such as a sort or hash table) before writing to temporary disk files, in MB. Default is 1MB + 0.075% of total RAM (up to 32MB).
	WorkMem int64 `json:"work-mem,omitempty" validate:"omitempty,gte=1,lte=1024"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASServiceThanosComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	// Whether the endpoint is encrypted or accepts plaintext.
	// By default endpoints are always encrypted and
	// this property is only included for service components that may disable encryption.
	SSL   *bool              `json:"ssl,omitempty"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Thanos connection information properties
type DBAASServiceThanosConnectionInfo struct {
	QueryFrontendURI       string `json:"query-frontend-uri,omitempty"`
	QueryURI               string `json:"query-uri,omitempty"`
	ReceiverRemoteWriteURI string `json:"receiver-remote-write-uri,omitempty"`
	RulerURI               string `json:"ruler-uri,omitempty"`
}

// Prometheus integration URI
type DBAASServiceThanosPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceThanos struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceThanosComponents `json:"components,omitempty"`
	// Thanos connection information properties
	ConnectionInfo *DBAASServiceThanosConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceThanosPrometheusURI `json:"prometheus-uri" validate:"required"`
	State         EnumServiceState                 `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool `json:"termination-protection,omitempty"`
	// Thanos settings
	ThanosSettings *JSONSchemaThanos    `json:"thanos-settings,omitempty"`
	Type           DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

// DBaaS service
type DBAASServiceType struct {
	// DbaaS service available versions
	AvailableVersions []string `json:"available-versions,omitempty"`
	// DbaaS service default version
	DefaultVersion string `json:"default-version,omitempty"`
	// DbaaS service description
	Description string               `json:"description,omitempty"`
	Name        DBAASServiceTypeName `json:"name,omitempty" validate:"omitempty,gte=0,lte=64"`
	// DbaaS service plans
	Plans []DBAASPlan `json:"plans,omitempty"`
}

type DBAASServiceTypeName string

// Update waiting to be installed
type DBAASServiceUpdate struct {
	// Deadline for installing the update
	Deadline time.Time `json:"deadline,omitempty"`
	// Description of the update
	Description string `json:"description,omitempty"`
	// The earliest time the update will be automatically applied
	StartAfter time.Time `json:"start-after,omitempty"`
	// The time when the update will be automatically applied
	StartAT time.Time `json:"start-at,omitempty"`
}

type DBAASServiceValkeyComponents struct {
	// Service component name
	Component string `json:"component" validate:"required"`
	// DNS name for connecting to the service component
	Host string `json:"host" validate:"required"`
	// Port number for connecting to the service component
	Port  int64              `json:"port" validate:"required,gte=0,lte=65535"`
	Route EnumComponentRoute `json:"route" validate:"required"`
	// Whether the endpoint is encrypted or accepts plaintext.
	// By default endpoints are always encrypted and
	// this property is only included for service components that may disable encryption.
	SSL   *bool              `json:"ssl,omitempty"`
	Usage EnumComponentUsage `json:"usage" validate:"required"`
}

// Valkey connection information properties
type DBAASServiceValkeyConnectionInfo struct {
	Password string   `json:"password,omitempty"`
	Slave    []string `json:"slave,omitempty"`
	URI      []string `json:"uri,omitempty"`
}

// Prometheus integration URI
type DBAASServiceValkeyPrometheusURI struct {
	Host string `json:"host,omitempty"`
	Port int64  `json:"port,omitempty" validate:"omitempty,gte=0,lte=65535"`
}

type DBAASServiceValkeyUsersAccessControl struct {
	Categories []string `json:"categories,omitempty"`
	Channels   []string `json:"channels,omitempty"`
	Commands   []string `json:"commands,omitempty"`
	Keys       []string `json:"keys,omitempty"`
}

type DBAASServiceValkeyUsers struct {
	AccessControl *DBAASServiceValkeyUsersAccessControl `json:"access-control,omitempty"`
	Password      string                                `json:"password,omitempty"`
	Type          string                                `json:"type,omitempty"`
	Username      string                                `json:"username,omitempty"`
}

type DBAASServiceValkey struct {
	// List of backups for the service
	Backups []DBAASServiceBackup `json:"backups,omitempty"`
	// Service component information objects
	Components []DBAASServiceValkeyComponents `json:"components,omitempty"`
	// Valkey connection information properties
	ConnectionInfo *DBAASServiceValkeyConnectionInfo `json:"connection-info,omitempty"`
	// Service creation timestamp (ISO 8601)
	CreatedAT time.Time `json:"created-at,omitempty"`
	// TODO UNIT disk space for data storage
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=0"`
	// Service integrations
	Integrations []DBAASIntegration `json:"integrations,omitempty"`
	// Allowed CIDR address blocks for incoming connections
	IPFilter []string `json:"ip-filter,omitempty"`
	// Automatic maintenance settings
	Maintenance *DBAASServiceMaintenance `json:"maintenance,omitempty"`
	Name        DBAASServiceName         `json:"name" validate:"required,gte=0,lte=63"`
	// Number of service nodes in the active plan
	NodeCount int64 `json:"node-count,omitempty" validate:"omitempty,gte=0"`
	// Number of CPUs for each node
	NodeCPUCount int64 `json:"node-cpu-count,omitempty" validate:"omitempty,gte=0"`
	// TODO UNIT of memory for each node
	NodeMemory int64 `json:"node-memory,omitempty" validate:"omitempty,gte=0"`
	// State of individual service nodes
	NodeStates []DBAASNodeState `json:"node-states,omitempty"`
	// Service notifications
	Notifications []DBAASServiceNotification `json:"notifications,omitempty"`
	// Subscription plan
	Plan string `json:"plan" validate:"required"`
	// Prometheus integration URI
	PrometheusURI *DBAASServiceValkeyPrometheusURI `json:"prometheus-uri" validate:"required"`
	State         EnumServiceState                 `json:"state,omitempty"`
	// Service is protected against termination and powering off
	TerminationProtection *bool                `json:"termination-protection,omitempty"`
	Type                  DBAASServiceTypeName `json:"type" validate:"required,gte=0,lte=64"`
	// Service last update timestamp (ISO 8601)
	UpdatedAT time.Time `json:"updated-at,omitempty"`
	// URI for connecting to the service (may be absent)
	URI string `json:"uri,omitempty"`
	// service_uri parameterized into key-value pairs
	URIParams map[string]any `json:"uri-params,omitempty"`
	// List of service users
	Users []DBAASServiceValkeyUsers `json:"users,omitempty"`
	// Valkey settings
	ValkeySettings *JSONSchemaValkey `json:"valkey-settings,omitempty"`
	// Valkey version
	Version string `json:"version,omitempty"`
	// The zone where the service is running
	Zone string `json:"zone,omitempty"`
}

type DBAASTaskResultCodes struct {
	Code   string `json:"code,omitempty"`
	Dbname string `json:"dbname,omitempty"`
}

type DBAASTask struct {
	CreateTime  time.Time              `json:"create-time,omitempty"`
	ID          UUID                   `json:"id,omitempty"`
	Result      string                 `json:"result,omitempty"`
	ResultCodes []DBAASTaskResultCodes `json:"result-codes,omitempty"`
	Success     *bool                  `json:"success,omitempty"`
	TaskType    string                 `json:"task-type,omitempty"`
}

// Grafana User secrets
type DBAASUserGrafanaSecrets struct {
	// Grafana password
	Password string `json:"password,omitempty"`
	// Grafana username
	Username string `json:"username,omitempty"`
}

// Kafka Connect secrets
type DBAASUserKafkaConnectSecrets struct {
	// Kafka Connect password
	Password string `json:"password,omitempty"`
	// Kafka Connect username
	Username string `json:"username,omitempty"`
}

// Kafka User secrets
type DBAASUserKafkaSecrets struct {
	// Kafka certificate
	AccessCert       string    `json:"access-cert,omitempty"`
	AccessCertExpiry time.Time `json:"access-cert-expiry,omitempty"`
	// Kafka access key
	AccessKey string `json:"access-key,omitempty"`
	// Kafka password
	Password string `json:"password,omitempty"`
	// Kafka username
	Username string `json:"username,omitempty"`
}

// MySQL User secrets
type DBAASUserMysqlSecrets struct {
	// MySQL password
	Password string `json:"password,omitempty"`
	// MySQL username
	Username string `json:"username,omitempty"`
}

// Opensearch User secrets
type DBAASUserOpensearchSecrets struct {
	// Opensearch password
	Password string `json:"password,omitempty"`
	// Opensearch username
	Username string `json:"username,omitempty"`
}

type DBAASUserPassword string

// Postgres User secrets
type DBAASUserPostgresSecrets struct {
	// Postgres password
	Password string `json:"password,omitempty"`
	// Postgres username
	Username string `json:"username,omitempty"`
}

type DBAASUserUsername string

// Valkey User secrets
type DBAASUserValkeySecrets struct {
	// Valkey password
	Password string `json:"password,omitempty"`
	// Valkey username
	Username string `json:"username,omitempty"`
}

type DeployTargetType string

const (
	DeployTargetTypeEdge      DeployTargetType = "edge"
	DeployTargetTypeDedicated DeployTargetType = "dedicated"
)

// Deploy target
type DeployTarget struct {
	// Deploy Target description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Deploy Target ID
	ID UUID `json:"id" validate:"required"`
	// Deploy Target name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Deploy Target type
	Type DeployTargetType `json:"type,omitempty"`
}

// DNS domain
type DNSDomain struct {
	// DNS domain creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DNS domain ID
	ID UUID `json:"id,omitempty"`
	// DNS domain unicode name
	UnicodeName string `json:"unicode-name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type DNSDomainRecordType string

const (
	DNSDomainRecordTypeNS    DNSDomainRecordType = "NS"
	DNSDomainRecordTypeCAA   DNSDomainRecordType = "CAA"
	DNSDomainRecordTypeNAPTR DNSDomainRecordType = "NAPTR"
	DNSDomainRecordTypePOOL  DNSDomainRecordType = "POOL"
	DNSDomainRecordTypeA     DNSDomainRecordType = "A"
	DNSDomainRecordTypeHINFO DNSDomainRecordType = "HINFO"
	DNSDomainRecordTypeCNAME DNSDomainRecordType = "CNAME"
	DNSDomainRecordTypeSOA   DNSDomainRecordType = "SOA"
	DNSDomainRecordTypeSSHFP DNSDomainRecordType = "SSHFP"
	DNSDomainRecordTypeSRV   DNSDomainRecordType = "SRV"
	DNSDomainRecordTypeAAAA  DNSDomainRecordType = "AAAA"
	DNSDomainRecordTypeMX    DNSDomainRecordType = "MX"
	DNSDomainRecordTypeTXT   DNSDomainRecordType = "TXT"
	DNSDomainRecordTypeALIAS DNSDomainRecordType = "ALIAS"
	DNSDomainRecordTypeURL   DNSDomainRecordType = "URL"
	DNSDomainRecordTypeSPF   DNSDomainRecordType = "SPF"
)

// DNS domain record
type DNSDomainRecord struct {
	// DNS domain record content
	Content string `json:"content,omitempty"`
	// DNS domain record creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// DNS domain record ID
	ID UUID `json:"id,omitempty"`
	// DNS domain record name
	Name string `json:"name,omitempty"`
	// DNS domain record priority
	Priority int64 `json:"priority,omitempty" validate:"omitempty,gte=0"`
	// DNS domain record system status
	SystemRecord *bool `json:"system-record,omitempty"`
	// DNS domain record TTL
	Ttl int64 `json:"ttl,omitempty" validate:"omitempty,gte=0"`
	// DNS domain record type
	Type DNSDomainRecordType `json:"type,omitempty"`
	// DNS domain record update date
	UpdatedAT time.Time `json:"updated-at,omitempty"`
}

type DomainName string

type ElasticIPAddressfamily string

const (
	ElasticIPAddressfamilyInet4 ElasticIPAddressfamily = "inet4"
	ElasticIPAddressfamilyInet6 ElasticIPAddressfamily = "inet6"
)

// Elastic IP
type ElasticIP struct {
	// Elastic IP address family
	Addressfamily ElasticIPAddressfamily `json:"addressfamily,omitempty"`
	// Elastic IP cidr
	Cidr string `json:"cidr,omitempty"`
	// Elastic IP description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Elastic IP address healthcheck
	Healthcheck *ElasticIPHealthcheck `json:"healthcheck,omitempty"`
	// Elastic IP ID
	ID UUID `json:"id,omitempty"`
	// Elastic IP address
	IP     string `json:"ip,omitempty"`
	Labels Labels `json:"labels,omitempty"`
}

type ElasticIPHealthcheckMode string

const (
	ElasticIPHealthcheckModeTCP   ElasticIPHealthcheckMode = "tcp"
	ElasticIPHealthcheckModeHTTP  ElasticIPHealthcheckMode = "http"
	ElasticIPHealthcheckModeHttps ElasticIPHealthcheckMode = "https"
)

// Elastic IP address healthcheck
type ElasticIPHealthcheck struct {
	// Interval between the checks in seconds (default: 10)
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gte=5,lte=300"`
	// Health check mode
	Mode ElasticIPHealthcheckMode `json:"mode" validate:"required"`
	// Health check port
	Port int64 `json:"port" validate:"required,gte=1,lte=65535"`
	// Number of attempts before considering the target unhealthy (default: 3)
	StrikesFail int64 `json:"strikes-fail,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Number of attempts before considering the target healthy (default: 2)
	StrikesOk int64 `json:"strikes-ok,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Health check timeout value in seconds (default: 2)
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=2,lte=60"`
	// Skip TLS verification
	TlsSkipVerify *bool `json:"tls-skip-verify,omitempty"`
	// An optional domain or subdomain to check TLS against
	TlsSNI string `json:"tls-sni,omitempty" validate:"omitempty,gte=1,lte=255"`
	// An endpoint to use for the health check, for example '/status'
	URI string `json:"uri,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type EnumComponentRoute string

const (
	EnumComponentRouteDynamic     EnumComponentRoute = "dynamic"
	EnumComponentRoutePrivate     EnumComponentRoute = "private"
	EnumComponentRoutePublic      EnumComponentRoute = "public"
	EnumComponentRoutePrivatelink EnumComponentRoute = "privatelink"
)

type EnumComponentUsage string

const (
	EnumComponentUsagePrimary EnumComponentUsage = "primary"
	EnumComponentUsageReplica EnumComponentUsage = "replica"
)

type EnumDatadogSite string

const (
	EnumDatadogSiteUs3DatadoghqCom EnumDatadogSite = "us3.datadoghq.com"
	EnumDatadogSiteDdogGovCom      EnumDatadogSite = "ddog-gov.com"
	EnumDatadogSiteDatadoghqEU     EnumDatadogSite = "datadoghq.eu"
	EnumDatadogSiteUs5DatadoghqCom EnumDatadogSite = "us5.datadoghq.com"
	EnumDatadogSiteAp1DatadoghqCom EnumDatadogSite = "ap1.datadoghq.com"
	EnumDatadogSiteDatadoghqCom    EnumDatadogSite = "datadoghq.com"
)

type EnumExternalEndpointTypes string

const (
	EnumExternalEndpointTypesPrometheus    EnumExternalEndpointTypes = "prometheus"
	EnumExternalEndpointTypesOpensearch    EnumExternalEndpointTypes = "opensearch"
	EnumExternalEndpointTypesRsyslog       EnumExternalEndpointTypes = "rsyslog"
	EnumExternalEndpointTypesDatadog       EnumExternalEndpointTypes = "datadog"
	EnumExternalEndpointTypesElasticsearch EnumExternalEndpointTypes = "elasticsearch"
)

type EnumIntegrationTypes string

const (
	EnumIntegrationTypesDatasource EnumIntegrationTypes = "datasource"
	EnumIntegrationTypesLogs       EnumIntegrationTypes = "logs"
	EnumIntegrationTypesMetrics    EnumIntegrationTypes = "metrics"
)

type EnumKafkaAuthMethod string

const (
	EnumKafkaAuthMethodCertificate EnumKafkaAuthMethod = "certificate"
	EnumKafkaAuthMethodSasl        EnumKafkaAuthMethod = "sasl"
)

type EnumMasterLinkStatus string

const (
	EnumMasterLinkStatusUP   EnumMasterLinkStatus = "up"
	EnumMasterLinkStatusDown EnumMasterLinkStatus = "down"
)

type EnumMigrationMethod string

const (
	EnumMigrationMethodDump        EnumMigrationMethod = "dump"
	EnumMigrationMethodReplication EnumMigrationMethod = "replication"
)

type EnumMigrationStatus string

const (
	EnumMigrationStatusRunning EnumMigrationStatus = "running"
	EnumMigrationStatusSyncing EnumMigrationStatus = "syncing"
	EnumMigrationStatusFailed  EnumMigrationStatus = "failed"
	EnumMigrationStatusDone    EnumMigrationStatus = "done"
)

type EnumMysqlAuthenticationPlugin string

const (
	EnumMysqlAuthenticationPluginCachingSha2Password EnumMysqlAuthenticationPlugin = "caching_sha2_password"
	EnumMysqlAuthenticationPluginMysqlNativePassword EnumMysqlAuthenticationPlugin = "mysql_native_password"
)

type EnumOpensearchRulePermission string

const (
	EnumOpensearchRulePermissionAdmin     EnumOpensearchRulePermission = "admin"
	EnumOpensearchRulePermissionRead      EnumOpensearchRulePermission = "read"
	EnumOpensearchRulePermissionDeny      EnumOpensearchRulePermission = "deny"
	EnumOpensearchRulePermissionReadwrite EnumOpensearchRulePermission = "readwrite"
	EnumOpensearchRulePermissionWrite     EnumOpensearchRulePermission = "write"
)

type EnumPGPoolMode string

const (
	EnumPGPoolModeTransaction EnumPGPoolMode = "transaction"
	EnumPGPoolModeStatement   EnumPGPoolMode = "statement"
	EnumPGPoolModeSession     EnumPGPoolMode = "session"
)

type EnumPGSynchronousReplication string

const (
	EnumPGSynchronousReplicationQuorum EnumPGSynchronousReplication = "quorum"
	EnumPGSynchronousReplicationOff    EnumPGSynchronousReplication = "off"
)

type EnumPGVariant string

const (
	EnumPGVariantTimescale EnumPGVariant = "timescale"
	EnumPGVariantAiven     EnumPGVariant = "aiven"
)

type EnumRsyslogFormat string

const (
	EnumRsyslogFormatCustom  EnumRsyslogFormat = "custom"
	EnumRsyslogFormatRfc3164 EnumRsyslogFormat = "rfc3164"
	EnumRsyslogFormatRfc5424 EnumRsyslogFormat = "rfc5424"
)

type EnumServiceState string

const (
	EnumServiceStateRunning     EnumServiceState = "running"
	EnumServiceStateRebuilding  EnumServiceState = "rebuilding"
	EnumServiceStateRebalancing EnumServiceState = "rebalancing"
	EnumServiceStatePoweroff    EnumServiceState = "poweroff"
)

type EnumSortOrder string

const (
	EnumSortOrderDesc EnumSortOrder = "desc"
	EnumSortOrderAsc  EnumSortOrder = "asc"
)

// A notable Mutation Event which happened on the infrastructure
type Event struct {
	// Body parameters (free form map)
	BodyParams map[string]any `json:"body-params,omitempty"`
	// Operation processing time
	ElapsedMS int64 `json:"elapsed-ms,omitempty" validate:"omitempty,gt=0"`
	// Query string parameters (free form map)
	GetParams map[string]any `json:"get-params,omitempty"`
	// Operation handler name
	Handler string `json:"handler,omitempty"`
	// IAM API Key
	IAMAPIKey *IAMAPIKey `json:"iam-api-key,omitempty"`
	// IAM Role
	IAMRole *IAMRole `json:"iam-role,omitempty"`
	// User
	IAMUser *User `json:"iam-user,omitempty"`
	// Operation message
	Message string `json:"message,omitempty"`
	// URI path parameters (free form map)
	PathParams map[string]any `json:"path-params,omitempty"`
	// Operation unique identifier
	RequestID string `json:"request-id,omitempty"`
	// Client IP address
	SourceIP string `json:"source-ip,omitempty"`
	// Operation HTTP status
	Status int64 `json:"status,omitempty" validate:"omitempty,gt=0"`
	// Time at which the event happened, millisecond resolution
	Timestamp time.Time `json:"timestamp,omitempty"`
	// Operation request URI
	URI string `json:"uri,omitempty"`
	// Operation targeted zone
	Zone string `json:"zone,omitempty"`
}

// IAM API Key
type IAMAPIKey struct {
	// IAM API Key
	Key string `json:"key,omitempty"`
	// IAM API Key name
	Name string `json:"name,omitempty"`
	// IAM API Key Role ID
	RoleID UUID `json:"role-id,omitempty"`
}

// IAM API Key
type IAMAPIKeyCreated struct {
	// IAM API Key
	Key string `json:"key,omitempty"`
	// IAM API Key name
	Name string `json:"name,omitempty"`
	// IAM API Key Role ID
	RoleID UUID `json:"role-id,omitempty"`
	// IAM API Key Secret
	Secret string `json:"secret,omitempty"`
}

type IAMPolicyDefaultServiceStrategy string

const (
	IAMPolicyDefaultServiceStrategyAllow IAMPolicyDefaultServiceStrategy = "allow"
	IAMPolicyDefaultServiceStrategyDeny  IAMPolicyDefaultServiceStrategy = "deny"
)

// Policy
type IAMPolicy struct {
	// IAM default service strategy
	DefaultServiceStrategy IAMPolicyDefaultServiceStrategy `json:"default-service-strategy" validate:"required"`
	// IAM services
	Services map[string]IAMServicePolicy `json:"services" validate:"required"`
}

// IAM Role
type IAMRole struct {
	// IAM Role description
	Description string `json:"description,omitempty" validate:"omitempty,gte=1,lte=255"`
	// IAM Role mutability
	Editable *bool `json:"editable,omitempty"`
	// IAM Role ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// IAM Role name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// IAM Role permissions
	Permissions []string `json:"permissions,omitempty"`
	// Policy
	Policy *IAMPolicy `json:"policy,omitempty"`
}

type IAMServicePolicyType string

const (
	IAMServicePolicyTypeRules IAMServicePolicyType = "rules"
	IAMServicePolicyTypeAllow IAMServicePolicyType = "allow"
	IAMServicePolicyTypeDeny  IAMServicePolicyType = "deny"
)

type IAMServicePolicy struct {
	Rules []IAMServicePolicyRule `json:"rules,omitempty"`
	Type  IAMServicePolicyType   `json:"type,omitempty"`
}

type IAMServicePolicyRuleAction string

const (
	IAMServicePolicyRuleActionAllow IAMServicePolicyRuleAction = "allow"
	IAMServicePolicyRuleActionDeny  IAMServicePolicyRuleAction = "deny"
)

type IAMServicePolicyRule struct {
	Action     IAMServicePolicyRuleAction `json:"action,omitempty"`
	Expression string                     `json:"expression,omitempty"`
	Resources  []string                   `json:"resources,omitempty"`
}

// Private Network
type InstancePrivateNetworks struct {
	// Private Network ID
	ID UUID `json:"id,omitempty"`
	// Private Network MAC address
	MACAddress string `json:"mac-address,omitempty"`
}

// Instance
type Instance struct {
	// Instance Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Instance creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Instance disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Instance Elastic IPs
	ElasticIPS []ElasticIP `json:"elastic-ips,omitempty"`
	// Instance ID
	ID UUID `json:"id,omitempty"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Instance IPv6 address
	Ipv6Address string `json:"ipv6-address,omitempty"`
	Labels      Labels `json:"labels,omitempty"`
	// Instance MAC address
	MACAddress string `json:"mac-address,omitempty"`
	// Resource manager
	Manager *Manager `json:"manager,omitempty"`
	// Instance name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instance Private Networks
	PrivateNetworks []InstancePrivateNetworks `json:"private-networks,omitempty"`
	// Instance public IPv4 address
	PublicIP           net.IP             `json:"public-ip,omitempty"`
	PublicIPAssignment PublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Indicates if the instance has secure boot enabled
	SecurebootEnabled *bool `json:"secureboot-enabled,omitempty"`
	// Instance Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Instance Snapshots
	Snapshots []Snapshot `json:"snapshots,omitempty"`
	// SSH key
	SSHKey *SSHKey `json:"ssh-key,omitempty"`
	// Instance SSH Keys
	SSHKeys []SSHKey      `json:"ssh-keys,omitempty"`
	State   InstanceState `json:"state,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Indicates if the instance has tpm enabled
	TpmEnabled *bool `json:"tpm-enabled,omitempty"`
	// Instance Cloud-init user-data (base64 encoded)
	UserData string `json:"user-data,omitempty" validate:"omitempty,gte=1"`
}

// Instance password
type InstancePassword struct {
	// Password
	Password string `json:"password,omitempty"`
}

type InstancePoolState string

const (
	InstancePoolStateScalingUP   InstancePoolState = "scaling-up"
	InstancePoolStateScalingDown InstancePoolState = "scaling-down"
	InstancePoolStateDestroying  InstancePoolState = "destroying"
	InstancePoolStateCreating    InstancePoolState = "creating"
	InstancePoolStateSuspended   InstancePoolState = "suspended"
	InstancePoolStateRunning     InstancePoolState = "running"
	InstancePoolStateUpdating    InstancePoolState = "updating"
)

// Instance Pool
type InstancePool struct {
	// Instance Pool Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Instance Pool description
	Description string `json:"description,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instances disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Instances Elastic IPs
	ElasticIPS []ElasticIP `json:"elastic-ips,omitempty"`
	// Instance Pool ID
	ID UUID `json:"id,omitempty"`
	// The instances created by the Instance Pool will be prefixed with this value (default: pool)
	InstancePrefix string `json:"instance-prefix,omitempty" validate:"omitempty,gte=1,lte=30"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Instances
	Instances []Instance `json:"instances,omitempty"`
	// Enable IPv6 for instances
	Ipv6Enabled *bool  `json:"ipv6-enabled,omitempty"`
	Labels      Labels `json:"labels,omitempty"`
	// Resource manager
	Manager *Manager `json:"manager,omitempty"`
	// Minimum number of running instances
	MinAvailable int64 `json:"min-available,omitempty" validate:"omitempty,gte=0"`
	// Instance Pool name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Instance Pool Private Networks
	PrivateNetworks    []PrivateNetwork   `json:"private-networks,omitempty"`
	PublicIPAssignment PublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Instance Pool Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Number of instances
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// SSH key
	SSHKey *SSHKey `json:"ssh-key,omitempty"`
	// Instances SSH keys
	SSHKeys []SSHKey `json:"ssh-keys,omitempty"`
	// Instance Pool state
	State InstancePoolState `json:"state,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Instances Cloud-init user-data
	UserData string `json:"user-data,omitempty" validate:"omitempty,gte=1"`
}

type InstanceState string

const (
	InstanceStateExpunging  InstanceState = "expunging"
	InstanceStateStarting   InstanceState = "starting"
	InstanceStateDestroying InstanceState = "destroying"
	InstanceStateRunning    InstanceState = "running"
	InstanceStateStopping   InstanceState = "stopping"
	InstanceStateStopped    InstanceState = "stopped"
	InstanceStateMigrating  InstanceState = "migrating"
	InstanceStateError      InstanceState = "error"
	InstanceStateDestroyed  InstanceState = "destroyed"
)

// Target Instance
type InstanceTarget struct {
	// Instance ID
	ID UUID `json:"id,omitempty"`
}

type InstanceTypeFamily string

const (
	InstanceTypeFamilyGpu3      InstanceTypeFamily = "gpu3"
	InstanceTypeFamilyGpua30    InstanceTypeFamily = "gpua30"
	InstanceTypeFamilyGpu3080ti InstanceTypeFamily = "gpu3080ti"
	InstanceTypeFamilyGpu2      InstanceTypeFamily = "gpu2"
	InstanceTypeFamilyGpu       InstanceTypeFamily = "gpu"
	InstanceTypeFamilyMemory    InstanceTypeFamily = "memory"
	InstanceTypeFamilyGpua5000  InstanceTypeFamily = "gpua5000"
	InstanceTypeFamilyStorage   InstanceTypeFamily = "storage"
	InstanceTypeFamilyStandard  InstanceTypeFamily = "standard"
	InstanceTypeFamilyColossus  InstanceTypeFamily = "colossus"
	InstanceTypeFamilyCPU       InstanceTypeFamily = "cpu"
)

type InstanceTypeSize string

const (
	InstanceTypeSizeLarge      InstanceTypeSize = "large"
	InstanceTypeSizeHuge       InstanceTypeSize = "huge"
	InstanceTypeSizeJumbo      InstanceTypeSize = "jumbo"
	InstanceTypeSizeMedium     InstanceTypeSize = "medium"
	InstanceTypeSizeMega       InstanceTypeSize = "mega"
	InstanceTypeSizeSmall      InstanceTypeSize = "small"
	InstanceTypeSizeExtraLarge InstanceTypeSize = "extra-large"
	InstanceTypeSizeTitan      InstanceTypeSize = "titan"
	InstanceTypeSizeMicro      InstanceTypeSize = "micro"
	InstanceTypeSizeColossus   InstanceTypeSize = "colossus"
	InstanceTypeSizeTiny       InstanceTypeSize = "tiny"
)

// Compute instance type
type InstanceType struct {
	// Requires authorization or publicly available
	Authorized *bool `json:"authorized,omitempty"`
	// CPU count
	Cpus int64 `json:"cpus,omitempty" validate:"omitempty,gt=0"`
	// Instance type family
	Family InstanceTypeFamily `json:"family,omitempty"`
	// GPU count
	Gpus int64 `json:"gpus,omitempty" validate:"omitempty,gt=0"`
	// Instance type ID
	ID UUID `json:"id,omitempty"`
	// Available memory
	Memory int64 `json:"memory,omitempty" validate:"omitempty,gt=0"`
	// Instance type size
	Size InstanceTypeSize `json:"size,omitempty"`
	// Instance Type available zones
	Zones []ZoneName `json:"zones,omitempty"`
}

type JSONSchemaGrafanaAlertingErrorORTimeout string

const (
	JSONSchemaGrafanaAlertingErrorORTimeoutAlerting  JSONSchemaGrafanaAlertingErrorORTimeout = "alerting"
	JSONSchemaGrafanaAlertingErrorORTimeoutKeepState JSONSchemaGrafanaAlertingErrorORTimeout = "keep_state"
)

type JSONSchemaGrafanaAlertingNodataORNullvalues string

const (
	JSONSchemaGrafanaAlertingNodataORNullvaluesAlerting  JSONSchemaGrafanaAlertingNodataORNullvalues = "alerting"
	JSONSchemaGrafanaAlertingNodataORNullvaluesNOData    JSONSchemaGrafanaAlertingNodataORNullvalues = "no_data"
	JSONSchemaGrafanaAlertingNodataORNullvaluesKeepState JSONSchemaGrafanaAlertingNodataORNullvalues = "keep_state"
	JSONSchemaGrafanaAlertingNodataORNullvaluesOk        JSONSchemaGrafanaAlertingNodataORNullvalues = "ok"
)

// Azure AD OAuth integration
type JSONSchemaGrafanaAuthAzuread struct {
	// Automatically sign-up users on successful sign-in
	AllowSignUP *bool `json:"allow_sign_up,omitempty"`
	// Allowed domains
	AllowedDomains []string `json:"allowed_domains,omitempty"`
	// Require users to belong to one of given groups
	AllowedGroups []string `json:"allowed_groups,omitempty"`
	// Authorization URL
	AuthURL string `json:"auth_url" validate:"required,lte=2048"`
	// Client ID from provider
	ClientID string `json:"client_id" validate:"required,lte=1024"`
	// Client secret from provider
	ClientSecret string `json:"client_secret" validate:"required,lte=1024"`
	// Token URL
	TokenURL string `json:"token_url" validate:"required,lte=2048"`
}

// Generic OAuth integration
type JSONSchemaGrafanaAuthGenericOauth struct {
	// Automatically sign-up users on successful sign-in
	AllowSignUP *bool `json:"allow_sign_up,omitempty"`
	// Allowed domains
	AllowedDomains []string `json:"allowed_domains,omitempty"`
	// Require user to be member of one of the listed organizations
	AllowedOrganizations []string `json:"allowed_organizations,omitempty"`
	// API URL
	APIURL string `json:"api_url" validate:"required,lte=2048"`
	// Authorization URL
	AuthURL string `json:"auth_url" validate:"required,lte=2048"`
	// Allow users to bypass the login screen and automatically log in
	AutoLogin *bool `json:"auto_login,omitempty"`
	// Client ID from provider
	ClientID string `json:"client_id" validate:"required,lte=1024"`
	// Client secret from provider
	ClientSecret string `json:"client_secret" validate:"required,lte=1024"`
	// Name of the OAuth integration
	Name string `json:"name,omitempty" validate:"omitempty,lte=128"`
	// OAuth scopes
	Scopes []string `json:"scopes,omitempty"`
	// Token URL
	TokenURL string `json:"token_url" validate:"required,lte=2048"`
}

// Github Auth integration
type JSONSchemaGrafanaAuthGithub struct {
	// Automatically sign-up users on successful sign-in
	AllowSignUP *bool `json:"allow_sign_up,omitempty"`
	// Require users to belong to one of given organizations
	AllowedOrganizations []string `json:"allowed_organizations,omitempty"`
	// Allow users to bypass the login screen and automatically log in
	AutoLogin *bool `json:"auto_login,omitempty"`
	// Client ID from provider
	ClientID string `json:"client_id" validate:"required,lte=1024"`
	// Client secret from provider
	ClientSecret string `json:"client_secret" validate:"required,lte=1024"`
	// Stop automatically syncing user roles
	SkipOrgRoleSync *bool `json:"skip_org_role_sync,omitempty"`
	// Require users to belong to one of given team IDs
	TeamIDS []int `json:"team_ids,omitempty"`
}

// GitLab Auth integration
type JSONSchemaGrafanaAuthGitlab struct {
	// Automatically sign-up users on successful sign-in
	AllowSignUP *bool `json:"allow_sign_up,omitempty"`
	// Require users to belong to one of given groups
	AllowedGroups []string `json:"allowed_groups" validate:"required"`
	// API URL. This only needs to be set when using self hosted GitLab
	APIURL string `json:"api_url,omitempty" validate:"omitempty,lte=2048"`
	// Authorization URL. This only needs to be set when using self hosted GitLab
	AuthURL string `json:"auth_url,omitempty" validate:"omitempty,lte=2048"`
	// Client ID from provider
	ClientID string `json:"client_id" validate:"required,lte=1024"`
	// Client secret from provider
	ClientSecret string `json:"client_secret" validate:"required,lte=1024"`
	// Token URL. This only needs to be set when using self hosted GitLab
	TokenURL string `json:"token_url,omitempty" validate:"omitempty,lte=2048"`
}

// Google Auth integration
type JSONSchemaGrafanaAuthGoogle struct {
	// Automatically sign-up users on successful sign-in
	AllowSignUP *bool `json:"allow_sign_up,omitempty"`
	// Domains allowed to sign-in to this Grafana
	AllowedDomains []string `json:"allowed_domains" validate:"required"`
	// Client ID from provider
	ClientID string `json:"client_id" validate:"required,lte=1024"`
	// Client secret from provider
	ClientSecret string `json:"client_secret" validate:"required,lte=1024"`
}

type JSONSchemaGrafanaCookieSamesite string

const (
	JSONSchemaGrafanaCookieSamesiteLax    JSONSchemaGrafanaCookieSamesite = "lax"
	JSONSchemaGrafanaCookieSamesiteStrict JSONSchemaGrafanaCookieSamesite = "strict"
	JSONSchemaGrafanaCookieSamesiteNone   JSONSchemaGrafanaCookieSamesite = "none"
)

// Grafana date format specifications
type JSONSchemaGrafanaDateFormats struct {
	// Default time zone for user preferences. Value 'browser' uses browser local time zone.
	DefaultTimezone string `json:"default_timezone,omitempty" validate:"omitempty,lte=64"`
	// Moment.js style format string for cases where full date is shown
	FullDate string `json:"full_date,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring day accuracy is shown
	IntervalDay string `json:"interval_day,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring hour accuracy is shown
	IntervalHour string `json:"interval_hour,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring minute accuracy is shown
	IntervalMinute string `json:"interval_minute,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring month accuracy is shown
	IntervalMonth string `json:"interval_month,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring second accuracy is shown
	IntervalSecond string `json:"interval_second,omitempty" validate:"omitempty,lte=128"`
	// Moment.js style format string used when a time requiring year accuracy is shown
	IntervalYear string `json:"interval_year,omitempty" validate:"omitempty,lte=128"`
}

type JSONSchemaGrafanaSMTPServerStarttlsPolicy string

const (
	JSONSchemaGrafanaSMTPServerStarttlsPolicyOpportunisticStartTLS JSONSchemaGrafanaSMTPServerStarttlsPolicy = "OpportunisticStartTLS"
	JSONSchemaGrafanaSMTPServerStarttlsPolicyMandatoryStartTLS     JSONSchemaGrafanaSMTPServerStarttlsPolicy = "MandatoryStartTLS"
	JSONSchemaGrafanaSMTPServerStarttlsPolicyNoStartTLS            JSONSchemaGrafanaSMTPServerStarttlsPolicy = "NoStartTLS"
)

// SMTP server settings
type JSONSchemaGrafanaSMTPServer struct {
	// Address used for sending emails
	FromAddress string `json:"from_address" validate:"required,lte=319"`
	// Name used in outgoing emails, defaults to Grafana
	FromName *string `json:"from_name,omitempty" validate:"omitempty,lte=128"`
	// Server hostname or IP
	Host string `json:"host" validate:"required,lte=255"`
	// Password for SMTP authentication
	Password *string `json:"password,omitempty" validate:"omitempty,lte=255"`
	// SMTP server port
	Port int `json:"port" validate:"required,gte=1,lte=65535"`
	// Skip verifying server certificate. Defaults to false
	SkipVerify *bool `json:"skip_verify,omitempty"`
	// Either OpportunisticStartTLS, MandatoryStartTLS or NoStartTLS. Default is OpportunisticStartTLS.
	StarttlsPolicy JSONSchemaGrafanaSMTPServerStarttlsPolicy `json:"starttls_policy,omitempty"`
	// Username for SMTP authentication
	Username *string `json:"username,omitempty" validate:"omitempty,lte=255"`
}

type JSONSchemaGrafanaUserAutoAssignOrgRole string

const (
	JSONSchemaGrafanaUserAutoAssignOrgRoleViewer JSONSchemaGrafanaUserAutoAssignOrgRole = "Viewer"
	JSONSchemaGrafanaUserAutoAssignOrgRoleAdmin  JSONSchemaGrafanaUserAutoAssignOrgRole = "Admin"
	JSONSchemaGrafanaUserAutoAssignOrgRoleEditor JSONSchemaGrafanaUserAutoAssignOrgRole = "Editor"
)

// Grafana settings
type JSONSchemaGrafana struct {
	// Enable or disable Grafana legacy alerting functionality. This should not be enabled with unified_alerting_enabled.
	AlertingEnabled *bool `json:"alerting_enabled,omitempty"`
	// Default error or timeout setting for new alerting rules
	AlertingErrorORTimeout JSONSchemaGrafanaAlertingErrorORTimeout `json:"alerting_error_or_timeout,omitempty"`
	// Max number of alert annotations that Grafana stores. 0 (default) keeps all alert annotations.
	AlertingMaxAnnotationsToKeep int `json:"alerting_max_annotations_to_keep,omitempty" validate:"omitempty,gte=0,lte=1e+06"`
	// Default value for 'no data or null values' for new alerting rules
	AlertingNodataORNullvalues JSONSchemaGrafanaAlertingNodataORNullvalues `json:"alerting_nodata_or_nullvalues,omitempty"`
	// Allow embedding Grafana dashboards with iframe/frame/object/embed tags. Disabled by default to limit impact of clickjacking
	AllowEmbedding *bool `json:"allow_embedding,omitempty"`
	// Azure AD OAuth integration
	AuthAzuread *JSONSchemaGrafanaAuthAzuread `json:"auth_azuread,omitempty"`
	// Enable or disable basic authentication form, used by Grafana built-in login
	AuthBasicEnabled *bool `json:"auth_basic_enabled,omitempty"`
	// Generic OAuth integration
	AuthGenericOauth *JSONSchemaGrafanaAuthGenericOauth `json:"auth_generic_oauth,omitempty"`
	// Github Auth integration
	AuthGithub *JSONSchemaGrafanaAuthGithub `json:"auth_github,omitempty"`
	// GitLab Auth integration
	AuthGitlab *JSONSchemaGrafanaAuthGitlab `json:"auth_gitlab,omitempty"`
	// Google Auth integration
	AuthGoogle *JSONSchemaGrafanaAuthGoogle `json:"auth_google,omitempty"`
	// Cookie SameSite attribute: 'strict' prevents sending cookie for cross-site requests, effectively disabling direct linking from other sites to Grafana. 'lax' is the default value.
	CookieSamesite JSONSchemaGrafanaCookieSamesite `json:"cookie_samesite,omitempty"`
	// Serve the web frontend using a custom CNAME pointing to the Aiven DNS name
	CustomDomain *string `json:"custom_domain,omitempty" validate:"omitempty,lte=255"`
	// This feature is new in Grafana 9 and is quite resource intensive. It may cause low-end plans to work more slowly while the dashboard previews are rendering.
	DashboardPreviewsEnabled *bool `json:"dashboard_previews_enabled,omitempty"`
	// Signed sequence of decimal numbers, followed by a unit suffix (ms, s, m, h, d), e.g. 30s, 1h
	DashboardsMinRefreshInterval string `json:"dashboards_min_refresh_interval,omitempty" validate:"omitempty,lte=16"`
	// Dashboard versions to keep per dashboard
	DashboardsVersionsToKeep int `json:"dashboards_versions_to_keep,omitempty" validate:"omitempty,gte=1,lte=100"`
	// Send 'X-Grafana-User' header to data source
	DataproxySendUserHeader *bool `json:"dataproxy_send_user_header,omitempty"`
	// Timeout for data proxy requests in seconds
	DataproxyTimeout int `json:"dataproxy_timeout,omitempty" validate:"omitempty,gte=15,lte=90"`
	// Grafana date format specifications
	DateFormats *JSONSchemaGrafanaDateFormats `json:"date_formats,omitempty"`
	// Set to true to disable gravatar. Defaults to false (gravatar is enabled)
	DisableGravatar *bool `json:"disable_gravatar,omitempty"`
	// Editors can manage folders, teams and dashboards created by them
	EditorsCanAdmin *bool `json:"editors_can_admin,omitempty"`
	// Google Analytics ID
	GoogleAnalyticsUAID string `json:"google_analytics_ua_id,omitempty" validate:"omitempty,lte=64"`
	// Enable Grafana /metrics endpoint
	MetricsEnabled *bool `json:"metrics_enabled,omitempty"`
	// Enforce user lookup based on email instead of the unique ID provided by the IdP
	OauthAllowInsecureEmailLookup *bool `json:"oauth_allow_insecure_email_lookup,omitempty"`
	// Store logs for the service so that they are available in the HTTP API and console.
	ServiceLog *bool `json:"service_log,omitempty"`
	// SMTP server settings
	SMTPServer *JSONSchemaGrafanaSMTPServer `json:"smtp_server,omitempty"`
	// Enable or disable Grafana unified alerting functionality. By default this is enabled and any legacy alerts will be migrated on upgrade to Grafana 9+. To stay on legacy alerting, set unified_alerting_enabled to false and alerting_enabled to true. See https://grafana.com/docs/grafana/latest/alerting/set-up/migrating-alerts/ for more details.
	UnifiedAlertingEnabled *bool `json:"unified_alerting_enabled,omitempty"`
	// Auto-assign new users on signup to main organization. Defaults to false
	UserAutoAssignOrg *bool `json:"user_auto_assign_org,omitempty"`
	// Set role for new signups. Defaults to Viewer
	UserAutoAssignOrgRole JSONSchemaGrafanaUserAutoAssignOrgRole `json:"user_auto_assign_org_role,omitempty"`
	// Users with view-only permission can edit but not save dashboards
	ViewersCanEdit *bool `json:"viewers_can_edit,omitempty"`
	// Setting to enable/disable Write-Ahead Logging. The default value is false (disabled).
	Wal *bool `json:"wal,omitempty"`
}

type JSONSchemaKafkaCompressionType string

const (
	JSONSchemaKafkaCompressionTypeGzip         JSONSchemaKafkaCompressionType = "gzip"
	JSONSchemaKafkaCompressionTypeSnappy       JSONSchemaKafkaCompressionType = "snappy"
	JSONSchemaKafkaCompressionTypeLz4          JSONSchemaKafkaCompressionType = "lz4"
	JSONSchemaKafkaCompressionTypeZstd         JSONSchemaKafkaCompressionType = "zstd"
	JSONSchemaKafkaCompressionTypeUncompressed JSONSchemaKafkaCompressionType = "uncompressed"
	JSONSchemaKafkaCompressionTypeProducer     JSONSchemaKafkaCompressionType = "producer"
)

// Configure log cleaner for topic compaction
type JSONSchemaKafkaLogCleanupAndCompaction struct {
	// How long are delete records retained?
	LogCleanerDeleteRetentionMS int `json:"log_cleaner_delete_retention_ms,omitempty" validate:"omitempty,gte=0,lte=3.1556926e+11"`
	// The maximum amount of time message will remain uncompacted. Only applicable for logs that are being compacted
	LogCleanerMaxCompactionLagMS int `json:"log_cleaner_max_compaction_lag_ms,omitempty" validate:"omitempty,gte=30000,lte=9.223372036854776e+18"`
	// Controls log compactor frequency. Larger value means more frequent compactions but also more space wasted for logs. Consider setting log.cleaner.max.compaction.lag.ms to enforce compactions sooner, instead of setting a very high value for this option.
	LogCleanerMinCleanableRatio float64 `json:"log_cleaner_min_cleanable_ratio,omitempty" validate:"omitempty,gte=0.2,lte=0.9"`
	// The minimum time a message will remain uncompacted in the log. Only applicable for logs that are being compacted.
	LogCleanerMinCompactionLagMS int `json:"log_cleaner_min_compaction_lag_ms,omitempty" validate:"omitempty,gte=0,lte=9.223372036854776e+18"`
	// The default cleanup policy for segments beyond the retention window
	LogCleanupPolicy string `json:"log_cleanup_policy,omitempty"`
}

type JSONSchemaKafkaLogMessageTimestampType string

const (
	JSONSchemaKafkaLogMessageTimestampTypeCreateTime    JSONSchemaKafkaLogMessageTimestampType = "CreateTime"
	JSONSchemaKafkaLogMessageTimestampTypeLogAppendTime JSONSchemaKafkaLogMessageTimestampType = "LogAppendTime"
)

// Kafka broker configuration values
type JSONSchemaKafka struct {
	// Enable auto creation of topics
	AutoCreateTopicsEnable *bool `json:"auto_create_topics_enable,omitempty"`
	// Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.
	CompressionType JSONSchemaKafkaCompressionType `json:"compression_type,omitempty"`
	// Idle connections timeout: the server socket processor threads close the connections that idle for longer than this.
	ConnectionsMaxIdleMS int `json:"connections_max_idle_ms,omitempty" validate:"omitempty,gte=1000,lte=3.6e+06"`
	// Replication factor for autocreated topics
	DefaultReplicationFactor int `json:"default_replication_factor,omitempty" validate:"omitempty,gte=1,lte=10"`
	// The amount of time, in milliseconds, the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins. The default value for this is 3 seconds. During development and testing it might be desirable to set this to 0 in order to not delay test execution time.
	GroupInitialRebalanceDelayMS int `json:"group_initial_rebalance_delay_ms,omitempty" validate:"omitempty,gte=0,lte=300000"`
	// The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
	GroupMaxSessionTimeoutMS int `json:"group_max_session_timeout_ms,omitempty" validate:"omitempty,gte=0,lte=1.8e+06"`
	// The minimum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.
	GroupMinSessionTimeoutMS int `json:"group_min_session_timeout_ms,omitempty" validate:"omitempty,gte=0,lte=60000"`
	// Configure log cleaner for topic compaction
	LogCleanupAndCompaction *JSONSchemaKafkaLogCleanupAndCompaction `json:"log-cleanup-and-compaction,omitempty"`
	// The number of messages accumulated on a log partition before messages are flushed to disk
	LogFlushIntervalMessages int `json:"log_flush_interval_messages,omitempty" validate:"omitempty,gte=1,lte=9.223372036854776e+18"`
	// The maximum time in ms that a message in any topic is kept in memory before flushed to disk. If not set, the value in log.flush.scheduler.interval.ms is used
	LogFlushIntervalMS int `json:"log_flush_interval_ms,omitempty" validate:"omitempty,gte=0,lte=9.223372036854776e+18"`
	// The interval with which Kafka adds an entry to the offset index
	LogIndexIntervalBytes int `json:"log_index_interval_bytes,omitempty" validate:"omitempty,gte=0,lte=1.048576e+08"`
	// The maximum size in bytes of the offset index
	LogIndexSizeMaxBytes int `json:"log_index_size_max_bytes,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.048576e+08"`
	// The maximum size of local log segments that can grow for a partition before it gets eligible for deletion. If set to -2, the value of log.retention.bytes is used. The effective value should always be less than or equal to log.retention.bytes value.
	LogLocalRetentionBytes int `json:"log_local_retention_bytes,omitempty" validate:"omitempty,gte=-2,lte=9.223372036854776e+18"`
	// The number of milliseconds to keep the local log segments before it gets eligible for deletion. If set to -2, the value of log.retention.ms is used. The effective value should always be less than or equal to log.retention.ms value.
	LogLocalRetentionMS int `json:"log_local_retention_ms,omitempty" validate:"omitempty,gte=-2,lte=9.223372036854776e+18"`
	// This configuration controls whether down-conversion of message formats is enabled to satisfy consume requests.
	LogMessageDownconversionEnable *bool `json:"log_message_downconversion_enable,omitempty"`
	// The maximum difference allowed between the timestamp when a broker receives a message and the timestamp specified in the message
	LogMessageTimestampDifferenceMaxMS int `json:"log_message_timestamp_difference_max_ms,omitempty" validate:"omitempty,gte=0,lte=9.223372036854776e+18"`
	// Define whether the timestamp in the message is message create time or log append time.
	LogMessageTimestampType JSONSchemaKafkaLogMessageTimestampType `json:"log_message_timestamp_type,omitempty"`
	// Should pre allocate file when create new segment?
	LogPreallocate *bool `json:"log_preallocate,omitempty"`
	// The maximum size of the log before deleting messages
	LogRetentionBytes int `json:"log_retention_bytes,omitempty" validate:"omitempty,gte=-1,lte=9.223372036854776e+18"`
	// The number of hours to keep a log file before deleting it
	LogRetentionHours int `json:"log_retention_hours,omitempty" validate:"omitempty,gte=-1,lte=2.147483647e+09"`
	// The number of milliseconds to keep a log file before deleting it (in milliseconds), If not set, the value in log.retention.minutes is used. If set to -1, no time limit is applied.
	LogRetentionMS int `json:"log_retention_ms,omitempty" validate:"omitempty,gte=-1,lte=9.223372036854776e+18"`
	// The maximum jitter to subtract from logRollTimeMillis (in milliseconds). If not set, the value in log.roll.jitter.hours is used
	LogRollJitterMS int `json:"log_roll_jitter_ms,omitempty" validate:"omitempty,gte=0,lte=9.223372036854776e+18"`
	// The maximum time before a new log segment is rolled out (in milliseconds).
	LogRollMS int `json:"log_roll_ms,omitempty" validate:"omitempty,gte=1,lte=9.223372036854776e+18"`
	// The maximum size of a single log file
	LogSegmentBytes int `json:"log_segment_bytes,omitempty" validate:"omitempty,gte=1.048576e+07,lte=1.073741824e+09"`
	// The amount of time to wait before deleting a file from the filesystem
	LogSegmentDeleteDelayMS int `json:"log_segment_delete_delay_ms,omitempty" validate:"omitempty,gte=0,lte=3.6e+06"`
	// The maximum number of connections allowed from each ip address (defaults to 2147483647).
	MaxConnectionsPerIP int `json:"max_connections_per_ip,omitempty" validate:"omitempty,gte=256,lte=2.147483647e+09"`
	// The maximum number of incremental fetch sessions that the broker will maintain.
	MaxIncrementalFetchSessionCacheSlots int `json:"max_incremental_fetch_session_cache_slots,omitempty" validate:"omitempty,gte=1000,lte=10000"`
	// The maximum size of message that the server can receive.
	MessageMaxBytes int `json:"message_max_bytes,omitempty" validate:"omitempty,gte=0,lte=1.000012e+08"`
	// When a producer sets acks to 'all' (or '-1'), min.insync.replicas specifies the minimum number of replicas that must acknowledge a write for the write to be considered successful.
	MinInsyncReplicas int `json:"min_insync_replicas,omitempty" validate:"omitempty,gte=1,lte=7"`
	// Number of partitions for autocreated topics
	NumPartitions int `json:"num_partitions,omitempty" validate:"omitempty,gte=1,lte=1000"`
	// Log retention window in minutes for offsets topic
	OffsetsRetentionMinutes int `json:"offsets_retention_minutes,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// The purge interval (in number of requests) of the producer request purgatory(defaults to 1000).
	ProducerPurgatoryPurgeIntervalRequests int `json:"producer_purgatory_purge_interval_requests,omitempty" validate:"omitempty,gte=10,lte=10000"`
	// The number of bytes of messages to attempt to fetch for each partition (defaults to 1048576). This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made.
	ReplicaFetchMaxBytes int `json:"replica_fetch_max_bytes,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.048576e+08"`
	// Maximum bytes expected for the entire fetch response (defaults to 10485760). Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum.
	ReplicaFetchResponseMaxBytes int `json:"replica_fetch_response_max_bytes,omitempty" validate:"omitempty,gte=1.048576e+07,lte=1.048576e+09"`
	// The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences.
	SaslOauthbearerExpectedAudience string `json:"sasl_oauthbearer_expected_audience,omitempty" validate:"omitempty,lte=128"`
	// Optional setting for the broker to use to verify that the JWT was created by the expected issuer.
	SaslOauthbearerExpectedIssuer string `json:"sasl_oauthbearer_expected_issuer,omitempty" validate:"omitempty,lte=128"`
	// OIDC JWKS endpoint URL. By setting this the SASL SSL OAuth2/OIDC authentication is enabled. See also other options for SASL OAuth2/OIDC.
	SaslOauthbearerJwksEndpointURL string `json:"sasl_oauthbearer_jwks_endpoint_url,omitempty" validate:"omitempty,lte=2048"`
	// Name of the scope from which to extract the subject claim from the JWT. Defaults to sub.
	SaslOauthbearerSubClaimName string `json:"sasl_oauthbearer_sub_claim_name,omitempty" validate:"omitempty,lte=128"`
	// The maximum number of bytes in a socket request (defaults to 104857600).
	SocketRequestMaxBytes int `json:"socket_request_max_bytes,omitempty" validate:"omitempty,gte=1.048576e+07,lte=2.097152e+08"`
	// Enable verification that checks that the partition has been added to the transaction before writing transactional records to the partition
	TransactionPartitionVerificationEnable *bool `json:"transaction_partition_verification_enable,omitempty"`
	// The interval at which to remove transactions that have expired due to transactional.id.expiration.ms passing (defaults to 3600000 (1 hour)).
	TransactionRemoveExpiredTransactionCleanupIntervalMS int `json:"transaction_remove_expired_transaction_cleanup_interval_ms,omitempty" validate:"omitempty,gte=600000,lte=3.6e+06"`
	// The transaction topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads (defaults to 104857600 (100 mebibytes)).
	TransactionStateLogSegmentBytes int `json:"transaction_state_log_segment_bytes,omitempty" validate:"omitempty,gte=1.048576e+06,lte=2.147483647e+09"`
}

type JSONSchemaKafkaConnectConnectorClientConfigOverridePolicy string

const (
	JSONSchemaKafkaConnectConnectorClientConfigOverridePolicyNone JSONSchemaKafkaConnectConnectorClientConfigOverridePolicy = "None"
	JSONSchemaKafkaConnectConnectorClientConfigOverridePolicyAll  JSONSchemaKafkaConnectConnectorClientConfigOverridePolicy = "All"
)

type JSONSchemaKafkaConnectConsumerAutoOffsetReset string

const (
	JSONSchemaKafkaConnectConsumerAutoOffsetResetEarliest JSONSchemaKafkaConnectConsumerAutoOffsetReset = "earliest"
	JSONSchemaKafkaConnectConsumerAutoOffsetResetLatest   JSONSchemaKafkaConnectConsumerAutoOffsetReset = "latest"
)

type JSONSchemaKafkaConnectConsumerIsolationLevel string

const (
	JSONSchemaKafkaConnectConsumerIsolationLevelReadUncommitted JSONSchemaKafkaConnectConsumerIsolationLevel = "read_uncommitted"
	JSONSchemaKafkaConnectConsumerIsolationLevelReadCommitted   JSONSchemaKafkaConnectConsumerIsolationLevel = "read_committed"
)

type JSONSchemaKafkaConnectProducerCompressionType string

const (
	JSONSchemaKafkaConnectProducerCompressionTypeGzip   JSONSchemaKafkaConnectProducerCompressionType = "gzip"
	JSONSchemaKafkaConnectProducerCompressionTypeSnappy JSONSchemaKafkaConnectProducerCompressionType = "snappy"
	JSONSchemaKafkaConnectProducerCompressionTypeLz4    JSONSchemaKafkaConnectProducerCompressionType = "lz4"
	JSONSchemaKafkaConnectProducerCompressionTypeZstd   JSONSchemaKafkaConnectProducerCompressionType = "zstd"
	JSONSchemaKafkaConnectProducerCompressionTypeNone   JSONSchemaKafkaConnectProducerCompressionType = "none"
)

// Kafka Connect configuration values
type JSONSchemaKafkaConnect struct {
	// Defines what client configurations can be overridden by the connector. Default is None
	ConnectorClientConfigOverridePolicy JSONSchemaKafkaConnectConnectorClientConfigOverridePolicy `json:"connector_client_config_override_policy,omitempty"`
	// What to do when there is no initial offset in Kafka or if the current offset does not exist any more on the server. Default is earliest
	ConsumerAutoOffsetReset JSONSchemaKafkaConnectConsumerAutoOffsetReset `json:"consumer_auto_offset_reset,omitempty"`
	// Records are fetched in batches by the consumer, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that the consumer can make progress. As such, this is not a absolute maximum.
	ConsumerFetchMaxBytes int `json:"consumer_fetch_max_bytes,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.048576e+08"`
	// Transaction read isolation level. read_uncommitted is the default, but read_committed can be used if consume-exactly-once behavior is desired.
	ConsumerIsolationLevel JSONSchemaKafkaConnectConsumerIsolationLevel `json:"consumer_isolation_level,omitempty"`
	// Records are fetched in batches by the consumer.If the first record batch in the first non-empty partition of the fetch is larger than this limit, the batch will still be returned to ensure that the consumer can make progress.
	ConsumerMaxPartitionFetchBytes int `json:"consumer_max_partition_fetch_bytes,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.048576e+08"`
	// The maximum delay in milliseconds between invocations of poll() when using consumer group management (defaults to 300000).
	ConsumerMaxPollIntervalMS int `json:"consumer_max_poll_interval_ms,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// The maximum number of records returned in a single call to poll() (defaults to 500).
	ConsumerMaxPollRecords int `json:"consumer_max_poll_records,omitempty" validate:"omitempty,gte=1,lte=10000"`
	// The interval at which to try committing offsets for tasks (defaults to 60000).
	OffsetFlushIntervalMS int `json:"offset_flush_interval_ms,omitempty" validate:"omitempty,gte=1,lte=1e+08"`
	// Maximum number of milliseconds to wait for records to flush and partition offset data to be committed to offset storage before cancelling the process and restoring the offset data to be committed in a future attempt (defaults to 5000).
	OffsetFlushTimeoutMS int `json:"offset_flush_timeout_ms,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// This setting gives the upper bound of the batch size to be sent. If there are fewer than this many bytes accumulated for this partition, the producer will 'linger' for the linger.ms time waiting for more records to show up. A batch size of zero will disable batching entirely (defaults to 16384).
	ProducerBatchSize int `json:"producer_batch_size,omitempty" validate:"omitempty,gte=0,lte=5.24288e+06"`
	// The total bytes of memory the producer can use to buffer records waiting to be sent to the broker (defaults to 33554432).
	ProducerBufferMemory int `json:"producer_buffer_memory,omitempty" validate:"omitempty,gte=5.24288e+06,lte=1.34217728e+08"`
	// Specify the default compression type for producers. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'none' which is the default and equivalent to no compression.
	ProducerCompressionType JSONSchemaKafkaConnectProducerCompressionType `json:"producer_compression_type,omitempty"`
	// This setting gives the upper bound on the delay for batching: once there is batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if there are fewer than this many bytes accumulated for this partition the producer will 'linger' for the specified time waiting for more records to show up. Defaults to 0.
	ProducerLingerMS int `json:"producer_linger_ms,omitempty" validate:"omitempty,gte=0,lte=5000"`
	// This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.
	ProducerMaxRequestSize int `json:"producer_max_request_size,omitempty" validate:"omitempty,gte=131072,lte=6.7108864e+07"`
	// The maximum delay that is scheduled in order to wait for the return of one or more departed workers before rebalancing and reassigning their connectors and tasks to the group. During this period the connectors and tasks of the departed workers remain unassigned. Defaults to 5 minutes.
	ScheduledRebalanceMaxDelayMS int `json:"scheduled_rebalance_max_delay_ms,omitempty" validate:"omitempty,gte=0,lte=600000"`
	// The timeout in milliseconds used to detect failures when using Kafka’s group management facilities (defaults to 10000).
	SessionTimeoutMS int `json:"session_timeout_ms,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
}

type JSONSchemaKafkaRestConsumerRequestTimeoutMS int

const (
	JSONSchemaKafkaRestConsumerRequestTimeoutMS1000  JSONSchemaKafkaRestConsumerRequestTimeoutMS = 1000
	JSONSchemaKafkaRestConsumerRequestTimeoutMS15000 JSONSchemaKafkaRestConsumerRequestTimeoutMS = 15000
	JSONSchemaKafkaRestConsumerRequestTimeoutMS30000 JSONSchemaKafkaRestConsumerRequestTimeoutMS = 30000
)

type JSONSchemaKafkaRestNameStrategy string

const (
	JSONSchemaKafkaRestNameStrategyTopicName       JSONSchemaKafkaRestNameStrategy = "topic_name"
	JSONSchemaKafkaRestNameStrategyRecordName      JSONSchemaKafkaRestNameStrategy = "record_name"
	JSONSchemaKafkaRestNameStrategyTopicRecordName JSONSchemaKafkaRestNameStrategy = "topic_record_name"
)

type JSONSchemaKafkaRestProducerCompressionType string

const (
	JSONSchemaKafkaRestProducerCompressionTypeGzip   JSONSchemaKafkaRestProducerCompressionType = "gzip"
	JSONSchemaKafkaRestProducerCompressionTypeSnappy JSONSchemaKafkaRestProducerCompressionType = "snappy"
	JSONSchemaKafkaRestProducerCompressionTypeLz4    JSONSchemaKafkaRestProducerCompressionType = "lz4"
	JSONSchemaKafkaRestProducerCompressionTypeZstd   JSONSchemaKafkaRestProducerCompressionType = "zstd"
	JSONSchemaKafkaRestProducerCompressionTypeNone   JSONSchemaKafkaRestProducerCompressionType = "none"
)

// Kafka REST configuration
type JSONSchemaKafkaRest struct {
	// If true the consumer's offset will be periodically committed to Kafka in the background
	ConsumerEnableAutoCommit *bool `json:"consumer_enable_auto_commit,omitempty"`
	// Maximum number of bytes in unencoded message keys and values by a single request
	ConsumerRequestMaxBytes int `json:"consumer_request_max_bytes,omitempty" validate:"omitempty,gte=0,lte=6.7108864e+08"`
	// The maximum total time to wait for messages for a request if the maximum number of messages has not yet been reached
	ConsumerRequestTimeoutMS JSONSchemaKafkaRestConsumerRequestTimeoutMS `json:"consumer_request_timeout_ms,omitempty"`
	// Name strategy to use when selecting subject for storing schemas
	NameStrategy JSONSchemaKafkaRestNameStrategy `json:"name_strategy,omitempty"`
	// If true, validate that given schema is registered under expected subject name by the used name strategy when producing messages.
	NameStrategyValidation *bool `json:"name_strategy_validation,omitempty"`
	// The number of acknowledgments the producer requires the leader to have received before considering a request complete. If set to 'all' or '-1', the leader will wait for the full set of in-sync replicas to acknowledge the record.
	ProducerAcks string `json:"producer_acks,omitempty"`
	// Specify the default compression type for producers. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'none' which is the default and equivalent to no compression.
	ProducerCompressionType JSONSchemaKafkaRestProducerCompressionType `json:"producer_compression_type,omitempty"`
	// Wait for up to the given delay to allow batching records together
	ProducerLingerMS int `json:"producer_linger_ms,omitempty" validate:"omitempty,gte=0,lte=5000"`
	// The maximum size of a request in bytes. Note that Kafka broker can also cap the record batch size.
	ProducerMaxRequestSize int `json:"producer_max_request_size,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// Maximum number of SimpleConsumers that can be instantiated per broker
	SimpleconsumerPoolSizeMax int `json:"simpleconsumer_pool_size_max,omitempty" validate:"omitempty,gte=10,lte=250"`
}

type JSONSchemaMysqlInternalTmpMemStorageEngine string

const (
	JSONSchemaMysqlInternalTmpMemStorageEngineTempTable JSONSchemaMysqlInternalTmpMemStorageEngine = "TempTable"
	JSONSchemaMysqlInternalTmpMemStorageEngineMEMORY    JSONSchemaMysqlInternalTmpMemStorageEngine = "MEMORY"
)

// mysql.conf configuration values
type JSONSchemaMysql struct {
	// The number of seconds that the mysqld server waits for a connect packet before responding with Bad handshake
	ConnectTimeout int `json:"connect_timeout,omitempty" validate:"omitempty,gte=2,lte=3600"`
	// Default server time zone as an offset from UTC (from -12:00 to +12:00), a time zone name, or 'SYSTEM' to use the MySQL server default.
	DefaultTimeZone string `json:"default_time_zone,omitempty" validate:"omitempty,gte=2,lte=100"`
	// The maximum permitted result length in bytes for the GROUP_CONCAT() function.
	GroupConcatMaxLen int `json:"group_concat_max_len,omitempty" validate:"omitempty,gte=4,lte=1.8446744073709552e+19"`
	// The time, in seconds, before cached statistics expire
	InformationSchemaStatsExpiry int `json:"information_schema_stats_expiry,omitempty" validate:"omitempty,gte=900,lte=3.1536e+07"`
	// Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool. Default is 25
	InnodbChangeBufferMaxSize int `json:"innodb_change_buffer_max_size,omitempty" validate:"omitempty,gte=0,lte=50"`
	// Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent (default is 1): 0 - dirty pages in the same extent are not flushed, 1 - flush contiguous dirty pages in the same extent, 2 - flush dirty pages in the same extent
	InnodbFlushNeighbors int `json:"innodb_flush_neighbors,omitempty" validate:"omitempty,gte=0,lte=2"`
	// Minimum length of words that are stored in an InnoDB FULLTEXT index. Changing this parameter will lead to a restart of the MySQL service.
	InnodbFTMinTokenSize int `json:"innodb_ft_min_token_size,omitempty" validate:"omitempty,gte=0,lte=16"`
	// This option is used to specify your own InnoDB FULLTEXT index stopword list for all InnoDB tables.
	InnodbFTServerStopwordTable *string `json:"innodb_ft_server_stopword_table,omitempty" validate:"omitempty,lte=1024"`
	// The length of time in seconds an InnoDB transaction waits for a row lock before giving up. Default is 120.
	InnodbLockWaitTimeout int `json:"innodb_lock_wait_timeout,omitempty" validate:"omitempty,gte=1,lte=3600"`
	// The size in bytes of the buffer that InnoDB uses to write to the log files on disk.
	InnodbLogBufferSize int `json:"innodb_log_buffer_size,omitempty" validate:"omitempty,gte=1.048576e+06,lte=4.294967295e+09"`
	// The upper limit in bytes on the size of the temporary log files used during online DDL operations for InnoDB tables.
	InnodbOnlineAlterLogMaxSize int `json:"innodb_online_alter_log_max_size,omitempty" validate:"omitempty,gte=65536,lte=1.099511627776e+12"`
	// When enabled, information about all deadlocks in InnoDB user transactions is recorded in the error log. Disabled by default.
	InnodbPrintAllDeadlocks *bool `json:"innodb_print_all_deadlocks,omitempty"`
	// The number of I/O threads for read operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
	InnodbReadIoThreads int `json:"innodb_read_io_threads,omitempty" validate:"omitempty,gte=1,lte=64"`
	// When enabled a transaction timeout causes InnoDB to abort and roll back the entire transaction. Changing this parameter will lead to a restart of the MySQL service.
	InnodbRollbackOnTimeout *bool `json:"innodb_rollback_on_timeout,omitempty"`
	// Defines the maximum number of threads permitted inside of InnoDB. Default is 0 (infinite concurrency - no limit)
	InnodbThreadConcurrency int `json:"innodb_thread_concurrency,omitempty" validate:"omitempty,gte=0,lte=1000"`
	// The number of I/O threads for write operations in InnoDB. Default is 4. Changing this parameter will lead to a restart of the MySQL service.
	InnodbWriteIoThreads int `json:"innodb_write_io_threads,omitempty" validate:"omitempty,gte=1,lte=64"`
	// The number of seconds the server waits for activity on an interactive connection before closing it.
	InteractiveTimeout int `json:"interactive_timeout,omitempty" validate:"omitempty,gte=30,lte=604800"`
	// The storage engine for in-memory internal temporary tables.
	InternalTmpMemStorageEngine JSONSchemaMysqlInternalTmpMemStorageEngine `json:"internal_tmp_mem_storage_engine,omitempty"`
	// The slow log output destination when slow_query_log is ON. To enable MySQL AI Insights, choose INSIGHTS. To use MySQL AI Insights and the mysql.slow_log table at the same time, choose INSIGHTS,TABLE. To only use the mysql.slow_log table, choose TABLE. To silence slow logs, choose NONE.
	LogOutput string `json:"log_output,omitempty"`
	// The slow_query_logs work as SQL statements that take more than long_query_time seconds to execute. Default is 10s
	LongQueryTime float64 `json:"long_query_time,omitempty" validate:"omitempty,gte=0,lte=3600"`
	// Size of the largest message in bytes that can be received by the server. Default is 67108864 (64M)
	MaxAllowedPacket int `json:"max_allowed_packet,omitempty" validate:"omitempty,gte=102400,lte=1.073741824e+09"`
	// Limits the size of internal in-memory tables. Also set tmp_table_size. Default is 16777216 (16M)
	MaxHeapTableSize int `json:"max_heap_table_size,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.073741824e+09"`
	// Start sizes of connection buffer and result buffer. Default is 16384 (16K). Changing this parameter will lead to a restart of the MySQL service.
	NetBufferLength int `json:"net_buffer_length,omitempty" validate:"omitempty,gte=1024,lte=1.048576e+06"`
	// The number of seconds to wait for more data from a connection before aborting the read.
	NetReadTimeout int `json:"net_read_timeout,omitempty" validate:"omitempty,gte=1,lte=3600"`
	// The number of seconds to wait for a block to be written to a connection before aborting the write.
	NetWriteTimeout int `json:"net_write_timeout,omitempty" validate:"omitempty,gte=1,lte=3600"`
	// Slow query log enables capturing of slow queries. Setting slow_query_log to false also truncates the mysql.slow_log table. Default is off
	SlowQueryLog *bool `json:"slow_query_log,omitempty"`
	// Sort buffer size in bytes for ORDER BY optimization. Default is 262144 (256K)
	SortBufferSize int `json:"sort_buffer_size,omitempty" validate:"omitempty,gte=32768,lte=1.073741824e+09"`
	// Global SQL mode. Set to empty to use MySQL server defaults. When creating a new service and not setting this field Aiven default SQL mode (strict, SQL standard compliant) will be assigned.
	SQLMode string `json:"sql_mode,omitempty" validate:"omitempty,lte=1024"`
	// Require primary key to be defined for new tables or old tables modified with ALTER TABLE and fail if missing. It is recommended to always have primary keys because various functionality may break if any large table is missing them.
	SQLRequirePrimaryKey *bool `json:"sql_require_primary_key,omitempty"`
	// Limits the size of internal in-memory tables. Also set max_heap_table_size. Default is 16777216 (16M)
	TmpTableSize int `json:"tmp_table_size,omitempty" validate:"omitempty,gte=1.048576e+06,lte=1.073741824e+09"`
	// The number of seconds the server waits for activity on a noninteractive connection before closing it.
	WaitTimeout int `json:"wait_timeout,omitempty" validate:"omitempty,gte=1,lte=2.147483e+06"`
}

type JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingAuthenticationBackend string

const (
	JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingAuthenticationBackendInternal JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingAuthenticationBackend = "internal"
)

type JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingType string

const (
	JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingTypeUsername JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingType = "username"
)

// Internal Authentication Backend Limiting
type JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimiting struct {
	// The number of login attempts allowed before login is blocked
	AllowedTries int `json:"allowed_tries,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The internal backend. Enter `internal`
	AuthenticationBackend JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingAuthenticationBackend `json:"authentication_backend,omitempty" validate:"omitempty,lte=1024"`
	// The duration of time that login remains blocked after a failed login
	BlockExpirySeconds int `json:"block_expiry_seconds,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The maximum number of blocked IP addresses
	MaxBlockedClients int `json:"max_blocked_clients,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The maximum number of tracked IP addresses that have failed login
	MaxTrackedClients int `json:"max_tracked_clients,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The window of time in which the value for `allowed_tries` is enforced
	TimeWindowSeconds int `json:"time_window_seconds,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The type of rate limiting
	Type JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimitingType `json:"type,omitempty" validate:"omitempty,lte=1024"`
}

type JSONSchemaOpensearchAuthFailureListenersIPRateLimitingType string

const (
	JSONSchemaOpensearchAuthFailureListenersIPRateLimitingTypeIP JSONSchemaOpensearchAuthFailureListenersIPRateLimitingType = "ip"
)

// IP address rate limiting settings
type JSONSchemaOpensearchAuthFailureListenersIPRateLimiting struct {
	// The number of login attempts allowed before login is blocked
	AllowedTries int `json:"allowed_tries,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// The duration of time that login remains blocked after a failed login
	BlockExpirySeconds int `json:"block_expiry_seconds,omitempty" validate:"omitempty,gte=1,lte=36000"`
	// The maximum number of blocked IP addresses
	MaxBlockedClients int `json:"max_blocked_clients,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The maximum number of tracked IP addresses that have failed login
	MaxTrackedClients int `json:"max_tracked_clients,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// The window of time in which the value for `allowed_tries` is enforced
	TimeWindowSeconds int `json:"time_window_seconds,omitempty" validate:"omitempty,gte=1,lte=36000"`
	// The type of rate limiting
	Type JSONSchemaOpensearchAuthFailureListenersIPRateLimitingType `json:"type,omitempty" validate:"omitempty,lte=1024"`
}

// Opensearch Security Plugin Settings
type JSONSchemaOpensearchAuthFailureListeners struct {
	// Internal Authentication Backend Limiting
	InternalAuthenticationBackendLimiting *JSONSchemaOpensearchAuthFailureListenersInternalAuthenticationBackendLimiting `json:"internal_authentication_backend_limiting,omitempty"`
	// IP address rate limiting settings
	IPRateLimiting *JSONSchemaOpensearchAuthFailureListenersIPRateLimiting `json:"ip_rate_limiting,omitempty"`
}

// Opensearch Email Sender Settings
type JSONSchemaOpensearchEmailSender struct {
	// This should be identical to the Sender name defined in Opensearch dashboards
	EmailSenderName string `json:"email_sender_name" validate:"required,lte=40"`
	// Sender password for Opensearch alerts to authenticate with SMTP server
	EmailSenderPassword string `json:"email_sender_password" validate:"required,lte=1024"`
	// Sender username for Opensearch alerts
	EmailSenderUsername string `json:"email_sender_username" validate:"required,lte=320"`
}

// Opensearch ISM History Settings
type JSONSchemaOpensearchIsmHistory struct {
	// Specifies whether ISM is enabled or not
	IsmEnabled *bool `json:"ism_enabled" validate:"required"`
	// Specifies whether audit history is enabled or not. The logs from ISM are automatically indexed to a logs document.
	IsmHistoryEnabled *bool `json:"ism_history_enabled,omitempty"`
	// The maximum age before rolling over the audit history index in hours
	IsmHistoryMaxAge int `json:"ism_history_max_age,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// The maximum number of documents before rolling over the audit history index.
	IsmHistoryMaxDocs int `json:"ism_history_max_docs,omitempty" validate:"omitempty,gte=1,lte=9.223372036854776e+18"`
	// The time between rollover checks for the audit history index in hours.
	IsmHistoryRolloverCheckPeriod int `json:"ism_history_rollover_check_period,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// How long audit history indices are kept in days.
	IsmHistoryRolloverRetentionPeriod int `json:"ism_history_rollover_retention_period,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
}

type JSONSchemaOpensearchSearchBackpressureMode string

const (
	JSONSchemaOpensearchSearchBackpressureModeMonitorOnly JSONSchemaOpensearchSearchBackpressureMode = "monitor_only"
	JSONSchemaOpensearchSearchBackpressureModeEnforced    JSONSchemaOpensearchSearchBackpressureMode = "enforced"
	JSONSchemaOpensearchSearchBackpressureModeDisabled    JSONSchemaOpensearchSearchBackpressureMode = "disabled"
)

// Node duress settings
type JSONSchemaOpensearchSearchBackpressureNodeDuress struct {
	// The CPU usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.9
	CPUThreshold float64 `json:"cpu_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The heap usage threshold (as a percentage) required for a node to be considered to be under duress. Default is 0.7
	HeapThreshold float64 `json:"heap_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The number of successive limit breaches after which the node is considered to be under duress. Default is 3
	NumSuccessiveBreaches int `json:"num_successive_breaches,omitempty" validate:"omitempty,gte=1"`
}

// Search shard settings
type JSONSchemaOpensearchSearchBackpressureSearchShardTask struct {
	// The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 10.0
	CancellationBurst float64 `json:"cancellation_burst,omitempty" validate:"omitempty,gte=1"`
	// The maximum number of tasks to cancel per millisecond of elapsed time. Default is 0.003
	CancellationRate float64 `json:"cancellation_rate,omitempty" validate:"omitempty,gte=0"`
	// The maximum number of tasks to cancel, as a percentage of successful task completions. Default is 0.1
	CancellationRatio float64 `json:"cancellation_ratio,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The CPU usage threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 15000
	CPUTimeMillisThreshold int `json:"cpu_time_millis_threshold,omitempty" validate:"omitempty,gte=0"`
	// The elapsed time threshold (in milliseconds) required for a single search shard task before it is considered for cancellation. Default is 30000
	ElapsedTimeMillisThreshold int `json:"elapsed_time_millis_threshold,omitempty" validate:"omitempty,gte=0"`
	// The number of previously completed search shard tasks to consider when calculating the rolling average of heap usage. Default is 100
	HeapMovingAverageWindowSize int `json:"heap_moving_average_window_size,omitempty" validate:"omitempty,gte=0"`
	// The heap usage threshold (as a percentage) required for a single search shard task before it is considered for cancellation. Default is 0.5
	HeapPercentThreshold float64 `json:"heap_percent_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The minimum variance required for a single search shard task’s heap usage compared to the rolling average of previously completed tasks before it is considered for cancellation. Default is 2.0
	HeapVariance float64 `json:"heap_variance,omitempty" validate:"omitempty,gte=0"`
	// The heap usage threshold (as a percentage) required for the sum of heap usages of all search shard tasks before cancellation is applied. Default is 0.5
	TotalHeapPercentThreshold float64 `json:"total_heap_percent_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
}

// Search task settings
type JSONSchemaOpensearchSearchBackpressureSearchTask struct {
	// The maximum number of search tasks to cancel in a single iteration of the observer thread. Default is 5.0
	CancellationBurst float64 `json:"cancellation_burst,omitempty" validate:"omitempty,gte=1"`
	// The maximum number of search tasks to cancel per millisecond of elapsed time. Default is 0.003
	CancellationRate float64 `json:"cancellation_rate,omitempty" validate:"omitempty,gte=0"`
	// The maximum number of search tasks to cancel, as a percentage of successful search task completions. Default is 0.1
	CancellationRatio float64 `json:"cancellation_ratio,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The CPU usage threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 30000
	CPUTimeMillisThreshold int `json:"cpu_time_millis_threshold,omitempty" validate:"omitempty,gte=0"`
	// The elapsed time threshold (in milliseconds) required for an individual parent task before it is considered for cancellation. Default is 45000
	ElapsedTimeMillisThreshold int `json:"elapsed_time_millis_threshold,omitempty" validate:"omitempty,gte=0"`
	// The window size used to calculate the rolling average of the heap usage for the completed parent tasks. Default is 10
	HeapMovingAverageWindowSize int `json:"heap_moving_average_window_size,omitempty" validate:"omitempty,gte=0"`
	// The heap usage threshold (as a percentage) required for an individual parent task before it is considered for cancellation. Default is 0.2
	HeapPercentThreshold float64 `json:"heap_percent_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
	// The heap usage variance required for an individual parent task before it is considered for cancellation. A task is considered for cancellation when taskHeapUsage is greater than or equal to heapUsageMovingAverage * variance. Default is 2.0
	HeapVariance float64 `json:"heap_variance,omitempty" validate:"omitempty,gte=0"`
	// The heap usage threshold (as a percentage) required for the sum of heap usages of all search tasks before cancellation is applied. Default is 0.5
	TotalHeapPercentThreshold float64 `json:"total_heap_percent_threshold,omitempty" validate:"omitempty,gte=0,lte=1"`
}

// Search Backpressure Settings
type JSONSchemaOpensearchSearchBackpressure struct {
	// The search backpressure mode. Valid values are monitor_only, enforced, or disabled. Default is monitor_only
	Mode JSONSchemaOpensearchSearchBackpressureMode `json:"mode,omitempty"`
	// Node duress settings
	NodeDuress *JSONSchemaOpensearchSearchBackpressureNodeDuress `json:"node_duress,omitempty"`
	// Search shard settings
	SearchShardTask *JSONSchemaOpensearchSearchBackpressureSearchShardTask `json:"search_shard_task,omitempty"`
	// Search task settings
	SearchTask *JSONSchemaOpensearchSearchBackpressureSearchTask `json:"search_task,omitempty"`
}

// Operating factor
type JSONSchemaOpensearchShardIndexingPressureOperatingFactor struct {
	// Specify the lower occupancy limit of the allocated quota of memory for the shard. If the total memory usage of a shard is below this limit, shard indexing backpressure decreases the current allocated memory for that shard. Default is 0.75
	Lower float64 `json:"lower,omitempty" validate:"omitempty,gte=0"`
	// Specify the optimal occupancy of the allocated quota of memory for the shard. If the total memory usage of a shard is at this level, shard indexing backpressure doesn’t change the current allocated memory for that shard. Default is 0.85
	Optimal float64 `json:"optimal,omitempty" validate:"omitempty,gte=0"`
	// Specify the upper occupancy limit of the allocated quota of memory for the shard. If the total memory usage of a shard is above this limit, shard indexing backpressure increases the current allocated memory for that shard. Default is 0.95
	Upper float64 `json:"upper,omitempty" validate:"omitempty,gte=0"`
}

type JSONSchemaOpensearchShardIndexingPressurePrimaryParameterNode struct {
	// Define the percentage of the node-level memory threshold that acts as a soft indicator for strain on a node. Default is 0.7
	SoftLimit float64 `json:"soft_limit,omitempty" validate:"omitempty,gte=0"`
}

type JSONSchemaOpensearchShardIndexingPressurePrimaryParameterShard struct {
	// Specify the minimum assigned quota for a new shard in any role (coordinator, primary, or replica). Shard indexing backpressure increases or decreases this allocated quota based on the inflow of traffic for the shard. Default is 0.001
	MinLimit float64 `json:"min_limit,omitempty" validate:"omitempty,gte=0"`
}

// Primary parameter
type JSONSchemaOpensearchShardIndexingPressurePrimaryParameter struct {
	Node  *JSONSchemaOpensearchShardIndexingPressurePrimaryParameterNode  `json:"node,omitempty"`
	Shard *JSONSchemaOpensearchShardIndexingPressurePrimaryParameterShard `json:"shard,omitempty"`
}

// Shard indexing back pressure settings
type JSONSchemaOpensearchShardIndexingPressure struct {
	// Enable or disable shard indexing backpressure. Default is false
	Enabled *bool `json:"enabled,omitempty"`
	// Run shard indexing backpressure in shadow mode or enforced mode. In shadow mode (value set as false), shard indexing backpressure tracks all granular-level metrics, but it doesn’t actually reject any indexing requests. In enforced mode (value set as true), shard indexing backpressure rejects any requests to the cluster that might cause a dip in its performance. Default is false
	Enforced *bool `json:"enforced,omitempty"`
	// Operating factor
	OperatingFactor *JSONSchemaOpensearchShardIndexingPressureOperatingFactor `json:"operating_factor,omitempty"`
	// Primary parameter
	PrimaryParameter *JSONSchemaOpensearchShardIndexingPressurePrimaryParameter `json:"primary_parameter,omitempty"`
}

// OpenSearch settings
type JSONSchemaOpensearch struct {
	// Explicitly allow or block automatic creation of indices. Defaults to true
	ActionAutoCreateIndexEnabled *bool `json:"action_auto_create_index_enabled,omitempty"`
	// Require explicit index names when deleting
	ActionDestructiveRequiresName *bool `json:"action_destructive_requires_name,omitempty"`
	// Opensearch Security Plugin Settings
	AuthFailureListeners *JSONSchemaOpensearchAuthFailureListeners `json:"auth_failure_listeners,omitempty"`
	// Controls the number of shards allowed in the cluster per data node
	ClusterMaxShardsPerNode int `json:"cluster_max_shards_per_node,omitempty" validate:"omitempty,gte=100,lte=10000"`
	// How many concurrent incoming/outgoing shard recoveries (normally replicas) are allowed to happen on a node. Defaults to 2.
	ClusterRoutingAllocationNodeConcurrentRecoveries int `json:"cluster_routing_allocation_node_concurrent_recoveries,omitempty" validate:"omitempty,gte=2,lte=16"`
	// Opensearch Email Sender Settings
	EmailSender *JSONSchemaOpensearchEmailSender `json:"email-sender,omitempty"`
	// Enable/Disable security audit
	EnableSecurityAudit *bool `json:"enable_security_audit,omitempty"`
	// Maximum content length for HTTP requests to the OpenSearch HTTP API, in bytes.
	HTTPMaxContentLength int `json:"http_max_content_length,omitempty" validate:"omitempty,gte=1,lte=2.147483647e+09"`
	// The max size of allowed headers, in bytes
	HTTPMaxHeaderSize int `json:"http_max_header_size,omitempty" validate:"omitempty,gte=1024,lte=262144"`
	// The max length of an HTTP URL, in bytes
	HTTPMaxInitialLineLength int `json:"http_max_initial_line_length,omitempty" validate:"omitempty,gte=1024,lte=65536"`
	// Relative amount. Maximum amount of heap memory used for field data cache. This is an expert setting; decreasing the value too much will increase overhead of loading field data; too much memory used for field data cache will decrease amount of heap available for other operations.
	IndicesFielddataCacheSize *int `json:"indices_fielddata_cache_size,omitempty" validate:"omitempty,gte=3,lte=100"`
	// Percentage value. Default is 10%. Total amount of heap used for indexing buffer, before writing segments to disk. This is an expert setting. Too low value will slow down indexing; too high value will increase indexing performance but causes performance issues for query performance.
	IndicesMemoryIndexBufferSize int `json:"indices_memory_index_buffer_size,omitempty" validate:"omitempty,gte=3,lte=40"`
	// Absolute value. Default is unbound. Doesn't work without indices.memory.index_buffer_size. Maximum amount of heap used for query cache, an absolute indices.memory.index_buffer_size maximum hard limit.
	IndicesMemoryMaxIndexBufferSize int `json:"indices_memory_max_index_buffer_size,omitempty" validate:"omitempty,gte=3,lte=2048"`
	// Absolute value. Default is 48mb. Doesn't work without indices.memory.index_buffer_size. Minimum amount of heap used for query cache, an absolute indices.memory.index_buffer_size minimal hard limit.
	IndicesMemoryMinIndexBufferSize int `json:"indices_memory_min_index_buffer_size,omitempty" validate:"omitempty,gte=3,lte=2048"`
	// Percentage value. Default is 10%. Maximum amount of heap used for query cache. This is an expert setting. Too low value will decrease query performance and increase performance for other operations; too high value will cause issues with other OpenSearch functionality.
	IndicesQueriesCacheSize int `json:"indices_queries_cache_size,omitempty" validate:"omitempty,gte=3,lte=40"`
	// Maximum number of clauses Lucene BooleanQuery can have. The default value (1024) is relatively high, and increasing it may cause performance issues. Investigate other approaches first before increasing this value.
	IndicesQueryBoolMaxClauseCount int `json:"indices_query_bool_max_clause_count,omitempty" validate:"omitempty,gte=64,lte=4096"`
	// Limits total inbound and outbound recovery traffic for each node. Applies to both peer recoveries as well as snapshot recoveries (i.e., restores from a snapshot). Defaults to 40mb
	IndicesRecoveryMaxBytesPerSec int `json:"indices_recovery_max_bytes_per_sec,omitempty" validate:"omitempty,gte=40,lte=400"`
	// Number of file chunks sent in parallel for each recovery. Defaults to 2.
	IndicesRecoveryMaxConcurrentFileChunks int `json:"indices_recovery_max_concurrent_file_chunks,omitempty" validate:"omitempty,gte=2,lte=5"`
	// Opensearch ISM History Settings
	IsmHistory *JSONSchemaOpensearchIsmHistory `json:"ism-history,omitempty"`
	// Enable or disable KNN memory circuit breaker. Defaults to true.
	KnnMemoryCircuitBreakerEnabled *bool `json:"knn_memory_circuit_breaker_enabled,omitempty"`
	// Maximum amount of memory that can be used for KNN index. Defaults to 50% of the JVM heap size.
	KnnMemoryCircuitBreakerLimit int `json:"knn_memory_circuit_breaker_limit,omitempty" validate:"omitempty,gte=3,lte=100"`
	// Compatibility mode sets OpenSearch to report its version as 7.10 so clients continue to work. Default is false
	OverrideMainResponseVersion *bool `json:"override_main_response_version,omitempty"`
	// Enable or disable filtering of alerting by backend roles. Requires Security plugin. Defaults to false
	PluginsAlertingFilterByBackendRoles *bool `json:"plugins_alerting_filter_by_backend_roles,omitempty"`
	// Whitelisted addresses for reindexing. Changing this value will cause all OpenSearch instances to restart.
	ReindexRemoteWhitelist []string `json:"reindex_remote_whitelist"`
	// Script compilation circuit breaker limits the number of inline script compilations within a period of time. Default is use-context
	ScriptMaxCompilationsRate string `json:"script_max_compilations_rate,omitempty" validate:"omitempty,lte=1024"`
	// Search Backpressure Settings
	SearchBackpressure *JSONSchemaOpensearchSearchBackpressure `json:"search_backpressure,omitempty"`
	// Maximum number of aggregation buckets allowed in a single response. OpenSearch default value is used when this is not defined.
	SearchMaxBuckets *int `json:"search_max_buckets,omitempty" validate:"omitempty,gte=1,lte=1e+06"`
	// Shard indexing back pressure settings
	ShardIndexingPressure *JSONSchemaOpensearchShardIndexingPressure `json:"shard_indexing_pressure,omitempty"`
	// Size for the thread pool queue. See documentation for exact details.
	ThreadPoolAnalyzeQueueSize int `json:"thread_pool_analyze_queue_size,omitempty" validate:"omitempty,gte=10,lte=2000"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolAnalyzeSize int `json:"thread_pool_analyze_size,omitempty" validate:"omitempty,gte=1,lte=128"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolForceMergeSize int `json:"thread_pool_force_merge_size,omitempty" validate:"omitempty,gte=1,lte=128"`
	// Size for the thread pool queue. See documentation for exact details.
	ThreadPoolGetQueueSize int `json:"thread_pool_get_queue_size,omitempty" validate:"omitempty,gte=10,lte=2000"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolGetSize int `json:"thread_pool_get_size,omitempty" validate:"omitempty,gte=1,lte=128"`
	// Size for the thread pool queue. See documentation for exact details.
	ThreadPoolSearchQueueSize int `json:"thread_pool_search_queue_size,omitempty" validate:"omitempty,gte=10,lte=2000"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolSearchSize int `json:"thread_pool_search_size,omitempty" validate:"omitempty,gte=1,lte=128"`
	// Size for the thread pool queue. See documentation for exact details.
	ThreadPoolSearchThrottledQueueSize int `json:"thread_pool_search_throttled_queue_size,omitempty" validate:"omitempty,gte=10,lte=2000"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolSearchThrottledSize int `json:"thread_pool_search_throttled_size,omitempty" validate:"omitempty,gte=1,lte=128"`
	// Size for the thread pool queue. See documentation for exact details.
	ThreadPoolWriteQueueSize int `json:"thread_pool_write_queue_size,omitempty" validate:"omitempty,gte=10,lte=2000"`
	// Size for the thread pool. See documentation for exact details. Do note this may have maximum value depending on CPU count - value is automatically lowered if set to higher than maximum value.
	ThreadPoolWriteSize int `json:"thread_pool_write_size,omitempty" validate:"omitempty,gte=1,lte=128"`
}

// Autovacuum settings
type JSONSchemaPGAutovacuum struct {
	// Specifies a fraction of the table size to add to autovacuum_analyze_threshold when deciding whether to trigger an ANALYZE. The default is 0.2 (20% of table size)
	AutovacuumAnalyzeScaleFactor float64 `json:"autovacuum_analyze_scale_factor,omitempty" validate:"omitempty,gte=0,lte=1"`
	// Specifies the minimum number of inserted, updated or deleted tuples needed to trigger an ANALYZE in any one table. The default is 50 tuples.
	AutovacuumAnalyzeThreshold int `json:"autovacuum_analyze_threshold,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// Specifies the maximum age (in transactions) that a table's pg_class.relfrozenxid field can attain before a VACUUM operation is forced to prevent transaction ID wraparound within the table. Note that the system will launch autovacuum processes to prevent wraparound even when autovacuum is otherwise disabled. This parameter will cause the server to be restarted.
	AutovacuumFreezeMaxAge int `json:"autovacuum_freeze_max_age,omitempty" validate:"omitempty,gte=2e+08,lte=1.5e+09"`
	// Specifies the maximum number of autovacuum processes (other than the autovacuum launcher) that may be running at any one time. The default is three. This parameter can only be set at server start.
	AutovacuumMaxWorkers int `json:"autovacuum_max_workers,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Specifies the minimum delay between autovacuum runs on any given database. The delay is measured in seconds, and the default is one minute
	AutovacuumNaptime int `json:"autovacuum_naptime,omitempty" validate:"omitempty,gte=1,lte=86400"`
	// Specifies the cost delay value that will be used in automatic VACUUM operations. If -1 is specified, the regular vacuum_cost_delay value will be used. The default value is 20 milliseconds
	AutovacuumVacuumCostDelay int `json:"autovacuum_vacuum_cost_delay,omitempty" validate:"omitempty,gte=-1,lte=100"`
	// Specifies the cost limit value that will be used in automatic VACUUM operations. If -1 is specified (which is the default), the regular vacuum_cost_limit value will be used.
	AutovacuumVacuumCostLimit int `json:"autovacuum_vacuum_cost_limit,omitempty" validate:"omitempty,gte=-1,lte=10000"`
	// Specifies a fraction of the table size to add to autovacuum_vacuum_threshold when deciding whether to trigger a VACUUM. The default is 0.2 (20% of table size)
	AutovacuumVacuumScaleFactor float64 `json:"autovacuum_vacuum_scale_factor,omitempty" validate:"omitempty,gte=0,lte=1"`
	// Specifies the minimum number of updated or deleted tuples needed to trigger a VACUUM in any one table. The default is 50 tuples
	AutovacuumVacuumThreshold int `json:"autovacuum_vacuum_threshold,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// Causes each action executed by autovacuum to be logged if it ran for at least the specified number of milliseconds. Setting this to zero logs all autovacuum actions. Minus-one (the default) disables logging autovacuum actions.
	LogAutovacuumMinDuration int `json:"log_autovacuum_min_duration,omitempty" validate:"omitempty,gte=-1,lte=2.147483647e+09"`
}

// Background (BG) writer settings
type JSONSchemaPGBGWriter struct {
	// Specifies the delay between activity rounds for the background writer in milliseconds. Default is 200.
	BgwriterDelay int `json:"bgwriter_delay,omitempty" validate:"omitempty,gte=10,lte=10000"`
	// Whenever more than bgwriter_flush_after bytes have been written by the background writer, attempt to force the OS to issue these writes to the underlying storage. Specified in kilobytes, default is 512. Setting of 0 disables forced writeback.
	BgwriterFlushAfter int `json:"bgwriter_flush_after,omitempty" validate:"omitempty,gte=0,lte=2048"`
	// In each round, no more than this many buffers will be written by the background writer. Setting this to zero disables background writing. Default is 100.
	BgwriterLruMaxpages int `json:"bgwriter_lru_maxpages,omitempty" validate:"omitempty,gte=0,lte=1.073741823e+09"`
	// The average recent need for new buffers is multiplied by bgwriter_lru_multiplier to arrive at an estimate of the number that will be needed during the next round, (up to bgwriter_lru_maxpages). 1.0 represents a “just in time” policy of writing exactly the number of buffers predicted to be needed. Larger values provide some cushion against spikes in demand, while smaller values intentionally leave writes to be done by server processes. The default is 2.0.
	BgwriterLruMultiplier float64 `json:"bgwriter_lru_multiplier,omitempty" validate:"omitempty,gte=0,lte=10"`
}

type JSONSchemaPGDefaultToastCompression string

const (
	JSONSchemaPGDefaultToastCompressionLz4  JSONSchemaPGDefaultToastCompression = "lz4"
	JSONSchemaPGDefaultToastCompressionPglz JSONSchemaPGDefaultToastCompression = "pglz"
)

type JSONSchemaPGLogErrorVerbosity string

const (
	JSONSchemaPGLogErrorVerbosityTERSE   JSONSchemaPGLogErrorVerbosity = "TERSE"
	JSONSchemaPGLogErrorVerbosityDEFAULT JSONSchemaPGLogErrorVerbosity = "DEFAULT"
	JSONSchemaPGLogErrorVerbosityVERBOSE JSONSchemaPGLogErrorVerbosity = "VERBOSE"
)

type JSONSchemaPGPGStatStatementsTrack string

const (
	JSONSchemaPGPGStatStatementsTrackAll  JSONSchemaPGPGStatStatementsTrack = "all"
	JSONSchemaPGPGStatStatementsTrackTop  JSONSchemaPGPGStatStatementsTrack = "top"
	JSONSchemaPGPGStatStatementsTrackNone JSONSchemaPGPGStatStatementsTrack = "none"
)

type JSONSchemaPGTrackCommitTimestamp string

const (
	JSONSchemaPGTrackCommitTimestampOff JSONSchemaPGTrackCommitTimestamp = "off"
	JSONSchemaPGTrackCommitTimestampOn  JSONSchemaPGTrackCommitTimestamp = "on"
)

type JSONSchemaPGTrackFunctions string

const (
	JSONSchemaPGTrackFunctionsAll  JSONSchemaPGTrackFunctions = "all"
	JSONSchemaPGTrackFunctionsPL   JSONSchemaPGTrackFunctions = "pl"
	JSONSchemaPGTrackFunctionsNone JSONSchemaPGTrackFunctions = "none"
)

type JSONSchemaPGTrackIoTiming string

const (
	JSONSchemaPGTrackIoTimingOff JSONSchemaPGTrackIoTiming = "off"
	JSONSchemaPGTrackIoTimingOn  JSONSchemaPGTrackIoTiming = "on"
)

// Write-ahead log (WAL) settings
type JSONSchemaPGWal struct {
	// PostgreSQL maximum WAL size (MB) reserved for replication slots. Default is -1 (unlimited). wal_keep_size minimum WAL size setting takes precedence over this.
	MaxSlotWalKeepSize int `json:"max_slot_wal_keep_size,omitempty" validate:"omitempty,gte=-1,lte=2.147483647e+09"`
	// PostgreSQL maximum WAL senders
	MaxWalSenders int `json:"max_wal_senders,omitempty" validate:"omitempty,gte=20,lte=64"`
	// Terminate replication connections that are inactive for longer than this amount of time, in milliseconds.
	WalSenderTimeout int `json:"wal_sender_timeout,omitempty" validate:"omitempty,gte=0,lte=1.08e+07"`
	// WAL flush interval in milliseconds. Note that setting this value to lower than the default 200ms may negatively impact performance
	WalWriterDelay int `json:"wal_writer_delay,omitempty" validate:"omitempty,gte=10,lte=200"`
}

// postgresql.conf configuration values
type JSONSchemaPG struct {
	// Autovacuum settings
	Autovacuum *JSONSchemaPGAutovacuum `json:"autovacuum,omitempty"`
	// Background (BG) writer settings
	BGWriter *JSONSchemaPGBGWriter `json:"bg-writer,omitempty"`
	// This is the amount of time, in milliseconds, to wait on a lock before checking to see if there is a deadlock condition.
	DeadlockTimeout int `json:"deadlock_timeout,omitempty" validate:"omitempty,gte=500,lte=1.8e+06"`
	// Specifies the default TOAST compression method for values of compressible columns (the default is lz4).
	DefaultToastCompression JSONSchemaPGDefaultToastCompression `json:"default_toast_compression,omitempty"`
	// Time out sessions with open transactions after this number of milliseconds
	IdleInTransactionSessionTimeout int `json:"idle_in_transaction_session_timeout,omitempty" validate:"omitempty,gte=0,lte=6.048e+08"`
	// Controls system-wide use of Just-in-Time Compilation (JIT).
	Jit *bool `json:"jit,omitempty"`
	// Controls the amount of detail written in the server log for each message that is logged.
	LogErrorVerbosity JSONSchemaPGLogErrorVerbosity `json:"log_error_verbosity,omitempty"`
	// Choose from one of the available log-formats. These can support popular log analyzers like pgbadger, pganalyze etc.
	LogLinePrefix string `json:"log_line_prefix,omitempty"`
	// Log statements that take more than this number of milliseconds to run, -1 disables
	LogMinDurationStatement int `json:"log_min_duration_statement,omitempty" validate:"omitempty,gte=-1,lte=8.64e+07"`
	// Log statements for each temporary file created larger than this number of kilobytes, -1 disables
	LogTempFiles int `json:"log_temp_files,omitempty" validate:"omitempty,gte=-1,lte=2.147483647e+09"`
	// PostgreSQL maximum number of files that can be open per process
	MaxFilesPerProcess int `json:"max_files_per_process,omitempty" validate:"omitempty,gte=1000,lte=4096"`
	// PostgreSQL maximum locks per transaction
	MaxLocksPerTransaction int `json:"max_locks_per_transaction,omitempty" validate:"omitempty,gte=64,lte=6400"`
	// PostgreSQL maximum logical replication workers (taken from the pool of max_parallel_workers)
	MaxLogicalReplicationWorkers int `json:"max_logical_replication_workers,omitempty" validate:"omitempty,gte=4,lte=64"`
	// Sets the maximum number of workers that the system can support for parallel queries
	MaxParallelWorkers int `json:"max_parallel_workers,omitempty" validate:"omitempty,gte=0,lte=96"`
	// Sets the maximum number of workers that can be started by a single Gather or Gather Merge node
	MaxParallelWorkersPerGather int `json:"max_parallel_workers_per_gather,omitempty" validate:"omitempty,gte=0,lte=96"`
	// PostgreSQL maximum predicate locks per transaction
	MaxPredLocksPerTransaction int `json:"max_pred_locks_per_transaction,omitempty" validate:"omitempty,gte=64,lte=5120"`
	// PostgreSQL maximum prepared transactions
	MaxPreparedTransactions int `json:"max_prepared_transactions,omitempty" validate:"omitempty,gte=0,lte=10000"`
	// PostgreSQL maximum replication slots
	MaxReplicationSlots int `json:"max_replication_slots,omitempty" validate:"omitempty,gte=8,lte=64"`
	// Maximum depth of the stack in bytes
	MaxStackDepth int `json:"max_stack_depth,omitempty" validate:"omitempty,gte=2.097152e+06,lte=6.291456e+06"`
	// Max standby archive delay in milliseconds
	MaxStandbyArchiveDelay int `json:"max_standby_archive_delay,omitempty" validate:"omitempty,gte=1,lte=4.32e+07"`
	// Max standby streaming delay in milliseconds
	MaxStandbyStreamingDelay int `json:"max_standby_streaming_delay,omitempty" validate:"omitempty,gte=1,lte=4.32e+07"`
	// Sets the maximum number of background processes that the system can support
	MaxWorkerProcesses int `json:"max_worker_processes,omitempty" validate:"omitempty,gte=8,lte=96"`
	// Sets the time interval to run pg_partman's scheduled tasks
	PGPartmanBgwInterval int `json:"pg_partman_bgw.interval,omitempty" validate:"omitempty,gte=3600,lte=604800"`
	// Controls which role to use for pg_partman's scheduled background tasks.
	PGPartmanBgwRole string `json:"pg_partman_bgw.role,omitempty" validate:"omitempty,lte=64"`
	// Enables or disables query plan monitoring
	PGStatMonitorPgsmEnableQueryPlan *bool `json:"pg_stat_monitor.pgsm_enable_query_plan,omitempty"`
	// Sets the maximum number of buckets
	PGStatMonitorPgsmMaxBuckets int `json:"pg_stat_monitor.pgsm_max_buckets,omitempty" validate:"omitempty,gte=1,lte=10"`
	// Controls which statements are counted. Specify top to track top-level statements (those issued directly by clients), all to also track nested statements (such as statements invoked within functions), or none to disable statement statistics collection. The default value is top.
	PGStatStatementsTrack JSONSchemaPGPGStatStatementsTrack `json:"pg_stat_statements.track,omitempty"`
	// PostgreSQL temporary file limit in KiB, -1 for unlimited
	TempFileLimit int `json:"temp_file_limit,omitempty" validate:"omitempty,gte=-1,lte=2.147483647e+09"`
	// PostgreSQL service timezone
	Timezone string `json:"timezone,omitempty" validate:"omitempty,lte=64"`
	// Specifies the number of bytes reserved to track the currently executing command for each active session.
	TrackActivityQuerySize int `json:"track_activity_query_size,omitempty" validate:"omitempty,gte=1024,lte=10240"`
	// Record commit time of transactions.
	TrackCommitTimestamp JSONSchemaPGTrackCommitTimestamp `json:"track_commit_timestamp,omitempty"`
	// Enables tracking of function call counts and time used.
	TrackFunctions JSONSchemaPGTrackFunctions `json:"track_functions,omitempty"`
	// Enables timing of database I/O calls. This parameter is off by default, because it will repeatedly query the operating system for the current time, which may cause significant overhead on some platforms.
	TrackIoTiming JSONSchemaPGTrackIoTiming `json:"track_io_timing,omitempty"`
	// Write-ahead log (WAL) settings
	Wal *JSONSchemaPGWal `json:"wal,omitempty"`
}

type JSONSchemaPgbouncerAutodbPoolMode string

const (
	JSONSchemaPgbouncerAutodbPoolModeTransaction JSONSchemaPgbouncerAutodbPoolMode = "transaction"
	JSONSchemaPgbouncerAutodbPoolModeSession     JSONSchemaPgbouncerAutodbPoolMode = "session"
	JSONSchemaPgbouncerAutodbPoolModeStatement   JSONSchemaPgbouncerAutodbPoolMode = "statement"
)

// System-wide settings for pgbouncer.
type JSONSchemaPgbouncer struct {
	// If the automatically created database pools have been unused this many seconds, they are freed. If 0 then timeout is disabled. [seconds]
	AutodbIdleTimeout int `json:"autodb_idle_timeout,omitempty" validate:"omitempty,gte=0,lte=86400"`
	// Do not allow more than this many server connections per database (regardless of user). Setting it to 0 means unlimited.
	AutodbMaxDBConnections int `json:"autodb_max_db_connections,omitempty" validate:"omitempty,gte=0,lte=2.147483647e+09"`
	// PGBouncer pool mode
	AutodbPoolMode JSONSchemaPgbouncerAutodbPoolMode `json:"autodb_pool_mode,omitempty"`
	// If non-zero then create automatically a pool of that size per user when a pool doesn't exist.
	AutodbPoolSize int `json:"autodb_pool_size,omitempty" validate:"omitempty,gte=0,lte=10000"`
	// List of parameters to ignore when given in startup packet
	IgnoreStartupParameters []string `json:"ignore_startup_parameters,omitempty"`
	// PgBouncer tracks protocol-level named prepared statements related commands sent by the client in transaction and statement pooling modes when max_prepared_statements is set to a non-zero value. Setting it to 0 disables prepared statements. max_prepared_statements defaults to 100, and its maximum is 3000.
	MaxPreparedStatements int `json:"max_prepared_statements,omitempty" validate:"omitempty,gte=0,lte=3000"`
	// Add more server connections to pool if below this number. Improves behavior when usual load comes suddenly back after period of total inactivity. The value is effectively capped at the pool size.
	MinPoolSize int `json:"min_pool_size,omitempty" validate:"omitempty,gte=0,lte=10000"`
	// If a server connection has been idle more than this many seconds it will be dropped. If 0 then timeout is disabled. [seconds]
	ServerIdleTimeout int `json:"server_idle_timeout,omitempty" validate:"omitempty,gte=0,lte=86400"`
	// The pooler will close an unused server connection that has been connected longer than this. [seconds]
	ServerLifetime int `json:"server_lifetime,omitempty" validate:"omitempty,gte=60,lte=86400"`
	// Run server_reset_query (DISCARD ALL) in all pooling modes
	ServerResetQueryAlways *bool `json:"server_reset_query_always,omitempty"`
}

// System-wide settings for pglookout.
type JSONSchemaPglookout struct {
	// Number of seconds of master unavailability before triggering database failover to standby
	MaxFailoverReplicationTimeLag int `json:"max_failover_replication_time_lag,omitempty" validate:"omitempty,gte=10,lte=9.223372036854776e+18"`
}

// Schema Registry configuration
type JSONSchemaSchemaRegistry struct {
	// If true, Karapace / Schema Registry on the service nodes can participate in leader election. It might be needed to disable this when the schemas topic is replicated to a secondary cluster and Karapace / Schema Registry there must not participate in leader election. Defaults to `true`.
	LeaderEligibility *bool `json:"leader_eligibility,omitempty"`
	// The durable single partition topic that acts as the durable log for the data. This topic must be compacted to avoid losing data due to retention policy. Please note that changing this configuration in an existing Schema Registry / Karapace setup leads to previous schemas being inaccessible, data encoded with them potentially unreadable and schema ID sequence put out of order. It's only possible to do the switch while Schema Registry / Karapace is disabled. Defaults to `_schemas`.
	TopicName string `json:"topic_name,omitempty" validate:"omitempty,gte=1,lte=249"`
}

// Configuration options for Thanos Compactor.
type JSONSchemaThanosCompactor struct {
	// Retention time for data in days for each resolution (5m, 1h, raw)
	RetentionDays int `json:"retention.days,omitempty" validate:"omitempty,gte=0"`
}

// Configuration options for Thanos Query.
type JSONSchemaThanosQuery struct {
	// Set the default evaluation interval for subqueries.
	QueryDefaultEvaluationInterval string `json:"query.default-evaluation-interval,omitempty" validate:"omitempty,lte=20"`
	// The maximum lookback duration for retrieving metrics during expression evaluations in PromQL. PromQL always evaluates the query for a certain timestamp, and it looks back for the given amount of time to get the latest sample. If it exceeds the maximum lookback delta, it assumes the series is stale and returns none (a gap). The lookback delta should be set to at least 2 times the slowest scrape interval. If unset, it will use the promql default of 5m.
	QueryLookbackDelta string `json:"query.lookback-delta,omitempty" validate:"omitempty,lte=20"`
	// The default metadata time range duration for retrieving labels through Labels and Series API when the range parameters are not specified. The zero value means the range covers the time since the beginning.
	QueryMetadataDefaultTimeRange string `json:"query.metadata.default-time-range,omitempty" validate:"omitempty,lte=20"`
	// Maximum time to process a query by the query node.
	QueryTimeout string `json:"query.timeout,omitempty" validate:"omitempty,lte=20"`
	// The maximum samples allowed for a single Series request. The Series call fails if this limit is exceeded. Set to 0 for no limit. NOTE: For efficiency, the limit is internally implemented as 'chunks limit' considering each chunk contains a maximum of 120 samples. The default value is 100 * store.limits.request-series.
	StoreLimitsRequestSamples int `json:"store.limits.request-samples,omitempty" validate:"omitempty,gte=0,lte=1e+08"`
	// The maximum series allowed for a single Series request. The Series call fails if this limit is exceeded. Set to 0 for no limit. The default value is 1000 * cpu_count.
	StoreLimitsRequestSeries int `json:"store.limits.request-series,omitempty" validate:"omitempty,gte=0,lte=1e+08"`
}

// Configuration options for Thanos Query Frontend.
type JSONSchemaThanosQueryFrontend struct {
	// Whether to align the query range boundaries with the step. If enabled, the query range boundaries will be aligned to the step, providing more accurate results for queries with high-resolution data.
	QueryRangeAlignRangeWithStep *bool `json:"query-range.align-range-with-step,omitempty"`
}

// Thanos settings
type JSONSchemaThanos struct {
	// Configuration options for Thanos Compactor.
	Compactor *JSONSchemaThanosCompactor `json:"compactor,omitempty"`
	// Configuration options for Thanos Query.
	Query *JSONSchemaThanosQuery `json:"query,omitempty"`
	// Configuration options for Thanos Query Frontend.
	QueryFrontend *JSONSchemaThanosQueryFrontend `json:"query_frontend,omitempty"`
}

// System-wide settings for the timescaledb extension
type JSONSchemaTimescaledb struct {
	// The number of background workers for timescaledb operations. You should configure this setting to the sum of your number of databases and the total number of concurrent background workers you want running at any given point in time.
	MaxBackgroundWorkers int `json:"max_background_workers,omitempty" validate:"omitempty,gte=1,lte=4096"`
}

type JSONSchemaValkeyAclChannelsDefault string

const (
	JSONSchemaValkeyAclChannelsDefaultAllchannels   JSONSchemaValkeyAclChannelsDefault = "allchannels"
	JSONSchemaValkeyAclChannelsDefaultResetchannels JSONSchemaValkeyAclChannelsDefault = "resetchannels"
)

type JSONSchemaValkeyMaxmemoryPolicy string

const (
	JSONSchemaValkeyMaxmemoryPolicyNoeviction     JSONSchemaValkeyMaxmemoryPolicy = "noeviction"
	JSONSchemaValkeyMaxmemoryPolicyAllkeysLru     JSONSchemaValkeyMaxmemoryPolicy = "allkeys-lru"
	JSONSchemaValkeyMaxmemoryPolicyVolatileLru    JSONSchemaValkeyMaxmemoryPolicy = "volatile-lru"
	JSONSchemaValkeyMaxmemoryPolicyAllkeysRandom  JSONSchemaValkeyMaxmemoryPolicy = "allkeys-random"
	JSONSchemaValkeyMaxmemoryPolicyVolatileRandom JSONSchemaValkeyMaxmemoryPolicy = "volatile-random"
	JSONSchemaValkeyMaxmemoryPolicyVolatileTtl    JSONSchemaValkeyMaxmemoryPolicy = "volatile-ttl"
	JSONSchemaValkeyMaxmemoryPolicyVolatileLfu    JSONSchemaValkeyMaxmemoryPolicy = "volatile-lfu"
	JSONSchemaValkeyMaxmemoryPolicyAllkeysLfu     JSONSchemaValkeyMaxmemoryPolicy = "allkeys-lfu"
)

type JSONSchemaValkeyPersistence string

const (
	JSONSchemaValkeyPersistenceOff JSONSchemaValkeyPersistence = "off"
	JSONSchemaValkeyPersistenceRdb JSONSchemaValkeyPersistence = "rdb"
)

// Valkey settings
type JSONSchemaValkey struct {
	// Determines default pub/sub channels' ACL for new users if ACL is not supplied. When this option is not defined, all_channels is assumed to keep backward compatibility. This option doesn't affect Valkey configuration acl-pubsub-default.
	AclChannelsDefault JSONSchemaValkeyAclChannelsDefault `json:"acl_channels_default,omitempty"`
	// Set Valkey IO thread count. Changing this will cause a restart of the Valkey service.
	IoThreads int `json:"io_threads,omitempty" validate:"omitempty,gte=1,lte=32"`
	// LFU maxmemory-policy counter decay time in minutes
	LfuDecayTime int `json:"lfu_decay_time,omitempty" validate:"omitempty,gte=1,lte=120"`
	// Counter logarithm factor for volatile-lfu and allkeys-lfu maxmemory-policies
	LfuLogFactor int `json:"lfu_log_factor,omitempty" validate:"omitempty,gte=0,lte=100"`
	// Valkey maxmemory-policy
	MaxmemoryPolicy JSONSchemaValkeyMaxmemoryPolicy `json:"maxmemory_policy,omitempty"`
	// Set notify-keyspace-events option
	NotifyKeyspaceEvents string `json:"notify_keyspace_events,omitempty" validate:"omitempty,lte=32"`
	// Set number of Valkey databases. Changing this will cause a restart of the Valkey service.
	NumberOfDatabases int `json:"number_of_databases,omitempty" validate:"omitempty,gte=1,lte=128"`
	// When persistence is 'rdb', Valkey does RDB dumps each 10 minutes if any key is changed. Also RDB dumps are done according to backup schedule for backup purposes. When persistence is 'off', no RDB dumps and backups are done, so data can be lost at any moment if service is restarted for any reason, or if service is powered off. Also service can't be forked.
	Persistence JSONSchemaValkeyPersistence `json:"persistence,omitempty"`
	// Set output buffer limit for pub / sub clients in MB. The value is the hard limit, the soft limit is 1/4 of the hard limit. When setting the limit, be mindful of the available memory in the selected service plan.
	PubsubClientOutputBufferLimit int `json:"pubsub_client_output_buffer_limit,omitempty" validate:"omitempty,gte=32,lte=512"`
	// Require SSL to access Valkey
	SSL *bool `json:"ssl,omitempty"`
	// Valkey idle connection timeout in seconds
	Timeout int `json:"timeout,omitempty" validate:"omitempty,gte=0,lte=3.1536e+07"`
}

// Kubelet image GC options
type KubeletImageGC struct {
	HighThreshold int64  `json:"high-threshold,omitempty" validate:"omitempty,gte=0"`
	LowThreshold  int64  `json:"low-threshold,omitempty" validate:"omitempty,gte=0"`
	MinAge        string `json:"min-age,omitempty"`
}

type Labels map[string]string

type LoadBalancerState string

const (
	LoadBalancerStateCreating  LoadBalancerState = "creating"
	LoadBalancerStateMigrated  LoadBalancerState = "migrated"
	LoadBalancerStateDeleting  LoadBalancerState = "deleting"
	LoadBalancerStateRunning   LoadBalancerState = "running"
	LoadBalancerStateMigrating LoadBalancerState = "migrating"
	LoadBalancerStateError     LoadBalancerState = "error"
)

// Load Balancer
type LoadBalancer struct {
	// Load Balancer creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Load Balancer description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Load Balancer ID
	ID UUID `json:"id,omitempty"`
	// Load Balancer public IP
	IP     net.IP `json:"ip,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Load Balancer name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Load Balancer Services
	Services []LoadBalancerService `json:"services,omitempty"`
	// Load Balancer state
	State LoadBalancerState `json:"state,omitempty"`
}

type LoadBalancerServerStatusStatus string

const (
	LoadBalancerServerStatusStatusFailure LoadBalancerServerStatusStatus = "failure"
	LoadBalancerServerStatusStatusSuccess LoadBalancerServerStatusStatus = "success"
)

// Load Balancer Service status
type LoadBalancerServerStatus struct {
	// Backend server public IP
	PublicIP net.IP `json:"public-ip,omitempty"`
	// Status of the instance's healthcheck
	Status LoadBalancerServerStatusStatus `json:"status,omitempty"`
}

type LoadBalancerServiceProtocol string

const (
	LoadBalancerServiceProtocolTCP LoadBalancerServiceProtocol = "tcp"
	LoadBalancerServiceProtocolUDP LoadBalancerServiceProtocol = "udp"
)

type LoadBalancerServiceState string

const (
	LoadBalancerServiceStateCreating LoadBalancerServiceState = "creating"
	LoadBalancerServiceStateDeleting LoadBalancerServiceState = "deleting"
	LoadBalancerServiceStateRunning  LoadBalancerServiceState = "running"
	LoadBalancerServiceStateUpdating LoadBalancerServiceState = "updating"
	LoadBalancerServiceStateError    LoadBalancerServiceState = "error"
)

type LoadBalancerServiceStrategy string

const (
	LoadBalancerServiceStrategyRoundRobin LoadBalancerServiceStrategy = "round-robin"
	LoadBalancerServiceStrategyMaglevHash LoadBalancerServiceStrategy = "maglev-hash"
	LoadBalancerServiceStrategySourceHash LoadBalancerServiceStrategy = "source-hash"
)

// Load Balancer Service
type LoadBalancerService struct {
	// Load Balancer Service description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Load Balancer Service healthcheck
	Healthcheck *LoadBalancerServiceHealthcheck `json:"healthcheck,omitempty"`
	// Healthcheck status per backend server
	HealthcheckStatus []LoadBalancerServerStatus `json:"healthcheck-status,omitempty"`
	// Load Balancer Service ID
	ID UUID `json:"id,omitempty"`
	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`
	// Load Balancer Service name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Port exposed on the Load Balancer's public IP
	Port int64 `json:"port,omitempty" validate:"omitempty,gt=0"`
	// Network traffic protocol
	Protocol LoadBalancerServiceProtocol `json:"protocol,omitempty"`
	// Load Balancer Service state
	State LoadBalancerServiceState `json:"state,omitempty"`
	// Load balancing strategy
	Strategy LoadBalancerServiceStrategy `json:"strategy,omitempty"`
	// Port on which the network traffic will be forwarded to on the receiving instance
	TargetPort int64 `json:"target-port,omitempty" validate:"omitempty,gt=0"`
}

type LoadBalancerServiceHealthcheckMode string

const (
	LoadBalancerServiceHealthcheckModeTCP   LoadBalancerServiceHealthcheckMode = "tcp"
	LoadBalancerServiceHealthcheckModeHTTP  LoadBalancerServiceHealthcheckMode = "http"
	LoadBalancerServiceHealthcheckModeHttps LoadBalancerServiceHealthcheckMode = "https"
)

// Load Balancer Service healthcheck
type LoadBalancerServiceHealthcheck struct {
	// Healthcheck interval (default: 10). Must be greater than or equal to Timeout
	Interval int64 `json:"interval,omitempty" validate:"omitempty,gte=5,lte=300"`
	// Healthcheck mode
	Mode LoadBalancerServiceHealthcheckMode `json:"mode,omitempty"`
	// Healthcheck port
	Port int64 `json:"port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Number of retries before considering a Service failed
	Retries int64 `json:"retries,omitempty" validate:"omitempty,gte=1,lte=20"`
	// Healthcheck timeout value (default: 2). Must be lower than or equal to Interval
	Timeout int64 `json:"timeout,omitempty" validate:"omitempty,gte=2,lte=60"`
	// SNI domain for HTTPS healthchecks
	TlsSNI string `json:"tls-sni,omitempty" validate:"omitempty,gte=1,lte=255"`
	// An endpoint to use for the HTTP healthcheck, e.g. '/status'
	URI string `json:"uri,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type ManagerType string

const (
	ManagerTypeSKSNodepool  ManagerType = "sks-nodepool"
	ManagerTypeInstancePool ManagerType = "instance-pool"
)

// Resource manager
type Manager struct {
	// Manager ID
	ID UUID `json:"id,omitempty"`
	// Manager type
	Type ManagerType `json:"type,omitempty"`
}

// Cluster networking configuration.
type Networking struct {
	// CIDR Range for Pods in cluster. This must not overlap with any IP ranges assigned to pods. Max of two, comma-separated, dual-stack CIDRs is allowed.
	// If not specified, defaults to 192.168.0.0/16.
	ClusterCidr string `json:"cluster-cidr,omitempty"`
	// Mask size for node cidr in cluster. It must be larger than the Pod CIDR subnet mask. Defaults to 24
	NodeCidrMaskSizeIpv4 int64 `json:"node-cidr-mask-size-ipv4,omitempty" validate:"omitempty,gt=0"`
	// Mask size for node cidr in cluster. It must be larger than the Pod CIDR subnet mask. Defaults to 64
	NodeCidrMaskSizeIpv6 int64 `json:"node-cidr-mask-size-ipv6,omitempty" validate:"omitempty,gt=0"`
	// CIDR range for service cluster IPs. This must not overlap with any IP ranges assigned to nodes or pods. Max of two, comma-separated, dual-stack CIDRs is allowed.
	// If not specified, defaults to 10.96.0.0/12.
	ServiceClusterIPRange string `json:"service-cluster-ip-range,omitempty"`
}

type OperationReason string

const (
	OperationReasonIncorrect   OperationReason = "incorrect"
	OperationReasonUnknown     OperationReason = "unknown"
	OperationReasonUnavailable OperationReason = "unavailable"
	OperationReasonForbidden   OperationReason = "forbidden"
	OperationReasonBusy        OperationReason = "busy"
	OperationReasonFault       OperationReason = "fault"
	OperationReasonPartial     OperationReason = "partial"
	OperationReasonNotFound    OperationReason = "not-found"
	OperationReasonInterrupted OperationReason = "interrupted"
	OperationReasonUnsupported OperationReason = "unsupported"
	OperationReasonConflict    OperationReason = "conflict"
)

// Related resource reference
type OperationReference struct {
	// Command name
	Command string `json:"command,omitempty"`
	// Reference ID
	ID UUID `json:"id,omitempty"`
	// Link to the referenced resource
	Link string `json:"link,omitempty"`
}

type OperationState string

const (
	OperationStateFailure OperationState = "failure"
	OperationStatePending OperationState = "pending"
	OperationStateSuccess OperationState = "success"
	OperationStateTimeout OperationState = "timeout"
)

// Operation
type Operation struct {
	// Operation ID
	ID UUID `json:"id,omitempty"`
	// Operation message
	Message string `json:"message,omitempty"`
	// Operation failure reason
	Reason OperationReason `json:"reason,omitempty"`
	// Related resource reference
	Reference *OperationReference `json:"reference,omitempty"`
	// Operation status
	State OperationState `json:"state,omitempty"`
}

// Organization
type Organization struct {
	// Organization address
	Address string `json:"address,omitempty"`
	// Organization balance
	Balance float64 `json:"balance,omitempty"`
	// Organization city
	City string `json:"city,omitempty"`
	// Organization country
	Country string `json:"country,omitempty"`
	// Organization currency
	Currency string `json:"currency,omitempty"`
	// Organization ID
	ID UUID `json:"id,omitempty"`
	// Organization name
	Name string `json:"name,omitempty"`
	// Organization postcode
	Postcode string `json:"postcode,omitempty"`
}

// Private Network
type PrivateNetwork struct {
	// Private Network description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Private Network end IP address
	EndIP net.IP `json:"end-ip,omitempty"`
	// Private Network ID
	ID     UUID   `json:"id,omitempty"`
	Labels Labels `json:"labels,omitempty"`
	// Private Network leased IP addresses
	Leases []PrivateNetworkLease `json:"leases,omitempty"`
	// Private Network name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Private Network netmask
	Netmask net.IP `json:"netmask,omitempty"`
	// Private Network DHCP Options
	Options *PrivateNetworkOptions `json:"options,omitempty"`
	// Private Network start IP address
	StartIP net.IP `json:"start-ip,omitempty"`
	// Private Network VXLAN ID
	Vni int64 `json:"vni,omitempty" validate:"omitempty,gt=0"`
}

// Private Network leased IP address
type PrivateNetworkLease struct {
	// Attached instance ID
	InstanceID UUID `json:"instance-id,omitempty"`
	// Private Network IP address
	IP net.IP `json:"ip,omitempty"`
}

// Private Network DHCP Options
type PrivateNetworkOptions struct {
	// DNS Servers
	DNSServers []net.IP `json:"dns-servers,omitempty"`
	// Domain search list, limited to 255 octets
	DomainSearch []string `json:"domain-search,omitempty"`
	// NTP Servers
	NtpServers []net.IP `json:"ntp-servers,omitempty"`
	// Routers
	Routers []net.IP `json:"routers,omitempty"`
}

type PublicIPAssignment string

const (
	PublicIPAssignmentInet4 PublicIPAssignment = "inet4"
	PublicIPAssignmentDual  PublicIPAssignment = "dual"
	PublicIPAssignmentNone  PublicIPAssignment = "none"
)

// Organization Quota
type Quota struct {
	// Resource Limit. -1 for Unlimited
	Limit int64 `json:"limit,omitempty"`
	// Resource Name
	Resource string `json:"resource,omitempty"`
	// Resource Usage
	Usage int64 `json:"usage,omitempty"`
}

// Resource
type Resource struct {
	// Resource ID
	ID UUID `json:"id,omitempty"`
	// Resource name
	Name string `json:"name,omitempty"`
}

type ReverseDNSRecord struct {
	DomainName DomainName `json:"domain-name,omitempty" validate:"omitempty,gte=1,lte=253"`
}

// Security Group
type SecurityGroup struct {
	// Security Group description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Security Group external sources
	ExternalSources []string `json:"external-sources,omitempty"`
	// Security Group ID
	ID UUID `json:"id,omitempty"`
	// Security Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Security Group rules
	Rules []SecurityGroupRule `json:"rules,omitempty"`
}

type SecurityGroupResourceVisibility string

const (
	SecurityGroupResourceVisibilityPrivate SecurityGroupResourceVisibility = "private"
	SecurityGroupResourceVisibilityPublic  SecurityGroupResourceVisibility = "public"
)

// Security Group
type SecurityGroupResource struct {
	// Security Group ID
	ID UUID `json:"id,omitempty"`
	// Security Group name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Whether this points to a public security group. This is only valid when in the context of
	// a rule addition which uses a public security group as a source or destination.
	Visibility SecurityGroupResourceVisibility `json:"visibility,omitempty"`
}

type SecurityGroupRuleFlowDirection string

const (
	SecurityGroupRuleFlowDirectionIngress SecurityGroupRuleFlowDirection = "ingress"
	SecurityGroupRuleFlowDirectionEgress  SecurityGroupRuleFlowDirection = "egress"
)

// ICMP details
type SecurityGroupRuleICMP struct {
	Code int64 `json:"code,omitempty" validate:"omitempty,gte=-1,lte=254"`
	Type int64 `json:"type,omitempty" validate:"omitempty,gte=-1,lte=254"`
}

type SecurityGroupRuleProtocol string

const (
	SecurityGroupRuleProtocolTCP    SecurityGroupRuleProtocol = "tcp"
	SecurityGroupRuleProtocolEsp    SecurityGroupRuleProtocol = "esp"
	SecurityGroupRuleProtocolICMP   SecurityGroupRuleProtocol = "icmp"
	SecurityGroupRuleProtocolUDP    SecurityGroupRuleProtocol = "udp"
	SecurityGroupRuleProtocolGre    SecurityGroupRuleProtocol = "gre"
	SecurityGroupRuleProtocolAh     SecurityGroupRuleProtocol = "ah"
	SecurityGroupRuleProtocolIpip   SecurityGroupRuleProtocol = "ipip"
	SecurityGroupRuleProtocolIcmpv6 SecurityGroupRuleProtocol = "icmpv6"
)

// Security Group rule
type SecurityGroupRule struct {
	// Security Group rule description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// End port of the range
	EndPort int64 `json:"end-port,omitempty" validate:"omitempty,gte=1,lte=65535"`
	// Network flow direction to match
	FlowDirection SecurityGroupRuleFlowDirection `json:"flow-direction,omitempty"`
	// ICMP details
	ICMP *SecurityGroupRuleICMP `json:"icmp,omitempty"`
	// Security Group rule ID
	ID UUID `json:"id,omitempty"`
	// CIDR-formatted network allowed
	Network string `json:"network,omitempty"`
	// Network protocol
	Protocol SecurityGroupRuleProtocol `json:"protocol,omitempty"`
	// Security Group
	SecurityGroup *SecurityGroupResource `json:"security-group,omitempty"`
	// Start port of the range
	StartPort int64 `json:"start-port,omitempty" validate:"omitempty,gte=1,lte=65535"`
}

// Kubernetes Audit parameters
type SKSAudit struct {
	// Enabled
	Enabled        *bool                  `json:"enabled,omitempty"`
	Endpoint       SKSAuditEndpoint       `json:"endpoint,omitempty" validate:"omitempty,gte=1,lte=2000"`
	InitialBackoff SKSAuditInitialBackoff `json:"initial-backoff,omitempty" validate:"omitempty,gte=1,lte=10"`
}

type SKSAuditBearerToken string

// Kubernetes Audit parameters
type SKSAuditCreate struct {
	BearerToken    SKSAuditBearerToken    `json:"bearer-token" validate:"required,gte=1,lte=2000"`
	Endpoint       SKSAuditEndpoint       `json:"endpoint" validate:"required,gte=1,lte=2000"`
	InitialBackoff SKSAuditInitialBackoff `json:"initial-backoff,omitempty" validate:"omitempty,gte=1,lte=10"`
}

type SKSAuditEndpoint string

type SKSAuditInitialBackoff string

// Kubernetes Audit parameters
type SKSAuditUpdate struct {
	BearerToken SKSAuditBearerToken `json:"bearer-token,omitempty" validate:"omitempty,gte=1,lte=2000"`
	// Enable or Disable Kubernetes Audit
	Enabled        *bool                  `json:"enabled,omitempty"`
	Endpoint       SKSAuditEndpoint       `json:"endpoint,omitempty" validate:"omitempty,gte=1,lte=2000"`
	InitialBackoff SKSAuditInitialBackoff `json:"initial-backoff,omitempty" validate:"omitempty,gte=1,lte=10"`
}

type SKSClusterCni string

const (
	SKSClusterCniCalico SKSClusterCni = "calico"
	SKSClusterCniCilium SKSClusterCni = "cilium"
)

type SKSClusterLevel string

const (
	SKSClusterLevelStarter SKSClusterLevel = "starter"
	SKSClusterLevelPro     SKSClusterLevel = "pro"
)

type SKSClusterState string

const (
	SKSClusterStateRotatingCsiCredentials       SKSClusterState = "rotating-csi-credentials"
	SKSClusterStateRotatingCcmCredentials       SKSClusterState = "rotating-ccm-credentials"
	SKSClusterStateCreating                     SKSClusterState = "creating"
	SKSClusterStateUpgrading                    SKSClusterState = "upgrading"
	SKSClusterStateDeleting                     SKSClusterState = "deleting"
	SKSClusterStateRunning                      SKSClusterState = "running"
	SKSClusterStateSuspending                   SKSClusterState = "suspending"
	SKSClusterStateUpdating                     SKSClusterState = "updating"
	SKSClusterStateError                        SKSClusterState = "error"
	SKSClusterStateRotatingKarpenterCredentials SKSClusterState = "rotating-karpenter-credentials"
	SKSClusterStateResuming                     SKSClusterState = "resuming"
)

// SKS Cluster
type SKSCluster struct {
	Addons *SKSClusterAddons `json:"addons,omitempty"`
	// Kubernetes Audit parameters
	Audit *SKSAudit `json:"audit,omitempty"`
	// Enable auto upgrade of the control plane to the latest patch version available
	AutoUpgrade *bool `json:"auto-upgrade,omitempty"`
	// Cluster CNI
	Cni SKSClusterCni `json:"cni,omitempty"`
	// Cluster creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Cluster description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Indicates whether to deploy the Kubernetes network proxy.
	EnableKubeProxy *bool `json:"enable-kube-proxy,omitempty"`
	// Indicates whether to add operators certificate authority (CA) as part of trusted CAs for the API server.
	EnableOperatorsCA *bool `json:"enable-operators-ca,omitempty"`
	// Cluster endpoint
	Endpoint string `json:"endpoint,omitempty"`
	// A list of Kubernetes-only Alpha features to enable for API server component
	FeatureGates []string `json:"feature-gates,omitempty"`
	// Cluster ID
	ID     UUID             `json:"id,omitempty"`
	Labels SKSClusterLabels `json:"labels,omitempty"`
	// Cluster level
	Level SKSClusterLevel `json:"level,omitempty"`
	// Cluster name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Cluster Nodepools
	Nodepools []SKSNodepool `json:"nodepools,omitempty"`
	// Cluster state
	State SKSClusterState `json:"state,omitempty"`
	// Control plane Kubernetes version
	Version string `json:"version,omitempty"`
}

type SKSClusterAddons []string

type SKSClusterDeprecatedResource struct {
	Group          string `json:"group,omitempty"`
	RemovedRelease string `json:"removed-release,omitempty"`
	Resource       string `json:"resource,omitempty"`
	Subresource    string `json:"subresource,omitempty"`
	Version        string `json:"version,omitempty"`
}

type SKSClusterLabels map[string]string

// Kubeconfig request for a SKS cluster
type SKSKubeconfigRequest struct {
	// List of roles. The certificate present in the Kubeconfig will have these roles set in the Org field.
	Groups []string `json:"groups" validate:"required"`
	// Validity in seconds of the Kubeconfig user certificate (default: 30 days)
	Ttl int64 `json:"ttl,omitempty" validate:"omitempty,gt=0"`
	// User name in the generated Kubeconfig. The certificate present in the Kubeconfig will also have this name set for the CN field.
	User string `json:"user" validate:"required"`
}

type SKSNodepoolPublicIPAssignment string

const (
	SKSNodepoolPublicIPAssignmentInet4 SKSNodepoolPublicIPAssignment = "inet4"
	SKSNodepoolPublicIPAssignmentDual  SKSNodepoolPublicIPAssignment = "dual"
)

type SKSNodepoolState string

const (
	SKSNodepoolStateRenewingToken SKSNodepoolState = "renewing-token"
	SKSNodepoolStateCreating      SKSNodepoolState = "creating"
	SKSNodepoolStateDeleting      SKSNodepoolState = "deleting"
	SKSNodepoolStateRunning       SKSNodepoolState = "running"
	SKSNodepoolStateScaling       SKSNodepoolState = "scaling"
	SKSNodepoolStateUpdating      SKSNodepoolState = "updating"
	SKSNodepoolStateError         SKSNodepoolState = "error"
)

// SKS Nodepool
type SKSNodepool struct {
	// Nodepool addons
	Addons []string `json:"addons,omitempty"`
	// Nodepool Anti-affinity Groups
	AntiAffinityGroups []AntiAffinityGroup `json:"anti-affinity-groups,omitempty"`
	// Nodepool creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Deploy target
	DeployTarget *DeployTarget `json:"deploy-target,omitempty"`
	// Nodepool description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Nodepool instances disk size in GiB
	DiskSize int64 `json:"disk-size,omitempty" validate:"omitempty,gte=20,lte=51200"`
	// Nodepool ID
	ID UUID `json:"id,omitempty"`
	// Instance Pool
	InstancePool *InstancePool `json:"instance-pool,omitempty"`
	// The instances created by the Nodepool will be prefixed with this value (default: pool)
	InstancePrefix string `json:"instance-prefix,omitempty" validate:"omitempty,gte=1,lte=30"`
	// Compute instance type
	InstanceType *InstanceType `json:"instance-type,omitempty"`
	// Kubelet image GC options
	KubeletImageGC *KubeletImageGC   `json:"kubelet-image-gc,omitempty"`
	Labels         SKSNodepoolLabels `json:"labels,omitempty"`
	// Nodepool name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Nodepool Private Networks
	PrivateNetworks []PrivateNetwork `json:"private-networks,omitempty"`
	// Nodepool public IP assignment of the Instances:
	// * IPv4 and IPv6 (`dual`) addressing.
	// * IPv4 and IPv6 (`dual`) addressing.
	PublicIPAssignment SKSNodepoolPublicIPAssignment `json:"public-ip-assignment,omitempty"`
	// Nodepool Security Groups
	SecurityGroups []SecurityGroup `json:"security-groups,omitempty"`
	// Number of instances
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// Nodepool state
	State  SKSNodepoolState  `json:"state,omitempty"`
	Taints SKSNodepoolTaints `json:"taints,omitempty"`
	// Instance template
	Template *Template `json:"template,omitempty"`
	// Nodepool version
	Version string `json:"version,omitempty"`
}

type SKSNodepoolLabels map[string]string

type SKSNodepoolTaintEffect string

const (
	SKSNodepoolTaintEffectNoExecute        SKSNodepoolTaintEffect = "NoExecute"
	SKSNodepoolTaintEffectNoSchedule       SKSNodepoolTaintEffect = "NoSchedule"
	SKSNodepoolTaintEffectPreferNoSchedule SKSNodepoolTaintEffect = "PreferNoSchedule"
)

// Nodepool taint
type SKSNodepoolTaint struct {
	// Nodepool taint effect
	Effect SKSNodepoolTaintEffect `json:"effect" validate:"required"`
	// Nodepool taint value
	Value string `json:"value" validate:"required,gte=1,lte=255"`
}

type SKSNodepoolTaints map[string]SKSNodepoolTaint

// SKS Cluster OpenID config map
type SKSOidc struct {
	// OpenID client ID
	ClientID string `json:"client-id" validate:"required,gte=1,lte=255"`
	// JWT claim to use as the user's group
	GroupsClaim string `json:"groups-claim,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Prefix prepended to group claims
	GroupsPrefix string `json:"groups-prefix,omitempty" validate:"omitempty,gte=1,lte=255"`
	// OpenID provider URL
	IssuerURL string `json:"issuer-url" validate:"required,gte=1,lte=255"`
	// A key value map that describes a required claim in the ID Token
	RequiredClaim map[string]string `json:"required-claim,omitempty"`
	// JWT claim to use as the user name
	UsernameClaim string `json:"username-claim,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Prefix prepended to username claims
	UsernamePrefix string `json:"username-prefix,omitempty" validate:"omitempty,gte=1,lte=255"`
}

// Exported snapshot information
type SnapshotExport struct {
	// Exported snapshot disk file MD5 checksum
	Md5sum string `json:"md5sum,omitempty"`
	// Exported snapshot disk file pre-signed URL
	PresignedURL string `json:"presigned-url,omitempty"`
}

type SnapshotState string

const (
	SnapshotStateSnapshotting SnapshotState = "snapshotting"
	SnapshotStateDeleted      SnapshotState = "deleted"
	SnapshotStateExporting    SnapshotState = "exporting"
	SnapshotStateReady        SnapshotState = "ready"
	SnapshotStateDeleting     SnapshotState = "deleting"
	SnapshotStateError        SnapshotState = "error"
	SnapshotStateExported     SnapshotState = "exported"
)

// Snapshot
type Snapshot struct {
	// Snapshot creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Exported snapshot information
	Export *SnapshotExport `json:"export,omitempty"`
	// Snapshot ID
	ID UUID `json:"id,omitempty"`
	// Instance
	Instance *Instance `json:"instance,omitempty"`
	// Snapshot name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Snapshot size in GiB
	Size int64 `json:"size,omitempty" validate:"omitempty,gte=10,lte=51200"`
	// Snapshot state
	State SnapshotState `json:"state,omitempty"`
}

// SOS Bucket usage
type SOSBucketUsage struct {
	// SOS Bucket creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// SOS Bucket name
	Name string `json:"name,omitempty"`
	// SOS Bucket size in B
	Size     int64    `json:"size,omitempty" validate:"omitempty,gte=0"`
	ZoneName ZoneName `json:"zone-name,omitempty"`
}

// SSH key
type SSHKey struct {
	// SSH key fingerprint
	Fingerprint string `json:"fingerprint,omitempty"`
	// SSH key name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
}

type TemplateBootMode string

const (
	TemplateBootModeLegacy TemplateBootMode = "legacy"
	TemplateBootModeUefi   TemplateBootMode = "uefi"
)

type TemplateVisibility string

const (
	TemplateVisibilityPrivate TemplateVisibility = "private"
	TemplateVisibilityPublic  TemplateVisibility = "public"
)

// Instance template
type Template struct {
	// Boot mode (default: legacy)
	BootMode TemplateBootMode `json:"boot-mode,omitempty"`
	// Template build
	Build string `json:"build,omitempty"`
	// Template MD5 checksum
	Checksum string `json:"checksum,omitempty"`
	// Template creation date
	CreatedAT time.Time `json:"created-at,omitempty"`
	// Template default user
	DefaultUser string `json:"default-user,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Template description
	Description string `json:"description,omitempty" validate:"omitempty,lte=255"`
	// Template family
	Family string `json:"family,omitempty"`
	// Template ID
	ID UUID `json:"id,omitempty"`
	// Template maintainer
	Maintainer string `json:"maintainer,omitempty"`
	// Template name
	Name string `json:"name,omitempty" validate:"omitempty,gte=1,lte=255"`
	// Enable password-based login
	PasswordEnabled *bool `json:"password-enabled,omitempty"`
	// Template size
	Size int64 `json:"size,omitempty" validate:"omitempty,gt=0"`
	// Enable SSH key-based login
	SSHKeyEnabled *bool `json:"ssh-key-enabled,omitempty"`
	// Template source URL
	URL string `json:"url,omitempty"`
	// Template version
	Version string `json:"version,omitempty"`
	// Template visibility
	Visibility TemplateVisibility `json:"visibility,omitempty"`
	// Zones availability
	Zones []ZoneName `json:"zones,omitempty"`
}

// User
type User struct {
	// User Email
	Email string `json:"email" validate:"required"`
	// User ID
	ID UUID `json:"id,omitempty"`
	// True if the user has not yet created an Exoscale account
	Pending *bool `json:"pending,omitempty"`
	// IAM Role
	Role *IAMRole `json:"role" validate:"required"`
	// SSO enabled
	Sso *bool `json:"sso,omitempty"`
	// Two Factor Authentication enabled
	TwoFactorAuthentication *bool `json:"two-factor-authentication,omitempty"`
}

// Zone
type Zone struct {
	// Zone API endpoint
	APIEndpoint Endpoint `json:"api-endpoint,omitempty"`
	Name        ZoneName `json:"name,omitempty"`
	// Zone SOS endpoint
	SOSEndpoint Endpoint `json:"sos-endpoint,omitempty"`
}

type ZoneName string

const (
	ZoneNameCHDk2  ZoneName = "ch-dk-2"
	ZoneNameDEMuc1 ZoneName = "de-muc-1"
	ZoneNameCHGva2 ZoneName = "ch-gva-2"
	ZoneNameATVie1 ZoneName = "at-vie-1"
	ZoneNameDEFra1 ZoneName = "de-fra-1"
	ZoneNameBGSof1 ZoneName = "bg-sof-1"
	ZoneNameATVie2 ZoneName = "at-vie-2"
	ZoneNameHrZag1 ZoneName = "hr-zag-1"
)
