// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigProfileSlice(dest, src []*otlpprofiles.Profile) []*otlpprofiles.Profile {
	var newDest []*otlpprofiles.Profile
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Profile, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigProfile()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigProfile(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigProfile()
		}
	}
	for i := range src {
		CopyOrigProfile(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestProfileSlice() []*otlpprofiles.Profile {
	orig := make([]*otlpprofiles.Profile, 5)
	orig[0] = NewOrigProfile()
	orig[1] = GenTestOrigProfile()
	orig[2] = NewOrigProfile()
	orig[3] = GenTestOrigProfile()
	orig[4] = NewOrigProfile()
	return orig
}
