/* AgendaView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AgendaView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2011-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Maxwell Barvian
 *              Niels Avonds <niels.avonds@gmail.com>
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <libecal/libecal.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libical-glib/libical-glib.h>
#include "elementary-calendar.h"
#include <float.h>
#include <math.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <pango/pango.h>

#define MAYA_MAIN_WINDOW_ACTION_PREFIX "win."
#define MAYA_MAIN_WINDOW_ACTION_NEW_EVENT "action_new_event"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_AGENDA_VIEW (maya_view_agenda_view_get_type ())
#define MAYA_VIEW_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView))
#define MAYA_VIEW_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))
#define MAYA_VIEW_IS_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_IS_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_AGENDA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))

typedef struct _MayaViewAgendaView MayaViewAgendaView;
typedef struct _MayaViewAgendaViewClass MayaViewAgendaViewClass;
typedef struct _MayaViewAgendaViewPrivate MayaViewAgendaViewPrivate;
enum  {
	MAYA_VIEW_AGENDA_VIEW_0_PROPERTY,
	MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY,
	MAYA_VIEW_AGENDA_VIEW_NUM_PROPERTIES
};
static GParamSpec* maya_view_agenda_view_properties[MAYA_VIEW_AGENDA_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define MAYA_VIEW_TYPE_AGENDA_EVENT_ROW (maya_view_agenda_event_row_get_type ())
#define MAYA_VIEW_AGENDA_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow))
#define MAYA_VIEW_AGENDA_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRowClass))
#define MAYA_VIEW_IS_AGENDA_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW))
#define MAYA_VIEW_IS_AGENDA_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW))
#define MAYA_VIEW_AGENDA_EVENT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRowClass))

typedef struct _MayaViewAgendaEventRow MayaViewAgendaEventRow;
typedef struct _MayaViewAgendaEventRowClass MayaViewAgendaEventRowClass;

#define MAYA_TYPE_APPLICATION (maya_application_get_type ())
#define MAYA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_APPLICATION, MayaApplication))
#define MAYA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_APPLICATION, MayaApplicationClass))
#define MAYA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_APPLICATION))
#define MAYA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_APPLICATION))
#define MAYA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_APPLICATION, MayaApplicationClass))

typedef struct _MayaApplication MayaApplication;
typedef struct _MayaApplicationClass MayaApplicationClass;
typedef struct _MayaApplicationPrivate MayaApplicationPrivate;

#define MAYA_TYPE_MAIN_WINDOW (maya_main_window_get_type ())
#define MAYA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindow))
#define MAYA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))
#define MAYA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))

typedef struct _MayaMainWindow MayaMainWindow;
typedef struct _MayaMainWindowClass MayaMainWindowClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	MAYA_VIEW_AGENDA_VIEW_EVENT_REMOVED_SIGNAL,
	MAYA_VIEW_AGENDA_VIEW_NUM_SIGNALS
};
static guint maya_view_agenda_view_signals[MAYA_VIEW_AGENDA_VIEW_NUM_SIGNALS] = {0};

struct _MayaViewAgendaView {
	GtkBox parent_instance;
	MayaViewAgendaViewPrivate * priv;
};

struct _MayaViewAgendaViewClass {
	GtkBoxClass parent_class;
};

struct _MayaViewAgendaViewPrivate {
	HdyHeaderBar* _header_bar;
	GtkLabel* day_label;
	GtkLabel* weekday_label;
	GtkListBox* selected_date_events_list;
	GtkListBox* upcoming_events_list;
	GDateTime* selected_date;
};

struct _MayaApplication {
	GtkApplication parent_instance;
	MayaApplicationPrivate * priv;
	MayaMainWindow* window;
};

struct _MayaApplicationClass {
	GtkApplicationClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	MayaViewAgendaView* self;
	MayaViewAgendaEventRow* row;
};

struct _Block2Data {
	int _ref_count_;
	MayaViewAgendaView* self;
	MayaViewAgendaEventRow* row;
};

static gint MayaViewAgendaView_private_offset;
static gpointer maya_view_agenda_view_parent_class = NULL;

VALA_EXTERN GType maya_view_agenda_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewAgendaView, g_object_unref)
static void maya_view_agenda_view_activate_eventrow (MayaViewAgendaView* self,
                                              GtkListBoxRow* row);
VALA_EXTERN GType maya_view_agenda_event_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewAgendaEventRow, g_object_unref)
VALA_EXTERN ECalComponent* maya_view_agenda_event_row_get_calevent (MayaViewAgendaEventRow* self);
VALA_EXTERN GType maya_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaApplication, g_object_unref)
VALA_EXTERN GType maya_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaMainWindow, g_object_unref)
VALA_EXTERN void maya_main_window_on_modified (MayaMainWindow* self,
                                   ECalComponent* comp);
static void maya_view_agenda_view_header_update_func (MayaViewAgendaView* self,
                                               GtkListBoxRow* lbrow,
                                               GtkListBoxRow* lbbefore);
VALA_EXTERN gboolean maya_view_agenda_event_row_get_is_allday (MayaViewAgendaEventRow* self);
static gint maya_view_agenda_view_upcoming_sort_function (GtkListBoxRow* child1,
                                                   GtkListBoxRow* child2,
                                                   MayaViewAgendaView* self);
static gint maya_view_agenda_view_compare_rows (MayaViewAgendaView* self,
                                         MayaViewAgendaEventRow* row1,
                                         MayaViewAgendaEventRow* row2);
static gint maya_view_agenda_view_selected_sort_function (GtkListBoxRow* child1,
                                                   GtkListBoxRow* child2,
                                                   MayaViewAgendaView* self);
VALA_EXTERN const gchar* maya_view_agenda_event_row_get_summary (MayaViewAgendaEventRow* self);
static gint maya_view_agenda_view_get_event_type (MayaViewAgendaEventRow* row);
static void maya_view_agenda_view_upcoming_header_update_func (MayaViewAgendaView* self,
                                                        GtkListBoxRow* lbrow,
                                                        GtkListBoxRow* lbbefore);
static void maya_view_agenda_view_on_events_added (MayaViewAgendaView* self,
                                            ESource* source,
                                            GeeCollection* events);
VALA_EXTERN MayaViewAgendaEventRow* maya_view_agenda_event_row_new (ESource* source,
                                                        ECalComponent* calevent,
                                                        gboolean is_upcoming);
VALA_EXTERN MayaViewAgendaEventRow* maya_view_agenda_event_row_construct (GType object_type,
                                                              ESource* source,
                                                              ECalComponent* calevent,
                                                              gboolean is_upcoming);
static void ____lambda207_ (MayaViewAgendaView* self,
                     ECalComponent* event);
static void _____lambda207__maya_view_agenda_event_row_removed (MayaViewAgendaEventRow* _sender,
                                                         ECalComponent* event,
                                                         gpointer self);
static void ____lambda208_ (MayaViewAgendaView* self,
                     ECalComponent* event);
static void _____lambda208__maya_view_agenda_event_row_removed (MayaViewAgendaEventRow* _sender,
                                                         ECalComponent* event,
                                                         gpointer self);
static gint maya_view_agenda_view_search_calcomp (GtkWidget* widget,
                                           ECalComponent* comp);
static void maya_view_agenda_view_on_events_updated (MayaViewAgendaView* self,
                                              ESource* source,
                                              GeeCollection* events);
static gint _maya_view_agenda_view_search_calcomp_gcompare_func (gconstpointer a,
                                                          gconstpointer b);
VALA_EXTERN void maya_view_agenda_event_row_update (MayaViewAgendaEventRow* self,
                                        ECalComponent* event);
static void maya_view_agenda_view_on_events_removed (MayaViewAgendaView* self,
                                              ESource* source,
                                              GeeCollection* events);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GtkRevealer* maya_view_agenda_event_row_get_revealer (MayaViewAgendaEventRow* self);
static gboolean _____lambda209_ (Block1Data* _data1_);
static gboolean ______lambda209__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean _____lambda210_ (Block2Data* _data2_);
static gboolean ______lambda210__gsource_func (gpointer self);
static void maya_view_agenda_view_on_model_parameters_changed (MayaViewAgendaView* self);
static void maya_view_agenda_view_on_today_changed (MayaViewAgendaView* self);
VALA_EXTERN void maya_view_agenda_view_set_selected_date (MayaViewAgendaView* self,
                                              GDateTime* date);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_new (void);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_construct (GType object_type);
VALA_EXTERN HdyHeaderBar* maya_view_agenda_view_get_header_bar (MayaViewAgendaView* self);
static void maya_view_agenda_view_set_header_bar (MayaViewAgendaView* self,
                                           HdyHeaderBar* value);
static GObject * maya_view_agenda_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _maya_view_agenda_view_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                GtkListBoxRow* before,
                                                                                gpointer self);
static gint _maya_view_agenda_view_selected_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                           GtkListBoxRow* row2,
                                                                           gpointer self);
static gboolean _maya_view_agenda_view___lambda211_ (MayaViewAgendaView* self,
                                              GtkListBoxRow* row);
static gboolean __maya_view_agenda_view___lambda211__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                        gpointer self);
static void _maya_view_agenda_view_upcoming_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                         GtkListBoxRow* before,
                                                                                         gpointer self);
static gint _maya_view_agenda_view_upcoming_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                           GtkListBoxRow* row2,
                                                                           gpointer self);
static gboolean _maya_view_agenda_view___lambda212_ (MayaViewAgendaView* self,
                                              GtkListBoxRow* row);
static gboolean __maya_view_agenda_view___lambda212__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                        gpointer self);
static void _maya_view_agenda_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                               ESource* source,
                                                                               GeeCollection* events,
                                                                               gpointer self);
static void _maya_view_agenda_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                   ESource* source,
                                                                                   GeeCollection* events,
                                                                                   gpointer self);
static void _maya_view_agenda_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                   ESource* source,
                                                                                   GeeCollection* events,
                                                                                   gpointer self);
static void _maya_view_agenda_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                                 gpointer self);
static void _maya_view_agenda_view_on_today_changed_calendar_time_manager_on_update_today (CalendarTimeManager* _sender,
                                                                                    gpointer self);
VALA_EXTERN GDateTime* maya_application_get_selected_datetime (void);
static void _maya_view_agenda_view_activate_eventrow_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self);
static void maya_view_agenda_view_finalize (GObject * obj);
static GType maya_view_agenda_view_get_type_once (void);
static void _vala_maya_view_agenda_view_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_maya_view_agenda_view_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
maya_view_agenda_view_get_instance_private (MayaViewAgendaView* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewAgendaView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
maya_view_agenda_view_activate_eventrow (MayaViewAgendaView* self,
                                         GtkListBoxRow* row)
{
	ECalComponent* calevent = NULL;
	ECalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	GApplication* _tmp3_;
	MayaMainWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = maya_view_agenda_event_row_get_calevent (G_TYPE_CHECK_INSTANCE_CAST (row, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	calevent = _tmp2_;
	_tmp3_ = g_application_get_default ();
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, MAYA_TYPE_APPLICATION, MayaApplication)->window;
	maya_main_window_on_modified (_tmp4_, calevent);
	_g_object_unref0 (calevent);
}

static void
maya_view_agenda_view_header_update_func (MayaViewAgendaView* self,
                                          GtkListBoxRow* lbrow,
                                          GtkListBoxRow* lbbefore)
{
	MayaViewAgendaEventRow* row = NULL;
	MayaViewAgendaEventRow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	row = _tmp0_;
	if (lbbefore != NULL) {
		MayaViewAgendaEventRow* before = NULL;
		MayaViewAgendaEventRow* _tmp1_;
		MayaViewAgendaEventRow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		MayaViewAgendaEventRow* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		MayaViewAgendaEventRow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		MayaViewAgendaEventRow* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
		before = _tmp1_;
		_tmp2_ = row;
		_tmp3_ = maya_view_agenda_event_row_get_is_allday (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = before;
		_tmp6_ = maya_view_agenda_event_row_get_is_allday (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp4_ == _tmp7_) {
			MayaViewAgendaEventRow* _tmp8_;
			_tmp8_ = row;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp8_, NULL);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_tmp9_ = row;
		_tmp10_ = maya_view_agenda_event_row_get_is_allday (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = before;
		_tmp13_ = maya_view_agenda_event_row_get_is_allday (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp11_ != _tmp14_) {
			GraniteHeaderLabel* header_label = NULL;
			GraniteHeaderLabel* _tmp15_;
			GraniteHeaderLabel* _tmp16_;
			GraniteHeaderLabel* _tmp17_;
			MayaViewAgendaEventRow* _tmp18_;
			GraniteHeaderLabel* _tmp19_;
			_tmp15_ = granite_header_label_new (_ ("During the day"));
			g_object_ref_sink (_tmp15_);
			header_label = _tmp15_;
			_tmp16_ = header_label;
			_tmp17_ = header_label;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp17_, 6);
			gtk_widget_set_margin_start ((GtkWidget*) _tmp16_, 6);
			_tmp18_ = row;
			_tmp19_ = header_label;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp18_, (GtkWidget*) _tmp19_);
			_g_object_unref0 (header_label);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	} else {
		MayaViewAgendaEventRow* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = row;
		_tmp21_ = maya_view_agenda_event_row_get_is_allday (_tmp20_);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			GraniteHeaderLabel* allday_header = NULL;
			GraniteHeaderLabel* _tmp23_;
			GraniteHeaderLabel* _tmp24_;
			GraniteHeaderLabel* _tmp25_;
			MayaViewAgendaEventRow* _tmp26_;
			GraniteHeaderLabel* _tmp27_;
			_tmp23_ = granite_header_label_new (_ ("All day"));
			g_object_ref_sink (_tmp23_);
			allday_header = _tmp23_;
			_tmp24_ = allday_header;
			_tmp25_ = allday_header;
			gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, 6);
			gtk_widget_set_margin_start ((GtkWidget*) _tmp24_, 6);
			_tmp26_ = row;
			_tmp27_ = allday_header;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp26_, (GtkWidget*) _tmp27_);
			_g_object_unref0 (allday_header);
		}
		_g_object_unref0 (row);
		return;
	}
	_g_object_unref0 (row);
}

static gint
maya_view_agenda_view_upcoming_sort_function (GtkListBoxRow* child1,
                                              GtkListBoxRow* child2,
                                              MayaViewAgendaView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (child1 != NULL, 0);
	g_return_val_if_fail (child2 != NULL, 0);
	result = maya_view_agenda_view_compare_rows (self, G_TYPE_CHECK_INSTANCE_CAST (child1, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow), G_TYPE_CHECK_INSTANCE_CAST (child2, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	return result;
}

static gint
maya_view_agenda_view_selected_sort_function (GtkListBoxRow* child1,
                                              GtkListBoxRow* child2,
                                              MayaViewAgendaView* self)
{
	MayaViewAgendaEventRow* row1 = NULL;
	MayaViewAgendaEventRow* _tmp0_;
	MayaViewAgendaEventRow* row2 = NULL;
	MayaViewAgendaEventRow* _tmp1_;
	MayaViewAgendaEventRow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	MayaViewAgendaEventRow* _tmp17_;
	MayaViewAgendaEventRow* _tmp18_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (child1 != NULL, 0);
	g_return_val_if_fail (child2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child1, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	row1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (child2, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	row2 = _tmp1_;
	_tmp2_ = row1;
	_tmp3_ = maya_view_agenda_event_row_get_is_allday (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		MayaViewAgendaEventRow* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = row2;
		_tmp6_ = maya_view_agenda_event_row_get_is_allday (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			MayaViewAgendaEventRow* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			MayaViewAgendaEventRow* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp8_ = row1;
			_tmp9_ = maya_view_agenda_event_row_get_summary (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = row2;
			_tmp12_ = maya_view_agenda_event_row_get_summary (_tmp11_);
			_tmp13_ = _tmp12_;
			result = g_utf8_collate (_tmp10_, _tmp13_);
			_g_object_unref0 (row2);
			_g_object_unref0 (row1);
			return result;
		} else {
			result = -1;
			_g_object_unref0 (row2);
			_g_object_unref0 (row1);
			return result;
		}
	} else {
		MayaViewAgendaEventRow* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = row2;
		_tmp15_ = maya_view_agenda_event_row_get_is_allday (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_) {
			result = 1;
			_g_object_unref0 (row2);
			_g_object_unref0 (row1);
			return result;
		}
	}
	_tmp17_ = row1;
	_tmp18_ = row2;
	result = maya_view_agenda_view_compare_rows (self, _tmp17_, _tmp18_);
	_g_object_unref0 (row2);
	_g_object_unref0 (row1);
	return result;
}

static gint
maya_view_agenda_view_compare_rows (MayaViewAgendaView* self,
                                    MayaViewAgendaEventRow* row1,
                                    MayaViewAgendaEventRow* row2)
{
	ICalComponent* ical_event1 = NULL;
	ECalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	ICalComponent* _tmp2_;
	GDateTime* start_date1 = NULL;
	GDateTime* end_date1 = NULL;
	ICalComponent* _tmp3_;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	ICalComponent* ical_event2 = NULL;
	ECalComponent* _tmp6_;
	ECalComponent* _tmp7_;
	ICalComponent* _tmp8_;
	GDateTime* start_date2 = NULL;
	GDateTime* end_date2 = NULL;
	ICalComponent* _tmp9_;
	GDateTime* _tmp10_ = NULL;
	GDateTime* _tmp11_ = NULL;
	gint comp = 0;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = maya_view_agenda_event_row_get_calevent (row1);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_get_icalcomponent (_tmp1_);
	ical_event1 = _tmp2_;
	_tmp3_ = ical_event1;
	calendar_util_icalcomponent_get_local_datetimes (_tmp3_, &_tmp4_, &_tmp5_);
	_g_date_time_unref0 (start_date1);
	start_date1 = _tmp4_;
	_g_date_time_unref0 (end_date1);
	end_date1 = _tmp5_;
	_tmp6_ = maya_view_agenda_event_row_get_calevent (row2);
	_tmp7_ = _tmp6_;
	_tmp8_ = e_cal_component_get_icalcomponent (_tmp7_);
	ical_event2 = _tmp8_;
	_tmp9_ = ical_event2;
	calendar_util_icalcomponent_get_local_datetimes (_tmp9_, &_tmp10_, &_tmp11_);
	_g_date_time_unref0 (start_date2);
	start_date2 = _tmp10_;
	_g_date_time_unref0 (end_date2);
	end_date2 = _tmp11_;
	_tmp12_ = start_date1;
	_tmp13_ = start_date2;
	comp = g_date_time_compare (_tmp12_, _tmp13_);
	if (comp != 0) {
		result = comp;
		_g_date_time_unref0 (end_date2);
		_g_date_time_unref0 (start_date2);
		_g_date_time_unref0 (end_date1);
		_g_date_time_unref0 (start_date1);
		return result;
	} else {
		GDateTime* _tmp14_;
		GDateTime* _tmp15_;
		_tmp14_ = end_date1;
		_tmp15_ = end_date2;
		comp = g_date_time_compare (_tmp14_, _tmp15_);
		if (comp != 0) {
			result = comp;
			_g_date_time_unref0 (end_date2);
			_g_date_time_unref0 (start_date2);
			_g_date_time_unref0 (end_date1);
			_g_date_time_unref0 (start_date1);
			return result;
		}
	}
	_tmp16_ = maya_view_agenda_event_row_get_summary (row1);
	_tmp17_ = _tmp16_;
	_tmp18_ = maya_view_agenda_event_row_get_summary (row2);
	_tmp19_ = _tmp18_;
	result = g_utf8_collate (_tmp17_, _tmp19_);
	_g_date_time_unref0 (end_date2);
	_g_date_time_unref0 (start_date2);
	_g_date_time_unref0 (end_date1);
	_g_date_time_unref0 (start_date1);
	return result;
}

static gint
maya_view_agenda_view_get_event_type (MayaViewAgendaEventRow* row)
{
	ICalComponent* comp = NULL;
	ECalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	ICalComponent* _tmp2_;
	GDateTime* now = NULL;
	GDateTime* _tmp3_;
	GDateTime* stripped_time = NULL;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* stripped_time_end = NULL;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	CalendarUtilDateRange* range = NULL;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	CalendarUtilDateRange* _tmp14_;
	ICalComponent* _tmp15_;
	CalendarUtilDateRange* _tmp16_;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	CalendarUtilDateRange* _tmp22_;
	ICalComponent* _tmp23_;
	CalendarUtilDateRange* _tmp24_;
	GDateTime* _tmp25_;
	GDateTime* _tmp26_;
	GDateTime* _tmp27_;
	GDateTime* _tmp28_;
	GDateTime* _tmp29_;
	GDateTime* _tmp30_;
	GDateTime* _tmp31_;
	GDateTime* _tmp32_;
	GDateTime* _tmp33_;
	GDateTime* _tmp34_;
	GDateTime* _tmp35_;
	CalendarUtilDateRange* _tmp36_;
	ICalComponent* _tmp37_;
	CalendarUtilDateRange* _tmp38_;
	GDateTime* _tmp39_;
	GDateTime* _tmp40_;
	GDateTime* _tmp41_;
	GDateTime* _tmp42_;
	GDateTime* _tmp43_;
	GDateTime* _tmp44_;
	GDateTime* _tmp45_;
	GDateTime* _tmp46_;
	GDateTime* _tmp47_;
	GDateTime* _tmp48_;
	GDateTime* _tmp49_;
	CalendarUtilDateRange* _tmp50_;
	ICalComponent* _tmp51_;
	CalendarUtilDateRange* _tmp52_;
	GDateTime* _tmp53_;
	GDateTime* _tmp54_;
	GDateTime* _tmp55_;
	GDateTime* _tmp56_;
	GDateTime* _tmp57_;
	GDateTime* _tmp58_;
	GDateTime* _tmp59_;
	GDateTime* _tmp60_;
	GDateTime* _tmp61_;
	CalendarUtilDateRange* _tmp62_;
	ICalComponent* _tmp63_;
	CalendarUtilDateRange* _tmp64_;
	gint result;
	g_return_val_if_fail (row != NULL, 0);
	_tmp0_ = maya_view_agenda_event_row_get_calevent (row);
	_tmp1_ = _tmp0_;
	_tmp2_ = e_cal_component_get_icalcomponent (_tmp1_);
	comp = _tmp2_;
	_tmp3_ = g_date_time_new_now_local ();
	now = _tmp3_;
	_tmp4_ = now;
	_tmp5_ = now;
	_tmp6_ = now;
	_tmp7_ = g_date_time_new_local (g_date_time_get_year (_tmp4_), g_date_time_get_month (_tmp5_), g_date_time_get_day_of_month (_tmp6_), 0, 0, (gdouble) 0);
	stripped_time = _tmp7_;
	_tmp8_ = stripped_time;
	_tmp9_ = g_date_time_add_days (_tmp8_, 1);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp9_;
	_tmp10_ = stripped_time;
	_tmp11_ = g_date_time_add_days (_tmp10_, 1);
	stripped_time_end = _tmp11_;
	_tmp12_ = stripped_time;
	_tmp13_ = stripped_time_end;
	_tmp14_ = calendar_util_date_range_new (_tmp12_, _tmp13_);
	range = _tmp14_;
	_tmp15_ = comp;
	_tmp16_ = range;
	if (calendar_util_icalcomponent_is_in_range (_tmp15_, _tmp16_)) {
		result = 1;
		_g_object_unref0 (range);
		_g_date_time_unref0 (stripped_time_end);
		_g_date_time_unref0 (stripped_time);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp17_ = stripped_time_end;
	_tmp18_ = stripped_time;
	_tmp19_ = g_date_time_add_days (_tmp17_, 7 - g_date_time_get_day_of_week (_tmp18_));
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp19_;
	_tmp20_ = stripped_time;
	_tmp21_ = stripped_time_end;
	_tmp22_ = calendar_util_date_range_new (_tmp20_, _tmp21_);
	_g_object_unref0 (range);
	range = _tmp22_;
	_tmp23_ = comp;
	_tmp24_ = range;
	if (calendar_util_icalcomponent_is_in_range (_tmp23_, _tmp24_)) {
		result = 2;
		_g_object_unref0 (range);
		_g_date_time_unref0 (stripped_time_end);
		_g_date_time_unref0 (stripped_time);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp25_ = now;
	_tmp26_ = now;
	_tmp27_ = now;
	_tmp28_ = g_date_time_new_local (g_date_time_get_year (_tmp25_), g_date_time_get_month (_tmp26_), g_date_time_get_day_of_month (_tmp27_), 0, 0, (gdouble) 0);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp28_;
	_tmp29_ = stripped_time;
	_tmp30_ = stripped_time;
	_tmp31_ = g_date_time_add_days (_tmp29_, 8 - g_date_time_get_day_of_week (_tmp30_));
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp31_;
	_tmp32_ = stripped_time;
	_tmp33_ = g_date_time_add_days (_tmp32_, 7);
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp33_;
	_tmp34_ = stripped_time;
	_tmp35_ = stripped_time_end;
	_tmp36_ = calendar_util_date_range_new (_tmp34_, _tmp35_);
	_g_object_unref0 (range);
	range = _tmp36_;
	_tmp37_ = comp;
	_tmp38_ = range;
	if (calendar_util_icalcomponent_is_in_range (_tmp37_, _tmp38_)) {
		result = 3;
		_g_object_unref0 (range);
		_g_date_time_unref0 (stripped_time_end);
		_g_date_time_unref0 (stripped_time);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp39_ = now;
	_tmp40_ = now;
	_tmp41_ = now;
	_tmp42_ = g_date_time_new_local (g_date_time_get_year (_tmp39_), g_date_time_get_month (_tmp40_), g_date_time_get_day_of_month (_tmp41_), 0, 0, (gdouble) 0);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp42_;
	_tmp43_ = now;
	_tmp44_ = now;
	_tmp45_ = g_date_time_new_local (g_date_time_get_year (_tmp43_), g_date_time_get_month (_tmp44_), 1, 0, 0, (gdouble) 0);
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp45_;
	_tmp46_ = stripped_time_end;
	_tmp47_ = g_date_time_add_months (_tmp46_, 1);
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp47_;
	_tmp48_ = stripped_time;
	_tmp49_ = stripped_time_end;
	_tmp50_ = calendar_util_date_range_new (_tmp48_, _tmp49_);
	_g_object_unref0 (range);
	range = _tmp50_;
	_tmp51_ = comp;
	_tmp52_ = range;
	if (calendar_util_icalcomponent_is_in_range (_tmp51_, _tmp52_)) {
		result = 4;
		_g_object_unref0 (range);
		_g_date_time_unref0 (stripped_time_end);
		_g_date_time_unref0 (stripped_time);
		_g_date_time_unref0 (now);
		return result;
	}
	_tmp53_ = now;
	_tmp54_ = now;
	_tmp55_ = g_date_time_new_local (g_date_time_get_year (_tmp53_), g_date_time_get_month (_tmp54_), 1, 0, 0, (gdouble) 0);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp55_;
	_tmp56_ = stripped_time;
	_tmp57_ = g_date_time_add_months (_tmp56_, 1);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp57_;
	_tmp58_ = stripped_time;
	_tmp59_ = g_date_time_add_months (_tmp58_, 1);
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp59_;
	_tmp60_ = stripped_time;
	_tmp61_ = stripped_time_end;
	_tmp62_ = calendar_util_date_range_new (_tmp60_, _tmp61_);
	_g_object_unref0 (range);
	range = _tmp62_;
	_tmp63_ = comp;
	_tmp64_ = range;
	if (calendar_util_icalcomponent_is_in_range (_tmp63_, _tmp64_)) {
		result = 5;
		_g_object_unref0 (range);
		_g_date_time_unref0 (stripped_time_end);
		_g_date_time_unref0 (stripped_time);
		_g_date_time_unref0 (now);
		return result;
	}
	result = -1;
	_g_object_unref0 (range);
	_g_date_time_unref0 (stripped_time_end);
	_g_date_time_unref0 (stripped_time);
	_g_date_time_unref0 (now);
	return result;
}

static void
maya_view_agenda_view_upcoming_header_update_func (MayaViewAgendaView* self,
                                                   GtkListBoxRow* lbrow,
                                                   GtkListBoxRow* lbbefore)
{
	MayaViewAgendaEventRow* row = NULL;
	MayaViewAgendaEventRow* _tmp0_;
	gint row_type = 0;
	MayaViewAgendaEventRow* _tmp1_;
	GraniteHeaderLabel* header_label = NULL;
	GraniteHeaderLabel* _tmp5_;
	GraniteHeaderLabel* _tmp6_;
	GraniteHeaderLabel* _tmp7_;
	MayaViewAgendaEventRow* _tmp13_;
	GraniteHeaderLabel* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	row = _tmp0_;
	_tmp1_ = row;
	row_type = maya_view_agenda_view_get_event_type (_tmp1_);
	if (lbbefore != NULL) {
		MayaViewAgendaEventRow* before = NULL;
		MayaViewAgendaEventRow* _tmp2_;
		gint before_type = 0;
		MayaViewAgendaEventRow* _tmp3_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
		before = _tmp2_;
		_tmp3_ = before;
		before_type = maya_view_agenda_view_get_event_type (_tmp3_);
		if (row_type == before_type) {
			MayaViewAgendaEventRow* _tmp4_;
			_tmp4_ = row;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp4_, NULL);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	}
	_tmp5_ = granite_header_label_new ("");
	g_object_ref_sink (_tmp5_);
	header_label = _tmp5_;
	_tmp6_ = header_label;
	_tmp7_ = header_label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp7_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 6);
	switch (row_type) {
		case 1:
		{
			GraniteHeaderLabel* _tmp8_;
			_tmp8_ = header_label;
			gtk_label_set_label ((GtkLabel*) _tmp8_, _ ("Tomorrow"));
			break;
		}
		case 2:
		{
			GraniteHeaderLabel* _tmp9_;
			_tmp9_ = header_label;
			gtk_label_set_label ((GtkLabel*) _tmp9_, _ ("This Week"));
			break;
		}
		case 3:
		{
			GraniteHeaderLabel* _tmp10_;
			_tmp10_ = header_label;
			gtk_label_set_label ((GtkLabel*) _tmp10_, _ ("Next Week"));
			break;
		}
		case 4:
		{
			GraniteHeaderLabel* _tmp11_;
			_tmp11_ = header_label;
			gtk_label_set_label ((GtkLabel*) _tmp11_, _ ("This Month"));
			break;
		}
		case 5:
		{
			GraniteHeaderLabel* _tmp12_;
			_tmp12_ = header_label;
			gtk_label_set_label ((GtkLabel*) _tmp12_, _ ("Next Month"));
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp13_ = row;
	_tmp14_ = header_label;
	gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp13_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (header_label);
	_g_object_unref0 (row);
}

/**
     * Events have been added to the given source.
     */
static void
____lambda207_ (MayaViewAgendaView* self,
                ECalComponent* event)
{
	g_return_if_fail (event != NULL);
	g_signal_emit (self, maya_view_agenda_view_signals[MAYA_VIEW_AGENDA_VIEW_EVENT_REMOVED_SIGNAL], 0, event);
}

static void
_____lambda207__maya_view_agenda_event_row_removed (MayaViewAgendaEventRow* _sender,
                                                    ECalComponent* event,
                                                    gpointer self)
{
	____lambda207_ ((MayaViewAgendaView*) self, event);
}

static void
____lambda208_ (MayaViewAgendaView* self,
                ECalComponent* event)
{
	g_return_if_fail (event != NULL);
	g_signal_emit (self, maya_view_agenda_view_signals[MAYA_VIEW_AGENDA_VIEW_EVENT_REMOVED_SIGNAL], 0, event);
}

static void
_____lambda208__maya_view_agenda_event_row_removed (MayaViewAgendaEventRow* _sender,
                                                    ECalComponent* event,
                                                    gpointer self)
{
	____lambda208_ ((MayaViewAgendaView*) self, event);
}

static void
maya_view_agenda_view_on_events_added (MayaViewAgendaView* self,
                                       ESource* source,
                                       GeeCollection* events)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			MayaViewAgendaEventRow* row = NULL;
			ECalComponent* _tmp4_;
			MayaViewAgendaEventRow* _tmp5_;
			MayaViewAgendaEventRow* _tmp6_;
			MayaViewAgendaEventRow* _tmp7_;
			GtkListBox* _tmp8_;
			MayaViewAgendaEventRow* _tmp9_;
			MayaViewAgendaEventRow* row2 = NULL;
			ECalComponent* _tmp10_;
			MayaViewAgendaEventRow* _tmp11_;
			MayaViewAgendaEventRow* _tmp12_;
			MayaViewAgendaEventRow* _tmp13_;
			GtkListBox* _tmp14_;
			MayaViewAgendaEventRow* _tmp15_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			_tmp5_ = maya_view_agenda_event_row_new (source, _tmp4_, FALSE);
			g_object_ref_sink (_tmp5_);
			row = _tmp5_;
			_tmp6_ = row;
			g_signal_connect_object (_tmp6_, "removed", (GCallback) _____lambda207__maya_view_agenda_event_row_removed, self, 0);
			_tmp7_ = row;
			gtk_widget_show_all ((GtkWidget*) _tmp7_);
			_tmp8_ = self->priv->selected_date_events_list;
			_tmp9_ = row;
			gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
			_tmp10_ = event;
			_tmp11_ = maya_view_agenda_event_row_new (source, _tmp10_, TRUE);
			g_object_ref_sink (_tmp11_);
			row2 = _tmp11_;
			_tmp12_ = row2;
			g_signal_connect_object (_tmp12_, "removed", (GCallback) _____lambda208__maya_view_agenda_event_row_removed, self, 0);
			_tmp13_ = row2;
			gtk_widget_show_all ((GtkWidget*) _tmp13_);
			_tmp14_ = self->priv->upcoming_events_list;
			_tmp15_ = row2;
			gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
			_g_object_unref0 (row2);
			_g_object_unref0 (row);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
}

static gint
maya_view_agenda_view_search_calcomp (GtkWidget* widget,
                                      ECalComponent* comp)
{
	MayaViewAgendaEventRow* row = NULL;
	ECalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	gint result;
	g_return_val_if_fail (widget != NULL, 0);
	g_return_val_if_fail (comp != NULL, 0);
	row = MAYA_VIEW_IS_AGENDA_EVENT_ROW (widget) ? ((MayaViewAgendaEventRow*) widget) : NULL;
	_tmp0_ = maya_view_agenda_event_row_get_calevent (row);
	_tmp1_ = _tmp0_;
	result = calendar_util_ecalcomponent_compare_func (_tmp1_, comp);
	return result;
}

/**
     * Events for the given source have been updated.
     */
static gint
_maya_view_agenda_view_search_calcomp_gcompare_func (gconstpointer a,
                                                     gconstpointer b)
{
	gint result;
	result = maya_view_agenda_view_search_calcomp ((GtkWidget*) a, (ECalComponent*) b);
	return result;
}

static void
maya_view_agenda_view_on_events_updated (MayaViewAgendaView* self,
                                         ESource* source,
                                         GeeCollection* events)
{
	GList* selected_date_events_children = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* upcoming_events_children = NULL;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->selected_date_events_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	selected_date_events_children = _tmp1_;
	_tmp2_ = self->priv->upcoming_events_list;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	upcoming_events_children = _tmp3_;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp4_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) events);
		_event_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GList* found = NULL;
			GList* _tmp8_;
			ECalComponent* _tmp9_;
			GList* _tmp10_;
			GList* _tmp11_;
			GList* found2 = NULL;
			GList* _tmp15_;
			ECalComponent* _tmp16_;
			GList* _tmp17_;
			GList* _tmp18_;
			_tmp5_ = _event_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _event_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			event = (ECalComponent*) _tmp7_;
			_tmp8_ = selected_date_events_children;
			_tmp9_ = event;
			_tmp10_ = g_list_find_custom (_tmp8_, _tmp9_, _maya_view_agenda_view_search_calcomp_gcompare_func);
			found = _tmp10_;
			_tmp11_ = found;
			if (_tmp11_ != NULL) {
				GList* _tmp12_;
				gconstpointer _tmp13_;
				ECalComponent* _tmp14_;
				_tmp12_ = found;
				_tmp13_ = _tmp12_->data;
				_tmp14_ = event;
				maya_view_agenda_event_row_update (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp13_, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow), _tmp14_);
			}
			_tmp15_ = upcoming_events_children;
			_tmp16_ = event;
			_tmp17_ = g_list_find_custom (_tmp15_, _tmp16_, _maya_view_agenda_view_search_calcomp_gcompare_func);
			found2 = _tmp17_;
			_tmp18_ = found2;
			if (_tmp18_ != NULL) {
				GList* _tmp19_;
				gconstpointer _tmp20_;
				ECalComponent* _tmp21_;
				_tmp19_ = found2;
				_tmp20_ = _tmp19_->data;
				_tmp21_ = event;
				maya_view_agenda_event_row_update (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp20_, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow), _tmp21_);
			}
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	(upcoming_events_children == NULL) ? NULL : (upcoming_events_children = (g_list_free (upcoming_events_children), NULL));
	(selected_date_events_children == NULL) ? NULL : (selected_date_events_children = (g_list_free (selected_date_events_children), NULL));
}

/**
     * Events for the given source have been removed.
     */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MayaViewAgendaView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->row);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
_____lambda209_ (Block1Data* _data1_)
{
	MayaViewAgendaView* self;
	MayaViewAgendaEventRow* _tmp0_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = _data1_->row;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
______lambda209__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda209_ (self);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MayaViewAgendaView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->row);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
_____lambda210_ (Block2Data* _data2_)
{
	MayaViewAgendaView* self;
	MayaViewAgendaEventRow* _tmp0_;
	gboolean result;
	self = _data2_->self;
	_tmp0_ = _data2_->row;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
______lambda210__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda210_ (self);
	return result;
}

static void
maya_view_agenda_view_on_events_removed (MayaViewAgendaView* self,
                                         ESource* source,
                                         GeeCollection* events)
{
	GList* selected_date_events_children = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* upcoming_events_children = NULL;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_tmp0_ = self->priv->selected_date_events_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	selected_date_events_children = _tmp1_;
	_tmp2_ = self->priv->upcoming_events_list;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	upcoming_events_children = _tmp3_;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp4_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) events);
		_event_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GList* found = NULL;
			GList* _tmp8_;
			ECalComponent* _tmp9_;
			GList* _tmp10_;
			GList* _tmp11_;
			GList* found2 = NULL;
			GList* _tmp23_;
			ECalComponent* _tmp24_;
			GList* _tmp25_;
			GList* _tmp26_;
			_tmp5_ = _event_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _event_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			event = (ECalComponent*) _tmp7_;
			_tmp8_ = selected_date_events_children;
			_tmp9_ = event;
			_tmp10_ = g_list_find_custom (_tmp8_, _tmp9_, _maya_view_agenda_view_search_calcomp_gcompare_func);
			found = _tmp10_;
			_tmp11_ = found;
			if (_tmp11_ != NULL) {
				Block1Data* _data1_;
				GList* _tmp12_;
				gconstpointer _tmp13_;
				MayaViewAgendaEventRow* _tmp14_;
				MayaViewAgendaEventRow* _tmp15_;
				GtkRevealer* _tmp16_;
				GtkRevealer* _tmp17_;
				MayaViewAgendaEventRow* _tmp18_;
				GtkRevealer* _tmp19_;
				GtkRevealer* _tmp20_;
				guint _tmp21_;
				guint _tmp22_;
				_data1_ = g_slice_new0 (Block1Data);
				_data1_->_ref_count_ = 1;
				_data1_->self = g_object_ref (self);
				_tmp12_ = found;
				_tmp13_ = _tmp12_->data;
				_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp13_, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
				_data1_->row = _tmp14_;
				_tmp15_ = _data1_->row;
				_tmp16_ = maya_view_agenda_event_row_get_revealer (_tmp15_);
				_tmp17_ = _tmp16_;
				gtk_revealer_set_reveal_child (_tmp17_, FALSE);
				_tmp18_ = _data1_->row;
				_tmp19_ = maya_view_agenda_event_row_get_revealer (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = gtk_revealer_get_transition_duration (_tmp20_);
				_tmp22_ = _tmp21_;
				g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp22_, ______lambda209__gsource_func, block1_data_ref (_data1_), block1_data_unref);
				block1_data_unref (_data1_);
				_data1_ = NULL;
			}
			_tmp23_ = upcoming_events_children;
			_tmp24_ = event;
			_tmp25_ = g_list_find_custom (_tmp23_, _tmp24_, _maya_view_agenda_view_search_calcomp_gcompare_func);
			found2 = _tmp25_;
			_tmp26_ = found2;
			if (_tmp26_ != NULL) {
				Block2Data* _data2_;
				GList* _tmp27_;
				gconstpointer _tmp28_;
				MayaViewAgendaEventRow* _tmp29_;
				MayaViewAgendaEventRow* _tmp30_;
				GtkRevealer* _tmp31_;
				GtkRevealer* _tmp32_;
				MayaViewAgendaEventRow* _tmp33_;
				GtkRevealer* _tmp34_;
				GtkRevealer* _tmp35_;
				guint _tmp36_;
				guint _tmp37_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->self = g_object_ref (self);
				_tmp27_ = found2;
				_tmp28_ = _tmp27_->data;
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp28_, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
				_data2_->row = _tmp29_;
				_tmp30_ = _data2_->row;
				_tmp31_ = maya_view_agenda_event_row_get_revealer (_tmp30_);
				_tmp32_ = _tmp31_;
				gtk_revealer_set_reveal_child (_tmp32_, FALSE);
				_tmp33_ = _data2_->row;
				_tmp34_ = maya_view_agenda_event_row_get_revealer (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = gtk_revealer_get_transition_duration (_tmp35_);
				_tmp37_ = _tmp36_;
				g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp37_, ______lambda210__gsource_func, block2_data_ref (_data2_), block2_data_unref);
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	(upcoming_events_children == NULL) ? NULL : (upcoming_events_children = (g_list_free (upcoming_events_children), NULL));
	(selected_date_events_children == NULL) ? NULL : (selected_date_events_children = (g_list_free (selected_date_events_children), NULL));
}

/**
     * Calendar model parameters have been updated.
     */
static void
maya_view_agenda_view_on_model_parameters_changed (MayaViewAgendaView* self)
{
	GList* selected_date_events_children = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* upcoming_events_children = NULL;
	GtkListBox* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_date_events_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	selected_date_events_children = _tmp1_;
	_tmp2_ = self->priv->upcoming_events_list;
	_tmp3_ = gtk_container_get_children ((GtkContainer*) _tmp2_);
	upcoming_events_children = _tmp3_;
	_tmp4_ = selected_date_events_children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp4_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GtkWidget* _tmp5_;
				_tmp5_ = row;
				gtk_widget_destroy (_tmp5_);
			}
		}
	}
	_tmp6_ = upcoming_events_children;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp6_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkWidget* row = NULL;
			row = (GtkWidget*) row_it->data;
			{
				GtkWidget* _tmp7_;
				_tmp7_ = row;
				gtk_widget_destroy (_tmp7_);
			}
		}
	}
	(upcoming_events_children == NULL) ? NULL : (upcoming_events_children = (g_list_free (upcoming_events_children), NULL));
	(selected_date_events_children == NULL) ? NULL : (selected_date_events_children = (g_list_free (selected_date_events_children), NULL));
}

static void
maya_view_agenda_view_on_today_changed (MayaViewAgendaView* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->upcoming_events_list;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp1_ = self->priv->upcoming_events_list;
	gtk_list_box_invalidate_headers (_tmp1_);
}

/**
     * The given date has been selected.
     */
static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
maya_view_agenda_view_set_selected_date (MayaViewAgendaView* self,
                                         GDateTime* date)
{
	GDateTime* _tmp0_;
	gchar* formated_weekday = NULL;
	gchar* _tmp1_;
	gchar* new_value = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gchar* format = NULL;
	gchar* _tmp9_;
	GtkLabel* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkListBox* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = _g_date_time_ref0 (date);
	_g_date_time_unref0 (self->priv->selected_date);
	self->priv->selected_date = _tmp0_;
	_tmp1_ = g_date_time_format (date, "%A");
	formated_weekday = _tmp1_;
	_tmp2_ = string_substring (formated_weekday, (glong) string_index_of_nth_char (formated_weekday, (glong) 1), (glong) -1);
	new_value = _tmp2_;
	_tmp3_ = g_unichar_to_string (g_unichar_totitle (string_get_char (formated_weekday, (glong) 0)));
	_tmp4_ = _tmp3_;
	_tmp5_ = new_value;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_g_free0 (new_value);
	new_value = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp7_ = self->priv->weekday_label;
	_tmp8_ = new_value;
	gtk_label_set_label (_tmp7_, _tmp8_);
	_tmp9_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
	format = _tmp9_;
	_tmp10_ = self->priv->day_label;
	_tmp11_ = g_date_time_format (date, format);
	_tmp12_ = _tmp11_;
	gtk_label_set_label (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->selected_date_events_list;
	gtk_list_box_invalidate_filter (_tmp13_);
	_g_free0 (format);
	_g_free0 (new_value);
	_g_free0 (formated_weekday);
}

MayaViewAgendaView*
maya_view_agenda_view_construct (GType object_type)
{
	MayaViewAgendaView * self = NULL;
	self = (MayaViewAgendaView*) g_object_new (object_type, NULL);
	return self;
}

MayaViewAgendaView*
maya_view_agenda_view_new (void)
{
	return maya_view_agenda_view_construct (MAYA_VIEW_TYPE_AGENDA_VIEW);
}

HdyHeaderBar*
maya_view_agenda_view_get_header_bar (MayaViewAgendaView* self)
{
	HdyHeaderBar* result;
	HdyHeaderBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}

static void
maya_view_agenda_view_set_header_bar (MayaViewAgendaView* self,
                                      HdyHeaderBar* value)
{
	HdyHeaderBar* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_agenda_view_get_header_bar (self);
	if (old_value != value) {
		HdyHeaderBar* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_header_bar);
		self->priv->_header_bar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_agenda_view_properties[MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY]);
	}
}

static void
_maya_view_agenda_view_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                           GtkListBoxRow* before,
                                                                           gpointer self)
{
	maya_view_agenda_view_header_update_func ((MayaViewAgendaView*) self, row, before);
}

static gint
_maya_view_agenda_view_selected_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self)
{
	gint result;
	result = maya_view_agenda_view_selected_sort_function (row1, row2, (MayaViewAgendaView*) self);
	return result;
}

static gboolean
_maya_view_agenda_view___lambda211_ (MayaViewAgendaView* self,
                                     GtkListBoxRow* row)
{
	GDateTime* _tmp0_;
	MayaViewAgendaEventRow* event_row = NULL;
	MayaViewAgendaEventRow* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	GDateTime* _tmp4_;
	gboolean result;
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->selected_date;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	event_row = G_TYPE_CHECK_INSTANCE_CAST (row, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow);
	_tmp1_ = event_row;
	_tmp2_ = maya_view_agenda_event_row_get_calevent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->selected_date;
	result = calendar_util_ecalcomponent_is_on_day (_tmp3_, _tmp4_);
	return result;
}

static gboolean
__maya_view_agenda_view___lambda211__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                               gpointer self)
{
	gboolean result;
	result = _maya_view_agenda_view___lambda211_ ((MayaViewAgendaView*) self, row);
	return result;
}

static void
_maya_view_agenda_view_upcoming_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                    GtkListBoxRow* before,
                                                                                    gpointer self)
{
	maya_view_agenda_view_upcoming_header_update_func ((MayaViewAgendaView*) self, row, before);
}

static gint
_maya_view_agenda_view_upcoming_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                      GtkListBoxRow* row2,
                                                                      gpointer self)
{
	gint result;
	result = maya_view_agenda_view_upcoming_sort_function (row1, row2, (MayaViewAgendaView*) self);
	return result;
}

static gboolean
_maya_view_agenda_view___lambda212_ (MayaViewAgendaView* self,
                                     GtkListBoxRow* row)
{
	MayaViewAgendaEventRow* event_row = NULL;
	MayaViewAgendaEventRow* _tmp0_;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	ICalComponent* comp = NULL;
	MayaViewAgendaEventRow* _tmp2_;
	ECalComponent* _tmp3_;
	ECalComponent* _tmp4_;
	ICalComponent* _tmp5_;
	GDateTime* stripped_time = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* stripped_time_end = NULL;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	CalendarUtilDateRange* range = NULL;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	CalendarUtilDateRange* _tmp19_;
	ICalComponent* _tmp20_;
	CalendarUtilDateRange* _tmp21_;
	gboolean result;
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, MAYA_VIEW_TYPE_AGENDA_EVENT_ROW, MayaViewAgendaEventRow));
	event_row = _tmp0_;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = event_row;
	_tmp3_ = maya_view_agenda_event_row_get_calevent (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = e_cal_component_get_icalcomponent (_tmp4_);
	comp = _tmp5_;
	_tmp6_ = now;
	_tmp7_ = now;
	_tmp8_ = now;
	_tmp9_ = g_date_time_new_local (g_date_time_get_year (_tmp6_), g_date_time_get_month (_tmp7_), g_date_time_get_day_of_month (_tmp8_), 0, 0, (gdouble) 0);
	stripped_time = _tmp9_;
	_tmp10_ = stripped_time;
	_tmp11_ = g_date_time_add_days (_tmp10_, 1);
	_g_date_time_unref0 (stripped_time);
	stripped_time = _tmp11_;
	_tmp12_ = now;
	_tmp13_ = now;
	_tmp14_ = g_date_time_new_local (g_date_time_get_year (_tmp12_), g_date_time_get_month (_tmp13_), 1, 0, 0, (gdouble) 0);
	stripped_time_end = _tmp14_;
	_tmp15_ = stripped_time_end;
	_tmp16_ = g_date_time_add_months (_tmp15_, 2);
	_g_date_time_unref0 (stripped_time_end);
	stripped_time_end = _tmp16_;
	_tmp17_ = stripped_time;
	_tmp18_ = stripped_time_end;
	_tmp19_ = calendar_util_date_range_new (_tmp17_, _tmp18_);
	range = _tmp19_;
	_tmp20_ = comp;
	_tmp21_ = range;
	result = calendar_util_icalcomponent_is_in_range (_tmp20_, _tmp21_);
	_g_object_unref0 (range);
	_g_date_time_unref0 (stripped_time_end);
	_g_date_time_unref0 (stripped_time);
	_g_date_time_unref0 (now);
	_g_object_unref0 (event_row);
	return result;
}

static gboolean
__maya_view_agenda_view___lambda212__gtk_list_box_filter_func (GtkListBoxRow* row,
                                                               gpointer self)
{
	gboolean result;
	result = _maya_view_agenda_view___lambda212_ ((MayaViewAgendaView*) self, row);
	return result;
}

static void
_maya_view_agenda_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                          ESource* source,
                                                                          GeeCollection* events,
                                                                          gpointer self)
{
	maya_view_agenda_view_on_events_added ((MayaViewAgendaView*) self, source, events);
}

static void
_maya_view_agenda_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                              ESource* source,
                                                                              GeeCollection* events,
                                                                              gpointer self)
{
	maya_view_agenda_view_on_events_removed ((MayaViewAgendaView*) self, source, events);
}

static void
_maya_view_agenda_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                              ESource* source,
                                                                              GeeCollection* events,
                                                                              gpointer self)
{
	maya_view_agenda_view_on_events_updated ((MayaViewAgendaView*) self, source, events);
}

static void
_maya_view_agenda_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                            gpointer self)
{
	maya_view_agenda_view_on_model_parameters_changed ((MayaViewAgendaView*) self);
}

static void
_maya_view_agenda_view_on_today_changed_calendar_time_manager_on_update_today (CalendarTimeManager* _sender,
                                                                               gpointer self)
{
	maya_view_agenda_view_on_today_changed ((MayaViewAgendaView*) self);
}

static void
_maya_view_agenda_view_activate_eventrow_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self)
{
	maya_view_agenda_view_activate_eventrow ((MayaViewAgendaView*) self, row);
}

static GObject *
maya_view_agenda_view_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewAgendaView * self;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkButton* button_add = NULL;
	gchar* _tmp2_;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkApplication* _tmp5_;
	GtkButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_;
	GtkStyleContext* _tmp16_;
	HdyHeaderBar* _tmp17_ = NULL;
	HdyHeaderBar* _tmp18_;
	HdyHeaderBar* _tmp19_;
	GtkLabel* _tmp20_;
	HdyHeaderBar* _tmp21_;
	GtkButton* _tmp22_;
	HdyHeaderBar* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkLabel* _tmp25_ = NULL;
	GtkLabel* _tmp26_;
	GtkStyleContext* _tmp27_;
	GtkLabel* placeholder_label = NULL;
	GtkLabel* _tmp28_ = NULL;
	GtkLabel* _tmp29_;
	GtkStyleContext* _tmp30_;
	GtkLabel* _tmp31_;
	GtkListBox* _tmp32_ = NULL;
	GtkListBox* _tmp33_;
	GtkListBox* _tmp34_;
	GtkLabel* _tmp35_;
	GtkListBox* _tmp36_;
	GtkListBox* _tmp37_;
	GtkListBox* _tmp38_ = NULL;
	GtkListBox* _tmp39_;
	GtkListBox* _tmp40_;
	GtkListBox* _tmp41_;
	GtkBox* box = NULL;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkLabel* _tmp44_;
	GtkBox* _tmp45_;
	GtkListBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkListBox* _tmp48_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkBox* _tmp49_;
	GtkWidget* _tmp50_;
	GtkScrolledWindow* _tmp51_ = NULL;
	HdyHeaderBar* _tmp52_;
	GtkScrolledWindow* _tmp53_;
	GtkStyleContext* _tmp54_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp55_;
	CalendarEventStore* _tmp56_;
	CalendarEventStore* _tmp57_;
	CalendarEventStore* _tmp58_;
	CalendarEventStore* _tmp59_;
	CalendarTimeManager* time_manager = NULL;
	CalendarTimeManager* _tmp60_;
	CalendarTimeManager* _tmp61_;
	GDateTime* _tmp62_;
	GDateTime* _tmp63_;
	GtkListBox* _tmp64_;
	GtkListBox* _tmp65_;
	parent_class = G_OBJECT_CLASS (maya_view_agenda_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp1_;
	_tmp2_ = g_strdup (MAYA_MAIN_WINDOW_ACTION_PREFIX MAYA_MAIN_WINDOW_ACTION_NEW_EVENT);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("appointment-new", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	button_add = _tmp3_;
	_tmp4_ = button_add;
	_tmp5_ = application_instance;
	_tmp6_ = button_add;
	_tmp7_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = _tmp9_ = gtk_application_get_accels_for_action (_tmp5_, _tmp8_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _vala_array_length (_tmp9_);
	_tmp12_ = granite_markup_accel_tooltip (_tmp11_, (gint) _vala_array_length (_tmp9_), _ ("Create a new event"));
	_tmp13_ = _tmp12_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_margin_start ((GtkWidget*) _tmp14_, 6);
	gtk_label_set_xalign (_tmp14_, (gfloat) 0);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->weekday_label);
	self->priv->weekday_label = _tmp14_;
	_tmp15_ = self->priv->weekday_label;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	gtk_style_context_add_class (_tmp16_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp17_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp17_, TRUE);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	maya_view_agenda_view_set_header_bar (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_header_bar;
	_tmp20_ = self->priv->weekday_label;
	hdy_header_bar_pack_start (_tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_header_bar;
	_tmp22_ = button_add;
	hdy_header_bar_pack_end (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->_header_bar;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, GTK_STYLE_CLASS_FLAT);
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_margin_start ((GtkWidget*) _tmp25_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp25_, 12);
	gtk_label_set_xalign (_tmp25_, (gfloat) 0);
	g_object_ref_sink (_tmp25_);
	_g_object_unref0 (self->priv->day_label);
	self->priv->day_label = _tmp25_;
	_tmp26_ = self->priv->day_label;
	_tmp27_ = gtk_widget_get_style_context ((GtkWidget*) _tmp26_);
	gtk_style_context_add_class (_tmp27_, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp28_ = (GtkLabel*) gtk_label_new (_ ("Your upcoming events will be displayed here when you select a date wit" \
"h events."));
	g_object_set (_tmp28_, "wrap", TRUE, NULL);
	g_object_set (_tmp28_, "wrap-mode", PANGO_WRAP_WORD, NULL);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp28_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp28_, 12);
	gtk_label_set_justify (_tmp28_, GTK_JUSTIFY_CENTER);
	g_object_ref_sink (_tmp28_);
	placeholder_label = _tmp28_;
	_tmp29_ = placeholder_label;
	_tmp30_ = gtk_widget_get_style_context ((GtkWidget*) _tmp29_);
	gtk_style_context_add_class (_tmp30_, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp31_ = placeholder_label;
	gtk_widget_show_all ((GtkWidget*) _tmp31_);
	_tmp32_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp32_, FALSE);
	g_object_set ((GtkWidget*) _tmp32_, "height-request", 128, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp32_, TRUE);
	gtk_list_box_set_selection_mode (_tmp32_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->selected_date_events_list);
	self->priv->selected_date_events_list = _tmp32_;
	_tmp33_ = self->priv->selected_date_events_list;
	gtk_list_box_set_header_func (_tmp33_, _maya_view_agenda_view_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp34_ = self->priv->selected_date_events_list;
	_tmp35_ = placeholder_label;
	gtk_list_box_set_placeholder (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->selected_date_events_list;
	gtk_list_box_set_sort_func (_tmp36_, _maya_view_agenda_view_selected_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp37_ = self->priv->selected_date_events_list;
	gtk_list_box_set_filter_func (_tmp37_, __maya_view_agenda_view___lambda211__gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp38_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp38_, FALSE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp38_, 24);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp38_, TRUE);
	gtk_list_box_set_selection_mode (_tmp38_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->upcoming_events_list);
	self->priv->upcoming_events_list = _tmp38_;
	_tmp39_ = self->priv->upcoming_events_list;
	gtk_list_box_set_header_func (_tmp39_, _maya_view_agenda_view_upcoming_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp40_ = self->priv->upcoming_events_list;
	gtk_list_box_set_sort_func (_tmp40_, _maya_view_agenda_view_upcoming_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp41_ = self->priv->upcoming_events_list;
	gtk_list_box_set_filter_func (_tmp41_, __maya_view_agenda_view___lambda212__gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp42_);
	box = _tmp42_;
	_tmp43_ = box;
	_tmp44_ = self->priv->day_label;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = box;
	_tmp46_ = self->priv->selected_date_events_list;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = box;
	_tmp48_ = self->priv->upcoming_events_list;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = box;
	_tmp50_ = _g_object_ref0 ((GtkWidget*) _tmp49_);
	_tmp51_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set (_tmp51_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set ((GtkContainer*) _tmp51_, "child", _tmp50_, NULL);
	_g_object_unref0 (_tmp50_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp51_, TRUE);
	g_object_ref_sink (_tmp51_);
	scrolled_window = _tmp51_;
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp52_ = self->priv->_header_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp52_);
	_tmp53_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp53_);
	_tmp54_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp54_, GTK_STYLE_CLASS_VIEW);
	_tmp55_ = calendar_event_store_get_default ();
	calmodel = _tmp55_;
	_tmp56_ = calmodel;
	g_signal_connect_object (_tmp56_, "events-added", (GCallback) _maya_view_agenda_view_on_events_added_calendar_event_store_events_added, self, 0);
	_tmp57_ = calmodel;
	g_signal_connect_object (_tmp57_, "events-removed", (GCallback) _maya_view_agenda_view_on_events_removed_calendar_event_store_events_removed, self, 0);
	_tmp58_ = calmodel;
	g_signal_connect_object (_tmp58_, "events-updated", (GCallback) _maya_view_agenda_view_on_events_updated_calendar_event_store_events_updated, self, 0);
	_tmp59_ = calmodel;
	g_signal_connect_object (_tmp59_, "parameters-changed", (GCallback) _maya_view_agenda_view_on_model_parameters_changed_calendar_event_store_parameters_changed, self, 0);
	_tmp60_ = calendar_time_manager_get_default ();
	time_manager = _tmp60_;
	_tmp61_ = time_manager;
	g_signal_connect_object (_tmp61_, "on-update-today", (GCallback) _maya_view_agenda_view_on_today_changed_calendar_time_manager_on_update_today, self, 0);
	_tmp62_ = maya_application_get_selected_datetime ();
	_tmp63_ = _tmp62_;
	maya_view_agenda_view_set_selected_date (self, _tmp63_);
	_g_date_time_unref0 (_tmp63_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp64_ = self->priv->selected_date_events_list;
	g_signal_connect_object (_tmp64_, "row-activated", (GCallback) _maya_view_agenda_view_activate_eventrow_gtk_list_box_row_activated, self, 0);
	_tmp65_ = self->priv->upcoming_events_list;
	g_signal_connect_object (_tmp65_, "row-activated", (GCallback) _maya_view_agenda_view_activate_eventrow_gtk_list_box_row_activated, self, 0);
	_g_object_unref0 (calmodel);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (box);
	_g_object_unref0 (placeholder_label);
	_g_object_unref0 (button_add);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
maya_view_agenda_view_class_init (MayaViewAgendaViewClass * klass,
                                  gpointer klass_data)
{
	maya_view_agenda_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewAgendaView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_agenda_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_agenda_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_agenda_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_agenda_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY, maya_view_agenda_view_properties[MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY] = g_param_spec_object ("header-bar", "header-bar", "header-bar", hdy_header_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_agenda_view_signals[MAYA_VIEW_AGENDA_VIEW_EVENT_REMOVED_SIGNAL] = g_signal_new ("event-removed", MAYA_VIEW_TYPE_AGENDA_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_cal_component_get_type ());
}

static void
maya_view_agenda_view_instance_init (MayaViewAgendaView * self,
                                     gpointer klass)
{
	self->priv = maya_view_agenda_view_get_instance_private (self);
}

static void
maya_view_agenda_view_finalize (GObject * obj)
{
	MayaViewAgendaView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->day_label);
	_g_object_unref0 (self->priv->weekday_label);
	_g_object_unref0 (self->priv->selected_date_events_list);
	_g_object_unref0 (self->priv->upcoming_events_list);
	_g_date_time_unref0 (self->priv->selected_date);
	G_OBJECT_CLASS (maya_view_agenda_view_parent_class)->finalize (obj);
}

static GType
maya_view_agenda_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewAgendaViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_agenda_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewAgendaView), 0, (GInstanceInitFunc) maya_view_agenda_view_instance_init, NULL };
	GType maya_view_agenda_view_type_id;
	maya_view_agenda_view_type_id = g_type_register_static (gtk_box_get_type (), "MayaViewAgendaView", &g_define_type_info, 0);
	MayaViewAgendaView_private_offset = g_type_add_instance_private (maya_view_agenda_view_type_id, sizeof (MayaViewAgendaViewPrivate));
	return maya_view_agenda_view_type_id;
}

GType
maya_view_agenda_view_get_type (void)
{
	static volatile gsize maya_view_agenda_view_type_id__once = 0;
	if (g_once_init_enter (&maya_view_agenda_view_type_id__once)) {
		GType maya_view_agenda_view_type_id;
		maya_view_agenda_view_type_id = maya_view_agenda_view_get_type_once ();
		g_once_init_leave (&maya_view_agenda_view_type_id__once, maya_view_agenda_view_type_id);
	}
	return maya_view_agenda_view_type_id__once;
}

static void
_vala_maya_view_agenda_view_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	MayaViewAgendaView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView);
	switch (property_id) {
		case MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY:
		g_value_set_object (value, maya_view_agenda_view_get_header_bar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_agenda_view_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	MayaViewAgendaView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView);
	switch (property_id) {
		case MAYA_VIEW_AGENDA_VIEW_HEADER_BAR_PROPERTY:
		maya_view_agenda_view_set_header_bar (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

