// third_party/blink/public/mojom/storage_key/storage_key.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "third_party/blink/public/mojom/storage_key/ancestor_chain_bit.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class StorageKeyDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::StorageKeyDataView> {
  using Data = ::blink::mojom::internal::StorageKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class StorageKeyDataView {
 public:
  StorageKeyDataView() = default;

  StorageKeyDataView(
      internal::StorageKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetTopLevelSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSite(UserType* output) {
    
    auto* pointer = data_->top_level_site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorChainBit(UserType* output) const {
    auto data_value = data_->ancestor_chain_bit;
    return mojo::internal::Deserialize<::blink::mojom::AncestorChainBit>(
        data_value, output);
  }
  ::blink::mojom::AncestorChainBit ancestor_chain_bit() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AncestorChainBit>(data_->ancestor_chain_bit));
  }
  inline void GetTopLevelSiteIfThirdPartyEnabledDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopLevelSiteIfThirdPartyEnabled(UserType* output) {
    
    auto* pointer = data_->top_level_site_if_third_party_enabled.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAncestorChainBitIfThirdPartyEnabled(UserType* output) const {
    auto data_value = data_->ancestor_chain_bit_if_third_party_enabled;
    return mojo::internal::Deserialize<::blink::mojom::AncestorChainBit>(
        data_value, output);
  }
  ::blink::mojom::AncestorChainBit ancestor_chain_bit_if_third_party_enabled() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AncestorChainBit>(data_->ancestor_chain_bit_if_third_party_enabled));
  }
 private:
  internal::StorageKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::StorageKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::StorageKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::StorageKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_origin, origin_fragment);
    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in StorageKey struct");
    decltype(Traits::top_level_site(input)) in_top_level_site = Traits::top_level_site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_level_site)::BaseType> top_level_site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_top_level_site, top_level_site_fragment);
    fragment->top_level_site.Set(
        top_level_site_fragment.is_null() ? nullptr : top_level_site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_level_site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_level_site in StorageKey struct");
    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_nonce, nonce_fragment);
    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());
    mojo::internal::Serialize<::blink::mojom::AncestorChainBit>(
        Traits::ancestor_chain_bit(input), &fragment->ancestor_chain_bit);
    decltype(Traits::top_level_site_if_third_party_enabled(input)) in_top_level_site_if_third_party_enabled = Traits::top_level_site_if_third_party_enabled(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_level_site_if_third_party_enabled)::BaseType> top_level_site_if_third_party_enabled_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_top_level_site_if_third_party_enabled, top_level_site_if_third_party_enabled_fragment);
    fragment->top_level_site_if_third_party_enabled.Set(
        top_level_site_if_third_party_enabled_fragment.is_null() ? nullptr : top_level_site_if_third_party_enabled_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_level_site_if_third_party_enabled.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_level_site_if_third_party_enabled in StorageKey struct");
    mojo::internal::Serialize<::blink::mojom::AncestorChainBit>(
        Traits::ancestor_chain_bit_if_third_party_enabled(input), &fragment->ancestor_chain_bit_if_third_party_enabled);
  }

  static bool Deserialize(::blink::mojom::internal::StorageKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::StorageKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void StorageKeyDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void StorageKeyDataView::GetTopLevelSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_level_site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void StorageKeyDataView::GetNonceDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void StorageKeyDataView::GetTopLevelSiteIfThirdPartyEnabledDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->top_level_site_if_third_party_enabled.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_STORAGE_KEY_STORAGE_KEY_MOJOM_SHARED_H_