/**CFile****************************************************************
Copyright (c) The Regents of the University of California. All rights reserved.

Permission is hereby granted, without written agreement and without license or
royalty fees, to use, copy, modify, and distribute this software and its
documentation for any purpose, provided that the above copyright notice and
the following two paragraphs appear in all copies of this software.

IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS,
AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE,
SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


  FileName    [dar_.c]

  SystemName  [ABC: Logic synthesis and verification system.]

  PackageName [DAG-aware AIG rewriting.]

  Synopsis    [Storage for AIG subgraph data.]

  Author      [Alan Mishchenko]
  
  Affiliation [UC Berkeley]

  Date        [Ver. 1.0. Started - April 28, 2007.]

  Revision    [$Id: dar_.c,v 1.00 2007/04/28 00:00:00 alanmi Exp $]

***********************************************************************/

#include "darInt.h"

////////////////////////////////////////////////////////////////////////
///                        DECLARATIONS                              ///
////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////
///                     FUNCTION DEFINITIONS                         ///
////////////////////////////////////////////////////////////////////////

const int s_nDataSize1 = 2*43906;
unsigned int s_Data1[2*43906] = {
    4,    6,    5,    7,    9,   11,    5,    6,    4,    7,   15,   17,
    2,    8,    4,   21,    3,   10,    5,   25,    7,   25,    9,   25,
    2,   10,    7,   33,    9,   33,    2,   14,    5,   39,    6,   39,
   17,   39,    3,   16,    7,   47,   33,   47,    2,   16,    4,   53,
    7,   53,    3,   14,    5,   59,   17,   59,   53,   59,    3,   11,
    7,   67,    4,   68,    5,   66,    6,   73,   33,   67,    7,   76,
    5,   77,    9,   77,    9,   66,   33,   85,    3,    9,    4,   88,
    7,   91,   88,   93,    6,   88,   21,   89,   11,   89,   21,  100,
   25,  101,   11,   88,    7,  107,   33,  107,    2,   11,    5,  113,
    7,  112,   30,  113,   25,  113,    5,  120,    7,  121,    9,  120,
    9,  113,   25,  128,   21,  129,    9,  112,    2,    9,    6,  137,
    5,  138,   11,  136,    3,   17,    7,  144,  113,  145,   15,  144,
  113,  151,    3,   15,    6,  155,    4,  156,   17,  154,  113,  161,
    2,   17,    7,  165,    5,  166,  155,  165,   15,  164,    2,   15,
    6,  174,   17,  174,    3,   13,  113,  181,  135,  181,  143,  181,
    2,   12,    9,  189,  181,  189,    9,  192,    2,   13,   85,  197,
  107,  197,    3,   12,    7,  203,   11,  203,   33,  203,  197,  203,
    9,  211,    3,   19,    7,  215,   33,  215,  173,  215,  179,  215,
    2,   18,  215,  225,    2,   19,  151,  229,  161,  229,    3,   18,
  113,  235,  229,  235,    2,    4,   25,  241,    9,  241,   15,  241,
   11,  241,    6,  240,    7,  240,   59,  253,    7,  241,    9,  257,
    6,  241,  253,  261,    3,    5,  251,  265,    6,  266,  241,  269,
  253,  265,    7,  272,    7,  273,  241,  277,   53,  265,    7,  280,
  248,  265,    9,  285,   11,  265,  241,  288,    9,  291,   17,  265,
    9,  265,  257,  265,   25,  299,  251,  298,    7,  264,    3,  305,
    5,  305,  128,  305,  101,  305,  299,  305,  241,  305,    7,  317,
  265,  319,    9,  305,  113,  322,  113,  305,    9,  326,    6,  264,
  241,  331,   17,  331,   53,  331,  253,  331,    7,  265,   59,  341,
  241,  343,  331,  341,  241,  346,  241,  347,   15,  341,  113,  353,
  241,  340,    7,  357,  265,  357,   59,  357,  331,  357,  256,  265,
    7,  367,   59,  367,  331,  367,    6,  265,    5,  375,  242,  375,
  316,  375,   25,  375,  241,  382,  305,  375,  241,  386,  241,  387,
   11,  375,  241,  375,  265,  394,    7,  397,   25,  394,  305,  394,
  251,  395,  257,  375,  241,  374,  260,  265,  241,  265,  251,  413,
  331,  413,  261,  413,  375,  413,  257,  413,   19,  413,   12,  413,
   11,  413,    9,  428,    9,  413,   11,  433,   11,  432,   15,  413,
   11,  412,    9,  441,    7,  413,  241,  445,  265,  445,  375,  445,
  409,  445,  411,  445,    6,  412,  241,  457,  445,  457,  241,  460,
    6,  413,  357,  465,  367,  465,    7,  412,  265,  471,   59,  471,
  331,  471,  465,  471,  241,  479,    2,    6,  353,  483,  322,  483,
   30,  483,   25,  483,    9,  490,  305,  483,    9,  494,   19,  483,
  413,  483,   12,  483,  244,  483,  241,  483,    9,  506,    9,  483,
  305,  510,   25,  510,   11,  510,  241,  510,  257,  510,  247,  483,
   11,  483,    2,  524,    4,  527,    5,  524,    3,  531,    9,  524,
  258,  483,  151,  483,  257,  483,    9,  540,  155,  483,   17,  545,
  235,  483,  181,  483,  161,  483,    4,  482,    2,  555,    5,  482,
    2,  559,    6,  559,   17,  559,    5,  483,    2,  567,    6,  566,
  241,  567,  483,  573,    9,  573,    9,  567,    4,  483,    6,  581,
    3,  582,    3,    7,  289,  587,  510,  587,   11,  591,   11,  590,
  516,  587,  413,  587,  483,  598,  498,  587,  500,  587,   19,  587,
  483,  606,  502,  587,   12,  587,  483,  612,  534,  587,  524,  587,
    9,  618,  288,  587,  305,  623,   25,  623,   11,  587,  265,  629,
  331,  631,  510,  628,    9,  628,  483,  636,  483,  628,    9,  640,
  265,  628,  305,  645,   25,  645,  375,  628,  265,  587,   11,  653,
   33,  655,   11,  652,   25,  659,  305,  659,  295,  587,  241,  587,
    9,  587,    4,  668,    2,  671,    3,  668,    5,  675,  524,  668,
  483,  668,   11,  681,   11,  680,   11,  668,  483,  686,  392,  587,
  165,  587,  375,  587,   17,  695,   11,  695,   11,  694,  113,  587,
  567,  587,  305,  705,   25,  705,  555,  704,    5,  586,    3,  713,
    7,  713,  623,  713,  645,  713,  659,  713,  128,  713,  394,  713,
  101,  713,  299,  713,  705,  713,  510,  713,  483,  713,    9,  736,
    9,  713,  113,  740,  483,  740,  241,  713,  375,  746,  375,  713,
  241,  750,  113,  713,    9,  754,    4,  586,    7,  759,  589,  759,
   33,  759,    5,  587,    7,  767,    2,  768,   47,  767,  483,  773,
  759,  767,  483,  777,   17,  767,  113,  781,  483,  781,  483,  766,
   47,  787,  759,  787,   17,  787,  566,  587,   47,  795,  759,  795,
   17,  795,    4,  587,    3,  803,    6,  805,    7,  802,  494,  803,
  490,  803,  736,  803,   25,  803,  483,  816,  305,  803,  483,  820,
  713,  803,  483,  824,  483,  803,  305,  828,   25,  828,  713,  828,
  555,  829,  483,  802,  580,  587,  483,  587,  413,  842,   19,  842,
   12,  842,   11,  843,    9,  851,    9,  842,   11,  855,   11,  854,
   11,  842,    9,  860,    5,  843,  803,  865,    9,  865,  839,  865,
  841,  865,    4,  842,  483,  875,  865,  875,  483,  878,    4,  843,
  787,  883,  795,  883,    5,  842,  587,  889,   47,  889,  759,  889,
   17,  889,  883,  889,  483,  899,    3,    4,  559,  903,   19,  903,
   12,  903,  842,  903,  587,  903,  483,  912,  165,  912,    9,  903,
   11,  918,  483,  903,  241,  923,  555,  923,  587,  922,   11,  922,
   15,  903,   11,  903,    9,  934,  483,  934,  524,  903,  692,  903,
  767,  903,  375,  945,  165,  903,    7,  949,  587,  948,    6,  902,
    3,  955,    7,  902,  787,  959,  795,  959,  889,  959,  767,  959,
  483,  967,   33,  959,    7,  903,  956,  973,   88,  973,    4,  973,
    3,  973,  955,  980,    9,  980,    3,  972,    4,  972,  955,  973,
    3,  990,  375,  973,    9,  973,    3,  996,    6,  903,    4, 1001,
    3, 1001,    3, 1000,    4, 1000,    2,    5,  955, 1011,  914, 1011,
  918, 1011,   11, 1017,   11, 1016,  912, 1011,  483, 1022,  920, 1011,
  906, 1011,   19, 1011,  903, 1030,  842, 1011,  903, 1034,  908, 1011,
  910, 1011,   12, 1011,  903, 1042,  922, 1011,  587, 1046,  928, 1011,
  936, 1011,  934, 1011,    9, 1054,   15, 1011,   11, 1011,  918, 1060,
    9, 1060,  903, 1064,  903, 1060,    9, 1068,  483, 1011,  912, 1072,
  903, 1072,  587, 1076,  587, 1072,  903, 1080,  155, 1072,  587, 1011,
  922, 1086,  483, 1086,  903, 1090,  903, 1086,  483, 1094,   11, 1087,
    9, 1099,    9, 1086,   11, 1103,   17, 1011,    9, 1011,  934, 1108,
  903, 1108,   11, 1113,   11, 1112,   11, 1108,  903, 1118,  587, 1108,
   11, 1123,  668, 1011,   11, 1127,  544, 1011,  155, 1011,  483, 1132,
   67, 1011,  375, 1137,    7, 1010,    2, 1141,  959, 1141,   85, 1141,
  107, 1141,  203, 1141,   67, 1141,    9, 1153,  215, 1141,   47, 1141,
  759, 1141,    6, 1010,    2, 1163,    5, 1163,   17, 1163,    7, 1011,
    2, 1171,    5, 1171,    2, 1170,    5, 1170, 1163, 1171,    5, 1180,
    2, 1181,  483, 1171,  903, 1170,  375, 1189,  972, 1011,  375, 1193,
    6, 1011,    2, 1197,    5, 1197,    2, 1196,    5, 1196, 1141, 1197,
    2, 1206,    5, 1207,  903, 1196, 1000, 1011,  903, 1011,   19, 1216,
  842, 1216,   12, 1216,   11, 1217,    9, 1225,  587, 1216,  483, 1228,
   11, 1216,    9, 1232,    9, 1216,   11, 1237,   11, 1236,   15, 1216,
  483, 1216,  587, 1244,    7, 1217,   59, 1249,  331, 1249, 1213, 1249,
 1215, 1249,    6, 1216, 1249, 1259,    6, 1217, 1189, 1263, 1193, 1263,
    7, 1216,  375, 1269, 1263, 1269,    3,    6,  413, 1275, 1216, 1275,
  241, 1275,    9, 1281,   11, 1283,   11, 1280,    9, 1287,   17, 1275,
    3, 1290,    5, 1293,    4, 1290,    2, 1297,  903, 1291, 1011, 1275,
   11, 1275,  241, 1304,    9, 1307,  248, 1275,    9, 1311,  973, 1275,
    9, 1315,  341, 1275,  803, 1319,    9, 1319,    5, 1274,    3, 1325,
   17, 1325,  357, 1325,  367, 1325,  471, 1325,  341, 1325,  241, 1337,
 1249, 1325,  253, 1325,   53, 1325,    5, 1275,    6, 1347,    2, 1348,
  918, 1347,  903, 1347,    9, 1354,    9, 1347,  903, 1358,    4, 1275,
    6, 1362,  265, 1363,    2,    7,  393, 1369,  334, 1369, 1325, 1369,
 1363, 1374,   17, 1374,   62, 1369,  331, 1369,   17, 1382,   59, 1369,
   17, 1386, 1328, 1369, 1304, 1369,    9, 1393,   17, 1369,  331, 1396,
  241, 1397,   59, 1396, 1325, 1396,   11, 1369, 1275, 1406,    9, 1409,
  265, 1369,  241, 1412,   11, 1413,   15, 1369,    5, 1418,    3, 1421,
    2, 1418,    4, 1425, 1011, 1419,  107, 1369,   67, 1369,  803, 1433,
    9, 1433, 1359, 1369,  203, 1369,  215, 1369,   85, 1369,    5, 1368,
    2, 1447,    7, 1447,   47, 1447,   85, 1447,  107, 1447,  203, 1447,
   67, 1447,    9, 1461,  215, 1447,  759, 1447,  959, 1447,    4, 1368,
    2, 1471,    7, 1471,  265, 1471,    7, 1476,  331, 1471,   59, 1471,
 1325, 1471,    5, 1369,    7, 1486,  803, 1487, 1275, 1486,  803, 1493,
    9, 1493, 1346, 1369,  803, 1499,    9, 1499,    4, 1369,    7, 1505,
    3, 1506, 1060, 1505,   11, 1505, 1011, 1512, 1011, 1505,    7, 1517,
   11, 1517,   11, 1516, 1347, 1505, 1275, 1504, 1362, 1369, 1275, 1369,
  413, 1531,   19, 1531,   12, 1531, 1216, 1531, 1011, 1531,  903, 1540,
    9, 1531,   11, 1545,   11, 1544,   11, 1531,    9, 1550,  903, 1531,
 1011, 1554,   11, 1530,    9, 1559,    5, 1531,  959, 1563,   47, 1563,
  759, 1563,   17, 1563, 1527, 1563, 1529, 1563,    4, 1530, 1563, 1577,
    4, 1531, 1493, 1581, 1499, 1581,    5, 1530,  803, 1587,    9, 1587,
 1581, 1587,    1,  974,    1,  975,    1,  982,    1,  983,    0,  204,
    0,  195,    0,  881,    0,  463,    0,  212,    0,  900,    0,  480,
    0,  194,    0,  880,    0,  462,    0,  213,    0,  901,    0,  481,
    0,  205,    0,  216,    0,  217,    1,  446,    0,  448,    0,  415,
    0,  421,    1,   92,    0,   92,    1,   94, 1645, 1647,    1,   93,
   88, 1650, 1645, 1653,    0,   93,    1,   95, 1657, 1659,    0,  108,
    0,  109,    1,  360,    0,  368,    0,  358,    0,  414,    1,  447,
 1637, 1675,    0,  449, 1635, 1679,    0,  191,    0,  877,    0,  473,
    1,  473,    0,  459,    1,  459,    0,  891,    0,  207,    0,  458,
    0,  876,    0,  190,    1,  458,    0,  472,    0,  890,    0,  206,
    1,  472,    1,  977,    1,  976,    0,  399,    0,  398,    0,  397,
    7, 1722,    0,  275,    0,  269,  241, 1728,    0,  270,    1,  279,
    0,  321,    0,  274,    0,  271,    1,  278,    0,  320,    1,  277,
  241, 1746,    0,  319,  265, 1750,    1,  276,    0,  318,    1,  926,
    0, 1518,    0,  950,    0, 1519,    0,  951,    1,  998,    1,  999,
    0,  575,    0, 1478,    0,  282,    0, 1479,    0,  283,    0,  369,
    0,  359, 1667, 1785,    0,  420,    1,  422,    1,  927,    1, 1421,
    5, 1794, 1419, 1797,    3, 1794, 1799, 1801,    0,  527,    2, 1804,
  525, 1807,    4, 1804, 1809, 1811,    1,  671,    4, 1814,  669, 1817,
    2, 1814, 1819, 1821,    0, 1293,    3, 1824, 1291, 1827,    5, 1824,
 1829, 1831,    1, 1425,    2, 1834, 1419, 1837,    4, 1834, 1839, 1841,
    0,  531,    5, 1844,  525, 1847,    3, 1844, 1849, 1851,    1,  675,
    3, 1854,  669, 1857,    5, 1854, 1859, 1861,    0, 1297,    4, 1864,
 1291, 1867,    2, 1864, 1869, 1871,    1, 1422,    0,  528,    1,  672,
    0, 1294,    1, 1426,    0,  532,    1,  676,    0, 1298,    1,  123,
    0,   79,    1,  993,    0,  124,    1,   80,    0, 1210,    0, 1184,
    0,  125, 1891, 1905,    1,   81, 1893, 1909,    1,  122, 1897, 1913,
    0,   78, 1899, 1917,    0, 1208,    0, 1182,    1,  992,    1,  361,
 1671, 1927,    0,  574,    1,  984,    1,  985,    1,  114,    9, 1937,
    0,   68,    1,  980,  955, 1942,    9, 1942,    0,  568,    9, 1949,
    1,  924,    1,  925,    0,  306,  375, 1957,    0,  308, 1413, 1961,
    0,   26,    1,  306,    1,  308,    1,  714,    0, 1142,    0, 1448,
    0, 1450,    1, 1450, 1413, 1979,    0, 1474,    0,   54,    0,   56,
    1, 1472,    0, 1326,    0,   60,    1,   60,    0, 1166,    0,   40,
    1,  956,  973, 2001,  973, 2000,    0,  556,    1,   22,    0, 1475,
    1, 1165, 1168, 2012, 1169, 2013, 2015, 2017, 1168, 2013, 1169, 2012,
 2021, 2023,    1, 1167,    2, 2027, 1197, 2029, 1997, 2031,    0,   57,
    1,  957,    0, 1451, 1980, 2039, 1979, 2039, 1413, 2042, 1413, 2039,
 1979, 2046,    1, 1449,    5, 2051, 1451, 2053, 1975, 2055,    1, 1451,
 1977, 2059, 1413, 2061,    0,  307, 1967, 2065,  375, 2067,    0,  309,
 1969, 2071, 1413, 2073,    0,   41,    1,  307, 1958, 2079, 1957, 2079,
  375, 2082,  375, 2079, 1957, 2086,    1,  309, 1962, 2091, 1961, 2091,
 1413, 2094, 1413, 2091, 1961, 2098,    1,   41,    2, 2103,   43, 2105,
 1999, 2107,    1, 1143,    5, 2111, 1171, 2113, 1973, 2115,    1,  561,
  564, 2118,  565, 2119, 2121, 2123,  564, 2119,  565, 2118, 2127, 2129,
    0,   91,    7, 2132,    0,  569,    1,  981,    9, 2139,  955, 2139,
    0,   69,    9, 2145,    1,  115,    0,  432,    0,  500,    0, 1245,
    0, 1237,    0,  501,    0,  433,    1, 1415,    1,  348,    1,  388,
    1,  826,    1,  126,    1, 1376,    1,  380,    1,  814,    1,  118,
    1,  302,    1,  710,    1,  102,    1,  402,    1,  834,    1,  130,
    1,  404,    1,  836,    1,  132,    1,  314,    1,  732,    1,  104,
    0, 1236,    0, 1244,    1, 1414,    0,  202,    1,  888,    1,  202,
 1603, 2215,    0,  106,    1,  106, 1663, 2221,    1,  794,    0,  366,
    0,   84,    1,  786,    1,   84, 1941, 2233,    1,  390,    1,  994,
    1,  450,    1,  105,    1,  733,    1,  405,    1,  315,    1,  837,
    1,  133,    1,  407,    1,  451,    1,  391,    1, 1383,    0,  905,
    1,  905,    0, 1477,    1, 1477, 1775, 2269,    6, 2269,    7, 2269,
    6, 2268, 2275, 2277, 1983, 2269,    7, 2268, 2273, 2283,    0,  281,
    1,  281, 1777, 2289,    6, 2289,    7, 2289,    6, 2288, 2295, 2297,
 1987, 2289,    7, 2288, 2293, 2303,    1, 1387,    1,  406, 2227, 2309,
    1,  995,    0,  461,    1,  461, 1621, 2317, 1699, 2317,    0, 1261,
    1, 1261,    0,  879,    0,  193,    1,  879, 1619, 2331, 1701, 2331,
    1,  193, 1617, 2337, 1703, 2337,    0, 1579,    0,  211,    9, 2344,
    1, 1579,    1,  211, 1623, 2351, 1711, 2351,    0,  479,  241, 2356,
    0,  899,  483, 2360,    0,  227,    1,  479, 1627, 2367, 1707, 2367,
    1,  899, 1625, 2373, 1709, 2373,    1,  227,    0, 1273,    0, 1593,
    0,  239,    1, 1273,    1, 1593,    1,  239,    0,  478, 2367, 2393,
    1,  478, 2359, 2397, 1615, 2397, 2357, 2397, 1687, 2397,    0, 1272,
 2387, 2407,    1, 1272, 2381, 2411,    0,  898, 2373, 2415,    0,  210,
 2351, 2419,    1,  898, 2363, 2423, 1613, 2423, 2361, 2423, 1695, 2423,
    1,  210, 2347, 2433, 1611, 2433, 2345, 2433, 1697, 2433,    0, 1592,
 2389, 2443,    0,  192,    9, 2446, 2337, 2449, 2337, 2447,    1, 1592,
 2383, 2455,    1,  192, 1605, 2459, 2329, 2459, 1683, 2459,    0,  460,
  241, 2466, 2317, 2469, 2317, 2467,    0,  878,  483, 2474, 2331, 2477,
 2331, 2475,    0,  238, 2391, 2483,    1,  460, 1609, 2487, 2315, 2487,
 1691, 2487,    1,  878, 1607, 2495, 2327, 2495, 1685, 2495,    1,  238,
 2385, 2503,    0, 1260, 2325, 2507,    0, 1578, 2349, 2511,    0,  226,
 2379, 2515,    1, 1260, 2323, 2519,    1, 1578, 2343, 2523,    1,  226,
 2365, 2527,    1,  349,    1,  127,    1,  827,    1,  389,    1,  119,
    1,  815,    1,  381,    1, 1377,    1,  131,    1,  835,    1,  303,
    1,  403,    1,  711,    1,  103,    1, 1366,    1,  694,    1,  702,
    9, 2563,    0,  572,    1,  572, 1931, 2569,    0, 1516,    1, 1516,
 1761, 2575,    7, 2575,    6, 2574, 2579, 2581,    6, 2575,    7, 2574,
 2585, 2587,    0,  944,    0,  948,    1,  578,  587, 2595,    1,  948,
 1763, 2599,    7, 2599,    6, 2598, 2603, 2605,    6, 2599,    7, 2598,
 2609, 2611,    1, 1186,    1,  996,    3, 2616,    1,  544,    1,  465,
  471, 2622, 1687, 2625,    1,  197,  203, 2628, 1697, 2631,    1,  883,
  889, 2634, 1695, 2637,    1,  181,  189, 2640, 1683, 2643,    0,  445,
 1693, 2647, 1713, 2647,  265, 2646, 1675, 2653, 2257, 2647,  375, 2647,
  457, 2647,    1,  445,  264, 2662,  241, 2662, 1679, 2667,  375, 2662,
  457, 2662, 1691, 2673,    1,  865,  875, 2676, 1685, 2679,    0,  215,
    7, 2682,    1,  215, 1633, 2687,    1, 1563,    0,  457,  241, 2692,
 2317, 2695,    1,  457,  241, 2698,  445, 2699,  445, 2698, 1691, 2705,
    0,  875,  483, 2708, 2331, 2711,    1,  875,  865, 2714, 1685, 2717,
    0,  189,    9, 2720, 2337, 2723,    1,  189,  181, 2726, 1683, 2729,
    0,  203,    7, 2732, 2215, 2735,   11, 2732, 2351, 2739,    0,  471,
    7, 2742, 1689, 2745,  265, 2742, 2367, 2749,    0,  889,  587, 2752,
 2373, 2755,    1,  203, 1629, 2759,  197, 2758, 1697, 2763,    1,  471,
  265, 2766, 2647, 2769,  465, 2766, 1687, 2773,    1,  889,  883, 2776,
 1695, 2779,    0,  107,    7, 2782, 2221, 2785,    1,  107, 1665, 2789,
    1,  795,    0,  367, 2255, 2795,  375, 2795,    7, 2794,    1,  367,
  265, 2802, 1783, 2805,    0,   85,    7, 2808, 2233, 2811,    0,  357,
    7, 2814, 1927, 2817,    1,   85, 2145, 2821,    1,  357,  265, 2824,
 1785, 2827,    1,  787,    0,  573,  483, 2832, 2569, 2835,    1,  579,
    1,  573, 1773, 2841,    1,  997,    1,  545,    1, 1187,  903, 2849,
    1, 1367,    0,  949,    7, 2854, 2599, 2857,    0,  945,  483, 2861,
    1,  949, 1767, 2865,    0, 1517,    7, 2868, 2575, 2871,    1, 1517,
 1765, 2875,    1,  703,    1,  695,    1,  332,    1,  266, 1731, 2885,
 1733, 2885,    1, 1012,    1,   30,  113, 2892,    0,  316,  265, 2896,
  375, 2897,    0,  272,    7, 2902, 1735, 2903,    1,  736,  803, 2908,
    1,  316, 1737, 2913,  375, 2912,    1,  272, 1727, 2919,  241, 2918,
    0, 1374, 2545, 2925,    1, 1374, 1363, 2928,    1, 1382,    0,  904,
  483, 2934, 2265, 2937,    1,  904,    0, 1476,    7, 2942, 2269, 2945,
    1, 1476, 1779, 2949, 2011, 2949,    0,  280,    7, 2954, 2289, 2957,
    1,  280, 1781, 2961, 2035, 2961,    1, 1386,    1,   99,    1,  991,
    0, 1181,    2, 2972,    0,  347, 2165, 2977,    1,  347,    1,  263,
  273, 2983,  272, 2982, 2985, 2987,  272, 2983,  273, 2982, 2991, 2993,
    0,   77,    0, 1207,    5, 2998,    1,   77,    5, 3002, 1917, 3005,
    9, 3003,    0,  121,    7, 3010, 1913, 3013,    9, 3011,    0,  387,
 2259, 3019,    1,  121,    9, 3023,    1,  825,  483, 3027,    1,  387,
  241, 3030,  241, 3031,    1,   98,    0, 1206,    2, 3038,    0,  386,
 2237, 3043, 3033, 3043,    1,  386,  241, 3048,    1,  824,  483, 3052,
    1,  990,    3, 3056,    0,  120, 3023, 3061,    9, 3063,    0, 1180,
    5, 3066,    1,  120, 3016, 3071,    5, 3070, 1897, 3075, 3013, 3075,
 3011, 3071,    9, 3080,    9, 3070,    9, 3071, 3011, 3086,    0,   76,
 3008, 3091,    7, 3090, 1899, 3095, 3005, 3095, 3003, 3091,    9, 3100,
    9, 3091, 3003, 3104,    0,  346, 2531, 3109,    1,   76, 2997, 3113,
    9, 3115,    1,  776,    1,  346,  241, 3120, 2977, 3123,    1,   21,
    2, 3127, 1275, 3129,    9, 3131,    4, 3126, 3133, 3135,    2, 3126,
  668, 3139, 3135, 3141,  587, 3139,    9, 3144, 3135, 3147,    9, 3139,
  587, 3150, 3135, 3153,  100, 3126,  129, 3126,  129, 3127,  100, 3127,
   89, 3127,   11, 3164,   11, 3127,   89, 3169,   89, 3168,   89, 3126,
    0,   25, 2243, 3177, 2547, 3177, 2539, 3177, 2533, 3177, 3024, 3177,
    3, 3177, 1369, 3189,   11, 3191,    5, 3176, 3193, 3195,    3, 3176,
  524, 3199, 3195, 3201,  483, 3199,   11, 3204, 3195, 3207,   11, 3199,
  483, 3210, 3195, 3213, 3023, 3177,    9, 3216,  101, 3177,  128, 3177,
  113, 3177,    9, 3224,    9, 3177, 3023, 3228,  113, 3228,    1,   33,
    5, 3234,    6, 3237, 2997, 3235,    9, 3241, 3177, 3235,   67, 3235,
    9, 3247,   67, 3234, 3239, 3251,    1,   25,  128, 3254,  101, 3254,
  113, 3255,    9, 3254,  113, 3262,  113, 3254,    9, 3266,    9, 3267,
    0,   33, 2759, 3273, 2789, 3273, 2821, 3273,    9, 3273,   67, 3272,
    9, 3283,    1,  251,  298, 3286,  395, 3286,  395, 3287,  298, 3287,
  257, 3287,  265, 3297,  265, 3296,  265, 3287,  257, 3302,  265, 3286,
    0,  305, 2249, 3309, 2553, 3309, 2543, 3309, 2537, 3309, 3034, 3309,
 3031, 3309,  241, 3320, 3235, 3309,  299, 3309,  394, 3309,  375, 3309,
  241, 3330,  241, 3309, 3031, 3334,  375, 3334,  241, 3308,  375, 3341,
    1,  331, 2647, 3345,  413, 3345,  241, 3344, 1369, 3344,  341, 3344,
    0,  253,    7, 3356,  265, 3356, 3345, 3357,    1,  555,  923, 3364,
  923, 3365,  704, 3364,  829, 3364,  829, 3365,  704, 3365,    0,  713,
 2245, 3379, 2549, 3379, 2541, 3379, 2535, 3379, 3028, 3379, 3027, 3379,
  483, 3390, 3235, 3379,  705, 3379,  828, 3379,  803, 3379,  483, 3400,
  483, 3379, 3027, 3404,  803, 3404,    1,  759,    3, 3410,    6, 3413,
 3273, 3411,  767, 3410, 3415, 3419,    0,  559,    0,  251,  413, 3424,
  413, 3425,  257, 3425,  413, 3431,  412, 3430, 3433, 3435,  412, 3431,
  413, 3430, 3439, 3441,    1,  305,    3, 3445,  375, 3447,    3, 3444,
  394, 3444,  299, 3444,  241, 3444,  375, 3456,  375, 3444,  241, 3460,
    1,  253,  265, 3464,    0,  555,    4, 3469,   15, 3471,  483, 3473,
    2, 3468, 3475, 3477,    4, 3468,  524, 3481, 3477, 3483,   11, 3481,
  483, 3486, 3477, 3489,  483, 3481,   11, 3492, 3477, 3495,    1,  713,
    5, 3499,   17, 3501,  587, 3503,    3, 3498, 3505, 3507,    5, 3498,
  668, 3511, 3507, 3513,    9, 3511,  587, 3516, 3507, 3519,  587, 3511,
    9, 3522, 3507, 3525,  828, 3498,  705, 3498,  483, 3498,  803, 3532,
  803, 3498,  483, 3536,    1,  559,  903, 3540,    1,  955,  980, 3544,
    3, 3544,  973, 3549,  973, 3548,  973, 3545, 2139, 3555, 1011, 3544,
  973, 3544,    3, 3560,    0, 1141,    2, 3564,    9, 3565, 3411, 3565,
    0, 1447,    9, 3573, 3411, 3573,    1, 1471,    4, 3579,   11, 3581,
 1369, 3583,    2, 3578, 3585, 3587,    4, 3578, 1418, 3591, 3587, 3593,
   15, 3591, 1369, 3596, 3587, 3599, 1369, 3591,   15, 3602, 3587, 3605,
  265, 3578, 2011, 3609,    0, 1325,    5, 3613,    9, 3615, 1275, 3617,
    3, 3612, 3619, 3621,    5, 3612, 1290, 3625, 3621, 3627,   17, 3625,
 1275, 3630, 3621, 3633, 1275, 3625,   17, 3636, 3621, 3639,    1,   53,
  265, 3642, 2035, 3645,    0,   59,    5, 3648,    1, 1141, 3177, 3653,
 3379, 3653, 3309, 3653,    0, 1163,    5, 3660,    1,  959, 3565, 3665,
 3273, 3665, 3573, 3665,    1, 1447, 3177, 3673, 3309, 3673, 3379, 3673,
    0, 1471,    7, 3680, 2269, 3683, 3345, 3681,    1, 1325, 1369, 3688,
 3357, 3689, 3681, 3689,    0,   39,    5, 3696,    1,   47, 3565, 3701,
 3573, 3701, 3273, 3701,    0,   53,    2, 3709,  587, 3711,   17, 3713,
    7, 3708, 2289, 3717,    4, 3708, 3715, 3721,    2, 3708, 1290, 3725,
 3721, 3727, 1275, 3725,   17, 3730, 3721, 3733,   17, 3725, 1275, 3736,
 3721, 3739, 3345, 3709, 3689, 3709,    1,   59,    3, 3747,  483, 3749,
   15, 3751,    5, 3746, 3753, 3755,    3, 3746, 1418, 3759, 3755, 3761,
 1369, 3759,   15, 3764, 3755, 3767,   15, 3759, 1369, 3770, 3755, 3773,
 1369, 3746, 3681, 3747, 3357, 3747, 3709, 3747,    1,  330, 1369, 3785,
  471, 3785,  367, 3785,  357, 3785,  341, 3785,  241, 3795,    0, 1162,
   17, 3799,    0,  758,  767, 3803,    0,   32, 2215, 3807, 2221, 3807,
 2233, 3807, 3249, 3807, 3246, 3807,    9, 3817, 3235, 3807,   67, 3820,
    9, 3823,   67, 3807, 3235, 3826,    9, 3829,    1,  758, 3807, 3833,
    1,   32, 3104, 3837, 3284, 3837, 3091, 3837,    9, 3842, 3283, 3837,
    9, 3846, 3273, 3837,   67, 3851,    9, 3853,    9, 3837, 3283, 3856,
 3091, 3856,    0, 1470, 3785, 3863,    0,   24, 2203, 3867, 3259, 3867,
 2191, 3867, 3257, 3867, 2179, 3867, 2895, 3867, 2171, 3867, 3265, 3867,
 3269, 3867, 3085, 3867, 3071, 3867,    9, 3889, 3267, 3867,    9, 3893,
 2893, 3867,  113, 3897, 3263, 3867,  113, 3901, 3255, 3867,  101, 3905,
  128, 3905,  113, 3905,    9, 3910,    9, 3905,  113, 3914, 3837, 3867,
  128, 3867,  101, 3867,    9, 3867,  113, 3924,  113, 3867,    9, 3928,
    1,   24, 3220, 3933, 3222, 3933, 3232, 3933, 3226, 3933, 3224, 3933,
    9, 3942, 3228, 3933,  113, 3946, 3177, 3933,  101, 3950,  128, 3950,
  113, 3950,    9, 3956,    9, 3950,  113, 3960,  128, 3933, 3177, 3964,
  101, 3933, 3177, 3968,    9, 3933, 3224, 3972, 3177, 3972,  113, 3976,
  113, 3972, 3177, 3980,  113, 3933, 3228, 3984, 3177, 3984,    9, 3988,
    9, 3984, 3177, 3992,    0,  712, 2201, 3997, 3531, 3997, 2189, 3997,
 3529, 3997, 2177, 3997, 2911, 3997, 2169, 3997, 3535, 3997, 3539, 3997,
 3055, 3997, 3053, 3997,  483, 4019, 3537, 3997,  483, 4023, 2909, 3997,
  803, 4027, 3533, 3997,  803, 4031, 3499, 3997,  705, 4035,  828, 4035,
  803, 4035,  483, 4040,  483, 4035,  803, 4044, 3837, 3997,  828, 3997,
  705, 3997,  483, 3997,  803, 4054,  803, 3997,  483, 4058,    0,   52,
 3785, 4063,    0,  304, 2199, 4067, 3455, 4067, 2187, 4067, 3453, 4067,
 2175, 4067, 2917, 4067, 2167, 4067, 3459, 4067, 3463, 4067, 3051, 4067,
 3049, 4067,  241, 4089, 3461, 4067,  241, 4093, 2913, 4067,  375, 4097,
 3457, 4067,  375, 4101, 3445, 4067,  299, 4105,  394, 4105,  375, 4105,
  241, 4110,  241, 4105,  375, 4114, 3837, 4067,  394, 4067,  299, 4067,
  241, 4067,  375, 4124,  375, 4067,  241, 4128,    0,   38,   17, 4133,
    0,  252,  265, 4137, 3785, 4137,    0,  558,   17, 4143,    1,  712,
 3396, 4147, 3398, 4147, 3408, 4147, 3402, 4147, 3400, 4147,  483, 4156,
 3404, 4147,  803, 4160, 3379, 4147,  705, 4164,  828, 4164,  803, 4164,
  483, 4170,  483, 4164,  803, 4174,    9, 4147,  828, 4147, 3379, 4180,
  705, 4147, 3379, 4184,  483, 4147, 3400, 4188, 3379, 4188,  803, 4192,
  803, 4188, 3379, 4196,  803, 4147, 3404, 4200, 3379, 4200,  483, 4204,
  483, 4200, 3379, 4208,    1,  304, 3326, 4213, 3328, 4213, 3338, 4213,
 3332, 4213, 3330, 4213,  241, 4222, 3334, 4213,  375, 4226, 3309, 4213,
  299, 4230,  394, 4230,  375, 4230,  241, 4236,  241, 4230,  375, 4240,
    9, 4213,  394, 4213, 3309, 4246,  299, 4213, 3309, 4250,  241, 4213,
 3330, 4254, 3309, 4254,  375, 4258,  375, 4254, 3309, 4262,  375, 4213,
 3334, 4266, 3309, 4266,  241, 4270,  241, 4266, 3309, 4274,    0, 1446,
 3833, 4279,    0, 1140, 3833, 4283,    1, 1446, 3867, 4287, 3997, 4287,
 4067, 4287,    1,   46, 4279, 4295, 3807, 4295, 4283, 4295,    1, 1140,
 3867, 4303, 4067, 4303, 3997, 4303,    1,   58, 1369, 4311, 4063, 4311,
 3863, 4311, 4137, 4311,    1,  958, 3807, 4321, 4279, 4321, 4283, 4321,
    1, 1324, 1369, 4329, 3863, 4329, 4063, 4329, 4137, 4329,    1,  214,
 1631, 4339, 2685, 4339,    0,  214,    1, 1562,    1,  444,  449, 4349,
    7, 4349,  265, 4353, 2647, 4355, 2658, 4349,  251, 4349, 2647, 4349,
  375, 4362,  375, 4349, 2647, 4366,    0,  444, 2701, 4371, 1689, 4371,
 1705, 4371,  447, 4371, 2665, 4371, 2241, 4371, 3785, 4371, 2671, 4371,
  265, 4371,  331, 4371, 2663, 4371,  375, 4393,  375, 4371,    1,  510,
  257, 4399,    1, 1058,    0, 1396,    0, 1406,    0,  628,  375, 4409,
    1,  652,    1,  288,    1,  267, 1741, 4417,    1, 1013,    1, 1375,
    1,  333, 2903, 4425, 3361, 4425,    0, 1375, 2931, 4431, 2173, 4431,
    1,  273, 2905, 4437, 1739, 4437,    6, 4436,    7, 4437, 4443, 4445,
    6, 4437, 3359, 4437,    7, 4436, 4449, 4453,    0,  273, 2883, 4457,
 2913, 4457, 3351, 4457, 3457, 4457, 2923, 4457, 1749, 4457, 1743, 4457,
    1,   31, 3224, 4473, 3177, 4473,  113, 4476,  113, 4473, 3177, 4480,
    1,  737, 3400, 4485, 3379, 4485,  803, 4488,  803, 4485, 3379, 4492,
    1,  317, 2903, 4497, 3361, 4497, 2900, 4497,    7, 4497,  265, 4505,
 2897, 4507, 1753, 4497, 1745, 4497, 3330, 4497, 2897, 4497,  375, 4516,
 3309, 4497,  375, 4520,  375, 4497, 2897, 4524, 3309, 4524,    0,  317,
    7, 4530, 2913, 4531,  375, 4535,  375, 4531,    1,  507,    1,  245,
    0, 1397,    1,  913,    0, 1407,    1,  653,   11, 4551,    1,  289,
    1,  629,  713, 4557,   25, 4557,  305, 4557,    0,  629,  375, 4565,
    0,  340, 3785, 4569, 4311, 4569, 4329, 4569, 4555, 4569,    0,  766,
 1413, 4579,  922, 4579,  903, 4579,  483, 4584,  483, 4579,  903, 4588,
    0,   66,   75, 4593,    7, 4593, 3113, 4593,    9, 4599, 3251, 4593,
    9, 4603,  375, 4593,  483, 4593,    9, 4593,    1,  340,  331, 4613,
    1,  766,  483, 4616, 2591, 4617,  483, 4621,    1,   66,    5, 4624,
    6, 4627, 3248, 4625, 1941, 4625,    9, 4633,   36, 4625, 3247, 4625,
    9, 4638,    9, 4624, 1941, 4643, 3807, 4643,   33, 4625,    9, 4648,
    9, 4625, 3247, 4652,   33, 4652, 3807, 4625,    9, 4659,    0, 1170,
 2615, 4663,  903, 4665,    0,  112, 3972, 4669, 3270, 4669, 3086, 4669,
 1938, 4669, 1937, 4669,    9, 4678, 2564, 4669, 3071, 4669,    9, 4684,
 3267, 4669,    9, 4688, 2563, 4669,    9, 4692,    9, 4669, 3267, 4696,
 3933, 4696, 1937, 4696, 3071, 4696, 2563, 4696, 3933, 4669,    9, 4708,
    1, 1170, 1413, 4713,  922, 4713,  483, 4713,  903, 4718,  903, 4713,
  483, 4722,    1,  112,    2, 4727,    7, 4729, 3261, 4727,    9, 4733,
   25, 4727,  903, 4727,  587, 4727,    9, 4727,    0,  972, 3059, 4745,
 1925, 4745, 3563, 4745, 3553, 4745, 3549, 4745, 3547, 4745, 2005, 4745,
 2001, 4745, 1595, 4745, 1945, 4745, 1599, 4745, 2239, 4745, 1717, 4745,
 2619, 4745, 1769, 4745, 1947, 4745, 1933, 4745, 1943, 4745,  955, 4781,
    9, 4781,    0,  802,  807, 4787,  375, 4787,    7, 4787,  805, 4793,
  265, 4793,  483, 4787,    0,  144,  483, 4801,    1,  972, 3551, 4805,
 2003, 4805,  375, 4805,  955, 4805,    9, 4805, 1011, 4805,    1,  802,
  713, 4819,  483, 4819,    1,  144,    0,  256, 2309, 4827, 4437, 4827,
  264, 4826,  299, 4833,  264, 4827,  367, 4837,  265, 4826, 2309, 4841,
 4805, 4827, 4613, 4827,  375, 4827,  510, 4827,  483, 4827,    9, 4852,
    9, 4827,  483, 4856,    0, 1504,    1,  256, 2798, 4863,    7, 4863,
  265, 4867,  264, 4862,  264, 4863, 2795, 4863,  375, 4874,  265, 4862,
 4873, 4879,  305, 4863,  713, 4863,   25, 4863,  375, 4863, 2795, 4888,
  265, 4863, 4871, 4893,    1,  164,    0,  374,  241, 4899,    0, 1346,
    9, 4903,    0,  154,    0, 1412, 2853, 4909, 2163, 4909,    0, 1418,
    1, 1346,    1,  154,  483, 4919,    1, 1412,  241, 4922,    1, 1290,
 4915, 4927,    1, 1280,    1,  246,    0,  566, 2596, 4935,  586, 4934,
  705, 4939,  586, 4935,  795, 4943, 2595, 4935,  587, 4946,  587, 4935,
 2595, 4950,    0, 1086,  375, 4955,    0,  922, 1759, 4959, 2265, 4959,
 3367, 4959, 4421, 4959, 1953, 4959,    1,  566,    5, 4971,    6, 4973,
 1950, 4971, 1949, 4971,    9, 4978,  586, 4970,  586, 4971,  587, 4970,
 4985, 4987, 4827, 4971,    9, 4971, 1949, 4992, 4745, 4971, 4569, 4971,
  587, 4971, 4983, 5001,    1, 1086,    9, 5005,    1,  922, 3369, 5009,
  555, 5009,  257, 5009,    1,  932,    0,   88, 3171, 5019,   10, 5018,
  101, 5023,  101, 5019,   10, 5019,  107, 5029,    0,  934,  375, 5033,
    0, 1108,  587, 5037,    1, 1362,  265, 5041,    1,   88,   93, 5045,
 1643, 5047,   93, 5044, 1645, 5051, 1645, 5045, 2135, 5045,  973, 5044,
 4745, 5059, 3163, 5045, 3173, 5045, 3167, 5045,    7, 5044,   10, 5044,
   10, 5045,   11, 5044, 3807, 5075, 5073, 5075,   33, 5045,   21, 5045,
  973, 5045, 4805, 5085, 3807, 5045, 4279, 5045, 4283, 5045, 4745, 5045,
   11, 5045, 5071, 5097,    1, 1304,    1, 1108,  973, 5103,  972, 5102,
 5105, 5107,  972, 5103,  973, 5102, 5111, 5113,  257, 5103,    0,  260,
    0,  580,    0,  136,    0,  668,    1,  260, 4139, 5127, 4138, 5127,
  264, 5126, 5131, 5133,  264, 5127, 4137, 5137,  265, 5126, 4137, 5141,
 5137, 5142, 5129, 5141, 5138, 5141, 5137, 5141, 4137, 5150,  265, 5127,
 4137, 5154, 5133, 5157, 5133, 5155, 4137, 5161, 4137, 5127,  265, 5165,
 5137, 5167,  265, 5164, 5133, 5171,    1,  580,    1,  136, 5019, 5177,
    1,  524, 5125, 5181,    1,  296, 5019, 5185,    0, 1413, 2559, 5189,
 2209, 5189, 4925, 5189,    0, 1419, 5181, 5197,    1,  295,  973, 5201,
  972, 5201,   49, 5201,   48, 5201,  972, 5200, 5203, 5211,  973, 5200,
 5205, 5215,   48, 5200, 5207, 5219,   49, 5200, 5209, 5223,    1, 1413,
 1417, 5227,    1, 1291, 5125, 5231, 5197, 5231,    0, 1087,  375, 5237,
    0,  923, 1793, 5241, 2941, 5241, 5012, 5241, 3543, 5241, 3559, 5241,
 2891, 5241, 5017, 5241, 1955, 5241,  555, 5241, 5009, 5258, 5009, 5241,
  555, 5262,    1, 1087, 5037, 5267,    1,  923,  555, 5270, 4959, 5273,
  241, 5270, 4959, 5277, 4959, 5271,  555, 5281,    1,  933, 4959, 5285,
    0,  935,  375, 5289,    0, 1109, 5005, 5293,    1,  935,    0,  669,
 4927, 5299,    1,  525, 4915, 5303, 5299, 5303,    1,  669,    1,  297,
    0,  341,  483, 5313, 3747, 5313, 3689, 5313, 3345, 5313, 4415, 5313,
    0,  257, 2255, 5325, 4888, 5325, 4881, 5325, 3467, 5325, 2919, 5325,
 4871, 5325, 4893, 5336, 4894, 5325,    7, 5324, 4863, 5343, 4872, 5325,
 4879, 5347, 4869, 5325, 4893, 5325, 4871, 5352, 5343, 5353,    3, 5325,
    5, 5358, 4862, 5360, 4863, 5361, 5363, 5365, 5343, 5364, 4862, 5361,
 4863, 5360, 5371, 5373, 5344, 5361, 5343, 5361, 4863, 5378,    5, 5325,
    3, 5382, 4862, 5384, 4863, 5385, 5387, 5389, 5343, 5388, 4862, 5385,
 4863, 5384, 5395, 5397, 5344, 5385, 5343, 5385, 4863, 5402,  264, 5325,
 4863, 5406, 4879, 5409, 5344, 5407, 5343, 5407, 4863, 5414, 4863, 5407,
 4871, 5419, 5343, 5418,    7, 5325,  265, 5425, 4863, 5427,  266, 5325,
  375, 5325, 4863, 5432,  510, 5325,  483, 5325,    9, 5438,    9, 5325,
  483, 5442,  251, 5325,  265, 5446,  265, 5447, 4892, 5325,  265, 5325,
  257, 5454,    1, 5457,    7, 5455, 5459, 5461,    0, 5461, 5457, 5465,
  251, 5454, 4863, 5454, 4863, 5325,    3, 5472,    5, 5474,    5, 5472,
    3, 5478,  375, 5472,    7, 5473, 5361, 5485, 5385, 5485, 5477, 5485,
 5481, 5485, 5407, 5485,  264, 5472, 4879, 5497, 5485, 5497,  264, 5473,
 4893, 5503,  265, 5472,  265, 5324, 4417, 5509,  251, 5509,    1,  341,
 5325, 5515,  331, 5514,    1,  257,  445, 5521,  265, 5522,  449, 5521,
  448, 5521,  414, 5521,  415, 5521,  421, 5521,  420, 5521,  253, 5521,
  265, 5538,  340, 5521,  341, 5521,  272, 5520,  241, 5546,  273, 5521,
 5549, 5551,  272, 5521,  273, 5520,  412, 5521,  251, 5559,  241, 5520,
  265, 5562, 5551, 5565,  272, 5563, 5557, 5569,  500, 5521,  432, 5521,
  501, 5521,  413, 5520, 5525, 5579, 5529, 5579, 5533, 5579, 5535, 5579,
 5555, 5579, 5541, 5579,  251, 5579, 5559, 5592, 5560, 5579, 5559, 5579,
  251, 5598, 5577, 5579,  433, 5521, 5579, 5605,  264, 5520, 5543, 5609,
  367, 5609,  264, 5521,  299, 5615,  412, 5520, 5527, 5619, 5531, 5619,
 5537, 5619, 5551, 5619, 5573, 5619, 5575, 5619,  413, 5521,  375, 5632,
 5619, 5635,  251, 5632, 5619, 5639, 5619, 5633,  251, 5643,  483, 5632,
 5619, 5647,    9, 5632, 5619, 5651,    7, 5521,  265, 5654, 5609, 5657,
  265, 5655, 5615, 5661, 2227, 5521,  375, 5665, 4841, 5521,  375, 5669,
  375, 5520, 2227, 5673, 4841, 5673, 4827, 5673,  375, 5521,  413, 5680,
 5619, 5683,  413, 5681, 5559, 5687,  483, 5521,  413, 5690, 5619, 5693,
  413, 5691, 5559, 5697,    9, 5521,  413, 5700, 5619, 5703,  413, 5701,
 5559, 5707,  251, 5521,  413, 5710, 5619, 5713,  413, 5711, 5559, 5717,
  265, 5521,  445, 5720, 5579, 5723,  253, 5720, 5579, 5727,    7, 5720,
 5609, 5731, 4827, 5521,    3, 5735,    5, 5736,    5, 5735,    3, 5740,
  375, 5735,    7, 5734, 5739, 5747, 5743, 5747,  264, 5735, 5747, 5753,
  265, 5735,  265, 5520, 2647, 5759, 5545, 5759, 1783, 5759,  241, 5758,
 5551, 5767,    0, 1171, 4714, 5771, 4716, 5771, 4720, 5771, 4724, 5771,
 2850, 5771, 1413, 5771, 4713, 5782,  922, 5771, 4713, 5786, 4718, 5771,
  903, 5790, 2849, 5771,  903, 5794,  483, 5771, 4722, 5798,  903, 5798,
 4713, 5802, 4713, 5798,  903, 5806, 4722, 5771,  483, 5810,  903, 5771,
 4718, 5814, 2849, 5814,  483, 5814, 4713, 5820, 4713, 5814,  483, 5824,
 4713, 5771, 1413, 5828,  922, 5828,  483, 5828,  903, 5834,  903, 5828,
  483, 5838,    0,  973, 1895, 5843, 2037, 5843, 1597, 5843, 1601, 5843,
 2142, 5843, 2313, 5843, 4810, 5843, 1715, 5843, 1771, 5843, 1935, 5843,
 2140, 5843, 2139, 5843,  955, 5866,    9, 5866,  375, 5843, 4805, 5872,
  483, 5843,    9, 5843, 2139, 5878,  955, 5843, 2139, 5882, 1011, 5843,
 4805, 5843,  375, 5888,    1, 1171,    3, 5892, 4663, 5895,  903, 5897,
  483, 5892, 4663, 5901,  903, 5903, 4663, 5893, 1413, 5907,  922, 5907,
  483, 5907,  903, 5912,  903, 5907,  483, 5916,    1,  973,  956, 5920,
 4745, 5923,   88, 5920, 4745, 5927,    5, 5920, 4745, 5931, 1011, 5933,
    3, 5920,  955, 5936, 4745, 5939,    9, 5936, 4745, 5943, 4745, 5937,
  955, 5947,    9, 5947,  375, 5920, 4745, 5953,  955, 5920,    3, 5956,
 4745, 5959, 5325, 5921,    9, 5920,    3, 5964, 4745, 5967, 4745, 5921,
  375, 5971,    0,  767,  903, 5974, 4617, 5977,  483, 5979, 4617, 5975,
 1413, 5983,  922, 5983,  903, 5983,  483, 5988,  483, 5983,  903, 5992,
    0,  567, 4989, 5997, 4983, 5997, 5001, 6000, 5002, 5997, 4984, 5997,
 4987, 6007, 5001, 5997, 4983, 6010,    3, 5997,    7, 6014, 4970, 6016,
 4971, 6017, 6019, 6021, 4970, 6017, 4971, 6016, 6025, 6027,    7, 5997,
    3, 6030, 4970, 6032, 4971, 6033, 6035, 6037, 4970, 6033, 4971, 6032,
 6041, 6043,    3, 5996,    7, 6047,    2, 5996, 4992, 6051, 6015, 6051,
    7, 6055, 4971, 6057,    9, 6051, 4971, 6060, 4971, 6051,    9, 6064,
  586, 5997, 4971, 6068, 4987, 6071, 4971, 6069, 4983, 6075,    2, 5997,
 6048, 6079, 4971, 6081,    7, 6079, 6047, 6084, 4971, 6087, 4971, 6085,
 6047, 6091, 6047, 6079,    7, 6094, 4971, 6097, 4992, 5997,  587, 6101,
 2839, 5997,  587, 6105,    9, 5997, 4971, 6108,  587, 6111, 4971, 5997,
    2, 6115,    7, 6117, 4975, 6117,  586, 6114, 4987, 6123,    5, 6114,
    6, 6127, 6117, 6129, 6119, 6127,  586, 6115, 5001, 6135,    9, 6114,
  587, 6139,  587, 6115,    9, 6143,    0,   67, 4636, 6147,   37, 6147,
 3008, 6147, 4656, 6147, 4650, 6147,    7, 6146, 4643, 6159, 2233, 6159,
 4625, 6159,    9, 6165,    5, 6147,    6, 6169,   36, 6147, 4625, 6172,
 3807, 6173, 4648, 6147,    9, 6178, 3003, 6147,    9, 6182,   33, 6146,
 6151, 6187, 3856, 6187, 3837, 6187,    9, 6192,    9, 6187, 3837, 6196,
   33, 6147, 4652, 6200, 3807, 6201,    9, 6205,    9, 6200, 4625, 6208,
 3807, 6209, 4625, 6200,    9, 6214, 4652, 6147,   33, 6218,    9, 6147,
 4648, 6222, 3003, 6222,   33, 6222, 4625, 6228, 3807, 6229,   33, 6223,
 3837, 6235, 4625, 6222,   33, 6238, 4625, 6147,   75, 6243, 4629, 6243,
    7, 6243, 4627, 6249, 6171, 6243,  375, 6243,   36, 6242,   33, 6242,
    9, 6258,    9, 6242,   33, 6262,    0,   89, 5079, 6267, 5071, 6267,
 5097, 6270, 5098, 6267, 5072, 6267, 5075, 6277, 5097, 6267, 5071, 6280,
  107, 6267,    5, 6267,    7, 6286, 5044, 6288, 5045, 6289, 6291, 6293,
 5044, 6289, 5045, 6288, 6297, 6299,    7, 6267,    5, 6302, 5044, 6304,
 5045, 6305, 6307, 6309, 5044, 6305, 5045, 6304, 6313, 6315,    5, 6266,
    7, 6318, 5045, 6321,    7, 6319,    7, 6266,    5, 6326, 5045, 6329,
 5075, 6327, 2221, 6327, 5045, 6327,    4, 6266, 6287, 6339,    7, 6341,
 5045, 6343,   10, 6266, 5075, 6347, 2221, 6347, 5045, 6347,   10, 6267,
 5097, 6355, 5045, 6354, 5075, 6359, 5045, 6355, 5071, 6363, 1274, 6267,
    4, 6267, 6324, 6369, 5045, 6371,    7, 6369, 6319, 6374, 5045, 6377,
 5044, 6374, 5045, 6375, 6319, 6383, 6381, 6383, 5044, 6375, 5045, 6374,
 6389, 6391, 6319, 6369,    7, 6394, 5045, 6397,    6, 6267,    3, 6400,
    3, 6267,    6, 6404,   21, 6267,   11, 6409, 5045, 6411, 5045, 6267,
   10, 6414, 5075, 6417,   10, 6415, 5097, 6421, 5311, 6267,   11, 6266,
 2969, 6427, 5082, 6427, 5045, 6427,   21, 6432,   21, 6427, 5045, 6436,
    1,  767, 4580, 6441, 4582, 6441, 4586, 6441, 4590, 6441, 2862, 6441,
 1413, 6441, 4579, 6452,  922, 6441, 4579, 6456, 4584, 6441,  483, 6460,
 2861, 6441,  483, 6464,  759, 6440,  903, 6441, 4588, 6470,  483, 6470,
 4579, 6474, 4579, 6470,  483, 6478, 4588, 6441,  903, 6482,  483, 6441,
 4584, 6486, 2861, 6486,  903, 6486, 4579, 6492, 4579, 6486,  903, 6496,
 4579, 6441, 1413, 6500,  922, 6500,  903, 6500,  483, 6506,  483, 6500,
  903, 6510,    1,  567,    5, 6514,    6, 6517, 4935, 6517, 2137, 6515,
    9, 6523,   14, 6515,    2, 6515,  563, 6529, 4935, 6531, 6519, 6529,
 4935, 6535,    7, 6529, 6520, 6539, 4935, 6539, 6517, 6542, 6517, 6539,
 4935, 6546, 1197, 6529, 4935, 6551,    6, 6515,    5, 6554,    5, 6515,
    6, 6558, 5325, 6515,  903, 6515,    9, 6514, 4950, 6567,  587, 6567,
 4935, 6570, 4935, 6567,  587, 6574,  241, 6515, 4950, 6515,    9, 6581,
  587, 6515,    9, 6585, 4935, 6587, 4935, 6584,    9, 6591, 4935, 6515,
    2, 6594,    7, 6597,    5, 6595, 6539, 6601, 6599, 6601,    6, 6601,
 6597, 6607,    9, 6595,  587, 6611,  587, 6594,    9, 6615, 5843, 6515,
 5313, 6515,  587, 6514,    1,   67, 4594, 6625, 4606, 6625, 3280, 6625,
   75, 6625, 4593, 6632, 2146, 6625, 2145, 6625,    9, 6638,    7, 6625,
   73, 6643, 4593, 6645,  375, 6625, 4593, 6648,   33, 6624, 4593, 6653,
    9, 6655,    9, 6625, 3273, 6658, 2145, 6658, 4593, 6625,   75, 6664,
  375, 6664,   36, 6665,   33, 6665,    9, 6672,    9, 6665,   33, 6676,
 3273, 6625,    9, 6680,    1,   89, 1657, 6685,   25, 6685, 3565, 6685,
 3573, 6685, 3273, 6685,   21, 6684,  483, 6685, 5843, 6685,   11, 6684,
    0, 1487,   10, 6705,    7, 6705,    5, 6708,    5, 6705,    7, 6712,
    0, 1347,    0,  113, 2149, 6719,    9, 6721, 4736, 6719,    9, 6725,
 3023, 6719,    9, 6729, 4740, 6719,    9, 6733, 2879, 6719,    9, 6737,
  587, 6719, 4727, 6740,    9, 6743,   25, 6719, 4727, 6746,    9, 6749,
 4727, 6719,    5, 6753,    6, 6755, 4731, 6755,    2, 6752,    7, 6761,
 6755, 6763, 6757, 6761,   25, 6752,    9, 6769,  587, 6752,    9, 6773,
    9, 6753,   25, 6777,  587, 6777, 3255, 6719,    9, 6783,    0,  137,
    1,  113,   31, 6788,    2, 6788,    7, 6793, 4669, 6793, 4697, 6789,
   14, 6788,    6, 6789,    6, 6788,    5, 6804,   11, 6788,    5, 6808,
    5, 6788,    6, 6813,    6, 6812, 4696, 6813,    9, 6813, 4669, 6820,
 4669, 6813,    9, 6824,    7, 6788, 6815, 6829,   15, 6788, 6803, 6833,
    8, 6788,    8, 6789, 4669, 6839, 1368, 6789,    5, 6789,   35, 6845,
 4669, 6847, 6795, 6845, 4669, 6851,    6, 6845, 6796, 6855, 4669, 6855,
 6793, 6858, 6793, 6855, 4669, 6862, 1171, 6845, 4669, 6867,   17, 6845,
 4669, 6871,    7, 6789, 6811, 6875, 6807, 6875, 6817, 6875, 6801, 6875,
    2, 6874,    2, 6789,    7, 6886,   30, 6788, 3867, 6891,   25, 6788,
 4696, 6895, 3867, 6895,    9, 6899,    9, 6894, 3867, 6903, 4669, 6895,
    9, 6906,    9, 6895, 4669, 6910,  587, 6788, 4696, 6915,    9, 6915,
 4669, 6918, 4669, 6915,    9, 6922,   25, 6789, 4473, 6927, 6791, 6927,
 3972, 6927, 3933, 6927,    9, 6934,    9, 6927, 3933, 6938, 4696, 6789,
 6837, 6943,   25, 6943,  587, 6943,    9, 6789, 6837, 6951, 4669, 6953,
  587, 6951, 4669, 6957,   25, 6951, 4669, 6961, 4669, 6950,   25, 6965,
 6837, 6965,  587, 6965, 4669, 6789,    5, 6972,    6, 6975,    2, 6973,
 6855, 6979, 6977, 6979,    7, 6979, 6975, 6985,   25, 6973,    9, 6989,
  587, 6973,    9, 6993,    9, 6972, 6837, 6997,   25, 6997,  587, 6997,
    9, 6973, 6839, 7005,    9, 6788, 6799, 7009, 6840, 7009, 6839, 7009,
 4669, 7014, 4669, 7009, 6839, 7018,   25, 7008, 3867, 7023,   25, 7009,
 3933, 7027,    1,  137, 6267, 7031,    0,  375,  413, 7034,  413, 7035,
  241, 7034, 3307, 7041, 2885, 7041,    0,  261,    0,  803,   16, 7049,
    7, 7049,    4, 7052,    4, 7049,    7, 7056,    0,  581,    0,  145,
    1,  375,  317, 7064,  265, 7065,  256, 7068,  256, 7069, 4901, 7065,
    4, 7065,    2, 7077,  265, 7077,    2, 7076, 4899, 7083,    2, 7065,
  265, 7087,    4, 7086, 4899, 7091,    2, 7064,  265, 7064,    3, 7064,
 7084, 7099, 7092, 7099, 7083, 7099, 4899, 7104, 7091, 7099, 4899, 7108,
 7075, 7099, 4899, 7099, 7083, 7114, 7091, 7114,  240, 7064,  240, 7065,
  265, 7123,    7, 7125, 7114, 7123, 7099, 7123, 4899, 7130, 4899, 7123,
 7099, 7134,  413, 7065,    7, 7138,    3, 7065, 7079, 7143, 4899, 7145,
 7081, 7143, 4899, 7149,    5, 7065, 7089, 7153, 4899, 7155,  445, 7065,
 4349, 7159, 7121, 7159,  367, 7065, 4863, 7165,  973, 7065, 4805, 7169,
  316, 7064, 4067, 7173,  973, 7064, 4745, 7177,  445, 7064, 4371, 7181,
  257, 7064, 4841, 7185, 2227, 7185, 4827, 7185, 7071, 7185,  305, 7064,
 4067, 7195,  241, 7197,  241, 7194, 4067, 7201,  587, 7064,  257, 7065,
 4863, 7207, 7073, 7207,  628, 7065,  587, 7065,   11, 7214,   11, 7065,
  587, 7218,  241, 7219,  305, 7065, 4497, 7225, 7067, 7225, 4254, 7225,
 4213, 7225,  241, 7232,  241, 7225, 4213, 7236, 4900, 7065, 7121, 7241,
 7095, 7241, 7097, 7241,  241, 7065, 7095, 7249, 4899, 7251, 7097, 7249,
 4899, 7255,    6, 7249, 7121, 7249, 4899, 7261, 4899, 7248, 7121, 7265,
 7095, 7265, 7097, 7265, 4899, 7065,  241, 7272, 7121, 7275, 7095, 7275,
 7097, 7275,  241, 7273, 7123, 7283,  241, 7064, 4371, 7287, 7141, 7287,
 7127, 7287, 7075, 7287, 7134, 7287, 7123, 7287, 4899, 7298, 4899, 7287,
 7123, 7302,  305, 7286, 4067, 7307,  305, 7287, 4213, 7311,    1,  261,
  413, 7315, 3357, 7315,  264, 7319,  265, 7318, 7321, 7323,  264, 7318,
  265, 7319, 7327, 7329,    1,  803,  737, 7332, 4799, 7333, 1274, 7332,
    6, 7333,    2, 7341,    2, 7340, 4787, 7345,    2, 7333,    6, 7348,
 4787, 7351,    2, 7332,    6, 7332,    3, 7356,  587, 7332,    3, 7360,
    3, 7332, 7346, 7365, 7352, 7365, 7345, 7365, 4787, 7370, 7351, 7365,
 4787, 7374,    6, 7365,    6, 7364, 7337, 7365, 4787, 7365, 7345, 7384,
 7351, 7384,    7, 7332, 7379, 7391, 1275, 7332, 7341, 7395,  482, 7332,
  482, 7333, 7384, 7401, 7365, 7401, 4787, 7404, 4787, 7401, 7365, 7408,
    3, 7333, 7343, 7413, 4787, 7415,    7, 7333, 7363, 7419, 7359, 7419,
 7381, 7419, 7339, 7419,  736, 7332, 3997, 7429,  713, 7332, 3997, 7433,
  483, 7435,  483, 7432, 3997, 7439,   11, 7333,  483, 7443,  713, 7333,
 4485, 7447, 7335, 7447, 4188, 7447, 4147, 7447,  483, 7454,  483, 7447,
 4147, 7458, 4798, 7333, 7399, 7463, 7355, 7463,  483, 7333, 7355, 7469,
 4787, 7471, 7399, 7469, 4787, 7475, 4787, 7468, 7399, 7479, 7355, 7479,
 4787, 7333,  483, 7484, 7399, 7487, 7355, 7487,  483, 7485, 7401, 7493,
  483, 7332, 7337, 7497, 7408, 7497, 7401, 7497, 4787, 7502, 4787, 7497,
 7401, 7506,  713, 7496, 3997, 7511,  713, 7497, 4147, 7515,    1,  145,
  586, 7519,    7, 7519,    3, 7522,    3, 7519,    7, 7526,    1,  155,
  483, 7530,    0,  175,  482, 7535,    6, 7535,    2, 7538,    2, 7535,
    6, 7542,    1, 1505, 1011, 7546,    6, 7549,    7, 7549,    6, 7548,
 7553, 7555,    7, 7548, 7551, 7559,    1, 1363,    8, 7563,    6, 7563,
    4, 7566,    4, 7563,    6, 7570, 1374, 7563, 4423, 7575, 1374, 7562,
 4431, 7579,  265, 7562, 5189, 7583,    1,  165,  903, 7586,    6, 7589,
    7, 7589,    6, 7588, 7593, 7595,    7, 7588, 7591, 7599,    1,  175,
   44, 7602,   45, 7603, 7605, 7607,   44, 7603,   45, 7602, 7611, 7613,
    0,  299, 3289, 7617, 2181, 7617, 3307, 7617, 2885, 7617,    1,  299,
 4371, 7627, 2801, 7627, 1669, 7627, 5461, 7627, 3295, 7627,  305, 7626,
 4067, 7639,  251, 7627,  305, 7627, 4213, 7645,    0,  705, 3371, 7649,
 2183, 7649,    0,  101, 3157, 7655, 2185, 7655, 3175, 7655, 6697, 7655,
 3037, 7655, 6685, 7655,   21, 7667,    1,  705, 3377, 7671,  713, 7670,
 3997, 7675,  555, 7671,  713, 7671, 4147, 7681,    1,  101, 3163, 7685,
   25, 7684, 3867, 7689,   21, 7685,   25, 7685, 3933, 7695,    0,  129,
 2253, 7699,   21, 7699,    1,  129,   21, 7704,    0,  395, 2247, 7709,
 4417, 7709,  265, 7709,    7, 7715,  251, 7709,    0,  829, 2251, 7721,
  555, 7721,    1,  395, 2647, 7727, 1719, 7727,  251, 7726,    1,  829,
  555, 7734,    0,  298,  265, 7739,    7, 7741, 7627, 7743, 2551, 7739,
 7642, 7739, 4417, 7739, 7627, 7739,  251, 7752,  251, 7739, 7627, 7756,
    1,  298, 2647, 7761, 1783, 7761,  251, 7760, 7617, 7767, 7617, 7761,
  251, 7771,    0,  704, 2555, 7775, 7678, 7775, 7671, 7775,  555, 7780,
  555, 7775, 7671, 7784,    0,  100, 2557, 7789, 7692, 7789, 2969, 7789,
 5082, 7789, 5045, 7789,   21, 7798, 7685, 7789,   21, 7802,   21, 7789,
 7685, 7806, 5045, 7806,    1,  704,  555, 7812, 7649, 7815, 7649, 7813,
  555, 7819,    1,  100,   21, 7822, 7655, 7825, 7655, 7823,   21, 7829,
    0,  128, 3159, 7833, 2197, 7833, 7707, 7833, 7705, 7833,   21, 7841,
    1,  128, 3161, 7845, 7702, 7845,   25, 7844, 3867, 7851,   21, 7845,
 7699, 7854, 7699, 7845,   21, 7858,   25, 7845, 3933, 7863,    0,  394,
 3291, 7867, 2193, 7867, 7733, 7867, 2885, 7867, 3307, 7867, 7727, 7867,
  251, 7879,    0,  828, 3373, 7883, 2195, 7883, 7737, 7883, 7735, 7883,
  555, 7891,    1,  394, 4371, 7895, 3293, 7895, 7718, 7895, 1721, 7895,
 1725, 7895, 7717, 7895,  305, 7894, 4067, 7909,  251, 7895, 7709, 7912,
 7709, 7895,  251, 7916,  305, 7895, 4213, 7921,    1,  828, 3375, 7925,
 7724, 7925,  713, 7924, 3997, 7931,  555, 7925, 7721, 7934, 7721, 7925,
  555, 7938,  713, 7925, 4147, 7943,    0,    8,    6, 7947,    3, 7948,
 1274, 7947,  113, 7947,    3, 7947,    0, 7957,    6, 7956,    0, 7956,
    9, 7963,   11, 7957,  587, 7947,    1,   10, 5081, 7971, 5026, 7971,
    7, 7971,    2, 7976, 1368, 7971, 5097, 7971,  931, 7971, 1417, 7971,
  939, 7971,  941, 7971,  272, 7971, 1476, 7971,  280, 7971,  949, 7971,
 1517, 7971, 4696, 7971,  149, 7971,  631, 7971,  970, 7971,   50, 7971,
  764, 7971,  357, 7971,  367, 7971,  471, 7971, 1249, 7971, 5019, 7971,
  101, 8022,  128, 7971,  101, 7971, 5019, 8028, 4669, 7971,    9, 8032,
  759, 7971,   33, 8036, 1471, 7971,  265, 8040,  959, 7971,   33, 8044,
  253, 7971,  265, 8048,  113, 7971,    9, 8052,  375, 7971,   88, 7971,
   89, 7971,    2, 7971,    1, 8063,    7, 8062,    1, 8062,   11, 8069,
    9, 8063,    3, 7971,    9, 8074,   33, 7971,  959, 8078,   47, 8078,
  759, 8078,   25, 7971,  305, 7971,  713, 7971,    2, 7970, 8059, 8093,
 8077, 8093, 8075, 8093,    9, 8099, 3867, 8093, 3997, 8093, 4067, 8093,
    3, 7970, 4696, 8109, 8061, 8109, 8072, 8109, 8063, 8109,    9, 8116,
 4669, 8109,    9, 8120,    9, 8109, 4669, 8124, 8063, 8124,   47, 7971,
   33, 8130,   53, 7971,  265, 8134,  265, 7971,  253, 8138, 1471, 8138,
   53, 8138,  587, 7971,  483, 7971,    9, 7971, 4669, 8150,  113, 8150,
    3, 8150, 8093, 8157,    3, 8151, 8063, 8161,    0,   10,  203, 8165,
  107, 8165, 5019, 8169,   85, 8165, 2215, 8165, 2221, 8165, 2233, 8165,
 5075, 8165, 4643, 8165, 5045, 8165,   25, 8185, 4551, 8165,  922, 8165,
 1413, 8165,  273, 8165,  281, 8165, 1477, 8165, 1516, 8165,  948, 8165,
 4625, 8165,    9, 8205,  759, 8165,  959, 8165,   67, 8165,    9, 8213,
 1505, 8165, 1011, 8216,   88, 8165,   33, 8221,   89, 8165, 5019, 8225,
    3, 8165,   33, 8229,    9, 8231, 8063, 8229,    9, 8228,   33, 8237,
    2, 8165,    9, 8241,   33, 8165, 1141, 8165, 1447, 8165,    2, 8164,
 2215, 8251, 2221, 8251, 5075, 8251, 2233, 8251, 4643, 8251, 8229, 8251,
 4625, 8251,    9, 8265, 4295, 8251, 3833, 8251, 4321, 8251, 5045, 8251,
    3, 8164, 8241, 8277, 8093, 8277, 3837, 8277, 4287, 8277, 4303, 8277,
  128, 8277,  101, 8277,  113, 8277,    9, 8292,    9, 8277,  113, 8296,
   47, 8165,  165, 8165,  903, 8302,  265, 8165,  587, 8165, 1011, 8165,
 1505, 8310, 1369, 8165,  483, 8165,  903, 8316,  903, 8165,  483, 8320,
  165, 8320,    9, 8165,    3, 8326,   33, 8329,    3, 8327,  113, 8333,
    0,  240, 4266, 8337, 4888, 8337, 4892, 8337, 4213, 8337,  375, 8344,
 4863, 8337,  375, 8348,  265, 8348,  261, 8337, 3335, 8337,  375, 8357,
  347, 8337,  386, 8337,  331, 8337,  305, 8337,  375, 8366,  340, 8337,
  331, 8371,  375, 8337, 4213, 8374, 4863, 8374,  305, 8374, 1325, 8337,
   59, 8337,    7, 8337,  265, 8387, 4213, 8389, 4863, 8389,  305, 8389,
  265, 8386,  331, 8397,    7, 8336, 5141, 8401, 5137, 8402, 5137, 8401,
 5141, 8406, 5150, 8401, 5154, 8401, 5133, 8413, 5161, 8401, 5127, 8401,
  265, 8419, 5137, 8421,  265, 8418, 5133, 8425,  265, 8401, 5127, 8429,
 5141, 8431, 5127, 8428, 5133, 8435, 3785, 8401, 4329, 8401, 4311, 8401,
  483, 8337,    9, 8337, 1275, 8337,   15, 8337,  265, 8337, 4863, 8452,
  257, 8452,    1, 8457,    6, 8452,    1, 8461,  241, 8462,  241, 8461,
    1, 8466,    7, 8452,  331, 8471,    7, 8453, 7895, 8475, 7287, 8475,
 8465, 8475, 8469, 8475, 7627, 8475, 8459, 8475,    0, 8475, 8457, 8489,
  375, 8475,    1,  264, 3293, 8495, 7718, 8495, 3295, 8495, 3305, 8495,
 3301, 8495, 5512, 8495, 5451, 8495, 7756, 8495, 7091, 8495, 4899, 8512,
 7083, 8495, 4899, 8516, 7092, 8495, 7084, 8495, 4696, 8495, 7075, 8495,
 7123, 8495, 4899, 8528, 7134, 8495,  445, 8495, 4349, 8535, 8386, 8495,
  331, 8539,  471, 8495,  367, 8495,  357, 8495,  631, 8495, 1249, 8495,
  628, 8495, 8387, 8495, 8401, 8495, 4137, 8495, 3863, 8495, 4063, 8495,
 8475, 8495, 4371, 8495, 4549, 8495, 4545, 8495,  407, 8495, 1417, 8495,
  665, 8495,  338, 8495, 1480, 8495,  336, 8495, 4745, 8495, 4669, 8495,
    9, 8586, 4899, 8495, 7091, 8590, 7083, 8590, 7123, 8590, 4569, 8495,
 7709, 8495,  251, 8600,  341, 8495, 4863, 8605,  241, 8605,  253, 8495,
  331, 8610,  251, 8495, 7709, 8614, 5509, 8614, 7739, 8614,  256, 8495,
  375, 8623, 7739, 8495,  251, 8626, 5509, 8495,  251, 8630,  257, 8495,
  305, 8635,   53, 8495,  331, 8638, 1471, 8495,  331, 8642,    6, 8495,
 4349, 8647, 4497, 8647,  413, 8647, 4213, 8647, 8109, 8647, 4147, 8647,
 3933, 8647,  445, 8647,  316, 8647, 4713, 8647, 4863, 8647, 8337, 8647,
  305, 8647,  241, 8672,  241, 8647,  305, 8676,  587, 8647, 8387, 8647,
    7, 8495, 3785, 8685, 4329, 8685, 4311, 8685, 8337, 8684,  331, 8693,
  331, 8685, 8337, 8697,   15, 8685,  241, 8684,  375, 8703,  331, 8495,
  253, 8706, 1471, 8706,   53, 8706,  305, 8495,    6, 8494, 8539, 8717,
 8693, 8717, 4371, 8717, 8623, 8717, 8703, 8717, 8685, 8717, 8337, 8729,
  241, 8729,  471, 8717,  367, 8717,  357, 8717, 1369, 8717,  341, 8717,
  241, 8743, 4569, 8717, 4137, 8717, 4063, 8717, 3863, 8717, 8401, 8717,
    7, 8494, 8389, 8757, 8555, 8757, 8374, 8757, 8670, 8757, 8635, 8757,
 8676, 8757, 8647, 8757, 8337, 8770,  241, 8770, 8337, 8757, 8647, 8776,
  375, 8776,    9, 8757,  375, 8757, 8337, 8784,  241, 8757,    1, 8789,
 8647, 8791, 8647, 8788,  587, 8495,   11, 8796,   11, 8495,  587, 8800,
    9, 8495, 4669, 8804, 1369, 8495,   17, 8495,  241, 8495,    1, 8813,
    7, 8815, 8717, 8817,    7, 8814, 8647, 8821,    7, 8812, 8717, 8825,
  375, 8825,    7, 8813,    1, 8830, 8647, 8833, 8647, 8831,  331, 8831,
    6, 8813, 8337, 8495,    7, 8842, 8717, 8845,  331, 8845,  483, 8843,
    9, 8843,    7, 8843, 8647, 8855,  375, 8855,    0,  264, 3299, 8861,
 5431, 8861, 5469, 8861, 5449, 8861, 4888, 8861, 4863, 8861,  375, 8872,
  629, 8861,  394, 8861,  299, 8861,  659, 8861,  623, 8861,  645, 8861,
  101, 8861,  705, 8861,  128, 8861,  828, 8861, 3345, 8861, 3445, 8861,
  375, 8899, 2981, 8861, 3049, 8861, 7195, 8861, 3461, 8861, 4613, 8861,
  331, 8910, 4614, 8861,  375, 8861, 4863, 8916,  241, 8916,  803, 8861,
  483, 8922,  113, 8861,    9, 8926,  256, 8861,  331, 8931, 5455, 8861,
  251, 8935,    7, 8861,  331, 8939,  241, 8941,  241, 8938,  331, 8945,
  331, 8861, 4613, 8948,    7, 8860, 3837, 8953, 8093, 8953,  394, 8953,
  299, 8953,  375, 8953,  241, 8962, 4303, 8953, 4287, 8953,  241, 8953,
  375, 8970,  483, 8861,  803, 8974,    9, 8861,  113, 8978,   17, 8861,
  241, 8861,  375, 8984,    7, 8984,  331, 8989,    7, 8985,  375, 8993,
    1,  240, 3342, 8997, 2900, 8997, 8672, 8997, 8743, 8997, 3795, 8997,
 8770, 8997, 8729, 8997, 2658, 8997, 7159, 8997, 2703, 8997, 2660, 8997,
  413, 8997, 8757, 8997, 8647, 9022, 8684, 8997, 8717, 9027, 8605, 8997,
  457, 8997, 2647, 9032, 8647, 8997,  305, 9036, 8757, 9036, 8916, 8997,
  257, 8997, 2647, 8997,  375, 9046,  457, 9046, 3341, 8997,  375, 9052,
 2897, 8997,  375, 9056,  305, 8997, 8647, 9060,  340, 8997, 8717, 9065,
 3785, 9065, 8495, 9065,  375, 8997, 3341, 9072, 2897, 9072, 2647, 9072,
 8861, 9072,    7, 8997,  413, 9082,    0, 9085,    1, 9083,  264, 9088,
  264, 9089, 8495, 9082, 8717, 9095, 8495, 9083, 8757, 9099,  305, 9099,
  265, 9083, 2897, 9105, 3341, 9105, 2647, 9105, 9087, 9105,    1, 9105,
 9085, 9115, 9093, 9105, 8861, 9105,  265, 9082, 8717, 9123, 3785, 9123,
 9091, 9123, 8495, 9123,  483, 8997,    9, 8997,  265, 8997,    7, 9136,
 8717, 9139, 3785, 9139, 8495, 9139,    7, 9137, 8647, 9147, 8495, 8997,
    7, 9150, 8717, 9153,    7, 9151, 8647, 9157, 8861, 8997,  375, 9160,
    0,  482,    6, 9165,    4, 9167,  803, 9165,    5, 9165,  587, 9173,
    9, 9173,    5, 9164,   17, 9179,   19, 9165,   12, 9165,    9, 9165,
   11, 9186,   11, 9165,    9, 9190,    1,  586, 4795, 9195,  807, 9195,
 4787, 9198, 4788, 9195, 4790, 9195, 8374, 9195, 8389, 9195, 4797, 9195,
 8086, 9195, 8090, 9195, 8251, 9195, 4283, 9195, 4279, 9195, 3807, 9195,
 1491, 9195,  631, 9195, 1160, 9195, 1466, 9195,  764, 9195,  357, 9195,
  367, 9195,  471, 9195, 1249, 9195, 8800, 9195, 8647, 9195, 4787, 9195,
  807, 9246,  375, 9246,   33, 9195,  759, 9252, 1141, 9195,  759, 9256,
  803, 9195,  375, 9195, 4787, 9262, 8337, 9262, 8165, 9195,  265, 9269,
  566, 9195,  567, 9195, 7971, 9195,   25, 9276,  713, 9276, 8495, 9195,
   11, 9282,    4, 9195,  483, 9287,    5, 9195,   17, 9291,  483, 9290,
  759, 9195, 1141, 9296, 1447, 9296,   33, 9296,  713, 9195, 7971, 9304,
   25, 9195, 7971, 9308, 8337, 9195,  375, 9312,    4, 9194, 9273, 9317,
 9295, 9317, 9291, 9317,  483, 9323, 4279, 9317, 3807, 9317, 4283, 9317,
 8251, 9317,    5, 9194, 9275, 9335, 9288, 9335, 9287, 9335,  483, 9340,
 8647, 9335,    9, 9335,  483, 9335, 9287, 9348, 1447, 9195,  759, 9352,
   11, 9195, 8495, 9357, 8495, 9356,    9, 9195, 1011, 9195,  483, 9195,
    5, 9366, 9317, 9369,    5, 9367, 9287, 9373,    0,  586,    7, 9377,
    4, 9378,   16, 9377, 8800, 9377,  273, 9377, 1477, 9377,  281, 9377,
  948, 9377, 1516, 9377,  750, 9377,  386, 9377,  347, 9377,  510, 9377,
  767, 9377,  375, 9377,  305, 9406,  713, 9406,  165, 9377,  903, 9412,
 8495, 9377,   11, 9416,  566, 9377,  759, 9421,    5, 9377,  759, 9425,
  483, 9427,  483, 9424,  759, 9431,    4, 9377,    0, 9435,    7, 9434,
    0, 9434,  587, 9441,  713, 9435,  713, 9377,  375, 9446,  305, 9377,
  375, 9450,    4, 9376,  767, 9455,    5, 9376, 3837, 9459, 8093, 9459,
  828, 9459,  705, 9459,  803, 9459,  483, 9468, 4287, 9459, 4303, 9459,
  483, 9459,  803, 9476, 1505, 9377, 1011, 9480,   11, 9377, 8495, 9484,
  903, 9377,  165, 9488,    9, 9377,  483, 9492, 1011, 9377, 1505, 9496,
  483, 9377,    9, 9500,    5, 9500,  759, 9505,    5, 9501,  803, 9509,
    1,  482,    6, 9513,    5, 9514,   14, 9513,    5, 9513,    1, 9521,
    6, 9520,    1, 9520,  483, 9527,   11, 9513,    0,  902,  524, 9533,
 1291, 9533,  767, 9533,    7, 9533,    3, 9541,  305, 9533,  375, 9544,
  386, 9533,  347, 9533,  375, 9533,  305, 9552,  483, 9533,   11, 9556,
   11, 9533,  483, 9560,    1, 1010, 5038, 9565, 5037, 9565,  587, 9568,
  668, 9565, 1419, 9565, 8982, 9565,    7, 9564, 3867, 9579, 8277, 9579,
 9459, 9579, 8953, 9579, 4067, 9579, 3997, 9579,  375, 9565,  483, 9565,
    9, 9565,  587, 9596,  587, 9565, 5037, 9600,    9, 9600,   17, 9565,
 8861, 9606, 8861, 9565,    7, 9611,   17, 9610,    0, 1010, 9535, 9617,
 9537, 9617, 9559, 9617, 9563, 9617,    5, 9617,    6, 9627,    7, 9627,
 5006, 9617, 5005, 9617,    9, 9634, 9362, 9617, 1290, 9617, 9533, 9641,
  525, 9617, 9533, 9645, 8804, 9617, 8150, 9617,  922, 9617, 1413, 9617,
 7971, 9617,    9, 9656,    6, 9617,   11, 9661, 9195, 9617,    9, 9664,
    6, 9616,   17, 9669,    7, 9616, 9195, 9673, 9317, 9673, 4321, 9673,
 3833, 9673, 4295, 9673, 5045, 9673,   19, 9617,   12, 9617,   11, 9617,
    9, 9690,  483, 9617,  903, 9694, 1275, 9617,   17, 9698, 9533, 9701,
    9, 9617, 5005, 9704, 9195, 9704, 7971, 9704, 8495, 9704,   11, 9704,
   17, 9617, 1275, 9716, 9533, 9719,  903, 9617,  483, 9722, 8495, 9617,
    9, 9726,    1,  902, 9573, 9731, 9575, 9731, 9599, 9731, 9605, 9731,
 1418, 9731, 9565, 9741,  669, 9731, 9565, 9745, 8386, 9731,    7, 9731,
 8337, 9750,    7, 9730, 9673, 9755, 8251, 9755, 4283, 9755, 3807, 9755,
 4279, 9755,  483, 9731,   15, 9731, 1369, 9768, 9565, 9771, 1369, 9731,
   15, 9774, 9565, 9777, 1011, 9731, 8337, 9731,    7, 9782, 9617, 9731,
    6, 9786,    7, 9786,    6, 9787, 9791, 9793,    7, 9787, 9789, 9797,
    0, 1274,    5, 9801,    1, 1368, 4904, 9805, 4903, 9805,    9, 9808,
 9484, 9805, 1517, 9805, 1476, 9805,  272, 9805,  280, 9805,  949, 9805,
 1197, 9805, 1471, 9805,  265, 9826,  253, 9805,  265, 9830,   53, 9805,
  265, 9834,    5, 9804, 3867, 9839, 8277, 9839, 8953, 9839, 9459, 9839,
 3997, 9839, 4067, 9839,   11, 9805, 9377, 9852,    9, 9805, 4903, 9856,
  265, 9805, 1471, 9860,  253, 9860,   53, 9860, 9377, 9805,   11, 9868,
    5, 9869,    0, 1368, 5075, 9875, 2221, 9875, 4643, 9875, 2233, 9875,
 2215, 9875, 4339, 9875,    7, 9875,    5, 9888,    4, 9889,   10, 9875,
 8714, 9875, 8800, 9875, 4625, 9875,    9, 9901,   47, 9875,  305, 9875,
 8495, 9906,  959, 9875, 5045, 9875, 4551, 9875, 1325, 9875,   59, 9875,
  331, 9875,    5, 9875,    0, 9923,    7, 9922,    0, 9922, 1369, 9929,
 9287, 9923,    4, 9875, 1011, 9935, 8495, 9875,   10, 9938,   10, 9939,
  305, 9938,   11, 9938, 9943, 9947,   11, 9939, 9941, 9951,    4, 9874,
 8495, 9955, 8717, 9955, 4329, 9955, 4311, 9955, 3785, 9955,    5, 9874,
 9195, 9967, 9755, 9967, 9317, 9967, 3833, 9967, 4295, 9967, 4321, 9967,
 5045, 9967,  759, 9875,   11, 9875, 8495, 9984,   17, 9875,  903, 9875,
  265, 9875,   15, 9875, 9195, 9875,  241, 9997,    1, 1274,    6,10001,
    4,10002,    4,10003,    8,10001, 5123,10001,    5,10011,    4,10010,
10013,10015,    4,10011,    5,10010,10019,10021,  341,10001, 4663,10001,
  903,10027, 1471,10001,  253,10001,   53,10001,    4,10001,    1,10037,
    6,10036,    1,10036, 1275,10043,    5,10001, 9935,10047, 8337,10001,
    9,10051,    5,10000, 8685,10055, 1369,10055, 8401,10055, 3863,10055,
 4137,10055, 4063,10055, 4569,10055, 9955,10055,  241,10001,   17,10001,
 1369,10001,    5,10077,    0,   14,    6,10081,    2,10082,  482,10081,
    2,10081,    0,10089,    6,10088,    0,10088,   15,10095,    2,10080,
   17,10099, 1369,10081,   17,10081,    1,   16,    7,10107,    3,10108,
  586,10107, 8306,10107, 1447,10107, 1141,10107, 9875,10107,  241,10121,
  265,10120, 9992,10107,  545,10107,  695,10107, 1382,10107, 1374,10107,
 1386,10107,   59,10107, 1369,10138,  154,10107,  483,10143, 1325,10107,
 1369,10146,  331,10107, 1369,10150,    3,10107,    1,10155,    7,10154,
    1,10154,   17,10161, 8241,10155,   15,10154,  483,10167,    3,10106,
 9673,10171, 8251,10171, 3807,10171, 4279,10171, 4283,10171, 9967,10171,
   33,10107, 1369,10107,  331,10186, 1325,10186,   59,10186, 1011,10107,
  265,10107, 8165,10196, 9875,10196, 1275,10107,   15,10107,    3,10204,
  483,10207,    3,10205, 1369,10211, 8165,10107,  265,10214,    0,   16,
    4,10219,    3,10220,    3,10221,    7,10219,    2,10226,10225,10229,
    2,10227,10223,10233, 1368,10219,10225,10237,  902,10219,10233,10241,
   59,10219, 1325,10219,  331,10219,    3,10219,    4,10250,10233,10253,
    2,10219,    7,10256,10225,10259,  903,10257, 8495,10219,  587,10265,
10001,10219,  903,10269,    2,10218, 8495,10273, 8717,10273,10055,10273,
 4311,10273, 4329,10273, 3785,10273,  265,10219, 1275,10219,    1,   14,
 8982,10291, 8861,10291,   17,10294, 4745,10291, 1011,10299,   53,10291,
  253,10291, 1471,10291,    2,10291,    3,10291,  483,10311,10257,10311,
   59,10291,   17,10316,   62,10291, 1325,10291,   17,10322,  331,10291,
   17,10326, 1328,10291,  334,10291,  393,10291, 1359,10291, 1031,10291,
  499,10291, 8337,10291,  483,10343, 9875,10291, 1011,10347,    3,10290,
 8685,10351, 1369,10351, 8401,10351, 9955,10351, 4063,10351, 4137,10351,
 3863,10351, 4569,10351,10273,10351,  241,10291, 1369,10291,   17,10291,
 8861,10374,   59,10374, 1325,10374,  331,10374,    1,   11,  340,10385,
  341,10385,  264,10385,  375,10391, 1010,10385,  264,10384,  341,10397,
10387,10397,    5,10385,    6,10402,    2,10402,    2,10403,    7,10385,
  265,10410,10397,10413,  265,10411,10391,10417,    5,10384,   29,10421,
  341,10421,    6,10421,   25,10427, 8262,10385,    9,10431, 8279,10385,
    9,10435,   88,10384, 3807,10439, 6347,10439, 6327,10439, 8251,10439,
 9875,10439, 8165,10439, 8229,10385, 8251,10452,    9,10455,    9,10453,
 8251,10459, 8241,10385,   33,10385, 6685,10465,    9,10465, 6267,10385,
  101,10471, 8240,10385, 8296,10475, 8277,10475,    9,10478,    9,10475,
 8277,10482, 8228,10385, 6719,10385,    9,10489,  265,10384,10389,10493,
 5313,10493, 8251,10385, 8229,10498,    9,10501,  483,10384, 5197,10505,
 5125,10505, 1275,10384, 1369,10385, 6685,10513,    9,10513, 1011,10385,
  265,10385,    7,10520,10397,10523,    2,10384,10423,10527,10428,10527,
10427,10527,   25,10532,10425,10527,  340,10527,10397,10539,10399,10527,
10392,10527,  375,10527,10391,10546,    7,10527,  265,10550,10397,10553,
  265,10551,10391,10557,10391,10527,  375,10560,10463,10527,    9,10565,
10487,10527,    9,10569,10519,10527,    6,10573,    7,10572,10575,10577,
    7,10573,    6,10572,10581,10583,   25,10527,10427,10586, 8165,10527,
  903,10527,  265,10527,    7,10594,10397,10597,    9,10527,    3,10384,
10482,10603,    5,10602,    6,10607,    5,10603,    6,10611,10475,10613,
10458,10603,10395,10603,    6,10619,    7,10618,10621,10623,    7,10619,
    6,10618,10627,10629,10407,10603,    6,10633,    7,10632,10635,10637,
    7,10633,    6,10632,10641,10643, 8326,10603,10453,10603,    9,10648,
10475,10603,    9,10652, 9875,10603,    9,10657,10521,10603,  375,10661,
    9,10602, 8251,10665, 3807,10665, 9875,10665, 8165,10665, 8165,10603,
    9,10674,    9,10675, 3807,10603,    9,10681,    9,10603,10475,10684,
10453,10684, 8165,10684, 8251,10603,    9,10693,    2,10385,10613,10697,
 8165,10699,10646,10697, 8327,10697,10690,10697,10676,10697,    5,10696,
10603,10711,    6,10713,    7,10712,10715,10717,    7,10713,    6,10712,
10721,10723, 8326,10697,10603,10726, 8251,10727,10674,10697,    9,10732,
 8165,10696,10613,10737,10705,10737, 8296,10737,10684,10737, 8277,10737,
    9,10746,10603,10737,    9,10750,    9,10737,10603,10754, 8277,10754,
  265,10697, 8165,10697,10684,10762, 8251,10763,    9,10767,    9,10762,
10603,10770, 8251,10771,10603,10762,    9,10776,10684,10697, 8165,10780,
 8165,10781,    9,10697,10674,10786, 8165,10786,10603,10790, 8251,10791,
 8165,10787,10603,10797, 8277,10797,10603,10786, 8165,10802, 8165,10803,
10603,10697, 8326,10808, 8165,10808,    9,10812, 8165,10809,    9,10817,
    9,10808, 8165,10820, 8165,10821,   67,10697,10427,10827,    3,10385,
 8225,10831, 8242,10831,10427,10831,10409,10831,    6,10839,    7,10838,
10841,10843,    7,10839,    6,10838,10847,10849,    7,10831,10421,10853,
  375,10831,10590,10831,    9,10859, 8165,10830,10527,10863,    9,10865,
 8165,10831,10527,10868,    9,10871,    9,10831, 8241,10874,10527,10831,
 8326,10879, 8165,10878,    9,10883, 8165,10879,    9,10886,    9,10879,
 8165,10890, 8165,10891, 8241,10831,    9,10896,   89,10384,   88,10385,
 8225,10903, 8165,10385,  264,10907, 1368,10906,10909,10911,    7,10906,
    2,10915,    2,10914,10909,10919,  265,10915,    5,10907,    3,10924,
10919,10927,10911,10927,    3,10925,10917,10933, 1369,10925, 1369,10906,
  265,10907,10939,10941,    2,10907,10937,10945, 8229,10945,    9,10949,
10831,10945,    9,10953,    3,10907,    5,10957,    6,10959,10786,10957,
    5,10956,10919,10965,10911,10965,10697,10957,    9,10970,    9,10957,
10697,10974,    2,10906,10961,10979,10613,10979, 8296,10979,10974,10979,
10684,10979,    7,10978,10927,10991,10965,10991,10909,10991, 8277,10979,
    9,10998,10957,10979,    9,11002,10603,10979,    9,11006,    9,10979,
10603,11010, 8277,11010,10957,11010,    3,10906,10923,11019,10945,11019,
    9,11023,10527,11019,    9,11027,    9,10384, 1369,11031,   33,11031,
    3,11030, 8251,11037, 3807,11037, 9875,11037, 8165,11037,    3,11031,
 8241,11047,    1,    9,   69,11051, 6625,11053,  981,11050,  980,11050,
 4745,11059, 7966,11050, 7967,11050,    4,11050,    7,11067, 1275,11067,
 7954,11051, 7967,11051,11063,11075,  120,11050, 3867,11079,  112,11050,
11073,11083,   66,11050, 8251,11087, 1941,11087, 6159,11087, 3807,11087,
 9875,11087, 8165,11087,  121,11050, 7966,11051,11065,11103, 7957,11051,
   11,11106, 1141,11051, 1447,11051,   67,11051,    7,11114,11087,11117,
  113,11051,11083,11121, 7947,11123, 7947,11120,11083,11127,   89,11051,
 8495,11131,   25,11050,  113,11134, 3867,11137, 3867,11135,  113,11141,
  567,11050, 4950,11145,  587,11145, 4935,11148, 4935,11145,  587,11152,
  973,11050,    3,11156, 4745,11159,  587,11051,  566,11162,  566,11163,
  567,11163,11165,11169,  567,11162,11167,11173, 1011,11051, 1369,11051,
 6625,11179, 7956,11051, 7955,11051,   33,11051, 6625,11187,   25,11051,
11101,11191, 3984,11191, 3023,11191, 3933,11191,  113,11198,  113,11191,
 3933,11202,  973,11051, 2139,11207,11057,11207,  567,11051, 4971,11213,
  587,11215,  257,11051,  483,11219,  483,11050,  257,11223, 1011,11050,
  973,11227,  972,11226,11229,11231,  972,11227,  973,11226,11235,11237,
  257,11227,  265,11050, 5019,11243,  903,11051,    7,11246,    2,11050,
11187,11251,11073,11251,11127,11251,11207,11251,11113,11251,11111,11251,
11075,11251,11179,11251,11121,11251, 7947,11269,   25,11251, 5019,11251,
    3,11050,11068,11276,11069,11277,11279,11281,11068,11277,11069,11276,
11285,11287,11185,11277,  973,11276, 4745,11293,11103,11277,11109,11277,
11249,11277,   10,11276,   10,11277,   11,11276, 8251,11307, 3807,11307,
 9875,11307,11305,11307, 8165,11307,   33,11277, 7971,11319, 8165,11277,
   25,11323, 7947,11277,  973,11277, 4805,11329, 3807,11277, 8251,11277,
 4279,11277, 4283,11277, 9673,11277, 9967,11277, 9875,11277, 4745,11277,
   11,11277,11303,11349, 7971,11349,    2,11051,11315,11355,11303,11355,
11349,11358,11350,11355,11304,11355,11307,11365,11349,11355,11303,11368,
    5,11355,    7,11372,11276,11374,11277,11375,11377,11379,11276,11375,
11277,11374,11383,11385,    7,11355,    5,11388,11276,11390,11277,11391,
11393,11395,11276,11391,11277,11390,11399,11401,    5,11354,    7,11404,
11277,11407,    7,11405,    7,11354,11087,11413,    5,11412,11277,11417,
11307,11413,11277,11413,    4,11354,11373,11425,    7,11427,11277,11429,
   10,11354,11087,11433,11307,11433,11277,11433,   10,11355,11349,11441,
11277,11440,11307,11445,11277,11441,11303,11449,    4,11355,11410,11453,
11277,11455,    7,11453,11405,11458,11277,11461,11276,11458,11277,11459,
11405,11467,11465,11467,11276,11459,11277,11458,11473,11475,11405,11453,
    7,11478,11277,11481,    1,11452,    1,11355,    4,11486,   67,11355,
 1275,11355,    9,11493,11485,11495,11489,11495, 7947,11355,   11,11501,
11277,11503,11277,11355,   10,11506,11307,11509,   10,11507,11349,11513,
   11,11354,11326,11517,11277,11517, 7947,11520, 7947,11517,11277,11524,
    3,11051, 8213,11529, 8052,11529, 7971,11529,  113,11534,  113,11529,
 7971,11538, 8241,11529, 7947,11528,  483,11529,  112,11051,11326,11549,
11277,11549, 7947,11552, 7947,11549,11277,11556,   67,11050,11187,11561,
11053,11561,11179,11561,   66,11051,  113,11050,11556,11571,11185,11571,
11549,11571, 7947,11576,   25,11570, 3867,11581, 7947,11571,11549,11584,
   25,11571, 3933,11589, 7947,11051,  113,11592,11083,11595,11251,11595,
  113,11593,11549,11601,    3,11593,11549,11605,11517,11605,    3,11592,
   11,11051, 8116,11613, 8099,11613,11272,11613,11561,11613,11491,11613,
11251,11613,   25,11624, 8074,11613, 8093,11629,   25,11613,11251,11632,
 8109,11613, 8063,11636, 8063,11613, 8109,11640, 7957,11612,11277,11645,
 6625,11613,  113,11613,    2,11613,11183,11653,11545,11653,11611,11653,
11529,11653, 7947,11661,    3,11613, 7971,11664, 8093,11667, 7971,11665,
 8109,11671,    2,11612,11605,11675,11326,11675,11277,11675, 7947,11680,
 7947,11675,11277,11684, 7971,11613,    3,11688, 8093,11691,    3,11689,
 8063,11695,   11,11050,11355,11699,  113,11701, 1369,11699,11251,11705,
   33,11699,11251,11709,    3,11698, 8251,11713, 3807,11713,11433,11713,
11413,11713, 9875,11713, 8165,11713,    3,11699, 8241,11727,    0,   11,
 8095,11731, 8112,11731, 6688,11731, 6285,11731,  203,11730, 2351,11741,
 8159,11731, 8162,11731, 8128,11731, 8114,11731, 8097,11731, 8118,11731,
 8100,11731,    5,11730, 1369,11759, 8116,11731,    9,11762, 8099,11731,
    9,11766,  181,11731,   98,11731, 5019,11773, 8058,11731, 8093,11777,
 8156,11731, 8093,11781, 8076,11731, 8093,11785,   30,11731, 8124,11731,
 8063,11790, 8072,11731, 8109,11794, 8063,11731, 8161,11798, 8124,11798,
 8109,11798,    9,11804,    9,11798, 8109,11808,   25,11731, 6685,11812,
    9,11812,   89,11731, 5019,11819,   21,11821,   21,11818, 5019,11825,
 2759,11731, 2789,11731, 2821,11731, 6658,11731, 6685,11731,   25,11836,
 4413,11731,  113,11731,    9,11842,  128,11731,  659,11731,  623,11731,
  645,11731,  705,11731,  299,11731,  828,11731,  394,11731,  241,11731,
  375,11862,  483,11731,  803,11866, 8074,11731, 8093,11871,    9,11873,
    9,11870, 8093,11877,  101,11731,   21,11731,   89,11882, 5019,11885,
   89,11883, 5045,11889, 8061,11731, 8109,11892,  803,11731,  483,11896,
  375,11731,  241,11900,  587,11901, 6625,11731,    9,11906, 6789,11731,
    2,11911, 6855,11913, 1369,11730,  587,11730,  375,11919, 8109,11731,
 8061,11922, 8072,11922, 8063,11922,    9,11928,    9,11922, 8063,11932,
  145,11731,  903,11730,  375,11939,  265,11731, 8161,11731, 8063,11944,
    2,11730, 8124,11949, 8804,11949, 3972,11949, 8150,11949, 8495,11949,
    9,11958, 7971,11949,    9,11962, 3933,11949,    9,11966,    9,11949,
 8109,11970, 8495,11970, 3933,11970, 7971,11970, 8109,11949,    9,11980,
    3,11730,  483,11985,    2,11731, 8075,11989,    9,11991,    3,11731,
 8151,11994,    5,11995,    6,11999,    0,11998,    0,11995,    5,12004,
 8150,11994, 8093,12009, 7971,11994, 8093,12013,    9,12015,    9,12012,
 8093,12019, 1369,11995,   11,12023,12003,12025,12007,12025, 7971,11995,
 8161,12031,11997,12031, 8124,12031, 8109,12031,    9,12038,    9,12031,
 8109,12042,    9,11994, 7971,12046, 8093,12049, 7971,12047, 8109,12053,
   89,11730, 5082,12057, 2969,12057, 5045,12057,   21,12062,   21,12057,
 5045,12066,   88,11731, 7971,12070, 8093,12073, 7971,12071, 8109,12077,
 8150,11731,    3,12080, 8093,12083,    3,12081, 8063,12087, 7971,11731,
 1368,12091,  264,12090,12093,12095,    5,12090,    3,12099,    3,12098,
12093,12103, 1369,12099,    7,12091,    2,12108,12103,12111,12095,12111,
    2,12109,12101,12117,  265,12109,  265,12090, 1369,12091,12123,12125,
   88,12090, 8093,12129,   88,12091, 8061,12133,    2,12091,12001,12137,
    7,12136,12103,12141,12095,12141,    9,12137,    3,12091, 8061,12149,
 8072,12149,12121,12149, 8063,12149,    9,12156,    9,12149, 8063,12160,
    2,12090,12107,12165,12149,12165,    9,12169,    3,12090,    5,12173,
    6,12175,12137,12177,12146,12173,    5,12172,12111,12183,12141,12183,
12093,12183, 8093,12173,    9,12191,12137,12173,    9,12194,    9,12172,
 8093,12199,    9,12173,12137,12202,    9,12090,    3,12206, 8093,12209,
    3,12207, 8063,12213,    9,11731, 8116,12216, 8099,12216, 8074,12216,
 8093,12223,   25,12216, 8109,12216, 8063,12228, 8063,12216, 8109,12232,
 6625,12216,  113,12216,    3,12216, 7971,12240, 8093,12243, 7971,12241,
 8109,12247, 7971,12216,    3,12250, 8093,12253,    3,12251, 8063,12257,
    0,    9,  192,12261, 2329,12263,  211,12261, 2419,12267,  211,12260,
 2433,12271,  192,12260, 2337,12275,  189,12260, 2337,12279,    4,12261,
    7,12282,  413,12260,  413,12261, 1216,12260, 1216,12261, 1086,12261,
 9617,12295,  137,12261,  587,12261, 1011,12300, 9617,12303, 1011,12301,
 9565,12307, 1011,12261, 9617,12311,  587,12313,  587,12310, 9617,12317,
 1011,12260, 5267,12321, 9600,12321, 9565,12321,  587,12326,  587,12321,
 9565,12330,  587,12260, 5231,12335, 5181,12335,10505,12335, 1275,12261,
    2,12260,10001,12345,    5,12347,    4,12346,12349,12351,    4,12347,
    5,12346,12355,12357,    3,12260,11243,12361,11251,12361, 5177,12361,
 5185,12361,    2,12261,    3,12261,11355,12373,    1,  265,  471,12376,
 2647,12379,  357,12376, 1785,12383,  586,12377,  375,12387,  586,12376,
  413,12377,    3,12377,    7,12394,  375,12397,    7,12395,  331,12401,
  483,12395,   15,12405,    5,12377,   17,12409,  587,12411,    3,12376,
  669,12415, 1418,12415,12413,12415, 1369,12415,   15,12422,   15,12415,
 1369,12426,    5,12376,12417,12431, 1419,12431,12415,12435,  668,12431,
12415,12439,12419,12431,12407,12431,12429,12431,    9,12431,  587,12448,
12415,12451,12425,12431,  587,12431,    9,12456,12415,12459, 6719,12377,
    9,12463, 7867,12377,  251,12467, 3357,12377, 3681,12377, 3709,12377,
 2647,12377, 5843,12377, 4407,12377,11917,12377,  305,12377,  713,12377,
   25,12377, 4405,12377, 7041,12377,  251,12493, 1471,12376, 2011,12497,
   53,12376, 2035,12501,  257,12377,  253,12376, 5325,12507,  251,12376,
 7867,12511, 7617,12511, 7041,12511, 7617,12377,  251,12519, 1363,12376,
 5189,12523,  483,12377,    9,12377, 8938,12377,  375,12531, 5313,12377,
 7035,12377, 7091,12537, 7083,12537, 7123,12537,  241,12537,   11,12376,
 5313,12547,  587,12376,12387,12551,11731,12551,    9,12376, 5019,12557,
12361,12557, 1369,12376,   11,12377,  587,12377,12391,12567,    7,12376,
    2,12571,    4,12572,12537,12575,    4,12571,    2,12578,12537,12581,
12545,12571,  240,12571,12537,12587, 8948,12571,  331,12571, 8861,12592,
 8861,12571,  331,12596, 4827,12571,    6,12377,  257,12603,  265,12605,
  241,12603,    1,12609,12607,12611,    7,12377,    3,12614,  375,12617,
 8861,12614,  375,12621,  375,12615, 8861,12625,  241,12614,  375,12629,
  257,12376, 2647,12633, 1783,12633,  256,12377,  375,12639, 8861,12377,
  261,12643,  260,12643,  256,12643,    6,12643,  241,12650,    7,12643,
  241,12654,  331,12655,    6,12642,12645,12661,    7,12642,12647,12665,
12653,12665,  375,12665,  241,12643,    6,12672,12665,12675,    7,12672,
    6,12673,12679,12681,12655,12681,    7,12673,12675,12687,  241,12377,
    7,12691,  331,12693,    7,12690,  375,12697, 8997,12691,    7,12701,
  241,12376, 4457,12705,  374,12705, 5189,12705,  265,12705,    6,12712,
 8386,12705,    6,12705,  265,12718,    7,12705, 8337,12722, 8337,12705,
    7,12726, 8861,12705,    6,12731,    7,12731,    6,12730,12735,12737,
    7,12730,12733,12741,    1,  241,  448,12745, 4349,12747,  445,12744,
 1679,12751,  457,12744, 4371,12755, 8461,12744, 8475,12759,  277,12744,
 4457,12763,  923,12744, 4959,12767, 8388,12744, 8389,12744,    4,12745,
   11,12775, 1369,12777,    2,12745, 1275,12781,    9,12783,    2,12744,
 1419,12787,  668,12787,12779,12787,  587,12787,    9,12794,    9,12787,
  587,12798,    4,12744,12789,12803,  669,12803,12787,12807, 1418,12803,
12787,12811,12791,12803,12785,12803,12801,12803,   15,12803, 1369,12820,
12787,12823,12797,12803, 1369,12803,   15,12828,12787,12831,  445,12745,
  265,12834, 4349,12837,  923,12745, 5009,12841, 8374,12745,  346,12745,
 2981,12847,  386,12745,  387,12745, 3049,12853,  347,12745, 8389,12745,
12771,12859, 1412,12745, 5227,12863,  346,12744, 2977,12867,12857,12867,
  386,12744, 4067,12873,12853,12873, 1412,12744, 5189,12879,  374,12744,
12845,12883,  387,12744, 3043,12887,12851,12887,  347,12744,12847,12893,
  272,12745, 4453,12897, 4437,12897, 1755,12897, 8388,12745, 8495,12905,
12773,12905, 8387,12745,  265,12911, 8861,12913,  265,12910, 8495,12917,
  253,12745,   59,12744, 1325,12744,  341,12745,  375,12745,12883,12929,
 8337,12931, 8337,12928,12883,12935, 4371,12745,  457,12939,  375,12939,
 4531,12745,  375,12945, 8366,12745,  375,12949,  305,12744, 4457,12953,
  375,12952, 4067,12957, 4067,12953,  375,12961,  331,12744, 4457,12965,
12927,12965, 8386,12745, 8495,12971,  331,12971, 1325,12971,   59,12971,
  265,12971, 8375,12745, 8495,12983,  305,12745,12887,12987, 4266,12987,
 3031,12987, 4213,12987,  375,12994, 8337,12986,  375,12999,  375,12987,
 4213,13002, 5325,12745,    7,13007, 5361,13009, 5385,13009, 5407,13009,
 1275,12744,   15,12744, 8475,12745,  375,13021, 8461,13021,    6,12744,
 8429,13027, 8428,13027, 4139,13027, 4138,13027,    3,13026,    5,13036,
    5,13026,    3,13040,  264,13026,13031,13045,13035,13045,  264,13027,
 8401,13051, 4137,13051,  265,13026, 8401,13057,13051,13058,13029,13057,
13052,13057, 4137,13057,13051,13066,13033,13057,13054,13057,13051,13057,
 8401,13074, 4137,13074, 4137,13027,  265,13081,13051,13083,  265,13080,
13045,13087,  341,13027,  265,13027, 8401,13092,13045,13095, 4137,13092,
13045,13099,13045,13093, 8401,13103, 4137,13103, 8401,13027,  265,13109,
13051,13111,  265,13108,13045,13115,    7,12744, 8605,13119, 8374,13119,
 8916,13119, 8389,13119,  412,13119,  241,13119,  265,13130,  264,13118,
  264,13119, 8452,13119, 8647,13119,  265,13118,13137,13143, 8861,13119,
  375,13146, 8337,13119,  375,13150,  265,13150,  305,13119,  713,13119,
   25,13119,  375,13119, 8861,13162, 8337,13162,  265,13119,  241,13168,
13135,13169, 8337,13168,    6,12745,12965,13177,13145,13177,13139,13177,
 8453,13177,13119,13185,12923,13177,12925,13177,13135,13177,13169,13192,
13172,13177,13136,13177,13143,13199,13175,13177,13155,13177,13169,13177,
13135,13206,    3,13177,    5,13210,13118,13212,13119,13213,13215,13217,
13118,13213,13119,13212,13221,13223,    5,13177,    3,13226,13118,13228,
13119,13229,13231,13233,13118,13229,13119,13228,13237,13239,  264,13177,
13119,13242,13143,13245,13119,13243,13135,13249,  413,13177, 8452,13177,
 8861,13255,  305,13177, 8337,13177,  265,13260, 8861,13263,  265,13261,
 8495,13267,  265,13177, 8337,13270, 8861,13273, 8861,13271, 8337,13277,
13119,13177,  264,13280,13143,13283,  264,13281,13169,13287,  265,13280,
13287,13291,  265,13281,13283,13295, 8387,13177,  264,13299,  265,13298,
13301,13303,  264,13298,  265,13299,13307,13309,  265,13176, 8842,13313,
 8495,13313, 8337,13316, 8337,13313, 8495,13320,    7,12745,13039,13325,
13043,13325,13045,13325,  241,13324,    0,13333, 8717,13325, 8495,13325,
 8337,13339,  305,13339, 4311,13325, 4329,13325, 3785,13325,10351,13325,
10055,13325, 8337,13324, 8495,13355,  331,13355, 1325,13355,   59,13355,
  265,13355,   59,13325, 8337,13367, 1325,13325, 8337,13371,  331,13325,
 8337,13375, 8861,13375,  265,13325,13051,13381,13335,13381, 5325,13381,
    1,13381,13333,13389, 8861,13381, 8337,13381,13027,13325,  264,13396,
  264,13397,  265,13396,13401,13403,  265,13397,13399,13407,  265,13324,
 8717,13411, 3785,13411,13045,13411, 8495,13411,  374,12745, 8842,13421,
 8495,13421, 8337,13424, 8337,13421, 8495,13428,  340,12745, 8717,13433,
13045,13433, 3785,13433, 8495,13433,  375,12744, 4371,13443,13428,13443,
12983,13443, 8475,13443,13421,13443, 8337,13452,  305,13442, 4067,13457,
 8337,13443,13421,13460,  305,13443, 4213,13465, 8452,12745, 8647,13469,
    7,13469, 8495,13473, 8337,12745,  375,13476,12883,13479,  375,13477,
  305,13483,13421,13483,  305,13476,  375,13489,    6,13477, 8453,13493,
 8452,13492,13495,13497, 8452,13493, 8453,13492,13501,13503,    7,13477,
13213,13507,13229,13507,  375,13507,13243,13507,  265,13507,13177,13517,
    6,13476,    3,13521,    5,13522,13507,13525,    5,13521,    3,13528,
13507,13531,13517,13521,  264,13521,13507,13537,    7,13476, 8495,13541,
  331,13541, 1325,13541,   59,13541,  265,13541,  265,13476, 8647,13553,
    7,13553, 8495,13557,  265,13477,13177,13561,13521,13561,    7,13561,
  265,12745,  445,13568, 4349,13571,  445,13569, 4371,13575, 8770,13569,
 8729,13569,13027,13569,  375,13583, 8684,13569, 8717,13587,  331,13569,
13177,13591, 8757,13569, 8647,13594, 8647,13569, 8757,13598, 8387,13568,
 8495,13603,    6,13569,    7,13569, 8647,13609, 8495,13608, 8717,13613,
 8495,13609, 8757,13617,    6,13568, 8842,13621, 8495,13621, 8337,13624,
13609,13621, 8337,13621, 8495,13630,    7,13568, 8717,13635, 3785,13635,
13045,13635, 8495,13635,13607,13635, 8337,13568, 8647,13647,    7,13647,
 8495,13651, 8495,13569,    6,13654,    7,13654, 8717,13659,    6,13655,
13659,13663,    7,13655,13657,13667, 8647,13667,  265,12744,13258,13673,
12845,13673,13091,13673,12935,13673,12927,13673,12929,13673, 8337,13685,
13479,13673,12911,13673,13260,13673,12859,13673, 4457,13673, 5189,13673,
13177,13673,  305,13700, 8337,13700,  305,13673,13177,13706, 8386,13673,
    7,13673, 8337,13712, 8861,13673,    6,13717,    7,13717,    6,13716,
13721,13723,    7,13716,13719,13727, 8337,13673,13177,13730,    7,13730,
    1,  587,  264,13737,  375,13739,   16,13737,  264,13736,  341,13745,
    7,13737,    4,13748,    4,13749,    3,13736,  717,13755,  341,13755,
    6,13755,  713,13761,   17,13755,  566,13736, 1108,13737, 9565,13769,
11731,13737,  265,13772,11942,13737, 3565,13737, 3573,13737, 3273,13737,
  375,13736,  113,13736, 4696,13787,    9,13787, 4669,13790, 4669,13787,
    9,13794, 1011,13737, 9565,13799,    9,13801,    9,13798, 9565,13805,
  241,13737,    9,13737, 1011,13810, 9565,13813, 1011,13811, 9617,13817,
  113,13737, 4727,13821,    9,13823, 7049,13737,  807,13827,  375,13827,
  265,13736,11731,13833, 1487,13737, 1011,13736, 5293,13839, 9704,13839,
 9617,13839,    9,13844,    9,13839, 9617,13848,  265,13737,11731,13852,
    4,13736,13757,13857,13762,13857,13761,13857,  713,13862,13759,13857,
  340,13857,13745,13869,13747,13857,13740,13857,  375,13857,13739,13876,
    7,13857,  265,13880,13745,13883,  265,13881,13739,13887,13739,13857,
  375,13890,  713,13857,13761,13894,  265,13857,    7,13898,13745,13901,
  483,13857,    5,13736,13853,13907,  375,13909,  483,13906,    4,13737,
    7,13914,  767,13915,13761,13919,    5,13737,    3,13923,    1,13924,
    1,13923,    3,13928,   17,13923,  587,13933,13927,13935,13931,13935,
  567,13736,  483,13736,    5,13942,    1,  483, 9174,13946, 9175,13946,
    2,13947,    7,13952,    2,13946,    7,13957,    6,13946, 9170,13947,
 9175,13947,13949,13965,  824,13946, 3997,13969,  802,13946,13963,13973,
  766,13946,  825,13946, 9174,13947,13951,13981,  803,13947,13973,13985,
 9165,13987, 9165,13984,13973,13991,  713,13946,  803,13994, 3997,13997,
 3997,13995,  803,14001, 1171,13946, 4663,14005,  903,14007,  155,13946,
 9172,13947, 9171,13947,  713,13947,13979,14017, 4200,14017, 3027,14017,
 4147,14017,  803,14024,  803,14017, 4147,14028, 1171,13947, 4722,14033,
  903,14033, 4713,14036, 4713,14033,  903,14040,  257,13947,    9,14045,
    9,13946,  257,14049,  903,13946,  257,14053,   11,13946, 5197,14057,
 5125,14057,12335,14057,    4,13946,    2,14065,    7,14067,14013,14069,
    5,13946,13958,14072,13959,14073,14075,14077,13958,14073,13959,14072,
14081,14083,  586,14072,  586,14073,  587,14072,14089,14091, 4827,14073,
    9,14073, 4569,14073, 4745,14073,  587,14073,14087,14103,    4,13947,
14093,14107,14087,14107,14103,14110,14104,14107,14088,14107,14091,14117,
14103,14107,14087,14120,    3,14107,    7,14124,14072,14126,14073,14127,
14129,14131,14072,14127,14073,14126,14135,14137,    7,14107,    3,14140,
14072,14142,14073,14143,14145,14147,14072,14143,14073,14142,14151,14153,
    3,14106,    7,14157,    2,14106,14125,14161,    7,14163,14073,14165,
  586,14107,14073,14168,14091,14171,14073,14169,14087,14175,    2,14107,
14158,14179,14073,14181,    7,14179,14157,14184,14073,14187,14073,14185,
14157,14191,14157,14179,    7,14194,14073,14197,14073,14107,  586,14200,
14091,14203,  586,14201,14103,14207,    5,13947,14069,14211, 9165,14213,
    6,14211, 9165,14210,14069,14219,   17,14211,  802,13947, 9165,14225,
  803,13946,14226,14229,14015,14229,14225,14229, 9165,14234,  713,14228,
 3997,14239, 9165,14229,14225,14242,  713,14229, 4147,14247, 9165,13947,
  803,14250,13973,14253,  803,14251,14225,14257,    4,14251,    2,14261,
    7,14263,    5,14250,14265,14267,14069,14267,  587,13947, 9340,14273,
 9323,14273, 9290,14273, 9317,14279, 9335,14273, 9287,14282, 9287,14273,
 9335,14286,    5,14273, 9195,14290, 9317,14293, 9195,14291, 9335,14297,
 9195,14273,    5,14300, 9317,14303,    5,14301, 9287,14307,  587,13946,
    5,14310,    0,  265,  446,14315, 4371,14317,  445,14314, 1675,14321,
 8725,14315, 8766,14315,  471,14314, 2367,14329, 8827,14315, 8836,14315,
  319,14314, 4497,14337, 1302,14315,  667,14315, 8794,14315, 8768,14315,
 8727,14315, 8774,14315, 8732,14315, 1011,14315, 1275,14354,    3,14315,
 1369,14359,   11,14361,    5,14315,    9,14365, 1275,14367,    3,14314,
 1291,14371,  524,14371,14369,14371,  483,14371,   11,14378,   11,14371,
  483,14382,    5,14314,  525,14387,14371,14389,14373,14387,14375,14387,
 1290,14387,14371,14397,14363,14387,14385,14387,14381,14387,   17,14387,
 1275,14406,14371,14409, 1275,14387,   17,14412,14371,14415, 8770,14315,
  241,14418, 8729,14315,  241,14422,  445,14315,  241,14426, 4371,14429,
 1303,14315,  666,14315, 8784,14315, 4266,14315, 8622,14315, 8717,14441,
 8824,14315, 8717,14445, 8702,14315, 8717,14449,  256,14314, 7185,14453,
 2309,14453, 5673,14453, 5521,14453,  375,14461, 4213,14315,  375,14464,
  316,14315, 4533,14469, 1757,14469, 8697,14315,  629,14315,  407,14315,
 5325,14479, 3121,14315, 3031,14315, 5519,14315, 3355,14315,  510,14315,
 8788,14315, 8647,14492, 8676,14315, 8757,14496, 8647,14315, 8831,14500,
 8788,14500, 8757,14500,  241,14506,  241,14500, 8757,14510,  331,14315,
 1325,14315,   59,14315, 5521,14315,  375,14521,  375,14315, 4213,14524,
 8757,14524,   53,14525, 1471,14525,  253,14525,  253,14314, 4425,14537,
 4497,14537,  483,14315,    9,14542,    9,14315,  483,14546, 8684,14315,
 8717,14551,  241,14553,  241,14550, 8717,14557,  331,14551,  251,14315,
  257,14563, 8495,14565, 8635,14315, 8757,14568, 5515,14315,  331,14573,
 8757,14315, 8635,14576, 8676,14576, 8647,14576,  241,14582,  375,14576,
  241,14576, 8647,14588, 1369,14314, 2853,14593,   15,14315, 1275,14315,
 1011,14598,  587,14315,  241,14602, 8831,14315, 8647,14606,    6,14314,
14341,14611,14343,14611,14601,14611,14357,14611, 8495,14611,  241,14611,
    7,14314,14433,14625,14435,14625,14605,14625, 8495,14625, 3785,14625,
10055,14625,10351,14625, 4329,14625, 4311,14625, 4555,14625,14073,14625,
 4971,14625, 8717,14625,    7,14315, 8813,14652,14623,14653, 8495,14657,
    4,14653,    2,14660,14620,14663, 8495,14663,14611,14666,14611,14663,
 8495,14670,    2,14653,    4,14674,14620,14677, 8495,14677,14611,14680,
14611,14677, 8495,14684,  240,14653,14620,14689, 8495,14689,14611,14692,
14611,14689, 8495,14696, 8812,14652, 8717,14701, 8495,14652, 8717,14705,
  241,14707,  241,14704, 8717,14711,  331,14705,   15,14653,  483,14717,
 1275,14653,    9,14721, 8495,14653, 8831,14725,14655,14725, 8788,14725,
 8757,14725,  241,14732,  241,14725, 8757,14736,  375,14653, 8647,14653,
  241,14652, 8647,14745, 8495,14744, 8717,14749, 8495,14745, 8757,14753,
  257,14314, 8614,14757, 4417,14757, 8495,14757,  251,14762,  251,14757,
 8495,14766,  256,14315, 8647,14771, 7207,14771, 5432,14771, 5325,14771,
  375,14778, 8495,14770, 8717,14783,  375,14771, 5325,14786, 8495,14771,
 8757,14791, 8812,14315,    6,14794,    7,14794, 8717,14799,    6,14795,
14799,14803,    7,14795,14797,14807, 8647,14807, 8495,14315,  261,14812,
  260,14812,  256,14812, 8717,14819,  256,14813, 8635,14823,    6,14813,
14815,14827,    7,14813,14817,14831, 8635,14831, 8676,14831, 8647,14831,
  241,14838,  375,14831,  241,14831, 8647,14844,    6,14812,  241,14848,
14831,14851,    7,14812, 8717,14855,  241,14857,  241,14854, 8717,14861,
  331,14855,  241,14812,    6,14866,14831,14869,    7,14866, 8717,14873,
    6,14867,14873,14877,14855,14877,    7,14867,14869,14883, 8647,14883,
  241,14315,  445,14888, 4371,14891,  445,14889, 4349,14895, 8770,14888,
 8729,14888,  587,14888,14625,14903, 8684,14888, 8717,14907, 8757,14888,
 8647,14910, 8387,14889, 8495,14915, 8647,14888, 8757,14918,    6,14889,
 8842,14923, 8495,14923, 8337,14926, 8337,14923, 8495,14930,    7,14889,
 8717,14935, 3785,14935, 8495,14935,    6,14888,14935,14943,    7,14888,
 8647,14947, 8495,14946, 8717,14951,14923,14947, 8495,14947, 8757,14957,
 8495,14888,    6,14960,    7,14960, 8717,14965,    6,14961,14965,14969,
    7,14961,14963,14973, 8647,14973, 8337,14889, 8647,14979,    7,14979,
 8495,14983,12745,14315,  375,14987,  241,14314, 9099,14991, 9036,14991,
 8647,14991, 8997,14996, 5521,14991,  375,15001,  375,14991, 9082,14991,
 8495,15007,    7,14991, 8495,15011, 8997,15013, 8997,15010, 8495,15017,
 8997,14991, 8647,15020,    7,15020, 8495,15025,    0,  241,  460,15029,
 2315,15031,  479,15029, 2393,15035,  479,15028, 2397,15039,  460,15028,
 2317,15043,  457,15028, 2317,15047,  269,15028, 2885,15051,  464,15029,
   16,15029,  413,15029,    6,15058,    4,15029,    7,15062,    7,15063,
   15,15063,  483,15069,    2,15029,  587,15073,   17,15075,    2,15028,
  525,15079, 1290,15079,15071,15079, 1275,15079,   17,15086,   17,15079,
 1275,15090,    4,15028, 1291,15095,15079,15097,15081,15095,15083,15095,
  524,15095,15079,15105,15077,15095,15093,15095,15089,15095,   11,15095,
  483,15114,15079,15117,  483,15095,   11,15120,15079,15123, 9072,15029,
  305,15127, 9105,15029,  305,15131, 9083,15029,  413,15135,  412,15134,
15137,15139,  412,15135,  413,15134,15143,15145, 3445,15029,  375,15149,
12526,15029,12528,15029,  251,15029,  375,15029,  305,15159, 8997,15161,
 8997,15158,  305,15165,12614,15029,  375,15169, 7065,15029,  265,15173,
 7259,15175,  305,15028, 9105,15179, 9072,15179,  375,15179, 8997,15184,
 8997,15179,  375,15188, 9082,15029,  375,15193,  265,15193, 5521,15029,
  375,15199,  265,15199,  483,15029,12377,15204,    9,15029,12377,15208,
   17,15029,13737,15029,  375,15215,    6,15028,    3,15219,    5,15220,
15193,15223,    5,15219,    3,15226,15193,15229,15197,15219,15057,15219,
    3,15235,    2,15234,15237,15239,    2,15235,    3,15234,15243,15245,
15065,15219,    3,15249,    2,15248,15251,15253,    2,15249,    3,15248,
15257,15259,  264,15219,15193,15263, 8997,15219,    7,15028, 4437,15269,
15213,15269,    3,15273,    2,15272,15275,15277,    2,15273,    3,15272,
15281,15283,12571,15269, 4805,15269, 4613,15269,14073,15269,  375,15269,
  510,15269, 4971,15269,  483,15269,    9,15300,    9,15269,  483,15304,
    6,15029, 9020,15309, 9021,15309,12393,15309,12392,15309, 8337,15309,
  265,15318, 8452,15308,  241,15322, 8453,15309,15325,15327, 8452,15309,
 8453,15308,  412,15309, 8997,15335,  241,15308,  265,15338,15327,15341,
 8452,15339,15333,15345,15067,15309,    3,15349,    2,15348,15351,15353,
    2,15349,    3,15348,15357,15359,  413,15308,15313,15363,15315,15363,
15331,15363,15321,15363, 8997,15363,15335,15372,15336,15363,15335,15363,
 8997,15378,  412,15308,15311,15383,15317,15383,15327,15383,  413,15309,
12377,15390,15383,15393, 8997,15390,15383,15397,15383,15391, 8997,15401,
12377,15309,  413,15404,15383,15407,  413,15405,15335,15411, 8997,15309,
  413,15414,15383,15417,  413,15415,15335,15421,  265,15309, 8337,15424,
15363,15427,  265,15308,  241,15430,15327,15433,    7,15029,15223,15437,
 8997,15439,15229,15437, 8997,15443,15263,15437, 8997,15447,    4,15436,
15219,15451,    3,15453,    2,15452,15455,15457,    2,15453,    3,15452,
15461,15463,  264,15436,  264,15437,12377,15436,  375,15471, 8997,15436,
15223,15475,15229,15475,  375,15475,15263,15475,  265,15475,15219,15485,
   59,15437, 1325,15437,  331,15437, 1275,15437,    9,15495,   15,15437,
  483,15499,  265,15437,15266,15503,15219,15503, 8997,15506,15467,15503,
 8997,15503,15219,15512,  305,15503,  265,15436,15469,15519,  331,15519,
  375,15028, 3307,15525, 2885,15525,12511,15525,12377,15525,  251,15533,
  340,15029,  331,15537, 9136,15029,    7,15541, 8997,15029,  375,15544,
  305,15547,  305,15545,  375,15551,    6,15545,    3,15555,    5,15556,
    5,15555,    3,15560,  264,15555,    7,15545, 8495,15567,  331,15567,
 1325,15567,   59,15567,  265,15567,    7,15544,15559,15579,15563,15579,
15223,15579,15229,15579,  375,15579,15263,15579,15565,15579,  265,15579,
15219,15595,15555,15595,  265,15544,15555,15601,    7,15601,  265,15545,
 8647,15607,    7,15607, 8495,15611,  265,15029,    7,15615,  375,15617,
    7,15614,  331,15621, 8997,15614,    7,15625,12377,15029,13421,15629,
13313,15629,13621,15629,14923,15629,12721,15629,12715,15629,12709,15629,
  375,15629,12705,15645,    7,15629,  331,15649,  483,15628,    9,15628,
    7,15628,  375,15657,  265,15028, 9036,15661, 9099,15661,  241,15661,
    6,15667,15629,15669, 8647,15661, 8997,15672, 5521,15661,  375,15677,
 9082,15661, 8495,15681,  375,15661,    7,15661, 8495,15687, 8997,15689,
 8997,15686, 8495,15693, 8997,15661, 8647,15696,    7,15696, 8495,15701,
    0,  587, 9319,15705, 9336,15705,  889,15704, 2373,15711, 9371,15705,
 9374,15705, 9350,15705, 9338,15705, 9321,15705, 9342,15705, 9324,15705,
  578,15705,    3,15705,    6,15730,    7,15705,  567,15735, 9195,15737,
    4,15735, 9366,15741,  483,15741, 9195,15744, 9195,15741,  483,15748,
    7,15704, 9340,15705,  483,15754, 9323,15705,  483,15758,  579,15705,
 9272,15705, 9317,15765, 9368,15705, 9317,15769, 9294,15705, 9317,15773,
  566,15704,15729,15777, 9348,15705, 9287,15780, 9288,15705, 9335,15784,
 9287,15705, 9373,15788, 9348,15788, 9335,15788,  483,15794,  483,15788,
 9335,15798,  567,15705,    9,15802,15777,15805,15777,15803,    9,15809,
12377,15705,   11,15813,    9,15705,  567,15816,15777,15819,  567,15817,
 9290,15705, 9317,15825,  483,15827,  483,15824, 9317,15831, 9275,15705,
 9335,15834,  375,15705,   11,15839,   11,15704,  375,15843, 9335,15705,
 9275,15846, 9288,15846, 9287,15846,  483,15852,  483,15846, 9287,15856,
    9,15704, 5231,15861, 5181,15861,10505,15861,14057,15861, 1011,15704,
  375,15871, 9373,15705, 9287,15874,    4,15704, 9262,15879,  375,15879,
 9195,15882,    7,15879,  265,15887, 9195,15889, 9195,15879,  375,15892,
  483,15879,    5,15704,    5,15705, 9367,15900, 9366,15900, 9317,15905,
 9195,15900, 9317,15909,  483,15911,  483,15908, 9317,15915, 9195,15901,
 9373,15919,15903,15919, 9348,15919, 9335,15919,  483,15926,  483,15919,
 9335,15930,  483,15900, 9195,15934, 9317,15937, 9195,15935, 9335,15941,
  567,15704,15763,15945,    9,15945,  566,15705,15823,15951,15948,15951,
15945,15951,    9,15956, 9195,15950, 9317,15961, 9195,15951, 9335,15965,
    9,15951,15945,15968, 9366,15705,    5,15972, 9317,15975,    5,15973,
 9287,15979, 9195,15705,  566,15982, 9317,15985,  566,15983, 9275,15989,
    5,15983, 9275,15993, 9288,15993, 9287,15993,  483,15998,  483,15993,
 9287,16002,    5,15982, 9317,16007,  483,16009,  483,16006, 9317,16013,
  483,15982,    5,16016, 9317,16019,    5,16017, 9287,16023,  483,15705,
 9340,16026, 9323,16026, 9290,16026, 9317,16033, 9335,16026, 9287,16036,
 9287,16026, 9335,16040,    5,16026, 9195,16044, 9317,16047, 9195,16045,
 9335,16051, 9195,16026,    5,16054, 9317,16057,    5,16055, 9287,16061,
    0,  483,  878,16065, 2327,16067,  899,16065, 2415,16071,  899,16064,
 2423,16075,  878,16064, 2331,16079,  875,16064, 2331,16083,  573,16064,
 2569,16087,    2,16064,   15,16091,  413,16064,  413,16065,  573,16065,
 2567,16099, 1216,16064, 1216,16065,  904,16065, 2263,16107, 6515,16065,
    5,16111, 6539,16113,  903,16064, 4421,16117, 5285,16117, 2265,16117,
    4,16064,    5,16064,    4,16065,    2,16129,    7,16131,    0,16130,
    0,16129,    2,16136,   15,16129,  483,16141,16135,16143,16139,16143,
 9513,16065,    5,16149,16133,16151,    4,16148,    2,16155,    7,16157,
16151,16159,    1, 1011,  996,16162,   14,16162,    5,16163,    6,16169,
 9617,16171,    2,16162, 9617,16175,16171,16176,16172,16175,16171,16175,
 9617,16182,    7,16175,16169,16187, 9617,16189,    5,16162,16186,16193,
16175,16193,    7,16196,    7,16197,16187,16193,    6,16192,16195,16205,
16199,16205,    7,16192,16203,16211,16175,16211,    3,16211,16162,16217,
    3,16193,    7,16221,16162,16222,16162,16221,    7,16226,    7,16227,
16205,16231,    6,16193,16201,16235,16214,16235,16175,16235,16211,16240,
16211,16235,16175,16244,16225,16235,16229,16235,16219,16235,    7,16193,
16175,16254,16205,16257,16205,16255,16175,16261, 9704,16163,  587,16265,
 5293,16163,  587,16269,  997,16162,  972,16162,16235,16275,    9,16275,
14652,16163,  973,16163,16273,16283,16278,16283,    9,16283,16275,16288,
16275,16283,    9,16292,  955,16162, 5241,16297, 1505,16162,    6,16301,
    7,16300,16303,16305,    7,16301,    6,16300,16309,16311,   67,16162,
16235,16315,    9,16163, 9617,16318,  587,16321,  587,16319, 9617,16325,
   15,16162,  257,16163,    9,16331,    9,16162,  973,16335,16275,16337,
  973,16334,  257,16335,  587,16162, 5293,16345, 9704,16345, 9617,16345,
    9,16350,    9,16345, 9617,16354,    6,16162,    5,16358,    7,16162,
16221,16362,16235,16365,16235,16363, 8647,16363,  903,16362,16235,16373,
    6,16163,16329,16377,    7,16163,16167,16381,16205,16381,16361,16381,
 8717,16381,14315,16380, 4311,16381, 4329,16381, 3785,16381,10351,16381,
10055,16381,  973,16162,    9,16402,  972,16163,16341,16407,16165,16407,
16405,16407,16403,16407,    9,16415, 9617,16163, 1368,16418,   14,16418,
    2,16418,    7,16425,16423,16427,    7,16424,    5,16418,    6,16433,
16431,16435,16421,16435,    6,16432,16427,16441,    2,16419,16435,16445,
16171,16445,    7,16445,16433,16451,    9,16418,  587,16455,  587,16419,
    9,16459,    6,16418,    5,16462,16427,16465,    7,16418,    2,16468,
16435,16471,14315,16163,    7,16474,   17,16475,  903,16162,    3,16480,
    6,16483,    6,16482, 5241,16481, 1274,16480,   15,16480, 1275,16480,
    6,16480,    3,16496,    5,16496,    7,16480,16485,16503,16235,16503,
    6,16481,16495,16509,16493,16509,    7,16481,16499,16515,16501,16515,
16487,16515,16205,16515,16361,16515,16491,16515,16167,16515,    1,  903,
 9542,16530, 9543,16530, 1274,16530,    3,16530, 9541,16539,    6,16538,
    7,16538,    5,16545,16530,16547,    5,16539,    7,16551,16530,16552,
16530,16551,    7,16556,    7,16557,16543,16561,    6,16539, 9533,16565,
16545,16565,16555,16565,16559,16565,16549,16565,    7,16539,16543,16577,
    4,16530,16576,16581,16543,16583,16539,16581,    7,16586,16543,16589,
    7,16587,16565,16593,16545,16581,16565,16596,16565,16581,16545,16600,
16568,16581,16579,16581,    7,16581,16539,16608,16543,16611,16539,16609,
16545,16615, 1170,16530,16565,16619, 9541,16531,16535,16623,  559,16530,
 5241,16627,  767,16530,16565,16631,  165,16530,    6,16635,    7,16634,
16637,16639,    7,16635,    6,16634,16643,16645, 9540,16531,16543,16649,
16533,16649,16539,16649,16537,16649, 1275,16530,16623,16659, 9533,16659,
  257,16531,  483,16665,  483,16530,  257,16669,   15,16530, 5241,16673,
    6,16530,    3,16676,16649,16679,    7,16530,16541,16683,16566,16683,
16551,16682,16565,16689,16565,16683, 9533,16692,  375,16683, 1011,16682,
16565,16699, 9533,16683,16565,16702,15269,16683, 4827,16683,    6,16531,
16662,16711,16659,16711, 9533,16714, 9533,16711,16659,16718,    7,16531,
16539,16723, 9533,16725,16537,16723, 9533,16729, 1007,16723,16543,16723,
 9533,16735,16679,16723, 9533,16739,  331,16723, 1325,16723,   59,16723,
 9533,16722,16543,16749,16539,16749,16679,16749,16537,16749, 9533,16531,
 1275,16759,16711,16761,    7,16759,16565,16765,    7,16758,16539,16769,
16543,16769,16679,16769,16537,16769,15029,16531,    7,16779, 1011,16530,
    5,16782,    6,16785,    6,16784, 5241,16783,   14,16782, 1275,16782,
   15,16782,    6,16782,    5,16798,    3,16798,    7,16782,16787,16805,
16565,16805,    6,16783,16797,16811,16795,16811,    7,16783,16801,16817,
16803,16817,16789,16817,16543,16817,16679,16817,16793,16817,16537,16817,
    1, 1369, 1010,16833,   16,16833,    2,16833,    5,16838,    5,16839,
16837,16843,    7,16833,    4,16846,16843,16849,    4,16847,16841,16853,
16835,16853,    2,16832,   11,16859,15900,16833,  331,16832,   59,16832,
 6717,16833,    9,16869, 1325,16832,  265,16832,    4,16833,    7,16876,
16843,16879,    2,16877,    1,16882,    1,16877,    2,16886,   11,16877,
 1369,16891,16885,16893,16889,16893,    5,16833,    2,16898,16853,16901,
15705,16898, 1275,16898,    9,16907, 1346,16833,    9,16911,15705,16833,
   11,16915,    5,16914, 1275,16833,    5,16921,   17,16923,    5,16920,
    9,16927, 1275,16832, 6717,16931,    9,16933,    1, 1275, 5814,16937,
  902,16937,  902,16936,    3,16937,    7,16944,  413,16937, 1216,16937,
 6787,16937,    5,16953,    4,16952,16955,16957,    4,16953,    5,16952,
16961,16963, 1505,16937, 5771,16937,  903,16968, 1011,16937,  903,16972,
  903,16936,16941,16977,  241,16936,   17,16936, 5299,16983, 4915,16983,
   11,16936,  903,16937, 5771,16990,16943,16991, 1011,16990,15208,16937,
    9,16937,15029,17000,15029,16937,    9,17004,    4,16936,  265,17009,
    5,16936,    4,16937, 1011,17015, 1369,16936, 6717,17019,    9,17021,
    1,   17,    4,17025,    6,17026,  113,17025, 1275,17024, 5299,17033,
 4915,17033,  241,17025,    2,17024,    3,17024,11731,17025,  265,17045,
    1,   15, 5886,17049,    5,17048,  483,17053,  413,17049, 1216,17049,
  165,17049, 5843,17049, 1011,17062,14315,17049,   17,17067,  903,17049,
 1011,17070, 1011,17048,  241,17048,  903,17048, 5241,17079, 1011,17049,
 5843,17082,  903,17082,15204,17049,  483,17049,15029,17090,15029,17049,
  483,17094,    3,17048,  483,17099,    2,17049,    3,17049,    5,17105,
    1,17106,    1,17105,    5,17110,  483,17105,   15,17115,17109,17117,
17113,17117, 1369,17105,    0, 1011,    2,17125,    7,17127, 9565,17129,
    5,17124, 9565,17133,17129,17134,17130,17133,17129,17133, 9565,17140,
    6,17133,17127,17145, 9565,17147, 9600,17125,    9,17151, 5267,17125,
    9,17155,16722,17125,10385,17125,    9,17161,  587,17125, 9565,17164,
    9,17167,    9,17165, 9565,17171, 1275,17125,  903,17175,    9,17125,
  375,17125,  587,17181,    9,17124, 5267,17185, 9600,17185, 9565,17185,
  587,17190,  587,17185, 9565,17194,  587,17124,  375,17199,13737,17125,
    9,17203,    6,17124,17176,17207,17175,17207,  903,17210,  903,17207,
17175,17214,    7,17124,10001,17219,  903,17221,    6,17125,    3,17224,
17219,17227,  903,17229,    7,17125,   88,17233,   89,17233,  265,17233,
  264,17232,17239,17241,  264,17233,    3,17233,    9,17246,    3,17232,
17237,17251,    9,17251,    2,17232,17235,17257,17249,17257,17247,17257,
    9,17263,  265,17232,17245,17267,    2,17233,17254,17271,    9,17271,
17251,17274,17251,17271,    9,17278,16531,17232,    9,17233,    3,17284,
17257,17287,    3,17285,17271,17291,  903,17233, 9565,17125, 1368,17297,
   14,17297,    2,17296,    7,17303,    2,17297,    7,17306,    7,17307,
17301,17311,    5,17297,17305,17315,17129,17315,    6,17314,17311,17321,
    6,17315,17309,17325,17303,17325,17299,17325,  587,17296,    9,17333,
    9,17297,  587,17337,    6,17297,    5,17340,17311,17343,    7,17297,
    2,17346,17325,17349,12377,17125,    9,17353,16531,17125,    6,17357,
    7,17357,    6,17356,17361,17363,    7,17356,17359,17367,    0,  903,
  767,17370, 4617,17373,  483,17375,   15,17371, 1011,17379,  767,17371,
 4588,17383,  483,17383, 4579,17386, 4579,17383,  483,17390,  375,17371,
   11,17395,  483,17370, 2265,17399, 4421,17399, 5285,17399,   11,17370,
  375,17407,    6,17370,17380,17411,17379,17411, 1011,17414, 1011,17411,
17379,17418,    7,17370, 3549,17423, 2001,17423, 8495,17423,10291,17423,
 1011,17431,14073,17423,11277,17423, 4971,17423, 5045,17423,    6,17371,
    5,17442,17423,17445, 1011,17447,    7,17371, 1011,17451,    0, 1369,
 2789,17455, 2821,17455, 2759,17455, 2687,17455, 6658,17455,    2,17455,
    6,17466, 6625,17455,    9,17470,12551,17455, 1347,17455,13808,17455,
 6685,17455,13833,17455, 4413,17455,17025,17455,  265,17487,  241,17486,
17038,17455,  903,17455,    9,17455, 6625,17496,   17,17454,12377,17501,
   11,17454,12377,17505,  803,17455,   15,17454, 5303,17511, 4927,17511,
17033,17511,16983,17511,  265,17454, 2853,17521,17082,17455,   11,17455,
12377,17526,12564,17455,  241,17455,13737,17532,17025,17532, 1011,17455,
17049,17538,12377,17455,   10,17543,   10,17542,  305,17543,   11,17543,
17547,17551,   11,17542,17545,17555,17049,17455, 1011,17558,    4,17454,
    5,17455,13737,17455,  241,17566,    0, 1275,    3,17570,    9,17573,
    4,17570,    5,17570, 9856,17579, 9805,17579,    9,17582,    9,17579,
 9805,17586,    5,17571,    3,17591,    0,17592,    0,17591,    3,17596,
    9,17591, 1275,17601,17595,17603,17599,17603,   17,17591, 9805,17609,
 1369,17590,   17,17613, 1486,17571,   17,17617, 1369,17571,17577,17621,
    9,17623,    5,17621,    9,17627,    5,17620,   17,17631,    0,   17,
    4,17634,  587,17637,  155,17635, 1011,17635, 1369,17634,12377,17645,
16990,17635,  587,17635,12377,17650,12566,17635,  903,17635,16937,17656,
12377,17635,  587,17660,16937,17635,  903,17664,    3,17634,  483,17669,
    2,17635,    4,17673,    0,17674,    0,17673,    4,17678,  587,17673,
   17,17683,17677,17685,17681,17685,    3,17635, 1369,17691,    0,   15,
    5,17695,    7,17696, 1369,17694, 5303,17701, 4927,17701,16983,17701,
17033,17701,    3,17694,    3,17695,10104,17712,10105,17713,17715,17717,
10104,17713,10105,17712,17721,17723,    1,   13,  113,17727,    0,   12,
17727,17731,    9,17732,    2,17735,    2,17734,  137,17732,  136,17732,
    2,17733,17741,17745,    3,17733,17739,17749,17743,17749,    2,17732,
    9,17754,17749,17757,17749,17755,    3,17732,17737,17763,17745,17763,
    0,   13,    1,   12, 1369,17771,   33,17771,    3,17770, 8251,17777,
 3807,17777, 9875,17777, 8165,17777,    3,17771, 8241,17787,17769,17771,
    9,17791,    2,17792,    2,17793,  137,17791,  136,17791,    2,17791,
    9,17802,    3,17791,17797,17807,    2,17790,17807,17811,17799,17811,
    3,17790,17805,17817,17795,17817,17803,17817,17801,17817,    1,  413,
    4,17826,    2,17826,    5,17826,    6,17833,    6,17832,    3,17826,
    6,17839,    6,17838, 2653,17827, 1637,17827,14537,17827,14321,17827,
  260,17826, 2903,17827, 1639,17827, 1641,17827, 3361,17827,  331,17826,
17521,17827, 4909,17827,14593,17827,  261,17826,  257,17826,   14,17826,
 1274,17826, 2159,17827, 2161,17827,  251,17827, 2647,17827,  331,17885,
   15,17826, 1275,17826,14652,17827,    6,17827,17829,17895,17831,17895,
 8997,17895,17863,17895,17871,17895,17889,17895,17891,17895,    7,17827,
17833,17911,17839,17911, 8495,17911,  413,17910,    0,17919,17837,17911,
17843,17911,  265,17911,17921,17927,    1,17927,17919,17931, 2647,17927,
 8717,17911, 3785,17911,17853,17911,17875,17911,17877,17911,14315,17910,
  261,17911,    7,17826,17835,17951,17841,17951, 8647,17951,  251,17951,
    6,17826,    5,17960,17911,17963,    3,17960,17911,17967,15029,17827,
  265,17971,17895,17973,    7,17971,14315,17827,    6,17978,    7,17978,
    6,17979,17983,17985,    7,17979,17981,17989,    0,  412, 9036,17993,
 9099,17993,17829,17993,17895,17998,17831,17993,17895,18002,17896,17993,
17898,17993,17913,17993,17915,17993,  446,17993, 4371,18015, 4379,17993,
17900,17993,17917,17993, 4360,17993, 3429,17993,17882,17993, 7039,17993,
17958,17993,17949,17993,  241,17993,  445,18036, 4371,18039,  445,18037,
 4349,18043,16097,17993,12289,17993, 8647,17993, 8997,18050, 4349,17993,
  251,18054,17951,17993,  251,18058,  251,17993, 4349,18062,17827,18062,
17951,18062,17895,17993,17829,18070,17831,18070, 8997,18070, 5521,17993,
  375,18079,  445,17993,  241,18082, 4371,18085,    3,18083,    2,18082,
18089,18091,    2,18083,    3,18082,18095,18097,  465,17993,    5,18101,
    4,18100,18103,18105,    4,18101,    5,18100,18109,18111, 9082,17993,
 8495,18115,17910,17993,17833,18119,17839,18119, 8495,18119,  375,17993,
    7,17993, 8495,18129, 8997,18131,17827,18129,17829,18135,17831,18135,
 8997,18135, 8997,18128, 8495,18143,17827,18128,17833,18147,17839,18147,
 8495,18147, 8997,17993, 8647,18154,17895,18154,    7,18154, 8495,18161,
17827,17993,  241,18164,    6,18167,    6,18166,  265,18165,17895,18173,
  261,18164,  375,18165,  260,18164,  251,18164,    6,18165,18177,18185,
    7,18165,18171,18189,18181,18189,    6,18164,18173,18195,  241,18194,
18189,18199,18189,18195,    7,18164,17833,18205,17839,18205,18169,18205,
18185,18205, 8495,18205,    1,  843,    0,  842,18217,18219,  483,18220,
    4,18223,    4,18222,  581,18220,  580,18220,    4,18221,18229,18233,
    5,18221,18227,18237,18231,18237,    4,18220,  483,18242,18237,18245,
18237,18243,    5,18220,18225,18251,18233,18251,    0,  413,15309,18257,
  265,18258,15363,18261,15424,18257,15363,18265,13375,18257,13381,18257,
 4888,18257,13162,18257,  251,18256,  375,18256,  265,18257,15309,18281,
15383,18283,15309,18280,15363,18287,  331,18257, 2663,18257,  251,18293,
    9,18256,  483,18256,  375,18257, 4863,18300,13119,18300, 4863,18257,
  375,18306,13119,18257,  375,18310,    6,18257,  264,18314,    7,18257,
  264,18318,  264,18319,  265,18319,18321,18325,  265,18318,18323,18329,
 8647,18319,  375,18319,  331,18319,    7,18256, 1689,18339, 1705,18339,
 2701,18339,18317,18339, 8717,18339,12755,18339, 7627,18339, 7895,18339,
 3785,18339,13443,18339, 7287,18339,  265,18339,  331,18339, 8495,18339,
  375,18339,12745,18339,  457,18371,  375,18371,    6,18256,18291,18377,
12745,18257,17895,18381, 8647,18381,    7,18381, 8495,18387,    1,  412,
 1679,18391,  448,18391, 4349,18395, 4351,18391, 4390,18391,18300,18391,
 4457,18391,18277,18391, 1673,18391,18279,18391, 1789,18391,18364,18391,
18335,18391, 3427,18391, 7037,18391,  265,18391,  445,18422, 4349,18425,
  445,18423, 4371,18429,16095,18391,12287,18391, 5189,18391,18299,18391,
18297,18391, 2153,18391, 2151,18391, 4371,18391,  331,18446,18339,18391,
  331,18450,  331,18391, 4371,18454,18339,18454,  445,18391,  265,18460,
 4349,18463,    5,18461,    4,18460,18467,18469,    4,18461,    5,18460,
18473,18475,  465,18391,    3,18479,    2,18478,18481,18483,    2,18479,
    3,18478,18487,18489, 8386,18391,18318,18391,  375,18391,18257,18496,
    7,18391,  265,18501,18257,18503, 8337,18500,18257,18500, 8337,18391,
    7,18510, 8861,18391,    6,18515,    7,18515,    6,18514,18519,18521,
    7,18514,18517,18525,18257,18391,  265,18528,  241,18529,    6,18532,
    6,18533,  375,18528,  261,18529,  260,18529,  251,18529,    6,18529,
  241,18546,18531,18547,    7,18529, 8495,18553,18537,18553,    6,18528,
18553,18559,18541,18559,    7,18528,18549,18565,18535,18565,18547,18565,
18543,18565,    0,  843,    1,  842,    5,18576,18575,18577,  483,18581,
    4,18582,    4,18583,  581,18581,  580,18581,    4,18581,  483,18592,
    5,18581,18587,18597,    4,18580,18597,18601,18589,18601,    5,18580,
18595,18607,18585,18607,18593,18607,18591,18607,    1, 1217,16117,18617,
12291,18617,16103,18617, 4959,18617,17399,18617, 2205,18617, 2207,18617,
 1269,18617,    5,18633,    4,18632,18635,18637,    4,18633,    5,18632,
18641,18643, 1259,18617,    2,18647,    3,18646,18649,18651,    3,18647,
    2,18646,18655,18657,    7,18617,    0, 1216,    9,18662,18617,18665,
  483,18662,18617,18669,18660,18663,    7,18663,18617,18674,18617,18663,
    6,18679,    7,18679,    6,18678,18683,18685,    7,18678,18681,18689,
    1, 1531, 4904,18693,17609,18693,17586,18693, 4903,18693,    9,18700,
17579,18693,    9,18704,    9,18693, 4903,18708,17579,18708,    5,18692,
    0, 1530,18693,18717,    4,18719,    5,18719,    4,18718,18723,18725,
    5,18718,18721,18729,    1,   19, 1369,18733,    3,18733,    3,18732,
 9875,18739,    0,   18,18733,18743,    2,18745,    3,18745,    2,18744,
18749,18751,    3,18744,18747,18755,    0, 1217,12293,18759,16105,18759,
 1269,18759,    2,18765,    3,18764,18767,18769,    3,18765,    2,18764,
18773,18775, 1259,18759,    5,18779,    4,18778,18781,18783,    4,18779,
    5,18778,18787,18789,  375,18759,    7,18759,    1, 1216,    4,18796,
18759,18799,    3,18796,    6,18803,    6,18802,    5,18796,    6,18809,
    6,18808,    2,18796,18759,18815, 5241,18797,   14,18796, 1274,18796,
 2157,18797, 2155,18797,18795,18797,18799,18829,18815,18829,   15,18796,
 1275,18796,    6,18796,    3,18838,    5,18838,    7,18796,18805,18845,
18811,18845,18794,18797,18803,18851,18809,18851,    6,18797,18800,18857,
18816,18857,18799,18857,18759,18862,18815,18857,18759,18866,18835,18857,
18837,18857,18759,18857,18799,18874,18815,18874,    7,18797,18841,18881,
18843,18881,18803,18881,18759,18887,18809,18881,18759,18891,18807,18881,
18813,18881,18821,18881,18823,18881,18759,18880,18803,18903,18809,18903,
18759,18797,    6,18909,    7,18909,    6,18908,18913,18915,    7,18908,
18803,18919,18809,18919,18911,18919,    0, 1531,    1, 1530, 6717,18929,
    9,18931,18927,18929,    4,18935,    5,18935,    4,18934,18939,18941,
    5,18934,18937,18945,    0,   19,    1,   18,18949,18951,    2,18953,
    3,18953,    2,18952,18957,18959,    3,18952,18955,18963,    0,    2,
11303,18967,11349,18968, 5071,18967, 5097,18972,11350,18967, 5098,18967,
11304,18967,11307,18981, 5072,18967, 5075,18985,11315,18967, 5079,18967,
13961,18967,  581,18993,    4,18992,18995,18997,    5,18992,  580,18993,
19001,19003,    5,18993,    4,18993,  483,19008,19001,19011,  483,18993,
    4,19014,19001,19017,    4,19015,19007,19021, 1181,18966, 1206,18966,
 3451,18967,  375,19029, 1967,18967,  375,19033,  567,18966, 4992,19037,
    9,19037, 4971,19040, 4971,19037,    9,19044, 1141,18966,  555,18966,
  981,18967,16129,18966,16143,19055, 9523,18967,  483,19059, 9525,19061,
 1007,18967, 1297,18966,  524,18966,    0,19069,    4,19070,    4,19069,
    0,19074,   97,18967,11067,18967, 1275,19080, 7947,19083, 1205,18967,
  571,18967,11070,18967, 7947,19091,10043,18967, 1275,19094,10041,19097,
10044,18967,10041,19101, 1206,18967, 3001,19105, 1901,19105,   30,18967,
 8165,19111, 8150,18967,   33,19115, 1181,18967, 3663,19119, 1997,19119,
 3069,19119, 1923,19119, 9769,18967, 3972,18967, 8124,18967, 9357,18967,
 9346,18967, 8782,18967, 4244,18967, 4178,18967, 9768,18967, 8804,18967,
 8245,18967, 8249,18967, 8247,18967, 6950,18967,12299,18967, 4652,18967,
10684,18967,14096,18967, 4992,18967,  203,18967,11731,19167,17771,18967,
  113,19171,14223,18967,   85,18967,11731,19177,11031,18967,  113,19181,
  107,18967,11731,19185,11699,18967,  113,19189, 8701,18967, 9293,18967,
 3933,18967,    9,19196, 8109,18967,    9,19200, 4213,18967,    9,19204,
 4147,18967,    9,19208, 8757,18967,    9,19212, 9335,18967,    9,19216,
10202,18967, 7947,19221,17637,19221,  578,18967, 4935,19227,11349,18967,
11303,19230, 5097,18967, 5071,19234, 8647,18967,   11,19239,10603,18967,
  375,19243,10427,19243,10609,19243,    7,19243,10607,19251,    9,19242,
 4625,18967,  375,19257,   75,19257, 4629,19257,    7,19257, 4627,19265,
    9,19256,11277,18967,   10,19270,11307,19273,   10,19271,11349,19277,
  483,19271, 5045,18967,   10,19282, 5075,19285,   10,19283, 5097,19289,
  483,19283, 6789,18967,    9,19294,  288,18967,  525,18967,19073,19301,
19077,19301, 1811,19301, 1877,19301,    5,19301,17563,19301, 4861,19301,
 1290,18967,    5,19317, 3721,19317, 1985,19317,17563,19317, 4861,19317,
  296,18967, 8861,19329,   12,18967, 8165,19333,   18,18967,   25,18967,
    9,19338, 8165,19341, 8165,19339,    9,19345, 7971,18967,    9,19348,
   33,19351,   33,19349,    9,19355,   47,18967,11731,19359,10107,18967,
 1275,19362, 7947,19365,17637,19365,  113,19363,   59,18967,17635,19373,
10291,18967,  165,19377,  375,18967,  510,18967,   11,18967, 8165,19385,
    9,19387,  265,19384,    9,19384, 8165,19393,    9,18967,  567,19397,
 4971,19399,    6,19397,   25,19396, 8165,19405, 7971,19396,   33,19409,
 3933,19396, 8109,19396, 4213,19396, 4147,19396, 9335,19396, 8757,19396,
 8495,19396, 6789,19396, 4625,19396,10603,19396, 4971,19396,14073,19396,
  567,19396, 4935,19437,   11,19397, 8109,19441, 3933,19441, 8495,19441,
 7971,19441,  265,19396, 8861,19451,   11,19396, 8165,19455,  483,19396,
   17,18967, 1275,19460, 4861,19463,17563,19463, 3721,19463, 1985,19463,
   15,19460,   15,18967, 9731,19474, 1011,19475,  483,19475,   17,19474,
 6515,18967,  483,19485, 6527,19487, 6557,19487, 6561,19487,14210,18967,
   17,19495, 4971,18967,    9,19498,14073,18967,    9,19502, 5921,18967,
  375,19507,10046,18967,   16,18966,    0,19513,    4,19514,19317,19517,
19463,19517,    4,19513,    0,19522,19317,19525,19463,19525, 8495,19513,
10351,19513, 4311,19513, 4329,19513, 8717,19513,10055,19513, 3785,19513,
   14,18966,    6,19545,    2,19546,    2,19545,    6,19550,  482,19545,
   17,19545,   10,18966,17777,19559, 2215,19559,11307,19559, 5075,19559,
11713,19559, 2221,19559,11087,19559,10439,19559,10665,19559, 4643,19559,
11037,19559, 2233,19559, 9195,19559,11277,19559, 5045,19559,19455,19559,
19333,19559,19393,19559,19385,19559,    9,19597, 9317,19559, 9755,19559,
 4321,19559,10171,19559, 4295,19559, 3833,19559,10603,19559,    9,19613,
 4625,19559,    9,19617,    8,18967,   11,19621,   14,18967, 9731,19625,
   17,19625,   11,18966, 8124,19631, 3972,19631, 8804,19631, 8150,19631,
 7971,19631,    9,19640, 3933,19631,    9,19644, 8109,19631,    9,19648,
 8495,19631,    9,19652,    9,19631, 8109,19656, 3933,19656, 8495,19656,
 7971,19656,    9,18966,10001,19667,    5,19669,    4,19668,19671,19673,
    4,19669,    5,19668,19677,19679,   16,18967,    7,19683,   10,18967,
11277,19686,11307,19689, 5045,19686, 5075,19693,11349,19687, 5097,19687,
 9195,19687,19656,19687,19441,19687,19631,19687,    9,19706,11277,19687,
11303,19711, 5045,19687, 5071,19715,    9,19687,19631,19718,   19,18967,
   13,18967,19631,19725,10385,18967,  101,19729,  128,19729,    9,19729,
  113,19734,  483,19729,10081,19739,11759,19739,10405,19739,  113,19729,
    9,19746,   67,18967,11613,19751,12216,19751,    9,19751,11731,19756,
11731,19751,    9,19760,  566,18967,  253,19765, 1471,19765,   53,19765,
  256,18967,  629,18967, 1413,18967, 1471,19777, 1346,18967,  340,18967,
 8165,19783,  567,18967, 4935,19787,    9,19789,    9,19786, 4935,19793,
  305,18967,  959,18967,11731,19799,  759,18967,11731,19803,  331,18967,
17635,19807, 1325,18967,17635,19811,10001,18967,10003,19815,    4,19817,
    4,19816,10007,19815,  580,19815,10006,19815,  483,19815,    4,19828,
    4,19829,  581,19815,    4,19815,10003,19836,  483,19836,    5,19815,
19819,19843,19833,19843,    4,19814,19835,19849,19823,19849,19843,19849,
    5,19814,19839,19857,19821,19857,19825,19857,19827,19857,19841,19857,
19831,19857,19837,19857, 9731,18967,   15,19872, 8495,18967,  483,19877,
    9,19876, 9195,18967,  113,19883,11731,19883,  241,18967,    7,19888,
  483,18967,    9,19892,   17,19893,  903,19897,    5,19892,  253,19901,
 1471,19901,   53,19901,    5,19893, 1505,19909,  903,18967,    7,19913,
 1275,18967,10043,19916,10041,19919,11067,19916, 7947,19923,17637,19917,
10107,19927,    0,19916,    4,19931,    0,19932,19917,19935,    7,19932,
19937,19939,    7,19931,    4,19942,   16,19931,    6,19916,    4,19949,
    6,19950,19917,19953,    1,19950,19955,19957,    1,19949,    4,19960,
    8,19916,    4,19965,    1,19966,    1,19965,    4,19970,10107,19916,
 7947,19975,17637,19975, 7947,19917,11067,19981,10107,19981,    9,19917,
 2009,19987, 3135,19987,19969,19987,19973,19987, 5231,19987,19957,19987,
19963,19987,    0,19987, 5175,19987,14065,19987,   17,19916,19525,20009,
19517,20009, 3721,20009, 1985,20009,    1,20009,19987,20019,20003,20009,
 4861,20009,17563,20009,    5,19916,    4,19917,    5,19917,  265,18967,
17635,20035, 5771,20035,    9,20035,   11,20034,   11,20035,    9,20034,
 8861,20047,  483,20035,    7,20034, 8165,20053,    7,20035, 8495,20057,
  587,18967,    7,20061,    4,20063,    4,20062,   16,20061,   17,20061,
    4,20060,20071,20073,    5,20060,20067,20077,20069,20077,    4,20061,
    7,20082,20077,20085,    5,20061,20065,20089,13947,18967,    5,20092,
   17,20095,    5,20093,    9,20099,    4,18966, 8770,20103, 8729,20103,
 8697,20103, 8784,20103, 4266,20103, 9262,20103,    2,20103,    7,20117,
 8684,20103, 8717,20121,  331,20121, 8647,20103, 8757,20126, 8757,20103,
 8647,20130,  375,20130, 4213,20103,  375,20136, 9750,20103,19687,20103,
  347,20103,  386,20103,  340,20103,  331,20149,  375,20103, 8757,20152,
 4213,20152, 9195,20152,  305,20152,    9,20103,10291,20103,  483,20165,
   59,20103,   15,20103, 9195,20103,  375,20172,  331,20103,10001,20103,
    9,20179,  305,20103,  375,20182,    7,20103, 8495,20186, 8717,20189,
  331,20189, 8495,20187, 8757,20195, 9731,20186,  265,20187, 8757,20201,
 4213,20201, 9195,20201,  305,20201,  265,20186,  331,20211, 8647,20187,
 1325,20103,    7,20102, 8495,20219,10351,20219, 4311,20219, 4329,20219,
 3785,20219,10055,20219, 8717,20219,  483,20103, 1275,20103,  265,20103,
    7,20239, 8495,20241,  375,20241,    7,20238,  331,20247, 9731,20103,
    7,20250, 8495,20103,    7,20254, 8717,20257,  331,20257,  483,20255,
    9,20255,    7,20255, 8647,20267,  375,20267,    5,18966, 9535,20273,
 9537,20273,    2,20273,    6,20278, 9559,20273,  482,20273, 9563,20273,
 9362,20273,  922,20273, 1413,20273,   19,20273,   12,20273, 8150,20273,
 8804,20273,19385,20273, 1290,20273, 9533,20305,  525,20273, 9533,20309,
 7971,20273,    9,20312,   11,20273,    9,20316,   17,20273, 1275,20320,
 9533,20323,    9,20273, 9195,20326,   11,20326, 7971,20326, 8495,20326,
 9195,20273,    9,20336,    6,20273,    5,20341,    2,20340,    5,20340,
18967,20347,   11,20341,    7,20273,    5,20353,    6,20272,   17,20357,
    7,20272, 9195,20361,11277,20361, 5045,20361, 9755,20361, 4295,20361,
10171,20361, 4321,20361, 3833,20361, 9317,20361,  483,20273,  903,20380,
 1275,20273,   17,20384, 9533,20387,  903,20273,  483,20390, 8495,20273,
    9,20394, 9731,20273,    6,20398,    7,20398,    6,20399,20403,20405,
    7,20399,20401,20409,    6,18966,19836,20413,19857,20415,19854,20413,
19871,20413,19815,20413,    4,20423,19843,20425,    4,20422,19857,20429,
19477,20413,19145,20413,19875,20413,19843,20413,19849,20438,19849,20413,
19843,20442,19718,20413,19473,20413,19483,20413,19725,20413,   19,20413,
   12,20413,19337,20413,19687,20413,    9,20460,19475,20413, 9731,20465,
   17,20465,    9,20413,19687,20470,   11,20470,   11,20413,    9,20476,
 8495,20413,    5,20413,    9,20483,    4,20413,19815,20487,19849,20489,
19815,20486,19857,20493,    5,20412,   17,20497,    7,18966,10439,20501,
11087,20501,10665,20501, 4643,20501,11307,20501, 5075,20501,17777,20501,
 2215,20501,18739,20501, 4339,20501,11713,20501, 2221,20501,11037,20501,
 2233,20501,19626,20501,19129,20501,    0,20501,    4,20534,19301,20537,
19317,20537,19463,20537,20009,20537,10036,20501,19843,20547, 8800,20501,
 8714,20501, 5045,20501,11277,20501, 4551,20501,19628,20501,19455,20501,
19393,20501,19723,20501,19333,20501,  305,20501, 8495,20570,  959,20501,
19625,20501, 9731,20576,   17,20576,10603,20501,    9,20583, 4625,20501,
    9,20587,19385,20501,    9,20591,  759,20501,   47,20501,10107,20501,
  241,20599,  265,20598,10196,20501,   11,20501, 8495,20606,   17,20501,
19625,20610,   59,20501,10291,20501, 1011,20617,   15,20501, 1325,20501,
 8495,20501,   10,20624,   10,20625,  305,20624,   11,20624,20629,20633,
   11,20625,20627,20637, 9731,20501,19625,20640,    4,20501,    7,20645,
  483,20647,18967,20649,    0,20644,19301,20653,19317,20653,19463,20653,
20009,20653,20651,20653,    7,20644,19916,20665,20653,20667, 1275,20665,
18967,20670,20653,20673,18967,20665, 1275,20676,20653,20679,10001,20644,
19843,20683, 1011,20645,10047,20645,    5,20501, 9287,20691,  331,20501,
    4,20500, 8495,20697, 4311,20697,10351,20697, 3785,20697, 4329,20697,
 8717,20697,10055,20697,    5,20500, 9195,20713,11277,20713, 5045,20713,
 4321,20713, 9755,20713, 4295,20713,10171,20713, 9317,20713, 3833,20713,
  903,20501,  265,20501,10107,20734, 9195,20501,  241,20739,10001,20501,
    4,20742,19843,20745,    5,20742,18967,20748,    4,20743,20751,20753,
19511,20753,19857,20753,    5,20743,    7,18967, 8810,20762, 8811,20762,
    2,20763,    1,20768,20483,20763, 8495,20773, 8800,20763,20273,20763,
 8495,20763,   11,20780, 8810,20763,20767,20785,10081,20763, 1011,20789,
 1010,20788,20791,20793, 1010,20789, 1011,20788,20797,20799,  566,20763,
   11,20763, 9731,20805, 8495,20805, 8495,20804,  265,20763,20482,20763,
   17,20815,  567,20763, 9195,20819,    9,20763, 8811,20763,20765,20825,
  241,20762,  265,20762, 8165,20831, 1011,20763,  375,20763,    4,20762,
20815,20839,    5,20762,11276,20842, 5044,20842,11277,20842,11276,20843,
20849,20851, 5045,20842, 5044,20843,20855,20857,20773,20843,20470,20843,
20103,20843,20413,20843,    9,20866, 9195,20843,11277,20843,20845,20873,
 5045,20843,20847,20877,    9,20843,20413,20880,    4,20763,20480,20885,
    7,20884,20843,20889, 9366,20885,    1,20885,    3,20894,20842,20896,
20843,20897,20899,20901,20889,20900,20842,20897,20843,20896,20907,20909,
20890,20897,20889,20897,20843,20914,    3,20885,    1,20918,20842,20920,
20843,20921,20923,20925,20889,20924,20842,20921,20843,20920,20931,20933,
20890,20921,20889,20921,20843,20938, 9195,20885,  483,20942,20866,20885,
 8495,20885,20413,20948,  483,20885, 9195,20952,20413,20885, 8495,20956,
20843,20956,20843,20885,    1,20962,    3,20964,    3,20962,    1,20968,
    7,20963,20897,20973,20921,20973,20967,20973,20971,20973,20413,20962,
    5,20763,    7,20985,   17,20985,20413,20989,20413,20984,20839,20993,
   17,20993,  483,20984,20839,20985,    1,21001,    3,21002,    3,21001,
    1,21006,    7,21000,21005,21011,21009,21011,20413,21001,20413,20763,
    5,21019,20885,21021,    9,21021,    5,21018,20839,21027,   17,21027,
  483,20763,    5,21032,    5,18967,    0,21037,    3,21038, 9357,21037,
20742,21037,20761,21045,20187,21037, 8495,21049,20501,21037,10001,21036,
20753,21055,20763,21037, 8495,21059,13947,21036,   17,21063,  256,21037,
20186,21037,20885,21037,    7,21071,20897,21073,20921,21073,    9,21037,
 1275,21079, 9533,21081,21041,21081,   17,21037, 9195,21087, 7971,21087,
 8495,21087,  483,21036,  253,21095, 1471,21095,   53,21095, 1275,21036,
    6,21036,20640,21105,20610,21105,21069,21105, 9731,21105,20501,21112,
20501,21105, 9731,21116,   17,21116,   17,21105,20501,21122,    7,21036,
11276,21126, 5044,21126,11277,21126,11276,21127,21133,21135, 5045,21126,
 5044,21127,21139,21141,    1,21127,    3,21144,18967,21147,    3,21127,
    1,21150,18967,21153,18967,21127,20470,21127,21049,21127,20413,21127,
    9,21162,20103,21127, 9195,21127,11277,21127,21129,21171, 5045,21127,
21131,21175,    9,21127,20413,21178,    6,21037,21149,21183,21155,21183,
20254,21183,19243,21183,19257,21183,18967,21183,    1,21183,    3,21196,
21126,21198,21127,21199,21201,21203,21126,21199,21127,21198,21207,21209,
    3,21183,    1,21212,21126,21214,21127,21215,21217,21219,21126,21215,
21127,21214,21223,21225, 8495,21183,20103,21228,19687,21183,20843,21183,
21166,21183,   11,21183,20501,21239,20103,21183, 8495,21242,21127,21242,
21127,21183,20103,21248,20763,21183, 9731,21253,   17,21253,    7,21037,
19625,21259,   15,21259,20413,21263,20103,21258,21105,21267,  241,21258,
21105,21259,20103,21273,20103,21037,    7,21277,21199,21279,21215,21279,
11277,21279, 5045,21279,21183,21279,    6,21276,    1,21291,    3,21292,
21279,21295,    3,21291,    1,21298,21279,21301,    7,21276,21105,21305,
  241,21037,  483,21309,    7,21308,    4,18967,21183,21315,    0,21314,
20309,21319,  524,21319,20273,21323,20305,21319, 1291,21319,20273,21329,
21081,21319,20323,21319,20387,21319,   11,21319,  483,21338,20273,21341,
  483,21319,   11,21344,20273,21347,  165,21315,17635,21315, 1011,21352,
17642,21315,20413,21315,    6,21359,    9,21315,20352,21315,11277,21365,
 5045,21365,20985,21315,   11,21315,10075,21315,  483,21315, 1347,21315,
    6,21314,    1,21381,    3,21382,21365,21385,    3,21381,    1,21388,
21365,21391,20273,21381,   11,21381,    7,21314,    6,21315,   17,21401,
    7,21315,21384,21404,21390,21404,21385,21405,20273,21411,21407,21411,
21391,21405,20273,21417,21409,21417,21385,21404,21384,21405,21423,21425,
21391,21404,21390,21405,21429,21431,11276,21404, 5044,21404,11276,21405,
11277,21404,21439,21441, 5044,21405, 5045,21404,21445,21447,    0,21405,
    4,21450,    4,21405,    0,21454, 8495,21405, 5045,21405,20273,21461,
21437,21461,11277,21405,20273,21467,21435,21467,    9,21405,20273,21404,
21385,21475,21391,21475,11277,21475, 5045,21475,  265,21405,  483,21405,
18967,21487,21453,21489,21457,21489,21381,21405,20273,21315,    6,21497,
    1,21499,    3,21500,    3,21499,    1,21504,    7,21496,21503,21509,
21507,21509,21385,21509,21391,21509,11277,21509, 5045,21509, 1011,21315,
17635,21522,    6,18967,    2,21526,   11,21529,20103,21527,20690,21527,
    9,21535,21259,21527,    9,21539,   17,21527,    4,21526,   11,21545,
    5,21526,20640,21549,21259,21549,20610,21549, 9731,21549,20501,21556,
20501,21549, 9731,21560,   17,21560,   17,21549,20501,21566,    4,21527,
   15,21571,    5,21527,  482,21575,    2,21575,    6,21578,    6,21575,
    2,21582,    9,21575,20501,21587,20501,21574,    9,21591,20501,21527,
    5,21595,   17,21597,    5,21594,    9,21601,    1,    3,19718,21604,
19719,21604,19402,21605,20962,21604,20973,21613,21248,21604,21272,21604,
21494,21604,20963,21604,21249,21604,21001,21604,21011,21627,21273,21604,
21495,21604,21178,21604,20880,21604,21179,21604,20881,21604,21049,21604,
20773,21604,21361,21604,15753,21605,  803,21649,14387,21605,  375,21653,
 9663,21604, 9177,21604,20351,21604,20485,21604,21360,21604,  990,21604,
 4745,21667,19685,21605,21087,21671,21156,21605,21087,21675,21317,21605,
21291,21604,21279,21681,21499,21604,21509,21685,  996,21604, 4745,21689,
21472,21604,21473,21604,  761,21605, 3419,21697, 6469,21697, 3119,21697,
21048,21604,20772,21604,  973,21604,  955,21708, 4745,21711,    9,21708,
 4745,21715, 4745,21709,  955,21719,    9,21719, 2077,21605,    7,21725,
   14,21724,21727,21729,    6,21725,   15,21724,21733,21735,20350,21604,
20484,21604, 9662,21604, 9176,21604,21380,21604,21104,21604,21126,21604,
21183,21751,    9,21751,20842,21604,20885,21757,    9,21757,  305,21604,
18967,21763,  375,21765,  955,21604,  973,21769, 4805,21771,  973,21768,
 4745,21775,17423,21769, 4745,21769,  713,21604,21404,21604,21381,21785,
    9,21785,20884,21604,21316,21605,21182,21604,20501,21795,21793,21795,
21405,21604,21381,21800,    9,21800,20885,21604,20843,21806,20890,21807,
20889,21807,20843,21812,20973,21807,21073,21807,20413,21807,20843,21807,
21757,21823,20889,21822,21183,21604,21127,21828,21279,21829,21679,21829,
20103,21829,21127,21829,21751,21839,21105,21604,21381,21604,21365,21845,
21405,21844,20413,21845,21475,21845,21405,21845,21785,21855,20273,21855,
21509,21845,20843,21604,20885,21862,    9,21862,21127,21604,21183,21868,
18967,21869,21183,21873,    9,21868, 1199,21605,13923,21604,13935,21881,
 9437,21605,  587,21885, 9439,21887, 1177,21605, 1421,21604,  668,21604,
    1,21895,    5,21896,    5,21895,    1,21900,  117,21605,11759,21605,
 1369,21906, 7971,21909,11760,21605, 7971,21913,  809,21605,  989,21605,
 9929,21605, 1369,21920, 9927,21923, 9930,21605, 9927,21927,19596,21605,
    9,21931,19556,21605,20170,21605,19707,21605,    9,21939,20956,21605,
21791,21943,21242,21605,21795,21947,20773,21605,21707,21951,21049,21605,
21705,21955,21373,21605,20464,21605,19557,21605,20499,21605,20359,21605,
 9181,21605, 9671,21605, 4145,21605, 3801,21605, 4135,21605,10101,21605,
20577,21605,19656,21605,19441,21605,19332,21605,19392,21605,19454,21605,
21059,21605,19440,21605,19657,21605, 4134,21605,10100,21605,20498,21605,
20358,21605,20142,21605,    9,22007,20576,21605,20864,21605,    9,22013,
21116,21605,21166,21605,21183,22019,    9,22019,21560,21605, 9180,21605,
 9670,21605, 3800,21605, 4144,21605,21026,21605,20839,22035,20814,21605,
20839,22039,20992,21605,20839,22043,21359,21605,21845,22047,21647,22047,
21053,21605,21795,22053,20779,21605, 8087,21605, 8091,21605, 8089,21605,
20303,21605,    9,22065,20465,21605,10786,21605,11131,21605, 4696,21605,
11970,21605,19722,21605,19333,21605,19393,21605,19455,21605,20351,21605,
21739,22087,20485,21605,21741,22091, 9663,21605,21743,22095, 9177,21605,
21745,22099,20350,21605,21661,22103,20484,21605,21663,22107, 9662,21605,
21657,22111, 9176,21605,21659,22115,10099,21605,   17,22119,   17,22118,
 4133,21605,   17,22125,   17,22124, 8251,21605,    9,22131, 3807,21605,
    9,22135,   13,21604,18967,22139,   19,21604,20501,22143, 9875,22143,
   12,21604, 8251,22149, 3807,22149,19559,22149,20501,22149, 9875,22149,
 8165,22149,   18,21604, 3799,21605,   17,22165,   17,22164, 4143,21605,
   17,22171,   17,22170, 4283,21605,    9,22177, 4279,21605,    9,22181,
 9669,21605,   17,22185,   17,22184, 9179,21605,   17,22191,   17,22190,
 9673,21605,    9,22197, 9967,21605,    9,22201,19624,21605,20501,22205,
   17,22205,19686,21605,22149,22211,19441,22211,19656,22211,21607,22211,
19631,22211,    9,22220,    9,22211,19631,22224,19559,21605,19385,22228,
    9,22231,    9,22229,19545,21605,   17,22236,   17,22237,10102,21605,
 7971,22243,17053,22243,  629,21605,21117,21605,21561,21605,20867,21605,
20885,22255,21167,21605,21183,22259,21548,21605,   17,22263,20501,22263,
21104,21605,21069,22269,21267,22269,21305,22269,21259,22269,20103,22277,
   17,22269,20501,22269,20838,21605,20985,22285,20842,21605,21865,22289,
21809,22289,21613,22289,21637,22289,21867,22289,20773,22289,20956,22289,
21863,22289,20885,22305,    9,22305,20885,22289,20413,22310,20413,22289,
20885,22314,21126,21605,21871,22319,21831,22319,21617,22319,21635,22319,
21877,22319,21049,22319,21242,22319,21869,22319,21183,22335,    9,22335,
21183,22319,20103,22340,20103,22319,21183,22344,21020,21605,20885,22349,
21278,21605,21183,22353,21052,21605,21829,22357,21127,22357,21358,21605,
21747,22363,21665,22363,21532,21605,20497,21605,   17,22371,   17,22370,
20361,21605,    9,22377,20713,21605,    9,22381,20357,21605,   17,22385,
   17,22384,21048,21605,21643,22391,20772,21605,21645,22395,21509,21605,
21381,22399,21499,22399,    9,22399,21475,21605,21381,22407,    9,22407,
21365,21605,21381,22413,    9,22413,11971,21605, 4697,21605, 8387,21605,
    9,22423,11949,21605,   11,22426,    5,22428,    6,22426,    5,22432,
    5,22426,    6,22436,    6,22437,    7,22426,22441,22443,    7,22427,
22435,22447,22439,22447,22431,22447,   14,22426,22447,22455,    6,22427,
   15,22426,22459,22461,    9,22426,    9,22427, 4669,21605,   11,22468,
    5,22470,    6,22468,    5,22474,    5,22468,    6,22478,    6,22479,
    7,22468,22483,22485,    7,22469,22477,22489,22481,22489,22473,22489,
   14,22468,22489,22497,    6,22469,   15,22468,22501,22503,    9,22468,
    9,22469,12345,21605,    5,22510,    4,22510,   12,22510,   13,22511,
22517,22519,   12,22511,   13,22510,22523,22525,    4,22511,22513,22529,
    5,22511,22515,22533, 5123,21605,    5,22536,    4,22536,   12,22536,
   13,22537,22543,22545,   12,22537,   13,22536,22549,22551,    4,22537,
22539,22555,    5,22537,22541,22559,10697,21605,    9,22562,19385,21605,
19559,22566,    9,22569,    9,22567,19559,22573,19397,21605,    6,22576,
   11,22577,   11,22576,19475,21605,20413,22584, 1406,21605, 1396,21605,
  525,21605,  903,22593,  934,21605,    9,22597, 1290,21605,  903,22601,
  669,21605,21899,22605,21903,22605, 1861,22605, 1887,22605,    4,22605,
17013,22605, 4917,22605,19687,21605,22139,22621,21609,22621,    9,22621,
20103,22620,    9,22629,19625,21605,20501,22632,19384,21605,21087,22637,
20326,22637,    9,22636,20273,22637,    9,22644,    9,22637,20273,22648,
19396,21605,    5,22652,   10,22652,19441,22657,   10,22653,19455,22661,
   11,22652,22661,22665,   11,22653,22657,22669,19474,21605,20413,22673,
 1418,21605,    4,22677, 3755,22677, 1995,22677,17013,22677, 4917,22677,
   12,21605,22139,22689,18967,22688,   18,21605,22143,22695,21252,21605,
21279,21605,21183,22701,21291,22701,    9,22701,20483,21605,20763,22708,
20187,21605,21036,22712,21069,22715,21036,22713,21049,22719,21037,22713,
21037,22712,    9,22713,20353,21605,    5,22729,21315,22729,   33,21605,
 8150,22735,17727,22735,    9,22735, 7971,22740, 7971,22735,    9,22744,
17025,22735, 8165,21605,   30,22751,  181,22751,    9,22751,   25,22756,
   25,22751,    9,22760,  145,22751,   53,21605,17049,22767,10219,21605,
  903,22771,  155,22771,10081,21605, 1369,22776, 7971,22779,17053,22779,
  257,21605,    9,22785, 1171,21605, 4722,22789, 4713,22789,  903,22792,
21315,22789,  903,22789, 4713,22798,  628,21605,    9,22803,   11,21605,
  766,22807,  767,22807,20984,22807,20762,22806,22813,22815,20985,22807,
20762,22807,22140,22807,19718,22807,19725,22807,  586,22806,22809,22829,
    5,22807,20763,22832,22815,22835,20763,22833,22821,22839,  587,22832,
22829,22843,  587,22833,  586,22807,22847,22849, 5515,22807,17043,22807,
 4825,22807,17727,22807, 8150,22807,22139,22807,18967,22862,19396,22806,
19397,22806,19396,22807,22869,22871,19397,22807,22867,22875,22653,22875,
20763,22807,    5,22880,22815,22883,19687,22807,    9,22886, 7971,22807,
    9,22890,19461,22807,    9,22807,19687,22896, 7971,22896,18967,22896,
18967,22807,22139,22904,    9,22904,20103,22905,    9,22911, 1369,22806,
  903,22806,    9,22917,  587,22807,    5,22920,22829,22923,18967,22806,
20326,22927,21087,22927,    9,22926,20273,22927,    9,22934,    9,22927,
20273,22938,    9,22806,18967,22942,20763,22806,22819,22947,  587,22806,
22811,22951,    9,22951,   17,21605,19722,22956,19723,22957,22959,22961,
19723,22956,19722,22957,22965,22967,19396,22956,19396,22957,19397,22956,
22973,22975,19545,22956,20497,22956,20357,22956, 4133,22956,10099,22956,
 3799,22956, 4143,22956, 9179,22956, 9669,22956,19475,22957,21315,22957,
19397,22957,22971,23001, 1369,22956, 1275,22956,  903,23007,  587,22957,
  903,22957,   15,21605,20103,23014,18967,23015,20501,23019, 1369,23014,
 4917,23023,17013,23023, 3755,23023, 1995,23023,18967,23014,20413,23033,
    9,21605,19631,23036,19384,23036,19384,23037,22567,23043,19385,23036,
10697,23036, 4669,23036,11949,23036,   11,23037,23047,23055,22567,23055,
18967,23055,18967,23036,   10,23062,   10,23063,   11,23062,23067,23069,
   11,23063,23065,23073,   11,23036,18967,23076, 7049,21605,  587,23081,
 7051,23083, 7055,23083, 7059,23083,17219,21605,  903,23091, 4663,21605,
  903,23095, 4745,21605,  955,23099,    9,23099, 4569,21605,17423,21605,
  955,23107,    9,23107,14625,21605, 5997,21605,    7,23114,    5,23114,
    6,23119,23117,23121,    6,23118,    6,23114,    5,23126,    7,23115,
23129,23131,23125,23131,   14,23114,23131,23137,    6,23115,   15,23114,
23141,23143,20482,21605,20762,23146,20773,23149,20762,23147,20815,23153,
20839,23147,21399,23147,19683,23147,20763,23147,20843,23163,23149,23163,
20763,23146,20839,23169,23153,23169,20186,21605,21036,23174,21049,23177,
21036,23175,21069,23181,  331,23175,   59,23175, 1325,23175,  265,23175,
20644,21605,20352,21605, 9660,21605, 8386,21605,   59,23199,  331,23199,
 1325,23199,  265,23199,21243,21605,21829,23209,20957,21605,21807,23213,
21272,21605,21631,23217,20962,21605,    9,23221,21248,21605,21625,23225,
21549,21605,20501,23228,21105,21605,20501,23232,20843,21605,21758,23237,
21623,23237,21760,23237,21641,23237,20885,23237,21757,23246,20889,23247,
21757,23237,20885,23252,    9,23252,20103,23236,    9,23259,    9,23237,
21757,23262,20885,23236,    9,23267,21127,21605,21752,23271,21625,23271,
21754,23271,21639,23271,18967,23270,21087,23281,21183,23271,21751,23284,
21751,23271,21183,23288,    9,23288,20103,23270,21183,23295,    9,23295,
    9,23271,21751,23300,21405,21605,21633,23305,21394,23305,21786,23305,
21381,23305,20273,23312,21785,23312,20326,23305,21087,23305,21695,23305,
21037,23305,21036,23304,23325,23327,21036,23305,21037,23304,23331,23333,
21788,23305,21785,23305,21381,23338,    9,23338,    9,23305,20273,23344,
21785,23344,20273,23305,21381,23350,    9,23350,21259,21605,21843,23357,
20885,21605,20763,23360,    5,23363,18967,23362,    6,23360,18967,23368,
18967,23360,    6,23372,    6,23373,    7,23360,23377,23379,    7,23361,
23365,23383,    4,23383,23363,23387,23371,23383,23375,23383,23367,23383,
21526,23360,23383,23397,    6,23361,21527,23360,23401,23403,    9,23361,
20843,23407,21791,23361,20413,23411,20413,23360,21791,23415,20843,23360,
    9,23419,21183,21605,21315,23422,21795,23425,21795,23423,20103,23429,
20103,23422,21795,23433,20763,23422,21249,21605,21617,23439,21001,21605,
    9,23443,21273,21605,21619,23447,21371,21605,    9,23451,21253,21605,
    8,21604,22363,23457,22053,23457,21983,23457,23039,23457,21985,23457,
22077,23457,22075,23457,22465,23457,22507,23457,23053,23457,23051,23457,
20501,23457,23037,23457,19631,23483,11949,23483, 4669,23483,18967,23457,
   10,21604,22870,23493,22869,23493,22867,23493,23041,23493,22583,23493,
21995,23493,22665,23493,21991,23493,19441,23493,22626,23493,21997,23493,
19656,23493,22908,23493,22902,23493,22419,23493,22421,23493,11970,23493,
 4696,23493,21987,23493,23069,23493,21989,23493,23079,23493,22643,23493,
22933,23493,22945,23493,22693,23493,22904,23493,    9,23546,22896,23493,
18967,23550,22621,23493,    9,23554,19396,23493,22807,23558, 8647,23493,
22637,23493,    9,23565,23077,23493,18967,23569,22689,23493,18967,23573,
22927,23493,    9,23577,22943,23493,18967,23581,22807,23493,19396,23584,
19396,23585,18967,23584,    9,23590,    9,23584,18967,23594,18967,23585,
    9,23598,    9,23585,18967,23602,19631,23493,    9,23606,18967,23493,
22896,23610,22807,23610,    9,23614,    9,23610,22807,23618,    9,23493,
11949,23622, 4669,23622,22621,23622,19631,23622,22904,23622,22807,23622,
18967,23634,18967,23622,22807,23638, 4669,23493,    9,23642,11949,23493,
    9,23646,   16,21604,22979,23651,21935,23651,22239,23651,22389,23651,
22375,23651,22001,23651,21999,23651,22005,23651,22003,23651,22123,23651,
22129,23651,22983,23651,22981,23651,22987,23651,22985,23651,22989,23651,
22995,23651,22993,23651,22991,23651,22169,23651,22029,23651,22027,23651,
22175,23651,22031,23651,22189,23651,22195,23651,22033,23651,    7,23651,
    3,23706,    3,23651,    7,23710,  586,23651,22957,23651,19545,23717,
20357,23717,20497,23717,10099,23717, 4133,23717, 3799,23717, 9669,23717,
 9179,23717, 4143,23717,19559,23651,20713,23651,20361,23651, 9967,23651,
 9673,23651, 4283,23651, 3807,23651, 8251,23651, 4279,23651,   14,21604,
23175,23755,23199,23755,    5,23755,    1,23760,22677,23763,23023,23763,
    1,23755,    5,23768,22677,23771,23023,23771,16381,23755,14625,23755,
 4569,23755,13325,23755, 8685,23755,19513,23755, 1369,23755,   17,23755,
20219,23755, 4063,23755,10273,23755,20697,23755, 4137,23755, 8401,23755,
 9955,23755, 3863,23755,19631,21605,   11,23808,    5,23810,    6,23808,
    5,23814,    5,23808,    6,23818,    6,23819,    7,23808,23823,23825,
    7,23809,23817,23829,23821,23829,23813,23829,   14,23808,23829,23837,
    6,23809,   15,23808,23841,23843,    9,23808,23457,23847,    9,23809,
19667,21605,    5,23852,    4,23852,   12,23852,   13,23853,23859,23861,
   12,23853,   13,23852,23865,23867,    4,23853,23855,23871,    5,23853,
23857,23875,    8,21605,23646,23879,23642,23879,23606,23879,23851,23879,
22467,23879,22509,23879,19384,23879,19631,23879,23493,23894,23493,23879,
11949,23898, 4669,23898,19631,23898,11949,23879,23493,23906, 4669,23879,
23493,23910,18967,23879,   11,23914,   11,23915,23493,23919,   11,23879,
18967,23922,   14,21605,18967,23926,20501,23929,   17,23929,18967,23927,
20413,23935,   16,21605,22241,23939,22387,23939,22373,23939,22121,23939,
22127,23939,22167,23939,22173,23939,22187,23939,22193,23939,19545,23939,
10099,23939, 4133,23939, 3799,23939, 4143,23939, 9669,23939, 9179,23939,
20357,23939,20497,23939,19625,23939,21549,23939,21105,23939,   11,21604,
23053,23983,23051,23983,23039,23983,21985,23983,22085,23983,    5,23982,
    6,23995,21983,23983,22077,23983,22075,23983,22081,23983,22083,23983,
22572,23983,23847,23983,22465,23983,22507,23983,22211,23983,    9,24017,
19396,23983,22567,23983,    9,24022, 8165,23983,    9,24027,23037,23983,
11949,24031, 4669,24031,19631,24031,19559,23983,    9,24039, 8251,23983,
    9,24043, 3807,23983,    9,24047, 9875,23983,    9,24051,20501,23983,
    9,24055,    9,23982, 8251,24059, 3807,24059,22211,24059,19559,24059,
20501,24059, 9875,24059, 8165,24059,    9,23983,22567,24074,18967,24074,
18967,23983,21183,24081,23997,24081,  375,24081,    7,24081,23995,24089,
    9,24080,    9,21604,22869,24095,23894,24095,21997,24095,21365,24095,
21475,24095,21509,24095,21405,24094,22047,24095,22357,24095,23919,24095,
21995,24095,22583,24095,23906,24095,23910,24095,21127,24094,22319,24125,
20843,24094,22289,24129,22419,24095,22421,24095,21279,24095,  973,24094,
 4745,24139,19559,24095,20361,24095,20713,24095, 9673,24095, 9967,24095,
 4283,24095, 4279,24095, 8251,24095, 3807,24095,   33,24095, 7971,24161,
 8165,24095,   25,24165, 9875,24095,20501,24095, 4745,24095,17423,24095,
21405,24095,20273,24177,21785,24177,19631,24095,23879,24182, 4669,24095,
23879,24186,11949,24095,23879,24190,  973,24095, 4805,24195,19687,24095,
23493,24199,23879,24095,19631,24202,11949,24202, 4669,24202,20413,24095,
   11,24094, 8251,24213, 3807,24213,22211,24213,19559,24213,20501,24213,
 9875,24213, 8165,24213,21127,24095,21751,24229,20843,24095,21757,24233,
   11,24095,19687,24237,23610,24237,23493,24237,18967,24242, 7971,24237,
18967,24237,23493,24248,18967,24095,   10,24252,24213,24255,   10,24253,
24237,24259,  483,24253,   10,21605,23893,24265,24020,24265,22581,24265,
22669,24265,19455,24265,23917,24265,19333,24265,23073,24265,19393,24265,
23060,24265,24092,24265,23925,24265,24078,24265,23651,24265, 9755,24265,
 9317,24265, 4321,24265, 3833,24265,10171,24265, 4295,24265,22149,24265,
18967,24307,24213,24265,18967,24311,24059,24265,18967,24315,21183,24265,
19396,24265,23983,24320,19559,24321,  922,24265, 1413,24265,19683,24265,
24074,24265,18967,24332,23055,24265,18967,24336,24080,24265,    9,24340,
20839,24265,21399,24265,19385,24265,23879,24349,    9,24349,23983,24265,
19396,24355,19396,24354,18967,24355,    9,24360,    9,24355,18967,24364,
18967,24354,    9,24368,    9,24354,18967,24372,18967,24264,19441,24377,
24213,24377,24059,24377,22149,24377,19656,24377,19631,24377,    9,24388,
23983,24377,    9,24393,    9,24377,19631,24396,  903,24265,  483,24400,
  483,24265,  903,24404,18967,24265,23055,24408,24074,24408,19559,24409,
    9,24415,    9,24408,23983,24418,19559,24419,23983,24408,    9,24424,
    9,24265,24080,24428,18967,24428,19559,24433,23983,24432,23983,24428,
18967,24438,18967,24429,19631,24443,   17,21604,21963,24447,23958,24447,
23972,24447,23974,24447,23960,24447,23962,24447,21979,24447,21977,24447,
21967,24447,21965,24447,23964,24447,23966,24447,23968,24447,23970,24447,
21971,24447,21969,24447,21975,24447,21973,24447,22807,24447,19545,24447,
23939,24486,20357,24447,23939,24490,20497,24447,23939,24494, 9669,24447,
23939,24498, 9179,24447,23939,24502, 3799,24447,23939,24506, 4143,24447,
23939,24510,10099,24447,23939,24514, 4133,24447,23939,24518,23939,24447,
19545,24522,20357,24522,20497,24522,10099,24522, 4133,24522, 3799,24522,
 9669,24522, 9179,24522, 4143,24522,   15,24446,   15,21604,23357,24545,
22713,24545,22423,24545, 8337,24545,20103,24545,   17,24544,  483,24545,
   19,21605,22163,24561,18967,24560,   13,21605,24080,24567,22149,24567,
23983,24567,18967,24572,18967,24567,23983,24576,  113,21605,10385,24581,
23879,24583,    9,24583,11731,21605,   67,24589,23879,24591,    9,24591,
  137,21605,12261,21605,  587,24599,10107,24601,11067,24601,12285,24601,
 1346,21605, 1505,24609,  256,21605, 8495,24613,10107,24613, 1486,21605,
  803,24619, 1504,21605,20029,24623,21103,24623,19781,24623,  973,21605,
 2845,24631, 4812,24631,  955,24631, 4805,24636, 2971,24631, 4814,24631,
    9,24631, 4805,24644, 4805,24631,  955,24648,    9,24648,  341,21605,
  803,24655,17049,24655,20884,21605,21820,24661,21807,24661,20413,24664,
20413,24661,21807,24668,21182,21605,21195,24673,21836,24673,21829,24673,
20103,24678,20103,24673,21829,24682,20984,21605,20839,24687,20413,24689,
20413,24686,20839,24693,21258,21605,23755,24697,21749,24697,21574,21605,
    9,24703,21404,21605,24109,24707,21803,24707,21849,24707,21621,24707,
21693,24707,21805,24707,21801,24707,21381,24721,    9,24721, 1141,21605,
17025,24727, 1447,21605,17025,24731,  253,21605,17049,24735, 1471,21605,
17049,24739,21018,21605,    5,24742,20839,24745,    5,24743,20885,24749,
21276,21605,    7,24753,20413,21605,    6,24756,    4,24759,18967,24760,
18967,24759,    4,24764,    4,24765,21314,24759,21570,24756,21571,24757,
24773,24775,    6,24757,21314,24778,21314,24779,20885,24757,24661,24785,
21571,24756,21570,24757,24789,24791,21315,24757,24783,24795,21381,24757,
20885,24756,21791,24801,19475,24756,20984,24756,20839,24807,21315,24756,
21747,24811,24781,24811,23457,24811,    5,24756,20762,24819,20762,24818,
24763,24819,24767,24819,20839,24819,21399,24819,24771,24819,19683,24819,
20763,24819,20843,24837,24823,24837,20763,24818,24821,24843,20839,24843,
    5,24757,24769,24849,20885,24849,24661,24849,20763,24756,    5,24856,
20839,24859,    5,24857,20885,24863,20103,21605,21183,24867,21127,24869,
24673,24869,   15,24866,21183,24866,21795,24877,   15,24867,19687,24866,
    9,24883,19625,24866,20843,24866,    9,24889,21549,24866,21127,24866,
21183,24895,    9,24895,21105,24866,20763,24866,    5,24903,21527,24866,
    9,24867,19687,24909,20843,24909,21127,24909,    6,24866,21036,24917,
    5,24917,18967,24920,18967,24917,    5,24924,21036,24916,    5,24916,
18967,24930,24881,24917,18967,24916,    5,24936,    7,24866,23755,24941,
 1325,24941,  331,24941,   59,24941,  265,24941,    7,24867,23929,24953,
22205,24953,24919,24953,24923,24953,24927,24953,24929,24953,24933,24953,
24939,24953,24905,24953,    4,24953,24903,24973,22269,24953,22263,24953,
  375,24953,21037,24953,24917,24983,    6,24867,    5,24986,24941,24989,
24901,24987,24893,24987,24887,24987,21037,24866,24987,24999,    7,24999,
20273,21605,21258,25004,21259,25005,25007,25009,21183,25005,21259,25004,
21258,25005,25015,25017,  375,25005,    6,25004,    7,25004,    7,25005,
25023,25027,21315,25027,    6,25005,25025,25033,20501,21605,    7,25036,
    4,25039,    4,25038,20885,25037,    7,25037,18967,25047,    5,25049,
    5,25048,    5,25047,18967,25054,    5,25046,21036,25047,21037,25037,
22269,25063,21105,25063,   16,25036,   10,25037,  803,25037,  903,25037,
    9,25037,   17,25036,19625,25036,21105,25036,21549,25036,21037,25036,
21829,25087,25059,25087,21127,25087,24095,25087,25071,25087,   11,25037,
    4,25036,    7,25100,25051,25101,    5,25036,25041,25107,18967,25106,
25099,25111,    5,25037,25103,25115,25043,25115,25087,25115,    7,25114,
25087,25123,25069,25115,    4,25037,25111,25129,25057,25129,25053,25129,
25061,25129,25079,25129, 9165,21605, 9168,25140, 9169,25141,25143,25145,
 9169,25140, 9168,25141,25149,25151, 8337,21605,   15,25155,    6,25155,
    5,25158,    7,25155,  375,25163,    6,25154,25157,25167,    7,25154,
25161,25171,23755,25171,   59,25171,  331,25171, 1325,25171,  265,25171,
 9617,21605, 9630,25184, 9631,25185,25187,25189, 9629,25185, 9631,25184,
 9630,25185,25195,25197,  375,25185,    6,25185,    7,25185,    6,25184,
25205,25207,    7,25184,25203,25211, 9875,21605,    7,25214,    4,25216,
    4,25217, 9893,25215,   16,25214,  803,25215,    9,25215,   17,25214,
  903,25215,    4,25215,25231,25235,    5,25215,25219,25239,25225,25239,
    4,25214,    7,25244,25239,25247,    5,25214,25221,25251,  843,21605,
    9,25255,  413,21605,    7,25259,  375,25259, 1530,21605,    9,25265,
 1216,21605,    7,25269,21497,21605,    7,25273,21277,21605,    7,25276,
21183,25279,    7,25277,21105,25283,21019,21605,    5,25286,20885,25289,
    5,25287,20839,25293,  265,21605,    7,25297, 7971,25299,  587,21605,
   11,25302,    9,25305,    9,25303,   11,25309,    5,25303,20501,25313,
 9875,25313,  903,21605,    9,25319,   11,25321,   11,25318,    9,25325,
    7,25319, 1141,25329,   33,25329, 1447,25329, 1011,25318,    7,25337,
 1275,21605,    9,25341, 1369,25343,   17,25340,  903,25347,    5,25340,
 1505,25351,    5,25341,  253,25355,   53,25355, 1471,25355, 1369,25340,
    9,25363, 1011,21605,    7,25367,  959,25369,   47,25369,  759,25369,
  903,25366,    7,25377, 1369,21605, 9929,25380, 9927,25383,11759,25380,
 7971,25387,17053,25381,10081,25391,    7,25380,    4,25394,    5,25395,
    7,25398,25381,25401,    0,25398,25403,25405,    4,25395,    0,25395,
    5,25410,    1,25380,    5,25415,    1,25416,25381,25419,    6,25416,
25421,25423,    6,25415,    5,25426,   14,25415,   10,25380,    5,25433,
    0,25434,    0,25433,    5,25438,   16,25380,10081,25380, 7971,25445,
17053,25445, 7971,25381,11759,25451,10081,25451,   17,25380,   11,25380,
   11,25381, 1965,25461, 3195,25461,25437,25461,25441,25461, 5197,25461,
25405,25461,25413,25461,    1,25461, 4579,25461,15899,25461,   15,25380,
23763,25483,23771,25483, 3755,25483, 1995,25483,    0,25483,25461,25493,
25477,25483, 4917,25483,17013,25483,    4,25380,    7,25502,20029,25503,
19781,25503,21103,25503,    5,25380,25409,25513,  803,25513,    4,25381,
20033,25519,25457,25519,    5,25381,25397,25525,25505,25525,25443,25525,
10219,25525,  959,25525,   47,25525,  759,25525, 1275,25380,    9,25541,
  241,21605,    9,25545,  483,25545,    7,25544, 8495,25551,10107,25551,
17571,21605,    7,25557,    4,25558,    4,25559,   16,25557,   17,25557,
    4,25556,25567,25569,    5,25556,25561,25573,25565,25573,    4,25557,
    7,25578,25573,25581,    5,25557,25563,25585,17371,21605,16711,25589,
    7,25589,14315,21605,    5,25594,    6,25596,    6,25597,   14,25594,
   15,25594,    6,25594,    5,25606,    7,25594,25601,25611,    6,25595,
25605,25615,    7,25595,25609,25619,25599,25619,25603,25619,15705,21605,
  767,25627,  483,25629,    4,25627,  483,25633,21527,21605,20103,25636,
    5,25637,   17,25641,    5,25636,    9,25645,21315,21605,21183,25648,
21795,25651,21183,25649,24673,25655,21747,25649,20413,25659,23457,25649,
20413,25663,20413,25648,23457,25667,21747,25667,21037,21605,21829,25673,
20501,25675,21127,25673,20501,25679,21105,25673,   11,25673,20501,25685,
   15,25673,20501,25672,24095,25691,21829,25691,21127,25691,20187,25672,
24095,25673,20501,25701,    6,25673,    7,25673,    6,25672,25707,25709,
20103,25709,    7,25672,21749,25715,23755,25715,25705,25715,20103,25672,
    7,25723,20763,21605,20482,25726,20839,25729,20483,25726,21183,25726,
    4,25727,23147,25737,24819,25737,    5,25727,23383,25743,20956,25743,
20773,25743,24953,25743,20885,25743,20413,25752,20413,25743,20885,25756,
    4,25726,21605,25761,    7,25763,25743,25765,24849,25761,20413,25761,
    5,25726,20839,25773,20413,25775,20413,25772,20839,25779,20413,25726,
    5,25782,20839,25785,    5,25783,20885,25789,    5,21604,25275,25793,
25003,25793,25725,25793,24755,25793,21049,25793,21242,25793,20773,25793,
20956,25793,25699,25793,22725,25793,22391,25793,24682,25793,23209,25793,
25712,25793,25733,25793,22711,25793,22395,25793,24668,25793,23213,25793,
25770,25793,25083,25793,23235,25793,22017,25793,25085,25793,23231,25793,
22025,25793,25087,25793,25691,25793,22357,25793,22047,25793,23455,25793,
15567,25793,12971,25793,13355,25793,13541,25793,22869,25793,22635,25793,
23021,25793,23894,25793,23919,25793,21997,25793,21995,25793,22583,25793,
23906,25793,23910,25793,22419,25793,22421,25793,23034,25793,19656,25793,
19441,25793,11970,25793, 4696,25793,22674,25793,22069,25793,25081,25793,
22011,25793, 9357,25793,25205,25793,25027,25793, 9356,25793,25171,25793,
24941,25793,23199,25793,23175,25793,20606,25793,25593,25793,19396,25793,
11131,25793,21059,25793,23018,25793,20501,25933,20057,25793,22633,25793,
20501,25939,21405,25793,  357,25793,  367,25793,  471,25793, 1249,25793,
  628,25793, 4569,25793,14625,25793, 4545,25793,13325,25793, 8337,25961,
 4549,25793,23229,25793,20501,25967,23233,25793,20501,25971,25706,25793,
20186,25793, 8386,25793, 9083,25793, 9484,25793, 9984,25793,20187,25793,
 8387,25793,19513,25793, 8401,25793,20219,25793, 4137,25793,10273,25793,
 4063,25793, 3863,25793,20697,25793, 9955,25793,20353,25793,25709,25793,
20103,26010,25715,25793,24673,25793,20103,26016,24697,25793,21183,25793,
20103,26022,21259,25793, 4745,25793,17423,25793, 9082,25793,22673,25793,
20413,26034,23033,25793,20413,26038,25551,25793,24613,25793,22249,25793,
20326,25793,21087,25793, 9704,25793,23879,25793,19631,26054,11949,26054,
 4669,26054,11949,25793,23879,26062,    9,26062, 4669,25793,23879,26068,
    9,26068,20805,25793,23015,25793,18967,26076,20501,26079,18967,26077,
20413,26083,19631,25793,23879,26086,    9,26086, 9377,25793,   11,26092,
  341,25793,  241,26097, 8165,25793,  256,25793,  257,25793,   11,25793,
 9195,26106,20501,26106,  587,26106, 9377,26106, 9875,26106,20763,26106,
20804,25793,10219,25793,  587,26123,   53,25793,20501,25793,   10,26128,
   10,26129,   11,26128,26133,26135,   11,26129,26131,26139,20413,25793,
20885,26142,24661,26142,25761,26142,22673,26142,23033,26142,20762,25793,
25761,25793,20413,26156,24661,25793,20413,26160,20885,25793,20413,26164,
   17,25793,20762,26168,20762,26169,20763,26169,26171,26175,20763,26168,
26173,26179,    9,25793,11949,26182, 4669,26182,19631,26182,18967,26182,
20273,26182, 9617,26182,20763,25793,   11,26196,25707,25793, 9875,25793,
   10,26202,   10,26203,   11,26202,26207,26209,   11,26203,26205,26213,
  253,25793,    6,25793,25273,26219,24753,26219,24999,26219,24953,26219,
25005,26219,25723,26219,25707,26219,25185,26219,25163,26219,25589,26219,
24081,26219, 4713,26219,16363,26219, 9195,26219, 4863,26219,13119,26219,
 8757,26219, 4213,26219,23493,26219, 8109,26219, 3933,26219, 4147,26219,
 9335,26219,20103,26219, 8337,26219,20273,26219, 8997,26219,25673,26219,
  241,26219,18967,26219,   11,26279,   11,26219,  587,26219, 8387,26219,
14653,26219,20187,26219,    7,25793, 8717,26293, 3785,26293,25673,26292,
23755,26293,10351,26293, 4311,26293, 4329,26293,10055,26293,20103,26292,
 8337,26292, 8997,26292,   15,26293,18967,26317,18967,26292,  241,26292,
 9195,25793,   11,26324, 1471,25793,    6,25792,23175,26331,25977,26331,
24941,26331,26311,26331,26299,26331,25975,26331,25715,26331,24697,26331,
26315,26331,23199,26331,25171,26331,25979,26331,26033,26331,26313,26331,
16381,26331,26323,26331,26103,26331,13325,26331, 8685,26331,26155,26331,
26321,26331,26293,26331,20103,26375,25673,26375, 8997,26375, 8337,26375,
  241,26375,18967,26375,   17,26331, 1369,26331, 4569,26331,19513,26331,
 4063,26331,10273,26331, 3863,26331,20697,26331, 9955,26331, 4137,26331,
20219,26331, 8401,26331,14625,26331,    7,25792,25987,26415,26266,26415,
26201,26415,26274,26415,26272,26415,25989,26415,25981,26415,26268,26415,
21604,26415,18967,26433,26219,26435, 8997,26415,26219,26438,26105,26415,
26276,26415, 8647,26415,19396,26415,26197,26415,26278,26415,26219,26415,
20103,26454,25673,26454, 8997,26454, 8337,26454,  241,26454,18967,26454,
 8337,26415,26219,26468,20103,26415,26219,26472,    9,26415,18967,26476,
  241,26415,    1,26481,26219,26483,26219,26480,25673,26415,26219,26488,
18967,26415,    9,26492,26219,26492,  587,25793,   11,26498, 1369,25793,
25673,25793,20501,26505,    6,26504,    7,26504,26331,26511,    6,26505,
26511,26515,    7,26505,26509,26519,26219,26519,18967,25793,    9,26524,
23015,26524,20501,26529,  483,26525,    6,26524,    7,26524,26331,26537,
    7,26525,26219,26541,    6,26525,  241,25793,    1,26547,    7,26549,
26331,26551,    7,26548,26219,26555,    7,26547,    1,26558,26219,26561,
26219,26559,    7,26546,26331,26567,20273,25793,    9,26570,14315,25793,
 8997,25793,    7,26576,26331,26579,    7,26577,26219,26583, 9617,25793,
    9,26586, 8337,25793,    7,26590,26331,26593,  483,26591,    9,26591,
    7,26591,26219,26601,20103,25793,21183,26604,24673,26604,25709,26604,
    7,26604,26331,26613,  483,26605,    9,26605,    7,26605,26219,26621,
    4,21604,21955,26625,24877,26625,23433,26625,21947,26625,21951,26625,
24801,26625,23415,26625,21943,26625,22282,26625,22251,26625,22266,26625,
22253,26625,24811,26625,25667,26625,22363,26625,22053,26625,21116,26625,
21560,26625,25735,26625,23437,26625,22699,26625,21253,26625,23930,26625,
22206,26625,24805,26625,23937,26625,22587,26625,23039,26625,23053,26625,
23051,26625,21961,26625,21981,26625,20465,26625,20576,26625,21985,26625,
21983,26625,22077,26625,22075,26625, 9573,26625, 9575,26625,23847,26625,
22465,26625,22507,26625,    3,26625,    7,26712, 9605,26625,  586,26625,
 9599,26625,19474,26625,20413,26723,20186,26625,20805,26625,22423,26625,
22713,26625,22205,26625,20501,26734,19625,26625,20501,26738,19687,26625,
23929,26625,20501,26744,23934,26625,20413,26749,22585,26625,20413,26753,
 8386,26625,23927,26625,18967,26759,20501,26761,18967,26758,20413,26765,
23037,26625,19631,26769,11949,26769, 4669,26769, 1418,26625, 9565,26777,
  669,26625, 9565,26781,22263,26625,20501,26784,22269,26625,20501,26788,
21549,26625,20501,26792,20843,26625,21105,26625,20501,26798,21127,26625,
23423,26625,20103,26805,23357,26625, 7971,26625, 1170,26625,25203,26813,
20501,26625,22269,26816,22263,26816,21105,26816,21549,26816,22205,26816,
23929,26816,19625,26816,20762,26625,26219,26833,23361,26625,20413,26837,
   11,26625,    1,26841,18967,26841,   15,26625,18967,26846,20413,26849,
18967,26847,20501,26853, 1369,26846, 9565,26857,    7,26625,    4,26861,
    3,26860,    4,26860,21605,26867,20103,26860, 8337,26860,18967,26860,
26219,26875, 1011,26860,25203,26879,    6,26625,21604,26882,20763,26883,
    6,26624,24811,26889,22053,26889,22363,26889,25667,26889,20501,26889,
25649,26889,20413,26901,18967,26889,    7,26624,24265,26907,19559,26907,
 9673,26907, 8251,26907, 3807,26907, 4283,26907,20361,26907, 4279,26907,
20713,26907, 9967,26907,  483,26625, 1369,26625,   15,26930, 9565,26933,
25649,26625,20413,26937,18967,26625,   15,26940,20413,26943,23927,26940,
20413,26947,    6,26940,21604,26950,    7,26940,26219,26955,    7,26941,
26953,26959,26885,26959,26331,26959,23755,26959,    6,26941, 1011,26625,
    7,26971,25207,26973,23197,26973,    7,26970,25203,26979,20103,26625,
    7,26982, 8337,26625,    7,26986, 9565,26625, 9617,26625,    6,26992,
    7,26992,    6,26993,26997,26999,    7,26993,26995,27003,20273,26625,
    6,27006,    7,27006,    6,27007,27011,27013,    7,27007,27009,27017,
    7,21604,25987,27021,26266,27021,22732,27021,22733,27021,25087,27021,
25691,27021,22357,27021,22047,27021,26027,27021,25989,27021,26268,27021,
20819,27021,20152,27021, 8374,27021, 8389,27021,20201,27021,20952,27021,
    1,27021,    4,27056,    4,27057,    3,27021,    4,27062,  902,27021,
19559,27021,20361,27021, 9673,27021,20713,27021, 9967,27021, 4283,27021,
 4279,27021, 8251,27021, 3807,27021,26100,27021,26106,27021,26128,27021,
26202,27021, 8647,27021,20326,27021,25239,27021,25115,27021, 8800,27021,
21087,27021,  357,27021,  367,27021,  471,27021, 1249,27021, 8086,27021,
19687,27021, 9704,27021,25742,27021,20885,27021,  483,27122, 1141,27021,
  375,27021,20103,27128, 8337,27128,25673,27021,20501,27135,26219,27021,
20103,27138, 8337,27138,   11,27139,   17,27139, 1447,27021,21127,27021,
20843,27021, 8165,27021,25793,27154,  265,27155,   33,27021,  567,27021,
22729,27021,21315,27164,   11,27021,25793,27169, 8495,27169,25793,27168,
 8495,27168,18967,27169,21037,27169,21497,27021,21277,27021,21276,27021,
21496,27021,20273,27021,    9,27190,21315,27190,20103,27021,26219,27196,
  375,27196,21037,27196,21314,27021,22729,27205,20273,27205,21036,27021,
25129,27211,20103,27211,21183,27021,    9,27021,20273,27218, 9617,27218,
21315,27021,22729,27224,20273,27224,21037,27021,20103,27230,25743,27021,
   25,27021, 7971,27236, 7971,27021,   25,27240, 9617,27021,    9,27244,
 8337,27021,26219,27248,  375,27248,    4,27021,25037,27255,25215,27255,
    3,27254,    1,27254,25727,27255,  483,27255,20691,27255, 9923,27255,
18967,27255,20103,27273,18967,27254,22729,27277,20273,27277,    5,27021,
27061,27283,    1,27283,25727,27282,18967,27283,22729,27291,20273,27291,
   17,27283,18967,27297,18967,27282,25129,27301,20103,27301,25793,27021,
 8165,27306,   11,27306,20501,27306, 9875,27306, 9731,27021, 8495,27021,
   11,27318,    4,27020,    1,27323,27283,27324,27286,27323,27289,27323,
27121,27323,24265,27323,27225,27323,27290,27323,27211,27323,27301,27323,
27283,27323,    1,27344,25727,27345,18967,27344,18967,27345,19559,27323,
18967,27323,27283,27356, 4283,27323, 9673,27323, 8251,27323, 3807,27323,
20361,27323, 9967,27323,20713,27323, 4279,27323,    5,27020,27059,27377,
27263,27377,27235,27377,27264,27377, 8647,27377,19396,27377,27231,27377,
27272,27377,27205,27377,27277,27377,27255,27377,    1,27399,25727,27398,
18967,27398,18967,27399,26219,27377,    9,27377,18967,27410,25727,27377,
27255,27414,18967,27377,    9,27418,27255,27418, 1011,27021,25727,27021,
    5,27426,27323,27429,    5,27427,27255,27433,18967,27021,    7,27437,
21605,27439,    4,27441,    4,27440,    4,27439,21605,27446,    4,27438,
   16,27437,  113,27437,11731,27437,   17,27437,    4,27436,22729,27461,
21605,27460,27459,27465,27377,27461,20273,27461,    5,27436,25129,27473,
27443,27473,27323,27473,20103,27473,    5,27437,25101,27483,23193,27483,
    7,27483,21605,27489,27461,27491,27449,27483,27445,27483,27461,27483,
27255,27483,21315,27483,    4,27437,    7,27504,27473,27505,27283,27505,
21037,27505,  483,27021,20885,27514,20501,27021,  241,27519,25793,27518,
 9875,27021,  241,27525,25793,27524,20413,27021,    6,21604,24811,27533,
25667,27533,22363,27533,22053,27533,    1,27533,    5,27542,22605,27545,
22677,27545,23023,27545,25483,27545,20644,27533,21359,27533,25793,27557,
12345,27533,    5,27561,    4,27560,27563,27565,    4,27561,    5,27560,
27569,27571, 5123,27533,    5,27575,    4,27574,27577,27579,    4,27575,
    5,27574,27583,27585,19667,27533,    5,27589,    4,27588,27591,27593,
    4,27589,    5,27588,27597,27599,  341,27533,21052,27533,25793,27605,
25649,27533,20413,27609,25673,27533,21183,27613,26861,27533,    9,27617,
26293,27533,    9,27621,17219,27533,  903,27625, 4663,27533,  903,27629,
23195,27533,21315,27633,10219,27533,  903,27637,   53,27533,25025,27533,
21315,27643,20103,27533,    9,27647,21314,27533,24795,27651,26142,27651,
20413,27651,25793,27656,25793,27651,20413,27660,21036,27533,25129,27665,
21259,27533,26625,27669,   17,27533,21315,27673,21037,27533,25793,27677,
20501,27679,20501,27676,25793,27683, 8337,27533,    9,27687, 1471,27533,
    5,27533,    6,27693,  587,27695,21605,27697,    1,27692,22605,27701,
22677,27701,23023,27701,25483,27701,27699,27701,    6,27692,25380,27713,
27701,27715, 1369,27713,21605,27718,27701,27721,21605,27713, 1369,27724,
27701,27727,    9,27693,18967,27692,25129,27733, 9935,27693,20645,27693,
    4,27533,20501,27740,26524,27741,20501,27745,25793,27741,18967,27748,
20501,27751,18967,27749,20413,27755,18967,27741,25793,27758,20501,27761,
20501,27759,25793,27765,18967,27740,26142,27769,20413,27769,25793,27772,
25793,27769,20413,27776,26940,27533,26969,27781,  253,27533,    4,27532,
24811,27787,22053,27787,22363,27787,25667,27787,20501,27787,25649,27787,
20413,27799,18967,27787,    5,27532,24941,27805,23175,27805,25715,27805,
24697,27805,25171,27805,23199,27805,26959,27805,16381,27805,13325,27805,
 8685,27805,26293,27805,   17,27805, 1369,27805, 4569,27805,19513,27805,
 4063,27805,10273,27805, 4137,27805,20219,27805, 8401,27805, 3863,27805,
14625,27805,20697,27805, 9955,27805,  241,27533,18967,27533,20486,27857,
20487,27857,20413,27857,    4,27862,    4,27863,  580,27857,  483,27857,
    4,27870,    4,27871,  581,27857,    4,27856,27861,27879,26142,27879,
27877,27879,20413,27879,25793,27886,25793,27879,20413,27890,    5,27856,
25129,27895,27859,27895,27865,27895,27869,27895,27873,27895,    5,27857,
25101,27907,27555,27907,23193,27907,27743,27907,27886,27907,27867,27907,
27875,27907,20413,27907,27879,27922,27879,27907,20413,27926,    4,27857,
20413,27930,27895,27933,  483,27930,27895,27937,27895,27931,20413,27941,
 1369,27533,    5,27945,20501,27533,21037,27949,    4,27948,27907,27953,
    5,27948,18967,27956,21037,27948,25793,27961,    4,27949,27959,27965,
27665,27965,27733,27965,27895,27965,    5,27949,27961,27975,    7,21605,
    1,27979,    2,27981,    5,27983,    5,27982, 1010,27981,    5,27981,
    2,27990,    3,27978,    9,27995, 4311,27979,10351,27979, 4329,27979,
 3785,27979,10055,27979, 8717,27979,26283,27979,26388,27979,23790,27979,
27828,27979,22143,27979,22149,27979,24213,27979,24059,27979,  331,27979,
 8337,28027,20103,28027,21036,27978,21049,28033,21242,28033,21183,28033,
20103,28038,20103,28033,21183,28042,26331,27979,20103,28047, 8337,28047,
   17,28046,21277,27978,21183,28055,27693,27979,18967,28059,25793,27979,
21127,28063,20843,28063,19687,28063, 8337,28063,20103,28063, 7971,28063,
  241,28063, 8495,27979,  241,28079, 8337,27978,26331,28083,27805,28083,
 1325,28083,  331,28083,   59,28083,23755,28083,25793,28083,  265,28083,
21037,27979,27665,28101,28033,28101,   11,28101,21315,27979, 1325,27979,
 8337,28111,20103,28111,   59,27979, 8337,28117,20103,28117,10291,27979,
  483,28123,20273,27978,27533,28127,21315,28129,20103,27978,26331,28133,
27805,28133,23755,28133,  331,28133, 1325,28133,   59,28133,25793,28133,
  265,28133,21105,27979,   11,27979,20103,28153, 8337,28153,   17,27979,
26331,28158, 8337,28159,20103,28159,27805,28158,23755,28158,27731,27979,
27692,27979,    9,28173,23755,27979,20103,28177, 8337,28177,   17,28176,
23983,27979,    9,28185,   15,27979,    3,28189,20273,28189, 9617,28189,
27805,27979,20103,28197, 8337,28197,   17,28196,  241,27978,25793,28205,
 8495,28205,10107,28205,  265,27979,20103,28213, 8337,28213,    4,27978,
27985,28219,21105,28219,21549,28219,19625,28219,28173,28219,18967,28229,
    5,27978,19397,28233,28060,28233,18966,28232,18966,28233,    9,28241,
27323,28233,23651,28233,26907,28233, 9755,28233, 9317,28233, 4321,28233,
 3833,28233,10171,28233, 4295,28233,28101,28233,21183,28233, 1413,28233,
  922,28233,27856,28233,28059,28233,18967,28272,19396,28233,28239,28277,
19683,28233,18967,28232,28235,28283,28242,28283,28241,28283,    9,28288,
    9,28283,28241,28292,27533,28233,18967,28296,    9,28233,18967,28300,
28239,28303,18967,28301,28241,28307,21399,28233,20839,28233,  483,28233,
  903,28314,  903,28233,  483,28318,18967,28233,28059,28322,28239,28323,
    9,28327,27533,28322,    9,28322,28239,28333,    4,27979,27987,28337,
27993,28337,28270,28337,28330,28337,28298,28337,27989,28337,  586,28337,
    3,28337,    7,28352,    7,28337,    3,28356,27856,28337,28233,28360,
21575,28337,28296,28337,18967,28366,27533,28337,28322,28370,18967,28370,
28233,28374,28233,28370,18967,28378,28322,28337,27533,28382,18967,28337,
28296,28386,27533,28386,28233,28390,28233,28386,27533,28394,28233,28337,
27856,28398,27533,28398,18967,28402,18967,28398,27533,28406,    5,27979,
27255,28411, 9287,28411,20885,28411,27533,28410,28219,28419,18967,28421,
    9,28419,  241,28411,  483,28427,28219,28411,27856,28431,27533,28431,
18967,28434,18967,28431,27533,28438,18967,28410,28219,28443,   17,28443,
21036,27979,21069,28449,21267,28449,21305,28449,28219,28449,21259,28449,
20103,28459,   17,28449,21037,27978,26331,28465,21749,28465,27805,28465,
23755,28465,28449,28465,25793,28465,10001,27979,    9,28479,27533,27979,
21496,28483,21277,28483,20885,28483,27931,28483,    9,28483, 9731,28483,
21037,28482,21037,28483,21315,28483,20273,28500,21036,28482,28499,28505,
21036,28483,28497,28509,20273,28483,21315,28512,    4,28483,    5,28483,
28386,28519,28337,28519,18967,28522,18967,28519,28337,28526,   17,28519,
    4,28482,28519,28533,    5,28482,28517,28537,28219,28537,18967,28541,
    9,28537, 1275,27979,20031,28547,20885,28547,    5,28547,18967,27979,
20103,28555,    5,28555,28337,28559,    9,28559,    5,28554,28219,28565,
   17,28565,21527,27979,18967,27978,28519,28573,    7,28573,    4,28576,
    4,28577,28553,28573,21605,28573,    5,28584,28581,28587,    5,28585,
28579,28591,   16,28573,28591,28595,   11,28573,20273,28573,  567,28573,
    5,28572,    4,28573,    7,28606,28591,28609,28483,28607,28547,28607,
  483,28607,    5,28573,21605,28618,28581,28621,20762,21605,20803,28625,
    7,28625,    4,28628,25743,28631,    4,28629,24687,28635,25773,28635,
21035,28625,   16,28625,25743,28643,20999,28625,20985,28625,  483,28649,
   11,28625,20273,28625,  567,28625,    4,28624,20985,28659,    5,28624,
20956,28663,20773,28663,20885,28663,20413,28668,20413,28663,20885,28672,
20482,28625,20839,28677,    4,28625,    7,28680,25743,28683,20843,28681,
  483,28681,    5,28625,21605,28690,28635,28693,20839,28691,20413,28697,
20413,28690,20839,28701,20413,28625,    5,28705,20885,28707,    5,28704,
20839,28711,    5,21605,21183,28715,18967,28716,24673,28719,21194,28715,
24673,28723,28573,28714,28581,28727,20620,28714,20621,28714, 9994,28714,
 9995,28714,    1,28715,    1,28714,26781,28741,  668,28741,26625,28745,
26777,28741, 1419,28741,26625,28751,26857,28741,26933,28741,    2,28741,
    9,28741,  587,28760,26625,28763,  587,28741,    9,28766,26625,28769,
21018,28714,20839,28773,19396,28715,22579,28777,21611,28777,19683,28715,
20413,28783,23490,28715,20413,28787,21526,28714,26816,28791,24953,28791,
   17,28791,20501,28791,26625,28798,26625,28791,20501,28802,20762,28714,
20773,28807,20956,28807,20885,28807,20413,28812,20413,28807,20885,28816,
27787,28715,18967,28821,20501,28823,18967,28820,20413,28827,27802,28715,
20413,28831,21019,28714,20885,28835,27856,28715,20413,28839,27931,28715,
20413,28843,26904,28715,20413,28847,26861,28715,18967,28851,20823,28715,
20645,28715, 9935,28715,21362,28715,21376,28715,27533,28715,18967,28865,
20501,28867,18967,28864,20413,28871, 9994,28715,28737,28875,20822,28715,
28807,28879,20763,28715,28835,28883,28816,28883,20866,28883,21021,28883,
20413,28883,28807,28892,20843,28892,28807,28883,20413,28898,    9,28899,
20843,28883,20413,28904,    9,28882,28807,28909,  803,28715,   11,28913,
27979,28715,18967,28917,20621,28715,28731,28921,20413,28714,21399,28925,
20839,28925,25737,28925,19683,28925,20763,28925,20843,28935,28807,28935,
20763,28924,20839,28941,25737,28715,20413,28945,20839,28715,20413,28949,
20620,28715,28733,28953,21399,28715,20413,28957,  483,28715,21315,28960,
26860,28715,28337,28715,   11,28967,23457,28715,18967,28970,20413,28973,
18967,28971,20501,28977,    9,28715,21315,28980,20763,28981,20763,28980,
28807,28987,   17,28715,11949,28991, 4669,28991,19631,28991,18967,28991,
20273,28991, 9617,28991, 9995,28715,28735,29005, 1275,28714, 1505,29009,
26889,28715,18967,29012,20413,29015,18967,29013,20501,29019, 1369,28714,
  803,29023,  587,28715, 1505,28715,    6,28714,26940,29031,20413,29033,
28965,29031,18967,29037,18967,29030,26816,29041,24953,29041,   17,29041,
20501,29041,26625,29048,26625,29041,20501,29052,26625,29031,18967,29056,
20413,29059,18967,29057,20501,29063,18967,29031,20413,29067,26625,29069,
26625,29066,20413,29073,    7,28714,19397,29077,    0,29077,    2,29080,
28991,29083,    2,29077,    0,29087,    0,29086,28991,29091,28999,29077,
    1,29076,29091,29097,29083,29097,29081,29097,    2,29103,    1,29077,
29089,29107,    2,29107,28852,29077,    0,29076,    2,29115,29107,29116,
29110,29115,29107,29115,    2,29122,18966,29076,18966,29077,29097,29129,
28991,29129,    9,29129,27323,29077,23651,29077,26907,29077, 9755,29077,
 9317,29077, 4321,29077, 3833,29077,10171,29077, 4295,29077,21183,29077,
 1413,29077,  922,29077,26940,29077,28851,29077,18967,29162,19396,29077,
29127,29167,19683,29077,18967,29076,29079,29173,29134,29173,29129,29173,
    9,29178,    9,29173,29129,29182,26625,29077,18967,29186,21399,29077,
    9,29077,18967,29192,29127,29195,18967,29193,29129,29199,20839,29077,
  483,29077,  903,29204,  903,29077,  483,29208,18967,29077,29115,29213,
28851,29212,29127,29213,    9,29219,26625,29212,    9,29212,29127,29225,
    6,28715,29083,29229,29097,29230,29091,29229,29097,29234,29098,29229,
29100,29229,29105,29229,29109,29229,29119,29229,29121,29229,29125,29229,
29111,29229,29115,29253,24907,29229,25639,29229,22369,29229,28600,29229,
28557,29229,28654,29229,22057,29229,29178,29229,29160,29229,19706,29229,
10737,29229,10475,29229,10979,29229,19597,29229,12137,29229,29219,29229,
29215,29229,29130,29229,29222,29229,29129,29229,29173,29294,29097,29294,
29188,29229,29097,29229,29091,29302,29083,29302,29129,29302,    1,29229,
    5,29310,    5,29229,    1,29314,29173,29229,29129,29318,19687,29229,
19631,29322,26940,29229,29077,29326,10697,29229, 8165,29331,19631,29229,
19687,29334,21575,29229,20273,29229,28573,29340,28625,29340,29186,29229,
18967,29346,19384,29229,19559,29351,28625,29229,20273,29354,28573,29229,
20273,29358,   11,29229,18967,29362,19559,29365,18967,29363,19631,29369,
  587,29229,21605,29373,29313,29375,29317,29375,26625,29229,29212,29380,
18967,29380,29077,29384,29077,29380,18967,29388,29212,29229,29127,29393,
29115,29393,26625,29392,18967,29229,29186,29400,29077,29401,29173,29405,
29097,29405,26625,29400,29077,29410,   11,29401,19687,29415,   11,29400,
19559,29419,29077,29400,29127,29423,26625,29422,29115,29423,29077,29229,
26940,29430,26625,29430,18967,29434,18967,29430,29127,29439,26625,29438,
29115,29439,18967,29431,29129,29447,    7,28715,28791,29451,29041,29451,
19625,29451,21549,29451,21105,29451,26625,29450,29031,29463,18967,29465,
 1275,29451,  903,29469,29031,29451,26940,29473,26625,29473,18967,29476,
18967,29473,26625,29480,20763,28714,28635,29485,28855,29485,20839,29485,
20413,29491,20413,29484,20839,29495,    9,29485,20762,28715,28941,29501,
29495,29501,28773,29501,20815,29501,20993,29501,21027,29501,28985,29501,
29498,29501,29485,29501,20413,29519,    9,29518,20985,29501,20413,29525,
    9,29501,29485,29528,21527,28714,29229,29533,    9,29533,26940,28715,
20413,29539, 9731,28715,    7,29543,26625,28715,20762,29547,    6,29547,
    7,29547,29400,29553,29229,29553,18967,29556,18967,29552,18967,29553,
29229,29562,    6,29546,29553,29567,    7,29546,29551,29571,29031,29571,
18967,29575,18967,29546,20413,29579,18967,29547,20501,29583,    6,29582,
    7,29582,    6,29583,29589,29591,    7,29583,29587,29595,  903,28715,
    7,29599,18967,28715,21183,29602,24673,29605,21183,29603,21795,29609,
23457,29602,20413,29613,27787,29602,20413,29617,27533,29602,20413,29621,
20413,29603,27787,29625,26889,29625,26625,29625,27533,29625,23457,29625,
26889,29602,20413,29637,26625,29602,20413,29641,21315,28715,21183,29645,
24673,29645,25709,29645,    7,29645,  483,29644,    9,29644,18967,28714,
27965,29659,27948,29659,26816,29659,26898,29659,27796,29659,24953,29659,
20119,29659,25129,29659,29653,29659,26887,29659,23480,29659,25099,29659,
21605,29659,    6,29684,29645,29687,29451,29659,28625,29691,28573,29691,
20187,29659,28625,29659,19683,29659,20839,29659,21399,29659,28573,29659,
27787,29659,20501,29708,20501,29659,27787,29712,26889,29712,26625,29712,
27533,29712,23457,29712,27533,29659,20501,29724,   17,29659,    6,29658,
26816,29731,24953,29731,29451,29731,   17,29731,20501,29731,26625,29740,
26625,29731,20501,29744,    7,29658,29697,29749,20103,29749,20186,29659,
29731,29755,    6,29659,29752,29759,24941,29759,23175,29759,29645,29759,
28133,29759,21605,29758,29645,29771,20103,29759,29749,29774,29077,29759,
29749,29759,20103,29780,   11,29759,20763,29759,26625,29787,    7,29659,
29731,29791,20103,29793,20103,29790,29731,29797,23457,29659,20501,29800,
26889,29659,20501,29804,20103,29659,    7,29809,29759,29811,    7,29808,
29731,29815,26625,29659,20501,29818,    6,29819,    7,29819,    6,29818,
29825,29827,    7,29818,29823,29831,21036,21605,27965,29835,27951,29835,
27948,29835,26816,29835,27796,29835,26898,29835,27216,29835,28151,29835,
28101,29835,26887,29835,21194,29835,24673,29857,24675,29835,21069,29835,
21267,29835,21305,29835,24953,29835,20119,29835,22723,29835,25129,29835,
25063,29835,23480,29835,21796,29835,21795,29835,20501,29882,25099,29835,
18967,29835,21183,29889,21795,29891,21183,29888,24673,29895,21259,29835,
20103,29899,21183,29835,27021,29902,18967,29902,24673,29907,20187,29835,
21127,29911,28573,29835,28625,29835,19683,29835,20839,29835,21399,29835,
27787,29835,20501,29924,27533,29835,20501,29928,27021,29835,21183,29932,
20501,29835,27787,29936,26889,29936,26625,29936,27533,29936,23457,29936,
21795,29936,   17,29835,    6,29834,26816,29953,21069,29953,21267,29953,
24953,29953,21305,29953,25063,29953,21259,29953,20103,29967,   17,29953,
20501,29953,26625,29972,26625,29953,20501,29976,    7,29834,21242,29981,
29911,29981,21049,29981,21183,29981,20103,29988,20103,29981,21183,29992,
20186,29835,29953,29997,21105,29997,    6,29835,28133,30003,21279,30003,
21166,30003,29992,30003,23175,30003,24941,30003,20103,30003,21127,30016,
29981,30016,21127,30003,20103,30022,29981,30003,20103,30026,   11,30003,
20763,30003,26625,30033,    7,29835,21105,30037,20103,30039,29953,30037,
20103,30043,20103,30036,29953,30047,21105,30047,23457,29835,20501,30052,
26889,29835,20501,30056,26625,29835,20501,30060,    6,30061,    7,30061,
    6,30060,30067,30069,    7,30060,30065,30073,20103,29835,    7,30077,
30003,30079,21183,30079,    7,30076,29953,30085,21105,30085,    4,21605,
26371,30091,26450,30091,26539,30091,26542,30091,27439,30090,27483,30101,
17048,30091,26496,30091,26452,30091,26373,30091,26466,30091,26386,30091,
  586,30091,  803,30117,  586,30090,  767,30121,    1,30091,   15,30124,
    2,30124,    7,30124,26219,30131,    7,30125,23755,30135,26331,30135,
27805,30135,25793,30135,    1,30090,26454,30145,26375,30145,26415,30145,
26219,30150,26219,30145,26415,30154,26292,30145,26331,30159,25793,30145,
    7,30162,26331,30165,    7,30163,26219,30169,    7,30145,25793,30173,
26415,30175,25793,30172,26331,30179,    3,30090,  767,30183,26454,30091,
18967,30186,26375,30091,18967,30190,28159,30091, 8684,30091, 8647,30091,
26154,30091,26331,30201,26534,30091,26541,30205,26536,30091,26331,30209,
26320,30091,26331,30213,19384,30091,20501,30217,19474,30091,20611,30091,
 9989,30091,20762,30090,20985,30227,27436,30091,20501,30231,27507,30231,
27451,30231,27453,30231,26492,30091,26219,30240,26278,30091,26415,30244,
26219,30091,26541,30248,26492,30248,26415,30248,18967,30254,18967,30248,
26415,30258,27021,30091,18967,30263,20413,30265,18967,30262,20501,30269,
21527,30091,    9,30273,21258,30091,21575,30091,20501,30279,20985,30091,
20501,30090,27907,30285,27483,30285,  340,30091,    9,30091,  483,30091,
26292,30091,26331,30297,18967,30299,18967,30296,26331,30303,20413,30091,
20763,30307,25793,30309,26197,30091,26415,30312,  375,30091,24095,30091,
18967,30319,20413,30321,18967,30318,20501,30325,24252,30091,20501,30329,
   15,30091,    1,30332,18967,30332,   11,30091,18967,30339,20413,30341,
18967,30338,20501,30345, 1369,30339, 9565,30349,28741,30349,30129,30349,
27979,30339,19631,30357,11949,30357, 4669,30357,26415,30091,    1,30365,
26219,30367,26197,30364,26278,30364,26219,30364,18967,30374,18967,30364,
26219,30378,18967,30365,26219,30383, 1369,30090,20029,30387,19781,30387,
21103,30387,26541,30091,26219,30394,    6,30090,23646,30399,23642,30399,
23606,30399,24349,30399,26086,30399,26062,30399,26068,30399,24583,30399,
24591,30399,19384,30399,24265,30419,25793,30399,19631,30422,11949,30422,
 4669,30422,11949,30399,23493,30430,25793,30430, 4669,30399,23493,30436,
25793,30436,19631,30399,23493,30442,25793,30442,   11,30399,18967,30448,
24265,30451,18967,30399,   11,30454,24265,30457,   11,30455,23493,30461,
25793,30461,23493,30399,11949,30466, 4669,30466,19631,30466,    7,30090,
21549,30475,21105,30475,19625,30475,    6,30091,26524,30483,26545,30485,
26524,30482,26541,30489,    7,30091,26525,30492,30455,30493,25793,30497,
    2,30493,    0,30500,30422,30503,25793,30503,30399,30506,30399,30503,
25793,30510,    0,30493,    2,30514,30422,30517,25793,30517,30399,30520,
30399,30517,25793,30524,    1,30492,26219,30529,18966,30493,30422,30533,
25793,30533,30399,30536,30399,30533,25793,30540, 8495,30492,21183,30493,
 8495,30493,26524,30492,26331,30551,21037,30492,25793,30492,26331,30557,
18967,30559,18967,30556,26331,30563,  265,30492,  265,30493,25793,30493,
26541,30571,30495,30571,26492,30571,26415,30571,18967,30578,18967,30571,
26415,30582,18967,30492,26219,30587,25793,30586,26331,30591,25793,30587,
26415,30595,20763,30090,26142,30599,24849,30599,25793,30599,20413,30604,
20413,30599,25793,30608,20762,30091,26219,30613,20885,30613,25793,30612,
26331,30619,25793,30613,26415,30623,26524,30091,20501,30627,    6,30626,
26541,30631,    7,30626,26331,30635,    6,30627,26537,30639,30635,30639,
    7,30627,30631,30645,26219,30645, 8495,30091,    7,30650,25793,30091,
    1,30655,    7,30656,26219,30659,    7,30657,26331,30663,20762,30654,
26331,30667,20762,30655,26197,30671,26219,30671,    6,30655,    7,30655,
26197,30679,26278,30679,    1,30678,26219,30685,26219,30679,18967,30688,
18967,30678,26219,30693,18967,30679,26219,30696,    6,30654,30679,30701,
    7,30654,26331,30705,18967,30707,30677,30705,18967,30704,26331,30713,
18967,30654,20501,30717,    6,30716,    7,30716,26331,30723,    6,30717,
30723,30727,    7,30717,30721,30731,26219,30731,18967,30655,20413,30737,
    7,30736,26219,30741,    7,30737,26331,30745,  265,30091,    0,30748,
    6,30751,21605,30752,21605,30751,    6,30756,    6,30757,    7,30748,
30755,30763,30759,30763,    7,30749,30761,30769,18967,30091,26454,30772,
26375,30772,26292,30772,26331,30779,   11,30772,20501,30783,   15,30772,
27021,30772,20501,30789,20501,30773,25793,30793,27021,30793,24095,30793,
26415,30772,26219,30800,20187,30773,25793,30805,26219,30772,26415,30808,
24095,30772,20501,30813,    6,30773,26604,30817,29645,30817,25793,30817,
20103,30822,20103,30817,25793,30826,    7,30773,26331,30831,27805,30831,
23755,30831,25793,30831,    6,30772,30831,30841,    7,30772,26219,30845,
25793,30844,26331,30849,30817,30845,25793,30845,26415,30855,25793,30772,
20501,30859,    6,30858,    7,30858,26331,30865,    6,30859,30865,30869,
    7,30859,30863,30873,26219,30873,20103,30773,26219,30879,    7,30879,
25793,30883,21037,30091,    6,30887,    7,30887,    6,30886,30891,30893,
    7,30886,30889,30897,18967,30090,27530,30901,26142,30901,26009,30901,
26270,30901,28571,30901,26454,30901,26375,30901,24210,30901,27459,30901,
26219,30901,20273,30920,26415,30920,20413,30901,25793,30926,27021,30926,
24095,30926,27021,30901,20413,30934,20985,30901,24095,30901,20413,30940,
20352,30901,25793,30945,26292,30901,26331,30949,    7,30901,25793,30953,
20273,30955,26415,30955,20273,30952,25793,30961,25793,30952,26331,30965,
26415,30901,26219,30968,20273,30901,26219,30972,    7,30972,25793,30977,
25793,30901,20413,30980,    7,30981,26219,30985,    7,30980,26331,30989,
21314,21605,27530,30993,26142,30993,26270,30993,26009,30993,26454,30993,
26375,30993,28571,30993,24795,30993,24799,30993,24210,30993,21850,30993,
21845,30993,20413,31016,27459,30993,18967,30993,    6,31023,29645,31025,
26219,30993,20273,31028,26415,31028,27021,30993,20413,31034,20413,30993,
25793,31038,27021,31038,24095,31038,21845,31038,20985,30993,24095,30993,
20413,31050,26292,30993,26331,31055,20352,30993,25793,31059,    7,30993,
25793,31063,20273,31065,26415,31065,25793,31062,26331,31071,20273,31062,
25793,31075,26415,30993,26219,31078,25793,30993,20413,31082,    7,31083,
26219,31087,    7,31082,26331,31091,20273,30993,26219,31094,    7,31094,
25793,31099,    6,21605,27347,31103,27401,31103,27378,31103,27327,31103,
27380,31103,27329,31103,27263,31103,27377,31116,27285,31103,27059,31103,
27377,31122,27194,31103,27203,31103,27215,31103,27208,31103,27228,31103,
27233,31103,27188,31103,27187,31103,27184,31103,27183,31103,27294,31103,
27275,31103,27305,31103,27280,31103,27481,31103,27470,31103,27341,31103,
27394,31103,27122,31103,27390,31103,27337,31103,26796,31103,26802,31103,
30939,31103,30229,31103,30616,31103,31049,31103,28681,31103,20843,31180,
28686,31103,22287,31103,28661,31103,28649,31103,27502,31103,27513,31103,
25030,31103,24983,31103,30283,31103,25683,31103,21058,31103,29835,31205,
21195,31103,29835,31209,25629,31103,13894,31103,13919,31103,27498,31103,
27509,31103,27930,31103,27895,31223,27857,31103,    4,31226,27895,31229,
    4,31227,27907,31233,27479,31103,27468,31103,27500,31103,27511,31103,
26941,31103, 9457,31103,30118,31103,30185,31103,30123,31103,30105,31103,
26742,31103, 9444,31103, 9435,31103,  713,31260,30751,31102,30763,31265,
30221,31103,19397,31102,28777,31271, 3119,31103, 3027,31103, 3805,31103,
 4820,31103, 6469,31103, 3419,31103,27422,31103,27359,31103,27392,31103,
27339,31103,27343,31103,27396,31103,27404,31103,27351,31103,27352,31103,
27407,31103, 9539,31103,24554,31103,29659,31102,29645,31311,17294,31103,
26843,31103,30335,31103,26845,31103,25689,31103,30337,31103,30787,31103,
24552,31103,25157,31103,24881,31103,28387,31103,28386,31102,31335,31337,
28387,31102,28386,31103,31341,31343,27287,31103,27323,31347,30127,31103,
30117,31103,  803,31352,    3,31103,    0,31356,27277,31103,20273,31360,
27377,31360,27461,31103,20273,31366,27483,31366,27377,31366,27205,31103,
20273,31374,27377,31374,27218,31103,27316,31103,27398,31103,18967,31384,
27345,31103,18967,31388,  413,31103,30292,31103,26986,31103,26982,31103,
 9287,31103,27224,31103,20273,31402,27323,31403,21276,31103,29835,31409,
21496,31103,27021,31412,27021,31413,21277,31103,27021,31418,27021,31419,
21183,31419, 6441,31103,  759,31427, 4403,31103,17075,31103,16329,31103,
 4919,31103,17099,31103, 9362,31103, 5309,31103, 4547,31103,27291,31103,
20273,31446,27323,31447,26810,31103,26990,31103,  777,31103,  824,31103,
  244,31103, 4933,31103, 5297,31103,17077,31103,13019,31103,12705,31103,
13673,31103,18391,31103,18617,31103,14597,31103,27210,31103,27323,31481,
27472,31103,27323,31485,27300,31103,27323,31489,26317,31103,26476,31103,
 9134,31103, 1216,31103,19687,31103,26625,31500,19397,31103,29659,31505,
29835,31505,22655,31505,23622,31103,27410,31103,22139,31103,22163,31103,
24543,31103,24557,31103,  305,31103,21036,31102,26816,31527,25063,31527,
31245,31527,21069,31527,21267,31527,21305,31527,24953,31527,21259,31527,
20103,31543,   17,31527,20501,31527,26625,31548,26625,31527,20501,31552,
26415,31103,    9,31556,26940,31103,29645,31103,29659,31563,27418,31103,
27255,31566,27272,31103,27377,31570,27255,31103,27483,31574,27418,31574,
27377,31574,18967,31580,18967,31574,27377,31584, 8446,31103,  155,31103,
17049,31103, 1369,31593, 8861,31103,26625,31103,21127,31598,20843,31598,
19687,31598, 8337,31598,20103,31598, 7971,31598, 9565,31598,18967,31598,
 9731,31103,27021,31616,30613,31103,20885,31620, 9617,31102,26973,31625,
 8337,31103,24545,31628,26625,31628,    9,31628, 4819,31103,  713,31636,
13857,31103,  713,31640, 4543,31103,21372,31103,21315,31103,27190,31648,
27483,31648,25027,31648,27021,31649,20273,31657,27377,31657,27021,31648,
20273,31662,27323,31663,20273,31648,27021,31668,27021,31669,   11,31648,
21037,31103,29835,31677,20103,31679,20763,31676,29835,31683,20103,31676,
29835,31687,  713,31103,13857,31690, 9435,31690, 4819,31690,  803,31690,
   25,31103, 7971,31103,26625,31702,20884,31103,29659,31707,29835,31707,
20984,31103,28659,31713,28625,31713,30227,31713,22285,31713,17233,31103,
  903,31722,30091,31103,    9,31726,20162,31103,20171,31103,25027,31103,
21315,31734,27190,31103,21315,31738,21127,31103,26625,31742,20843,31103,
26625,31746,28681,31746, 9565,31103,26625,31752, 8997,31103,    9,31756,
  766,31103, 9455,31761,30121,31761, 3803,31761,  759,31761,    9,31103,
27021,31770,30091,31770, 9195,31770,  241,31770,26415,31770, 8997,31770,
27377,31770,23493,31770, 8337,31770,20103,31770, 1011,31103,  903,31792,
  241,31103,    9,31796,27297,31103,27282,31103,27323,31803,18967,31805,
18967,31802,27323,31809,   17,31803,20103,31103,24545,31814,26625,31814,
21037,31814,29835,31821,    9,31814,21037,31815,25793,31827,20273,31103,
27224,31830,27291,31830,27205,31830,27277,31830,27461,31830,21315,31830,
27021,31842,27021,31843,27021,31830,21315,31848,27231,31103,27377,31852,
  803,31103,30117,31856,  713,31856,20885,31103,27021,31862,30613,31862,
23493,31103,    9,31868,24545,31103,20103,31872, 8337,31872,   17,31873,
   11,31103,28715,31881,19631,31883,11949,31883, 4669,31883,21315,31880,
 8451,31103,27377,31103,27059,31894,27263,31894,27205,31894,27231,31894,
27461,31894,27272,31894,27277,31894,27255,31894,18967,31910,    9,31894,
18967,31894,27255,31916,  903,31103,17233,31920, 1011,31920,  257,31103,
27483,31103,21315,31928,27461,31928,27255,31928,    4,31102,23646,31937,
23642,31937,23606,31937,24349,31937,26086,31937,26062,31937,26068,31937,
24583,31937,24591,31937,19384,31937,24265,31957,25793,31937,19631,31960,
11949,31960, 4669,31960,11949,31937,23493,31968,25793,31968, 4669,31937,
23493,31974,25793,31974,19631,31937,23493,31980,25793,31980,   11,31937,
18967,31986,24265,31989,18967,31937,   11,31992,24265,31995,   11,31993,
23493,31999,25793,31999,23493,31937,11949,32004, 4669,32004,19631,32004,
    5,31102,26940,32013,20413,32015,18967,32012,26816,32019,24953,32019,
31245,32019,   17,32019,20501,32019,26625,32028,26625,32019,20501,32032,
26625,32013,18967,32036,20413,32039,18967,32037,20501,32043,18967,32013,
20413,32047,26625,32049,26625,32046,20413,32053,    4,31103,27857,32057,
27879,32059,27857,32056,27895,32063,20763,32056,29835,32067,29659,32067,
28715,32057,29083,32073,29091,32073,19631,32073,11949,32073, 4669,32073,
29129,32073,18967,32073,29077,32087,18967,32056,23147,32091,24819,32091,
28925,32091,28715,32091,20413,32099,    5,31103,27437,32102,19397,32103,
21605,32103,20762,32108,20762,32109,  586,32108,  586,32109,31993,32103,
25793,32119,    2,32103,21605,32123,    0,32122,31960,32127,25793,32127,
31937,32130,31937,32127,25793,32134,32073,32127,    0,32103,21605,32141,
    2,32140,31960,32145,25793,32145,31937,32148,31937,32145,25793,32152,
32073,32145,  586,32140,  586,32141,21605,32102,18966,32102,18966,32103,
21605,32167,    7,32169,    9,32167,31960,32167,25793,32167,31937,32176,
31937,32167,25793,32180,32073,32167,    1,32103,32125,32187,31937,32189,
    3,32103,32143,32193,31937,32195,28573,32103,28625,32103,20843,32201,
 9195,32103,20501,32103,21183,32103,27436,32102,27323,32211, 9377,32103,
  713,32215, 9875,32103,19396,32103,32165,32221,    9,32103,18967,32224,
32165,32227,18967,32225,32167,32231,20763,32102,22285,32235,28659,32235,
28625,32235,32111,32235,30227,32235,30772,32103,20501,32247,27021,32102,
27323,32251,18967,32253,18967,32250,27323,32257,   17,32251, 1369,32103,
  903,32103,    9,32265,  587,32102, 9455,32269,32159,32269,32115,32269,
 3803,32269,30121,32269,  759,32269,25673,32103,20501,32283,20763,32103,
32113,32287,27021,32287,30613,32287,  587,32103,32161,32295,32117,32295,
30117,32295,  713,32295,27021,32103,27483,32305,32105,32305,27418,32305,
27377,32305,18967,32312,18967,32305,27377,32316,31992,32103,32163,32321,
18967,32103,32163,32325,31937,32327,32165,32325,    9,32331,    9,32324,
32165,32335,30091,32324,20501,32339,31937,32324,32163,32343,31937,32103,
18967,32346,32163,32349,30091,32103,    9,32353,18967,32352,20501,32357,
18967,32353,20413,32361,18967,32102,24953,32365,32171,32365,32107,32365,
32172,32365,32167,32365,    9,32374,    9,32365,32167,32378,27021,32364,
27323,32383,27021,32365,27377,32387,21037,31102,26604,32391,31561,32391,
31615,32391,29645,32391,25793,32391,20103,32400,20103,32391,25793,32404,
21314,31103,23147,32409,24819,32409,28925,32409,28715,32409,20413,32417,
21036,31103,25673,32421,20501,32423,25087,32421,25691,32421,22357,32421,
24953,32421,21049,32421,21242,32421,21183,32421,20103,32438,27021,32420,
27323,32443,20103,32421,21183,32446,27021,32421,27377,32451,27436,31103,
    5,32454,27323,32457,    5,32455,27255,32461, 9195,31103,    9,32464,
27021,31103,21496,32468,21277,32468,20885,32468,    9,32468, 9731,32468,
21037,32468,21315,32468,20273,32482,27323,32483,21037,32469,21315,32469,
27205,32491,21036,32468,27323,32495,32489,32495,21036,32469,27231,32501,
32481,32501,20273,32468,21315,32506,    4,32469,    5,32469,27231,32513,
27272,32513,27255,32513,18967,32518,18967,32513,27255,32522,    9,32513,
    4,32468,32513,32529,    5,32468,27323,32533,18967,32535,32511,32533,
18967,32532,27323,32541,   17,32533,18967,32468,    5,32546,27323,32549,
    5,32547,27255,32553,  587,31103,30091,32557,  803,32559,    5,32556,
 9455,32563, 3803,32563,30121,32563,  759,32563,    5,32557, 9435,32573,
  803,32573,18967,31103,32391,32579,26625,32581,27398,32578,27345,32578,
21605,32578,    7,32589,    4,32591,    4,32590,    4,32589,    7,32596,
   16,32589,27282,32578,27323,32603,26625,32578,32391,32607,27377,32578,
27255,32610,20483,32579,25793,32615,27255,32578,27377,32618,21183,32579,
26625,32623,    4,32579,26142,32627,24849,32627,21605,32627,    7,32633,
25793,32627,20413,32636,20413,32627,25793,32640,    5,32579,32593,32645,
    4,32578,24819,32649,23147,32649,28925,32649,28715,32649,20413,32657,
    5,32578,24953,32661,32595,32661,32599,32661,32635,32661,32601,32661,
27021,32660,27323,32673,27021,32661,27377,32677,27021,32578,    5,32680,
27323,32683,    5,32681,27255,32687,20763,31103,18967,32691,    5,32692,
    5,32693,21037,32690,29835,32699,29659,32691,29835,32691,21036,32691,
21037,32691,25793,32709,30091,32691,20885,32713,    4,32691,32697,32717,
    5,32691,18967,32720,28681,32721,    4,32690,32723,32727,32695,32727,
29659,32727,29835,32727,32707,32727,    5,32690,28625,32739,22285,32739,
28659,32739,30227,32739,32709,32739,18967,31102,    5,32750,26816,32753,
24953,32753,31245,32753,   17,32753,26625,32753,20501,32762,20501,32753,
26625,32766,    5,32751,    9,32771,30091,32771,20501,32775,21526,21605,
    5,32778,26816,32781,24953,32781,   17,32781,26625,32781,20501,32788,
20501,32781,26625,32792,    5,32779,    9,32797,30091,32797,20501,32801,
18967,21605,20355,32804,20354,32804,26415,32805,26219,32810,26454,32805,
26375,32805,21127,32805,21183,32818,21248,32805,21273,32805,20986,32805,
20987,32805,28109,32804,28108,32805,32831,32833,31676,32805,31527,32837,
28109,32805,28108,32804,32841,32843,20352,32805,    4,32847,22729,32849,
22731,32847,32809,32847,20486,32805,26292,32805,26331,32859,19622,32804,
19623,32805,32863,32865,19623,32804,19622,32805,32869,32871,  386,32805,
  347,32805,21396,32804,21397,32805,32879,32881,21546,32804,21547,32805,
32885,32887,21397,32804,21396,32805,32891,32893,21547,32804,21546,32805,
32897,32899,20477,32805,27673,32805,20476,32805,27672,32805,21127,32804,
21087,32911,29031,32804,31881,32805,21543,32805,21087,32805,21127,32921,
31880,32805,21542,32805,26219,32805,26415,32928,27283,32805,31103,32933,
20353,32805,32807,32937,20487,32805,21403,32804,21402,32805,32943,32945,
21573,32804,21572,32805,32949,32951,21403,32805,21402,32804,32955,32957,
21573,32805,21572,32804,32961,32963,20985,32804,32829,32967,21401,32804,
32056,32805,29450,32805,29041,32975,28791,32975,29731,32975,29659,32975,
20984,32805,21400,32805,32971,32987,32103,32805,    7,32990,32365,32993,
32057,32805,29451,32805,32915,32999,20984,32804,32827,33003,20985,32805,
31103,33007,    7,33006,33003,33011,21400,32804,21401,32805,33015,33017,
21183,32805,21127,33020,20413,32805,    4,33025,    4,33024,   11,33024,
27533,32805,   17,33032,20273,32805,    7,33037,    7,33036,   15,33037,
25793,32805,    7,33045,26219,33047,    7,33044,26331,33051,21527,32805,
   17,33054,31103,32805,    4,33059,21037,33059,32421,33063,21037,33058,
31527,33067,    4,33058,   11,33058,21037,32805,31103,33075,32391,33077,
31103,33074,31527,33081,28715,32805,29031,33085,    7,33085,29759,33089,
21527,33085,29229,33093,    7,33084,29041,33097,29731,33097,29659,33097,
28791,33097,   15,33085,  580,32805, 1170,32805,  256,32805,  629,32805,
 1413,32805,  922,32805,  581,32805, 1171,32805,  767,32805,31103,33125,
  375,32805,  305,33128,  510,32805,   18,32804,   12,32804,23493,33137,
 1291,32805,  525,32805,   13,32805,22807,33145,33137,33145,   19,32805,
33135,33151,   18,32805,   13,32804,   12,32805,33157,33159,   19,32804,
33155,33163,   16,32805,32421,33167,25743,33167,32365,33167,32661,33167,
27533,33167,21037,33167,31103,33179,   10,32805,19333,33183,33137,33183,
31648,33183,19455,33183,24237,33183,22896,33183,19393,33183,19385,33183,
    9,33199,22807,33183,    9,33202,20413,33183,    9,33183,22807,33208,
21315,33183,31103,33212,31103,33183,21315,33216,   14,32804,32847,33221,
33041,33221,24953,33221,32975,33221,33097,33221,26816,33221,33167,33221,
33111,33221,   17,33221,20501,33221,26625,33240,26625,33221,20501,33244,
   10,32804,22149,33249,19441,33249,24213,33249,24059,33249,19656,33249,
    9,33249,19631,33260,19631,33249,    9,33264,23983,33249,    9,33269,
  524,32805, 1290,32805,   11,32804,21087,33277,20326,33277,33183,33277,
    9,33283,    9,33276,23493,33287,33183,33287,23493,33277,    9,33293,
20273,33277,    9,33296,    9,33277,20273,33300,    9,32804,   11,33304,
23493,33307,33183,33307,   11,33305,24265,33313,33249,33313,   15,32804,
32937,33319,32999,33319,26142,33319,33123,33319,20413,33319,25793,33328,
20273,33319,25793,33319,20413,33334,   11,32805,24567,33339,33157,33339,
24428,33339,20413,33338,31103,33338,33260,33339,33249,33339,    9,33352,
24265,33339,    9,33356,    9,33339,24265,33360,33249,33360,  483,33338,
    9,32805,30090,33368,30090,33369,30091,33368,33373,33375,  483,33368,
   11,33369,20273,33381,30091,33369,33371,33385,20501,33385,   17,32805,
19474,33390,19475,33391,33393,33395,21314,33390,19474,33391,19475,33390,
33401,33403,21314,33391,21315,33390,33407,33409,27533,33390,21527,33390,
33319,33391, 1275,33390,21315,33391,33399,33421,  305,32805,  375,33424,
 1011,32805,    7,33428,33221,33431,   15,33429,    7,33429,  241,32805,
    7,33438,  483,32805,    4,33442,  903,33442,    9,33442,    4,33443,
   11,33442,  903,32805,    9,33455,  483,33454, 1275,32805,   17,33460,
    7,32805,20985,33464,33003,33467,20985,33465,32985,33471,25672,33465,
30772,33465,25673,33465,30773,33465,21036,33465,30090,33465,20273,33464,
33221,33487,25793,33464,26331,33491,28715,33464,29731,33495,29659,33495,
28791,33495,29041,33495,33221,33495,18967,33465,    5,33506,30091,33506,
    5,33507,33485,33513,   17,33507,21605,33465,    4,33518,33513,33521,
21037,33518,    4,33519,33509,33527,33483,33527,   11,33519,25793,33465,
26415,33535, 1011,33464,33221,33539,  241,33464, 8495,33465,32103,33465,
20273,33547,32165,33547,21037,33465,21604,33553,21605,33552,33555,33557,
21605,33553,21604,33552,33561,33563,28715,33465,20273,33567,29533,33567,
30091,33465,18967,33572,33221,33465,20273,33577,23927,33465,20273,33581,
29031,33465,20273,33585,32013,33465,20273,33589,   15,33465,29835,33465,
29659,33465,29077,33597,32102,33465,    4,33465,24687,33603,25773,33603,
21605,33602,33513,33609,31830,33603,32645,33603,29485,33603,22729,33603,
31103,33603,20273,33620,20273,33603,31103,33624,    5,33465,18967,33628,
33527,33631,31103,33628,20103,33629,31103,33637,    5,33464,33519,33641,
    7,33641,21605,33645,33603,33647,33620,33641,33547,33641,33557,33641,
33475,33641,33525,33641,33481,33641,31648,33641,20413,33641,33603,33641,
31103,33666,21315,33641,31103,33670,31103,33641,33603,33674,21315,33674,
    4,33464,33507,33681,25743,33681,33601,33681,32365,33681,32661,33681,
33635,33681,33575,33681,33477,33681,33511,33681,33479,33681,32421,33681,
33221,33681,27533,33681,33629,33681,31103,33709,21037,33681,31103,33713,
31103,33465,    5,33716,33681,33719,    5,33717,33603,33723,    6,32804,
33624,33727,33713,33727,33085,33727,29229,33733,33179,33727,21036,33727,
33681,33739,33167,33739,28714,33727,33567,33745,18967,33727,    5,33749,
33603,33751,    5,33748,33681,33755,33167,33755,20273,33727,33603,33760,
33603,33727,20273,33764,29451,33727,   17,33727,    5,33726,26816,33773,
33681,33773,24953,33773,33487,33773,33041,33773,33495,33773,33097,33773,
32847,33773,32975,33773,33167,33773,33111,33773,33539,33773,33431,33773,
   17,33773,33465,33773,20273,33803,26625,33773,20501,33806,20501,33773,
26625,33810,    5,33727,33603,33815,18967,33814,33681,33819,33167,33819,
    9,33815,33465,33815,20273,33827,30091,33815,20501,33831,33465,33727,
18967,33834,    4,33837,    4,33836,21315,33834,21314,33834,    4,33835,
33843,33847,    5,33835,33841,33851,33845,33851,    4,33834,18967,33856,
33851,33859,33851,33857,    5,33834,33839,33865,33847,33865,    5,32805,
27953,33871,27743,33871,27555,33871,    2,33870,    0,33870,    3,33870,
    1,33870,33609,33871,33521,33871,30285,33871,33485,33871,32717,33871,
25101,33871,33027,33871,33061,33871,23193,33871,33593,33871,33451,33871,
20413,33871,20885,33871,33603,33871,27533,33913,23015,33871,20501,33917,
27741,33871,20501,33921,    9,33871,30492,33871,    6,33871,33879,33929,
33881,33929,20273,33929,    7,33871,33883,33937,33885,33937,25793,33937,
32805,33936,    4,33945,21605,33937,33947,33949,    5,33949,33945,33953,
33603,33949,30091,33936,21527,33937,27533,33937,21315,33963,    7,33870,
31648,33967,20413,33967,31103,33967,21315,33972,21315,33967,31103,33976,
21315,33871,21605,33981,33929,33983,30091,33871,20501,33987,    6,33986,
    7,33986,    6,33987,33993,33995,    7,33987,33991,33999,    4,32804,
27530,34003,26142,34003,26270,34003,26009,34003,33879,34003,33929,34012,
33881,34003,33929,34016,33930,34003,33932,34003,33939,34003,33941,34003,
33506,34003,33681,34029,33683,34003,33934,34003,33943,34003,26454,34003,
26375,34003,33769,34003,32937,34003,32999,34003,33664,34003,32941,34003,
33908,34003,32997,34003,28571,34003,33970,34003,33961,34003,18967,34003,
33465,34062,33681,34065,33465,34063,33641,34069,33206,34003,33123,34003,
33121,34003,24210,34003,33413,34003,33415,34003,32903,34003,32909,34003,
33771,34003,32917,34003,32927,34003,33275,34003,33143,34003,27459,34003,
33419,34003,33463,34003,33035,34003,33057,34003,33517,34003,26219,34003,
20273,34110,26415,34110,24265,34003,28233,34003,29077,34003,33183,34003,
20413,34122,33641,34003,20413,34126,33967,34003,20413,34130,33391,34003,
27533,34135,20413,34003,25793,34138,27021,34138,33641,34138,33871,34138,
33967,34138,33183,34138,24095,34138,27021,34003,20413,34154,33929,34003,
33879,34158,33881,34158,20273,34158,20985,34003,31103,34167,   11,34003,
21605,34171,33465,34003,18967,34174,33681,34177,24095,34003,20413,34180,
26292,34003,26331,34185,20352,34003,25793,34189,33936,34003,33883,34193,
33885,34193,25793,34193,    7,34003,25793,34201,20273,34203,26415,34203,
33871,34201,33879,34209,33881,34209,20273,34209,25793,34200,26331,34217,
20273,34200,25793,34221,33871,34200,33883,34225,33885,34225,25793,34225,
26415,34003,26219,34232,20273,34003,26219,34236,33929,34236,    7,34236,
25793,34243,25793,34003,20413,34246,    7,34247,26219,34251,    7,34246,
26331,34255,33871,34003,18967,34258,    6,34261,    6,34260,21605,34259,
33929,34267,21527,34258,31103,34259,21526,34258,20413,34258,    6,34259,
34271,34279,    7,34259,34265,34283,34275,34283,    6,34258,34267,34289,
18967,34288,34283,34293,34283,34289,    7,34258,33883,34299,33885,34299,
34263,34299,34279,34299,25793,34299,    4,32805,    2,34311,    7,34313,
27669,34311,23357,34311,32468,34311,28483,34311,27978,34311,31746,34311,
31742,34311,31500,34311,20413,34310,23014,34311,31103,34310,21605,34311,
    7,34338,    7,34339,33773,34343,33221,34343,   15,34338,27021,34311,
31103,34350,28411,34311,33629,34311,20413,34357,  483,34310,31103,34311,
27021,34362,20843,34362,21127,34362,19687,34362,19687,34311,31103,34372,
20843,34311,31103,34376,21127,34311,31103,34380,   15,34311,21605,34384,
  375,34311,33727,34311,    9,34391,    7,34311,21605,34394,25793,34395,
  265,34395,31103,34395,    7,34310,33755,34405,33819,34405,33773,34405,
33739,34405,25743,34405,32661,34405,32421,34405,32365,34405,33221,34405,
27533,34405,21037,34405,33727,34427,31103,34427,21037,34311,33929,34433,
26219,34433,    7,34433,25793,34439,28715,34311,20413,34443,    5,32804,
27965,34447,27948,34447,26816,34447,27796,34447,26898,34447,20353,34447,
29451,34447,32847,34447,33487,34447,33041,34447,32975,34447,33495,34447,
33097,34447,34343,34447,34315,34447,33527,34447,33518,34447,33641,34481,
33643,34447,24953,34447,20119,34447,33706,34447,34362,34447,32727,34447,
25129,34447,34333,34447,33029,34447,34337,34447,33071,34447,32691,34447,
34424,34447,34403,34447,32067,34447,31707,34447,26887,34447,32857,34447,
32973,34447,21605,34447,33465,34522,33641,34525,33465,34523,33681,34529,
33176,34447,33111,34447,33109,34447,31505,34447,23480,34447,33347,34447,
33349,34447,32905,34447,32907,34447,32919,34447,32925,34447,33273,34447,
33141,34447,25099,34447,33539,34447,34361,34447,33445,34447,33431,34447,
33367,34447,33453,34447,33031,34447,33073,34447,33533,34447,20187,34447,
19683,34447,20839,34447,21399,34447,33167,34447,27533,34586,33681,34447,
27533,34590,34405,34447,27533,34594,28625,34447,28573,34447,33339,34447,
20413,34603, 1171,34447,27787,34447,20501,34608,27533,34447,20501,34612,
33681,34612,34405,34612,33167,34612,20501,34447,27787,34622,26889,34622,
26625,34622,27533,34622,23457,34622,34395,34447,   17,34447,33465,34447,
29077,34639,20273,34639,21605,34638,33641,34645,28233,34639,24265,34639,
   11,34639,    6,34446,26816,34655,34405,34655,33041,34655,33097,34655,
34343,34655,33681,34655,32847,34655,33487,34655,32975,34655,33495,34655,
24953,34655,33167,34655,33111,34655,33539,34655,33431,34655,   17,34655,
33465,34655,20273,34689,20501,34655,26625,34692,26625,34655,20501,34696,
    7,34446,34635,34701,34579,34701,34311,34701,20103,34701,20186,34447,
34655,34711,34394,34447,34655,34715,31103,34447,34311,34718,    6,34447,
34706,34723,34395,34723,33039,34723,33089,34723,34397,34723,34341,34723,
20273,34723,34708,34723,23175,34723,24941,34723,34325,34723,28133,34723,
33437,34723,20103,34723,34701,34750,34701,34723,34311,34754,20103,34754,
   11,34723,34311,34723,34701,34762,20763,34723,26625,34767,    7,34447,
21605,34771,34311,34773,34655,34771,34311,34777,20103,34777,20103,34770,
34655,34783,34311,34770,34655,34787,23457,34447,20501,34790,26889,34447,
20501,34794,20103,34447,    7,34799,34723,34801,    7,34798,34655,34805,
26625,34447,20501,34808,    6,34809,    7,34809,    6,34808,34815,34817,
    7,34808,34813,34821,34311,34447,21605,34824,18967,34825,    6,34828,
    6,34829,31103,34824,21527,34825,21526,34825,20413,34825,    6,34825,
18967,34842,34827,34843,    7,34825,34723,34849,25793,34849,34833,34849,
    6,34824,34849,34857,34837,34857,    7,34824,34655,34863,34845,34863,
34831,34863,34843,34863,34839,34863,    6,32805,34236,34875,34120,34875,
34433,34875,20962,34875,21001,34875,34118,34875,34355,34875,25648,34875,
21314,34874,34891,34893,25649,34875,33087,34875,21314,34875,34116,34875,
23017,34875,34335,34875,21937,34875,34170,34875,34173,34875,21959,34875,
21315,34874,34897,34917,34385,34875,34387,34875,24875,34875,33332,34875,
33435,34875,33043,34875,33107,34875,34349,34875,21605,34875,21315,34936,
34893,34939,21315,34937,34901,34943,20273,34875,34003,34946,33319,34946,
20885,34875,20843,34952,21315,34875,21605,34956,34893,34959,19475,34875,
26625,34963,24265,34875,34003,34966,29077,34875,34003,34970,28233,34875,
34003,34974,20843,34875,20885,34978,   11,34875,34003,34982,33319,34875,
20273,34986,34003,34875,29077,34990,20273,34990,28233,34990,24265,34990,
   11,34990,30993,34875,30901,34875,20984,34875,20839,35007,    5,34875,
20763,35011,20843,35013,20763,35010,20839,35017,20763,34875,    5,35020,
20839,35023,    5,35021,20885,35027,    7,32804,34736,35031,34459,35031,
34461,35031,29691,35031,29340,35031,28714,35031,33603,35043,21605,35031,
    5,35047,33681,35049,34405,35049,33167,35049,    5,35046,33603,35057,
34607,35031,34637,35031,33924,35031,34447,35031,   11,35031,32103,35031,
29835,35031,29659,35031,20273,35031,34723,35076,29229,35076,35011,35031,
34723,35031,20273,35084,  567,35031,29229,35031,20273,35090,    9,35031,
33871,35094,33871,35031,    9,35098,    4,35030,    5,35030,35083,35105,
34875,35105,35010,35031,35103,35111,    4,35031,35108,35115,    7,35114,
35049,35119,35105,35115,34875,35122,34875,35115,35105,35126,  483,35115,
    5,35031,21605,35132,33603,35135,35103,35133,34875,35139,34875,35132,
35103,35143,34875,35031,18967,35147,    4,35148,    4,35149,21315,35147,
21314,35147,    4,35147,18967,35158,    5,35147,35115,35163,35153,35163,
    4,35146,35163,35169,35155,35169,    5,35146,35103,35175,35161,35175,
35151,35175,35159,35175,35157,35175,    0,    4,14087,35187,14103,35188,
 4983,35187, 5001,35192,14104,35187, 5002,35187,14088,35187,14091,35201,
 4984,35187, 4987,35205,14093,35187, 4989,35187,28758,35187,29229,35213,
28741,35187,    2,35216,29229,35219,20501,35186,19463,35223,19317,35223,
19301,35223,20009,35223,   53,35186,19463,35233,20009,35233,19317,35233,
19053,35187,  989,35241, 1201,35187,18967,35245, 1203,35247,17673,35186,
17685,35251,21405,35186,21489,35255,19513,35186,19463,35259,20009,35259,
19317,35259,10157,35187,   17,35267,10159,35269,20343,35187,18967,35273,
20345,35275, 1179,35187,  527,35186,19301,35281,19916,35186,    4,35285,
    7,35286,    7,35285,    4,35290,   16,35285,19069,35186,19301,35297,
 1290,35186,    0,35301,    2,35302,    2,35301,    0,35306,18966,35301,
21530,35187,20501,35313, 1489,35187,16859,35187,   11,35318, 9875,35321,
21529,35187,   11,35324,20501,35327,  147,35187,16860,35187, 9875,35333,
  987,35187, 8069,35187,   11,35338, 8067,35341, 8070,35187, 8067,35345,
27519,35187,27525,35187,26322,35187,26566,35187,26102,35187,26276,35187,
26105,35187,33464,35187,29600,35187,32295,35187,31856,35187,25636,35187,
29229,35371,    9,35371,28555,35187,29229,35377,    9,35377,19301,35187,
20501,35383,  527,35383,19069,35383, 4266,35187, 8056,35187, 8147,35187,
20739,35187, 9997,35187, 8784,35187, 8622,35187, 8824,35187, 8702,35187,
 8697,35187, 8676,35187, 8635,35187,20828,35187,19772,35187,19890,35187,
19774,35187,19894,35187,19382,35187,19458,35187,32557,35187,  803,35429,
19463,35187,20501,35433,   53,35433,19513,35433,20009,35187,   53,35441,
20501,35441,19513,35441,19317,35187,20501,35449,   53,35449,19513,35449,
19914,35187,21066,35187,20575,35187,21312,35187,21270,35187,  694,35187,
 9377,35467,16920,35187,    9,35471,17621,35187,    9,35475, 4213,35187,
  375,35478, 8757,35187,  375,35482, 9530,35187, 9875,35487,16091,35487,
20501,35487,19751,35187,   53,35495,  253,35495,  117,35495,   71,35495,
 1471,35495, 1397,35187, 9592,35187,16514,35187,19380,35187,13836,35187,
20595,35187, 9911,35187, 9983,35187, 9905,35187,17566,35187,16816,35187,
17910,35187,18880,35187,14103,35187,14087,35532, 5001,35187, 4983,35536,
20597,35187,26219,35187,  241,35542,  587,35543, 8647,35187,  241,35548,
  587,35549,14073,35187,  586,35554,14091,35557,  586,35555,14103,35561,
 4971,35187,  586,35564, 4987,35567,  586,35565, 5001,35571, 1291,35187,
35305,35575,35309,35575, 1871,35575, 1889,35575,    3,35575,19667,35575,
12345,35575, 5123,35575,19067,35575,35311,35575,18967,35575, 1297,35597,
35301,35597,19917,35187,35289,35603,35293,35603,19939,35603,19945,35603,
    6,35603,19947,35603,35295,35603,   17,35603,19931,35619,35285,35619,
 1108,35187,   11,35625,22806,35187,    9,35629,  524,35187,    3,35633,
 3477,35633, 2007,35633,19051,35633,19667,35633,12345,35633, 5123,35633,
18967,35633,  555,35649,  713,35187, 1325,35187,17455,35655,10001,35187,
 1505,35659, 9513,35187,   11,35662, 9875,35665,16091,35665,20501,35665,
19396,35187,  483,35672,17455,35187,13737,35676,  803,35187,31103,35680,
31103,35187,  803,35684,  113,35187,  375,35187,  587,35691, 9195,35693,
 4213,35690, 7971,35690, 8757,35690,  587,35690, 9377,35703, 9565,35690,
18967,35690,19892,35187,    9,35710,  510,35187,18967,35714,  587,35187,
  375,35718, 9377,35721, 9377,35719,  375,35725,  483,35187,19396,35728,
  587,35729,   11,35728, 5123,35735,12345,35735, 3477,35735, 2007,35735,
19667,35735,19051,35735,18967,35735,  555,35749,18967,35728,    9,35752,
    9,35728,18967,35756, 1275,35187,16833,35760,    9,35763,  903,35761,
    9,35761,21575,35187,18967,35771,21577,35773,21581,35773,21585,35773,
 6685,35187, 7519,35187,   17,35783, 7521,35785, 7525,35785, 7529,35785,
21258,35187,  241,35792,16722,35187,32103,35187,    9,35799,10310,35187,
 8684,35187,  241,35804,  331,35805,26292,35187,  241,35810,  482,35186,
    2,35815,    0,35816,35633,35819,35735,35819,    0,35815,    2,35824,
35633,35827,35735,35827,35749,35815,35649,35815,18966,35815,35735,35837,
35633,35837, 1368,35186,25793,35843, 8495,35843,23755,35843,10055,35843,
 4329,35843, 4311,35843,26331,35843,27805,35843, 3785,35843, 8717,35843,
10351,35843,  586,35186,31761,35867,32563,35867,32269,35867,    7,35867,
    4,35874,    4,35867,    7,35878,   16,35867,  767,35867,31103,35885,
  482,35187,  587,35889, 1274,35187,  587,35186, 9262,35895,  375,35895,
 9195,35898,    7,35895,  265,35903, 9195,35905, 9195,35895,  375,35908,
  483,35895,  483,35186, 1369,35186,19463,35917,19301,35917,20009,35917,
19317,35917, 1368,35187,    7,35927,  586,35187,14073,35930,14091,35933,
 4971,35930, 4987,35937,31856,35931,32295,35931, 7971,35931,14073,35931,
14087,35947, 4971,35931, 4983,35951,31103,35931,  803,35954,  803,35931,
31103,35958,  483,35931, 1531,35187,13737,35187, 1487,35966,17455,35966,
16833,35187, 1196,35972, 1196,35973, 1197,35972,35977,35979, 1197,35973,
35975,35983, 1275,35972,    9,35987,  767,35187,31103,35991, 1487,35187,
13737,35994,16937,35187,   17,35999, 9377,36001,17573,36001,16947,36001,
 1347,35187,18967,36009,  555,36011,  251,36011, 1365,36011, 1351,36011,
   21,36011,20762,35187,  241,36022,  256,35187,25793,36026,25793,36027,
 8495,36026, 8495,36027,18967,36026,21037,36026,  972,35187, 9377,36041,
  629,35187,18967,36044,  340,35187, 9377,36049,27978,35187,28353,36053,
30003,36053,29759,36053,34723,36053,21183,36053,    2,36053,28337,36065,
28189,36065,28191,36053,  959,36053,  759,36053,   47,36053,   66,35187,
   89,35187,    7,36080,  973,35187,35895,36085,21527,35187,21605,36088,
29229,36091,    9,36091,  145,35187,  165,35187,  305,35187,   25,35187,
27533,35187, 1505,36105,  331,35187,17455,36109,   59,35187,17455,36113,
29599,35187,    7,36116,26546,35187,    7,36120, 8812,35187,    7,36124,
10291,35187,    3,36129,    3,36128, 9565,35187,  375,36134, 8495,35187,
  256,36138,    7,36139,  375,36143,    7,36138,  241,36146,  331,36147,
  241,36138,    7,36152, 7971,35187,  375,36156,25793,35187,  256,36160,
    7,36160,  241,36164,  241,36160,    7,36168,32805,35187,    7,36172,
19888,35187,    7,36176,18967,35187,  256,36180,  629,36180,  510,36180,
  375,36180,  483,36180,    9,36190,    9,36180,  483,36194,    7,36180,
  241,36198,    7,36181,25793,36203, 8495,36203,  241,36180,    7,36208,
  241,35187,26292,36212,26219,36212, 8684,36212, 8647,36212,20762,36212,
21258,36212,    7,36212,25793,36226,25793,36227, 8495,36226, 8495,36227,
18967,36226,21037,36226,25793,36212,    7,36240, 8495,36212,    7,36244,
18967,36212,    7,36248,21037,36212,    7,36252,    9,35187,19892,36256,
 1011,36256,   11,36261,18967,36256,  483,36264,  483,36256,18967,36268,
  903,35187,    7,36272, 9377,36275,19913,35187,    6,36279,    7,36279,
    6,36278,36283,36285,    7,36278,36281,36289,   15,35187,25381,36293,
  483,36293,    2,36293,28189,36299, 1011,35187,16710,36303,16711,36303,
16710,36302,36307,36309,    0,36303,    6,36312,16711,36302,36305,36317,
    9,36302,   11,36321, 1275,36302,36315,36325,   11,36303,    9,36329,
    6,36302,    3,36332,    6,36303,    0,36336,36325,36339,    7,36303,
25793,36343, 8495,36343,21605,35187,21037,36348,21105,36348,21527,36348,
29229,36355,    9,36355,21549,36348,19625,36348,21526,36348,    5,36364,
  922,36349,  918,36349, 1505,36349, 1419,36349,  668,36349,  483,36349,
  903,36378,  587,36349,    9,36382,    9,36349,  903,36386,   11,36387,
  587,36386,   15,36348,   11,36348,    9,36397,    6,36348,21036,36400,
    5,36400,18967,36404,18967,36400,    5,36408,    7,36348,30003,36413,
29759,36413,34723,36413,21183,36413,  959,36413,   47,36413,  759,36413,
    6,36349,36353,36429,36361,36429,36351,36429,36363,36429,    7,36349,
36403,36439,31527,36439,22269,36439,28791,36439,22263,36439,32781,36439,
36367,36439,21105,36439,21549,36439,29953,36439,29731,36439,34655,36439,
33773,36439,29835,36439,29659,36439,34447,36439,32753,36439,32019,36439,
29041,36439,23929,36439,22205,36439,19625,36439,33221,36439,36407,36439,
36411,36439,18967,36348,    5,36490,    6,36493,36413,36495,    6,36492,
36439,36499,36439,36493,   14,36490,36439,36505,    6,36491,36395,36509,
    6,36490,    5,36512,36439,36515,  903,36349,    7,36519,    9,36518,
  483,36518,  265,35187,17455,36527, 5843,36527,  483,36527,  587,36527,
    9,36527,    7,36526, 9377,36539,    7,36527,   11,35187, 8069,36544,
 8067,36547,16859,36544, 9875,36551,21529,36544,20501,36555,16091,36545,
 9513,36559,    7,36544,    2,36563,    7,36564,36545,36567,    1,36564,
36569,36571,    1,36563,    2,36574,    0,36544,    2,36579,    0,36580,
36545,36583,    6,36580,36585,36587,    6,36579,    2,36590,  482,36579,
 1368,36544,    2,36597,    1,36598,    1,36597,    2,36602,18966,36544,
    2,36607,    6,36608,    6,36607,    2,36612,  482,36607, 9513,36544,
20501,36619, 9875,36619,16091,36619,20501,36545,21529,36627, 9513,36627,
 9875,36545,16859,36633, 9513,36633, 1369,36545, 1989,36639, 3587,36639,
36601,36639,36605,36639, 5303,36639,36571,36639,36577,36639,    0,36639,
 4897,36639,17041,36639,18967,36545,20281,36661,20345,36661,36611,36661,
36615,36661,36587,36661,36593,36661,    7,36661,20285,36661,36595,36661,
36617,36661,  483,36661,20273,36683,36579,36683,36607,36683,21605,36544,
    9,36691,  483,36544,35819,36695,35827,36695, 3477,36695, 2007,36695,
    1,36695,36639,36705,36655,36695,19051,36695,19667,36695, 5123,36695,
12345,36695,35837,36695,18967,36695,  555,36721,35815,36721,    3,36544,
    3,36545,  375,36729,21308,35187,    7,36732,16481,35187,    7,36736,
21037,35187,  256,36740,    7,36740,  241,36744,  241,36740,    7,36748,
16531,35187,    7,36752, 1011,36753,    7,36757,18797,35187,    7,36760,
17827,35187,    7,36764,16783,35187,    7,36768,    2,35186,27138,36773,
28047,36773,26454,36773, 8770,36773,26375,36773, 8729,36773, 8697,36773,
 8784,36773,28197,36773, 4266,36773, 9262,36773,28111,36773,27128,36773,
28027,36773,28117,36773,28177,36773,31872,36773,28063,36773,31598,36773,
24545,36773,31103,36812, 8684,36773, 8717,36817,  331,36817,26292,36773,
26331,36823, 8647,36773, 8757,36826,26219,36773,27021,36830,26415,36830,
26415,36773,26219,36836, 8757,36773, 8647,36840,  375,36840, 4213,36773,
  375,36846,28153,36773,26860,36773,28213,36773,35931,36773,28159,36773,
31770,36773,  347,36773,  386,36773, 9750,36773,27978,36773,26331,36869,
27805,36869, 1325,36869,  331,36869,   59,36869,23755,36869,25793,36869,
  265,36869,  340,36773,  331,36887,31103,36773,24545,36890,26625,36890,
    9,36890,  375,36773, 8757,36898, 4213,36898, 9195,36898,27021,36898,
  305,36898,  483,36773, 9195,36773,  375,36912,10001,36773,    9,36917,
 1325,36773, 1275,36773,  331,36773,27533,36773,    9,36927,  305,36773,
  375,36930,10291,36773,  483,36935,27021,36773,26219,36938,  375,36938,
    7,36773,25793,36944,26331,36947, 8495,36944, 8717,36951,  331,36951,
25793,36945,26415,36957,27021,36957, 8495,36945, 8757,36963,26625,36944,
 9731,36944,21605,36945,24545,36971,26625,36971,    9,36971,  265,36945,
 8757,36979, 4213,36979,27021,36979, 9195,36979,  305,36979,21605,36944,
26331,36991,27805,36991,23755,36991,   59,36991,  331,36991, 1325,36991,
25793,36991,  265,36991,  265,36944,  331,37009, 8647,36945,26219,36945,
   59,36773,    7,36772,25793,37019, 8495,37019,23755,37019,10055,37019,
 4329,37019, 4311,37019, 3785,37019,27805,37019,10351,37019, 8717,37019,
26331,37019,    9,36773,31103,37042,   15,36773,31103,37047, 9731,36773,
    7,37050,21605,36773,   15,37055,31103,37057,    6,37055,    5,37060,
    7,37055,26219,37065,  375,37065,    6,37054,37057,37071,    7,37054,
26331,37075,37063,37075,27805,37075,23755,37075,   59,37075,  331,37075,
 1325,37075,25793,37075,  265,37075,  265,36773,    7,37095, 8495,37097,
  375,37097,    7,37094,  331,37103,26625,36773,31103,37106,    7,37106,
 8495,36773,    7,37112, 8717,37115,  331,37115,    9,37113,  483,37113,
    7,37113, 8647,37125,  375,37125,25793,36773,    7,37130,26331,37133,
  483,37131,    9,37131,    7,37131,26219,37141,    3,35186,20305,37145,
 9641,37145,20309,37145, 9645,37145,    4,37145,    7,37154,35603,37157,
 9719,37145,   16,37145,35603,37163,35619,37145,21081,37145,20323,37145,
20387,37145, 9701,37145,35719,37145,  524,37145,20273,37179, 9617,37179,
 1291,37145, 9617,37185,20273,37185,  305,37145,  375,37190,  386,37145,
  347,37145,  767,37145,31103,37199,  483,37145,   11,37202, 9617,37205,
20273,37205,  375,37145,  305,37210,    7,37145,    3,37215,18967,37217,
35187,37219,    4,37214,35603,37223,37221,37223,    3,37214,35187,37229,
   11,37145,  483,37232, 9617,37235,20273,37235,    6,35186,19975,37241,
    0,37241,    2,37244,35575,37247,35633,37247,35735,37247,36695,37247,
18966,37241,35735,37257,35633,37257,35575,37257,36695,37257,35749,37241,
35649,37241,36721,37241,35597,37241,19365,37241,19221,37241,19917,37241,
10107,37279,  587,37241,    3,37241,    2,37241,    6,37287,   17,37289,
35187,37291,    0,37286,35575,37295,35633,37295,35735,37295,36695,37295,
37293,37295,    6,37286,36544,37307,37295,37309,   11,37307,35187,37312,
37295,37315,35187,37307,   11,37318,37295,37321,    7,35186,    4,37325,
    3,37326,    3,37327,35927,37331,  902,37325,25525,37325, 1325,37325,
10001,37325,  903,37341, 1275,37325,   59,37325,25793,37325,  587,37349,
 8495,37325,  587,37353,    2,37325,    7,37356,37331,37359,  903,37357,
10311,37357,    3,37325,    4,37366,27533,37325,  903,37371,  331,37325,
    2,37324,25793,37377, 8495,37377,23755,37377, 4329,37377,10055,37377,
27805,37377, 3785,37377, 4311,37377,26331,37377, 8717,37377,10351,37377,
21605,37325,  903,37401,  155,37401,  265,37325,    7,35187, 5045,37408,
  805,37409, 9195,37413,    4,37408,37279,37417,19916,37417,37241,37421,
 1275,37417,18967,37424,37241,37427,18967,37417, 1275,37430,37241,37433,
26546,37408,32805,37408,29599,37408,  652,37409, 9195,37443, 8812,37408,
19888,37408,19913,37408,21308,37408,16481,37408,37285,37409,16783,37408,
17827,37408,18797,37408,26498,37409, 8796,37409, 8495,37408,  241,37468,
  331,37469,25793,37408,  241,37474,25793,37409,  241,37479,  587,37478,
 8495,37409,  241,37485,  587,37484,21037,37408,  241,37490,   88,37409,
37411,37495,16531,37408,  587,37409,  265,37500, 9195,37503,26625,37501,
25793,37501, 8495,37501,25793,37500, 8495,37500, 9731,37501,  265,37409,
  587,37518, 9195,37521, 4213,37519, 7971,37519, 8757,37519,  587,37519,
 9377,37531, 9565,37519,   89,37409, 5069,37537, 9195,37537,27021,37537,
  483,37409, 1275,37409,    9,37547,26503,37409, 8809,37409,18967,37408,
  241,37554,  241,37408,25793,37558,25793,37559, 8495,37558, 8495,37559,
18967,37558,21037,37558,  903,37408, 9377,37573,21605,37408,30003,37577,
29759,37577,34723,37577,21183,37577,37495,37577,  959,37577,   47,37577,
  759,37577,  265,37408, 9377,37595,  903,37409,31103,37598,31920,37409,
31103,37409,  903,37604,  375,37409,    2,37408,37331,37611,37495,37611,
    3,37408,14072,37616, 4970,37616,14072,37617,14073,37616,37623,37625,
 4971,37616, 4970,37617,37629,37631,    7,37617,    4,37635,    1,37616,
37537,37639,    9,37639,36773,37617,37537,37617, 7971,37617,14073,37617,
37619,37651, 4971,37617,37621,37655,  483,37617,    9,37617,    2,37409,
37369,37663,37329,37663,37637,37663,    7,37662,37617,37671,37335,37663,
 9362,37663,27218,37663,37642,37663,37639,37663,    9,37682,28189,37663,
    1,37663,    5,37688,37616,37690,37617,37691,37693,37695,37671,37694,
37616,37691,37617,37690,37701,37703,37672,37691,37671,37691,37617,37708,
    5,37663,    1,37712,37616,37714,37617,37715,37717,37719,37671,37718,
37616,37715,37617,37714,37725,37727,37672,37715,37671,37715,37617,37732,
28337,37663,37660,37663,27021,37663,    9,37740, 9195,37663,    9,37744,
    9,37663,37639,37748,27021,37748, 9195,37748,37617,37748,37241,37663,
37617,37663,    1,37760,    5,37762,    5,37760,    1,37766,    7,37761,
37691,37771,37715,37771,37765,37771,37769,37771,    9,37760,    3,37409,
37577,37783,    9,37785,   16,37783,    4,37783,    7,37790,    7,37783,
    4,37794,18967,37783,35187,37799,37789,37801,37793,37801,37797,37801,
    9,37782,37577,37809,37611,37809,37611,37783,    1,37815,    5,37816,
    5,37815,    1,37820,    7,37814,37819,37825,37823,37825,    9,37815,
    9,37409,    3,37832,37577,37835,37611,37835,    3,37833,37663,37841,
    3,35187,10104,37844,10105,37844,    0,37845,    5,37850,    4,37844,
36773,37855,10104,37845,37849,37859,10105,37845,37847,37863,36945,37845,
37855,37867,10291,37844,36944,37845,  265,37873,37663,37845,    7,37877,
37691,37879,37715,37879, 1369,37845,   11,37885, 9617,37887,37853,37887,
20273,37887,   11,37844,    6,37844,    7,37844,14072,37898, 4970,37898,
14073,37898,14072,37899,37905,37907, 4971,37898, 4970,37899,37911,37913,
35187,37899,36773,37899, 7971,37899,14073,37899,37901,37923, 4971,37899,
37903,37927,  483,37899,    6,37845,37856,37933,37855,37933,36773,37936,
    1,37933,    5,37940,37898,37942,37899,37943,37945,37947,37898,37943,
37899,37942,37951,37953,    5,37933,    1,37956,37898,37958,37899,37959,
37961,37963,37898,37959,37899,37958,37967,37969,36773,37933,37855,37972,
37899,37933,    7,37845,  265,37979,36773,37981,35187,37978,    2,37985,
    4,37979,37987,37989,    3,37989,37985,37993,37663,37989,36773,37978,
  265,37999,37897,37979,36773,37845,    4,38005,37933,38007,    7,38005,
37943,38011,37959,38011,14073,38011, 4971,38011,    6,38004,    1,38021,
    5,38022,38011,38025,    5,38021,    1,38028,38011,38031,38007,38021,
    7,38004,  265,38037,18967,37845,    4,38041,37933,38043,  256,38041,
    7,38041,  241,38048,  241,38041,    7,38052,    2,35187,29229,38057,
28741,38059,28741,38056,29229,38063,    0,38057,    0,38056,28714,38069,
37185,38069, 1290,38069,37145,38075,37179,38069,  525,38069,37145,38081,
37887,38069,37205,38069,37235,38069,    5,38069,21605,38090,21605,38069,
    5,38094, 1275,38069,   17,38098,37145,38101,   17,38069, 1275,38104,
37145,38107, 1505,38057,17455,38057,  903,38112,17494,38057,  483,38057,
37214,38057,14073,38121, 4971,38121,37783,38057,  587,38057,10373,38057,
    9,38057,  155,38057,    6,38056,    1,38137,    5,38138,38121,38141,
    5,38137,    1,38144,38121,38147,37145,38137,  587,38137,    7,38056,
37331,38155,    6,38057,    5,38158,18966,38159,    0,38159,    2,38164,
    2,38159,    0,38168, 1369,38159,   17,38159,35187,38175,38163,38177,
38167,38177,38171,38177,    7,38057,38141,38185,37145,38187,38147,38185,
37145,38191,34447,38185,28715,38185,38069,38197,38071,38185,29659,38185,
29835,38185,38093,38185,38097,38185, 4971,38185,37145,38211,14073,38185,
37145,38215,37145,38184,38141,38219,38147,38219,14073,38219, 4971,38219,
21605,38185,  903,38229,37145,38057,    4,38232,    6,38233,    1,38237,
    5,38238,    5,38237,    1,38242,38235,38237,    7,38233,  265,38249,
    7,38232,38241,38253,38245,38253,38141,38253,38147,38253,14073,38253,
 4971,38253,  903,38057,17455,38266,    6,35187,    4,38271,    1,38272,
    0,38270,   17,38277,37844,38278,37845,38279,38281,38283,37845,38278,
37844,38279,38287,38289, 1369,38271,    2,38270,  587,38295,    3,38270,
    2,38271, 1275,38301,    1,    5,35962,38304,35963,38304,37760,38304,
37771,38311,37976,38304,38002,38304,37761,38304,37977,38304,37815,38304,
37825,38323,38003,38304,37930,38304,37658,38304,37931,38304,37659,38304,
   77,38304, 3095,38337, 1917,38337,  120,38304, 3013,38343, 1897,38343,
   79,38305, 3113,38349,  125,38305, 3023,38353,35929,38305,37885,38357,
37916,38305,37885,38361,38021,38304,38011,38365,38237,38304,38253,38369,
 4597,38305, 6625,38373,  113,38304, 4696,38377,    9,38377, 4669,38380,
 4669,38377,    9,38384,37896,38304,37898,38304,37933,38391,  483,38391,
37616,38304,37663,38397,  483,38397,   59,38304,23023,38403,25483,38403,
22677,38403,27533,38304,23023,38411,22677,38411,22605,38411,25483,38411,
37663,38304,37617,38420,37672,38421,37671,38421,37617,38426,37771,38421,
37879,38421,37617,38421,38397,38435,37671,38434,37933,38304,37899,38440,
38011,38441,37899,38441,38391,38447,37897,38304,38137,38304,38121,38453,
38219,38453,38185,38453,37145,38459,38253,38453,37617,38304,37663,38464,
  483,38464,37899,38304,37933,38470,  483,38470,  979,38305,21605,38477,
  987,38479,21879,38305, 1205,38483,29229,38304,29375,38487,17105,38304,
17117,38491,23755,38304,23023,38495,22677,38495,25483,38495,26863,38305,
21605,38503,26865,38505,10091,38305,   15,38509,10093,38511, 1009,38305,
  675,38304,22605,38517, 1418,38304,    1,38521,    3,38522,    3,38521,
    1,38526,21604,38521,21895,38304,22605,38533,25380,38304,    5,38537,
    6,38538,    6,38537,    5,38542,   14,38537, 1365,38305,17573,38305,
    9,38550,10001,38553,27996,38305,27533,38557, 1203,38305,17574,38305,
10001,38563,  177,38305,27995,38305,    9,38568,27533,38571, 7963,38305,
    9,38574, 7961,38577, 7964,38305, 7961,38581,  120,38305,   77,38305,
37758,38305,37972,38305,37457,38305,37867,38305,35912,38305,35733,38305,
35732,38305,35913,38305,22605,38305,27533,38605,  675,38605,21895,38605,
36856,38305,  483,38613,37644,38305,  483,38617,37918,38305,37933,38621,
  483,38621,37177,38305,  483,38627, 4798,38305,15896,38305,23023,38305,
   59,38635,27533,38635,23755,38635,22677,38305,27533,38643,   59,38643,
23755,38643,25483,38305,   59,38651,27533,38651,23755,38651,25368,38305,
30290,38305,27127,38305,30762,38305,30566,38305,  843,38304,35187,38669,
 1531,38304,  842,38304, 1530,38304,35930,38305,38675,38679,38307,38679,
 9492,38305,10001,38685,13755,38685,27533,38685,24597,38305,   59,38693,
  331,38693,   97,38693,  141,38693, 1325,38693,  629,38305,37896,38305,
37610,38305,37783,38709,37616,38305,38467,38713,38423,38713,38311,38713,
38331,38713,38469,38713,38465,38713,37663,38725,  483,38725,37898,38305,
38473,38731,38443,38731,38315,38731,38329,38731,38475,38731,38471,38731,
37933,38743,  483,38743,37866,38305,37456,38305,17508,38305, 9257,38305,
27149,38305, 9353,38305, 9253,38305,38253,38305,38137,38763,38237,38763,
  483,38763,38219,38305,38137,38771,  483,38771,38121,38305,38137,38777,
  483,38777,15897,38305, 4799,38305,27161,38305,20187,38305,  483,38789,
 8387,38305,  483,38793, 9541,38305,15879,38305,  483,38798, 4787,38305,
  483,38802,16125,38305,    3,38806,    2,38806,  842,38806,  843,38807,
38813,38815,  842,38807,  843,38806,38819,38821,    2,38807,38809,38825,
    3,38807,38811,38829, 5121,38305,    3,38832,    2,38832,  842,38832,
  843,38833,38839,38841,  842,38833,  843,38832,38845,38847,    2,38833,
38835,38851,    3,38833,38837,38855,35729,38305,  587,38859,  587,38858,
19384,38305,  483,38865,  669,38305, 1011,38869, 1086,38305,  483,38873,
 1418,38305, 1011,38877,25381,38305,38541,38881,38545,38881,25423,38881,
25429,38881,    7,38881,25431,38881,38547,38881,   15,38881,25415,38897,
38537,38897, 1419,38305,38525,38903,38529,38903, 1801,38903, 1875,38903,
    2,38903,23983,38903,10603,38903, 4625,38903,21893,38903,38531,38903,
21605,38903, 1421,38925,38521,38925, 1108,38305, 9565,38931,  246,38305,
  483,38935,  294,38305, 8495,38939,35931,38305,38669,38943,38309,38943,
  483,38943,36773,38942,  483,38951,19396,38305,35718,38305,37885,38957,
37202,38957,37145,38957,  483,38962,  483,38957,37145,38966,  668,38305,
    2,38971, 3507,38971, 1971,38971,21783,38971,23983,38971,10603,38971,
 4625,38971,21605,38971,  713,38987,20060,38305,  483,38991,  713,38305,
16833,38995,38011,38305,37933,38999,38021,38999,  483,38999,37285,38305,
37409,39006,36945,38305,37845,39011,37845,39010,  483,39011,37215,38305,
    3,39019,38057,39019, 9377,38305,    9,39024,10001,39027,13755,39027,
27533,39027, 1471,38305,16937,39035, 9875,38305, 1011,39039, 1347,39039,
  555,38305,20763,38305,  566,39046,  566,39047,  567,39046,39051,39053,
  567,39047,39049,39057,  257,38305,  483,39061,  973,38305, 4816,39065,
 4805,39065, 1011,39068,38057,39065, 1011,39065, 4805,39074,  628,38305,
  483,39079, 1406,38305,  587,38305,23584,39085,24355,39085,37782,39085,
37408,39084,39091,39093,37783,39085,37408,39085,38670,39085,    3,39085,
37409,39102,39093,39105,37409,39103,39099,39109,38669,39085,35187,39112,
35728,39084,23493,39085,22807,39118,22807,39085,23493,39122,35729,39084,
35728,39085,39127,39129,35729,39085,39117,39133,37409,39085,    3,39136,
39093,39139,  483,39085,35187,39142,35187,39085,38669,39146,  483,39146,
36773,39147,  483,39153, 1011,39084,  483,39157,    9,39084, 4625,39161,
10603,39161, 3507,39161, 1971,39161,23983,39161,21783,39161,21605,39161,
  713,39175,18967,39084,  483,39179,35187,39084,37202,39183,37885,39183,
37145,39183,  483,39188,  483,39183,37145,39192,37409,39084,39097,39197,
   11,39084,  483,39201, 1369,38305,35964,39204,35965,39205,39207,39209,
35965,39204,35964,39205,39213,39215,35761,39205,38057,39205,   15,39204,
 1011,39223,   11,39205, 1011,39205,   11,39204, 1275,38305,  483,38305,
35895,39234, 4787,39234,15879,39234,21405,38305, 1011,39243,  483,39243,
 7535,38305,   15,39249, 7537,39251, 7541,39251, 7545,39251,28337,38305,
21605,39259,28351,39261,28355,39261,28359,39261, 6147,38305,  483,39269,
15269,38305,  483,39273,17423,38305, 1011,39277,  483,39277, 4827,38305,
  483,39283, 4745,38305, 1011,39287,  483,39287,17232,38305,30492,38305,
25793,39295,  265,39294, 4569,38305,  483,39301,14625,38305,  483,39305,
 7063,38305,  483,39309,37284,38305,37356,38305,17233,38305,30493,38305,
  483,39319,37973,38305,37759,38305,38002,38305,38327,39327,37760,38305,
  483,39331,37976,38305,38321,39335,37617,38305,38398,39339,38319,39339,
38400,39339,38335,39339,37663,39339,38397,39348,37671,39349,38397,39339,
37663,39354,  483,39354,36773,39338,  483,39361,  483,39339,38397,39364,
37663,39338,  483,39369,37899,38305,38392,39373,38321,39373,38394,39373,
38333,39373,35187,39372,37885,39383,37933,39373,38391,39386,38391,39373,
37933,39390,  483,39390,36773,39372,37933,39397,  483,39397,  483,39373,
38391,39402,38185,38305,38150,39407,38137,39407,37145,39410,37202,39407,
37885,39407,  483,39407,37145,39418,37145,39407,38137,39422,  483,39422,
37979,38305,38451,39429,37663,38305,37409,39432,    3,39435,    7,39433,
39437,39439,    2,39439,39435,39443,  483,39433,37617,39447,37241,39432,
37617,39432,  483,39453,37933,38305,36773,39456,37977,38305,38315,39461,
37815,38305,  483,39465,38003,38305,38317,39469,38127,38305,  483,39473,
  482,38304,    5,39477,    6,39478,    6,39477,    5,39482,   14,39477,
  586,38304,39122,39489,39128,39489,39127,39489,38863,39489,38601,39489,
38948,39489,38603,39489,39150,39489,39144,39489,38783,39489,38785,39489,
    3,39489,    1,39512,38971,39515,39161,39515,    1,39489,    3,39520,
38971,39523,39161,39523,39175,39489,38987,39489,21604,39489,39161,39533,
38971,39533,39146,39489,  483,39538,39142,39489,35187,39542,38943,39489,
  483,39546,35728,39489,39085,39550,22807,39489,39085,39554,26219,39489,
 8647,39489,19396,39489,39085,39489,22807,39564,35728,39564,35187,39564,
  483,39570,  483,39564,35187,39574,35895,39489,    9,39489,18967,39580,
18967,39489,    9,39584,35187,39489,39142,39588,39085,39588,  483,39592,
  483,39588,39085,39596,  483,39489,38943,39600,39146,39600,39085,39600,
35187,39606,35187,39600,39085,39610, 4787,39489,15879,39489, 1368,38304,
 3867,39619, 8277,39619, 3997,39619, 4067,39619, 9459,39619, 8953,39619,
 1274,38304,27979,39633,14625,39633, 4569,39633,16381,39633,13325,39633,
26293,39633, 8685,39633,35843,39633, 1369,39633,19513,39633, 3863,39633,
37019,39633, 9955,39633,37377,39633, 8401,39633,10273,39633,20697,39633,
 4137,39633,20219,39633, 4063,39633,35895,38305,  483,39674,35915,38305,
    3,39678,    2,39678,  842,39678,  843,39679,39685,39687,  842,39679,
  843,39678,39691,39693,    2,39679,39681,39697,    3,39679,39683,39701,
  482,38305,39616,39705,39614,39705,39578,39705,35718,39705,35895,39705,
39489,39714,39489,39705,15879,39718, 4787,39718,35895,39718,15879,39705,
39489,39726, 4787,39705,39489,39730,35187,39705,  587,39734,  587,39735,
39489,39739,  587,39705,35187,39742, 1368,38305,  587,38304,39241,39749,
39239,39749,39237,39749,38599,39749,38597,39749,38633,39749,38631,39749,
39677,39749,38801,39749,38805,39749,38679,39749,  483,39771,39235,39749,
15879,39775, 4787,39775,35895,39775,  483,39748,38679,39783,  483,38304,
38121,39787,38219,39787,38253,39787,37899,39786,38731,39795,37617,39786,
38713,39799,38011,39787,38185,39787,37145,39805,14625,39787, 4569,39787,
19396,39787,35931,39787,39489,39815,15269,39787, 4827,39787,  587,39786,
38679,39823,37899,39787,38391,39827,37617,39787,38397,39831,17423,39787,
 4745,39787,    9,39787,18967,39838,18967,39787,    9,39842,  587,39787,
39588,39847,39489,39847,35187,39850,35187,39847,39489,39854,35187,39787,
  586,39858,39823,39861,  586,39859,39847,39865,  586,38305,39713,39869,
38861,39869,39737,39869,39745,39869,38675,39869,35187,39879,39823,39869,
35187,39883,39783,39869,35187,39887, 1108,39869,  295,39869,35927,39869,
37611,39869,38155,39869,35719,39869,39705,39901,39749,39869,22807,39905,
35728,39905,35187,39905,  483,39910,  483,39905,35187,39914,35187,39868,
39823,39919,39783,39919,38675,39919,39749,39919,  483,39927, 1011,39869,
    9,39930,    9,39869, 1011,39934, 1369,38304, 1275,39938, 1275,38304,
39429,39943,23023,39943,22605,39943,25483,39943,22677,39943, 1369,39942,
  803,38305,17455,39956,13737,39957,39705,39961, 1505,38305,21605,39965,
  713,39967,  305,39967, 1489,39967, 1509,39967,   25,39967,15705,38305,
  767,39979,39705,39981,17455,38305,   15,39985, 9513,39987,16859,39987,
17469,39987,  803,39984,  154,38305,  165,39997,  374,38305,   11,40001,
   66,38305,  340,38305,30091,40006,27978,38305,39633,40011,23755,40011,
27805,40011,26331,40011,25793,40011, 8495,40011,  511,38305,   11,40025,
  935,38305,  483,40029, 1109,38305,   11,40033,  295,38305,  256,38305,
  375,40039, 9805,40039,20762,38305, 1141,40045, 1447,40045,   33,40045,
   88,38305,11251,40053, 5177,40053,  136,38305,36727,40059,37895,40059,
36079,40059,  144,38305,  113,40067,  341,38305,  113,40071,16937,40071,
27979,38305,38411,40077,  483,40077,39943,40077, 9565,40077,  113,38305,
 4727,40087,    9,40089,37662,38305,37241,40093,37932,38305,36773,40097,
37782,38305,37978,38305,39633,40103,38389,40103,  305,38305,16833,40109,
   25,38305,16833,40113,20501,38305, 1011,40117, 1347,40117,  253,38305,
16937,40123,   53,38305,16937,40127,  251,38305,   21,38305,38004,38305,
    7,40135,37241,38305,    6,40138,    2,40141,35187,40142,35187,40141,
    2,40146,    2,40147,38056,40141,37663,40138,    3,40138,40145,40157,
40149,40157,40153,40157,    3,40139,40151,40165,40093,40165,36773,38305,
37933,40171,37899,40173,37933,40170,35931,40170,  483,40179,37617,40170,
  483,40183,37899,40170,37933,40187,  483,40187,37409,40170,    3,40193,
  483,40171,35931,40197,37617,40197,37899,40197,    6,40170,37844,40205,
    3,40205,35187,40208,35187,40205,    3,40212,    7,40171,40207,40217,
40211,40217,40215,40217,40195,40217,    2,40217,40193,40227,37845,40217,
40205,40231,37845,40170,    7,40235,37325,38305,    7,40238,    2,40241,
    2,40240,    7,40239,35187,40247,    3,40249,    3,40248,    3,40247,
35187,40254,    3,40246,37844,40247, 1368,40238,  586,40239, 1369,40238,
37845,40238,40259,40269,40265,40269,  587,40239,    2,40238,    7,40276,
40251,40277,    3,40238,40243,40283,35187,40282,40275,40287,    3,40239,
40279,40291,40245,40291,40269,40291,    7,40290,40269,40299,40263,40291,
    2,40239,40287,40305,40257,40305,40253,40305,40261,40305,40267,40305,
10219,38305,    7,40316,    2,40318,    2,40319, 1368,40316, 1369,40316,
    2,40317,40327,40329,    3,40317,40321,40333,40325,40333,    2,40316,
    7,40338,40333,40341,    3,40316,40323,40345,  413,38305,    7,40349,
  375,40349, 1217,38305,  483,40355, 1216,38305,    7,40359,  412,38305,
  483,40363,36348,38305,    2,40366,36429,40369,38233,38305,    7,40373,
25296,38305,    7,40377,  265,38305,27978,40381,30492,40380,   17,40380,
 8495,40387,    6,40380,   11,40391,    7,40380,30091,40394,    7,40381,
27021,40399, 9195,40399,40391,40399,40001,40399,21605,40398,    6,40381,
40395,40411,40007,40411,   17,40411,21605,40381,    7,40418,   17,40419,
  241,40380,  483,40425,21605,40380,    7,40429,30091,40380,    7,40432,
   11,38305,18967,40436,  483,40439,  587,40436,  483,40443, 1369,40436,
  483,40437,  587,40449,    3,40436,    3,40437, 9875,40455,20501,40455,
 1011,38305,  483,40461,  587,40463,  587,40460,  483,40467,    9,40460,
 9565,40471,    7,40461,  959,40475,  759,40475,   47,40475,  903,40460,
    7,40483,   15,38305, 1369,40486, 1011,40489,  241,40486,  483,40493,
    3,40486,  165,40497,    3,40487,  253,40501, 1471,40501,   53,40501,
21605,38305,27533,40509,   15,40509,31103,40513, 1275,40509,    7,40508,
23755,40519,39633,40519,27805,40519,26331,40519,25793,40519, 8495,40519,
    7,40509,26219,40533,  305,40533,   25,40533,  713,40533,  265,40509,
31103,40543,  265,40508,    7,40547,25367,38305,    6,40551,    7,40551,
    6,40550,40555,40557,    7,40550,40553,40561,   17,38305,19917,40565,
  587,40565,  265,40564, 8495,40571,  265,40565, 8861,40575,    3,40564,
  113,40579,    3,40565,10109,40583,10108,40583,10108,40582,40585,40589,
10109,40582,40587,40593, 1141,40583, 1447,40583,   33,40583,  903,38305,
    7,40603, 1141,40605, 1447,40605,   33,40605, 1011,40602,    7,40613,
18967,38305, 1108,40617, 1072,40617,  165,40617, 1291,40617,  524,40617,
    9,40617, 1011,40628,   11,40616,  483,40633,   11,40617,  483,40636,
  483,40617,   11,40641, 1011,40640,  587,40641,   11,40640,    9,40616,
  587,40616,  483,40653,    7,40616, 1141,40657, 1447,40657,   33,40657,
 1011,40617,21183,40665,    7,40665,  483,40664,    9,40664,  241,38305,
  483,40675,   15,40674,  483,40679,    9,40675,    7,40674,  375,40685,
 9805,40685,    7,40675,  265,40691,   59,40691,  331,40691, 1325,40691,
  265,40674,  483,40701,    9,38305, 7963,40704, 7961,40707,27995,40704,
27533,40711,17573,40704,10001,40715,13755,40705, 9377,40719,    1,40704,
    3,40723,    1,40724,40705,40727,    7,40724,40729,40731,    7,40723,
    3,40734,  586,40723,    6,40704,    3,40741,    6,40742,40705,40745,
    0,40742,40747,40749,    0,40741,    3,40752,21604,40704,    3,40757,
    7,40758,    7,40757,    3,40762,  586,40757, 1274,40704,    3,40769,
    0,40770,    0,40769,    3,40774, 9377,40704,27533,40779,10001,40779,
13755,40779,10001,40705,17573,40787, 9377,40787,27533,40705,27995,40793,
 9377,40793,21605,40705,26715,40799,26865,40799,40761,40799,40765,40799,
40731,40799,40737,40799,    6,40799,26719,40799,40739,40799,40767,40799,
  587,40799,26625,40821,40723,40821,40757,40821, 1275,40705, 1991,40829,
 3621,40829,40773,40829,40777,40829, 5299,40829,40749,40829,40755,40829,
    1,40829, 4907,40829,17711,40829, 1011,40704, 9565,40851,  587,40704,
39515,40855,39523,40855, 3507,40855, 1971,40855,    0,40855,40829,40865,
40845,40855,21783,40855,23983,40855, 4625,40855,10603,40855,39533,40855,
21605,40855,  713,40881,39489,40881,18967,40704, 1011,40705,18967,40889,
 9617,40889,    2,40704,36727,40895,37895,40895,36079,40895,    3,40704,
11251,40903, 5177,40903,    2,40705,36729,40909,    3,40705,11355,40913,
30748,38305,    7,40916,17125,38305,    7,40920,30091,38305,  340,40924,
    7,40924,25793,40929,  265,40928, 1011,40925,    7,40935,  265,40925,
    7,40939,  265,40924,    7,40942,14315,38305,31103,40947,  375,40947,
    7,40947, 8495,40953,37845,38305,37897,40957, 1275,40957,36945,40956,
    6,40957,    7,40957,    6,40956,40967,40969,36773,40969,    7,40956,
38389,40975,39633,40975,40965,40975,36773,40956,    7,40983,37409,38305,
37285,40986,  113,40987,    2,40987,39313,40993,40157,40993,    3,40987,
39439,40999,40217,40999,    2,40986,38305,41005,    7,41007,40999,41009,
40165,41005,37241,41005,    3,40986,    3,38304,40375,41019,40237,41019,
40985,41019,40137,41019,40963,41019,39015,41019,38749,41019,40098,41019,
39323,41019,40972,41019,40989,41019,39009,41019,38751,41019,40094,41019,
39325,41019,41014,41019,15567,41019,12971,41019,13355,41019,13541,41019,
21049,41019,21242,41019,39127,41019,39714,41019,39739,41019,38603,41019,
38601,41019,38863,41019,39726,41019,39730,41019,20956,41019,20773,41019,
38783,41019,38785,41019,11970,41019,19441,41019,19656,41019, 4696,41019,
    5,41019,    6,41097,27169,41019,27168,41019,33465,41019,40011,41019,
30492,41019,40519,41019,39295,41019,30493,41019,40929,41019,  357,41019,
  367,41019,  471,41019, 1249,41019,  628,41019,20057,41019, 4569,41019,
14625,41019, 4545,41019,36203,41019,36343,41019,40953,41019,21183,41019,
20103,41142,13325,41019, 8337,41147, 4549,41019, 9357,41019, 9356,41019,
40966,41019,36026,41019,37558,41019,36226,41019,36944,41019, 8386,41019,
20186,41019, 9083,41019, 9484,41019,36027,41019,37559,41019,36227,41019,
36945,41019, 8387,41019,20187,41019,19513,41019,35843,41019,20219,41019,
 8401,41019,37019,41019,20697,41019, 4137,41019, 9955,41019, 3863,41019,
 4063,41019,37377,41019,10273,41019,21405,41019,20606,41019, 9984,41019,
37215,41019,40969,41019,36773,41218,40975,41019,40097,41019,36773,41224,
40103,41019,37979,41019,19396,41019,11131,41019,21059,41019, 9082,41019,
28205,41019,25551,41019,24613,41019,20326,41019,21087,41019,39705,41019,
35895,41250,15879,41250, 4787,41250,11949,41019,    9,41258, 4669,41019,
    9,41262,15879,41019,39705,41266, 4787,41019,39705,41270,20805,41019,
37501,41019,19631,41019,    9,41278,35895,41019,39705,41282, 9704,41019,
40387,41019,38939,41019,40033,41019,40571,41019,20804,41019,  341,41019,
  241,41299,27979,41019,  241,41303, 9377,41019,   11,41306,  256,41019,
35187,41310,  257,41019,35187,41315,20763,41019,   11,41318, 4745,41019,
17423,41019,  587,41019,   11,41326,37409,41326,37500,41019, 9875,41019,
   10,41334,   10,41335,   11,41334,41339,41341,   11,41335,41337,41345,
 1471,41019,37325,41019,  587,41351,37241,41019,40093,41354,41005,41354,
37408,41019,  241,41360,41005,41019,37241,41364,40093,41019,37241,41368,
20885,41019,20413,41372, 1369,41019,37409,41377,37409,41019,  241,41381,
  587,41380,40967,41019, 9195,41019,   11,41388,20413,41019,20885,41392,
10219,41019,  587,41397,20501,41019,   10,41400,   10,41401,   11,41400,
41405,41407,   11,41401,41403,41411,  253,41019,    6,41019,40373,41417,
40135,41417,40235,41417,40983,41417,40967,41417,27021,41417,40533,41417,
30091,41417, 4713,41417,16363,41417, 4863,41417,13119,41417,26415,41417,
 8757,41417,23493,41417,27377,41417, 4213,41417, 9195,41417,39489,41417,
 9335,41417, 4147,41417, 3933,41417, 8109,41417,36212,41417,36773,41417,
20103,41417, 8337,41417,37145,41417, 8997,41417,40957,41417,  241,41417,
35187,41478,18967,41417,   11,41483,35187,41417,  241,41486,  587,41487,
  587,41417, 8387,41417,20187,41417,14653,41417,36945,41417,    7,41019,
30091,41502,26331,41503, 8717,41503,23755,41503,27805,41503, 3785,41503,
40957,41502,36212,41502,39633,41503,10055,41503, 4329,41503, 4311,41503,
10351,41503,36773,41502,20103,41502, 8337,41502, 8997,41502, 1275,41503,
   15,41503,18967,41541,35187,41502,  241,41544,  241,41502,35187,41548,
27021,41019,   11,41552,   53,41019,    6,41018,41165,41559,41531,41559,
41517,41559,41157,41559,40975,41559,40103,41559,41537,41559,41169,41559,
41167,41559,41239,41559,41533,41559,41535,41559,40011,41559,27979,41559,
40519,41559,41549,41559,41311,41559,16381,41559,13325,41559,26293,41559,
 8685,41559,41361,41559,41545,41559,41503,41559,36773,41607,40957,41607,
 8997,41607,20103,41607, 8337,41607,  241,41607,35187,41607, 1369,41559,
 4569,41559,35843,41559,19513,41559, 3863,41559, 9955,41559, 4063,41559,
37377,41559,10273,41559,20697,41559, 4137,41559,37019,41559,20219,41559,
 8401,41559,14625,41559,    7,41018,41181,41653,41466,41653,41387,41653,
41476,41653,41474,41653,41185,41653,41183,41653,41171,41653,41468,41653,
41470,41653, 8997,41653,41417,41674,41315,41653,41478,41653,26219,41653,
 8647,41653,41381,41653,41486,41653,19396,41653,41417,41653,36773,41692,
40957,41692, 8997,41692,20103,41692, 8337,41692,  241,41692,35187,41692,
20103,41653,41417,41708, 8337,41653,41417,41712,36773,41653,41417,41716,
  483,41653,    9,41653,18967,41722,  241,41653,    1,41727,41417,41729,
41417,41726,18967,41653,    9,41734,40957,41653,41417,41738,35187,41653,
41417,41742,   11,41019,27021,41746,  587,41746, 9195,41746,20501,41746,
 9377,41746, 9875,41746,20763,41746,    9,41019, 4669,41762,11949,41762,
19631,41762,18967,41762,20273,41762, 9617,41762,   17,41019,20762,41776,
20762,41777,20763,41776,41781,41783,20763,41777,41779,41787,40957,41019,
    6,41790,    7,41790,41559,41795,    6,41791,41795,41799,    7,41791,
41793,41803,41417,41803, 9617,41019,    9,41808,36212,41019,    7,41812,
35187,41019,  256,41816,    7,41816,  241,41820,41559,41821,    7,41817,
41417,41827,  241,41816,    7,41830,  241,41019,    1,41835,    7,41837,
41559,41839,    7,41836,41417,41843,37408,41834,    7,41835,    1,41848,
41417,41851,41417,41849,    7,41834,41559,41857,35187,41856,35187,41834,
    7,41862,18967,41019,  483,41867,    9,41866,30091,41019,    7,41872,
14315,41019, 8997,41019,    7,41878,41559,41881,    7,41879,41417,41885,
20273,41019,    9,41888, 8337,41019,    7,41892,41559,41895,    9,41893,
  483,41893,    7,41893,41417,41903,20103,41019,21183,41906,    7,41906,
41559,41911,    9,41907,  483,41907,    7,41907,41417,41919,36773,41019,
40097,41922,40969,41922,    7,41922,41559,41929,    9,41923,  483,41923,
    7,41923,41417,41937,    2,38304,38595,41941,40177,41941,39459,41941,
38591,41941,38593,41941,40155,41941,39451,41941,38589,41941,39237,41941,
39241,41941,39239,41941,38599,41941,38597,41941,38633,41941,38631,41941,
26777,41941, 9741,41941,26781,41941, 9745,41941,39677,41941,38801,41941,
38805,41941,    5,41941,    6,41986,38881,41989, 9771,41941,   14,41941,
38881,41995,38897,41941,30349,41941,26857,41941,26933,41941, 9777,41941,
40077,41941,31598,41941,35931,41941,37519,41941,35690,41941,40651,41941,
38955,41941,40887,41941,39235,41941,35895,42025,15879,42025, 4787,42025,
 8982,41941,  668,41941,26625,42035, 9731,42035, 1419,41941, 9731,42041,
26625,42041,40471,41941,38931,41941,40037,41941,40851,41941,37617,41941,
37899,41941,39457,41941,36773,42059,39429,41941,27021,41941,  375,41941,
35187,42066,31103,41941,26625,42070, 9195,41941,  483,41941,39433,41941,
37241,42079,  587,41941,    1,42083,35187,42083,    9,42082, 9731,42089,
26625,42089,    6,41941,    2,42095,21605,42097,38305,42099,    5,42094,
38881,42103,42101,42103,    2,42094,38305,42109,    7,41940, 9459,42113,
 8953,42113, 3997,42113, 4067,42113, 8277,42113, 3867,42113,    9,41941,
  587,42126, 9731,42129,26625,42129,   17,41941, 8861,42134,26625,41941,
31103,42138, 8861,41941,    7,42143,   17,42142,35187,41941,  375,42148,
 9731,41941,    7,38304,39023,42155,41231,42155,25445,42155,    1,42155,
    2,42162,    3,42162,38903,42167,38971,42167,39161,42167,40855,42167,
18967,42167,    2,42163,    3,42163,    5,42155,    2,42182,    3,42182,
    2,42183,42187,42189,    3,42183,42185,42193,21604,42155,18967,42197,
39161,42197,38971,42197,38903,42197,40855,42197,39175,42155,38987,42155,
40881,42155,38925,42155,22779,42155,22243,42155,28063,42155,41303,42155,
31598,42155,25299,42155,  357,42155,  367,42155,  471,42155, 1249,42155,
35690,42155,37519,42155,  272,42155, 1476,42155,  280,42155,  949,42155,
 1517,42155,40387,42155,40571,42155,40033,42155,38939,42155,21087,42155,
20326,42155, 9704,42155, 9304,42155,35931,42155,40998,42155,  253,42155,
  265,42270,  375,42155,35187,42274,31103,42155,26625,42278,25381,42155,
10081,42283,41417,42155, 1369,42287,26625,42155,31103,42290, 9617,42155,
    9,42294,   53,42155,  265,42298,20273,42155,    9,42302,37899,42155,
37617,42155, 1471,42155,  265,42310,  587,42155,35187,42315,38233,42155,
38004,42155,36773,42155,37845,42322,38056,42155,39019,42327,37145,42327,
37844,42155,40305,42333,37933,42155,  483,42155,37845,42155,36773,42340,
40999,42155,  305,42155,21605,42347,  713,42155, 9195,42350,21605,42351,
 9195,42155,  713,42356,    2,42155,    1,42360, 8229,42361,40987,42361,
35187,42361,36773,42369,35187,42360,39019,42373,37145,42373,    3,42155,
42179,42379,    1,42379,    7,42379,   15,42385,38305,42387,    1,42378,
38903,42391,38971,42391,39161,42391,40855,42391,18967,42391,42389,42391,
    7,42378,40704,42405,42391,42407,    9,42405,38305,42410,42391,42413,
38305,42405,    9,42416,42391,42419,40987,42378, 1369,42379,35187,42378,
40305,42427,   25,42155,21605,42431,    2,42154,    1,42435,42379,42436,
42382,42435,42423,42435,42269,42435,42333,42435,42427,42435,42379,42435,
    1,42450,40987,42451,35187,42451, 3997,42435, 4067,42435, 9459,42435,
 8953,42435, 8277,42435, 3867,42435,    3,42154,42165,42471,42363,42471,
42345,42471,42366,42471,26219,42471, 8647,42471,42341,42471,42368,42471,
19396,42471,42361,42471,    1,42491,40987,42490,35187,42490,41417,42471,
  483,42471,18967,42471,    9,42502,    9,42471,18967,42506,40987,42471,
42361,42510,35187,42471,42361,42514,32805,42155,  265,42155,  253,42520,
 1471,42520,   53,42520,40987,42155,    3,42528,42435,42531,    3,42529,
42361,42535,35187,42155,    7,42539,38305,42541,    2,42543,    2,42542,
    2,42541,38305,42548,    2,42540, 1368,42539,  375,42538, 1369,42539,
    2,42538,39019,42561,38305,42560,42559,42565,37145,42561,    3,42538,
40305,42571,42545,42571,42435,42571,    3,42539,40277,42579,39315,42579,
    7,42579,38305,42585,42561,42587,42551,42579,42547,42579,42561,42579,
42361,42579,    2,42539,    7,42598,42571,42599,37845,42599,    9,42155,
20273,42606, 9617,42606,    6,38304,40509,42613,31103,42615,21604,42613,
40471,42613,40851,42613,40037,42613,38931,42613, 8982,42613,27979,42613,
  483,42631,41941,42631,40957,42613,37933,42637,41503,42613,  483,42641,
 8861,42613,   17,42644,17423,42613, 1011,42649, 4745,42613, 1011,42653,
 9875,42613, 1011,42657, 1471,42613,36773,42613,  483,42663,37844,42613,
40305,42667,37979,42613,41941,42671, 1369,42613,38057,42675,  331,42613,
   17,42678, 1325,42613,   17,42682,  334,42613, 1328,42613, 8337,42613,
  483,42691,20103,42613,  483,42695,   53,42613,  393,42613, 1359,42613,
    3,42613,  483,42705,35187,42704,40305,42709,10257,42705,37357,42705,
    2,42613,   62,42613,   59,42613,   17,42720,20501,42613, 1011,42725,
  253,42613,    3,42612,40975,42731,40103,42731,27979,42731,40519,42731,
40011,42731,16381,42731,13325,42731,26293,42731, 8685,42731,41503,42731,
 1369,42731, 4569,42731,35843,42731,19513,42731, 3863,42731, 9955,42731,
20697,42731, 4137,42731,37019,42731, 8401,42731,20219,42731, 4063,42731,
14625,42731,37377,42731,10273,42731,18967,42613,  165,42783,  241,42613,
35187,42613,    3,42788,40305,42791,    3,42789,40277,42795,39315,42795,
   17,42613, 8861,42800,  331,42800, 1325,42800,   59,42800,    7,38305,
25004,42810,25005,42810,25184,42810,25185,42810,  264,42811,    5,42811,
    0,42822,    3,42822,    1,42810,    4,42829,25004,42811,42815,42833,
25184,42811,42819,42837,25005,42811,42813,42841,25185,42811,42817,42845,
41493,42811,41622,42811,25367,42810,30748,42810,39650,42811,42752,42811,
38673,42811,38675,42811,39823,42811,39783,42811,27533,42811,26625,42869,
  331,42811,35187,42873,41559,42811, 1369,42876,  767,42811,18967,42881,
41019,42811,37899,42885,37617,42885,35931,42885,27021,42885,30091,42885,
 9195,42885,25793,42811,30091,42899,27021,42899,37845,42811,42667,42905,
   59,42811,35187,42909, 1325,42811,35187,42913,37897,42811,17125,42810,
30091,42810,25793,42921,41019,42921,  265,42920, 1369,42811,30091,42929,
41559,42928,20103,42929, 8337,42929,36773,42929,42731,42928,39633,42928,
42707,42811,42704,42811,  483,42947,39633,42811, 1369,42950,39749,42811,
  483,42955, 1275,42811,  265,42810,40411,42961,30091,42960,21605,42810,
26331,42967,25793,42967,23755,42967,27805,42967,39633,42967,42731,42967,
41559,42967,41019,42967, 8495,42967,42731,42811, 1369,42986,  241,42810,
  375,42991, 9805,42991,18967,42810, 1141,42997,   33,42997, 1447,42997,
  265,42811,35187,43005, 9377,43005, 9533,43005,37145,43005,21605,42811,
34311,43015,42619,43015,26625,43015,24545,43015, 9731,43015,    2,42810,
    3,42810,    0,43028,43005,43031,  295,43029, 1108,43029,35927,43029,
38155,43029,37611,43029,    9,43029, 1011,43044, 1011,43029,    9,43048,
    2,42811,42831,43053,    5,43053,42829,43057,36256,43053,    9,43053,
35187,43062,35187,43053,    9,43066,    3,42811,    5,43070,22807,43071,
37663,43071,42613,43070,  483,43079,  241,43071,    9,43083,37845,42810,
41559,43087,38389,43087,42731,43087,39633,43087,41019,43087,42613,42811,
32805,43099,37845,43098,37845,43099,37844,43098,43105,43107,37844,43099,
43103,43111,    3,43099, 1369,43115,    3,43098,  483,43119,   15,42811,
20273,43123, 9617,43123,35187,42810,    7,43129,    2,43130,    2,43131,
38305,43129,    3,43136,43135,43139,    3,43137,43133,43143, 1368,43129,
43143,43147,   59,43129, 1325,43129,  331,43129,  265,43129,    2,43129,
    7,43158,43143,43161,    3,43129,38305,43164,43135,43167,37408,38305,
    7,43171,    2,43172,40999,43175,    2,43173,40101,43179,41017,43179,
 1368,43171,40999,43185,   59,43171, 1325,43171,  331,43171,  265,43171,
    2,43170,37783,43197,    2,43171,    7,43200,40999,43203,37617,43201,
    3,43171,38305,43208,43179,43211,    3,38305,43129,43214,43135,43217,
    1,43214, 1011,43221,42041,43221, 1418,43221,41941,43227,42035,43221,
  669,43221,41941,43233,42089,43221,42129,43221, 1369,43221,   15,43240,
41941,43243,   15,43221, 1369,43246,41941,43249,11989,43215,    9,43253,
13737,43215,    9,43257,37357,43215,10257,43215,38118,43215,38132,43215,
37544,43215,37409,43215,  483,43270,  113,43215,  587,43275,37345,43215,
37241,43214,40993,43281,40993,43215,37241,43285,    9,43215,38057,43288,
  483,43215,38057,43292,37409,43292,10289,43215,   15,43214,  165,43301,
   11,43214,    9,43214,11251,43307, 5177,43307,   17,43214,  113,43313,
   11,43215,  165,43215,    7,43214,    0,43321,    4,43322,    4,43321,
    0,43326,35186,43321,  295,43321, 1108,43321,35927,43321,38155,43321,
37611,43321,    9,43321, 1011,43342, 1011,43321,    9,43346,    7,43215,
21604,43351,    1,43351,    3,43354,    3,43351,    1,43358,   15,43351,
38305,43363,43353,43365,43357,43365,43361,43365, 1011,43363,37409,43214,
43179,43375,41941,43215,37408,43379,    7,43379,35187,43382,35187,43379,
    6,43386,    7,43386,    6,43387,43391,43393,    7,43387,43389,43397,
 1011,43215,37408,43401,    7,43401,35187,43404,35187,43401,    7,43408,
38057,43215,40097,43413,40969,43413,    7,43413,    9,43412,  483,43412,
35187,43214,40305,43425,40275,43425,38305,43425,    6,43430,43413,43433,
    6,43425,38305,43436,43413,43439,41941,43425,    6,43443,    7,43443,
    6,43442,43447,43449,    7,43442,43445,43453, 1011,43425,    7,43457,
37844,38305,42336,43461,42917,43461,42905,43461,39013,43461,40305,43461,
40275,43461,37933,43461,42155,43474,42155,43461,37933,43478,    6,43460,
41941,43461,    6,43485,    7,43485,    6,43484,43489,43491,    7,43484,
43487,43495, 1011,43461,    7,43499,    2,38305,41603,43503,41686,43503,
41825,43503,41828,43503,42541,43502,42579,43513,16936,43503,36400,43503,
36439,43519,36348,43503,    6,43523,36413,43525,    6,43522,36439,43529,
36439,43523,41744,43503,41688,43503,41605,43503,41706,43503,41620,43503,
    1,43503, 1275,43544,    4,43544,    7,43544,41417,43551,    7,43545,
39633,43555,41559,43555,42731,43555,41019,43555,    1,43502,41692,43565,
41607,43565,41653,43565,41417,43570,41417,43565,41653,43574,41502,43565,
41559,43579,41019,43565,    7,43582,41559,43585,    7,43583,41417,43589,
    7,43565,41019,43593,41653,43595,41019,43592,41559,43599,    5,43502,
21605,43603,42810,43604,42811,43605,43607,43609,42811,43604,42810,43605,
43613,43615,41692,43503,35187,43618,41607,43503,35187,43622,41360,43503,
41559,43627,41820,43503,41559,43631,41544,43503,41559,43635,35760,43503,
 8315,43503,37408,43502,37783,43643,42538,43503,42601,43647,42553,43647,
42555,43647,41742,43503,41417,43654,41486,43503,41653,43658,41417,43503,
41827,43662,41742,43662,41653,43662,35187,43668,35187,43662,41653,43672,
37783,43503,37325,43502,42795,43679,42579,43679,41502,43503,41559,43685,
35187,43687,35187,43684,41559,43691,37241,43503,37409,43695,41019,43697,
41381,43503,41653,43700, 1275,43503,    1,43704,35187,43704,    9,43705,
 9731,43711,43221,43711,43549,43711,26625,43711,  587,43503,42811,43721,
35895,43723,15879,43723, 4787,43723,41653,43503,    1,43731,41417,43733,
41381,43730,41486,43730,41417,43730,35187,43740,35187,43730,41417,43744,
    9,43502,36727,43749,36079,43749,37895,43749,41827,43503,41417,43756,
    6,43502,39616,43761,39614,43761,39578,43761,39901,43761,41282,43761,
41266,43761,41270,43761,39961,43761,39981,43761,35718,43761,39869,43781,
41019,43761,35895,43784,15879,43784, 4787,43784,15879,43761,39489,43792,
41019,43792, 4787,43761,39489,43798,41019,43798,35895,43761,39489,43804,
41019,43804,  587,43761,35187,43810,39869,43813,35187,43761,  587,43816,
39869,43819,  587,43817,39489,43823,41019,43823,39489,43761,15879,43828,
 4787,43828,35895,43828,    7,43502,    6,43503,36348,43838,36439,43841,
36348,43839,36429,43845,    7,43503,41817,43848,43817,43849,41019,43853,
    4,43849,    0,43856,43784,43859,41019,43859,43761,43862,43761,43859,
41019,43866,    0,43849,    4,43870,43784,43873,41019,43873,43761,43876,
43761,43873,41019,43880,    1,43848,41417,43885,35186,43849,43784,43889,
41019,43889,43761,43892,43761,43889,41019,43896,41816,43848,41559,43901,
41019,43848,41559,43905,35187,43907,35187,43904,41559,43911,41019,43849,
41827,43915,43851,43915,41742,43915,41653,43915,35187,43922,35187,43915,
41653,43926,35187,43848,41417,43931,41019,43930,41559,43935,41019,43931,
41653,43939,37409,43502,41354,43943,40165,43943,41019,43943,37241,43948,
37241,43943,41019,43952,37408,43503,41417,43957,37663,43957,41019,43956,
41559,43963,41019,43957,41653,43967,41816,43503,    6,43970,    7,43970,
41559,43975,    6,43971,43975,43979,    7,43971,43973,43983,41417,43983,
41019,43503,    1,43989,    7,43990,41417,43993,    7,43991,41559,43997,
37408,43988,41559,44001,37408,43989,41381,44005,    7,43989,41381,44009,
41486,44009,    1,44008,41417,44015,41417,44009,35187,44018,35187,44009,
41417,44022,    7,43988,41559,44027,35187,44029,35187,44026,41559,44033,
35187,43988,    6,44036,    7,44036,41559,44041,    6,44037,44041,44045,
    7,44037,44039,44049,41417,44049,21605,43503,    7,44055,  265,44057,
35187,43503,41692,44060,41607,44060,41502,44060,41559,44067, 1275,44060,
41653,44060,41417,44072,36945,44061,41019,44077,41417,44060,41653,44080,
    6,44061,41922,44085,43413,44085,41019,44085,36773,44090,36773,44085,
41019,44094,    7,44061,41559,44099,42731,44099,39633,44099,41019,44099,
    6,44060,44099,44109,    7,44060,41417,44113,41019,44112,41559,44117,
44085,44113,41019,44113,41653,44123,41019,44060,    6,44126,    7,44126,
41559,44131,    6,44127,44131,44135,    7,44127,44129,44139,41417,44139,
36773,44061,41417,44145,    7,44145,41019,44149,35187,43502,41217,44153,
41472,44153,29229,44153,41099,44153,36429,44153,42559,44153,41417,44153,
37145,44166,37783,44153,37214,44153,41019,44173,    7,44153,41019,44177,
37145,44179,37145,44176,41019,44183,37145,44153,41417,44186,    7,44186,
41019,44191,38056,38305,41472,44195,41217,44195,41099,44195,29229,44195,
36429,44195,42559,44195,35187,44195,    6,44209,43413,44211,41417,44195,
37145,44214,37783,44195,37214,44195,41019,44221,    7,44195,41019,44225,
37145,44227,37145,44224,41019,44231,37145,44195,41417,44234,    7,44234,
41019,44239,    6,38305,42453,44243,42493,44243,42472,44243,42439,44243,
42474,44243,42441,44243,42363,44243,42471,44256,42381,44243,42165,44243,
42471,44262,42325,44243,42330,44243,42343,44243,42321,44243,42319,44243,
42371,44243,42376,44243,42568,44243,42447,44243,42484,44243,42054,44243,
42056,44243,44171,44243,43645,44243,43960,44243,44219,44243,43201,44243,
37617,44298,43206,44243,38711,44243,43199,44243,42605,44243,40231,44243,
43677,44243,40959,44243,10586,44243,10827,44243,42594,44243,42603,44243,
42577,44243,42596,44243, 6664,44243, 6243,44243, 9780,44242,  566,44242,
  566,44243,  567,44242,44337,44339,43517,44243, 9781,44242,42012,44243,
36303,44242,36303,44243,26970,44242,26971,44242,43639,44243, 4593,44243,
 6625,44358, 3113,44243, 3023,44243, 4736,44243, 6653,44243,42518,44243,
 3251,44243,42516,44243,42486,44243,42449,44243,42496,44243,42456,44243,
19257,44243,19243,44243,43425,44242,43413,44389,40511,44243,17452,44243,
42085,44243,43707,44243,42087,44243,40961,44243,43709,44243,44071,44243,
36099,44243,36098,44242,44409,44411,36099,44242,36098,44243,44415,44417,
43605,44243,43222,44242,43223,44243,44423,44425,43222,44243,43223,44242,
44429,44431,42199,44243,24081,44243,42181,44243,42383,44243,42435,44441,
42401,44243,42177,44243,43547,44243,    5,44242,42283,44451,25380,44451,
42155,44455, 1369,44451,21605,44458,42155,44461,21605,44451, 1369,44464,
42155,44467,42373,44243,37145,44470,42561,44243,37145,44474,42579,44474,
42327,44243,37145,44480,27514,44243,42490,44243,35187,44486,42451,44243,
35187,44490,  413,44243,32805,44243,42155,44496,28547,44243,42064,44243,
42138,44243,40517,44243,40543,44243,30294,44243,38004,44243,43461,44513,
38232,44243,42155,44517,38005,44243,42155,44521,30749,44243, 9780,44243,
44345,44527,26970,44243,44355,44531, 6625,44243, 4593,44534,   33,44535,
 9781,44243,44333,44541,25005,44243,26971,44243,44353,44547,25185,44243,
25589,44243,42074,44243,42152,44243,10831,44243,   77,44243,  120,44243,
  506,44243,38041,44243, 5101,44243,16989,44243,10511,44243, 4931,44243,
 5267,44243,16981,44243,13017,44243,12705,44243,13673,44243,18391,44243,
18617,44243,14599,44243, 9366,44243,36302,44243,18217,44243,42332,44243,
42435,44599,42570,44243,42435,44603,42426,44243,42435,44607,41539,44243,
41720,44243, 9132,44243, 1216,44243,36302,44242,    3,44618,44351,44621,
30748,44243,30748,44242,44525,44627,30749,44242,44625,44631,16931,44243,
35931,44243,41941,44636,39600,44243,42500,44243,18929,44243,38669,44243,
38677,44243,17019,44243,39941,44243,39955,44243,27021,44243,  483,44656,
41941,44656,37844,44242,44351,44663,41653,44243,  483,44666,43413,44243,
43425,44671,42514,44243,42361,44674,42368,44243,42471,44678,42361,44243,
42579,44682,42514,44682,42471,44682,35187,44688,35187,44682,42471,44692,
20234,44243, 8444,44243,  567,44243,44335,44701,16937,44243,   11,44705,
 1369,44705,26625,44243,41941,44710,41941,44243,37899,44714,37617,44714,
35931,44714,27021,44714,26625,44714, 9195,44714, 9731,44714,43957,44243,
37663,44730,20103,44243,  483,44734, 8337,44243,  483,44738, 9533,44243,
 4727,44243,   25,44744,10527,44243,   25,44748, 4541,44243,38128,44243,
38057,44243,42155,44757,37145,44759,37145,44756,42155,44763,  587,44756,
37845,44243,43461,44769,36773,44771,36773,44768,43461,44775,   25,44243,
10527,44778, 4727,44778,  113,44778, 9195,44243,41941,44786,  483,44786,
37782,44243,43197,44793,43643,44793,38709,44793,17451,44243, 1011,44800,
35688,44243,36910,44243,36923,44243,37899,44243,41941,44810,37617,44243,
41941,44814,43201,44814, 9731,44243,41941,44820, 8997,44243,  483,44824,
   66,44243,   33,44829,  483,44243,27021,44832,30091,44832,  241,44832,
 9195,44832,41653,44832, 8997,44832,42471,44832,39489,44832,20103,44832,
 8337,44832,36773,44832,  903,44243, 1011,44856,18967,44243,  567,44861,
  566,44860,44863,44865,  566,44861,  567,44860,44869,44871,  241,44243,
  483,44874,42425,44243,42378,44243,42435,44881,35187,44883,35187,44880,
42435,44887, 1369,44881,36773,44243,37845,44892,43461,44895,  483,44892,
37845,44893,41019,44901,37145,44243,42327,44904,42373,44904,42561,44904,
38057,44904,42155,44913,42341,44243,42471,44916,30091,44243,  483,44920,
  113,44243,   25,44924,35187,44924,17125,44243,37663,44243,43957,44932,
39489,44243,  483,44936,39943,44243, 1369,44941,  587,44243,43215,44945,
35895,44947,15879,44947, 4787,44947,38057,44944, 8449,44243,20237,44243,
  265,44242,40399,44961,   11,44961,42471,44243,42165,44966,42363,44966,
42341,44966,42368,44966,42361,44966,35187,44976,  483,44966,35187,44966,
42361,44982,20834,44243, 1011,44243,17451,44988,35187,44988,  903,44988,
20763,44988,20763,44243, 1011,44998,  257,44243,42579,44243,42561,45004,
42361,45004,    2,44242,39616,45011,39614,45011,39578,45011,39901,45011,
41282,45011,41266,45011,41270,45011,39961,45011,39981,45011,35718,45011,
39869,45031,41019,45011,35895,45034,15879,45034, 4787,45034,15879,45011,
39489,45042,41019,45042, 4787,45011,39489,45048,41019,45048,35895,45011,
39489,45054,41019,45054,  587,45011,35187,45060,39869,45063,35187,45011,
  587,45066,39869,45069,  587,45067,39489,45073,41019,45073,39489,45011,
15879,45078, 4787,45078,35895,45078,    3,44242,36302,45087,44349,45089,
35187,45086,44351,45093,    2,44243,   14,45097,    5,45097,    6,45100,
    6,45097,    5,45104,21605,45097,38305,45109,45099,45111,45103,45111,
45107,45111,43215,45097,43325,45119,43329,45119,35895,45119,15879,45119,
 4787,45119,43331,45119,35187,45119,43321,45133,35187,45096,39313,45137,
40157,45137,43281,45137,43215,45137,37241,45145,    3,44243,42539,45148,
38305,45149,37408,45152,37408,45153,45067,45149,41019,45159,    4,45149,
    0,45163,38305,45163,    0,45162,45034,45169,41019,45169,45011,45172,
45011,45169,41019,45176,45119,45169,    0,45149,38305,45183,    4,45182,
45034,45187,41019,45187,45011,45190,45011,45187,41019,45194,45119,45187,
    0,45148,38305,45148,    1,45148,45176,45205,45194,45205,45169,45205,
45011,45210,45187,45205,45011,45214,45159,45205,45011,45205,45169,45220,
45187,45220,35186,45148,35186,45149,38305,45229,    7,45231,45220,45229,
45205,45229,45011,45236,45034,45229,41019,45229,45011,45242,45011,45229,
45205,45246,41019,45246,45119,45229,    1,45149,45165,45255,45011,45257,
45167,45255,45011,45261,    5,45149,45185,45265,45011,45267,43171,45149,
37617,45271,42538,45148,42435,45275,37409,45148,38709,45279,43197,45279,
45155,45279,43643,45279,42155,45148,42435,45289,35187,45291,35187,45288,
42435,45295, 1369,45289, 1011,45149,  483,45301,   11,45148,   33,45305,
37409,45149,45157,45309,43957,45309,   11,45149,   25,45315,35187,45315,
42155,45149,42579,45321,45151,45321,42514,45321,42471,45321,35187,45328,
35187,45321,42471,45332,45066,45149,45201,45337,45203,45337,35187,45149,
45201,45343,45011,45345,45203,45343,45011,45349,45011,45342,45201,45353,
45203,45353,45011,45149,35187,45358,45201,45361,45203,45361,35187,45148,
40217,45367,45233,45367,42155,45366,42435,45373,42155,45367,42471,45377,
37845,44242,41922,45381,43413,45381,44595,45381,44993,45381,41019,45381,
36773,45390,36773,45381,41019,45394,38056,44243,39313,45399,40157,45399,
43281,45399,43215,45399,37241,45407,37844,44243,40217,45411,42155,45410,
42435,45415,42155,45411,42471,45419,42538,44243,    3,45422,42435,45425,
    3,45423,42361,45429,42155,44243,32805,45432,37845,45432,37845,45433,
37844,45432,42435,45441,45439,45441,37844,45433,42341,45447,45437,45447,
    3,45433,42341,45453,42368,45453,42361,45453,35187,45458,35187,45453,
42361,45462,  483,45453,    3,45432,42435,45469,35187,45471,35187,45468,
42435,45475, 1369,45469,35187,45432,    3,45480,42435,45483,    3,45481,
42361,45487,   11,44243, 8861,45491,    3,45490,   33,45495,    3,45491,
  113,45499,  331,45491, 1325,45491,   59,45491,35187,44243,42490,45508,
42451,45508,38305,45508,    7,45515,    2,45517,    2,45516,    2,45515,
    7,45522, 1368,45515, 1011,45508,45381,45529,42378,45508,42435,45533,
42471,45508,42361,45536,37285,45509,41019,45541,42361,45508,42471,45544,
  113,45508,    2,45509,41354,45551,40165,45551,38305,45551,    7,45557,
41019,45551,37241,45560,37241,45551,41019,45564,    3,45509,45519,45569,
    2,45508,40157,45573,39313,45573,43281,45573,43215,45573,37241,45581,
    3,45508,40217,45585,45521,45585,45525,45585,45559,45585,45527,45585,
42155,45584,42435,45597,42155,45585,42471,45601,42155,45508,    3,45604,
42435,45607,    3,45605,42361,45611,37409,44243,43503,45615,37663,45617,
    3,45615,43201,45621,    3,45614,38709,45625,43197,45625,43643,45625,
35187,44242,    3,45632,44351,45635,35187,38305,37214,45639,    2,45641,
39019,45643,39021,45641,37286,45639,35890,45638,35891,45639,45651,45653,
35891,45638,35890,45639,45657,45659,38152,45638,38153,45639,45663,45665,
38296,45638,38297,45639,45669,45671,38153,45638,38152,45639,45675,45677,
38297,45638,38296,45639,45681,45683,37283,45639,42675,45639,37282,45639,
42674,45639,37899,45638,37885,45695,38293,45639,37885,45639,37899,45701,
44945,45639,38292,45639,44944,45639,37287,45639,38173,45638,38172,45639,
45713,45715,38303,45638,38302,45639,45719,45721,38173,45639,38172,45638,
45725,45727,38303,45639,38302,45638,45731,45733,45096,45639,45149,45639,
    7,45738,45367,45741,45097,45639,37241,45639,    2,45747,    2,45746,
  587,45746,42613,45639, 1369,45754,38271,45639, 1369,45758,44243,45639,
    2,45763,    2,45762,  587,45762,  136,45639,  137,45639, 1530,45638,
  842,45638,  669,45639, 1419,45639,  843,45639,39085,45783,45777,45783,
 1531,45639,45775,45789, 1530,45639,  843,45638,  842,45639,45795,45797,
 1531,45638,45793,45801, 1368,45639,45411,45805,40999,45805,45367,45805,
45585,45805,42613,45805,37845,45805,44243,45817,  586,45639,39847,45821,
39142,45821,39085,45821,  483,45826,37241,45821,  483,45821,39085,45832,
  586,45638,38675,45837,39823,45837,39783,45837,39749,45837,  483,45845,
 1418,45639,  668,45639,  587,45638,37885,45853,37202,45853,37145,45853,
  483,45858,  483,45853,37145,45862,  587,45639,37241,45866,44243,45866,
    9,45866,  483,45639,  587,45875,37145,45877, 1369,45639,35760,45880,
35761,45881,45883,45885,35760,45881,35761,45880,45889,45891,42613,45880,
38271,45880,   15,45880,    9,45639,    2,45900,    2,45901,  587,45900,
  265,45639,  375,45909,   15,45639, 1369,45912,    7,45639,40956,45917,
44060,45917,40957,45917,44061,45917,43502,45917,37844,45917,35187,45917,
    3,45930,43503,45930,    3,45931,45927,45937, 1369,45931,38305,45917,
    2,45942,45937,45945,37845,45942,    2,45943,45933,45951,45929,45951,
  587,45943,45149,45917,37145,45959,45227,45959,37845,45917,38305,45964,
43503,45917,35187,45968,  375,45917,45148,45917,    2,45917,40101,45977,
41017,45977,38305,45976,45937,45983,44904,45977,45569,45977,43375,45977,
39019,45977,44243,45977,37145,45994,37145,45977,44243,45998,    3,45917,
35187,46002,45951,46005,44243,46002,    3,45916,45943,46011,    7,46011,
38305,46015,45977,46017,45994,46011,45959,46011,45967,46011,45919,46011,
45949,46011,45925,46011,37241,46011,45977,46011,44243,46034,44243,46011,
45977,46038,    2,45916,45931,46043,40999,46043,45975,46043,45367,46043,
45585,46043,46009,46043,45971,46043,45921,46043,45935,46043,45923,46043,
45411,46043,42613,46043,46003,46043,44243,46069,37845,46043,44243,46073,
44243,45917,    3,46076,46043,46079,    3,46077,45977,46083,    6,45638,
45998,46087,46073,46087,45817,46087,37844,46087,46043,46095,45805,46095,
35187,46087,    3,46101,45977,46103,    3,46100,46043,46107,45805,46107,
37145,46087,45977,46112,45977,46087,37145,46116,    3,46087,35187,46120,
46043,46123,45805,46123,45917,46121,37145,46129,45917,46087,35187,46132,
    2,46135,    2,46134,38057,46132,38056,46132,    2,46133,46141,46145,
    3,46133,46139,46149,46143,46149,    2,46132,35187,46154,46149,46157,
46149,46155,    3,46132,46137,46163,46145,46163,    3,45639,    5,46169,
    6,46171,    4,46168,    0,46168,    5,46168,    1,46168,45983,46169,
45945,46169,43679,46169,45927,46169,40277,46169,45749,46169,45765,46169,
39315,46169,45905,46169,37241,46169,45977,46169,42613,46203,43848,46169,
  256,46169,    6,46169,46175,46211,46177,46211,37145,46211,    7,46169,
46179,46219,46181,46219,41019,46219,45639,46218,    2,46227,38305,46219,
46229,46231,    3,46231,46227,46235,45977,46231,43503,46218,  241,46218,
38271,46219,    7,46168,37241,46247,38057,46169,38305,46251,46211,46253,
43503,46169,    6,46256,    7,46256,    6,46257,46261,46263,    7,46257,
46259,46267,  241,46169,    7,46270,    2,45638,41472,46275,41217,46275,
46175,46275,46211,46280,46177,46275,46211,46284,46212,46275,46214,46275,
46221,46275,46223,46275,46173,46275,45930,46275,46043,46299,46045,46275,
46216,46275,46225,46275,41099,46275,46032,46275,45711,46275,46200,46275,
45745,46275,46248,46275,46245,46275,35187,46275,45917,46322,46043,46325,
45917,46323,46011,46329,45830,46275,29229,46275,45773,46275,36429,46275,
45895,46275,45897,46275,45687,46275,45693,46275,45705,46275,45707,46275,
45849,46275,45779,46275,42559,46275,45899,46275,45915,46275,45757,46275,
45761,46275,45941,46275,41417,46275,37145,46368,45821,46275,37241,46372,
46011,46275,37241,46376,46247,46275,37241,46380,45881,46275,42613,46385,
37241,46275,46011,46388,46169,46388,46247,46388,45821,46388,46211,46275,
46175,46398,46177,46398,37145,46398,37783,46275,44243,46407,45917,46275,
35187,46410,46043,46413,37214,46275,41019,46417,46218,46275,46179,46421,
46181,46421,41019,46421,    7,46275,41019,46429,37145,46431,46169,46429,
46175,46435,46177,46435,37145,46435,37145,46428,41019,46443,46169,46428,
46179,46447,46181,46447,41019,46447,37145,46275,41417,46454,46211,46454,
    7,46454,41019,46461,46169,46275,35187,46464,    6,46467,    6,46466,
38305,46465,46211,46473,38271,46464,44243,46465,38270,46464,37241,46464,
    6,46465,46477,46485,    7,46465,46471,46489,46481,46489,    6,46464,
46473,46495,35187,46494,46489,46499,46489,46495,    7,46464,46179,46505,
46181,46505,46469,46505,46485,46505,41019,46505,    2,45639,42671,46517,
39429,46517,44814,46517,44810,46517,44636,46517,37241,46516,40077,46517,
44243,46516,46003,46517,37241,46535,    9,46516,44243,46517,37617,46540,
37899,46540,35931,46540,35931,46517,44243,46548,37617,46517,44243,46552,
37899,46517,44243,46556,    7,46517,44243,46561,    7,46516,46107,46565,
46123,46565,46095,46565,40999,46565,45585,46565,45411,46565,45367,46565,
42613,46565,37845,46565,46087,46583,44243,46583,37845,46517,46211,46589,
41417,46589,    7,46589,41019,46595,    3,45638,45951,46599,45942,46599,
46011,46603,46013,46599,46066,46599,46540,46599,40305,46599,46529,46599,
45751,46599,46533,46599,45767,46599,46580,46599,46563,46599,45649,46599,
45737,46599,38305,46599,45917,46630,46011,46633,45917,46631,46043,46637,
45814,46599,45771,46599,45869,46599,45871,46599,45689,46599,45691,46599,
45699,46599,45709,46599,45851,46599,45781,46599,40275,46599,46539,46599,
45903,46599,45873,46599,45907,46599,45753,46599,45769,46599,45957,46599,
45805,46599,42613,46676,46043,46599,42613,46680,46565,46599,42613,46684,
45867,46599,37241,46689,42613,46599,46043,46692,46565,46692,45805,46692,
45917,46599,38305,46700,46011,46703,46560,46599,44243,46599,46517,46708,
    7,46599,38305,46713,46517,46715,46517,46712,41941,46599,    6,46721,
    7,46721,    6,46720,46725,46727,    7,46720,46723,46731, 1011,46599,
    7,46735,46517,46599,38305,46738,35187,46739,    6,46742,    6,46743,
44243,46738,38271,46739,38270,46739,37241,46739,    6,46739,35187,46756,
46741,46757,    7,46739,41019,46763,46747,46763,    6,46738,46763,46769,
46751,46769,    7,46738,46759,46775,46745,46775,46757,46775,46753,46775,
    6,45639,    7,45638,43214,46787,45977,46789,38305,46787,    3,46793,
46043,46795,46565,46795,45805,46795,    3,46792,45977,46803,   59,46787,
 1325,46787,  331,46787,  265,46787,    2,46787,    7,46814,46795,46817,
    3,46787,38305,46820,45977,46823,46785,46787,35187,46827,    2,46828,
    2,46829,38057,46827,38056,46827,    2,46827,35187,46838,    3,46827,
46833,46843,    2,46826,46843,46847,46835,46847,    3,46826,46841,46853,
46831,46853,46839,46853,46837,46853,    0,    6,13135,46863,13169,46864,
 4871,46863, 4893,46868,13172,46863, 4894,46863,13136,46863,13143,46877,
 4872,46863, 4879,46881,13145,46863, 4881,46863,37417,46863,38056,46888,
38057,46889,46891,46893,38057,46888,38056,46889,46897,46899,17176,46863,
17380,46863,16950,46863,17058,46863,16948,46863,17056,46863,16974,46863,
17072,46863,16996,46863,17086,46863, 3348,46863,18291,46863, 7316,46863,
 8455,46863, 8343,46863, 8353,46863,13139,46863,13175,46863,13155,46863,
13517,46863,15197,46863,15485,46863,15512,46863,15595,46863,15203,46863,
 5757,46863, 5453,46863, 5471,46863, 5455,46863, 4863,46959, 5507,46863,
12569,46863,12387,46863,12551,46966,12552,46863,16995,46863,16941,46863,
16977,46974,16978,46863,17017,46862,17016,46862,19836,46863,19857,46985,
19815,46863,    4,46988,19857,46991,    4,46989,19843,46995,27930,46863,
27895,46999,27857,46863,    4,47002,27895,47005,    4,47003,27907,47009,
36303,46862,36325,47013,27128,46863, 9136,46863,27266,46863,27163,46863,
34310,46863,34447,47025,46516,46863,46599,47029,33454,46863,33368,46863,
28027,46863,28111,46863,28117,46863,26928,46863,24253,46863,30569,46863,
30316,46863,28213,46863,26525,46863, 9137,46863,  273,46863, 1477,46863,
  281,46863,17011,46863, 5043,46863,15503,46863, 8997,47066,24558,46863,
26575,46863,41877,46863,  120,46863,   77,46863,16977,46863,16941,47080,
 9262,46863,14813,46863,26605,46863,41923,46863, 8843,46863,37131,46863,
41907,46863,26591,46863,41893,46863,37113,46863,20255,46863, 9288,46863,
 8697,46863, 9275,46863, 8784,46863,19877,46863,41867,46863,20043,46863,
21376,46863,21485,46863,19787,46863,19391,46863,19299,46863,19271,46863,
19283,46863,17010,46863, 5042,46863,36518,46863,40664,46863,17017,46863,
46983,47143, 1516,46863,  948,46863,17016,46863,46981,47151,16972,46863,
  903,47154,17070,46863, 1011,47158,17175,46863,  903,47162,17379,46863,
 1011,47166, 4213,46863,  375,47170, 8757,46863,  375,47174, 4266,46863,
16865,46863,16873,46863,16867,46863,12642,46863, 8896,46863,14740,46863,
 8355,46863,  264,47193,  265,47192,47195,47197,  264,47192,  265,47193,
47201,47203,14515,46863,14517,46863,14519,46863,20201,46863,36979,46863,
20152,46863,36898,46863,20239,46863,37095,46863,21522,46863,38266,46863,
17082,46863,  903,47228,16990,46863,16943,47233, 1011,47232,35780,46863,
29644,46863,43412,46863,15628,46863, 9044,46863,  264,47247,  265,47246,
47249,47251,  264,47246,  265,47247,47255,47257,12484,46863,12486,46863,
12488,46863,12551,46863,12387,47266,12547,46863,12633,46863,12507,46863,
12497,46863,12501,46863,13381,46863,13169,46863,13135,47282, 4893,46863,
 4871,47286,12563,46863,27255,46863,  483,47292, 9287,46863,  483,47296,
13119,46863,  264,47300,13143,47303,  264,47301,13169,47307, 4863,46863,
  264,47310, 4879,47313,  264,47311, 4893,47317, 7315,46863,  413,47320,
  264,47320,  264,47321,  265,47320,47327,47329,  265,47321,47325,47333,
14653,46863,  375,47336,16875,46863,12504,46863,19478,46863,35766,46863,
20044,46863,36534,46863,12566,46863,12391,47353,33338,46863,34447,47357,
45866,46863,46599,47361,25545,46863,40675,46863, 1413,46863,  922,46863,
 1281,46863,  247,46863,36303,46863,38299,47377,37897,47377,36335,47377,
35893,47377,20035,46863,   11,47387,   11,47386,36527,46863,  587,47392,
24545,46863,  483,47396,35761,46863,  903,47400,19475,46863, 1011,47404,
 1086,46863,  934,46863, 1216,46863,17049,47412,16937,47412, 9766,46863,
 5519,46863, 8389,46863, 8861,46863, 3345,47424,12377,47424, 8337,46863,
  375,47430, 8374,46863, 8365,46863,20169,46863,36921,46863, 8453,46863,
 4863,47443,13119,47443, 9072,46863, 9105,46863,  305,46863,12377,47452,
 9731,46863,  483,47456, 8997,46863,15503,47460,  265,47460,  265,47461,
  257,47460,  264,47469,  265,47468,47471,47473,  264,47468,  265,47469,
47477,47479,  375,47460,15029,46863,12377,47484,  375,46863,27021,47488,
30091,47488, 9195,47488, 8757,47488, 4213,47488,14653,47488,20103,47488,
36773,47488, 8337,47488, 8997,47488,  241,47488, 6578,46863,  394,46863,
  828,46863,  128,46863,  299,46863,  705,46863,  101,46863,28715,46863,
21315,47526,  165,46863,  903,47530,43215,46863,38057,47534, 1505,46863,
 1011,47538,30091,46863,  375,47542,  113,46863,   25,47546,    9,47546,
  803,46863,  483,47552,  518,46863,  504,46863,  508,46863,  645,46863,
  623,46863,  659,46863,  510,46863,  241,47568,  506,46863,    9,47572,
  244,46863,  483,47576,  265,46863, 8997,47580, 5041,47580,17009,47580,
 8861,47581,  241,46863,  265,47591, 6515,47590,  375,47590,  510,47590,
  483,47590,    9,47600,    9,47590,  483,47604, 1011,46863,16990,47608,
17070,47608,17379,47608,40617,47608,16937,47608,  903,47618, 1505,47608,
17049,47608,  903,47624,21315,47608,19475,47608,  587,47608,  903,47608,
16937,47634,17049,47634,  903,46863,16937,47641,16977,47643,17082,47640,
16972,47640,17175,47640,32805,47640,36349,47640,17049,47640, 1011,47656,
  165,47640,16937,47640,16943,47663, 1011,47662,38057,47640,35761,47640,
  483,47640,   11,47640, 1011,47640,17049,47676,16937,47676,10527,47640,
 4727,47640, 6515,47640, 6564,46863, 6685,46863,35187,47690,   11,47691,
 6515,46863,  241,47696,  903,47696,  587,47697,10761,46863,10592,46863,
 4738,46863,13857,46863,  483,47710,10527,46863,  903,47714,    9,47714,
 3345,46863,  413,47720, 8861,47720, 1369,47721,  341,47721, 3747,46863,
 1369,47731, 3689,46863, 1369,47735,17000,46863,17090,46863, 2691,46863,
 2777,46863, 2793,46863, 2831,46863, 6486,46863, 4415,46863,10493,46863,
13941,46863,10901,46863, 4727,46863,  903,47760,    9,47760, 4819,46863,
  483,47766, 6703,46863, 6623,46863, 5759,46863, 7823,46863, 7813,46863,
 7761,46863, 7705,46863, 7735,46863, 7727,46863,13904,46863,10600,46863,
 4742,46863, 4822,46863, 2875,46863, 2865,46863, 2961,46863, 2949,46863,
 2919,46863, 3645,46863, 3609,46863, 3467,46863,17102,46863,17104,46863,
 1369,47815, 5041,46863,  265,47819,  265,47818, 4919,46863,  483,47824,
17100,46863,17009,46863,  265,47831,  265,47830,17099,46863,  483,47836,
 4920,46863, 6441,46863,  483,47842,17123,46863, 3353,46863, 3691,46863,
10154,46863, 3777,46863, 2847,46863, 2881,46863, 2933,46863, 2929,46863,
 2967,46863, 5271,46863, 4923,46863, 3355,46863, 3031,46863, 3121,46863,
20819,46863,37537,46863,20952,46863,37748,46863,20885,46863,  483,47884,
37663,46863,    9,47888,11529,46863, 1010,46862,23717,47895,24522,47895,
24447,47895,23939,47900,23939,47895,24447,47904,22956,47895,23651,47909,
21605,47895,   17,47913,23939,47915,   17,47912,23651,47919,   17,47895,
21605,47923,24447,47925,21605,47922,23651,47929,  264,46862,47135,47933,
47823,47933,47835,47933,47137,47933,47587,47933,47585,47933,47465,47933,
47583,47933,47019,47933,47581,47933,17009,47953, 5041,47953, 8997,47953,
  265,46862,47063,47961,47065,47961,47055,47961, 8997,47961, 5041,47961,
17009,47961, 8495,47961,  241,47961,  241,46862,  240,46863,  265,47981,
    1,47982,    0,47982, 5521,47983, 5520,47982,47989,47991, 5520,47983,
 5521,47982,47995,47997,    0,47983,47985,48001,    1,47983,47987,48005,
  264,46863,15193,48009,15475,48009,15579,48009,13119,48008,13143,48017,
 4863,48008, 4879,48021,47972,48009,47970,48009,47821,48009,47833,48009,
13507,48009,47968,48009,47467,48009,   53,48009, 1471,48009, 8997,48009,
47961,48042,  253,48009,17009,48009,47961,48048, 5041,48009,47961,48052,
15437,48009, 8997,48057,20501,48009,47961,48009,17009,48062, 5041,48062,
 8997,48062,20219,48009,37019,48009,19513,48009,35843,48009,20697,48009,
37377,48009,13119,48009,13135,48083, 4863,48009, 4871,48087,18967,48009,
  483,48091, 1369,48009, 9875,48009, 8401,48009, 9955,48009,10273,48009,
 4137,48009, 3863,48009, 4063,48009,  241,48009,  413,46863, 3345,48112,
 7315,48112,17049,48112,16937,48112,12377,46863, 8861,48122,15029,48122,
  305,48122,  713,48122,   25,48122,  587,48123,12387,48135,   11,48123,
  257,48123,  253,48123, 1471,48123,   53,48123, 1369,48123,  257,48122,
  587,48122,12391,48153,  257,46863, 9136,48156, 9137,48156,  264,48157,
48159,48163,17827,48156,48163,48167,  413,48156,    1,48170,  264,48156,
 8997,48175,  241,48175,    1,48179,  265,48157, 8997,48183,48175,48184,
 4425,48183,48161,48183,48176,48183,48175,48183, 8997,48194, 5579,48183,
17873,48183, 1791,48183,48173,48183,48181,48183,  265,48156, 8997,48208,
48163,48211,48163,48209, 8997,48215, 8997,48156,  265,48218,48163,48221,
  265,48219,48175,48225,12377,48156,36925,46863,20177,46863, 8383,46863,
 8385,46863,   88,46863,   11,48239,37409,48239,  566,46863,27021,48245,
 9195,48245,20501,48245, 9377,48245, 9875,48245,  587,48245,20763,48245,
  653,46863,   11,48261,  289,46863,  587,48265,36349,46863,  903,48268,
40617,46863, 1011,48272,   66,46863,   33,48277,20217,46863,37017,46863,
37845,46863,38057,46863,  903,48286,43215,48286,  155,48286,21315,46863,
  483,48294, 1011,48294,28715,48294, 1347,48294, 1347,46863,21315,48304,
  155,46863,38057,48308,21378,46863,38134,46863,20103,46863,  375,48316,
36773,46863,  375,48320,  713,46863,12377,48324,   25,46863,  113,48328,
12377,48328,26625,46863,  483,48334,10107,46863,38056,48338,38056,48339,
38057,48338,48343,48345,38057,48339,48341,48349,    3,48339,    3,48338,
 9195,46863,  375,48356,27021,46863,  375,48360,   19,46863,   59,48365,
32805,46863,    4,48368,34447,48371,  903,48368,    9,48368,    4,48369,
33871,48379,   11,48368,34447,48383,45639,46863,    2,48386,46599,48389,
    2,48387,46169,48393,  587,48386,46599,48397,36256,46863,35187,46863,
 6685,48402,    9,48402,  483,46863,27255,48408,26625,48408,24545,48408,
 9287,48408,21315,48408,  903,48408, 9731,48408,13857,48408,  803,48408,
  244,48408,17049,48408, 6441,48408, 4819,48408,17099,48408, 4919,48408,
    9,48408,  241,48440,  241,48408,    9,48444,20885,48408,    5,48408,
27021,48451, 9195,48451,20501,48451, 9377,48451, 9875,48451,  587,48451,
20763,48451,    9,46863,32805,48466,10527,48466,  113,48466,  506,48466,
16937,48466, 4727,48466,  483,48466,  241,48480,  241,48466,  483,48484,
37663,48466,  265,48467,   11,48491,    3,48466,   11,48495,37409,48495,
35187,48466,19917,46863,18967,48503,    5,48504,    5,48505,21036,48503,
21037,48503,    4,48503,48509,48515,    5,48503,18967,48518,    4,48502,
48521,48523,48507,48523,48511,48523,    5,48502,48513,48531,  587,46863,
12377,48535,12551,48537,45639,48535,46275,48541,12377,48534,12391,48545,
36527,48534,45639,48534,46599,48551,  265,48535,17827,48555, 1011,48534,
   11,46863,32805,48561,34003,48563,20035,48560,32805,48560,34447,48569,
  903,48560, 1275,48561,    9,48575,    3,48560,   33,48579,    3,48561,
  113,48583,16937,46863, 1216,48586,  413,48586,21036,48586,21037,48586,
21036,48587,48595,48597,21037,48587,48593,48601,  903,48587,16941,48605,
 1011,48586,  903,48608,  903,48586,16943,48613, 1011,48612,    9,48586,
17049,46863, 1216,48620,  413,48620,  903,48620, 1011,48626, 1011,48620,
  903,48630,  483,48620,    2,48620,    3,48620, 1369,48639,    2,48621,
    3,48621,  483,48645,    2,46862,    6,48649,    4,48651,    5,48649,
    9,48655,21604,48657,21604,48656,21605,48657,48661,48663,21605,48656,
48659,48667,    5,48648,23717,48671,24522,48671,24447,48671,23939,48676,
23939,48671,24447,48680,22956,48671,23651,48685,   17,48671,21605,48689,
24447,48691,21605,48688,23651,48695,21605,48671,   17,48699,23939,48701,
   17,48698,23651,48705,   19,48649,   12,48649,    9,48649,   11,48712,
   11,48649,    9,48716,21605,48649,48652,48720,48653,48721,48723,48725,
48653,48720,48652,48721,48729,48731,    3,46862,    5,48735,    4,46862,
19975,48739,19365,48739,19221,48739,19917,48739,10107,48747,  587,48739,
    5,46862,25451,48753,42283,48753,19739,48753,    0,48753,    3,48761,
25380,48753, 7971,48765,42155,48765,  164,48753,48353,48771,20763,48753,
 1011,48775, 1010,48774,48777,48779, 1010,48775, 1011,48774,48783,48785,
    2,48753,   17,48788,48353,48791,    2,48752,23717,48795,24522,48795,
23939,48795,24447,48800,24447,48795,23939,48804,22956,48795,23651,48809,
21605,48795,   17,48813,23939,48815,   17,48812,23651,48819,   17,48795,
21605,48823,24447,48825,21605,48822,23651,48829, 1369,48753,21605,48832,
 7971,48835,42155,48835,21605,48753, 1369,48840,42155,48843, 7971,48843,
   17,48753,37844,48848,48762,48848,48763,48849,48853,48855,37844,48849,
48763,48848,48762,48849,48861,48863,37845,48848,48859,48867,37845,48849,
48851,48871,    2,48849,48355,48875,47853,48875,    2,48848,48353,48881,
    5,46863,  374,48884,  374,48885,  375,48884,48889,48891,19381,48885,
19380,48884,48895,48897,19381,48884,19380,48885,48901,48903,20812,48884,
20813,48884,20812,48885,48909,48911, 1197,48885,21604,48915,21604,48914,
21605,48915,48919,48921,21605,48914,48917,48925,  375,48885,48887,48929,
20813,48885,48907,48933,20501,48885, 1011,48937,27021,48885,  483,48941,
 9195,48885,  483,48945, 9377,48885,  483,48949, 9875,48885, 1011,48953,
  587,48885,  483,48957, 1369,48885, 1011,48961,38057,48961,20763,48885,
  483,48967,  903,48885,  375,48971,  483,48884,27021,48975, 9195,48975,
20501,48975, 9377,48975, 9875,48975,  587,48975,20763,48975,18967,48885,
  483,48991,  165,48991,    2,48884,48961,48997,    3,48884,13118,49000,
 4862,49000,13118,49001,13119,49000,49007,49009, 4863,49000, 4862,49001,
49013,49015,15193,49001,15475,49001,15579,49001,13507,49001,20501,49001,
  253,49001,15437,49001, 8997,49031,20219,49001,37019,49001,19513,49001,
35843,49001,20697,49001,37377,49001,13119,49001,49003,49047, 4863,49001,
49005,49051,  241,49001, 9875,49001,   53,49001, 1471,49001, 8401,49001,
 9955,49001,10273,49001, 4137,49001, 3863,49001, 4063,49001, 1369,49001,
18967,49001,  483,49077,    2,48885,    1,49081,    7,49082,49000,49084,
49001,49085,49087,49089,49000,49085,49001,49084,49093,49095,    7,49081,
    1,49098,49000,49100,49001,49101,49103,49105,49000,49101,49001,49100,
49109,49111,    1,49080,    7,49115,    7,49080,49001,49119,    0,49080,
49083,49123,    7,49125,49001,49127,    0,49081,49116,49131,49001,49133,
    7,49131,49115,49136,49001,49139,49001,49137,49115,49143,49115,49131,
    7,49146,49001,49149,49001,49081,    3,48885,37357,49155,  165,49155,
10257,49155,  483,49155,35187,48885,  375,49165,    9,48885,    1,49168,
    3,49171,46863,49172,46863,49171,    3,49176,    3,49177,37845,49169,
37845,49168,37844,49168,49183,49187,37844,49169,49185,49191,    2,49168,
49175,49195,49179,49195,    2,49169,49181,49201,    3,46863,49171,49204,
49195,49207,    6,49205,   11,49211,    0,49205,    0,49204,40704,49217,
38305,49217,    9,49220,    9,49217,38305,49224,    6,49204,40705,49229,
49217,49231,49219,49229,18967,49229,    4,49236,    5,49236,    5,49237,
    4,49237,46863,49244,49241,49247,46863,49237,    4,49250,49241,49253,
    4,49251,49243,49257,49227,49229,   17,49229,49223,49229,37325,49205,
  903,49267,10107,49204,48875,49271,10219,49205,  903,49275,17049,49204,
 1369,49279,   11,49205,   25,49283,    9,49283,   17,49205,  903,49289,
21315,49289,37409,49205,    9,49295, 1011,49205,  375,49299,    9,49204,
   11,49303,37409,49303,   11,49204,   33,49309,35187,49205, 1505,49313,
    4,49204,49289,49317,    5,49204,13118,49320, 4862,49320,13118,49321,
13119,49320,49327,49329, 4863,49320, 4862,49321,49333,49335,15193,49321,
15475,49321,15579,49321,13507,49321,20501,49321,  253,49321,15437,49321,
 8997,49351,37019,49321,20219,49321,35843,49321,19513,49321,37377,49321,
20697,49321,13119,49321,49323,49367, 4863,49321,49325,49371,  241,49321,
 9875,49321, 1471,49321,   53,49321, 8401,49321,10273,49321, 9955,49321,
 4137,49321, 4063,49321, 3863,49321, 1369,49321,18967,49321,  483,49397,
    4,49205,    1,49401,    7,49402,49320,49404,49321,49405,49407,49409,
49320,49405,49321,49404,49413,49415,    7,49401,    1,49418,49320,49420,
49321,49421,49423,49425,49320,49421,49321,49420,49429,49431,    1,49400,
    7,49435,    7,49400,49321,49439,    0,49400,49403,49443,    7,49445,
49321,49447,    0,49401,49436,49451,49321,49453,    7,49451,49435,49456,
49321,49459,49321,49457,49435,49463,49435,49451,    7,49466,49321,49469,
49321,49401,    5,49205,20645,49475, 1505,49475, 9935,49475,18967,49205,
    7,49483,    4,49484,    4,49485,   16,49483,   17,49483,    4,49482,
49493,49495,    5,49482,49487,49499,49491,49499,    4,49483,    7,49504,
49499,49507,    5,49483,49489,49511,    2,46863,    6,49515,   17,49517,
35187,49519,    0,49515,38305,49523,   15,49525,    0,49514,36545,49529,
49521,49529,   15,49529,    6,49514,49531,49537,36544,49537,49529,49541,
49527,49537,   11,49537,35187,49546,49529,49549,35187,49537,   11,49552,
49529,49555,45639,49514,46599,49559,45639,49515,46275,49563,17125,49515,
   16,49567,   16,49566,   17,49567,49571,49573,   17,49566,49569,49577,
17049,49514,    4,49514,    7,49583,    1,49585,  265,49583,    1,49588,
    0,49588,49587,49589,49586,49588,49595,49597,49587,49588,49586,49589,
49601,49603,    0,49589,49591,49607,    1,49589,49593,49611,    4,49515,
 1011,49615,    1,49617,    0,49617,    1,49616,49621,49623,    0,49616,
49619,49627,    4,46863,27857,49630,27895,49633,19815,49630,19857,49637,
49237,49631,49239,49641,49237,49630,49241,49645,32805,49630,34447,49649,
32805,49631,34003,49653,27857,49631,27879,49657,19815,49631,19849,49661,
    2,49630,    7,49665,    1,49667,  265,49665,    1,49670,    0,49670,
49669,49671,49668,49670,49677,49679,49669,49670,49668,49671,49683,49685,
    0,49671,49673,49689,    1,49671,49675,49693,    2,49631,  903,49697,
    1,49699,    0,49699,    1,49698,49703,49705,    0,49698,49701,49709,
    1,    7,  377,49713,48110,49712,48111,49712,49152,49712,49472,49712,
49153,49712,49473,49712,49374,49712,49054,49712,49375,49712,49055,49712,
  704,49712,  100,49712,26502,49712,41376,49712, 8808,49712,47622,49713,
47660,49713,47146,49713,47148,49713,49059,49713,49379,49713,49158,49713,
49478,49713,49061,49713,49381,49713,48998,49713,49318,49713,47224,49713,
47226,49713,48041,49713,48039,49713,47058,49713,47060,49713,47220,49713,
47222,49713,48047,49713,47056,49713,47442,49713,49349,49713,49029,49713,
49121,49713,49441,49713,47628,49713,47668,49713,48962,49713,49290,49713,
22798,49713,39074,49713,31498,49713,44616,49713,31392,49713,44494,49713,
47540,49713,47532,49713,31794,49713,44858,49713,48298,49713,48288,49713,
31924,49713,44994,49713, 8652,49713, 8535,49713,13252,49713,43989,49712,
41417,49843,30655,49712,26219,49847,26503,49712,41377,49712, 8809,49712,
26547,49712,26219,49857,41835,49712,41417,49861,  273,49712,12897,49865,
 8813,49712, 8647,49869,  376,49713,  705,49712,  101,49712,  803,49712,
  483,49879,30091,49712,26219,49883,  113,49712,    9,49887,43503,49712,
41417,49891,43215,49712,  483,49895,43214,49712,  112,49712,  802,49712,
49320,49712,49401,49905,  241,49905,49000,49712,49081,49911,  241,49911,
49081,49712,49001,49916,49001,49917,49911,49921,49401,49712,49321,49924,
49321,49925,49905,49929,49001,49712,49081,49932,  241,49932,49321,49712,
49401,49938,  241,49938,  414,49713,18391,49945,  420,49713,18391,49949,
  449,49713,18391,49953, 8808,49713,49855,49957, 8453,49713,46863,49960,
20239,49713,46863,49964,37095,49713,46863,49968,47976,49713,47593,49713,
26502,49713,49851,49977,31921,49713,47592,49713, 8495,49983,  828,49713,
49903,49987,  128,49713,49901,49991,  705,49713,49737,49995,  101,49713,
49739,49999,47977,49713, 8495,50003,47488,49713,48122,49713,48480,49713,
48440,49713,47568,49713, 1344,49713, 1482,49713,   64,49713, 1484,49713,
  336,49713, 1480,49713,  254,49713, 1342,49713,  338,49713, 1123,49713,
  931,49713,  665,49713, 1417,49713, 1429,49713, 1301,49713, 1127,49713,
  941,49713,  523,49713, 1283,49713,  939,49713, 1103,49713,  171,49713,
 1525,49713,  407,49713, 1517,49713,  949,49713,  280,49713, 1476,49713,
  272,49713, 1017,49713, 1077,49713, 1047,49713, 1113,49713, 1245,49713,
 1237,49713,  501,49713,  433,49713,  929,49713,  591,49713,  915,49713,
  681,49713, 1555,49713,  911,49713, 1545,49713,  855,49713,41376,49713,
49853,50107, 4900,49713,14622,49713,48113,49713, 8997,50115, 1382,49713,
  695,49713,48286,49713,  903,50122,48294,49713, 1011,50126,26503,49713,
49741,50131,47530,49713,  903,50134,47538,49713, 1011,50138,49289,49713,
49317,50142,  903,50142,48961,49713,48997,50148, 1011,50148,21522,49713,
46863,50154,38266,49713,46863,50158,  394,49713,  299,49713,31792,49713,
  903,50166,44856,49713, 1011,50170,22789,49713,  903,50174,39065,49713,
 1011,50178, 1386,49713,  545,49713,41377,49713,49743,50187,  413,49712,
 8647,50191,18062,50191,17993,50191,  251,50196,  251,50191,17993,50200,
46863,50191,  412,49712,48008,49713,50207,50209,49717,50209,  341,50209,
40381,49713,   17,50217,  913,49713,  483,50221,  289,49713, 8809,49713,
49745,50227,49000,49713,49935,50231,49919,50231,49721,50231,49731,50231,
49937,50231,49933,50231,49081,50243,  241,50243,49320,49713,49941,50249,
49927,50249,49723,50249,49729,50249,49943,50249,49939,50249,49401,50261,
  241,50261, 1374,49713, 8672,49713,12534,49713,12921,49713,  264,50273,
  265,50272,50275,50277,  264,50272,  265,50273,50281,50283, 8605,49713,
26097,49713,41299,49713,26277,49713,41479,49713,26104,49713,41314,49713,
 1477,49713,46863,50300,  281,49713,46863,50304, 1516,49713,46863,50308,
  948,49713,46863,50312,44988,49713,  903,50316,31920,49713, 1011,50320,
43293,49713,49895,50325,15156,49713,  264,50329,  265,50328,50331,50333,
  264,50328,  265,50329,50337,50339, 8916,49713,14623,49713, 8495,50345,
 4901,49713, 8495,50349,14611,49713,  241,50352, 4899,49713,  241,50356,
15219,49713,  412,50360,  413,50361,50363,50365,  412,50361,  413,50360,
50369,50371, 5119,49713,  412,50374,  413,50375,50377,50379,  412,50375,
  413,50374,50383,50385,13177,49713,  413,50388,  264,50388,  264,50389,
  265,50388,50395,50397,  265,50389,50393,50401, 5313,49713,12377,50404,
47591,49713,  265,50409, 8861,50411,  265,50408, 8495,50415,47641,49713,
43292,49713,49899,50421,15158,49713,39228,49713,23012,49713,40676,49713,
25546,49713,  500,49713,18391,50435,  432,49713,18391,50439, 1244,49713,
18617,50443, 1236,49713,18617,50447, 1109,49713,  903,50451, 1412,49713,
  305,50455,44832,49713,31770,49713,25545,49713,    9,50462,40675,49713,
  483,50466,  935,49713,  483,50471, 1087,49713,    9,50475, 1413,49713,
  295,49713, 1290,49713,  903,50483, 1304,49713,    9,50487,48009,49713,
50191,50491,49719,50491,  241,50491,22957,49713,  903,50498,39205,49713,
 1011,50502,47608,49713, 1505,50506,21315,50506,47640,49713,  165,50512,
38057,50512,  510,49713,46863,50518,  922,49713, 1108,49713, 1280,49713,
    9,50527,  246,49713,  483,50531,  412,49713,47460,50535,  483,50535,
    9,50535, 8997,50535,46863,50542,46863,50535, 8997,50546, 1216,49713,
44243,50550,31103,50550,  483,50550,18617,50557,    9,50550,18617,50561,
 8677,49713,  305,49713,  241,50567,16163,50567, 8647,50566, 8495,49713,
  257,50574, 1141,49713,16531,50579,  253,49713,   59,50582, 1325,50582,
  331,50582,  265,50582, 8634,49713, 8611,49713,41349,49713,26127,49713,
  273,49713,12705,50601,13673,50601,18391,50601, 2923,50601,46863,50600,
  331,49713,   53,50612, 1471,50612,  253,50612, 1369,50612, 8861,49713,
  241,50623,  375,50625,  375,50622,  251,49713,  413,50631,17993,50633,
  413,50630,18391,50637,15029,50630,  264,50641,  265,50640,50643,50645,
  264,50640,  265,50641,50649,50651,39204,49713,  257,49713,  265,50657,
26625,50657,25793,50657,41019,50657, 8495,50657, 9731,50657,25793,50656,
41019,50656, 8495,50656,  265,50656, 4863,50677,12377,49713,46863,50680,
 5313,50680,  341,49713,  241,50687,  298,49713, 4863,50691,  704,49713,
49875,50695, 9195,50695,  100,49713,49877,50701,  395,49713,  829,49713,
49879,50707, 9195,50707,  129,49713,49887,50713,   89,49713,48884,50716,
48884,50717,48885,50717,50719,50723,48885,50716,50721,50727,   11,50716,
  567,49713,42155,50733,41941,50733, 7971,50733, 9565,50733,  587,50733,
 9377,50743,  587,50732, 9195,50747,38057,49713,47640,50750,46863,50750,
  903,50754,  903,50750,46863,50758,21315,49713,47608,50762,46863,50762,
 1011,50766, 1011,50762,46863,50770,  628,49713, 1396,49713,  241,50777,
  288,49713, 7971,50781,  265,49713,23584,50785,39564,50785,24355,50785,
39905,50785, 5520,50785,  256,50784,50795,50797, 5521,50785,  256,50785,
50204,50785,   10,50784,    1,50785,  257,50808,50797,50811,  257,50809,
50803,50815,   10,50785,50191,50785,46863,50820,47590,50784,23493,50785,
22807,50826,39489,50785,39085,50830,22807,50785,23493,50834,39085,50785,
39489,50838, 1087,50785,  935,50785,47591,50784, 8495,50847,47590,50785,
50847,50851, 4213,50785, 8757,50785,26415,50785,41653,50785,27377,50785,
 9335,50785,42471,50785, 8109,50785, 4147,50785, 3933,50785,   53,50784,
 1471,50784,  253,50784,47591,50785,50825,50881,  257,50785,    1,50884,
50797,50887,50797,50885, 4827,50885,  305,50785, 8861,50895, 8495,50785,
  331,50899,46863,50785,50191,50902,  241,50902,  241,50785,46863,50908,
 8337,50909,46863,50913, 1369,50784,  305,50917,   11,50785,50807,50921,
 8165,50921, 1369,50921,  241,50784,47460,50929,  483,50929,    9,50929,
 8997,50929,46863,50936,46863,50929, 8997,50940,  257,50784,50801,50945,
50803,50945, 4863,50945,   11,50784,50819,50953, 7971,50953, 1011,49713,
31920,50958,48294,50958,44856,50958,47538,50958,48961,50958,39065,50958,
21315,50958,46863,50972,31103,50958,  903,50976, 1505,50958,46863,50980,
44243,50958,  903,50984,39205,50958,    9,50958,  903,50958,31103,50992,
44243,50992,46863,50958,21315,50998, 1505,50998,  903,49713,44988,51004,
48286,51004,31792,51004,47530,51004,49289,51004,22789,51004,38057,51004,
46863,51018,44243,51004, 1011,51022,  165,51004,46863,51026,31103,51004,
 1011,51030,22957,51004,  483,51004, 1011,51004,44243,51038,31103,51038,
46863,51004,38057,51044,  165,51044,  241,49713,47961,51050, 4899,51050,
14611,51050,  375,51050,12377,51051,  375,51061, 8997,51051,  375,51065,
  265,51065,46863,51069, 1275,51050,    9,51073,   15,51050,  483,51077,
  265,51050,47460,51081,  483,51081,    9,51081, 8997,51081,46863,51088,
46863,51081, 8997,51092, 8647,49713,  413,51096,  305,51097,   11,51097,
 1369,51097,  341,51097,  305,51096,41417,49713,   11,51111, 1369,51111,
26219,49713,   11,51117, 1369,51117,32102,49713,27021,51123,45148,49713,
   11,51127, 1369,51127,31857,49713,44925,49713,32294,49713,45314,49713,
17565,49713,32103,49713,  241,51143,  587,51142,45149,49713,   11,51148,
49317,49713,49289,51152,48997,49713,48961,51156,49001,49713,49912,51161,
49725,51161,49914,51161,49735,51161,49081,51161,49911,51170,49911,51161,
49081,51174,  241,51174,  241,51161,49911,51180,49321,49713,49906,51185,
49727,51185,49908,51185,49733,51185,49401,51185,49905,51194,49905,51185,
49401,51198,  241,51198,  241,51185,49905,51204,49475,49713, 1505,51208,
49155,49713,  165,51212,  240,49712,51059,51217,50163,51217,50165,51217,
51051,51217,  375,51225,  264,49712,49715,51229,50838,51229,50834,51229,
50850,51229,50847,51229,50945,51229,49983,51229,50415,51229,50677,51229,
50691,51229,50496,51229,50003,51229,50906,51229,50910,51229,50345,51229,
50349,51229, 8374,51229, 8389,51229,50705,51229,20152,51229,36898,51229,
20201,51229,36979,51229,50902,51229,  241,51276,50908,51229,46863,51280,
50491,51229,  241,51284,47590,51229,50785,51288,22807,51229,50785,51292,
39085,51229,50785,51296,26219,51229,41417,51229,14524,51229,35690,51229,
50733,51229,37519,51229,50781,51229,50953,51229,50455,51229,50917,51229,
19396,51229, 8647,51229,20103,51229,  375,51324,36773,51229,  375,51328,
 8337,51229,  375,51332,50785,51229,39085,51336,22807,51336,47590,51336,
46863,51336,  241,51344,  241,51336,46863,51348,47488,51229,47961,51229,
    9,51229,18967,51356,  483,51229,35187,51229,  375,51362,18967,51229,
    9,51366,46863,51229,50908,51370,50785,51370,  241,51374,  241,51370,
50785,51378,  375,51370,  241,51229,50491,51384,50902,51384,50785,51384,
46863,51390,46863,51384,50785,51394,  375,51229, 8337,51398,20103,51398,
36773,51398,14315,51398,35187,51398,46863,51398,14315,51229,  375,51412,
 4899,51229,14611,51229, 1010,49712, 3867,51421, 8277,51421, 4067,51421,
 3997,51421, 8953,51421, 9459,51421,  902,49712,50321,51435,51031,51435,
24265,51435,28233,51435,29077,51435,51005,51435,31103,51447,19559,51435,
 4283,51435, 9673,51435, 4279,51435, 3807,51435,20361,51435,20713,51435,
 9967,51435, 8251,51435,47961,49713,  241,51468,47979,49713,  412,51472,
  413,51473,51475,51477,  412,51473,  413,51472,51481,51483,  240,49713,
  340,51487,51398,51487,51418,51487,51416,51487,51354,51487,47974,51487,
47589,51487, 8590,51487,12537,51487,14620,51487,  375,51487,51229,51508,
    7,51487,  265,51512,  265,51513,51229,51517,47580,51487, 8861,51521,
47961,51487,51229,51524, 8495,51524,51229,51487,  375,51530,14611,51530,
 4899,51530,47961,51530, 8495,51487, 4899,51540,47961,51540,14611,51540,
14611,51487,51229,51548, 8495,51548, 4899,51487,51229,51554, 8495,51554,
46863,51487,  265,51560, 8861,51563,  265,51561, 8495,51567,51229,51567,
  265,51487,    7,51572,15309,51573,15308,51572,51577,51579,15308,51573,
15309,51572,51583,51585,46863,51572, 8861,51589,  902,49713,31103,51593,
43053,51593,46863,51593, 1010,49713, 1505,51601,  918,51601,    9,51601,
  903,51606,  903,51601,    9,51610,  265,49712,49873,51615,50165,51615,
51059,51615,51057,51615,51055,51615,51053,51615,49975,51615,49973,51615,
50113,51615,50111,51615,50163,51615,51471,51615,50355,51615,50359,51615,
50209,51615,  241,51645, 8948,51615,50225,51615,50479,51615,  331,51615,
 8861,51654, 8861,51615,  331,51658, 4827,51615,15269,51615,51051,51615,
  375,51667,14611,51667, 4899,51667,47961,51667,  241,51614,50209,51677,
  241,49712,18300,51681, 8605,51681, 8916,51681,50945,51681,49321,51680,
50249,51691,49001,51680,50231,51695,50705,51681, 8374,51681,51508,51681,
50691,51681,47443,51681, 8389,51681,50677,51681,51517,51681, 8861,51681,
  375,51714,26219,51681,41417,51681,  305,51681,48009,51681,51229,51725,
 8647,51681, 8452,51681,46863,51731,  713,51681,   25,51681,18257,51681,
  375,51738, 8337,51681,  375,51742,  265,51742,46863,51747,  375,51681,
18257,51750, 8861,51750, 8337,51750,51487,51750,51487,51681,  375,51760,
  265,51680,50209,51765,49321,51681,49905,51769,49001,51681,49911,51773,
  265,51681,51370,51777,51229,51777,46863,51780,46863,51777,51229,51784,
 8337,51776,46863,51789,46863,51681,  264,51792,51765,51795,  264,51793,
51777,51799,  264,49713,51489,51803,51515,51803,51575,51803,51521,51803,
50411,51803,50659,51803,51563,51803, 8471,51803, 8397,51803, 8371,51803,
20149,51803,36887,51803,20211,51803,37009,51803,20247,51803,37103,51803,
51589,51803,50207,51803,46863,51839,51765,51803,46863,51843,51677,51803,
46863,51847,36773,51803,46863,51851,20103,51803,46863,51855, 8337,51803,
46863,51859, 4613,51803,12571,51803,36539,51803,37595,51803,36049,51803,
47581,51803,51487,51873,51615,51803,39085,51877,22807,51877,47590,51877,
46863,51877,  241,51884,  241,51877,46863,51888,46863,51802,51765,51893,
51677,51893,50207,51893,51615,51893,  241,51901,  341,51893, 1369,51803,
  341,51803,51487,51909, 8337,51909,20103,51909,36773,51909,35187,51909,
14315,51909,46863,51909,12377,51803,  375,51925, 1011,49712,26219,51929,
41417,51929, 8647,51929,  903,49712,49981,51937,51594,51937,  375,51937,
31103,51937,51593,51944,51593,51937,31103,51948,15269,51937, 4827,51937,
 1217,49713,  483,51957,    9,51957,  413,49713, 8647,51962,13177,51962,
  251,51962,18391,51969,  375,51962,18391,51973,44243,51962,31103,51962,
18391,51963,  251,51981,  483,51962,18391,51985,    9,51962,18391,51989,
  375,49713,    5,51992,51615,51995,  413,51993,17993,51999,  413,51992,
18391,52003,  241,51993,51487,52007,46863,51992,  241,51992,51217,52013,
51615,52013, 8861,51992,12377,51993,51487,52021,15029,51992,14315,49713,
  341,52027,51487,52029,15029,49713,  266,52032,  267,52032,  264,52033,
52035,52039,  465,52032,52039,52043,  413,52032,    6,52046,  264,52032,
  251,52051,  241,52051,    6,52055,  265,52033,  251,52059,52051,52060,
 8841,52059,52037,52059,52052,52059,52051,52059,  251,52070,15363,52059,
15055,52059,15061,52059,52049,52059,52057,52059,  265,52032,  251,52084,
52039,52087,52039,52085,  251,52091,  251,52032,  265,52094,52039,52097,
  265,52095,52051,52101,  375,52032, 8639,49713, 8643,49713,26217,49713,
41415,49713,  164,49713,51593,52115,  903,52115, 1504,49713,51601,52121,
  144,49713,  113,52125,  802,49713,49880,52129,49879,52129,  483,52132,
 9366,52129, 9195,52129,  483,52138,  483,52129,49879,52142, 9195,52142,
31103,52129,  112,49713,49888,52151,49887,52151,    9,52154,    9,52151,
49887,52158,44243,52151, 1486,49713,  803,52165,43214,49713,49896,52169,
49895,52169,  483,52172,  483,52169,49895,52176, 1073,49713,  903,52181,
  525,49713,  903,52185,  669,49713,  483,52189,  566,49713,51929,52193,
51615,52193,10107,52193,21036,49713,   17,52201,   88,49713,37611,52205,
36083,52205,38155,52205,35927,52205, 1346,49713, 1505,52215,  154,49713,
  483,52219,26329,49713,41557,49713,  165,49713,49155,52226,47640,52226,
46863,52226,  903,52232,  903,52226,46863,52236,43215,52226, 1505,49713,
49475,52242,47608,52242,46863,52242, 1011,52248, 1011,52242,46863,52252,
28715,52242,  803,49713,49903,52259,  483,52261,  483,52258,49903,52265,
  113,49713,49901,52269,    9,52271,    9,52268,49901,52275,28715,49713,
 1505,52278,43215,49713,49899,52283,  483,52285,  483,52282,49899,52289,
  165,52282,29028,49713,43318,49713,25793,49713,  257,52298,  713,49713,
  241,52303,16163,52303,41019,49713,  257,52308,   25,49713,  241,52313,
16163,52313, 1447,49713,16531,52319,   33,49713,16531,52323, 1471,49713,
   59,52326, 1325,52326,  331,52326,  265,52326,   53,49713, 1325,52336,
   59,52336,  331,52336,  265,52336, 1325,49713,   53,52346, 1471,52346,
  253,52346, 1369,52346,   59,49713, 1471,52356,   53,52356,  253,52356,
 1369,52356,48466,49713,  483,52366,48408,49713,    9,52370,  843,49713,
    9,52375, 1530,49713,    9,52379,40436,49713,  113,52383,  587,49713,
28714,52387,36212,52387,30091,52387,  567,52386, 9195,52395,   11,52386,
32103,52386,35187,52387,  241,52402,  241,52387,35187,52406,    4,52386,
 9366,52411, 9195,52411,  483,52414,  483,52411, 9195,52418,31103,52411,
    5,52387,21605,52424, 9195,52425,27021,52425,21605,52387,   11,52433,
    5,52432,   11,49713,32805,52439,19888,52439,19913,52439,  265,52439,
51803,52447,43503,52439, 1275,52438,    9,52453,   89,52438,  587,52438,
  265,52438,51229,52461, 7971,52461,45149,52438,18967,52439,  241,52468,
  241,52439,18967,52472,    2,52438,    9,52477,44243,52477,    3,52439,
 7971,52483,42155,52483,    2,52439,52205,52489,38305,52439,  265,52493,
38305,52438,  113,52497, 1369,49713,  331,52500,   59,52500,40674,52501,
38305,52501,  265,52509,  241,52508,  241,52501,38305,52514, 1325,52500,
  265,52500,51229,52521,  305,52521,   17,52500,  241,52527,38305,52500,
35187,52501,  265,52501,  331,52535,51803,52535,    4,52500,51601,52541,
    5,52500,  803,52545,    5,52501,  959,52549,   47,52549,  759,52549,
    4,52501, 1275,52500,    9,52559,   17,49713, 1275,52562,  903,52565,
 1369,52562,  241,52569,    2,52562,  903,52573,51593,52573,    3,52562,
  113,52579,    3,52563, 1141,52583, 1447,52583,   33,52583,    2,52563,
  265,52591,51803,52591,38305,49713, 1369,52596,    3,52596,    3,52597,
 8165,52603,20501,52603, 9875,52603,   11,52603,   11,52596,  113,52613,
   15,49713, 1010,52617, 1010,52616, 1011,52616,52619,52623, 1011,52617,
52621,52627,  241,52616,  483,52631,    3,52616,  483,52635,    3,52617,
 1369,52639, 1275,49713,   17,52642,  903,52645,   11,52642,    9,52649,
  241,52642,    9,52653,    9,52643, 1369,52657,   11,52657,    5,52642,
 1505,52663,    5,52643,   53,52667, 1471,52667,  253,52667, 1369,52642,
    9,52675,18967,49713,  241,52679,    9,52681,    5,52678,   17,52685,
    5,52679,    9,52689,  483,49713,  803,52693,52129,52695,43215,52693,
52169,52699, 1216,52693,18759,52703,  413,52693,17993,52707,  803,52692,
49903,52711,48466,52692,43215,52692,49899,52717,40675,52692, 1216,52692,
18617,52723,  413,52692,18391,52727,44243,52692,38305,52693,46169,52733,
    9,52692,46863,52736,  903,52692,    5,52692,10107,52743,51929,52743,
51615,52743,    5,52693,46863,52692,    9,52752,    9,49713,  113,52757,
52151,52759,    4,52756,    7,52763,    2,52765,    2,52764,    2,52763,
    7,52770, 1368,52763, 1216,52757,18759,52777,  413,52757,17993,52781,
  113,52756,49901,52785,48408,52756,25545,52756, 1216,52756,18617,52793,
  413,52756,18391,52797,31103,52756,  483,52756,46863,52802, 1011,52756,
    3,52756,52769,52809,52773,52809,37611,52809,38155,52809,35927,52809,
52489,52809,52775,52809,    3,52757,52767,52825,52151,52825,37663,52825,
52477,52825,31103,52825,46863,52756,  483,52836,31103,49713, 1216,52840,
  413,52840,21036,52840,21037,52840,21037,52841,52847,52851,  903,52841,
51593,52855, 1011,52840,  903,52858,21036,52841,52849,52863,  903,52840,
51435,52867, 1011,52866,    9,52840,    5,52840,27021,52875,44243,49713,
 1216,52878,  413,52878,  903,52878, 1011,52884, 1011,52878,  903,52888,
  483,52878,    3,52878,   11,52895, 1369,52895,    3,52879,  483,52901,
49205,49713,    5,52905,48885,49713,  113,52909,    3,52909,    3,49712,
20819,52915,50945,52915,51508,52915,37537,52915,36898,52915,20152,52915,
 8374,52915,50695,52915,50701,52915,50707,52915,50713,52915,50691,52915,
50705,52915,37748,52915,20952,52915,52395,52915,52457,52915,52142,52915,
52158,52915, 8389,52915,50677,52915,51517,52915,50747,52915,50731,52915,
52418,52915,52478,52915,36979,52915,20201,52915,26219,52915,26106,52915,
52129,52915,  483,52976,52411,52915,  483,52980,51123,52915,32103,52915,
52875,52915,31770,52915,42885,52915,20885,52915,  483,52994,40399,52915,
44714,52915,  357,52915,  367,52915,  471,52915, 1249,52915, 8800,52915,
 8647,52915,47488,52915, 8086,52915,19687,52915,19559,52915,20361,52915,
 9673,52915,20713,52915, 9967,52915, 4283,52915, 4279,52915, 3807,52915,
 8251,52915,41746,52915,41417,52915,44832,52915, 9704,52915,20326,52915,
21087,52915,52906,52915,48245,52915,48975,52915,48451,52915,52151,52915,
    9,53058,52477,52915,    9,53062,51487,52915,  375,53066,50785,52915,
 8165,52915,  265,53073, 1447,52915,38305,53077,21127,52915,20843,52915,
52425,52915,37663,52915,    9,53086, 1141,52915,38305,53091,  566,52915,
  567,52915,46863,53097,44243,52915,41941,53100,  483,53100,  375,52915,
51487,53106,20103,53106, 8337,53106,36773,53106,46863,53106,41941,52915,
44243,53118,   33,52915,38305,53123, 9617,52915,    9,53126, 8337,52915,
  375,53130,48884,52915, 1011,52915,48885,52915,  483,53139,52907,52915,
   25,52915, 7971,53144,41019,52915,   11,53148,  305,52915, 8495,52915,
   11,53154,20103,52915,  375,53158,20273,52915,    9,53162,    4,52915,
28411,53167,31103,53167,48408,53167,52905,53167,  483,53167,46863,53176,
20691,53167, 9923,53167,46863,53167,  483,53184,    5,52915,52905,53188,
   17,53189,18967,53193,46863,53188,  483,53188,25793,52915,   11,53200,
  713,52915, 7971,52915,   25,53206,36773,52915,  375,53210,    4,52914,
53191,53215,53051,53215,24265,53215,28233,53215,29077,53215,53135,53215,
53197,53215,53189,53215,52905,53231,46863,53231,19559,53215, 9673,53215,
 4283,53215,20361,53215, 9967,53215,20713,53215, 8251,53215, 4279,53215,
 3807,53215,    5,52914,53143,53255,53174,53255,50785,53255,53139,53255,
53184,53255,50733,53255,19396,53255,53167,53255,52905,53270,46863,53270,
 8647,53255,41417,53255,26219,53255,    9,53255,18967,53282,  483,53255,
18967,53255,    9,53288,52905,53255,53167,53292,46863,53255,53167,53296,
   11,52915,25793,53301,25793,53300, 8495,53301, 8495,53300,18967,53301,
41019,53301,41019,53300,21037,53301,    9,52915,52151,53318,37663,53318,
52477,53318,31103,53318,20273,53318, 9617,53318,52905,52915,    5,53332,
53215,53335,    5,53333,53167,53339, 9875,52915,35187,53343,  241,53343,
46863,52915,  375,53348,    5,53348,53215,53353,    5,53349,53167,53357,
  483,52915,52129,53360,20885,53360,52411,53360,44243,53360,    5,53361,
    5,53360,18967,52915,11731,53375,  113,53375,31103,52915,    9,53380,
20501,52915,35187,53385,  241,53385,    2,49712,52711,53391,52785,53391,
51059,53391,50165,53391,49995,53391,49999,53391,49987,53391,49991,53391,
50163,53391,52013,53391,52265,53391,52275,53391,17609,53391, 4904,53391,
17586,53391,52259,53391,  483,53423,  272,53391, 1476,53391,  280,53391,
  949,53391, 1517,53391,52269,53391,    9,53437, 9484,53391,51803,53391,
51051,53391,  375,53445, 4903,53391,    9,53448,17579,53391,    9,53452,
42991,53391,40039,53391,40685,53391, 1197,53391,  265,53391,  253,53464,
 1471,53464,   53,53464,   53,53391,  265,53472,  253,53391,  265,53476,
    5,53391, 1471,53391,  265,53482,    5,53390, 8953,53487, 9459,53487,
 4067,53487, 3997,53487, 8277,53487, 3867,53487,   11,53391, 9377,53500,
    9,53391, 4903,53504,17579,53504, 9377,53391,   11,53510,    5,53511,
    5,49712,48765,53517,48835,53517,48843,53517,25445,53517,22779,53517,
22243,53517,    7,53517,    2,53531,28063,53517,25299,53517,31598,53517,
53152,53517,50733,53517,35690,53517,37519,53517,50781,53517,52461,53517,
50953,53517,  272,53517, 1476,53517,  280,53517,  949,53517, 1517,53517,
  357,53517,  367,53517,  471,53517, 1249,53517, 9304,53517,53204,53517,
53144,53517,35931,53517,52912,53517,20326,53517,21087,53517,20273,53517,
    9,53586,50785,53517, 1369,53591,53391,53591,25381,53517,48753,53597,
10081,53597, 9704,53517,   53,53517,  265,53604,37899,53517,37617,53517,
52483,53517, 9617,53517,    9,53614,  253,53517,  265,53618,31103,53517,
26625,53622,  375,53517,35187,53626,26625,53517,31103,53630, 1471,53517,
  265,53634,  265,53517,  253,53638, 1471,53638,   53,53638,49204,53517,
49205,53517,52913,53517,  713,53517, 9195,53652,52915,53652,21605,53653,
  305,53517,52915,53660,21605,53661,    2,53517, 8229,53667,52909,53667,
46863,53667,    3,53517,52909,53674,53391,53675, 1369,53675,46863,53674,
52915,53517,  305,53684,  713,53684,   25,53684,   25,53517,52915,53692,
21605,53693, 9195,53517,  713,53698,    2,53516,53677,53703,53581,53703,
53647,53703,53683,53703,53675,53703,52909,53713,46863,53713, 4067,53703,
 3997,53703, 8953,53703, 9459,53703, 8277,53703, 3867,53703,    3,53516,
53651,53731,53670,53731,50785,53731,50733,53731,53649,53731,53672,53731,
19396,53731,53667,53731,52909,53746,46863,53746, 8647,53731,26219,53731,
41417,53731,  483,53731,18967,53731,    9,53760,    9,53731,18967,53764,
52909,53731,53667,53768,46863,53731,53667,53772,  587,53517,35187,53777,
  483,53517,52909,53517,    3,53782,53703,53785,    3,53783,53667,53789,
46863,53517,    3,53792,53703,53795,    3,53793,53667,53799,    9,53517,
20273,53802, 9617,53802,35187,53517,  375,53808,    4,49712,48747,53813,
37279,53813,19981,53813,24601,53813,    7,53813,21605,53823,53071,53813,
52743,53813,52193,53813,50225,53813, 8306,53813,  545,53813,  695,53813,
 1382,53813, 1374,53813, 1386,53813,51906,53813,53442,53813,53199,53813,
53373,53813,53095,53813,51803,53813, 1369,53856,53391,53856, 9992,53813,
20734,53813,19916,53813,48739,53867,37241,53867, 7947,53867,28205,53813,
24613,53813,25551,53813,53189,53813,  483,53881,   33,53813, 9875,53813,
  265,53886,  241,53887,20501,53813,  265,53892,  241,53893, 1141,53813,
  154,53813,  483,53901, 1447,53813,  331,53813, 1369,53906,  265,53813,
 8165,53910, 9875,53910,20501,53910, 1011,53813,   59,53813, 1369,53920,
    3,53813, 8241,53925,   15,53924,  483,53929,53391,53813,51803,53932,
 1325,53813, 1369,53936,    3,53812,24265,53941,28233,53941,29077,53941,
 9673,53941,19559,53941, 4283,53941,20361,53941, 8251,53941, 3807,53941,
 9967,53941,20713,53941, 4279,53941, 1369,53813,  331,53966, 1325,53966,
   59,53966,51803,53966,18967,53813, 1275,53976,48739,53979,37241,53979,
 7947,53979,  113,53977, 1275,53813,18967,53988,48739,53991, 7947,53991,
37241,53991, 8165,53813,  265,53998,46863,53813,38056,54002,38056,54003,
38057,54002,54007,54009,38057,54003,54005,54013,   15,53813,    3,54017,
 1369,54019,    3,54016,  483,54023,    5,49713,  375,54026,51615,54029,
 1368,54027,    7,54027,    2,54034,    2,54035,32805,54027,31103,54041,
20035,54027,  375,54045,  341,54027,18967,54049,12377,54027,  375,54053,
52915,54027,31103,54057,27021,54027,31103,54061,30091,54027,31103,54065,
31103,54026,27021,54069,52915,54069,18967,54027,47608,54075,46863,54075,
 1011,54078, 1011,54075,46863,54082,53924,54027,53825,54087,  483,54087,
51929,54027,  483,54093,51615,54027,  375,54097,  483,54097, 1369,54026,
  803,54103,  483,54026,53813,54107,10107,54107,51929,54107,51615,54107,
 1275,54026, 1505,54117,18967,54026,   17,54121, 1369,54027,51601,54125,
    2,54026,54078,54129,54075,54129,46863,54132,52541,54129, 1505,54129,
  918,54129,52121,54129,54125,54129,  903,54129,    9,54146,    9,54129,
  903,54150,46863,54129,54075,54154,    3,54026,54033,54159,54037,54159,
53966,54159,12571,54159, 4613,54159,51615,54159, 8337,54159,46863,54173,
52591,54159,53932,54159,53391,54159,53813,54180,53813,54159, 1369,54184,
53391,54184,36773,54159,46863,54191,20103,54159,46863,54195, 1369,54159,
53813,54198,    2,54027,    0,54202,54159,54205,46863,54207,    7,54202,
54159,54211,  265,54203,    9,54215,54159,54203,    9,54219,46863,54219,
    3,54027,48286,54225,54039,54225,54150,54225,52573,54225,52115,54225,
38057,54225,46863,54236,53813,54224,53825,54241,  483,54241,    9,54225,
54129,54246,  483,54225,53813,54251,54154,54225,46863,54225,38057,54256,
54129,54256,54129,54225,    9,54262,46863,54262,10107,54027,  483,54269,
53813,54027,  483,54273,    3,54273, 1369,54277,53391,54277,    3,54272,
53825,54283,  483,54283,   17,54027,20273,54289, 9617,54289,    3,49713,
16722,54295,16530,54294,54297,54299,16723,54295,16531,54294,54303,54305,
16530,54295,    1,54295,35187,54311,   17,54313,    7,54295,16531,54316,
54299,54319,16531,54317,54309,54323,   15,54317,38305,54327,    1,54294,
40705,54331,54329,54331,   17,54331,    7,54294,54333,54339,40704,54339,
54331,54343,49713,54339,    4,54346,    4,54339,49713,54350,54315,54339,
    9,54339,38305,54356,54331,54359,38305,54339,    9,54362,54331,54365,
52489,54295,    9,54369,36527,54295,  375,54373,  341,54295,12377,54295,
    9,54379,16531,54295,    7,54382,54299,54385,37611,54295,    9,54389,
 8321,54295,35927,54295,    9,54395,38155,54295,    9,54399,43503,54295,
44243,54403,  113,54295,38305,54406,40086,54295, 8241,54295,44243,54294,
   11,54415, 1369,54415, 1486,54295,35187,54295,47640,54423,46863,54423,
  903,54426,  903,54423,46863,54430,53480,54295,11731,54295,51615,54295,
  241,54295,   17,54294,  113,54443,38305,54294,    9,54294,37611,54449,
38155,54449,35927,54449,52489,54449,   15,54294,  483,54459,   11,54295,
44243,54463,38305,54295,  113,54466,38057,54295,    7,54471,  375,54471,
    4,54294,54426,54477,54423,54477,46863,54480,52573,54477,54377,54477,
52115,54477,43053,54477,46863,54477,54423,54492,    5,54294,54473,54497,
    6,54497,54471,54501,53966,54497,12571,54497, 4613,54497,51615,54497,
 8337,54497,46863,54513,52591,54497,53932,54497,53813,54497, 1369,54520,
53391,54520,53391,54497,53813,54526,20103,54497,46863,54531,36773,54497,
46863,54535, 1369,54497,53813,54538,    4,54295,    0,54542,54497,54545,
46863,54547,    5,54295,48294,54551,21315,54551,46863,54554,53391,54550,
 1369,54550,46863,54551,21315,54562,53391,54295,    5,54567,53813,54569,
    5,54566, 1369,54295, 9893,54575,52129,54575,54353,54575,54349,54575,
20885,54575,52411,54575,44243,54575,    5,54574,    5,54575,53813,54593,
    2,49713,53227,54597,53262,54597,53355,54597,53358,54597,53298,54597,
53264,54597,53229,54597,53274,54597,53234,54597,49168,54597,    1,54597,
    7,54597,  567,54621,52915,54623,    4,54621,54575,54627,53360,54627,
52915,54627,  483,54632,  483,54627,52915,54636,    9,54621,    1,54596,
36544,54643,35187,54643,   11,54646,   11,54643,35187,54650,    7,54596,
36545,54655,54643,54657,54645,54655,21605,54655,54653,54655,54649,54655,
   15,54655,53270,54597,46863,54670,53231,54597,46863,54674,49169,54597,
54097,54597,53134,54597,53215,54683,53352,54597,53215,54687,53196,54597,
53215,54691, 8311,54597,48884,54596,54617,54697,53731,54597,53881,54597,
54283,54597,54241,54597,54087,54597,36256,54597,53296,54597,53167,54712,
53184,54597,53255,54716,53167,54597,53357,54720,53296,54720,53255,54720,
46863,54726,46863,54720,53255,54730,48885,54597,    9,54734,54697,54737,
54697,54735,    9,54741,35187,54597,    9,54744,    9,54597,48885,54748,
54697,54751,48885,54749,35187,54748,   11,54749,52915,54759,53188,54597,
53215,54763,46863,54765,46863,54762,53215,54769,53813,54763,53139,54597,
53255,54774,44243,54597,   11,54779,54225,54597,53813,54783,51229,54597,
  265,54597,54027,54789,47961,54791,14611,54791, 4899,54791,  375,54791,
   17,54596,  903,54801,51593,54801,54477,54801,54225,54801,   11,54596,
53318,54811,52825,54811,52915,54811,    9,54816,    9,54811,52915,54820,
44243,54811,53255,54597,53139,54826,53184,54826,53167,54826,46863,54832,
46863,54826,53167,54836,53357,54597,53167,54840,    4,54596,51418,54845,
51416,54845,51398,54845,51354,54845,51909,54845,  340,54845,51803,54857,
51873,54845,47974,54845,47589,54845, 8590,54845,14620,54845,12537,54845,
52021,54845,52029,54845,53106,54845,  375,54845,51229,54878,52915,54878,
    0,54845,    6,54885,    7,54845,  265,54888,51803,54891,  265,54889,
51229,54895,52915,54895,47580,54845,51803,54901, 8861,54901, 8495,54845,
47961,54906, 4899,54906,14611,54906,52915,54845,  375,54914,14611,54845,
51229,54918, 8495,54918, 4899,54845,51229,54924, 8495,54924,47961,54845,
51229,54930, 8495,54930,  265,54845,    7,54936,51803,54939,54887,54937,
54886,54936,54943,54945,54887,54936,54886,54937,54949,54951,46863,54936,
 8861,54955,51803,54955,46863,54845,  265,54960,51803,54963, 8861,54963,
  265,54961,51229,54969, 8495,54969,51229,54845,  375,54974,14611,54974,
 4899,54974,47961,54974,    5,54596, 1505,54985,  918,54985,52541,54985,
52121,54985,54125,54985,  903,54985,    9,54996,    9,54985,  903,55000,
    5,54597,54889,55005,52915,55007,53349,55004,    6,55005,54914,55013,
52915,55013,54845,55016,54845,55013,52915,55020,   53,55005, 1471,55005,
  253,55005,52557,55005,53348,55004,53215,55033,  241,55005,    9,55037,
52915,55004,53215,55041,46863,55043,46863,55040,53215,55047,53813,55041,
   17,55005,35187,55053,52915,55005,53357,55057,55011,55057,53296,55057,
53255,55057,46863,55064,46863,55057,53255,55068,46863,55004,52915,55072,
53215,55075,52915,55073,53255,55079,48885,54596,54679,55083,    9,55083,
48884,54597,54755,55089,55086,55089,55083,55089,    9,55094,52915,55088,
53215,55099,52915,55089,53255,55103,    9,55089,55083,55106,53348,54597,
    5,55110,53215,55113,    5,55111,53167,55117,52915,54597,48884,55120,
53215,55123,48884,55121,53139,55127,    5,55121,53139,55131,53184,55131,
53167,55131,46863,55136,46863,55131,53167,55140,    5,55120,53215,55145,
46863,55147,46863,55144,53215,55151,53813,55145,46863,55120,    5,55156,
53215,55159,    5,55157,53167,55163,21605,54597,54027,55167,31103,55169,
46863,54597,53270,55172,53231,55172,53188,55172,53215,55179,53255,55172,
53167,55182,53167,55172,53255,55186,    5,55172,52915,55190,53215,55193,
52915,55191,53255,55197,52915,55172,    5,55200,53215,55203,    5,55201,
53167,55207,    4,49713,51398,55211,  375,55211,51229,55214,53709,55211,
53740,55211,51909,55211,53797,55211,53800,55211,  340,55211,51803,55229,
54339,55210,54575,55233,53774,55211,53742,55211,53711,55211,53750,55211,
53716,55211,54663,55211,53533,55211, 1368,55211,52205,55251,54449,55251,
52809,55251,54295,55251,    9,55259,    7,55211,  265,55263,51229,55265,
   89,55263,52915,55269,  265,55262,51803,55273,    2,55262,52205,55277,
52809,55277,54449,55277,54295,55277,    9,55285,    2,55263,52825,55289,
53318,55289,    9,55289,52915,55294,52915,55289,    9,55298,53746,55211,
46863,55302,53713,55211,46863,55306,31796,55211,25037,55211,25215,55211,
42338,55211,42076,55211,43053,55211,42959,55211,54575,55211,54339,55325,
54786,55211,51360,55211,53780,55211,52751,55211, 8148,55211, 9594,55211,
54377,55211,54439,55211,53758,55211,54700,55211,54826,55211,53286,55211,
53646,55211,53703,55353,53794,55211,53703,55357,53682,55211,53703,55361,
53371,55211,  842,55211, 9377,55367,54591,55211,54421,55211,54561,55211,
53681,55211,53255,55211,54597,55378,  483,55378,53679,55211,54573,55211,
55131,55211,54559,55211,54435,55211,19892,55211,53772,55211,53667,55396,
53672,55211,53731,55400,53667,55211,53799,55404,53772,55404,53731,55404,
46863,55410,46863,55404,53731,55414,  935,55211,20733,55211, 9991,55211,
41941,55211,  483,55424, 9565,55211,  483,55428, 1487,55211,54597,55211,
51229,55434,   53,55435, 1471,55435,  253,55435,53731,55434,53255,55434,
47546,55211,   66,55211, 1369,55451,  241,55211,31103,55454,18967,55211,
  483,55458,  483,55211,42155,55462,41941,55462,51229,55462,53517,55462,
 7971,55462, 9565,55462,53731,55462,53255,55462,  587,55462, 9377,55481,
18967,55462,  587,55463, 9195,55487,52915,55487,53674,55211,53703,55493,
46863,55495, 1369,55493,46863,55492,53703,55501,53391,55493,53649,55211,
53731,55506,31103,55211,  241,55510,  587,55511,  113,55211,46863,55516,
17455,55211,54551,55211, 1369,55523,53391,55523,51229,55211,  375,55528,
54597,55528,  483,55528, 1011,55211, 8165,55537, 9875,55537,20501,55537,
   11,55537,  265,55211,    7,55546,51803,55549,54295,55547,47961,55553,
14611,55553, 4899,55553,  375,55553, 1369,55210,54985,55563,51601,55563,
54129,55563,  587,55210, 9366,55571,54575,55571,53360,55571, 9195,55571,
  483,55578,52915,55571,  483,55582,  483,55571, 9195,55586,52915,55586,
31103,55571,53731,55211,53649,55594,53672,55594,53667,55594,46863,55600,
  483,55594,54597,55594,46863,55594,53667,55608,  587,55211, 9377,55613,
  483,55615,  483,55612, 9377,55619,21605,55211,21526,55622,    6,55623,
21527,55622,55627,55629,    7,55622,    7,55623,55625,55635,    6,55622,
18967,55638,55635,55641,18967,55622,    6,55645,55633,55647,    6,55644,
55635,55651, 1347,55211, 1369,55655,53799,55211,53667,55658,    2,55210,
51418,55663,51416,55663,51398,55663,51354,55663,51909,55663,  340,55663,
51803,55675,51873,55663,47974,55663,47589,55663, 8590,55663,14620,55663,
12537,55663,52021,55663,52029,55663,53106,55663,  375,55663,51229,55696,
52915,55696,    0,55663,    6,55703,    7,55663,  265,55706,51803,55709,
  265,55707,51229,55713,52915,55713,47580,55663,51803,55719, 8861,55719,
 8495,55663,47961,55724, 4899,55724,14611,55724,52915,55663,  375,55732,
14611,55663,51229,55736, 8495,55736, 4899,55663,51229,55742, 8495,55742,
47961,55663,51229,55748, 8495,55748,  265,55663,    7,55754,51803,55757,
55705,55755,55704,55754,55761,55763,55705,55754,55704,55755,55767,55769,
46863,55754, 8861,55773,51803,55773,46863,55663,  265,55778,51803,55781,
 8861,55781,  265,55779,51229,55787, 8495,55787,51229,55663,  375,55792,
14611,55792, 4899,55792,47961,55792,    3,55210,54801,55803,52573,55803,
52115,55803,43053,55803,46863,55803,    2,55211,    7,55814,52205,55817,
52809,55817,54449,55817,54295,55817,    9,55825,54295,55815,54501,55829,
    7,55829,54497,55833,  375,55829,    3,55211,55707,55839,52915,55841,
55706,55839,53793,55838,55779,55839,    6,55839,55732,55851,52915,55851,
55663,55854,55663,55851,52915,55858,    0,55851,55829,55851,    0,55850,
55663,55867,    0,55839,    6,55870,55663,55873,    0,55838,49713,55838,
55845,55879,    1,55838,55868,55883,55874,55883,55867,55883,55663,55888,
55873,55883,55663,55892,55849,55883,55663,55883,55867,55898,55873,55898,
46862,55839,55898,55905,55883,55905,55663,55908,55663,55905,55883,55912,
    1,55839,55863,55917,55663,55919,    7,55839,55663,55922,55879,55925,
55879,55923,55663,55929,52591,55839,53792,55838,53703,55935,43027,55839,
43837,55839,39747,55839,53517,55838,53703,55945,46863,55947, 1369,55945,
46863,55944,53703,55953,53391,55945, 1369,55839,18967,55959,   11,55838,
 1369,55963,18967,55839,46863,55967,   11,55839,46863,55971,53517,55839,
53799,55975,55847,55975,53772,55975,53731,55975,46863,55982,46863,55975,
53731,55986,55778,55839,55877,55991,46863,55839,55877,55995,55663,55997,
55663,55994,55877,56001,55663,55839,    7,56004,55879,56007,46863,56004,
55877,56011,46863,55838,53517,56014,53703,56017,53517,56015,53731,56021,
49204,55211,53517,56024,53703,56027,53517,56025,53731,56031,53792,55211,
    3,56034,53703,56037,    3,56035,53667,56041, 7971,55211,  483,56044,
42155,55211,  483,56048,53517,55211,  483,56052,49204,56052,53703,56057,
49204,56053,53649,56061,    3,56053,53649,56065,53672,56065,53667,56065,
46863,56070,  483,56065,54597,56065,46863,56065,53667,56078,    3,56052,
53703,56083,46863,56085, 1369,56083,46863,56082,53703,56091,53391,56083,
46863,56052,    3,56096,53703,56099,    3,56097,53667,56103,   11,55211,
    3,56106, 1369,56109,    3,56107,  483,56113,46863,55211,53746,56116,
53713,56116,53674,56116,53703,56123,53731,56116,53667,56126,53667,56116,
53731,56130,  113,56116,    3,56116,53517,56136,53703,56139,53517,56137,
53731,56143,53517,56116,    3,56146,53703,56149,    3,56147,53667,56153,
46863,49713,47982,56156,47983,56157,56159,56161,47983,56156,47982,56157,
56165,56167,49588,56156,49589,56157,56171,56173,49670,56156,49671,56157,
56177,56179,49589,56156,49588,56157,56183,56185,49671,56156,49670,56157,
56189,56191, 8453,56156,  273,56156,21522,56156,38266,56156, 1516,56156,
  948,56156,20239,56156,37095,56156, 1477,56156,  281,56156,49617,56156,
49616,56157,56215,56217,49699,56156,49698,56157,56221,56223,49617,56157,
49616,56156,56227,56229,49699,56157,49698,56156,56233,56235, 1216,56156,
  412,56156,12377,56156,  375,56156,  510,56156,38057,56156,  903,56248,
  165,56156,  903,56252,21315,56156, 1011,56256, 1505,56156, 1011,56260,
  413,56157,50785,56265,56241,56265, 1217,56157,56239,56271, 1216,56157,
  413,56156,  412,56157,56277,56279, 1217,56156,56275,56283,  264,56157,
51777,56287,50908,56287,50785,56287,  241,56292,  241,56287,50785,56296,
  375,56287,  264,56156,50207,56303,51765,56303,51677,56303,51615,56303,
  241,56311,  341,56303, 1011,56156, 1505,56316,21315,56316,  903,56156,
  165,56322,38057,56322,  483,56156,    9,56328,    9,56156,  483,56332,
    5,56157,    4,56156,56337,56339,46863,56340,    2,56343,    2,56342,
49515,56340,49514,56340,    2,56341,56349,56353,    3,56341,56347,56357,
56351,56357,    2,56340,46863,56362,56357,56365,56357,56363,    3,56340,
56345,56371,56353,56371,    3,56157,  375,56377,    2,56156,56337,56381,
    1,56383,    0,56382,56385,56387,    0,56383,    1,56382,56391,56393,
56377,56381,46863,56396,    4,56399,    4,56398,49631,56396,49630,56396,
    4,56397,56405,56409,    5,56397,56403,56413,56407,56413,    4,56396,
46863,56418,56413,56421,56413,56419,    5,56396,56401,56427,56409,56427,
    2,56157,    3,56156,56337,56435,    7,56437,    6,56436,56439,56441,
    6,56437,    7,56436,56445,56447,56433,56435,46863,56451,    4,56452,
    4,56453,49631,56451,49630,56451,    4,56451,46863,56462,    5,56451,
56457,56467,    4,56450,56467,56471,56459,56471,    5,56450,56465,56477,
56455,56477,56463,56477,56461,56477,    4,56157,56435,56487,    1,56489,
    0,56488,56491,56493,    0,56489,    1,56488,56497,56499,56381,56487,
    7,56503,    6,56502,56505,56507,    6,56503,    7,56502,56511,56513,
    5,56156,56487,56517,46863,56519,    2,56520,    2,56521,49515,56519,
49514,56519,    2,56519,46863,56530,    3,56519,56525,56535,    2,56518,
56535,56539,56527,56539,    3,56518,56533,56545,56523,56545,56531,56545,
56529,56545,    1,    2,11709,56555,11632,56555,11035,56555,10468,56555,
17775,56555,11788,56555,12226,56555,11816,56555,11770,56555,44558,56555,
42181,56555,44243,56576,44438,56555,10856,56555, 3447,56555,  375,56584,
 3448,56555,11705,56555,11033,56555,10516,56555,17773,56555,18735,56555,
10427,56555,10831,56600,10836,56555,10855,56555,16623,56555,16711,56555,
 9533,56610,16718,56555, 3555,56555, 5882,56555, 9261,56555,  483,56621,
 3699,56555,   15,56625,    6,56624,56627,56629,   14,56625,    7,56624,
56633,56635, 1999,56555,   15,56639,    6,56638,56641,56643,   14,56639,
    7,56638,56647,56649,29450,56555,29731,56653,29659,56653,28791,56653,
29041,56653,38067,56555,    5,56663,38185,56665,42155,56554,44243,56669,
42471,56670,44966,56669,42471,56669,44243,56676, 1471,56554,36639,56681,
15390,56555,15383,56685,28715,56555,21527,56689,29229,56691,    7,56689,
29759,56695,    7,56688,28791,56699,29041,56699,29731,56699,29659,56699,
 1005,56555,16877,56554,16893,56711, 9925,56555, 1369,56715, 9927,56717,
35336,56555,  989,56721,35278,56555, 1177,56725,  987,56555,35187,56728,
  989,56731,36563,56554,36639,56735,  671,56554,36597,56554,36639,56741,
 1418,56554,    1,56745,    4,56746,    4,56745,    1,56750,  147,56555,
35187,56754,   53,56757,17637,56555,  587,56760,10107,56763,35316,56555,
 1471,56767,35330,56555,   53,56771,17638,56555,10107,56775, 1489,56555,
35187,56778, 1471,56781, 1179,56555,35187,56784, 1177,56787,37229,56555,
35187,56790,37223,56793, 9441,56555,  587,56796, 9439,56799,37230,56555,
37223,56803, 9442,56555, 9439,56807,45432,56555,42435,56811,   30,56555,
11731,56814,45433,56555,56669,56819,43099,56555,52259,56555,  483,56825,
44742,56555,44904,56555,52613,56555,52383,56555,52497,56555,39231,56555,
40447,56555,39083,56555,38797,56555,39019,56555,39301,56555,39429,56555,
39305,56555,  386,56555,  347,56555,54492,56555,45508,56555,56116,56555,
55812,56555,40987,56555,52909,56555,51598,56555,50419,56555,56332,56555,
52836,56555,52366,56555,36639,56555, 1471,56881,36563,56881,36597,56881,
  181,56555,11731,56888,50579,56555,52319,56555,52323,56555,54436,56555,
54406,56555,52532,56555,52514,56555,55520,56555,44930,56555,39317,56555,
51141,56555,40123,56555,39228,56555,40676,56555,47366,56555,40682,56555,
52599,56555,50655,56555,52531,56555,36538,56555,36048,56555,37594,56555,
42918,56555,40922,56555,39292,56555,11111,56555,11113,56555,11187,56555,
17508,56555,17180,56555, 3280,56555, 3574,56555, 3568,56555,12216,56555,
   25,56958,11613,56555,   25,56962,48406,56555,48400,56555,48500,56555,
43292,56555,47534,56555,17494,56555,39065,56555,48961,56555,49162,56555,
17496,56555,11179,56555,47892,56555,11546,56555,11207,56555, 5878,56555,
52446,56555,35506,56555,39035,56555,40087,56555,    9,57003,10513,56555,
    9,57006,36102,56555,  253,57011,   53,57011,  117,57011, 1471,57011,
 7968,56555,53813,57021,10107,57021,11067,57021,37282,56555,53813,57029,
37417,57029,10107,57029,35652,56555,  253,57037, 1471,57037,  809,57037,
   53,57037,38293,56555,53813,57047,37417,57047,38275,57047,10107,57047,
 1397,56555,35187,57056,52439,56555,  265,57060,40127,56555,43318,56555,
48750,56555,53813,57069,10107,57069,36100,56555,  253,57075,   53,57075,
 1471,57075, 9404,56555,  483,57083, 8053,56555,    9,57087,10465,56555,
    9,57090,11936,56555,10119,56555,10185,56555,53885,56555,10117,56555,
45490,56555,   33,57105, 8212,56555,    9,57109,11812,56555,    9,57112,
53899,56555, 6719,56555,   11,57119,    5,57120,    6,57119,    5,57124,
    5,57119,    6,57128,    6,57129,    7,57119,57133,57135,   15,57119,
    6,57118,57139,57141,   14,57119,    7,57118,57131,57147,57127,57147,
57123,57147,57145,57147, 6787,56555,    5,57157,    4,57157,   12,57157,
   13,57156,57163,57165,   13,57157,   12,57156,57169,57171,    5,57156,
57161,57175,    4,57156,57159,57179,10831,56555,  375,57182,44243,57182,
10427,57182,    9,57183,11529,56555,46863,57192,  483,57192,17640,56555,
39226,56555,48572,56555,47410,56555,40568,56555,47374,56555,47674,56555,
17656,56555,47676,56555,47634,56555,48112,56555,47412,56555, 5814,56555,
  918,56555,36256,56555,46863,57226,48466,56555,49713,57230,35187,57230,
   11,57231,47608,56555,  903,57238,52756,56555,46863,57242,48620,56555,
  247,56555,46863,57248, 1419,56555,56749,57253,56753,57253,25519,57253,
 1841,57253, 1883,57253,22679,57253,    5,57253,22677,57267,14065,57253,
 5175,57253,40565,56555,  587,57274,  922,56555,51593,56555,46863,57280,
47640,56555,   11,57285, 1011,57284,   11,57284,35718,56555, 9439,57293,
37223,57293, 9381,57293,37157,57293,35877,57293,35881,57293, 9383,57293,
37163,57293,35883,57293,   17,57293,37145,57313, 9377,57313,35867,57313,
51051,56555,  375,57321,50959,56555,    9,57325,39205,56555,   10,57329,
   10,57328,   11,57329,57333,57335, 1011,57328,   11,57328,57331,57341,
48402,56555,    9,57344,48560,56555,  903,57348,36544,56555,    6,57353,
36661,57355,36675,57353, 8067,57353, 7979,57353, 7981,57353,39747,57353,
43837,57353,43027,57353, 1369,57353, 7971,57373,  934,56555,46863,57376,
  668,56555,    5,57381,22605,57383,22615,57381, 3135,57381, 2009,57381,
14065,57381, 5175,57381,53905,56555,55432,56555,10303,56555,42661,56555,
   25,56555,11613,57404,12216,57404,    9,57404,11731,57410,35187,57404,
  253,57415,   53,57415,  117,57415, 1471,57415,11731,57404,    9,57424,
 8165,56555,   67,57428,    9,57431, 7947,56555,  587,57434,53813,57437,
10107,57437,11067,57437,17049,56555,46863,57444,  165,56555,43215,57448,
  113,56555,54295,57452,  767,56555,  483,57457, 9377,57459, 9377,57456,
  483,57463,  803,56555,17455,57466,  375,56555,10831,57470, 3447,57470,
  305,57470,17125,57470,  510,56555,   11,56555,   33,57483,44243,57485,
44243,57482,   33,57489,39205,57482,47640,57482,46863,57482,  903,57496,
35187,57482,43027,57501,43837,57501, 8067,57501, 7979,57501,39747,57501,
 7981,57501, 1369,57501, 7971,57515,  903,57482,46863,57518,    9,56555,
10465,57522,11812,57522,10513,57522,   25,57522,11731,57530,56156,57522,
40675,57522, 3565,57522, 3573,57522, 3273,57522,11731,57522,   25,57544,
48402,57522,17455,57522, 5843,57522,   11,57523,46863,57555,49713,57522,
46863,57558,  903,57522,35187,57522,46863,57564,46863,57522,49713,57568,
35187,57568,   11,57569,  587,57522, 5175,57577,14065,57577, 3135,57577,
 2009,57577,  483,57522,55839,56555,  483,57589, 5771,56555,  903,57592,
 6705,56555, 1369,57597, 6707,57599, 6711,57599, 6715,57599, 3697,56555,
   16,57607,   16,57606,   17,57607,57611,57613,   17,57606,57609,57617,
 3709,56555, 8075,56555,    9,57623, 3273,56555,    9,57626, 3423,56555,
   16,57631,   16,57630,   17,57631,57635,57637,   17,57630,57633,57641,
 3661,56555,   16,57645,   16,57644,   17,57645,57649,57651,   17,57644,
57647,57655, 3681,56555, 3357,56555,53675,56555,    9,57663,42379,56555,
    9,57667, 3573,56555,    9,57670, 3565,56555,    9,57674,52878,56555,
15436,56555,  375,57681,54550,56555,17232,56555,38305,57686, 4935,56555,
    6,57691,    5,57692,    7,57691,    5,57691,    6,57698,    6,57699,
57697,57703,    6,57690,   15,57691,57707,57709,    7,57690,57695,57713,
57701,57713,   14,57691,57713,57719,55803,56555,46863,57722,16127,56555,
    6,57727,    5,57728,    7,57727,    5,57727,    6,57734,    6,57735,
57733,57739,    6,57726,   15,57727,57743,57745,    7,57726,57731,57749,
57737,57749,   14,57727,57749,57755,54477,56555,46863,57758,49155,56555,
  483,57762, 5843,56555,  955,57766,    9,57766, 5313,56555, 9802,56555,
48736,56555, 9434,56555,  483,57779,15309,56555,  413,57782,15383,57785,
  413,57783,15335,57789,    8,56554,    4,57793,    1,57794,57381,57797,
57577,57797,    1,57793,    4,57802,57381,57805,57577,57805,   10,56554,
    7,57811,    2,57812,57353,57815,57501,57815,    2,57811,    7,57820,
57353,57823,57501,57823,57515,57811,57373,57811, 1368,57811,57501,57833,
57353,57833, 3867,57811, 8277,57811, 3997,57811, 4067,57811, 9459,57811,
 8953,57811,57483,57811,    9,57811,   14,56555,38881,57855,   11,56554,
44778,57859,44243,57859,   25,57862,47640,57859,   25,57859,44243,57868,
48466,57859,  903,57859,46863,57874,46863,57859,  903,57878,    9,57878,
    9,57859,46863,57884,    9,56554,40903,57889,40053,57889,43307,57889,
 5019,57889,12361,57889,   16,56555,19625,57901,21105,57901,21549,57901,
17591,57901,   17,56554,36639,57911,   10,56555,57859,57915,11731,56555,
   30,57918,  181,57918,54295,57918,    9,57918,   25,57926,  145,57918,
   25,57918,    9,57932,   67,56555,    9,57937, 8165,57939, 8165,57936,
    9,57943,17635,56555,  155,57946,  903,57946,  145,56555,11731,57952,
17695,56555, 1369,57957, 7971,57959,53517,57959,17053,57959,17699,57959,
42155,57959,  155,56555,17635,57970,10305,56555,42699,56555,10307,56555,
  566,56555,53813,57981,10107,57981,  256,56555,42810,56555,17125,57988,
 1170,56555,  629,56555, 1413,56555,37408,56555,25793,57999,41019,57999,
 8495,57999,  265,57998, 1346,56555,48884,56555,27021,58011,52915,58011,
 9195,58011,20763,58011,  340,56555,  331,58021,35187,58020,38270,56555,
  766,56555,25519,58029,  802,56555, 9366,58033, 9195,58033,  483,58036,
  483,58033, 9195,58040,31103,58033,42729,56555,  257,56555,44243,58048,
 1487,56555,55211,58052,44243,56555,10831,58056,42181,58056,42155,58057,
42471,58063,42155,58056,42435,58067, 9533,58056,37145,58056,   11,58057,
   25,58075,35187,58056,17125,58056,   11,58056,   33,58083,49713,58056,
  257,58056,55211,56555,46863,58090,17455,58090, 1487,58090, 1197,56555,
    4,58099,    5,58098,58101,58103,    5,58099,    4,58098,58107,58109,
 1505,56555,45002,56555,42155,56555,42435,58117,44243,58119,44243,58116,
42435,58123,  305,56555,  375,58126,35187,58126,  253,58131, 1471,58131,
   53,58131,  713,56555,35187,58138,  253,58141, 1471,58141,  809,58141,
   53,58141,37241,56555,  587,58150,53813,58153,37417,58153,10107,58153,
  955,56555, 5843,58160,48739,56555,  587,58164,53813,58167,10107,58167,
40461,56555,    9,58173,52501,56555,35187,58176,  241,58176, 9801,56555,
   17,58182,    4,58183,58185,58187,    5,58183,57901,58191,    4,58182,
    7,58194,58191,58197,    5,58182,48735,56555,   17,58202,    4,58203,
58205,58207,    5,58203,57901,58211,    4,58202,    7,58214,58211,58217,
    5,58202, 9533,56555,16711,58222,44243,58222,37145,56555,44243,58228,
 8861,56555,    5,58233,    6,58235,    6,58234,   14,58233,   15,58233,
    6,58233,    5,58244,    7,58233,58237,58249,    6,58232,58243,58253,
    7,58232,58239,58257,58247,58257,58241,58257, 9377,56555,  767,58264,
  483,58267,    4,58264,  483,58271, 1217,56555,  483,58275,  413,56555,
15309,58278,15383,58281,15309,58279,15363,58285,46863,58278,  412,56555,
  483,58291, 1216,56555,46863,58294,56156,56555,    9,58298, 1011,56555,
39205,58302,47640,58302,46863,58302,  903,58308,    7,58302,  903,58302,
46863,58314,43215,58302,    7,58319,38305,56555,17232,58322,    7,58322,
17125,58326,17125,58322,    7,58330,49713,56555,48466,58334,    9,58334,
46863,58338,44243,58334,46863,58334,    9,58344,  241,56555,52501,58348,
    7,58348,    7,58349,  265,58355,  265,58348,  483,58359,  483,56555,
40675,58362,43215,58362,49155,58362,11529,58362,  903,58362,    9,58362,
    5,58362,53813,58377,10107,58377,    5,58363,55211,58383,40675,56555,
    7,58387,    9,58386,  483,58386,46863,58386,35187,56555,37229,58396,
37223,58399, 1177,58397, 1179,58403,  989,58397,  987,58407, 1179,58396,
 1177,58411,  987,58396,  989,58415, 1489,58396, 1471,58419,  147,58396,
   53,58423,  117,58397,   25,58427,  809,58397,  713,58431,    2,58396,
    7,58435,    2,58436,58397,58439,    5,58436,58441,58443,    5,58435,
    7,58446,   10,58435,    4,58396,    7,58453,    4,58454,58397,58457,
    3,58454,58459,58461,    3,58453,    7,58464,  586,58453, 1368,58396,
    7,58471,    5,58472,    5,58471,    7,58476,   10,58471,   16,58396,
    7,58483,    3,58484,    3,58483,    7,58488,  586,58483,44243,58396,
52501,58396,  340,58396,48466,58396, 1397,58396,   25,58396, 1471,58505,
  253,58505,   53,58505,  117,58505,  713,58396,   53,58515,  253,58515,
 1471,58515,  809,58515,   53,58397,  147,58525,  305,58525,  713,58525,
   25,58525, 1471,58397, 1489,58535,  305,58535,   25,58535,  713,58535,
  305,58396,  253,58545, 1471,58545,   53,58545,  253,58397,  305,58553,
   25,58553,  713,58553,    9,58396,46863,58560, 1369,58397, 9891,58565,
 9927,58565,58475,58565,58479,58565,58443,58565,58449,58565,    4,58565,
 9895,58565,19687,58565,20843,58565,21127,58565,58451,58565,58481,58565,
   11,58565, 9875,58593,58435,58593,58471,58593,   17,58397,10111,58601,
10159,58601,58487,58601,58491,58601,36729,58601,58461,58601,58467,58601,
    2,58601,10113,58601,58469,58601,58493,58601,  587,58601,10107,58625,
58453,58625,58483,58625,46863,58396,    9,58632,   11,58396,57815,58637,
57823,58637, 8067,58637, 7979,58637,    3,58637,58601,58647,58617,58637,
 7981,58637,39747,58637,43027,58637,43837,58637,57833,58637, 1369,58637,
 7971,58663,57811,58663,  587,58396,35877,58669,35881,58669, 9439,58669,
 9381,58669,    5,58669,58565,58679,58579,58669,37223,58669,37157,58669,
 9383,58669,37163,58669,35883,58669,   17,58669, 9377,58695,37145,58695,
35867,58695,    6,58396,    7,58396,25793,58705,41019,58705, 8495,58705,
  265,58704,    6,58397,36661,58715,58705,58715,57999,58715,    7,58397,
58703,58723,58027,58723,  265,58396,    6,58728,    7,58728,    6,58729,
58733,58735,    7,58729,58731,58739,  903,56555,17455,58742,17635,58742,
47608,58742, 5771,58742,48560,58742,   11,58743,46863,58755,    9,58742,
  483,58742,46863,58742,   11,58763, 1011,58762,   11,58762,   11,58742,
46863,58770,    7,58743, 8165,58775, 1011,58742,46863,58778,46863,56555,
21036,58782,21036,58783,21037,58782,58787,58789,21037,58783,58785,58793,
54477,58782,55211,58782,55803,58782,52756,58782,51593,58782,40675,58782,
43215,58782,36256,58782,11529,58782,  934,58782,  247,58782, 1216,58782,
  413,58782,17049,58782,   11,58783,  903,58825,    9,58825,    9,58782,
49713,58830,35187,58830,   11,58831, 1011,58782,  903,58838,35187,58782,
    9,58842,  903,58782,   11,58847, 1011,58846,   11,58846,   11,58782,
  903,58854,    5,58782,27021,58859,52915,58859, 9195,58859,20763,58859,
49713,58782,    9,58868, 1275,56555,   17,58872,    4,58872,    7,58876,
    5,58872,    4,58873,58875,58883,    5,58873,58879,58887,57901,58887,
  265,56555,37408,58892,52439,58892,    7,58892,  331,58899,35187,58898,
    7,58893,  375,58905,  241,58892,  483,58909,38305,58893,  375,58913,
35187,58892,    6,58916,    7,58916,    6,58917,58921,58923,    7,58917,
58919,58927,  587,56555, 9441,58930, 9439,58933,17637,58930,10107,58937,
37417,58931,37241,58941,11067,58931, 7947,58945,    7,58930,    4,58949,
    7,58950,58931,58953,    0,58950,58955,58957,    0,58949,    4,58960,
35186,58949,    1,58930,    4,58967,    1,58968,58931,58971,    6,58968,
58973,58975,    6,58967,    4,58978,    8,58967,   16,58930,    4,58985,
    0,58986,    0,58985,    4,58990,35186,58985,22807,58931,37241,58930,
10107,58999,53813,58999,37417,58999, 7947,58930,53813,59007,10107,59007,
11067,59007,10107,58931,17637,59015,48739,59015,37241,59015, 7947,59015,
48739,58930,53813,59025,10107,59025,53813,58931,48739,59031,37241,59031,
 7947,59031,40565,58930,   17,58931, 1985,59041, 3721,59041,58989,59041,
58993,59041, 5299,59041,58957,59041,58963,59041,    1,59041,35233,59041,
35917,59041, 4861,59041,17563,59041,58965,59041,58995,59041,35187,59041,
   53,59071,58949,59071,58985,59071,35187,58930,35881,59079,35877,59079,
37223,59079,37157,59079,    6,59079, 9439,59079, 9381,59079,37163,59079,
 9383,59079,35883,59079,   17,59079,37145,59101, 9377,59101,35867,59101,
    9,58930,57797,59109,57805,59109, 3135,59109, 2009,59109,    0,59109,
59041,59119,59057,59109, 5175,59109,14065,59109,    4,58930, 9366,59129,
 9195,59129,  483,59132,  483,59129, 9195,59136,31103,59129,    5,58930,
25519,59143,    5,58931,25503,59147,24623,59147,30387,59147,58565,59147,
22605,59147,36526,56555,    6,59158,    7,59158,    6,59159,59163,59165,
    7,59159,59161,59169,40920,56555,    7,59172,43400,56555,    7,59177,
16065,56555,    5,59181,    7,59182,    7,59183,56555,59186,    6,59182,
59189,59191,    6,59183,56555,59183,    7,59196,59191,59199,    7,59197,
59195,59203,15029,56555,    5,59206,    6,59209,    6,59208,   14,59206,
   15,59206,    6,59206,    5,59218,    7,59206,59211,59223,  375,59223,
    6,59207,59217,59229,    7,59207,59221,59233,59213,59233,   59,59233,
59215,59233,  331,59233, 1325,59233,  265,59233,43215,56555,    9,59249,
  483,59248,46863,59248,  165,59248, 1011,59248,    7,59259,17125,56555,
    4,59262,    7,59265, 1011,59266, 1011,59265,    7,59270,    7,59271,
 1170,59265,    5,59263,57993,59279,58313,59279,17129,59279,42811,59263,
42811,59262,44243,59262,42810,59262,59287,59293,42810,59263,59289,59297,
  375,59262,    6,59262,59269,59303,59273,59303,59277,59303,    7,59262,
38305,59310,    6,59263,59275,59315,59311,59315,    7,59263,59303,59321,
38305,59262,    7,59324,54295,56555,11731,59328,  113,59328,    5,59328,
    5,59329,57901,59337,17455,56555,    7,59341,    4,59342,    4,59343,
   16,59341,   17,59341,55211,59340,  803,59340,  903,59340,    9,59340,
    4,59340,59351,59361,    5,59340,59345,59365,59349,59365,    4,59341,
    7,59370,59365,59373,    5,59341,59347,59377,    4,56554,26454,59381,
26375,59381, 8672,59381, 8743,59381,41692,59381,41607,59381, 8770,59381,
 8729,59381, 3795,59381,47953,59381,48062,59381,47961,59381,48009,59404,
48009,59381,47961,59408,26219,59381,26415,59412,41417,59381,41653,59416,
44832,59381,31770,59381, 8757,59381, 8647,59424,41653,59381,41417,59428,
26415,59381,26219,59432, 8647,59381,  305,59436, 8757,59436, 8605,59381,
47580,59381,47933,59445, 8684,59381, 8717,59449, 8916,59381,44243,59381,
  483,59454,41502,59381,41559,59459,  340,59381, 8717,59463, 3785,59463,
 8495,59463,  375,59381, 8861,59470,46863,59470,47488,59381,26292,59381,
26331,59479,    9,59381,31103,59482,  305,59381, 8647,59486,    7,59381,
    1,59491,  264,59492,  264,59493,25793,59491,26415,59499,41019,59491,
41653,59503, 8495,59491,  305,59507, 8757,59507, 8495,59490, 8717,59513,
41019,59490,41559,59517,  265,59491,59497,59521, 8861,59521,46863,59521,
25793,59490,26331,59529,  265,59490, 8717,59533,59495,59533, 3785,59533,
 8495,59533,31103,59381,    9,59542,  483,59381,44243,59546,46863,59381,
  265,59551,48009,59553,  265,59550,47933,59557,  375,59550,41019,59381,
    7,59563,41417,59565,    7,59562,41559,59569,  265,59381,46863,59573,
47961,59575,46863,59572,47933,59579,    7,59573, 8647,59583,    7,59572,
 8717,59587, 3785,59587, 8495,59587,25793,59381,    7,59595,26219,59597,
    7,59594,26331,59601, 8495,59381,    7,59604, 8717,59607,    7,59605,
 8647,59611, 8861,59381,  375,59614,    5,56554,26777,59619, 9741,59619,
 9745,59619,26781,59619,30349,59619,26857,59619,26933,59619,    2,59619,
    7,59634,57353,59637,57501,59637,58637,59637,    6,59635, 9777,59619,
 1368,59619,57501,59649,57353,59649,58637,59649,57515,59619,57373,59619,
58663,59619, 9771,59619,40077,59619,31598,59619,55462,59619,50733,59619,
37519,59619,35690,59619, 8982,59619,55211,59619,  483,59678,  668,59619,
 9731,59683,26625,59683, 1419,59619, 9731,59689,26625,59689,   17,59619,
 8861,59694,    9,59619,  587,59698, 9731,59701,26625,59701,  375,59619,
35187,59706,    6,59619,    7,59619,    5,59713,    2,59712,57353,59717,
57501,59717,58637,59717,    5,59712,58396,59725,59717,59727,35187,59725,
56555,59730,59717,59733,56555,59725,35187,59736,59717,59739,    7,59618,
 3867,59743, 8277,59743, 3997,59743, 4067,59743, 9459,59743, 8953,59743,
31103,59619,26625,59756,  483,59619,55211,59760,  587,59619,    9,59764,
 9731,59767,26625,59767,35187,59619,  375,59772,26625,59619,31103,59776,
 8861,59619,    7,59781,   17,59780,    6,56554,36633,59787,36627,59787,
    1,59787,    4,59792,57253,59795,57381,59795,57577,59795,59109,59795,
    5,59792,38304,59787,39987,59787,36544,59787, 9875,59811,20501,59811,
   11,59787,35187,59816,20501,59819, 9875,59819,    5,59787,    1,59824,
    4,59787,    6,59829, 1369,59831,56555,59833,    1,59828,57253,59837,
57381,59837,57577,59837,59109,59837,59835,59837,    6,59828,58930,59849,
59837,59851,  587,59849,56555,59854,59837,59857,56555,59849,  587,59860,
59837,59863,35187,59787,   11,59866,20501,59869, 9875,59869,    7,56554,
 4904,59875,17586,59875,17609,59875,40685,59875,40039,59875,42991,59875,
 9484,59875,  272,59875, 1476,59875,  280,59875,  949,59875, 1517,59875,
 1197,59875, 4903,59875,    9,59902,17579,59875,    9,59906,   11,59875,
 9377,59910,    9,59875, 4903,59914,17579,59914,  253,59875,  265,59920,
   53,59875,  265,59924, 1471,59875,  265,59928,    5,59874, 3867,59933,
 8277,59933, 4067,59933, 3997,59933, 8953,59933, 9459,59933,  265,59875,
  253,59946, 1471,59946,   53,59946, 9377,59875,   11,59954,    5,59955,
    7,56555,59826,59960,59827,59961,59963,59965,59827,59960,59826,59961,
59969,59971,59804,59960,59805,59961,59975,59977,59805,59960,59804,59961,
59981,59983,21036,59960,14072,59960,14073,59960,14072,59961,59991,59993,
59183,59960,59191,59997,59183,59961,59185,60001, 4970,59960, 4971,59960,
 4970,59961,60007,60009,16169,59961, 9617,60013,39786,59961,59807,59961,
59806,59961,28715,59960,28791,60023,29731,60023,29659,60023,29041,60023,
21036,59961,21037,59960,60033,60035,38304,59961,59787,60038,  483,60038,
38304,59960,60019,60045,59787,60045,  483,60045,18967,59961,    5,60053,
    5,60052,    2,59961,    0,60059,56555,60061,    5,60063,59961,60065,
    7,60064,60067,60069,59960,60065,    6,60064,60073,60075,    1,59961,
    3,60079,    5,60081,56555,60082,56555,60081,    5,60086,    5,60087,
 1011,60079,56555,60093,    5,60079,    1,59960,21036,60099,    3,60099,
56555,60103,    5,60105,    5,60104,    5,60103,56555,60110,    5,60099,
18967,60114,18967,60099,    5,60118,    5,60119,    2,59960,59811,60125,
36545,60125,59787,60129,59819,60125,59869,60125,   15,60125,29659,59961,
29077,60139,39787,59961,60045,60143,32103,59961,41746,59961,26106,59961,
 8800,59961,36526,59960,40920,59960, 1163,59961,41019,59961,   11,60160,
35187,60161,59619,59961, 4971,59961,60005,60169,14073,59961,59989,60173,
 4555,59961,  559,59961,   39,59961, 8495,59961,35187,60183,   11,60182,
15029,59960,  375,60189,17125,59960,38305,60192,   11,59961,41019,60196,
25793,60196, 8495,60196,  265,59961, 3447,60205,10831,60205,  305,60205,
17125,60205,11731,60205,  567,59961,46863,60217,   15,59961, 3651,60221,
 1993,60221, 4903,60221,17579,60221,  241,59960,38305,59960,60017,60233,
60021,60233,60041,60233,60043,60233,60039,60233,59787,60243,  483,60243,
17125,60232, 1011,59960,59279,60251,21037,59961,59987,60255,   11,60255,
28715,59961,29533,60261,20273,60261, 9617,60261,35187,59960,25793,60269,
41019,60269, 8495,60269,58715,60269,  265,60268,  265,59960,  331,60281,
35187,60280,38305,59961,37845,60287,37844,60286,60289,60291,37844,60287,
37845,60286,60295,60297,60048,60287,59787,60287,60045,60302,60050,60287,
60045,60287,59787,60308,  483,60308,  483,60287,60045,60314, 1011,59961,
25793,59961,35187,60321,   11,60320,    4,59960,60091,60327,60107,60327,
60033,60327,60101,60327,59337,60327,58191,60327,58211,60327,60057,60327,
60117,60327,60121,60327,21549,60327,21105,60327,19625,60327,58887,60327,
17591,60327,    5,59960,    1,60359,    3,60361,60205,60363,60255,60359,
    4,59961,60085,60369,60089,60369,60113,60369,60109,60369,57685,60369,
59335,60369,58201,60369,58221,60369,57775,60369,57777,60369,60095,60369,
60055,60369,60123,60369,31103,60369,21575,60369,58881,60369,58009,60369,
17579,60369, 4903,60369,48408,60369,46863,60369,  483,60410,  483,60369,
46863,60414,    5,59961,18967,60418,60327,60421, 1368,60419,    2,60419,
    7,60426,    7,60419,    2,60430,59787,59961,38304,60435,60287,60437,
38304,60434,60233,60441,  483,59961,38304,60445,60287,60447,38304,60444,
60233,60451,    5,56555,60081,60454,60369,60457,60103,60454,60369,60461,
    1,60455,    3,60464,    1,60454,59491,60469,59490,60469,59381,60469,
    7,60474,    7,60475,    5,60469,59961,60481,    6,60468,60473,60485,
60477,60485,    7,60468,60471,60491,59381,60491,    6,60469,59381,60497,
60491,60498,60479,60497,60494,60497,60491,60497,59381,60506,    7,60469,
59381,60510,60485,60513,60485,60511,59381,60517,    2,60454,60261,60521,
60483,60521,53813,60455,  483,60527,52915,60455,46863,60531,59875,60455,
 9801,60454,60369,60537,48735,60454,60369,60541,10107,60455,  483,60545,
 9195,60455,46863,60549,54295,60454,60369,60553,  587,60455,17455,60557,
11731,60557,    9,60455, 8861,60563,   17,60455,  587,60567,26625,60569,
 9731,60569,60467,60569,  483,60454,53813,60577,10107,60577,20763,60455,
46863,60583,46863,60454,27021,60587,52915,60587, 9195,60587,20763,60587,
 1275,60454,60369,60597,  587,60454,25519,60601,27021,60455,46863,60605,
    6,60454,38881,60609,59381,60455,30091,60455,31103,60615,    4,56555,
    2,60619,    0,60621,56555,60623,    5,60625,    7,60621,60627,60629,
    1,60618,59689,60633, 1418,60633,59619,60637,59683,60633,  669,60633,
59619,60643,60569,60633,59701,60633,59767,60633,   15,60633, 1369,60652,
59619,60655, 1369,60633,   15,60658,59619,60661,  842,60619, 9377,60665,
59787,60619, 9377,60618,  483,60671,  587,60619,  483,60674, 9377,60677,
 9377,60675,  483,60681,21527,60619,    9,60685,31103,60619,  587,60689,
  587,60618, 9366,60693, 9195,60693,  483,60696,  483,60693, 9195,60700,
31103,60693,  483,60619,  587,60706, 9377,60709, 9377,60707,  587,60707,
 9195,60715,    7,60618,59337,60719,58191,60719,58211,60719,21105,60719,
21549,60719,19625,60719,58887,60719,17591,60719,    6,60619,    1,60737,
    4,60738,    4,60737,    1,60742, 1369,60737,56555,60747,60741,60749,
60745,60749,    7,60619,    2,60755,21183,60755, 9377,60755,59619,60619,
38305,60619,    3,60764,    2,60764,56555,60765,    6,60770,60769,60773,
    6,60765,56555,60776,60769,60779, 1011,60619,46862,60782,46862,60783,
46863,60783,60785,60789,46863,60782,60787,60793,    6,56555,36303,60797,
36302,60796,60799,60801,36303,60796,36302,60797,60805,60807,40946,60796,
40946,60797,60765,60796,60769,60815,    2,60797,    0,60818,40947,60796,
60813,60823,40947,60797,60811,60827,60765,60797,60767,60831,59381,60797,
   17,60797,35187,60837,20501,60839,60125,60839,60821,60839, 9875,60839,
35187,60796,58723,60849,    5,60796,38881,60853,    0,    3, 8169,60857,
 8028,60857, 8173,60857, 8214,60857, 8167,60857, 8154,60857, 8026,60857,
 8054,60857,17728,60857,60210,60857,60283,60857,58128,60857,58023,60857,
57476,60857,56854,60857,56856,60857,58901,60857,58906,60857,58122,60857,
58066,60857,56810,60857,56822,60857,16743,60857,16696,60857, 4810,60857,
16745,60857,16729,60857,16714,60857, 6648,60857, 2079,60857,  375,60916,
 2086,60857,16733,60857,16565,60857,16683,60924,16692,60857,16735,60857,
16739,60857,51942,60857,44534,60857,42383,60857,44243,60938,44440,60857,
16747,60857,   75,60857, 6625,60946, 6632,60857, 6645,60857,60079,60857,
    5,60955,60327,60957,    5,60954,60369,60961,60096,60857,60369,60965,
 1325,60856,40829,60969, 1173,60857,17591,60856,17603,60975,10039,60857,
 1275,60979,10041,60981,38560,60857, 1205,60985, 1203,60857,38305,60988,
 1205,60991,38514,60857, 1007,60995,40741,60856,40829,60999,  531,60856,
 1290,60856,    0,61005,    5,61006,    5,61005,    0,61010,40769,60856,
40829,61015,38548,60857, 1325,61019,  177,60857,38305,61022,   59,61025,
17053,60857,  483,61028,10081,61031, 1009,60857,38305,61034, 1007,61037,
 1365,60857,38305,61040, 1325,61043,38566,60857,   59,61047,17054,60857,
10081,61051,42109,60857,38305,61054,42103,61057, 9527,60857,  483,61060,
 9525,61063,42110,60857,42103,61067, 9528,60857, 9525,61071,  386,60857,
56555,61074, 8150,60857,  113,61078,  347,60857,56555,61082,58905,60857,
  375,61086,45432,60857,56555,61090,43099,60857,56555,61094,40829,60857,
 1325,61099,40741,61099,40769,61099,60535,60857,    9,61107,57916,60857,
    9,61111,57851,60857,    9,61115,17727,60857,  113,61118,57060,60857,
 8309,60857,60230,60857,57986,60857,57998,60857,60268,60857,58352,60857,
58704,60857,13820,60857,13772,60857,57994,60857,58056,60857,42155,61144,
36101,60857,  375,61149,37407,60857,47392,60857,36532,60857,36536,60857,
57284,60857,58760,60857,58762,60857,58846,60857,58372,60857,57278,60857,
57996,60857,57470,60857,  305,61174,60205,60857,  305,61178,58374,60857,
58830,60857,57586,60857,57480,60857,57230,60857,57568,60857,40684,60857,
36542,60857,  375,61197,42990,60857,40038,60857,37498,60857,36754,60857,
35796,60857, 8225,60857, 8242,60857,  128,60857, 7971,61214,  101,60857,
 7971,61218,37362,60857,48122,60857,12526,60857, 6698,60857,47690,60857,
38704,60857,11943,60857,    9,61235,12343,60857,    5,61239,    4,61238,
61241,61243,    4,61239,    5,61238,61247,61249,40132,60857,  331,61253,
   59,61253,   97,61253, 1325,61253, 8148,60857,48753,61263,10081,61263,
11759,61263,39044,60857,  331,61271, 1325,61271,  571,61271,   59,61271,
42338,60857,48753,61281,44451,61281,10081,61281,42959,60857,48753,61289,
44451,61289,42825,61289,10081,61289,  629,60857,56555,61298,38305,61298,
  289,60857,  587,61305,10287,60857,17660,60857,10262,60857,40130,60857,
  331,61315,   59,61315, 1325,61315,53780,60857,48753,61323,10081,61323,
60668,60857,    9,61329, 8213,60857,    9,61332,11813,60857,    9,61337,
17030,60857, 8211,60857, 8301,60857, 8209,60857,38110,60857, 8052,60857,
    9,61350,10464,60857,    9,61355,10527,60857,    9,61359, 4727,60857,
    9,61363,11989,60857,   11,61367,    5,61368,    6,61367,    5,61372,
    5,61367,    6,61376,    6,61377,    7,61367,61381,61383,   15,61367,
    6,61366,61387,61389,   14,61367,    7,61366,61379,61395,61375,61395,
61371,61395,61393,61395,12371,60857,    5,61405,    4,61405,   12,61405,
   13,61404,61411,61413,   13,61405,   12,61404,61417,61419,    5,61404,
61409,61423,    4,61404,61407,61427, 6625,60857,44243,61430,  375,61430,
   75,61430,    9,61431, 6685,60857,  483,61440,46863,61440,17060,60857,
35768,60857,50524,60857,52806,60857,50480,60857,36296,60857,50990,60857,
  510,60857,56555,61460,47608,60857,36293,60857,  483,61466,  295,60857,
49713,61470, 1291,60857,61009,61475,61013,61475,20033,61475, 1831,61475,
 1881,61475,19319,61475,    4,61475,19317,61489,15899,61475, 4579,61475,
48561,60857,    9,61497,  922,60857,56555,61500,51937,60857,  375,61504,
57915,60857,57859,61508,    9,61511,39234,60857,60853,61515,60609,61515,
 9525,61515,42103,61515, 9517,61515,41989,61515,39485,61515,39481,61515,
57855,61515, 9519,61515,41995,61515,39487,61515,   15,61515, 9513,61541,
41941,61541,39477,61541,50958,60857,    9,61548,35761,60857,    9,61552,
35719,60857,  375,61557,57482,60857,57852,61561,57811,61561,    9,61564,
    9,61561,57811,61568,57522,60857,  483,61572,46863,61572, 1072,60857,
 1108,60857,49713,61580,  524,60857,    4,61585,19301,61587,19311,61585,
 3195,61585, 1965,61585,15899,61585, 4579,61585,40704,60857,    7,61601,
40799,61603,40813,61601, 7961,61601, 7951,61601, 7953,61601,35893,61601,
37897,61601,38299,61601, 1275,61601, 7947,61621,52756,60857, 1011,61624,
10245,60857,37339,60857,   33,60857,10385,61632,    9,61635, 7971,60857,
  101,61638,  128,61638,    9,61638,  113,61644,  483,61638,48753,61649,
10081,61649,11759,61649,  113,61638,    9,61656,   21,60857,38305,61660,
  331,61663,   59,61663,   97,61663, 1325,61663,47640,60857,56555,61672,
17635,60857,12377,61676,11731,60857,13737,61680,  567,60857,46863,61685,
55211,60857,44243,60857, 6625,61690,42383,61690,58116,61690,42155,61690,
56555,61698,56555,61690,42155,61702, 1505,60857,38057,61706,  288,60857,
46863,61711,48466,60857,56555,61714,   11,60857,  340,61719,  341,61719,
  264,61718,61721,61725,    7,61719,  265,61728,61725,61731,  265,61729,
  264,61719,61735,61737,56555,61719,57859,61741,    9,61743,  483,61718,
 4579,61747,15899,61747, 3195,61747, 1965,61747,  265,61719,    7,61756,
61725,61759,56555,61718,57852,61763,57811,61763,    9,61766,    9,61763,
57811,61770,  265,61718,61723,61775,46863,61775,    9,60857, 8213,61780,
 8052,61780, 7971,61780,  113,61786,36527,61780,58782,61780,58362,61780,
 8241,61780,  113,61780, 7971,61798,35761,61780,50958,61780,  483,61780,
56555,61806, 1011,61780,49713,61810,38305,61780,38299,61815,37897,61815,
 7961,61815, 7951,61815,35893,61815, 7953,61815, 1275,61815, 7947,61829,
49713,61780, 1011,61832,56555,61780,46863,61836,  483,61836,46863,61780,
56555,61842, 7563,60857, 1275,61847, 7565,61849, 7569,61849, 7573,61849,
 7065,60857,35187,61857,10089,60857,   16,61861,   16,61860,   17,61861,
61865,61867,   17,61860,61863,61871,10257,60857,  903,61874, 8241,60857,
    9,61878, 3255,60857,    9,61883,48789,60857,   16,61887,   16,61886,
   17,61887,61891,61893,   17,61886,61889,61897,37357,60857,  903,61900,
 3499,60857,    9,61905, 3445,60857,    9,61909,38184,60857,  375,61913,
16722,60857,16543,61917,16679,61917,16537,61917,35187,61916,13922,60857,
13753,61927, 4805,60857,  375,61930,16683,60857,16565,61934,  375,61934,
 6515,60857,    9,61941,59824,60857,60369,61945,    9,61945, 9520,60857,
    9,61951,16711,60857,16659,61954,    8,60856,    3,61959,    6,61960,
61601,61963,61815,61963,    6,61959,    3,61968,61601,61971,61815,61971,
61829,61959,61621,61959, 1274,61959,61815,61981,61601,61981,   16,60856,
   10,60856,    5,61989,    0,61990,61585,61993,61747,61993,    0,61989,
    5,61998,61585,62001,61747,62001,57811,61989,59933,61989,59743,61989,
 8093,61989, 3837,61989,39619,61989,51421,61989,53703,61989,42435,61989,
 4287,61989, 4303,61989,53487,61989,42113,61989, 9839,61989, 9579,61989,
    9,61989,  113,62036,  128,61989,  101,61989,  113,61989,    9,62044,
57859,60857,57915,62048,    9,62051,    9,62049,57915,62055,   11,60856,
  483,62059,    9,60856,57889,62063, 5185,62063,11243,62063,12557,62063,
11251,62063, 5177,62063,   16,60857,57293,62077,35603,62077,58669,62077,
59079,62077,55005,62077,   17,60856,61685,62089,  483,62089,   15,60856,
40829,62095,   10,60857,21183,62099,  759,62099,   47,62099,  959,62099,
  203,62099,  107,62099,   85,62099,   67,62099,    9,62115,  113,60857,
 8150,62118,17727,62118,13737,62118,    9,62118, 7971,62126,17025,62118,
 7971,62118,    9,62132,10385,60857,    9,62137,   33,62139,   33,62136,
    9,62143,  165,60857,17049,62146,17025,60857, 1275,62151, 7947,62153,
48739,62153,17637,62153,17029,62153,37241,62153,  113,62150,17049,60857,
  165,62166,10247,60857,37347,60857,10249,60857,16659,60857,16711,62176,
37408,60857,56555,62180,16531,62180,  340,60857,51803,62187,  331,62187,
 1325,62187,   59,62187,52439,60857,56555,62196,52563,60857,  265,62201,
 1413,60857,56555,62204,  256,60857,56555,62208,38305,62208,  566,60857,
61987,62215, 9377,62215,37325,62215,10219,62215,  959,62215,   47,62215,
  759,62215,  587,62215,20763,62215,42810,60857,43073,62235,42827,62235,
58703,62235,60849,62235,58027,62235,42821,62235, 1325,62235,   59,62235,
  331,62235,  265,62235,42613,62235,56555,62257,  241,62234,  580,60857,
20033,62263,59143,62263,60601,62263,58029,62263,55210,60857,31103,62273,
37375,60857, 1347,60857,37409,60857,  375,62280,  375,60857,58905,62284,
16683,62284, 4805,62284,58126,62284, 6625,62284, 2079,62284,51937,62284,
  305,62284,56555,62300,56555,62284,  305,62304,37409,62284,  803,60857,
37608,60857,  305,60857,60205,62314,57470,62314,  375,62314,56555,62320,
56555,62314,  375,62324,58116,60857,44243,62328,58126,60857,  375,62332,
42155,60857,58056,62336,44243,62336,56555,62340,  483,62336,48753,62345,
44451,62345,10081,62345,56555,62336,44243,62352,53517,60857,  483,62356,
48753,62359,10081,62359,  251,60857,38305,62364,  331,62367, 1325,62367,
   59,62367,  555,60857,38305,62374,  331,62377, 1325,62377,  571,62377,
   59,62377,60612,60857,    7,62387,36273,60857,    7,62391,59787,60857,
60619,62394,    9,62397,    5,62394,60369,62401,    9,62401,    5,62395,
60327,62407,60719,62407,57901,62407,   17,62407,59381,60857,60455,62416,
    7,62419, 9513,60857,    5,62423,   17,62425,    5,62422,    9,62429,
58362,60857,  903,62432,    9,62432,58348,60857,    7,62438,58782,60857,
  903,62442,    9,62442,58396,60857,    7,62448,58742,60857,    9,62453,
  483,62452,46863,62452,60763,60857,    7,62461,  903,60857,58782,62464,
58362,62464,37357,62464,10257,62464,  483,62464,56555,62474,46863,62464,
56555,62478,56555,62464,    9,62483,46863,62482,  483,62482,38057,62464,
    7,62491,  265,60857,46863,62495,   11,62497,   11,62494,46863,62501,
    7,62494,51803,62505,  331,62505, 1325,62505,   59,62505,    7,62495,
  375,62515,35187,60857,59960,62518,16722,62518,    7,62518,56555,62524,
16531,62524,56555,62518,    7,62530,16531,62518,    7,62534,46863,60857,
36527,62538,58742,62538,57522,62538,12377,62538, 6685,62538, 1011,62538,
  903,62538,56555,62552,    9,62538,56555,62556,56555,62538,  903,62560,
    9,62560,36527,60857,    7,62567,  331,62569,    9,62566,46863,62566,
  483,62566,    7,62566,  375,62579,38305,60857,42109,62582,42103,62585,
 1205,62583, 1203,62589, 1007,62583, 1009,62593, 1203,62582, 1205,62597,
 1009,62582, 1007,62601,  177,62582,   59,62605, 1365,62582, 1325,62609,
  571,62583,  555,62613,   97,62583,   21,62617,    5,62582,    6,62621,
    5,62622,62583,62625,    2,62622,62627,62629,    2,62621,    6,62632,
  482,62621,    3,62582,    6,62639,    3,62640,62583,62643,    4,62640,
62645,62647,    4,62639,    6,62650,    8,62639,   14,62582,    6,62657,
    2,62658,    2,62657,    6,62662,  482,62657, 1274,62582,    6,62669,
    4,62670,    4,62669,    6,62674,    8,62669,  256,62582,  629,62582,
  555,62582,   59,62685,  331,62685, 1325,62685,  571,62685,   21,62582,
 1325,62695,  331,62695,   59,62695,   97,62695, 1325,62583, 1365,62705,
  251,62705,   21,62705,  555,62705,   59,62583,  177,62715,  251,62715,
  555,62715,   21,62715,  251,62582,  331,62725,   59,62725, 1325,62725,
  331,62583,  251,62733,  555,62733,   21,62733,   15,62583,10085,62741,
10093,62741,62661,62741,62665,62741,40909,62741,62629,62741,62635,62741,
    3,62741,10087,62741,62637,62741,62667,62741,  483,62741,10081,62765,
62621,62765,62657,62765, 1275,62583,10005,62773,10041,62773,62673,62773,
62677,62773,62647,62773,62653,62773,    5,62773,10009,62773,23879,62773,
31937,62773,30399,62773,62655,62773,62679,62773,    9,62773,10001,62801,
62639,62801,62669,62801,  483,62582,39485,62809,39481,62809, 9525,62809,
 9517,62809,    4,62809,62773,62819,62787,62809,42103,62809,41989,62809,
 9519,62809,41995,62809,57855,62809,60853,62809,60609,62809,39487,62809,
   15,62809, 9513,62841,41941,62841,39477,62841,    9,62582,61971,62849,
61963,62849, 7961,62849, 7951,62849,    2,62849,62741,62859,62757,62849,
 7953,62849,35893,62849,38299,62849,37897,62849,61981,62849, 1275,62849,
 7947,62875,61959,62875,    6,62582,    7,62582,58703,62883,58027,62883,
60849,62883,   59,62883, 1325,62883,  331,62883,  265,62883,42613,62883,
56555,62899,  241,62882,    7,62583,58715,62905,58056,62905,40799,62905,
  375,62905,56555,62905,44243,62914,44243,62905,56555,62918,  265,62583,
  375,62923,62881,62923,  241,62582,    6,62928,    7,62928,    6,62929,
62933,62935,    7,62929,62931,62939, 1011,60857,52756,62942,46863,62942,
  483,62942,    9,62942,49713,62950,49713,62942,    9,62954,    7,62943,
10107,62959,53813,62959,49713,60857,22807,62965, 1108,62964,  295,62964,
    9,62964, 1011,62972, 1011,62964,    9,62976,    4,62964,31103,62981,
  241,60857,59960,62984,42810,62984,    7,62984,56555,62990,38305,62990,
56555,62984,    7,62996,38305,62984,    6,63000,    7,63000,    6,63001,
63005,63007,    7,63001,63003,63011,  483,60857, 9527,63014, 9525,63017,
17053,63014,10081,63021,11759,63015, 7971,63025,44451,63015,42155,63029,
    0,63014,    5,63033,    0,63034,63015,63037,    7,63034,63039,63041,
    7,63033,    5,63044,   10,63033,    6,63014,    5,63051,    6,63052,
63015,63055,    1,63052,63057,63059,    1,63051,    5,63062,38304,63051,
   14,63014,    5,63069,    1,63070,    1,63069,    5,63074,38304,63069,
36527,63014,58742,63014,57522,63014,12377,63014, 6685,63014, 7971,63014,
48753,63091,10081,63091,11759,63091,42155,63014,10081,63099,48753,63099,
44451,63099,10081,63015,17053,63107,53517,63107,42155,63107, 7971,63107,
53517,63014,48753,63117,10081,63117,48753,63015,53517,63123, 7971,63123,
42155,63123,36293,63014,   17,63015,   11,63015,    9,63014,56555,63136,
   15,63015, 1995,63141, 3755,63141,63073,63141,63077,63141, 5303,63141,
63059,63141,63065,63141,    0,63141,38403,63141,39943,63141, 4917,63141,
17013,63141,63067,63141,63079,63141,38305,63141,   59,63171,63051,63171,
63069,63171,  903,63014,56555,63178, 1011,63014,   11,63014,61993,63185,
62001,63185, 3195,63185, 1965,63185,    1,63185,63141,63195,63157,63185,
 4579,63185,15899,63185,38305,63014,39481,63205,39485,63205,42103,63205,
41989,63205,    7,63205, 9525,63205, 9517,63205,41995,63205, 9519,63205,
57855,63205,60609,63205,60853,63205,39487,63205,   15,63205,41941,63233,
 9513,63233,39477,63233,    4,63014,20033,63241,59143,63241,60601,63241,
58029,63241,63133,63241,    5,63014,61987,63253, 9377,63253,37325,63253,
10219,63253,  959,63253,   47,63253,  759,63253,  587,63253,20763,63253,
    4,63015,    7,63272,63253,63275,20029,63273,59147,63273,21103,63273,
19781,63273,19301,63273,62773,63273,    5,63015,  803,63291,56555,63014,
  903,63294,    9,63294,40674,60857,    6,63300,    7,63300,    6,63301,
63305,63307,    7,63301,63303,63311,38266,60857,    7,63315,36752,60857,
    7,63318,16937,60857,  580,63322,  483,63322,    4,63327,    4,63326,
49631,63322,49630,63322,  581,63322,    4,63322,  483,63338,46863,63338,
    5,63322,63329,63345,    4,63323,63333,63349,63337,63349,    5,63323,
63335,63355,63325,63355,63331,63355,63341,63355,63343,63355,46863,63322,
    4,63366,63355,63369,    4,63367,63345,63373,38057,60857,    5,63376,
    6,63379,    6,63378,   14,63376,   15,63376, 1505,63376,    6,63376,
    5,63390,    7,63376,63381,63395,  375,63395,    6,63377,63387,63401,
    7,63377,63393,63405,63383,63405,38161,63405,   59,63405,63385,63405,
  331,63405, 1325,63405,  265,63405,  903,63376,    7,63423,16531,60857,
 1275,63427,16711,63429,37408,63426,    7,63426,16543,63435,16679,63435,
16537,63435,35187,63434,    7,63427,16565,63445,35187,63426,    7,63448,
12377,60857,    9,63453,46863,63452,  483,63452,17635,63452,13737,60857,
  113,63462,11731,63462,    5,63462,13753,63469,    5,63463,13751,63473,
13917,63473,13743,63473,60619,60857,59787,63480,    9,63483,60455,60857,
59381,63486,    7,63489,    5,60856,45491,63493,42800,63493,59694,63493,
10374,63493,60563,63493, 9606,63493,42134,63493,  629,63493,  705,63493,
  101,63493,  299,63493,  828,63493,  128,63493,  394,63493,48122,63493,
  803,63493,  483,63524,42613,63493,   17,63528,51992,63493,  375,63493,
  241,63534,49713,63534,10291,63493,   17,63540,  256,63493,  113,63493,
    9,63546,   17,63493,42613,63550,10291,63550,59619,63550, 9565,63550,
41941,63550,    9,63493,  113,63562,    7,63493,21605,63567,  241,63566,
    7,63492,59933,63573,59743,63573,57811,63573, 8093,63573, 3837,63573,
53703,63573, 4287,63573,42435,63573, 4303,63573,53487,63573, 9839,63573,
42113,63573, 9579,63573,39619,63573,51421,63573,31103,63493,46863,63493,
12377,63606,  483,63493,  803,63610,49713,63493,  375,63614,56555,63493,
    5,63619,    6,63621,    6,63620,   14,63619,   15,63619,    6,63618,
63629,63631,    7,63618,63625,63635,63627,63635,    7,63619,63623,63641,
    6,63619,    5,63644,63635,63647,  241,63493,  375,63650,    7,63650,
59619,63493,    7,63657,   17,63656,12377,63493,46863,63662, 9565,63493,
    7,63667,   17,63666,41941,63493,    7,63673,   17,63672,    4,60856,
20305,63679, 9641,63679, 9645,63679,20309,63679,21081,63679,20323,63679,
20387,63679,    3,63679,    6,63694,61601,63697,61815,63697,62849,63697,
    6,63695, 9701,63679, 1274,63679,61815,63709,61601,63709,62849,63709,
61829,63679,61621,63679,62875,63679, 9719,63679,43005,63679,58056,63679,
  386,63679,  347,63679,  767,63679,31103,63733,  524,63679, 9617,63737,
20273,63737, 1291,63679, 9617,63743,20273,63743,  305,63679,  375,63748,
  375,63679,  305,63752,44243,63679,56555,63756,   11,63679,  483,63760,
 9617,63763,20273,63763,    7,63679,38305,63769,56555,63771,    6,63679,
    4,63775,    3,63774,61601,63779,61815,63779,62849,63779,    4,63774,
62582,63787,63779,63789,38305,63787,60857,63792,63779,63795,60857,63787,
38305,63798,63779,63801,    7,63678,63253,63805,62215,63805,  483,63679,
   11,63810, 9617,63813,20273,63813,56555,63679,44243,63818,    7,60856,
40787,63823,40793,63823,    0,63823,    5,63828,61475,63831,61585,63831,
61747,63831,63185,63831,36001,63823,26106,63823,32103,63823,41746,63823,
43005,63823, 8800,63823,59910,63823,36539,63823,37595,63823,36049,63823,
63253,63823,62215,63823,61305,63823,48975,63823,48245,63823,48451,63823,
60707,63823,  386,63823,  347,63823,  510,63823,60755,63823, 9852,63823,
53500,63823,36041,63823,37573,63823,36275,63823,  375,63823,  305,63892,
  273,63823,  281,63823, 1477,63823, 1516,63823,  948,63823,40704,63823,
10001,63907,27533,63907, 8495,63823,   11,63912,48885,63823,  483,63917,
41019,63823,   11,63920,  567,63823,63493,63925,  165,63823,  903,63928,
   11,63823,25793,63932,41019,63932, 8495,63932,59875,63932, 9805,63932,
53391,63932,60618,63823,  483,63947,    9,63823,  483,63950,38305,63950,
27533,63955,10001,63955, 1505,63823, 1011,63960,  305,63823,  375,63964,
    4,63823,63610,63969,63291,63969,63493,63969,  483,63974,  483,63969,
63493,63978,56555,63968,  483,63983,    5,63823,    7,63987, 1275,63989,
60857,63991,    0,63986,61475,63995,61585,63995,61747,63995,63185,63995,
63993,63995,    7,63986,63014,64007,63995,64009,  483,64007,60857,64012,
63995,64015,60857,64007,  483,64018,63995,64021,    4,63822,63253,64025,
62215,64025,    5,63822,59743,64031,59933,64031,57811,64031, 8093,64031,
 3837,64031,42435,64031, 4303,64031,53703,64031, 4287,64031,42113,64031,
 9579,64031,53487,64031, 9839,64031,51421,64031,39619,64031,25793,63823,
   11,64062,  903,63823,  165,64066,38305,63823,    9,64070,27533,64073,
10001,64073, 1011,63823, 1505,64078,56555,63823,    4,64082,  483,64085,
  483,63823,    9,64088,59875,63823,   11,64092,    5,64093, 9805,63823,
   11,64098,    5,64099,53391,63823,   11,64104,    5,64105,    6,60856,
60454,64111,60369,64113,    5,64111,56555,64116,60369,64119,56555,64111,
   17,64122,    4,64122,    7,64126,    5,64122,60369,64131,    5,64123,
60327,64135,60719,64135,64129,64135,57901,64135,    4,64123,64125,64145,
    7,60857,16539,64149,16683,64151,  264,64149,  264,64148,    3,64149,
16530,64158,16530,64159,    1,64158,58396,64148,58348,64148,36527,64148,
  375,64171,40674,64148,36752,64148,  331,64149, 1325,64149,   59,64149,
38057,64148,  375,64185,16531,64148,64161,64189,16543,64189,16679,64189,
16537,64189,35187,64188,   17,64149,  241,64201,38305,64149,42383,64205,
 6625,64205,58116,64205,42155,64205,56555,64212,56555,64205,42155,64216,
16531,64149,64163,64221,16659,64221,48885,64149,56555,64227,   15,64149,
  483,64231,38305,64231,27533,64235,64165,64235,10001,64235,35187,64148,
56555,64242,16531,64242,  265,64148,64155,64249,51803,64249,  331,64249,
 1325,64249,   59,64249,  241,64148,56555,64260,38305,64260,38305,64148,
58703,64267,58027,64267,60849,64267,   59,64267, 1325,64267,  331,64267,
  265,64267,42613,64267,56555,64283,  241,64266,  265,64149,64157,64289,
41941,64289,51229,64289, 4213,64289, 8757,64289, 9565,64289,59619,64289,
  305,64289,  713,64289,   25,64289, 8165,64289, 9617,64289,20273,64289,
    4,64148,57293,64317,35603,64317,58669,64317,59079,64317,55005,64317,
    5,64148,    3,64329,    1,64331,64205,64333,21183,64329,  759,64329,
   47,64329,  959,64329,    4,64149,43053,64345,54985,64345,54129,64345,
51601,64345,58782,64345,46863,64345,56555,64356,56555,64345,46863,64360,
    5,64149,  803,64365, 1275,64149,    9,64369,56555,64148,25793,64373,
 8495,64373,41019,64373,35187,64372,  241,64372,59960,60857,25793,64385,
41019,64385, 8495,64385,  241,64384,35187,64384,    5,60857,60079,64396,
60369,64399,    0,64396,63743,64403, 1290,64403,63679,64407,63737,64403,
  525,64403,63679,64413,63763,64403,63813,64403,   17,64403, 1275,64420,
63679,64423, 1275,64403,   17,64426,63679,64429,    3,64396,    6,64433,
  759,64397,  483,64437,64025,64397,  483,64441,63823,64397,  483,64445,
 9377,64397,  483,64449, 9513,64396,    9,64453,  959,64397,  483,64457,
37325,64397,  483,64461,   47,64397,  483,64465,10219,64397,  483,64469,
59787,64396,60369,64473,    9,64473,13737,64396,13753,64479,49713,64397,
61987,64397,  483,64485,    9,64397,42613,64489,59619,64489,10291,64489,
 9565,64489,41941,64489,   17,64397,  113,64501,63805,64397,  483,64505,
20763,64397,  483,64509,  483,64396,64025,64513,63823,64513,61987,64513,
63805,64513, 9377,64513,37325,64513,10219,64513,  959,64513,   47,64513,
  759,64513,  587,64513,20763,64513,  587,64397,  483,64539,    7,64396,
21183,64543,  759,64543,   47,64543,  959,64543,    6,64397,56555,64553,
    4,64554,    5,64554,    5,64555,64557,64561,    4,64555,64559,64565,
    7,64397,    0,64569,    5,64570,    5,64569,    0,64574,21105,64569,
21549,64569,19625,64569, 1275,64569,60857,64585,64573,64587,64577,64587,
63679,64397,63705,64593,64435,64593,31103,64593,  375,64593,    7,64593,
64433,64603,  903,64397,  375,64607,    7,64607,35187,64397,60796,64612,
60797,64612,31103,64613,60797,64613,64615,64621,  375,64613,60796,64613,
64617,64627,56555,64397,59787,64631,    9,64633,56555,64396,59914,64637,
60221,64637,59875,64637,    9,64642,60369,64637,    9,64637,59875,64648,
60454,60857,59914,64653,60221,64653,59875,64653,    9,64658,60369,64653,
    9,64653,59875,64664,    4,60857, 8743,64669, 8605,64669, 8672,64669,
 8647,64669,  305,64676, 3795,64669,10025,64669,27603,64669,31524,64669,
31690,64669,31700,64669,63569,64669,46862,64669,    0,64669,    2,64696,
    6,64696,    6,64697,63604,64669,24655,64669,63534,64669, 8916,64669,
62092,64669,63133,64669,48408,64669,  713,64669,31103,64718,  305,64669,
 8647,64722,31103,64722,   25,64669,31103,64728,  340,64669, 8717,64733,
 3785,64733, 8495,64733,  483,64669,62089,64740,46863,64740,  375,64669,
63493,64746, 8861,64746,62089,64669,  483,64752,   15,64669,  483,64757,
20273,64759, 9617,64759,64403,64759,64699,64759,31103,64669,  305,64768,
  713,64768,   25,64768,63493,64768,49713,64769,  483,64668,20033,64781,
59143,64781,58029,64781,60601,64781,49713,64668,31103,64791,46863,64669,
  483,64794,    6,64668,64795,64799,    2,64801,    3,64800,64803,64805,
    3,64801,    2,64800,64809,64811,    7,64668,57293,64815,64695,64815,
    2,64819,    3,64818,64821,64823,    3,64819,    2,64818,64827,64829,
64701,64815,    2,64833,    3,64832,64835,64837,    3,64833,    2,64832,
64841,64843,35603,64815,59079,64815,58669,64815,55005,64815,    6,64669,
    0,64854,64815,64857,    2,64859,    3,64858,64861,64863,    3,64859,
    2,64858,64867,64869,    7,64669,60857,64873,  264,64874,  264,64875,
    1,64873,  264,64880,  264,64881,64703,64873,    2,64887,    3,64886,
64889,64891,    3,64887,    2,64886,64895,64897,25793,64873,41019,64873,
 8495,64873,  305,64905,59875,64873,53391,64873, 9805,64873,38305,64873,
  483,64915,  265,64872, 8717,64919,64883,64919,64877,64919, 3785,64919,
 8495,64919,  265,64873,64885,64931,64879,64931,63493,64931, 8861,64931,
46863,64931, 8861,64669,  375,64942,63493,64669,31103,64946,  375,64946,
  265,64669,    7,64952, 8717,64955, 3785,64955, 8495,64955,    7,64953,
 8647,64963,56555,64669,59381,64967,    7,64969,56555,64668,31103,64973,
  375,64973,59712,64973,    7,64973,  265,64981,59619,64980,59619,64973,
    7,64986,60618,60857,31103,64991,  375,64991,59712,64991,    7,64991,
  265,64999,59619,64998,59619,64991,    7,65004,    6,60857,  264,65009,
64746,65011,  375,65011,64669,65014,64931,65011,64669,65011,  375,65020,
  264,65008,64733,65025,  341,65025,64669,65029,64955,65025,64919,65025,
    3,65008,  341,65037,64669,65039,63907,65037,40705,65037,63823,65045,
64235,65037,63955,65037,64073,65037,   17,65037,64953,65009,  375,65057,
    4,65009, 1274,65061,    3,65061,    6,65064,    6,65061,    3,65068,
56555,65008,60796,60857,56555,60857,  386,65076,45432,65076,  347,65076,
43099,65076,60418,65077,60327,65087,59961,65077,    5,65091,60369,65093,
    5,65090,60327,65097,   18,65076,   12,65076, 1291,65076,48561,65076,
  525,65076,49630,65076,  580,65076, 1170,65076,37408,65076,  256,65076,
52439,65076,  629,65076, 1413,65076,47640,65076,  922,65076,49631,65076,
  581,65076, 1171,65076,44243,65076,42155,65136,  375,65076,  305,65140,
48466,65076,  510,65076,   13,65077,65103,65149,   19,65077,65101,65153,
   13,65076,   18,65077,   19,65076,65159,65161,   12,65077,65157,65165,
57915,65165,   14,65077,57901,65171,60719,65171,60327,65171,65115,65171,
   17,65171,   10,65077,    9,65183,   16,65076,65171,65187,   10,65076,
65165,65191,48560,65076,  524,65076, 1290,65076,   11,65076,65149,65201,
57852,65201,65184,65201,65183,65201,    9,65208,57811,65201,    9,65212,
    9,65201,65183,65216,57811,65216,46863,65200,  483,65200,    9,65076,
  483,65226,46863,65226,   17,65076, 1275,65232,   11,65077,65191,65237,
    9,65239,57915,65237,    9,65243,    9,65236,65191,65247,57915,65247,
    9,65077,   11,65253,65183,65255,57811,65255,   11,65252,65191,65261,
57915,65261,   15,65077,65233,65267,65135,65267,  305,65076,  375,65272,
42155,65076,44243,65276, 1011,65076,    7,65281,    7,65280,65171,65285,
   15,65281,  241,65076,    7,65290,  483,65076,    4,65295,    4,65294,
  903,65294,    9,65294,   11,65294,  903,65076,    9,65307,46863,65306,
  483,65306,35187,65076,    7,65314, 1275,65076,   17,65318,46863,65076,
    4,65323,    4,65322,  903,65322,    9,65322,   11,65322,    7,65077,
    9,65335,   11,65335,  567,65335,    4,65335,  483,65343,    5,65335,
    5,65334,65343,65349,    4,65334,65347,65353,    6,65076,65350,65357,
65355,65357,65289,65357,65349,65357,65343,65364,65343,65357,65349,65368,
   11,65357,65346,65357,65353,65375,    5,65357,65335,65379,65349,65381,
65335,65378,65353,65385,65335,65357,    4,65389,    5,65389,65343,65393,
    4,65388,65393,65397,    5,65388,65391,65401,65353,65401,    5,65077,
60629,65407,59960,65406,59960,65407,38185,65407,57993,65407,65115,65407,
65113,65407,65111,65407,59961,65406,65413,65425,60327,65425,65197,65407,
65195,65407,65105,65407,60251,65407,58313,65407,65299,65407,65327,65407,
65285,65407,65225,65407,65223,65407,65305,65407,65333,65407,56555,65407,
    7,65454,    7,65455,59961,65407,60359,65461,65411,65461,   11,65461,
 1171,65407,65335,65469,65335,65407,65187,65407,57901,65407,60327,65407,
60719,65407,   17,65407,65335,65483,59875,65483,64385,65407,64373,65407,
    6,65407,65459,65493,60755,65493,65283,65493,   11,65493,    7,65407,
56555,65502,    7,65406,65461,65507,65493,65507,    6,65406,65505,65513,
65457,65513,60719,65513,65413,65513,60327,65513,57901,65513,65187,65513,
65115,65513,65285,65513,65503,65513,   17,65513,    4,65076,    2,65537,
    7,65539,65407,65541,65510,65537,65533,65537,65507,65537,65493,65548,
31103,65537,65493,65537,65507,65554,  483,65536,65407,65559,46863,65536,
65407,65563,  375,65537,   15,65537,65357,65569,    7,65536,65513,65573,
65171,65573,65407,65573,59712,65537,65502,65537,65513,65583,    7,65537,
65493,65587,65407,65587,65507,65591,  265,65587,59619,65586,65407,65586,
65513,65599,59619,65537,    7,65602,65407,65537,    6,65607,    7,65607,
65493,65611,    6,65606,65611,65615,    7,65606,65609,65619,65513,65619,
    4,65077,65135,65625,65133,65625,65131,65625,65372,65625,65199,65625,
65109,65625,65107,65625,65235,65625,65321,65625,   11,65625,65357,65644,
65233,65625,65357,65625,   11,65650,65075,65625,65073,65625,    7,65625,
60455,65625,    7,65661,    5,65076,    2,65664,65625,65667,    1,65664,
    3,65664,    0,65664,65625,65675,59914,65665,60221,65665,65336,65665,
65297,65665,65325,65665,59875,65665,    9,65688,65659,65665,65667,65693,
65675,65693,60369,65665,    9,65665,65335,65700,59875,65700,65335,65665,
    9,65706,65658,65665,65671,65711,65673,65711,    6,65665,65668,65717,
65676,65717,65667,65717,65625,65722,65675,65717,65625,65726,65625,65717,
65667,65730,65675,65730,    7,65665,65671,65737,65625,65739,65673,65737,
65625,65743,65625,65736,65671,65747,65673,65747,65625,65665,    6,65753,
    7,65753,    6,65752,65757,65759,    7,65752,65671,65763,65673,65763,
65755,65763,    6,65077,60619,65771,    9,65773,   17,65771,65625,65777,
65537,65771,    9,65781,    5,65771,60369,65785,    9,65785,    5,65770,
65573,65791,60327,65791,60719,65791,57901,65791,65187,65791,65115,65791,
65285,65791,   17,65791,    7,65076,25793,65809,41019,65809, 8495,65809,
 1011,65808,65513,65817,65791,65817,65407,65817,65171,65817,  241,65808,
35187,65808,   15,65809,65665,65831,65407,65809,   11,65835,    4,65808,
65791,65839,65513,65839,65171,65839,65407,65839,    4,65809,65785,65849,
65665,65849,65771,65809,    4,65855,    5,65855,    4,65854,65859,65861,
    5,65854,65857,65865,    1,    4,49284,65869,49311,65869,48330,65869,
48279,65869,47548,65869,47076,65869,47078,65869,48581,65869,48584,65869,
54254,65869,54260,65869,54266,65869,54222,65869, 8672,65869, 8743,65869,
 3795,65869, 8605,65869, 8647,65869,  305,65904,27021,65868,31103,65909,
27377,65910,31894,65909,27377,65909,31103,65916,   21,65868,57577,65921,
59109,65921,19987,65921,57381,65921,59787,65868,57577,65931,57381,65931,
57253,65931,59109,65931,15390,65869,15383,65941,44768,65869,44663,65945,
48284,65869,37897,65949,44243,65869,37845,65953,45411,65955,37845,65952,
44663,65959,37845,65869,44243,65963,45381,65965,44243,65962,44663,65969,
46863,65962,37897,65973, 1175,65869,56555,65977, 1177,65979,49215,65869,
    9,65983,49229,65985,56709,65869, 1009,65989,54641,65869,54643,65993,
60737,65868,60749,65997,11355,65868,11495,66001,57793,65868,57577,66005,
57381,66005,59109,66005,59715,65869,56555,66013,59717,66015, 7959,65869,
    9,66019, 7961,66021,49534,65869,49537,66025,19086,65869, 1203,66029,
49529,65869,   15,66032,49537,66035,19064,65869, 1009,66039,54668,65869,
54643,66043, 1205,65869,18967,66046, 1203,66049,19949,65868,19987,66053,
 1425,65868,57253,66057,  668,65868,    1,66061,    2,66062,    2,66061,
    1,66066,56554,66061,58930,65868,    4,66073,    6,66074,    6,66073,
    4,66078,    8,66073,19965,65868,19987,66085,56745,65868,57253,66089,
60136,65869,59787,66093,  571,65869,18967,66096,  555,66099,16091,65869,
   15,66102, 9513,66105,19078,65869,   21,66109,54655,65869,   15,66112,
54643,66115, 1007,65869,18967,66118, 1009,66121,60125,65869,   15,66124,
59787,66127,19088,65869,  555,66131,16092,65869, 9513,66135,   97,65869,
18967,66138,   21,66141,20347,65869,18967,66144,20345,66147,10095,65869,
   15,66150,10093,66153,20348,65869,20345,66157,10096,65869,10093,66161,
32468,65869,27323,66165,33442,65869,48368,65869,32469,65869,65909,66173,
28483,65869,28479,65869,63604,65869,31690,65869,31700,65869,31524,65869,
31596,65869,32464,65869,53380,65869,25037,65869,24655,65869,25457,65869,
23005,65869,27603,65869,22591,65869,23105,65869,23357,65869,23113,65869,
  120,65869,46863,66212,   77,65869,46863,66216,54154,65869,54225,66220,
56328,65869,58298,65869,58868,65869,52752,65869,52370,65869,58344,65869,
57253,65869,59787,66237, 1425,66237,56745,66237,19987,65869,   21,66245,
19949,66245,19965,66245,25215,65869,48583,65869,  113,66254,25459,65869,
31920,65869,32263,65869,23099,65869,23107,65869,24631,65869,22915,65869,
22589,65869,65294,65869,65322,65869,63534,65869,54256,65869,54129,66280,
25305,65869,32295,65869,31796,65869,62092,65869,63133,65869,22785,65869,
22803,65869,22951,65869,24735,65869,23012,65869,25546,65869,47364,65869,
25548,65869,62442,65869,63294,65869,62432,65869,62560,65869,57577,65869,
   21,66319,59787,66319,57793,66319,57381,65869,59787,66327,   21,66327,
57793,66327,59109,65869,   21,66335,59787,66335,57793,66335,48578,65869,
   33,66343,48276,65869,   33,66347,49308,65869,   33,66351,59340,65869,
63135,65869,61464,65869,61580,65869,61578,65869,62946,65869,62950,65869,
62550,65869,61810,65869,63182,65869,62948,65869,57660,65869,57766,65869,
62060,65869,57772,65869,22767,65869,19810,65869,  251,66387,  555,66387,
 1365,66387,   21,66387, 9994,65869, 9513,66397,16859,66397,59787,66397,
20620,65869,59787,66405,21529,66405, 9513,66405,19372,65869,  251,66413,
   21,66413,  177,66413,  555,66413,20823,65869,59787,66423,21529,66423,
20771,66423, 9513,66423,57971,65869,   21,66433,  251,66433,  177,66433,
  159,66433,  555,66433,25303,65869,   11,66445,24739,65869,29028,65869,
57658,65869,57620,65869,48328,65869,  113,66456,19806,65869,  251,66461,
  555,66461,   21,66461, 8916,65869,54262,65869,46863,66470,54219,65869,
46863,66474,32556,65869,  759,66479, 7061,65869,    3,66483,    2,66483,
  842,66483,  843,66482,66489,66491,  843,66483,  842,66482,66495,66497,
    3,66482,66487,66501,    2,66482,66485,66505,47546,65869,   25,66508,
49283,65869,   25,66512,47600,65869,48444,65869,47572,65869,62146,65869,
17476,65869,23010,65869,63184,65869,61584,65869,48558,65869,47408,65869,
25460,65869,61474,65869,47372,65869,61746,65869,47632,65869,17538,65869,
47634,65869,47676,65869,48112,65869,47412,65869, 5886,65869,48095,65869,
 1072,65869,60857,66560,48408,65869,49713,66564,  241,66564,  587,66565,
  903,66564,48420,65869,61780,65869, 1011,66576,47640,65869, 1011,66580,
  483,66580,47590,65869,  483,66586,47672,65869,47368,65869, 1413,65869,
46863,66594,52692,65869,46863,66598,47370,65869,  922,65869,46863,66604,
49075,65869,49395,65869,48586,65869,10025,65869, 1281,65869,46863,66616,
 1291,65869,60857,66620,  669,65869,66065,66625,66069,66625,40909,66625,
 1821,66625, 1879,66625,38973,66625,    3,66625,38971,66639,57911,66625,
17041,66625, 4897,66625,56739,66625,66071,66625,56555,66625,  671,66653,
66061,66653,25381,65869,   11,66659,   11,66658,58931,65869,66077,66665,
66081,66665,58715,66665,58975,66665,58981,66665,59089,66665,    7,66665,
59079,66679,23879,66665,30399,66665,31937,66665,58983,66665,66083,66665,
    9,66665,58967,66693,66073,66693,58782,65869,49713,66698,60857,66698,
   11,66699, 1108,65869,60857,66706,62089,65869,  483,66710, 4802,65869,
 5314,65869,17670,65869,17693,65869,62059,65869,  483,66722,47608,65869,
60857,66726,  903,66726,   11,66727,  587,66726,19474,65869,10093,66737,
20345,66737,10085,66737,20281,66737,19549,66737,19553,66737,10087,66737,
20285,66737,19555,66737,  483,66737,20273,66757,10081,66757,19545,66757,
61718,65869,  483,66764,22957,65869,  903,66768,  587,66768,62538,65869,
56555,66774, 1011,66774,  288,65869,    9,66781,19916,65869,    7,66785,
35603,66787,35613,66785,10041,66785,10005,66785,10009,66785,23879,66785,
30399,66785,31937,66785,    9,66785,10001,66805,63014,65869,56555,66808,
   11,66809,  587,66809, 1011,66808,   11,66808,48534,65869, 1011,66820,
 1418,65869,    3,66825,38903,66827,38913,66825, 3587,66825, 1989,66825,
56681,66825,57911,66825,17041,66825, 4897,66825,56555,66825, 1471,66845,
 1086,65869,46863,66848,  524,65869,60857,66852, 1304,65869,    9,66857,
 1530,65869,    9,66861, 9195,65869,31103,66864,10031,65869,27641,65869,
  713,65869,31103,66872, 1447,65869,13737,66877, 9875,65869,   15,66880,
 9513,66883,16859,66883,59787,66883,  803,66881, 1325,65869,18967,66892,
  251,66895,  555,66895, 1365,66895,   21,66895,16937,65869,46863,66904,
 1505,65869,28715,66908, 5438,65869,49162,65869,  113,65869,48583,66916,
48328,66916,   25,66916,46863,66922,46863,66916,   25,66926,  375,65869,
63493,66930, 8861,66930,58334,65869,46863,66936,58362,65869,60857,66940,
  506,65869,46863,66944,  587,65869,  759,66949,31103,66951,31103,66948,
  759,66955,22957,66948,47608,66948,46863,66948, 1011,66962, 1011,66948,
46863,66966, 1369,65869,   15,66970, 4897,66973,17041,66973, 3587,66973,
 1989,66973,57911,66973,56681,66973,56555,66973, 1471,66987, 1275,66970,
    9,66991, 1275,65869,18967,66994,31937,66997,30399,66997,10041,66997,
10005,66997,23879,66997,10009,66997,    9,66997,10001,67011,   11,66994,
    9,67015,    9,66995,   11,67019, 1369,67019, 1369,66994,    9,67025,
  483,65869,32805,67028,56156,67028,65076,67028,25545,67028,62089,67028,
62942,67028,62059,67028,47590,67028,47640,67028,17669,67028, 5313,67028,
 4801,67028,  587,67029,46863,67055,61718,67028,49713,67028,46863,67060,
 1011,67028,60857,67064,  903,67028,46863,67068,46863,67028,49713,67072,
  587,67073,  241,67072,  903,67072,60857,67028,56555,67082,  587,67083,
   11,67083, 1011,67082,   11,67082,   11,67028,60857,67094, 5325,67028,
56555,67028,60857,67100,  241,67028,46863,67104, 4593,67028,11985,67028,
 5843,67028,49155,67028, 5876,65869,49155,65869,  483,67118, 6267,65869,
    9,67123, 6367,67125, 6403,67125, 6407,67125,60419,65869,56555,67133,
60425,67135,60429,67135,60433,67135, 5325,65869,  483,67142,55005,65869,
    9,67147, 5843,65869,56555,67150, 1011,67150,  483,67150,12023,65869,
11986,65869, 4608,65869,11985,65869,  483,67164, 3681,65869,56555,67168,
 3709,65869,56555,67172, 3357,65869,56555,67176,52840,65869, 4593,65869,
  483,67182,54202,65869,54159,67187,46863,67189, 4801,65869,  483,67192,
54129,65869,54256,67196,46863,67196,54225,67200,54225,67196,46863,67204,
17669,65869,  483,67208, 5313,65869,56555,67212,  483,67212,15309,65869,
  413,67218,15383,67221,  413,67219,15335,67225,54225,65869,54154,67228,
46863,67228,54129,67232,54129,67228,46863,67236, 1274,65868,    6,67241,
    4,67242,66785,67245,66997,67245,    4,67241,    6,67250,66785,67253,
66997,67253,67011,67241,66805,67241,    8,67241,66997,67263,66785,67263,
 1368,65868,    1,67269,    2,67270,66825,67273,66973,67273,    2,67269,
    1,67278,66825,67281,66973,67281,66987,67269,66845,67269,56554,67269,
66973,67291,66825,67291,  586,65868,24265,67297,28233,67297,29077,67297,
19559,67297, 8251,67297,20361,67297, 9673,67297,20713,67297, 4283,67297,
 9967,67297, 4279,67297, 3807,67297,  482,65869,  903,67323,    1,67325,
    0,67325,    1,67324,67329,67331,    0,67324,67327,67335,  587,65868,
31690,67339,31103,67339,  713,67342,  713,67339,31103,67346,48408,67339,
46863,67339,  483,67352,  483,67339,46863,67356,  483,65868,57577,67361,
57253,67361,19987,67361,59109,67361,57381,67361, 1369,65868, 1275,65868,
47953,67375,48062,67375,47961,67375,48009,67380,48009,67375,47961,67384,
47580,67375,47933,67389,46863,67375,  265,67393,48009,67395,  265,67392,
47933,67399,  265,67375,46863,67403,47961,67405,46863,67402,47933,67409,
 1368,65869,48009,67413,49321,67413,49001,67413,  265,67413,46863,67421,
  586,65869,58056,67425,58601,67425,40799,67425,44243,67425,56555,67432,
35927,67425,38155,67425,37611,67425,  375,67425,  510,67425,    9,67425,
  483,67446,56555,67425,44243,67450,  483,67425,    9,67454,  843,65869,
    9,67459,15705,65869,    9,67463,10001,67465,13755,67465,15733,67465,
27533,67465,17455,65869,56555,67474, 1347,67474, 1011,67474,  767,65869,
56555,67483, 1471,67485,  253,67485,  809,67485,  771,67485,   53,67485,
 1347,65869,17455,67496,  567,65869,    9,67501,10033,65869,27691,65869,
10035,65869,27978,65869,26331,67511,23755,67511,27805,67511,  256,65869,
25793,67519,59875,67519,41019,67519, 8495,67519,53391,67519, 9805,67519,
  972,65869,25793,67533,41019,67533, 8495,67533,20762,65869,58715,67541,
  375,67541,  154,65869,40909,67547,49204,65869,   11,67550,   33,67553,
   11,67551,   25,67557, 1369,67551,37409,67551,  340,65869,25793,67565,
41019,67565, 8717,67565, 8495,67565, 3785,67565,49514,65869,   66,65869,
   33,67579,46863,67581,46863,67578,   33,67585,  112,65869,44243,67589,
27785,65869,  257,65869,67373,67595,31103,67594,31103,65869,27021,67601,
27377,67603,27021,67600,27323,67607,   25,67600,  713,67600,  305,67600,
63493,67600, 8861,67600, 9195,67600,52915,67600, 1369,67601,  587,67601,
  713,67627,  903,67600,  241,67600,  587,67600,  759,67635,49713,67600,
  257,67600,  165,65869,60857,67642,31926,65869,27021,65869,27323,67649,
31103,67651,31103,67648,27323,67655,52915,65869,31103,67658,  305,65869,
 8647,67662,31103,67662,   25,65869,49283,67668,47546,67668,31103,67668,
  113,67668,46863,67676,46863,67668,  113,67680,20501,65869,   15,67684,
59787,67687,21529,67687, 9513,67687,  803,67685, 1141,65869,13737,67697,
   33,65869,13737,67701,  331,65869,18967,67704,  251,67707,   21,67707,
  555,67707,   59,65869,18967,67714,  251,67717,   21,67717,  177,67717,
  555,67717, 8861,65869,60796,67727,60797,67727,60796,67726,67731,67733,
31103,67726,60797,67726,67729,67739,  375,67726,63493,65869,60796,67745,
60797,67745,31103,67744,60797,67744,67747,67753,60796,67744,67749,67757,
  375,67744,  413,65869,15309,67762,15383,67765,15309,67763,15363,67769,
46863,67762,32805,65869,    9,67775,  483,67774,46863,67774, 1216,65869,
46863,67782,65076,65869,    9,67787,  483,67786,46863,67786,56156,65869,
  483,67794,56555,67794,56555,65869,56156,67800,63014,67800,62538,67800,
 3357,67800,17455,67800, 5313,67800, 5843,67800, 3681,67800, 3709,67800,
46863,67800,49713,67820,60857,67820,   11,67821,49713,67800,46863,67828,
  483,67800,60857,67832,   11,67801,46863,67837,60857,67800,    9,67841,
  483,67840,46863,67840,15029,67800,    7,67849,  903,65869,31103,67852,
22957,67852,47608,67852,48408,67852,46863,67852, 1011,67862,  483,67862,
  483,67852,46863,67868,    7,67852,25793,67873,41019,67873, 8495,67873,
 1011,67852,46863,67880,28715,67852,    7,67885,21605,65869,   15,67889,
31103,67891,    7,67888,26331,67895,23755,67895,27805,67895,    7,67889,
26219,67903,49713,65869,58782,67906,48408,67906,  483,67906,46863,67912,
31103,67906,56555,67906,46863,67918,    3,67907,31103,67923,46863,67906,
  483,67926,56555,67926,  241,65869,31103,67932,48408,67932,46863,67932,
  483,67938,  483,67932,46863,67942,    7,67932,25793,67947,59875,67947,
41019,67947, 8495,67947,53391,67947, 9805,67947,56555,67933,    7,67961,
    9,65869,25545,67964,62942,67964,60857,67964, 1011,67970, 1011,67964,
60857,67974,25545,65869,    7,67979,  483,67978,    9,67978,46863,67978,
46863,65869,37844,67988,37896,67989,37844,67989,    6,67994,37845,67988,
67993,67999,67997,67999,67995,67999,37897,67999,54262,67988,54219,67988,
  120,67988,   77,67988,    6,67989,37844,68017,37844,68016,67999,68021,
32805,67988,37845,67989,68019,68027,67991,68027,37899,68027,37897,67989,
67991,68035,54129,67988,54225,68038,52692,67988,58334,67988,65076,67988,
54225,67988,54129,68048,25545,67988,   66,67988,   33,68055,62942,67988,
   25,67988,  113,68060,  113,67988,   25,68064,  506,67988, 1086,67988,
 1281,67988, 1216,67988,  413,67988,  922,67988, 1413,67988,16937,67988,
  587,67989,  483,68085,  483,67988,49713,68088,  241,68088,  587,68089,
  903,68088,  241,67988,  483,68098,  903,67988, 1011,68102,  483,68102,
 1275,67989,56555,67988,49713,68110,60857,68110,   11,68111,60857,67988,
56555,68118, 1011,68118, 1011,67988,60857,68124,  903,68124,   11,68125,
  587,68124,  587,67988, 1011,68134,    2,67988,    3,67988,   11,68140,
   33,68143,   11,68141,   25,68147, 1369,68141,37409,68141,    2,67989,
    3,67989,  483,68157,49713,67988,56555,68160,  483,68160,   11,67988,
    3,68166,   33,68169,    3,68167,  113,68173,   15,65869,10095,68176,
10093,68179,54643,68177,54655,68183,49537,68177,49529,68187,54655,68176,
54643,68191,49529,68176,49537,68195,16091,68176, 9513,68199,60125,68176,
59787,68203,16859,68177, 9875,68207,21529,68177,20501,68211,    1,68176,
    2,68215,    1,68216,68177,68219,    7,68216,68221,68223,    7,68215,
    2,68226, 1368,68215,    6,68176,    2,68233,    6,68234,68177,68237,
    0,68234,68239,68241,    0,68233,    2,68244,18966,68233,56554,68176,
    2,68251,    7,68252,    7,68251,    2,68256, 1368,68251,  482,68176,
    2,68263,    0,68264,    0,68263,    2,68268,18966,68263,20501,68176,
 9513,68275,59787,68275,21529,68275, 9875,68176,59787,68283, 9513,68283,
16859,68283,59787,68177,60125,68291, 9875,68291,20501,68291, 9513,68177,
16091,68299,20501,68299, 9875,68299,  483,68177, 2007,68307, 3477,68307,
68267,68307,68271,68307, 5197,68307,68241,68307,68247,68307,    1,68307,
19051,68307,19667,68307, 5123,68307,12345,68307,68249,68307,68273,68307,
18967,68307,  555,68337,68233,68337,68263,68337,56555,68177,59637,68345,
59717,68345,68255,68345,68259,68345,68223,68345,68229,68345,    6,68345,
59649,68345,39747,68345,43837,68345,43027,68345,68231,68345,68261,68345,
 1369,68345,59619,68373,68215,68373,68251,68373,18967,68176,19553,68381,
19549,68381,20345,68381,20281,68381,    7,68381,68345,68391,68359,68381,
10093,68381,10085,68381,20285,68381,10087,68381,19555,68381,  483,68381,
20273,68407,10081,68407,19545,68407, 1369,68176,67281,68415,67273,68415,
 3587,68415, 1989,68415,    0,68415,68307,68425,68323,68415,56681,68415,
57911,68415, 4897,68415,17041,68415,67291,68415,56555,68415, 1471,68441,
67269,68441,    3,68176,40909,68447,    3,68177,40895,68451,40059,68451,
43749,68451,38903,68451,18967,65869,20347,68460,20345,68463, 1203,68461,
 1205,68467, 1009,68461, 1007,68471, 1205,68460, 1203,68475, 1007,68460,
 1009,68479,   97,68460,   21,68483,  571,68460,  555,68487,  177,68461,
   59,68491, 1365,68461, 1325,68495,    2,68460,    6,68499,    2,68500,
68461,68503,    5,68500,68505,68507,    5,68499,    6,68510,   14,68499,
    4,68460,    6,68517,    4,68518,68461,68521,    3,68518,68523,68525,
    3,68517,    6,68528, 1274,68517,  482,68460,    6,68535,    5,68536,
    5,68535,    6,68540,   14,68535,    8,68460,    6,68547,    3,68548,
    3,68547,    6,68552, 1274,68547,  256,68461,  629,68461, 1325,68460,
   21,68563,  251,68563,  555,68563, 1365,68563,   59,68460,  555,68573,
  251,68573,   21,68573,  177,68573,  555,68461,  571,68583,  331,68583,
   59,68583, 1325,68583,   21,68461,   97,68593,  331,68593, 1325,68593,
   59,68593,  331,68460,  251,68603,  555,68603,   21,68603,  251,68461,
  331,68611,   59,68611, 1325,68611,    9,68461, 7951,68619, 7961,68619,
68551,68619,68555,68619,68451,68619,68525,68619,68531,68619,    2,68619,
 7953,68619,35893,68619,38299,68619,37897,68619,68533,68619,68557,68619,
 1275,68619, 7947,68649,68517,68649,68547,68649,  483,68461, 9517,68657,
 9525,68657,68539,68657,68543,68657,20033,68657,68507,68657,68513,68657,
    4,68657, 9519,68657,57855,68657,60853,68657,60609,68657,68515,68657,
68545,68657,   15,68657, 9513,68687,68499,68687,68535,68687, 1275,68460,
67245,68695,67253,68695,10041,68695,10005,68695,    5,68695,68657,68705,
68673,68695,10009,68695,23879,68695,31937,68695,30399,68695,67263,68695,
    9,68695,10001,68721,67241,68721,   15,68460,19549,68727,19553,68727,
10093,68727,10085,68727,    3,68727,68619,68737,68635,68727,20345,68727,
20281,68727,10087,68727,20285,68727,19555,68727,  483,68727,10081,68753,
20273,68753,19545,68753,    7,68460,58715,68761,  375,68761,    7,68461,
58703,68767,58027,68767,60849,68767,68345,68767,35603,68767,   59,68767,
 1325,68767,  331,68767,  265,68767,  241,68766,  241,68461,    6,68789,
    7,68789,    6,68788,68793,68795,    7,68788,68791,68799,  265,68460,
  375,68803, 1011,65869,59960,68807,61780,68806,63014,68806,62538,68806,
17455,68806,47640,68806, 5843,68806,48534,68806,  483,68806,60857,68824,
    9,68806,60857,68828,46863,68806,60857,68832,  903,68832,   11,68833,
  587,68832,  587,68806,46863,68842,   11,68807,46863,68847,    7,68807,
56555,68850,63823,68851, 9377,68851,  903,68806,46863,68858,56555,68807,
    6,68863,    7,68863,    6,68862,68867,68869,    7,68862,68865,68873,
60857,68806,    7,68877,  483,68876,46863,68876,    9,68876,62942,65869,
    7,68887,46863,68886,    9,68886,  483,68886,60857,65869,58782,68896,
58362,68896,47608,68896, 1108,68896, 1072,68896,  165,68896,  524,68896,
 1291,68896,   11,68897,  483,68915,    9,68896, 1011,68918,  587,68897,
  483,68923,46863,68896,56555,68926, 1011,68926,  483,68896,56555,68932,
  587,68933,   11,68933, 1011,68932,   11,68932,   11,68896,  483,68944,
    7,68897, 1141,68949, 1447,68949,   33,68949,56555,68896,    9,68957,
46863,68956,  483,68956, 1011,68896,    7,68965,    9,68964,  483,68964,
46863,68964,  265,65869,16710,68974,44242,68974,16711,68974,16710,68975,
68981,68983,45086,68975,44242,68975,    3,68988,44243,68974,68987,68993,
68991,68993,60797,68975,60796,68974,68999,69001,60796,68975,60797,68974,
69005,69007,    3,68975,44242,69011,44242,69010,68993,69015,    6,69010,
 1274,68975,44243,68975,69013,69023,45087,68975,68979,69027,16711,68975,
68977,69031, 1275,68975, 4899,69035,14611,69035,47961,69035,   11,68974,
    9,69043,46863,68974,69019,69047,69021,69047,    9,68975,   11,69053,
    6,68974,    0,69056,69035,69059,    7,68974,25793,69063,41019,69063,
 8717,69063, 8495,69063, 3785,69063,    6,68975,    3,69074,69047,69077,
    7,68975, 8647,69081,21605,68975,  375,69085,18967,68974,  375,69089,
   11,65869,39085,69093,49204,69092,   33,69097,  803,69093,63014,69092,
25381,69092,  265,69092,    9,69107,60857,69092,  483,69110,  483,69092,
60857,69114, 1275,69092,    9,69119,    2,69092,44243,69123,    3,69092,
   33,69127,46863,69129,46863,69126,   33,69133,    3,69093,49283,69137,
47546,69137,  113,69137,46863,69142,46863,69137,  113,69146,46863,69092,
    3,69150,   33,69153,    3,69151,  113,69157,20034,65869,  375,69161,
48560,65869,    3,69164,   33,69167,    3,69165,  113,69171,59206,65869,
    7,69175,29598,65869,    7,69179,60455,65869,  256,69183,  375,69183,
    7,69183,  241,69188,  241,69183,    7,69192,15029,65869,56555,69196,
    7,69199,28715,65869,  256,69203, 1505,69202,    7,69203,  241,69208,
  241,69203,    7,69212,  903,69202,    7,69217,54027,65869,  375,69221,
    2,69220,54159,69225,46863,69227,    2,69221,54256,69231,46863,69231,
54225,69234,54225,69231,46863,69238,17635,65869,    7,69243,    2,69244,
    2,69245, 1368,69243, 1369,69243,    2,69242,69253,69255,    3,69242,
69247,69259,69251,69259,    2,69243,    7,69264,69259,69267,    3,69243,
69249,69271,    2,65868,41692,69275,41607,69275, 8672,69275, 8743,69275,
26454,69275,26375,69275, 8770,69275, 8729,69275, 3795,69275,47953,69275,
48062,69275,47961,69275,48009,69298,48009,69275,47961,69302,41417,69275,
41653,69306,26219,69275,26415,69310,31770,69275,44832,69275, 8757,69275,
 8647,69318,26415,69275,26219,69322,41653,69275,41417,69326, 8647,69275,
  305,69330, 8757,69330, 8605,69275,47580,69275,47933,69339, 8684,69275,
 8717,69343, 8916,69275,31103,69275,    9,69348,26292,69275,26331,69353,
  340,69275, 8717,69357, 3785,69357, 8495,69357,  375,69275, 8861,69364,
46863,69364,47488,69275,41502,69275,41559,69373,  483,69275,44243,69376,
  305,69275, 8647,69380,    7,69275,    1,69385,  264,69386,  264,69387,
41019,69385,41653,69393,25793,69385,26415,69397, 8495,69385,  305,69401,
 8757,69401, 8495,69384, 8717,69407,25793,69384,26331,69411,  265,69385,
69391,69415, 8861,69415,46863,69415,41019,69384,41559,69423,  265,69384,
 8717,69427,69389,69427, 3785,69427, 8495,69427,44243,69275,  483,69436,
    9,69275,31103,69440,46863,69275,  265,69445,48009,69447,  265,69444,
47933,69451,  375,69444,25793,69275,    7,69457,26219,69459,    7,69456,
26331,69463,  265,69275,46863,69467,47961,69469,46863,69466,47933,69473,
    7,69467, 8647,69477,    7,69466, 8717,69481, 3785,69481, 8495,69481,
41019,69275,    7,69489,41417,69491,    7,69488,41559,69495, 8495,69275,
    7,69498, 8717,69501,    7,69499, 8647,69505, 8861,69275,  375,69508,
    3,65868,21116,69513,21253,69513,21560,69513,20465,69513,20576,69513,
59683,69513,42035,69513, 9573,69513,59689,69513, 9575,69513,42041,69513,
43711,69513,42089,69513,42129,69513,    1,69513,    6,69543,68974,69544,
68975,69545,69547,69549,68974,69545,68975,69544,69553,69555,    4,69513,
    6,69558,66665,69561,66785,69561,66997,69561,68695,69561, 9599,69513,
    8,69513,66997,69573,66785,69573,66665,69573,68695,69573,67011,69513,
66805,69513,68721,69513,66693,69513,60569,69513,59701,69513,59767,69513,
 9605,69513,32468,69513,28483,69513,19625,69513,20501,69602,43015,69513,
44714,69513,19474,69513,20413,69611,20805,69513,20186,69513,21549,69513,
20501,69618,21105,69513,20501,69622, 1418,69513,59619,69627, 9565,69627,
41941,69627,  669,69513, 9565,69635,59619,69635,41941,69635,37501,69513,
31103,69513,27021,69644, 8386,69513,50657,69513,36944,69513,48408,69513,
 1369,69513,   15,69656, 9565,69659,41941,69659,59619,69659,  483,69513,
46863,69666,20501,69513,21105,69670,21549,69670,19625,69670,    6,69513,
    3,69679,56555,69681,65869,69683,    4,69678,66665,69687,66785,69687,
66997,69687,68695,69687,69685,69687,    3,69678,68460,69699,69687,69701,
18967,69699,65869,69704,69687,69707,65869,69699,18967,69710,69687,69713,
    7,69513,20103,69716, 8337,69716,36773,69716,27021,69513,31103,69724,
    7,69512,24265,69729,28233,69729,29077,69729,20361,69729, 9673,69729,
 4279,69729, 9967,69729,19559,69729, 4283,69729,20713,69729, 3807,69729,
 8251,69729,44243,69513,41941,69754,46863,69513,  483,69758,   15,69513,
18967,69763,20501,69765,18967,69762,20413,69769, 1369,69762, 9565,69773,
41941,69773,59619,69773, 8337,69513,    7,69780,18967,69513,   15,69784,
20413,69787, 1011,69513,44242,69790,44242,69791,44243,69790,69795,69797,
44243,69791,69793,69801,28715,69513,    7,69805,36773,69513,    7,69808,
41941,69513,44243,69812,20103,69513,    7,69816,20273,69513,    6,69820,
    7,69820,    6,69821,69825,69827,    7,69821,69823,69831, 9617,69513,
    6,69834,    7,69834,    6,69835,69839,69841,    7,69835,69837,69845,
    6,65868,    1,69849,    3,69850,    4,69849,    3,69855,67988,69856,
67989,69857,69859,69861,67988,69857,67989,69856,69865,69867,21604,69849,
    3,69849,    1,69872,    7,65868,59007,69877,58999,69877,59025,69877,
19981,69877,48747,69877,37279,69877,57047,69877,57029,69877,58153,69877,
    1,69877,    2,69896,66625,69899,66825,69899,66973,69899,68415,69899,
58167,69877,56554,69877,66973,69911,66825,69911,66625,69911,68415,69911,
66987,69877,66845,69877,68441,69877,66653,69877,24601,69877,57437,69877,
57021,69877,57069,69877,54107,69877,52743,69877,52193,69877,20734,69877,
25551,69877,24613,69877,28205,69877,20501,69877,  265,69950,  241,69951,
 1141,69877,56555,69957,60577,69877,62959,69877,58377,69877,57981,69877,
19916,69877, 7947,69969,48739,69969,37241,69969,58931,69877,48739,69977,
 7947,69977,37241,69977, 8306,69877,   33,69877,56555,69987, 1447,69877,
56555,69991, 9875,69877,  241,69995,  265,69994, 9992,69877,  545,69877,
  695,69877, 1382,69877, 1374,69877, 1386,69877,  154,69877,  483,70013,
60455,69877,  483,70017, 1369,69877,  331,70020, 1325,70020,   59,70020,
 1325,69877, 1369,70028, 1275,69877,18967,70032,48739,70035,37241,70035,
 7947,70035,   59,69877, 1369,70042,    2,69877,    7,70047,    9,70049,
65869,70051,    1,70046,66625,70055,66825,70055,66973,70055,68415,70055,
70053,70055,    7,70046,68176,70067,70055,70069,   15,70067,65869,70072,
70055,70075,65869,70067,   15,70078,70055,70081,    3,69877, 8241,70085,
   15,70084,  483,70089,  331,69877, 1369,70092,    3,69876,24265,70097,
28233,70097,29077,70097,19559,70097,20713,70097, 4283,70097,20361,70097,
 9673,70097, 4279,70097, 9967,70097, 8251,70097, 3807,70097,18967,69877,
 1275,70122,48739,70125,37241,70125, 7947,70125,  113,70123, 1011,69877,
  265,69877,20501,70136, 8165,70136, 9875,70136,46863,69877,38056,70144,
38056,70145,38057,70144,70149,70151,38057,70145,70147,70155,   15,69877,
    3,70159, 1369,70161,    3,70158,  483,70165,54027,69877,  483,70169,
 8165,69877,  265,70172,    7,65869,69874,70176,69875,70177,70179,70181,
69875,70176,69874,70177,70185,70187,69852,70176,69853,70177,70191,70193,
69853,70176,69852,70177,70197,70199,11276,70176,11277,70176,11276,70177,
70205,70207, 5044,70176, 5045,70176, 5044,70177,70213,70215,40583,70177,
40583,70176,40582,70176,70219,70223,40582,70177,70221,70227,24094,70177,
69871,70177,69870,70177,21604,70177,69849,70236,    9,70236,21604,70176,
70233,70243,69849,70243,    9,70243,    4,70177,    0,70250,    1,70177,
  264,70254,  264,70255,24095,70177,70243,70261,45149,70177,26498,70177,
41326,70177, 8796,70177,27533,70177,    9,70273,25793,70177,27021,70277,
  587,70276,  241,70277, 5045,70177,70211,70285,11277,70177,70203,70289,
 4551,70177,10001,70177,    9,70295, 8495,70177,  305,70299,  587,70298,
  241,70299,   88,70177, 1369,70307,  587,70177,25793,70310,41019,70310,
 8495,70310, 1369,70177,20103,70319,36773,70319, 8337,70319,  265,70177,
70259,70327,63493,70327, 8861,70327,46863,70327,   89,70177,46863,70337,
  483,70177,18967,70341,37241,70343,48739,70343,70253,70343, 7947,70343,
 1275,70177,44243,70353,21605,70176,70231,70357,70235,70357,70239,70357,
70241,70357,70237,70357,69849,70367,    9,70367,26331,70357,23755,70357,
27805,70357,  241,70176,25793,70379,59875,70379,41019,70379, 8495,70379,
 9805,70379,53391,70379,  903,70176,25793,70393, 8495,70393,41019,70393,
18967,70176,58715,70401,  375,70401,  265,70176,70257,70407,25793,70407,
41019,70407, 8717,70407, 8495,70407, 3785,70407,21605,70177,70246,70421,
69849,70421,70243,70424,70248,70421,70243,70421,69849,70430,    9,70430,
24545,70421,    9,70421,70243,70438,  903,70421,  241,70177,51487,70445,
  375,70177, 1369,70449,41019,70177,  587,70452,  241,70453,    2,70176,
48009,70459,  265,70459,46863,70463,49321,70459,49001,70459,    3,70176,
58056,70471,58601,70471,40799,70471,44243,70471,56555,70478,35927,70471,
  375,70471,  510,70471,  483,70471,    9,70488,38155,70471,37611,70471,
56555,70471,44243,70496,    9,70471,  483,70500,    2,70177,44243,70505,
48466,70505,47640,70505,46863,70505,    9,70512,  903,70512,  903,70505,
46863,70518,    9,70505,46863,70522,49155,70505,    3,70177, 1369,70529,
    9,70531,37663,70529,    9,70528, 1369,70537,18967,70529,44243,70541,
69849,70177,21604,70545,70421,70547,21604,70544,70357,70551,    9,70177,
21604,70555,70421,70557,21604,70554,70357,70561,    3,70554, 1369,70565,
    3,70555,  483,70569,    3,65869,60078,70572,60079,70572,13748,70573,
13736,70572,70579,70581,13736,70573,13737,70572,13749,70573,70587,70589,
    1,70573,    5,70592,    1,70572,69385,70597,69384,70597,69275,70597,
    7,70602,    7,70603,59961,70597,    6,70596,70601,70611,70605,70611,
    7,70596,70599,70617,69275,70617,    6,70597,69275,70623,70617,70624,
70607,70623,70620,70623,70617,70623,69275,70632,56555,70623,    7,70597,
69275,70638,70611,70641,70611,70639,69275,70645,48560,70572,   33,70649,
60230,70573,57986,70573,58352,70573, 8309,70573,13737,70573,    7,70660,
70581,70663,59960,70573,70575,70667,70611,70667,  241,70666,  256,70573,
56555,70674,   11,70573,48583,70679,48328,70679,   25,70679,46863,70684,
46863,70679,   25,70688,59961,70573,70577,70693,  483,70573,   15,70697,
41941,70699, 9565,70699,70595,70699,59619,70699, 1369,70573,46863,70709,
37409,70573,46863,70713,46863,70572,   11,70716,   33,70719, 1369,70717,
   11,70717,   25,70725,37409,70717,   15,70572,40909,70731,   11,70572,
   33,70735,46863,70737,46863,70734,   33,70741,    6,70572,    1,70744,
70667,70747,    5,70744,    7,70572,70609,70753,58056,70753,70636,70753,
70623,70753,56555,70760,40799,70753,58601,70753,44243,70753,56555,70768,
35927,70753,  375,70753,  510,70753,  483,70753,    9,70778,38155,70753,
37611,70753,    9,70753,  483,70786,56555,70753,70623,70790,44243,70790,
    6,70573,70731,70797,56555,70797,    7,70573,13737,70802,70581,70805,
13737,70803,70585,70809,70611,70803,56555,70813,70747,70803,56555,70817,
70751,70803,42613,70803,56555,70823,54497,70803,54159,70803,51803,70803,
58348,70802,10291,70803,56555,70835,   59,70803, 1325,70803,  331,70803,
 1275,70803,    9,70845,56555,70802,70611,70849,70747,70849,  241,70848,
  241,70802,56555,70856,   15,70803,  483,70861,69275,70573,58348,70573,
    7,70866,38057,70573,    7,70871,43503,70573,44243,70875,56555,70573,
  256,70878,    7,70878,70611,70883,70747,70883,  241,70882,    7,70879,
70623,70891,  241,70878,    7,70894,  241,70573,44242,70899,44242,70898,
44243,70899,70903,70905,59960,70898,44243,70898,70901,70911,    7,70898,
56555,70914,56555,70898,    7,70918,    2,65869,    1,70922,69635,70925,
  668,70925,69513,70929,69627,70925, 1419,70925,69513,70935,70699,70925,
69659,70925,69773,70925,  587,70925,    9,70944,69513,70947,    9,70925,
  587,70950,69513,70953,54027,70922,54159,70957,46863,70959,54027,70923,
54154,70963,46863,70963,54129,70966,54129,70963,46863,70970,44243,70923,
   11,70975,46863,70922,   11,70922,44243,70981,    6,70922,    0,70985,
    5,70986,    5,70985,    0,70991,    0,70990,    1,70984,70995,70997,
70989,70997,70987,70997,    5,71003,    1,70985,70993,71007,    5,71007,
    0,70984,    5,71013,71007,71014,71010,71013,71007,71013,    5,71020,
  903,70985,    1,71025,    0,71025,    1,71024,71029,71031,    0,71024,
71027,71035,    7,70922,48009,71039,  265,71039,46863,71043,49321,71039,
49001,71039,    7,70923,70989,71051,70997,71052,70995,71051,70997,71056,
70998,71051,71000,71051,71005,71051,71009,71051,71017,71051,71019,71051,
71023,71051,71011,71051,71013,71075,14219,71051,14013,71051,14267,71051,
16151,71051,70997,71051,70995,71086,70989,71086,56554,71051,    1,71051,
    2,71094,    2,71051,    1,71098,14211,71051, 9165,71103,    9,71051,
65869,71107,71093,71109,71097,71109,71101,71109,70985,71051,69513,70923,
  903,70923,46862,71120,46862,71121,46863,71121,71123,71127,46863,71120,
71125,71131,    6,65869,    1,71134,70803,71137,56555,71139,    4,71134,
69977,71143,58930,71143,69877,71147,69969,71143,19917,71143,69877,71153,
70343,71143,70035,71143,70125,71143,  587,71143,56555,71162,69877,71165,
56555,71143,  587,71168,69877,71171,    2,71134,  903,71175,    1,71177,
    0,71177,    1,71176,71181,71183,    0,71176,71179,71187,    2,71135,
  265,71191,    0,71192,    1,71192,    0,71193,71197,71199,    1,71193,
71195,71203,    3,71135,    8,71207,    4,71207,    6,71210,    6,71207,
    4,71214,56555,71207,65869,71219,71209,71221,71213,71221,71217,71221,
    0,    5,59619,71229,59961,71230,60166,71229, 1207,71228,19105,71237,
 1180,71228,19119,71241,60158,71228,60180,71228,60178,71228,60318,71228,
60167,71229, 1197,71228,59875,71255,53391,71255, 9805,71255,60159,71228,
60181,71228,60179,71228,38158,71229,44195,71269, 1196,71228,60319,71228,
28739,71229,    2,71277,29229,71279,   59,71228,60221,71283,63823,71228,
61747,71287,61585,71287,61475,71287,63185,71287,   39,71228,56555,71297,
   15,71299,    6,71298,71301,71303,   14,71299,    7,71298,71307,71309,
 1163,71228,19119,71313,   25,71228,61747,71317,63185,71317,25461,71317,
61585,71317,70985,71228,71086,71327,70997,71327,71051,71330,71051,71327,
70997,71334,38057,71229,    6,71338,44195,71341,60973,71229, 1179,71345,
49213,71229,49217,71349,54619,71229,   11,71353,54655,71355, 1003,71229,
60857,71359, 1007,71361,11995,71228,12025,71365,64569,71228,64587,71369,
61989,71228,61747,71373,63185,71373,61585,71373, 8065,71229,   11,71381,
 8067,71383,63777,71229,60857,71387,63779,71389,21918,71229,  987,71393,
54336,71229,54339,71397,  989,71229,21605,71400,  987,71403,21890,71229,
 1179,71407,49262,71229,49217,71411,54331,71229,   17,71414,54339,71417,
25395,71228,25461,71421, 1293,71228,61475,71425,25433,71228,25461,71429,
61005,71228,61475,71433,63014,71228,    5,71437,    7,71438,    7,71437,
    5,71442,   10,71437,  524,71228,    0,71449,    3,71450,    3,71449,
    0,71454,60856,71449,21904,71229,   25,71461,  809,71229,21605,71464,
  713,71467,13755,71229,   17,71470, 9377,71473,65054,71229,63823,71477,
  117,71229,21605,71480,   25,71483,21916,71229,  713,71487,13764,71229,
 9377,71491,65037,71229,   17,71494,63823,71497, 1177,71229,21605,71500,
 1179,71503,49229,71229,   17,71506,49217,71509,26867,71229,21605,71512,
26865,71515,10161,71229,   17,71518,10159,71521,26868,71229,26865,71525,
10162,71229,10159,71529, 1180,71229, 2975,71533, 1903,71533,19025,71533,
33464,71229,34655,71541,34447,71541,33221,71541,33773,71541, 1207,71229,
19027,71551, 3567,71551, 1973,71551, 3041,71551, 1921,71551,19049,71551,
 9824,71229,71273,71565,53462,71229,71273,71569,59900,71229,71273,71573,
60319,71229,71251,71577,60159,71229,71245,71581,60178,71229,71267,71585,
59901,71229,71255,71589,60158,71229,71263,71593,60180,71229,71265,71597,
25461,71229,   25,71601,25395,71601,25433,71601,61475,71229,63823,71609,
 1293,71609,61005,71609,65808,71229,65513,71617,65791,71617,65407,71617,
65171,71617,60835,71229,60318,71229,71275,71629, 9617,71629,19797,71229,
  375,71635,20735,71229,47386,71229,20040,71229,20050,71229,61747,71229,
63823,71647,   25,71647,61989,71647,63185,71229,   25,71655,63823,71655,
61989,71655,61585,71229,63823,71663,   25,71663,61989,71663,20056,71229,
  375,71671, 9825,71229,71255,71675,53463,71229,71255,71679,57562,71229,
58846,71229,58372,71229,58758,71229,58762,71229,57224,71229,57284,71229,
57278,71229,58760,71229,20686,71229,24738,71229,  305,71703,  713,71703,
 1489,71703,   25,71703,10074,71229, 9377,71713,17573,71713,63823,71713,
22766,71229,  305,71721,   25,71721,  147,71721,  713,71721,27672,71229,
63823,71731,27995,71731, 9377,71731,62147,71229,   25,71739,  305,71739,
  147,71739,  169,71739,  713,71739,31881,71229,63823,71751,27995,71751,
31359,71751, 9377,71751,60221,71229,   59,71761,  653,71229,   11,71765,
 9993,71229,17542,71229, 9936,71229,24734,71229,  305,71775,  713,71775,
   25,71775,60834,71229,21350,71229,16129,71229,    3,71787,    2,71787,
  842,71787,  843,71786,71793,71795,  843,71787,  842,71786,71799,71801,
    3,71786,71791,71805,    2,71786,71789,71809,16966,71229,19480,71229,
50522,71229,52740,71229,57380,71229,59108,71229,50478,71229,57252,71229,
19986,71229,51036,71229,57576,71229,58112,71229,58362,71229,  903,71836,
47640,71229,56555,71840,60179,71229,71249,71845,60181,71229,71247,71849,
63015,71229,71441,71853,71445,71853,62905,71853,63041,71853,63047,71853,
63215,71853,    6,71853,63205,71867,19687,71853,21127,71853,20843,71853,
63049,71853,71447,71853,   11,71853,63033,71881,71437,71881,19917,71229,
    9,71886,  525,71229,71453,71891,71457,71891,36729,71891, 1851,71891,
 1885,71891,35635,71891,    2,71891,35633,71905,62095,71891,17711,71891,
 4907,71891,61003,71891,71459,71891,60857,71891,  531,71919,71449,71919,
 1413,71229,  331,71925,49713,71924, 1419,71229,56555,71930,58782,71229,
  903,71934,  296,71229, 8861,71939, 1106,71229,18967,71943, 9617,71943,
24095,71229,46863,71949,57522,71229,   11,71953,  903,71952,  587,71952,
51004,71229,  483,71960,22956,71229,70471,71965,70753,71965,10159,71965,
26865,71965,10111,71965,26715,71965,23709,71965,23713,71965,67425,71965,
10113,71965,26719,71965,23715,71965,  587,71965,10107,71991,26625,71991,
23651,71991,19475,71229,  483,71998,  918,71229,56555,72002,  922,71229,
56555,72006,49713,72006,  668,71229,56555,72012, 1290,71229,    2,72017,
35575,72019,35585,72017, 3621,72017, 1991,72017,60969,72017,62095,72017,
17711,72017, 4907,72017,60857,72017, 1325,72037,58930,71229,    9,72040,
52692,71229,  903,72044,25380,71229,    6,72049,38881,72051,38891,72049,
 9927,72049, 9891,72049, 9895,72049,19687,72049,21127,72049,20843,72049,
   11,72049, 9875,72069, 1447,71229,15705,72073, 9917,71229,20615,71229,
  759,71229,17455,72081, 9195,71229, 1487,72085, 1471,71229,21605,72088,
  305,72091,  713,72091, 1489,72091,   25,72091, 9805,71229, 1197,72101,
 1275,72101,    9,72105, 1197,72100,71273,72109,10001,71229,   17,72112,
 9377,72115,17573,72115,63823,72115,17455,71229,12377,72122,59961,71229,
59619,72126, 1011,72126, 9617,72131, 1011,72127, 9565,72135,59619,72135,
   89,71229,17455,72141,60797,71229,59381,72144,  165,71229,21315,72148,
  587,71229,66971,72153,17455,72153,57522,72152,    9,72152,56555,72160,
56555,72152,    9,72164,60857,72153,    9,72169, 1369,71229,39085,72173,
21605,72172,20843,72177,21127,72177, 9927,72177, 9891,72177,19687,72177,
 9895,72177,   11,72177, 9875,72191, 1275,71229,   17,72194, 4907,72197,
17711,72197, 3621,72197, 1991,72197,62095,72197,60969,72197,60857,72197,
 1325,72211,  483,71229,20035,72214,58742,72214,19475,72214,51004,72214,
56555,72214,  903,72224,  903,72214,56555,72228,49713,72228,49713,72214,
  903,72234,55839,71229,46863,72239,65061,71229,60857,72243,65063,72245,
65067,72245,65071,72245, 7065,71229,18967,72253, 6789,71229,   11,72257,
 6843,72259, 6885,72259, 6889,72259,11277,71229,46863,72267, 9935,71229,
 1011,72270,20645,71229, 1011,72274, 3445,71229,  375,72279, 5045,71229,
46863,72283,17104,71229,48643,72287,12614,71229,  375,72291,69872,71229,
68155,72295,71116,71229,71013,72299,70985,71229,71013,72303,71051,72305,
71051,72302,71013,72309,71051,71229,70985,72313,70997,72315,70985,72312,
71013,72319,  482,71228,23717,72323,24522,72323,24447,72323,23939,72328,
23939,72323,24447,72332,22956,72323,23651,72337,21605,72323,   17,72341,
23939,72343,   17,72340,23651,72347,   17,72323,21605,72351,24447,72353,
21605,72350,23651,72357, 1368,71228,    7,72361,    5,72362,72049,72365,
72177,72365,    5,72361,    7,72370,72049,72373,72177,72373,72191,72361,
72069,72361,   10,72361,72177,72383,72049,72383,27021,72361,24095,72361,
 9195,72361,52915,72361,23651,72361,51435,72361,21605,72361,    9,72401,
67297,72361,70097,72361,69729,72361,11277,72361, 5045,72361,10171,72361,
53941,72361, 9755,72361,26907,72361, 4321,72361,27323,72361, 3833,72361,
 9317,72361, 4295,72361,53215,72361, 1274,71228,    3,72435,    0,72436,
72017,72439,72197,72439,    0,72435,    3,72444,72017,72447,72197,72447,
72211,72435,72037,72435,60856,72435,72197,72457,72017,72457,  586,71228,
39619,72463,51421,72463,57811,72463,59933,72463,59743,72463, 8093,72463,
 3837,72463,42435,72463, 4287,72463,53703,72463, 4303,72463,42113,72463,
 9839,72463,53487,72463, 9579,72463,  483,72463,  803,72494,  828,72463,
  705,72463,  803,72463,  483,72502,  482,71229,66737,72507,36661,72507,
62741,72507,68727,72507,68381,72507, 1274,71229,  587,71228,61747,72521,
25461,72521,61475,72521,63185,72521,61585,72521,  483,71228,56555,72533,
    6,72535,    5,72536,    7,72535,    5,72535,    6,72542,    6,72543,
72541,72547,    6,72534,   15,72535,72551,72553,    7,72534,72545,72557,
72539,72557,   14,72535,72557,72563, 1368,71229,55839,72567,51803,72567,
54159,72567,54497,72567,  265,72567, 1275,71228,59914,72579,60221,72579,
18708,72579, 9856,72579,53504,72579, 9805,72579,    9,72590,53391,72579,
    9,72594,59875,72579,    9,72598,18693,72579,    9,72602,60369,72579,
    9,72579,18693,72608, 9805,72608,59875,72608,53391,72608,  586,71229,
   33,72619, 1447,72619, 1141,72619,  889,72619,  795,72619,  787,72619,
  767,72619,  483,72633, 1505,71229,16937,72636,56555,72636,  581,71229,
60857,72643, 1325,72645,  331,72645,  571,72645,  585,72645,   59,72645,
16937,71229, 1505,72656,13947,71229,    2,72661,14217,72663,   11,72661,
 9875,72667,16091,72667,13955,72667,20501,72667, 9919,71229,20623,71229,
 9921,71229, 1196,71229,72103,72683,71256,72683,71258,72683,71260,72683,
71255,72683,59875,72692,53391,72692, 9805,72692,59875,72683,71255,72700,
 9805,72683,71255,72704,53391,72683,71255,72708,  154,71229,64148,71229,
 1325,72715,   59,72715,  331,72715,  265,72715,52501,71229,  265,72725,
  297,71229,18967,72729, 1107,71229,59960,71229,21105,72735,65513,72735,
65791,72735,65407,72735,21549,72735,19625,72735,65171,72735,59619,72735,
   15,72735,   88,71229,70177,72755,70176,72754,72757,72759,70176,72755,
70177,72754,72763,72765, 1141,72755, 1447,72755,   33,72755,   11,72755,
37409,72755,  972,71229,   59,72779, 1325,72779,  331,72779,27978,71229,
60796,71229,59381,72789,31102,71229,62905,72793,68761,72793,70401,72793,
67541,72793,  164,71229,36729,72803,68447,72803,70731,72803,67547,72803,
54596,71229,44243,72813,20695,71229,  155,71229,20763,71229,  375,72820,
 1197,71229,71273,72825,59875,72827, 9805,72827,53391,72827,53391,72824,
71273,72835, 9805,72824,71273,72839,59875,72824,71273,72843,  375,71229,
20763,72846,20836,71229, 1141,71229,15705,72853,   33,71229,15705,72857,
27021,71229, 1487,72861,  959,71229,17455,72865,52915,71229, 1487,72869,
   47,71229,17455,72873,59875,71229, 1197,72877,72683,72879, 1275,72877,
    9,72883, 1197,72876,71273,72887,  253,71229,21605,72890,  305,72893,
   25,72893,  713,72893,53391,71229, 1197,72901,72683,72903, 1275,72901,
    9,72907, 1197,72900,71273,72911,   53,71229,21605,72914,  305,72917,
   25,72917,  147,72917,  713,72917,27533,71229,   17,72926,63823,72929,
27995,72929, 9377,72929,30749,71229,    7,72937,26970,71229,    7,72941,
70864,71229,    7,72945,69849,71229,    3,72948,68155,72951,    3,72949,
67577,72955,68139,72955,70979,72955,69275,71229,70573,72962,    7,72965,
69513,71229, 1011,72968,    7,72971, 9780,71229,    7,72975,59381,71229,
    2,72979,72789,72981,60797,72978,    6,72978,56555,72986,72981,72989,
26625,71229, 1011,72992,    7,72995, 9731,71229, 1011,72998,    7,73001,
69790,71229,    7,73005,   13,71229,32805,71229,    7,73010,33221,73013,
34655,73013,33773,73013,34447,73013,   15,73011,34875,73023,    7,73011,
34723,73027,   19,71229,   59,73031,   18,71229,65076,71229,    7,73037,
65493,73039,    7,73036,65171,73043,65791,73043,65513,73043,65407,73043,
   15,73037,65357,73053,   12,71229,68974,71229,  375,73059,71119,71229,
    7,73063, 1011,71229,52387,73067,20762,73067,59961,73066, 9617,73073,
20645,73066, 9935,73066,   17,73066,18967,73081, 9617,73081,    6,73066,
    7,73067,18967,73088,26625,73066,    7,73093,18967,73067,    7,73096,
   17,73097, 9731,73066,    7,73103,69513,73066,    7,73107,21315,73066,
    7,73111,   15,71229,18967,73115,   17,73117,    3,73114,    3,73115,
72567,73123,   17,73114,  265,71229,    9,73128, 8861,73131,60857,73129,
    9,73135,65869,73128,  375,73139,   11,71229,60857,73143,    9,73145,
 1275,73143,    9,73149,    9,73142,60857,71229,    7,73154,   59,73157,
 1325,73157,  331,73157,  265,73157,    7,73155,  375,73167,  265,73155,
  375,73171,12377,73154,    7,73175,18967,71229,    7,73179,25793,73181,
41019,73181, 8495,73181,46863,71229,20035,73188,58742,73188,  903,73188,
56555,73194,56555,73188,  903,73198,20035,71229,21183,73203,    7,73203,
  331,73207,  483,73202,46863,73202,    9,73202,    7,73202,  375,73217,
49713,71229,39085,73221,  136,73220, 1197,73220,  137,73220,  922,73220,
 1413,73220, 1011,73220,    6,73234,  483,73220,  903,73238,  903,73220,
  483,73242,    2,73220,    9,73246,44243,73247,    3,73220,    5,73253,
    6,73255,    9,73253,    2,73221,73257,73261,73229,73261,73258,73261,
29229,73261,72683,73261,73237,73261,73087,73261,    9,73261,73253,73276,
73253,73261,    9,73280,    3,73221,73225,73285,73249,73285,73227,73285,
73247,73285,    9,73293,    9,73220,    2,73296,73285,73299,    2,73297,
73253,73303,   17,71229,10161,73306,10159,73309,54339,73307,54331,73313,
49217,73307,49229,73317,54331,73306,54339,73321,49229,73306,49217,73325,
65037,73306,63823,73329,13755,73306, 9377,73333,27995,73307,27533,73337,
17573,73307,10001,73341,    7,73306,    3,73345,    7,73346,73307,73349,
    1,73346,73351,73353,    1,73345,    3,73356,21604,73345,    0,73306,
    3,73363,    0,73364,73307,73367,    6,73364,73369,73371,    6,73363,
    3,73374, 1274,73363,  586,73306,    3,73381,    1,73382,    1,73381,
    3,73386,21604,73381,60856,73306,    3,73393,    6,73394,    6,73393,
    3,73398, 1274,73393,10001,73306,63823,73405, 9377,73405,17573,73405,
27533,73306, 9377,73413,63823,73413,27995,73413, 9377,73307,13755,73421,
27533,73421,10001,73421,63823,73307,65037,73429,10001,73429,27533,73429,
60857,73307,63697,73437,63779,73437,73397,73437,73401,73437,73371,73437,
73377,73437,    7,73437,63709,73437,35893,73437,37897,73437,38299,73437,
73379,73437,73403,73437, 1275,73437,63679,73465,73363,73465,73393,73465,
  587,73307, 1971,73473, 3507,73473,73385,73473,73389,73473, 5231,73473,
73353,73473,73359,73473,    0,73473,21783,73473,23983,73473, 4625,73473,
10603,73473,73361,73473,73391,73473,21605,73473,  713,73503,73345,73503,
73381,73503, 1011,73306,18967,73511, 9617,73511, 1275,73306,72439,73517,
72447,73517, 3621,73517, 1991,73517,    1,73517,73473,73527,73489,73517,
60969,73517,62095,73517, 4907,73517,17711,73517,72457,73517,60857,73517,
 1325,73543,72435,73543,21605,73306,23713,73549,23709,73549,26865,73549,
26715,73549,    6,73549,73437,73559,73451,73549,10159,73549,10111,73549,
26719,73549,10113,73549,67425,73549,70753,73549,70471,73549,23715,73549,
  587,73549,26625,73581,10107,73581,23651,73581, 1011,73307, 9565,73589,
    2,73306,36729,73593,68447,73593,67547,73593,70731,73593,    2,73307,
36727,73603,68451,73603,37895,73603,36079,73603,35575,73603,   15,73306,
21605,71229,26867,73616,26865,73619, 1179,73617, 1177,73623,  987,73617,
  989,73627, 1177,73616, 1179,73631,  989,73616,  987,73635,  809,73616,
  713,73639,  117,73616,   25,73643, 1489,73617, 1471,73647,  147,73617,
   53,73651,26219,73617,    5,73616,    7,73657,    5,73658,73617,73661,
    2,73658,73663,73665,    2,73657,    7,73668, 1368,73657,    3,73616,
    7,73675,    3,73676,73617,73679,    4,73676,73681,73683,    4,73675,
    7,73686,   16,73675,   10,73616,    7,73693,    2,73694,    2,73693,
    7,73698, 1368,73693,  586,73616,    7,73705,    4,73706,    4,73705,
    7,73710,   16,73705,44243,73617,48466,73617,  340,73617, 1397,73617,
   53,73616,  713,73725,  305,73725,   25,73725,  147,73725, 1471,73616,
   25,73735,  305,73735,  713,73735, 1489,73735,   25,73617,  117,73745,
  253,73745, 1471,73745,   53,73745,  713,73617,  809,73755,  253,73755,
   53,73755, 1471,73755,  253,73616,  305,73765,   25,73765,  713,73765,
  305,73617,  253,73773, 1471,73773,   53,73773,    9,73617,46863,73780,
  587,73617, 9381,73785, 9439,73785,73709,73785,73713,73785,25519,73785,
73683,73785,73689,73785,    5,73785, 9383,73785,62077,73785,64317,73785,
64815,73785,73691,73785,73715,73785,   17,73785, 9377,73815,73675,73815,
73705,73815,   11,73617, 7979,73823, 8067,73823,73697,73823,73701,73823,
73603,73823,73665,73823,73671,73823,    3,73823, 7981,73823,39747,73823,
43027,73823,43837,73823,73673,73823,73703,73823, 1369,73823, 7971,73853,
73657,73853,73693,73853,   17,73616,23709,73861,23713,73861,10159,73861,
10111,73861,    2,73861,73823,73871,73839,73861,26865,73861,26715,73861,
10113,73861,26719,73861,67425,73861,70471,73861,70753,73861,23715,73861,
  587,73861,10107,73893,26625,73893,23651,73893, 1369,73616,72365,73901,
72373,73901, 9927,73901, 9891,73901,    4,73901,73785,73911,73801,73901,
 9895,73901,19687,73901,20843,73901,21127,73901,72383,73901,   11,73901,
 9875,73927,72361,73927,46863,73617,    9,73932,    6,73616,62905,73937,
68761,73937,70401,73937,67541,73937,    7,73616,    6,73617,62883,73949,
68767,73949,64267,73949,62235,73949,38881,73949,73437,73949,73947,73949,
72787,73949,    7,73617,25793,73967,41019,73967, 8495,73967,73937,73967,
72793,73967,  265,73966,  265,73617,    6,73981,    7,73981,    6,73980,
73985,73987,    7,73980,73983,73991,  903,71229,64148,73995,57522,73994,
58782,73994,58362,73994,52501,73995,52692,73994,46863,73994,56555,74008,
    9,73994,56555,74012,  483,73994,56555,74016,49713,74016,49713,73994,
  483,74022,   15,73995,  483,74027,    7,73994,   59,74031, 1325,74031,
  331,74031,    7,73995,60857,74038,59875,74039,  375,74039, 9805,74039,
53391,74039,60857,73995,    6,74051,    7,74051,    6,74050,74055,74057,
    7,74050,74053,74061,56555,73994,    7,74065,46863,74064,  483,74064,
    9,74064,58742,71229,    7,74075,    9,74074,46863,74074,  483,74074,
56555,71229,43502,74085,21036,74085,    6,74089,    6,74088,43503,74085,
    6,74095,    6,74094,21037,74085,59634,74085,59635,74085,    6,74105,
    6,74104,21104,74085,59645,74085,43838,74085,21548,74085,21526,74085,
    5,74118,59644,74085,19624,74085,18967,74085,    5,74126,    6,74128,
    6,74129,    6,74126,    5,74134,    6,74127,   14,74126,38305,74085,
    2,74142,59619,74085,    2,74146,    5,74085,59961,74151,    6,74151,
21526,74150,    6,74150,18967,74158,18967,74150,    6,74162,    6,74163,
    2,74085,59619,74168,38305,74168,   14,74085,18967,74174,21527,74085,
74155,74179,    9,74179,19625,74085,21549,74085,43839,74085,21105,74085,
47640,74084,  922,74084,  918,74084, 1505,74084,  668,74084, 1419,74084,
  483,74084,  903,74204,   11,74085,    9,74209,   15,74085,74139,74213,
46863,74084,  903,74216,    9,74084,   11,74221,  903,74220,  587,74220,
  587,74084,    9,74228,    6,74084,74191,74233,74189,74233,74187,74233,
74113,74233,74087,74233,74101,74233,74103,74233,74171,74233,74169,74233,
59619,74251,74149,74233,72981,74233,74185,74233,74145,74233,74173,74233,
74213,74233,59381,74233,    7,74084,74093,74269,74099,74269,74123,74269,
74109,74269,74159,74269,74089,74269,74095,74269,74105,74269,74151,74269,
74111,74269,74115,74269,74117,74269,74157,74269,74121,74269,21105,74269,
21549,74269,65513,74269,65791,74269,65407,74269,74125,74269,19625,74269,
65171,74269,74175,74269,74131,74269,74129,74269,74137,74269,74177,74269,
74161,74269,74165,74269,74163,74269,74141,74269,59619,74269,   15,74269,
    6,74085,21036,74336,74269,74339,43503,74336,74269,74343,59635,74336,
74269,74347,    5,74336,74269,74351,18967,74350,74269,74355,18967,74336,
    5,74358,74269,74361,    7,74085,74091,74365,74097,74365,74107,74365,
74155,74365,21183,74365,65493,74365,74133,74365,74167,74365,    9,74365,
  959,74365,   47,74365,  759,74365,  903,74084,    7,74391,  483,74390,
    9,74390,46863,74390,    9,71229,20035,74400,58742,74400,58930,74400,
19917,74400,  903,74400,56555,74410,  265,74400, 8861,74415,  587,74400,
56555,74418,56555,74400,   11,74423,  903,74422,  587,74422,  265,74401,
 8495,74431,   11,74431,    3,74400,70177,74437,70176,74436,74439,74441,
70176,74437,70177,74436,74445,74447, 1141,74437, 1447,74437,   33,74437,
   11,74437,37409,74437,    3,74401,  113,74461,   11,74400,21522,71229,
    7,74467,63452,71229,    7,74471,13673,71229,    7,74475,17049,71229,
    3,74478,48643,74481,    2,74479,    3,74479,48637,74487,49581,74487,
47813,74487,21315,71229,  165,74494, 1011,74494,    7,74499,16163,71229,
    2,74503,72683,74505,73087,74505,16171,74505,  375,74503,64669,71229,
    7,74515,  265,74517,12377,71229,  256,74521,17455,74520,    7,74520,
  375,74527,    7,74521,  241,74530,  331,74531,60857,74520,    7,74537,
  241,74521,    7,74540,10385,71229,  375,74545,70899,71229,    7,74549,
18391,71229,    7,74553,18617,71229,    7,74557,12705,71229,    7,74561,
70573,71229,69275,74564,    7,74567,    3,71228,74332,74571,72750,74571,
71253,74571,72985,74571,72147,74571,71783,74571,71577,74571,67600,74571,
45491,74571,42800,74571,59710,74571,74365,74593,74269,74571,59619,74596,
72735,74571,59619,74600,59694,74571,60563,74571,  629,74571,  101,74571,
  705,74571,  299,74571,  128,74571,  828,74571,  394,74571,48122,74571,
70327,74571,66930,74571, 9606,74571,10374,74571,  113,74571,    9,74632,
74465,74571,73153,74571,73031,74571,73057,74571,73131,74571,71939,74571,
72733,74571,74415,74571,72145,74571,59381,74653,42134,74571,10291,74571,
   17,74658,51992,74571,  375,74571,  241,74664,65869,74664,49713,74664,
60796,74571,74213,74673,  256,74571,  803,74571,  483,74678,  483,74571,
  803,74682,31103,74571,65869,74686,    6,74571,59619,74690,74365,74693,
56555,74690,74213,74697,    7,74571,  241,74700,    7,74570,57811,74705,
59933,74705,59743,74705, 9839,74705, 9579,74705,39619,74705,51421,74705,
 4287,74705, 4303,74705, 8093,74705, 3837,74705,53487,74705,42113,74705,
42435,74705,53703,74705,42613,74571,   17,74736,46863,74571,12377,74740,
    9,74571,  113,74744,49713,74571,  375,74748,   17,74571,42613,74752,
59619,74752,10291,74752, 9565,74752,41941,74752, 9565,74571,    7,74765,
   17,74764,65869,74571,60796,74771,60797,74771,31103,74770,60797,74770,
74773,74779,60796,74770,74775,74783,  375,74770,  241,74571,  375,74788,
    7,74788,56555,74571,    5,74795,74269,74797,72735,74797,    6,74797,
74365,74803,    6,74796,74269,74807,72735,74807,   14,74795,72735,74813,
74269,74813,   15,74795,    6,74795,    5,74820,74269,74823,72735,74823,
    7,74795,74803,74829,    6,74794,74213,74833,74819,74833,    7,74794,
74807,74839,74823,74839,71229,74838,74807,74845,74823,74845,74797,74845,
74813,74845,74813,74839,12377,74571,46863,74856,41941,74571,    7,74861,
   17,74860,59619,74571,74269,74866,72735,74866,    6,74866,74365,74873,
    6,74867,74269,74877,72735,74877,    7,74867,   17,74866,    2,71228,
71233,74887,56555,74887,72129,74887,72127,74887,59619,74895,71235,74887,
72790,74887,71627,74887,74153,74887,74155,74887,74365,74906,74372,74887,
74158,74887,74269,74913,74279,74887,74350,74887,74269,74919,74353,74887,
74266,74887,74150,74887,    6,74927,74365,74929,    6,74926,74269,74933,
74269,74927,74287,74887,74336,74887,    5,74940,74269,74943,60261,74887,
71629,74887,63737,74887,37179,74887, 9535,74887,63743,74887, 9537,74887,
37185,74887,74264,74887,74174,74887,74269,74965,74315,74887,73073,74887,
37887,74887,37205,74887,37235,74887,74085,74887,    5,74978,    6,74981,
74365,74983,    6,74980,74269,74987,74269,74981,    6,74978,    5,74992,
74269,74995,    6,74979,74213,74999,   14,74978,74269,75003,    5,74887,
74336,75006,74269,75009,74085,75006,    6,75013,74365,75015,    6,75012,
74269,75019,74269,75013,74085,75007,74233,75025,    6,75006,72735,75029,
74085,75028,74269,75033,74269,75029,74085,75029,74233,75039,    7,75006,
71853,75043,72049,75043,72177,75043,73901,75043,    6,75007,74365,75053,
    7,75007,72131,74887,72753,74887,74335,74887, 9563,74887,74382,74887,
   10,74887,72177,75069,72049,75069,71853,75069,73901,75069,   14,74887,
74085,75079,74233,75081,74085,75078,74269,75085,72735,75079,74269,75079,
72191,74887,72069,74887,73927,74887,71881,74887,64759,74887,63763,74887,
63813,74887, 9559,74887,74213,74887,74233,75108,74365,74887,74155,75112,
    9,75112,43123,74887,42606,74887,53318,74887, 9362,74887,27218,74887,
28189,74887,74233,74887,59381,75130,74213,75130,72789,74887,59381,75136,
64289,74887,26182,74887,28991,74887, 8804,74887,54289,74887,53802,74887,
 8150,74887, 1290,74887,63679,75155, 9533,75155,37145,75155,  525,74887,
 9533,75163,63679,75163,37145,75163,  922,74887, 1413,74887,73615,74887,
73127,74887,73009,74887,73035,74887,73081,74887,71943,74887,72729,74887,
73511,74887,41762,74887, 7971,74887,    9,75192,53517,74887,    9,75196,
  483,74887,  903,75200, 9195,74887,    9,75204, 1275,74887,   17,75208,
 9533,75211,37145,75211,63679,75211,27021,74887,    9,75218,    7,74887,
    2,75223,60857,75225,71229,75227,    5,75222,71853,75231,72049,75231,
72177,75231,73901,75231,75229,75231,    2,75222,73616,75243,75231,75245,
21605,75243,71229,75248,75231,75251,71229,75243,21605,75254,75231,75257,
    6,74887,74150,75260,74269,75263,74085,75260,    5,75266,74269,75269,
56555,75261,71229,75272,74085,75261,74155,75277,    9,75277,    5,75260,
72735,75283,74085,75282,74269,75287,74269,75283,74085,75283,74233,75293,
75275,75283,   11,75261,21604,75299,21604,75298,21605,75299,75303,75305,
21605,75298,75301,75309,52915,74887,    9,75312,    6,74886,23717,75317,
24522,75317,24447,75317,23939,75322,23939,75317,24447,75326,22956,75317,
23651,75331,   17,75317,21605,75335,24447,75337,21605,75334,23651,75341,
21605,75317,   17,75345,23939,75347,   17,75344,23651,75351,    7,74886,
27021,75355,24095,75355, 9195,75355,52915,75355,21605,75355,    9,75365,
67297,75355,26907,75355, 9755,75355, 9317,75355, 3833,75355,23651,75355,
51435,75355,27323,75355, 4321,75355,69729,75355,53215,75355, 4295,75355,
70097,75355,53941,75355,10171,75355, 5045,75355,11277,75355,42155,74887,
    9,75402,   19,74887,   12,74887,   11,74887,    9,75410,    9,74887,
74365,75414,42155,75414,27021,75414,52915,75414, 9195,75414,25793,75414,
53517,75414, 7971,75414, 8495,75414,41019,75414,   11,75414,   17,74887,
 1275,75438, 9533,75441,37145,75441,63679,75441, 8495,74887,    9,75448,
  903,74887,  483,75452,21605,74887,26219,75457,42810,75456,75056,75456,
75057,75457,75463,75465,75053,75457,42810,75457,75057,75456,75056,75457,
75473,75475,42811,75456,75471,75479,42811,75457,75461,75483,44243,75457,
  375,75457,    6,75457,    7,75457,25793,75493,    6,75456,75493,75497,
    7,75456,75491,75501,41019,74887,    9,75504,59381,74887,72789,75508,
74233,75508,25793,74887,    9,75514,26625,74887,    6,75518,    7,75518,
    6,75519,75523,75525,    7,75519,75521,75529, 9731,74887,    6,75532,
    7,75532,    6,75533,75537,75539,    7,75533,75535,75543,69513,74887,
    6,75546,    7,75546,    6,75547,75551,75553,    7,75547,75549,75557,
    7,71228,73276,75561,27306,75561,73261,75561,    9,75566,24095,75561,
52603,75561,53910,75561,55537,75561,20053,75561,20831,75561,19783,75561,
64289,75561,27021,75561,25793,75586,  265,75587,  959,75561,60857,75593,
58775,75561, 5045,75561,11277,75561, 4551,75561,70136,75561,10196,75561,
  273,75561, 1477,75561,  281,75561,  948,75561, 1516,75561,  922,75561,
 1413,75561,52915,75561,  265,75623,   47,75561,60857,75627,25793,75561,
27021,75630, 9195,75561,  265,75635,  759,75561,60857,75639,   89,75561,
 5019,75643,60857,75643, 1505,75561, 1011,75648,  587,75561,60857,75653,
70573,75653, 1369,75561,43503,75659,  483,75561,  903,75662,  165,75561,
  903,75666, 1141,75561,18967,75671, 1447,75561,18967,75675,    2,75561,
61780,75679,    9,75679,60857,75682,54295,75679,70085,75679,53925,75679,
10155,75679,11529,75679,60857,75679,    9,75696,    3,75561,73221,75701,
    9,75703, 8063,75701,53667,75701,42361,75701,   33,75561,18967,75713,
    2,75560,27021,75717,24095,75717, 9195,75717,52915,75717,21605,75717,
    9,75727,67297,75717,23651,75717,51435,75717,27323,75717, 4321,75717,
 9755,75717,26907,75717, 9317,75717, 3833,75717,69729,75717,53941,75717,
10171,75717,70097,75717,53215,75717, 4295,75717, 5045,75717,11277,75717,
    3,75560,57811,75765,59933,75765,59743,75765,39619,75765,51421,75765,
 4287,75765, 4303,75765, 9839,75765, 9579,75765, 8093,75765, 3837,75765,
42113,75765,53487,75765,42435,75765,53703,75765,  265,75561,53813,75796,
69877,75796,10107,75796, 1011,75561, 1505,75804,54597,75805,21605,75561,
    9,75811,  145,75811,  903,75561,  165,75816,  483,75816,54295,75817,
    9,75561,73261,75824,69877,75561,  265,75828,10107,75561,  265,75832,
53813,75561,  265,75836,    6,71228,63091,75841,63099,75841,63117,75841,
25451,75841,53597,75841,42283,75841,61289,75841,61281,75841,62345,75841,
    0,75841,    3,75860,71891,75863,72017,75863,72197,75863,73517,75863,
    3,75861,62359,75841,60856,75841,72197,75877,72017,75877,71891,75877,
73517,75877,72211,75841,72037,75841,73543,75841,71919,75841,19739,75841,
61649,75841,61263,75841,61323,75841,20763,75841, 1011,75903, 1010,75902,
75905,75907, 1010,75903, 1011,75902,75911,75913,25380,75841, 7971,75917,
53517,75917,42155,75917,63015,75841,53517,75925, 7971,75925,42155,75925,
 1369,75841,21605,75932,53517,75935,42155,75935, 7971,75935,    3,75841,
    6,75943,   11,75945,71229,75947,    0,75942,71891,75951,72017,75951,
72197,75951,73517,75951,75949,75951,    6,75942,73306,75963,75951,75965,
   17,75963,71229,75968,75951,75971,71229,75963,   17,75974,75951,75977,
    2,75841,60857,75981,   16,75983,   16,75982,   17,75983,75987,75989,
   17,75982,75985,75993,    2,75840,23717,75997,24522,75997,23939,75997,
24447,76002,24447,75997,23939,76006,22956,75997,23651,76011,21605,75997,
   17,76015,23939,76017,   17,76014,23651,76021,   17,75997,21605,76025,
24447,76027,21605,76024,23651,76031,21605,75841, 1369,76034,53517,76037,
42155,76037, 7971,76037,   17,75841,37844,76044,75872,76044,75873,76045,
76049,76051,37844,76045,75873,76044,75872,76045,76057,76059,37845,76044,
76055,76063,37845,76045,76047,76067,    7,71229,74797,76071,74829,76073,
  264,76071,    5,76071,    3,76078,    3,76079,    5,76070,75925,76085,
63014,76085,75841,76089,75917,76085,25381,76085,75841,76095,75935,76085,
76037,76085,  483,76085,60857,76102,75841,76105,60857,76085,  483,76108,
75841,76111,32805,76070,34655,76115,33773,76115,34447,76115,33221,76115,
32805,76071,34003,76125,33319,76125,34447,76071,35031,76131,65407,76071,
65335,76135,65076,76070,65513,76139,65791,76139,65407,76139,65171,76139,
65076,76071,65625,76149,65267,76149,20035,76070,  375,76155,74794,76071,
59381,76159,74819,76159,74571,76071,56555,76165,59619,76167,56555,76164,
59381,76171,12377,76070,  375,76175,49204,76071, 1369,76071,  241,76181,
56555,76071,74571,76184,59381,76187,59381,76185,74571,76191,49205,76071,
65869,76195, 1275,76071,  903,76199,60857,76070,   59,76203, 1325,76203,
  331,76203,  265,76203,  903,76070,   59,76213, 1325,76213,  331,76213,
56555,76070,74877,76221,74866,76221,65513,76221,65791,76221,65407,76221,
74807,76221,74823,76221,74797,76221,21105,76221,75029,76221,75283,76221,
21549,76221,19625,76221,65171,76221,75079,76221,74813,76221,59619,76221,
74571,76254,74571,76221,59619,76258,   15,76221,74887,76263,21605,76070,
73949,76267,  265,76071,63823,76271,63679,76271,72619,76271, 9377,76271,
 9533,76271,37145,76271,    2,76070,76077,76285,76081,76285,55839,76285,
54159,76285,54497,76285,51803,76285,73123,76285,76179,76285,65869,76301,
  265,76285,    3,76070,76196,76307,67988,76307,   33,76307, 1447,76307,
 1141,76307,76271,76307,76195,76307,65869,76320,    9,76307,46863,76307,
65869,76326,65869,76307,76195,76330,46863,76330,    2,76071,76310,76337,
76328,76337,76334,76337,76083,76337,   10,76337,    5,76337,    7,76348,
    7,76337,    5,76352,55803,76337,54225,76337,54477,76337,51593,76337,
67988,76337,76307,76364,64345,76337,76324,76337,73121,76337,72713,76337,
76326,76337,65869,76376,    9,76337,76307,76380,60857,76337,71229,76385,
76347,76387,76351,76387,76355,76387,  903,76337,46863,76337,76330,76396,
65869,76396,76307,76400,76307,76396,65869,76404,76330,76337,46863,76408,
65869,76337,76326,76412,46863,76412,76307,76416,76307,76412,46863,76420,
76307,76337,67988,76424,    9,76424,46863,76424,65869,76430,65869,76424,
46863,76434,    3,76071,    5,76438,76285,76441,  113,76439,46863,76438,
76285,76447,65869,76449,76285,76439,67988,76453,    9,76453,46863,76453,
65869,76458,65869,76453,46863,76462,   15,76071,74485,76467,73261,76467,
46863,76071,    3,76472,76285,76475,65869,76477,    3,76473,76412,76481,
65869,76481,76337,76484,76337,76481,65869,76488,65869,76070,  375,76493,
70176,71229,  375,76497,    3,71229,70554,76500,    5,76501,    1,76505,
71229,76507,    2,76509,59961,76505,74887,76513,    6,76505,76511,76517,
73261,76517,    0,76500,75163,76523,  524,76523,74887,76527,75155,76523,
 1291,76523,74887,76533,75211,76523,75441,76523,  483,76523,   11,76540,
74887,76543,   11,76523,  483,76546,74887,76549,   33,76501,    9,76553,
 8147,76501,42315,76501,53777,76501,70555,76500,70176,76500,    9,76565,
43848,76501,70177,76501,76563,76571,76566,76571,    9,76571,76565,76576,
76565,76571,    9,76580, 1141,76501,    9,76585, 1447,76501,    9,76589,
69849,76500,68155,76593,17049,76500,48643,76597, 1369,76501,  803,76601,
   15,76500,76337,76605,37409,76501,    9,76609,    9,76500,70177,76613,
76565,76615,70177,76612, 1141,76613, 1447,76613,   33,76613,   11,76613,
37409,76613,   11,76501,    9,76631,    6,76500,    7,76500,   33,76637,
 1447,76637, 1141,76637,76271,76637,    6,76501,60856,76647,    0,76647,
    3,76650,    3,76647,    0,76654,   11,76647,71229,76659,76649,76661,
76653,76661,76657,76661,    7,76501,43503,76668,70177,76500,    9,76672,
70176,76501,76619,76677,76503,76677,76675,76677,76673,76677,    9,76685,
43503,76501,    7,76688,   17,76689, 1011,76501,  375,76695,    7,76695,
18967,76501,    4,76700,    5,76700,76071,76705,    6,76704,    6,76705,
76070,76701,76709,76713,76705,76713,   14,76700,76713,76719,71229,76701,
    7,76723,76711,76725,    7,76722,76709,76729,76705,76729,76719,76729,
   15,76723,76071,76701,76703,76739,   15,76700,76739,76743,    6,76700,
    5,76746,76729,76749,76713,76749,    7,76700,76707,76755,76711,76755,
    6,76701,76743,76761,76737,76761,    7,76701,76749,76767,76709,76767,
71229,76766,76749,76773,76709,76773,76705,76773,76719,76773,76719,76767,
65869,76500,68155,76785,68109,76785,  256,76785,    7,76785,  241,76792,
  241,76785,    7,76796,70572,71229,68155,76801,68109,76801,  256,76801,
    7,76801,  241,76808,  241,76801,    7,76812,    2,71229,    0,76817,
    4,76818,    0,76816,    2,76823,    5,76816,62284,76817,62186,76817,
64248,76817,62504,76817,64205,76817,61690,76817,52501,76817,70021,76817,
17496,76817,11179,76817,10187,76817,53967,76817,17455,76817,    9,76852,
16065,76817,   16,76857,   16,76856,   17,76857,76861,76863,   17,76856,
76859,76867,70802,76817,  340,76817,60857,76872,64148,76817,  265,76876,
    9,76817,17455,76880,  375,76817,60857,76884,  587,76817,   17,76889,
37145,76891, 9533,76891,76523,76891,76821,76891,63679,76891,44243,76817,
60857,76902,49713,76903,   17,76816,36729,76909,68447,76909,67547,76909,
70731,76909,49713,76816,44243,76919,54295,76817,    9,76923,    6,76816,
66737,76927,36661,76927,62741,76927,68381,76927,68727,76927,    7,76816,
54497,76939,55839,76939,54159,76939,51803,76939,73123,76939,  265,76939,
    7,76817,62494,76952,70573,76952,  265,76952,60857,76958,60857,76952,
  265,76962,  265,76953,60857,76967,62494,76817,    7,76970,43215,76817,
    9,76975,  265,76817,64148,76978,  483,76979,    7,76978,60857,76984,
60857,76978,    7,76988,60857,76817,42810,76993,42810,76992,42811,76993,
76997,76999,  375,76992,  340,76992,42811,76992,76995,77007,44243,76992,
    6,76992,    7,76992,  265,77014,    6,76993,77015,77019,    7,76993,
77013,77023,  265,76993,    7,77027,  265,76992,    7,77030,65869,76817,
69275,77035,    7,77037,70573,76817,    6,77041,    7,77041,    6,77040,
77045,77047,    7,77040,77043,77051,65869,76816,69716,77055,    7,77055,
69513,77058,69513,77055,    7,77062,70922,71229,69716,77067,    7,77067,
69513,77070,69513,77067,    7,77074,    6,71229,74890,77079,59619,77081,
38056,77078,    5,77084,76825,77079,76827,77089,55814,77078,55815,77079,
77093,77095,55815,77078,55814,77079,77099,77101, 1346,77078, 1346,77079,
 1347,77078,77107,77109,17126,77079,17125,77079,    2,77114,17127,77079,
 9565,77119,74169,77079,59619,77123,60621,77079,59619,77127,38056,77079,
38057,77078,44195,77133,58303,77079, 1010,77079, 1010,77078,77119,77141,
35187,77079,    2,77144,    0,77079,    4,77149,    2,77151,71229,77152,
71229,77151,    2,77156,    2,77157,76816,77151, 1011,77149,71229,77165,
    5,77079,    1,77168,    5,77078,38056,77173,77133,77175,    2,77172,
58302,77079,77141,77181, 9565,77181,59619,77181,20501,77079, 1011,77189,
 1010,77188,77191,77193, 1010,77189, 1011,77188,77197,77199,  567,77079,
21604,77203,21604,77202,21605,77203,77207,77209,21605,77202,77205,77213,
 1347,77079,77105,77217,74887,77079,56555,77220,59619,77223,56555,77221,
59381,77227, 9875,77079, 1011,77231, 1010,77230,77233,77235, 1010,77231,
 1011,77230,77239,77241,56555,77079,74887,77244,59619,77247,59619,77245,
74887,77251, 1011,77244, 9565,77255,77141,77255,59619,77255, 1011,77245,
 9617,77263,77139,77263,74887,77263,  587,77079,21605,77271,42155,77273,
53517,77273,76085,77273,77171,77273, 7971,77273, 1011,77078,77113,77285,
77117,77285,74505,77285,77131,77285,77137,77285,77147,77285,73261,77285,
38057,77079,77179,77301,77087,77301,41941,77301,76827,77301, 9565,77301,
59619,77301,77141,77301,56555,77078,72981,77317,75508,77317,74887,77317,
59381,77322,59381,77317,74887,77326,21605,77078,62905,77331,68761,77331,
67541,77331,70401,77331,73967,77331, 1011,77079,56555,77343,59381,77345,
56555,77342,59619,77349,77141,77349, 9565,77349,    2,77078,66737,77357,
    5,77356,77301,77361,62741,77357,36661,77357,68727,77357,68381,77357,
    3,77078,77161,77373,    2,77079,17125,77376,77285,77379,35187,77376,
77285,77383,    3,77079,77155,77387,77159,77387,77163,77387,77167,77387,
   11,77079,37844,77397,37844,77396,37845,77397,77401,77403,37845,77396,
77399,77407,65869,71229, 1530,77410,  842,77410,48535,77410,  669,77410,
 1419,77410,49514,77410,  136,77410,49515,77410,  137,77410,  843,77411,
77415,77431, 1531,77411,77413,77435,  843,77410, 1530,77411, 1531,77410,
77441,77443,  842,77411,77439,77447, 1418,77410,48534,77410,  668,77410,
  587,77410,46863,77456,    9,77456, 1369,77410,   15,77462,    9,77410,
    2,77467,    2,77466,  587,77466,  265,77410,  375,77475,   15,77410,
 1369,77478,46863,77410,    2,77483,    2,77482,  587,77482,    7,77411,
   59,77491, 1325,77491,  331,77491,  265,77491,    6,77410,77491,77501,
    2,77503,    3,77503,    2,77502,77507,77509,    3,77502,77505,77513,
    3,77411,67577,77517,77425,77517,77423,77517,68139,77517,70979,77517,
77455,77517,77453,77517,77421,77517,77471,77517,77487,77517,77461,77517,
77459,77517,77473,77517,77489,77517,    7,77517, 1011,77517,    7,77549,
    2,77410,    9,77552,77517,77555,46863,77552,77517,77559,69716,77553,
77546,77553,    7,77553,69513,77566,77517,77566,69513,77553,    7,77572,
77517,77553,    6,77577,    7,77577,    6,77576,77581,77583,    7,77576,
77579,77587,    2,77411,76517,77591,29229,77591,72789,77591,77429,77591,
77427,77591,72683,77591,74233,77591,77317,77591,77451,77591,77419,77591,
77417,77591,77285,77591,73087,77591,77465,77591,77481,77591,    7,77591,
70573,77591,    7,77625,    3,77410,    4,77628,77591,77631,    1,77628,
    5,77628,    0,77628,77591,77639,    5,77629,    6,77643,77591,77645,
68155,77629,77469,77629,77485,77629,68109,77629,77623,77629,77631,77657,
77639,77657,  256,77629,77622,77629,77635,77665,77637,77665,    6,77629,
77632,77671,77640,77671,77631,77671,77591,77676,77639,77671,77591,77680,
77591,77671,77631,77684,77639,77684,    7,77629,77635,77691,77591,77693,
77637,77691,77591,77697,  241,77690,77591,77690,77635,77703,77637,77703,
  241,77629,    7,77708,77591,77629,    6,77713,    7,77713,    6,77712,
77717,77719,    7,77712,77635,77723,77637,77723,77715,77723,    6,77411,
    7,77410,  375,77733,77731,77733,    2,77737,    3,77737,    2,77736,
77741,77743,    3,77736,77739,77747,    1,    6,18363,77751, 4389,77751,
18362,77751, 4388,77751,70572,77750,70667,77761,70849,77761,70803,77761,
56555,77767,70883,77761,  272,77751, 8997,77773, 4425,77773, 8452,77751,
  251,77779, 8841,77779, 8453,77751,  273,77751, 4139,77751, 8429,77751,
 4138,77751, 8428,77751,70879,77751,70797,77797,18257,77751,  465,77801,
  445,77751,17827,77805, 4371,77751,  265,77808,18339,77751,  265,77812,
64953,77751,  375,77817,14888,77751,  375,77821,13569,77751,  375,77825,
 4137,77751,  265,77828, 8401,77751,  265,77832,  413,77750,77835,77837,
77831,77837,77795,77837,77793,77837,77815,77837,77811,77837,77757,77837,
77759,77837,  241,77837, 1217,77750,  412,77750, 8401,77859, 4137,77859,
18339,77859, 4371,77859,77791,77859,77789,77859,77753,77859,77755,77859,
 1216,77750,40461,77751,    9,77879,59573,77751,  375,77883,69467,77751,
  375,77887, 7047,77751,  412,77891,  413,77890,77893,77895,  413,77891,
  412,77890,77899,77901,12615,77751,  375,77905,45880,77751,46275,77909,
33390,77751,34003,77913,77462,77751,77591,77917,65232,77751,65625,77921,
  923,77751,16481,77925,16783,77925,18797,77925,25367,77751,    9,77933,
68975,77751,  375,77937,62984,77751,    9,77941, 1412,77751,17827,77945,
  412,77751,77837,77949, 1216,77751, 9137,77751,  375,77955,  253,77751,
 9136,77959, 9137,77959,17826,77959,    1,77959,  413,77966,17827,77959,
  413,77959,    1,77972,  265,77958, 8997,77977, 4425,77977,77963,77977,
77965,77977,77969,77977,77975,77977,  265,77959, 8997,77990, 8997,77959,
  265,77994,  265,77995,12377,77959, 8337,77751,  266,78003,  267,78003,
  464,78003,    6,78003,  413,78010,  465,78003,  413,78003,    6,78016,
  265,78002,  251,78021, 8841,78021,78007,78021,78009,78021,78013,78021,
78019,78021,  265,78003,  251,78034,  251,78003,  265,78038,  265,78039,
  375,78003,38057,77751,  265,77751,18339,78048,77837,78051, 4371,78048,
77837,78055,  253,78048, 8997,78059, 4425,78059, 8337,78048,  251,78065,
 8841,78065,77837,78049, 8401,78071, 4137,78071,18339,78071, 4371,78071,
 4137,78048,77837,78081, 8401,78048,77837,78085,  241,78049, 8401,78089,
 4137,78089, 1369,78048,17827,78095,  241,78048, 1011,77751,56555,78101,
60369,78103,  241,77751,  413,78107,14315,78106,  375,78111,57522,78107,
67028,78107,  265,78107,60857,78106,    9,78121,56555,78107,    9,78124,
65869,78107,  483,78128,  483,78107,65869,78132,    9,78107,56555,78136,
  265,78106, 8685,77751,  375,78143,  264,77750,78066,78147,78060,78147,
78091,78147,78093,78147,18339,78147, 4371,78147,17911,78147,13433,78147,
13411,78147,13635,78147,77978,78147,78022,78147,77999,78147,78043,78147,
77774,78147,77780,78147,64733,78147,64955,78147,78021,78147,  251,78184,
77977,78147, 8997,78188,78065,78147,  251,78192,78059,78147, 8997,78196,
77779,78147,  251,78200,77773,78147, 8997,78204, 9139,78147, 9123,78147,
 9065,78147,14935,78147,64919,78147,59463,78147,69357,78147,59533,78147,
69427,78147,59587,78147,69481,78147,78088,78147, 8401,78231, 4137,78231,
 8997,78147,78059,78236,77977,78236,77773,78236,  251,78147,78065,78244,
78021,78244,77779,78244,27979,78147,26293,78147,41503,78147, 8685,78147,
78141,78147,77949,78147,78099,78147,78049,78147, 8337,78267,  251,78269,
  253,78267, 8997,78273,  241,78266, 8401,78277, 4137,78277,  241,78267,
 1369,78147,  241,78147,    6,78287,78065,78289,78021,78289,77779,78289,
    1,78287,78059,78297,77977,78297,77773,78297,78049,78286, 8401,78305,
 4137,78305,16381,78147,19513,78147,35843,78147,13325,78147,70407,78147,
69063,78147,67565,78147,  341,78147,64669,78325, 8997,78325,59381,78325,
69275,78325,65869,78325,  241,78325,  471,78147,  367,78147,  357,78147,
 8401,78147, 4137,78147,37019,78147, 4063,78147,20219,78147, 3863,78147,
20697,78147,37377,78147, 9955,78147,10273,78147,14625,78147, 4569,78147,
  265,77750,77785,78369,  251,78371,77787,78369, 8997,78375,  253,78369,
 8997,78379, 8337,78369,  251,78383,  241,78368, 8401,78387, 4137,78387,
77791,78387,77789,78387,  241,78369,  241,77750, 8428,78399,78147,78401,
 4138,78399,78147,78405, 4137,78399,  265,78409,  265,78408,78147,78413,
 8401,78399,  265,78417,  265,78416,78147,78421,  265,78398, 8401,78425,
 4137,78425,77791,78425,77789,78425,  265,78399, 8401,78434,78147,78437,
 4137,78434,78147,78441,78147,78435, 8401,78445, 4137,78445,  240,77751,
  265,78451, 1010,77751,28337,78455,  264,77751,78426,78459,78428,78459,
78419,78459,78411,78459,78388,78459,78390,78459,77860,78459,77862,78459,
77864,78459,77866,78459,18339,78459,77859,78480, 4371,78459,77859,78484,
78381,78459,78385,78459,13381,78459,77961,78459,78005,78459,77993,78459,
78037,78459,77997,78459,78041,78459,78015,78459,77971,78459,77807,78459,
77803,78459,64746,78459,78382,78459,  251,78517,78378,78459, 8997,78521,
78035,78459,  251,78525,77991,78459, 8997,78529, 9072,78459, 9105,78459,
59470,78459,69364,78459,59521,78459,69415,78459,64931,78459,  413,78459,
77859,78459, 8401,78548, 4137,78548,18339,78548, 4371,78548,78425,78459,
 8401,78558, 4137,78558,78387,78459, 8401,78564, 4137,78564, 8401,78459,
78425,78570,78387,78570,77859,78570, 4137,78459,78425,78578,78387,78578,
77859,78578, 8337,78459,78369,78586,  251,78589,  253,78459,78369,78592,
 8997,78595,78396,78459,78119,78459,78369,78459, 8337,78602,  251,78605,
  253,78602, 8997,78609,  241,78603, 8401,78613, 4137,78613,  241,78602,
69275,78459,  375,78620,59381,78459,  375,78624, 8997,78459,  375,78628,
64669,78459,  375,78632,70327,78459,65869,78459,  375,78638,66930,78459,
  375,78459,64669,78644, 8997,78644,59381,78644,69275,78644,65869,78644,
  241,78644,  241,78459,78369,78658,  375,78658,  394,78459,  299,78459,
 1217,77751,  413,77751,77859,78671,78369,78671,  375,78671,14315,77751,
  241,78678,  375,78681,  375,78679,  341,77751,12377,78687,  257,77751,
  375,78691,70572,77751,70693,78695,70800,78695,70797,78695,56555,78700,
56555,78695,70797,78704, 1346,77751,    9,78709, 1061,77751,    9,78713,
  525,77751,    9,78717,64396,77751,    9,78721,38056,77751,29229,78725,
    9,78725,  137,77751,56555,78731,    5,78733,    4,78732,78735,78737,
    4,78733,    5,78732,78741,78743,20103,77751,  375,78747, 1471,77751,
12377,78751,36773,77751,  375,78755,   53,77751,12377,78759,45639,77751,
 1369,78762,46275,78765,32805,77751,   17,78768,34003,78771,77410,77751,
 1369,78774,77591,78777,65076,77751,   17,78780,65625,78783, 1275,77751,
    5,78786,    9,78789,    5,78787,   17,78793,35187,77751, 1196,78797,
    6,78797, 1011,78800,  137,78797,  136,78797, 1197,78797, 1413,78797,
  922,78797, 1011,78797,    6,78814,  903,78797,  483,78818,  483,78797,
  903,78822,    2,78796,78805,78827,29229,78827,78799,78827,78817,78827,
78803,78827,    9,78827,    3,78796,78807,78841,78809,78841,    2,78797,
78841,78847,    9,78849,    9,78846,78841,78853,    3,78797,    5,78857,
    6,78859,78827,78861,78838,78857,    9,78857,78827,78866,78827,78857,
    9,78870,    9,78797,    2,78875,78857,78877,    3,78875,    2,78874,
78841,78883,    3,78874,   17,77751,65076,78889,65407,78891,32805,78889,
34447,78895,20035,78889,58742,78889,65076,78888,65625,78903,32805,78888,
34003,78907,  903,78889,56555,78910,56555,78889,  903,78914,65869,78889,
    2,78919,    3,78919,    2,78918,    3,78918,18967,77751,  295,78929,
 1108,78929, 1011,78929,    9,78934,    9,78929, 1011,78938,  483,78929,
18967,78943,    5,78944,    5,78945,21036,78943,21037,78943,    4,78943,
78949,78955,    5,78943,18967,78958,    4,78942,78961,78963,78947,78963,
78951,78963,    5,78942,78953,78971, 1369,77751,12376,78974,12376,78975,
12377,78974,78979,78981,77410,78975,77517,78985,45639,78975,46599,78989,
12377,78975,78977,78993,36527,78975,68806,78975,77410,78974,77591,79001,
45639,78974,46275,79005, 1011,78975,65869,79008,65869,78975, 1011,79012,
  265,78974,17827,79017,56555,78975,    4,79021,    5,79021,    4,79020,
    5,79020,60857,77751,  241,79030,    9,79033,    5,79030,    9,79037,
    5,79031,   17,79041,70177,77751,38056,79045,38056,79044,38057,79045,
79049,79051,38057,79044,79047,79055,  375,79045,27979,77751,  375,79061,
    2,77750,68283,79065,68275,79065,36633,79065,36627,79065,39987,79065,
66423,79065,66883,79065,66405,79065,66397,79065,67687,79065,78047,79065,
    9,79087,36544,79065, 9875,79091,20501,79091,68177,79065, 9875,79097,
20501,79097,64396,79065,    9,79103,    5,79065,60857,79106,    9,79109,
35187,79065,   11,79112,20501,79115, 9875,79115,   11,79065,35187,79120,
 9875,79123,20501,79123,60857,79065,    5,79129,   17,79131,    5,79128,
    9,79135,    3,77750,40779,79139,63907,79139,73421,79139,73429,79139,
64235,79139,67465,79139,63955,79139,39027,79139,38685,79139,64073,79139,
    6,79139,    4,79161,78728,79139,78838,79139,78827,79139,    9,79168,
78725,79139,    9,79172, 9934,79139,20644,79139, 4663,79139,  903,79181,
17219,79139,  903,79185,12345,79139,    5,79189,    4,79188,79191,79193,
    4,79189,    5,79188,79197,79199, 5123,79139,    5,79203,    4,79202,
79205,79207,    4,79203,    5,79202,79211,79213,19667,79139,    5,79217,
    4,79216,79219,79221,    4,79217,    5,79216,79225,79227,73306,79139,
 9377,79231,63823,79231,40705,79139, 9377,79237,63823,79237,21036,79139,
70177,79139,    9,79245,  341,79139,64669,79249,65869,79249,  253,79139,
65869,79255, 8337,79139,    9,79259,  241,79139, 1471,79139,65869,79265,
37325,79139,  903,79269,20103,79139,    9,79273,10219,79139,  903,79277,
    4,79139,20501,79280, 9875,79280,    5,79139,    6,79287,78827,79289,
78725,79289,18967,79286, 9935,79287,20645,79287,36773,79139,    9,79301,
   53,79139,65869,79305,    5,79138,27979,79309, 8685,79309,41503,79309,
26293,79309, 1369,79309,16381,79309,13325,79309,35843,79309,19513,79309,
 8401,79309, 4137,79309,14625,79309, 4569,79309,37019,79309, 4063,79309,
 3863,79309,37377,79309,20219,79309,10273,79309, 9955,79309,20697,79309,
    9,79139,78725,79352,78827,79352,35187,79139, 1505,79359,   17,79139,
71229,79362, 9377,79365,63823,79365,21315,79363,71229,79139,   17,79372,
63823,79375, 9377,79375,18967,79139,20413,79381,    4,79383,    4,79382,
20487,79381,20486,79381,79161,79381,    4,79393,    4,79392,79163,79381,
  580,79381,49630,79381,79162,79381,46863,79381,    4,79406,    4,79407,
  483,79381,    4,79412,    4,79413,49631,79381,  581,79381,    4,79381,
20413,79422,79161,79422,46863,79422,  483,79422,    5,79381,79385,79433,
79179,79433,79283,79433,79395,79433,79411,79433,79417,79433,20413,79433,
    4,79380,79389,79449,79446,79449,79421,79449,79419,79449,79399,79449,
79433,79449,20413,79460,20413,79449,79433,79464,    5,79380,79425,79469,
79387,79469,79391,79469,79427,79469,79397,79469,79401,79469,79403,79469,
79405,79469,79429,79469,79409,79469,79431,79469,79415,79469,79423,79469,
20413,79495, 1369,79139,    5,79499,27979,79139,65869,79503,    9,79503,
20501,79139,    4,79508,79433,79511,    5,79508,18967,79514,21037,79508,
    4,79509,79517,79521,79243,79521,79295,79521,79469,79521,    5,79509,
79519,79531, 9875,79139,    4,79534,    5,79534,    4,79535,    5,79535,
    4,77750,    3,79545,    5,77750,10256,79549,37356,79549, 4745,79549,
 1011,79555,17423,79549, 1011,79559,63550,79549,64489,79549,63493,79549,
   17,79566,70803,79549,56555,79571,74752,79549, 8982,79549,74571,79549,
   17,79578, 8861,79549,   17,79582,37844,79549,27979,79549,  483,79589,
  253,79549,56555,79593, 8337,79549,  483,79597,  241,79549, 1325,79549,
   17,79602,  331,79549,   17,79606, 1328,79549,  334,79549,   53,79549,
56555,79615,20501,79549, 1011,79619,36773,79549,  483,79623, 9875,79549,
 1011,79627, 1359,79549,  393,79549,    2,79549,37325,79634,10219,79634,
    3,79549,  483,79641,35187,79640,10257,79641,37357,79641,   62,79549,
   59,79549,   17,79652,20103,79549,  483,79657, 1471,79549,56555,79661,
    3,79548,27979,79665, 8685,79665,26293,79665,41503,79665, 1369,79665,
16381,79665,13325,79665,19513,79665,35843,79665, 8401,79665, 4137,79665,
14625,79665, 4569,79665,20219,79665, 3863,79665, 4063,79665,20697,79665,
37019,79665, 9955,79665,10273,79665,37377,79665,18967,79549,  165,79709,
 1369,79549,38057,79713,35187,79549,    3,79717,    3,79716,   17,79549,
63493,79722,74571,79722, 8861,79722, 1325,79722,  331,79722,   59,79722,
37325,79549,    2,79736,    3,79736,    2,79737,    3,79737,10219,79549,
    2,79746,    3,79746,    2,79747,    3,79747,    5,77751, 1196,79756,
 1196,79757, 1197,79756,79761,79763,21604,79757,    6,79757,  587,79769,
21605,79771,    1,79757,    3,79774,    3,79775,18967,79775,  483,79781,
    1,79756,25381,79785,63014,79785,79773,79785,60857,79785,  483,79792,
  483,79785,60857,79796,    6,79756,79787,79801,63015,79801,79785,79805,
25380,79801,79785,79809,79789,79801,79783,79801,79799,79801, 1369,79801,
21605,79818,79785,79821,79795,79801,21605,79801, 1369,79826,79785,79829,
 1216,79757,  413,79757, 1197,79757,79759,79837,79546,79757,  903,79757,
20735,79757, 9993,79757, 1275,79756,    9,79849,60857,79756,    9,79853,
56555,79757, 1505,79856,21605,79757,21376,79757,  483,79757,21315,79864,
58112,79757,21315,79757,  483,79870, 1505,79757,56555,79874,    2,79756,
79767,79879,    7,79881,    6,79880,79883,79885,    6,79881,    7,79880,
79889,79891,79777,79879,    7,79895,    6,79894,79897,79899,    6,79895,
    7,79894,79903,79905,28337,79879,    3,79756,79861,79911,    7,79913,
    6,79912,79915,79917,    6,79913,    7,79912,79921,79923,    2,79757,
79779,79927,    7,79929,    6,79928,79931,79933,    6,79929,    7,79928,
79937,79939,    3,79757,    1,79942,79879,79945,    7,79947,    6,79946,
79949,79951,    6,79947,    7,79946,79955,79957,79545,79942,79545,79757,
    2,79963,    3,79963,    2,79962,    3,79962,    9,79757,63493,79973,
74571,79973, 8861,79973, 1325,79973,  331,79973,   59,79973,    3,77751,
79112,79987,    9,79989,78847,79987,    9,79993, 1216,79987,12371,79987,
    5,79999,    4,79998,80001,80003,    4,79999,    5,79998,80007,80009,
  413,79987,  375,79987,60454,79987,60369,80017,  566,79987,35187,79987,
79065,80022,    9,80025,79106,79987, 1011,79987,37407,79987,10287,79987,
65869,79987,  165,80036,38132,79987,    9,79987,38057,80042,67642,79987,
38057,79987,    9,80048,  165,79987,65869,80052,    5,79986,    4,79987,
    5,79987,79065,80060,56555,80060,60369,80065,  483,80060,79065,79987,
35187,80070,    9,80073,    4,80071,    5,80071,    4,80070,    5,80070,
56555,79987,49630,80084,46863,80084,    4,80089,    4,80088,  581,80084,
  580,80084,49631,80084,    4,80084,46863,80100,  483,80100,    5,80084,
60369,80107,80091,80107,    4,80085,80095,80113,80099,80113,    5,80085,
60327,80119,60719,80119,80097,80119,80087,80119,57901,80119,80093,80119,
80103,80119,80105,80119,  483,80084,    4,80136,80119,80139,    4,80137,
80107,80143,  483,79987,    5,80146,    2,77751,79538,80151,79541,80153,
79514,80151,79521,80157,79024,80151,79027,80161,78958,80151,78963,80165,
79021,80151,    5,80168,79027,80171,    5,80169,79023,80175,78943,80151,
    5,80178,78963,80181,    5,80179,78955,80185,    1,80151,    7,80189,
    4,80191,    4,80190,   16,80189,    4,80189,    7,80198,28714,80151,
   17,80203,79286,80151,79541,80207,79521,80207,35187,80150,79289,80213,
29229,80213,79352,80213,    9,80213,79139,80220,79139,80213,    9,80224,
    9,80151,    4,80150,  265,80231,    5,80150,80193,80235,28337,80235,
    4,80151, 1011,80241,    5,80151,80195,80245,80201,80245,79534,80245,
79543,80251,79508,80245,79531,80255,79021,80244,79027,80259,78943,80244,
78963,80263,79021,80245,79029,80267,78943,80245,78971,80271,80197,80245,
28219,80245,30475,80245,23939,80245,79139,80244,79541,80283,79521,80283,
21605,80244,   17,80289,79139,80151,35187,80293,    9,80295,    4,80293,
    5,80293,79537,80301,79511,80301,79177,80301,79179,80301,79285,80301,
79283,80301,    4,80292,80301,80315,    5,80292,79541,80319,79521,80319,
80299,80319,21605,80151,    5,80326,   17,80329,    5,80327,    9,80333,
    4,77751,79750,80337,79753,80339,79740,80337,79743,80343,78922,80337,
78925,80347,78880,80337,78883,80351,78919,80337,    3,80354,78925,80357,
    3,80355,78921,80361,78875,80337,    3,80364,78883,80367,    3,80365,
78877,80371,    6,80337, 1369,80375,56555,80377,    1,80337,60857,80381,
 1275,80383,    1,80336,58931,80387,19916,80387,80379,80387,18967,80387,
 1275,80394, 1275,80387,18967,80398,    6,80336,19917,80403,80387,80405,
80389,80403,80391,80403,58930,80403,80387,80413,80385,80403,80401,80403,
  587,80403,56555,80420,80387,80423,80397,80403,56555,80403,  587,80428,
80387,80431,43214,80337,79640,80337,79753,80437,79743,80437,    2,80336,
  265,80443,    2,80337,  903,80447,    3,80337,67988,80450,67988,80451,
67989,80450,80455,80457,79746,80451,79755,80461,79736,80451,79745,80465,
78919,80450,78925,80469,78875,80450,78883,80473,78919,80451,78927,80477,
78875,80451,78887,80481,67989,80451,80453,80485,79549,80450,79753,80489,
79743,80489,38305,80450,79549,80337,    2,80497,    3,80497,79749,80501,
79739,80501,79551,80501,79553,80501,79639,80501,79637,80501,    2,80496,
80501,80515,    3,80496,79753,80519,79743,80519,80499,80519,38305,80337,
    3,80526,    3,80527,    0,    7, 1517,80532, 2575,80535,  949,80532,
 2599,80539, 1476,80532, 2269,80543,  280,80532, 2289,80547,  272,80532,
 4437,80551,  121,80532,38343,80555, 3075,80555, 1913,80555,   76,80532,
 3005,80563, 1899,80563,38337,80563,  123,80533, 3061,80571,   81,80533,
 2997,80575,  367,80532, 7627,80579,  357,80532, 1927,80583,  397,80532,
 7895,80587, 1516,80532,  948,80532,  107,80532, 2221,80595,  203,80532,
 2215,80599,  215,80532, 4339,80603,   91,80532, 5045,80607, 1477,80532,
  281,80532,  273,80532,  317,80532,14469,80617,   67,80532,11087,80621,
 4643,80621, 2233,80621, 4625,80621,    9,80629,   53,80532, 2289,80633,
 1471,80532, 2269,80637,80012,80533,77949,80641,79834,80533,77949,80645,
79996,80533,78669,80649,79832,80533,78669,80653,78546,80533,77949,80657,
78108,80533,78141,80661,77949,80661,77855,80533,77949,80667,  416,80533,
17993,80671,  418,80533,17993,80675,  447,80533,17993,80679,  295,80532,
  294,80532,   76,80533,38587,80687,26285,80533,26390,80533,26106,80533,
  121,80533,38585,80697,26502,80533,32269,80533,31761,80533,32563,80533,
31921,80533,31591,80533,78287,80533,78141,80713,78099,80713,77949,80713,
23788,80533,27830,80533,27947,80533,41746,80533,26216,80533,41414,80533,
26126,80533,41348,80533,26328,80533,41556,80533,29029,80533,43319,80533,
  203,80533, 2211,80745,60857,80745,   85,80533, 4593,80751, 2229,80751,
60857,80751,80229,80533,39823,80533,23013,80533,39229,80533,39783,80533,
38673,80533,38675,80533,  107,80533, 5019,80773, 2219,80773,60857,80773,
80228,80533,40956,80533,45411,80783,37899,80783,41493,80533, 1517,80533,
 2573,80791,80591,80791,  949,80533, 2593,80797,80593,80797,  280,80533,
 2287,80803,80613,80803, 1476,80533, 2267,80809,80611,80809,  272,80533,
 4457,80815,80615,80815, 8673,80533, 8681,80533, 8800,80533, 8742,80533,
41622,80533, 8740,80533, 8610,80533, 8642,80533, 8638,80533,39650,80533,
42752,80533, 8717,80533,  413,80843, 1369,80842,  341,80842, 3785,80533,
  413,80851, 1369,80850,  341,80850,  413,80532, 8717,80859, 3785,80859,
13443,80859, 7627,80859, 7287,80859, 7895,80859,12755,80859, 1689,80859,
 2701,80859, 1705,80859,77859,80859,78459,80880,78548,80859,78048,80859,
77837,80887,78071,80859,18454,80859,78147,80859,78459,80859,77859,80896,
  265,80859,77751,80900,77837,80903,77751,80901,77859,80907,18391,80859,
  331,80910,  331,80859,18391,80914, 8495,80859,77751,80859,  265,80920,
77837,80923,12745,80859,  375,80927,  457,80927,  375,80859,13977,80533,
80021,80533,13767,80533, 4347,80533, 2213,80533, 2225,80533, 2231,80533,
10079,80533,79501,80533,18715,80533,18579,80533,14313,80533,80149,80533,
13945,80533, 4987,80533,14091,80533, 4619,80533,80069,80533,13913,80533,
 4555,80533,16635,80533,16301,80533, 2575,80533, 2599,80533, 2289,80533,
 2269,80533, 4437,80533, 7549,80533, 7589,80533,13785,80533,80015,80533,
23755,80533, 1369,80996,39633,80533, 1369,81000,78284,80533, 7205,80533,
 2561,80533, 2261,80533, 4423,80533, 2307,80533,79318,80533,10058,80533,
79674,80533,26331,80533, 1369,81022,41559,80533, 1369,81026, 4329,80533,
 1369,81030, 4311,80533, 1369,81034,10354,80533, 3786,80533, 4330,80533,
27805,80533, 1369,81044,42731,80533, 1369,81048,10055,80533, 1369,81052,
10351,80533, 1369,81056, 4312,80533,78645,80533,78324,80533,78458,80533,
  375,81067, 3794,80533,78147,80533,  413,81073, 1369,81072,  341,81072,
  215,80533, 4345,81081,60857,81081,79309,80533, 1369,81086,79665,80533,
 1369,81090, 1477,80533,80543,81095,  281,80533,80547,81099, 1516,80533,
80535,81103,  948,80533,80539,81107,13443,80533,16669,80533,43293,80533,
26104,80533,41314,80533,26277,80533,41479,80533,13027,80533,  264,81124,
  264,81125,  413,81125,  265,81124,81129,81133,  265,81125,81127,81137,
 5127,80533,  264,81140,  264,81141,  413,81141,  265,81140,81145,81149,
  265,81141,81143,81153,15309,80533,  412,81157,  413,81156,81159,81161,
  413,81157,  412,81156,81165,81167,32294,80533,45314,80533,31857,80533,
44925,80533,14053,80533,22897,80533,39143,80533,78107,80533,  413,81184,
78141,81187,77949,81187,  413,81185,77859,81193, 1276,80533,17993,81197,
  438,80533,17993,81201, 1278,80533,18759,81205, 1242,80533,18759,81209,
22806,80533,  903,81213,    9,81213,39084,80533,  483,81219,39204,80533,
41941,81223,22956,80533,26625,81227, 1109,80533,35187,81231,  294,80533,
80683,81235,35187,81235, 1413,80533, 1471,81241,  295,80533,80685,81245,
39749,80533,  483,81249,24095,80533,35187,81253,   11,81252,39787,80533,
  241,81259,  903,81259,  587,81258,24236,80533,39846,80533,78459,80533,
  413,81270,77949,81273,  413,81271,77859,81277,39232,80533,46169,81281,
  510,80533,   11,81285, 1108,80533,   11,81289, 1216,80533,79987,81292,
78669,81295,79757,81292,78669,81299, 1275,81292,18759,81303,   15,81292,
18759,81307, 8808,80533,41376,80533, 7195,80533, 1141,80533,14315,81317,
  959,80533,17125,81321,  253,80533,25793,81324,41019,81324, 8495,81324,
  317,80533,15661,81333,14991,81333,17993,81333, 2899,81333,  273,80533,
80551,81343, 8634,80533, 8677,80533,  331,80533,  413,81351,18391,81353,
  413,81350,17993,81357, 8861,81351,63493,81351,74571,81351,15029,81351,
 8495,80533,  586,81368,  586,81369,  587,81368,81373,81375,   11,81368,
  253,81368, 1471,81368,   53,81368,  587,81369,81371,81387,  305,81369,
  713,81369,   25,81369, 1369,81368,  257,81369,  257,81368,14011,80533,
  257,80533,25793,81404,41019,81404, 8495,81404,  973,80533,20103,81413,
 8337,81413,36773,81413,  341,80533,30091,81421, 8717,81420,20103,81421,
36773,81421, 8337,81421, 3785,81420,78147,81420,   89,80533,10831,81437,
10903,81437, 5019,81437,60857,81437,17125,81437,  567,80533,63493,81449,
74571,81449, 8861,81449,  652,80533,60857,81457,  288,80533, 8861,81461,
  265,80533,78670,81465,77859,81467,  413,81465,77751,81471,77837,81473,
77751,81470,77859,81477,73154,81465,62059,81465,78107,81465,15029,81465,
 4593,81465,11985,81465,78459,81465,80057,81465,79911,81465, 8861,81465,
63493,81465,74571,81465,72152,81465,61718,81465,77751,81465,  413,81508,
77859,81511,  413,81509,77949,81515,   17,81464,35187,81519,   11,81465,
60857,81522,  587,81465,71229,81526,71229,81465,60857,81530,   11,81531,
  587,81530,60857,81465,   10,81539,   10,81538,  305,81539,   11,81539,
81543,81547,71229,81538,   11,81538,81541,81553,  587,81464,60857,81557,
   11,81464, 8861,81561, 1011,80533,50785,81565,    9,81564,   11,81569,
   11,81565,    9,81573,71229,81565,77387,81577,  903,80533,50959,81581,
45149,80533,35187,81585,   11,81584,32103,80533,27021,81591,  241,81591,
  903,81591,  587,81590, 7333,80533,  483,81601, 6789,80533,    9,81605,
  903,81605,14073,80533,  241,81611,  903,81611,  587,81610,11277,80533,
35187,81619,   11,81618,42707,80533, 3445,80533,  375,81627,10313,80533,
79643,80533, 2621,80533,14229,80533,11571,80533, 5045,80533,35187,81641,
   11,81640, 4971,80533,  241,81647,  903,81647,  587,81646, 7009,80533,
 7497,80533, 7287,80533, 7845,80533, 7925,80533, 7895,80533, 7685,80533,
 7671,80533, 7627,80533,14102,80533,11348,80533, 5096,80533, 5000,80533,
 7533,80533, 4617,80533,  483,81683,13907,80533,  483,81687, 7563,80533,
  264,81691,  264,81690,  265,81691,81695,81697,  265,81690,81693,81701,
 7531,80533,  483,81705,79634,80533,80501,81709,79719,81709,79640,80533,
  483,81715,42716,80533,42795,81719,42704,80533,  483,81723,10308,80533,
36131,81727,10310,80533,  483,81731, 5227,80533, 5009,80533, 3461,80533,
 2981,80533, 3049,80533,80061,80533,  483,81745,  240,80532,77859,81749,
78459,81750,78089,81749,78147,81755,78305,81749,78231,81749,78277,81749,
78445,81749,78564,81749,78613,81749,78558,81749,78548,81749,78071,81749,
78387,81749,78459,81776,78425,81749,78459,81780,78434,81749,78147,81785,
13103,81749, 5161,81749,13074,81749, 5150,81749,13057,81749,13051,81796,
 5141,81749, 5137,81800,13051,81749,13057,81804, 5137,81749, 5141,81808,
13092,81749,13045,81813, 5154,81749, 5133,81817,78048,81749,77837,81821,
78459,81749,78387,81824,78425,81824,77859,81824,25793,81749,41019,81749,
 8495,81749,78147,81749,48009,81749,49321,81749,49001,81749,78399,81749,
  265,81847,78459,81849,  265,81846,78147,81853,  265,81749,13027,81856,
13045,81859, 5127,81856, 5133,81863,13027,81857,13057,81867, 5127,81857,
 5141,81871,78399,81856,78147,81875,77751,81856,77837,81879,77751,81857,
78387,81883,78425,81883,77859,81883,77751,81749,  265,81890,77837,81893,
23755,81749,39633,81749, 3785,81749, 8717,81749,79309,81749,79665,81749,
10055,81749,10351,81749,27805,81749,42731,81749,26331,81749, 4329,81749,
41559,81749, 4311,81749, 5127,81749,  265,81925, 5137,81927,  265,81924,
 5133,81931,13027,81749,  265,81935,13051,81937,  265,81934,13045,81941,
 1010,80532,27021,81945,24095,81945,52915,81945, 9195,81945,81565,81945,
    9,81955,81569,81945,23651,81945,67297,81945,81289,81945,21605,81945,
    9,81967,51435,81945, 4321,81945, 9755,81945,11277,81945, 5045,81945,
 4295,81945, 3833,81945,69729,81945,26907,81945,70097,81945,27323,81945,
53941,81945,53215,81945,10171,81945, 9317,81945,  264,80532,51421,82001,
39619,82001,57811,82001,59743,82001,59933,82001, 8093,82001, 3837,82001,
53703,82001, 4303,82001,42435,82001, 4287,82001,53487,82001, 9579,82001,
42113,82001, 9839,82001,  241,82001,  375,82032,  394,82001,  299,82001,
  375,82001,  241,82040,78399,80533,  264,82044,  264,82045,  413,82045,
  265,82044,82049,82053,  265,82045,82047,82057,  240,80533,78397,82061,
78459,82063,78099,82061,78147,82066,78264,82061,78283,82061,78260,82061,
78262,82061,78661,82061,78599,82061,78619,82061,78601,82061,78675,82061,
77837,82061,77949,82088,78673,82061,77950,82061,78118,82061,78459,82097,
78670,82061,77859,82101,77949,82061,78147,82104,77837,82104,78141,82061,
78147,82110,  413,82061,77751,82115,77837,82117,77751,82114,77859,82121,
78147,82061,78099,82124,78141,82124,77949,82124,78107,82061,  265,82132,
78459,82135,  265,82133,78147,82139,77751,82061,  413,82142,77859,82145,
  413,82143,77949,82149,  265,82061,78107,82152,78459,82155,78107,82153,
78141,82159,  902,80533,37663,82163,37599,82163,  265,80532,25793,82169,
41019,82169,39787,82169,23755,82169,39633,82169, 8495,82169,78147,82169,
 8717,82169, 3785,82169,79309,82169,79665,82169,27805,82169,42731,82169,
10055,82169,10351,82169,26331,82169,41559,82169, 4329,82169, 4311,82169,
 4555,82169,14073,82169, 4971,82169,21605,82169,65869,82215,38305,82169,
56555,82219,  483,82219,  241,80532, 4437,82225,    7,82225,  265,82229,
39787,82225,51615,82225, 4613,82225,12571,82225,14073,82225, 4971,82225,
  375,82225,  510,82225,51937,82225,16683,82225, 4805,82225,    9,82225,
  483,82254,  483,82225,    9,82258,38305,82225,  483,82263, 1010,80533,
55211,82267,64345,82267,36256,82267,35187,82267,    9,82274,    9,82267,
35187,82278, 1011,80532,10001,82283,  903,82285,27533,82283,  903,82289,
79139,82283,  903,82293,82267,82283,    9,82296,82278,82283,81231,82283,
21605,82283,  903,82305,    9,82283,82267,82308,  903,80532, 3549,82313,
 2001,82313,21769,82313,10291,82313, 1011,82321,42613,82313, 1011,82325,
79549,82313, 1011,82329,24095,82313,25793,82313, 8495,82313, 5045,82313,
11277,82313,39787,82313,14073,82313, 4971,82313,21605,82313,  955,82349,
    9,82349,65869,82349,38305,82313, 1011,82357,  483,82357,41019,82313,
  264,80533,   53,82365, 1471,82365,  253,82365,72567,82365,76285,82365,
76939,82365,77751,82364,  375,82379,  471,82365,  367,82365,  357,82365,
  341,82365,  241,82389,  241,82365,    9,82393,  483,82393,  413,80533,
78106,82398,78107,82399,82401,82403,78459,82403,78106,82399,78107,82398,
82409,82411,78141,82411,77949,82411,79987,82398,77949,82419,79757,82398,
77949,82423,78459,82398,77949,82427,  331,82398,17993,82431,  261,82398,
17993,82435,77949,82399,78459,82439,17993,82399,  331,82443, 1275,82398,
17993,82447,   15,82398,17993,82451,  375,80533,   53,82455, 1471,82455,
  253,82455, 1369,82455,   11,82455,  261,80533,  413,82467,18391,82469,
  413,82466,17993,82473,15029,82467,  264,82477,  265,82476,82479,82481,
  264,82476,  265,82477,82485,82487,16531,80533,  483,82491,12745,80533,
  264,82495,13129,82495,  413,82495,13119,82501,15503,82495,50535,82495,
50929,82495,51081,82495,82231,82495,13171,82495,13133,82495,  264,82494,
  265,82495,82519,82521,  265,82494,82497,82525,  375,82495,  257,82495,
  264,82531,  265,82530,82533,82535,  264,82530,  265,82531,82539,82541,
  566,80533,   53,82545,  253,82545, 1471,82545,   88,80533, 1369,82553,
 1346,80533,55211,82557,28714,80533,28337,82561,60618,80533,60757,82565,
    3,82565,60755,82569,  154,80533,37663,82573,43214,80533,43053,82577,
  483,82577,43502,80533,80531,82583,46169,82583,   67,80533,11529,82589,
11569,82589, 4610,82589,61780,82589,    9,82589, 4593,82598,60857,82598,
60857,82589,    9,82604, 4593,82589,    9,82608,37845,80533,38305,82612,
45411,82615,37899,82615,79926,80533,79987,82621,    4,82623,    5,82622,
82625,82627,    5,82623,    4,82622,82631,82633,80058,80533,79757,82637,
    2,82639,    3,82638,82641,82643,    3,82639,    2,82638,82647,82649,
80244,80533,   17,82653, 1447,80533,14315,82657,   33,80533,14315,82661,
  759,80533,17125,82665,   47,80533,17125,82669, 1471,80533,41019,82672,
25793,82672, 8495,82672,   53,80533,25793,82680,41019,82680, 8495,82680,
25793,80533,  586,82688,  586,82689,   11,82688, 1369,82688,  587,82688,
82693,82699,  253,82688,   53,82688, 1471,82688,  587,82689,82691,82709,
   25,82689,  713,82689,  305,82689,  257,82688,  257,82689, 1325,80533,
74571,82723,63493,82723, 8861,82723,15029,82723,41019,80533,  586,82732,
  586,82733,  587,82732,82737,82739,   11,82732,  253,82732, 1471,82732,
   53,82732,  713,82733,   25,82733,  305,82733,  587,82733,82735,82757,
  257,82732, 1369,82732,  257,82733,   59,80533,63493,82767,74571,82767,
 8861,82767,15029,82767,79139,80533,80244,82777,80245,82777,80293,82777,
    4,82782,80319,82785,    4,82783,80301,82789,80298,82777,80319,82793,
21036,82777,21037,82777, 1216,82777,  413,82777,80245,82776,82779,82805,
 1011,82777,  903,82808,21037,82776,82797,82813,80244,82776,82781,82817,
21036,82776,82799,82821,65869,82777,    9,82777,  903,82777, 1011,82828,
    4,82777,80293,82833,80315,82835,80293,82832,80319,82839,79549,80533,
80450,82843,80451,82843,80497,82843,    2,82848,80519,82851,    2,82849,
80501,82855,80498,82843,80519,82859, 1216,82843,  413,82843,80451,82842,
82845,82867,  903,82843, 1011,82870,80450,82842,82847,82875,56555,82843,
  483,82843, 1011,82843,  903,82882,    2,82842,80501,82887,79719,82887,
    3,82842,80337,82892,  483,82893,    3,82843,82867,82899, 1369,82899,
    2,82843,82875,82905,82895,82905,80497,82905,80515,82911,80497,82904,
80519,82915,80519,82905,80437,82905,80489,82905,79587,82905,79721,82905,
79645,82905,80337,82842,    3,82930,82905,82933,    3,82931,82887,82937,
27533,80533, 1216,82941,  413,82941,21036,82941,21037,82941, 1011,82941,
  903,82950,21037,82940,82947,82955,21036,82940,82949,82959,    9,82941,
65869,82941,  903,82941, 1011,82966,42613,80533, 1216,82971,  413,82971,
  903,82971, 1011,82976,  483,82971,56555,82971, 1011,82971,  903,82984,
    2,82971,42667,82989,42791,82989,42709,82989,    3,82971, 1369,82997,
    2,82970,42795,83001,    3,82970,  483,83005,10001,80533, 1216,83009,
  413,83009,21036,83009,21037,83009,21036,83008,83017,83019, 1011,83009,
  903,83022,21037,83008,83015,83027,65869,83009,    9,83009,  903,83009,
 1011,83034,10291,80533, 1216,83039,  413,83039,  903,83039, 1011,83044,
56555,83039,  483,83039, 1011,83039,  903,83052,    2,83039,37871,83057,
36133,83057,35803,83057,    3,83039, 1369,83065,    2,83038,36131,83069,
    3,83038,  483,83073, 1369,80533,26331,83076,25793,83076,23755,83076,
27805,83076,40381,83077,41559,83076, 8717,83076,21036,83077,39633,83076,
78147,83076,79309,83076,10055,83076,42731,83076, 3785,83076,79665,83076,
 4329,83076,10351,83076, 4311,83076,38305,83076,41941,83115,41019,83076,
 8495,83076,38305,83077,41019,83123,    5,83077,18967,83126,18967,83077,
   11,83131,    5,83130,   17,80533,25367,83137,62984,83137,60857,83137,
  265,83143,  241,83142,  241,83137,60857,83148,21605,83136,26625,83153,
  265,83136,35187,83157,21605,83137,25793,83161,35187,83137,  265,83165,
  587,80533,62984,83169,62518,83169,68807,83169,36526,83169,17125,83169,
  265,83169,35187,83180,35187,83169,60857,83184,  265,83184,32103,83168,
38305,83168,  483,83193,39787,83168,14073,83168, 4971,83168,  265,83168,
60857,83203,  241,83169,60857,83206,60857,83169,  241,83210,35187,83210,
   11,80533,25793,83216,41019,83216, 8495,83216,  265,83217, 8495,83225,
45149,83216,21605,83216,  903,83231,    9,83231,24095,83216,11277,83216,
 5045,83216,  265,83216, 8861,83243,    3,83217,  375,83247,38305,80533,
76424,83251,54262,83251,54219,83251,76453,83251,42185,83251,42193,83260,
42194,83251,42191,83251,42193,83251,42185,83268,80450,83251,37844,83251,
37845,83251,44663,83277,38707,83277,43483,83277,37897,83277,80451,83251,
80450,83250,83287,83289,  120,83251,   77,83251,32805,83251,54225,83251,
54129,83298,76337,83251,76307,83302,76307,83251,76337,83306,54129,83251,
54225,83310,  113,83251,   25,83314,  506,83251, 1216,83251,  413,83251,
 1413,83251,37845,83250,45411,83327,83275,83327,37899,83327,37897,83250,
83275,83335,65076,83251,37844,83250,    6,83340,83277,83343,83277,83341,
80451,83250,83273,83349,   66,83251,   33,83353,   25,83251,  113,83356,
 1281,83251, 1086,83251,  922,83251,  483,83251,  241,83366,  587,83367,
  903,83366,  241,83251,  483,83374,  903,83251, 1011,83378,  483,83378,
 1369,83250,41941,83385,  587,83250,  483,83389,  587,83251, 1011,83392,
 1011,83251,  903,83396,   11,83397,  587,83396, 1275,83250,46169,83405,
60857,83251,56555,83408,56555,83251,   11,83413,60857,83412,    2,83250,
80531,83419,46169,83419,    3,83250,43053,83425,  483,83425,    2,83251,
80435,83431,80495,83431,43461,83431,80529,83431,46599,83431,43425,83431,
    3,83251,43837,83445,43027,83445,   11,83445,   25,83451,39747,83445,
   11,83444,   33,83457, 1369,83445,   11,83251,    3,83463,  113,83465,
    3,83462,   33,83469,   15,80533, 1216,83473,18617,83475,  413,83473,
18391,83479,25545,83473,62942,83473, 1216,83472,18759,83487,  413,83472,
17993,83491,60857,83473, 1011,83494,18967,83473,   17,83499, 1011,83473,
60857,83502,    3,83472,37663,83507,    3,83473,37611,83511,38155,83511,
35927,83511,21605,80533,27065,83519,27261,83519,21036,83519,21037,83519,
27067,83519,27255,83519,73221,83519,55211,83519,36256,83519,51593,83519,
55803,83519,64345,83519,54477,83519, 1216,83519,  413,83519,21037,83518,
83525,83551,21036,83518,83527,83555,  247,83519,  934,83519,    9,83519,
35187,83562,   11,83563, 1011,83519,  903,83568,   17,83518,26625,83573,
   11,83518,  903,83577,    9,83577,   11,83519,  903,83582,  903,83519,
27021,83587, 1011,83586,   11,83587,   11,83586,35187,83519,    9,83596,
65869,83519,    5,83518,28337,83603,    5,83519,27021,83607,52915,83607,
 9195,83607,20501,83607, 9875,83607,30475,83607,28219,83607,23939,83607,
 1275,80533,43214,83624,43214,83625,43215,83624,83629,83631, 1216,83625,
18617,83635,  413,83625,18391,83639,43215,83625,83627,83643,40675,83625,
73994,83625, 1216,83624,18759,83651,  413,83624,17993,83655,71229,83625,
  903,83658,  903,83625,71229,83662,38305,83624,46169,83667,    5,83624,
55211,83671,    5,83625,53813,83675,10107,83675,69877,83675,  483,80533,
  241,83683,    9,83685,    9,83682,   11,83689,   17,83683,  903,83693,
   11,83683,    9,83697,    5,83682,   53,83701,  253,83701, 1471,83701,
    5,83683, 1505,83709,    9,80533,80151,83712, 1011,83713,82267,83717,
  241,83713,  483,83721,  483,83712,   11,83725, 1011,83712,81945,83729,
   11,83729,    3,83712, 1369,83735,    3,83713,  483,83739,17025,80533,
    5,83742,    2,83745,   17,83746,   17,83745,    2,83750,    2,83751,
  164,83745,38057,83743,38057,83742,38056,83742,83759,83763,38056,83743,
83761,83767,    3,83742,83749,83771,83753,83771,83757,83771,    3,83743,
83755,83779,13737,80533,  375,83783,80151,80533,    9,83786,35187,83787,
    9,83791,    5,83787,    9,83795,    5,83786,   17,83799,79987,80533,
  413,83802,77949,83805,  413,83803,77859,83809, 1216,83802,78669,83813,
 1216,83803,77857,83817,    4,83803,79549,83821,    2,83823,    3,83822,
83825,83827,    3,83823,    2,83822,83831,83833,    4,83802,79757,83837,
    2,83839,    3,83838,83841,83843,    3,83839,    2,83838,83847,83849,
79757,80533,  413,83852,77949,83855,  413,83853,77859,83859, 1216,83852,
78669,83863, 1216,83853,77857,83867,    2,83853,79139,83871,    4,83873,
    5,83872,83875,83877,    5,83873,    4,83872,83881,83883,    2,83852,
79987,83887,    4,83889,    5,83888,83891,83893,    5,83889,    4,83888,
83897,83899,    3,80532,79231,83903,79237,83903,79365,83903,79375,83903,
73413,83903,73405,83903,40793,83903,40787,83903,71751,83903,36001,83903,
71731,83903,72115,83903,72929,83903,71713,83903,    7,83903,    4,83933,
83519,83935,32103,83903,26106,83903,41746,83903,43005,83903, 8800,83903,
64513,83903,63253,83903,62215,83903,59910,83903,41019,83903,   11,83956,
60755,83903,60707,83903, 9852,83903,48975,83903,48245,83903,48451,83903,
76271,83903,82267,83903,    9,83974,82278,83903,83157,83903,81231,83903,
81235,83903,81519,83903,  386,83903,  347,83903,  510,83903,  273,83903,
  281,83903, 1477,83903, 1516,83903,  948,83903,  165,83903,  903,84004,
40704,83903,79139,84009,27533,84009,10001,84009,73307,83903,79139,84017,
27533,84017,10001,84017,53500,83903,37595,83903,36049,83903,36539,83903,
68851,83903,36041,83903,37573,83903,36275,83903, 1505,83903, 1011,84040,
25793,83903,   11,84044,64397,83903,  483,84049, 8495,83903,   11,84052,
60618,83903,  483,84057,  375,83903,  305,84060,  903,83903,  165,84064,
 1011,83903, 1505,84068,  305,83903,  375,84072,    4,83903,56555,84076,
  483,84079,    5,83902,57811,84083,59743,84083,59933,84083, 9579,84083,
 9839,84083,51421,84083,39619,84083, 4303,84083, 4287,84083, 8093,84083,
 3837,84083,42113,84083,53487,84083,53703,84083,42435,84083,48885,83903,
  483,84115,   11,83903,25793,84118,41019,84118, 8495,84118,59875,84118,
 9805,84118,53391,84118,    9,83903,82267,84132,  483,84132,38305,84132,
79139,84139,10001,84139,27533,84139,38305,83903,    9,84146,79139,84149,
27533,84149,10001,84149, 9805,83903,   11,84156,    5,84157,  483,83903,
    9,84162,56555,83903,    4,84166,  483,84169,53391,83903,   11,84172,
    5,84173,59875,83903,   11,84178,    5,84179,    2,80532,11087,84185,
11307,84185,11713,84185,10439,84185, 2221,84185,10665,84185,11037,84185,
 2233,84185,17777,84185, 2215,84185,18739,84185, 4339,84185,79091,84185,
79097,84185, 5075,84185, 4643,84185,79115,84185,79123,84185,59811,84185,
36619,84185,68291,84185,68299,84185,24213,84185,24059,84185,22149,84185,
22143,84185,72667,84185,60839,84185,35665,84185,59819,84185,59869,84185,
35487,84185,    7,84185,    4,84251,27306,84185,24095,84185,53910,84185,
55537,84185,79280,84185,80301,84263,83607,84185,40455,84185,25313,84185,
 8714,84185,32103,84185,26106,84185, 8800,84185,41746,84185,81569,84185,
48009,84185,49001,84185,49321,84185, 4551,84185,81531,84185,81289,84185,
81245,84185,83729,84185,10196,84185,70136,84185,10603,84185,    9,84305,
 4625,84185,    9,84309,81565,84185,    9,84313,23983,84185,    9,84317,
76501,84185,68176,84185,79065,84323,59787,84323, 9513,84323,36545,84185,
79065,84331,59787,84331, 9513,84331,  759,84185,35187,84339,10107,84185,
  265,84342,  241,84343,69877,84185,  265,84348,  241,84349,  305,84185,
 8495,84354,  959,84185,35187,84359,28714,84185,77079,84185, 1011,84365,
 1010,84364,84367,84369, 1010,84365, 1011,84364,84373,84375,   47,84185,
35187,84379,48245,84185,48975,84185,48451,84185,11277,84185, 5045,84185,
52603,84185, 8495,84185,   10,84394,   10,84395,  305,84394,   11,84394,
84399,84403,   11,84395,84397,84407,  331,84185,71229,84411,79549,84185,
 1011,84415,  265,84185,53813,84418,71229,84419,10107,84418,69877,84418,
79757,84419,  903,84185,55211,84431,10291,84185, 1011,84435,25793,84185,
   10,84438,   10,84439,27021,84438,   11,84438,84443,84447,   11,84439,
84441,84451,42613,84185, 1011,84455, 1325,84185,71229,84459,    5,84185,
27255,84463, 9287,84463,53167,84463,21605,84462,    4,84185,79139,84472,
80301,84475,49475,84473,73066,84473,28715,84473, 1011,84473,71229,84484,
71229,84473, 1011,84488,27693,84473,10047,84473,79287,84473,41019,84185,
   10,84498,   10,84499,   11,84498,84503,84505,   11,84499,84501,84509,
   59,84185,71229,84513,    4,84184, 8495,84517,41019,84517,25793,84517,
49001,84517,49321,84517,48009,84517,  265,84517,78147,84517,23755,84517,
39633,84517, 3785,84517, 8717,84517,41559,84517, 4311,84517,79665,84517,
10351,84517,26331,84517,42731,84517, 4329,84517,79309,84517,27805,84517,
10055,84517,    5,84184,27021,84563,24095,84563, 9195,84563,52915,84563,
21605,84563,    9,84573,23651,84563, 9755,84563,51435,84563,67297,84563,
 4321,84563,69729,84563,26907,84563, 9317,84563,53215,84563,27323,84563,
53941,84563, 3833,84563,10171,84563,70097,84563, 4295,84563, 5045,84563,
11277,84563,53813,84185,  265,84610,  241,84611,48885,84185, 1011,84617,
   11,84185,25793,84620, 8495,84620,41019,84620,   17,84185,30091,84629,
65869,84185,   15,84632,79065,84635,59787,84635, 9513,84635,  803,84633,
38305,84185, 1011,84645, 1347,84645,   15,84185,28714,84650,28714,84651,
65869,84650,79065,84657, 9513,84657,59787,84657,28715,84650,84655,84665,
28715,84651,84653,84669, 9195,84185,  241,84673,35187,84673,21605,84185,
27255,84679,    7,84678,    4,84682,    4,84683,84253,84679,   16,84678,
55211,84679,  803,84679,    9,84679,   17,84678,  903,84679,65869,84679,
    4,84679,84699,84705,    5,84679,84685,84709,84691,84709,27021,84709,
    4,84678,    7,84716,84709,84719,    5,84678,84687,84723,52915,84185,
35187,84727,  241,84727,27021,84185,35187,84733,  241,84733,25793,84732,
79139,84185,80245,84740,    4,84740,80301,84745,    5,84740,80151,84748,
    4,84741,80319,84753,84751,84753,80207,84753,80283,84753,    5,84741,
84743,84763,    5,80532,80759,84767,    7,84767,    2,84770,    3,84770,
83251,84775,    2,84771,84776,84779,84775,84779,83251,84782,83251,84779,
84775,84786,    3,84771,84773,84791,83251,84793,27306,84767,24095,84767,
52603,84767,53910,84767,55537,84767,84438,84767,84394,84767,84498,84767,
81539,84767,25793,84767,27021,84814,84185,84814,64289,84767,84060,84767,
81569,84767,83729,84767,81245,84767,81289,84767,70136,84767,10196,84767,
  273,84767, 1477,84767,  281,84767,  948,84767, 1516,84767,81565,84767,
    9,84847, 1505,84767, 1011,84850, 5045,84767,11277,84767, 4551,84767,
  922,84767, 1413,84767,20831,84767,19783,84767,20053,84767,58775,84767,
 9195,84767,  265,84873,   47,84767,60857,84877,  165,84767,  903,84880,
41019,84767,84185,84884,27021,84767,25793,84888,  265,84889, 8495,84767,
84185,84894,  959,84767,60857,84899,   89,84767, 5019,84903,60857,84903,
  375,84767,83903,84908,  759,84767,60857,84913,  265,84767,53813,84916,
69877,84916,10107,84916, 1011,84767, 1505,84924,54597,84925,  903,84767,
  165,84930,  483,84930,54295,84931, 1447,84767,18967,84939, 1141,84767,
18967,84943,    2,84767,61780,84947,    9,84947,60857,84950,54295,84947,
70085,84947,11529,84947,10155,84947,53925,84947,60857,84947,    9,84964,
    3,84767, 8063,84969,42361,84969,53667,84969,84185,84767,41019,84976,
 8495,84976,25793,84976,83903,84767,  375,84984,   33,84767,18967,84989,
    2,84766,27021,84993,24095,84993, 9195,84993,52915,84993,21605,84993,
    9,85003,67297,84993, 9755,84993,51435,84993,23651,84993, 4321,84993,
26907,84993,69729,84993,10171,84993,53941,84993,70097,84993,53215,84993,
 9317,84993, 4295,84993,27323,84993, 3833,84993, 5045,84993,11277,84993,
    3,84766,57811,85041,59743,85041,59933,85041,51421,85041,39619,85041,
 4303,85041, 4287,85041, 9579,85041, 9839,85041, 8093,85041, 3837,85041,
53487,85041,42113,85041,53703,85041,42435,85041,52915,84767,  265,85073,
  587,84767,60857,85077,70573,85077, 1369,84767,43503,85083,  483,84767,
  903,85086,21605,84767,    9,85091,  145,85091,10107,84767,  265,85096,
    9,84767,53813,84767,  265,85102,69877,84767,  265,85106,    4,80532,
83715,85111,80781,85111,83789,85111,    7,85111,    2,85118,83511,85121,
    2,85119,82163,85125,83507,85125,82573,85125, 1368,85111,83511,85133,
25525,85111,84498,85111,84438,85111,84709,85111,79634,85111,80501,85145,
84394,85111,64513,85111,63253,85111,62215,85111,81539,85111,64397,85111,
  483,85159,83787,85111,    9,85163,43214,85111, 8495,85111,84185,85168,
  587,85169,  331,85111,60857,85175,79139,85111,  903,85179,  265,85111,
60857,85183,79987,85183,10001,85111,  903,85189,41019,85111,84185,85192,
  587,85193,27533,85111,  903,85199,   59,85111,60857,85203,    3,85111,
    4,85206,85125,85209,38305,85206,    2,85111,    7,85214,83511,85217,
79549,85214,80501,85221,49155,85215,62464,85215,43215,85215,  903,85215,
60857,85230,60857,85215,  903,85234,42705,85215,10311,85215,79641,85215,
84185,85111,25793,85244,41019,85244, 8495,85244,25793,85111,84185,85252,
  587,85253, 1325,85111,60857,85259,    2,85110, 8495,85263,25793,85263,
41019,85263,49321,85263,49001,85263,48009,85263,  265,85263,78147,85263,
39633,85263,23755,85263, 3785,85263, 8717,85263,26331,85263, 4329,85263,
79309,85263,10055,85263,41559,85263,27805,85263, 4311,85263,79665,85263,
42731,85263,10351,85263,49205,85111,  903,85309,21605,85111,  903,85313,
  155,85313, 1275,85111,43215,85319,77751,85111,38305,85111,    7,85324,
    2,85326,    2,85327, 1368,85324, 1369,85324,    2,85325,85335,85337,
    3,85325,85329,85341,85333,85341,84185,85341,    2,85324,    7,85348,
85341,85351,    3,85324,85331,85355,79549,85111,80451,85358,    2,85358,
80501,85363,    3,85358,80337,85366,    2,85359,80519,85371,85369,85371,
80437,85371,80489,85371,    3,85359,85361,85381,    5,80533,83932,85385,
83933,85385,64148,85385,64149,85385,    0,85385,56555,85395, 1369,85397,
    7,85385,83903,85400,60857,85400,  265,85401,83903,85407, 1275,85401,
60857,85411,    0,85384,63015,85415,25380,85415,85413,85415,21605,85415,
 1369,85422, 1369,85415,21605,85426,    7,85384,85417,85431,25381,85431,
85415,85435,63014,85431,85415,85439,85419,85431,85399,85431,85429,85431,
85425,85431,  483,85431,60857,85450,85415,85453,60857,85431,  483,85456,
85415,85459,54440,85385,83903,85385,    7,85464,27425,85385,53137,85385,
 9365,85385,  803,85385,60857,85474,62310,85385,85206,85385,85125,85481,
  241,85385,  483,85485,54295,85484,54295,85385,  241,85490,  483,85384,
   53,85495,  253,85495, 1471,85495, 1275,85384,55211,85503,21605,85384,
28337,85507, 1369,85385, 1011,85511,60857,85385,    7,85514,  803,85514,
    2,85384,85389,85521,85393,85521,55211,85521,64345,85521,84132,85521,
36256,85521,83903,85521,    9,85534,    9,85521,83903,85538,35187,85538,
35187,85521,    9,85544,    3,85384,85467,85549,85387,85549,85403,85549,
85401,85549,83903,85557,85391,85549,85517,85549,85405,85549,   53,85549,
 1471,85549,  253,85549,76285,85549,76939,85549,72567,85549,  241,85549,
  483,85579,    9,85579,    2,85385,    3,85385,  165,85587, 1108,85587,
 1072,85587,76337,85587, 1011,85587,  483,85596,    9,85596,85111,85586,
85125,85603,    9,85587, 1011,85606,  483,85587, 1011,85610,80151,85384,
   17,85615,85111,85385, 1368,85618,    7,85618,    2,85623,    2,85622,
 1369,85618,    2,85619,85629,85631,    3,85619,85627,85635,85121,85635,
85217,85635,85621,85635,85133,85635,    2,85618,    7,85646,85635,85649,
    3,85618,85625,85653,85125,85653,55211,85385,  265,85659,   17,85385,
    3,80533,73221,85665,    9,85667,78796,85665,    9,85671, 8139,85665,
53639,85665,42521,85665,85322,85665,    9,85681,55004,85665,85111,85665,
77751,85686,    9,85689,42613,85664,  483,85693,10291,85664,  483,85697,
79549,85664,  483,85701,85585,85665,    9,85705,    9,85664, 1369,85709,
   15,85664,37663,85713,85125,85713,38305,85664,43053,85719,  483,85719,
   17,85665,  903,85725,35187,85665,77751,85728,    9,85731,    4,85664,
85125,85735,37663,85735,    5,85664,76939,85741, 1471,85741,   53,85741,
  253,85741,76285,85741,72567,85741,  241,85741,    9,85755,  483,85755,
    5,85665, 1505,85761,  922,85761,  918,85761,54597,85760,  903,85761,
    9,85770,  483,85770,  483,85761,  903,85776,    9,85761,  903,85780,
77751,85760,    9,85785,79756,85665,    9,85789,84185,85665,   16,85792,
    7,85792,    4,85797,    4,85796,   17,85792,    4,85793,85803,85805,
  483,85805,    5,85793,85801,85811,85797,85811,85795,85811,    4,85792,
    7,85818,85811,85821,    5,85792,85799,85825,54597,85665,   11,85829,
    5,85828, 1369,85665,    9,85835,18967,85665,    4,85839,  483,85841,
77751,85665,35187,85844,    9,85847,    9,85845,85111,85851,85111,85844,
    9,85855,    5,85845,   17,85859,    5,85844,    9,85863,77751,85664,
  375,85867,79986,80533,  375,85871,    2,80533,80080,85875,80079,85877,
80298,85875,80319,85881,80293,85875,    4,85884,80319,85887,    4,85885,
80301,85891,11727,85875,11047,85875,17787,85875,18737,85875,78670,85875,
77859,85903,10874,85875,77952,85875,77857,85909,    7,85874,83903,85913,
85167,85875,85355,85875,85213,85875, 1216,85875,77751,85923,77877,85925,
77751,85922,77857,85929,62310,85875,64483,85875,68896,85875,62464,85875,
61780,85875,61688,85875,85159,85875,10831,85875,    9,85946,  413,85875,
77751,85951,77837,85953,77751,85950,77859,85957,74571,85875,17178,85875,
50959,85875,43400,85875,11177,85875,84077,85875,85913,85971,40675,85875,
55546,85875,54440,85875,69196,85875,17125,85875,    9,85982,15029,85875,
65869,85986,52169,85875,49155,85875,40453,85875,43305,85875,40005,85875,
84767,85875,77751,86001,    9,86003,73994,85875,42613,85874,42795,86009,
10291,85874,36131,86013,70135,85875,53919,85875,10195,85875,79842,85875,
79757,85875,  903,86024,63493,85875, 8861,85875,80058,85875,80079,86033,
54422,85875,11529,85875,54447,85875,52601,85875,  145,85875,35187,86044,
36096,85875,79601,85875,79549,85874,80501,86053,79719,86053,64396,85875,
85111,86059, 1011,85875,43215,86062,  241,85875,54295,86066,65869,85875,
60857,86070,15029,86070,    9,85875,10831,86076,60857,86076,17125,86076,
84076,85875,  483,86085,  803,85875,60857,86088,  903,85875,53813,86093,
60857,86092,10107,86093,69877,86093,79757,86092,71229,86092,  265,85875,
55211,86106,10371,85875,42787,85875,55211,85875,60857,86114,  265,86114,
38305,85874,46169,86121,80531,86121,72818,85875,   11,85875,43215,86128,
43316,85875,35187,85875,54295,86134,  145,86134,71229,85875,  903,86140,
  155,86140,43215,85875,   10,86147,   10,86146,85111,86147, 1011,86146,
84767,86147,   11,86147,86151,86159,   11,86146,86149,86163,  155,85875,
71229,86166,    5,85874,55211,86171,64345,86171,84132,86171,36256,86171,
83903,86171,    9,86180,    9,86171,83903,86184,35187,86184,35187,86171,
    9,86190,    4,85875,80070,86195,80077,86197,80293,86195,80315,86201,
80293,86194,80319,86205,  483,86195,83903,86209,80533,86194,    3,86213,
    7,86195,86215,86217,    2,86217,86213,86221,79987,86194,80079,86225,
83903,86194,  483,86229,77751,86195,79545,86233,    3,86235,    2,86234,
86237,86239,    2,86235,    3,86234,86243,86245,77751,86194,79549,86249,
    3,86251,    2,86250,86253,86255,    2,86251,    3,86250,86259,86261,
    5,85875,85914,86265,85913,86265,83903,86268,49713,86265,49712,86264,
86273,86275,49712,86265,49713,86264,86279,86281,53813,86265,64317,86265,
64815,86265,62077,86265,10107,86265,69877,86265,   17,86265,83903,86297,
35187,86297,60857,86264,85111,86303,65869,86265,    9,86307,  587,86265,
60857,86311,83903,86265,85913,86314,79757,85874,79987,86319,    4,86321,
    5,86320,86323,86325,    5,86321,    4,86320,86329,86331,80336,85875,
79549,86335,    3,86337,    2,86336,86339,86341,    2,86337,    3,86336,
86345,86347,83903,85875,   16,86351,    7,86351,86265,86355,    4,86354,
    4,86355,   17,86351,    4,86351,    7,86364,    5,86351,86361,86369,
    4,86350,86363,86373,  483,86373,    5,86350,86359,86379,86367,86379,
86355,86379,86353,86379,54295,85875,  241,86388,35187,86388,60857,85875,
    7,86395,    4,86396,    4,86397,86265,86397,   16,86395,   17,86395,
  803,86394,55211,86394,  903,86394,65869,86394,    9,86394,    4,86394,
86407,86419,    5,86394,86399,86423,86405,86423,85111,86423,    4,86395,
    7,86430,86423,86433,    5,86395,86401,86437,77751,85875,  413,86440,
77859,86443,  413,86441,77949,86447, 1216,86440,77857,86451, 1216,86441,
78669,86455,    4,86441,79757,86459,    3,86461,    2,86460,86463,86465,
    2,86461,    3,86460,86469,86471,    4,86440,79549,86475,    3,86477,
    2,86476,86479,86481,    2,86477,    3,86476,86485,86487,79987,85875,
80244,86491,80245,86491,80151,86491,    5,86496,    5,86497,    4,86491,
80083,86503,80029,86503,80063,86503,86501,86503,    5,86491,80151,86512,
    4,86490,80079,86517,86513,86517,86493,86517,86515,86517,86499,86517,
    5,86490,86495,86529,86503,86529,77751,85874,86529,86535,86503,86536,
86532,86535,86521,86535,86512,86535,86517,86545,86503,86535,86529,86548,
86491,86535,    5,86552,86517,86555,    5,86553,86503,86559,85663,86535,
85100,86535,    9,86535,84767,86566,84767,86535,    9,86570,    5,86535,
86491,86574,86517,86577,86491,86575,86529,86581,80150,80533,80315,86585,
80301,86586,80298,86585,80319,86591,80301,86585,80315,86594,80316,86585,
80325,86585,80293,86585,    4,86602,80319,86605,    4,86603,80301,86609,
85663,86585,85100,86585,    9,86585,84767,86616,84767,86585,    9,86620,
    4,86585,80293,86625,80315,86627,80293,86624,80319,86631,    4,80533,
79968,86635,79967,86637,80498,86635,80519,86641,80497,86635,    2,86644,
80519,86647,    2,86645,80501,86651,78670,86635,77859,86655,77952,86635,
77857,86659,    0,86635,21605,86663,  587,86665,    7,86635,  483,86669,
18967,86671,    0,86634,19917,86675,58930,86675,86673,86675,56555,86675,
  587,86682,  587,86675,56555,86686,    7,86634,58931,86691,86675,86693,
86677,86691,86679,86691,19916,86691,86675,86701,86265,86691,86667,86691,
86689,86691,86685,86691, 1275,86691,18967,86712,86675,86715,18967,86691,
 1275,86718,86675,86721,29023,86635,25513,86635,24619,86635,84363,86635,
84723,86635,84471,86635, 1216,86635,77751,86737,77877,86739,77751,86736,
77857,86743,63610,86635,63291,86635,84321,86635,86028,86635,86030,86635,
85960,86635,86437,86635,76631,86635,76601,86635,74682,86635, 8974,86635,
  413,86635,77751,86769,77837,86771,77751,86768,77859,86775,63493,86635,
  483,86778,85875,86778,29598,86635,25545,86635,59206,86635,15029,86635,
56555,86790,62942,86635,80030,86635,79987,86635, 1011,86798,74571,86635,
85875,86802,  483,86802, 8861,86635,85875,86808,  483,86808,79926,86635,
79967,86815,85875,86635, 8861,86818,63493,86818,74571,86818,79263,86635,
76816,86635,77387,86829,76500,86635,84185,86833,   11,86833,  903,86635,
28715,86838,56555,86635,15029,86842,  483,86635,63493,86846,74571,86846,
 8861,86846, 1011,86635,79987,86854,60857,86854,10073,86635,27855,86635,
62278,86635,  587,86635,28715,86866,29026,86635,60857,86635, 1011,86872,
 1347,86872,28715,86635,   11,86879,84185,86879,  903,86878,  587,86878,
 1347,86635,60857,86888,    2,86634,    4,86893,    7,86895,    3,86634,
85125,86899,37663,86899,    2,86635,79962,86905,79965,86907,80497,86905,
80515,86911,80497,86904,80519,86915,79757,86904,79967,86919,71229,86904,
77387,86923,77751,86905,79065,86927,    5,86929,    4,86928,86931,86933,
    4,86929,    5,86928,86937,86939,77751,86904,79139,86943,    5,86945,
    4,86944,86947,86949,    4,86945,    5,86944,86953,86955,    3,86635,
85217,86959,85121,86959,86897,86959,86217,86959,85133,86959,    6,86959,
    6,86958,    7,86958,86971,86975,    7,86959,86973,86979,60755,86959,
35927,86959,38155,86959,37611,86959,71229,86958,84185,86991,   11,86991,
79987,86634,79757,86997,    2,86999,    3,86998,87001,87003,    3,86999,
    2,86998,87007,87009,80150,86635,79139,87013,    5,87015,    4,87014,
87017,87019,    4,87015,    5,87014,87023,87025,84767,86635, 1368,87029,
    7,87029,    2,87032,    2,87033, 1369,87029,    2,87029,    7,87040,
    3,87029,87037,87045,    2,87028,87039,87049,    3,87028,87035,87053,
87043,87053,87031,87053,71229,86635,    7,87061,    2,87062,    2,87063,
 1368,87061, 1369,87061,    2,87060,77387,87073,87071,87073,    3,87060,
87065,87079,87069,87079,84185,87079,   11,87079,    2,87061,77373,87089,
76635,87089,    7,87088,87079,87095,72519,87089,    3,87061,87067,87101,
85875,87101,77751,86635,  413,87106,77859,87109,  413,87107,77949,87113,
 1216,87106,77857,87117, 1216,87107,78669,87121,    2,87107,79987,87125,
    5,87127,    4,87126,87129,87131,    4,87127,    5,87126,87135,87137,
    2,87106,79139,87141,    5,87143,    4,87142,87145,87147,    4,87143,
    5,87142,87151,87153,79757,86635,80450,87157,80451,87157,80337,87157,
    3,87162,    3,87163,    2,87157,79971,87169,79841,87169,79961,87169,
87167,87169,    3,87157,80337,87178,    2,87156,79967,87183,87179,87183,
87159,87183,87181,87183,87165,87183,    3,87156,87161,87195,87169,87195,
77751,86634,87195,87201,87169,87202,87198,87201,87187,87201,87178,87201,
87183,87211,87169,87201,87195,87214,87157,87201,    3,87218,87183,87221,
    3,87219,87169,87225,    3,87201,87157,87228,87183,87231,87157,87229,
87195,87235,80336,80533,80515,87239,80501,87240,80498,87239,80519,87245,
80501,87239,80515,87248,80516,87239,80525,87239,80497,87239,    2,87256,
80519,87259,    2,87257,80501,87263,    2,87239,80497,87267,80515,87269,
80497,87266,80519,87273,77751,80533,79962,87277,    2,87279,79971,87281,
    2,87278,79967,87285,80070,87277,    4,87289,80083,87291,    4,87288,
80079,87295,79968,87277,79967,87299,80080,87277,80079,87303,80498,87277,
80519,87307,80298,87277,80319,87311,80497,87277,    2,87314,80519,87317,
    2,87315,80501,87321,80293,87277,    4,87324,80319,87327,    4,87325,
80301,87331,81857,87277,78453,87277,80233,87277,80445,87277, 8453,87277,
  273,87277,84484,87277,85230,87277,84531,87277,85277,87277,21522,87277,
 1516,87277,38266,87277,  948,87277,20239,87277, 1477,87277,37095,87277,
  281,87277,84473,87277, 1011,87370,85215,87277,  903,87374,80242,87277,
80448,87277,80447,87277,  903,87382,80241,87277, 1011,87386,38057,87277,
  903,87390,  165,87277,  903,87394,21315,87277, 1011,87398, 1505,87277,
 1011,87402, 1216,87276,  412,87276,  413,87277,87409,87411, 1217,87277,
87407,87415,  413,87276, 1216,87277, 1217,87276,87421,87423,  412,87277,
87419,87427,12377,87277,  375,87277,57522,87277,67028,87277,67800,87277,
  510,87277,  240,87277,  265,87443,77750,87445,77751,87444,87447,87449,
77751,87445,77750,87444,87453,87455,  264,87277,84517,87459,85263,87459,
81749,87459,  341,87459,  264,87276,  375,87469,  241,87277,81464,87472,
81465,87473,87475,87477,81464,87473,81465,87472,87481,87483, 1011,87277,
84473,87486,80241,87486, 1505,87486,21315,87486,  903,87277,85215,87496,
80447,87496,  165,87496,38057,87496,  483,87277,65869,87506,    9,87506,
    9,87277,56555,87512,  483,87512,56555,87277,    9,87518,65869,87518,
65869,87277,  483,87524,56555,87524,    5,87277,84185,87531, 1011,87533,
    2,87531,80532,87536,    3,87531,85215,87541,    3,87530,87539,87545,
85263,87545,84517,87545,81749,87545,    2,87530,87533,87555,    4,87276,
87531,87559,    2,87561,    3,87561,    2,87560,87565,87567,    3,87560,
87563,87571,    3,87277,85111,87575,  903,87577,87559,87575,    0,87581,
    1,87580,87583,87585,    1,87581,    0,87580,87589,87591,    4,87575,
80532,87594,    5,87575,84473,87599,    5,87574,87597,87603,84517,87603,
85263,87603,81749,87603,    4,87574,87577,87613,    2,87276,85663,87617,
85100,87617,    9,87617,84767,87622,84767,87617,    9,87626,87575,87617,
    4,87631,    5,87631,    4,87630,87635,87637,    5,87630,87633,87641,
    2,87277,79962,87645,79965,87647,80497,87645,80515,87651,80497,87644,
80519,87655,79962,87644,79967,87659,87559,87645,    7,87663,    6,87662,
87665,87667,    6,87663,    7,87662,87671,87673,    4,87645, 1011,87677,
77751,87679,77750,87678,87681,87683,77750,87679,77751,87678,87687,87689,
    4,87644,  265,87693,77750,87695,77751,87694,87697,87699,77751,87695,
77750,87694,87703,87705,    3,87276,  375,87709,87645,87709,    4,87713,
    5,87713,    4,87712,87717,87719,    5,87712,87715,87723,    4,87277,
80070,87727,80077,87729,80293,87727,80315,87733,80293,87726,80319,87737,
80070,87726,80079,87741,    2,87727,  903,87745,77751,87747,77750,87746,
87749,87751,77750,87747,77751,87746,87755,87757,    2,87726,  265,87761,
77750,87763,77751,87762,87765,87767,77751,87763,77750,87762,87771,87773,
    5,87276,87575,87777,    7,87779,    6,87778,87781,87783,    6,87779,
    7,87778,87787,87789,87645,87777,    0,87793,    1,87792,87795,87797,
    1,87793,    0,87792,87801,87803,87727,87777,    2,87807,    3,87807,
    2,87806,87811,87813,    3,87806,87809,87817
};

const int s_nDataSize2 = 24772;
unsigned int s_Data2[24772] = {
    3,    9,    5,    6,  119,  796,  636,  113,  449,  235,  239,  105,
  789,   96,  439,  624,  630,  230,  111,  110,  787,  786,  628,  627,
  116,  115,  436,  435,  227,  226,   93,   92,  792,  791,  100,   99,
  443,  442,  633,  632,  128,  183,  234,  178,  233,   85,  762,  203,
   32,  742,  356,  169,  152,   12,  672,  741,  127,  168,  671,  740,
   50,  352,  149,   64,  414,  197,  276,  751,  722,  396,  275,  434,
  721,  785,  274,  795,  720,  448,  273,  719,  474,  758,  718,  392,
  269,  748,  715,  400,  118,  794,  635,   81,   76,  750,  747,  597,
  595,   91,  433,  225,   74,  745,  680,  565,  268,  476,  271,  761,
  350,  678,  345,  567,  757,  471,  470,  563,  469,  561,  551,  461,
  465,  706,  650,  714,  261,  332,  641,  708,  676,  542,  260,  458,
  755,  314,  325,  658,  288,  349,  760,  654,  656,  564,  562,  644,
  552,  642,  550,  259,  252,  254,  322,  311,  329,  109,  784,  626,
   43,  395,  182,   55,  399,  186,  104,  447,  238,   41,  389,  173,
  175,  193,  485,  580,  579,  734,   25,  733,  528,  548,  310,  546,
  344,  526,  308,  560,  342,  525,  556,  558,  523,  524,  522,  520,
  307,  622,  623,  431,  618,  620,  429,  617,  305,  615,  519,  518,
  516,  778,  304,  250,  302,  776,  216,  218,  774,  215,  301,  300,
  514,  771,  513,  541,  298,  512,  297,  535,  321,  508,  510,  319,
  538,  539,  533,  507,  509,  296,  146,  705,  531,  537,  317,  557,
  341,  143,  697,  555,  544,  339,  613,  426,  217,  773,  619,  428,
  221,  780,  611,  610,  424,  609,  769,  423,  422,  768,  213,  625,
  783,  670,  732,  782,  578,  577,  731,  484,  387,  668,  669,  171,
  172,  375,  191,  575,  729,  482,  446,  667,  237,  574,  728,  481,
  398,  666,  185,  573,  727,  480,  394,  665,  181,  572,  695,  694,
  140,  738,  372,  246,  690,  689,  136,  244,  369,  767,  212,  766,
  702,  701,  367,  257,  700,  315,  726,  382,   59,  407,  190,   52,
  366,  157,   65,  417,  201,   63,  413,  194,  686,  692,  243,  248,
  699,  256,  150,  354,  365,  364,  353,  156,  685,  348,  242,  661,
  192,  409,  376,  378,  411,  164,  569,  717,  473,  391,  660,  177,
  189,  406,  374,  371,  405,  162,  200,  416,  363,  362,  415,  155,
  313,  324,  361,  360,  331,  312,  328,  381,  316,  330,  359,  323,
 4596,24359,41366,41344, 4857,37718, 4594,24357, 4846,37706, 4678,26650,
 4592,24355, 4844,37704, 4591,24354, 4843,37703, 8816,41900,22056,15422,
 7473, 8464,42932, 8814,41898, 6804,20483,12853, 8462,42930, 8809,42808,
21978,15306, 7385, 8456,42895, 8807,41327,21965,15246,15293, 7372, 8454,
42893, 3212,20457,36983, 3516, 6187, 6184,20453,29352,10563,10421, 2593,
20452, 6183, 5637, 2589, 6182, 2645, 2619, 2283,26212,20199, 2269,12513,
 2614, 2661,18113, 2288, 4777,35226, 4775, 4774, 4773,42536, 2198,32674,
32753, 8833, 8780,40027,43084,39938,43445, 8548, 8831,24157,26148,31156,
29057, 8503, 8771, 8777,24156,26147,36425,33823,40025,43073,43081,39936,
43443,22500,18803, 8829, 8770,40023,43072,39934,43438, 8546, 8827,24155,
26146,31154,29044, 8501, 8765,24153,26140,36424,33800,33820,40022,43066,
39933,43435,22498,18801,43065,40020,43434,39931,18800,22493, 8764, 8499,
26128,24151,33799,36411, 8826, 8544,26120,24146,29025,31141, 8762, 8824,
43063,40019,43432,39929, 2287, 2286,21235,26865,13688,26627,13207,20826,
 2106, 2073, 4667, 4378, 1966, 4054,13206,20825, 2159, 2168,18699,39853,
10355,39675, 2167,39852,13205,18520, 2158,39674,20824,20823,42653,42280,
18519,10116,21390,13926, 2032,42279, 1932,42652, 2166, 2157,42651, 5184,
42278, 5035, 2070,21389,20822, 4377,13925,13204, 5034, 5183,13924,21388,
 5033, 5182,39673,42650,39851,42277, 4221, 5142,18518,21387,18698,20821,
 4220, 4982,10115,13923,10354,13203,39850,42276,39672,42649,20820,18697,
42648,39671,42275,39849,18517,21386, 4376, 5032,13202,10353,13922,10114,
 4375, 5181,20819,18696,21385,18516, 4981, 5141,42274,39848,42647,39670,
 5031, 5180,42646, 5140,42273, 4980, 4219,21384,20818, 4374,13921,13201,
 5135, 5174,39653,42257,39831,42630, 5172, 5133,24141,26112,31138,29023,
 5026, 4969, 4975,24140,26111,36408,33796,39651,42249,42254,39829,42628,
21363,18686, 5139, 5179,39669,42272,39847,42645, 5178, 5138,18515,20817,
18695,21383, 5030, 4979,10113,13200,10352,13920,39668,42271,39846,42644,
21382,18694, 5170,24183, 5169,36516, 5168,39992, 5167,22753, 5166,21404,
 5165,39867, 5164,21361, 4045,26846, 4044,21215, 5162,39827, 5191,21359,
 5190,39825, 5189, 5160, 5159, 4043, 5157, 5024, 1891,42248, 1847,42621,
 4193, 4341,18472,20750, 1681,21357,10093,13145,13869, 2660, 7371, 2659,
 2658,13144,20749, 1846, 1890,39824,18682,39649,10344, 1872,39823,18507,
13143, 1889,39648,20748,20747,42620,42247,10107,18506,21356,13868, 1871,
42246, 1843,42619, 2205,26240,26211, 2200,24249,24232, 2478, 2517,36625,
34562,31491,29570, 2507, 2558,34076,37229,29433,31635, 8704, 8600,35491,
38460,30352,32396,28999, 8171, 8335,38314,35364,32268,30297,30134, 8698,
 8591,35488,38453,30345,32384,32389, 8166, 8333,38305,35357,32255,30292,
 2285, 7325, 1898,14098, 1896, 1895, 1894,39359,24288,41706,41800,20017,
37217,39357,36575,18022,26236,20013,24246,39355,39925,18013,18779,20001,
22482,39395,20196,39397,20208,40017,39923,20064,42324,12370,42658,19065,
18776,41387,41382, 9904,21392,10687,10412,41365,41360,18055,18053,39685,
20893,39857,18775,43056,43431,42334,18524,42660,22479,40016,39922,14502,
15946,39376,39374,20062,20060,21649,22478,39380,39378,12368,18702,43055,
43430,18057,39680, 9906,39855,39991,21351,22752,39816,39990,39815,22751,
21350,39639,39814,33754,42230,28989,42602,18468,18677,24118,26056,31087,
28988,10090,10312,10318,24117,26055,36340,33753,39637,20700,20705,39812,
18675,42228,42600,42219,42225,18464,42598,21348,39635,39810,13101,13106,
13844,26054,24116,33752,36339,20699,21346,26053,24115,28987,31086,42218,
42595,36338,39633,31085,39808,39667,39845,39666,39844,39665,39843,18693,
18692,10351,10350,18514,39842,13199,13198,10112,39664,20816,20815,10111,
18513,42270,42643,13919,21381,13918,42269,21380,42642,39806,21403,21344,
39866,39805,39865,21343,21402,39804,21342,21175,26830,39802,21173,26826,
21340,39346,24061,39338,32626,39333, 9843,39332,39331, 9814,39328,15936,
39183,11746,19744,25614,39182,39181,39180,19836,42268,11903,42641,17932,
17931,40961,40960, 9771,21379, 9770, 9769,40959,40958,17930,17929,39663,
20814,39841,17928,40957,40956,42267,18512,42640,19835,39179,39178,11902,
11901,39177,39176,19834,19833,19832,19831,39175,39174,11900,18691,40955,
40954,17927,39662, 9768,39840,39173,19830,11899,17926,40953,13197, 9767,
40952,20813, 9766,17925,40951,11898,19829,39172,11897,42266,19828,19827,
42639,11896,40950,21378,13917,39171,39170,39169,39168,14088, 3310, 3309,
35263, 2276,26305, 5245, 6267, 5248, 5445,10636,10624, 5401, 7751, 5390,
 5674, 2548, 5410, 3350, 3931, 3971, 3960, 6123,28071,22800, 8025,27598,
16338, 7478,22061,15427, 3847, 3840, 3822, 5835,26825,21172, 7148,26571,
13617, 6808,20693,13100, 3469, 3729, 3618, 6021,27993,22666, 7965,27534,
16152,16158, 7368,21963,15285,15291, 3513, 3757, 3655, 6026,28010,22688,
 7970,27539,16193, 7376,21969,15297, 3722, 3611,27986,22657,22659,16147,
 3608, 3610,25575,25569,25573,25568, 2720, 2722,23945,23941,23943,23940,
 3606,26233,26200, 2718,24244,24224, 3603,22654,16143, 2716,22466,15931,
 8720, 2547, 2499, 2498,35234, 8719,35524, 7050,35233, 6181,20028, 5622,
20027, 5610, 7023,23939,24648,23938,24484, 5952, 7920,22462,25567,27390,
15928,25566,27757, 5620, 7027,36388,33781,31116,29009, 5970, 7936,33795,
36407,29022,31137, 5612, 7025,24121,24653,24129,24494, 5960, 7922,26081,
27412,26074,27796, 5601, 7014, 6501, 5946,27753,22458, 7917,27387,15926,
 4317, 7284,21850,15156, 5825, 5940, 5824, 5794, 7123, 6732, 6038,28015,
22709, 7982,27551,16225, 7395,21983,15311, 8718, 5673, 7049, 8717,35523,
23937,21560,14272,15352,40871,22739,16272,23936,22733,16263,14776,40870,
21558,14265,23935,21474,14087,15148,40869,22445,15906,23934,41714,40868,
34075,23933,34079,40867,41730,23932,41537,31827,37396,23931,41448, 4494,
23930,41503,23929,26451,38349,32305,23928,24323,23927,40866,31785,37351,
23925,40858, 4472,23924,40862,23923,40853,38197,23920,23919,38475,23914,
23913,38152,23908,40840,28843,38481,23905,23904,23903,23902,23901,23900,
23899,23898,23897,23896,40839,40838,23895,23894,40837,40836,23893,40835,
23892,23891,40834,40833,23890,40832,23889,23888,40831,40830,23887,40829,
23886,23885,40828,40827,23884,23882,40823,40826,40822,23879,23878,40819,
40818,23877,23876,23922,23875,23874,32490,32499,23873,23872,32793,23871,
17197,23870,23869,29043,33819,24320,40817,29655,38507,24317,24309,28839,
33590,23867,23868,23865,40816,25558,25555,23866,40815,23860,23864,21472,
14085,40814,22439,15900,25548,23863,40812,23859,23856,40811,40805,40808,
23858,33581,33583,23854,23881,33580,33592,23853,23852,19635,33579,40804,
23848,23844,33560,33558,35258,40795,23843,33557,33556,35255,25392,23842,
33555,33554,23841,24131,24133,23789,17857,23787,18134,25390,26230,23785,
25387,26229,26199,23783,23782,23781,23780,23779,23778,24120,24128,23777,
17845,23775,27731,25366,18759,23762,23761,23760,23759,23758,23757,23851,
23847,40801,40803,23850,33457,33578,35260,23849,33572,23756,33456,23755,
25328,18750,10402,24219,24218,24217,24239,41600,41620,24216,24215,24238,
29171,33958,24221,24241,24214,24237,24213,24236,24223,24243,24231,24248,
24235,24212,41619,41599,24580,24740,24486,24650,24479,24643,24493,24652,
24536,24696,24535,24695,24534,24694,24533,24693,24640,40701,30096,38438,
24638,24477,35149,24692,24532,24054,24053,24052,24051,24050,23803,17878,
23801,25476,23799,23798,23797,33549, 3281, 2981,35267, 2427, 2429, 2425,
 2424, 2495, 7047, 7649, 2423,21521,14156, 2422,35247,23754,40705,23741,
40684,40700,23725, 4338,40674,23724,40673, 7842, 7748, 7750, 7746, 7745,
 7744, 7761, 7758, 7769, 7651, 7653, 7648, 7647, 7646, 7645,21520,14155,
 6300,21670,14601, 7644,35246, 8354,35392, 7811, 7809, 7813,37284,31745,
 7771,36483,31210, 7788, 7802,36473,31194, 4186, 4465, 4184,13064, 4181,
 4180, 4236, 4246,23721,39799,39630,23720,18459,23719,10083,18671,39628,
33435,13819,10309,39797,28701,21329,36039,30815,42588,42206,25299,25298,
13062,42586,20667,20672,42197,42203,23718,21332,13824,33434,42590,28700,
42208,30814,36038,25297,20676,13069,39022,22404,15866,17830,43413,13837,
 9689,43025,21338, 9687,17828,40683,11384,19518,39000,11387,42593,21639,
19521,42214,14460,40699,20689,13087,24049,24531,24691, 4190,23717,22449,
15912,25296,20692,13099,23753,22427,15895,25337,20666,13060,23716,22403,
15865,25288,20665,13059,13584, 4199, 4197,23711,19508,11363,25282,20745,
13140, 9063, 9396, 9184, 9168, 9338,38785,32799, 9254,23359,17393, 9336,
38782,32791, 9247,23353,17357, 9344,38793,32809, 9282,23387,17431, 9456,
38858,32878, 9094,23244,17141,23710,21540,14212,15278,40657,22649,16130,
 2758,21538,14208, 3347, 5771, 1853, 5082, 1788, 4966,42481,42234, 1708,
26963,42233,26591,42480, 1852, 3346, 3345,42479,37847, 1851,37846, 1835,
13635,42478,42232,37845,26590, 1785,10346, 1834,35043, 1833,37844,13634,
 6891,27206, 6890,42477, 6889,37843, 5951, 5949,22464,27759, 5930, 5929,
22774,28067, 5928, 5927,20495,26455, 5926, 5925,26249,26192, 5924,26307,
 5934, 5932,27724,22402, 5923, 6119, 5922, 7262,27717, 5920, 6917, 6277,
 5918, 5917, 5916, 5915, 5914, 5954, 6118, 6927,27234, 6888,42759,27205,
29027,43024,42739, 8746,29048, 8768,43069, 6886, 6887,27204,42738,28699,
43023, 8745, 8742,43021, 8741,43020, 8740,43019, 8784,43196, 8739,43018,
 8767,43068, 8523, 8744, 4957,42196, 5672,42195, 4956,42194,24230,42193,
33939,33938,24127,42192,33769,35199,24492,42191,35198,33768,24688,20662,
24528,20661,24048,41181, 4990, 4842,42304,37700, 5671, 5670,42303,37699,
 2546, 2545,37881,42519, 5669, 5668,37880,42518, 2544, 5667, 5666, 4137,
 5106, 5104, 5072, 5070, 5074, 5076, 5068, 5067, 5066, 5065, 5064, 5063,
 5100, 5096, 5095, 5094, 5084, 5062, 4634, 5061,42190,28698,42457,26562,
 4635, 5091,42302,26982,42517,26626, 4666, 5090,37879, 4989,13687,42301,
42516,37878,26981, 4665,10365, 4136,35060, 5089,42515, 4988,26625,42300,
42514,26624,26980, 4664,42299, 4135,26979, 5088, 4134, 4987, 4663,42298,
42513, 2163,37877,13686, 2162,42512, 2150,26623,37876,10364,35059,13685,
 2161,42297, 2142,37875, 2140,42511, 2149,42296, 5087, 4986, 1917,26978,
42295,26622,42510, 2148, 4848, 4862, 4827, 4826, 4841,37698, 4882,13463,
42509,42294,37697,26621, 4840,10189, 4881,34876, 4839,37696, 4880,13462,
37874,13684, 5086,37695, 4985,13461,42293,42508,37694,26977, 4838,10188,
 4879,34875,23729,34834,40698,40656,23709,34880,40655,41381,24211,34827,
41560,41559, 4874,34826, 4876,34861, 4892,34905, 4878,37693,13460, 4898,
37778,13508, 8353,35391, 8390,35436, 8581, 8534, 8602,38462, 8683,38525,
15448, 8641,38478, 8579,15277,38435,15138,33431,16652,33730,33429,34560,
29423,29381,40645,41866,33391,26227,33910,40643,18131,33513,11326,11531,
33511,28664,40769,33510,40787,33508,28642,40785,33751,18774,41232,27772,
33679,28943,12118,40634,40633,33677,28941,40629,40632,40628,33675,28936,
41598,41618,33605,33597,33360,33359,33358,33357,33787,39161,39321,39320,
36288,34527,26330,41849,18165,34522,26325,33349,34055,41845,18161,34536,
39160,38969,23693,41793,39327,39626,32091,42030,33307,32090, 4703,33453,
28723,25230,25229,33306,28623,26436,26446,33608,33305,40807,35522,19640,
33304,40825,35232,19645,33303,34053,33301,34044,34048,33298,41691,33296,
41683,41686,33295,33536,33540,33535,33292,33287,33282,33286,33935,33933,
33279,40631,33711,41180,33709,41173,35230,19918,33708,41172,35520,19917,
33707,41171,33577,28797,33278,28611,33892,29148,33886,29144,33277,28610,
33276,28609,33275,28608,33274,28607,33291,28620,33273,28606,43071,33822,
43437,35917,33272,28605,36118,33548,30917,35916,33484,35981,35979,30906,
28760,30775,33546,36116,33383,36083,28645,33367,28749,33482,33271,35915,
36081,30729,33270,28604,39412,30728,39470,35914,33309,33311,39410,39456,
18196,25216,28625,35913,39468,39505,20324,25215,30734,41748,35944,41830,
23695,23697,28638,39458,33331,39507,25232,25234,30736,33269,41797,41832,
18192,23675,35964,35966,41701,41752,20319,23674,35912,30727,41697,28603,
41792,33268,33267,28602,36620,34558,31487,35911,33425,33427,36622,28601,
37113,31476,28689,35910,31489,33266,34471,37010,34556,30813,36021,36023,
29384,34420,37214,28675,33409,33411,31478,37012,30791,33265,29426,35909,
37115,34422,36005,36007,34066,30726,34473,29386,35908,30725,34068,37210,
29428,33264,39067,39069,23701,30724,23703,35907,23673,39065,33386,25214,
23672,39063,28670,25213,36000,30777,40776,40768,25250,25252,33263,40764,
28600,40762,33262,28599,43013,30723,43400,35906,23671,21636,22383,25212,
14454,15824,15837,33740,28975,43052,33261,43429,36320,33739,28974,43051,
31074,43428,36319,24075,31084,21648,28986,22477,26012,36329,14493,33749,
15945,43398,43011,22377,15823,14439,21634,26052,24114,33366,33365,28644,
33480,28747,36111,33529,30902,36079,33473,33260,33259,33972,33258,33553,
33285,28618,41597,41617,33284,33970,33294,33539,33528,28778,11448,40591,
40590,33526,33525,33524,33523,39058,39057,23835,30901,23815,36110,33479,
25517,28746,25494,40753,40752,33538,28787,40610,40608,33522,33780,40589,
42861,23670,33778,35362,33256,35344,33254,33463,34043,29414,41685,41783,
34041,29411,26400,26365,34040,41682,34039,34052,29420,34038,29410,34037,
29409,34065,34064,29425,34036,29408,39406,31565,39466,37204,34456,39450,
18188,26395,37101,39499,20313,26360,41742,41824,24283,24274,29519,34552,
31485,41780,36616,41681,34035,29407,36615,34551,31484,37203,34455,29376,
37100,31472,34411,37003,34047,29418,41695,41790,34046,34050,34034,34073,
34032,33930,33941,29158,33932,29155,33929,29153,33798,41083,18043,35223,
35283,35285,35154,35225,35169,30109,40588,40587,35146,30088,22376,15822,
35144,30086,22374,15820,35142,30084,22372,15818,39529,39623,35148,35209,
39159,35167,39318,35262,30208,40586,40585,35254,30204,41614,41595,35257,
30206,40794,40799,35162,40709,18758,34825,35269,35266,10793,10619,35245,
10783,10561,35251,35243,35242,33724,33728,33722,33721,33968,34685,29738,
40704,40703,34727,29780,41380,41359,34710,29763,20739,40561,13138,40560,
34684,29737,20657,40559,13052,40558,33851,27196, 9902,42736,26993,36435,
42547,42321,12366,27711,36437,43010,33439,42468, 9680,42735, 9685,36043,
11382,33445,11374,42216,36041,43009,33849,37911, 9900,42734,35066,36431,
37907,33847,12364,27710,36433,43008,35081,12602,37746,35083,35007,31772,
37338,35022,35015,35047,35005,35004,35003,35002,35001,35000,10302,35071,
10368,35013,35012,35011,34999,10301,13577,37817,34998,42180,10300,28558,
17770,37820,19393,34996,13579,42450,37818,26546,35045,35058,42292,10363,
26976,10362,37873,13683,35057,13682,42507,37872,26620,35056,37692,10361,
13459,34874,37871,37691,35055,13681,10187,37870,34873,35054,37869,10360,
13680,35053,37868,33660,25733, 9805,40999,26975,36216,42506,42291,11876,
25732,36215,40998,33659,42505, 9804,40997, 9803,36214,11875,33658,11874,
42290,36213,40996,33657,37867, 9802,40995,35052,36212,37866,33656,11873,
25731,36211,40994,33655,37690, 9801,40993,34872,36210,37689,33654,11872,
25730,36209,40992,33496,34824,18484,18433,34860,34891,18526,34871,42289,
10186,26974,10185,37688,13458,34870,13457,42504,37687,26619,34869,37686,
10184,13456,34868,37685,34922,37771,10204,13501,34915,37764,35355,41246,
40557,24074,35361,40556,41290,23645,35390,35394,35388,35387,35423,35431,
35421,35420,35419,34424,34430,29390,34410,29375,34409,29374,34408,29373,
43003,34454,43397,37099,34419,34418,29383,34554,25244,41863,17813,34550,
27709, 2281,26243,26215, 2280, 2279,26242,26806,26214,26542,23643,17768,
 9617,19682,25590, 9615,11631,25602,17766,11650,19701,23641,24043,17975,
 9857,19915,25886, 9855,12116,25884,17973,12114,19913,24041,24525,18827,
24685,10438,18963,10587,18825,10436,24523,10585,24683,18961, 2443, 2442,
18824,26805,10435,26541, 2441,21154,13576, 9256,38787,32802, 9246,38781,
32790, 9253,38784,32798, 6490, 6682,39661,39839, 6676, 6675, 6674, 6673,
 6672,39158, 6697,23640, 6775, 6783,36532,31231, 6580, 6579,18960,26804,
10584,26540, 6578,21153,13575, 6857,38536,32501, 6867,38538,32503, 6855,
38534,32498, 6822,20490,12860, 7477,22060,15426, 6814,20485,12855, 7472,
22055,15421, 8988,38813,32831, 8677,38488, 8239,38346, 6280,21655, 6279,
21654, 6320,23639,23638,23637,23636,40555,23635, 6274, 6315,38953, 8751,
 8823, 6245,23632,23631,14039,20651,37335,31769,15808,34822,24166,24163,
37375,31808,23727,25314,39344,39342,23630,14031,25171,15799, 6241,42999,
 8753,42998, 6240,42997, 6239,42996, 6238, 7605, 7603,21633,24145,14431,
24150,23743,21632,14430, 7577, 7576,21645,23768,14481,23764, 6237, 6236,
21631,42614,14429,42241, 6235,21630,14428,24073,24072,24071,24070,41264,
24069,24066,24065,37331,31766,24064,26009,24063,21647,14491, 8775,43079,
 8774,43078, 8737,42995, 7643,21669,14595,23622,21711,14828, 7827, 7826,
21710,23621,14827,23620, 7824,21709,14826, 6347, 6349, 6351,38519,32485,
 6362,38530,32492, 6364,38532,32494, 6358,38528,32489,18365,24583,18606,
18598,18597,18596,42444,37811,24657,24497,24634,24469,35138,24040,24039,
24522,24682,24681,24521,24578,24738,39405,39465,41680,20283,41779,18147,
18187,41741,20312,39449,41823,39498,24520,24680,24679,24519,24038,24037,
39157,39156,40949,19826,40948,17924,23619,23846,24202,35241,41126,33720,
25977,35386,41125,33719,25976,33718,41124,24482,24646,23834,23814,19058,
10678,43037,36075,43422,30854,19057,10677,42994,35892,43396,30674,15796,
22352,24144,24149,23613,23612,19134,10762,42990,37248,43394,31694,18444,
10075,18466,10092,18432,10073,18431,10072,18552,10124,18550,10122,23611,
23610,24036,24035,24518,24678,24677,24517,18454,10080,23609,23608,22370,
22368,15817,18448,25149,25148,18744,18741,10391,20660,23752,23751,22426,
22425,15894,18430,25336,25335,18757,18756,10405,20648,24161,24159,22349,
22348,15794,18522,26155,26150,18733,18732,10388,20880,35161,40708,34821,
25334,18505,10106,18494,10104,23607,23606,19397,19395,11212,18488,25147,
25146,17776,17773, 9620,20742,18381,38855,18383,23136,18385,38407,17765,
38850,17764,23121,17763,38405,17762,43195,17839,43034,17985,42989,17984,
42731,28965,42744,31065,17998,28977,19979,31082,42988,19997,43054,18379,
37275,17761,42173,28551,26945,42439,42170,28550,26539,30673,42436,42437,
19380,26536,26537,17760,42307,28549,30672,19379,42537,17759,42176,28548,
26948,37814,17758,34994,19378,30671,42446,19377,37812,17757,42746,28547,
30670,19376,43059,18265,10019,18264,10018,42987,20311,43393,18186,18921,
18906,18919,18915,18807,18731,38831,18730,23104,18729,38403,18869,18878,
18890,18823, 1666, 1701, 1613,22346,27707, 5904,15787,15792,27365, 7899,
15124,15129,21836, 7255, 1669, 1704, 1616,22339,27700, 5897,15785,27358,
 7892,15122,21829, 7248, 1664, 1699, 1611,22772,28065, 6116,16309,27593,
 8020,15404,22040, 7459, 1663, 1698, 1610,21183,26835, 5820,13632,26587,
 7143,13137,20738, 6799, 1829, 1839,37855,42487, 1838, 1828,42486,37854,
 2028, 2063, 1963,40545,40543, 2030, 2065, 1965, 2026, 2061, 1961, 2025,
 2060, 1960, 2154, 2146,37897,42535, 2153, 2145,37896,42534, 1827, 1837,
37853,42485, 1662, 1697,21182,26834, 1622, 4117, 7502, 7272, 7274,27373,
27378,27730,27742,17756,17854, 7245,27355,27697,18094, 7287,27392,27763,
 6313, 7244,27354,27696, 6266, 7243,27353,27695, 6311, 7242,28038,27694,
 7421, 7241,27352,27693, 6335, 7267, 7266, 7265, 7494,23605,23604,25145,
25144,23603,25143, 7324, 7323, 7322, 7321, 7320,20812,13196, 7319, 7318,
21377,13916, 7317, 4373, 7238,26225,26196, 8973,23120,16979, 8991,23130,
16996, 7361, 7359,33574,27527,28795,27980,30929,36127,23669,25203,23595,
25135,23750,25342, 8946,23103,16963,18369,38399,17755,38397,18727,38395,
39660, 8200,39838, 8199, 8198, 8197, 8196,39155, 8195, 8452,38335,42884,
 8140, 8431,38284,42842, 8238, 8459,38345,42916,17754,17853,18767,18068,
 4795, 4925,37367,42056, 4484, 4737,42533,37895, 4794, 4924,37366,42055,
 4483, 4736,37894,42532, 5148, 4829,39792,26808, 5188, 4825,39864,26903,
39989,27146, 4804,37381, 4788,37328, 4856,37595, 4824,37717, 5146, 4855,
39788,26801, 6299,27264,27094, 4457, 7316, 4456,27091,27262, 6297, 4299,
 4454,27752,27386, 7280, 4453,27978,27525, 7357, 4452,28047,27577, 7432,
 4451,27140,27285, 6329, 4450,27692,27351, 7237,13569, 4475,27089,27259,
 6295, 6696,21031,13404,34709,29762, 4560,34755,29808, 4581,34683,29736,
 4540,33871,35166,33467,24062,23862,25554,23594,25134,23714,23713,25286,
 4462, 4464, 4447, 4446, 4445, 4444, 4443, 4442, 4441, 4490, 4488, 4440,
 4439,34673,29726, 4521,33234, 4460, 4438, 4471, 4714, 4116, 4473, 4716,
 4119, 4497, 4755, 4167, 4493, 4495, 4753, 4165, 4466, 4711, 4111, 6367,
21723,14912, 6860,21744,15033, 9259,23362,17407,23593, 6328,21692,14780,
 6339,21695,14794, 6324,21690,14774, 4486, 4739, 4149, 4482, 4735, 4147,
14023, 4480, 4733, 4145, 4479, 4732, 4144, 4793, 4923,37365,42054, 4807,
37432, 4864,37753, 4806, 4936,37431,42088, 7907,23592,42849,23591,42851,
23590,42847, 8458,42915, 4918, 4916, 4911, 4910, 4909, 4933, 4932, 4931,
 4908, 4907, 4914,33979,42019,18138,33978,33765,42018,18021,35195,35194,
42017,18787,33764, 4922, 4792,42053,37364, 4747,26177, 4701,26259, 4705,
 4704, 4700, 4699, 4698, 4724, 4726, 4741, 4152, 4707, 4109, 4697, 4101,
 4696, 4100, 4695, 4099, 4694, 4098, 4693, 4097, 4745, 4156, 4749, 4162,
 4751,25133,24475,35152,24229,33977,24126,33763,24491,35193,34428,29388,
37024,34477,31481,37194,37023,31480,42016,37193,42435,34476,18270,10027,
26730,20331,26939,18213,20344,12777,42015,18212,42434,20330,18798,10416,
26729,20025,26938,18796,21497,14105,42014,18038,42433,21501,18025, 9892,
26728,21500,26937,18037,20021,12308,42013,18795,42432,20024, 4927,42065,
 4906,42012, 4935,42087, 4159, 4161, 4096, 4095, 5108,35087, 5099,35070,
 5057,34992, 4094, 5661, 4092, 5336,14586,14141,11159,11144, 4091, 5658,
 4090, 5522,14874,14302,14990,14331, 5862, 8892,17350,17552, 4089, 4088,
 4087, 5339, 4103, 5225,14403,14016, 5549,35329,26162,10521,41333,26658,
38425,42315,42540,15112,26160,38424,41335,33653,25729, 9800,40991,26618,
36208,42288,42503,11871,25728,36207,40990, 4791, 4921,37363,42052, 4478,
 4731,21062,26749, 4143, 4142,37893,42531, 4053, 4052,21234,26864, 4790,
 4920,37362,42051, 4477, 4730,21061,26748, 2152, 2144,37892,42530, 2059,
 2024,21233,26863, 4141, 4051, 1959, 4140,35970,21026,19466,37325,19470,
37594,35973,20647,36795,37324,20288,21025,20446,20646,37216,37593,36757,
37592,20286,20645,20426,21024,37208,37323,36392,41275,36391,41274,36390,
41273,36562,26297,36140,27688,36146,27687,37256,36530,36566,21023,20236,
37322,20194,37591,36542,20644,36570,37273,38249,36136,30938,42243,33227,
42616,33585,35886,30656,42245,33587,42618,33226,35885,30655,43077,28533,
43442,33225,36062,30839,43032,28725,43420,33455,35884,30654,42323,28532,
42657,33224,35963,40621,35883,30653,28530,41592,37231,31646,37228,31634,
37227,31633,37226,31632,37225,31631,36387,31115,36386,31114,36385,31113,
36384,31112,36134,40810,36142,40821,36071,40723,42984,38423,38141,32157,
38140,32156,38139,32155,38149,27088,38109,42750,38108,42749,38107,42748,
38187,27117,38186,27116,38100,42743,38088,27686,38247,38185,27115,38191,
27124,38214,27132,38159,27072,38158,32171,38157,32170,38156,32169,38228,
27110,38222,32183,38091,32101,38138,27063,36315,41193,31056,36314,41192,
31055,36313,41191,31054,36317,41195,31058,36312,31053,36311,31052,36310,
31051,36488,36486,36503,36501,37279,38775,37277,23368,37238,21750,37281,
21729,38738,38749,38748,38747,38746,38867,37264,27685,37262,31730,42983,
29628,43392,34603,37271,21705,37267,27297,37266,21703,37261,21701,36206,
40989,40988,36205,36204,40987,11870,25727,37684,13455,36203,40986,11869,
25726,37865,13677,36202,40985,11868,36078,42982,36077,40791,11447,37590,
37321,37589,37320,37588,37319,37587,37318,37601,37727,37586,37585,38474,
27258,38427,42992,38441,43041,42981,38422,38491,38421,40661,15111,25290,
37828,13590,37018,41853,37017,41852,37016,41851,37014,41847,37022,41855,
36427,41329,37904,42542,20055,26153,42839,38280,36037,40659,42464,37830,
19498,25285,42838,38279,36429,41331,27347,21820,20057,26158,42837,38278,
37832,42467,37810,42431,37809,42430,37825,31965,37834,31981,37808,31952,
37807,31951,37806,31950,37805,31949,37804,31948,37917,37915,37803,37802,
37901,37900,37801,42429,37800,42428,37799,42427,37910,42544,37909,32040,
37903,32034,37891,42529,37361,42050,21232,26862,21060,26747,37890,42528,
42049,37360,21231,26861,26746,21059,37889,42527,21230,26860,37888,42526,
21229,26859,36250,41019,31021,36249,41018,31020,36248,41017,31019,40536,
36252,41021,31023,36246,41015,37359,42048,19815,25716,41014,36245,36244,
41013,42047,37358,19814,25715,41012,36243,36242,41011,37887,42525,19813,
25714,41010,36241,36240,41009,42524,37886,19812,25713,41008,36239,36238,
41007,25712,19811,19810,25711,41006,36237,38303,27404,38277,32219,32089,
31946,38295,32233,38293,32229,38301,32251,38313,32267,38312,32266,38311,
32265,38310,32264,38316,32270,38322,27497,38321,32275,38320,32274,38319,
32273,38348,32304,37330,37597,39790,37599,37315,37576,39863,37575,39988,
37574,37314,37380,21016,21068,20643,20887,37573,37716,37379,37715,39787,
37714,37313,37312,37393,37311,31761,37371,31804,37429,31832,37334,37333,
31768,37340,31774,37317,31763,37373,31806,37310,31760,37309,31759,37308,
31758,37307,31757,37306,31756,37305,31755,37342,31782,37304,31754,37395,
31826,37357,42046,21058,26745,37356,42045,21057,26744,37384,21073,20905,
37725,37383,42080,21072,26757,36539,31236,42240,33909,42613,33908,36552,
36554,41277,27230,41843,41861,41231,32116,41230,41229,41228,40619,41868,
26318,41870,26320,40616,41138,41136,41859,41151,41140,40535,21494,14101,
23589,22490,15957,40534,22327,15761,11105,12188,25952,21433,14012,41188,
42876,41187,42788,41186,41198,41197,41185,41184,41183,41190,22326,15760,
25107,21432,14011,40532,21476,14091,25705,22469,15935,40531,22471,15939,
25961,21478,14093,40530,40528,40529,40526,40524,40522,40521,40546,40520,
40525,40519,40517,40518,40515,40513,40511,40510,40516,40509,40544,40508,
40527,40507,41533,40506,41451,40505,41499,40504,26449,40503,25565,42936,
22325,41892,27294,40502,40500,40501,40498,40497,22354,40496,27209,40495,
40494,40493,40492,40491,40490,40489,40488,40487,40486,40485,40484,40483,
40482,40481,40480,40479,40478,40477,40476,40475,40474,40473,40472,40471,
40470,40844,40873,40842,40469,40468,40467,40731,40727,40726,41525,41516,
41491,41482,41440,41413,41439,41412,41515,41524,41481,41490,43735,22324,
15759,16624,28157,21431,14010,43733,32591,21430,14009,28150,22323,15758,
43855,22322,43755,43758,43761,43764,43754,43757,43760,43763,43720,43719,
43718,43717,43716,43715,40425,40428,21429,14008,23586,22321,15757,40421,
40427,40420,40539,21428,14007,25691,22320,15756,40538,40419,41106,41105,
41104,41103,41102,41101,41100,41099,41098,41097,41096,41095,41094,41093,
41092,41091,41624,41622,41170,41169,41155,41150,41149,25938,40466,41386,
41364,41377,41358,41385,41363,41376,41357,41362,41384,41356,41375,40682,
40681,40697,40696,40680,40695,42655,42309,42637,42264,42636,42263,42635,
42262,42612,42239,41840,41839,40760,40781,40751,40750,40749,40748,40747,
40746,40745,40744,40743,19610,11499,40767,40742,19609,11498,40922,40921,
40920,40919,19824,11893,40806,19637,40824,19642,43451,43494,43383,43382,
43381,43426,43425,43403,43406,43493,42869,43492,41082,43497,25564,43543,
26448,43380,27232,43418,27208,41130,41128,41123,41122,41121,19910,41120,
19909,41119,21668,14585,25832,19949,12173,41118,21519,14140,25831,19948,
12172,40717,21471,14084,25676,22424,15893,40716,21470,14083,23749,22423,
15892,40715,21469,14082,25333,20638,13037,40714,40713,21468,21467,14081,
18429,25332,25331,18755,18754,10404,20637,43096,43094,43089,43552,43379,
43378,43391,43377,43405,43402,43376,43412,43411,43410,43050,27771,43049,
27770,43154,43150,43147,43146,42787,42875,42786,42791,42879,42790,42878,
42785,42874,42784,42873,42783,42872,42797,42800,42887,42799,42886,42804,
42889,42806,42891,42796,42883,42795,42882,42794,42881,42756,42863,42773,
42771,42766,42151,26932,42150,26931,42149,42148,42147,43496,43152,43542,
43214,43417,43030,42146,42578,43375,42972,42145,26304,42144, 8714,42143,
 4292,42142,41168,42213,26958,42212,26957,42211,42592,19520,28500,11386,
33192,42172,26944,42175,26947,41865,40982,40981,36199,25725,40980,33652,
36198,41589,38420,41594,26258,28531,41575,30651,28499,28529,30616,41573,
28498,26256,41591,41588,26253,29448,41570,31341,29251,41587,37002,26222,
41569,34280,36861,41579,41583,42426,42003,42441,42021,42422,42001,42421,
42000,42420,41999,42419,41998,42418,41997,42549,42554,42417,42416,42415,
42414,42413,42461,42460,42466,42035,42463,42033,42157,42424,42141,42412,
40979,40978,25668,42855,26110,42918,25092,42853,42871,42934,22317,42082,
25091,41996,26252,41995,41994,42037,43149,43093,42770,43091,42768,42068,
26182,43088,42765,42067,41993,41992,41991,41990,41989,41988,41090,42493,
42031,42411,42455,41986,42410,42058,35228,41985,33976,41984,33762,41983,
35192,41982,42064,26720,26751,42079,26756,41556,41555,41554,41553,41552,
41551,41550,41549,41548,41547,28954,36303,29445,28595,30719,28949,31037,
31036,28948,29138,29146,42040,18503,28890,11603,42085,18546,29136,12591,
28992,34983,33191,33607,28497,28496,28495,30615,28494,30614,28598,30722,
28597,30721,28493,40722,28492,43040,28938,33362,33190,28940,28933,33521,
28882,33189,28885,28491,33576,28490,28489,34058,28488,43036,30613,28487,
33738,43048,30612,28486,33188,33589,30951,30611,36138,35850,37007,33187,
34415,37109,35849,34465,37206,33186,33354,35968,35848,34061,36115,33185,
33364,35978,35847,33545,36598,33184,33281,35919,35846,33986,37009,33183,
34417,37112,35845,34470,37005,33182,34413,37103,35844,34460,36002,33181,
33988,36600,35843,33389,36004,33180,34063,37213,35842,33408,35921,33179,
33533,36113,35841,33289,29190,34982,29185,31274,29184,33907,37001,33984,
34407,37098,36596,34453,37212,33407,18346,19496,28643,33544,28617,28614,
28485,28484,28483,28673,28481,28479,29406,31544,29413,33178,34458,29378,
33352,37000,34029,34406,37097,37202,34452,29424,33406,34469,29382,29417,
29281,29422,29317,29405,29250,28838,28836,37849,42483,28814,30940,28478,
28477,37842,42476,28476,30606,28475,28474,38452,43058,28473,30605,28472,
28471,42453,37823,28739,28734,38419,42971,29679,43208,29678,43207,31729,
29627,33177,43206,31728,29626,29677,29650,43205,38505,28776,28775,42970,
36999,33520,34405,37096,36109,34451,35977,33543,17815,19590,28786,28783,
28774,28772,28771,30898,28770,28769,42474,37840,29623,12817,34588,34600,
31712,31658,37250,37234,37236,37269,29630,29589,34609,34590,33919,33906,
33913,33905,42969,31273,29183,33904,31235,36538,33925,31246,36556,36588,
29160,33943,37105,34462,18195,20323,37111,34468,18199,20327,37192,34475,
34981,37798,37021,34427,37199,34486,34447,37041,37036,34442,37198,34485,
34446,37040,37035,34441,37197,34484,34445,37039,37034,34440,37196,34483,
34444,37038,37033,34439,29372,42968,31543,29404,33981,31196,30367,30203,
30366,41981,18427,30356,14108,42029,18442,30336,14049,43491,18868,41980,
32456,32455,30380,30282,32249,32248,37303,10546,37572,14501,20624,30273,
35009,30290,34980,30280,30107,30279,30106,42967,38418,34593,34595,19025,
34597,19027,34592,19023,35427,30962,17897,28470,17732,38480,19333,35429,
19649,30604,38482,28844,35458,30603,17731,29656,18373,38508,20466,35444,
19332,31721,38493,28469,35460,31660,18367,29663,18375,38516,20472,35448,
20459,31725,38495,29587,28963,35440,31716,18371,30078,18726,38490,21427,
35454,20463,32088,38502,29646,29661,38512,29659,38510,34979,37797,17730,
19331,34977,37793,37795,35338,30602,17729,30097,18746,38439,21463,35336,
19330,32099,38437,28468,29180,29178,35416,31261,18112,29162,38477,20192,
35434,31268,18127,29166,38486,20217,35328,31264,18119,29164,38417,20198,
35327,31092,18019,30124,18785,38416,21482,35326,20004,32123,38415,28995,
34436,37030,18144,20280,34399,36995,29581,31652,29460,31502,31466,29366,
29003,31106,30139,30601,32132,28467,30142,30600,32143,28466,31130,29012,
34426,37020,17728,19329,34393,36989,28465,30597,29451,31497,31451,29356,
29455,29447,31340,30077,32087,31494,29249,30178,30202,30177,30299,30201,
30200,34404,36998,18725,21426,34279,36860,29360,30138,38134,36982,29363,
30425,38670,36988,29362,36987,29359,36981,29848,31780,31779,37302,10167,
37571,13097,20623,29838,31753,31752,37378,10150,37713,13026,20886,29854,
29837,29836,29887,36236,41005,31801,32030,31800,32029,41004,36235,37355,
42044,31799,32028,31798,32027,29877,29972,42043,37354,31797,32026,31796,
32025,29876,29971,37885,42523,31795,32024,31794,32023,29875,29970,42522,
37884,31793,32022,31792,32021,29874,29969,29873,29968,31791,32020,31790,
32019,29872,29967,37442,31835,31838,29892,20945,13294,37758,10198,37441,
42091,31834,32051,31837,32054,29891,29979,29963,29965,29961,29949,29948,
29947,29946,29945,29976,29975,29974,29956,31972,31971,41977,33975,31945,
33761,31944,31943,35191,29944,31942,31941,42063,42090,32050,32053,29978,
37353,42042,31017,31016,31015,31014,28924,28923,37883,42521,31013,31012,
31011,31010,28922,28921,36234,41003,31009,31008,28920,31007,31006,28919,
36573,36559,30749,41750,39927,27061,36085,28663,39519,26343,39521,26345,
39517,38971,39061,30955,30953,28834,28832,26597, 9597,20771, 9596,30942,
28812,13649,13159,36568,29087,20211,36550,30974,39555,30976,31207,31202,
39566,31213,39568,31215,32332,32324,14975,14864,32331,30971, 9587,30784,
30885,11334,11536,31035,28947,31034,28946,31033,28945,31032,30680,30682,
31027,43145,27971,38105,36361,38104,36360,38103,36359,38102,36358,30596,
30904,30595,30731,30594,30858,30593,30922,30592,31569,30591,31279,41602,
28464,40779,28463,40729,28462,30788,30920,30787,30919,30589,32108,30587,
30851,40741,31218,31282,31217,33158,31244,33923,33157,31281,31243,33922,
31223,31649,31222,33156,34481,31229,33155,31648,34480,31228,31103,41708,
30586,41705,30751,34057,30585,34060,30837,33551,31227,34479,33921,31242,
30584,33388,31238,33912,30583,33405,34467,30582,30581,34464,31590,33351,
33917,31240,31277,33471,30580,33542,30579,35822,28461,24137,33154,24135,
30578,35821,28460,20315,33153,18190,30577,35820,28459,20322,33152,18194,
40766,40775,28458,28669,33151,33385,31272,30897,33903,31234,31271,34450,
33902,31233,31270,36595,29182,20310,33983,18185,30576,35819,28457,20059,
33150,18701,40773,28667,42406,40772,30889,33149,30856,33148,31111,42577,
31110,31109,12307,41976,20622,30843,33147,31877,31865,31864,31875,38137,
37570,31904,31542,30896,31541,34449,31540,37201,29403,20309,34026,18184,
31630,42576,31629,31628,12776,41975,20621,31903,43374,33146,31108,31627,
33356,33519,31045,33145,43156,38484,28456,28455,38443,43045,28454,28453,
31152,30572,38414,42966,29040,29047,43204,38501,29676,29645,30895,36108,
28768,23808,33518,23827,31710,42921,31727,29625,36586,36582,36581,36580,
36579,36584,40740,29152,33928,31288,36607,29197,20336,33993,18262,31287,
36606,29196,20335,33992,18261,31286,36605,29195,23570,33991,23569,31284,
36603,29194,20334,33990,18260,37259,22029,43144,27970,32398,33816,32358,
33967,32372,33144,32371,32472,32357,32356,32355,32375,32377,32470,33143,
32469,32454,31940,32488,14328,32491,14344,32497,14301,32500,14308,39361,
26101,32247,10545,39782,26792,32246,31751,14500,13025,32238,39552,32227,
32323,32235,32231,32312,42580,32225,14040,42025,20652,32253,32263,42575,
32262,32261,14104,41974,20620,32260,32259,32300,32243,41593,28452,30571,
31099,41604,28451,30570,28450,30569,28449,41607,29090,41606,29089,30841,
28727,31733,29666,31732,29665,31225,31499,31220,31266,30568,31496,30567,
31263,30566,32131,30565,31105,30564,31091,30563,32122,30562,28448,42539,
28447,37827,28446,32197,32191,32196,32190,31097,31096,31095,38514,20470,
31258,31251,33142,31249,33223,31256,31255,31254,30650,30561,41572,26255,
41586,29175,31260,32084,31062,28962,32185,25060,43143,27969,32154,32153,
32152,32151,21506,32150,21505,37792,38136,43087,27905,42764,27245,41135,
25798,38184,32179,32181,32177,32114,32083,31493,32129,32128,32127,41585,
29248,31771,10157,39784,26794,31750,10149,39862,26902,39987,27145,31749,
31778,13024,13096,31777,10166,39781,26791,33466,43424,35165,40725,33880,
43390,32468,43373,32475,32374,33139,32354,31789,32018,31005,31004,31788,
32017,31787,32016,31830,13286,31829,32048,32045,25059,31976,25310,31939,
26251,31947,31983,31938,31937,32043,12475,31936,14107,31974,14074,31959,
35141,31935,33974,31934,33760,31933,35190,31932,13023,32258,14103,31931,
13022,31930,13021,32223,14038,32221,32257,32014,32013,31992,11595,31990,
31988,31986,31985,31963,31929,37791,29943,21499,34974,18036,29942,34973,
31928,18794,37790,20023,31927,37789,29941,20329,34972,18211,31926,31970,
32047,31003,32903,32767,32894,32750,32590,32608,16656,32623,12282,11039,
32630,32627,16680,32582,16581,32576,32615,32614,32573,32572,32570,32568,
32651,32665,32650,33138,32656,33896,33137,32664,32655,33895,32654,33894,
34023,32564,32563,33517,32562,41669,32828,32827,17502,17501,32745,32744,
16798,16797,32825,17495,32917,17319,32824,32850,17318,32849,32783,17544,
32797,17565,32561,32560,32658,32646,32926,32914,32913,32559,32558,32690,
32795,17563,17381,32684,32777,17541,17317,32672,17200,32670,17194,32669,
32741,16962,32740,32739,32738,32789,32923,32737,32736,32766,32755,10229,
10284,10239,10165,10237,10159,10228,10148,10227,10147,10226,10283, 9863,
 9748,40145,10048,40165,10050,40167,32291,31050,30365,28953,30176,28952,
28951,30343,30129,32290,32168,30364,30175,30174,30363,30199,30379, 9665,
21011,36541,36756,35972,36365,20445, 9752, 9582, 9750, 9581, 9627, 9634,
 9580, 9579, 9578,11036, 9648,11282, 9577,11035, 9667,34545,34581,35202,
33772, 9889, 9885, 9884, 9883,17877,17837,17713,17879,18133,17856,17712,
18096,17858,18098,18135,17711, 9949, 9955, 9953, 9952, 9951,18129,18093,
10037, 9640,23566,23565, 9646,23564,20220,33136,41616, 9694, 9697,23563,
19433,33135,40607,23562,24496,33134,35221,24699,33133,24539,33132,24046,
41177,10234,10296,10225,10282, 9726,21010, 9717, 9716, 9715, 9714, 9713,
11524, 9728,17865,24209,33927,10733,10730,23561,19623,33131,40798,23560,
24148,33130,33815,10024,21009,23559,20317,33129,41789,23694,20321,33330,
41796,40707,35160,25330,18753,34859,10070,18483,13378,34808,10099,18426,
13436,34909,10126,18555,13494,10794,10495,10784,10441,10782,10434,10796,
10498,10799,10512,10801,10515,10281,10224,10280,10223,10290,10231,35069,
34971,10279,26303,10278,10277,24228,33937,24125,24490,33767,35197,24673,
13015,24513,13014,24030,41167,10777,10431,10306,10236,34976,10768,10408,
10359,10183,10358,10182, 9797, 9796, 9795, 9799, 9794, 9793,10191,10196,
10146,10145,34402,34382,34392,34391,34390,34389,17710,18023,26235,26237,
26202,26204,18125,18089,18105,18118,17709,18100,18018,17708,18784,18778,
17707,18012,18092,26221,26195,18091,18724,18111,37836,42470,21174,26829,
37838,42472,21177,26832,37857,42495, 9576, 9575,21216,26848,11031,11030,
36545,41564,20204,26213, 9574,11029,36549,41567,20210,26218,41566,26217,
10511,10644,10497,10634,10420,10555,10514,10653,10508,10637,10403,34807,
14078,18425,36535,41546,20191,26194,10473,10618,10430,10580,10480,10623,
10491,10625,30183,10532,40102,10560,10582,10554,10579,32289,32272,10562,
10590,10628,10770,10617,10776,10620,10632,10550,10549,10548,10655,10630,
10616, 9860, 9852, 9851, 9854,10530,20618, 5566,20617, 9573,20885, 9712,
20616, 4291, 4290, 4289, 4288, 4287, 4286, 4356, 4355, 4354,41343,41339,
40665, 6669, 6709,20614,13010, 6821,20611,13007, 7470,22053,15419, 6720,
21548,14238,30101,35158,15891,22422,29753,34700,13136,20737, 4549, 4518,
29770,34717, 4565,29796,34743, 4572,29734,34681, 4535,41611,18173,41613,
33786,35208,34535,18103, 4285,42625,32907,32906,32195,32189,32188,32194,
 4993,42313, 4949,42140,42312,20607,20879,42139,10304,20606,13058,42138,
10729,20605,16109,42137,42448,42178,10276,42491,42136,42490, 4948,42489,
10286,42409, 4954,42443,36593,42135, 4284,42134,10029,42133, 9940,20935,
 9939,23558,12616,42351,23557,20934,33126,42350, 9183, 4283,10121,18549,
 4282,40459, 4281, 4280,20604,42634,13003,42261, 4279,20603,13002, 5137,
 4978,20602,42260,13001,42633,42632,42259,20601,20600,13000,12999,18690,
10349,20599,20598,12998,18689, 4278,20597,12997,18511,10110,20596,20595,
12996,18510,40918,20594,12995,17923, 9765,40917,20593,40916,17922,40692,
40691,40690,40689, 4320, 4322,40418,40417, 4306,40416,42585,42574, 4973,
42252, 4972,42405,42201,20670,42404,42200,10316,20703,13104,42223,10315,
42403,10097,18481,20592,20591,18478,12994,13134,20735,18415,18413,20734,
10063, 4277,20590,12993, 4335,20733,13133,35135,30076,22307,15748, 4399,
 4401, 4276, 4275, 4274, 4273, 4272, 4271,29721,34668, 4515, 4304,40712,
21466,14080,23748,22421,15890,40415,40514,41545,41544, 6668, 8194,33785,
35207,34534,40424,21425,14006,23588,22306,15747,40423,40414,40413,21439,
14026,23556,22334,15779, 4372, 4369, 4368, 4367,35151,30093,22413,15879,
35150, 4709,42027,20654,31957,13047, 4743, 4692,42062,20878,31969,13057,
32452,16107,32464,32480,32369,18743,24473,20658,26549,18117,24227,20589,
26528,18017,24124,20588,26527,18783,24489,20587,26526,40412,10275,20877,
12992,42311,41973,20586,31925,12991,30092,30275,29355,29432,30137,30296,
29002,29008, 4318,17706,23555,20691,26570,40411,25557, 6570, 4334,29718,
34665,12990,20585, 8185, 4333,34541,40410,21144,13573,23554,21321,13811,
 4337, 4332, 4331,17775,23649,20740,26589,18110,24208,20732,26586, 4339,
17705,23553,20744,26593,10094,18475,20584,20583,18473,12989,13156,20767,
18411,18408,20766,10060, 4269,20582,12988, 4346,20765,13155,23552,23551,
20958,20950,18569,13299,10132,18561,20957,23550,18568,23549,10131,18560,
23548,20949,23547,13298,10128,18557,20955,20947,18566,13296,23546,20967,
13309, 4426, 4425,20966,23545,13308,23544, 4422,20964,13306,18123,20907,
18736,26927,18735,20656,18116,20581,18016,20580,18782,20579,18072,27682,
18077,20932,18075,26926,18074,20930,18070,20923, 7374,21967,15295, 6806,
20578,12987, 7475,22058,15424, 7355,21955,15281, 6829,20897,13255, 7482,
22065,15432,17704,26941,39072,22305,15746,25553,21424,14005, 4345, 4344,
20764,39836,13154,39658, 4330, 4329,20731,26878,13132,26640, 5176, 5028,
20763,39657,13153,39835, 4328, 4672,20730,26639,13131,26877,39834,39656,
20762,20761,13152,13151,26876,26638,20729,20728,13130,13129, 4343,21375,
13913, 4327,21249,13704,39129,20760,13150,25661,20727,13128, 4364,20803,
13187, 4385,20846,13227, 4366,17904,26925,17903,20775,18109,20759, 4352,
 4363,17703,20773, 7224,21817,15106, 7278,21845,15151, 6793,20758,13149,
 7453,22033,15389, 4419, 4418,18063,20916,18723,20909, 4414, 4413,17702,
20911, 7222,21815,15104, 7399,21987,15317, 7350,21950,15275, 4312, 4362,
17701,20681, 7220,21813,15100,23543, 7430,22016,15356, 7436,22020,15361,
 7409,22000,15333, 7391,21981,15309, 9607, 9609,20868,26645,26883, 9571,
21254, 9570, 9569, 9568,20862,26642,26881, 9605,21252, 9603, 9711, 9710,
20845,26634,26872, 9709,21244, 9708,32149,17742,27675,18764,26633,17850,
27739, 7293,27674,27803, 7219, 7264,27723,27722, 7263,17700,27691, 7218,
27690,27673, 7233, 4397, 4384, 4387, 4383,10544,26524,14097,37564,10164,
26523,13611,37563,37712,26522,26665,37562, 4854,37711, 4819,37561,10169,
26582,13623,37610,37603,26564, 4833,37657,23542,26552,23747,26521,10144,
26664,13559,37710,24179,26684, 4622,26520, 4642,26575, 4621, 4680,26519,
26657, 4620, 4010, 4619, 4009, 4618, 4008, 4617, 4007, 4616, 4006, 4615,
 4005, 4614, 4004, 4613, 4003, 4612, 4002, 4651, 4042, 4650, 4041, 4649,
 4040,17699,42365, 4999,42364,42338,26673,42337,26672,17698,26694,10370,
26693, 9943,26689, 9942,26688, 4611,26518, 4610,42500, 4609,37862, 4608,
26517,42499,26516,37861,26515, 4984,42285,42284,26514,10357,26513, 4837,
37681,37680,26512,10181,26511,40976,36197,36196,40975, 9792,26510, 4627,
 4019, 4677, 4066, 4629, 4023, 4679,26656, 9567,17697,26655,26157,26889,
26152, 9850,17972,26509,25868,26789,25867, 5989, 4001, 5982, 4017, 9724,
 9832, 9821, 4068, 4021, 4025, 4000, 3999, 3998, 3997, 3996, 3995, 3994,
 3993, 3992,18079,18763,17849,17696, 5676, 3991, 5978, 4076, 9819, 4640,
 4639,26788,26573,26828,26827, 4655, 4607,26604,26847,26850,26787, 4653,
 4606,26845,26508,26844,26786, 4072, 4071, 4070, 9601, 9599,13239,13706,
 9566, 9565,13247,13710, 9707, 9706,13224,13694,32148,17740,27672,18762,
26869,17848,27738,17695,27802,26341,38967,25052,26190,25051,26188,25050,
12633,25049,12628,25048,26338,25047,12682,25046,26280,25045,12771,26095,
26329,25111,12672,25228,25044,25043,25042,25041,25040,25039,25038,25037,
25270,25269,25980,25979,25036,25035,25034,25033,25032,25295,25294,25293,
25292,26167,26172,26166,26171,26165,26170,26164,26169,25309,25308,25307,
26176,26181,26175,26180,26174,26179,25031,25030,25029,25028,25027,25026,
25025,25024,25023,25022,25021,25020,25019,25018,25017,25016,25015,25014,
25013,25012,25011,25010,25009,25008,25238,25236,25264,25266,25543,25542,
25537,25539,26316,26327,26091,25226,26059,26061,26058,32176,38181,25804,
25806,25802,25801,26108,20020,26093,20015,25242,19468,26336,20349,26335,
20348,26334,20347,26332,20343,26323,20340,25391,25370,29835,25369,34970,
26099,31094,32126,31253,35415,38473,36287,38148,36286,36285,25935,27057,
25934,26098,25933,26374,25963,27671,27340,25960,25932,27255,27085,25931,
25959,27050,26097,25967,26186,26184,33117,33965,33116,28439,29173,33964,
29435,34082,33115,28438,33114,34081,26377,26419,25260,33911,33531,28780,
28785,33537,33915,25007,25006,25005,33469,33960,29416,34045,33300,28622,
33283,28616,29170,33957,33350,34056,26369,26402,25004,26005,25003,25341,
29168,33955,34022,33954,26394,26357,28189,22298,28165,28167,33113,33899,
33112,28437,29150,33898,28123,33901,33516,28767,28122,28121,25552,40394,
25551,25550,28436,28435,28641,29402,29401,34021,26373,34969,26372,25248,
19474,11313,19927,25892,12124,28434,28433,25826,25825,26224,25828,26930,
26924,25830,25824,26967,41117,19947,12165,25389,26063,26083,27025,21441,
27190,21629,27108,27071,27244,32175,38180,27074,27070,27069,27076,27059,
21496,27027,27670,27047,34611,35085,27135,27056,34968,27055,38179,35414,
38472,38147,38146,27084,27254,27083,27253,27052,27222,31101,36363,26296,
26288,26271,26287,26283,20247,26285,26264,26290,26273,26294,26277,26293,
26276,26292,26275,25344,28055,28057,27828,27726,27784,27403,27783,27402,
27715,29840,27669,29881,29192,42830,42130,43047,27769,42402,37788,43086,
42763,41134,27668,42752,41279,41836,28023,27667,27737,29834,27736,27904,
27496,27903,27495,38178,32174,28432,28862,29400,29399,29247,27982,27966,
27515,38471,32426,38145,32163,36284,31043,27984,36120,40793,28431,28430,
29046,29039,27762,35413,38470,27243,27242,27068,28429,28880,29398,27126,
27270,27100,26923,27010,27012,26951,26961,26969,26954,26922,26921,26920,
26919,26918,42210,42129,30264,27000,42552,37919,29189,28991,30289,26917,
42459,37899,26956,42401,37787,43142,26916,41838,27054,26915,26914,27261,
27093,27122,27137,27139,27143,26929,27252,27082,26987,26986,26985,26984,
26965,27045,42306,26262,26269,26268,25864,25862,19907,12099,25861,21133,
13558,26232,25284,21158,13589,36233,41002,41001,36232,25459,25467,25466,
25439,25438,25437,25463,25462,25478,25436,25435,25434,25433,25432,25431,
25430,25429,25448,26797,26913,25450,25428,26630,26868,25427,25455,19572,
11451,19575,25453,11454,25425,19564,11435,25422,25421,34547,36611,29498,
31483,40783,36087,27782,27902,27499,27501,27494,27493,27401,27721,27720,
27719,27519,27514,27513,27512,26737,26742,26739,26717,26716,26715,26714,
26713,26735,26734,26733,36534,41543,26558,22395,26507,22420,26675,22296,
26506,20726,26578,20695,26505,20577,20876,26654,30266,30082,29431,29354,
30295,30136,29007,29001,26504,26785,26503,26784,26502,26783,26501,26782,
26653,20576,26803,26818,26810,26781,26780,26779,26778,26777,26905,26776,
26775,26774,26773,26772,26814,27666,26771,27735,27975,27749,28027,28044,
28037,26796,26770,26831,21179,21176,13621,13619,26843,21132,13557,26822,
26821,26820,25684,19793,25679,19791,25660,19781,25659,26261,25658,32147,
25657,26231,25656,25655,25654,27734,25653,25682,27665,27767,25704,27766,
27664,25703,25707,25652,27718,20178,20182,19439,11301,19435,11297,19999,
12305,20245,12674,20249,12676,20253,12680,20252,12679,20251,12678,26247,
21597,21596,21595,21594,30157,35219,33813,29037,29457,34543,40385,40384,
40383,40625,19655,20477,20475,42960,43367,42673,42571,42959,43366,19653,
28426,33105,28425,33104,19651,28424,33103,41111,41110,41108,31886,28423,
28422,28421,28420,19639,11546,19644,11548,19622,19115,41179,41153,19536,
11398,21323,21148,37369,37702,31765,21152,21314,21131,37377,37709,31776,
21130,32245,21129,21313,21128,21312,21127,21311,21126,21401,21305,37295,
37560,31748,21304,21374,13912,20757,20756,13148,21373,21241,13693,20725,
20724,13127,21240,21372,13911,21371,19612,11504,28419,40382,40381,19823,
11892,39128,20755,39127,19822,19780,11781,25651,20723,25650,19779,19821,
11891,19820,19819,11890,11889,19818,41089,41088,19437,11299,19540,11402,
19531,11393,20034,12310,20037,12329,15739,22295,20036,12328,20290,12758,
20300,12769,20299,12768,20298,12767,32458,40797,41132,40630,41662,41707,
41690,41785,41661,41774,41660,41773,41700,41699,41795,41684,41688,41659,
41727,41811,41725,41657,28418,28417,20229,12982,20228,20575,20225,12655,
20222,12653,28416,26302,42400,37786,22294,15738,22293,15737,22292,15736,
22291,15735,22290,15734,22289,15733,22288,15732,22287,15731,34719,29772,
35227,30162,29728,34675,35140,30081,34689,29742,35134,30075,29774,34721,
35133,30074,35253,30198,35132,30073,28931,33671,35130,30071,22286,35177,
22285,22284,22353,22283,31910,29115,29113,31879,28415,28414,22438,15899,
22282,15730,22746,21563,37294,37559,31747,21562,22748,16285,22750,16288,
22415,15884,22281,15729,22280,15728,22392,15849,22463,15930,34658,29711,
35157,30100,29710,34657,35156,30099,22419,15889,31863,29036,29035,22651,
16133,22653,16140,22658,16151,19922,19920,19906,40380,19905,19904,41087,
41116,19968,12203,19966,12201,19946,12164,19945,12163,38940,25109,21310,
21125,20232,12661,20234,12663,20240,12667,20239,12666,20238,12665,20242,
12669,20305,12687,20304,12686,20303,12685,20307,12689,20176,12631,20175,
12630,20180,12635,32140,31127,32139,31126,32138,31125,32137,31124,20351,
20346,31463,31462,31456,31448,31447,31446,31445,31862,32146,31924,41972,
21504,21503,21578,21577,21576,21575,27661,21437,21457,21455,32173,21534,
21532,21530,27660,41713,41802,42860,42754,41724,41810,21525,14160,21523,
14158,21518,14134,21517,14133,21542,14214,22955,23406,23405,23404,23403,
22986,21686,14735,21651,14505,41289,41281,42958,43365,40371,40370,43076,
43441,21638,14457,21657,14512,21674,14605,21672,14603,21667,14579,21666,
14578,19579,11459,19601,11477,25419,25417,19561,35438,30308,41723,41809,
27202,27033,21034,27713,21008,27733,25368,21007,27659,21075,22411,15877,
34878,29879,41558,41577,40612,40614,41693,41787,22278,15727,34907,29889,
26560,26816,22277,15726,26551,26812,22394,15852,22364,15806,34804,29833,
26500,26769,22363,15805,21481,20207,22481,20203,20213,20206,20202,26499,
26768,20201,20270,12650,20269,41342,41338,41337,41341,40664,40663,41562,
41581,20573,12980,29751,34698,34655,29708,34696,29749,34653,29706,41610,
20570,20569,34533,35206,33784,20568,18102,20567,12979,42624,42623,23537,
23536,20566,12978,20565,12977,41086,41085,36592,12658,20564,41808,41374,
41353,41373,41352,41372,41351,41371,40369,40368,40367,40366,40365,40364,
42597,42570,42569,42627,20664,13056,20563,12976,20800,13184,20754,20753,
13147,20799,20842,13223,20722,20721,13126,20841,20798,13183,20797,20650,
13049,20562,12975,20561,12974,20560,12973,20559,12972,41979,31961,42023,
42061,41971,31968,41970,32451,41969,40363,20875,13250,31923,42060,26496,
26767,21448,14037,20720,13125,20719,13124,25860,25859,20718,20717,25966,
25556,20796,13182,20927,13282,20929,13284,20809,13192,20795,13181,20866,
13243,20840,13222,20852,13232,20839,13221,21150,21156,21136,21124,21123,
21122,21121,21120,21278,27658,21119,25367,27732,21118,28025,21138,21117,
13556,21116,13555,21115,13554,21114,13553,21263,21262,21261,25415,25413,
12352,14223,12821,14281,12823,14284,11140,14523,11132,16013,16393,16380,
14985,14869,16399,16386,15015,14892,11966,11104,10996,14459,11321,11539,
11466,10995,11332,11472,11534,10994,11346,16643,10993,16653,11530,11520,
11433,12281,12285,11348,11345,40140,39228,11990,14113,11989,15240,11988,
21492,20011,21491,20010,21490,20009,21489,20008,21488,20007,21512,20042,
34803,29832,23535,23699,24207,21511,20041,33102,11672,22276,35218,11555,
11551,41176,11366,35137,40362,33101,40361,40523,41542,21487,21370,35188,
33950,13910,33100,40360,40499,41541,21486,20006,35187,33949,11888,43364,
33099,43363,12766,42568,18668,12657,36591,33098,32353,11080,12046,12039,
12010,12036,12014,11189,11191,37683,42287,11099,11101,37864,42502,11089,
11091,11066,11068,11117,36201,40984,12614,42348,27657,22275,42347,37744,
12613,12600,42346,37743,12538,12537,33097,13266,23526,27656,22272,12536,
12510,15773,14398,15722,33962,15721,26417,15720,26663,40355,15797,15719,
15718,33946,33830,33433,15717,15716,15715,26691,16233,33096,33095,15713,
33094,37344,33868,37388,33875,20474,32309,33833,33437,33837,17996,33093,
33092,15709,15706,15921,40354,33812,23525,20040,15834,32487,32496,32776,
40353,40352,33091,33811,33810,33809,37293,33808,33807,33806,33805,32299,
32474,32388,33090,32352,17684,23524,27756,22461,27655,22255,17843,23772,
17841,23746,27728,22418,26585,20716,15700,15099,15888,26495,26494,20558,
27029,21447,27036,21462,16104,14669,17900,16103,12971,40351,31922,32450,
25572,19660,17683,23523,26493,20557,16102,15274,26492,20556,12088,12087,
12086,41166,23522,12131,12085,42128,12084,40627,35975,37785,42399,12082,
12113,12079,12078,12077,12076,42498,37860,12075,12074,42283,37679,12073,
12072,40974,36195,12071,12123,41772,41771,41770,41769,41782,36891,41799,
36967,41768,36859,41807,12968,41806,36986,41805,36985,41767,36858,41766,
12517,12514,37751,12606,37749,12604,11378,42546,37906,11431,11430,11429,
11446,11450,11428,11427,11426,21537,12242,20215,20189,20274,21113,20200,
20268,20272,22254,20265,20555,20264,20794,20263,20262,21369,20261,20260,
22253,20257,20715,20267,24168,23521,41348,40350,24206,41540,22356,21036,
22362,21005,21070,22252,21510,21004,21146,22251,21140,22330,21435,21317,
13366,18487,13365,15909,18447,15816,21112,22361,15804,18405,15803,13364,
14077,13363,13435,13809,13572,15699,13492,18554,15698,36471,36498,36547,
15137,14053,16177,14484,40139,39954,15239,14112,15238,14111,15697,15887,
15864,40711,21465,20752,15098,20937,15326,36469,20468,15273,14182,20554,
15272,16100,14326,14299,15021,14896,15013,14890,14961,14960,14959,14958,
14853,14768,14231,14499,14426,14030,14767,14665,14705,14195,14692,14187,
14663,14180,14730,14577,14729,14132,14728,12159,14727,14726,43440,43362,
18059,34607,17682,34605,18720,34602,34903,14772,14786,14269,15355,14267,
14784,16269,15351,16265,14868,14852,14851,14850,14849,14957,14889,25722,
33651,14576,14575,14574,26973,14573,35051,14572,26612,14571,34867,14570,
14569,14096,13552,23520,14062,23519,39795,23518,21316,22250,39531,20793,
14004,39655,14003,21368,14002,39833,14001,14000,13999,39126,19817,40119,
40138,14280,14283,14228,20553,21485,20792,21484,14237,33758,33757,39753,
14240,39752,33089,14247,34800,14246,33088,21111,21451,14222,14207,26584,
15097,16099,14131,25721,33650,14130,14129,14128,26972,14127,35050,14126,
26611,14125,34866,14124,14123,14052,12157,12155,12153,12182,12152,12151,
12150,26971,12149,35049,12148,26610,12147,34865,33649,25720,13454,12146,
16900,17343,16912,17380,16619,16568,23517,16689,16566,24234,16564,22248,
16724,24188,16723,33085,16729,33890,33084,24187,23516,33889,16728,33888,
34012,16559,23826,33515,41648,16558,17067,17181,16557,26220,18087,16720,
16810,16773,16772,20552,17681,16771,16556,18719,16956,16955,17537,17300,
17536,17299,17535,17534,17297,17295,17293,17292,17291,17290,17533,17388,
17377,12965,12964,13095,12963,41609,18172,34532,35205,33783,15477,15532,
17101,12962,32905,32193,32187,16767,12961,13055,41347,13067,12960,18502,
12959,12958,18545,12957,17199,14073,18441,14048,32032,31967,31921,21110,
21446,14036,18404,14035,17680,23511,18740,24471,13163,13660,26601,20777,
18115,24226,18015,24123,18781,24488,12956,13551,26652,20874,40347,13054,
13588,26487,20551,40346,40512,41539,33756,35186,33948,13180,19648,25562,
20465,26438,30161,30303,21450,27031,29353,29430,30135,30294,29000,29006,
21461,27035,36984,41804,12955,13550,37747,42357,12954,13549,40345,25560,
26486,13123,33952,13122,13121,25965,25559,15460,15514,17055,17772,23647,
17679,23510,18108,24205,18121,17678,18738,18114,18014,18780,12953,26651,
18061,18085,17677,18083,18718,18081,15279,16126,15095,15694,17676,17906,
18107,15149,15902,13263,15344,16259,15353,16267,15187,15955,15289,16156,
15127,15790,15093,15692,13548,13610,13596,23508,22329,23745,22417,15809,
34823,15691,34863,22242,24181,15690,15886,20714,13547,40796,35139,33827,
33803,15828,15687,41794,13546,42222,13545,13544,13587,16239,34799,16238,
33082,13543,13578,42408,37794,37816,42445,13657,42127,13656,13655,13654,
42398,37782,13764,42369,17675,42368,13763,42367,13761,17674,13760,15683,
13728,13727,13542,13541,13540,42497,13539,37859,13538,42282,13537,13536,
37678,13535,40973,36194,13534,15680,14206,14568,14122,13667,13586,20550,
13585,11809,11819,11779,11817,12121,11775,11797, 9551,34857,33081,33079,
 1870,10340, 1763,21210, 1607,32011, 1803,35041,30536,30534,19291,31901,
17673,29870,28404,28402, 1820,37989, 1577,29932, 1748,18661, 1887,13864,
35765,35763,10964,37629, 9549,34854,33077,33074, 1867,10337, 1760,21207,
 1604,32008, 1800,35038,30532,30529,19289,31898,17671,29867,28400,28397,
 1817,37986, 1574,29929, 1745,18658, 1884,13861,35761,35758,10962,37626,
 9546,33071,33068,33066,19054,18717,14385,19286,38275,38056,30331,33064,
30526,30524,19282,30522,17667,28391,28388,28386,32215,35749,35477,35586,
10674,17664,21625,22234,35746,35744,10957,35742, 9542,33055,33053,33050,
19051,18714,14382,19279,38272,38053,30328,33047,30516,30513,19277,30510,
17661,28384,28382,28379,32212,35739,35474,35583,10671,17657,21622,22231,
35737,35734,10955,35731,17797,34167,33045,33043,36731,34323,33345,31399,
18340,31381,19447,34342,35958,30508,19267,31584,17649,29534,33325,28371,
17808,36906,20409,29311,35939,29295,34185,36925,35717,35715,19461,36750,
17796,34166,33029,33027,36730,34322,33344,31398,18339,31380,19446,34341,
35957,30500,19259,31583,17641,29533,33324,28368,17807,36905,20408,29310,
35938,29294,34184,36924,35713,35711,19460,36749,43358,33025,33022,33020,
 7205,40213, 6413,24632, 7559,39912, 6227,33018,42727,30498,27180,30496,
24775,28366,40212,28363, 7556,35709, 6226,43355, 7202,27333, 6412,42724,
35706,35704,39911,35702,43361,33015,33058,33061, 7208,40209, 6409,24630,
 7562,39908, 6223,33013,42730,30519,27183,30493,24778,28361,40216,28394,
 7555,35699, 6230,43354, 7201,27332, 6416,42723,35755,35752,39915,35697,
17638,10331,34848,35032,30491, 1811,33011, 1568, 9531, 1739,19256, 1878,
35695,32002,21053,21201,18613,18652,33008,29923,17635, 1861,10944, 1754,
35692, 1598,28359, 1794,37620,37980,19253,13855,17632,34202,33647,33633,
36770,34359,33005,31436,18359,31419,19250,34375,35689,30992,19768,31615,
17920,29549,33004,28918,17631,36945,20439,29346,35688,29330,34219,36962,
36230,36193,19249,36789,17630,33377,33646,33632,36229,33003,30991,17919,
30769,19248,35687,19767,28655,28917,35994,36192,17889,10746,35613,35557,
30927, 8803,33565, 5749, 9746, 8073,19628, 8560,36125,32295,22558,21685,
18903,19091,33570,30376,17895, 8844,11544, 6969,36132, 6014,28802, 8448,
38196,38333,19633,14689,17888,10745,35612,35556,30926, 8802,33564, 5748,
 9745, 8072,19627, 8559,36124,32294,22557,21684,18902,19090,33569,30375,
17894, 8843,11543, 6968,36131, 6013,28801, 8447,38195,38332,19632,14688,
17887,17628,35611,35555,30925,30488,33563,33001, 9744, 9528,19626,19246,
36123,35685,22556,21683,18901,19089,33568,32999,17893,17626,11542,10941,
36130,35683,28800,28356,38194,38331,19631,19244,39563,10143,34967,34798,
30660,42077,33233,26992,33856,42320,31186,31181,39684,31861,24419,21003,
26998,18587,42331,29831,29068,29085,36449,39689,35890,24423,28540,39559,
37950,37553,42072,13360,33862,18638,33197,33201,35065,37723,32038,34797,
31175,18619,33846,21002,30630,37949,31192,19345,29074,17746,28509,34966,
36467,18586,29079,21066,29936,37552,38021,34889,35855,35859,36462,21109,
33210,18637,33451,33444,35020,37608,31979,34796,30643,18604,33205,21001,
30835,37948,30639,19516,28522,17835,28711,34965,35868,18585,28517,21046,
29911,37551,37970,34832,36049,36060,35864,21108,18010,35175,33221,33215,
31081,18584,33736,21859,37947,37550,29904,35353,36327,30648,19351,32120,
17752,30423,33747,28527,31920,38450,34964,34795,36337,18946,28984,21000,
35874,35879,19988,38641,17823,18358,28697,29563,30809,31435,33401,34358,
38685,38468,31614,31418,36017,36769,11343,12750, 9663,10013,33421,34218,
32162,32425,36788,36944,36033,36961,28685,29329,30799,31601,19492,20438,
17822,18357,28696,29562,30808,31434,33400,34357,38467,38684,31613,31417,
36016,36768,11342,12749, 9662,10012,33420,34217,32424,32161,36787,36943,
36032,36960,28684,29328,30798,31600,19491,20437,17821,18356,33685,33684,
30807,31433,33399,34356,36258,36257,31612,31416,36015,36767,19976,19975,
17962,17961,33419,34216,31042,31041,36786,36942,36031,36959,28683,29327,
36265,36264,19490,20436,10003,34321,34165,34340,17795,32160,11309,35238,
35956,35937,28636,34183,31582,38466,20424,31397,18329,29293,29532,35383,
30747,36729,33323,33343, 9657,38683,19459,30427,36748,36904,12740,36923,
10002,34320,34164,34339,17794,32423,11308,35382,35955,35936,28635,34182,
31581,38682,20423,31396,18328,29292,29531,35237,30746,36728,33322,33342,
 9656,38465,19458,30305,36747,36903,12739,36922,33683,34319,34163,34338,
17793,31040,19974,33715,35954,35935,33682,34181,31580,36256,31048,31395,
28956,29291,29530,33714,36263,36727,33321,33341,17960,36255,19457,28928,
36746,36902,36262,36921,43340,17624,32997,32995, 7188,40208, 6408,32993,
 7542,39907, 6222,24772,42710,35681,27167,19242,24766,17621,40196,32990,
 7554,27177, 6210,43353, 7200,35678, 6396,42722,35675,35673,39895,19240,
34525,23507,32987, 7309,32975, 7308,24977,23337,17054,17288,23183,40340,
24975,23336,17053,17287,23182,40338,40336,23181,17052,24973,23335,17286,
38810,32821,40605,39392,25222,38772,40603,39389,25224,32726,38771,32725,
40601,40599,23180,39383,17051,39386,25220,25218,23334,24199,17285,24192,
25279,25281,38770,38769,38961,32820,32724,32723,38959,38809,40652,40654,
38955,38957,41224,17050,25995,23333,41226,23179,25993,17284,23681,23679,
32973,39048,40641,13960,23505,13952,23503,13969,23500,23498,39722,23496,
39746,23493,39745,40067,31682,40070,31685,40072,31687,40066,31681,40065,
31680,40055,31673,39721, 9923,39744, 9934,39743, 9933,16510,32971, 2826,
28343, 2824,40334,40332,40331,40329,40327,40325,40323,40321, 6294,22565,
16042, 6271,22626,16092, 4266,22625,16091,10919,19223, 6624,10911,24964,
 7087,19217,24960, 5724, 2709, 3037, 3181, 4265,22622,16089, 4298,22620,
16087, 7349,21949,15271, 7347,21947,15269, 7345,21945,15267, 3206, 5752,
10899,17800,34171,33121,33125,36735,34327,33348,31403,18344,31385,19450,
34346,35961,30552,19305,31588,17694,29538,33328,28443,17811,36910,20413,
29315,35942,29299,34189,36929,35807,35803,19464,36754,17799,34170,33120,
33124,36734,34326,33347,31402,18343,31384,19449,34345,35960,30551,19304,
31587,17693,29537,33327,28442,17810,36909,20412,29314,35941,29298,34188,
36928,35806,35802,19463,36753,18636,34169,33119,33123,36733,34325,34794,
31401,18342,31383,20999,34344,37946,30550,19303,31586,17692,29536,34963,
28441,18583,36908,20411,29313,37549,29297,34187,36927,35805,35801,21107,
36752,34520,23692,17727,34206,33644,33630,36773,34362,33170,31439,18362,
31423,19328,34379,35834,30989,19765,31619,17917,29553,33166,28915,17723,
36949,20442,29350,35830,29333,34222,36965,36227,36190,19324,36793,17726,
34205,33423,33403,37945,34793,33169,31860,18635,31422,19327,34378,35833,
30811,19494,31618,17825,29552,33165,28687,17722,36948,21106,29349,35829,
29830,34962,37548,36019,36035,19323,36792,17725,34204,34961,34792,36772,
34361,33168,31438,18361,31421,19326,34377,35832,31859,21105,31617,18634,
29551,33164,29829,17721,36947,20441,29348,35828,29332,34221,36964,37944,
37547,19322,36791,17719,33381,33643,33629,36226,33162,30988,17916,30773,
19320,35826,19764,28659,28914,35998,36189,17718,33380,33494,33506,37943,
34791,33161,31858,18633,30772,19319,33379,35825,30915,19588,30771,17875,
28658,33160,28758,17717,35997,21104,28657,35824,29828,34960,37546,36106,
36096,19318,35996,34201,17619,33398,33418,34790,37942,31857,32969,31415,
18632,34374,19209,30806,35662,31611,19489,29548,17820,28682,32964,36941,
17615,29345,21103,29827,35647,37538,34959,36030,36014,36785,19204,38965,
38827,38964,38402,38963,38394,30483,30481,30479,30197,30173,30172,37558,
37533,33232,26991,33855,42319,26997,31853,42071,34785,30663,10141,42330,
20996,31185,37937,30659,42076,28539,39558,29067,34954,39683,18580,28536,
13358,39562,37532,24418,29823,36448,39688,35889,24422,37708,37640,36827,
41765,29940,37091,37531,38132,37530,29954,29939,29952,29938,18047,17687,
18179,17690,37648,36442,36300,26727,26710,26725,26709,36053,36296,36454,
 8812, 5812, 8435, 8792, 4905,43814,43311,43002,43286,42582,42845,42928,
42841,17738,17994,17736,17882,37784,37852,36298,36308,42834,26708,42866,
42924,42836,41896, 4061, 5984, 5996, 3392, 6655, 3665, 5991, 2355,11822,
11824,12297,12293,41271,41244, 9823, 9825,28555,30678,23629,25170,28972,
31072,24113,26051,28716,30818,23740,25326,28544,30669,23602,25142, 9678,
 9673,12176,11804, 6292,22567,16044,14145,14590, 2539, 5657,14143,14588,
14164,14610, 2549, 5675, 1621, 5475, 1922, 5500, 3097, 5374, 5384, 3103,
 1927, 5218, 5216, 1912, 5230, 1907, 5228, 1909, 1924, 5240, 1920, 5242,
 5251, 1915,16600,16633,10970,11111,10966,11285,11116,12195,12208,11050,
24332,28819,28826,30947,37995,11048,37653,24461,38605,24787,38432,11046,
28807,30934,11044,43887,43853,43884,43850,43879,43845,43876,43842,14147,
14592,11113,12199,17610,19104,17607,19103,35640,28333, 8578, 8135, 4818,
 4785, 8230, 8669, 8667, 8228, 8584, 8161, 8176, 8596, 8576, 8133, 6923,
 6164,36294, 8790,36293, 6921, 6162, 6901, 6157, 4816, 4783, 8178, 8598,
 6925, 6166, 8586, 8163, 6903, 6159,24751,12788,39418,38649,38634,36069,
38630,37529,39997,39585,40148,40037,40013,40113,39995,39678,40109,39587,
39677,39544,39583,40111,39582,38677,35816,35815,38676,38692,38648,32845,
30554,32330,30665,31742,31199,32322,32317,10868,10865,28325,28322,28318,
28315,18253,11572,11569,37502,37165,35655,35652,35793,36302,36292,18631,
34162,32968,32963,36726,34318,34789,31394,18338,31379,20998,34337,37941,
30485,19208,31579,17614,29529,34958,28341,18582,36901,20407,29309,37537,
29290,34180,36920,35646,35661,21102,36745,18630,18355,32967,32962,31856,
31432,34788,34355,34200,34373,31610,31414,37940,36766,19207,19203,17613,
17618,34957,34215,29547,29344,36784,36940,37536,36958,29826,29326,35645,
35660,21101,20435,18629,17873,32966,32961,31855,30913,34787,33504,33376,
33375,30768,30767,37939,36104,19206,19202,17612,17617,34956,33492,28654,
28653,35993,35992,37535,36094,29825,28756,35644,35659,21100,19586,35799,
 9353, 9466, 9351, 8511, 8467, 9356, 9355,38382,28878,28873,28860,28855,
36282,36277,35797,18255,27821, 2597,18244,18243, 2456, 2596,18258,20185,
18251,18250,18248, 2639,37181,37178,37131,37164,37190,37163,37162,37161,
 2628, 2484,37160,37130,37159,37189,37158,37107,35671,28353,30196,28348,
30171,28352,28351,30211,28330,32980,32985,32978,32983,28346,28350,28329,
32887,32733,36647,36641,39425,39436,39434,17467,17466,17465,11252,11231,
11249,11228,28577,30701,28571,30695,17464,36512,36527,32681,33885, 2803,
29143, 2801,33883, 2815,29141, 2814,17283,36510,23099, 8940,16953, 8939,
24190,24197,17374,36514,23332, 9222,17282, 9221,24186,24195,16899,36509,
17342,36508,16716,36507,23331, 9220,17281, 9219,23513,23515,16898,35774,
16770,35773,35812,32912, 9413, 9412,38826,38825,32843,32842,36520,32749,
36525,32722,36524,32765, 9315, 9314,38768,38767,32721,32720,36523,32902,
36522,32643,11922,11919,17550,32854,17500,32826,17196,32891,17326,32918,
14566,13036,13033,13045, 9827,20640,20632, 5980,21627, 6232,20630, 4294,
28502,30618, 3072, 3390, 3308, 3501, 3294, 3479, 3296, 3485, 3291, 3474,
24393,42188,24390,42185,10400,38621,10397,38618,38600,37957,38597,37954,
 3369, 3053, 2347, 2474, 2341, 2468, 3497, 3306, 3387, 3070, 3372, 3056,
 3462, 3288, 3460, 3286, 3367, 3051, 6898, 5577, 6896, 5575, 6912, 5608,
 3262,38172,27114, 3033,38221,27106, 3031, 2490,38144,27081, 2488, 9523,
38143,27080, 9895, 3361, 3413, 3411, 2340, 2338,19193,20045, 3436,16188,
 7760,16186,16190,16166, 7755,27548, 7979,27546, 7977,27554, 7985,27371,
 7905,27369, 7903,10218,34894,29094,29104,23572,40849,33705,33700, 5477,
 3365, 5504, 2343, 5409, 3495, 5442, 3385, 5436, 3375, 5376, 3454, 5430,
 3363, 5327, 2345, 5283, 2367,32622,30556,30756,31026,32607,30558,30783,
30872,30884, 6085, 1558, 5512, 1532, 5502, 1551, 6098, 1541,16642,32605,
32620,16677,16631,16675,14167,14613,10974,10972, 5387, 3106,12007,12006,
19884,19883,27888,27479,25821,25820,22532,21907,15995,15226,13355,13354,
20992,20991,27887,27478,16175,22682, 3640,22681, 3639,28006, 3745,36150,
14722,16168,31028,14779,14262, 5486, 3092,14788,14271, 5514, 2300,14739,
14218, 5444, 3337, 3130, 5407,14202,14718, 3108, 5389,14190,14695, 3105,
 5386,14188,14693,14733,14211, 5433, 3328, 3090, 5367,14184,14674, 2302,
 5285,14115,14519, 2320, 5325,14137,14582,10976,10978, 2315, 5308,14118,
14556,12287,16679,12187,12185,12167,12213,12211,12145,12210,12220,12171,
12005,19882,25918,25819,19938,12144,13353,20990,25795,12218,12143,11787,
16647,11802,11800,11791,11789,12169,12012,11287,12142,12004,11785,11783,
32625,32624,16645,11772,16644,11535,11333,11771,11770,11769,11768,37781,
39432,42704,17745,19044,28513,30325,30629,32526,33196,35580,33861,33845,
31191,31174,35858,38269,11123,14378, 9612,10668,33200,35471,29073,29078,
36461,36466,35854,38050,28508,30067,30634,32209,19344,21619,17744,37488,
28512,29885,30628,32037,33195,35064,33860,33844,31190,37929,35857,37722,
11122,29816, 9611,31846,33199,34888,29072,34947,36460,36465,35853,38020,
28507,29935,30633,31908,19343,34770,42124,18618,28511,29884,30627,39579,
33194,35063,33859,39542,31189,31173,41965,37721,26764,13467,24372,10194,
39541,34887,29071,29077,36459,41964,35852,38019,28506,42123,30632,31907,
39578,21065,35579,33450,33204,33209,10667, 9684,21618,19515,32208,30827,
35470,33443,30642,30638,32525,30834,30066,28710,28516,28521,38268,36059,
30324,28721,19043,17834,14377,11391,35867,35863,38049,36048,35019,33449,
33203,33208,31845, 9683,34769,19514,31883,30826,34831,33442,37928,30637,
31978,30833,29910,28709,34946,28520,37607,36058,29852,28720,37487,17833,
29815,11390,35866,35862,37969,36047,35018,33448,39540,33207,10162,24371,
21045,39577,31882,30825,34830,39539,30641,30636,39576,30832,42122,28708,
28515,28519,37606,41963,29851,28719,18603,42121,13429,26763,41962,35861,
37968,36046,18009,35174,33220,33214,31080,10542,33735,21858, 9872,32383,
19996,35352,36326,30647,19350,32119,17751,30422,33746,28526,18003,38449,
12303,30287,36336,18945,28983,15177,35873,35878,19987,38640,18008,35578,
33219,33213,31079,10666,33734,21857, 9871,32382,19995,35469,36325,30646,
19349,32524,17750,30421,33745,28525,18002,38448,12302,30323,36335,19042,
28982,15176,35872,35877,19986,38639,18007,35173,33218,39538,31078,10541,
39575,21856,24379,32381,39537,35351,36324,30645,19348,39574,17749,42120,
33744,28524,41961,38447,26910,30286,42119,18944,28981,15175,35871,41960,
19985,38638,18006,35172,33217,33212,31077,31844,33733,34768, 9870,32380,
19994,35350,36323,37927,19347,32118,17748,30420,33743,34945,18001,38446,
12301,30285,36334,37486,28980,29814,35870,35876,19984,38637,35881,43188,
19019,43115,19000,43043,18937,42904,19125,40860,41464,40864,41531,40856,
41497,27449,27858,26485,26484,18893,35399,18905,18871,36637, 8640,43490,
 8638, 8636, 8632,43488, 8630,27913, 6309,27643, 6199,27650, 6201,27648,
27317,15071,21781,27319,36291,30114,30113,18035,18034,18843,27630, 6194,
27198,26411,27628,27627,27626,17953,18752,18873,18877, 6850,14325,14323,
13562,27200,27195,26544,26498,35410,18842,18840, 7945, 4605,36290,29959,
29958,18839,26754,26753,18838,30779,28661,28542,28311,32951,38593,37485,
26198,38808,32719,26208,26206,26210,28413,12590,18544,11602,18501,10103,
18493,11601,18500, 7875, 7873,27185,26532,26483,27409,27411,26491,27792,
26530,26719,26489,26712,12815,27808,26482,27790,27795,27794,26070,27380,
30341,10472,28732,29134,29567,29569,30349,30351,29019,29021,27745,26481,
26480,25346,25339,25355,38807,32718,26068,26073,25349,25351,25348, 2714,
26479,25856,26478,25855,26477,25854,26067,26078,32125,19191,26065,26076,
26476,26475,26072,26080,26131,26136,32145,10040,37484,37483, 4063, 5977,
22224,15675,18722,38647,38592,36537,38591,26410,26474,26473,26416,26683,
27293,27228,26245,26662,35635,28328,28327,43141, 8634, 3698, 3417,43138,
 8621, 3713, 3441, 4213, 6544, 4218, 6524,40309,21826,15119,24933,20136,
12548,31819,24935,29131,37427,37426,37408,38126,37407,24931,24929,17280,
35772,17341,35771, 8954, 8953, 8972, 8971,32782,38780,32780, 9335,38778,
 9333,35811,32911,35810,32910,35809,32909, 9436, 9435, 9450, 9449, 8407,
 8256,38629, 8415, 8264, 8255, 8406, 8263, 8414,35185,30123,35217,30156,
35214,30153,35789,40137,14174,32950,32949,32948,32953,35923,39167,35925,
38697,30195,42782,38646,27407,27788,27787, 8189,35791,12362,12359,11671,
11668, 8208,38343, 8206,38341, 8147,38291, 8145,38289, 8143,38287,10851,
27142,10850,27121,10849,27044, 6334, 1523,11177,11175,15347,23665,25199,
23667,25201,41325,41317,41322,41314,12358,23576,40851,37545,38125,37544,
37543,37541,41764,40304,28309,28308,28307,43105,18991,28306,28304,28884,
35642,42567,41159, 9349,33613, 2854,28895, 2849,33611, 2852,28893, 2847,
13527,26472,11550,36307, 9348,13526,18492,33879,41480,33867,41510,41496,
41445,41530,41535,43810,43282,43307,37913,41501,41463,13758,43028,41495,
43007,41529,12582,18534,26682,12589,18543,33877,41478,33870,41514, 4208,
 6553, 4263,22580,16060,11642,19693, 6603,11623,25597, 7060,19674,25585,
 5684, 2676, 3005, 3140, 4055, 5988, 4207, 6550,20547, 5987,19189,20546,
 9831,13525,20545, 9723,40302,40300,40298,38633,31123,25354,25357,40313,
40315,40312,40311,19187, 2935, 2932, 2975, 2972, 2931, 2389, 2392, 2388,
38391,12812,38367,38390,38360,10845,23489, 9521,23488,23541,23486,10861,
35182,30120,10858,12326,35220,30158,12323, 3320, 3318, 3083, 2317,41305,
27826,27824,27810,30339,28303,30476,21529,28302,30475,21527,28301,30474,
35418,30472,24979,41370,28299,40542,28298,40374,28297,41301,28504,41303,
28296,40378,28295,40389, 9517,22223, 9515,22222,28294,30471,15673,28293,
30470,26087,23485,26085,23484,26089,23634,26143,23482,28291,30468,35840,
25163,24068,33717,30467,33713,31149,36306,36274,36305,33668,36280,36279,
33666,41175,33726,30753, 8805, 9754,35271,35600,11567,11566, 8646,35602,
11561, 8644,40541,43812,40373,43309,40377,40376,43284,40388, 5853,40387,
35409,30466, 8193,35407,30465, 8192,35381,30464, 8184,35379,30463,35570,
30461,43352,28290,30460,27624,28289,30459,28287,30457,39372,30625,39369,
30622,38899,31715,39351,30456,39349,30978,39353,31089,29622,31709,38885,
31720,38884,30455, 8191,38882,30961,39786,30454,31739,35838,35795, 9519,
24942,24946,10856,10860,36345,36353,36344,36355,36343,36351,27406,35181,
30119,35281,30226, 8360, 8356, 8330, 8358,39348,32112,36349,36348,36347,
35184,30122,28764,41298,25054,40688,35240,30453, 8794,35249,30966,28852,
35594,28858,28857,35592,35385,30452, 4903,35397,30969,11554,35412,30451,
24989,41350,37156,36374,38124,38073,32589,11073,42118,18242,16618,38061,
11079,42117,17959,36254,33491,33503,36103,33681,30912,17872,30766,19973,
36261,19585,31039,28755,35991,36093,33703,33698,37155,38123,36373,18241,
37154, 9818,20884,14498,26409,27227,26106,41758,37129,18218,12026,42159,
18240,12035,42116,35785,38881,32098,33691,33693,33689,22218,12043,13218,
10294,10292,12028,30542,30450,30538,30449,31151,30448,31161,30447,31163,
31165,10883,22217, 5329,42155,42974, 8736,42153, 4951,41300,31460,30446,
31458,30544,31450,30445,30548,30444,30546,30443,30850,30442,31129,30441,
31171,30440,31177,31167,35657,35781, 5119, 5121,43484,18837,42822,32959,
28339,32957,28337,10890,10889,35180,30118,10888,35116,30009,32955,28335,
32956,28336,10886,32142,30439,32107,30438,33826,29060,33828,29062,30848,
31159,32105,31158,18239,12112,42115,40294,22797,16335,11611,19666,23481,
11704,19724,23480,11710,19727,23478,11634,19685,23477,11722,19733,23476,
40292,21574,14298,14322,21593,40290,11726,19737,23475,11202,19384,23474,
11677,19713,23473,11674,11673,19710,23534,11205,19387,23472,11208,19390,
23471,11353,19502,23470,11011,19312,23469,11649,19700,23468,12449,20095,
23467,11007,19309,23466,11630,19681,23465,12445,20092,23464,16116,10909,
19216, 6507,10843,19185, 7796, 5508, 1553, 6102, 1544,11201,19383, 7799,
10841,19183, 6769,10917,10916,19222, 6757, 1919, 5507, 5506, 2337,11200,
19382, 7798, 3099, 5379, 5378, 3456,11204,19386, 7743, 3078, 5354,14173,
14650,11010,19311, 6602,10930,19231, 7795,10927,10929,19230, 7724,10926,
19228, 7741, 5302, 2336,11207,19389, 7616,10838,19181,41258,11641,19692,
41257,10836,19179,41256,16649,22930,25272,11033,19314,25535,11323,19482,
25545,11004,19307,25874,11315,19476,25895,12442,20090,25866,11468,19595,
25469,11456,19577,25457,32610,32609,16651,22932,25274,30785,30886,11537,
11335,11325,19484,25547,25471,19597,11470,16682,12289,16681,25058,22939,
16691,12141,11331,16598,30781,11329,11767,11766,11320,19480,25541,12003,
12140,11319,19479,41255,17819,18627,28695,29901,30805,31851,33397,34784,
34199,34372,31609,31413,36013,37935,11341,13776, 9661,10272,33417,34953,
29546,29343,36783,36939,36029,37525,28681,29821,30797,31919,19488,21087,
17818,18651,28694,29922,30804,31892,33396,34847,34198,34371,31608,31412,
36012,37979,11340,13854, 9660,10330,33416,35031,29545,29342,36782,36938,
36028,37619,28680,29861,30796,32001,19487,21199,35953,18354,28693,29561,
30803,31431,33395,34354,34197,34370,35934,31411,36011,36765,28634,12748,
30745,10011,33415,34214,33340,29341,36781,36937,36027,36957,28679,29325,
30795,31599,33320,20434,35951,18353,28692,29560,30802,31430,33394,34353,
34196,34369,35932,31410,36010,36764,28632,12747,30743,10010,33414,34213,
33338,29340,36780,36936,36026,36956,28678,29324,30794,31598,33318,20433,
18163,34524,18170,34539,38973,41703,29442,14761,14765,14758,14451,13068,
10317,20704,13105,42224,24299,30412,43809,43281,43306,38235,27349, 7889,
14291,14320,14307,14275,27292,32314,26432, 8142,38286, 8205,38340,32311,
26426,27542, 7973,24301,30414,29621,31708,38245, 2898,34620, 3233,38243,
 2890,34618, 3225,38241, 2909,34616, 3245, 2476, 2353,29613,31699,38239,
 2333,34614, 2311,38232, 2959,32947, 2997,38230, 2957,33238, 2995,32946,
 2920, 3256,38218,33236, 2918, 3254,38216,32945, 2913, 3249,38211,33141,
 2911, 3247,38209, 3284, 3458,28841,30957,38225, 2952,33595, 2990,32944,
 2906, 3242,38205,33111, 2889, 3224,38171,26471,33619, 2904, 3240,38203,
33617, 2902, 3238,38201,33615, 2900, 3236,38199, 9347,33603, 2896, 3231,
38189,33601, 2888, 3223,38170,33599, 2908, 3244,38207,40288, 5473,19177,
 6077,19175, 6083,40286, 5510,20671,42202,28668,40774,28870,35518,28876,
28875,35516, 3026, 2497,12321,35396,30968,43080, 8776,42253, 4974, 9563,
35780, 9562,35779, 9561,35778, 9560,35777,35621,35776,43187,43525,33087,
28410, 8381,40344, 6063,40349, 5471, 8656, 8665,35769,35619,43193,43529,
24924,24922,19170, 6052,40280, 5460,19169, 6094,40279, 5498,40284, 6048,
40278, 5456,35768, 9554,35767, 9553,42816,42903,33083,28406, 8214, 8219,
42821,42908,35276,30221,10834,40283, 5465,19173, 6057,40282, 5484,19172,
 6072, 4604,35480, 8688,38151, 7004,35486, 8696,38161, 7021,35484, 8694,
38154, 7019,11715,11706,15672,11667,11713,11702,15669,11664,11699,11717,
11708, 5397, 3116,14777,14260, 5481, 3113, 5447, 3389,14741,14220, 5446,
 3339, 5412, 3500, 3132, 5411,14204,14721, 7329,21927,15249, 5494, 2352,
 5372, 3448, 3101, 5382,14186,14691, 2327, 5344,14162,14608, 3077, 5353,
14172,14646,11648,19699, 6601,35482, 8692,38166, 7017, 5392, 3473, 3110,
 5391,14192,14699,23463,43692,43694,24920,38951,22867,16482,33249,28118,
16479,28586,28115,22864,30710,35901,40584,16114,11661,23661,38948,22861,
16476,43690,33246,28112,16473,43689,28583,28109,22858,30707,35898,40581,
25195,23462,43789,43767,24919,23461,43688,43686,24918,16464,28568,30692,
28588,33251,30712,24853,35903,24812,28590,33253,30714,24855,35905,24814,
28576,30700,28575,30699,28574,30698,28594,30718,28593,30717,28592,30716,
23460,26117,23459,26125,25062,24917,25064,24916,23615,26119,23618,26127,
24915,25159,24914,25161,23458,25068,23457,25070,25378,24913,25384,24912,
23580,24911,23578,24910,25380,25086,25386,25084,23456,23455,43698,43696,
43702,43700,24909,24908,23454,28127,23453,28131,28125,24907,28129,24906,
23452,25073,23451,25076,27214,24905,27040,24904,23584,24903,23582,24902,
27216,25090,27042,25088, 9897,23617,27212,23825,27038,23807,25508,25507,
25485,25484,38076,32635,24060,43752,24059,43747,43751,25989,43746,25988,
16663,38064,23708,23707,28163,28162,28160,28159,25277,25276,33688,11488,
11501,33695,11465,19593,41254,23833,23813,24901,25514,24900,25491,25516,
25493,23824,23806,25376,25506,25382,25483,25505,25482,23840,23819,25258,
25524,25255,25501,25521,25498,16662,40650,40648,12139,16661,17475,16660,
17494,16708,32634,16655,11765,16654,16668,16665,17463,25268,22928,16640,
16658,12002,16657,41253,22927,16639,27274,27104, 8615, 2949, 8724, 2967,
24899,24898, 5711, 3168,27087,27257,39591,39593,39778,39780,24897,24896,
25305,41442,41415,24895,24981,41405,41436,24894,40670,21283,13733,25304,
20144,12556,40669,23178,17049,25303,23330,17279,40668,22082,15459,25302,
21736,14943,40667,22103,15510,25301,21714,14841,31816,38978,12457,20101,
23723,12456,20100,23722,12455,20099,25853,25930,41147,41165,24893,25153,
25151,41527,41493,41518,41484,24892,24891,24985,24983,41512,41476,41523,
41489,24890,24889,29127,37418,38081,38944,38942,25926,25928,41143,41145,
41161,41163,24888,24887,25157,24316,25155,24308,26445,24886,26435,24885,
31153,30573, 8606,27241, 8708,27067,24884,11397,24883,19535, 5633,40721,
 8611,27268, 8716,27098,24882,13815,24881,21327,27278,27119,15862, 8485,
22401, 8532,24880,24879,27266,27096,13813, 5014,21325, 5150,24878,24877,
24305,25080,24314,25078,24876,26430,24875,26443,38381,12808,38372, 9614,
33240,28553,30852,30588,23810,25510,23829,25487,24874,25489,24873,25512,
28730,32109,30590, 8604,27239, 8706,27065,25072,11400,25075,19538,23818,
25523,23839,25500,25257,25497,25254,25520,25114,41379,26145,23677,25211,
24077,36418,36416,36452,21509,20039,35274,30219,12320,35212,30151,33801,
29031,33802,29032,12319,12317,12316,12325,33814,29038,29030,31148,29029,
31147,33804,29034,31169,31146,33818,29042,23805,25504,23823,25481,26115,
25480,26123,25503,25094,40694,30575,35818,25066,41355,14455,13070,10319,
20706,13107,42226,34316,10000,34335,34160,17805,17791,20405,11306,35931,
35950,34178,28631,31377,31577,31392,20421,29288,18326,29307,29527,36724,
30742,33337,33317,18336, 9654,19444,19455,36899,36743,36918,12737,34315,
 9999,34334,34159,17804,17790,20404,11305,35930,35949,34177,28630,31376,
31576,31391,20420,29287,18325,29306,29526,36723,30741,33336,33316,18335,
 9653,19443,19454,36898,36742,36917,12736,34314, 9998,34333,34158,34388,
36806,31455,29578,35929,35948,34387,28629,31375,31575,31644,20419,29577,
18324,29305,29525,36980,30740,33335,33315,29358,31643,36979,34229,36897,
36741,36916,12735,34530,23691,34519,23690,34518,23689,37417,37349,37500,
37481,37567,37337,37555,33628,33624,33374,33373, 9760, 9764,19763,19759,
31002,30998,33638,33642,30765,30764,30983,30987,28913,28909,28652,28651,
36225,36221,28904,28900,17915,17911,11887,11883,35990,35989,36188,36184,
34783,33502,33372,33371,10271, 9735,21086,19584,31918,30877,34952,33490,
30763,30762,31850,30911,29820,28754,28650,28649,37934,36102,29900,28792,
18626,17871,13775,11515,35988,35987,37524,36092,34846,33501,33370,33369,
10329, 9734,21198,19583,32000,30876,35030,33489,30761,30760,31891,30910,
29860,28753,28648,28647,37978,36101,29921,28791,18650,17870,13853,11514,
35986,35985,37618,36091,33500,33499,38464,38679, 9733, 9732,19582,19581,
30875,30874,33488,33487,30759,30758,30909,30908,28752,28751,32408,32159,
36100,36099,28790,28789,17869,17868,11513,11512,35984,35983,36090,36089,
20673,42204,28671,40777,43082, 8778,35236,31145,42255, 4976,12467,15666,
12584,18536,15665,18529,11600,18499,43684,43683,43682,43681,41521,41506,
41487,41472,28106,28105,41520,41486,41505,41471,28104,28103,12588,18542,
35566,30397,17734,29615,31701,29620,31707,11594,11580,11593,11592,13438,
40317,40319, 2675,11660,19708,41252, 6693,40409,12569,20157,40408,40672,
12563,20151,40276,40403,40406,12618,42353,20165,42669,40402,40405,40550,
40548,12621,42356,20168,42672,40274,40272,40554,40552,35279,30224,34631,
29684,40270,43213,40268,43541,40400,40397,24303,34628,29681,40399,43210,
40396,43538,32283,11690, 3331,32281,11697,11696,11695,11694,19722, 2733,
11692,19720, 2731, 6695, 6692,34708,29761,20865,13242,11180,11183,11179,
11182, 2831,15192,39417,31625,18280,19041,29473,30322,31309,32523,34248,
35577,34246,34106,31307,31515,36671,38267,12696,14376, 9964,10665,34104,
35468,29216,29471,36826,36669,36824,38048,29214,30065,31513,32207,20360,
21617,18318,37584,29511,29813,31361,31913,34295,34944,34300,34148,31356,
37965,36713,37480,12727,29846, 9992,31873,34152,34767,29271,34991,36876,
36717,36881,37926,29266,29895,31557,31843,20395,34820,42168,18576,29518,
29812,31369,39620,34308,34943,34307,39550,31368,31564,42011,37479,26800,
13352,24374,10138,39549,34766,29279,29517,36889,42010,36888,37925,29278,
42167,31563,31842,39619,20989,18315,18575,34990,34819,31355,31912,34299,
34942,34294,34151,31360,31556,36716,37478,21142,21022,18640,18594,34147,
34765,29265,29510,36880,36712,36875,37924,29270,29894,37964,37583,20398,
20988,39536,10155,34989,34818,31354,41959,34298,26909,34293,42114,31359,
31555,39573,31872,24378,21021,26908,18593,42113,29845,29264,29509,36879,
39572,36874,24377,29269,39535,37963,37582,41958,13391,39547,10137,34941,
34764,31365,42007,34304,26936,34303,42164,31364,31560,39617,31841,24384,
20987,26935,18574,42163,29811,29275,29514,36885,39616,36884,24383,29274,
39546,37923,37477,42006,13351,38766,32717,41738,39446,26352,38806,41818,
39493,26389,32819,38805,32818,38804,32817,41744,39452,26362,38765,41826,
39501,26397,32716,38764,32715,41740,41820,23329,39495,17278,39448,26391,
26354,23177,24271,17048,24282,41746,41828,23176,39503,17047,39454,26399,
26364,23328,24276,17277,24285,24278,26367,18312,19039,29506,30320,31351,
32521,34285,35575,34290,34140,31346,31552,36705,38265,12724,14374, 9989,
10663,34144,35466,29261,29502,36866,36709,36871,38046,29256,30063,31548,
32205,20392,21615,18311,37476,29505,29843,31350,31955,34284,34987,34289,
34139,31345,37922,36704,37580,12723,29810, 9988,31840,34143,34816,29260,
34940,36865,36708,36870,37961,29255,29907,31547,31870,20391,34763,42112,
18591,29504,29842,31349,39571,34283,34986,34288,39534,31344,31551,41957,
37579,26762,13389,24370,10153,39533,34815,29259,29501,36864,41956,36869,
37960,29254,42111,31546,31869,39570,21019,18310,18590,34939,34762,31348,
31954,34282,34985,34287,34138,31343,31550,36703,37578,21080,20986,18621,
18573,34142,34814,29258,29500,36863,36707,36868,37959,29253,29906,37921,
37475,20390,21018,39491,41816,18351,18625,29558,29899,31428,31849,34351,
34782,34367,34194,31408,31606,36762,37933,12745,13774,10008,10270,34211,
34951,29338,29543,36934,36778,36954,37523,29322,29819,31596,31917,20431,
21085,18350,18649,29557,29920,31427,31890,34350,34845,34366,34193,31407,
31605,36761,37977,12744,13852,10007,10328,34210,35029,29337,29542,36933,
36777,36953,37617,29321,29859,31595,31999,20430,21197,39509,41834,39497,
41822,39416,39422,36636,26312,40618,12761, 9997,34313,34157,34332,17789,
17803,11304,20403,35947,35928,28628,34176,31574,31374,20418,31390,18323,
29286,29524,29304,30739,36722,33314,33334, 9652,18334,19453,19442,36740,
36896,12734,36915, 9996,34312,34156,34331,17788,17802,11303,20402,35946,
35927,28627,34175,31573,31373,20417,31389,18322,29285,29523,29303,30738,
36721,33313,33333, 9651,18333,19452,19441,36739,36895,12733,36914,26314,
40623,12765,40108,39363,34244,18711,34242,34102, 9962,32204,20358,35465,
31511,10662,34100,21614,31305,38045,31303,20356,29212,18278,29210,35574,
36667,19038,29469,14373,18276,38264,12694,30319,36822,36665,36820,22228,
34292,18709,34297,34146, 9991,32202,20394,35463,31554,10660,34150,21612,
31353,38043,31358,20397,29263,18314,29268,35572,36711,19036,29508,14371,
18317,38262,12726,30317,36873,36715,36878,22226,26350,24269,27187,27023,
34349,33623,34365,34192,10006, 9763,20429,19758,31594,30997,34209,33641,
31406,31604,31426,30986,29320,28908,29336,29541,36760,36220,29556,28899,
18349,17910,12743,11882,36932,36776,36952,36183,34348,33627,34364,34191,
10005, 9759,20428,19762,31593,31001,34208,33637,31405,31603,31425,30982,
29319,28912,29335,29540,36759,36224,29555,28903,18348,17914,12742,11886,
36931,36775,36951,36187,34330,18612,34311,34174, 9995,31998,20416,35028,
31572,10327,34155,21196,31388,37616,31372,20401,29302,18332,29284,34844,
36738,18648,29522,13851,18321,37976,12732,29919,36913,36720,36894,21052,
34329,18579,34310,34173, 9994,31916,20415,34950,31571,10269,34154,21084,
31387,37522,31371,20400,29301,18331,29283,34781,36737,18624,29521,13773,
18320,37932,12731,29898,36912,36719,36893,20995,39415,36635,36645,36634,
18150,32346,18876,18918,24312,24295,43680,43679,43678,43677,26441,26422,
24311,28102,24294,28101,28100,26440,28099,26421,29619,31706,35564,30395,
24748,12785,38909,17715,34572,32943,34565,32942,33109,32941,33107,32940,
33462,32939,33464,33255,33791,32938,33839,32937,26996,33854,42329,33231,
 4860,26990, 4869,42075, 4812,31180, 4889,42318,30662,30658,42070,31184,
42110,29066,28535,28538, 4851,41955, 4868,29084, 4811,42109, 4886,26761,
41954,35888,26760,36447,33841,33229, 6909, 6154,33836,33460,36639,34574,
33128,35369,32936,35343,32935,35345,33257, 4929, 4853, 4801, 8174, 8594,
26661,35341,33835,20883, 4403,27646,33832,36456,29081,34567,33172,36633,
33793,33174,35371,33176,20032, 6170,31135, 7934,31122,21877,36400,15196,
38669,38458,32136,32394,36405, 8854,12314, 8759,21876, 7933,32393,31121,
38668,12313,36399,36404,32135, 8758,15195, 8853,38457,31134,20031, 7031,
27226,35360,33777, 6907, 6152,27545, 7976,27376, 7910,25374, 5783,40720,
 5590,40719,27247, 8608,27078, 8710,11395,25577,19533,25579,25372,34570,
33459,36372,38122,40107,18793,26105,38657, 5299, 6951, 5277, 6942, 5207,
35783,36420,35787,36422,35213,30152,35211,30150,35122,30023, 8388, 8378,
 8328,24307, 8365,36415,36414,35216,30155,26359,24273, 8422, 8428, 5279,
 6944, 5209,32415,39946, 7623, 5315,32412,39943, 7620, 5312,18875,32509,
16150, 2984,35426,30960,32517,16139,30869,11425,25477,25461,30880,11462,
30866,11422,39427,30599,35836,36440,36444,10217,34885,14438,42333,10393,
20892,14503,42335,10413,20894,10266,34883,20882, 5976,26660, 7452,40393,
22765,40392,42558,17686,24994,24996,38675,37474,26104,38673,37292,41297,
41296, 5257,41295,42384,35378,31144, 7315,41309,22694,41308,42557,18046,
26133,26138,42926,17689,25000,24998,26707,26706,11659,19707,23731,16164,
22675, 3628,22673, 3626,27999, 3736,16172,22678, 3635,22677, 3634,28001,
 3741,36160,14714,11656,36158,14704,11128,11130,11151,11166,11150,11165,
18238,11137,11136,11156,11171,11139,11158,11173,43676,43675,40426,40422,
23861,43674,43673,25549,11054,28809,30936,11052,11058,24334,28821,28828,
30949,37997,11056,37655,19527,24456,19529,24467,17847,28737,30847,28736,
30846,17852,24463,38607,24789,38434,22436,24452,22433,24449,18761,32104,
30104,18766, 9511,24629,23450,22216,19145,21808, 9502,24823, 9509,24627,
 9506,24624,23447,22213,10827,22210,19142,10825,27623,21805, 9499,24821,
12241,24413,11978,11977,24351,37674,12240,38014,12239,24346,11976,11975,
24408,38009,12238,37669,36177,23963,36172,23958,34838,10321,34735,29788,
34724,29777,29106,29096,34761,10289,12275,18486,39272,17971,34802,10265,
12256,24403,12237,12236,24341,37664,12254,38004,12252,24339,12235,12234,
24401,38002,12250,37662,36165,23951,36167,23953,34650,29703,34652,29705,
25917,25916,25915,25914,25913,25912,12270,24399,12269,12268,24337,37660,
12267,38000,36163,23949,34648,29701,39271,39270,39269,39268,39614, 9840,
39611, 9837,39311,39313,15815,18446,15664,18407,25958,25957,39326,39325,
15938,18403,11852,24415,11851,11850,24353,37676,11849,38016,11848,24410,
11847,11846,24348,37671,11845,38011,36179,23965,36174,23960,23948,36162,
34737,29790,34726,29779,23955,36169,25637,25636,25635,25634,39114,39113,
39112,39111,39110,39109,25665,25663,12587,18541,11879,18498,14047,18440,
25702,25701,39166,39165,14090,18402,39108,17936,11844,24405,11843,11842,
24343,37666,11841,38006,34806,10216,34670,29723,34760,10233,11867,24398,
11866,11865,24336,37659,11864,37999,34647,29700,10477, 2940,32467,16149,
32466,16148,22209,30149,27815,22206,30146,27818,21516,30358,29052,42781,
 5262,29055, 5650,32406,39962, 7642, 5292,32403,39959, 7639, 5289,30355,
31454,31143,27276,27113,15961, 8496,22495, 8542,26122,26114, 9817, 9816,
40359,40358,40357,38632,36068,38628,36066,25364, 5587,25362, 5585,27744,
35164,27741,32167,30182,43039, 8749,28286,30437,28285,30436,28557,30676,
23626,25167,28284,30435,15392,38911,22203,15663,28480,30608,28283,30434,
13472,38888,38891, 9556, 9558,32073,17462,28408,30540,28282,30433,28281,
30432,28546,30667,23599,25139,28280,30431,32743,17461,17460,16952,32742,
32889,17532,32841,17492,32823,28445,30560,26002,23327,17046,17276,23175,
41237,32840,32328,32320,26000,23174,17275,17045,23326,41235,16461,22851,
41251,16456,22848,41249,14757,14744,14494,14440,28961,31061,24084,26022,
 9874, 9881,41268,41241,15171,24103,26041,24102,26040,24101,26039,24100,
26038,24099,26037,41261,24098,26036,24096,26034,24095,26033,24094,26032,
28970,31070,24093,26031,17457,14547, 9868, 9879, 9866, 9877,28967,31067,
24111,26049,15173,41263,24108,26046,39341,22202,15662,28964,31064,24106,
26044,28960,31060,24082,26020, 9865, 9876,32852,17456,17548,32851,17455,
32816,32785,32916,17531,17044, 9586, 9584,32333,32325, 9591, 9589, 9595,
 9593,28279,30430,12843,38913,22201,15661,28482,30610,40679,23173,17043,
25319,23325,17274,40677,23324,17273,25317,23172,17042,32839,32327,32319,
13094,11464,19592,25465,14477,13090,14461,13088,11377,11369,28713,30829,
23737,25323,13425,39016,38994,39015,38993,39014,38992,39013,38991,39012,
38990, 9676, 9671,17454,28706,30823,28704,30821,11381,11373,13427,25313,
22200,15660,11379,11371,11376,11368,28703,30820,28278,30429,36332,17990,
14546,14542,14497,14496,22199,15659,17992,36342,13093,13092,22198,15658,
36055, 2866, 2829, 3638, 3744, 3499, 3633, 3740, 3484,11658, 3631, 3738,
 3477,11670,11655, 5719, 3176, 5341, 4133, 4211, 6542, 5449, 3341, 6652,
 3662, 3115, 5396,14196,14706, 3112, 5394,14194,14701,42953, 8732,11657,
19706, 7754, 3118, 5400, 5399, 3481,11676,19712, 7757,11654,19704, 7752,
 5403, 3483, 3120, 5402,14198,14713,27282,27129,15657, 8469,22197, 8525,
25605,25607, 5438, 3330, 5347, 2330, 4205, 6539, 4204, 6536, 4216, 6535,
18237,30015, 5335,42108, 5656,42107, 5334, 4130, 4202, 6534, 9809, 9807,
12024,12022,26008,26705,31206,13483,12498,43672,43671,41432,41401,28098,
41431,41400,28097,12417,12474,37392,41411,10446,37390,41407,43005,41462,
12490,13482,12473,13478,12472, 4325,13891,13909,41113,11025,11027,11024,
41934,41909,41932,41907,41930,41905,43557,43224,41928,41903,25633,26470,
39107,22052,15418,25818,26704,10264,10263,10262,10261, 9791, 9790, 2808,
12838,12830, 2417, 2470, 2512,26469,25852,26468,26467,26466,26465,12840,
41950,41925,41947,41922,41942,41917,41939,41914,15417,22051, 7469,12848,
12847,12835,26703,26702,26701,26700,26699,25611,31367,29516,42166, 4823,
42009, 4867,26799, 4810, 4873,34306,36887,42106,26907,41953,31562,29277,
34302,26934,42162, 4821,42005, 4866,31559, 4809, 4871,31363,29273,42105,
29513,41952,26759,36883,13383,12952,13474,12951,13042,12950,13020,12949,
14487,15161,13350,13349,20985,20984,27892,27483,13348,20983,25782,13347,
20982,25206,12948,12947,20544, 4262,12946,12945,26464,14072,26566,26463,
14046,26580,26462,18439, 4603,14071,13524,14070,18453,18438,17861, 4657,
26461,17863,13626,18471,14057, 4633,13523,14045,22196,21308,39164,39106,
39324,34716,29769,10260,10259,10258,10257,10256,10255,13793,13786,13790,
13783,10254,10253,10252,10251,42104, 9370,42103, 4943,42102, 8891,42101,
 4942,42100, 5521,42099, 4941,42098, 4940,42097, 5861,42096, 5548,42095,
 4939,42094, 4938,42093, 5224,39607, 6179,39604, 6176,39600, 5011,39597,
 5008,32103,30103,11072,11078,12111,13800,13797,39315,12034,12944,13018,
26606,13076,13075,13600,32387,18401,26557,32345,32365,14060,26556,14059,
26555,34072,34074,35363,33779,32386,32385,32344,32363,14015,13566,18400,
18399,32343,32360,41729,41726,14014,13565,32342,31867,18491,10102,13908,
18497,32463,16138,39646,39105,39267,39266,39104, 8395,38401, 6355,41721,
 2806,14942,14940,15509, 2419, 2472, 2515,15507,38567,30014,30070, 6192,
21609,14364,18236,30013, 5520, 4129,14974,15523,13346,13345,13381,13344,
13040,13343,14489,15163,24034,23979,13415,25700,25956,25911,18771,18770,
14056,10057,10087,17950,18452,18437,18457,10079,14044,17955,25910,25632,
25631,30112,25667,14089,14069,15937,24022,15654,15908,17948,18398,18397,
32341,15653,30111,12274,11878,12266,12265,12264,12263,11863,11862,11861,
11860,11840,11839,11838,11837,11836,11835,11834,11833,11974,11973,12233,
12232,11832,11831,11830,11829,12231,12230,11972,11971,12229,12228,12248,
12246,12260,12258,12227,12226,32071,25909,12471,23983,23975,13362,39031,
39034,23974,23973,24018,13370,24017,25987,23323,17041,17272,23171,41218,
41216,23170,17040,25985,23322,17271,16688,16705,41214,41212,41210,43228,
43561,41208,41207,43742,19608,11484,16702,22946,41206,41222,23193,17068,
25991,23345,17302,41220,32632,32631,32629,32628,24058,43750,43745,25983,
24057,43749,43744,25982,16694,16693,16711,11413,41203,43739,19605,11481,
16698,22943,41202,11444,12020,11198,11196, 2533, 5649,11154,11169,19364,
19373,23443,23442,25123,25132,17605,17604, 9495, 9494,11149,11164,19361,
19370,23441,23439,25120,25129,17603,17601, 9493, 9491,11276,19424,25193,
11263,28096,22842,19411,28093,16450,25186,22839,16447,14152,14598,14154,
14600,40573,43670,43669,40565,11273,19421,25190,11260,28090,22836,19408,
28087,16444,25183,22833,16441,40575,40567,11622,11639,19673,19690,23659,
23654,25584,25596,17786,17781, 9645, 9639,40577,40569,11148,11163,19360,
19369,23657,23652,25119,25128,17784,17779, 9643, 9637,11628,11646,19679,
19697,23437,23436,25589,25601,17599,17598, 9489, 9488,25173,21913,15232,
25175,22538,16001,12943,12942,20543,20542,27895,27486,11632,11651,19683,
19702,23644,23642,25591,25603,17769,17767, 9618, 9616,11621,11638,19672,
19689,23435,23433,25583,25595,17597,17595, 9487, 9485,24843,24802,27885,
27476,24840,24799,27882,27473,11280,11267,19428,19415,24847,24806,11243,
11222,11278,11265,19426,19413,24845,24804,11247,11226,11246,11225,11245,
11224, 9633, 9626, 9631, 9624, 9630, 9623, 9629,22193,22192, 9622,11609,
19664, 6702,11613,19668, 6646,11653,10814,19162, 2877,11724,19735, 6704,
11720,19731, 6648,12357,10807,19156, 2750,35666,14645,35664,14654,14724,
11679,19715, 6691,35668,14649,10928,10937,12356,22619, 3566,27955, 3703,
22617, 3564,27953, 3701, 3642, 3747, 3503, 3652, 3754, 3510, 3650, 3752,
 3508,12361,10908,19215, 2747,10907,19214, 2708,10905,19212, 2706,12355,
22624, 3568,27957, 3705, 3648, 3750, 3506,10913,19219, 2711,36153,14644,
 3409, 2351,16161,22670, 3623,22669, 3622,27996, 3733, 3621, 3732, 3472,
36155,14698, 5721, 3178,11637,11620,19688,19671,25594,25582, 6644, 2752,
 7104, 3068, 5757, 3211,22609, 3556,27948, 3691, 3647, 3749, 3505,11625,
19676, 2678,14720,14712,14697,12350,20053, 6708,10920,10912,19224,19218,
24965,24961, 6625, 2710, 7088, 3038, 5725, 3182,14643,11645,11627,19696,
19678,25600,25588, 6598, 2670, 7057, 3002, 5681, 3137,11643,11624,19694,
19675,25598,25586, 6604, 2677, 7061, 3006, 5685, 3141, 6665,11636,11619,
19687,19670,25593,25581, 6597, 2669, 7056, 3001, 5680, 3136, 7420, 8000,
 6079,22010,27569, 1609,15345,28036, 1696,16260,22730, 1661, 5493, 1546,
 6090, 1536,14782,14264, 5488, 3076,11352,19501, 6767,11351,19500, 6759,
 7423, 8002, 6081,22012,27571, 1593,15349,28040, 1694,16262,22732, 1659,
11360,11358, 4196, 6563, 4559, 2510, 5632, 6430, 6983, 5538, 5417, 3315,
 2532, 5648, 6454, 6991, 5552, 7418, 7998, 6076,22006,27567, 1615,15341,
28034, 1703,16258,22728, 1668, 7429, 8005, 6096,22015,27574, 1945,15354,
28043, 2010,16268,22736, 2045,11018, 7431, 8007, 6100,22017,27576, 1943,
15357,28046, 2008,16271,22738, 2043, 7354, 7956, 6008,21954,27522, 3450,
15280,27974, 3718,16127,22646, 3599,11022, 7356, 7958, 6010,21956,27524,
 3452,15282,27977, 3720,16129,22648, 3601, 3219, 5763, 3215, 5759, 3217,
 5761,12345, 7373,21966,15294,12347, 7375, 7969, 6025,21968,27538, 3512,
15296,28009, 3756,16192,22687, 3654, 6020, 3468, 7964, 3728,27533,27992,
 7367, 3617,21962,22665,15290,16157,11605,11607, 6022, 3470, 7966, 3730,
27535,27994, 7369, 3619,21964,22667,15292,16159, 7212, 7880, 5884,21812,
27338, 1956,15096,27654, 2021,15695,22246, 2056,15652, 7176, 7863, 5878,
21771,27307, 1958,15057,27622, 2023,15651,22191, 2058, 5882, 1979, 7878,
 2086,27336,27652, 7210, 2119,21810,22244,15094,15693,15650, 5877, 1981,
 7862, 2088,27306,27621, 7175, 2121,21770,22190,15056,15649, 5903, 1972,
 7898, 2079,27364,27706, 7254, 2112,21835,22345,15128,15791, 5905, 1970,
 7900, 2077,27366,27708, 7256, 2110,21837,22347,15130,15793, 7277, 7914,
 5937,21844,27383, 1947,15150,27748, 2012,15903,22442, 2047, 7279, 7916,
 5939,21846,27385, 1942,15152,27751, 2007,15905,22444, 2042,11579,15682,
15954,15648, 7174, 7861, 5876,21769,27305, 1951,15055,27620, 2016,15647,
22189, 2051, 7225, 7887, 5893,21818,27346, 1941,15107,27681, 2006,15745,
22304, 2041, 5965, 1995, 7927, 2103,27417,27801, 7292, 2136,21871,22489,
15188,15956, 5967, 1997, 7929, 2105,27419,27805, 7295, 2138,21873,22492,
15190,15959,15725,15646, 5875, 1974, 7860, 2081,27304,27619, 7173, 2114,
21768,22188,15054,15645, 5898, 1969, 7893, 2076,27359,27701, 7249, 2109,
21830,22340,15123,15786, 5963, 1993, 7925, 2101,27415,27799, 7290, 2134,
21869,22487,15186,15953, 5975, 2335, 1930, 5492, 3095, 5371, 1929, 5238,
 4396, 6018, 3466, 7962, 3726,27531,27990, 7365, 3615,21960,22663,15288,
16155,15644, 5874, 1989, 7859, 2097,27303,27618, 7172, 2130,21767,22187,
15053,15643, 5896, 1991, 7891, 2099,27357,27699, 7247, 2132,21828,22338,
15121,15784, 5901, 1987, 7896, 2095,27362,27704, 7252, 2128,21833,22343,
15126,15789,40964,40969,11764,11763,12001,12000,19881,19880,27891,27482,
25817,25816,22535,21910,15998,15229,11762,11761,19755,19754,27894,27485,
25630,25629,22537,21912,16000,15231,40905,40903, 9789, 9788,40901,40899,
40897,40896,40966,40971,40909,40907,40895,40894, 6556, 2584,10923,19227,
 7632, 5986, 2350, 6894, 5573, 5343, 2349, 6532, 2574, 6531, 2573,11135,
 5333, 2323, 6530, 2572, 6538, 2576, 6558, 2586, 6548, 2579, 6523, 2567,
 6552, 2581,42955,43330,42965,43372,42963,43370,43386,42977,43388,42979,
43328,42952,27399,27780,18424,10069,27918,27458,27867,27441,27850,27237,
18451,10078,26723,26534,25881,26460,25851,25613,25872,25850,25533,33674,
28935,33476,28743,34646,29699,15642,22186,10387,20541,25975,33672,28932,
25970,25973,25724, 6489, 6488,22185,16713,32639,32637,35179,30117,23822,
35131,30072,15714,22269,15641,22184,15819,22373,15848,22391,12098,15640,
22183,22249,16565,32569,32571, 9719,33478,28745,23832,25719,25969,25718,
34680,29733,14043,18436,14466,14392,25879,25878,39323,17980,39257,17970,
39317,17978,26434,29669,40064,43549,26428,39091,17935,39163,17943,39090,
17934,39625,18600,34033,34028,34031,32368,15883,33670,28930,41658,41677,
41679,39052,40789,10443,20697,10475,20687, 6684, 6686,10479,20540, 6681,
 6680,18396,10056,14100,18395,32340,15639,21550,16438,32542,32541,22717,
16437,32540,32539,15638,22182,35542,14642, 7787, 7786,10643,19009,10642,
24512,19008,24672,12068,19901,24016, 6774, 6773,15637,22181,34007,34006,
41647,41646,27847,27438,26554, 9787, 9786, 9785, 9784,43226,43559,43555,
43222,25849,25610,26004,26007,15109,14390,26698,25609,10775,34837,15977,
15208,22514,21889,27846,27437,15976,15207,27398,27397,21864,21863,22513,
21888,27779,27778,15181,15180,27845,27436,22476,22475,15944,15943,24033,
24032,23978,23977,27844,27435,22564,22563,16041,16040,27843,27434,21895,
21894,15214,15213,27842,27433,22520,22519,15983,15982,15206,21887,15205,
27865,21886,27456,27841,27432,21015,21014,13387,13386,27840,27431,20628,
20627,13030,13029,15204,21885,25773,12104,12103,11744,11743,12094,12096,
10779,34810, 9700,23972,23971,27861,27452,20981,20980,13342,13341,11739,
11738, 7942, 7940,10724,10721,23970,23969,23982,24015,23968,23967,24014,
23981,24013,24025,24027,24012,12070,27864,27455,22512,22511,15975,15974,
27863,27454,20636,20634,13035,13032,24511,24671,19132,19131,10760,10759,
10732,10735,24516,24676,19106,19108,10731,10734,24510,24670,19113,19112,
10741,10740,24509,24669,19062,19061,10684,10683,10781,34759,15212,21893,
25753, 7947,10429,10571,18816,18957,24508,24668,10426,10568,24505,18813,
18954,24665,27870,27461,21901,21898,15220,15217,27873,27464,22526,22523,
15989,15986,10439,10588,18828,18964,24526,24686,10437,10586,24524,18826,
18962,24684,11737,11736,11945,11944,10596,10595,11735,11734, 9849, 9848,
12067,12066,14142,14587, 9783, 9782,12065,12063,19900,19898,25848,25846,
24011,24009,17969,17967, 9847, 9845,27876,27467,20539,20538,12941,12940,
15223,21904,25776,12061,12060,14139,14584,12117,12115,19916,19914,25887,
25885,24044,24042,17976,17974, 9858, 9856,11432,19557,25411,28147,22914,
16602,41080,11934,19847,25742,28084,22830,16436,12222,12284,16672,12217,
12215,41025,43668,11931,19844,25739,28081,22827,16433,11412,41027,11312,
19473,25900,25247,19933,12130,41029,11109,19341,25898,25106,19931,12128,
12154,19940,25920,28156,22923,16635,12183,19958,25945,25943,19956,12181,
12158,19944,25924,25951,19964,12197,11798,19788,25675,25673,19786,11796,
11776,19772,25641,25639,19770,11774,24992,20537,12939,12938,20536,25208,
12059,11760,19753,25628,25627,19752,11759,11818,19804,25696,25688,19797,
11808,11820,19806,25698,25690,19799,11810,40597,40758,40595,40594,11733,
11449,11453,19574,25452,28145,22912,16597,12058,11816,19802,25694,25686,
19795,11806,40639,41075,40637,11758,16629,11108,12193,11999,19879,25908,
25815,19937,12138,12206,12205,12038,11757,19751,25785,25626,19870,11960,
12937,20535,25784,25002,20534,12936,12057,43728,43725,32603,11411,19550,
25402,28149,22917,16605,23999,25793,23996,25790,11938,19851,24003,11913,
11936,19849,24001,11917,11916,11915,12045,12042,13120,15165,12156,19942,
25922,25823,19886,12009,12122,19926,25891,25643,19774,11778,12125,19928,
25893,25625,19750,11756,11815,32602,30882,43667,40537,12120,19924,25889,
25693,19801,11814,11107,12033,12192,19962,25949,28154,22921,16628,12191,
19961,25948,12190,19960,25947,25839,19892,12032,12296,19991,26015,12292,
27396,21862,19981,27777,15179,26011,22474,15942,15399,12056,12846,12547,
17076,15466,12055,15522,39256,39255,39254,39253,39252,39251,39263,39265,
39250,39249,39248,39247,41047,41046,41059,41061,41051,41045,41043,41042,
41041,41040,41039,41038,41037,41036,41035,25752,22562,16039,25751,22518,
15981,25750,21013,13385,25749,20626,13028,13044,20642,25772,11943,12102,
11742,12092,41054,41053,41056,12137,41034,14685,12136,11996,25761,20979,
13340,11732,12162,25907,17091,15471,15526,39246,19972,12273,12354,17039,
15458,15506,25771,22510,15973,24007,19896,12053,12090,24029,19903,12089,
24006,19895,12052,24005,19894,12051,15407,12851,41065,41064,41063,41070,
41068,41049,12119,41032,25779,22529,15992,11924,12041,41078,41073,11731,
11311,19472,25246,28144,22911,16596,12050,25764,20533,12935,12049,12100,
19908,25863,12189,12110,11106,19340,25105,28153,22920,16627,12109,19912,
25883,12262,11859,17316,14861,11730,14973,14817,11729,12834,12408,39101,
39103,39089,39088,39087,39086,39093,39095,39085,39084,39125,39121,39124,
39120,40887,40886,40885,40884,40883,40882,40927,40893,40881,40880,40879,
11755,40878,14710,14683,11754,11753,25624,25623,14807,12832,39083,20489,
12859,39082,20052,12349,39081,21547,14236,39080,39079,43776,43805,39078,
40447,43732,17270,14840,14939,17396,14901,15027,12225,12244,40915,40914,
40913, 9781, 9780,11077,40876,40925,40891,40889,40936,40934,39151,39147,
39150,39146,11813,11812,40932,40930,40938,14394,11970,12224,40944,40943,
40942,11828,11827,40940,11826,40911,40947,39308,39307,39140,39139,11752,
19749,25622,25621,19748,11751,14389,39077,39076, 9722, 9721,12135,19936,
25814,25906,19878,11995,12934,13377,12967,13339,39117,39116,39149,39145,
39154,39153, 9830, 9829,13375,12933,13338,12970,40737,40739,40734,17453,
16185,16111,14676,12161,12134,12133,19935,25905,25813,19877,11994,12179,
11794,11750,11749,16595,11439,11438,19567,25441,15755,17269,15754,15753,
25531,25446,25408,19555,11420,25620,26459,25475,25474,25473,19599,11474,
25445,25444,19570,11442,25406,19553,11418,25399,19547,11408,16959,17482,
13265,13337,15636,39056,22178,15634,28773,30900,39099,39097,39119,39123,
39075,39074, 9703, 9705,17452,28766,30894,28763,30892,28762,30891,12175,
19951,25937,25837,19890,12018,40756,16626,11529,39135,39137,14641,11793,
19784,25671,11748,19747,25619,12932,20532,25424,12048,11528,11522,11747,
19746,25618,11780,19776,25645,12178,19954,25941,11436,19565,25426,11993,
11992,19876,19875,27860,27451,25812,25811,22516,21891,15979,15210,25844,
30888,11476,30863,11415,25810,12017,12016,19889,19888,27839,27430,25836,
25835,22509,21884,15972,15203,25834,25940,19953,25939,19544,25396,25395,
25617,19745,25616,19562,25420,25418,25647,19778,25649,19560,25416,25414,
25670,19783,25669,19543,25394,25393,34715,29768, 1823, 1805,12576,24366,
 1065, 1012,24432,38030,12599,37738,35076,34899,38032,37740,24173,22266,
24434,21419,27315,26681,20922,13278,20920,13276,29112,20926,13281, 1859,
 1842, 1150, 1140, 9932,39742, 9931,39741,24819,39740,34742,29795,13907,
18540, 1482, 1476,12573,24363,12596,37734, 1062, 1009,24428,38026,12611,
42344,12595,37733,35078,34901,38034,37742,24175,22274,24436,21423, 9930,
39739, 9929,39738, 9926,39729, 9925,39728,24831,39727,29130,37421,29129,
37420,29099,29109, 1469,36495,37425,37424,37423,12586,18539,12624,42360,
20171,42676, 1479, 1473,12626,20173,42362, 1481,42678, 1475, 8054, 9922,
39720,29125,37415,38037, 1149, 1139, 1152, 1142,12620,20167,42355, 1145,
42671, 1135,35453,39526,38500,38702,24594,22314,41882,29647,27291,27290,
27617,27314,27289,12795,30387,38366,30408,38358,38363,38365, 2930,38357,
 2387,37255,29642,37254,29641,37253,29640,19022,43201,30416,38370,27663,
37246,36144,37245,38299,40063,31679,40062,31678,31738,31737,31705,35446,
31723,24604,15633,41888,29654, 8044,31735,38376, 2386,35443,31719,35442,
31718,32516,16284,32479,16283,35456,39528,38504,38704,24596,22316,41884,
29649,24601,29658,41890,15385,37241,37244, 1421,40058,31676,40057,31675,
38385,12811,24756,12793,29602,30390,38389,38388,29600,29596,29618,31704,
34636, 1433,29689, 1438,43219,43551,24599,29653,41887,15383,24598,29652,
41886,15382, 1285, 1418, 8050,38379,12806,24754,12791,24750,12787,38378,
38384,12810,38375,38387, 1306, 1294, 1303, 1291,29617,31703,29612,31698,
34634, 1429,29687, 1436,43217,43548,34630, 1300,29683, 1288,43212,43540,
30964, 3798, 3778, 3800, 3780,35425,30959,32462,16137,32461,16136,36652,
34579,34586,36650,34577,34584,34085,29464,31470,29585,31656,31506,29370,
29462,31468,29583,31654,31504,29368,36644,21875, 7932,32392, 5254,31444,
20450,38667,12312,36398,36403,31443,31624,36800, 8757,12755, 8518,15194,
 8852,38456, 8493,31120,31133,36972,36799,36971,12754,32134,20030,31623,
 6169,20449, 7030, 8702, 8337,38763, 9313,41293, 8934,36480, 8701,43062,
 8761,18031, 8593, 8173,38803,36371,36370,36369,18030,18029,18028,27225,
41287,29017,38339, 8204,38308, 8169,34386,32391,34385,34228,31132, 7931,
33774, 8517,31642, 8756,34227, 5253,36397,31641,38666,35366,35201,38455,
33771,29576,36805, 6168,29575, 8492,36402, 8851,29015, 7029,36978,36804,
36977,30301, 8061,41292, 7297,38121,38120,36368,18792,38119,36491,38118,
38117,38116,31119,31118,41283,18027,41285,18033,27911,27641,42858,42857,
26103,35204, 5619,36383, 5616,36380,24771, 7553,40207, 6407,31301,24617,
34240,40205,34238,34098,31299,39906,36663, 7199,39905, 6221,43351, 7551,
34096, 6406,29208,43349,36818,36661,36816,42721,29206,27330,42720, 7197,
27172, 6220,24769, 7550,40204, 6404,31297,24616,34236,40203,34234,34094,
31295,39903,36659, 7196,39901, 6218,43348, 7549,34092, 6402,29204,43347,
36814,36657,36812,42718,29202,27329,42716, 7195,27170, 6216,34504,30404,
34501,30401,18155,41645, 6885, 6148,41642, 7307,41673,41778,22311,41672,
22818,41641,22547,41640,22332,41639,26348,26380,22545,41668,18159,41675,
38227, 2955,34005, 2993, 2916,38213,34004, 3252, 2894,38183,34025, 3229,
 2887,38169,34020, 3222, 2627, 2643,38824, 9409,41720, 9218,36476, 2626,
41719, 2595, 2647, 2634,23169,18235,22102,18234,18217,21766,22081,18233,
37188,18232,18231,18230,18216,21765,21923,18229,18215,36632,14274,35340,
34569,20455, 2653,31640,31453,36976,12760,36803, 2617, 8060, 8540, 8244,
38393, 6849,41718, 6440, 2625,36148, 8149,38297,41717, 3792,18228,18227,
 6920, 6161,18226,18225,18224,18223,21921,18222,18221,41757,26415,41756,
26414,20448, 2591,31622,31442,36970,12753,36798, 2464,18210,26408,26407,
41754,34549,35325,41666, 7314,41665,41776,22693,41664, 6432,42556,18178,
26697,26356,26393,34087,38762, 9312,41711, 8933,36479, 2483,41710, 2455,
38802,37153,37152,37151,18209,18208,21763,18207,29565,21760,37224, 2557,
18220,37221, 2554,36643,20333,36602,39439,31285,36604,39484,24264,40237,
40132,40235,40130,39442,31290,36609,41735,39478,24258,40093,40186,40088,
40181,18143,34398,34435,37029,20279,36994,18145,34400,34437,37031,20281,
36996,39483,24263,39482,24262,39486,24266,40091,40184,40086,40179,40083,
40176,40081,40174,40241,40136,40239,40134,34758,10627,34757,10559,39303,
39305,34812,10557,37291,38086,37290,38094,37289,38080,38614,37288,38662,
37287,38664,37301,38656,37473,38655,30133,20531,10622,20530,10525,18394,
10055,18422,10067,18393,10054,26458,26696,10410,13522,15751,22319,25877,
34645,29698,34644,29697,34660,29713,38660,37435,37440,34753,29806,34751,
29804,34672,29725,34643,29696,34642,29695,34656,29709,34662,29715,34730,
29783,34732,29785,34677,29730,34641,29694,34640,29693,34667,29720,34666,
29719,37327,38096,20808,13191,18392,18391,10053,20807,20851,13231,18390,
18389,10052,20850,20857,13235,18421,18419,10066,20855,18410,10062,18477,
10096,20791,13179,18409,18412,10061,20790,14025,18388,13571,18387,20836,
13215,18414,18417,10064,20835,13521,18416,34836,10553,34691,29744,13625,
18470,13520,18480,39295,39298,12931,20529,20572,10615,12981,20574,12930,
20528,12929,20527,12928,20526,32453,16108,27288,18450,10077, 5631,37822,
 5630,42452,42565,18490,10101,13290,20941,13178,20789,13214,20834,34706,
29759,34699,29752,13177,18474,20788,20787,18476,10095,13213,18479,20833,
20832,18482,10098,13176,18538,13175,18496,32478,16282,32460,16135,13212,
20831,13174,20786,13220,20838,13190,20806,13230,20849,32339,15631,32362,
15847,32337,15629,39186,39188,15802,22360,25843,39259,39261,15628,22173,
25858,39245,39244,12083,12081,10274,39719,40156,40256,40155,40255,24386,
15813,24636,13407,30271,30269, 6595, 6594,34679,29732,14042,18435, 6251,
 6249,13292,20943,34704,29757,34702,29755,34701,29754,13119,13118,18533,
32482,16287,10342,39718,40154,40254,40153,40253,24396,13488,24439,13440,
30194,30193,34714,29767,38659,37400,37405, 8700,30362,30361,30170,30169,
37413,34739,29792,39737,10247,30192,30191,34741,29794,13117,37729,13629,
42340,24441,13487,24438,13490,39736,10215,39748,10210,39731,10209,39726,
10220,39735,10208,39725,10245,39733,10222,39717,10213,20954,10594,10379,
39764,10378,39763,39762,10528,40246,40143,40245,40142,40220,40105,40219,
40104,18564,10135,20952,13301,18563,18571,10134,20960,10373,39756,18559,
10130,20948,13297,18558,18567,10129,20956,10205,34916,34923,37772,13502,
37765,10203,34914,34921,37770,13500,37763,39761,10377,40172,40079,40170,
40077,40152,40252,40151,40251,39766,10523,40161,40261,40160,40260,40233,
40128,40231,40126,34851, 9960,34232,34090,10334, 1864,21204, 1757,32005,
 1601,35035, 1797,31293,31509,31895,20354,29864,18274,29200,29467,37983,
 1814,29926, 1571,18655, 1742,13858, 1881,36810,36655,37623,12692,34934,
34778,34003, 7306,34002,29395,34001,34498,34011,34508,34000,34497,40229,
34492,41761,34931,34775,41968,34018,34514,40243,34516,42397, 1037,41633,
 1031,41632, 1048,42392, 1022,41635, 1050,42394, 1024,41760,41631, 1046,
42390, 1020,41629, 2954,41628, 2992,41627, 2915,41626, 3251,41650, 2892,
41652, 3227,41656, 2886,41654, 3221,34263, 9979,34254,34121, 9970,  936,
20366,  931,31521,  926,34112,  921,31315,31530,31324,20375,29222,18286,
29231,29479,36686,  916,29488,  911,18294,  906,12712,  901,36842,36677,
36833,12703,34381,31639,34224, 2650,34226, 2616,31621, 2599, 2652,36975,
34384,36802,29572,36797,29574,36969, 2482, 6384,37645,37150,37149,39645,
37635,37644,37632,37148,37147,37146,37145,37144,27910, 2624, 8314, 6262,
41716,37187,38260,37297,37347,42609,32086,38078,37639,34016, 7313,34015,
29397,34014,34512,37090, 2481, 2480, 2630, 2637, 2505, 6421,37518,37128,
37399,37127,37495,37126,37469,37124,37468,37513,37142,37123,37511,37462,
37299,37756,37434,37122,37141,37121,37140,39431,36631,37412,37404,37498,
37494,37472,10043,37461,37460,37467,10039,37458,37457,37647,37138,37137,
37120,37510,37517,37520,37174,37505,37439,29444,37119,37136,37135,37172,
37170,37118,37117, 2641, 2632,39414,26406,26405,27640,42564, 2623,37566,
37286,31638,12764,12757,41733, 2622, 2621,37527,37402,37492,10045,37455,
37454,37465,37185,37508,37437,37184,37183,26413,27645,42561,20297, 2612,
20295, 2610,35114, 2608,35112, 2606,12763,37557,39421,18930,22264,27005,
21417,13951,24817,38564,38257,38562,37452,38560,30007,38068,32735,32711,
38761,32710, 9311,38760, 9310,38072,32709,38071,32901,38070,32764,17268,
23321,24825, 9217,24780, 9216,17267,38060,16897,38059,17340,38058,17530,
38066,27635,27312, 7608,38801,32708,27786,32093,30095,22171,15627,38645,
30126,38644,38643, 5247, 5530,32815,38800,32814, 9381,38799, 9380,38075,
32813,27684,30333,18707,35295,27162,27153,35405,22170,39882,38555,24446,
22351,39919,38609,24465,35332,27193,35291,27160,27150,35403,42950, 8731,
42949, 8730,42948, 8729,42947, 8728,35377,32076,40005, 8482,40002, 8479,
35541,14640,35540,14639,14313,27249,27251,17038,23168,24827, 9024,24782,
 9023,17037,38063,27021,16563,38690,23265,21508,37451,38084,32336,32515,
15626,32520,15625,32511,15677,32508,15624,32529,16280,38571, 5200,32335,
15623,35539,14638,14662,14637,35552,14666, 8626, 8629,14668,14708,18932,
22271,27007,21421,13942,24829,30360,42780,35108,30005, 5647,35143,30085,
 5665,22165,18820, 5605, 5604,35347,32111,32506,15929, 6955, 5331,40061,
43546,42762,18769, 6937, 5272, 6936, 5271, 6935, 5270, 6933, 5268, 5629,
22268, 6939, 5274,22180,22164, 6946, 5281,25809,32240,18748, 8323, 8156,
 8316, 8158, 8320, 8153, 5580,35374,32097,35335,32096,35334,32095,32513,
15882,32367,15881,38759, 9309,43061, 8932,36478, 8059,38798,38115,38114,
38113,18791,18790,18789,30347,37642,37515,37450,38130,37755,38112,38111,
27909,27639,37569,38128, 3646,22685,16184, 6338, 1522,12640,12645,15371,
 6342, 1510,12642,12647,15373, 6782, 6781,14798,21699, 6344,14796,21697,
 6341, 7801, 1555, 7440,12375, 7443, 8012, 6107,22026,27582, 1592,15367,
28052, 1693,16277,22744, 1658, 1489, 7435,12373, 7437, 8010, 6105,22021,
27580, 1940,15362,28050, 2005,16275,22742, 2040, 7442,22025,15366, 7439,
22023,15364, 7426, 1562,12340,12333,12338,12331, 5804, 3214,12342,12335,
 6027, 3514, 7971, 3758,27540,28011, 7377, 3656,21970,22689,15298,16194,
15505,12533,15504,14938,16379,14982,16012,12532, 6752, 1497, 6749, 1494,
41395,41428,41393,41426,41397,41430, 7673, 2785,12396, 3807, 8862,12509,
12436,12393, 5370, 3094,12439,12401, 5365, 3088,14737,14216, 5440, 3335,
 3128, 5405,14200,14716, 3087, 5364,14181,14664, 7871,12398, 4411, 4409,
12435,20087, 6593, 3074, 5351,14171,14636,12448,20094, 6591,12546,15118,
21825, 7236,12545,20135, 6451,12407,12544,12406,12388,12506, 3804, 8859,
12522,12505, 7664, 2776, 7671, 2783, 7717, 2884,41403,41434, 6017, 3465,
 7961, 3725,27530,27989, 7364, 3614,21959,22662,15287,16154,15051,21757,
 7169,12568,20156, 6382,14937,21735, 6848,41461,41460,12427,20084, 2755,
31205,31204,16392,12489,12488,12426, 4417,13481, 2225, 7635, 2415,15621,
 7167, 7858, 5873,21755,27302, 2239,15049,27613, 2245,15620,22163, 2261,
 7304, 7938, 5973,21879,27421, 2241,15198,27830, 2247,15967,22504, 2264,
 7251, 7895, 5900,21832,27361, 2237,15125,27703, 2243,15788,22342, 2257,
16032,12416,20081, 7526,31201,12415,12414,15686,15952, 2667,15619, 7166,
 7857, 5872,21754,27301, 1949,15048,27612, 2014,15618,22162, 2049,12423,
 7223, 7885, 5891,21816,27344, 1939,15105,27679, 2004,15743,22302, 2039,
12404, 7351, 7953, 6005,21951,27517, 3446,15276,27968, 3715,16106,22638,
 3587, 2256,21296,12567,13748,20155, 2235, 2255,21295,12566,13747,20154,
 2234,12560,20148, 6450,41459,15243, 3788,41450,15617,41420,41458,12425,
20083, 2209,31821,12497,12496,15117,21824, 7235,12562,20150, 6449, 2227,
 2223,12487,20114, 4245,12485,20112, 4243,12875,20501, 4242,14245,41418,
41456,12559,20147, 2220, 6016, 3464, 7960, 3724,27529,27988, 7363, 3613,
21958,22661,15286,16153,12500,12432, 7405, 7990, 6044,21993,27559, 1591,
15324,28021, 1692,16231,22715, 1657,15316,41467, 2217,12430, 7400, 7988,
 6042,21988,27557, 1938,15318,28019, 2003,16229,22713, 2038, 7404,21992,
15323, 7402,21990,15321, 1457,21287,12552,13738,20140, 1453,41444,15320,
41469, 1463,15615,15612,16030,12413,20080, 1444,12412,20079, 1443,31824,
31818,12565,20153, 2233,12484,32070,12483,12482,13480,13746,21294, 2254,
12481,20111, 4241,12480,20110, 4240,12492,20116, 6512,12479,20109, 6380,
 2268,22161,15610,15609,22160, 2259,15966,22503, 2263,12420,12419,15685,
22239, 2251,12495,12558,20146, 2219,12554,20142, 1460,15103, 2216,41454,
12422,41409,41438,15245, 3790,41453,11020,40855,30973,11578,11577,11591,
11575,11589, 4564,11583,11582, 2666,11586,11585,12828,12826, 5829, 3832,
12874,12870,20498, 3812,12869,20497, 3811, 3831, 5828, 3830, 5827, 3834,
 5831,12877,12879,12873, 7468,22050,15416, 2531, 5823, 3818, 3836, 3843,
12884,20506, 3875, 3905, 5843, 3898, 5839, 3900, 5841,12888, 7474,22057,
15423,12890, 7476, 8024, 6122,22059,27597, 3926,15425,28070, 3966,16337,
22799, 3955, 6117, 1968, 8021, 2075,27594,28066, 7460, 2108,22041,22773,
15405,16310, 7454, 8017, 6112,22034,27590, 1937,15390,28062, 2002,16302,
22767, 2037, 6115, 1983, 8019, 2091,27592,28064, 7456, 2124,22037,22769,
15401,16306, 7450, 8015, 6110,22032,27588, 1954,15388,28060, 2019,16293,
22756, 2054, 6109, 1977, 8014, 2084,27587,28059, 7449, 2117,22031,22755,
15387,16292,12895, 7488, 8031, 6129,22071,27604, 1590,15438,28077, 1691,
16344,22806, 1656, 3810, 3826, 3829,12893, 7483, 8029, 6127,22066,27602,
 1936,15433,28075, 2001,16342,22804, 2036, 7487,22070,15437, 7485,22068,
15435, 5838, 3897, 3886, 3910, 3915, 3877, 3891, 3902, 3874, 3889, 3896,
 3873, 3888, 3895, 3879, 3893, 3904, 6124, 3932, 8026, 3972,27599,28072,
 7479, 3961,22062,22801,15428,16339, 3884, 3908, 3913, 3809, 3825, 3828,
12865,43305,43632,43303,43630,43300,43627,43299,43626,14287,43298,43625,
43296,43623,14936,21734, 6847,22080,14935,22079,19102,22101,19101,14934,
43294,14933,43621,14932,14931,15462,15475,15457,15456,14956,14950, 6852,
 6846, 6845,15485,14333,14993,14992,14981,15007,15006,15005,15022,15014,
15010,15009,15004,15025,14351,15024,15483,15020,14349,15012, 5524, 1639,
14997,14337,14991,14332,14980,14979,14978,14995,14335,14984, 5519, 1906,
14339,15000,14999,43316,43637,15003,15479,14306,43314,43635,15041,14354,
15040,15493,15044,14356,15043,15495, 6866,14914,21725, 6369,14916,21727,
 6371,12858,20488, 6820,12872,20500, 3817, 3953,22796,16334,12883,20505,
 3872, 3952,22795,16333, 3951,22794,16332, 3865,22785,16323,19032,19100,
38551,19030,19099,38548,30001,29999, 6915, 4625, 4602,35104,29997,15608,
22159,15607,22158,15821,22375, 3127, 3334,35145,30087, 3314, 3325,15606,
27585, 4632,15846,22390,40060,43545, 2385, 2530, 2543,40009,43415, 2964,
38234,30168,30190,40054,43537,30277,23167,19097,40033,43462,38797,32707,
 2929,30189,40458,23320,17266,25101,23166,17036,40446,23349,17310,25097,
23198,17075,38926,38925,38924,38923,39028,39026,38922,38921,38920,38919,
39041,39043,40452,40462,40454,40445,40444,40442,40449,32588,32587,32586,
40456,23339,17294,25099,23187,17062,32922,32788,16896,17339,32594,40441,
16617,25096,16879,23055,40439,16911,23063,40438,40437,23400,17527,16871,
23049,40436,40435,22906,16587,40434,22905,16586,16585,22904,40433,40432,
22903,16584,16868,23046,40465,16590,22909,40464,16609,16607,16594,43731,
43730,40431,40430,39039,39038,39037,39036,16616,38937,38936,39243,39241,
38935,38934,39292,39288,17173,16615,16752,16614,16613,16612,16744,16611,
16789,39239,39238,16852,17211,32900,32763,16623,16621,11076,11075,39237,
39236,39278,39277,39276,39275,11952,19862,25769,25748,19855,11942,32899,
32762,17499,17451,17325,25842,21445,14034,17484,16791,25870,23275,17187,
25841,23273,17185,25876,23263,17165,11948,19858,25763,13414,13413,39216,
39215,39197,39196,39291,39287,12478,12477,13373,13336,13335,13368,12031,
12030,39235,39234,12108,12107,39284,39283,11941,11940,19854,19853,27900,
27491,25747,25746,22542,21917,16005,15236,39233,39232,39203,39201,27879,
27470,27855,27446,27838,27429,25904,25903,25745,25955,25902,18666,42563,
25759,25755,25998,27775,25808,27637,27015,27615,41158,41157,27836,27427,
27049,27611,39207,39211,11951,11950,19861,19860,27835,27426,25768,25767,
22508,21883,15971,15202,25766,11956,11954,19866,19864,27875,27466,25778,
25775,22528,21903,15991,15222,39221,39219,39224,39223,39290,39286,39231,
39230,39281,39280,14930,14929,14847,14954,14316,21588, 3816,14319,21591,
 3882,14318,21590, 2882,14948,14946,14294,21570,  893,14296,21572,  964,
 8262, 8413, 8261, 8412, 8253, 8404, 3081, 5860, 3167, 5859, 3175, 8260,
 8411, 1395, 1411, 1414,21584,14311,14347,21606, 1403,14305,21581, 1409,
14342,21602, 3815, 8259, 8410, 8258, 8409, 8252, 8403, 1406, 1393, 1111,
 1117,14703,14648,14660, 8187, 8350, 3080, 2322, 5710, 3166, 5718, 3174,
11162,11147,19368,19359,25127,25118, 6642, 2749, 7102, 3062, 5755, 3209,
11161,11146,19367,19358,25126,25117, 6623, 2705, 7086, 3036, 5723, 3180,
14635,11168,11153,19372,19363,25131,25122, 6590, 2665, 7054, 2999, 5678,
 3134,11160,11145,19366,19357,25125,25116, 6600, 2674, 7059, 3004, 5683,
 3139,14894,16401,15605,15603,14362,15842,14927,16368,43326,42946,43324,
42944,43321,42941,42939,43319,43255,43588,43263,43596,43262,43595,14473,
21643, 6260,30231,32200,38696,30229,38545,30262,30167,38588,30018,30166,
30012, 3276, 3434,43569,43236,43566,43233,16329,22791, 6234,16050,22573,
 6247, 7829, 7736, 7585, 7869, 7600, 6756, 7794, 7740, 6576,14475, 6583,
 7597, 4175,14479, 4170,15601,22157, 6792,15140,15600,22156, 7261,14360,
 2881, 2805, 5527, 2986, 2945, 2937, 2928, 2927, 2384, 2977,38654,30261,
 8287, 8126, 8281, 8116,  830, 8286, 8125, 8285, 8124,  824,  827, 8303,
 8131, 8302, 8123, 8307, 8101, 8300, 8301, 8120, 8121, 8299, 8119, 8297,
 8118, 8295, 8104, 8292, 8129, 8306, 8103, 8308, 8106,30038,30035,38259,
30315, 8425, 8427,32057,14884,13417,15599,22155, 6511,15656,22195, 7821,
 6331, 6427,15712, 6424, 7414,15705,22257, 6844, 5887, 5799,16243,14926,
21733, 6841,15598,15965, 6473,22154,15597,15868,15596,15840,22386, 6843,
14445, 5911, 5635,14453,14444,14448,15830,15844,22388, 6840, 5913, 5628,
15833,15827,15826,14839, 7575,15595, 2872, 2741,14925,21732, 6839,15594,
22153, 2833,15593,22152, 2835,15592,22151, 2438,15591,22150, 2432, 2664,
15875,22409, 2445, 2717,15589,22148, 7839,16355,16374,15782,22336, 7823,
16357,22809, 7240,16207,22702, 7765,14756,14227,14755,14226,14754,14225,
16218,16217,43513,43174,43510,43171,16224, 6719,21546,14235,16216,22706,
 6725,14763,14230,16220,15588,22147, 7390,15933,22467, 7388,43505,43166,
43502,43163,16209,22704, 7767,15811,22366, 7394,16146,22656, 7387,16145,
 3605,22655,16144,15587,22146, 7231,15855,16035,15854,16034, 2839,15860,
22399, 2838,15859,22398, 7229,15586,22145, 7501,30128,38653,30132,38652,
38681,38651,30131,13334,16069,22590,16078, 6270,22599, 6269,16181,12927,
27932, 6914, 6960, 5414, 8057, 5957, 6506, 6505,18941,18940,10538,10537,
16179,13333,16170,13332,16388,15017, 7588, 6306, 5236, 5811, 5851, 5869,
 6740, 7127, 5798, 6468, 6996, 5564,14405,14018,14404,14017,15770, 6466,
 6994, 5562,14450,14447,15769,15768,15767,16373,22815, 7228,14407,14020,
15772,16122,22643, 7227,14409,14022,14443, 5547, 5223,32069,27917,16038,
22561,16037, 6291,22560, 6288,27915,15874,22408, 4435,15801,22359, 4459,
 6574,22144,15585, 6562,22358,15800, 6582,22406,15872,16011, 5655, 4128,
15584,22143, 4437, 5660, 4093,14634,14633,14632,14631,43483,18998,16048,
22571, 6258,43478,43131,43475,43128, 6707,21367,13906,16183,22684, 4239,
14678, 6689,21336,13835,14680,16124,13331, 5770, 5919,14672,14671, 5768,
 5868, 5766, 5907, 6561, 4189,15911,22448, 6838, 5943, 5627, 6442, 6987,
 5542,15703, 5594, 5416, 5598, 6075, 7011, 7997,28033,27566, 6496, 7417,
22727,22005,16257,15340,15583, 5600, 5867, 7013, 7854,27610,27300, 6498,
 7163,22142,21753,15582,15047, 5945, 5645, 6724, 7116, 5787, 5602, 5947,
 7015, 7918,27754,27388, 6502, 7285,22459,21851,15927,15157, 5597, 5962,
 7010, 7924,27798,27414, 6495, 7289,22486,21868,15951,15185,15455,16352,
15503,16351,16350,15513,22106, 7835,14844,21717, 7820,14886,21720, 7819,
15410,22044, 7818,14825,21708, 7817,14824,21707, 7816,16199,22692, 7815,
14883,14823,43587,43254,43586,43253, 7825, 2663,16362,22811, 1398,16367,
16366,43289,43616,43594,43261, 2414,16372,22814, 1155,16371,22813, 2421,
16359,43280,43613,43252,43585,14838,16365,16364,43278,43611,43275,43608,
43273,43606,43291,43618,15447,38524, 8682,15449,38526, 8684,43271,43604,
43270,43603,43598,43265,43259,43592,16370,43269,43602,43017,43408,15858,
 3596,22642,16121,15857,22397, 2837,14234,21545, 6718, 5782,14743,21688,
 6318,16198,16215,16304,16214,16197,16213,16206,22701, 7764,16205,22700,
 7763, 6717,21544,14233,16291,16212, 5810,43103,43458,40124,14170,40123,
14169,30188,30187,38695,30186,38694,30185,32066,32060,14630,14629,14628,
 3343, 7680,39970,32449, 5425, 7677,39967,32446, 5422, 8440, 8451, 3712,
 3440, 3696, 3415, 3589, 3585, 3711, 3439,14244,43101,43456, 6671,21079,
13519,15581,16237,43099,43454,43111,18997, 3710, 3438,43109,18995,43123,
43470,43120,43467,16101,22636, 3583,15932, 3604,16312,16142,14805, 5765,
 5233,43113,43460,16120, 3595,16119,22641, 3594,16118,22640, 3593,14803,
16047,22570, 3522,16046,22569, 3521, 6706,20785,13173, 6447,21556,14255,
 6445,22725,16252, 6333, 6444,14418,14028,14442,15337, 5596, 6067, 7009,
 7995,28031,27564, 6494, 7412,22724,22003,16251,15336, 6435,21554,14253,
 6438,22722,16249, 6434, 7416,14753,14387, 5540, 6065, 6985, 7993,28029,
27562, 6437, 7410,22721,22001,16248,15334,15301,21973, 7380, 6030, 5803,
 6029, 5775, 6743, 7129, 5801, 6731, 7122, 5793, 6727, 7118, 5789,14760,
 6032, 5777,14746, 7386,21979,15307, 5781, 5452, 6034, 5779, 6723, 7115,
 5786, 5795, 6039, 7124, 7983,28016,27552, 6733, 7396,22710,21984,16226,
15312,14752,14748, 5791, 6037, 7120, 7981,28014,27550, 6729, 7392,22708,
21982,16222,15310,43027,14465,21641, 6257,16327,22789, 6256,32237,15002,
14464,14463, 6589, 6484,21453,14051,16246,14469,14468,15689,15950, 6254,
15580, 5571, 5866, 7001, 7853,27609,27299, 6481, 7162,22141,21752,15579,
15046,14751,14471, 5569, 5889, 6999, 7883,27677,27342, 6479, 7221,22300,
21814,15741,15101,16326,22788, 3938,43577,43244,43574,43241, 6819,21366,
13905, 6818,20784,13172,16331,22793, 4238, 5813, 3987, 6796,21319,13807,
 5817, 4015, 5809, 4012, 6805,20713,13116, 6807, 7147, 5834,20783,26609,
 3845,13171,26853, 3838,13666,21222, 3820, 6790, 7138, 5808,20805,26616,
 1953,13189,26857, 2018,13674,21227, 2053, 5807, 1976, 7137, 2083,26636,
26874, 6789, 2116,20848,21247,13229,13701, 5821, 1967, 7144, 2074,26629,
26867, 6800, 2107,20830,21239,13211,13692, 6794, 7140, 5815,20782,26608,
 1935,13170,26852, 2000,13665,21221, 2035, 5819, 1985, 7142, 2093,26647,
26885, 6798, 2126,20870,21256,13245,13708,16325,22787, 3937, 3940, 3946,
 3921, 3959, 3970, 3930, 3950, 3964, 3924, 3936, 3944, 3919, 3949, 3963,
 3923, 3957, 3968, 3928, 6835, 7154, 5848,20903,26670, 1589,13261,26895,
 1690,13717,21268, 1655, 3935, 3943, 3918, 6830, 7152, 5846,20898,26668,
 1934,13256,26893, 1999,13715,21266, 2034, 6834,20902,13260, 6832,20900,
13258,16315,22777, 3856, 3855, 3861, 3850, 5836, 3848, 7149, 3841,26628,
26866, 6809, 3823,20829,21238,13210,13691, 3934, 3942, 3917,14837,21713,
 6353,22100,14836,14835,14846, 6851,21738,14952, 6837,21731,14924,15502,
15501,15516,15528,15540,14882,15536, 5864, 1638,16378, 5858, 4127, 5857,
 1905, 6854,21740,14967,14881,15534,14878,14906,15544,15546, 6862,21746,
15035, 6864,21748,15037,14867,14908,14897,14891,14888,14899,14875,14880,
16098,16095,22634,22631, 3578, 3575,22629, 3573,27960, 3708,22608, 3555,
27947, 3688,22606, 3553,27945, 3686,40118,14110,30165,38687,30164,32068,
 3274, 3432, 3268, 3426,27965,27963,14626, 5349,27940,35536,14625,35538,
14627,35535,14624,35534,14623, 6664, 6663, 4303,21444,14033, 6560,21443,
14032, 5738, 3196, 2528, 2527, 5644, 7042, 8345, 8183, 2526, 3323, 3317,
 5640, 7038, 6931, 5266, 5641, 7039, 2524, 3313, 7732,39979,32435, 5362,
 7729,39976,32432, 5359,22612, 3559,27951, 3694,22611, 3558,27950, 3693,
 7630,39953,32422, 5322, 7627,39950,32419, 5319,35533,14622,35532,14621,
35531,14620,35545,14653,35530,14619,35544,14652,10716,10713,10708,10705,
35527,14616,35529,14618,10710,10707,10593,10592, 2702, 2690,18867,18855,
10470,10458, 5741, 3199, 7099, 3049,24735,24575, 5733, 3191, 3272, 3430,
 5735, 3193, 5734, 3192, 7096, 3046,24732,24572, 5731, 3189, 7094, 3044,
24730,24570, 5728, 3186, 7091, 3041,24727,24567, 5715, 3172, 7083, 3029,
24724,24564, 3270, 3428, 2700, 2688,18865,18853,10468,10456,43482,18834,
 5709, 3165, 5704, 3161, 5626, 4113, 5855, 4085, 5662, 3986, 5701, 3158,
 5693, 3150, 7077, 3022, 7069, 3014,24716,24556,24708,24548, 6620, 2699,
 6612, 2687,18985,18864,18977,18852,10613,10467,10605,10455, 5697, 3154,
 5689, 3146, 7073, 3018,22604, 7065, 3010,24712,24552, 3551,24704,24544,
 6616, 2694, 6608, 2682,27943,18981,18859,18973,18847, 3684,10609,10462,
10601,10450,22603, 3550,27942, 3683, 2696, 2684,18861,18849,10464,10452,
 5698, 3155, 5690, 3147, 7074, 3019, 7066, 3011,24713,24553,24705,24545,
 6617, 2695, 6609, 2683,18982,18860,18974,18848,10610,10463,10602,10451,
28004, 3126, 3060, 3379, 3125, 3123, 3122, 3333, 3066, 3383, 3065, 3382,
10507,18914,10506, 2875,18913, 2874, 3304, 3493, 3302, 3491, 3301, 3490,
 2746, 2745,18889,18888,10490,10489, 2744, 2743,18887,18886,10488,10487,
14522, 5654, 2538,15766,15765,14397, 8138, 8310, 5559, 5546, 5545, 5222,
 5707, 5221, 5717, 5544, 5220,16422,16417,16419,43666,43661,43664,43659,
43656,43654,43652,43650,43643,43648,43641,43646, 1721, 7573, 1718, 7570,
 7711, 2859, 7706, 2844,16494, 7690, 2800, 7688, 2798, 7687, 2797, 7709,
 2857, 7704, 2842,16484, 7694, 2813,16502, 7685, 2795, 7714, 2864, 7684,
 2794,16491,16490, 7693, 2812, 7683, 2793,16534,16541,16532,16539,16547,
16552,16489,16551,32547,16545,32549,16550,16549,32544,16488,32584,32596,
16580,22899,28140,32583,38724,43714,22901,28142,38722,43712,16582,32581,
16671,16593,16569,16412,16411,16410, 7682, 2792, 7692, 2811,16524,16526,
16408,16407,16430,16406,16509,16506, 3645,22871,16497,16427,16426,22823,
 4558,16425,22822, 4556,16592,16500,16511,16465,16469,16467, 7701, 2822,
 7699, 2820, 7697, 2818,16504,16951,23098, 8930,32714,16751,16750, 4324,
16746,32898,32761, 9180,23289,17210, 6722,23032,16851,17209,23288, 9179,
17215,23293, 9187,16839,16989, 6471,23037,16857,16836,16987,16831,16984,
43775,43804, 4361, 9178,17191,23279, 9156,17164,23262, 9137,17189,23277,
 9154,16785,17184,23272, 9152,17183,23271, 9151,17163,23261, 9136,16793,
17260,23314, 9210,17259,23313, 9209,17258,17257,17256,17540,17520,16895,
16894,17384,16916,17373,17084,23204, 9040,17546, 4126, 8890, 8929,23097,
16950,16949,23096, 8928,16948,23095, 8927,16947,43871,43830,43869,43828,
17472, 6376,22977,16757,16765,22969, 7161,17449,16799,17459,32713,16749,
16748,17470,17447, 8952, 8951,16830,23015, 7448,16850,23031, 6788,32760,
17208,23287, 9177, 8970, 8969,16809,22996, 4555,16808,22995, 6317,16849,
23030, 7159,16829,23014, 6374,16848,23029, 7446,16828,23013, 6786,17207,
23286, 9176,16782,16847,23028, 7215,16827,23012, 6419,16779,17480,32732,
32754,32731,16784,17182,16768, 9189,43807,43778, 4268,17176,17161,43867,
43826,17160,43865,43824, 9208,23312,17030,17255,23160, 9017, 9207,23311,
17029,17254,23159, 9016, 9226,23343,17066,17298,23191, 9030,17028,17253,
 9206,23310,17252, 9205,23309,17251,17027,23158, 9015,17250,23308, 9204,
17026,23157, 9014,17249,23307, 9203,17248,23306, 9202,17025,23156, 9013,
17247,16867,17519,16893,16892,16891,16890,16902,16865,23045, 6470,16873,
16870,23048, 6378, 6190,23395,17522,16864,23044, 4525,16883,23059, 4509,
16914,23065, 4508, 9201,23305,17246, 9249,23355,17360,17420,23377, 9272,
17138,23241, 9091, 5871, 7856, 7524, 7165, 8042, 6140,16927,17143,23076,
23246, 7522, 9096,28180,28208, 8040, 9120, 6138, 8876,17436,23391, 9286,
17592,28242, 9307,23430,28276, 8912, 7520, 8038, 6136,17136,23239, 9089,
17430,23386, 9281,17586,28237, 9302,23425,28271, 8907, 7518, 8036, 6134,
 9269,23374,16924,17140,17417,23073,23243, 7516, 9093,28177,28205, 8034,
 9117, 6132, 8873,17372,16889, 9229,23348,17074,17309,23197, 9034,17073,
23196, 9033,16881,23057, 4517,16670,16574,22893,28134,32575,38716,43706,
22895,28136,38718,43708,16576,32577,32601,16573,22892,28133,16625,22919,
28152,16946,23094, 8925,16945,23093, 8924,38796,32704,17444,17443,17498,
17477,17504,17488,17490,17442,17441,16795, 3581,22981,16775,16774,22980,
 4507, 3580,23011,16826, 8943,23102,17179,16957,23268, 9147,32748,32893,
 3864,22994,16807,16806,22993, 4539, 2179,23010,16825,17509,16846,23027,
 2193, 2184,23020,16838,16855,23035, 2197, 2182,23018,16834,16811,22998,
 4506,16813,23000, 4524,16982,16819,43800,43771, 9166, 1673, 9200,23304,
17024,17245,23155, 9012, 9228,23347,17072,17308,23195, 9032, 9224,23341,
17064,17296,23189, 9028,32759,32897,17214,23292, 9186,17206,23285, 9175,
 3948,23026,16845, 3644,23025,16844,43803,43774, 9174, 2192,17159,23260,
 9135, 9134,23259,17158,17440,17514,17512,16860,23040, 2191,17000,23134,
 8995,16998,23132, 8993, 3591,23024,16843,17222,16994, 9192,23296,17218,
 9194,23298,17220,17507,16992,23127, 8987,16862,23042, 1328,23154,17244,
17023,17474,17243,17022,17497,17021,17486,17439,17496,17057,17093,17020,
17019,17117,17352,17371,17370,17376,17369,17390,17379,17392,17109, 8894,
 1637,17338, 8889, 1904,17356,17103,17438,17401,17126,17403,17128,17409,
23364, 9261,17411,23366, 9263, 8923,23092,16944, 8922,23091,16943, 9133,
 2862, 9144, 2791, 9142, 2810,  838,22973,16764,16761,22976,  840, 9131,
 2790,16736,16734,17324, 8978,16842,23023, 3814, 9107,23257,17154,17107,
23220, 9070, 9076,23226,17115, 8968, 8967,23119,16978,16803,22990, 3881,
16802,22989, 2880,32747,16805,22992, 1327,16816,23003, 1334, 9165, 8962,
 8961, 1344, 9163, 8966,23118,16977, 8964,23116,16975,17217,23295, 9191,
 9011,23153,17018,17017,23152, 9010,17120,23229, 9079,17082,23202, 9038,
 9062,23213,17099,32758,32757, 8984, 8982, 8977, 8976, 2171, 2170, 2178,
23009,16824,43802,43773, 9173, 2190, 9199,23303,17016,17242,23151, 9009,
 9198,23302,17015,17241,23150, 9008, 9196,23300,17239,23148,17238,17237,
17236,17235,17234,17233,17232,17231,17518,17517,17172,17337,17336,17335,
17334,17345,17205,32896,17333,32921,28257, 9056,43837, 9245, 9395,28250,
 9329,43796, 9392,28197, 9326,43902,28224, 9053,43895, 9242,43834, 9049,
28254, 9238, 9388,43793, 9322,28247, 9385,43899, 9319,28194,43892, 9046,
28221, 9235, 9232,23352,17089,17323,23207, 9043,17321,17320,32773,32680,
32679,32772,32685,32778,32683,32775,32792,32688,38823,32771,17516,17539,
17543,17204,23284, 9172,17013,23147,17012, 9006,23146, 9005,17011,17010,
23145,23144, 9004, 9003,17009,17007,23143,23141, 9002, 9000,17081,17080,
23201,23200, 9037, 9036,38830, 9416,32848, 9415,32847,38829, 9215,23319,
17035,17265,23165, 9022, 9213,23317,17033,17263,23163, 9020,17203,23283,
 9171,16878,23054, 2188,17529,23402, 1325,17526,23399, 9170,16876,23052,
 1324,17525,23398, 2187, 1177, 1188, 1160, 1185, 1167, 1170,32806,32697,
 1220, 1215, 1246, 1202, 1250, 1232,32811,32702,17134,23237, 9087,17427,
17583,23383,23422,28234,28268, 9278, 1184, 9299, 1187, 8904, 1176,16926,
23075, 1159,17142,28179, 1166,23245,28207, 1169, 9095, 9119, 8875, 9275,
23380,17423, 9277,23382,17426,17148,16931,23251,23080,28212,28184, 9101,
 1236, 9124, 1240, 8880, 1226,32808,32699,38792,38755,43819,43784, 9280,
 1245, 9301, 1249, 8906, 1231,23385,23083,28236,28187, 9343, 1254, 9363,
 1256, 8883, 1210,38860,38757,43860,43786, 9458, 1260, 9471, 1262, 8911,
 1219,17429,16934,28215,28270, 9127, 1208, 9376, 1258,32880,32701,43821,
43907, 9306, 1214, 9480, 1264,28241,28275, 9365, 1222, 9378, 1242,43862,
43909, 9473, 1228, 9482, 1252,17153,17585,23256,23424, 9106, 1197,32810,
32931,38794,38872, 9285, 1201,23390,23429, 9345, 1204,38864,38874, 9462,
 1206,17435,17591,32884,32933,17434,17590,23389,23428,28240,28274, 9284,
 1200, 9305, 1213, 8910, 1218,17433,17589,23388,23427,28239,28273, 9283,
 1199, 9304, 1212, 8909, 1217,17147,16930,23250,23079, 9100, 1235,28211,
28183, 9123, 1239, 8879, 1225,16933,23082, 1244,17152,28186, 1248,23255,
28214, 1230, 9105, 9126, 8882,17145,23248, 9098,17151,23254,17150, 9104,
23253, 9103,38863, 9461,32883, 9460,32882,38862, 1316, 1319, 1337, 1313,
 1340, 1322,17098,23212,17097, 9061,23211, 9060,38834, 9427,32857, 9426,
32856,38833,17367,17366,17365,17364,17363,16908,32794,32925,17425,17582,
 9448, 9447, 1380,17560,23409, 1373,38849, 9446,32872, 9444,32870,38847,
38841, 9434,32864, 9432,32862,38839,38837, 9430,32860, 9429,32859,38836,
32691,32796,17106,17105,23219,23218, 9069, 9068,38844, 9439,32867, 9438,
32866,38843, 1370, 1378, 1348, 1375, 1356, 1362,16910,23062, 2186, 1385,
23412,17568, 9252,23358,17387, 1382, 1390, 1353, 1387, 1359, 1365,32693,
32800,17114,23225,17113, 9075,23224, 9074,38853, 9453,32875, 9452,32874,
38852,17332,17331,17330,17329,16888,32787,32920,17432,17588,17358,17556,
17351,17553,17389,17570,17378,17562,17382,17564,17394,17572,17362,17558,
 9442, 9441, 9424, 9423, 1368, 1108,13330,13329,13400,13397,17078,17315,
17071,17307,15133,13770,13518,14434,15468,14972,15521,14863,13769,14436,
15135,13517,13768,14811,15395,13516,13767,14420,15116,13515,15518,14860,
15465,14965,13805,14816,15398,13568,17124,17405,17070,17314,15369,14792,
14790,15359,14821,15430,15491,14910,14770,15314,12926,13328,15520,14971,
13327,12925,13326,12924,13325,12923,15542,15031,13469,13253,14815,15397,
15464,14859,17349,16906,17347,16904,14873,16397,14871,16395,14532,13324,
14527,13323,14525,13393,14530,12922,14535,12984,14537,12921,14517,12920,
16382,14987,16384,14989,16022,13322,16017,13321,16015,13395,16020,12919,
16025,12986,16027,12918,16008,12917,15775,15777,14402,14400,17398,14510,
14903,14858,14508,14424,14819,16961,17305,14412,14855,13876,13883,13881,
13873,14422,14414,14416,14809,13946,13944,13878,13889,13887,15029,14923,
13451,14963,13840,13900,13831,13803,13842,13981,13779,13829,13959,13950,
13971,13964,13962,13967,16068,22589,16077, 4261,22598, 4260,16066,22587,
16075, 4259,22596, 4257,15256,21934,15263, 7336,21941, 7343,15254,21932,
15261, 7334,21939, 7341,12916,20525, 4255,13079,20683, 4314,12915,20524,
 4254,12914,20523, 4253,13081,20685, 4316,13320,20978, 4434,13419,21040,
 4468,13319,20977, 4433,13318,20976, 4432,13317,20975, 4431,12913,20522,
 4252,12912,20521, 4251,12911,20520, 4250, 4301,22781,16319,15412,22046,
 7464,12910,20519, 6816,12909,20518, 6634,12908,20517, 6661,12907,20516,
 6459,12906,20515, 6453,12905,20514, 6802,13316,20974, 6632,13315,20973,
 6637,13314,20972, 6628,13313,20971, 6457,16321,22783, 4249,16308,22771,
 4248,16203,22698, 6715,15914,22451, 6492,15305,21977, 7384,15303,21975,
 7382,15155,21849, 7283,15414,22048, 7466,13006,20610, 6813,15403,22039,
 7458,13009,20613, 6659,16201,22696, 6713,13403,21030, 6639, 8092, 8571,
 8574, 8095,38612,37449,38626,37448,38624,37446,38541,37444,14814,17313,
17312,12904,12903,12902,12901,13083,13012, 7107, 5350,42779,42777, 4169,
 4393,14834,14922, 4390, 4349, 4424, 4270, 4347,18969,43135,27930,27928,
27921, 4601, 4600, 4598,27511,27509,27504, 7785, 6772, 6679, 6487, 6688,
 8090, 8569,30259,35323,30254,35317,30252,35315, 8089, 8568,18967,43133,
30251,35314,30244,35307,30257,35321,30249,35312,15087,21797, 4505, 4504,
 4512, 4579, 4577, 4514,29692,34639,29691,34638,29707,34654,29717,34664,
29799,34746,29801,34748,29740,34687,13958, 6932, 5267, 6930, 5265, 4503,
 4502, 4501, 4520, 4519, 4551, 8363, 2934, 2926, 2974, 2970, 8370, 2925,
 2383, 2391, 2382, 8368, 8347,30250,35313, 8343, 7722, 7720,19096,19094,
10709,10706, 4500,22238,15684, 4499,22236,15681,13514,21078, 7566,12900,
20513, 6779,12899,20512, 6826,12898,20511, 6737,17122,23231, 9081, 9066,
23216,17102,17111,23222, 9072, 9026,23185,17056,17095,23209, 9058,12897,
20510, 7806,15550,22120, 7851, 7507,22090,15478,15533,22114, 7845,15538,
22116, 7847, 7499,22084,15461,15530,22111, 7841,15711,22261, 6742,15708,
22259, 7774, 7581,22380,15829,15836,22382, 7583,15923,22457, 7564, 7593,
22241,15688,15442,22075, 7492,15489,22096, 7513,15481,22092, 7509, 7837,
22108,15515,17005,23139, 8998, 8997,23138,17004,15500,22099, 7832, 7497,
22078,15454,15453,22077, 7496, 7831,22098,15499,15473,22087, 7504, 4529,
22140,15578,13822,15577, 4527,22139,15576,13817,15575,15724,13513,15574,
22138, 4179,15573,13583,14251,15710,15572,22137, 7776,14257,15571,16242,
15707,15570,22136, 6745,16254,15569,15832,15835,15702,15922,15568,22135,
 6500,15567,15925, 4188, 4538,22455,15920, 4537,22454,15919, 7591,22453,
15918,15917,13613,15916, 7595,22134,15566,14065,15565,17228,14833, 4173,
13188,20804, 4365,13228,20847, 4386,17227,13237,20859, 4389,13169,20781,
 4360,14099,13827, 4534,13603,21164, 7590,14068,14024,13570,13209,20828,
 4382,13512,13412,13411,17003,17226,15452,14832,15498,14921,17328,16887,
14866,16391,14521,13410,16377,14977,16010,13409,14396,13941,13885,13074,
20679, 4310,13073,20678, 4309, 4308,22776,16314,15300,21972, 7379,13072,
 4531,15564,22133, 6475,15870,15563,15825,13599,13511,15764, 6771, 6670,
 6678, 6486, 7784,13448,13897, 3266, 3424,42761,42776, 6929, 5264, 2924,
 2381,18833,43481, 8713, 2380, 2379, 2962,19078,42868,18806,43450, 2923,
 1016, 1058,35100,29992, 1044,35096,29988,15561,22131,35097,29989, 1040,
 2404, 1034, 1042, 1054, 1028, 5115, 5117,16064,22585,16073, 4297,22594,
 4296,27926, 4624, 6948, 5294,15252,21930,15259, 7332,21937, 7339,27507,
 8352,14813,14857,14970,14969,42775,13447,13896,13446,13895, 7110, 5369,
 2980, 8377, 7739, 7738,19111,19110,10739,10738,18987,43158, 2942, 8712,
 4563,13639,21187, 4554,13904, 4195, 4381,15070,21780, 4533,13903,14067,
13957,16938,16937,42132,42573,17002,17225,15451,14920,15497,14831,14919,
15409,22043, 7462,13305,20963, 6811,13304,20962, 6657,16196,22691, 6711,
13303,13986,13985,13984,17224,14918,14830,42689,42380,42688,42379, 4429,
13311,20969, 4428,13977,16936,13307,20965, 4423,13509,37779, 4899,13507,
37777, 4897,13983,42687,42378,42373,42682,13988,42377,42686,42691,42382,
 9078,23228,17119, 7511,22094,15487,15440,22073, 7490,13115,20712, 6824,
42802, 8376, 8375, 7849,22118,15548,13826,13445,13894,13114,13628, 2232,
21214,13743,13651,21291, 2250, 6477,21167,15144,13606,21841, 7270,13956,
21399, 2214, 2231,21355,13867,15143,21840, 7269, 6483,21334,13833,13955,
 4574,13113,13949, 4571, 4570,13731,21281, 4553,13168,13737,21286, 2230,
13742,21290, 2249,13954,21398, 2213,13948,21396, 2229,13112,20711, 6735,
13940,15265,21943,15066,21776,15085,21795,30243,35306,15560,22130, 4548,
29765,34712,29750,34697, 2378, 5130, 5127,43480,18832, 2377,35094,29986,
 2376,35090,29982,15558,22128,35091,29983, 2403,15077,21787,30235,35299,
30246,35309, 8342,13111,20710, 6777,13110,20709, 7804, 4550,13208,20827,
 4380,18680,42605, 4379,13646,18934,42986, 8312, 1778,42238,42611,13167,
20780, 4359, 7035, 5307,42741, 1710, 1626, 8327, 8326, 2375, 8340, 8325,
 7615, 7612,19074,19071,10696,10693, 4562,13166, 8224, 8659,19004,43178,
15330,21997, 8664, 8226, 2922, 2374, 8223, 8658, 5467,  955, 6059,  953,
 5464,  959, 6056,  957, 8661, 8663, 8218, 8221,14243,14242,16236,16235,
32298,32297, 8076, 6069,42820,42819, 8383,10641,19007,10640, 6755,19006,
 6754,15343,22008, 7135, 5491,42828, 2373, 8387, 8386, 7793, 7792,19130,
19129,10758,10757,19123,42907,43185,43523,42818,42906, 8672, 8675, 1503,
 6071, 5483, 1507,32302, 7134, 5490, 8080, 6089,19017,43192,43191,43528,
43190,43527,42827,42913, 8385, 7791, 7790,19128,19127,10756,10755,10651,
19016,10648, 6766,19013, 6763, 8233, 8236,42911,42825, 5497, 1549, 6093,
 1539, 5496, 1548, 6092, 1538,15069,21779,15332,21999,15083,21793,15090,
21800,15088,21798,15674,22221,15557,22127,15556,22126,15559,22129,15555,
22125,15078,21788,15080,21790,15076,21786,15554,22124,15562,22132,15553,
22123,15552,22122,15074,21784,15073,21783,15184,21867,15949,22485,15948,
22484,15988,15219,22525,21900,27872,27463,15985,15216,27869,22522,21897,
27460,27857,27448,27849,27440,25615,27633,27608,21778,15068,27834,27425,
27765,27606,15970,15201,22507,21882,27833,27424,15969,15200,27899,27898,
22541,22540,22506,21881,27490,27489,16004,16003,27832,27423,21916,21915,
15235,15234,27897,27488
};


const int s_nDataSize3 = 24772;
unsigned int s_Data3[24772] = {
//Output priorities (total = 24772):
10, 9, 12, 6, 11, 14, 4, 1, 7, 5, 2, 3, 13, 8, 0,
0, 1, 2, 219, 218, 76, 217, 216, 77, 1, 0, 74, 78, 79, 75,
70, 71, 72, 68, 73, 69, 310, 299, 296, 331, 297, 332, 114, 26, 298,
340, 330, 336, 338, 339, 62, 112, 328, 334, 329, 335, 113, 337, 327, 333,
115, 60, 27, 61, 63, 273, 215, 36, 213, 31, 35, 39, 319, 312, 320,
323, 324, 343, 157, 345, 28, 178, 32, 59, 269, 58, 309, 305, 275, 271,
308, 304, 34, 117, 181, 129, 154, 211, 30, 38, 177, 193, 55, 130, 268,
33, 303, 174, 29, 37, 119, 212, 143, 188, 66, 270, 141, 183, 194, 179,
126, 261, 190, 267, 344, 346, 272, 189, 173, 274, 51, 322, 321, 342, 315,
214, 311, 14, 57, 223, 348, 125, 176, 192, 317, 280, 314, 165, 160, 175,
326, 127, 17, 247, 172, 262, 5, 231, 99, 138, 124, 54, 301, 325, 167,
15, 43, 205, 47, 122, 147, 292, 295, 83, 106, 86, 87, 220, 131, 347,
293, 150, 209, 233, 67, 116, 148, 156, 171, 180, 191, 256, 195, 341, 128,
277, 291, 281, 289, 294, 313, 102, 46, 103, 207, 229, 236, 240, 224, 227,
249, 170, 49, 251, 258, 318, 133, 197, 278, 2, 56, 252, 265, 254, 20,
142, 151, 316, 164, 121, 162, 41, 107, 139, 203, 288, 302, 48, 52, 110,
53, 64, 4, 16, 284, 135, 307, 3, 40, 155, 202, 23, 93, 22, 92,
290, 65, 210, 50, 98, 208, 94, 123, 137, 187, 225, 7, 10, 120, 109,
263, 287, 186, 108, 152, 264, 90, 253, 96, 97, 136, 200, 118, 140, 300,
306, 185, 6, 11, 89, 259, 85, 101, 132, 196, 24, 45, 260, 244, 91,
18, 104, 232, 19, 44, 105, 184, 21, 84, 226, 250, 283, 279, 286, 158,
248, 257, 255, 80, 169, 13, 100, 81, 168, 199, 238, 9, 12, 82, 182,
201, 266, 146, 204, 230, 239, 241, 159, 221, 285, 134, 88, 242, 246, 8,
144, 222, 149, 161, 228, 237, 276, 95, 206, 282, 163, 198, 243, 235, 245,
42, 166, 25, 111, 145, 153, 234, 13, 0, 1, 8, 3, 11, 7, 9,
2, 12, 4, 6, 5, 10, 0, 61, 62, 0, 2, 3, 5, 6, 8,
15, 17, 1, 4, 7, 9, 10, 11, 12, 13, 14, 16, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 63, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 4, 5,
2, 0, 1, 3, 7, 10, 8, 11, 6, 9, 97, 100, 22, 123, 124,
125, 98, 101, 40, 39, 66, 72, 75, 69, 68, 74, 21, 41, 67, 73,
77, 30, 71, 23, 106, 36, 54, 55, 63, 96, 32, 99, 58, 59, 65,
38, 107, 27, 17, 56, 57, 64, 70, 76, 29, 15, 31, 122, 102, 25,
48, 49, 50, 51, 52, 53, 26, 28, 103, 37, 127, 104, 120, 121, 24,
33, 46, 47, 62, 112, 113, 116, 105, 20, 13, 126, 128, 35, 34, 19,
42, 43, 44, 45, 60, 61, 18, 79, 84, 91, 16, 14, 82, 89, 94,
85, 119, 83, 88, 95, 118, 78, 90, 81, 86, 93, 12, 80, 87, 92,
108, 109, 110, 111, 114, 115, 117, 148, 542, 149, 147, 303, 531, 555, 573,
574, 532, 556, 150, 153, 155, 578, 304, 560, 536, 151, 154, 157, 534, 558,
576, 533, 538, 557, 575, 547, 551, 570, 305, 568, 306, 540, 541, 544, 546,
550, 553, 562, 564, 565, 571, 552, 554, 572, 535, 559, 577, 537, 561, 569,
539, 543, 545, 548, 549, 563, 566, 567, 308, 307, 152, 156, 158, 382, 144,
128, 145, 438, 446, 450, 458, 462, 470, 474, 482, 492, 500, 504, 510, 516,
522, 530, 204, 394, 528, 381, 397, 480, 498, 396, 400, 436, 444, 448, 456,
460, 468, 472, 490, 502, 508, 514, 520, 286, 388, 393, 294, 403, 273, 384,
385, 387, 391, 399, 408, 313, 317, 347, 354, 414, 419, 426, 25, 88, 127,
130, 198, 275, 336, 483, 126, 281, 283, 341, 432, 299, 325, 390, 402, 415,
416, 417, 418, 427, 428, 116, 124, 134, 142, 221, 229, 298, 479, 486, 497,
527, 24, 87, 227, 311, 315, 329, 353, 506, 512, 518, 30, 34, 41, 196,
300, 484, 48, 104, 186, 191, 264, 335, 343, 363, 234, 276, 441, 443, 453,
455, 465, 467, 477, 495, 525, 222, 269, 476, 494, 524, 395, 89, 140, 413,
420, 425, 481, 499, 505, 511, 517, 529, 200, 257, 327, 398, 401, 440, 445,
452, 457, 464, 469, 32, 36, 42, 47, 345, 365, 435, 442, 447, 454, 459,
466, 471, 478, 489, 496, 501, 507, 513, 519, 526, 202, 323, 146, 170, 177,
179, 248, 255, 368, 380, 206, 122, 132, 258, 279, 288, 296, 349, 375, 434,
46, 114, 165, 180, 201, 219, 243, 250, 297, 405, 429, 33, 38, 43, 172,
203, 208, 346, 392, 404, 410, 485, 488, 183, 216, 261, 348, 386, 430, 20,
26, 65, 100, 131, 162, 167, 174, 182, 188, 189, 194, 210, 218, 240, 252,
260, 266, 272, 284, 360, 372, 383, 423, 12, 17, 57, 92, 99, 129, 213,
215, 230, 231, 278, 291, 293, 339, 389, 406, 411, 422, 15, 60, 62, 97,
117, 119, 135, 199, 224, 225, 236, 245, 267, 302, 321, 326, 377, 407, 102,
137, 175, 274, 431, 412, 421, 424, 173, 238, 246, 251, 253, 262, 270, 282,
366, 370, 378, 437, 439, 449, 451, 461, 463, 473, 475, 491, 493, 503, 509,
515, 521, 523, 0, 1, 81, 82, 106, 160, 168, 184, 185, 192, 193, 263,
271, 277, 322, 358, 22, 28, 31, 40, 67, 98, 103, 105, 138, 254, 316,
319, 355, 328, 10, 14, 49, 52, 59, 70, 73, 90, 112, 133, 220, 228,
232, 233, 301, 309, 314, 331, 333, 337, 344, 351, 35, 37, 44, 163, 342,
409, 433, 487, 259, 27, 29, 39, 50, 161, 164, 176, 178, 181, 187, 190,
197, 205, 239, 241, 242, 324, 332, 359, 361, 362, 371, 373, 374, 6, 7,
45, 55, 56, 75, 77, 79, 80, 108, 109, 159, 166, 169, 171, 195, 217,
237, 247, 249, 256, 265, 268, 280, 334, 340, 350, 357, 367, 369, 379, 2,
3, 9, 18, 19, 21, 23, 53, 63, 64, 66, 68, 72, 76, 83, 84,
93, 95, 96, 101, 107, 111, 120, 121, 123, 125, 139, 141, 143, 212, 244,
290, 295, 310, 312, 318, 320, 330, 338, 352, 356, 4, 5, 8, 11, 13,
51, 54, 58, 61, 69, 71, 74, 78, 85, 86, 94, 110, 113, 115, 136,
207, 209, 211, 214, 223, 226, 235, 285, 287, 289, 292, 364, 376, 16, 91,
118, 0, 3, 19, 149, 96, 20, 150, 5, 1, 6, 4, 2, 147, 93,
91, 145, 148, 95, 146, 85, 55, 66, 76, 59, 73, 81, 51, 61, 64,
54, 58, 92, 94, 63, 173, 62, 86, 65, 75, 60, 74, 82, 56, 52,
53, 57, 171, 167, 160, 159, 170, 72, 141, 162, 172, 28, 68, 29, 140,
168, 27, 70, 126, 139, 69, 163, 89, 137, 166, 71, 169, 129, 142, 164,
116, 135, 143, 90, 67, 113, 121, 165, 161, 131, 123, 125, 133, 30, 7,
138, 10, 117, 119, 11, 120, 127, 134, 130, 132, 115, 124, 114, 136, 9,
118, 33, 77, 157, 158, 8, 12, 88, 155, 156, 34, 78, 99, 97, 128,
36, 44, 87, 35, 43, 15, 13, 17, 122, 21, 23, 25, 144, 37, 45,
47, 103, 32, 42, 80, 39, 49, 83, 108, 40, 50, 84, 38, 46, 48,
31, 41, 79, 18, 98, 22, 24, 26, 14, 16, 105, 107, 100, 152, 111,
109, 104, 101, 110, 112, 106, 153, 102, 151, 154, 0, 1, 3, 4, 2,
12, 13, 10, 11, 14, 9, 6, 5, 7, 8, 21, 24, 23, 22, 20,
19, 15, 16, 17, 18, 0, 1, 3, 2, 108, 109, 139, 153, 122, 96,
178, 97, 126, 95, 101, 100, 94, 174, 140, 172, 175, 173, 5, 36, 154,
88, 83, 80, 35, 161, 151, 19, 11, 6, 147, 143, 34, 176, 123, 37,
169, 170, 171, 163, 164, 165, 166, 167, 168, 155, 156, 157, 158, 159, 160,
82, 162, 177, 152, 81, 111, 7, 12, 20, 128, 4, 93, 21, 64, 13,
148, 60, 62, 118, 10, 18, 33, 144, 30, 48, 135, 149, 86, 114, 99,
124, 129, 130, 131, 61, 63, 65, 8, 14, 16, 22, 24, 26, 28, 73,
75, 77, 90, 56, 72, 74, 76, 78, 51, 53, 55, 57, 59, 67, 69,
71, 79, 89, 91, 50, 52, 54, 58, 66, 68, 70, 92, 107, 39, 41,
43, 45, 47, 110, 103, 105, 120, 145, 127, 38, 40, 42, 44, 46, 137,
102, 104, 106, 31, 32, 49, 9, 15, 17, 23, 29, 87, 25, 27, 150,
141, 142, 84, 85, 146, 98, 116, 119, 133, 115, 121, 136, 132, 125, 117,
112, 113, 138, 134, 2, 0, 1, 3, 8, 6, 7, 4, 5, 9, 10,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 2, 1, 4, 8, 7, 9, 6, 0, 5, 3, 10, 109, 107,
108, 97, 105, 28, 30, 21, 81, 26, 32, 106, 20, 24, 35, 22, 34,
96, 104, 62, 27, 111, 11, 18, 23, 36, 83, 37, 12, 95, 17, 46,
56, 25, 40, 42, 87, 89, 14, 16, 13, 29, 103, 82, 110, 15, 19,
31, 33, 102, 38, 66, 67, 68, 69, 70, 71, 72, 85, 41, 115, 117,
91, 93, 94, 99, 101, 43, 73, 86, 88, 114, 116, 50, 52, 74, 76,
77, 78, 79, 39, 113, 44, 45, 47, 48, 49, 51, 53, 54, 55, 57,
58, 59, 60, 61, 63, 64, 65, 75, 80, 84, 90, 92, 98, 100, 112,
0, 1, 20, 17, 18, 12, 19, 16, 21, 15, 23, 14, 22, 13, 0,
6, 5, 11, 3, 9, 2, 8, 1, 7, 4, 10, 3, 4, 11, 14,
17, 32, 0, 1, 2, 5, 6, 7, 8, 9, 10, 12, 13, 15, 16,
18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 33,
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 2, 3, 0, 1,
15, 13, 17, 21, 77, 76, 33, 30, 34, 110, 105, 114, 118, 31, 32,
35, 101, 100, 16, 131, 12, 14, 130, 135, 132, 112, 120, 116, 111, 115,
119, 79, 117, 113, 121, 20, 133, 80, 134, 78, 81, 44, 109, 49, 47,
124, 46, 28, 48, 126, 26, 87, 89, 90, 88, 6, 5, 7, 9, 11,
19, 36, 38, 40, 42, 86, 91, 18, 4, 10, 39, 8, 37, 41, 43,
45, 60, 127, 27, 61, 106, 129, 59, 108, 128, 53, 54, 57, 58, 62,
50, 29, 56, 63, 52, 55, 107, 122, 123, 125, 51, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 75, 82, 83, 84, 85, 92, 93, 94,
95, 96, 97, 98, 99, 102, 103, 104, 23, 25, 24, 22, 175, 174, 176,
162, 158, 165, 124, 166, 15, 155, 126, 160, 120, 121, 122, 123, 125, 127,
128, 129, 153, 157, 171, 152, 163, 170, 96, 97, 108, 0, 3, 6, 9,
12, 66, 69, 72, 75, 78, 81, 130, 131, 150, 151, 156, 159, 161, 168,
169, 173, 177, 154, 164, 167, 172, 1, 2, 4, 5, 7, 8, 10, 11,
13, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43,
44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
59, 60, 61, 62, 63, 64, 65, 67, 68, 70, 71, 73, 74, 76, 77,
79, 80, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
95, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 109, 110, 111, 112,
113, 114, 115, 116, 117, 118, 119, 132, 133, 134, 135, 136, 137, 138, 139,
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 178, 179, 0, 1, 2,
8, 6, 7, 3, 5, 4, 0, 1305, 1308, 540, 545, 558, 563, 564, 569,
570, 575, 576, 581, 582, 587, 588, 593, 594, 599, 600, 605, 606, 611, 612,
617, 618, 623, 624, 629, 630, 635, 636, 641, 642, 647, 648, 653, 654, 657,
662, 663, 668, 669, 672, 677, 678, 681, 684, 687, 690, 0, 1, 2, 3,
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93,
94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183,
184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198,
199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213,
214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258,
259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303,
304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363,
364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378,
379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393,
394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408,
409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423,
424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438,
439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453,
454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483,
484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498,
499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513,
514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528,
529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 541, 542, 543, 544,
546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 559, 560, 561,
562, 565, 566, 567, 568, 571, 572, 573, 574, 577, 578, 579, 580, 583, 584,
585, 586, 589, 590, 591, 592, 595, 596, 597, 598, 601, 602, 603, 604, 607,
608, 609, 610, 613, 614, 615, 616, 619, 620, 621, 622, 625, 626, 627, 628,
631, 632, 633, 634, 637, 638, 639, 640, 643, 644, 645, 646, 649, 650, 651,
652, 655, 656, 658, 659, 660, 661, 664, 665, 666, 667, 670, 671, 673, 674,
675, 676, 679, 680, 682, 683, 685, 686, 688, 689, 691, 692, 693, 694, 695,
696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710,
711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725,
726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740,
741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755,
756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770,
771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785,
786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800,
801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815,
816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830,
831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845,
846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860,
861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875,
876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890,
891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905,
906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920,
921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935,
936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950,
951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965,
966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980,
981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995,
996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010,
1011, 1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025,
1026, 1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040,
1041, 1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055,
1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070,
1071, 1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085,
1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100,
1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115,
1116, 1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130,
1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145,
1146, 1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160,
1161, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175,
1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190,
1191, 1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 1205,
1206, 1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220,
1221, 1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235,
1236, 1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250,
1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265,
1266, 1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280,
1281, 1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295,
1296, 1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1306, 1307, 1309, 1310, 158, 161,
164, 167, 170, 173, 74, 77, 86, 89, 0, 3, 12, 15, 24, 27, 36,
39, 48, 51, 60, 63, 110, 113, 122, 125, 134, 137, 146, 149, 76, 88,
156, 160, 162, 165, 169, 171, 2, 132, 175, 26, 38, 50, 62, 72, 83,
84, 95, 108, 120, 78, 90, 96, 104, 174, 14, 144, 176, 9, 21, 33,
45, 57, 69, 79, 81, 91, 93, 98, 106, 119, 131, 143, 155, 59, 71,
157, 159, 163, 166, 168, 172, 99, 101, 103, 105, 11, 35, 47, 73, 75,
80, 82, 85, 87, 92, 94, 97, 100, 102, 107, 117, 129, 141, 8, 20,
23, 32, 44, 56, 68, 114, 126, 138, 150, 153, 179, 186, 191, 198, 180,
192, 1, 4, 5, 6, 7, 10, 13, 16, 17, 18, 19, 22, 25, 28,
29, 30, 31, 34, 37, 40, 41, 42, 43, 46, 49, 52, 53, 54, 55,
58, 61, 64, 65, 66, 67, 70, 109, 111, 112, 115, 116, 118, 121, 123,
124, 127, 128, 130, 133, 135, 136, 139, 140, 142, 145, 147, 148, 151, 152,
154, 213, 214, 215, 216, 177, 189, 184, 196, 221, 222, 223, 224, 178, 181,
182, 183, 185, 187, 188, 190, 193, 194, 195, 197, 199, 200, 201, 202, 203,
204, 205, 206, 207, 208, 209, 210, 211, 212, 217, 218, 219, 220, 2, 4,
6, 8, 10, 12, 32, 34, 36, 46, 48, 52, 54, 56, 58, 60, 62,
64, 86, 87, 88, 105, 106, 107, 108, 109, 112, 113, 115, 117, 121, 1,
3, 5, 7, 9, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23,
25, 26, 27, 28, 29, 30, 31, 33, 35, 37, 38, 39, 40, 41, 42,
43, 44, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63, 65, 66, 67,
68, 71, 73, 75, 76, 78, 79, 80, 82, 83, 84, 92, 93, 94, 96,
97, 98, 99, 100, 101, 102, 103, 104, 110, 111, 114, 116, 118, 119, 120,
122, 124, 126, 127, 129, 131, 141, 143, 145, 146, 148, 150, 152, 153, 156,
166, 167, 170, 173, 174, 176, 180, 182, 184, 186, 0, 22, 24, 50, 69,
70, 72, 74, 77, 81, 85, 89, 90, 91, 95, 123, 125, 128, 130, 132,
133, 134, 135, 136, 137, 138, 139, 140, 142, 144, 147, 149, 151, 154, 155,
157, 158, 159, 160, 161, 162, 163, 164, 165, 168, 169, 171, 172, 175, 177,
178, 179, 181, 183, 185, 122, 85, 89, 92, 106, 118, 136, 148, 156, 164,
27, 35, 37, 38, 52, 57, 62, 67, 71, 83, 55, 65, 68, 121, 26,
53, 63, 66, 80, 82, 105, 114, 119, 123, 137, 143, 14, 25, 30, 31,
100, 28, 117, 108, 134, 3, 12, 34, 36, 39, 40, 45, 46, 51, 59,
60, 61, 73, 74, 75, 76, 77, 78, 84, 86, 87, 88, 90, 91, 93,
94, 95, 110, 112, 115, 116, 120, 127, 128, 130, 132, 141, 142, 152, 175,
58, 0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 29, 32, 33, 41, 42, 43, 44,
47, 48, 49, 50, 54, 56, 64, 69, 70, 72, 79, 81, 96, 97, 98,
99, 101, 102, 103, 104, 107, 109, 111, 113, 124, 125, 126, 129, 131, 133,
135, 138, 139, 140, 144, 145, 146, 147, 149, 150, 151, 153, 154, 155, 157,
158, 159, 160, 161, 162, 163, 165, 166, 167, 168, 169, 170, 171, 172, 173,
174, 176, 177, 23, 29, 5, 24, 25, 26, 27, 28, 30, 31, 0, 1,
2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 20, 21, 22, 32, 83, 84, 96, 99, 100, 16, 85, 98, 18,
26, 27, 37, 40, 49, 52, 17, 51, 55, 57, 97, 8, 3, 19, 9,
50, 56, 58, 10, 53, 72, 82, 87, 89, 91, 14, 118, 129, 12, 81,
86, 88, 90, 130, 11, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31,
32, 33, 34, 35, 36, 43, 67, 68, 69, 93, 95, 41, 45, 47, 4,
5, 6, 13, 38, 117, 128, 71, 0, 1, 2, 15, 39, 92, 94, 65,
70, 122, 123, 127, 7, 42, 44, 46, 48, 54, 59, 60, 61, 62, 63,
64, 66, 105, 106, 109, 110, 111, 112, 113, 114, 121, 124, 126, 73, 74,
75, 76, 77, 78, 79, 80, 101, 102, 103, 104, 107, 108, 115, 116, 119,
120, 125, 18, 24, 5, 7, 9, 13, 0, 1, 2, 3, 4, 6, 8,
10, 11, 12, 14, 15, 16, 17, 19, 20, 21, 22, 23, 25, 26, 27,
28, 29, 30, 38, 37, 3, 2, 39, 4, 40, 5, 109, 110, 111, 99,
107, 97, 105, 140, 141, 142, 0, 98, 106, 1, 100, 108, 34, 35, 36,
10, 11, 42, 46, 50, 54, 58, 62, 66, 70, 13, 17, 21, 30, 6,
88, 90, 96, 102, 113, 115, 121, 123, 125, 135, 137, 139, 9, 14, 18,
22, 33, 44, 48, 52, 56, 60, 64, 68, 72, 116, 126, 130, 43, 47,
51, 55, 59, 63, 67, 71, 85, 91, 93, 103, 80, 82, 83, 73, 75,
76, 119, 129, 133, 12, 16, 20, 31, 7, 41, 45, 49, 53, 57, 61,
65, 69, 117, 127, 131, 87, 89, 95, 101, 112, 114, 120, 122, 124, 134,
136, 138, 86, 92, 94, 104, 118, 128, 132, 79, 81, 84, 74, 77, 78,
8, 15, 19, 23, 32, 24, 25, 28, 26, 27, 29, 0, 1, 2, 3,
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93,
94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 34, 5, 6, 7,
8, 9, 10, 11, 12, 33, 47, 2, 4, 19, 20, 21, 36, 37, 38,
40, 41, 0, 1, 3, 13, 14, 15, 16, 17, 18, 22, 23, 24, 25,
26, 27, 28, 29, 30, 31, 32, 35, 39, 42, 43, 44, 45, 46, 48,
49, 50, 144, 145, 0, 141, 142, 143, 155, 154, 139, 140, 146, 147, 150,
151, 76, 82, 83, 84, 85, 86, 87, 158, 131, 77, 132, 159, 23, 24,
25, 26, 27, 28, 32, 33, 73, 79, 91, 95, 1, 3, 5, 12, 13,
14, 15, 16, 17, 18, 19, 20, 21, 22, 29, 30, 31, 34, 102, 104,
106, 108, 112, 113, 114, 115, 116, 117, 118, 119, 138, 37, 39, 41, 43,
48, 50, 52, 54, 2, 4, 6, 7, 8, 9, 10, 11, 36, 38, 40,
42, 44, 45, 46, 47, 56, 57, 58, 59, 60, 62, 64, 66, 68, 70,
72, 74, 75, 78, 80, 81, 88, 89, 90, 92, 93, 94, 96, 97, 98,
100, 103, 105, 107, 109, 137, 160, 161, 162, 35, 49, 51, 53, 55, 61,
63, 65, 67, 69, 71, 99, 101, 110, 111, 120, 121, 122, 123, 124, 125,
126, 127, 128, 129, 130, 133, 134, 135, 136, 148, 149, 152, 153, 156, 157,
4, 11, 5, 6, 7, 8, 10, 9, 12, 17, 18, 19, 21, 2, 3,
0, 1, 13, 14, 15, 16, 20, 28, 32, 34, 38, 40, 22, 23, 24,
25, 26, 27, 29, 30, 31, 33, 35, 36, 37, 39, 41, 73, 69, 95,
11, 72, 14, 12, 13, 93, 71, 74, 94, 87, 81, 86, 79, 60, 96,
98, 88, 59, 82, 97, 44, 46, 54, 68, 92, 100, 45, 53, 67, 43,
91, 99, 80, 89, 77, 1, 3, 9, 5, 6, 7, 8, 70, 28, 83,
22, 34, 42, 49, 51, 57, 17, 23, 29, 37, 63, 19, 25, 31, 39,
48, 50, 52, 56, 58, 62, 64, 66, 84, 76, 90, 78, 75, 85, 4,
0, 2, 10, 20, 26, 32, 36, 40, 15, 61, 16, 18, 24, 30, 35,
38, 47, 55, 65, 21, 27, 33, 41, 0, 1, 2, 3, 4, 5, 6,
7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 40, 42, 3, 1, 51, 5, 49, 48, 22, 24,
4, 2, 52, 50, 76, 78, 80, 94, 96, 98, 23, 47, 26, 27, 63,
64, 65, 70, 71, 21, 77, 79, 81, 17, 20, 33, 37, 41, 43, 57,
55, 56, 58, 59, 60, 61, 62, 18, 19, 25, 32, 36, 95, 97, 99,
0, 38, 39, 54, 67, 69, 73, 75, 85, 87, 91, 93, 53, 66, 84,
86, 90, 89, 6, 7, 11, 12, 13, 82, 83, 68, 72, 74, 92, 8,
9, 10, 14, 15, 16, 28, 29, 30, 31, 34, 35, 44, 45, 46, 88,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 125, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 0, 1, 2, 3, 4, 5,
6, 7, 8, 1, 3, 43, 0, 2, 4, 5, 6, 7, 8, 9, 10,
11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
41, 42, 44, 45, 46, 89, 90, 0, 1, 2, 3, 4, 5, 6, 7,
8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
83, 84, 85, 86, 87, 88, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100, 101, 102, 103, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
26, 27, 28, 29, 30, 31, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 186, 189, 174,
185, 179, 180, 177, 181, 188, 191, 60, 63, 175, 183, 176, 184, 64, 61,
62, 65, 178, 182, 187, 190, 130, 142, 154, 166, 104, 110, 116, 13, 24,
36, 78, 122, 136, 148, 160, 172, 7, 18, 30, 84, 102, 108, 114, 105,
111, 117, 120, 123, 74, 86, 98, 107, 113, 119, 125, 1, 9, 20, 32,
44, 45, 55, 75, 99, 103, 109, 115, 0, 6, 19, 31, 42, 43, 54,
72, 73, 85, 96, 97, 137, 149, 161, 173, 2, 46, 47, 56, 76, 77,
100, 101, 127, 133, 139, 145, 151, 157, 163, 169, 8, 21, 33, 87, 106,
112, 118, 121, 124, 128, 129, 140, 141, 152, 153, 3, 4, 15, 26, 38,
48, 49, 50, 51, 57, 58, 66, 67, 68, 69, 80, 90, 91, 92, 93,
126, 131, 134, 138, 143, 146, 150, 155, 158, 162, 167, 170, 10, 11, 22,
23, 34, 35, 88, 89, 135, 147, 159, 171, 5, 12, 14, 16, 17, 25,
27, 28, 29, 37, 39, 40, 41, 52, 53, 59, 70, 71, 79, 81, 82,
83, 94, 95, 132, 144, 156, 164, 165, 168, 756, 759, 761, 104, 105, 640,
647, 700, 107, 757, 760, 102, 222, 224, 310, 420, 431, 441, 460, 468, 491,
494, 501, 558, 571, 654, 666, 683, 722, 7, 10, 31, 34, 60, 65, 162,
165, 178, 434, 467, 477, 480, 550, 569, 657, 671, 682, 718, 751, 13, 37,
54, 175, 181, 262, 265, 313, 385, 465, 551, 563, 641, 645, 701, 719, 253,
316, 333, 339, 364, 365, 369, 371, 436, 439, 461, 496, 499, 505, 514, 520,
522, 577, 585, 588, 598, 601, 608, 617, 622, 685, 727, 733, 223, 240, 191,
709, 92, 115, 144, 199, 248, 252, 290, 307, 338, 372, 382, 410, 475, 508,
513, 515, 527, 547, 566, 567, 572, 580, 587, 590, 595, 604, 606, 615, 619,
688, 716, 725, 730, 735, 739, 747, 11, 16, 22, 23, 35, 40, 46, 47,
52, 53, 59, 64, 88, 89, 94, 103, 118, 121, 124, 138, 143, 149, 163,
164, 179, 184, 190, 202, 205, 208, 225, 244, 245, 250, 259, 268, 280, 281,
284, 285, 291, 322, 328, 332, 340, 373, 379, 388, 400, 401, 404, 405, 411,
421, 426, 428, 429, 437, 442, 450, 455, 457, 469, 478, 481, 488, 497, 502,
529, 530, 536, 537, 540, 553, 564, 570, 625, 626, 630, 635, 637, 643, 655,
656, 668, 670, 678, 681, 691, 692, 699, 703, 704, 724, 738, 749, 750, 753,
560, 574, 723, 85, 331, 470, 101, 217, 633, 642, 697, 742, 745, 754, 19,
43, 48, 187, 324, 97, 218, 296, 416, 130, 137, 166, 226, 241, 271, 279,
319, 327, 391, 399, 440, 482, 142, 283, 325, 403, 443, 453, 485, 758, 0,
24, 67, 298, 336, 346, 464, 489, 504, 507, 510, 516, 518, 521, 523, 524,
535, 552, 559, 573, 576, 579, 582, 583, 591, 592, 594, 599, 602, 603, 607,
611, 614, 616, 620, 623, 632, 644, 649, 651, 661, 663, 667, 669, 684, 687,
696, 708, 720, 726, 729, 732, 736, 1, 2, 3, 4, 5, 6, 8, 9,
12, 14, 15, 17, 18, 20, 21, 25, 26, 27, 28, 29, 30, 32, 33,
36, 38, 39, 41, 42, 44, 45, 49, 50, 51, 55, 56, 57, 58, 61,
62, 63, 66, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
80, 81, 82, 83, 84, 86, 87, 90, 91, 93, 95, 96, 98, 99, 100,
106, 108, 109, 110, 111, 112, 113, 114, 116, 117, 119, 120, 122, 123, 125,
126, 127, 128, 129, 131, 132, 133, 134, 135, 136, 139, 140, 141, 145, 146,
147, 148, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 167,
168, 169, 170, 171, 172, 173, 174, 176, 177, 180, 182, 183, 185, 186, 188,
189, 192, 193, 194, 195, 196, 197, 198, 200, 201, 203, 204, 206, 207, 209,
210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 227, 228, 229, 230, 231,
232, 233, 234, 235, 236, 237, 238, 239, 242, 243, 246, 247, 249, 251, 254,
255, 256, 257, 258, 260, 261, 263, 264, 266, 267, 269, 270, 272, 273, 274,
275, 276, 277, 278, 282, 286, 287, 288, 289, 292, 293, 294, 295, 297, 299,
300, 301, 302, 303, 304, 305, 306, 308, 309, 311, 312, 314, 315, 317, 318,
320, 321, 323, 326, 329, 330, 334, 335, 337, 341, 342, 343, 344, 345, 347,
348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
363, 366, 367, 368, 370, 374, 375, 376, 377, 378, 380, 381, 383, 384, 386,
387, 389, 390, 392, 393, 394, 395, 396, 397, 398, 402, 406, 407, 408, 409,
412, 413, 414, 415, 417, 418, 419, 422, 423, 424, 425, 427, 430, 432, 433,
435, 438, 444, 445, 446, 447, 448, 449, 451, 452, 454, 456, 458, 459, 462,
463, 466, 471, 472, 473, 474, 476, 479, 483, 484, 486, 487, 490, 492, 493,
495, 498, 500, 503, 506, 509, 511, 512, 517, 519, 525, 526, 528, 531, 532,
533, 534, 538, 539, 541, 542, 543, 544, 545, 546, 548, 549, 554, 555, 556,
557, 561, 562, 565, 568, 575, 578, 581, 584, 586, 589, 593, 596, 597, 600,
605, 609, 610, 612, 613, 618, 621, 624, 627, 628, 629, 631, 634, 636, 638,
639, 646, 648, 650, 652, 653, 658, 659, 660, 662, 664, 665, 672, 673, 674,
675, 676, 677, 679, 680, 686, 689, 690, 693, 694, 695, 698, 702, 705, 706,
707, 710, 711, 712, 713, 714, 715, 717, 721, 728, 731, 734, 737, 740, 741,
743, 744, 746, 748, 752, 755, 325, 326, 324, 15, 258, 103, 123, 3, 9,
124, 331, 14, 259, 16, 2, 8, 337, 102, 335, 340, 4, 10, 17, 120,
246, 247, 276, 333, 334, 33, 72, 128, 338, 5, 11, 76, 105, 127, 0,
13, 74, 73, 122, 1, 75, 7, 300, 336, 364, 6, 12, 228, 235, 263,
265, 270, 280, 291, 106, 297, 77, 135, 162, 169, 192, 199, 201, 214, 216,
225, 260, 262, 104, 306, 316, 339, 170, 200, 223, 341, 137, 160, 190, 203,
215, 218, 141, 150, 157, 171, 180, 187, 312, 313, 317, 39, 125, 143, 148,
158, 173, 178, 188, 308, 318, 107, 322, 362, 35, 91, 97, 109, 299, 230,
272, 293, 244, 256, 289, 323, 367, 38, 121, 302, 303, 311, 327, 245, 257,
261, 290, 305, 234, 264, 279, 34, 36, 79, 85, 115, 126, 298, 307, 309,
319, 328, 57, 63, 69, 198, 229, 271, 292, 82, 88, 90, 96, 108, 118,
304, 320, 329, 37, 41, 80, 86, 116, 301, 332, 139, 159, 164, 168, 189,
194, 205, 213, 217, 220, 222, 40, 136, 145, 167, 177, 197, 202, 212, 227,
18, 27, 48, 363, 237, 267, 282, 196, 240, 241, 252, 253, 285, 286, 142,
147, 152, 155, 156, 172, 175, 182, 185, 186, 310, 321, 330, 346, 347, 348,
355, 138, 163, 165, 193, 195, 204, 210, 219, 226, 131, 132, 208, 250, 251,
278, 314, 315, 357, 365, 140, 146, 179, 206, 211, 20, 29, 50, 161, 166,
191, 221, 224, 269, 368, 26, 44, 47, 58, 64, 70, 81, 87, 117, 144,
151, 153, 174, 181, 183, 93, 99, 111, 232, 274, 295, 59, 65, 71, 133,
134, 149, 154, 176, 184, 209, 350, 361, 239, 242, 254, 284, 287, 268, 56,
62, 68, 78, 84, 94, 100, 112, 114, 92, 98, 110, 238, 283, 55, 61,
67, 349, 236, 243, 255, 266, 281, 288, 19, 24, 28, 42, 45, 49, 129,
130, 207, 248, 249, 277, 354, 359, 360, 233, 275, 296, 352, 353, 22, 31,
52, 54, 60, 66, 83, 89, 95, 101, 113, 119, 342, 345, 366, 231, 273,
294, 25, 43, 46, 23, 32, 53, 343, 351, 358, 21, 30, 51, 344, 356,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224,
225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254,
255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269,
270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284,
285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299,
300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314,
315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329,
330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344,
345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359,
360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374,
375, 376, 377, 19, 29, 33, 45, 86, 88, 90, 92, 18, 27, 31, 47,
82, 103, 37, 41, 55, 87, 11, 35, 39, 43, 49, 51, 53, 57, 61,
63, 89, 91, 105, 109, 114, 20, 9, 13, 107, 28, 30, 32, 34, 46,
48, 78, 84, 133, 135, 93, 112, 134, 136, 36, 40, 62, 66, 80, 38,
42, 44, 50, 52, 54, 56, 58, 64, 127, 131, 137, 1, 15, 16, 21,
22, 102, 111, 113, 128, 132, 138, 23, 25, 59, 68, 70, 94, 69, 3,
4, 6, 7, 10, 104, 106, 108, 110, 121, 123, 67, 24, 26, 60, 122,
124, 72, 76, 81, 96, 85, 74, 98, 129, 83, 125, 0, 2, 5, 8,
12, 14, 17, 71, 73, 75, 77, 79, 95, 97, 99, 100, 126, 65, 130,
101, 118, 116, 120, 115, 117, 119, 219, 220, 221, 127, 131, 135, 139, 228,
229, 230, 231, 232, 233, 234, 235, 222, 223, 224, 225, 226, 227, 236, 237,
238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252,
253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 275,
276, 277, 278, 9, 13, 17, 21, 25, 29, 36, 40, 44, 48, 49, 56,
60, 64, 68, 72, 76, 80, 84, 171, 176, 180, 184, 0, 1, 2, 3,
4, 5, 6, 7, 8, 10, 11, 12, 14, 15, 16, 18, 19, 20, 22,
23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 41,
42, 43, 45, 46, 47, 50, 51, 52, 53, 54, 55, 57, 58, 59, 61,
62, 63, 65, 66, 67, 69, 70, 71, 73, 74, 75, 77, 78, 79, 81,
82, 83, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 128,
129, 130, 132, 133, 134, 136, 137, 138, 140, 141, 142, 143, 144, 145, 146,
147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161,
162, 163, 164, 165, 166, 167, 168, 169, 170, 172, 173, 174, 175, 177, 178,
179, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195,
196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210,
211, 212, 213, 214, 215, 216, 217, 218, 267, 268, 269, 270, 271, 272, 273,
274, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 1, 2,
3, 4, 0, 8, 12, 11, 102, 127, 6, 5, 101, 7, 128, 4, 3,
10, 1, 2, 0, 9, 92, 90, 97, 114, 94, 95, 99, 112, 111, 123,
116, 118, 120, 121, 125, 98, 89, 91, 96, 93, 100, 113, 24, 34, 16,
36, 14, 22, 13, 21, 33, 18, 26, 30, 115, 117, 124, 119, 122, 126,
17, 25, 29, 104, 19, 27, 31, 106, 28, 20, 32, 15, 23, 35, 54,
56, 110, 51, 72, 88, 38, 40, 49, 58, 60, 64, 66, 74, 81, 105,
107, 37, 39, 50, 52, 57, 59, 63, 65, 71, 73, 82, 87, 42, 43,
45, 48, 61, 67, 70, 76, 77, 79, 83, 86, 53, 55, 41, 44, 46,
47, 62, 68, 69, 75, 78, 80, 84, 85, 109, 103, 108, 7, 8, 6,
9, 17, 10, 28, 26, 24, 50, 68, 4, 34, 5, 0, 23, 46, 2,
18, 33, 1, 85, 19, 58, 62, 70, 29, 31, 35, 3, 25, 27, 47,
48, 49, 51, 11, 90, 30, 32, 36, 40, 41, 42, 43, 44, 45, 12,
13, 14, 15, 16, 20, 21, 22, 37, 38, 39, 52, 53, 54, 55, 56,
57, 59, 60, 61, 63, 64, 65, 66, 67, 69, 71, 72, 73, 74, 75,
76, 77, 78, 79, 80, 81, 82, 83, 84, 86, 87, 88, 89, 88, 125,
101, 103, 124, 127, 134, 135, 25, 29, 37, 45, 165, 177, 163, 180, 138,
142, 113, 24, 28, 36, 40, 41, 44, 48, 49, 58, 59, 60, 61, 66,
67, 68, 69, 70, 71, 72, 73, 89, 92, 93, 145, 148, 149, 94, 105,
109, 151, 154, 161, 173, 96, 99, 100, 102, 104, 107, 108, 111, 114, 115,
116, 118, 119, 120, 122, 123, 126, 132, 133, 136, 137, 140, 141, 155, 156,
159, 160, 164, 169, 171, 172, 175, 176, 179, 181, 182, 183, 0, 1, 2,
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 20, 21, 22, 23, 26, 27, 30, 31, 32, 33, 34, 35, 38,
39, 42, 43, 46, 47, 50, 51, 52, 53, 54, 55, 56, 57, 62, 63,
64, 65, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
87, 90, 91, 95, 97, 98, 106, 110, 112, 117, 121, 128, 129, 130, 131,
139, 143, 144, 146, 147, 150, 152, 153, 157, 158, 162, 166, 167, 168, 170,
174, 178, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 0, 1, 2, 3,
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63,
64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78,
79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93,
94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108,
109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123,
124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138,
139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153,
154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168,
169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183,
184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198,
199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213,
214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258,
259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303,
304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363,
364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378,
379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393,
394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408,
409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423,
424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438,
439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453,
454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483,
484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498,
499, 500, 501, 502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513,
514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528,
529, 530, 531, 532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543,
544, 545, 546, 547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558,
559, 560, 561, 562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573,
574, 575, 576, 577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588,
589, 590, 591, 592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603,
604, 605, 606, 607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618,
619, 620, 621, 622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633,
634, 635, 636, 637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648,
649, 650, 651, 652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663,
664, 665, 666, 667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678,
679, 680, 681, 682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693,
694, 695, 696, 697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708,
709, 710, 711, 712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723,
724, 725, 726, 727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738,
739, 740, 741, 742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753,
754, 755, 756, 757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768,
769, 770, 771, 772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783,
784, 785, 786, 787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798,
799, 800, 801, 802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813,
814, 815, 816, 817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828,
829, 830, 831, 832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843,
844, 845, 846, 847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858,
859, 860, 861, 862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873,
874, 875, 876, 877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888,
889, 890, 891, 892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903,
904, 905, 906, 907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918,
919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933,
934, 935, 936, 937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948,
949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963,
964, 965, 966, 967, 968, 969, 970, 971, 306, 146, 158, 174, 216, 233, 27,
29, 121, 123, 125, 127, 144, 150, 152, 173, 188, 218, 295, 299, 307, 0,
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 30, 31, 32,
33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 122, 124,
126, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
142, 143, 145, 147, 148, 149, 151, 153, 154, 155, 156, 157, 159, 160, 161,
162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 175, 176, 177, 178,
179, 180, 181, 182, 183, 184, 185, 186, 187, 189, 190, 191, 192, 193, 194,
195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209,
210, 211, 212, 213, 214, 215, 217, 219, 220, 221, 222, 223, 224, 225, 226,
227, 228, 229, 230, 231, 232, 234, 235, 236, 237, 238, 239, 240, 241, 242,
243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257,
258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272,
273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287,
288, 289, 290, 291, 292, 293, 294, 296, 297, 298, 300, 301, 302, 303, 304,
305, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321,
322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336,
337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351,
352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366,
367, 368, 369, 370, 371, 372, 373, 374, 76, 106, 77, 107, 125, 115, 126,
60, 61, 71, 59, 96, 99, 110, 89, 70, 58, 25, 27, 33, 35, 86,
87, 72, 75, 79, 94, 112, 95, 100, 73, 74, 78, 101, 102, 105, 109,
88, 26, 32, 34, 103, 104, 108, 24, 97, 98, 113, 114, 44, 64, 69,
36, 38, 41, 43, 47, 54, 57, 63, 66, 111, 37, 39, 40, 42, 45,
46, 55, 56, 62, 65, 67, 68, 90, 92, 5, 11, 9, 84, 8, 4,
10, 2, 48, 50, 52, 81, 82, 0, 6, 12, 14, 85, 80, 83, 49,
51, 53, 91, 93, 118, 121, 124, 3, 17, 18, 21, 22, 29, 30, 1,
7, 13, 15, 116, 119, 122, 129, 16, 19, 20, 23, 28, 31, 117, 120,
123, 127, 128, 130, 3, 4, 5, 6, 25, 26, 27, 28, 29, 33, 41,
54, 61, 62, 99, 101, 105, 106, 107, 108, 133, 134, 0, 7, 30, 83,
86, 87, 88, 90, 91, 92, 93, 135, 136, 137, 1, 2, 31, 32, 34,
100, 102, 103, 104, 119, 132, 138, 139, 140, 16, 21, 22, 23, 24, 44,
51, 64, 65, 66, 67, 69, 71, 72, 73, 74, 75, 76, 8, 9, 10,
11, 12, 13, 14, 15, 35, 36, 42, 43, 46, 48, 49, 50, 52, 60,
63, 77, 78, 79, 80, 81, 82, 85, 89, 94, 95, 96, 97, 98, 109,
110, 111, 112, 113, 114, 115, 120, 121, 17, 18, 19, 20, 37, 38, 39,
40, 45, 47, 53, 55, 56, 57, 58, 59, 68, 70, 84, 116, 117, 118,
122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 141, 142, 143, 144, 145,
146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160,
161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 49, 18, 16, 17, 42, 45, 15, 8,
46, 39, 6, 48, 7, 9, 10, 41, 44, 5, 40, 43, 30, 47, 51,
52, 25, 19, 20, 21, 22, 23, 24, 3, 4, 29, 31, 32, 33, 34,
35, 36, 37, 38, 71, 73, 11, 12, 13, 14, 50, 70, 0, 1, 2,
26, 27, 28, 60, 62, 69, 61, 63, 64, 65, 72, 75, 76, 54, 55,
56, 57, 58, 59, 66, 68, 81, 82, 83, 84, 86, 74, 53, 67, 77,
78, 79, 80, 85, 87, 88, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 100, 31, 35, 41, 33, 30, 34, 40, 82, 81, 103, 47, 32, 15,
99, 46, 9, 21, 8, 69, 65, 67, 14, 62, 57, 58, 60, 80, 56,
20, 11, 97, 10, 85, 86, 1, 22, 26, 36, 16, 17, 78, 79, 105,
108, 5, 24, 28, 38, 44, 45, 59, 61, 63, 70, 109, 111, 0, 4,
25, 29, 39, 50, 51, 54, 55, 71, 72, 73, 74, 75, 76, 77, 95,
96, 101, 102, 104, 110, 98, 18, 19, 83, 84, 89, 23, 27, 37, 42,
43, 48, 113, 2, 3, 6, 7, 12, 13, 49, 52, 53, 87, 88, 90,
91, 92, 93, 94, 106, 107, 112, 64, 66, 68, 5, 4, 0, 39, 48,
17, 8, 6, 7, 77, 78, 75, 76, 79, 80, 16, 15, 73, 56, 55,
74, 40, 41, 42, 60, 9, 10, 11, 12, 13, 14, 59, 43, 62, 1,
2, 3, 44, 61, 58, 68, 22, 23, 28, 35, 36, 45, 46, 47, 57,
67, 69, 70, 71, 19, 18, 20, 21, 24, 25, 26, 27, 29, 30, 31,
32, 33, 34, 37, 38, 49, 50, 51, 52, 53, 54, 63, 64, 65, 66,
72, 81, 82, 83, 84, 34, 44, 71, 32, 43, 30, 35, 72, 33, 11,
10, 39, 37, 13, 38, 42, 36, 12, 41, 31, 8, 9, 40, 50, 69,
55, 20, 24, 28, 135, 1, 5, 15, 136, 70, 46, 51, 114, 115, 45,
3, 7, 17, 113, 116, 54, 128, 129, 134, 138, 0, 4, 14, 26, 19,
23, 27, 48, 62, 63, 68, 123, 124, 125, 126, 131, 132, 29, 49, 59,
60, 66, 127, 130, 133, 86, 110, 119, 57, 58, 65, 83, 87, 103, 111,
122, 18, 22, 82, 102, 61, 64, 67, 21, 25, 52, 2, 6, 16, 75,
76, 85, 90, 95, 99, 100, 109, 120, 56, 73, 74, 77, 78, 79, 80,
81, 84, 88, 89, 91, 92, 93, 94, 96, 97, 98, 101, 104, 105, 106,
107, 108, 112, 117, 118, 121, 137, 47, 53, 4, 5, 0, 1, 2, 3,
7, 8, 6, 9, 10, 20, 25, 27, 18, 19, 21, 23, 24, 26, 28,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 22, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 76, 96, 112, 109, 110, 94, 95, 49, 73, 56, 61, 65, 68,
102, 30, 37, 38, 40, 41, 44, 45, 47, 48, 55, 57, 59, 60, 79,
82, 88, 89, 90, 91, 92, 98, 100, 105, 108, 111, 0, 1, 2, 3,
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 34,
35, 36, 39, 42, 43, 46, 50, 51, 52, 53, 54, 58, 62, 63, 64,
66, 67, 69, 70, 71, 72, 74, 75, 77, 78, 80, 81, 83, 84, 85,
86, 87, 93, 97, 99, 101, 103, 104, 106, 107, 113, 91, 42, 46, 77,
26, 8, 78, 41, 43, 44, 47, 68, 5, 30, 45, 89, 90, 48, 49,
50, 51, 25, 76, 93, 14, 70, 88, 4, 23, 24, 29, 59, 63, 75,
79, 92, 97, 0, 1, 2, 6, 7, 15, 16, 17, 20, 21, 27, 31,
32, 33, 34, 35, 36, 62, 64, 67, 72, 61, 66, 71, 86, 94, 12,
74, 55, 58, 60, 81, 83, 3, 9, 10, 11, 13, 18, 19, 22, 28,
37, 38, 39, 40, 53, 56, 65, 69, 73, 82, 84, 85, 52, 54, 57,
80, 87, 95, 96, 1, 8, 10, 13, 12, 6, 2, 0, 11, 9, 5,
25, 7, 19, 43, 44, 45, 32, 33, 34, 50, 51, 52, 26, 22, 23,
3, 4, 28, 15, 36, 37, 49, 30, 31, 29, 14, 20, 21, 24, 27,
17, 39, 46, 16, 35, 53, 38, 40, 41, 42, 18, 47, 48, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 49, 310, 312,
314, 269, 271, 273, 275, 277, 279, 281, 297, 299, 0, 1, 2, 3, 4,
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50,
51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140,
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170,
171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185,
186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200,
201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215,
216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230,
231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245,
246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260,
261, 262, 263, 264, 265, 266, 267, 268, 270, 272, 274, 276, 278, 280, 282,
283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 298,
300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 311, 313, 315, 316, 317,
318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332,
333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347,
348, 349, 350, 351, 352, 353, 354, 355, 179, 200, 161, 175, 243, 100, 104,
196, 198, 223, 227, 176, 203, 212, 215, 162, 163, 247, 160, 174, 216, 218,
158, 172, 96, 157, 166, 170, 197, 199, 217, 219, 159, 173, 178, 201, 99,
101, 103, 105, 177, 202, 213, 214, 98, 102, 92, 108, 112, 116, 120, 124,
128, 132, 184, 192, 208, 180, 188, 204, 239, 249, 221, 225, 154, 165, 169,
51, 53, 55, 57, 59, 63, 67, 71, 75, 79, 83, 87, 95, 119, 123,
127, 131, 138, 142, 146, 150, 183, 191, 207, 236, 241, 245, 250, 61, 65,
69, 73, 77, 81, 85, 89, 93, 109, 113, 117, 140, 144, 148, 152, 8,
9, 14, 15, 20, 21, 50, 52, 54, 56, 91, 107, 111, 115, 121, 125,
129, 133, 134, 135, 136, 137, 141, 145, 149, 153, 155, 164, 168, 181, 187,
189, 195, 205, 211, 58, 62, 66, 70, 74, 78, 82, 86, 118, 122, 126,
130, 0, 1, 2, 3, 4, 5, 6, 7, 10, 11, 12, 13, 16, 17,
18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
60, 64, 68, 72, 76, 80, 84, 88, 139, 143, 147, 151, 186, 194, 210,
222, 226, 238, 242, 246, 248, 94, 97, 156, 167, 171, 228, 230, 90, 106,
110, 114, 220, 224, 237, 240, 244, 251, 182, 185, 190, 193, 206, 209, 229,
231, 232, 233, 234, 235, 24, 51, 54, 111, 25, 52, 55, 112, 13, 31,
34, 37, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 26, 27, 28, 29, 30,
32, 33, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48,
49, 50, 53, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 113, 114,
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129,
130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 0,
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 8, 16, 18, 7, 26, 30, 34, 104, 14, 15, 17, 19, 22,
48, 68, 73, 75, 79, 11, 1, 6, 20, 28, 32, 36, 38, 40, 44,
98, 102, 103, 105, 106, 115, 2, 13, 21, 23, 49, 53, 54, 55, 56,
57, 58, 60, 61, 64, 66, 67, 69, 76, 83, 85, 95, 100, 10, 0,
3, 4, 5, 9, 12, 24, 25, 27, 29, 31, 33, 35, 37, 39, 41,
42, 43, 45, 46, 47, 50, 51, 52, 59, 62, 63, 65, 70, 71, 72,
74, 77, 78, 80, 81, 82, 84, 86, 87, 88, 89, 90, 91, 92, 93,
94, 96, 97, 99, 101, 107, 108, 109, 110, 111, 112, 113, 114, 116, 117,
118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 121, 120, 103, 101, 102,
86, 111, 124, 27, 44, 100, 10, 13, 82, 92, 98, 78, 88, 94, 42,
40, 9, 11, 12, 14, 80, 84, 90, 96, 45, 119, 122, 46, 48, 50,
52, 104, 106, 109, 110, 1, 4, 18, 25, 29, 32, 19, 34, 22, 5,
8, 38, 107, 39, 16, 17, 21, 26, 30, 33, 43, 87, 125, 41, 83,
93, 99, 2, 24, 28, 31, 35, 53, 55, 81, 91, 97, 105, 0, 3,
7, 6, 15, 20, 23, 36, 37, 47, 49, 51, 54, 56, 57, 58, 59,
60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74,
75, 76, 77, 79, 85, 89, 95, 108, 112, 113, 114, 115, 116, 117, 118,
123, 161, 57, 60, 95, 169, 165, 171, 0, 160, 40, 168, 164, 39, 58,
59, 96, 1, 2, 50, 55, 64, 75, 85, 92, 97, 71, 77, 81, 87,
6, 16, 30, 44, 181, 170, 49, 56, 63, 76, 86, 91, 98, 174, 180,
5, 15, 29, 43, 72, 78, 82, 88, 113, 126, 194, 195, 198, 158, 159,
162, 163, 114, 125, 144, 145, 166, 167, 192, 193, 156, 47, 48, 51, 52,
53, 54, 61, 62, 65, 66, 83, 84, 89, 90, 93, 94, 99, 100, 101,
102, 103, 104, 130, 131, 132, 133, 134, 135, 152, 175, 176, 177, 67, 69,
73, 79, 105, 3, 4, 7, 8, 13, 14, 17, 18, 19, 20, 25, 26,
27, 28, 31, 32, 33, 34, 37, 38, 41, 42, 45, 46, 68, 70, 74,
80, 106, 117, 118, 142, 143, 178, 179, 138, 9, 140, 147, 148, 107, 109,
111, 139, 141, 146, 149, 182, 183, 184, 185, 190, 191, 115, 119, 121, 123,
137, 155, 157, 187, 189, 197, 10, 11, 12, 21, 22, 23, 24, 35, 36,
108, 110, 112, 116, 120, 122, 124, 127, 128, 129, 136, 150, 151, 153, 154,
173, 186, 188, 196, 172, 37, 36, 33, 32, 35, 34, 4, 2, 6, 0,
44, 45, 47, 46, 42, 43, 39, 41, 40, 38, 5, 7, 3, 1, 51,
17, 11, 15, 19, 9, 13, 10, 14, 18, 16, 23, 24, 27, 28, 31,
8, 12, 20, 22, 21, 25, 26, 29, 30, 49, 48, 50, 179, 176, 165,
178, 171, 175, 174, 177, 162, 168, 190, 188, 202, 200, 33, 75, 93, 51,
81, 87, 173, 164, 157, 114, 3, 6, 156, 15, 21, 27, 170, 167, 123,
63, 69, 39, 45, 57, 199, 211, 172, 208, 205, 214, 181, 184, 203, 196,
169, 198, 201, 160, 161, 137, 163, 125, 209, 119, 183, 215, 166, 207, 204,
213, 197, 191, 206, 210, 182, 212, 187, 185, 53, 83, 89, 192, 186, 193,
136, 180, 194, 130, 142, 154, 155, 148, 149, 131, 143, 116, 32, 74, 92,
122, 101, 107, 110, 113, 98, 104, 71, 65, 41, 47, 59, 2, 11, 14,
20, 26, 195, 189, 147, 150, 151, 145, 133, 127, 139, 126, 138, 132, 144,
117, 159, 52, 82, 88, 158, 120, 96, 102, 108, 99, 105, 111, 30, 72,
90, 8, 5, 9, 0, 124, 97, 103, 109, 12, 18, 24, 48, 78, 84,
66, 60, 70, 62, 35, 77, 95, 68, 42, 50, 80, 86, 17, 23, 29,
36, 54, 38, 44, 56, 152, 153, 64, 40, 58, 46, 128, 140, 129, 134,
135, 141, 146, 106, 100, 112, 121, 7, 4, 115, 118, 34, 61, 76, 94,
16, 22, 28, 37, 43, 55, 49, 79, 85, 67, 1, 13, 19, 25, 31,
73, 91, 10, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
102, 103, 104, 105, 106, 107, 108, 109, 110, 2, 5, 8, 11, 14, 17,
20, 23, 26, 29, 32, 35, 38, 41, 44, 47, 50, 53, 56, 59, 62,
65, 68, 0, 1, 3, 4, 6, 7, 9, 10, 12, 13, 15, 16, 18,
19, 21, 22, 24, 25, 27, 28, 30, 31, 33, 34, 36, 37, 39, 40,
42, 43, 45, 46, 48, 49, 51, 52, 54, 55, 57, 58, 60, 61, 63,
64, 66, 67, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
53, 52, 72, 71, 73, 70, 97, 98, 96, 99, 68, 80, 82, 74, 77,
78, 5, 22, 25, 41, 49, 1, 9, 17, 95, 103, 102, 104, 75, 76,
79, 66, 69, 93, 67, 94, 81, 83, 84, 85, 86, 87, 88, 89, 90,
91, 106, 107, 92, 100, 101, 105, 32, 34, 38, 12, 15, 54, 58, 62,
39, 14, 36, 57, 61, 65, 31, 35, 47, 29, 45, 42, 28, 44, 30,
46, 18, 16, 55, 59, 63, 40, 21, 26, 50, 3, 7, 11, 19, 0,
4, 8, 33, 37, 20, 23, 24, 27, 43, 48, 51, 2, 6, 10, 13,
56, 60, 64, 0, 2, 1, 11, 5, 6, 12, 3, 4, 9, 10, 14,
7, 8, 13, 21, 36, 18, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 37, 15, 16, 22, 17, 19, 20, 0, 1, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 48, 5, 34, 63,
4, 62, 50, 47, 49, 33, 35, 36, 29, 3, 6, 61, 64, 54, 58,
45, 32, 51, 56, 60, 70, 57, 40, 46, 11, 55, 59, 44, 53, 65,
72, 14, 15, 17, 20, 22, 27, 66, 68, 69, 71, 26, 19, 67, 1,
9, 12, 7, 25, 24, 28, 30, 31, 10, 8, 16, 18, 21, 23, 52,
0, 2, 41, 42, 43, 13, 37, 38, 39, 107, 15, 97, 100, 101, 105,
99, 33, 81, 79, 80, 34, 92, 95, 86, 48, 118, 41, 43, 119, 35,
36, 37, 75, 102, 103, 104, 23, 24, 25, 26, 31, 4, 17, 19, 21,
22, 27, 38, 39, 52, 56, 58, 64, 70, 72, 82, 47, 87, 51, 55,
57, 77, 78, 98, 116, 117, 28, 29, 30, 32, 40, 42, 5, 7, 9,
93, 96, 1, 2, 3, 6, 8, 10, 12, 54, 59, 65, 66, 68, 69,
71, 73, 74, 76, 83, 84, 89, 90, 106, 109, 111, 112, 114, 44, 45,
46, 49, 50, 11, 53, 16, 18, 20, 0, 13, 14, 60, 61, 62, 63,
67, 85, 88, 91, 94, 108, 110, 113, 115, 13, 4, 46, 47, 2, 6,
37, 38, 43, 51, 54, 55, 58, 67, 69, 0, 1, 3, 5, 7, 8,
9, 10, 11, 12, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 39, 40, 41,
42, 44, 45, 48, 49, 50, 52, 53, 56, 57, 59, 60, 61, 62, 63,
64, 65, 66, 68, 70, 71, 72, 73, 74, 75, 7, 4, 6, 5, 2,
3, 9, 8, 0, 1, 23, 22, 24, 25, 14, 26, 30, 34, 10, 11,
12, 13, 15, 16, 17, 18, 19, 20, 21, 27, 28, 29, 31, 32, 33,
35, 36, 37, 0, 1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
70, 71, 72, 73, 0, 1, 2, 3, 4, 4, 0, 1, 2, 3, 5,
6, 7, 8, 0, 1, 2, 3, 4, 5, 323, 139, 149, 165, 207, 234,
320, 296, 300, 20, 44, 45, 52, 138, 147, 189, 191, 192, 193, 210, 213,
215, 217, 226, 232, 236, 238, 293, 322, 325, 74, 122, 306, 150, 264, 4,
5, 197, 201, 117, 172, 188, 195, 203, 222, 244, 245, 265, 271, 291, 292,
332, 2, 18, 19, 22, 34, 46, 57, 82, 84, 85, 88, 89, 120, 130,
133, 134, 136, 137, 140, 142, 143, 145, 146, 148, 153, 159, 160, 161, 162,
166, 169, 173, 184, 185, 209, 211, 219, 228, 229, 231, 237, 240, 242, 243,
246, 247, 248, 251, 253, 254, 257, 286, 294, 298, 324, 335, 33, 98, 118,
200, 204, 303, 305, 327, 100, 196, 205, 275, 123, 126, 282, 0, 1, 3,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 21, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 35, 36, 37, 38, 39, 40, 41,
42, 43, 47, 48, 49, 50, 51, 53, 54, 55, 56, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 75, 76, 77,
78, 79, 80, 81, 83, 86, 87, 90, 91, 92, 93, 94, 95, 96, 97,
99, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
115, 116, 119, 121, 124, 125, 127, 128, 129, 131, 132, 135, 141, 144, 151,
152, 154, 155, 156, 157, 158, 163, 164, 167, 168, 170, 171, 174, 175, 176,
177, 178, 179, 180, 181, 182, 183, 186, 187, 190, 194, 198, 199, 202, 206,
208, 212, 214, 216, 218, 220, 221, 223, 224, 225, 227, 230, 233, 235, 239,
241, 249, 250, 252, 255, 256, 258, 259, 260, 261, 262, 263, 266, 267, 268,
269, 270, 272, 273, 274, 276, 277, 278, 279, 280, 281, 283, 284, 285, 287,
288, 289, 290, 295, 297, 299, 301, 302, 304, 307, 308, 309, 310, 311, 312,
313, 314, 315, 316, 317, 318, 319, 321, 326, 328, 329, 330, 331, 333, 334,
336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350,
351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
107, 108, 109, 4, 5, 18, 20, 0, 1, 2, 3, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 23, 24, 25, 26,
0, 1, 2, 3, 4, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
115, 116, 117, 118, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 38, 40, 39, 65, 63, 66, 26, 28,
11, 20, 24, 32, 108, 8, 47, 45, 48, 49, 105, 109, 139, 75, 124,
18, 22, 30, 34, 111, 102, 114, 118, 77, 123, 133, 1, 5, 17, 46,
69, 73, 81, 29, 78, 101, 37, 50, 64, 9, 51, 55, 61, 76, 68,
72, 84, 2, 6, 14, 19, 23, 35, 67, 71, 79, 83, 107, 113, 115,
117, 137, 147, 36, 10, 27, 53, 57, 59, 135, 13, 103, 104, 126, 3,
7, 15, 41, 44, 54, 58, 60, 70, 74, 80, 82, 0, 4, 12, 16,
21, 25, 31, 33, 42, 43, 52, 56, 62, 85, 88, 91, 94, 106, 110,
112, 116, 119, 120, 121, 122, 125, 127, 128, 129, 130, 131, 132, 134, 136,
138, 140, 141, 142, 143, 144, 145, 146, 148, 89, 86, 87, 90, 92, 93,
95, 96, 97, 98, 99, 100, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 1, 2, 4, 32, 36, 38, 3, 34, 28, 31, 35,
37, 6, 12, 14, 19, 20, 22, 33, 39, 43, 53, 54, 55, 56, 57,
61, 67, 69, 70, 71, 30, 0, 5, 7, 8, 9, 10, 11, 13, 15,
16, 17, 18, 21, 23, 24, 25, 26, 27, 29, 40, 41, 42, 44, 45,
46, 47, 48, 49, 50, 51, 52, 58, 59, 60, 62, 63, 64, 65, 66,
68, 72, 16, 28, 34, 38, 42, 2, 14, 15, 18, 19, 26, 29, 30,
31, 32, 33, 40, 43, 0, 1, 3, 4, 5, 6, 7, 8, 9, 10,
11, 12, 13, 17, 20, 21, 22, 23, 24, 25, 27, 35, 36, 37, 39,
41, 2, 0, 7, 1, 86, 5, 74, 21, 89, 85, 88, 3, 4, 6,
51, 23, 111, 70, 56, 90, 98, 27, 78, 53, 68, 80, 87, 116, 12,
25, 109, 114, 103, 108, 110, 9, 57, 62, 65, 91, 96, 99, 69, 71,
72, 73, 81, 49, 50, 52, 93, 101, 36, 55, 64, 125, 19, 20, 22,
106, 41, 8, 11, 13, 29, 34, 37, 54, 102, 107, 118, 123, 126, 14,
15, 16, 18, 82, 83, 84, 92, 97, 100, 104, 112, 17, 32, 121, 94,
24, 113, 76, 77, 79, 10, 61, 95, 26, 28, 30, 31, 35, 38, 39,
40, 46, 58, 59, 60, 63, 66, 67, 75, 105, 115, 117, 119, 120, 124,
127, 128, 33, 42, 43, 44, 45, 47, 48, 122, 0, 1, 2, 3, 4,
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 2, 0, 1, 3, 4,
5, 6, 7, 8, 82, 11, 26, 19, 75, 6, 9, 47, 54, 66, 73,
80, 87, 0, 3, 4, 5, 18, 23, 24, 25, 44, 53, 62, 63, 65,
67, 68, 69, 70, 72, 76, 77, 86, 88, 89, 90, 91, 92, 93, 22,
10, 15, 21, 49, 58, 50, 59, 83, 1, 2, 7, 8, 12, 13, 14,
16, 17, 20, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 45, 46, 48, 51, 52, 55, 56, 57, 60, 61,
64, 71, 74, 78, 79, 81, 84, 85, 0, 1, 0, 1, 34, 2, 12,
13, 32, 37, 76, 3, 10, 11, 19, 20, 21, 22, 23, 27, 28, 29,
30, 35, 53, 55, 78, 4, 16, 17, 5, 6, 7, 8, 9, 14, 15,
18, 24, 25, 26, 31, 33, 36, 38, 39, 40, 41, 42, 43, 44, 45,
46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 59, 60, 61, 62,
63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 77, 79,
80, 81, 82, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
12, 13, 14, 15, 5, 30, 31, 0, 1, 2, 3, 4, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 32, 33, 34, 35, 36, 37, 59, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 60, 61, 62, 63,
64, 65, 36, 61, 20, 1, 19, 126, 127, 60, 56, 33, 34, 35, 21,
22, 52, 59, 67, 71, 72, 63, 65, 66, 32, 45, 57, 84, 91, 114,
125, 64, 0, 2, 3, 68, 70, 73, 26, 46, 53, 54, 55, 58, 115,
131, 74, 12, 96, 97, 99, 41, 42, 44, 49, 50, 75, 80, 83, 85,
103, 106, 107, 108, 109, 110, 111, 112, 113, 116, 117, 118, 119, 120, 124,
13, 62, 76, 77, 78, 86, 128, 129, 94, 23, 24, 25, 27, 28, 29,
30, 31, 37, 38, 39, 40, 43, 47, 48, 51, 4, 5, 6, 7, 8,
9, 10, 11, 14, 15, 16, 17, 18, 69, 79, 81, 82, 87, 88, 89,
90, 92, 93, 95, 98, 100, 101, 102, 104, 105, 121, 122, 123, 130, 132,
3, 2, 10, 11, 1, 4, 6, 8, 5, 7, 9, 0, 31, 30, 15,
43, 49, 53, 57, 45, 12, 13, 16, 18, 32, 34, 36, 14, 33, 35,
37, 21, 23, 17, 19, 20, 22, 24, 25, 26, 27, 28, 29, 42, 48,
52, 56, 38, 41, 44, 46, 50, 54, 39, 40, 47, 51, 55, 35, 36,
3, 5, 7, 9, 11, 2, 17, 30, 34, 14, 20, 23, 4, 6, 13,
16, 18, 19, 22, 24, 25, 31, 32, 33, 8, 10, 12, 15, 21, 0,
1, 26, 27, 28, 29, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 42, 43, 44, 45, 46, 47, 5, 4, 6, 21, 0, 3, 18,
16, 15, 17, 9, 12, 20, 7, 14, 19, 8, 10, 11, 13, 1, 2,
167, 168, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162,
163, 164, 165, 166, 0, 1, 2, 3, 4, 5, 6, 7, 8, 0, 1,
2, 3, 7, 6, 8, 9, 16, 2, 18, 19, 28, 27, 24, 25, 26,
17, 3, 20, 22, 21, 23, 13, 0, 4, 14, 1, 5, 12, 10, 11,
15, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 12, 13,
14, 15, 16, 17, 18, 19, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 18, 22, 28, 35, 53, 54, 57, 59, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 19, 20, 21, 23, 24, 25, 26, 27, 29, 30, 31, 32, 33, 34,
36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
51, 52, 55, 56, 58, 9, 13, 4, 6, 11, 15, 8, 12, 5, 7,
10, 14, 2, 3, 0, 1, 0, 3, 4, 7, 1, 2, 5, 6, 8,
9, 10, 0, 1, 2, 65, 64, 66, 52, 46, 49, 53, 59, 44, 48,
45, 57, 34, 25, 26, 27, 36, 56, 24, 43, 47, 0, 1, 2, 3,
4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 28, 29, 30, 31, 32, 33, 35, 37, 38, 39,
40, 41, 42, 50, 51, 54, 55, 58, 60, 61, 62, 63, 0, 1, 2,
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
108, 109, 110, 111, 112, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 42, 43, 44, 45, 46, 47, 48, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158,
159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173,
174, 175, 84, 86, 5, 16, 18, 21, 81, 82, 3, 6, 10, 12, 14,
22, 24, 26, 29, 39, 41, 42, 54, 56, 58, 60, 62, 75, 0, 1,
2, 4, 7, 8, 9, 11, 13, 15, 17, 19, 20, 23, 25, 27, 28,
30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 55, 57, 59, 61, 63, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 76, 77, 78, 79, 80, 83, 85, 0,
2, 4, 6, 14, 16, 18, 20, 8, 31, 10, 11, 24, 25, 28, 29,
32, 33, 36, 38, 40, 41, 44, 45, 9, 30, 1, 3, 5, 7, 12,
13, 15, 17, 19, 21, 22, 23, 26, 27, 34, 35, 37, 39, 42, 43,
46, 47, 27, 28, 35, 36, 45, 46, 13, 14, 59, 60, 0, 1, 2,
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 16, 17, 18, 19,
20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 37, 38,
39, 40, 41, 42, 43, 44, 47, 48, 49, 50, 51, 52, 53, 54, 55,
56, 57, 58, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117,
118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147,
148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162,
163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177,
178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192,
193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222,
223, 224, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 0, 4, 1, 2, 3, 7, 5, 9, 6, 8,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
30, 31, 32, 33, 34, 35, 36, 37, 8, 11, 9, 10, 0, 1, 4,
5, 2, 3, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56,
57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71,
72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86,
87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101,
102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116,
117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131,
132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146,
147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161,
162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176,
177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206,
207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221,
222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236,
237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251,
252, 253, 254, 255, 256, 257, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
35, 1, 2, 20, 29, 32, 33, 34, 0, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24,
25, 26, 27, 28, 30, 31, 36, 37, 38, 39, 40, 41, 42, 43, 44,
45, 46, 47, 48, 49, 50, 51, 52, 53, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
36, 37, 38, 39, 40, 0, 1, 0, 1, 2, 3, 4, 5, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121,
122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136,
137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151,
152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166,
167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181,
182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211,
212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226,
227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241,
242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256,
257, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
29, 0, 1, 4, 27, 19, 21, 5, 18, 6, 8, 10, 11, 12, 14,
15, 16, 17, 20, 0, 1, 2, 3, 7, 9, 13, 22, 23, 24, 25,
26, 28, 29, 30, 31, 32, 33, 34, 35, 0, 1, 2, 3, 4, 0,
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 112, 110, 113, 111, 29, 37, 18, 93, 96, 97, 99,
98, 92, 100, 104, 105, 108, 101, 61, 62, 69, 77, 86, 70, 78, 85,
68, 76, 87, 60, 54, 55, 59, 30, 38, 73, 81, 90, 94, 19, 14,
16, 71, 79, 84, 50, 51, 57, 0, 2, 4, 6, 8, 10, 12, 20,
26, 34, 44, 64, 72, 80, 91, 40, 63, 13, 5, 7, 9, 11, 15,
1, 3, 39, 21, 48, 49, 56, 95, 74, 82, 89, 31, 25, 33, 45,
65, 43, 103, 106, 107, 109, 17, 52, 53, 58, 28, 36, 41, 23, 27,
35, 47, 42, 66, 22, 24, 32, 46, 67, 75, 83, 88, 102, 6, 7,
0, 1, 3, 5, 2, 4, 50, 48, 52, 54, 56, 2, 6, 14, 18,
22, 26, 30, 34, 49, 53, 55, 57, 58, 59, 60, 0, 1, 3, 4,
5, 7, 8, 9, 10, 11, 12, 13, 15, 16, 17, 19, 20, 21, 23,
24, 25, 27, 28, 29, 31, 32, 33, 35, 36, 37, 38, 39, 40, 41,
42, 43, 44, 45, 46, 47, 51, 23, 24, 25, 26, 16, 18, 20, 22,
15, 17, 19, 21, 6, 8, 10, 12, 14, 0, 2, 1, 3, 4, 5,
11, 7, 9, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25,
26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40,
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70,
71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85,
86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100,
101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130,
131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 1, 0,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 0, 1, 2, 112, 114, 19, 61, 70,
18, 111, 3, 5, 6, 66, 82, 109, 110, 113, 58, 102, 104, 31, 35,
36, 37, 38, 71, 77, 86, 93, 95, 96, 108, 47, 25, 45, 46, 53,
55, 75, 40, 41, 42, 52, 60, 83, 84, 24, 26, 11, 12, 22, 23,
28, 30, 57, 63, 65, 69, 81, 90, 106, 32, 33, 34, 49, 50, 51,
72, 73, 78, 79, 87, 88, 94, 4, 7, 8, 9, 10, 20, 21, 29,
39, 43, 44, 48, 54, 56, 59, 62, 64, 67, 68, 74, 76, 80, 89,
91, 92, 100, 101, 115, 116, 16, 99, 13, 14, 15, 17, 27, 85, 97,
98, 103, 105, 107, 117, 7, 10, 19, 0, 1, 2, 3, 4, 5, 6,
8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 0, 1, 2, 3, 4,
5, 7, 17, 0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12,
13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 0, 1, 0, 7, 11,
5, 6, 10, 3, 4, 1, 2, 8, 9, 12, 0, 1, 2, 3, 4,
0, 1, 2, 3, 4, 1, 3, 0, 2, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 0, 1, 2, 3, 4,
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
35, 36, 0, 1, 75, 78, 76, 15, 79, 77, 8, 85, 14, 0, 4,
10, 81, 83, 84, 87, 12, 80, 82, 11, 9, 2, 6, 86, 36, 38,
37, 13, 1, 5, 3, 7, 49, 22, 24, 28, 32, 50, 58, 63, 66,
71, 23, 25, 29, 33, 47, 48, 51, 52, 53, 54, 46, 17, 19, 16,
20, 21, 26, 27, 30, 31, 34, 35, 39, 40, 41, 42, 43, 44, 45,
55, 56, 57, 59, 60, 61, 62, 64, 65, 67, 68, 69, 70, 72, 73,
74, 18, 11, 22, 1, 3, 5, 7, 9, 10, 13, 15, 16, 18, 20,
26, 28, 0, 2, 4, 6, 8, 12, 14, 17, 19, 21, 23, 24, 25,
27, 29, 47, 45, 43, 48, 42, 44, 49, 46, 33, 11, 27, 31, 37,
38, 63, 17, 18, 21, 23, 25, 29, 32, 35, 77, 83, 97, 0, 5,
9, 15, 16, 19, 39, 41, 53, 69, 20, 22, 24, 26, 28, 30, 34,
36, 76, 82, 96, 102, 103, 1, 3, 7, 13, 40, 51, 57, 61, 67,
71, 73, 75, 81, 87, 95, 101, 106, 107, 70, 2, 4, 6, 8, 10,
12, 14, 50, 52, 54, 55, 56, 58, 59, 60, 62, 64, 65, 66, 68,
72, 74, 78, 79, 80, 84, 85, 86, 88, 89, 90, 91, 92, 93, 94,
98, 99, 100, 104, 105, 108, 109, 0, 1, 46, 43, 47, 42, 3, 44,
5, 20, 4, 18, 24, 26, 30, 38, 34, 36, 7, 9, 22, 2, 45,
21, 40, 19, 35, 37, 39, 32, 12, 14, 28, 10, 16, 41, 25, 27,
31, 6, 8, 23, 33, 11, 17, 13, 15, 29, 52, 50, 53, 48, 49,
51, 0, 1, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125,
126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140,
141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155,
156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170,
171, 172, 173, 174, 175, 176, 177, 178, 179, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35,
36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80,
81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
111, 112, 113, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
27, 28, 29, 30, 31, 32, 33, 34, 35, 5, 15, 19, 27, 31, 35,
39, 43, 96, 104, 120, 121, 131, 0, 1, 2, 10, 12, 24, 25, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 76, 77, 78, 79, 80,
81, 82, 83, 84, 85, 86, 87, 88, 90, 91, 93, 95, 97, 99, 101,
103, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118,
119, 122, 123, 124, 125, 126, 127, 128, 129, 130, 132, 133, 134, 135, 136,
137, 138, 140, 144, 148, 152, 156, 160, 164, 3, 4, 6, 7, 8, 9,
11, 13, 14, 16, 17, 18, 20, 21, 22, 23, 26, 28, 29, 30, 32,
33, 34, 36, 37, 38, 40, 41, 42, 44, 45, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 89,
92, 94, 98, 100, 102, 139, 141, 142, 143, 145, 146, 147, 149, 150, 151,
153, 154, 155, 157, 158, 159, 161, 162, 163, 165, 166, 36, 57, 60, 65,
68, 114, 135, 156, 161, 162, 165, 170, 176, 179, 182, 183, 188, 191, 194,
197, 198, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43,
44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 58, 59,
61, 62, 63, 64, 66, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77,
78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
108, 109, 110, 111, 112, 113, 115, 116, 117, 118, 119, 120, 121, 122, 123,
124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 136, 137, 138, 139,
140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154,
155, 157, 158, 159, 160, 163, 164, 166, 167, 168, 169, 171, 172, 173, 174,
175, 177, 178, 180, 181, 184, 185, 186, 187, 189, 190, 192, 193, 195, 196,
199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213,
214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228,
229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258,
259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273,
274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288,
289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303,
304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318,
319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333,
334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348,
349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363,
364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378,
379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393,
394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408,
409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423,
424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438,
439, 440, 441, 442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453,
454, 455, 456, 457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468,
469, 470, 471, 472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483,
484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498,
499, 500, 501, 502, 503, 504, 505, 506, 0, 1, 2, 3, 4, 5, 6,
7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54,
55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,
85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99,
100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114,
115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129,
130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144,
145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174,
175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,
190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204,
205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219,
220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234,
235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249,
250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264,
265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279,
280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294,
295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309,
310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324,
325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339,
340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354,
355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369,
370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384,
385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399,
400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411, 412, 413, 414,
415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426, 427, 428, 429,
430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441, 442, 443, 444,
445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456, 457, 458, 459,
460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471, 472, 473, 474,
475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489,
490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501, 502, 503, 504,
505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519,
520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531, 532, 533, 534,
535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546, 547, 548, 549,
550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561, 562, 563, 564,
565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579,
580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591, 592, 593, 594,
595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606, 607, 608, 609,
610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621, 622, 623, 624,
625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636, 637, 638, 639,
640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651, 652, 653, 654,
655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666, 667, 668, 669,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 0, 1, 2, 3, 4, 5, 6, 7,
8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52,
53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67,
68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82,
83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97,
98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
158, 159, 160, 161, 162, 163, 164, 165, 166, 0, 1, 2, 3, 4, 5,
6, 7, 8, 9, 10, 11, 12, 13, 14, 0, 1, 2, 3, 4, 5,
0, 3, 5, 10, 16, 18, 94, 4, 6, 7, 8, 17, 37, 44, 48,
51, 56, 66, 69, 75, 79, 82, 84, 88, 98, 99, 102, 1, 2, 9,
11, 12, 13, 14, 15, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
29, 30, 31, 32, 33, 34, 35, 36, 38, 39, 40, 41, 42, 43, 45,
46, 47, 49, 50, 52, 53, 54, 55, 57, 58, 59, 60, 61, 62, 63,
64, 65, 67, 68, 70, 71, 72, 73, 74, 76, 77, 78, 80, 81, 83,
85, 86, 87, 89, 90, 91, 92, 93, 95, 96, 97, 100, 101, 103, 104,
105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179,
180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194,
81, 18, 24, 33, 69, 83, 19, 25, 35, 71, 0, 1, 2, 3, 4,
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21,
22, 23, 26, 27, 28, 29, 30, 31, 32, 34, 36, 37, 38, 39, 40,
41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 70, 72,
73, 74, 75, 76, 77, 78, 79, 80, 82, 84, 85, 86, 87, 88, 89,
90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149,
150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164,
165, 166, 167, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
12, 13, 14, 15, 16, 17, 4, 5, 6, 31, 32, 39, 40, 41, 0,
1, 2, 3, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 33, 34, 35,
36, 37, 38, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
129, 130, 131, 132, 133, 134, 135, 136, 0, 1, 3, 22, 23, 26, 34,
0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 20, 21, 24, 25, 27, 28, 29, 30, 31, 32, 33,
35, 36, 37, 38, 39, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 0,
1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60,
61, 62, 63, 64, 65, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
25, 26, 27, 28, 29, 30, 31, 32, 33, 51, 0, 1, 2, 3, 4,
5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34,
35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
50, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65,
66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 0, 1, 2,
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46,
47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76,
77, 74, 75, 92, 93, 116, 143, 144, 149, 14, 15, 34, 35, 36, 37,
68, 69, 98, 99, 104, 105, 110, 111, 154, 155, 156, 157, 166, 167, 168,
169, 178, 179, 180, 181, 4, 5, 6, 7, 22, 23, 24, 25, 46, 47,
50, 51, 56, 57, 60, 61, 80, 82, 85, 87, 121, 122, 123, 124, 133,
134, 135, 136, 190, 191, 194, 197, 202, 203, 206, 207, 212, 213, 216, 217,
0, 1, 2, 3, 8, 9, 10, 11, 12, 13, 16, 17, 18, 19, 20,
21, 26, 27, 28, 29, 30, 31, 32, 33, 38, 39, 40, 41, 42, 43,
44, 45, 48, 49, 52, 53, 54, 55, 58, 59, 62, 63, 64, 65, 66,
67, 70, 71, 72, 73, 76, 77, 78, 79, 81, 83, 84, 86, 88, 89,
90, 91, 94, 95, 96, 97, 100, 101, 102, 103, 106, 107, 108, 109, 112,
113, 114, 115, 117, 118, 119, 120, 125, 126, 127, 128, 129, 130, 131, 132,
137, 138, 139, 140, 141, 142, 145, 146, 147, 148, 150, 151, 152, 153, 158,
159, 160, 161, 162, 163, 164, 165, 170, 171, 172, 173, 174, 175, 176, 177,
182, 183, 184, 185, 186, 187, 188, 189, 192, 193, 195, 196, 198, 199, 200,
201, 204, 205, 208, 209, 210, 211, 214, 215, 218, 219, 220, 221, 0, 1,
2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 0, 1, 2,
3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62,
63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77,
78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92,
93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122,
123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137,
138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152,
153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167,
168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182,
183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197,
198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227,
228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242,
243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257,
258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272,
273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287,
288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302,
303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317,
318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332,
333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347,
348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362,
363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377,
0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14,
15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 0, 1, 2, 3,
4, 5, 6, 7, 0, 1, 14, 15, 16, 17, 2, 3, 4, 5, 8,
9, 10, 11, 12, 13, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 11, 2, 5, 10, 8, 4, 9, 1, 7,
3, 0, 6, 42, 45, 36, 39, 12, 16, 18, 22, 38, 41, 44, 47,
37, 40, 43, 46, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
11, 13, 14, 15, 17, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29,
30, 31, 32, 33, 34, 35, 0, 1, 2, 3, 4, 5, 6, 7, 8,
9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38,
39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68,
69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83,
84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98,
99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128,
129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158,
159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173,
174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188,
189, 190, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12,
13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57,
58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102,
103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 4, 5,
6, 8, 1, 3, 0, 2, 7, 9, 0, 1, 2, 3, 4, 5, 6,
7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36,
37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66,
67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111,
112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126,
127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141,
142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156,
157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171,
172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186,
187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201,
202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216,
217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231,
232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246,
247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261,
262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276,
277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291,
292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306,
307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321,
322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336,
337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351,
352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366,
367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378, 379, 380, 381,
382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 392, 393, 394, 395, 396,
397, 398, 399, 400, 401, 402, 403, 404, 405, 406, 407, 408, 409, 410, 411,
412, 413, 414, 415, 416, 417, 418, 419, 420, 421, 422, 423, 424, 425, 426,
427, 428, 429, 430, 431, 432, 433, 434, 435, 436, 437, 438, 439, 440, 441,
442, 443, 444, 445, 446, 447, 448, 449, 450, 451, 452, 453, 454, 455, 456,
457, 458, 459, 460, 461, 462, 463, 464, 465, 466, 467, 468, 469, 470, 471,
472, 473, 474, 475, 476, 477, 478, 479, 480, 481, 482, 483, 484, 485, 486,
487, 488, 489, 490, 491, 492, 493, 494, 495, 496, 497, 498, 499, 500, 501,
502, 503, 504, 505, 506, 507, 508, 509, 510, 511, 512, 513, 514, 515, 516,
517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 529, 530, 531,
532, 533, 534, 535, 536, 537, 538, 539, 540, 541, 542, 543, 544, 545, 546,
547, 548, 549, 550, 551, 552, 553, 554, 555, 556, 557, 558, 559, 560, 561,
562, 563, 564, 565, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576,
577, 578, 579, 580, 581, 582, 583, 584, 585, 586, 587, 588, 589, 590, 591,
592, 593, 594, 595, 596, 597, 598, 599, 600, 601, 602, 603, 604, 605, 606,
607, 608, 609, 610, 611, 612, 613, 614, 615, 616, 617, 618, 619, 620, 621,
622, 623, 624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636,
637, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649, 650, 651,
652, 653, 654, 655, 656, 657, 658, 659, 660, 661, 662, 663, 664, 665, 666,
667, 668, 669, 670, 671, 672, 673, 674, 675, 676, 677, 678, 679, 680, 681,
682, 683, 684, 685, 686, 687, 688, 689, 690, 691, 692, 693, 694, 695, 696,
697, 698, 699, 700, 701, 702, 703, 704, 705, 706, 707, 708, 709, 710, 711,
712, 713, 714, 715, 716, 717, 718, 719, 720, 721, 722, 723, 724, 725, 726,
727, 728, 729, 730, 731, 732, 733, 734, 735, 736, 737, 738, 739, 740, 741,
742, 743, 744, 745, 746, 747, 748, 749, 750, 751, 752, 753, 754, 755, 756,
757, 758, 759, 760, 761, 762, 763, 764, 765, 766, 767, 768, 769, 770, 771,
772, 773, 774, 775, 776, 777, 778, 779, 780, 781, 782, 783, 784, 785, 786,
787, 788, 789, 790, 791, 792, 793, 794, 795, 796, 797, 798, 799, 800, 801,
802, 803, 804, 805, 806, 807, 808, 809, 810, 811, 812, 813, 814, 815, 816,
817, 818, 819, 820, 821, 822, 823, 824, 825, 826, 827, 828, 829, 830, 831,
832, 833, 834, 835, 836, 837, 838, 839, 840, 841, 842, 843, 844, 845, 846,
847, 848, 849, 850, 851, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861,
862, 863, 864, 865, 866, 867, 868, 869, 870, 871, 872, 873, 874, 875, 876,
877, 878, 879, 880, 881, 882, 883, 884, 885, 886, 887, 888, 889, 890, 891,
892, 893, 894, 895, 896, 897, 898, 899, 900, 901, 902, 903, 904, 905, 906,
907, 908, 909, 910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921,
922, 923, 924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936,
937, 938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951,
952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966,
967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 980, 981,
982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 994, 995, 996,
997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011,
1012, 1013, 1014, 1015, 1016, 1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026,
1027, 1028, 1029, 1030, 1031, 1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041,
1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056,
1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071,
1072, 1073, 1074, 1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086,
1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101,
1102, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116,
1117, 1118, 1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 1130, 1131,
1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 1141, 1142, 1143, 1144, 1145, 1146,
1147, 1148, 1149, 1150, 1151, 1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161,
1162, 1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 1174, 1175, 1176,
1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189, 1190, 1191,
1192, 1193, 1194, 1195, 1196, 1197, 1198, 1199, 1200, 1201, 1202, 1203, 1204, 1205, 1206,
1207, 1208, 1209, 1210, 1211, 1212, 1213, 1214, 1215, 1216, 1217, 1218, 1219, 1220, 1221,
1222, 1223, 1224, 1225, 1226, 1227, 1228, 1229, 1230, 1231, 1232, 1233, 1234, 1235, 1236,
1237, 1238, 1239, 1240, 1241, 1242, 1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 1251,
1252, 1253, 1254, 1255, 1256, 1257, 1258, 1259, 1260, 1261, 1262, 1263, 1264, 1265, 1266,
1267, 1268, 1269, 1270, 1271, 1272, 1273, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281,
1282, 1283, 1284, 1285, 1286, 1287, 1288, 1289, 1290, 1291, 1292, 1293, 1294, 1295, 1296,
1297, 1298, 1299, 1300, 1301, 1302, 1303, 1304, 1305, 1306, 1307, 1308, 1309, 1310, 1311,
1312, 1313, 1314, 1315, 1316, 1317, 1318, 1319, 1320, 1321, 1322, 1323, 1324, 1325, 1326,
1327, 1328, 1329, 1330, 1331, 1332, 1333, 1334, 1335, 1336, 1337, 1338, 1339, 1340, 1341,
1342, 1343, 1344, 1345, 1346, 1347, 1348, 1349, 1350, 1351, 1352, 1353, 1354, 1355, 1356,
1357, 1358, 1359, 1360, 1361, 1362, 1363, 1364, 1365, 1366, 1367, 1368, 1369, 1370, 1371,
1372, 1373, 1374, 1375, 1376, 1377, 1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386,
1387, 1388, 1389, 1390, 1391, 1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401,
1402, 1403, 1404, 1405, 1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1415, 1416,
1417, 1418, 1419, 1420, 1421, 1422, 1423, 1424, 1425, 1426, 1427, 1428, 1429, 1430, 1431,
1432, 1433, 1434, 1435, 1436, 1437, 1438, 1439, 1440, 1441, 1442, 1443, 1444, 1445, 1446,
1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455, 1456, 1457, 1458, 1459, 1460, 1461,
1462, 1463, 1464, 1465, 1466, 1467, 1468, 1469, 1470, 1471, 1472, 1473, 1474, 1475, 1476,
1477, 1478, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486, 1487, 1488, 1489, 1490, 1491,
1492, 1493, 1494, 1495, 1496, 1497, 1498, 1499, 1500, 1501, 1502, 1503, 1504, 1505, 1506,
1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519, 1520, 1521,
1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536,
1537, 1538, 1539, 1540, 1541, 1542, 1543, 1544, 1545, 1546, 1547, 1548, 1549, 1550, 1551,
1552, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560, 1561, 1562, 1563, 1564, 1565, 1566,
1567, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579, 1580, 1581,
1582, 1583, 1584, 1585, 1586, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594, 1595, 1596,
1597, 1598, 1599, 1600, 1601, 1602, 1603, 1604, 1605, 1606, 1607, 1608, 1609, 1610, 1611,
1612, 1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620, 1621, 1622, 1623, 1624, 1625, 1626,
1627, 1628, 1629, 1630, 1631, 1632, 1633, 1634, 1635, 1636, 1637, 1638, 1639, 1640, 1641,
1642, 1643, 1644, 1645, 1646, 1647, 1648, 1649, 1650, 1651, 1652, 1653, 1654, 1655, 1656,
1657, 1658, 1659, 1660, 1661, 1662, 1663, 1664, 1665, 1666, 1667, 1668, 1669, 1670, 1671,
1672, 1673, 1674, 1675, 1676, 1677, 1678, 1679, 1680, 1681, 1682, 1683, 1684, 1685, 1686,
1687, 1688, 1689, 1690, 1691, 1692, 1693, 1694, 1695, 1696, 1697, 1698, 1699, 1700, 1701,
1702, 1703, 1704, 1705, 1706, 1707, 1708, 1709, 1710, 1711, 1712, 1713, 1714, 1715, 1716,
1717, 1718, 1719, 1720, 1721, 1722, 1723, 1724, 1725, 1726, 1727, 1728, 1729, 1730, 1731,
1732, 1733, 1734, 1735, 1736, 1737, 1738, 1739, 1740, 1741, 1742, 1743, 1744, 1745, 1746,
1747, 1748, 1749, 1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757, 1758, 1759, 1760, 1761,
1762, 1763, 1764, 1765, 1766, 1767, 1768, 1769, 1770, 1771, 1772, 1773, 1774, 1775, 1776,
1777, 1778, 1779, 1780, 1781, 1782, 1783, 1784, 1785, 1786, 1787, 1788, 1789, 1790, 1791,
1792, 1793, 1794, 1795, 1796, 1797, 1798, 1799, 1800, 1801, 1802, 1803, 1804, 1805, 1806,
1807, 1808, 1809, 1810, 1811, 1812, 1813, 1814, 1815, 1816, 1817, 1818, 1819, 1820, 1821,
1822, 1823, 1824, 1825, 1826, 1827, 1828, 1829, 1830, 1831, 1832, 1833, 1834, 1835, 1836,
1837, 1838, 1839, 1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848, 1849, 1850, 1851,
1852, 1853, 1854, 1855, 1856, 1857, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1866,
1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875, 1876, 1877, 1878, 1879, 1880, 1881,
1882, 1883, 1884, 1885, 1886, 1887, 1888, 1889, 1890, 1891, 1892, 1893, 1894, 1895, 1896,
1897, 1898, 1899, 1900, 1901, 1902, 1903, 1904, 1905, 1906, 1907, 1908, 1909, 1910, 1911,
1912, 1913, 1914, 1915, 1916, 1917, 1918, 1919, 1920, 1921, 1922, 1923, 1924, 1925, 1926,
1927, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 1937, 1938, 1939, 1940, 1941,
1942, 1943, 1944, 1945, 1946, 1947, 1948, 1949, 1950, 1951, 1952, 1953, 1954, 1955, 1956,
1957, 1958, 1959, 1960, 1961, 1962, 1963, 1964, 1965, 1966, 1967, 1968, 1969, 1970, 1971,
1972, 1973, 1974, 1975, 1976, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986,
1987, 1988, 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016,
2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024, 2025, 2026, 2027, 2028, 2029, 2030, 2031,
2032, 2033, 2034, 2035, 2036, 2037, 2038, 2039, 2040, 2041, 2042, 2043, 2044, 2045, 2046,
2047, 2048, 2049, 2050, 2051, 2052, 2053, 2054, 2055, 2056, 2057, 2058, 2059, 2060, 2061,
2062, 2063, 2064, 2065, 2066, 2067, 2068, 2069, 2070, 2071, 2072, 2073, 2074, 2075, 2076,
2077, 2078, 2079, 2080, 2081, 2082, 2083, 2084, 2085, 2086, 2087, 2088, 2089, 2090, 2091,
2092, 2093, 2094, 2095, 2096, 2097, 2098, 2099, 2100, 2101, 2102, 2103, 2104, 2105, 2106,
2107, 2108, 2109, 2110, 2111, 2112, 2113, 2114, 2115, 2116, 2117, 2118, 2119, 2120, 2121,
2122, 2123, 2124, 2125, 2126, 2127, 2128, 2129, 2130, 2131, 2132, 2133, 2134, 2135, 2136,
2137, 2138, 2139, 2140, 2141, 2142, 2143, 2144, 2145, 2146, 2147, 2148, 2149, 2150, 2151,
2152, 2153, 2154, 2155, 2156, 2157, 2158, 2159, 2160, 2161, 2162, 2163, 2164, 2165, 2166,
2167, 2168, 2169, 2170, 2171, 2172, 2173, 2174, 2175, 2176, 2177, 2178, 2179, 2180, 2181,
2182, 2183, 2184, 2185, 2186, 2187, 2188, 2189, 2190, 2191, 2192, 2193, 2194, 2195, 2196,
2197, 2198, 2199, 2200, 2201, 2202, 2203, 2204, 2205, 2206, 2207, 2208, 2209, 2210, 2211,
2212, 2213, 2214, 2215, 2216, 2217, 2218, 2219, 2220, 2221, 2222, 2223, 2224, 2225, 2226,
2227, 2228, 2229, 2230, 2231, 2232, 2233, 2234, 2235, 2236, 2237, 2238, 2239, 2240, 2241,
2242, 2243, 2244, 2245, 2246, 2247, 2248, 2249, 2250, 2251, 2252, 2253, 2254, 2255, 2256,
2257, 2258, 2259, 2260, 2261, 2262, 2263, 2264, 2265, 2266, 2267, 2268, 2269, 2270, 2271,
2272, 2273, 2274, 2275, 2276, 2277, 2278, 2279, 2280, 2281, 2282, 2283, 2284, 2285, 2286,
2287, 2288, 2289, 2290, 2291, 2292, 2293, 2294, 2295, 2296, 2297, 2298, 2299, 2300, 2301,
2302, 2303, 2304, 2305, 2306, 2307, 2308, 2309, 2310, 2311, 2312, 2313, 2314, 2315, 2316,
2317, 2318, 2319, 2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328, 2329, 2330, 2331,
2332, 2333, 2334, 2335, 2336, 2337, 2338, 2339, 2340, 2341, 2342, 2343, 2344, 2345, 2346,
2347, 2348, 2349, 2350, 2351, 2352, 2353, 2354, 2355, 2356, 2357, 2358, 2359, 2360, 2361,
2362, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374, 2375, 2376,
2377, 2378, 2379, 2380, 2381, 2382, 2383, 2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391,
2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406,
2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 2417, 2418, 2419, 2420, 2421,
2422, 2423, 2424, 2425, 2426, 2427, 2428, 2429, 2430, 2431, 2432, 2433, 2434, 2435, 2436,
2437, 2438, 2439, 2440, 2441, 2442, 2443, 2444, 2445, 2446, 2447, 2448, 2449, 2450, 2451,
2452, 2453, 2454, 2455, 2456, 2457, 2458, 2459, 2460, 2461, 2462, 2463, 2464, 2465, 2466,
2467, 2468, 2469, 2470, 2471, 2472, 2473, 2474, 2475, 2476, 2477, 2478, 2479, 2480, 2481,
2482, 2483, 2484, 2485, 2486, 2487, 2488, 2489, 2490, 2491, 2492, 2493, 2494, 2495, 2496,
2497, 2498, 2499, 2500, 2501, 2502, 2503, 2504, 2505, 2506, 2507, 2508, 2509, 2510, 2511,
2512, 2513, 2514, 2515, 2516, 2517, 2518, 2519, 2520, 2521, 2522, 2523, 2524, 2525, 2526,
2527, 2528, 2529, 2530, 2531, 2532, 2533, 2534, 2535, 2536, 2537, 2538, 2539, 2540, 2541,
2542, 2543, 2544, 2545, 2546, 2547, 2548, 2549, 2550, 2551, 2552, 2553, 2554, 2555, 2556,
2557, 2558, 2559, 2560, 2561, 2562, 2563, 2564, 2565, 2566, 2567, 2568, 2569, 2570, 2571,
2572, 2573, 2574, 2575, 2576, 2577, 2578, 2579, 2580, 2581, 2582, 2583, 2584, 2585, 2586,
2587, 2588, 2589, 2590, 2591, 2592, 2593, 2594, 2595, 2596, 2597, 2598, 2599, 2600, 2601,
2602, 2603, 2604, 2605, 2606, 2607, 2608, 2609, 2610, 2611, 2612, 2613, 2614, 2615, 2616,
2617, 2618, 2619, 2620, 2621, 2622, 2623, 2624, 2625, 2626, 2627, 2628, 2629, 2630, 2631,
2632, 2633, 2634, 2635, 2636, 2637, 2638, 2639, 2640, 2641, 2642, 2643, 2644, 2645, 2646,
2647, 2648, 2649, 2650, 2651, 2652, 2653, 2654, 2655, 2656, 2657, 2658, 2659, 2660, 2661,
2662, 2663, 2664, 2665, 2666, 2667, 2668, 2669, 2670, 2671, 2672, 2673, 2674, 2675, 2676,
2677, 2678, 2679, 2680, 2681, 2682, 2683, 2684, 2685, 2686, 2687, 2688, 2689, 2690, 2691,
2692, 2693, 2694, 2695, 2696, 2697, 2698, 2699, 2700, 2701, 2702, 2703, 2704, 2705, 2706,
2707, 2708, 2709, 2710, 2711, 2712, 2713, 2714, 2715, 2716, 2717, 2718, 2719, 2720, 2721,
2722, 2723, 2724, 2725, 2726, 2727, 2728, 2729, 2730, 2731, 2732, 2733, 2734, 2735, 2736,
2737, 2738, 2739, 2740, 2741, 2742, 2743, 2744, 2745, 2746, 2747, 2748, 2749, 2750, 2751,
2752, 2753, 2754, 2755, 2756, 2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 2765, 2766,
2767, 2768, 2769, 2770, 2771, 2772, 2773, 2774, 2775, 2776, 2777, 2778, 2779, 2780, 2781,
2782, 2783, 2784, 2785, 2786, 2787, 2788, 2789, 2790, 2791, 2792, 2793, 2794, 2795, 2796,
2797, 2798, 2799, 2800, 2801, 2802, 2803, 2804, 2805, 2806, 2807, 2808, 2809, 2810, 2811,
2812, 2813, 2814, 2815, 2816, 2817, 2818, 2819, 2820, 2821, 2822, 2823, 2824, 2825, 2826,
2827, 2828, 2829, 2830, 2831, 2832, 2833, 2834, 2835, 2836, 2837, 2838, 2839, 2840, 2841,
2842, 2843, 2844, 2845, 2846, 2847, 2848, 2849, 2850, 2851, 2852, 2853, 2854, 2855, 2856,
2857, 2858, 2859, 2860, 2861, 2862, 2863, 9, 11, 6, 7, 8, 10, 4, 5,
0, 1, 2, 3, 0, 2, 10, 3, 6, 1, 9, 11, 4, 8, 7,
5, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
29, 30, 31, 32, 33, 34, 35, 68, 116, 22, 10, 97, 117, 52, 110,
7, 19, 111, 115, 6, 18, 0, 74, 88, 12, 48, 108, 99, 109, 38,
104, 4, 16, 24, 96, 15, 3, 50, 84, 71, 85, 36, 102, 103, 119,
54, 86, 100, 30, 25, 105, 113, 69, 53, 63, 98, 87, 93, 89, 95,
9, 21, 62, 114, 5, 17, 26, 55, 2, 14, 65, 8, 20, 64, 92,
42, 106, 11, 23, 46, 66, 34, 101, 107, 56, 35, 47, 57, 67, 76,
118, 75, 83, 82, 94, 37, 77, 29, 51, 1, 13, 27, 49, 58, 112,
39, 59, 28, 70, 44, 73, 80, 81, 32, 72, 31, 43, 33, 40, 41,
45, 60, 61, 78, 79, 90, 91
};


/**Function*************************************************************

  Synopsis    [Reads library from array.]

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
Vec_Int_t * Dar_LibReadNodes()
{
    Vec_Int_t * vResult;
    int i;
    vResult = Vec_IntAlloc( s_nDataSize1 );
    for ( i = 0; i < s_nDataSize1; i++ )
        Vec_IntPush( vResult, s_Data1[i] );
    return vResult;
}

/**Function*************************************************************

  Synopsis    [Reads library from array.]

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
Vec_Int_t * Dar_LibReadOuts()
{
    Vec_Int_t * vResult;
    int i;
    vResult = Vec_IntAlloc( s_nDataSize2 );
    for ( i = 0; i < s_nDataSize2; i++ )
        Vec_IntPush( vResult, s_Data2[i] );
    return vResult;
}

/**Function*************************************************************

  Synopsis    [Reads library from array.]

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
Vec_Int_t * Dar_LibReadPrios()
{
    Vec_Int_t * vResult;
    int i;
    vResult = Vec_IntAlloc( s_nDataSize3 );
    for ( i = 0; i < s_nDataSize3; i++ )
        Vec_IntPush( vResult, s_Data3[i] );
    return vResult;
}

#if 0

#include "abc.h"

/**Function*************************************************************

  Synopsis    [Generate arrays.]

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
void Aig_NtkGenerateArrays( Abc_Ntk_t * pNtk )
{
    extern int Io_WriteAigerEncode( char * pBuffer, int Pos, unsigned x );

    Abc_Obj_t * pObj;
    int i, Count = 0;
    assert( Abc_NtkPiNum(pNtk) == 4 );
    assert( Abc_NtkIsStrash(pNtk) );
    assert( Abc_ObjFanoutNum(Abc_AigConst1(pNtk)) == 0 );
/*
    {
        unsigned char * pBuffer;
        int Pos, uLit, uLit0, uLit1, Size, Digit;

        Abc_NtkForEachPi( pNtk, pObj, i )
            pObj->pCopy = (void *)Count++;

        Pos = 0;
        pBuffer = ALLOC( char, 200000 );
        Abc_AigForEachAnd( pNtk, pObj, i )
        {
            pObj->pCopy = (void *)Count++;
            uLit  = ((int)pObj->pCopy << 1);
            uLit0 = (((int)Abc_ObjFanin0(pObj)->pCopy) << 1) | Abc_ObjFaninC0(pObj);
            uLit1 = (((int)Abc_ObjFanin1(pObj)->pCopy) << 1) | Abc_ObjFaninC1(pObj);
            assert( uLit0 < uLit1 );
            Pos = Io_WriteAigerEncode( pBuffer, Pos, uLit  - uLit1 );
            Pos = Io_WriteAigerEncode( pBuffer, Pos, uLit1 - uLit0 );
        }
        // write the buffer
        Size = 0;
        for ( i = 0; i < Pos; i++ )
        {
            if ( i % 36 == 0 )
                printf( "\n" );

            Digit = pBuffer[i] & 0xF;
            if ( Digit < 10 )
                printf( "%d", Digit );
            else 
                printf( "%c", Digit - 10 + 'A' );


            Digit = pBuffer[i];
            Digit >>= 4;
            if ( Digit < 10 )
                printf( "%d", Digit );
            else 
                printf( "%c", Digit - 10 + 'A' );

        }
        printf( "\n" );
        printf( "Size = %d.\n", Pos );
    }
*/


    Abc_NtkForEachPi( pNtk, pObj, i )
        pObj->pCopy = (void *)Count++;
    Abc_AigForEachAnd( pNtk, pObj, i )
    {
//        if ( (Count - 4) % 6 == 0 )
//            printf( "\n" );
//        printf( "%5d,", (((int)Abc_ObjFanin0(pObj)->pCopy) << 1) | Abc_ObjFaninC0(pObj) );
//        printf( "%5d,", (((int)Abc_ObjFanin1(pObj)->pCopy) << 1) | Abc_ObjFaninC1(pObj) );
        pObj->pCopy = (void *)Count++;
    }
//    printf( "\n" );
//    printf( "Nodes = %d.\n", Count-4 );



    Abc_NtkForEachPo( pNtk, pObj, i )
    {
        if ( i % 12 == 0 )
            printf( "\n" );
        printf( "%5d,",  (int)Abc_ObjFanin0(pObj)->pCopy );
    }
    printf( "\n" );
    printf( "Outputs = %d.\n", Abc_NtkPoNum(pNtk) );


/*
    {
        unsigned char * pBuffer;
        Vec_Int_t * vOuts;
        int Pos, Prev, Out;

        vOuts = Vec_IntAlloc( 25000 );
        Abc_NtkForEachPo( pNtk, pObj, i )
            Vec_IntPush( vOuts, Abc_ObjFaninId0(pObj) );
        Vec_IntSort( vOuts, 0 );

        Pos = 0;
        pBuffer = ALLOC( char, 50000 );
        Prev = 0;
        Vec_IntForEachEntry( vOuts, Out, i )
        {
            assert( Prev < Out );
            Pos = Io_WriteAigerEncode( pBuffer, Pos, Out - Prev );
            Prev = Out;
        }
        Vec_IntFree( vOuts );

        // write the buffer
        for ( i = 0; i < Pos; i++ )
        {
            if ( i % 32 == 0 )
                printf( "\n" );
            printf( "%d,",  pBuffer[i] );
        }
        printf( "\n" );
        printf( "Size = %d.\n", Pos );
    }
*/

}

#endif





////////////////////////////////////////////////////////////////////////
///                       END OF FILE                                ///
////////////////////////////////////////////////////////////////////////


