/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(OFFSCREEN_CANVAS)

#include "JSOffscreenCanvas.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "InspectorCanvasCallTracer.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMConvertVariadic.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCanvasContext.h"
#include "JSImageBitmap.h"
#include "JSImageBitmapRenderingContext.h"
#include "JSOffscreenCanvasRenderingContext2D.h"
#include "JSWebGL2RenderingContext.h"
#include "JSWebGLRenderingContext.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(OffscreenCanvas::RenderingContextType enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 5> values {
        MAKE_STATIC_STRING_IMPL("2d"),
        MAKE_STATIC_STRING_IMPL("webgl"),
        MAKE_STATIC_STRING_IMPL("webgl2"),
        MAKE_STATIC_STRING_IMPL("bitmaprenderer"),
        MAKE_STATIC_STRING_IMPL("webgpu"),
    };
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::_2d) == 0, "OffscreenCanvas::RenderingContextType::_2d is not 0 as expected");
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::Webgl) == 1, "OffscreenCanvas::RenderingContextType::Webgl is not 1 as expected");
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::Webgl2) == 2, "OffscreenCanvas::RenderingContextType::Webgl2 is not 2 as expected");
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::Bitmaprenderer) == 3, "OffscreenCanvas::RenderingContextType::Bitmaprenderer is not 3 as expected");
    static_assert(static_cast<size_t>(OffscreenCanvas::RenderingContextType::Webgpu) == 4, "OffscreenCanvas::RenderingContextType::Webgpu is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, OffscreenCanvas::RenderingContextType enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<OffscreenCanvas::RenderingContextType> parseEnumerationFromString<OffscreenCanvas::RenderingContextType>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType>, 5> mappings {
        std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType> { "2d"_s, OffscreenCanvas::RenderingContextType::_2d },
        std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType> { "bitmaprenderer"_s, OffscreenCanvas::RenderingContextType::Bitmaprenderer },
        std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType> { "webgl"_s, OffscreenCanvas::RenderingContextType::Webgl },
        std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType> { "webgl2"_s, OffscreenCanvas::RenderingContextType::Webgl2 },
        std::pair<ComparableASCIILiteral, OffscreenCanvas::RenderingContextType> { "webgpu"_s, OffscreenCanvas::RenderingContextType::Webgpu },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<OffscreenCanvas::RenderingContextType> parseEnumeration<OffscreenCanvas::RenderingContextType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<OffscreenCanvas::RenderingContextType>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<OffscreenCanvas::RenderingContextType>()
{
    return "\"2d\", \"webgl\", \"webgl2\", \"bitmaprenderer\", \"webgpu\""_s;
}

template<> ConversionResult<IDLDictionary<OffscreenCanvas::ImageEncodeOptions>> convertDictionary<OffscreenCanvas::ImageEncodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    OffscreenCanvas::ImageEncodeOptions result;
    JSValue qualityValue;
    if (isNullOrUndefined)
        qualityValue = jsUndefined();
    else {
        qualityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "quality"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto qualityConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, qualityValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1.0 }; });
    if (qualityConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.quality = qualityConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto typeConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, typeValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "image/png"_s }; });
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.type = typeConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_getContext);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_transferToImageBitmap);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_convertToBlob);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvas_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvas_width);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvas_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvas_height);

class JSOffscreenCanvasPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOffscreenCanvasPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOffscreenCanvasPrototype* ptr = new (NotNull, JSC::allocateCell<JSOffscreenCanvasPrototype>(vm)) JSOffscreenCanvasPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOffscreenCanvasPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasPrototype, JSOffscreenCanvasPrototype::Base);

using JSOffscreenCanvasDOMConstructor = JSDOMConstructor<JSOffscreenCanvas>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSOffscreenCanvasDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSOffscreenCanvasDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "OffscreenCanvas"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto widthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (widthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto heightConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(*lexicalGlobalObject, argument1.value());
    if (heightConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = OffscreenCanvas::create(*context, widthConversionResult.releaseReturnValue(), heightConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<OffscreenCanvas>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<OffscreenCanvas>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSOffscreenCanvasDOMConstructorConstruct, JSOffscreenCanvasDOMConstructor::construct);

template<> const ClassInfo JSOffscreenCanvasDOMConstructor::s_info = { "OffscreenCanvas"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasDOMConstructor) };

template<> JSValue JSOffscreenCanvasDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSOffscreenCanvasDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "OffscreenCanvas"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSOffscreenCanvas::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 6> JSOffscreenCanvasPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasConstructor, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvas_width, setJSOffscreenCanvas_width } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvas_height, setJSOffscreenCanvas_height } },
    HashTableValue { "getContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasPrototypeFunction_getContext, 1 } },
    HashTableValue { "transferToImageBitmap"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasPrototypeFunction_transferToImageBitmap, 0 } },
    HashTableValue { "convertToBlob"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasPrototypeFunction_convertToBlob, 0 } },
};

const ClassInfo JSOffscreenCanvasPrototype::s_info = { "OffscreenCanvas"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasPrototype) };

void JSOffscreenCanvasPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOffscreenCanvas::info(), JSOffscreenCanvasPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOffscreenCanvas::s_info = { "OffscreenCanvas"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvas) };

JSOffscreenCanvas::JSOffscreenCanvas(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OffscreenCanvas>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<OffscreenCanvas> JSOffscreenCanvas::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, OffscreenCanvas>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

void JSOffscreenCanvas::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(info()));

    vm.heap.reportExtraMemoryAllocated(this, wrapped().memoryCost());
}

JSObject* JSOffscreenCanvas::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOffscreenCanvasPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSOffscreenCanvasPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOffscreenCanvas::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOffscreenCanvas>(vm, globalObject);
}

JSValue JSOffscreenCanvas::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOffscreenCanvasDOMConstructor, DOMConstructorID::OffscreenCanvas>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOffscreenCanvas::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsOffscreenCanvas_widthGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "width"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvas_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvas>::get<jsOffscreenCanvas_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvas_widthSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "width"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvas_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvas>::set<setJSOffscreenCanvas_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvas_heightGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "height"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvas_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvas>::get<jsOffscreenCanvas_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvas_heightSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvas& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "height"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setHeight(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvas_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvas>::set<setJSOffscreenCanvas_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunction_getContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvas>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto contextTypeConversionResult = convert<IDLEnumeration<OffscreenCanvas::RenderingContextType>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "contextType"_s, "OffscreenCanvas"_s, "getContext"_s, expectedEnumerationValues<OffscreenCanvas::RenderingContextType>()); });
    if (contextTypeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto arguments = convertVariadicArguments<IDLAny>(*lexicalGlobalObject, *callFrame, 1);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLUnion<IDLInterface<WebGLRenderingContext>, IDLInterface<WebGL2RenderingContext>, IDLInterface<GPUCanvasContext>, IDLInterface<ImageBitmapRenderingContext>, IDLInterface<OffscreenCanvasRenderingContext2D>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getContext(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), contextTypeConversionResult.releaseReturnValue(), WTFMove(arguments)))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_getContext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunction_getContextBody>(*lexicalGlobalObject, *callFrame, "getContext");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunction_transferToImageBitmapBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvas>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ImageBitmap>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.transferToImageBitmap())));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_transferToImageBitmap, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunction_transferToImageBitmapBody>(*lexicalGlobalObject, *callFrame, "transferToImageBitmap");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasPrototypeFunction_convertToBlobBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSOffscreenCanvas>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<OffscreenCanvas::ImageEncodeOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<Blob>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.convertToBlob(optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasPrototypeFunction_convertToBlob, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSOffscreenCanvas>::call<jsOffscreenCanvasPrototypeFunction_convertToBlobBody>(*lexicalGlobalObject, *callFrame, "convertToBlob");
}

JSC::GCClient::IsoSubspace* JSOffscreenCanvas::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOffscreenCanvas, UseCustomHeapCellType::No>(vm, "JSOffscreenCanvas"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOffscreenCanvas.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOffscreenCanvas = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOffscreenCanvas.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOffscreenCanvas = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSOffscreenCanvas::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSOffscreenCanvas*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.reportExtraMemoryVisited(thisObject->wrapped().memoryCost());
#if ENABLE(RESOURCE_USAGE)
    visitor.reportExternalMemoryVisited(thisObject->wrapped().externalMemoryCost());
#endif
}

DEFINE_VISIT_CHILDREN(JSOffscreenCanvas);

size_t JSOffscreenCanvas::estimatedSize(JSCell* cell, VM& vm)
{
    auto* thisObject = jsCast<JSOffscreenCanvas*>(cell);
    return Base::estimatedSize(thisObject, vm) + thisObject->wrapped().memoryCost();
}

void JSOffscreenCanvas::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOffscreenCanvas*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSOffscreenCanvasOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsOffscreenCanvas = jsCast<JSOffscreenCanvas*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsOffscreenCanvas->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    OffscreenCanvas* owner = &jsOffscreenCanvas->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from OffscreenCanvas"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSOffscreenCanvasOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOffscreenCanvas = static_cast<JSOffscreenCanvas*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOffscreenCanvas->protectedWrapped().ptr(), jsOffscreenCanvas);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OffscreenCanvas@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15OffscreenCanvasE[]; }
#endif
template<std::same_as<OffscreenCanvas> T>
static inline void verifyVTable(OffscreenCanvas* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OffscreenCanvas@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15OffscreenCanvasE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OffscreenCanvas has subclasses. If OffscreenCanvas has subclasses that get passed
        // to toJS() we currently require OffscreenCanvas you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OffscreenCanvas>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OffscreenCanvas>(impl.ptr());
#endif
    return createWrapper<OffscreenCanvas>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OffscreenCanvas& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OffscreenCanvas* JSOffscreenCanvas::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOffscreenCanvas*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(OFFSCREEN_CANVAS)
