/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSOMColorValue.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSOMColorValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSOMColorValuePrototypeFunction_to);
static JSC_DECLARE_HOST_FUNCTION(jsCSSOMColorValueConstructorFunction_parse);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMColorValueConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOMColorValue_colorSpace);

class JSCSSOMColorValuePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSOMColorValuePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSOMColorValuePrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSOMColorValuePrototype>(vm)) JSCSSOMColorValuePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMColorValuePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSOMColorValuePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOMColorValuePrototype, JSCSSOMColorValuePrototype::Base);

using JSCSSOMColorValueDOMConstructor = JSDOMConstructorNotConstructable<JSCSSOMColorValue>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSCSSOMColorValueConstructorTableValues {
    HashTableValue { "parse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSOMColorValueConstructorFunction_parse, 1 } },
};

template<> const ClassInfo JSCSSOMColorValueDOMConstructor::s_info = { "CSSColorValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColorValueDOMConstructor) };

template<> JSValue JSCSSOMColorValueDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSOMColorValueDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSColorValue"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSOMColorValue::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSCSSOMColorValue::info(), JSCSSOMColorValueConstructorTableValues, *this);
    if (!(&globalObject)->inherits<JSDOMWindowBase>()) {
        auto propertyName = Identifier::fromString(vm, "parse"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, &globalObject, propertyName, slot);
    }
}

/* Hash table for prototype */

static const std::array<HashTableValue, 3> JSCSSOMColorValuePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMColorValueConstructor, 0 } },
    HashTableValue { "colorSpace"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOMColorValue_colorSpace, 0 } },
    HashTableValue { "to"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSOMColorValuePrototypeFunction_to, 1 } },
};

const ClassInfo JSCSSOMColorValuePrototype::s_info = { "CSSColorValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColorValuePrototype) };

void JSCSSOMColorValuePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSOMColorValue::info(), JSCSSOMColorValuePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSOMColorValue::s_info = { "CSSColorValue"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOMColorValue) };

JSCSSOMColorValue::JSCSSOMColorValue(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSOMColorValue>&& impl)
    : JSCSSStyleValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSOMColorValue> JSCSSOMColorValue::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSOMColorValue>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSOMColorValue::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSOMColorValuePrototype::createStructure(vm, &globalObject, JSCSSStyleValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSOMColorValuePrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSOMColorValue::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSOMColorValue>(vm, globalObject);
}

JSValue JSCSSOMColorValue::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSOMColorValueDOMConstructor, DOMConstructorID::CSSOMColorValue>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMColorValueConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSOMColorValuePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSOMColorValue::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSOMColorValue_colorSpaceGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOMColorValue& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSKeywordValue>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.colorSpace())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOMColorValue_colorSpace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOMColorValue>::get<jsCSSOMColorValue_colorSpaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCSSOMColorValuePrototypeFunction_toBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSOMColorValue>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto colorSpaceConversionResult = convert<IDLUnion<IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    if (colorSpaceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CSSOMColorValue>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.to(colorSpaceConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSOMColorValuePrototypeFunction_to, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSOMColorValue>::call<jsCSSOMColorValuePrototypeFunction_toBody>(*lexicalGlobalObject, *callFrame, "to");
}

static inline JSC::EncodedJSValue jsCSSOMColorValueConstructorFunction_parseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cssTextConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (cssTextConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnion<IDLInterface<CSSOMColorValue>, IDLInterface<CSSStyleValue>>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, CSSOMColorValue::parse(cssTextConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSOMColorValueConstructorFunction_parse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSOMColorValue>::callStatic<jsCSSOMColorValueConstructorFunction_parseBody>(*lexicalGlobalObject, *callFrame, "parse");
}

JSC::GCClient::IsoSubspace* JSCSSOMColorValue::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSOMColorValue, UseCustomHeapCellType::No>(vm, "JSCSSOMColorValue"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSOMColorValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSOMColorValue = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSOMColorValue.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSOMColorValue = std::forward<decltype(space)>(space); }
    );
}

void JSCSSOMColorValue::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSOMColorValue*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

CSSOMColorValue* JSCSSOMColorValue::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSOMColorValue*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
