/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMCSSCustomPropertyDescriptor.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DOMCSSCustomPropertyDescriptor>> convertDictionary<DOMCSSCustomPropertyDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DOMCSSCustomPropertyDescriptor result;
    JSValue inheritsValue;
    if (isNullOrUndefined)
        inheritsValue = jsUndefined();
    else {
        inheritsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "inherits"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (inheritsValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "inherits"_s, "DOMCSSCustomPropertyDescriptor"_s, "boolean"_s);
        return ConversionResultException { };
    }
    auto inheritsConversionResult = convert<IDLBoolean>(lexicalGlobalObject, inheritsValue);
    if (inheritsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.inherits = inheritsConversionResult.releaseReturnValue();
    JSValue initialValueValue;
    if (isNullOrUndefined)
        initialValueValue = jsUndefined();
    else {
        initialValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "initialValue"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!initialValueValue.isUndefined()) {
        auto initialValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, initialValueValue);
        if (initialValueConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.initialValue = initialValueConversionResult.releaseReturnValue();
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "DOMCSSCustomPropertyDescriptor"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, nameValue);
    if (nameConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue syntaxValue;
    if (isNullOrUndefined)
        syntaxValue = jsUndefined();
    else {
        syntaxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "syntax"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto syntaxConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, syntaxValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "*"_s }; });
    if (syntaxConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.syntax = syntaxConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const DOMCSSCustomPropertyDescriptor& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto inheritsValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, dictionary.inherits);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "inherits"_s), inheritsValue);
    if (!IDLDOMString::isNullValue(dictionary.initialValue)) {
        auto initialValueValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.initialValue));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "initialValue"_s), initialValueValue);
    }
    auto nameValue = toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, dictionary.name);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "name"_s), nameValue);
    auto syntaxValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, dictionary.syntax);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "syntax"_s), syntaxValue);
    return result;
}

} // namespace WebCore

