/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNodeFilter.h"

#include "ContextDestructionObserverInlines.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>


namespace WebCore {
using namespace JSC;

JSNodeFilter::JSNodeFilter(JSObject* callback, JSDOMGlobalObject* globalObject)
    : NodeFilter(globalObject->scriptExecutionContext())
    , m_data(new JSCallbackData(callback, globalObject, this))
{
}

JSNodeFilter::~JSNodeFilter()
{
    SUPPRESS_UNCOUNTED_LOCAL ScriptExecutionContext* context = scriptExecutionContext();
    // When the context is destroyed, all tasks with a reference to a callback
    // should be deleted. So if the context is 0, we are on the context thread.
    // We can't use RefPtr here since ScriptExecutionContext is not thread safe ref counted.
    if (!context || context->isContextThread())
        delete m_data;
    else
        context->postTask(DeleteCallbackDataTask(m_data));
#ifndef NDEBUG
    m_data = nullptr;
#endif
}

using JSNodeFilterDOMConstructor = JSDOMConstructorNotConstructable<JSNodeFilter>;

/* Hash table for constructor */

static const std::array<HashTableValue, 16> JSNodeFilterConstructorTableValues {
    HashTableValue { "FILTER_ACCEPT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "FILTER_REJECT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "FILTER_SKIP"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "SHOW_ALL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0xFFFFFFFF } },
    HashTableValue { "SHOW_ELEMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000001 } },
    HashTableValue { "SHOW_ATTRIBUTE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000002 } },
    HashTableValue { "SHOW_TEXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000004 } },
    HashTableValue { "SHOW_CDATA_SECTION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000008 } },
    HashTableValue { "SHOW_ENTITY_REFERENCE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000010 } },
    HashTableValue { "SHOW_ENTITY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000020 } },
    HashTableValue { "SHOW_PROCESSING_INSTRUCTION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000040 } },
    HashTableValue { "SHOW_COMMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000080 } },
    HashTableValue { "SHOW_DOCUMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000100 } },
    HashTableValue { "SHOW_DOCUMENT_TYPE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000200 } },
    HashTableValue { "SHOW_DOCUMENT_FRAGMENT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000400 } },
    HashTableValue { "SHOW_NOTATION"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x00000800 } },
};

static_assert(NodeFilter::FILTER_ACCEPT == 1, "FILTER_ACCEPT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::FILTER_REJECT == 2, "FILTER_REJECT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::FILTER_SKIP == 3, "FILTER_SKIP in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_ALL == 0xFFFFFFFF, "SHOW_ALL in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_ELEMENT == 0x00000001, "SHOW_ELEMENT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_ATTRIBUTE == 0x00000002, "SHOW_ATTRIBUTE in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_TEXT == 0x00000004, "SHOW_TEXT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_CDATA_SECTION == 0x00000008, "SHOW_CDATA_SECTION in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_ENTITY_REFERENCE == 0x00000010, "SHOW_ENTITY_REFERENCE in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_ENTITY == 0x00000020, "SHOW_ENTITY in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_PROCESSING_INSTRUCTION == 0x00000040, "SHOW_PROCESSING_INSTRUCTION in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_COMMENT == 0x00000080, "SHOW_COMMENT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_DOCUMENT == 0x00000100, "SHOW_DOCUMENT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_DOCUMENT_TYPE == 0x00000200, "SHOW_DOCUMENT_TYPE in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_DOCUMENT_FRAGMENT == 0x00000400, "SHOW_DOCUMENT_FRAGMENT in NodeFilter does not match value from IDL");
static_assert(NodeFilter::SHOW_NOTATION == 0x00000800, "SHOW_NOTATION in NodeFilter does not match value from IDL");

template<> const ClassInfo JSNodeFilterDOMConstructor::s_info = { "NodeFilter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeFilterDOMConstructor) };

template<> JSValue JSNodeFilterDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSNodeFilterDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NodeFilter"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    UNUSED_PARAM(globalObject);
    reifyStaticProperties(vm, nullptr, JSNodeFilterConstructorTableValues, *this);
}

JSValue JSNodeFilter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeFilterDOMConstructor, DOMConstructorID::NodeFilter>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

CallbackResult<typename IDLUnsignedShort::CallbackReturnType> JSNodeFilter::acceptNode(typename IDLInterface<Node>::ParameterType node)
{
    Ref<JSNodeFilter> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<Node>>(lexicalGlobalObject, globalObject, node));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    auto jsResult = m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::FunctionOrObject, Identifier::fromString(vm, "acceptNode"_s), returnedException);
    if (returnedException) {
        UNUSED_PARAM(lexicalGlobalObject);
        reportException(m_data->callback()->globalObject(), returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto returnValue = convert<IDLUnsignedShort>(lexicalGlobalObject, jsResult);
    if (returnValue.hasException(throwScope)) [[unlikely]]
        return CallbackResultType::ExceptionThrown;
    return { returnValue.releaseReturnValue() };
}

CallbackResult<typename IDLUnsignedShort::CallbackReturnType> JSNodeFilter::acceptNodeRethrowingException(typename IDLInterface<Node>::ParameterType node)
{
    Ref<JSNodeFilter> protectedThis(*this);

    auto& globalObject = *m_data->globalObject();
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = globalObject.vm();

    JSLockHolder lock(vm);
    auto& lexicalGlobalObject = globalObject;
    JSValue thisValue = jsUndefined();
    MarkedArgumentBuffer args;
    args.append(toJS<IDLInterface<Node>>(lexicalGlobalObject, globalObject, node));
    ASSERT(!args.hasOverflowed());

    NakedPtr<JSC::Exception> returnedException;
    auto jsResult = m_data->invokeCallback(thisValue, args, JSCallbackData::CallbackType::FunctionOrObject, Identifier::fromString(vm, "acceptNode"_s), returnedException);
    if (returnedException) {
        auto throwScope = DECLARE_THROW_SCOPE(vm);
        throwException(&lexicalGlobalObject, throwScope, returnedException);
        return CallbackResultType::ExceptionThrown;
     }

    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto returnValue = convert<IDLUnsignedShort>(lexicalGlobalObject, jsResult);
    if (returnValue.hasException(throwScope)) [[unlikely]]
        return CallbackResultType::ExceptionThrown;
    return { returnValue.releaseReturnValue() };
}

void JSNodeFilter::visitJSFunction(JSC::AbstractSlotVisitor& visitor)
{
    m_data->visitJSFunction(visitor);
}

void JSNodeFilter::visitJSFunction(JSC::SlotVisitor& visitor)
{
    m_data->visitJSFunction(visitor);
}

JSC::JSValue toJS(NodeFilter& impl)
{
    if (!static_cast<JSNodeFilter&>(impl).callbackData())
        return jsNull();

    return static_cast<JSNodeFilter&>(impl).callbackData()->callback();
}

ScriptExecutionContext* JSNodeFilter::scriptExecutionContext() const
{
    return ContextDestructionObserver::scriptExecutionContext();
}
} // namespace WebCore
