/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUADataValues.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMGlobalObject.h"
#include "JSNavigatorUABrandVersion.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>



namespace WebCore {
using namespace JSC;

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const UADataValues& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.architecture)) {
        auto architectureValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.architecture));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "architecture"_s), architectureValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.bitness)) {
        auto bitnessValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.bitness));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitness"_s), bitnessValue);
    }
    if (!IDLSequence<IDLDictionary<NavigatorUABrandVersion>>::isNullValue(dictionary.brands)) {
        auto brandsValue = toJS<IDLSequence<IDLDictionary<NavigatorUABrandVersion>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDictionary<NavigatorUABrandVersion>>::extractValueFromNullable(dictionary.brands));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "brands"_s), brandsValue);
    }
    if (!IDLSequence<IDLDOMString>::isNullValue(dictionary.formFactors)) {
        auto formFactorsValue = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDOMString>::extractValueFromNullable(dictionary.formFactors));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "formFactors"_s), formFactorsValue);
    }
    if (!IDLSequence<IDLDictionary<NavigatorUABrandVersion>>::isNullValue(dictionary.fullVersionList)) {
        auto fullVersionListValue = toJS<IDLSequence<IDLDictionary<NavigatorUABrandVersion>>>(lexicalGlobalObject, globalObject, throwScope, IDLSequence<IDLDictionary<NavigatorUABrandVersion>>::extractValueFromNullable(dictionary.fullVersionList));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "fullVersionList"_s), fullVersionListValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.mobile)) {
        auto mobileValue = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.mobile));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mobile"_s), mobileValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.model)) {
        auto modelValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.model));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "model"_s), modelValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.platform)) {
        auto platformValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.platform));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "platform"_s), platformValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.platformVersion)) {
        auto platformVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.platformVersion));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "platformVersion"_s), platformVersionValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.uaFullVersion)) {
        auto uaFullVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.uaFullVersion));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "uaFullVersion"_s), uaFullVersionValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.wow64)) {
        auto wow64Value = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, IDLBoolean::extractValueFromNullable(dictionary.wow64));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "wow64"_s), wow64Value);
    }
    return result;
}

} // namespace WebCore

