/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSScreen.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSScreenOrientation.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsScreenConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_height);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_width);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_colorDepth);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_pixelDepth);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_availLeft);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_availTop);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_availHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_availWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsScreen_orientation);

class JSScreenPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSScreenPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSScreenPrototype* ptr = new (NotNull, JSC::allocateCell<JSScreenPrototype>(vm)) JSScreenPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScreenPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSScreenPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSScreenPrototype, JSScreenPrototype::Base);

using JSScreenDOMConstructor = JSDOMConstructorNotConstructable<JSScreen>;

template<> const ClassInfo JSScreenDOMConstructor::s_info = { "Screen"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreenDOMConstructor) };

template<> JSValue JSScreenDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSScreenDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Screen"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSScreen::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 10> JSScreenPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsScreenConstructor, 0 } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_height, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_width, 0 } },
    HashTableValue { "colorDepth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_colorDepth, 0 } },
    HashTableValue { "pixelDepth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_pixelDepth, 0 } },
    HashTableValue { "availLeft"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_availLeft, 0 } },
    HashTableValue { "availTop"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_availTop, 0 } },
    HashTableValue { "availHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_availHeight, 0 } },
    HashTableValue { "availWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_availWidth, 0 } },
    HashTableValue { "orientation"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsScreen_orientation, 0 } },
};

const ClassInfo JSScreenPrototype::s_info = { "Screen"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreenPrototype) };

void JSScreenPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSScreen::info(), JSScreenPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().screenOrientationAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "orientation"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSScreen::s_info = { "Screen"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSScreen) };

JSScreen::JSScreen(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Screen>&& impl)
    : JSDOMWrapper<Screen>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, Screen>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSScreen::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSScreenPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSScreenPrototype::create(vm, &globalObject, structure);
}

JSObject* JSScreen::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSScreen>(vm, globalObject);
}

JSValue JSScreen::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSScreenDOMConstructor, DOMConstructorID::Screen>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSScreen::destroy(JSC::JSCell* cell)
{
    JSScreen* thisObject = static_cast<JSScreen*>(cell);
    thisObject->JSScreen::~JSScreen();
}

JSC_DEFINE_CUSTOM_GETTER(jsScreenConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSScreenPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSScreen::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsScreen_heightGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_widthGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_colorDepthGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.colorDepth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_colorDepth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_colorDepthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_pixelDepthGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.colorDepth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_pixelDepth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_pixelDepthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_availLeftGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.availLeft())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_availLeft, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_availLeftGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_availTopGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.availTop())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_availTop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_availTopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_availHeightGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.availHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_availHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_availHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_availWidthGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.availWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_availWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_availWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsScreen_orientationGetter(JSGlobalObject& lexicalGlobalObject, JSScreen& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<ScreenOrientation>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.orientation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsScreen_orientation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSScreen>::get<jsScreen_orientationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSScreen::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSScreen, UseCustomHeapCellType::No>(vm, "JSScreen"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForScreen.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForScreen = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForScreen.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForScreen = std::forward<decltype(space)>(space); }
    );
}

void JSScreen::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSScreen*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSScreenOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsScreen = jsCast<JSScreen*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsScreen->wrapped().window());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Window"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSScreenOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsScreen = static_cast<JSScreen*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsScreen->protectedWrapped().ptr(), jsScreen);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Screen@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore6ScreenE[]; }
#endif
template<std::same_as<Screen> T>
static inline void verifyVTable(Screen* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Screen@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore6ScreenE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Screen has subclasses. If Screen has subclasses that get passed
        // to toJS() we currently require Screen you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Screen>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Screen>(impl.ptr());
#endif
    return createWrapper<Screen>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Screen& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Screen* JSScreen::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSScreen*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
