#include "glib.h"
#include "xdp-method-info.h"

static const XdpMethodInfo method_info[] = {
  { .interface = "org.freedesktop.portal.Account"        , .method = "GetUserInformation"            , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Background"     , .method = "RequestBackground"             , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Background"     , .method = "SetStatus"                     , .uses_request = FALSE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Camera"         , .method = "AccessCamera"                  , .uses_request = TRUE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Camera"         , .method = "OpenPipeWireRemote"            , .uses_request = FALSE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Clipboard"      , .method = "RequestClipboard"              , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Clipboard"      , .method = "SetSelection"                  , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Clipboard"      , .method = "SelectionWrite"                , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Clipboard"      , .method = "SelectionWriteDone"            , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Clipboard"      , .method = "SelectionRead"                 , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "GetMountPoint"                 , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "Add"                           , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "AddNamed"                      , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "AddFull"                       , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "AddNamedFull"                  , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "GrantPermissions"              , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "RevokePermissions"             , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "Delete"                        , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "Lookup"                        , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "Info"                          , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "List"                          , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Documents"      , .method = "GetHostPaths"                  , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "Install"                       , .uses_request = FALSE, .option_arg =  3, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "PrepareInstall"                , .uses_request = TRUE, .option_arg =  3, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "RequestInstallToken"           , .uses_request = FALSE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "Uninstall"                     , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "GetDesktopEntry"               , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "GetIcon"                       , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.DynamicLauncher", .method = "Launch"                        , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Email"          , .method = "ComposeEmail"                  , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.FileChooser"    , .method = "OpenFile"                      , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.FileChooser"    , .method = "SaveFile"                      , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.FileChooser"    , .method = "SaveFiles"                     , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.FileTransfer"   , .method = "StartTransfer"                 , .uses_request = FALSE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.FileTransfer"   , .method = "AddFiles"                      , .uses_request = FALSE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.FileTransfer"   , .method = "RetrieveFiles"                 , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.FileTransfer"   , .method = "StopTransfer"                  , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "QueryStatus"                   , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "RegisterGame"                  , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "UnregisterGame"                , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "QueryStatusByPid"              , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "RegisterGameByPid"             , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "UnregisterGameByPid"           , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "QueryStatusByPIDFd"            , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "RegisterGameByPIDFd"           , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GameMode"       , .method = "UnregisterGameByPIDFd"         , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.GlobalShortcuts", .method = "CreateSession"                 , .uses_request = TRUE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.GlobalShortcuts", .method = "BindShortcuts"                 , .uses_request = TRUE, .option_arg =  3, },
  { .interface = "org.freedesktop.portal.GlobalShortcuts", .method = "ListShortcuts"                 , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Inhibit"        , .method = "Inhibit"                       , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.Inhibit"        , .method = "CreateMonitor"                 , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Inhibit"        , .method = "QueryEndResponse"              , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "CreateSession"                 , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "GetZones"                      , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "SetPointerBarriers"            , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "Enable"                        , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "Disable"                       , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "Release"                       , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.InputCapture"   , .method = "ConnectToEIS"                  , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Location"       , .method = "CreateSession"                 , .uses_request = TRUE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Location"       , .method = "Start"                         , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.NetworkMonitor" , .method = "GetAvailable"                  , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.NetworkMonitor" , .method = "GetMetered"                    , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.NetworkMonitor" , .method = "GetConnectivity"               , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.NetworkMonitor" , .method = "GetStatus"                     , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.NetworkMonitor" , .method = "CanReach"                      , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Notification"   , .method = "AddNotification"               , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Notification"   , .method = "RemoveNotification"            , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.OpenURI"        , .method = "OpenURI"                       , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.OpenURI"        , .method = "OpenFile"                      , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.OpenURI"        , .method = "OpenDirectory"                 , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.OpenURI"        , .method = "SchemeSupported"               , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Print"          , .method = "PreparePrint"                  , .uses_request = TRUE, .option_arg =  4, },
  { .interface = "org.freedesktop.portal.Print"          , .method = "Print"                         , .uses_request = TRUE, .option_arg =  3, },
  { .interface = "org.freedesktop.portal.ProxyResolver"  , .method = "Lookup"                        , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Realtime"       , .method = "MakeThreadRealtimeWithPID"     , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Realtime"       , .method = "MakeThreadHighPriorityWithPID" , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "CreateSession"                 , .uses_request = TRUE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "SelectDevices"                 , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "Start"                         , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyPointerMotion"           , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyPointerMotionAbsolute"   , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyPointerButton"           , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyPointerAxis"             , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyPointerAxisDiscrete"     , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyKeyboardKeycode"         , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyKeyboardKeysym"          , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyTouchDown"               , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyTouchMotion"             , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "NotifyTouchUp"                 , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.RemoteDesktop"  , .method = "ConnectToEIS"                  , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Request"        , .method = "Close"                         , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.ScreenCast"     , .method = "CreateSession"                 , .uses_request = TRUE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.ScreenCast"     , .method = "SelectSources"                 , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.ScreenCast"     , .method = "Start"                         , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.ScreenCast"     , .method = "OpenPipeWireRemote"            , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Screenshot"     , .method = "Screenshot"                    , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Screenshot"     , .method = "PickColor"                     , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Secret"         , .method = "RetrieveSecret"                , .uses_request = TRUE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Session"        , .method = "Close"                         , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Settings"       , .method = "ReadAll"                       , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Settings"       , .method = "Read"                          , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Settings"       , .method = "ReadOne"                       , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Trash"          , .method = "TrashFile"                     , .uses_request = FALSE, .option_arg = -1, },
  { .interface = "org.freedesktop.portal.Usb"            , .method = "CreateSession"                 , .uses_request = FALSE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Usb"            , .method = "EnumerateDevices"              , .uses_request = FALSE, .option_arg =  0, },
  { .interface = "org.freedesktop.portal.Usb"            , .method = "AcquireDevices"                , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.Usb"            , .method = "FinishAcquireDevices"          , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Usb"            , .method = "ReleaseDevices"                , .uses_request = FALSE, .option_arg =  1, },
  { .interface = "org.freedesktop.portal.Wallpaper"      , .method = "SetWallpaperURI"               , .uses_request = TRUE, .option_arg =  2, },
  { .interface = "org.freedesktop.portal.Wallpaper"      , .method = "SetWallpaperFile"              , .uses_request = TRUE, .option_arg =  2, },
  { .interface = NULL },
};

const XdpMethodInfo *xdp_method_info_get_all (void) { return method_info; };

unsigned int xdp_method_info_get_count (void) { return G_N_ELEMENTS(method_info) - 1; };
