/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.Task;
import org.gradle.api.internal.project.BuildScopedTaskResolver;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.util.Path;

public class ProjectScopedTaskResolver
implements TaskResolver {
    private final BuildScopedTaskResolver buildTaskResolver;
    private final ProjectIdentity currentProject;
    private final TaskContainer taskContainer;

    public ProjectScopedTaskResolver(BuildScopedTaskResolver buildTaskResolver, ProjectIdentity currentProject, TaskContainer taskContainer) {
        this.buildTaskResolver = buildTaskResolver;
        this.currentProject = currentProject;
        this.taskContainer = taskContainer;
    }

    public Task resolveTask(Path path) {
        Path targetProjectPath;
        String targetTaskName = path.getName();
        if (targetTaskName == null) {
            assert (path == Path.ROOT);
            throw new IllegalArgumentException("The root path is not a valid task path");
        }
        if (!path.isAbsolute() && path.segmentCount() == 1) {
            return this.taskContainer.getByName(targetTaskName);
        }
        Path path2 = targetProjectPath = path.getParent() != null ? this.currentProject.getProjectPath().absolutePath(path.getParent()) : Path.ROOT;
        if (targetProjectPath.equals((Object)this.currentProject.getProjectPath())) {
            return this.taskContainer.getByName(targetTaskName);
        }
        Path absoluteTaskPath = targetProjectPath.child(targetTaskName);
        return this.buildTaskResolver.resolveTask(absoluteTaskPath);
    }
}

