/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.sql.SQLException;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.sql.VECTOR;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonValue;
import oracle.sql.json.OracleJsonVector;

public class OracleJsonVectorImpl
implements OracleJsonVector {
    private byte[] raw;

    public OracleJsonVectorImpl(byte[] raw) {
        this.raw = raw;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.VECTOR;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public VECTOR getVECTOR() {
        return VECTOR.fromData(this.raw);
    }

    @Override
    public double[] getDoubleArray() {
        try {
            return VECTOR.toDoubleArray(this.raw);
        }
        catch (SQLException e) {
            throw new OracleJsonException(e);
        }
    }

    @Override
    public float[] getFloatArray() {
        try {
            return VECTOR.toFloatArray(this.raw);
        }
        catch (SQLException e) {
            throw new OracleJsonException(e);
        }
    }

    @Override
    public byte[] getByteArray() {
        try {
            return VECTOR.toByteArray(this.raw);
        }
        catch (SQLException e) {
            throw new OracleJsonException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof OracleJsonVector && ((OracleJsonVector)other).getVECTOR().equals(VECTOR.fromData(this.raw));
    }

    @Override
    public int hashCode() {
        return VECTOR.fromData(this.raw).hashCode();
    }

    @Override
    public <T> T wrap(Class<T> wrapper) {
        return wrapper.cast(new JakartaPrimitive.JakartaVectorImpl(this.raw));
    }

    public byte[] raw() {
        return this.raw;
    }
}

