"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.globalTenantName = exports.SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN = exports.ResourceType = exports.RESOURCE_ACCESS_MANAGEMENT_URI = exports.PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_RENDERING_TEXT = exports.PLUGIN_USERS_APP_ID = exports.PLUGIN_TENANTS_APP_ID = exports.PLUGIN_ROLES_APP_ID = exports.PLUGIN_RESOURCE_ACCESS_MANAGEMENT_APP_ID = exports.PLUGIN_PERMISSIONS_APP_ID = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.PLUGIN_GET_STARTED_APP_ID = exports.PLUGIN_AUTH_APP_ID = exports.PLUGIN_AUDITLOG_APP_ID = exports.OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN = exports.OPENDISTRO_SECURITY_ANONYMOUS = exports.MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_INTEGER = exports.LOGIN_PAGE_URI = exports.LOCAL_CLUSTER_ID = exports.GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_RENDERING_TEXT = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ERROR_MISSING_ROLE_PATH = exports.DEFAULT_TENANT = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.AUTH_TYPE_PARAM = exports.AUTH_RESPONSE_TYPE = exports.AUTH_HEADER_NAME = exports.AUTH_GRANT_TYPE = exports.APP_ID_RESOURCE_ACCESS_MANAGEMENT = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGIN = void 0;
exports.isGlobalTenant = isGlobalTenant;
exports.isPrivateTenant = isPrivateTenant;
exports.isRenderingPrivateTenant = isRenderingPrivateTenant;
exports.isValidResourceName = isValidResourceName;
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'opensearchDashboardsSecurity';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'security-dashboards-plugin';
const PLUGIN_GET_STARTED_APP_ID = exports.PLUGIN_GET_STARTED_APP_ID = `${PLUGIN_NAME}_getstarted`;
const PLUGIN_AUTH_APP_ID = exports.PLUGIN_AUTH_APP_ID = `${PLUGIN_NAME}_auth`;
const PLUGIN_ROLES_APP_ID = exports.PLUGIN_ROLES_APP_ID = `${PLUGIN_NAME}_roles`;
const PLUGIN_USERS_APP_ID = exports.PLUGIN_USERS_APP_ID = `${PLUGIN_NAME}_users`;
const PLUGIN_PERMISSIONS_APP_ID = exports.PLUGIN_PERMISSIONS_APP_ID = `${PLUGIN_NAME}_permissions`;
const PLUGIN_TENANTS_APP_ID = exports.PLUGIN_TENANTS_APP_ID = `${PLUGIN_NAME}_tenants`;
const PLUGIN_AUDITLOG_APP_ID = exports.PLUGIN_AUDITLOG_APP_ID = `${PLUGIN_NAME}_auditlog`;
const PLUGIN_RESOURCE_ACCESS_MANAGEMENT_APP_ID = exports.PLUGIN_RESOURCE_ACCESS_MANAGEMENT_APP_ID = `${PLUGIN_NAME}_resource_access_management`;
const APP_ID_LOGIN = exports.APP_ID_LOGIN = 'login';
const APP_ID_CUSTOMERROR = exports.APP_ID_CUSTOMERROR = 'customerror';
const APP_ID_RESOURCE_ACCESS_MANAGEMENT = exports.APP_ID_RESOURCE_ACCESS_MANAGEMENT = 'resource_access_management';
const OPENDISTRO_SECURITY_ANONYMOUS = exports.OPENDISTRO_SECURITY_ANONYMOUS = 'opendistro_security_anonymous';
const API_PREFIX = exports.API_PREFIX = '/api/v1';
const CONFIGURATION_API_PREFIX = exports.CONFIGURATION_API_PREFIX = 'configuration';
const API_ENDPOINT_AUTHINFO = exports.API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
const API_ENDPOINT_DASHBOARDSINFO = exports.API_ENDPOINT_DASHBOARDSINFO = API_PREFIX + '/auth/dashboardsinfo';
const API_ENDPOINT_AUTHTYPE = exports.API_ENDPOINT_AUTHTYPE = API_PREFIX + '/auth/type';
const LOGIN_PAGE_URI = exports.LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
const CUSTOM_ERROR_PAGE_URI = exports.CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
const RESOURCE_ACCESS_MANAGEMENT_URI = exports.RESOURCE_ACCESS_MANAGEMENT_URI = '/app/' + APP_ID_RESOURCE_ACCESS_MANAGEMENT;
const API_AUTH_LOGIN = exports.API_AUTH_LOGIN = '/auth/login';
const API_AUTH_LOGOUT = exports.API_AUTH_LOGOUT = '/auth/logout';
const OPENID_AUTH_LOGIN = exports.OPENID_AUTH_LOGIN = '/auth/openid/login';
const OPENID_AUTH_LOGIN_WITH_FRAGMENT = exports.OPENID_AUTH_LOGIN_WITH_FRAGMENT = '/auth/openid/captureUrlFragment';
const SAML_AUTH_LOGIN = exports.SAML_AUTH_LOGIN = '/auth/saml/login';
const SAML_AUTH_LOGIN_WITH_FRAGMENT = exports.SAML_AUTH_LOGIN_WITH_FRAGMENT = '/auth/saml/captureUrlFragment';
const ANONYMOUS_AUTH_LOGIN = exports.ANONYMOUS_AUTH_LOGIN = '/auth/anonymous';
const AUTH_TYPE_PARAM = exports.AUTH_TYPE_PARAM = 'auth_type';
const OPENID_AUTH_LOGOUT = exports.OPENID_AUTH_LOGOUT = '/auth/openid/logout';
const SAML_AUTH_LOGOUT = exports.SAML_AUTH_LOGOUT = '/auth/saml/logout';
const ANONYMOUS_AUTH_LOGOUT = exports.ANONYMOUS_AUTH_LOGOUT = '/auth/anonymous/logout';
const ERROR_MISSING_ROLE_PATH = exports.ERROR_MISSING_ROLE_PATH = '/missing-role';
const AUTH_HEADER_NAME = exports.AUTH_HEADER_NAME = 'authorization';
const AUTH_GRANT_TYPE = exports.AUTH_GRANT_TYPE = 'authorization_code';
const AUTH_RESPONSE_TYPE = exports.AUTH_RESPONSE_TYPE = 'code';
const GLOBAL_TENANT_SYMBOL = exports.GLOBAL_TENANT_SYMBOL = '';
const PRIVATE_TENANT_SYMBOL = exports.PRIVATE_TENANT_SYMBOL = '__user__';
const DEFAULT_TENANT = exports.DEFAULT_TENANT = 'default';
const GLOBAL_TENANT_RENDERING_TEXT = exports.GLOBAL_TENANT_RENDERING_TEXT = 'Global';
const PRIVATE_TENANT_RENDERING_TEXT = exports.PRIVATE_TENANT_RENDERING_TEXT = 'Private';
const globalTenantName = exports.globalTenantName = 'global_tenant';
const MAX_INTEGER = exports.MAX_INTEGER = 2147483647;
const MAX_LENGTH_OF_COOKIE_BYTES = exports.MAX_LENGTH_OF_COOKIE_BYTES = 4000;
const ESTIMATED_IRON_COOKIE_OVERHEAD = exports.ESTIMATED_IRON_COOKIE_OVERHEAD = 1.5;
const LOCAL_CLUSTER_ID = exports.LOCAL_CLUSTER_ID = '';
let AuthType = exports.AuthType = /*#__PURE__*/function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
  AuthType["ANONYMOUS"] = "anonymous";
  return AuthType;
}({});
let ResourceType = exports.ResourceType = /*#__PURE__*/function (ResourceType) {
  ResourceType["roles"] = "roles";
  ResourceType["users"] = "users";
  ResourceType["permissions"] = "permissions";
  ResourceType["tenants"] = "tenants";
  ResourceType["tenantsManageTab"] = "tenantsManageTab";
  ResourceType["tenantsConfigureTab"] = "tenantsConfigureTab";
  ResourceType["auth"] = "auth";
  ResourceType["auditLogging"] = "auditLogging";
  return ResourceType;
}({});
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */
function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}
function isPrivateTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === PRIVATE_TENANT_SYMBOL;
}
function isRenderingPrivateTenant(selectedTenant) {
  return selectedTenant !== null && (selectedTenant === null || selectedTenant === void 0 ? void 0 : selectedTenant.startsWith(PRIVATE_TENANT_SYMBOL));
}
function isGlobalTenant(selectedTenant) {
  return selectedTenant !== null && selectedTenant === GLOBAL_TENANT_SYMBOL;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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