/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.model;

import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.observability.model.Application;
import org.opensearch.observability.model.BaseObjectData;
import org.opensearch.observability.model.Notebook;
import org.opensearch.observability.model.ObservabilityObjectType;
import org.opensearch.observability.model.OperationalPanel;
import org.opensearch.observability.model.SavedQuery;
import org.opensearch.observability.model.SavedVisualization;
import org.opensearch.observability.model.Timestamp;
import org.opensearch.observability.model.XParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDataProperties;", "", "<init>", "()V", "OBJECT_PROPERTIES_MAP", "", "Lorg/opensearch/observability/model/ObservabilityObjectType;", "Lorg/opensearch/observability/model/ObservabilityObjectDataProperties$ObjectProperty;", "getReaderForObjectType", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/model/BaseObjectData;", "objectType", "validateObjectData", "", "objectData", "createObjectData", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "ObjectProperty", "opensearch-observability"})
public final class ObservabilityObjectDataProperties {
    @NotNull
    public static final ObservabilityObjectDataProperties INSTANCE = new ObservabilityObjectDataProperties();
    @NotNull
    private static final Map<ObservabilityObjectType, ObjectProperty> OBJECT_PROPERTIES_MAP;

    private ObservabilityObjectDataProperties() {
    }

    @NotNull
    public final Writeable.Reader<? extends BaseObjectData> getReaderForObjectType(@NotNull ObservabilityObjectType objectType) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        Writeable.Reader<? extends BaseObjectData> reader = OBJECT_PROPERTIES_MAP.get((Object)objectType);
        if (reader == null || (reader = reader.getObjectDataReader()) == null) {
            throw new IllegalArgumentException("Transport action used with unknown ConfigType:" + objectType);
        }
        return reader;
    }

    public final boolean validateObjectData(@NotNull ObservabilityObjectType objectType, @Nullable BaseObjectData objectData) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        return switch (WhenMappings.$EnumSwitchMapping$0[objectType.ordinal()]) {
            case 1 -> objectData instanceof Notebook;
            case 2 -> objectData instanceof SavedQuery;
            case 3 -> objectData instanceof SavedVisualization;
            case 4 -> objectData instanceof OperationalPanel;
            case 5 -> objectData instanceof Application;
            case 6 -> objectData instanceof Timestamp;
            case 7 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public final BaseObjectData createObjectData(@NotNull ObservabilityObjectType objectType, @NotNull XContentParser parser) {
        Intrinsics.checkNotNullParameter((Object)((Object)objectType), (String)"objectType");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Object object = OBJECT_PROPERTIES_MAP.get((Object)objectType);
        return object != null && (object = ((ObjectProperty)object).getObjectDataParser()) != null ? (BaseObjectData)object.parse(parser) : null;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)ObservabilityObjectType.NOTEBOOK, (Object)new ObjectProperty(Notebook.Companion.getReader(), Notebook.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.SAVED_QUERY, (Object)new ObjectProperty(SavedQuery.Companion.getReader(), SavedQuery.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.SAVED_VISUALIZATION, (Object)new ObjectProperty(SavedVisualization.Companion.getReader(), SavedVisualization.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.OPERATIONAL_PANEL, (Object)new ObjectProperty(OperationalPanel.Companion.getReader(), OperationalPanel.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.APPLICATION, (Object)new ObjectProperty(Application.Companion.getReader(), Application.Companion.getXParser())), new Pair((Object)ObservabilityObjectType.TIMESTAMP, (Object)new ObjectProperty(Timestamp.Companion.getReader(), Timestamp.Companion.getXParser()))};
        OBJECT_PROPERTIES_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0003J/\u0010\u000f\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u001b\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/opensearch/observability/model/ObservabilityObjectDataProperties$ObjectProperty;", "", "objectDataReader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/observability/model/BaseObjectData;", "objectDataParser", "Lorg/opensearch/observability/model/XParser;", "<init>", "(Lorg/opensearch/core/common/io/stream/Writeable$Reader;Lorg/opensearch/observability/model/XParser;)V", "getObjectDataReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "getObjectDataParser", "()Lorg/opensearch/observability/model/XParser;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "opensearch-observability"})
    private static final class ObjectProperty {
        @Nullable
        private final Writeable.Reader<? extends BaseObjectData> objectDataReader;
        @NotNull
        private final XParser<? extends BaseObjectData> objectDataParser;

        public ObjectProperty(@Nullable Writeable.Reader<? extends BaseObjectData> objectDataReader, @NotNull XParser<? extends BaseObjectData> objectDataParser) {
            Intrinsics.checkNotNullParameter(objectDataParser, (String)"objectDataParser");
            this.objectDataReader = objectDataReader;
            this.objectDataParser = objectDataParser;
        }

        @Nullable
        public final Writeable.Reader<? extends BaseObjectData> getObjectDataReader() {
            return this.objectDataReader;
        }

        @NotNull
        public final XParser<? extends BaseObjectData> getObjectDataParser() {
            return this.objectDataParser;
        }

        @Nullable
        public final Writeable.Reader<? extends BaseObjectData> component1() {
            return this.objectDataReader;
        }

        @NotNull
        public final XParser<? extends BaseObjectData> component2() {
            return this.objectDataParser;
        }

        @NotNull
        public final ObjectProperty copy(@Nullable Writeable.Reader<? extends BaseObjectData> objectDataReader, @NotNull XParser<? extends BaseObjectData> objectDataParser) {
            Intrinsics.checkNotNullParameter(objectDataParser, (String)"objectDataParser");
            return new ObjectProperty(objectDataReader, objectDataParser);
        }

        public static /* synthetic */ ObjectProperty copy$default(ObjectProperty objectProperty, Writeable.Reader reader, XParser xParser, int n, Object object) {
            if ((n & 1) != 0) {
                reader = objectProperty.objectDataReader;
            }
            if ((n & 2) != 0) {
                xParser = objectProperty.objectDataParser;
            }
            return objectProperty.copy(reader, xParser);
        }

        @NotNull
        public String toString() {
            return "ObjectProperty(objectDataReader=" + this.objectDataReader + ", objectDataParser=" + this.objectDataParser + ")";
        }

        public int hashCode() {
            int result = this.objectDataReader == null ? 0 : this.objectDataReader.hashCode();
            result = result * 31 + this.objectDataParser.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ObjectProperty)) {
                return false;
            }
            ObjectProperty objectProperty = (ObjectProperty)other;
            if (!Intrinsics.areEqual(this.objectDataReader, objectProperty.objectDataReader)) {
                return false;
            }
            return Intrinsics.areEqual(this.objectDataParser, objectProperty.objectDataParser);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ObservabilityObjectType.values().length];
            try {
                nArray[ObservabilityObjectType.NOTEBOOK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.SAVED_QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.SAVED_VISUALIZATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.OPERATIONAL_PANEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.APPLICATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.TIMESTAMP.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ObservabilityObjectType.NONE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

